<TeXmacs|1.0.7.19>

<style|<tuple|tmdoc|maxima|scilab>>

<\body>
  <\tmdoc-title>
    Example <name|Scilab> session
  </tmdoc-title>

  <subsection|Mathematical presentation of <name|Scilab> data types>

  Here follows some sample sessions, which was started using
  <menu|Insert|Session|Scilab>.

  <\session|scilab|default>
    <\output>
      \ \ \ \ \ \ \ \ ___________________________________________
      \ \ \ \ \ \ \ 

      \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ scilab-5.3.3

      \;

      \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ Consortium Scilab (DIGITEO)

      \ \ \ \ \ \ \ \ \ \ \ \ \ \ Copyright (c) 1989-2011 (INRIA)

      \ \ \ \ \ \ \ \ \ \ \ \ \ \ Copyright (c) 1989-2007 (ENPC)

      \ \ \ \ \ \ \ \ ___________________________________________
      \ \ \ \ \ \ \ 

      \ 

      \;
    </output>

    <\unfolded-io>
      --\<gtr\>
    <|unfolded-io>
      <\code>
        A= [0,1;0,0], B= [1;1]; C= [1,1];
      </code>
    <|unfolded-io>
      \ A \ =

      \ 

      <with|mode|math|<matrix|<tformat|<table|<row|<cell|0>|<cell|1>>|<row|<cell|0>|<cell|0>>>>>>

      \ 
    </unfolded-io>

    <\unfolded-io>
      --\<gtr\>
    <|unfolded-io>
      <\code>
        S1= syslin('c',A,B,C)
      </code>
    <|unfolded-io>
      \ S1 \ =

      \ 

      <with|mode|math|<choice|<tformat|<cwith|1|-1|1|1|cell-halign|r>|<table|<row|<cell|<wide|X|\<dot\>>
      <around*|(|t|)>>|<cell|=>|<cell|<matrix|<tformat|<table|<row|<cell|0>|<cell|1>>|<row|<cell|0>|<cell|0>>>>>*X
      <around*|(|t|)>+<matrix|<tformat|<table|<row|<cell|1>>|<row|<cell|1>>>>>*U
      <around*|(|t|)>>>|<row|<cell|Y <around*|(|t|)>>|<cell|=>|<cell|<matrix|<tformat|<table|<row|<cell|1>|<cell|1>>>>>*X
      <around*|(|t|)>>>>>>>

      \ 
    </unfolded-io>

    <\folded-io>
      --\<gtr\>
    <|folded-io>
      demo_run (texmacs_path + 'plugins/scilab/bin/scilab-demo.sce')
    <|folded-io>
      \ 

      --\<gtr\>//*****************************************************************************

      \ 

      --\<gtr\>// MODULE \ \ \ \ : scilab-demo.sce

      \ 

      --\<gtr\>// DESCRIPTION: Show a demo of some Scilab plugin features.

      \ 

      --\<gtr\>// COPYRIGHT \ : (C) 2013 Franois Poulain, Joris van der
      Hoeven

      \ 

      --\<gtr\>//*****************************************************************************

      \ 

      --\<gtr\>// This software falls under the GNU general public license
      version 3 or later.

      \ 

      --\<gtr\>// It comes WITHOUT ANY WARRANTY WHATSOEVER. For details, see
      the file LICENSE

      \ 

      --\<gtr\>// in the root directory or
      \<less\>http://www.gnu.org/licenses/gpl-3.0.html\<gtr\>.

      \ 

      --\<gtr\>//*****************************************************************************

      \ 

      \ 

      --\<gtr\>// print complex

      \ 

      --\<gtr\>(1 - 2*%i)^4

      \ ans \ =

      \ 

      <with|mode|math|-7+24*i>

      \ 

      \ 

      --\<gtr\>// print boolean matrix

      \ 

      --\<gtr\>rand(3,3) \<gtr\> 0.5

      \ ans \ =

      \ 

      <with|mode|math|<matrix|<tformat|<table|<row|<cell|T>|<cell|T>|<cell|T>>|<row|<cell|T>|<cell|F>|<cell|F>>|<row|<cell|F>|<cell|T>|<cell|T>>>>>>

      \ 

      \ 

      --\<gtr\>// print sparse matrix

      \ 

      --\<gtr\>sparse (rand(3,3) \<gtr\> 0.5)

      \ ans \ =

      \ 

      ( \ \ \ 3, \ \ \ 3) sparse matrix

      \ 

      ( \ \ \ 1, \ \ \ 1) \ \ \ T\ 

      ( \ \ \ 1, \ \ \ 2) \ \ \ T\ 

      ( \ \ \ 2, \ \ \ 1) \ \ \ T\ 

      ( \ \ \ 2, \ \ \ 3) \ \ \ T\ 

      ( \ \ \ 3, \ \ \ 1) \ \ \ T\ 

      ( \ \ \ 3, \ \ \ 2) \ \ \ T\ 

      \ 

      \ 

      --\<gtr\>// print matrix

      \ 

      --\<gtr\>A= [0,1;0,0], B= [1;1]; C= [1,1];

      \ A \ =

      \ 

      <with|mode|math|<matrix|<tformat|<table|<row|<cell|0>|<cell|1>>|<row|<cell|0>|<cell|0>>>>>>

      \ 

      \ 

      --\<gtr\>// print linear system

      \ 

      --\<gtr\>S1= syslin('c',A,B,C) \ 

      \ S1 \ =

      \ 

      <with|mode|math|<choice|<tformat|<cwith|1|-1|1|1|cell-halign|r>|<table|<row|<cell|<wide|X|\<dot\>>
      <around*|(|t|)>>|<cell|=>|<cell|<matrix|<tformat|<table|<row|<cell|0>|<cell|1>>|<row|<cell|0>|<cell|0>>>>>*X
      <around*|(|t|)>+<matrix|<tformat|<table|<row|<cell|1>>|<row|<cell|1>>>>>*U
      <around*|(|t|)>>>|<row|<cell|Y <around*|(|t|)>>|<cell|=>|<cell|<matrix|<tformat|<table|<row|<cell|1>|<cell|1>>>>>*X
      <around*|(|t|)>>>>>>>

      \ 

      \ 

      --\<gtr\>// print rational

      \ 

      --\<gtr\>s1= ss2tf (S1)

      \ s1 \ =

      \ 

      <with|mode|math|<frac|1+2*s|s<rsup|2>>>

      \ 

      --\<gtr\>h= s1/poly(1:4,'s','c')

      \ h \ =

      \ 

      <with|mode|math|<frac|1+2*s|s<rsup|2>+2*s<rsup|3>+3*s<rsup|4>+4*s<rsup|5>>>

      \ 

      --\<gtr\>f = (1 + %s) / (1 - %s)

      \ f \ =

      \ 

      <with|mode|math|<frac|1+s|1-s>>

      \ 

      \ 

      --\<gtr\>// print (non Ascii) string

      \ 

      --\<gtr\>"degr"

      \ ans \ =

      \ 

      <with|mode|math|<text|<extern|scilab-verbatim-\<gtr\>tree|degré>>>

      \ 

      --\<gtr\>M= ["une" "matrice"; "de" "caractre"]'

      \ M \ =

      \ 

      <with|mode|math|<matrix|<tformat|<table|<row|<cell|<text|une>>|<cell|<text|de>>>|<row|<cell|<text|matrice>>|<cell|<text|<extern|scilab-verbatim-\<gtr\>tree|caractère>>>>>>>>

      \ 

      --\<gtr\>strcat(M, " ")

      \ ans \ =

      \ 

      <with|mode|math|<text|<extern|scilab-verbatim-\<gtr\>tree|une matrice
      de caractère>>>

      \ 

      \ 

      --\<gtr\>// print mlist

      \ 

      --\<gtr\>M=mlist(['V','name','value'],['a','b','c'],[1 2 3])

      \ M \ =

      \ 

      <\with|mode|math>
        <text|mlist of type V with fields:>

        <block|<tformat|<table|<row|<cell|<varname><rsub|1>>|<cell|<matrix|<tformat|<table|<row|<cell|<text|V>>|<cell|<text|name>>|<cell|<text|value>>>>>>>>|<row|<cell|<varname><rsub|<text|name>>>|<cell|<matrix|<tformat|<table|<row|<cell|<text|a>>|<cell|<text|b>>|<cell|<text|c>>>>>>>>|<row|<cell|<varname><rsub|<text|value>>>|<cell|<matrix|<tformat|<table|<row|<cell|1>|<cell|2>|<cell|3>>>>>>>>>>
      </with>

      \ 

      \ 

      --\<gtr\>// overload V-list printing

      \ 

      --\<gtr\>function s= V2tmstree (arg)

      --\<gtr\> \ s= tmstree (arg.value) // generate stree

      --\<gtr\>endfunction

      \ 

      --\<gtr\>// now, printing M print M.value

      \ 

      --\<gtr\>M

      \ M \ =

      \ 

      <with|mode|math|<matrix|<tformat|<table|<row|<cell|1>|<cell|2>|<cell|3>>>>>>

      \ 

      \ 

      --\<gtr\>// print struct

      \ 

      --\<gtr\>s= struct ('month', 05, 'day', 31, 'year', 2013)

      \ s \ =

      \ 

      <\with|mode|math>
        <text|struct with fields:>

        <block|<tformat|<table|<row|<cell|<text|month>:>|<cell|5>>|<row|<cell|<text|day>:>|<cell|31>>|<row|<cell|<text|year>:>|<cell|2013>>>>>
      </with>

      \ 

      --\<gtr\>s.misc=s

      \ s \ =

      \ 

      <\with|mode|math>
        <text|struct with fields:>

        <block|<tformat|<table|<row|<cell|<text|month>:>|<cell|5>>|<row|<cell|<text|day>:>|<cell|31>>|<row|<cell|<text|year>:>|<cell|2013>>|<row|<cell|<text|misc>:>|<\cell>
          <text|struct with fields:>

          <block|<tformat|<table|<row|<cell|<text|month>:>|<cell|5>>|<row|<cell|<text|day>:>|<cell|31>>|<row|<cell|<text|year>:>|<cell|2013>>>>>
        </cell>>>>>
      </with>

      \ 

      --\<gtr\>s.misc=s

      \ s \ =

      \ 

      <\with|mode|math>
        <text|struct with fields:>

        <block|<tformat|<table|<row|<cell|<text|month>:>|<cell|5>>|<row|<cell|<text|day>:>|<cell|31>>|<row|<cell|<text|year>:>|<cell|2013>>|<row|<cell|<text|misc>:>|<\cell>
          <text|struct with fields:>

          <block|<tformat|<table|<row|<cell|<text|month>:>|<cell|5>>|<row|<cell|<text|day>:>|<cell|31>>|<row|<cell|<text|year>:>|<cell|2013>>|<row|<cell|<text|misc>:>|<\cell>
            <text|struct with fields:>

            <block|<tformat|<table|<row|<cell|<text|month>:>|<cell|5>>|<row|<cell|<text|day>:>|<cell|31>>|<row|<cell|<text|year>:>|<cell|2013>>>>>
          </cell>>>>>
        </cell>>>>>
      </with>

      \ 

      \ 

      --\<gtr\>// print struct matrix

      \ 

      --\<gtr\>S= struct ('month', 05, 'day', 31, 'year', 2013)

      \ S \ =

      \ 

      <\with|mode|math>
        <text|struct with fields:>

        <block|<tformat|<table|<row|<cell|<text|month>:>|<cell|5>>|<row|<cell|<text|day>:>|<cell|31>>|<row|<cell|<text|year>:>|<cell|2013>>>>>
      </with>

      \ 

      --\<gtr\>S(2)= S

      \ S \ =

      \ 

      <\with|mode|math>
        2\<times\>1<text| struct matrix:>

        <matrix|<tformat|<table|<row|<cell|<block|<tformat|<table|<row|<cell|<text|month>:>|<cell|5>>|<row|<cell|<text|day>:>|<cell|31>>|<row|<cell|<text|year>:>|<cell|2013>>>>>>>|<row|<cell|<block|<tformat|<table|<row|<cell|<text|month>:>|<cell|5>>|<row|<cell|<text|day>:>|<cell|31>>|<row|<cell|<text|year>:>|<cell|2013>>>>>>>>>>
      </with>

      \ 

      --\<gtr\>S(:,2)= S

      \ S \ =

      \ 

      <\with|mode|math>
        2\<times\>2<text| struct matrix:>

        <matrix|<tformat|<table|<row|<cell|<block|<tformat|<table|<row|<cell|<text|month>:>|<cell|5>>|<row|<cell|<text|day>:>|<cell|31>>|<row|<cell|<text|year>:>|<cell|2013>>>>>>|<cell|<block|<tformat|<table|<row|<cell|<text|month>:>|<cell|5>>|<row|<cell|<text|day>:>|<cell|31>>|<row|<cell|<text|year>:>|<cell|2013>>>>>>>|<row|<cell|<block|<tformat|<table|<row|<cell|<text|month>:>|<cell|5>>|<row|<cell|<text|day>:>|<cell|31>>|<row|<cell|<text|year>:>|<cell|2013>>>>>>|<cell|<block|<tformat|<table|<row|<cell|<text|month>:>|<cell|5>>|<row|<cell|<text|day>:>|<cell|31>>|<row|<cell|<text|year>:>|<cell|2013>>>>>>>>>>
      </with>

      \ 

      \ 

      --\<gtr\>S.month

      \ ans \ =

      \ 

      <\with|mode|math>
        <text|list with entries:>

        <block|<tformat|<table|<row|<cell|<varname><rsub|1>>|<cell|5>>|<row|<cell|<varname><rsub|2>>|<cell|5>>|<row|<cell|<varname><rsub|3>>|<cell|5>>|<row|<cell|<varname><rsub|4>>|<cell|5>>>>>
      </with>

      \ 

      \ 

      --\<gtr\>// print cell

      \ 

      --\<gtr\>ce= cell ([2 2 2])

      \ ce \ =

      \ 

      <\with|mode|math>
        <text|cell array:>

        <block|<tformat|<table|<row|<cell|<varname><rsub|:,:,1>>|<cell|=>|<cell|<matrix|<tformat|<table|<row|<cell|{}>|<cell|{}>>|<row|<cell|{}>|<cell|{}>>>>>>>|<row|<cell|<varname><rsub|:,:,2>>|<cell|=>|<cell|<matrix|<tformat|<table|<row|<cell|{}>|<cell|{}>>|<row|<cell|{}>|<cell|{}>>>>>>>>>>
      </with>

      \ 

      --\<gtr\>ce(2,1).entries= 0

      \ ce \ =

      \ 

      <\with|mode|math>
        <text|cell array:>

        <block|<tformat|<table|<row|<cell|<varname><rsub|:,:,1>>|<cell|=>|<cell|<matrix|<tformat|<table|<row|<cell|{}>|<cell|{}>>|<row|<cell|0>|<cell|{}>>>>>>>|<row|<cell|<varname><rsub|:,:,2>>|<cell|=>|<cell|<matrix|<tformat|<table|<row|<cell|{}>|<cell|{}>>|<row|<cell|{}>|<cell|{}>>>>>>>>>>
      </with>

      \ 

      --\<gtr\>ce(1,2).entries= S1

      \ ce \ =

      \ 

      <\with|mode|math>
        <text|cell array:>

        <block|<tformat|<table|<row|<cell|<varname><rsub|:,:,1>>|<cell|=>|<cell|<matrix|<tformat|<table|<row|<cell|{}>|<cell|<choice|<tformat|<cwith|1|-1|1|1|cell-halign|r>|<table|<row|<cell|<wide|X|\<dot\>>
        <around*|(|t|)>>|<cell|=>|<cell|<matrix|<tformat|<table|<row|<cell|0>|<cell|1>>|<row|<cell|0>|<cell|0>>>>>*X
        <around*|(|t|)>+<matrix|<tformat|<table|<row|<cell|1>>|<row|<cell|1>>>>>*U
        <around*|(|t|)>>>|<row|<cell|Y <around*|(|t|)>>|<cell|=>|<cell|<matrix|<tformat|<table|<row|<cell|1>|<cell|1>>>>>*X
        <around*|(|t|)>>>>>>>>|<row|<cell|0>|<cell|{}>>>>>>>|<row|<cell|<varname><rsub|:,:,2>>|<cell|=>|<cell|<matrix|<tformat|<table|<row|<cell|{}>|<cell|{}>>|<row|<cell|{}>|<cell|{}>>>>>>>>>>
      </with>

      \ 

      --\<gtr\>ce(2,2,2).entries= s

      \ ce \ =

      \ 

      <\with|mode|math>
        <text|cell array:>

        <block|<tformat|<table|<row|<cell|<varname><rsub|:,:,1>>|<cell|=>|<cell|<matrix|<tformat|<table|<row|<cell|{}>|<cell|<choice|<tformat|<cwith|1|-1|1|1|cell-halign|r>|<table|<row|<cell|<wide|X|\<dot\>>
        <around*|(|t|)>>|<cell|=>|<cell|<matrix|<tformat|<table|<row|<cell|0>|<cell|1>>|<row|<cell|0>|<cell|0>>>>>*X
        <around*|(|t|)>+<matrix|<tformat|<table|<row|<cell|1>>|<row|<cell|1>>>>>*U
        <around*|(|t|)>>>|<row|<cell|Y <around*|(|t|)>>|<cell|=>|<cell|<matrix|<tformat|<table|<row|<cell|1>|<cell|1>>>>>*X
        <around*|(|t|)>>>>>>>>|<row|<cell|0>|<cell|{}>>>>>>>|<row|<cell|<varname><rsub|:,:,2>>|<cell|=>|<cell|<matrix|<tformat|<table|<row|<cell|{}>|<cell|{}>>|<row|<cell|{}>|<\cell>
          <text|struct with fields:>

          <block|<tformat|<table|<row|<cell|<text|month>:>|<cell|5>>|<row|<cell|<text|day>:>|<cell|31>>|<row|<cell|<text|year>:>|<cell|2013>>|<row|<cell|<text|misc>:>|<\cell>
            <text|struct with fields:>

            <block|<tformat|<table|<row|<cell|<text|month>:>|<cell|5>>|<row|<cell|<text|day>:>|<cell|31>>|<row|<cell|<text|year>:>|<cell|2013>>|<row|<cell|<text|misc>:>|<\cell>
              <text|struct with fields:>

              <block|<tformat|<table|<row|<cell|<text|month>:>|<cell|5>>|<row|<cell|<text|day>:>|<cell|31>>|<row|<cell|<text|year>:>|<cell|2013>>>>>
            </cell>>>>>
          </cell>>>>>
        </cell>>>>>>>>>>
      </with>

      \ 

      \ 
    </folded-io>
  </session>

  <strong|<with|color|red|Note.>> Most of the Scilab data types are handled.
  Anyway, printing some ot them raise an issue due to the simplisticity of
  <name|Scilab> read-eval-print loop (see, e.g. the <scilab|mlist> case: the
  variable name is currently impossible to know). Also, some types cannot be
  printed since the printing method cannot be overloaded in scilab for this
  type (see e.g. the <scilab|sparse matrix> case; Sparse matrixes can
  nevertheless be printed, using <scilab|tmout>).

  <strong|<with|color|red|Note.>> Due to the simplisticity of <name|Scilab>
  read-eval-print loop, multiline command may fail (at least,
  <scilab|function> declaration and entries with comments or continuation
  mark (<scilab|..>)).

  <strong|<with|color|red|Note.>> There is some performances issues on big
  datas. The <scilab|tmstree()> function could be improved i) by removing
  local function definitions; ii) by limit repeted call of small functions
  (avoiding code factorisation); and iii) via a different handling for
  matrices.

  <subsection|Syntax highlighting>

  Here follows a sample block of code, which was started using
  <menu|Insert|Program|Block of code|Scilab>. Inserting <em|inline code> is
  also possible, e.g. to speak about ``<scilab|f(x,y+1)>''.

  <\scilab-code>
    g= 9.81 // the gravity

    \;

    function y= myfunction(x)

    \ \ // myfunction computes y= x^2+1

    \ \ // x should be a vector or matrix

    \ \ y= x^2+1

    endfunction
  </scilab-code>

  <subsection|Plot inserting>

  The function <scilab|plotout()> allows you to insert the current figure
  inside the <TeXmacs> session.

  <\session|scilab|default>
    <\unfolded-io>
      --\<gtr\>
    <|unfolded-io>
      x= -6.28:0.1:6.28; y= sin(x); plot (x, y);

      // Note: let open the plot window
    <|unfolded-io>
      \ 
    </unfolded-io>

    <\unfolded-io>
      --\<gtr\>
    <|unfolded-io>
      plotout()
    <|unfolded-io>
      <image|<tuple|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|ps>||||>
    </unfolded-io>
  </session>

  <subsection|Menu populating features>

  The <name|Scilab> menu has an ``<menu|Insert>'' entry which can be
  personalized. As an example, the session

  <\session|scilab|default>
    <\unfolded-io>
      --\<gtr\>
    <|unfolded-io>
      cf= ["abort", "break", "case", "continue", "do", "for", "if", "pause",
      "resume", "return", "select", "then", "while"];
    <|unfolded-io>
      \ 
    </unfolded-io>

    <\folded-io>
      --\<gtr\>
    <|folded-io>
      add_to_insert_menu ("Control flow", cf);
    <|folded-io>
      \ 
    </folded-io>
  </session>

  add to the <name|Scilab> menu the entry <menu|Scilab|Insert|Control flow>.
  It can be removed using

  <\session|scilab|default>
    <\folded-io>
      --\<gtr\>
    <|folded-io>
      rm_from_insert_menu ("Control flow");
    <|folded-io>
      \ 
    </folded-io>
  </session>

  <subsection|Completion>

  <name|Scilab> object's names can be completed via <key|tab>.

  <subsection|Verbatim import>

  <TeXmacs> allows you to edit a <name|Scilab> source in verbatim mode. See
  e.g. <hlink|<verbatim|scilab-demo.sce>|../bin/scilab-demo.sce>.

  <subsection|Demo launching>

  The <name|Scilab> menu lists the available <name|Scilab> demo. They can be
  launched, via <menu|Scilab|Launch demo>.

  <subsection|Help browsing>

  To be done.

  <tmdoc-copyright|2013|Franois Poulain, Joris van der Hoeven. Examples
  inspired from Scilab documentation.>

  <tmdoc-license|Permission is granted to copy, distribute and/or modify this
  document under the terms of the GNU Free Documentation License, Version 1.1
  or any later version published by the Free Software Foundation; with no
  Invariant Sections, with no Front-Cover Texts, and with no Back-Cover
  Texts. A copy of the license is included in the section entitled "GNU Free
  Documentation License".>
</body>

<\initial>
  <\collection>
    <associate|language|english>
  </collection>
</initial>