/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.file;

import com.izforge.izpack.util.file.DirectoryScanner;
import com.izforge.izpack.util.file.FileNameMapper;
import com.izforge.izpack.util.file.FileUtils;
import com.izforge.izpack.util.file.FlatFileNameMapper;
import com.izforge.izpack.util.file.IdentityMapper;
import com.izforge.izpack.util.file.SourceFileScanner;
import com.izforge.izpack.util.file.types.FileSet;
import com.izforge.izpack.util.file.types.Mapper;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileCopyTask {
    private static final Logger logger = Logger.getLogger(FileCopyTask.class.getName());
    protected File file = null;
    protected File destFile = null;
    protected File destDir = null;
    protected Vector<FileSet> filesets = new Vector();
    private boolean enableMultipleMappings = false;
    protected boolean preserveLastModified = false;
    protected boolean forceOverwrite = false;
    protected boolean flatten = false;
    protected boolean includeEmpty = true;
    protected boolean failonerror = true;
    protected Hashtable<String, String[]> fileCopyMap = new Hashtable();
    protected Hashtable<String, String[]> dirCopyMap = new Hashtable();
    protected Hashtable<File, File> completeDirMap = new Hashtable();
    protected Mapper mapperElement = null;
    private long granularity = FileUtils.getFileTimestampGranularity();

    public void setFile(File file) {
        this.file = file;
    }

    public void setToFile(File destFile) {
        this.destFile = destFile;
    }

    public void setToDir(File destDir) {
        this.destDir = destDir;
    }

    public void setPreserveLastModified(boolean preserve) {
        this.preserveLastModified = preserve;
    }

    public boolean getPreserveLastModified() {
        return this.preserveLastModified;
    }

    public void setOverwrite(boolean overwrite) {
        this.forceOverwrite = overwrite;
    }

    public void setFlatten(boolean flatten) {
        this.flatten = flatten;
    }

    public void setIncludeEmptyDirs(boolean includeEmpty) {
        this.includeEmpty = includeEmpty;
    }

    public void setEnableMultipleMappings(boolean enableMultipleMappings) {
        this.enableMultipleMappings = enableMultipleMappings;
    }

    public boolean isEnableMultipleMapping() {
        return this.enableMultipleMappings;
    }

    public void setFailOnError(boolean failonerror) {
        this.failonerror = failonerror;
    }

    public void addFileSet(FileSet set) {
        this.filesets.addElement(set);
    }

    public Mapper createMapper() throws Exception {
        if (this.mapperElement != null) {
            throw new Exception("Cannot define more than one mapper");
        }
        this.mapperElement = new Mapper();
        return this.mapperElement;
    }

    public void add(FileNameMapper fileNameMapper) throws Exception {
        this.createMapper().add(fileNameMapper);
    }

    public void setGranularity(long granularity) {
        this.granularity = granularity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws Exception {
        block21: {
            File savedFile = this.file;
            File savedDestFile = this.destFile;
            File savedDestDir = this.destDir;
            FileSet savedFileSet = null;
            if (this.file == null && this.destFile != null && this.filesets.size() == 1) {
                savedFileSet = this.filesets.elementAt(0);
            }
            this.validateAttributes();
            try {
                if (this.file != null) {
                    if (this.file.exists()) {
                        if (this.destFile == null) {
                            this.destFile = new File(this.destDir, this.file.getName());
                        }
                        if (this.forceOverwrite || !this.destFile.exists() || this.file.lastModified() - this.granularity > this.destFile.lastModified()) {
                            this.fileCopyMap.put(this.file.getAbsolutePath(), new String[]{this.destFile.getAbsolutePath()});
                        } else {
                            logger.fine(this.file + " omitted as " + this.destFile + " is up to date.");
                        }
                    } else {
                        String message = "Warning: Could not find file " + this.file.getAbsolutePath() + " to copy.";
                        if (!this.failonerror) {
                            logger.fine(message);
                        } else {
                            throw new Exception(message);
                        }
                    }
                }
                for (int i = 0; i < this.filesets.size(); ++i) {
                    boolean isEverythingIncluded;
                    FileSet fs = this.filesets.elementAt(i);
                    DirectoryScanner ds = null;
                    try {
                        ds = fs.getDirectoryScanner();
                    }
                    catch (Exception e) {
                        if (this.failonerror || !e.getMessage().endsWith(" not found.")) {
                            throw e;
                        }
                        logger.log(Level.WARNING, "Warning: " + e.getMessage(), e);
                        continue;
                    }
                    File fromDir = fs.getDir();
                    String[] srcFiles = ds.getIncludedFiles();
                    String[] srcDirs = ds.getIncludedDirectories();
                    boolean bl = isEverythingIncluded = ds.isEverythingIncluded() && !fs.hasSelectors() && !fs.hasPatterns();
                    if (isEverythingIncluded && !this.flatten && this.mapperElement == null) {
                        this.completeDirMap.put(fromDir, this.destDir);
                    }
                    this.scan(fromDir, this.destDir, srcFiles, srcDirs);
                }
                try {
                    this.doFileOperations();
                }
                catch (Exception e) {
                    if (!this.failonerror) {
                        System.err.println("Warning: " + e.getMessage());
                        break block21;
                    }
                    throw e;
                }
            }
            finally {
                this.file = savedFile;
                this.destFile = savedDestFile;
                this.destDir = savedDestDir;
                if (savedFileSet != null) {
                    this.filesets.insertElementAt(savedFileSet, 0);
                }
                this.fileCopyMap.clear();
                this.dirCopyMap.clear();
                this.completeDirMap.clear();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateAttributes() throws Exception {
        if (this.file == null && this.filesets.size() == 0) {
            throw new Exception("Specify at least one source - a file or a fileset.");
        }
        if (this.destFile != null && this.destDir != null) {
            throw new Exception("Only one of tofile and todir may be set.");
        }
        if (this.destFile == null && this.destDir == null) {
            throw new Exception("One of tofile or todir must be set.");
        }
        if (this.file != null && this.file.exists() && this.file.isDirectory()) {
            throw new Exception("Use a fileset to copy directories.");
        }
        if (this.destFile != null && this.filesets.size() > 0) {
            if (this.filesets.size() > 1) {
                throw new Exception("Cannot concatenate multiple files into a single file.");
            }
            FileSet fs = this.filesets.elementAt(0);
            DirectoryScanner ds = fs.getDirectoryScanner();
            String[] srcFiles = ds.getIncludedFiles();
            if (srcFiles.length == 0) {
                throw new Exception("Cannot perform operation from directory to file.");
            }
            if (srcFiles.length != 1) throw new Exception("Cannot concatenate multiple files into a single file.");
            if (this.file != null) throw new Exception("Cannot concatenate multiple files into a single file.");
            this.file = new File(ds.getBasedir(), srcFiles[0]);
            this.filesets.removeElementAt(0);
        }
        if (this.destFile == null) return;
        this.destDir = FileUtils.getParentFile(this.destFile);
    }

    protected void scan(File fromDir, File toDir, String[] files, String[] dirs) throws Exception {
        FileNameMapper mapper = null;
        mapper = this.mapperElement != null ? this.mapperElement.getImplementation() : (this.flatten ? new FlatFileNameMapper() : new IdentityMapper());
        this.buildMap(fromDir, toDir, files, mapper, this.fileCopyMap);
        if (this.includeEmpty) {
            this.buildMap(fromDir, toDir, dirs, mapper, this.dirCopyMap);
        }
    }

    protected void buildMap(File fromDir, File toDir, String[] names, FileNameMapper mapper, Hashtable<String, String[]> map) throws Exception {
        Object[] toCopy = null;
        if (this.forceOverwrite) {
            Vector<String> v = new Vector<String>();
            for (String name : names) {
                if (mapper.mapFileName(name) == null) continue;
                v.addElement(name);
            }
            toCopy = new String[v.size()];
            v.copyInto(toCopy);
        } else {
            SourceFileScanner ds = new SourceFileScanner();
            toCopy = ds.restrict(names, fromDir, toDir, mapper, this.granularity);
        }
        for (Object elementToCopy : toCopy) {
            File src = new File(fromDir, (String)elementToCopy);
            String[] mappedFiles = mapper.mapFileName((String)elementToCopy);
            if (!this.enableMultipleMappings) {
                map.put(src.getAbsolutePath(), new String[]{new File(toDir, mappedFiles[0]).getAbsolutePath()});
                continue;
            }
            for (int k = 0; k < mappedFiles.length; ++k) {
                mappedFiles[k] = new File(toDir, mappedFiles[k]).getAbsolutePath();
            }
            map.put(src.getAbsolutePath(), mappedFiles);
        }
    }

    protected void doFileOperations() throws Exception {
        Enumeration<Object> e;
        if (this.fileCopyMap.size() > 0) {
            logger.fine("Copying " + this.fileCopyMap.size() + " file" + (this.fileCopyMap.size() == 1 ? "" : "s") + " to " + this.destDir.getAbsolutePath());
            e = this.fileCopyMap.keys();
            while (e.hasMoreElements()) {
                String fromFile = (String)e.nextElement();
                String[] toFiles = this.fileCopyMap.get(fromFile);
                for (String toFile : toFiles) {
                    if (fromFile.equals(toFile)) {
                        logger.warning("Skipping self-copy of " + fromFile);
                        continue;
                    }
                    try {
                        logger.fine("Copying " + fromFile + " to " + toFile);
                        FileUtils.copyFile(fromFile, toFile, this.forceOverwrite, this.preserveLastModified);
                    }
                    catch (IOException ioe) {
                        String msg = "Failed to copy " + fromFile + " to " + toFile + " due to " + ioe.getMessage();
                        File targetFile = new File(toFile);
                        if (targetFile.exists() && !targetFile.delete()) {
                            msg = msg + " and I couldn't delete the corrupt " + toFile;
                        }
                        throw new Exception(msg, ioe);
                    }
                }
            }
        }
        if (this.includeEmpty) {
            e = this.dirCopyMap.elements();
            int createCount = 0;
            while (e.hasMoreElements()) {
                String[] dirs;
                for (String dir : dirs = e.nextElement()) {
                    File d = new File(dir);
                    if (d.exists()) continue;
                    if (!d.mkdirs()) {
                        System.err.println("Unable to create directory " + d.getAbsolutePath());
                        continue;
                    }
                    ++createCount;
                }
            }
            if (createCount > 0) {
                logger.fine("Copied " + this.dirCopyMap.size() + " empty director" + (this.dirCopyMap.size() == 1 ? "y" : "ies") + " to " + createCount + " empty director" + (createCount == 1 ? "y" : "ies") + " under " + this.destDir.getAbsolutePath());
            }
        }
    }
}

