/*
   Copyright (C) 1991-1995 Eberhard Mattes 

   dvispell.h - part of dvispell.
   dvispell converts DVI files into readable text files

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any
   later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  
*/

#include "ext.h"

#define CHAR_CODES 256

#define NIL16            0xffff

#define OUTPUT_HASH_SIZE 257
#define DFA_HASH_SIZE    257

#define S_NEWPAGE        6
#define S_NEWLINE        7
#define S_WORDSPACE      8
#define S_START          9
#define S_END            10
#define S_NONLETTER      11

#define ALLOCARRAY(P,N) ((P) = xmalloc ((N) * sizeof (*(P))))
#define ALLOC(P) ((P) = xmalloc (sizeof (*(P))))
#define RESIZE(P,N) ((P) = xrealloc ((P), (N) * sizeof (*(P))))

#define DFA_HASH(S,I) ((((u16)((S) << 5)) ^ (I)) % DFA_HASH_SIZE)

typedef unsigned short u16;
typedef unsigned long u32;
typedef unsigned char byte;






