/*
 * KON - Kanji ON Linux / FreeBSD Console -
 * Copyright (C) 1992, 1993 Takashi MANABE (manabe@tut.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY TAKASHI MANABE ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * 
 */


#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<unistd.h>
#ifdef __FreeBSD__
#include        <errno.h>
#endif

#include	<getcap.h>

#include	<defs.h>
#include	<version.h>
#include	<vc.h>

#ifdef notdef
static char *startupStr, *execProg;
#else
static char *execProg;
#endif

int	ConfigExecProg(const char *string)
{
	execProg = strdup(string);
	return SUCCESS;
}

#ifdef notdef
static int	ConfigStartup(const char *string)
{
	startupStr = strdup(string);
	return SUCCESS;
}

static void	RunStartupCmd(void)
{
	char *p;

	p = strtok(startupStr, "\n");
	while(p) {
		system(p);
		p = strtok(NULL, "\n");
	}
}
#endif

static bool startupMessage;

static int	ConfigMessage(const char *confstr)
{
	startupMessage = BoolConf(confstr);
	return SUCCESS;
}

void	ChildInit(void)
{
	DefineCap("StartupMessage", ConfigMessage, "On");
#ifdef notdef
	DefineCap("StartUp", ConfigStartup, NULL);
#endif
}

void	ChildCleanup(void)
{
#ifdef notdef
	free(startupStr);
#endif
}

void	ChildStart(FILE *errfp)
{
	char	*shell, *tail, *tcap;
	char	buff[80];

	setgid(getgid());
	setuid(getuid());

#ifdef notdef
	RunStartupCmd();
#endif

#if defined(linux)
	sprintf(buff, "TERMCAP=:co#%d:li#%d:tc=console:",
		dInfo.txmax + 1, dInfo.tymax + 1);
#elif defined(__FreeBSD__)
    sprintf(buff,"TERM=vt100");
#endif
	tcap = strdup(buff);
	putenv(tcap);

	if (startupMessage) {
	    printf("\rKON for Linux 0.99.4e, Copyright (C) 1993, 1994 Takashi MANABE and MAEDA Atusi\r\n"
		   "KON comes with \x1b[4mABSOLUTELY NO WARRANTY\x1b[m.\r\n"
		   "KON is free software, and you are welcome to redistribute it\r\n"
		   "KON under certain conditions; show COPYING for details.\r\n");
#if defined(__FreeBSD__)
	    printf("\rKON for FreeBSD-2.x ver0.01 Takashi OGURA\r\n");
#endif
	}
	printf("KON using VT number %c.\n\n",
#if defined(linux)
	       *(ttyname(fileno(errfp))+8));
#elif defined(__FreeBSD__)
	       *(ttyname(fileno(errfp))+9));
#endif
	fflush(stdout);

	if (execProg)
	    execlp(execProg, execProg, 0);
	else {
	    if ((execProg = getenv("SHELL")) == NULL)
		execProg = "/bin/sh";
	    if ((tail = rindex(execProg, '/')) == NULL)
		tail = " sh";
	    sprintf(buff, "-%s", tail + 1);
	    execl(execProg, buff, 0);
	}
	fprintf(errfp, "KON> couldn't exec shell\r\n");
	fprintf(errfp, "%s: %s\r\n", execProg, strerror(errno));
	exit(40);
}
