/*
 * File: 	notify.c
 * Author: 	Marc van Kempen
 * Desc:	display a notify box with a message
 *
 * Copyright (c) 1995, Marc van Kempen
 *
 * All rights reserved.
 *
 * This software may be used, modified, copied, distributed, and
 * sold, in both source and binary form provided that the above
 * copyright and these terms are retained, verbatim, as the first
 * lines of this file.  Under no circumstances is the author
 * responsible for the proper functioning of this software, nor does
 * the author assume any responsibility for damages incurred with
 * its use.
 *
 */

#ifndef lint
static const char rcsid[] =
  "$FreeBSD: src/gnu/lib/libdialog/notify.c,v 1.6.12.1 2001/08/12 22:48:02 eric Exp $";
#endif

#include <dialog.h>
#include <stdio.h>

void
dialog_notify(char *msg)
/*
 * Desc: display an error message
 */
{
    char *tmphlp;
    WINDOW *w;

    w = dupwin(newscr);
    if (w == NULL) {
	endwin();
	fprintf(stderr, "\ndupwin(newscr) failed, malloc memory corrupted\n");
	exit(1);
    }
    tmphlp = get_helpline();
#ifdef PC98
    use_helpline("Press return or space");
#else
    use_helpline("Press enter or space");
#endif	/* PC98 */
    dialog_mesgbox("Message", msg, -1, -1);
    restore_helpline(tmphlp);
    touchwin(w);
    wrefresh(w);
    delwin(w);

    return;

} /* dialog_notify() */

