#!/bin/sh

# $Id: extract.sh,v 4.0 2000/09/24 11:44:49 akiyama Exp $

release=4.1-RELEASE
default_srcdir=/cdrom
default_dstdir=`pwd`

#
# source directory
#
echo -n "Input distribution directory [${default_srcdir}]? "
read srcdir
if [ X"${srcdir}" = X ]; then
    srcdir=${default_srcdir}
fi

if [ -d ${srcdir}/src ]; then
    srcdir=${srcdir}/src
elif [ -d ${srcdir}/${release}/src ]; then
    srcdir=${srcdir}/${release}/src
else
    echo "$0: no distribution files"
    exit 1
fi

#
# destination directory
#
echo -n "Input work directory [${default_dstdir}]? "
read dstdir

if [ X"${dstdir}" != "X" ]; then
    if [ -w ${dstdir} ]; then
	dstdir="-C ${dstdir}"
    else
	echo "${dstdir}: Permission denied"
	exit 1
    fi
fi

#
# extract
#
echo -n "extracting:"
echo -n " base"
tarcmd="tar --unlink -xpzf - ${dstdir}"
cat ${srcdir}/sbase.?? | ${tarcmd}

echo -n " sys"
cat ${srcdir}/ssys.?? | ${tarcmd}

echo -n " mount newfs_msdos"
files="sbin/Makefile sbin/Makefile.inc sbin/mount sbin/newfs_msdos"
cat ${srcdir}/ssbin.?? | ${tarcmd} ${files}

echo -n " release"
cat ${srcdir}/srelease.?? | ${tarcmd}

echo -n " libdisk"
files="lib/libdisk"
cat ${srcdir}/slib.?? | ${tarcmd} ${files}

echo -n " libdialog"
files="gnu/lib/libdialog"
cat ${srcdir}/sgnu.?? | ${tarcmd} ${files}

echo -n " disklabel"
files="sbin/disklabel"
cat ${srcdir}/ssbin.?? | ${tarcmd} ${files}

echo -n " cksum"
files="usr.bin/cksum"
cat ${srcdir}/subin.?? | ${tarcmd} ${files}

echo .

exit 0
