/*-
 * Copyright (c) 2000, Shunsuke Akiyama <akiyama@FreeBSD.org>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	$Id: sockspipe.h,v 1.3 2000/07/18 09:26:49 akiyama Exp $
 */

#if !defined(_SOCKSPIPE_H)
#define _SOCKSPIPE_H

/*
 *  constants here
 */

#define VERSION	"1.0"

#define IOSIZE	2048

/*
 *  function prototypes
 */

int relay_io(int, int, char *, size_t);
void *relay_in2net(void *);
void *relay_net2out(void *);
int create_connection(struct sockaddr_in *, char *, char *);
void usage(void);
void parse_options(int, char **);
void d_printf(char *, ...);
void v_printf(char *, ...);
void set_signals(void);

/*
 *  socks correspondence
 */

#if defined(USE_SOCKS)
# if USE_SOCKS < 5
#  define	connect		Rconnect
#  define	bind 		Rbind
#  define	select		Rselect
#  define	getsockname 	Rgetsockname
#  define	getpeername 	Rgetpeername
#  define	gethostbyname 	Rgethostbyname
# else
#  define	connect 	SOCKSconnect
#  define	bind 		SOCKSbind
#  define	select		SOCKSselect
#  define	getsockname 	SOCKSgetsockname
#  define	getpeername 	SOCKSgetpeername
#  define	gethostbyname 	SOCKSgethostbyname
# endif
#endif

#endif /* _SOCKSPIPE_H */
