;;; i18n-man-ja.el --- browse UNIX Japanese manual pages
;;; $Id: i18n-man-ja.el,v 1.3 1998/09/12 20:25:53 iwasaki Exp $:

;;;  This file part of i18n-man - i18nized man,
;;;  a GNU Emacs front end to browse the UNIX manual pages in various langages.

;;; Everyone is granted permission to copy, modify and redistribute
;;; this program.

;;; HISTORY
;;;
;;;	Written by Mitsuru IWASAKI 11 Sep, 1998 (FreeBSD Japanese man Project)
;;;

;;; Suggested USAGE
;;;
;;;  In your ~/.emacs
;;;(autoload 'jman "i18n-man-ja" nil t)
;;;(autoload 'eman "i18n-man-en" nil t)
;;;  then
;;;  M-x jman
;;;    to get a Japanese manual page thru jman(1) and put it in a buffer.
;;;  M-x eman
;;;    to get a English manual page thru man(1) and put it in a buffer.

(require 'i18n-man)

(defun i18n-Man-ja-init-defvars ()
  "Used for initialising variables for Japanese i18n-man."
  (setq-default i18n-manual-lang-depend-program "jman")
  (setq-default i18n-Man-lang-depend-heading-regexp
		"^\\([^ \t\n_][^0-9\n]+\\)$")
  (setq-default i18n-Man-lang-depend-see-also-regexp
		"Ϣ\\|^SEE ALSO")
  (setq-default i18n-Man-lang-depend-first-heading-regexp
		"^[ \t]*̾$\\|^[ \t]*NAME$\\|^[ \t]*No manual entry fo.*$")

  (setq-default i18n-Man-lang-depend-cooked-hook
		'i18n-Man-ja-depend-fontify-manpage)
  (setq-default i18n-Man-lang-depend-process-started-hook
		'i18n-Man-ja-depend-process-coding-system))

(defun i18n-Man-ja-depend-fontify-manpage ()
  "Hook for the Japanese manpage depend fontify manpage.
Format the heading characters with BS such as ̾̾."
  (goto-char (point-min))
  (while (re-search-forward "\\(.\\)\\(\b+\\1\\)+" nil t)
    (replace-match "\\1")
    (put-text-property (- (point) 3) (point) 'face i18n-Man-overstrike-face)))
  
(require 'cl)
(defun i18n-Man-ja-depend-process-coding-system (process)
  "Hook for the Japanese manpage depend coding system setting."
  (if (featurep 'mule)
      (case emacs-major-version
	(20 ;; XEmacs or Emacs-20.x (Mule-2.4, 3.0 or later)
	 (if (string-match "XEmacs" emacs-version)
	     (progn (set-process-input-coding-system process 'euc-japan)
		    (set-process-input-coding-system process 'euc-japan))
	   (if (and (boundp 'mule-version)
		    (string-match "2.4" mule-version))
	       ;; Mule-2.4
	       (set-process-coding-system process 'coding-system-euc-japan 'coding-system-euc-japan)
	     ;; Mule-3.0 or later
	     (set-process-coding-system process 'euc-japan 'euc-japan))))
	(19 ;; Emacs-19.x (Mule-2.3)
	 (set-process-coding-system process '*euc-japan* '*euc-japan*)))))
  
;;;###autoload
(defun jman ()
  "i18n-man for Japanese manpage."
  (interactive)
  (i18n-Man-ja-init-defvars)
  (call-interactively 'i18n-man))

(provide 'jman)

;;; i18n-man-ja.el ends here
