--- src/roff/troff/env.h.orig	Sun Nov 23 03:46:19 2008
+++ src/roff/troff/env.h	Thu Nov 20 04:48:16 2008
@@ -216,6 +216,7 @@
 #ifdef	ENABLE_MULTIBYTE
   int stretch_threshold;
   int pre_wchar_cannot_break_after;
+  int pre_wchar_can_break_after;
   int pre_char_is_ascii;
   int enable_wcharkern;
   int met_with_kword_space;
--- src/roff/troff/env.cc.orig	Thu Jan  8 22:44:25 2009
+++ src/roff/troff/env.cc	Thu Jan  8 22:47:46 2009
@@ -320,7 +320,8 @@
 	curenv->add_node(ws);
       }
       pre_char_is_ascii = 1;
-      pre_wchar_cannot_break_after = 0;
+      pre_wchar_cannot_break_after = ci->cannot_break_after();
+      pre_wchar_can_break_after = 0;
     } else {
       /*
        * This node is a EUC charcater node.
@@ -335,7 +336,41 @@
 	space_total -= ns_node->nspaces();
 	delete ns_node;
       }
-
+      else if (!pre_char_is_ascii && line->next &&
+	       line->next->get_node_type() == NODE_NEWLINE_SPACE) {
+	/*
+	 *	line == (some special node)->(newline_space node)->
+	 *	delete newline_space node;
+	 */
+	node_type nt = line->get_node_type();
+	if (!(line->next->next && line->next->next->get_node_type() == NODE_TRANSPARENT_DUMMY) &&
+	    nt != NODE_GLYPH) {
+	    node *ns_node = line->next;
+	    line->next = ns_node->next;
+	    width_total -= ns_node->width();
+	    space_total -= ns_node->nspaces();
+	    delete ns_node;
+	}
+      }
+      // .Tn xxxx
+      else if (!pre_char_is_ascii && line->get_node_type() == NODE_TRANSPARENT_DUMMY) {
+	    /*
+	     * line == (transparent_dummy_node)->... ->(newline_space node)->
+	     * remove a newline-node.
+	     */
+	    node *ns_node = line->next;
+	    node *line2 = line;
+	    while (ns_node && ns_node->get_node_type() == NODE_TRANSPARENT_DUMMY) {
+		line2 = ns_node;
+		ns_node = ns_node->next;
+	    }
+	    if (ns_node && ns_node->get_node_type() == NODE_NEWLINE_SPACE) {
+		line2->next = ns_node->next;
+		width_total -= ns_node->width();
+		space_total -= ns_node->nspaces();
+		delete ns_node;
+	    }
+      }
       if (!pre_wchar_cannot_break_after && !ci->cannot_break_before()) {
 	/*
 	 * add a zero-width-space-node before EUC charcater node.
@@ -344,6 +379,7 @@
 	met_with_kword_space = 1;
       }
       pre_wchar_cannot_break_after = ci->cannot_break_after();
+      pre_wchar_can_break_after = ci->can_break_after();
 
       if (pre_char_is_ascii && enable_wcharkern && !hwkern.is_zero()) {
 	/*
@@ -487,7 +523,11 @@
     return;
   }
 #ifdef ENABLE_MULTIBYTE
-  add_node(new newline_space_node(x, get_fill_color())); // This node may be removed
+  if (pre_wchar_can_break_after)
+    add_node(new kword_space_node(get_fill_color()));	// zero length
+  else
+    add_node(new newline_space_node(x, get_fill_color()));
+  pre_wchar_can_break_after = 0;
 #else
   add_node(new word_space_node(x, get_fill_color(), w));
 #endif
@@ -778,6 +818,7 @@
   ,
   stretch_threshold(0),
   pre_wchar_cannot_break_after(0),
+  pre_wchar_can_break_after(0),
   pre_char_is_ascii(-1),
   enable_wcharkern(0),
   met_with_kword_space(0),
@@ -878,6 +919,7 @@
   ,
   stretch_threshold(e->stretch_threshold),
   pre_wchar_cannot_break_after(0),
+  pre_wchar_can_break_after(0),
   pre_char_is_ascii(-1),
   enable_wcharkern(0),
   met_with_kword_space(0),
@@ -1760,6 +1802,9 @@
 
 void environment::interrupt()
 {
+#ifdef ENABLE_MULTIBYTE
+  pre_wchar_can_break_after = 0;
+#endif
   if (!dummy) {
     add_node(new transparent_dummy_node);
     interrupted = 1;
