--- src/roff/troff/node.h.orig	Tue Nov 25 22:55:55 2008
+++ src/roff/troff/node.h	Wed Dec 31 02:22:16 2008
@@ -34,7 +34,40 @@
 
 enum hyphenation_type { HYPHEN_MIDDLE, HYPHEN_BOUNDARY, HYPHEN_INHIBIT };
 #ifdef	ENABLE_MULTIBYTE
-enum node_type {NODE_GLYPH, NODE_KWORD_SPACE, NODE_NEWLINE_SPACE, NODE_ANOTHER};
+enum node_type {
+    NODE_BRACKET,
+    NODE_BREAK_CHAR,
+    NODE_COMPOSITE,
+    NODE_DBREAK,
+    NODE_DIVERTED_COPY_FILE,
+    NODE_DIVERTED_SPACE,
+    NODE_DRAW,
+    NODE_DUMMY,
+    NODE_EXTRA_SIZE,
+    NODE_GLYPH,
+    NODE_HLINE,
+    NODE_HMOTION,
+    NODE_HYPHEN_INHIBITOR,
+    NODE_ITALIC_CORRECTED,
+    NODE_KERN_PAIR,
+    NODE_KWORD_SPACE,
+    NODE_LEFT_ITALIC_CORRECTED,
+    NODE_LIGATURE,
+    NODE_LINE_START,
+    NODE_NEWLINE_SPACE,
+    NODE_OVERSTRIKE,
+    NODE_SPACE_CHAR_HMOTION,
+    NODE_SPACE,
+    NODE_SPECIAL,
+    NODE_SUPPRESS,
+    NODE_TRANSPARENT_DUMMY,
+    NODE_UNBREAKABLE_SPACE,
+    NODE_VERTICAL_SIZE,
+    NODE_VLINE,
+    NODE_VMOTION,
+    NODE_WORD_SPACE,
+    NODE_ZERO_WIDTH,
+    NODE_ANOTHER};
 #endif
 
 class ascii_output_file;
@@ -151,6 +184,9 @@
   int force_tprint();
   const char *type();
   void asciify(macro *);
+#ifdef	ENABLE_MULTIBYTE
+  node_type get_node_type();
+#endif
 };
 
 class space_node : public node {
@@ -191,6 +227,9 @@
   const char *type();
   int force_tprint();
   hyphenation_type get_hyphenation_type();
+#ifdef	ENABLE_MULTIBYTE
+  node_type get_node_type();
+#endif
 };
 
 struct width_list {
@@ -218,6 +257,9 @@
   const char *type();
   int merge_space(hunits, hunits, hunits);
   int force_tprint();
+#ifdef	ENABLE_MULTIBYTE
+  node_type get_node_type();
+#endif
 };
 
 #ifdef	ENABLE_MULTIBYTE
@@ -256,6 +298,9 @@
   node *add_self(node *, hyphen_list **);
   hyphen_list *get_hyphen_list(hyphen_list *ss = 0);
   hyphenation_type get_hyphenation_type();
+#ifdef	ENABLE_MULTIBYTE
+  node_type get_node_type();
+#endif
 };
 
 class diverted_space_node : public node {
@@ -267,6 +312,9 @@
   int same(node *);
   const char *type();
   int force_tprint();
+#ifdef	ENABLE_MULTIBYTE
+  node_type get_node_type();
+#endif
 };
 
 class diverted_copy_file_node : public node {
@@ -279,6 +327,9 @@
   int same(node *);
   const char *type();
   int force_tprint();
+#ifdef	ENABLE_MULTIBYTE
+  node_type get_node_type();
+#endif
 };
 
 class extra_size_node : public node {
@@ -290,6 +341,9 @@
   int same(node *);
   const char *type();
   int force_tprint();
+#ifdef	ENABLE_MULTIBYTE
+  node_type get_node_type();
+#endif
 };
 
 class vertical_size_node : public node {
@@ -303,6 +357,9 @@
   int same(node *);
   const char *type();
   int force_tprint();
+#ifdef	ENABLE_MULTIBYTE
+  node_type get_node_type();
+#endif
 };
 
 class hmotion_node : public node {
@@ -329,6 +386,9 @@
   node *add_self(node *, hyphen_list **);
   hyphen_list *get_hyphen_list(hyphen_list *ss = 0);
   hyphenation_type get_hyphenation_type();
+#ifdef	ENABLE_MULTIBYTE
+  node_type get_node_type();
+#endif
 };
 
 class space_char_hmotion_node : public hmotion_node {
@@ -343,6 +403,9 @@
   node *add_self(node *, hyphen_list **);
   hyphen_list *get_hyphen_list(hyphen_list *ss = 0);
   hyphenation_type get_hyphenation_type();
+#ifdef	ENABLE_MULTIBYTE
+  node_type get_node_type();
+#endif
 };
 
 class vmotion_node : public node {
@@ -356,6 +419,9 @@
   int same(node *);
   const char *type();
   int force_tprint();
+#ifdef	ENABLE_MULTIBYTE
+  node_type get_node_type();
+#endif
 };
 
 class hline_node : public node {
@@ -370,6 +436,9 @@
   int same(node *);
   const char *type();
   int force_tprint();
+#ifdef	ENABLE_MULTIBYTE
+  node_type get_node_type();
+#endif
 };
 
 class vline_node : public node {
@@ -386,6 +455,9 @@
   int same(node *);
   const char *type();
   int force_tprint();
+#ifdef	ENABLE_MULTIBYTE
+  node_type get_node_type();
+#endif
 };
 
 
@@ -397,6 +469,9 @@
   const char *type();
   int force_tprint();
   hyphenation_type get_hyphenation_type();
+#ifdef	ENABLE_MULTIBYTE
+  node_type get_node_type();
+#endif
 };
 
 class transparent_dummy_node : public node {
@@ -408,6 +483,9 @@
   int force_tprint();
   int ends_sentence();
   hyphenation_type get_hyphenation_type();
+#ifdef	ENABLE_MULTIBYTE
+  node_type get_node_type();
+#endif
 };
 
 class zero_width_node : public node {
@@ -423,6 +501,9 @@
   void append(node *);
   int character_type();
   void vertical_extent(vunits *min, vunits *max);
+#ifdef	ENABLE_MULTIBYTE
+  node_type get_node_type();
+#endif
 };
 
 class left_italic_corrected_node : public node {
@@ -453,6 +534,9 @@
   hyphen_list *get_hyphen_list(hyphen_list *ss = 0);
   node *add_self(node *, hyphen_list **);
   node *merge_glyph_node(glyph_node *);
+#ifdef	ENABLE_MULTIBYTE
+  node_type get_node_type();
+#endif
 };
 
 class overstrike_node : public node {
@@ -471,6 +555,9 @@
   node *add_self(node *, hyphen_list **);
   hyphen_list *get_hyphen_list(hyphen_list *ss = 0);
   hyphenation_type get_hyphenation_type();
+#ifdef	ENABLE_MULTIBYTE
+  node_type get_node_type();
+#endif
 };
 
 class bracket_node : public node {
@@ -486,6 +573,9 @@
   int same(node *);
   const char *type();
   int force_tprint();
+#ifdef	ENABLE_MULTIBYTE
+  node_type get_node_type();
+#endif
 };
 
 class special_node : public node {
@@ -507,6 +597,9 @@
   int force_tprint();
   int ends_sentence();
   tfont *get_tfont();
+#ifdef	ENABLE_MULTIBYTE
+  node_type get_node_type();
+#endif
 };
 
 class suppress_node : public node {
@@ -525,6 +618,9 @@
   int same(node *);
   const char *type();
   int force_tprint();
+#ifdef	ENABLE_MULTIBYTE
+  node_type get_node_type();
+#endif
 private:
   void put(troff_output_file *out, const char *s);
 };
@@ -552,6 +648,9 @@
   int same(node *);
   const char *type();
   int force_tprint();
+#ifdef	ENABLE_MULTIBYTE
+  node_type get_node_type();
+#endif
 };
 
 class charinfo;
--- src/roff/troff/node.cc.orig	Tue Nov 25 22:55:55 2008
+++ src/roff/troff/node.cc	Wed Dec 31 02:22:16 2008
@@ -1907,6 +1907,9 @@
   const char *type();
   int force_tprint();
   void vertical_extent(vunits *, vunits *);
+#ifdef	ENABLE_MULTIBYTE
+  node_type get_node_type();
+#endif
 };
 
 class dbreak_node : public node {
@@ -1935,6 +1938,9 @@
   int same(node *);
   const char *type();
   int force_tprint();
+#ifdef	ENABLE_MULTIBYTE
+  node_type get_node_type();
+#endif
 };
 
 void *glyph_node::operator new(size_t n)
@@ -2359,6 +2365,9 @@
   const char *type();
   int force_tprint();
   hyphenation_type get_hyphenation_type();
+#ifdef	ENABLE_MULTIBYTE
+  node_type get_node_type();
+#endif
 };
 
 hyphen_inhibitor_node::hyphen_inhibitor_node(node *nd) : node(nd)
@@ -2535,6 +2544,9 @@
   node *add_self(node *, hyphen_list **);
   const char *type();
   int force_tprint();
+#ifdef	ENABLE_MULTIBYTE
+  node_type get_node_type();
+#endif
 };
 
 node *node::add_italic_correction(hunits *width)
@@ -2674,6 +2686,9 @@
   int same(node *);
   const char *type();
   int force_tprint();
+#ifdef	ENABLE_MULTIBYTE
+  node_type get_node_type();
+#endif
 };
 
 break_char_node::break_char_node(node *n, int bc, color *c, node *x)
@@ -3920,6 +3935,9 @@
   int force_tprint();
   void vertical_extent(vunits *, vunits *);
   vunits vertical_width();
+#ifdef	ENABLE_MULTIBYTE
+  node_type get_node_type();
+#endif
 };
 
 composite_node::composite_node(node *p, charinfo *c, tfont *t, node *x)
@@ -5328,10 +5346,174 @@
   return "newline_space_node";
 }
 
+/* get node functions */
+
 node_type node::get_node_type()
 {
     return NODE_ANOTHER;
 }
+
+node_type bracket_node::get_node_type()
+{
+    return NODE_BRACKET;
+}
+
+node_type break_char_node::get_node_type()
+{
+    return NODE_BREAK_CHAR;
+}
+
+node_type composite_node::get_node_type()
+{
+    return NODE_COMPOSITE;
+}
+
+node_type dbreak_node::get_node_type()
+{
+    return NODE_DBREAK;
+}
+
+node_type diverted_copy_file_node::get_node_type()
+{
+    return NODE_DIVERTED_COPY_FILE;
+}
+
+node_type diverted_space_node::get_node_type()
+{
+    return NODE_DIVERTED_SPACE;
+}
+
+node_type draw_node::get_node_type()
+{
+    return NODE_DRAW;
+}
+
+node_type dummy_node::get_node_type()
+{
+    return NODE_DUMMY;
+}
+
+node_type extra_size_node::get_node_type()
+{
+    return NODE_EXTRA_SIZE;
+}
+
+node_type glyph_node::get_node_type()
+{
+    return NODE_GLYPH;
+}
+
+node_type hline_node::get_node_type()
+{
+    return NODE_HLINE;
+}
+
+node_type hmotion_node::get_node_type()
+{
+    return NODE_HMOTION;
+}
+
+node_type hyphen_inhibitor_node::get_node_type()
+{
+    return NODE_HYPHEN_INHIBITOR;
+}
+
+node_type italic_corrected_node::get_node_type()
+{
+    return NODE_ITALIC_CORRECTED;
+}
+
+node_type kern_pair_node::get_node_type()
+{
+    return NODE_KERN_PAIR;
+}
+
+node_type kword_space_node::get_node_type()
+{
+    return NODE_KWORD_SPACE;
+}
+
+node_type left_italic_corrected_node::get_node_type()
+{
+    return NODE_LEFT_ITALIC_CORRECTED;
+}
+
+node_type ligature_node::get_node_type()
+{
+    return NODE_LIGATURE;
+}
+
+node_type line_start_node::get_node_type()
+{
+    return NODE_LINE_START;
+}
+
+node_type newline_space_node::get_node_type()
+{
+    return NODE_NEWLINE_SPACE;
+}
+
+node_type overstrike_node::get_node_type()
+{
+    return NODE_OVERSTRIKE;
+}
+
+node_type space_char_hmotion_node::get_node_type()
+{
+    return NODE_SPACE_CHAR_HMOTION;
+}
+
+node_type space_node::get_node_type()
+{
+    return NODE_SPACE;
+}
+
+node_type special_node::get_node_type()
+{
+    return NODE_SPECIAL;
+}
+
+node_type suppress_node::get_node_type()
+{
+    return NODE_SUPPRESS;
+}
+
+node_type transparent_dummy_node::get_node_type()
+{
+    return NODE_TRANSPARENT_DUMMY;
+}
+
+node_type unbreakable_space_node::get_node_type()
+{
+    return NODE_UNBREAKABLE_SPACE;
+}
+
+node_type vertical_size_node::get_node_type()
+{
+    return NODE_VERTICAL_SIZE;
+}
+
+node_type vline_node::get_node_type()
+{
+    return NODE_VLINE;
+}
+
+node_type vmotion_node::get_node_type()
+{
+    return NODE_VMOTION;
+}
+
+node_type word_space_node::get_node_type()
+{
+    return NODE_WORD_SPACE;
+}
+
+node_type zero_width_node::get_node_type()
+{
+    return NODE_ZERO_WIDTH;
+}
+
+#if 0
 node_type glyph_node::get_node_type()
 {
     return NODE_GLYPH;
@@ -5350,6 +5532,7 @@
 {
     return NODE_NEWLINE_SPACE;
 }
+#endif
 #endif
 
 int unbreakable_space_node::same(node *nd)
