# Provide support for building Zig software.
#
# Feature:	zig
# Usage:	USES=zig
# Valid ARGS:	(none), XYZ
#
# XYZ		Specify alternative Zig compiler version

# Variables, which can be set by the port:
#
#  ZIG_TUPLE		List of Zig dependencies required to build the port.
#			Each item is triplet of an arbitrary name, an URL without
#			scheme part (https://) and a directory name where the
#			expects this dependency to be placed.
#			This knob can be generated by running make make-zig-tuple
#			You might need to run this multiple time until all
#			transitive dependencies get pulled in.
#
# MAINTAINER: ports@FreeBSD.org

.if !defined(_INCLUDE_USES_ZIG_MK)
_INCLUDE_USES_ZIG_MK=    yes

# Check arguments sanity
.  if !empty(zig_ARGS:N[0-9][0-9][0-9])
IGNORE=	USES=zig has invalid arguments: ${zig_ARGS:N[0-9][0-9][0-9]}
.  endif

.sinclude "${MASTERDIR}/Makefile.zig"

ZIG_CMD?=	zig
ZIG_PORT?=	lang/zig${zig_ARGS}
ZIG_DEPSDIR=	${WRKDIR}/zig-packages
ZIG_TMPDEPSDIR=	${WRKDIR}/zig-packages-tmp

# Check alternative Zig version if requested
.  if ${zig_ARGS} && !exists(${PORTSDIR}/${ZIG_PORT})
IGNORE?= USES=zig has invalid version number: ${zig_ARGS}
.  endif

ZIG_CPUTYPE_DEFAULT=	${ARCH:S/amd64/x86_64/}
ZIG_CPUTYPE?=		${CPUTYPE:U${ZIG_CPUTYPE_DEFAULT}}

_ZIG2TUPLE_CMD=	zig2tuple

BUILD_DEPENDS+=	${ZIG_CMD}:${ZIG_PORT}

DIST_SUBDIR?=	zig

.  for z in ${ZIG_TUPLE}
.    for group url dir in ${z:S/:/ /g:tw}
MASTER_SITES+=	https://${url:H}/:${group}
DISTFILES+=	${url:T}:${group}
.    endfor
.  endfor

_USES_extract=	299:zig-pre-extract

# Generates ZIG_TUPLE= ... line ready to be pasted into the port based on
# build.zig.zon files found in ${WRKSRC}
make-zig-tuple: check-zig2tuple
	@${ECHO_MSG} "===> Processing build.zig.zon files"
	${_ZIG2TUPLE_CMD} ${WRKDIR}

check-zig2tuple:
	@if ! type ${_ZIG2TUPLE_CMD} > /dev/null 2>&1; then \
		${ECHO_MSG} "===> zig2tuple executable not found, install \"ports-mgmt/zig2tuple\""; exit 1; \
	fi

# Main targets implementation.

zig-pre-extract:
	@${ECHO_CMD} "===> Extracting zig dependencies"
# We don't know the name of the directory that is contained in the archive,
# but we need to rename it into the last component of the tuple
# To solve this we extract into an empty directory and then do
# mv * /path/where/we/want/it
	@${MKDIR} ${ZIG_DEPSDIR} ${ZIG_TMPDEPSDIR}
.  for z in ${ZIG_TUPLE}
.    for group url dir in ${z:S/:/ /g:tw}
	${MAKE} -C ${.CURDIR} do-extract EXTRACT_ONLY=${url:T} WRKDIR=${ZIG_TMPDEPSDIR}
	# In some cases the distfile holds files at the top level of the archive,
	# s we have to move ${ZIG_TMPDEPSDIR} itself, not its contents.
	if [ "$$(${FIND} ${ZIG_TMPDEPSDIR} -depth 1 -type f)" ]; then \
		${MV} ${ZIG_TMPDEPSDIR} ${ZIG_DEPSDIR}/${dir}; \
	else \
		${MV} ${ZIG_TMPDEPSDIR}/* ${ZIG_DEPSDIR}/${dir}; \
	fi
.    endfor
.  endfor
	@${RMDIR} ${ZIG_TMPDEPSDIR}

ZIG_ENV+=	DESTDIR=${STAGEDIR}
ZIG_ARGS+=	--prefix ${PREFIX} --system ${ZIG_DEPSDIR} --verbose \
		-Dcpu=${ZIG_CPUTYPE} \
		${"${WITH_DEBUG}" != "":?:--release=fast} \
		${"${WITH_DEBUG}" != "":?-Doptimize=Debug:-Doptimize=ReleaseSmall} \
		${ZIG_ARGS_${FLAVOR}}
DO_MAKE_BUILD?=	${SETENVI} ${WRK_ENV} ${ZIG_ENV} ${ZIG_CMD} build \
				${_MAKE_JOBS} ${ZIG_ARGS}
.  if !target(do-build)
do-build:
	@${DO_NADA}
.  endif

.  if !target(do-install)
do-install:
	@(cd ${BUILD_WRKSRC}; if ! ${DO_MAKE_BUILD}; then \
		if [ -n "${BUILD_FAIL_MESSAGE}" ] ; then \
			${ECHO_MSG} "===> Compilation failed unexpectedly."; \
			(${ECHO_CMD} "${BUILD_FAIL_MESSAGE}") | ${FMT_80} ; \
			fi; \
		${FALSE}; \
		fi)
.  endif

.endif
