#!/bin/sh
#
# Simple script to fetch the latest commits via the gitlab API.  Requires
# curl and jq.  Uses unauthenticated access.

REPOS_URL=https://git.morello-project.org/api/v4/projects/morello
MAX_DATE=1970101

tmpfile=`mktemp -t gen-Makefile.snapshot`

query_repo()
{
	curl ${REPOS_URL}%2F$1/repository/branches/morello%2Fdev > $tmpfile

	# Accumulate the dates of the last commits to find the snapshot date
	committime=`jq -r '.commit.committed_date' $tmpfile`
	committime=${committime%%T*}
	year=${committime%%-*}
	month=${committime%-*}
	month=${month#*-}
	day=${committime##*-}
	dateint=${year}${month}${day}
	if [ $dateint -gt $MAX_DATE ]; then
		export MAX_DATE=$dateint
	fi

	SHA=`jq -r '.commit.id' $tmpfile`
}

query_repo llvm-project
LLVM_COMMIT=$SHA

cat <<EOF > Makefile.snapshot
# Generated file!  Do not edit!  
#
# Generated by: files/gen-Makefile.snapshot.sh.
#
LLVM_MAJOR=	17
LLVM_RELEASE=	\${LLVM_MAJOR}.0.0
SNAPDATE=	${MAX_DATE}

LLVM_COMMIT=		${LLVM_COMMIT}
EOF

rm -f $tmpfile
