# $FreeBSD: stable/4/kerberosIV/Makefile.inc 100658 2002-07-25 09:33:17Z ru $

DISTRIBUTION?=	krb4

.if !defined(INCLUDEOBJDIR)

KRB4DIR=	${.CURDIR}/../../../crypto/kerberosIV
TELNETDIR=	${.CURDIR}/../../../crypto/telnet

.if exists(${.OBJDIR}/../../include)
INCLUDEOBJDIR=	${.OBJDIR}/../../include
.else
INCLUDEOBJDIR=	${.CURDIR}/../../include
.endif

.if exists(${.OBJDIR}/../../lib/libacl)
ROKENOBJDIR=	${.OBJDIR}/../../../kerberosIV/lib/libroken
.else
ROKENOBJDIR=	${.CURDIR}/../../../kerberosIV/lib/libroken
.endif

.if exists(${.OBJDIR}/../../lib/libacl)
ACLOBJDIR=	${.OBJDIR}/../../lib/libacl
.else
ACLOBJDIR=	${.CURDIR}/../../lib/libacl
.endif

.if exists(${.OBJDIR}/../../lib/libkadm)
KADMOBJDIR=	${.OBJDIR}/../../lib/libkadm
.else
KADMOBJDIR=	${.CURDIR}/../../lib/libkadm
.endif

.if exists(${.OBJDIR}/../../lib/libkafs)
KAFSOBJDIR=	${.OBJDIR}/../../lib/libkafs
.else
KAFSOBJDIR=	${.CURDIR}/../../lib/libkafs
.endif

.if exists(${.OBJDIR}/../../lib/libkdb)
KDBOBJDIR=	${.OBJDIR}/../../lib/libkdb
.else
KDBOBJDIR=	${.CURDIR}/../../lib/libkdb
.endif

.if exists(${.OBJDIR}/../../lib/libkrb)
KRBOBJDIR=	${.OBJDIR}/../../lib/libkrb
.else
KRBOBJDIR=	${.CURDIR}/../../lib/libkrb
.endif

.if exists(${.OBJDIR}/../../lib/libroken)
ROKENOBJDIR=	${.OBJDIR}/../../lib/libroken
.else
ROKENOBJDIR=	${.CURDIR}/../../lib/libroken
.endif

.if exists(${.OBJDIR}/../../lib/libsl)
SLOBJDIR=	${.OBJDIR}/../../lib/libsl
.else
SLOBJDIR=	${.CURDIR}/../../lib/libsl
.endif

.if exists(${.OBJDIR}/../../lib/libtelnet)
LIBTELNET=	${.OBJDIR}/../../lib/libtelnet/libtelnet.a
.else
LIBTELNET=	${.CURDIR}/../../lib/libtelnet/libtelnet.a
.endif

CFLAGS+= -I${.CURDIR}/../../include -Wall -DHAVE_CONFIG_H \
	-I${INCLUDEOBJDIR} \
	-DBINDIR=\"/usr/bin\" -DSBINDIR=\"/usr/sbin\" \
	-DLIBEXECDIR=\"/usr/libexec\"

protos.h: ${KRB4DIR}/include/protos.H
	ln -sf ${.ALLSRC} ${.TARGET} 

COMPILE_ET=     compile_et

.ORDER: ${KADMOBJDIR}/kadm_err.c ${KADMOBJDIR}/kadm_err.h
${KADMOBJDIR}/kadm_err.c ${KADMOBJDIR}/kadm_err.h: ${KRB4DIR}/lib/kadm/kadm_err.et          
	test -e ${KADMOBJDIR}/kadm_err.et || ln -s ${.ALLSRC} ${KADMOBJDIR}
	cd ${KADMOBJDIR}; ${COMPILE_ET} kadm_err.et

CLEANFILES+=${KADMOBJDIR}/kadm_err.h ${KADMOBJDIR}/kadm_err.c ${KADMOBJDIR}/kadm_err.et

.ORDER: ${KRBOBJDIR}/krb_err.c ${KRBOBJDIR}/krb_err.h
${KRBOBJDIR}/krb_err.c ${KRBOBJDIR}/krb_err.h: ${KRB4DIR}/lib/krb/krb_err.et
	test -e ${KRBOBJDIR}/krb_err.et || ln -s ${.ALLSRC} ${KRBOBJDIR}
	cd ${KRBOBJDIR}; ${COMPILE_ET} krb_err.et

CLEANFILES+=${KRBOBJDIR}/krb_err.h ${KRBOBJDIR}/krb_err.c ${KRBOBJDIR}/krb_err.et

.else

KRB4DIR=	${.CURDIR}/../../crypto/kerberosIV

.endif
