/*
 *
 *	A DCL driver for GNU "CC".  It accepts a CLD syntax identical to
 *	VAX-11 "C".
 *
 *	Since GCC consists of more than 1 pass we have to do the parsing
 *	here and have a DCL Command (.COM) file do the real work -- so that
 *	multiple images can be invoked WITHOUT having to resort to LIB$SPAWN.
 */

char *Input_Files[100];		/* Input file specifications */
char *Defines[100];		/* /DEFINE specifications    */
char *Includes[100];		/* /INCLUDE specifications   */
char *Debug;			/* /DEBUG specification	     */
char *Object;			/* Object file name	     */
int Optimize;			/* Do optimized compile	     */
int Machine_Code;		/* Output assembly lang	     */
int Verbose;			/* Make noise while compiling*/
char cc1_Options[100];		/* Options for the CC1 pass  */
char *Undefines[100];		/* /UNDEFINE specifications  */


/*
 *	Save a string in dynamic memory
 */
char *savestr(String)
register char *String;
{
	register char *cp,*New_String;

	/*
	 *	Allocate it
	 */
	New_String = (char *)malloc(strlen(String)+1);
	/*
	 *	Copy it
	 */
	cp = New_String;
	while((*cp++ = *String++) != 0) ;
	/*
	 *	Return it
	 */
	return(New_String);
}


/*
 *	Do the parsing
 */
main()
{
	register char *cp,*cp1;
	int i;
	char Temp[256];

	/*
	 *	Get the Input files
	 */
	i = 0;
	while(cli_get_value("VCG$INPUT",Temp,sizeof(Temp)))
				Input_Files[i++] = savestr(Temp);
	/*
	 *	Do the /DEFINE qualifier
	 */
	if (cli_present("VCG$DEFINE")) {
		i = 0;
		while(cli_get_value("VCG$DEFINE",Temp,sizeof(Temp))) {
					Defines[i++] = savestr(Temp);
#ifdef	notdef
					Euniceify(&Defines[i-1]);
#endif	notdef
		}
	}
	/*
	 *	Do the /DEBUG qualifier
	 */
	if (cli_present("VCG$DEBUG")) {
		/*
		 *	Get the value (Default = ALL)
		 */
		if (!cli_get_value("VCG$DEBUG",Temp,sizeof(Temp)))
			strcpy(Temp,"ALL");
		/*
		 *	Save it
		 */
		Debug = savestr(Temp);
	}
	/*
	 *	Do the "/INCLUDE_DIRECTORY" qualifier
	 */
	if (cli_present("VCG$INCLUDE")) {
		i = 0;
		while(cli_get_value("VCG$INCLUDE",Temp,sizeof(Temp)))
					Includes[i++] = savestr(Temp);
	}
	/*
	 *	Do the /MACHINE_CODE qualifier
	 */
	if (cli_present("VCG$MACHINE")) Machine_Code = 1;
	/*
	 *	Do the /OBJECT qualifier
	 */
	if (cli_present("VCG$OBJECT")) {
		cli_get_value("VCG$OBJECT",Temp,sizeof(Temp));
		Object = savestr(Temp);
	}
	/*
	 *	Do the /OPTIMIZE qualifier
	 */
	if (cli_present("VCG$OPTIM")) Optimize = 1;
	/*
	 *	Do the /UNDEFINE qualifier
	 */
	if (cli_present("VCG$UNDEFINE")) {
		i = 0;
		while(cli_get_value("VCG$UNDEFINE",Temp,sizeof(Temp))) {
					Undefines[i++] = savestr(Temp);
#ifdef	notdef
					Euniceify(&Undefines[i-1]);
#endif	notdef
		}
	}
	/*
	 *	Do the /CC1_OPTIONS qualifier
	 */
	if (cli_present("VCG$CC1_OPTIONS"))
		cli_get_value("VCG$CC1_OPTIONS",cc1_Options,sizeof(cc1_Options));
	/*
	 *	Do the /VERBOSE qualifier
	 */
	if (cli_present("VCG$VERBOSE")) Verbose = 1;
	/*
	 *	Generate the command
	 */
	cp = Temp;

	/* Invoke the .COM file */
	cp1 = "@GNU_CC:[000000]GCC";
	while(*cp1) *cp++ = *cp1++;

	/* P1 = File to compile */
	*cp++ = ' ';
	cp1 = Input_Files[0];
	while(*cp1) *cp++ = *cp1++;

	/* P2 = Options */
	*cp++ = ' ';
	if (Optimize || Debug || Machine_Code || Verbose) {
		if (Optimize)*cp++ = 'O';
		if (Debug)*cp++ = 'D';
		if (Machine_Code)*cp++ = 'M';
		if (Verbose) *cp++ = 'V';
	} else {
		*cp++ = '"';
		*cp++ = '"';
	}

	/* P3 = Defines */
	*cp++ = ' ';
	*cp++ = '"';
	if (Defines[0]) {
		cp1 = Defines[0];
		while(*cp1) {
			if (*cp1 == '"') *cp++ = '"';
			*cp++ = *cp1++;
		}

		i = 1;
		while(Defines[i]) {
			*cp++ = ',';
			cp1 = Defines[i++];
			while(*cp1) {
				if (*cp1 == '"') *cp++ = '"';
				*cp++ = *cp1++;
			}
		}
	}
	*cp++ = '"';

	/* P4 = Undefines */
	*cp++ = ' ';
	*cp++ = '"';
	if (Undefines[0]) {
		cp1 = Undefines[0];
		while(*cp1) {
			if (*cp1 == '"') *cp++ = '"';
			*cp++ = *cp1++;
		}

		i = 1;
		while(Undefines[i]) {
			*cp++ = ',';
			cp1 = Undefines[i++];
			while(*cp1) {
				if (*cp1 == '"') *cp++ = '"';
				*cp++ = *cp1++;
			}
		}
	}
	*cp++ = '"';
	/* P5 = Include directories */
	*cp++ = ' ';
	*cp++ = '"';
	if (Includes[0]) {
		cp1 = Includes[0];
		while(*cp1) *cp++ = *cp1++;

		i = 1;
		while(Includes[i]) {
			*cp++ = ',';
			cp1 = Includes[i++];
			while(*cp1) *cp++ = *cp1++;
		}
	}
	*cp++ = '"';

	/* P6 = CC1 compilation phase options */
	cp1 = cc1_Options;
	*cp++ = ' ';
	*cp++ = '"';
	while(*cp1) *cp++ = *cp1++;
	*cp++ = '"';

	/*
	 *	Do it
	 */
	lib_do_command(Temp, cp - Temp);
}


/*
 *	Execute the given DCL command
 */
lib_do_command(Text,Size)
char *Text;
int Size;
{
	struct {int Size; char *Ptr;} Descr;

	Descr.Ptr = Text;
	Descr.Size = Size;
	lib$do_command(&Descr);
}


/************		DCL PARSING ROUTINES		**********/

/*
 *	See if "NAME" is present
 */
int cli_present(Name)
char *Name;
{
	struct {int Size; char *Ptr;} Descr;

	Descr.Ptr = Name;
	Descr.Size = strlen(Name);
	return((cli$present(&Descr) & 1) ? 1 : 0);
}

/*
 *	Get value of "NAME"
 */
int cli_get_value(Name,Buffer,Size)
char *Name;
char *Buffer;
{
	struct {int Size; char *Ptr;} Descr1,Descr2;

	Descr1.Ptr = Name;
	Descr1.Size = strlen(Name);
	Descr2.Ptr = Buffer;
	Descr2.Size = Size-1;
	if (cli$get_value(&Descr1,&Descr2,&Descr2.Size) & 1) {
		Buffer[Descr2.Size] = 0;
		return(1);
	}
	return(0);
}


#ifdef	notdef
/*
 *	TEMPORARY:  Fixup define/undefine strings for Eunice command line
 *			processing
 */
Euniceify(sp)
char **sp;
{
#define	isupper(c) ((c >= 'A') && (c <= 'Z'))
#define tolower(c) (c - 'A' + 'a')
	register char *cp,*cp1;
	char Local[512];

	cp = *sp;
	cp1 = Local;
	while(*cp) {
		if (isupper(*cp)) {
			*cp1++ = '^';
			*cp1 = tolower(*cp);
		} else {
			*cp1 = *cp;
		}
		cp++;
		cp1++;
	}
	*cp1++ = 0;
	cp = (char *)malloc(strlen(Local)+1);
	strcpy(cp,Local);
	*sp = cp;
}
#endif	notdef
