
;;; d-flush-checkpoints.el

;; Copyright (C) 2014-2015 Davin Pearson

;; Emacs Lisp Archive Entry
;; Filename: d-flush-checkpoints.el
;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords: checkpoint flusher
;; Version: 1.0

;;; Commentary:

;; This file is not part of GNU Emacs.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; Known Bugs:

;; None so far!

;;; Code:
;;;
;;; flushes checkpoints
;;;
(defun d-flush-checkpoints (files)
  (save-some-buffers t)
  (let ((ptr files))
    (while ptr
      (let ((auto-mode-alist (cons '("" . fundamental-mode) auto-mode-alist)))
        (find-file (car ptr)))
      (goto-char (point-min))
      (flush-lines "CHECKPOINT;")
      (save-buffer)
      (kill-buffer nil)
      (setq ptr (cdr ptr)))))

;;; (d-flush-checkpoints (directory-files "~/cbrow-test/" t "cc\\|hh$"))
;;; (d-flush-checkpoints (directory-files "~/zallegro/2004/Tritus-II/" t "cc\\|hh$"))

(provide 'd-flush-checkpoints)
;;; d-flush-checkpoints.el ends here
