/**
 * GNU LibreJS - A browser add-on to block nonfree nontrivial JavaScript.
 * *
 * Copyright (C) 2011, 2012 Loic J. Duros
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see  <http://www.gnu.org/licenses/>.
 *
 */

var tabs = require("tabs");
var pageMod = require("page-mod");



// use the two buckets.
var removedScripts = require("script_entries/removed_scripts").removedScripts;
var acceptedScripts = require("script_entries/accepted_scripts").acceptedScripts;



var jsLoadObserver = require("js_load_observer/js_load_observer");

var reset = function (url) {
    acceptedScripts.clearScripts(url);
};

exports.testjsLoadObserverHttpObserverBypassed = function (test) {
    test.waitUntilDone();
    var url = 'http://lduros.net/assets/librejs/tests/load_observer/load_test.html',
        mod;
    
    reset(url);
    
    mod = pageMod.PageMod({

	//include: "data:*",
	include: "*",

	contentScriptWhen: 'ready',

	contentScript: 'self.postMessage(unsafeWindow.num);',
	
	onAttach: function (worker) {
	    worker.on('message', function (value) {
		test.assertEqual(value, null);
		test.done();
		mod.destroy();
	    });
	}
    });
    
    //tabs.open("data:text/html;charset=utf-8,<!doctype html>%0D%0A<html>%0D%0A<head><script>var num %3D 5%3B<%2Fscript><%2Fhead>%0D%0A%0D%0A<body><h1 id='test'>Test<%2Fh1><%2Fbody><%2Fhtml>");
    tabs.open("http://lduros.net/assets/librejs/tests/load_observer/load_test.html");
};

exports.testjsLoadObserverHttpObserverBypassed2 = function (test) {
    test.waitUntilDone();
    var url = 'lduros.net/assets/librejs/tests/load_observer/wrong_mimetype/',
        mod;
    reset(url);
    
    mod = pageMod.PageMod({

	//include: "data:*",
	include: "*",

	contentScriptWhen: 'ready',

	contentScript: 'self.postMessage(unsafeWindow.jsString);',
	
	onAttach: function (worker) {
	    worker.on('message', function (value) {
		test.assertEqual(value, null);
		test.done();
		mod.destroy();
	    });
	}
    });
    
    tabs.open(url);    
};

exports.testjsLoadObserverAccepted = function (test) {
    test.waitUntilDone();
    var url = 'http://lduros.net/assets/librejs/tests/load_observer/load_test.html',
        mod;

    reset(url);
    
    acceptedScripts.addAScript(url, {'inline': true,
				     'contents': 'var num = 5;'});

    test.assertEqual(acceptedScripts.scripts[url][acceptedScripts.scripts[url].length - 1].hash, '49ca8516cacaa673a4793aaf53f9ae8c7ed2d170');
		     
    mod = pageMod.PageMod({

	//include: "data:*",
	include: "*",

	contentScriptWhen: 'ready',

	contentScript: 'self.postMessage(unsafeWindow.num);',
	
	onAttach: function (worker) {
	    worker.on('message', function (value) {
		test.assertEqual(value, 5);
		test.done();
		mod.destroy();
	    });
	}
    });
    
    //tabs.open("data:text/html;charset=utf-8,<!doctype html>%0D%0A<html>%0D%0A<head><script>var num %3D 5%3B<%2Fscript><%2Fhead>%0D%0A%0D%0A<body><h1 id='test'>Test<%2Fh1><%2Fbody><%2Fhtml>");
    tabs.open("http://lduros.net/assets/librejs/tests/load_observer/load_test.html");
};

exports.testjsLoadObserverAcceptedExternalWrongMimeType = function (test) {
    test.waitUntilDone();
    var url = 'lduros.net/assets/librejs/tests/load_observer/wrong_mimetype/',
        mod;
    reset(url);
    acceptedScripts.addAScript(url, {'inline': true,
				     'contents': "var jsString = \"JavaScript is loaded on this page.\";\nalert('this is JavaScript with an HTML content-type response header!!');"});

    test.assertEqual(acceptedScripts.scripts[url][acceptedScripts.scripts[url].length - 1].hash, '56e9636015385c0883d606ffc360eb510c1ac3a7');

    mod = pageMod.PageMod({

	//include: "data:*",
	include: "*",

	contentScriptWhen: 'ready',

	contentScript: 'self.postMessage(unsafeWindow.jsString);',
	
	onAttach: function (worker) {
	    worker.on('message', function (value) {
		test.assertEqual(value, null);
		test.done();
		mod.destroy();
	    });
	}
    });
    
    tabs.open(url);    
};
