/*  Motti -- a strategy game
    Copyright (C) 1999-2014 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "StdAfx.h"
#include "Case.h"
#include <sstream>
#include "JSONParser.h"

Case::Case(void):isCityCenter_(false),casetype_(NOTUSED),player_(NULL),previousplayer_(NULL),colored_(false)
{
	if (player_!=NULL)
		playerName_=player_->getName();
	else
		playerName_="";
}

Case::Case(bool isCityCenter,Player *player,CASETYPE casetype):isCityCenter_(isCityCenter),casetype_(casetype),player_(player),previousplayer_(player),colored_(false)
{
	
	if (player!=NULL)
	{
		playerName_=player->getName();
	}
	else
		playerName_="";
	if (player!=NULL)
		previousplayername_=player->getName();
	else
		previousplayername_="";
}


Case::~Case(void)
{
}

Case::CASETYPE Case::getType(){
	return casetype_;
}

bool Case::isCityCenter()
{
	return isCityCenter_;

}

void Case::setCityCenter(bool isCityCenter){
		isCityCenter_=isCityCenter;

	}

void Case::setCaseType(CASETYPE casetype){
	casetype_=casetype;
}

std::string Case::toString(){
	std::string ret="[";
	if (isCityCenter_)
	{
		ret+="ISCITYCENTER";
	}
	else
	{
		ret+="NOTCITYCENTER";
	}
	ret+="|";
	switch (casetype_)
	{
		case SELECTED:
			ret+="SELECTED";
			break;
		case LOCKED:
			ret+="LOCKED";
			break;

		case FREE:
			ret+="FREE";
			break;

		default:
		case NOTUSED:
			ret+="NOTUSED";
			break;

	}
	ret+="|";
	
	if (player_!=NULL)
	{
		ret+=player_->getName();
	}
	else
	{
		ret+="WITHOUTPLAYER";
	}
	 ret+="]";

	 return ret;
}

void Case::setPlayer( Player *player){

	player_=player;
	if (player!=NULL)
		playerName_=player->getName();
	else
		playerName_="";
	if (previousplayer_==NULL) {
		previousplayer_=player;
		previousplayername_=playerName_;
	}
	

}
Player * Case::getPlayer(){
	return player_;
}

void Case::setPreviousPlayer( Player *player){
	if (player!=NULL)
		previousplayername_=player->getName();
	else
		previousplayername_="";
	
	previousplayer_=player;
}
Player * Case::getPreviousPlayer(){
	return previousplayer_;
}

bool Case::isColored(){return colored_;}
void Case::setColored(bool col){colored_=col;}

std::istream& operator>> (std::istream& in, Case& per){
	int version=0;
	in >> version;
	if (version==1)
	{
		in >> per.isCityCenter_;
		int casel=0;
		in >> casel;
		per.casetype_=(Case::CASETYPE)casel;
		in >> per.playerName_;
		in >> per.previousplayername_;
		in >> per.colored_;
	
	}
	return in;
}

std::ostream& operator<< (std::ostream& in, Case& per){
	
	in << 1;
	in << per.isCityCenter_;
	in << per.casetype_;
	
	in << per.playerName_;
	in << per.previousplayername_;
	in << per.colored_;
	return in;
}

std::string Case::generateJson(){
  std::stringstream in;
  in << "{";
  in <<"\"version\":"<< 1<<",";
	in <<"\"isCityCenter\":"<< isCityCenter_<<",";
	in <<"\"caseType\":";
	switch (casetype_)
	{
		case SELECTED:
			in <<"\"SELECTED\"";
			break;
		case LOCKED:
			in <<"\"LOCKED\"";
			break;

		case FREE:
			in <<"\"FREE\"";
			break;

		default:
		case NOTUSED:
			in <<"\"NOTUSED\"";
			break;

	}
	in <<",";
	
	in <<"\"playerName\":\""<< playerName_<<"\",";
	in <<"\"previousPlayerName\":\""<< previousplayername_<<"\",";
	in <<"\"colored\":"<< colored_;
	in << "}";
	return in.str();
}


Serializer& operator>> (Serializer& in, Case& per){
	int version=0;
	in >> version;
	if (version==1)
	{
		
		in >> per.isCityCenter_;
		int casel=0;
		in >> casel;
		per.casetype_=(Case::CASETYPE)casel;
		
		in >> per.playerName_;
		in >> per.previousplayername_;


		in >> per.colored_;
	
	}
	return in;
}

Serializer& operator<< (Serializer& in, Case& per){
	in << 1;
	in << per.isCityCenter_;
	in << (int)per.casetype_;
	
	in << per.playerName_;
	in << per.previousplayername_;
	in << per.colored_;
	return in;
}

Case Case::createFromNode(json_parser::Object* my_object,std::map<std::string,Player*> playerMap ){
  
  try{
  //{"version":1,"isCityCenter":0,"caseType":"NOTUSED","playerName":"","previousPlayerName":"","colored":0}  

    if (my_object==NULL)
      return Case();
    json_parser::Value *version=getValue(my_object,"version");
    json_parser::Value *isCityCenter=getValue(my_object,"isCityCenter");
    json_parser::Value *caseType=getValue(my_object,"caseType");
    json_parser::Value *playerName=getValue(my_object,"playerName");
    json_parser::Value *previousPlayerName=getValue(my_object,"previousPlayerName");
    json_parser::Value *colored=getValue(my_object,"colored");
    
    bool bisCityCenter=false;
    if (isCityCenter->cleanStr()=="1")
      bisCityCenter=true;
    
    CASETYPE type=Case::NOTUSED;
    
    if (caseType->cleanStr()=="SELECTED")
      type=Case::SELECTED;
    
    if (caseType->cleanStr()=="LOCKED")
      type=Case::LOCKED;
    
    if (caseType->cleanStr()=="FREE")
      type=Case::FREE;
    		
    Player *playee=NULL;
    
    if(!playerName->cleanStr().empty())
      playee=playerMap.find(playerName->cleanStr())->second;
    Case cases (bisCityCenter,playee,type);
    if(!previousPlayerName->cleanStr().empty())
      cases.setPreviousPlayer(playerMap.find(previousPlayerName->cleanStr())->second);
    if (colored->cleanStr()=="1")
      cases.setColored(true);
    else
      cases.setColored(false);

    return cases;
  } catch (json_parser::ParseError e) {
    std::cerr << "Oops, the json you gave me does not contain JSON data:" << std::endl;
    std::cerr << e.what() << std::endl;
  }
}