#!/usr/local/bin/perl

# log ananlysis for CAPA
#  Copyright (C) 1992-2000 Michigan State University
#
#  The CAPA system is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of the
#  License, or (at your option) any later version.
#
#  The CAPA system is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with the CAPA system; see the file COPYING.  If not,
#  write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#  Boston, MA 02111-1307, USA.
#
#  As a special exception, you have permission to link this program
#  with the TtH/TtM library and distribute executables, as long as you
#  follow the requirements of the GNU GPL in regard to all of the
#  software in the executable aside from TtH/TtM.

 require('getopts.pl');
 
 
 
 sub  S_Enterpath {
    local($set)=@_;
    local($notdone,$path);
    
    $notdone = 1;
    while ($notdone) {
      print "Please enter the CLASS absolute path:\n";
      $path = <>; chomp($path);
      if( $path =~ /\/$/ ) {
        $Rfullpath = "$path" . "records";
        $Lfullpath = "$path" . "records/log$set.db";
        $Wfullpath = "$path" . "records/weblog$set.db";
      } else {
        $Rfullpath = "$path" . "/records";
        $Lfullpath = "$path" . "/records/log$set.db";
        $Wfullpath = "$path" . "/records/weblog$set.db";
      }
      if( -d $path ) {
        if( -d $Rfullpath ) {
          if( -f $Lfullpath ) {
            $notdone = 0;
          } else {
            print "File [$Lfullpath] does not exist!\n";
          }
          if( -f $Wfullpath ) {
            $notdone = 0;
          } else {
            print "File [$Wfullpath] does not exist!\n";
          }
        } else {
          print "Directory [$Rfullpath] does not exist!\n";
        }
      } else {
        print "Directory [$path] does not exist!\n";
      }
    
    }
    return ($path);
  }
  
  sub S_ScanDB  {
    local($filename)=@_;
    local($line_cnt)=0;
    local($s_num,$dow,$mon,$sp,$day,$time,$yr,$ans_str);
    local(@ans_char);
    local($ii,$first);
    local($Yes_cnt,$No_cnt);
    
    open(IN, "<$filename") || die "Cannot open $filename file!";
    $Yes_cnt = 0; $No_cnt = 0;
    while (<IN>) {
      $line_cnt++;
      chomp();
      ($first,$ans_str) = split(/1997 /);
       # print "$ans_str\n";
      (@ans_char) = split(/ */,$ans_str);
       
       for($ii=0;$ii<=$#ans_char;$ii++) {
       
         $Yes_cnt++ if $ans_char[$ii] eq 'Y';
         
         $No_cnt++  if $ans_char[$ii] eq 'N';
       }
     }
     close(IN) || die "Cannot close $filename file!";
     print  "$filename contains $line_cnt lines.\n";
     print  "  Yes = $Yes_cnt, No = $No_cnt\n";
     return ($Yes_cnt,$No_cnt);
  }
  
  
  
  if(! &Getopts('s:') ) {
     print STDERR "$Usage\n";
     exit 2;
  }
  $opt_s = 1  if ! $opt_s;
  S_Enterpath($opt_s);
  
  ($Y_cntL,$N_cntL) = S_ScanDB("$Lfullpath");
  ($Y_cntW,$N_cntW) = S_ScanDB("$Wfullpath");
  $Yratio = 0.0; $Nratio = 0.0;
  $Yratio = $Y_cntW / $Y_cntL;
  $Nratio = $N_cntL / $N_cntW;
  
  printf " Y ratio = %5.2f, N ratio = %5.2f\n", $Yratio , $Nratio;
  
  
  
  
  
