/*
 This file is part of GNU Taler
 (C) 2020 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 * Imports.
 */
import { AmountString, j2s } from "@gnu-taler/taler-util";
import { WalletApiOperation } from "@gnu-taler/taler-wallet-core";
import { GlobalTestState } from "../harness/harness.js";
import { createSimpleTestkudosEnvironmentV2 } from "../harness/helpers.js";

/**
 * Run test for forced denom/coin selection.
 */
export async function runForcedSelectionTest(t: GlobalTestState) {
  // Set up test environment

  const { walletClient, bank, exchange, merchant } =
    await createSimpleTestkudosEnvironmentV2(t);

  await walletClient.call(WalletApiOperation.AddExchange, {
    exchangeBaseUrl: exchange.baseUrl,
  });

  await walletClient.call(WalletApiOperation.WithdrawTestBalance, {
    exchangeBaseUrl: exchange.baseUrl,
    amount: "TESTKUDOS:10" as AmountString,
    corebankApiBaseUrl: bank.corebankApiBaseUrl,
    forcedDenomSel: {
      denoms: [
        {
          value: "TESTKUDOS:2" as AmountString,
          count: 3,
        },
      ],
    },
  });

  await walletClient.call(WalletApiOperation.TestingWaitTransactionsFinal, {});

  const coinDump = await walletClient.call(WalletApiOperation.DumpCoins, {});
  console.log(coinDump);
  t.assertDeepEqual(coinDump.coins.length, 3);

  const payResp = await walletClient.call(WalletApiOperation.TestPay, {
    amount: "TESTKUDOS:3" as AmountString,
    merchantBaseUrl: merchant.makeInstanceBaseUrl(),
    summary: "bla",
    forcedCoinSel: {
      coins: [
        {
          value: "TESTKUDOS:2" as AmountString,
          contribution: "TESTKUDOS:1" as AmountString,
        },
        {
          value: "TESTKUDOS:2" as AmountString,
          contribution: "TESTKUDOS:1" as AmountString,
        },
        {
          value: "TESTKUDOS:2" as AmountString,
          contribution: "TESTKUDOS:1" as AmountString,
        },
      ],
    },
  });

  console.log(j2s(payResp));

  // Without forced selection, we would only use 2 coins.
  t.assertDeepEqual(payResp.numCoins, 3);
}

runForcedSelectionTest.suites = ["wallet"];
