/* xmlHandler.c generated by valac 0.56.18, the Vala compiler
 * generated from xmlHandler.vala, do not modify */

/* Copyright 2018 Siddhartha Das (bablu.boy@gmail.com)
*
* This file is part of Bookworm and handles all xml related parsing
*
* Bookworm is free software: you can redistribute it
* and/or modify it under the terms of the GNU General Public License as
* published by the Free Software Foundation, either version 3 of the
* License, or (at your option) any later version.
*
* Bookworm is distributed in the hope that it will be
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
* Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with Bookworm. If not, see http://www.gnu.org/licenses/.
*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>
#include <libxml/parser.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BOOKWORM_APP_TYPE_XML_DATA (bookworm_app_xml_data_get_type ())
#define BOOKWORM_APP_XML_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_XML_DATA, BookwormAppXMLData))
#define BOOKWORM_APP_XML_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_XML_DATA, BookwormAppXMLDataClass))
#define BOOKWORM_APP_IS_XML_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_XML_DATA))
#define BOOKWORM_APP_IS_XML_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_XML_DATA))
#define BOOKWORM_APP_XML_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_XML_DATA, BookwormAppXMLDataClass))

typedef struct _BookwormAppXMLData BookwormAppXMLData;
typedef struct _BookwormAppXMLDataClass BookwormAppXMLDataClass;
typedef struct _BookwormAppXMLDataPrivate BookwormAppXMLDataPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _BookwormAppParamSpecXMLData BookwormAppParamSpecXMLData;

#define BOOKWORM_APP_TYPE_XML_PARSER (bookworm_app_xml_parser_get_type ())
#define BOOKWORM_APP_XML_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_XML_PARSER, BookwormAppXmlParser))
#define BOOKWORM_APP_XML_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_XML_PARSER, BookwormAppXmlParserClass))
#define BOOKWORM_APP_IS_XML_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_XML_PARSER))
#define BOOKWORM_APP_IS_XML_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_XML_PARSER))
#define BOOKWORM_APP_XML_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_XML_PARSER, BookwormAppXmlParserClass))

typedef struct _BookwormAppXmlParser BookwormAppXmlParser;
typedef struct _BookwormAppXmlParserClass BookwormAppXmlParserClass;
typedef struct _BookwormAppXmlParserPrivate BookwormAppXmlParserPrivate;
#define _bookworm_app_xml_data_unref0(var) ((var == NULL) ? NULL : (var = (bookworm_app_xml_data_unref (var), NULL)))
typedef struct _BookwormAppParamSpecXmlParser BookwormAppParamSpecXmlParser;

struct _BookwormAppXMLData {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BookwormAppXMLDataPrivate * priv;
	gboolean shouldExtractionStart;
	gboolean useLocalTagName;
	gboolean isContainerTagMatched;
	gchar* currentTagName;
	GString* charBuffer;
	gchar* containerTagName;
	gchar* inputTagName;
	gchar* inputAttributeName;
	gboolean isXMLExtraction;
	gboolean enforceAttributeData;
	GeeArrayList* extractedTagValues;
	GeeArrayList* extractedTagAttributes;
};

struct _BookwormAppXMLDataClass {
	GTypeClass parent_class;
	void (*finalize) (BookwormAppXMLData *self);
};

struct _BookwormAppParamSpecXMLData {
	GParamSpec parent_instance;
};

struct _BookwormAppXmlParser {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BookwormAppXmlParserPrivate * priv;
};

struct _BookwormAppXmlParserClass {
	GTypeClass parent_class;
	void (*finalize) (BookwormAppXmlParser *self);
};

struct _BookwormAppParamSpecXmlParser {
	GParamSpec parent_instance;
};

static gpointer bookworm_app_xml_data_parent_class = NULL;
static gpointer bookworm_app_xml_parser_parent_class = NULL;
static BookwormAppXMLData* bookworm_app_xml_parser_thisXMLData;
static BookwormAppXMLData* bookworm_app_xml_parser_thisXMLData = NULL;

VALA_EXTERN gpointer bookworm_app_xml_data_ref (gpointer instance);
VALA_EXTERN void bookworm_app_xml_data_unref (gpointer instance);
VALA_EXTERN GParamSpec* bookworm_app_param_spec_xml_data (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
VALA_EXTERN void bookworm_app_value_set_xml_data (GValue* value,
                                      gpointer v_object);
VALA_EXTERN void bookworm_app_value_take_xml_data (GValue* value,
                                       gpointer v_object);
VALA_EXTERN gpointer bookworm_app_value_get_xml_data (const GValue* value);
VALA_EXTERN GType bookworm_app_xml_data_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppXMLData, bookworm_app_xml_data_unref)
VALA_EXTERN BookwormAppXMLData* bookworm_app_xml_data_new (void);
VALA_EXTERN BookwormAppXMLData* bookworm_app_xml_data_construct (GType object_type);
static void bookworm_app_xml_data_finalize (BookwormAppXMLData * obj);
static GType bookworm_app_xml_data_get_type_once (void);
VALA_EXTERN gpointer bookworm_app_xml_parser_ref (gpointer instance);
VALA_EXTERN void bookworm_app_xml_parser_unref (gpointer instance);
VALA_EXTERN GParamSpec* bookworm_app_param_spec_xml_parser (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags);
VALA_EXTERN void bookworm_app_value_set_xml_parser (GValue* value,
                                        gpointer v_object);
VALA_EXTERN void bookworm_app_value_take_xml_parser (GValue* value,
                                         gpointer v_object);
VALA_EXTERN gpointer bookworm_app_value_get_xml_parser (const GValue* value);
VALA_EXTERN GType bookworm_app_xml_parser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppXmlParser, bookworm_app_xml_parser_unref)
VALA_EXTERN BookwormAppXmlParser* bookworm_app_xml_parser_new (void);
VALA_EXTERN BookwormAppXmlParser* bookworm_app_xml_parser_construct (GType object_type);
VALA_EXTERN GeeArrayList* bookworm_app_xml_parser_extractDataFromXML (BookwormAppXmlParser* self,
                                                          const gchar* path,
                                                          GeeArrayList* inputDataList,
                                                          gboolean isXMLExtraction);
VALA_EXTERN void bookworm_app_xml_parser_parseXML (BookwormAppXmlParser* self,
                                       const gchar* path);
VALA_EXTERN void bookworm_app_xml_parser_start_element (BookwormAppXmlParser* self,
                                            const gchar* name,
                                            gchar** attributeList,
                                            gint attributeList_length1);
static void _bookworm_app_xml_parser_start_element_start_element_sax_func (void* ctx,
                                                                    xmlChar* name,
                                                                    xmlChar** atts);
VALA_EXTERN void bookworm_app_xml_parser_get_text (BookwormAppXmlParser* self,
                                       const gchar* chars,
                                       gint len);
static void _bookworm_app_xml_parser_get_text_characters_sax_func (void* ctx,
                                                            xmlChar* ch,
                                                            gint len);
VALA_EXTERN void bookworm_app_xml_parser_end_element (BookwormAppXmlParser* self,
                                          const gchar* name);
static void _bookworm_app_xml_parser_end_element_end_element_sax_func (void* ctx,
                                                                xmlChar* name);
VALA_EXTERN gchar* bookworm_app_xml_parser_process_tagname (BookwormAppXmlParser* self,
                                                const gchar* tagname);
static void bookworm_app_xml_parser_finalize (BookwormAppXmlParser * obj);
static GType bookworm_app_xml_parser_get_type_once (void);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

BookwormAppXMLData*
bookworm_app_xml_data_construct (GType object_type)
{
	BookwormAppXMLData* self = NULL;
#line 22 "../src/xmlHandler.vala"
	self = (BookwormAppXMLData*) g_type_create_instance (object_type);
#line 22 "../src/xmlHandler.vala"
	return self;
#line 197 "xmlHandler.c"
}

BookwormAppXMLData*
bookworm_app_xml_data_new (void)
{
#line 22 "../src/xmlHandler.vala"
	return bookworm_app_xml_data_construct (BOOKWORM_APP_TYPE_XML_DATA);
#line 205 "xmlHandler.c"
}

static void
bookworm_app_value_xml_data_init (GValue* value)
{
#line 22 "../src/xmlHandler.vala"
	value->data[0].v_pointer = NULL;
#line 213 "xmlHandler.c"
}

static void
bookworm_app_value_xml_data_free_value (GValue* value)
{
#line 22 "../src/xmlHandler.vala"
	if (value->data[0].v_pointer) {
#line 22 "../src/xmlHandler.vala"
		bookworm_app_xml_data_unref (value->data[0].v_pointer);
#line 223 "xmlHandler.c"
	}
}

static void
bookworm_app_value_xml_data_copy_value (const GValue* src_value,
                                        GValue* dest_value)
{
#line 22 "../src/xmlHandler.vala"
	if (src_value->data[0].v_pointer) {
#line 22 "../src/xmlHandler.vala"
		dest_value->data[0].v_pointer = bookworm_app_xml_data_ref (src_value->data[0].v_pointer);
#line 235 "xmlHandler.c"
	} else {
#line 22 "../src/xmlHandler.vala"
		dest_value->data[0].v_pointer = NULL;
#line 239 "xmlHandler.c"
	}
}

static gpointer
bookworm_app_value_xml_data_peek_pointer (const GValue* value)
{
#line 22 "../src/xmlHandler.vala"
	return value->data[0].v_pointer;
#line 248 "xmlHandler.c"
}

static gchar*
bookworm_app_value_xml_data_collect_value (GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
#line 22 "../src/xmlHandler.vala"
	if (collect_values[0].v_pointer) {
#line 259 "xmlHandler.c"
		BookwormAppXMLData * object;
		object = collect_values[0].v_pointer;
#line 22 "../src/xmlHandler.vala"
		if (object->parent_instance.g_class == NULL) {
#line 22 "../src/xmlHandler.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 266 "xmlHandler.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 22 "../src/xmlHandler.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 270 "xmlHandler.c"
		}
#line 22 "../src/xmlHandler.vala"
		value->data[0].v_pointer = bookworm_app_xml_data_ref (object);
#line 274 "xmlHandler.c"
	} else {
#line 22 "../src/xmlHandler.vala"
		value->data[0].v_pointer = NULL;
#line 278 "xmlHandler.c"
	}
#line 22 "../src/xmlHandler.vala"
	return NULL;
#line 282 "xmlHandler.c"
}

static gchar*
bookworm_app_value_xml_data_lcopy_value (const GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	BookwormAppXMLData ** object_p;
	object_p = collect_values[0].v_pointer;
#line 22 "../src/xmlHandler.vala"
	if (!object_p) {
#line 22 "../src/xmlHandler.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 297 "xmlHandler.c"
	}
#line 22 "../src/xmlHandler.vala"
	if (!value->data[0].v_pointer) {
#line 22 "../src/xmlHandler.vala"
		*object_p = NULL;
#line 303 "xmlHandler.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 22 "../src/xmlHandler.vala"
		*object_p = value->data[0].v_pointer;
#line 307 "xmlHandler.c"
	} else {
#line 22 "../src/xmlHandler.vala"
		*object_p = bookworm_app_xml_data_ref (value->data[0].v_pointer);
#line 311 "xmlHandler.c"
	}
#line 22 "../src/xmlHandler.vala"
	return NULL;
#line 315 "xmlHandler.c"
}

GParamSpec*
bookworm_app_param_spec_xml_data (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags)
{
	BookwormAppParamSpecXMLData* spec;
#line 22 "../src/xmlHandler.vala"
	g_return_val_if_fail (g_type_is_a (object_type, BOOKWORM_APP_TYPE_XML_DATA), NULL);
#line 22 "../src/xmlHandler.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 22 "../src/xmlHandler.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 22 "../src/xmlHandler.vala"
	return G_PARAM_SPEC (spec);
#line 334 "xmlHandler.c"
}

gpointer
bookworm_app_value_get_xml_data (const GValue* value)
{
#line 22 "../src/xmlHandler.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOOKWORM_APP_TYPE_XML_DATA), NULL);
#line 22 "../src/xmlHandler.vala"
	return value->data[0].v_pointer;
#line 344 "xmlHandler.c"
}

void
bookworm_app_value_set_xml_data (GValue* value,
                                 gpointer v_object)
{
	BookwormAppXMLData * old;
#line 22 "../src/xmlHandler.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOOKWORM_APP_TYPE_XML_DATA));
#line 22 "../src/xmlHandler.vala"
	old = value->data[0].v_pointer;
#line 22 "../src/xmlHandler.vala"
	if (v_object) {
#line 22 "../src/xmlHandler.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOOKWORM_APP_TYPE_XML_DATA));
#line 22 "../src/xmlHandler.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "../src/xmlHandler.vala"
		value->data[0].v_pointer = v_object;
#line 22 "../src/xmlHandler.vala"
		bookworm_app_xml_data_ref (value->data[0].v_pointer);
#line 366 "xmlHandler.c"
	} else {
#line 22 "../src/xmlHandler.vala"
		value->data[0].v_pointer = NULL;
#line 370 "xmlHandler.c"
	}
#line 22 "../src/xmlHandler.vala"
	if (old) {
#line 22 "../src/xmlHandler.vala"
		bookworm_app_xml_data_unref (old);
#line 376 "xmlHandler.c"
	}
}

void
bookworm_app_value_take_xml_data (GValue* value,
                                  gpointer v_object)
{
	BookwormAppXMLData * old;
#line 22 "../src/xmlHandler.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOOKWORM_APP_TYPE_XML_DATA));
#line 22 "../src/xmlHandler.vala"
	old = value->data[0].v_pointer;
#line 22 "../src/xmlHandler.vala"
	if (v_object) {
#line 22 "../src/xmlHandler.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOOKWORM_APP_TYPE_XML_DATA));
#line 22 "../src/xmlHandler.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "../src/xmlHandler.vala"
		value->data[0].v_pointer = v_object;
#line 397 "xmlHandler.c"
	} else {
#line 22 "../src/xmlHandler.vala"
		value->data[0].v_pointer = NULL;
#line 401 "xmlHandler.c"
	}
#line 22 "../src/xmlHandler.vala"
	if (old) {
#line 22 "../src/xmlHandler.vala"
		bookworm_app_xml_data_unref (old);
#line 407 "xmlHandler.c"
	}
}

static void
bookworm_app_xml_data_class_init (BookwormAppXMLDataClass * klass,
                                  gpointer klass_data)
{
#line 22 "../src/xmlHandler.vala"
	bookworm_app_xml_data_parent_class = g_type_class_peek_parent (klass);
#line 22 "../src/xmlHandler.vala"
	((BookwormAppXMLDataClass *) klass)->finalize = bookworm_app_xml_data_finalize;
#line 419 "xmlHandler.c"
}

static void
bookworm_app_xml_data_instance_init (BookwormAppXMLData * self,
                                     gpointer klass)
{
	GString* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
#line 23 "../src/xmlHandler.vala"
	self->shouldExtractionStart = FALSE;
#line 24 "../src/xmlHandler.vala"
	self->useLocalTagName = TRUE;
#line 25 "../src/xmlHandler.vala"
	self->isContainerTagMatched = FALSE;
#line 27 "../src/xmlHandler.vala"
	_tmp0_ = g_string_new ("");
#line 27 "../src/xmlHandler.vala"
	self->charBuffer = _tmp0_;
#line 32 "../src/xmlHandler.vala"
	self->isXMLExtraction = FALSE;
#line 33 "../src/xmlHandler.vala"
	self->enforceAttributeData = FALSE;
#line 34 "../src/xmlHandler.vala"
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 34 "../src/xmlHandler.vala"
	self->extractedTagValues = _tmp1_;
#line 35 "../src/xmlHandler.vala"
	_tmp2_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 35 "../src/xmlHandler.vala"
	self->extractedTagAttributes = _tmp2_;
#line 22 "../src/xmlHandler.vala"
	self->ref_count = 1;
#line 453 "xmlHandler.c"
}

static void
bookworm_app_xml_data_finalize (BookwormAppXMLData * obj)
{
	BookwormAppXMLData * self;
#line 22 "../src/xmlHandler.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOOKWORM_APP_TYPE_XML_DATA, BookwormAppXMLData);
#line 22 "../src/xmlHandler.vala"
	g_signal_handlers_destroy (self);
#line 26 "../src/xmlHandler.vala"
	_g_free0 (self->currentTagName);
#line 27 "../src/xmlHandler.vala"
	_g_string_free0 (self->charBuffer);
#line 29 "../src/xmlHandler.vala"
	_g_free0 (self->containerTagName);
#line 30 "../src/xmlHandler.vala"
	_g_free0 (self->inputTagName);
#line 31 "../src/xmlHandler.vala"
	_g_free0 (self->inputAttributeName);
#line 34 "../src/xmlHandler.vala"
	_g_object_unref0 (self->extractedTagValues);
#line 35 "../src/xmlHandler.vala"
	_g_object_unref0 (self->extractedTagAttributes);
#line 478 "xmlHandler.c"
}

static GType
bookworm_app_xml_data_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { bookworm_app_value_xml_data_init, bookworm_app_value_xml_data_free_value, bookworm_app_value_xml_data_copy_value, bookworm_app_value_xml_data_peek_pointer, "p", bookworm_app_value_xml_data_collect_value, "p", bookworm_app_value_xml_data_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BookwormAppXMLDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bookworm_app_xml_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BookwormAppXMLData), 0, (GInstanceInitFunc) bookworm_app_xml_data_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType bookworm_app_xml_data_type_id;
	bookworm_app_xml_data_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BookwormAppXMLData", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return bookworm_app_xml_data_type_id;
}

GType
bookworm_app_xml_data_get_type (void)
{
	static volatile gsize bookworm_app_xml_data_type_id__once = 0;
	if (g_once_init_enter (&bookworm_app_xml_data_type_id__once)) {
		GType bookworm_app_xml_data_type_id;
		bookworm_app_xml_data_type_id = bookworm_app_xml_data_get_type_once ();
		g_once_init_leave (&bookworm_app_xml_data_type_id__once, bookworm_app_xml_data_type_id);
	}
	return bookworm_app_xml_data_type_id__once;
}

gpointer
bookworm_app_xml_data_ref (gpointer instance)
{
	BookwormAppXMLData * self;
	self = instance;
#line 22 "../src/xmlHandler.vala"
	g_atomic_int_inc (&self->ref_count);
#line 22 "../src/xmlHandler.vala"
	return instance;
#line 513 "xmlHandler.c"
}

void
bookworm_app_xml_data_unref (gpointer instance)
{
	BookwormAppXMLData * self;
	self = instance;
#line 22 "../src/xmlHandler.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 22 "../src/xmlHandler.vala"
		BOOKWORM_APP_XML_DATA_GET_CLASS (self)->finalize (self);
#line 22 "../src/xmlHandler.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 527 "xmlHandler.c"
	}
}

BookwormAppXmlParser*
bookworm_app_xml_parser_construct (GType object_type)
{
	BookwormAppXmlParser* self = NULL;
#line 41 "../src/xmlHandler.vala"
	self = (BookwormAppXmlParser*) g_type_create_instance (object_type);
#line 42 "../src/xmlHandler.vala"
	_bookworm_app_xml_data_unref0 (bookworm_app_xml_parser_thisXMLData);
#line 42 "../src/xmlHandler.vala"
	bookworm_app_xml_parser_thisXMLData = NULL;
#line 41 "../src/xmlHandler.vala"
	return self;
#line 543 "xmlHandler.c"
}

BookwormAppXmlParser*
bookworm_app_xml_parser_new (void)
{
#line 41 "../src/xmlHandler.vala"
	return bookworm_app_xml_parser_construct (BOOKWORM_APP_TYPE_XML_PARSER);
#line 551 "xmlHandler.c"
}

static gpointer
_bookworm_app_xml_data_ref0 (gpointer self)
{
#line 138 "../src/xmlHandler.vala"
	return self ? bookworm_app_xml_data_ref (self) : NULL;
#line 559 "xmlHandler.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 144 "../src/xmlHandler.vala"
	return self ? g_object_ref (self) : NULL;
#line 567 "xmlHandler.c"
}

GeeArrayList*
bookworm_app_xml_parser_extractDataFromXML (BookwormAppXmlParser* self,
                                            const gchar* path,
                                            GeeArrayList* inputDataList,
                                            gboolean isXMLExtraction)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint count = 0;
	gchar* _tmp35_;
	gchar* _tmp36_;
	GeeArrayList* _tmp37_;
	GeeArrayList* result;
#line 128 "../src/xmlHandler.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 128 "../src/xmlHandler.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 128 "../src/xmlHandler.vala"
	g_return_val_if_fail (inputDataList != NULL, NULL);
#line 133 "../src/xmlHandler.vala"
	_tmp0_ = g_strconcat ("[START] [FUNCTION:extractDataFromXML] extracting xml from file=", path, NULL);
#line 133 "../src/xmlHandler.vala"
	_tmp1_ = _tmp0_;
#line 133 "../src/xmlHandler.vala"
	g_info ("xmlHandler.vala:133: %s", _tmp1_);
#line 133 "../src/xmlHandler.vala"
	_g_free0 (_tmp1_);
#line 134 "../src/xmlHandler.vala"
	count = 0;
#line 599 "xmlHandler.c"
	{
		GeeArrayList* _aXMLData_list = NULL;
		gint _aXMLData_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _aXMLData_index = 0;
#line 135 "../src/xmlHandler.vala"
		_aXMLData_list = inputDataList;
#line 135 "../src/xmlHandler.vala"
		_tmp2_ = _aXMLData_list;
#line 135 "../src/xmlHandler.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
#line 135 "../src/xmlHandler.vala"
		_tmp4_ = _tmp3_;
#line 135 "../src/xmlHandler.vala"
		_aXMLData_size = _tmp4_;
#line 135 "../src/xmlHandler.vala"
		_aXMLData_index = -1;
#line 135 "../src/xmlHandler.vala"
		while (TRUE) {
#line 621 "xmlHandler.c"
			gint _tmp5_;
			gint _tmp6_;
			BookwormAppXMLData* aXMLData = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			BookwormAppXMLData* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			BookwormAppXMLData* _tmp21_;
			const gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			BookwormAppXMLData* _tmp27_;
			const gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			BookwormAppXMLData* _tmp31_;
			BookwormAppXMLData* _tmp32_;
			BookwormAppXMLData* _tmp33_;
			gint _tmp34_;
#line 135 "../src/xmlHandler.vala"
			_aXMLData_index = _aXMLData_index + 1;
#line 135 "../src/xmlHandler.vala"
			_tmp5_ = _aXMLData_index;
#line 135 "../src/xmlHandler.vala"
			_tmp6_ = _aXMLData_size;
#line 135 "../src/xmlHandler.vala"
			if (!(_tmp5_ < _tmp6_)) {
#line 135 "../src/xmlHandler.vala"
				break;
#line 663 "xmlHandler.c"
			}
#line 135 "../src/xmlHandler.vala"
			_tmp7_ = _aXMLData_list;
#line 135 "../src/xmlHandler.vala"
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _aXMLData_index);
#line 135 "../src/xmlHandler.vala"
			aXMLData = (BookwormAppXMLData*) _tmp8_;
#line 136 "../src/xmlHandler.vala"
			_tmp9_ = g_strdup_printf ("%i", count);
#line 136 "../src/xmlHandler.vala"
			_tmp10_ = _tmp9_;
#line 136 "../src/xmlHandler.vala"
			_tmp11_ = g_strconcat ("Reading XML to extract data for input set #", _tmp10_, NULL);
#line 136 "../src/xmlHandler.vala"
			_tmp12_ = _tmp11_;
#line 136 "../src/xmlHandler.vala"
			_tmp13_ = g_strconcat (_tmp12_, ":", NULL);
#line 136 "../src/xmlHandler.vala"
			_tmp14_ = _tmp13_;
#line 136 "../src/xmlHandler.vala"
			_tmp15_ = aXMLData;
#line 136 "../src/xmlHandler.vala"
			_tmp16_ = _tmp15_->containerTagName;
#line 136 "../src/xmlHandler.vala"
			_tmp17_ = g_strconcat (_tmp14_, _tmp16_, NULL);
#line 136 "../src/xmlHandler.vala"
			_tmp18_ = _tmp17_;
#line 136 "../src/xmlHandler.vala"
			_tmp19_ = g_strconcat (_tmp18_, "/", NULL);
#line 136 "../src/xmlHandler.vala"
			_tmp20_ = _tmp19_;
#line 136 "../src/xmlHandler.vala"
			_tmp21_ = aXMLData;
#line 136 "../src/xmlHandler.vala"
			_tmp22_ = _tmp21_->inputTagName;
#line 136 "../src/xmlHandler.vala"
			_tmp23_ = g_strconcat (_tmp20_, _tmp22_, NULL);
#line 136 "../src/xmlHandler.vala"
			_tmp24_ = _tmp23_;
#line 136 "../src/xmlHandler.vala"
			_tmp25_ = g_strconcat (_tmp24_, "/", NULL);
#line 136 "../src/xmlHandler.vala"
			_tmp26_ = _tmp25_;
#line 136 "../src/xmlHandler.vala"
			_tmp27_ = aXMLData;
#line 136 "../src/xmlHandler.vala"
			_tmp28_ = _tmp27_->inputAttributeName;
#line 136 "../src/xmlHandler.vala"
			_tmp29_ = g_strconcat (_tmp26_, _tmp28_, NULL);
#line 136 "../src/xmlHandler.vala"
			_tmp30_ = _tmp29_;
#line 136 "../src/xmlHandler.vala"
			g_debug ("xmlHandler.vala:136: %s", _tmp30_);
#line 136 "../src/xmlHandler.vala"
			_g_free0 (_tmp30_);
#line 136 "../src/xmlHandler.vala"
			_g_free0 (_tmp26_);
#line 136 "../src/xmlHandler.vala"
			_g_free0 (_tmp24_);
#line 136 "../src/xmlHandler.vala"
			_g_free0 (_tmp20_);
#line 136 "../src/xmlHandler.vala"
			_g_free0 (_tmp18_);
#line 136 "../src/xmlHandler.vala"
			_g_free0 (_tmp14_);
#line 136 "../src/xmlHandler.vala"
			_g_free0 (_tmp12_);
#line 136 "../src/xmlHandler.vala"
			_g_free0 (_tmp10_);
#line 138 "../src/xmlHandler.vala"
			_tmp31_ = aXMLData;
#line 138 "../src/xmlHandler.vala"
			_tmp32_ = _bookworm_app_xml_data_ref0 (_tmp31_);
#line 138 "../src/xmlHandler.vala"
			_bookworm_app_xml_data_unref0 (bookworm_app_xml_parser_thisXMLData);
#line 138 "../src/xmlHandler.vala"
			bookworm_app_xml_parser_thisXMLData = _tmp32_;
#line 139 "../src/xmlHandler.vala"
			bookworm_app_xml_parser_parseXML (self, path);
#line 140 "../src/xmlHandler.vala"
			_tmp33_ = bookworm_app_xml_parser_thisXMLData;
#line 140 "../src/xmlHandler.vala"
			gee_abstract_list_set ((GeeAbstractList*) inputDataList, count, _tmp33_);
#line 141 "../src/xmlHandler.vala"
			_tmp34_ = count;
#line 141 "../src/xmlHandler.vala"
			count = _tmp34_ + 1;
#line 135 "../src/xmlHandler.vala"
			_bookworm_app_xml_data_unref0 (aXMLData);
#line 753 "xmlHandler.c"
		}
	}
#line 143 "../src/xmlHandler.vala"
	_tmp35_ = g_strconcat ("[END] [FUNCTION:extractDataFromXML] extracting xml from file=", path, NULL);
#line 143 "../src/xmlHandler.vala"
	_tmp36_ = _tmp35_;
#line 143 "../src/xmlHandler.vala"
	g_info ("xmlHandler.vala:143: %s", _tmp36_);
#line 143 "../src/xmlHandler.vala"
	_g_free0 (_tmp36_);
#line 144 "../src/xmlHandler.vala"
	_tmp37_ = _g_object_ref0 (inputDataList);
#line 144 "../src/xmlHandler.vala"
	result = _tmp37_;
#line 144 "../src/xmlHandler.vala"
	_g_object_unref0 (inputDataList);
#line 144 "../src/xmlHandler.vala"
	return result;
#line 772 "xmlHandler.c"
}

static void
_bookworm_app_xml_parser_start_element_start_element_sax_func (void* ctx,
                                                               xmlChar* name,
                                                               xmlChar** atts)
{
#line 152 "../src/xmlHandler.vala"
	bookworm_app_xml_parser_start_element (ctx, name, atts, _vala_array_length (atts));
#line 782 "xmlHandler.c"
}

static void
_bookworm_app_xml_parser_get_text_characters_sax_func (void* ctx,
                                                       xmlChar* ch,
                                                       gint len)
{
#line 153 "../src/xmlHandler.vala"
	bookworm_app_xml_parser_get_text (ctx, ch, len);
#line 792 "xmlHandler.c"
}

static void
_bookworm_app_xml_parser_end_element_end_element_sax_func (void* ctx,
                                                           xmlChar* name)
{
#line 154 "../src/xmlHandler.vala"
	bookworm_app_xml_parser_end_element (ctx, name);
#line 801 "xmlHandler.c"
}

void
bookworm_app_xml_parser_parseXML (BookwormAppXmlParser* self,
                                  const gchar* path)
{
	xmlSAXHandler handler = {0};
	void* user_data = NULL;
#line 147 "../src/xmlHandler.vala"
	g_return_if_fail (self != NULL);
#line 147 "../src/xmlHandler.vala"
	g_return_if_fail (path != NULL);
#line 148 "../src/xmlHandler.vala"
	xmlInitParser ();
#line 149 "../src/xmlHandler.vala"
	memset (&handler, 0, sizeof (xmlSAXHandler));
#line 150 "../src/xmlHandler.vala"
	user_data = NULL;
#line 152 "../src/xmlHandler.vala"
	handler.startElement = _bookworm_app_xml_parser_start_element_start_element_sax_func;
#line 153 "../src/xmlHandler.vala"
	handler.characters = _bookworm_app_xml_parser_get_text_characters_sax_func;
#line 154 "../src/xmlHandler.vala"
	handler.endElement = _bookworm_app_xml_parser_end_element_end_element_sax_func;
#line 156 "../src/xmlHandler.vala"
	xmlSAXUserParseFile (&handler, user_data, path);
#line 157 "../src/xmlHandler.vala"
	xmlCleanupParser ();
#line 830 "xmlHandler.c"
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 1413 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1414 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1414 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1415 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1416 "glib-2.0.vapi"
	result = _result_;
#line 1416 "glib-2.0.vapi"
	return result;
#line 851 "xmlHandler.c"
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
#line 1251 "glib-2.0.vapi"
	if (separator == NULL) {
#line 1252 "glib-2.0.vapi"
		separator = "";
#line 865 "xmlHandler.c"
	}
#line 1254 "glib-2.0.vapi"
	if (str_array != NULL) {
#line 869 "xmlHandler.c"
		gboolean _tmp1_ = FALSE;
#line 1254 "glib-2.0.vapi"
		if (str_array_length1 > 0) {
#line 1254 "glib-2.0.vapi"
			_tmp1_ = TRUE;
#line 875 "xmlHandler.c"
		} else {
			gboolean _tmp2_ = FALSE;
#line 1254 "glib-2.0.vapi"
			if (str_array_length1 == -1) {
#line 880 "xmlHandler.c"
				const gchar* _tmp3_;
#line 1254 "glib-2.0.vapi"
				_tmp3_ = str_array[0];
#line 1254 "glib-2.0.vapi"
				_tmp2_ = _tmp3_ != NULL;
#line 886 "xmlHandler.c"
			} else {
#line 1254 "glib-2.0.vapi"
				_tmp2_ = FALSE;
#line 890 "xmlHandler.c"
			}
#line 1254 "glib-2.0.vapi"
			_tmp1_ = _tmp2_;
#line 894 "xmlHandler.c"
		}
#line 1254 "glib-2.0.vapi"
		_tmp0_ = _tmp1_;
#line 898 "xmlHandler.c"
	} else {
#line 1254 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 902 "xmlHandler.c"
	}
#line 1254 "glib-2.0.vapi"
	if (_tmp0_) {
#line 906 "xmlHandler.c"
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
#line 1256 "glib-2.0.vapi"
		len = (gsize) 1;
#line 921 "xmlHandler.c"
		{
			gboolean _tmp4_ = FALSE;
#line 1257 "glib-2.0.vapi"
			i = 0;
#line 1257 "glib-2.0.vapi"
			_tmp4_ = TRUE;
#line 1257 "glib-2.0.vapi"
			while (TRUE) {
#line 930 "xmlHandler.c"
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
#line 1257 "glib-2.0.vapi"
				if (!_tmp4_) {
#line 937 "xmlHandler.c"
					gint _tmp5_;
#line 1257 "glib-2.0.vapi"
					_tmp5_ = i;
#line 1257 "glib-2.0.vapi"
					i = _tmp5_ + 1;
#line 943 "xmlHandler.c"
				}
#line 1257 "glib-2.0.vapi"
				_tmp4_ = FALSE;
#line 1257 "glib-2.0.vapi"
				if (str_array_length1 != -1) {
#line 1257 "glib-2.0.vapi"
					_tmp7_ = i < str_array_length1;
#line 951 "xmlHandler.c"
				} else {
#line 1257 "glib-2.0.vapi"
					_tmp7_ = FALSE;
#line 955 "xmlHandler.c"
				}
#line 1257 "glib-2.0.vapi"
				if (_tmp7_) {
#line 1257 "glib-2.0.vapi"
					_tmp6_ = TRUE;
#line 961 "xmlHandler.c"
				} else {
					gboolean _tmp8_ = FALSE;
#line 1257 "glib-2.0.vapi"
					if (str_array_length1 == -1) {
#line 966 "xmlHandler.c"
						const gchar* _tmp9_;
#line 1257 "glib-2.0.vapi"
						_tmp9_ = str_array[i];
#line 1257 "glib-2.0.vapi"
						_tmp8_ = _tmp9_ != NULL;
#line 972 "xmlHandler.c"
					} else {
#line 1257 "glib-2.0.vapi"
						_tmp8_ = FALSE;
#line 976 "xmlHandler.c"
					}
#line 1257 "glib-2.0.vapi"
					_tmp6_ = _tmp8_;
#line 980 "xmlHandler.c"
				}
#line 1257 "glib-2.0.vapi"
				if (!_tmp6_) {
#line 1257 "glib-2.0.vapi"
					break;
#line 986 "xmlHandler.c"
				}
#line 1258 "glib-2.0.vapi"
				_tmp11_ = str_array[i];
#line 1258 "glib-2.0.vapi"
				if (_tmp11_ != NULL) {
#line 992 "xmlHandler.c"
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
#line 1258 "glib-2.0.vapi"
					_tmp12_ = str_array[i];
#line 1258 "glib-2.0.vapi"
					_tmp13_ = strlen ((const gchar*) _tmp12_);
#line 1258 "glib-2.0.vapi"
					_tmp14_ = _tmp13_;
#line 1258 "glib-2.0.vapi"
					_tmp10_ = _tmp14_;
#line 1004 "xmlHandler.c"
				} else {
#line 1258 "glib-2.0.vapi"
					_tmp10_ = 0;
#line 1008 "xmlHandler.c"
				}
#line 1258 "glib-2.0.vapi"
				len += (gsize) _tmp10_;
#line 1012 "xmlHandler.c"
			}
		}
#line 1260 "glib-2.0.vapi"
		if (i == 0) {
#line 1017 "xmlHandler.c"
			gchar* _tmp15_;
#line 1261 "glib-2.0.vapi"
			_tmp15_ = g_strdup ("");
#line 1261 "glib-2.0.vapi"
			result = _tmp15_;
#line 1261 "glib-2.0.vapi"
			return result;
#line 1025 "xmlHandler.c"
		}
#line 1263 "glib-2.0.vapi"
		str_array_length1 = i;
#line 1264 "glib-2.0.vapi"
		_tmp16_ = strlen ((const gchar*) separator);
#line 1264 "glib-2.0.vapi"
		_tmp17_ = _tmp16_;
#line 1264 "glib-2.0.vapi"
		len += (gsize) (_tmp17_ * (i - 1));
#line 1266 "glib-2.0.vapi"
		_tmp18_ = g_malloc (len);
#line 1266 "glib-2.0.vapi"
		res = _tmp18_;
#line 1267 "glib-2.0.vapi"
		_tmp20_ = str_array[0];
#line 1267 "glib-2.0.vapi"
		if (_tmp20_ != NULL) {
#line 1043 "xmlHandler.c"
			const gchar* _tmp21_;
#line 1267 "glib-2.0.vapi"
			_tmp21_ = str_array[0];
#line 1267 "glib-2.0.vapi"
			_tmp19_ = (const gchar*) _tmp21_;
#line 1049 "xmlHandler.c"
		} else {
#line 1267 "glib-2.0.vapi"
			_tmp19_ = "";
#line 1053 "xmlHandler.c"
		}
#line 1267 "glib-2.0.vapi"
		_tmp22_ = res;
#line 1267 "glib-2.0.vapi"
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
#line 1267 "glib-2.0.vapi"
		ptr = _tmp23_;
#line 1061 "xmlHandler.c"
		{
			gboolean _tmp24_ = FALSE;
#line 1268 "glib-2.0.vapi"
			i = 1;
#line 1268 "glib-2.0.vapi"
			_tmp24_ = TRUE;
#line 1268 "glib-2.0.vapi"
			while (TRUE) {
#line 1070 "xmlHandler.c"
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
#line 1268 "glib-2.0.vapi"
				if (!_tmp24_) {
#line 1079 "xmlHandler.c"
					gint _tmp25_;
#line 1268 "glib-2.0.vapi"
					_tmp25_ = i;
#line 1268 "glib-2.0.vapi"
					i = _tmp25_ + 1;
#line 1085 "xmlHandler.c"
				}
#line 1268 "glib-2.0.vapi"
				_tmp24_ = FALSE;
#line 1268 "glib-2.0.vapi"
				if (!(i < str_array_length1)) {
#line 1268 "glib-2.0.vapi"
					break;
#line 1093 "xmlHandler.c"
				}
#line 1269 "glib-2.0.vapi"
				_tmp26_ = ptr;
#line 1269 "glib-2.0.vapi"
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
#line 1269 "glib-2.0.vapi"
				ptr = _tmp27_;
#line 1270 "glib-2.0.vapi"
				_tmp29_ = str_array[i];
#line 1270 "glib-2.0.vapi"
				if (_tmp29_ != NULL) {
#line 1105 "xmlHandler.c"
					const gchar* _tmp30_;
#line 1270 "glib-2.0.vapi"
					_tmp30_ = str_array[i];
#line 1270 "glib-2.0.vapi"
					_tmp28_ = (const gchar*) _tmp30_;
#line 1111 "xmlHandler.c"
				} else {
#line 1270 "glib-2.0.vapi"
					_tmp28_ = "";
#line 1115 "xmlHandler.c"
				}
#line 1270 "glib-2.0.vapi"
				_tmp31_ = ptr;
#line 1270 "glib-2.0.vapi"
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
#line 1270 "glib-2.0.vapi"
				ptr = _tmp32_;
#line 1123 "xmlHandler.c"
			}
		}
#line 1273 "glib-2.0.vapi"
		_tmp33_ = res;
#line 1273 "glib-2.0.vapi"
		res = NULL;
#line 1273 "glib-2.0.vapi"
		result = (gchar*) _tmp33_;
#line 1273 "glib-2.0.vapi"
		return result;
#line 1134 "xmlHandler.c"
	} else {
		gchar* _tmp34_;
#line 1275 "glib-2.0.vapi"
		_tmp34_ = g_strdup ("");
#line 1275 "glib-2.0.vapi"
		result = _tmp34_;
#line 1275 "glib-2.0.vapi"
		return result;
#line 1143 "xmlHandler.c"
	}
}

void
bookworm_app_xml_parser_start_element (BookwormAppXmlParser* self,
                                       const gchar* name,
                                       gchar** attributeList,
                                       gint attributeList_length1)
{
	BookwormAppXMLData* _tmp0_;
	gchar* _tmp1_;
	BookwormAppXMLData* _tmp2_;
	const gchar* _tmp3_;
	BookwormAppXMLData* _tmp4_;
	const gchar* _tmp5_;
	BookwormAppXMLData* _tmp7_;
	const gchar* _tmp8_;
	BookwormAppXMLData* _tmp9_;
	const gchar* _tmp10_;
	gboolean _tmp30_ = FALSE;
	BookwormAppXMLData* _tmp31_;
	gboolean _tmp47_ = FALSE;
	BookwormAppXMLData* _tmp48_;
#line 160 "../src/xmlHandler.vala"
	g_return_if_fail (self != NULL);
#line 160 "../src/xmlHandler.vala"
	g_return_if_fail (name != NULL);
#line 162 "../src/xmlHandler.vala"
	_tmp0_ = bookworm_app_xml_parser_thisXMLData;
#line 162 "../src/xmlHandler.vala"
	_tmp1_ = bookworm_app_xml_parser_process_tagname (self, name);
#line 162 "../src/xmlHandler.vala"
	_g_free0 (_tmp0_->currentTagName);
#line 162 "../src/xmlHandler.vala"
	_tmp0_->currentTagName = _tmp1_;
#line 164 "../src/xmlHandler.vala"
	_tmp2_ = bookworm_app_xml_parser_thisXMLData;
#line 164 "../src/xmlHandler.vala"
	_tmp3_ = _tmp2_->currentTagName;
#line 164 "../src/xmlHandler.vala"
	_tmp4_ = bookworm_app_xml_parser_thisXMLData;
#line 164 "../src/xmlHandler.vala"
	_tmp5_ = _tmp4_->containerTagName;
#line 164 "../src/xmlHandler.vala"
	if (g_strcmp0 (_tmp3_, _tmp5_) == 0) {
#line 1189 "xmlHandler.c"
		BookwormAppXMLData* _tmp6_;
#line 165 "../src/xmlHandler.vala"
		_tmp6_ = bookworm_app_xml_parser_thisXMLData;
#line 165 "../src/xmlHandler.vala"
		_tmp6_->isContainerTagMatched = TRUE;
#line 1195 "xmlHandler.c"
	}
#line 169 "../src/xmlHandler.vala"
	_tmp7_ = bookworm_app_xml_parser_thisXMLData;
#line 169 "../src/xmlHandler.vala"
	_tmp8_ = _tmp7_->currentTagName;
#line 169 "../src/xmlHandler.vala"
	_tmp9_ = bookworm_app_xml_parser_thisXMLData;
#line 169 "../src/xmlHandler.vala"
	_tmp10_ = _tmp9_->inputTagName;
#line 169 "../src/xmlHandler.vala"
	if (g_strcmp0 (_tmp8_, _tmp10_) == 0) {
#line 1207 "xmlHandler.c"
		gboolean _tmp11_ = FALSE;
		BookwormAppXMLData* _tmp12_;
		const gchar* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
#line 171 "../src/xmlHandler.vala"
		_tmp12_ = bookworm_app_xml_parser_thisXMLData;
#line 171 "../src/xmlHandler.vala"
		_tmp13_ = _tmp12_->containerTagName;
#line 171 "../src/xmlHandler.vala"
		_tmp14_ = strlen (_tmp13_);
#line 171 "../src/xmlHandler.vala"
		_tmp15_ = _tmp14_;
#line 171 "../src/xmlHandler.vala"
		if (_tmp15_ != 0) {
#line 1223 "xmlHandler.c"
			BookwormAppXMLData* _tmp16_;
#line 171 "../src/xmlHandler.vala"
			_tmp16_ = bookworm_app_xml_parser_thisXMLData;
#line 171 "../src/xmlHandler.vala"
			_tmp11_ = _tmp16_->isContainerTagMatched;
#line 1229 "xmlHandler.c"
		} else {
#line 171 "../src/xmlHandler.vala"
			_tmp11_ = FALSE;
#line 1233 "xmlHandler.c"
		}
#line 171 "../src/xmlHandler.vala"
		if (_tmp11_) {
#line 1237 "xmlHandler.c"
			BookwormAppXMLData* _tmp17_;
			BookwormAppXMLData* _tmp18_;
			GString* _tmp19_;
#line 172 "../src/xmlHandler.vala"
			_tmp17_ = bookworm_app_xml_parser_thisXMLData;
#line 172 "../src/xmlHandler.vala"
			_tmp17_->shouldExtractionStart = TRUE;
#line 173 "../src/xmlHandler.vala"
			_tmp18_ = bookworm_app_xml_parser_thisXMLData;
#line 173 "../src/xmlHandler.vala"
			_tmp19_ = _tmp18_->charBuffer;
#line 173 "../src/xmlHandler.vala"
			g_string_assign (_tmp19_, "");
#line 1251 "xmlHandler.c"
		} else {
			BookwormAppXMLData* _tmp20_;
			const gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			gboolean _tmp26_;
#line 176 "../src/xmlHandler.vala"
			_tmp20_ = bookworm_app_xml_parser_thisXMLData;
#line 176 "../src/xmlHandler.vala"
			_tmp21_ = _tmp20_->containerTagName;
#line 176 "../src/xmlHandler.vala"
			_tmp22_ = string_strip (_tmp21_);
#line 176 "../src/xmlHandler.vala"
			_tmp23_ = _tmp22_;
#line 176 "../src/xmlHandler.vala"
			_tmp24_ = strlen (_tmp23_);
#line 176 "../src/xmlHandler.vala"
			_tmp25_ = _tmp24_;
#line 176 "../src/xmlHandler.vala"
			_tmp26_ = _tmp25_ == 0;
#line 176 "../src/xmlHandler.vala"
			_g_free0 (_tmp23_);
#line 176 "../src/xmlHandler.vala"
			if (_tmp26_) {
#line 1278 "xmlHandler.c"
				BookwormAppXMLData* _tmp27_;
				BookwormAppXMLData* _tmp28_;
				GString* _tmp29_;
#line 177 "../src/xmlHandler.vala"
				_tmp27_ = bookworm_app_xml_parser_thisXMLData;
#line 177 "../src/xmlHandler.vala"
				_tmp27_->shouldExtractionStart = TRUE;
#line 178 "../src/xmlHandler.vala"
				_tmp28_ = bookworm_app_xml_parser_thisXMLData;
#line 178 "../src/xmlHandler.vala"
				_tmp29_ = _tmp28_->charBuffer;
#line 178 "../src/xmlHandler.vala"
				g_string_assign (_tmp29_, "");
#line 1292 "xmlHandler.c"
			}
		}
	}
#line 184 "../src/xmlHandler.vala"
	_tmp31_ = bookworm_app_xml_parser_thisXMLData;
#line 184 "../src/xmlHandler.vala"
	if (_tmp31_->shouldExtractionStart) {
#line 1300 "xmlHandler.c"
		BookwormAppXMLData* _tmp32_;
		const gchar* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
#line 184 "../src/xmlHandler.vala"
		_tmp32_ = bookworm_app_xml_parser_thisXMLData;
#line 184 "../src/xmlHandler.vala"
		_tmp33_ = _tmp32_->inputAttributeName;
#line 184 "../src/xmlHandler.vala"
		_tmp34_ = strlen (_tmp33_);
#line 184 "../src/xmlHandler.vala"
		_tmp35_ = _tmp34_;
#line 184 "../src/xmlHandler.vala"
		_tmp30_ = _tmp35_ > 0;
#line 1315 "xmlHandler.c"
	} else {
#line 184 "../src/xmlHandler.vala"
		_tmp30_ = FALSE;
#line 1319 "xmlHandler.c"
	}
#line 184 "../src/xmlHandler.vala"
	if (_tmp30_) {
#line 1323 "xmlHandler.c"
		gint count = 0;
		gboolean wasAttributeExtracted = FALSE;
		gboolean _tmp43_ = FALSE;
#line 186 "../src/xmlHandler.vala"
		count = 0;
#line 187 "../src/xmlHandler.vala"
		wasAttributeExtracted = FALSE;
#line 1331 "xmlHandler.c"
		{
			gchar** attribute_collection = NULL;
			gint attribute_collection_length1 = 0;
			gint _attribute_collection_size_ = 0;
			gint attribute_it = 0;
#line 188 "../src/xmlHandler.vala"
			attribute_collection = attributeList;
#line 188 "../src/xmlHandler.vala"
			attribute_collection_length1 = attributeList_length1;
#line 188 "../src/xmlHandler.vala"
			for (attribute_it = 0; attribute_it < attribute_collection_length1; attribute_it = attribute_it + 1) {
#line 1343 "xmlHandler.c"
				gchar* _tmp36_;
				gchar* attribute = NULL;
#line 188 "../src/xmlHandler.vala"
				_tmp36_ = g_strdup (attribute_collection[attribute_it]);
#line 188 "../src/xmlHandler.vala"
				attribute = _tmp36_;
#line 1350 "xmlHandler.c"
				{
#line 189 "../src/xmlHandler.vala"
					if (attributeList_length1 >= (count + 1)) {
#line 1354 "xmlHandler.c"
						BookwormAppXMLData* _tmp37_;
						const gchar* _tmp38_;
						const gchar* _tmp39_;
#line 190 "../src/xmlHandler.vala"
						_tmp37_ = bookworm_app_xml_parser_thisXMLData;
#line 190 "../src/xmlHandler.vala"
						_tmp38_ = _tmp37_->inputAttributeName;
#line 190 "../src/xmlHandler.vala"
						_tmp39_ = attributeList[count];
#line 190 "../src/xmlHandler.vala"
						if (g_strcmp0 (_tmp38_, _tmp39_) == 0) {
#line 1366 "xmlHandler.c"
							BookwormAppXMLData* _tmp40_;
							GeeArrayList* _tmp41_;
							const gchar* _tmp42_;
#line 192 "../src/xmlHandler.vala"
							_tmp40_ = bookworm_app_xml_parser_thisXMLData;
#line 192 "../src/xmlHandler.vala"
							_tmp41_ = _tmp40_->extractedTagAttributes;
#line 192 "../src/xmlHandler.vala"
							_tmp42_ = attributeList[count + 1];
#line 192 "../src/xmlHandler.vala"
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp41_, _tmp42_);
#line 193 "../src/xmlHandler.vala"
							wasAttributeExtracted = TRUE;
#line 194 "../src/xmlHandler.vala"
							_g_free0 (attribute);
#line 194 "../src/xmlHandler.vala"
							break;
#line 1384 "xmlHandler.c"
						}
#line 196 "../src/xmlHandler.vala"
						count = count + 2;
#line 1388 "xmlHandler.c"
					}
#line 188 "../src/xmlHandler.vala"
					_g_free0 (attribute);
#line 1392 "xmlHandler.c"
				}
			}
		}
#line 200 "../src/xmlHandler.vala"
		if (!wasAttributeExtracted) {
#line 1398 "xmlHandler.c"
			BookwormAppXMLData* _tmp44_;
#line 200 "../src/xmlHandler.vala"
			_tmp44_ = bookworm_app_xml_parser_thisXMLData;
#line 200 "../src/xmlHandler.vala"
			_tmp43_ = _tmp44_->enforceAttributeData;
#line 1404 "xmlHandler.c"
		} else {
#line 200 "../src/xmlHandler.vala"
			_tmp43_ = FALSE;
#line 1408 "xmlHandler.c"
		}
#line 200 "../src/xmlHandler.vala"
		if (_tmp43_) {
#line 1412 "xmlHandler.c"
			BookwormAppXMLData* _tmp45_;
			GeeArrayList* _tmp46_;
#line 201 "../src/xmlHandler.vala"
			_tmp45_ = bookworm_app_xml_parser_thisXMLData;
#line 201 "../src/xmlHandler.vala"
			_tmp46_ = _tmp45_->extractedTagAttributes;
#line 201 "../src/xmlHandler.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp46_, "");
#line 1421 "xmlHandler.c"
		}
	}
#line 205 "../src/xmlHandler.vala"
	_tmp48_ = bookworm_app_xml_parser_thisXMLData;
#line 205 "../src/xmlHandler.vala"
	if (_tmp48_->shouldExtractionStart) {
#line 1428 "xmlHandler.c"
		BookwormAppXMLData* _tmp49_;
#line 205 "../src/xmlHandler.vala"
		_tmp49_ = bookworm_app_xml_parser_thisXMLData;
#line 205 "../src/xmlHandler.vala"
		_tmp47_ = _tmp49_->isXMLExtraction;
#line 1434 "xmlHandler.c"
	} else {
#line 205 "../src/xmlHandler.vala"
		_tmp47_ = FALSE;
#line 1438 "xmlHandler.c"
	}
#line 205 "../src/xmlHandler.vala"
	if (_tmp47_) {
#line 1442 "xmlHandler.c"
		BookwormAppXMLData* _tmp50_;
		GString* _tmp51_;
		GString* _tmp52_;
		GString* _tmp53_;
		GString* _tmp54_;
		gchar* _tmp55_;
		gchar* _tmp56_;
		GString* _tmp57_;
#line 207 "../src/xmlHandler.vala"
		_tmp50_ = bookworm_app_xml_parser_thisXMLData;
#line 207 "../src/xmlHandler.vala"
		_tmp51_ = _tmp50_->charBuffer;
#line 207 "../src/xmlHandler.vala"
		_tmp52_ = g_string_append (_tmp51_, " <");
#line 207 "../src/xmlHandler.vala"
		_tmp53_ = g_string_append (_tmp52_, name);
#line 207 "../src/xmlHandler.vala"
		_tmp54_ = g_string_append (_tmp53_, " ");
#line 207 "../src/xmlHandler.vala"
		_tmp55_ = _vala_g_strjoinv (" ", attributeList, (gint) attributeList_length1);
#line 207 "../src/xmlHandler.vala"
		_tmp56_ = _tmp55_;
#line 207 "../src/xmlHandler.vala"
		_tmp57_ = g_string_append (_tmp54_, _tmp56_);
#line 207 "../src/xmlHandler.vala"
		g_string_append (_tmp57_, ">");
#line 207 "../src/xmlHandler.vala"
		_g_free0 (_tmp56_);
#line 1471 "xmlHandler.c"
	}
}

void
bookworm_app_xml_parser_end_element (BookwormAppXmlParser* self,
                                     const gchar* name)
{
	gchar* processed_name = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	BookwormAppXMLData* _tmp2_;
	const gchar* _tmp8_;
	BookwormAppXMLData* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp13_;
	BookwormAppXMLData* _tmp14_;
	const gchar* _tmp15_;
#line 215 "../src/xmlHandler.vala"
	g_return_if_fail (self != NULL);
#line 215 "../src/xmlHandler.vala"
	g_return_if_fail (name != NULL);
#line 217 "../src/xmlHandler.vala"
	_tmp0_ = bookworm_app_xml_parser_process_tagname (self, name);
#line 217 "../src/xmlHandler.vala"
	processed_name = _tmp0_;
#line 220 "../src/xmlHandler.vala"
	_tmp2_ = bookworm_app_xml_parser_thisXMLData;
#line 220 "../src/xmlHandler.vala"
	if (_tmp2_->shouldExtractionStart) {
#line 1501 "xmlHandler.c"
		BookwormAppXMLData* _tmp3_;
#line 220 "../src/xmlHandler.vala"
		_tmp3_ = bookworm_app_xml_parser_thisXMLData;
#line 220 "../src/xmlHandler.vala"
		_tmp1_ = _tmp3_->isXMLExtraction;
#line 1507 "xmlHandler.c"
	} else {
#line 220 "../src/xmlHandler.vala"
		_tmp1_ = FALSE;
#line 1511 "xmlHandler.c"
	}
#line 220 "../src/xmlHandler.vala"
	if (_tmp1_) {
#line 1515 "xmlHandler.c"
		BookwormAppXMLData* _tmp4_;
		GString* _tmp5_;
		GString* _tmp6_;
		GString* _tmp7_;
#line 222 "../src/xmlHandler.vala"
		_tmp4_ = bookworm_app_xml_parser_thisXMLData;
#line 222 "../src/xmlHandler.vala"
		_tmp5_ = _tmp4_->charBuffer;
#line 222 "../src/xmlHandler.vala"
		_tmp6_ = g_string_append (_tmp5_, " </");
#line 222 "../src/xmlHandler.vala"
		_tmp7_ = g_string_append (_tmp6_, name);
#line 222 "../src/xmlHandler.vala"
		g_string_append (_tmp7_, ">");
#line 1530 "xmlHandler.c"
	}
#line 226 "../src/xmlHandler.vala"
	_tmp8_ = processed_name;
#line 226 "../src/xmlHandler.vala"
	_tmp9_ = bookworm_app_xml_parser_thisXMLData;
#line 226 "../src/xmlHandler.vala"
	_tmp10_ = _tmp9_->containerTagName;
#line 226 "../src/xmlHandler.vala"
	if (g_strcmp0 (_tmp8_, _tmp10_) == 0) {
#line 1540 "xmlHandler.c"
		BookwormAppXMLData* _tmp11_;
		BookwormAppXMLData* _tmp12_;
#line 227 "../src/xmlHandler.vala"
		_tmp11_ = bookworm_app_xml_parser_thisXMLData;
#line 227 "../src/xmlHandler.vala"
		_tmp11_->isContainerTagMatched = FALSE;
#line 228 "../src/xmlHandler.vala"
		_tmp12_ = bookworm_app_xml_parser_thisXMLData;
#line 228 "../src/xmlHandler.vala"
		_tmp12_->shouldExtractionStart = FALSE;
#line 1551 "xmlHandler.c"
	}
#line 232 "../src/xmlHandler.vala"
	_tmp13_ = processed_name;
#line 232 "../src/xmlHandler.vala"
	_tmp14_ = bookworm_app_xml_parser_thisXMLData;
#line 232 "../src/xmlHandler.vala"
	_tmp15_ = _tmp14_->inputTagName;
#line 232 "../src/xmlHandler.vala"
	if (g_strcmp0 (_tmp13_, _tmp15_) == 0) {
#line 1561 "xmlHandler.c"
		BookwormAppXMLData* _tmp16_;
		BookwormAppXMLData* _tmp32_;
		BookwormAppXMLData* _tmp33_;
		gchar* _tmp34_;
#line 234 "../src/xmlHandler.vala"
		_tmp16_ = bookworm_app_xml_parser_thisXMLData;
#line 234 "../src/xmlHandler.vala"
		if (_tmp16_->shouldExtractionStart) {
#line 1570 "xmlHandler.c"
			BookwormAppXMLData* _tmp17_;
#line 235 "../src/xmlHandler.vala"
			_tmp17_ = bookworm_app_xml_parser_thisXMLData;
#line 235 "../src/xmlHandler.vala"
			if (!_tmp17_->isXMLExtraction) {
#line 1576 "xmlHandler.c"
				BookwormAppXMLData* _tmp18_;
				const gchar* _tmp19_;
				BookwormAppXMLData* _tmp20_;
				const gchar* _tmp21_;
#line 237 "../src/xmlHandler.vala"
				_tmp18_ = bookworm_app_xml_parser_thisXMLData;
#line 237 "../src/xmlHandler.vala"
				_tmp19_ = _tmp18_->currentTagName;
#line 237 "../src/xmlHandler.vala"
				_tmp20_ = bookworm_app_xml_parser_thisXMLData;
#line 237 "../src/xmlHandler.vala"
				_tmp21_ = _tmp20_->inputTagName;
#line 237 "../src/xmlHandler.vala"
				if (g_strcmp0 (_tmp19_, _tmp21_) == 0) {
#line 1591 "xmlHandler.c"
					BookwormAppXMLData* _tmp22_;
					GeeArrayList* _tmp23_;
					BookwormAppXMLData* _tmp24_;
					GString* _tmp25_;
					const gchar* _tmp26_;
#line 238 "../src/xmlHandler.vala"
					_tmp22_ = bookworm_app_xml_parser_thisXMLData;
#line 238 "../src/xmlHandler.vala"
					_tmp23_ = _tmp22_->extractedTagValues;
#line 238 "../src/xmlHandler.vala"
					_tmp24_ = bookworm_app_xml_parser_thisXMLData;
#line 238 "../src/xmlHandler.vala"
					_tmp25_ = _tmp24_->charBuffer;
#line 238 "../src/xmlHandler.vala"
					_tmp26_ = _tmp25_->str;
#line 238 "../src/xmlHandler.vala"
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp23_, _tmp26_);
#line 1609 "xmlHandler.c"
				}
			} else {
				BookwormAppXMLData* _tmp27_;
				GeeArrayList* _tmp28_;
				BookwormAppXMLData* _tmp29_;
				GString* _tmp30_;
				const gchar* _tmp31_;
#line 242 "../src/xmlHandler.vala"
				_tmp27_ = bookworm_app_xml_parser_thisXMLData;
#line 242 "../src/xmlHandler.vala"
				_tmp28_ = _tmp27_->extractedTagValues;
#line 242 "../src/xmlHandler.vala"
				_tmp29_ = bookworm_app_xml_parser_thisXMLData;
#line 242 "../src/xmlHandler.vala"
				_tmp30_ = _tmp29_->charBuffer;
#line 242 "../src/xmlHandler.vala"
				_tmp31_ = _tmp30_->str;
#line 242 "../src/xmlHandler.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp28_, _tmp31_);
#line 1629 "xmlHandler.c"
			}
		}
#line 245 "../src/xmlHandler.vala"
		_tmp32_ = bookworm_app_xml_parser_thisXMLData;
#line 245 "../src/xmlHandler.vala"
		_tmp32_->shouldExtractionStart = FALSE;
#line 246 "../src/xmlHandler.vala"
		_tmp33_ = bookworm_app_xml_parser_thisXMLData;
#line 246 "../src/xmlHandler.vala"
		_tmp34_ = g_strdup ("");
#line 246 "../src/xmlHandler.vala"
		_g_free0 (_tmp33_->currentTagName);
#line 246 "../src/xmlHandler.vala"
		_tmp33_->currentTagName = _tmp34_;
#line 1644 "xmlHandler.c"
	}
#line 215 "../src/xmlHandler.vala"
	_g_free0 (processed_name);
#line 1648 "xmlHandler.c"
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1535 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1535 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1535 "glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1536 "glib-2.0.vapi"
	if (start < ((glong) 0)) {
#line 1537 "glib-2.0.vapi"
		start = string_length + start;
#line 1675 "xmlHandler.c"
	}
#line 1539 "glib-2.0.vapi"
	if (end < ((glong) 0)) {
#line 1540 "glib-2.0.vapi"
		end = string_length + end;
#line 1681 "xmlHandler.c"
	}
#line 1542 "glib-2.0.vapi"
	if (start >= ((glong) 0)) {
#line 1542 "glib-2.0.vapi"
		_tmp2_ = start <= string_length;
#line 1687 "xmlHandler.c"
	} else {
#line 1542 "glib-2.0.vapi"
		_tmp2_ = FALSE;
#line 1691 "xmlHandler.c"
	}
#line 1542 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp2_, NULL);
#line 1543 "glib-2.0.vapi"
	if (end >= ((glong) 0)) {
#line 1543 "glib-2.0.vapi"
		_tmp3_ = end <= string_length;
#line 1699 "xmlHandler.c"
	} else {
#line 1543 "glib-2.0.vapi"
		_tmp3_ = FALSE;
#line 1703 "xmlHandler.c"
	}
#line 1543 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp3_, NULL);
#line 1544 "glib-2.0.vapi"
	g_return_val_if_fail (start <= end, NULL);
#line 1545 "glib-2.0.vapi"
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
#line 1545 "glib-2.0.vapi"
	result = _tmp4_;
#line 1545 "glib-2.0.vapi"
	return result;
#line 1715 "xmlHandler.c"
}

void
bookworm_app_xml_parser_get_text (BookwormAppXmlParser* self,
                                  const gchar* chars,
                                  gint len)
{
	BookwormAppXMLData* _tmp0_;
#line 250 "../src/xmlHandler.vala"
	g_return_if_fail (self != NULL);
#line 250 "../src/xmlHandler.vala"
	g_return_if_fail (chars != NULL);
#line 253 "../src/xmlHandler.vala"
	_tmp0_ = bookworm_app_xml_parser_thisXMLData;
#line 253 "../src/xmlHandler.vala"
	if (_tmp0_->shouldExtractionStart) {
#line 1732 "xmlHandler.c"
		BookwormAppXMLData* _tmp1_;
#line 254 "../src/xmlHandler.vala"
		_tmp1_ = bookworm_app_xml_parser_thisXMLData;
#line 254 "../src/xmlHandler.vala"
		if (!_tmp1_->isXMLExtraction) {
#line 1738 "xmlHandler.c"
			BookwormAppXMLData* _tmp2_;
			const gchar* _tmp3_;
			BookwormAppXMLData* _tmp4_;
			const gchar* _tmp5_;
#line 256 "../src/xmlHandler.vala"
			_tmp2_ = bookworm_app_xml_parser_thisXMLData;
#line 256 "../src/xmlHandler.vala"
			_tmp3_ = _tmp2_->currentTagName;
#line 256 "../src/xmlHandler.vala"
			_tmp4_ = bookworm_app_xml_parser_thisXMLData;
#line 256 "../src/xmlHandler.vala"
			_tmp5_ = _tmp4_->inputTagName;
#line 256 "../src/xmlHandler.vala"
			if (g_strcmp0 (_tmp3_, _tmp5_) == 0) {
#line 1753 "xmlHandler.c"
				BookwormAppXMLData* _tmp6_;
				GString* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
#line 257 "../src/xmlHandler.vala"
				_tmp6_ = bookworm_app_xml_parser_thisXMLData;
#line 257 "../src/xmlHandler.vala"
				_tmp7_ = _tmp6_->charBuffer;
#line 257 "../src/xmlHandler.vala"
				_tmp8_ = string_slice (chars, (glong) 0, (glong) len);
#line 257 "../src/xmlHandler.vala"
				_tmp9_ = _tmp8_;
#line 257 "../src/xmlHandler.vala"
				g_string_append (_tmp7_, _tmp9_);
#line 257 "../src/xmlHandler.vala"
				_g_free0 (_tmp9_);
#line 1770 "xmlHandler.c"
			}
		} else {
			BookwormAppXMLData* _tmp10_;
			GString* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
#line 261 "../src/xmlHandler.vala"
			_tmp10_ = bookworm_app_xml_parser_thisXMLData;
#line 261 "../src/xmlHandler.vala"
			_tmp11_ = _tmp10_->charBuffer;
#line 261 "../src/xmlHandler.vala"
			_tmp12_ = string_slice (chars, (glong) 0, (glong) len);
#line 261 "../src/xmlHandler.vala"
			_tmp13_ = _tmp12_;
#line 261 "../src/xmlHandler.vala"
			g_string_append (_tmp11_, _tmp13_);
#line 261 "../src/xmlHandler.vala"
			_g_free0 (_tmp13_);
#line 1789 "xmlHandler.c"
		}
	}
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
#line 1184 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1184 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 1185 "glib-2.0.vapi"
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
#line 1185 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1187 "glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1187 "glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 1815 "xmlHandler.c"
		gchar* _tmp2_;
#line 1188 "glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1188 "glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1188 "glib-2.0.vapi"
		return result;
#line 1823 "xmlHandler.c"
	} else {
#line 1190 "glib-2.0.vapi"
		result = -1;
#line 1190 "glib-2.0.vapi"
		return result;
#line 1829 "xmlHandler.c"
	}
}

gchar*
bookworm_app_xml_parser_process_tagname (BookwormAppXmlParser* self,
                                         const gchar* tagname)
{
	gchar* local_tagname = NULL;
	gchar* _tmp0_;
	BookwormAppXMLData* _tmp1_;
	gchar* result;
#line 266 "../src/xmlHandler.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 266 "../src/xmlHandler.vala"
	g_return_val_if_fail (tagname != NULL, NULL);
#line 267 "../src/xmlHandler.vala"
	_tmp0_ = string_strip (tagname);
#line 267 "../src/xmlHandler.vala"
	local_tagname = _tmp0_;
#line 268 "../src/xmlHandler.vala"
	_tmp1_ = bookworm_app_xml_parser_thisXMLData;
#line 268 "../src/xmlHandler.vala"
	if (_tmp1_->useLocalTagName) {
#line 1853 "xmlHandler.c"
		const gchar* _tmp2_;
#line 269 "../src/xmlHandler.vala"
		_tmp2_ = local_tagname;
#line 269 "../src/xmlHandler.vala"
		if (string_index_of (_tmp2_, ":", 0) != -1) {
#line 1859 "xmlHandler.c"
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gchar* _tmp8_;
#line 270 "../src/xmlHandler.vala"
			_tmp3_ = local_tagname;
#line 270 "../src/xmlHandler.vala"
			_tmp4_ = local_tagname;
#line 270 "../src/xmlHandler.vala"
			_tmp5_ = local_tagname;
#line 270 "../src/xmlHandler.vala"
			_tmp6_ = strlen (_tmp5_);
#line 270 "../src/xmlHandler.vala"
			_tmp7_ = _tmp6_;
#line 270 "../src/xmlHandler.vala"
			_tmp8_ = string_slice (_tmp3_, (glong) (string_index_of (_tmp4_, ":", 0) + 1), (glong) _tmp7_);
#line 270 "../src/xmlHandler.vala"
			_g_free0 (local_tagname);
#line 270 "../src/xmlHandler.vala"
			local_tagname = _tmp8_;
#line 1882 "xmlHandler.c"
		}
	}
#line 273 "../src/xmlHandler.vala"
	result = local_tagname;
#line 273 "../src/xmlHandler.vala"
	return result;
#line 1889 "xmlHandler.c"
}

static void
bookworm_app_value_xml_parser_init (GValue* value)
{
#line 38 "../src/xmlHandler.vala"
	value->data[0].v_pointer = NULL;
#line 1897 "xmlHandler.c"
}

static void
bookworm_app_value_xml_parser_free_value (GValue* value)
{
#line 38 "../src/xmlHandler.vala"
	if (value->data[0].v_pointer) {
#line 38 "../src/xmlHandler.vala"
		bookworm_app_xml_parser_unref (value->data[0].v_pointer);
#line 1907 "xmlHandler.c"
	}
}

static void
bookworm_app_value_xml_parser_copy_value (const GValue* src_value,
                                          GValue* dest_value)
{
#line 38 "../src/xmlHandler.vala"
	if (src_value->data[0].v_pointer) {
#line 38 "../src/xmlHandler.vala"
		dest_value->data[0].v_pointer = bookworm_app_xml_parser_ref (src_value->data[0].v_pointer);
#line 1919 "xmlHandler.c"
	} else {
#line 38 "../src/xmlHandler.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1923 "xmlHandler.c"
	}
}

static gpointer
bookworm_app_value_xml_parser_peek_pointer (const GValue* value)
{
#line 38 "../src/xmlHandler.vala"
	return value->data[0].v_pointer;
#line 1932 "xmlHandler.c"
}

static gchar*
bookworm_app_value_xml_parser_collect_value (GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
#line 38 "../src/xmlHandler.vala"
	if (collect_values[0].v_pointer) {
#line 1943 "xmlHandler.c"
		BookwormAppXmlParser * object;
		object = collect_values[0].v_pointer;
#line 38 "../src/xmlHandler.vala"
		if (object->parent_instance.g_class == NULL) {
#line 38 "../src/xmlHandler.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1950 "xmlHandler.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 38 "../src/xmlHandler.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1954 "xmlHandler.c"
		}
#line 38 "../src/xmlHandler.vala"
		value->data[0].v_pointer = bookworm_app_xml_parser_ref (object);
#line 1958 "xmlHandler.c"
	} else {
#line 38 "../src/xmlHandler.vala"
		value->data[0].v_pointer = NULL;
#line 1962 "xmlHandler.c"
	}
#line 38 "../src/xmlHandler.vala"
	return NULL;
#line 1966 "xmlHandler.c"
}

static gchar*
bookworm_app_value_xml_parser_lcopy_value (const GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	BookwormAppXmlParser ** object_p;
	object_p = collect_values[0].v_pointer;
#line 38 "../src/xmlHandler.vala"
	if (!object_p) {
#line 38 "../src/xmlHandler.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1981 "xmlHandler.c"
	}
#line 38 "../src/xmlHandler.vala"
	if (!value->data[0].v_pointer) {
#line 38 "../src/xmlHandler.vala"
		*object_p = NULL;
#line 1987 "xmlHandler.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 38 "../src/xmlHandler.vala"
		*object_p = value->data[0].v_pointer;
#line 1991 "xmlHandler.c"
	} else {
#line 38 "../src/xmlHandler.vala"
		*object_p = bookworm_app_xml_parser_ref (value->data[0].v_pointer);
#line 1995 "xmlHandler.c"
	}
#line 38 "../src/xmlHandler.vala"
	return NULL;
#line 1999 "xmlHandler.c"
}

GParamSpec*
bookworm_app_param_spec_xml_parser (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags)
{
	BookwormAppParamSpecXmlParser* spec;
#line 38 "../src/xmlHandler.vala"
	g_return_val_if_fail (g_type_is_a (object_type, BOOKWORM_APP_TYPE_XML_PARSER), NULL);
#line 38 "../src/xmlHandler.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 38 "../src/xmlHandler.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 38 "../src/xmlHandler.vala"
	return G_PARAM_SPEC (spec);
#line 2018 "xmlHandler.c"
}

gpointer
bookworm_app_value_get_xml_parser (const GValue* value)
{
#line 38 "../src/xmlHandler.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOOKWORM_APP_TYPE_XML_PARSER), NULL);
#line 38 "../src/xmlHandler.vala"
	return value->data[0].v_pointer;
#line 2028 "xmlHandler.c"
}

void
bookworm_app_value_set_xml_parser (GValue* value,
                                   gpointer v_object)
{
	BookwormAppXmlParser * old;
#line 38 "../src/xmlHandler.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOOKWORM_APP_TYPE_XML_PARSER));
#line 38 "../src/xmlHandler.vala"
	old = value->data[0].v_pointer;
#line 38 "../src/xmlHandler.vala"
	if (v_object) {
#line 38 "../src/xmlHandler.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOOKWORM_APP_TYPE_XML_PARSER));
#line 38 "../src/xmlHandler.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 38 "../src/xmlHandler.vala"
		value->data[0].v_pointer = v_object;
#line 38 "../src/xmlHandler.vala"
		bookworm_app_xml_parser_ref (value->data[0].v_pointer);
#line 2050 "xmlHandler.c"
	} else {
#line 38 "../src/xmlHandler.vala"
		value->data[0].v_pointer = NULL;
#line 2054 "xmlHandler.c"
	}
#line 38 "../src/xmlHandler.vala"
	if (old) {
#line 38 "../src/xmlHandler.vala"
		bookworm_app_xml_parser_unref (old);
#line 2060 "xmlHandler.c"
	}
}

void
bookworm_app_value_take_xml_parser (GValue* value,
                                    gpointer v_object)
{
	BookwormAppXmlParser * old;
#line 38 "../src/xmlHandler.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOOKWORM_APP_TYPE_XML_PARSER));
#line 38 "../src/xmlHandler.vala"
	old = value->data[0].v_pointer;
#line 38 "../src/xmlHandler.vala"
	if (v_object) {
#line 38 "../src/xmlHandler.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOOKWORM_APP_TYPE_XML_PARSER));
#line 38 "../src/xmlHandler.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 38 "../src/xmlHandler.vala"
		value->data[0].v_pointer = v_object;
#line 2081 "xmlHandler.c"
	} else {
#line 38 "../src/xmlHandler.vala"
		value->data[0].v_pointer = NULL;
#line 2085 "xmlHandler.c"
	}
#line 38 "../src/xmlHandler.vala"
	if (old) {
#line 38 "../src/xmlHandler.vala"
		bookworm_app_xml_parser_unref (old);
#line 2091 "xmlHandler.c"
	}
}

static void
bookworm_app_xml_parser_class_init (BookwormAppXmlParserClass * klass,
                                    gpointer klass_data)
{
#line 38 "../src/xmlHandler.vala"
	bookworm_app_xml_parser_parent_class = g_type_class_peek_parent (klass);
#line 38 "../src/xmlHandler.vala"
	((BookwormAppXmlParserClass *) klass)->finalize = bookworm_app_xml_parser_finalize;
#line 2103 "xmlHandler.c"
}

static void
bookworm_app_xml_parser_instance_init (BookwormAppXmlParser * self,
                                       gpointer klass)
{
#line 38 "../src/xmlHandler.vala"
	self->ref_count = 1;
#line 2112 "xmlHandler.c"
}

static void
bookworm_app_xml_parser_finalize (BookwormAppXmlParser * obj)
{
	BookwormAppXmlParser * self;
#line 38 "../src/xmlHandler.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOOKWORM_APP_TYPE_XML_PARSER, BookwormAppXmlParser);
#line 38 "../src/xmlHandler.vala"
	g_signal_handlers_destroy (self);
#line 2123 "xmlHandler.c"
}

static GType
bookworm_app_xml_parser_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { bookworm_app_value_xml_parser_init, bookworm_app_value_xml_parser_free_value, bookworm_app_value_xml_parser_copy_value, bookworm_app_value_xml_parser_peek_pointer, "p", bookworm_app_value_xml_parser_collect_value, "p", bookworm_app_value_xml_parser_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BookwormAppXmlParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bookworm_app_xml_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BookwormAppXmlParser), 0, (GInstanceInitFunc) bookworm_app_xml_parser_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType bookworm_app_xml_parser_type_id;
	bookworm_app_xml_parser_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BookwormAppXmlParser", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return bookworm_app_xml_parser_type_id;
}

GType
bookworm_app_xml_parser_get_type (void)
{
	static volatile gsize bookworm_app_xml_parser_type_id__once = 0;
	if (g_once_init_enter (&bookworm_app_xml_parser_type_id__once)) {
		GType bookworm_app_xml_parser_type_id;
		bookworm_app_xml_parser_type_id = bookworm_app_xml_parser_get_type_once ();
		g_once_init_leave (&bookworm_app_xml_parser_type_id__once, bookworm_app_xml_parser_type_id);
	}
	return bookworm_app_xml_parser_type_id__once;
}

gpointer
bookworm_app_xml_parser_ref (gpointer instance)
{
	BookwormAppXmlParser * self;
	self = instance;
#line 38 "../src/xmlHandler.vala"
	g_atomic_int_inc (&self->ref_count);
#line 38 "../src/xmlHandler.vala"
	return instance;
#line 2158 "xmlHandler.c"
}

void
bookworm_app_xml_parser_unref (gpointer instance)
{
	BookwormAppXmlParser * self;
	self = instance;
#line 38 "../src/xmlHandler.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 38 "../src/xmlHandler.vala"
		BOOKWORM_APP_XML_PARSER_GET_CLASS (self)->finalize (self);
#line 38 "../src/xmlHandler.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2172 "xmlHandler.c"
	}
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

