/* relevancy-service.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from relevancy-service.vala, do not modify */

/*
* Copyright (c) 2010 Michal Hruby <michal.mhr@gmail.com>
*               2017 elementary LLC.
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Michal Hruby <michal.mhr@gmail.com>
*/

#include "slingshot.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SYNAPSE_RELEVANCY_SERVICE_0_PROPERTY,
	SYNAPSE_RELEVANCY_SERVICE_NUM_PROPERTIES
};
static GParamSpec* synapse_relevancy_service_properties[SYNAPSE_RELEVANCY_SERVICE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _SynapseRelevancyServicePrivate {
	SynapseRelevancyBackend* backend;
};

static GType synapse_relevancy_backend_type_id = 0;
static gint SynapseRelevancyService_private_offset;
static gpointer synapse_relevancy_service_parent_class = NULL;
static SynapseRelevancyService* synapse_relevancy_service_instance;
static SynapseRelevancyService* synapse_relevancy_service_instance = NULL;
static GType synapse_relevancy_service_type_id = 0;

static SynapseRelevancyService* synapse_relevancy_service_new (void);
static SynapseRelevancyService* synapse_relevancy_service_construct (GType object_type);
static void synapse_relevancy_service_initialize_relevancy_backend (SynapseRelevancyService* self);
static GObject * synapse_relevancy_service_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties);
static void synapse_relevancy_service_finalize (GObject * obj);

gfloat
synapse_relevancy_backend_get_application_popularity (SynapseRelevancyBackend* self,
                                                      const gchar* desktop_id)
{
	SynapseRelevancyBackendIface* _iface_;
	g_return_val_if_fail (self != NULL, 0.0F);
	_iface_ = SYNAPSE_RELEVANCY_BACKEND_GET_INTERFACE (self);
	if (_iface_->get_application_popularity) {
		return _iface_->get_application_popularity (self, desktop_id);
	}
	return -1.0F;
}

gfloat
synapse_relevancy_backend_get_uri_popularity (SynapseRelevancyBackend* self,
                                              const gchar* uri)
{
	SynapseRelevancyBackendIface* _iface_;
	g_return_val_if_fail (self != NULL, 0.0F);
	_iface_ = SYNAPSE_RELEVANCY_BACKEND_GET_INTERFACE (self);
	if (_iface_->get_uri_popularity) {
		return _iface_->get_uri_popularity (self, uri);
	}
	return -1.0F;
}

void
synapse_relevancy_backend_application_launched (SynapseRelevancyBackend* self,
                                                GAppInfo* app_info)
{
	SynapseRelevancyBackendIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = SYNAPSE_RELEVANCY_BACKEND_GET_INTERFACE (self);
	if (_iface_->application_launched) {
		_iface_->application_launched (self, app_info);
	}
}

static void
synapse_relevancy_backend_default_init (SynapseRelevancyBackendIface * iface,
                                        gpointer iface_data)
{
}

GType
synapse_relevancy_backend_get_type (void)
{
	return synapse_relevancy_backend_type_id;
}

GType
synapse_relevancy_backend_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseRelevancyBackendIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_relevancy_backend_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	synapse_relevancy_backend_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "SynapseRelevancyBackend", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (synapse_relevancy_backend_type_id, G_TYPE_OBJECT);
	return synapse_relevancy_backend_type_id;
}

static inline gpointer
synapse_relevancy_service_get_instance_private (SynapseRelevancyService* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseRelevancyService_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

SynapseRelevancyService*
synapse_relevancy_service_get_default (void)
{
	SynapseRelevancyService* _tmp0_ = NULL;
	SynapseRelevancyService* _tmp1_;
	SynapseRelevancyService* _tmp2_;
	SynapseRelevancyService* _tmp4_;
	SynapseRelevancyService* result;
	_tmp1_ = synapse_relevancy_service_instance;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_tmp0_ = _tmp2_;
	if (_tmp0_ == NULL) {
		SynapseRelevancyService* _tmp3_;
		_tmp3_ = synapse_relevancy_service_new ();
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp3_;
	}
	_tmp4_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp4_;
	_g_object_unref0 (_tmp0_);
	return result;
}

static SynapseRelevancyService*
synapse_relevancy_service_construct (GType object_type)
{
	SynapseRelevancyService * self = NULL;
	self = (SynapseRelevancyService*) g_object_new (object_type, NULL);
	return self;
}

static SynapseRelevancyService*
synapse_relevancy_service_new (void)
{
	return synapse_relevancy_service_construct (SYNAPSE_TYPE_RELEVANCY_SERVICE);
}

static void
synapse_relevancy_service_initialize_relevancy_backend (SynapseRelevancyService* self)
{
	g_return_if_fail (self != NULL);
}

gfloat
synapse_relevancy_service_get_application_popularity (SynapseRelevancyService* self,
                                                      const gchar* desktop_id)
{
	SynapseRelevancyBackend* _tmp0_;
	SynapseRelevancyBackend* _tmp1_;
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	g_return_val_if_fail (desktop_id != NULL, 0.0F);
	_tmp0_ = self->priv->backend;
	if (_tmp0_ == NULL) {
		result = 0.0f;
		return result;
	}
	_tmp1_ = self->priv->backend;
	result = synapse_relevancy_backend_get_application_popularity (_tmp1_, desktop_id);
	return result;
}

gfloat
synapse_relevancy_service_get_uri_popularity (SynapseRelevancyService* self,
                                              const gchar* uri)
{
	SynapseRelevancyBackend* _tmp0_;
	SynapseRelevancyBackend* _tmp1_;
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	g_return_val_if_fail (uri != NULL, 0.0F);
	_tmp0_ = self->priv->backend;
	if (_tmp0_ == NULL) {
		result = 0.0f;
		return result;
	}
	_tmp1_ = self->priv->backend;
	result = synapse_relevancy_backend_get_uri_popularity (_tmp1_, uri);
	return result;
}

void
synapse_relevancy_service_application_launched (SynapseRelevancyService* self,
                                                GAppInfo* app_info)
{
	SynapseRelevancyBackend* _tmp0_;
	SynapseRelevancyBackend* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (app_info != NULL);
	g_debug ("relevancy-service.vala:72: application launched");
	_tmp0_ = self->priv->backend;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->backend;
	synapse_relevancy_backend_application_launched (_tmp1_, app_info);
}

gint
synapse_relevancy_service_compute_relevancy (gint base_relevancy,
                                             gfloat modifier)
{
	gint relevancy = 0;
	gint result;
	relevancy = (gint) (base_relevancy + ((modifier * SYNAPSE_MATCH_SCORE_INCREMENT_LARGE) * 2));
	result = relevancy;
	return result;
}

static GObject *
synapse_relevancy_service_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseRelevancyService * self;
	parent_class = G_OBJECT_CLASS (synapse_relevancy_service_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_RELEVANCY_SERVICE, SynapseRelevancyService);
	synapse_relevancy_service_instance = self;
	g_object_add_weak_pointer ((GObject*) self, &synapse_relevancy_service_instance);
	synapse_relevancy_service_initialize_relevancy_backend (self);
	return obj;
}

static void
synapse_relevancy_service_class_init (SynapseRelevancyServiceClass * klass,
                                      gpointer klass_data)
{
	synapse_relevancy_service_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseRelevancyService_private_offset);
	G_OBJECT_CLASS (klass)->constructor = synapse_relevancy_service_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_relevancy_service_finalize;
}

static void
synapse_relevancy_service_instance_init (SynapseRelevancyService * self,
                                         gpointer klass)
{
	self->priv = synapse_relevancy_service_get_instance_private (self);
}

static void
synapse_relevancy_service_finalize (GObject * obj)
{
	SynapseRelevancyService * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_RELEVANCY_SERVICE, SynapseRelevancyService);
	_g_object_unref0 (self->priv->backend);
	G_OBJECT_CLASS (synapse_relevancy_service_parent_class)->finalize (obj);
}

GType
synapse_relevancy_service_get_type (void)
{
	return synapse_relevancy_service_type_id;
}

GType
synapse_relevancy_service_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseRelevancyServiceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_relevancy_service_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseRelevancyService), 0, (GInstanceInitFunc) synapse_relevancy_service_instance_init, NULL };
	synapse_relevancy_service_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "SynapseRelevancyService", &g_define_type_info, 0);
	SynapseRelevancyService_private_offset = sizeof (SynapseRelevancyServicePrivate);
	return synapse_relevancy_service_type_id;
}

