/* FileUtil.c generated by valac 0.56.17, the Vala compiler
 * generated from FileUtil.vala, do not modify */

/*
* Copyright (c) 2017 Robert San <robertsanseries@gmail.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>

#define CIANO_UTILS_STRING_UTIL_EMPTY ""
#define CIANO_UTILS_STRING_UTIL_SPACE " "
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CIANO_UTILS_TYPE_FILE_UTIL (ciano_utils_file_util_get_type ())
#define CIANO_UTILS_FILE_UTIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CIANO_UTILS_TYPE_FILE_UTIL, CianoUtilsFileUtil))
#define CIANO_UTILS_FILE_UTIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CIANO_UTILS_TYPE_FILE_UTIL, CianoUtilsFileUtilClass))
#define CIANO_UTILS_IS_FILE_UTIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CIANO_UTILS_TYPE_FILE_UTIL))
#define CIANO_UTILS_IS_FILE_UTIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CIANO_UTILS_TYPE_FILE_UTIL))
#define CIANO_UTILS_FILE_UTIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CIANO_UTILS_TYPE_FILE_UTIL, CianoUtilsFileUtilClass))

typedef struct _CianoUtilsFileUtil CianoUtilsFileUtil;
typedef struct _CianoUtilsFileUtilClass CianoUtilsFileUtilClass;
typedef struct _CianoUtilsFileUtilPrivate CianoUtilsFileUtilPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _CianoUtilsParamSpecFileUtil CianoUtilsParamSpecFileUtil;

struct _CianoUtilsFileUtil {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CianoUtilsFileUtilPrivate * priv;
};

struct _CianoUtilsFileUtilClass {
	GTypeClass parent_class;
	void (*finalize) (CianoUtilsFileUtil *self);
};

struct _CianoUtilsParamSpecFileUtil {
	GParamSpec parent_instance;
};

static gpointer ciano_utils_file_util_parent_class = NULL;

VALA_EXTERN gpointer ciano_utils_file_util_ref (gpointer instance);
VALA_EXTERN void ciano_utils_file_util_unref (gpointer instance);
VALA_EXTERN GParamSpec* ciano_utils_param_spec_file_util (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
VALA_EXTERN void ciano_utils_value_set_file_util (GValue* value,
                                      gpointer v_object);
VALA_EXTERN void ciano_utils_value_take_file_util (GValue* value,
                                       gpointer v_object);
VALA_EXTERN gpointer ciano_utils_value_get_file_util (const GValue* value);
VALA_EXTERN GType ciano_utils_file_util_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CianoUtilsFileUtil, ciano_utils_file_util_unref)
VALA_EXTERN void ciano_utils_file_util_open_folder_file_app (const gchar* uri);
VALA_EXTERN void ciano_utils_file_util_create_file (const gchar* dir,
                                        const gchar* name_file,
                                        gchar** words,
                                        gint words_length1);
VALA_EXTERN void ciano_utils_file_util_delete_file (const gchar* dir,
                                        const gchar* name_file);
VALA_EXTERN gchar* ciano_utils_file_util_get_file_extension_name (const gchar* uri);
VALA_EXTERN CianoUtilsFileUtil* ciano_utils_file_util_new (void);
VALA_EXTERN CianoUtilsFileUtil* ciano_utils_file_util_construct (GType object_type);
static void ciano_utils_file_util_finalize (CianoUtilsFileUtil * obj);
static GType ciano_utils_file_util_get_type_once (void);

/**
         * Open folder in app files.
         *
         * Exemple:
         * > FileUtil.open_folder_files(uris)
         * 
         * @param {@code string} - uris
         */
void
ciano_utils_file_util_open_folder_file_app (const gchar* uri)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (uri != NULL);
	{
		GFile* directory = NULL;
		GFile* _tmp0_;
		GFile* _tmp1_;
		GFile* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp0_ = g_file_new_for_path (uri);
		directory = _tmp0_;
		_tmp1_ = directory;
		if (!g_file_query_exists (_tmp1_, NULL)) {
			GFile* _tmp2_;
			_tmp2_ = directory;
			g_file_make_directory_with_parents (_tmp2_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (directory);
				goto __catch0_g_error;
			}
		}
		_tmp3_ = directory;
		_tmp4_ = g_file_get_uri (_tmp3_);
		_tmp5_ = _tmp4_;
		g_app_info_launch_default_for_uri (_tmp5_, NULL, &_inner_error0_);
		_g_free0 (_tmp5_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (directory);
			goto __catch0_g_error;
		}
		_g_object_unref0 (directory);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_critical ("FileUtil.vala:47: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

/**
         * Create file and write.
         *
         * Exemple:
         * > FileUtil.create_file("/etc", "ola.text", array.data);
         * 
         * @param {@code string} - dir
         * @param {@code string} - name_file
         * @param {@code GenericArray<string> > data} - words
         */
void
ciano_utils_file_util_create_file (const gchar* dir,
                                   const gchar* name_file,
                                   gchar** words,
                                   gint words_length1)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (dir != NULL);
	g_return_if_fail (name_file != NULL);
	{
		GFile* directory = NULL;
		GFile* _tmp0_;
		GFile* _tmp1_;
		GFile* file = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		GFile* _tmp7_;
		GFile* _tmp8_;
		gchar* text = NULL;
		gchar* _tmp9_;
		GFile* _tmp16_;
		_tmp0_ = g_file_new_for_path (dir);
		directory = _tmp0_;
		_tmp1_ = directory;
		if (!g_file_query_exists (_tmp1_, NULL)) {
			GFile* _tmp2_;
			_tmp2_ = directory;
			g_file_make_directory_with_parents (_tmp2_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (directory);
				goto __catch0_g_error;
			}
		}
		_tmp3_ = g_strconcat (dir, "/", NULL);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strconcat (_tmp4_, name_file, NULL);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_file_new_for_path (_tmp6_);
		_tmp8_ = _tmp7_;
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
		file = _tmp8_;
		_tmp9_ = g_strdup (CIANO_UTILS_STRING_UTIL_EMPTY);
		text = _tmp9_;
		{
			gchar** word_collection = NULL;
			gint word_collection_length1 = 0;
			gint _word_collection_size_ = 0;
			gint word_it = 0;
			word_collection = words;
			word_collection_length1 = words_length1;
			for (word_it = 0; word_it < word_collection_length1; word_it = word_it + 1) {
				gchar* _tmp10_;
				gchar* word = NULL;
				_tmp10_ = g_strdup (word_collection[word_it]);
				word = _tmp10_;
				{
					const gchar* _tmp11_;
					const gchar* _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					_tmp11_ = text;
					_tmp12_ = word;
					_tmp13_ = g_strconcat (CIANO_UTILS_STRING_UTIL_SPACE, _tmp12_, NULL);
					_tmp14_ = _tmp13_;
					_tmp15_ = g_strconcat (_tmp11_, _tmp14_, NULL);
					_g_free0 (text);
					text = _tmp15_;
					_g_free0 (_tmp14_);
					_g_free0 (word);
				}
			}
		}
		_tmp16_ = file;
		if (!g_file_query_exists (_tmp16_, NULL)) {
			GFileOutputStream* file_stream = NULL;
			GFile* _tmp17_;
			GFileOutputStream* _tmp18_;
			GDataOutputStream* data_stream = NULL;
			GFileOutputStream* _tmp19_;
			GDataOutputStream* _tmp20_;
			GDataOutputStream* _tmp21_;
			const gchar* _tmp22_;
			_tmp17_ = file;
			_tmp18_ = g_file_create (_tmp17_, G_FILE_CREATE_NONE, NULL, &_inner_error0_);
			file_stream = _tmp18_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (text);
				_g_object_unref0 (file);
				_g_object_unref0 (directory);
				goto __catch0_g_error;
			}
			_tmp19_ = file_stream;
			_tmp20_ = g_data_output_stream_new ((GOutputStream*) _tmp19_);
			data_stream = _tmp20_;
			_tmp21_ = data_stream;
			_tmp22_ = text;
			g_data_output_stream_put_string (_tmp21_, _tmp22_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (data_stream);
				_g_object_unref0 (file_stream);
				_g_free0 (text);
				_g_object_unref0 (file);
				_g_object_unref0 (directory);
				goto __catch0_g_error;
			}
			_g_object_unref0 (data_stream);
			_g_object_unref0 (file_stream);
		}
		_g_free0 (text);
		_g_object_unref0 (file);
		_g_object_unref0 (directory);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp23_;
		const gchar* _tmp24_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp23_ = e;
		_tmp24_ = _tmp23_->message;
		g_critical ("FileUtil.vala:83: %s", _tmp24_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

/**
         * Delete file.
         *
         * Exemple:
         * > FileUtil.delete_file("/etc", "ola.text");
         * 
         * @param {@code string} - dir
         * @param {@code string} - name_file
         */
void
ciano_utils_file_util_delete_file (const gchar* dir,
                                   const gchar* name_file)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (dir != NULL);
	g_return_if_fail (name_file != NULL);
	{
		GFile* file = NULL;
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GFile* _tmp4_;
		GFile* _tmp5_;
		GFile* _tmp6_;
		_tmp0_ = g_strconcat (dir, "/", NULL);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_strconcat (_tmp1_, name_file, NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_file_new_for_path (_tmp3_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		_g_free0 (_tmp1_);
		file = _tmp5_;
		_tmp6_ = file;
		if (g_file_query_exists (_tmp6_, NULL)) {
			GFile* _tmp7_;
			_tmp7_ = file;
			g_file_delete (_tmp7_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file);
				goto __catch0_g_error;
			}
		}
		_g_object_unref0 (file);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_critical ("FileUtil.vala:105: %s", _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

/**
         * Get file extension name
         *
         * Exemple:
         * > FileUtil.get_file_extension_name("hello-tech.avi");
         * 
         * @param {@code string} - name_file
         * @return {@code string} - extension
         */
static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

gchar*
ciano_utils_file_util_get_file_extension_name (const gchar* uri)
{
	gint index = 0;
	gchar* extension = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (uri != NULL, NULL);
	index = string_last_index_of (uri, ".", 0);
	_tmp0_ = string_substring (uri, (glong) (index + 1), (glong) -1);
	extension = _tmp0_;
	result = extension;
	return result;
}

CianoUtilsFileUtil*
ciano_utils_file_util_construct (GType object_type)
{
	CianoUtilsFileUtil* self = NULL;
	self = (CianoUtilsFileUtil*) g_type_create_instance (object_type);
	return self;
}

CianoUtilsFileUtil*
ciano_utils_file_util_new (void)
{
	return ciano_utils_file_util_construct (CIANO_UTILS_TYPE_FILE_UTIL);
}

static void
ciano_utils_value_file_util_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
ciano_utils_value_file_util_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		ciano_utils_file_util_unref (value->data[0].v_pointer);
	}
}

static void
ciano_utils_value_file_util_copy_value (const GValue* src_value,
                                        GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = ciano_utils_file_util_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
ciano_utils_value_file_util_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
ciano_utils_value_file_util_collect_value (GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		CianoUtilsFileUtil * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = ciano_utils_file_util_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
ciano_utils_value_file_util_lcopy_value (const GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	CianoUtilsFileUtil ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = ciano_utils_file_util_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
ciano_utils_param_spec_file_util (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags)
{
	CianoUtilsParamSpecFileUtil* spec;
	g_return_val_if_fail (g_type_is_a (object_type, CIANO_UTILS_TYPE_FILE_UTIL), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
ciano_utils_value_get_file_util (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CIANO_UTILS_TYPE_FILE_UTIL), NULL);
	return value->data[0].v_pointer;
}

void
ciano_utils_value_set_file_util (GValue* value,
                                 gpointer v_object)
{
	CianoUtilsFileUtil * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CIANO_UTILS_TYPE_FILE_UTIL));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CIANO_UTILS_TYPE_FILE_UTIL));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		ciano_utils_file_util_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		ciano_utils_file_util_unref (old);
	}
}

void
ciano_utils_value_take_file_util (GValue* value,
                                  gpointer v_object)
{
	CianoUtilsFileUtil * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CIANO_UTILS_TYPE_FILE_UTIL));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CIANO_UTILS_TYPE_FILE_UTIL));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		ciano_utils_file_util_unref (old);
	}
}

static void
ciano_utils_file_util_class_init (CianoUtilsFileUtilClass * klass,
                                  gpointer klass_data)
{
	ciano_utils_file_util_parent_class = g_type_class_peek_parent (klass);
	((CianoUtilsFileUtilClass *) klass)->finalize = ciano_utils_file_util_finalize;
}

static void
ciano_utils_file_util_instance_init (CianoUtilsFileUtil * self,
                                     gpointer klass)
{
	self->ref_count = 1;
}

static void
ciano_utils_file_util_finalize (CianoUtilsFileUtil * obj)
{
	CianoUtilsFileUtil * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CIANO_UTILS_TYPE_FILE_UTIL, CianoUtilsFileUtil);
	g_signal_handlers_destroy (self);
}

/**
     * The {@code FileUtil} class related to files handling.
     *
     * @since 0.1.0
     */
static GType
ciano_utils_file_util_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { ciano_utils_value_file_util_init, ciano_utils_value_file_util_free_value, ciano_utils_value_file_util_copy_value, ciano_utils_value_file_util_peek_pointer, "p", ciano_utils_value_file_util_collect_value, "p", ciano_utils_value_file_util_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (CianoUtilsFileUtilClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ciano_utils_file_util_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CianoUtilsFileUtil), 0, (GInstanceInitFunc) ciano_utils_file_util_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType ciano_utils_file_util_type_id;
	ciano_utils_file_util_type_id = g_type_register_fundamental (g_type_fundamental_next (), "CianoUtilsFileUtil", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return ciano_utils_file_util_type_id;
}

GType
ciano_utils_file_util_get_type (void)
{
	static volatile gsize ciano_utils_file_util_type_id__once = 0;
	if (g_once_init_enter (&ciano_utils_file_util_type_id__once)) {
		GType ciano_utils_file_util_type_id;
		ciano_utils_file_util_type_id = ciano_utils_file_util_get_type_once ();
		g_once_init_leave (&ciano_utils_file_util_type_id__once, ciano_utils_file_util_type_id);
	}
	return ciano_utils_file_util_type_id__once;
}

gpointer
ciano_utils_file_util_ref (gpointer instance)
{
	CianoUtilsFileUtil * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
ciano_utils_file_util_unref (gpointer instance)
{
	CianoUtilsFileUtil * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CIANO_UTILS_FILE_UTIL_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

