/*
Copyright The cert-manager Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// CertificateDNSNameSelectorApplyConfiguration represents a declarative configuration of the CertificateDNSNameSelector type for use
// with apply.
type CertificateDNSNameSelectorApplyConfiguration struct {
	MatchLabels map[string]string `json:"matchLabels,omitempty"`
	DNSNames    []string          `json:"dnsNames,omitempty"`
	DNSZones    []string          `json:"dnsZones,omitempty"`
}

// CertificateDNSNameSelectorApplyConfiguration constructs a declarative configuration of the CertificateDNSNameSelector type for use with
// apply.
func CertificateDNSNameSelector() *CertificateDNSNameSelectorApplyConfiguration {
	return &CertificateDNSNameSelectorApplyConfiguration{}
}

// WithMatchLabels puts the entries into the MatchLabels field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the MatchLabels field,
// overwriting an existing map entries in MatchLabels field with the same key.
func (b *CertificateDNSNameSelectorApplyConfiguration) WithMatchLabels(entries map[string]string) *CertificateDNSNameSelectorApplyConfiguration {
	if b.MatchLabels == nil && len(entries) > 0 {
		b.MatchLabels = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.MatchLabels[k] = v
	}
	return b
}

// WithDNSNames adds the given value to the DNSNames field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the DNSNames field.
func (b *CertificateDNSNameSelectorApplyConfiguration) WithDNSNames(values ...string) *CertificateDNSNameSelectorApplyConfiguration {
	for i := range values {
		b.DNSNames = append(b.DNSNames, values[i])
	}
	return b
}

// WithDNSZones adds the given value to the DNSZones field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the DNSZones field.
func (b *CertificateDNSNameSelectorApplyConfiguration) WithDNSZones(values ...string) *CertificateDNSNameSelectorApplyConfiguration {
	for i := range values {
		b.DNSZones = append(b.DNSZones, values[i])
	}
	return b
}
