/* Contract.c generated by valac 0.56.17, the Vala compiler
 * generated from Contract.vala, do not modify */

/*
 * Copyright (C) 2011-2017 elementary Developers
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONTRACTOR_TYPE_CONTRACT (contractor_contract_get_type ())
#define CONTRACTOR_CONTRACT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTRACTOR_TYPE_CONTRACT, ContractorContract))
#define CONTRACTOR_CONTRACT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTRACTOR_TYPE_CONTRACT, ContractorContractClass))
#define CONTRACTOR_IS_CONTRACT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTRACTOR_TYPE_CONTRACT))
#define CONTRACTOR_IS_CONTRACT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTRACTOR_TYPE_CONTRACT))
#define CONTRACTOR_CONTRACT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTRACTOR_TYPE_CONTRACT, ContractorContractClass))

typedef struct _ContractorContract ContractorContract;
typedef struct _ContractorContractClass ContractorContractClass;
typedef struct _ContractorContractPrivate ContractorContractPrivate;

#define CONTRACTOR_TYPE_MIME_TYPE_MANAGER (contractor_mime_type_manager_get_type ())
#define CONTRACTOR_MIME_TYPE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTRACTOR_TYPE_MIME_TYPE_MANAGER, ContractorMimeTypeManager))
#define CONTRACTOR_MIME_TYPE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTRACTOR_TYPE_MIME_TYPE_MANAGER, ContractorMimeTypeManagerClass))
#define CONTRACTOR_IS_MIME_TYPE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTRACTOR_TYPE_MIME_TYPE_MANAGER))
#define CONTRACTOR_IS_MIME_TYPE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTRACTOR_TYPE_MIME_TYPE_MANAGER))
#define CONTRACTOR_MIME_TYPE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTRACTOR_TYPE_MIME_TYPE_MANAGER, ContractorMimeTypeManagerClass))

typedef struct _ContractorMimeTypeManager ContractorMimeTypeManager;
typedef struct _ContractorMimeTypeManagerClass ContractorMimeTypeManagerClass;

#define CONTRACTOR_TYPE_CONTRACT_KEY_FILE (contractor_contract_key_file_get_type ())
#define CONTRACTOR_CONTRACT_KEY_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTRACTOR_TYPE_CONTRACT_KEY_FILE, ContractorContractKeyFile))
#define CONTRACTOR_CONTRACT_KEY_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTRACTOR_TYPE_CONTRACT_KEY_FILE, ContractorContractKeyFileClass))
#define CONTRACTOR_IS_CONTRACT_KEY_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTRACTOR_TYPE_CONTRACT_KEY_FILE))
#define CONTRACTOR_IS_CONTRACT_KEY_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTRACTOR_TYPE_CONTRACT_KEY_FILE))
#define CONTRACTOR_CONTRACT_KEY_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTRACTOR_TYPE_CONTRACT_KEY_FILE, ContractorContractKeyFileClass))

typedef struct _ContractorContractKeyFile ContractorContractKeyFile;
typedef struct _ContractorContractKeyFileClass ContractorContractKeyFileClass;
enum  {
	CONTRACTOR_CONTRACT_0_PROPERTY,
	CONTRACTOR_CONTRACT_ID_PROPERTY,
	CONTRACTOR_CONTRACT_NAME_PROPERTY,
	CONTRACTOR_CONTRACT_ICON_PROPERTY,
	CONTRACTOR_CONTRACT_DESCRIPTION_PROPERTY,
	CONTRACTOR_CONTRACT_MAX_FILE_SIZE_PROPERTY,
	CONTRACTOR_CONTRACT_NUM_PROPERTIES
};
static GParamSpec* contractor_contract_properties[CONTRACTOR_CONTRACT_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CONTRACTOR_TYPE_CONTRACT_FILE (contractor_contract_file_get_type ())
#define CONTRACTOR_CONTRACT_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTRACTOR_TYPE_CONTRACT_FILE, ContractorContractFile))
#define CONTRACTOR_CONTRACT_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTRACTOR_TYPE_CONTRACT_FILE, ContractorContractFileClass))
#define CONTRACTOR_IS_CONTRACT_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTRACTOR_TYPE_CONTRACT_FILE))
#define CONTRACTOR_IS_CONTRACT_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTRACTOR_TYPE_CONTRACT_FILE))
#define CONTRACTOR_CONTRACT_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTRACTOR_TYPE_CONTRACT_FILE, ContractorContractFileClass))

typedef struct _ContractorContractFile ContractorContractFile;
typedef struct _ContractorContractFileClass ContractorContractFileClass;

#define CONTRACTOR_TYPE_GENERIC_CONTRACT (contractor_generic_contract_get_type ())
typedef struct _ContractorGenericContract ContractorGenericContract;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _ContractorContract {
	GObject parent_instance;
	ContractorContractPrivate * priv;
};

struct _ContractorContractClass {
	GObjectClass parent_class;
};

struct _ContractorContractPrivate {
	gchar* _id;
	gchar* _name;
	gchar* _icon;
	gchar* _description;
	gint64 _max_file_size;
	ContractorMimeTypeManager* mimetype_manager;
	ContractorContractKeyFile* keyfile;
};

struct _ContractorGenericContract {
	gchar* id;
	gchar* name;
	gchar* description;
	gchar* icon;
};

static gint ContractorContract_private_offset;
static gpointer contractor_contract_parent_class = NULL;

VALA_EXTERN GType contractor_contract_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContractorContract, g_object_unref)
VALA_EXTERN GType contractor_mime_type_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContractorMimeTypeManager, g_object_unref)
VALA_EXTERN GType contractor_contract_key_file_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContractorContractKeyFile, g_object_unref)
VALA_EXTERN ContractorContract* contractor_contract_new (GFile* file,
                                             GError** error);
VALA_EXTERN ContractorContract* contractor_contract_construct (GType object_type,
                                                   GFile* file,
                                                   GError** error);
VALA_EXTERN GType contractor_contract_file_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContractorContractFile, g_object_unref)
VALA_EXTERN ContractorContractFile* contractor_contract_file_new (GFile* file);
VALA_EXTERN ContractorContractFile* contractor_contract_file_construct (GType object_type,
                                                            GFile* file);
VALA_EXTERN ContractorContractKeyFile* contractor_contract_key_file_new (ContractorContractFile* contract_file,
                                                             GError** error);
VALA_EXTERN ContractorContractKeyFile* contractor_contract_key_file_construct (GType object_type,
                                                                   ContractorContractFile* contract_file,
                                                                   GError** error);
VALA_EXTERN gchar* contractor_contract_file_get_id (ContractorContractFile* self);
static void contractor_contract_set_id (ContractorContract* self,
                                 const gchar* value);
static void contractor_contract_load_mandatory_fields (ContractorContract* self,
                                                GError** error);
static void contractor_contract_load_non_mandatory_fields (ContractorContract* self);
VALA_EXTERN gboolean contractor_contract_supports_mime_type (ContractorContract* self,
                                                 const gchar* mime_type);
VALA_EXTERN gboolean contractor_mime_type_manager_is_type_supported (ContractorMimeTypeManager* self,
                                                         const gchar* mime_type);
VALA_EXTERN gboolean contractor_contract_supports_file_size (ContractorContract* self,
                                                 gint64 file_size);
VALA_EXTERN gint64 contractor_contract_get_max_file_size (ContractorContract* self);
VALA_EXTERN void contractor_contract_launch_uris (ContractorContract* self,
                                      gchar** uris,
                                      gint uris_length1,
                                      GError** error);
VALA_EXTERN GList* contractor_string_array_to_list (gchar** array,
                                        gint array_length1);
VALA_EXTERN GAppInfo* contractor_contract_key_file_get_app_info (ContractorContractKeyFile* self,
                                                     GError** error);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
VALA_EXTERN GType contractor_generic_contract_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ContractorGenericContract* contractor_generic_contract_dup (const ContractorGenericContract* self);
VALA_EXTERN void contractor_generic_contract_free (ContractorGenericContract* self);
VALA_EXTERN void contractor_generic_contract_copy (const ContractorGenericContract* self,
                                       ContractorGenericContract* dest);
VALA_EXTERN void contractor_generic_contract_destroy (ContractorGenericContract* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (ContractorGenericContract, contractor_generic_contract_destroy)
VALA_EXTERN void contractor_contract_get_generic (ContractorContract* self,
                                      ContractorGenericContract* result);
VALA_EXTERN const gchar* contractor_contract_get_id (ContractorContract* self);
VALA_EXTERN const gchar* contractor_contract_get_name (ContractorContract* self);
VALA_EXTERN const gchar* contractor_contract_get_description (ContractorContract* self);
VALA_EXTERN const gchar* contractor_contract_get_icon (ContractorContract* self);
VALA_EXTERN gchar* contractor_contract_key_file_get_name (ContractorContractKeyFile* self,
                                              GError** error);
static void contractor_contract_set_name (ContractorContract* self,
                                   const gchar* value);
VALA_EXTERN gchar** contractor_contract_key_file_get_mimetypes (ContractorContractKeyFile* self,
                                                    gint* result_length1,
                                                    GError** error);
VALA_EXTERN ContractorMimeTypeManager* contractor_mime_type_manager_new (gchar** mimetypes,
                                                             gint mimetypes_length1,
                                                             GError** error);
VALA_EXTERN ContractorMimeTypeManager* contractor_mime_type_manager_construct (GType object_type,
                                                                   gchar** mimetypes,
                                                                   gint mimetypes_length1,
                                                                   GError** error);
VALA_EXTERN gchar* contractor_contract_key_file_get_description (ContractorContractKeyFile* self,
                                                     GError** error);
static void contractor_contract_set_description (ContractorContract* self,
                                          const gchar* value);
VALA_EXTERN gchar* contractor_contract_key_file_get_icon (ContractorContractKeyFile* self,
                                              GError** error);
static void contractor_contract_set_icon (ContractorContract* self,
                                   const gchar* value);
VALA_EXTERN gint64 contractor_contract_key_file_get_max_file_size (ContractorContractKeyFile* self,
                                                       GError** error);
static void contractor_contract_set_max_file_size (ContractorContract* self,
                                            gint64 value);
static void contractor_contract_finalize (GObject * obj);
static GType contractor_contract_get_type_once (void);
static void _vala_contractor_contract_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_contractor_contract_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
contractor_contract_get_instance_private (ContractorContract* self)
{
	return G_STRUCT_MEMBER_P (self, ContractorContract_private_offset);
}

/**
         * the constructor used to create a Contract object containing a
         * ContractFile object based on the passed File object
         *
         * @param file the file of which a ContractFile object should be created
         */
ContractorContract*
contractor_contract_construct (GType object_type,
                               GFile* file,
                               GError** error)
{
	ContractorContract * self = NULL;
	ContractorContractFile* contract_file = NULL;
	ContractorContractFile* _tmp0_;
	ContractorContractKeyFile* _tmp1_ = NULL;
	ContractorContractFile* _tmp2_;
	ContractorContractKeyFile* _tmp3_;
	ContractorContractKeyFile* _tmp4_;
	ContractorContractFile* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	self = (ContractorContract*) g_object_new (object_type, NULL);
	_tmp0_ = contractor_contract_file_new (file);
	contract_file = _tmp0_;
	_tmp2_ = contract_file;
	_tmp3_ = contractor_contract_key_file_new (_tmp2_, &_inner_error0_);
	_tmp1_ = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (contract_file);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp4_ = _tmp1_;
	_tmp1_ = NULL;
	_g_object_unref0 (self->priv->keyfile);
	self->priv->keyfile = _tmp4_;
	_tmp5_ = contract_file;
	_tmp6_ = contractor_contract_file_get_id (_tmp5_);
	_tmp7_ = _tmp6_;
	contractor_contract_set_id (self, _tmp7_);
	_g_free0 (_tmp7_);
	contractor_contract_load_mandatory_fields (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp1_);
		_g_object_unref0 (contract_file);
		_g_object_unref0 (self);
		return NULL;
	}
	contractor_contract_load_non_mandatory_fields (self);
	_g_object_unref0 (_tmp1_);
	_g_object_unref0 (contract_file);
	return self;
}

ContractorContract*
contractor_contract_new (GFile* file,
                         GError** error)
{
	return contractor_contract_construct (CONTRACTOR_TYPE_CONTRACT, file, error);
}

/**
         * returns true if the MIME type is supported by this contract; false
         * otherwise
         *
         * @param mime_type the MIME type of the file or list of files on which the contract should be applied
         *
         * @return true if the MIME type is supported by this contract; false otherwise
         */
gboolean
contractor_contract_supports_mime_type (ContractorContract* self,
                                        const gchar* mime_type)
{
	ContractorMimeTypeManager* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (mime_type != NULL, FALSE);
	_tmp0_ = self->priv->mimetype_manager;
	result = contractor_mime_type_manager_is_type_supported (_tmp0_, mime_type);
	return result;
}

/**
         * returns true if the file size is supported by this contract; false
         * otherwise
         *
         * @param file_size the file size of the file or list of files on which the contract should be applied
         *
         * @return true if the file size is supported by this contract; false otherwise
         */
gboolean
contractor_contract_supports_file_size (ContractorContract* self,
                                        gint64 file_size)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (file_size == ((gint64) -1)) {
		_tmp0_ = TRUE;
	} else {
		gint64 _tmp1_;
		_tmp1_ = self->priv->_max_file_size;
		_tmp0_ = file_size <= _tmp1_;
	}
	result = _tmp0_;
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

void
contractor_contract_launch_uris (ContractorContract* self,
                                 gchar** uris,
                                 gint uris_length1,
                                 GError** error)
{
	GList* uri_list = NULL;
	GList* _tmp0_;
	GAppInfo* _tmp1_ = NULL;
	ContractorContractKeyFile* _tmp2_;
	GAppInfo* _tmp3_;
	GList* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = contractor_string_array_to_list (uris, (gint) uris_length1);
	uri_list = _tmp0_;
	_tmp2_ = self->priv->keyfile;
	_tmp3_ = contractor_contract_key_file_get_app_info (_tmp2_, &_inner_error0_);
	_tmp1_ = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		(uri_list == NULL) ? NULL : (uri_list = (_g_list_free__g_free0_ (uri_list), NULL));
		return;
	}
	_tmp4_ = uri_list;
	g_app_info_launch_uris (_tmp1_, _tmp4_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp1_);
		(uri_list == NULL) ? NULL : (uri_list = (_g_list_free__g_free0_ (uri_list), NULL));
		return;
	}
	_g_object_unref0 (_tmp1_);
	(uri_list == NULL) ? NULL : (uri_list = (_g_list_free__g_free0_ (uri_list), NULL));
}

/**
         * creates and returns a new GenericContract object and fills it with
         * data from this Contract object (id, name, description, icon)
         */
void
contractor_contract_get_generic (ContractorContract* self,
                                 ContractorGenericContract* result)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	ContractorGenericContract _tmp8_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_id;
	_tmp1_ = g_strdup (_tmp0_);
	_tmp2_ = self->priv->_name;
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = self->priv->_description;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = self->priv->_icon;
	_tmp7_ = g_strdup (_tmp6_);
	memset (&_tmp8_, 0, sizeof (ContractorGenericContract));
	_g_free0 (_tmp8_.id);
	_tmp8_.id = _tmp1_;
	_g_free0 (_tmp8_.name);
	_tmp8_.name = _tmp3_;
	_g_free0 (_tmp8_.description);
	_tmp8_.description = _tmp5_;
	_g_free0 (_tmp8_.icon);
	_tmp8_.icon = _tmp7_;
	*result = _tmp8_;
	return;
}

/**
         * loads mandatory fields from the key file
         */
static void
contractor_contract_load_mandatory_fields (ContractorContract* self,
                                           GError** error)
{
	gchar* _tmp0_ = NULL;
	ContractorContractKeyFile* _tmp1_;
	gchar* _tmp2_;
	gchar** mimetypes = NULL;
	ContractorContractKeyFile* _tmp3_;
	gint _tmp4_ = 0;
	gchar** _tmp5_;
	gint mimetypes_length1;
	gint _mimetypes_size_;
	ContractorMimeTypeManager* _tmp6_ = NULL;
	gchar** _tmp7_;
	gint _tmp7__length1;
	ContractorMimeTypeManager* _tmp8_;
	ContractorMimeTypeManager* _tmp9_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->keyfile;
	_tmp2_ = contractor_contract_key_file_get_name (_tmp1_, &_inner_error0_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	contractor_contract_set_name (self, _tmp0_);
	_tmp3_ = self->priv->keyfile;
	_tmp5_ = contractor_contract_key_file_get_mimetypes (_tmp3_, &_tmp4_, &_inner_error0_);
	mimetypes = _tmp5_;
	mimetypes_length1 = _tmp4_;
	_mimetypes_size_ = mimetypes_length1;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (_tmp0_);
		return;
	}
	_tmp7_ = mimetypes;
	_tmp7__length1 = mimetypes_length1;
	_tmp8_ = contractor_mime_type_manager_new (_tmp7_, _tmp7__length1, &_inner_error0_);
	_tmp6_ = _tmp8_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		mimetypes = (_vala_array_free (mimetypes, mimetypes_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_tmp0_);
		return;
	}
	_tmp9_ = _tmp6_;
	_tmp6_ = NULL;
	_g_object_unref0 (self->priv->mimetype_manager);
	self->priv->mimetype_manager = _tmp9_;
	_g_object_unref0 (_tmp6_);
	mimetypes = (_vala_array_free (mimetypes, mimetypes_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (_tmp0_);
}

/**
         * loads non-mandatory fields from the key file
         */
static void
contractor_contract_load_non_mandatory_fields (ContractorContract* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gchar* _tmp0_ = NULL;
		ContractorContractKeyFile* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->priv->keyfile;
		_tmp2_ = contractor_contract_key_file_get_description (_tmp1_, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		contractor_contract_set_description (self, _tmp0_);
		_g_free0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = self->priv->_id;
		_tmp4_ = err;
		_tmp5_ = _tmp4_->message;
		g_warning ("Contract.vala:121: Contract '%s' does not provide a description (%s)", _tmp3_, _tmp5_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	{
		gchar* _tmp6_ = NULL;
		ContractorContractKeyFile* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = self->priv->keyfile;
		_tmp8_ = contractor_contract_key_file_get_icon (_tmp7_, &_inner_error0_);
		_tmp6_ = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		contractor_contract_set_icon (self, _tmp6_);
		_g_free0 (_tmp6_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp9_;
		GError* _tmp10_;
		const gchar* _tmp11_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = self->priv->_id;
		_tmp10_ = err;
		_tmp11_ = _tmp10_->message;
		g_warning ("Contract.vala:127: Contract '%s' does not provide an icon (%s)", _tmp9_, _tmp11_);
		_g_error_free0 (err);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	{
		gint64 _tmp12_ = 0LL;
		ContractorContractKeyFile* _tmp13_;
		_tmp13_ = self->priv->keyfile;
		_tmp12_ = contractor_contract_key_file_get_max_file_size (_tmp13_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
		contractor_contract_set_max_file_size (self, _tmp12_);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp14_;
		GError* _tmp15_;
		const gchar* _tmp16_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = self->priv->_id;
		_tmp15_ = err;
		_tmp16_ = _tmp15_->message;
		g_debug ("Contract.vala:133: Contract '%s' does not provide a max file size (%s)", _tmp14_, _tmp16_);
		_g_error_free0 (err);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

const gchar*
contractor_contract_get_id (ContractorContract* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}

static void
contractor_contract_set_id (ContractorContract* self,
                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = contractor_contract_get_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_id);
		self->priv->_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contractor_contract_properties[CONTRACTOR_CONTRACT_ID_PROPERTY]);
	}
}

const gchar*
contractor_contract_get_name (ContractorContract* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
contractor_contract_set_name (ContractorContract* self,
                              const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = contractor_contract_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contractor_contract_properties[CONTRACTOR_CONTRACT_NAME_PROPERTY]);
	}
}

const gchar*
contractor_contract_get_icon (ContractorContract* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon;
	result = _tmp0_;
	return result;
}

static void
contractor_contract_set_icon (ContractorContract* self,
                              const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = contractor_contract_get_icon (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_icon);
		self->priv->_icon = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contractor_contract_properties[CONTRACTOR_CONTRACT_ICON_PROPERTY]);
	}
}

const gchar*
contractor_contract_get_description (ContractorContract* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}

static void
contractor_contract_set_description (ContractorContract* self,
                                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = contractor_contract_get_description (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contractor_contract_properties[CONTRACTOR_CONTRACT_DESCRIPTION_PROPERTY]);
	}
}

gint64
contractor_contract_get_max_file_size (ContractorContract* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_max_file_size;
	return result;
}

static void
contractor_contract_set_max_file_size (ContractorContract* self,
                                       gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = contractor_contract_get_max_file_size (self);
	if (old_value != value) {
		self->priv->_max_file_size = value;
		g_object_notify_by_pspec ((GObject *) self, contractor_contract_properties[CONTRACTOR_CONTRACT_MAX_FILE_SIZE_PROPERTY]);
	}
}

static void
contractor_contract_class_init (ContractorContractClass * klass,
                                gpointer klass_data)
{
	contractor_contract_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContractorContract_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_contractor_contract_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contractor_contract_set_property;
	G_OBJECT_CLASS (klass)->finalize = contractor_contract_finalize;
	/**
	         * the contracts ID based on the file name, e.g. file-roller-compress
	         * (file-roller-compress.contract)
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTRACTOR_CONTRACT_ID_PROPERTY, contractor_contract_properties[CONTRACTOR_CONTRACT_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	         * the name displayed in the GUI
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTRACTOR_CONTRACT_NAME_PROPERTY, contractor_contract_properties[CONTRACTOR_CONTRACT_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTRACTOR_CONTRACT_ICON_PROPERTY, contractor_contract_properties[CONTRACTOR_CONTRACT_ICON_PROPERTY] = g_param_spec_string ("icon", "icon", "icon", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTRACTOR_CONTRACT_DESCRIPTION_PROPERTY, contractor_contract_properties[CONTRACTOR_CONTRACT_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	         * the maximal file size a file or list of files are allowed to have to
	         * be applicable for this contract
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTRACTOR_CONTRACT_MAX_FILE_SIZE_PROPERTY, contractor_contract_properties[CONTRACTOR_CONTRACT_MAX_FILE_SIZE_PROPERTY] = g_param_spec_int64 ("max-file-size", "max-file-size", "max-file-size", G_MININT64, G_MAXINT64, (gint64) -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
contractor_contract_instance_init (ContractorContract * self,
                                   gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = contractor_contract_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_icon = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_description = _tmp1_;
	self->priv->_max_file_size = (gint64) -1;
}

static void
contractor_contract_finalize (GObject * obj)
{
	ContractorContract * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTRACTOR_TYPE_CONTRACT, ContractorContract);
	_g_free0 (self->priv->_id);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_icon);
	_g_free0 (self->priv->_description);
	_g_object_unref0 (self->priv->mimetype_manager);
	_g_object_unref0 (self->priv->keyfile);
	G_OBJECT_CLASS (contractor_contract_parent_class)->finalize (obj);
}

/**
     * a contract which defines an action available for certain files
     */
static GType
contractor_contract_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContractorContractClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contractor_contract_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContractorContract), 0, (GInstanceInitFunc) contractor_contract_instance_init, NULL };
	GType contractor_contract_type_id;
	contractor_contract_type_id = g_type_register_static (G_TYPE_OBJECT, "ContractorContract", &g_define_type_info, 0);
	ContractorContract_private_offset = g_type_add_instance_private (contractor_contract_type_id, sizeof (ContractorContractPrivate));
	return contractor_contract_type_id;
}

GType
contractor_contract_get_type (void)
{
	static volatile gsize contractor_contract_type_id__once = 0;
	if (g_once_init_enter (&contractor_contract_type_id__once)) {
		GType contractor_contract_type_id;
		contractor_contract_type_id = contractor_contract_get_type_once ();
		g_once_init_leave (&contractor_contract_type_id__once, contractor_contract_type_id);
	}
	return contractor_contract_type_id__once;
}

static void
_vala_contractor_contract_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	ContractorContract * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTRACTOR_TYPE_CONTRACT, ContractorContract);
	switch (property_id) {
		case CONTRACTOR_CONTRACT_ID_PROPERTY:
		g_value_set_string (value, contractor_contract_get_id (self));
		break;
		case CONTRACTOR_CONTRACT_NAME_PROPERTY:
		g_value_set_string (value, contractor_contract_get_name (self));
		break;
		case CONTRACTOR_CONTRACT_ICON_PROPERTY:
		g_value_set_string (value, contractor_contract_get_icon (self));
		break;
		case CONTRACTOR_CONTRACT_DESCRIPTION_PROPERTY:
		g_value_set_string (value, contractor_contract_get_description (self));
		break;
		case CONTRACTOR_CONTRACT_MAX_FILE_SIZE_PROPERTY:
		g_value_set_int64 (value, contractor_contract_get_max_file_size (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contractor_contract_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	ContractorContract * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTRACTOR_TYPE_CONTRACT, ContractorContract);
	switch (property_id) {
		case CONTRACTOR_CONTRACT_ID_PROPERTY:
		contractor_contract_set_id (self, g_value_get_string (value));
		break;
		case CONTRACTOR_CONTRACT_NAME_PROPERTY:
		contractor_contract_set_name (self, g_value_get_string (value));
		break;
		case CONTRACTOR_CONTRACT_ICON_PROPERTY:
		contractor_contract_set_icon (self, g_value_get_string (value));
		break;
		case CONTRACTOR_CONTRACT_DESCRIPTION_PROPERTY:
		contractor_contract_set_description (self, g_value_get_string (value));
		break;
		case CONTRACTOR_CONTRACT_MAX_FILE_SIZE_PROPERTY:
		contractor_contract_set_max_file_size (self, g_value_get_int64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

