/* appbar.c generated by valac 0.56.17, the Vala compiler
 * generated from appbar.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2011 ~ 2018 Deepin, Inc.
 *               2011 ~ 2018 Wang Yong
 *
 * Author:     Wang Yong <wangyong@deepin.com>
 * Maintainer: Wang Yong <wangyong@deepin.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <stdio.h>
#include <float.h>
#include <math.h>
#include <gee.h>
#include <cairo-gobject.h>

#define GETTEXT_PACKAGE "deepin-terminal-gtk"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_TERMINAL_BUS (terminal_bus_get_type ())
#define TERMINAL_BUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TERMINAL_BUS, TerminalBus))
#define IS_TERMINAL_BUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TERMINAL_BUS))
#define TERMINAL_BUS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_TERMINAL_BUS, TerminalBusIface))

typedef struct _TerminalBus TerminalBus;
typedef struct _TerminalBusIface TerminalBusIface;

#define TYPE_TERMINAL_BUS_PROXY (terminal_bus_proxy_get_type ())
enum  {
	TERMINAL_BUS_QUIT_SIGNAL,
	TERMINAL_BUS_NUM_SIGNALS
};
static guint terminal_bus_signals[TERMINAL_BUS_NUM_SIGNALS] = {0};
typedef GDBusProxy TerminalBusProxy;
typedef GDBusProxyClass TerminalBusProxyClass;

#define WIDGETS_TYPE_APPBAR (widgets_appbar_get_type ())
#define WIDGETS_APPBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_APPBAR, WidgetsAppbar))
#define WIDGETS_APPBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_APPBAR, WidgetsAppbarClass))
#define WIDGETS_IS_APPBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_APPBAR))
#define WIDGETS_IS_APPBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_APPBAR))
#define WIDGETS_APPBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_APPBAR, WidgetsAppbarClass))

typedef struct _WidgetsAppbar WidgetsAppbar;
typedef struct _WidgetsAppbarClass WidgetsAppbarClass;
typedef struct _WidgetsAppbarPrivate WidgetsAppbarPrivate;

#define MENU_TYPE_MENU (menu_menu_get_type ())
#define MENU_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MENU_TYPE_MENU, MenuMenu))
#define MENU_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MENU_TYPE_MENU, MenuMenuClass))
#define MENU_IS_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MENU_TYPE_MENU))
#define MENU_IS_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MENU_TYPE_MENU))
#define MENU_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MENU_TYPE_MENU, MenuMenuClass))

typedef struct _MenuMenu MenuMenu;
typedef struct _MenuMenuClass MenuMenuClass;

#define WIDGETS_TYPE_TABBAR (widgets_tabbar_get_type ())
#define WIDGETS_TABBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_TABBAR, WidgetsTabbar))
#define WIDGETS_TABBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_TABBAR, WidgetsTabbarClass))
#define WIDGETS_IS_TABBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_TABBAR))
#define WIDGETS_IS_TABBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_TABBAR))
#define WIDGETS_TABBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_TABBAR, WidgetsTabbarClass))

typedef struct _WidgetsTabbar WidgetsTabbar;
typedef struct _WidgetsTabbarClass WidgetsTabbarClass;

#define WIDGETS_TYPE_CONFIG_WINDOW (widgets_config_window_get_type ())
#define WIDGETS_CONFIG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindow))
#define WIDGETS_CONFIG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindowClass))
#define WIDGETS_IS_CONFIG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_CONFIG_WINDOW))
#define WIDGETS_IS_CONFIG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_CONFIG_WINDOW))
#define WIDGETS_CONFIG_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindowClass))

typedef struct _WidgetsConfigWindow WidgetsConfigWindow;
typedef struct _WidgetsConfigWindowClass WidgetsConfigWindowClass;

#define WIDGETS_TYPE_WINDOW (widgets_window_get_type ())
#define WIDGETS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_WINDOW, WidgetsWindow))
#define WIDGETS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_WINDOW, WidgetsWindowClass))
#define WIDGETS_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_WINDOW))
#define WIDGETS_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_WINDOW))
#define WIDGETS_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_WINDOW, WidgetsWindowClass))

typedef struct _WidgetsWindow WidgetsWindow;
typedef struct _WidgetsWindowClass WidgetsWindowClass;

#define WIDGETS_TYPE_WINDOW_EVENT_AREA (widgets_window_event_area_get_type ())
#define WIDGETS_WINDOW_EVENT_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_WINDOW_EVENT_AREA, WidgetsWindowEventArea))
#define WIDGETS_WINDOW_EVENT_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_WINDOW_EVENT_AREA, WidgetsWindowEventAreaClass))
#define WIDGETS_IS_WINDOW_EVENT_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_WINDOW_EVENT_AREA))
#define WIDGETS_IS_WINDOW_EVENT_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_WINDOW_EVENT_AREA))
#define WIDGETS_WINDOW_EVENT_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_WINDOW_EVENT_AREA, WidgetsWindowEventAreaClass))

typedef struct _WidgetsWindowEventArea WidgetsWindowEventArea;
typedef struct _WidgetsWindowEventAreaClass WidgetsWindowEventAreaClass;

#define WIDGETS_TYPE_CLICK_EVENT_BOX (widgets_click_event_box_get_type ())
#define WIDGETS_CLICK_EVENT_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_CLICK_EVENT_BOX, WidgetsClickEventBox))
#define WIDGETS_CLICK_EVENT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_CLICK_EVENT_BOX, WidgetsClickEventBoxClass))
#define WIDGETS_IS_CLICK_EVENT_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_CLICK_EVENT_BOX))
#define WIDGETS_IS_CLICK_EVENT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_CLICK_EVENT_BOX))
#define WIDGETS_CLICK_EVENT_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_CLICK_EVENT_BOX, WidgetsClickEventBoxClass))

typedef struct _WidgetsClickEventBox WidgetsClickEventBox;
typedef struct _WidgetsClickEventBoxClass WidgetsClickEventBoxClass;

#define WIDGETS_TYPE_WINDOW_BUTTON (widgets_window_button_get_type ())
#define WIDGETS_WINDOW_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_WINDOW_BUTTON, WidgetsWindowButton))
#define WIDGETS_WINDOW_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_WINDOW_BUTTON, WidgetsWindowButtonClass))
#define WIDGETS_IS_WINDOW_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_WINDOW_BUTTON))
#define WIDGETS_IS_WINDOW_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_WINDOW_BUTTON))
#define WIDGETS_WINDOW_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_WINDOW_BUTTON, WidgetsWindowButtonClass))

typedef struct _WidgetsWindowButton WidgetsWindowButton;
typedef struct _WidgetsWindowButtonClass WidgetsWindowButtonClass;

#define WIDGETS_TYPE_WORKSPACE_MANAGER (widgets_workspace_manager_get_type ())
#define WIDGETS_WORKSPACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_WORKSPACE_MANAGER, WidgetsWorkspaceManager))
#define WIDGETS_WORKSPACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_WORKSPACE_MANAGER, WidgetsWorkspaceManagerClass))
#define WIDGETS_IS_WORKSPACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_WORKSPACE_MANAGER))
#define WIDGETS_IS_WORKSPACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_WORKSPACE_MANAGER))
#define WIDGETS_WORKSPACE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_WORKSPACE_MANAGER, WidgetsWorkspaceManagerClass))

typedef struct _WidgetsWorkspaceManager WidgetsWorkspaceManager;
typedef struct _WidgetsWorkspaceManagerClass WidgetsWorkspaceManagerClass;
enum  {
	WIDGETS_APPBAR_0_PROPERTY,
	WIDGETS_APPBAR_NUM_PROPERTIES
};
static GParamSpec* widgets_appbar_properties[WIDGETS_APPBAR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_APPLICATION (application_get_type ())
#define APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APPLICATION, Application))
#define APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APPLICATION, ApplicationClass))
#define IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APPLICATION))
#define IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APPLICATION))
#define APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APPLICATION, ApplicationClass))

typedef struct _Application Application;
typedef struct _ApplicationClass ApplicationClass;

#define TYPE_TERMINAL_APP (terminal_app_get_type ())
#define TERMINAL_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TERMINAL_APP, TerminalApp))
#define TERMINAL_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TERMINAL_APP, TerminalAppClass))
#define IS_TERMINAL_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TERMINAL_APP))
#define IS_TERMINAL_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TERMINAL_APP))
#define TERMINAL_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TERMINAL_APP, TerminalAppClass))

typedef struct _TerminalApp TerminalApp;
typedef struct _TerminalAppClass TerminalAppClass;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define MENU_TYPE_MENU_ITEM (menu_menu_item_get_type ())
#define MENU_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MENU_TYPE_MENU_ITEM, MenuMenuItem))
#define MENU_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MENU_TYPE_MENU_ITEM, MenuMenuItemClass))
#define MENU_IS_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MENU_TYPE_MENU_ITEM))
#define MENU_IS_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MENU_TYPE_MENU_ITEM))
#define MENU_MENU_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MENU_TYPE_MENU_ITEM, MenuMenuItemClass))

typedef struct _MenuMenuItem MenuMenuItem;
typedef struct _MenuMenuItemClass MenuMenuItemClass;
typedef struct _WidgetsConfigWindowPrivate WidgetsConfigWindowPrivate;

#define CONFIG_TYPE_CONFIG (config_config_get_type ())
#define CONFIG_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_CONFIG, ConfigConfig))
#define CONFIG_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_CONFIG, ConfigConfigClass))
#define CONFIG_IS_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_CONFIG))
#define CONFIG_IS_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_CONFIG))
#define CONFIG_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_CONFIG, ConfigConfigClass))

typedef struct _ConfigConfig ConfigConfig;
typedef struct _ConfigConfigClass ConfigConfigClass;
typedef struct _ConfigConfigPrivate ConfigConfigPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _WidgetsWindowEventAreaPrivate WidgetsWindowEventAreaPrivate;
typedef gboolean (*WidgetsWindowEventAreaFilterDoubleClick) (gint x, gint y, gpointer user_data);
typedef struct _WidgetsWorkspaceManagerPrivate WidgetsWorkspaceManagerPrivate;

#define WIDGETS_TYPE_WORKSPACE (widgets_workspace_get_type ())
#define WIDGETS_WORKSPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_WORKSPACE, WidgetsWorkspace))
#define WIDGETS_WORKSPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_WORKSPACE, WidgetsWorkspaceClass))
#define WIDGETS_IS_WORKSPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_WORKSPACE))
#define WIDGETS_IS_WORKSPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_WORKSPACE))
#define WIDGETS_WORKSPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_WORKSPACE, WidgetsWorkspaceClass))

typedef struct _WidgetsWorkspace WidgetsWorkspace;
typedef struct _WidgetsWorkspaceClass WidgetsWorkspaceClass;

#define WIDGETS_TYPE_DIALOG (widgets_dialog_get_type ())
#define WIDGETS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_DIALOG, WidgetsDialog))
#define WIDGETS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_DIALOG, WidgetsDialogClass))
#define WIDGETS_IS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_DIALOG))
#define WIDGETS_IS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_DIALOG))
#define WIDGETS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_DIALOG, WidgetsDialogClass))

typedef struct _WidgetsDialog WidgetsDialog;
typedef struct _WidgetsDialogClass WidgetsDialogClass;

#define WIDGETS_TYPE_ABOUT_DIALOG (widgets_about_dialog_get_type ())
#define WIDGETS_ABOUT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_ABOUT_DIALOG, WidgetsAboutDialog))
#define WIDGETS_ABOUT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_ABOUT_DIALOG, WidgetsAboutDialogClass))
#define WIDGETS_IS_ABOUT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_ABOUT_DIALOG))
#define WIDGETS_IS_ABOUT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_ABOUT_DIALOG))
#define WIDGETS_ABOUT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_ABOUT_DIALOG, WidgetsAboutDialogClass))

typedef struct _WidgetsAboutDialog WidgetsAboutDialog;
typedef struct _WidgetsAboutDialogClass WidgetsAboutDialogClass;

#define WIDGETS_TYPE_PREFERENCE (widgets_preference_get_type ())
#define WIDGETS_PREFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_PREFERENCE, WidgetsPreference))
#define WIDGETS_PREFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_PREFERENCE, WidgetsPreferenceClass))
#define WIDGETS_IS_PREFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_PREFERENCE))
#define WIDGETS_IS_PREFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_PREFERENCE))
#define WIDGETS_PREFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_PREFERENCE, WidgetsPreferenceClass))

typedef struct _WidgetsPreference WidgetsPreference;
typedef struct _WidgetsPreferenceClass WidgetsPreferenceClass;
enum  {
	WIDGETS_APPBAR_CLOSE_WINDOW_SIGNAL,
	WIDGETS_APPBAR_EXIT_TERMINAL_SIGNAL,
	WIDGETS_APPBAR_QUIT_FULLSCREEN_SIGNAL,
	WIDGETS_APPBAR_NUM_SIGNALS
};
static guint widgets_appbar_signals[WIDGETS_APPBAR_NUM_SIGNALS] = {0};

struct _TerminalBusIface {
	GTypeInterface parent_iface;
	void (*exit) (TerminalBus* self, GError** error);
};

struct _WidgetsAppbar {
	GtkOverlay parent_instance;
	WidgetsAppbarPrivate * priv;
	gint height;
	GtkBox* max_toggle_box;
	GtkBox* window_button_box;
	GtkBox* window_close_button_box;
	GtkWidget* focus_widget;
	MenuMenu* menu;
	WidgetsTabbar* tabbar;
	WidgetsWindow* window;
	WidgetsWindowEventArea* event_area;
	WidgetsWindowButton* close_button;
	WidgetsWindowButton* max_button;
	WidgetsWindowButton* menu_button;
	WidgetsWindowButton* min_button;
	WidgetsWindowButton* quit_fullscreen_button;
	WidgetsWindowButton* unmax_button;
	WidgetsWorkspaceManager* workspace_manager;
	gint logo_width;
	gint titlebar_right_cache_width;
	gint menu_button_width;
};

struct _WidgetsAppbarClass {
	GtkOverlayClass parent_class;
};

struct _Block4Data {
	int _ref_count_;
	WidgetsAppbar* self;
	GdkRGBA background_color;
	TerminalApp* app;
};

struct _Block5Data {
	int _ref_count_;
	Block4Data * _data4_;
	TerminalBus* bus;
};

struct _WidgetsConfigWindow {
	GtkWindow parent_instance;
	WidgetsConfigWindowPrivate * priv;
	ConfigConfig* config;
	GdkRGBA title_line_dark_color;
	GdkRGBA title_line_light_color;
	GdkScreen* screen_monitor;
	GtkBox* box;
	GtkBox* top_box;
	GtkBox* window_frame_box;
	GtkBox* window_widget_box;
	WidgetsWorkspaceManager* workspace_manager;
	gboolean quake_mode;
	gboolean show_quake_menu;
	gboolean* config_theme_is_light;
	gint active_tab_underline_width;
	gint active_tab_underline_x;
	gint cache_height;
	gint cache_width;
	gint reset_timeout_delay;
	gint resize_cache_x;
	gint resize_cache_y;
	gint resize_cache_width;
	gint resize_cache_height;
	gint resize_timeout_delay;
	guint* reset_timeout_source_id;
	guint* resize_timeout_source_id;
};

struct _WidgetsConfigWindowClass {
	GtkWindowClass parent_class;
	void (*toggle_fullscreen) (WidgetsConfigWindow* self);
	void (*window_save_before_quit) (WidgetsConfigWindow* self);
	GdkCursorType* (*get_frame_cursor_type) (WidgetsConfigWindow* self, gdouble x, gdouble y);
	void (*update_frame) (WidgetsConfigWindow* self);
	GdkCursorType* (*get_cursor_type) (WidgetsConfigWindow* self, gdouble x, gdouble y);
};

struct _ConfigConfig {
	GObject parent_instance;
	ConfigConfigPrivate * priv;
	GeeArrayList* backspace_key_erase_names;
	GeeArrayList* del_key_erase_names;
	GeeArrayList* encoding_names;
	GeeHashMap* erase_map;
	gdouble default_opacity;
	gint default_size;
	gchar* default_mono_font;
	GKeyFile* config_file;
	gchar* config_file_path;
	gchar* temp_theme;
};

struct _ConfigConfigClass {
	GObjectClass parent_class;
};

struct _WidgetsWindowEventArea {
	GtkEventBox parent_instance;
	WidgetsWindowEventAreaPrivate * priv;
	WidgetsWindowEventAreaFilterDoubleClick filter_double_click_callback;
	gpointer filter_double_click_callback_target;
	GDestroyNotify filter_double_click_callback_target_destroy_notify;
	GtkContainer* drawing_area;
	GtkWidget* child_before_leave;
	gboolean is_double_clicked;
	gboolean is_press;
	gdouble press_x;
	gdouble press_y;
	gint double_clicked_max_delay;
};

struct _WidgetsWindowEventAreaClass {
	GtkEventBoxClass parent_class;
};

struct _WidgetsWorkspaceManager {
	GtkBox parent_instance;
	WidgetsWorkspaceManagerPrivate * priv;
	GeeHashMap* workspace_map;
	WidgetsTabbar* tabbar;
	WidgetsWorkspace* focus_workspace;
	gint workspace_index;
};

struct _WidgetsWorkspaceManagerClass {
	GtkBoxClass parent_class;
};

static gpointer widgets_appbar_parent_class = NULL;
VALA_EXTERN gint constant_TITLEBAR_HEIGHT;
VALA_EXTERN gint constant_WINDOW_BUTTON_WIDHT;
VALA_EXTERN gint constant_CLOSE_BUTTON_MARGIN_RIGHT;
VALA_EXTERN gint constant_CLOSE_BUTTON_WIDTH;

VALA_EXTERN GType terminal_bus_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint terminal_bus_register_object (void* object,
                                    GDBusConnection* connection,
                                    const gchar* path,
                                    GError** error);
VALA_EXTERN GType terminal_bus_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TerminalBus, g_object_unref)
VALA_EXTERN void terminal_bus_exit (TerminalBus* self,
                        GError** error);
static GType terminal_bus_get_type_once (void);
static void terminal_bus_proxy_g_signal (GDBusProxy* proxy,
                                  const gchar* sender_name,
                                  const gchar* signal_name,
                                  GVariant* parameters);
static void _dbus_handle_terminal_bus_quit (TerminalBus* self,
                                     GVariant* parameters);
static void terminal_bus_proxy_exit (TerminalBus* self,
                              GError** error);
static void terminal_bus_proxy_terminal_bus_interface_init (TerminalBusIface* iface);
static void _dbus_terminal_bus_exit (TerminalBus* self,
                              GVariant* _parameters_,
                              GDBusMethodInvocation* invocation);
static void terminal_bus_dbus_interface_method_call (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* method_name,
                                              GVariant* parameters,
                                              GDBusMethodInvocation* invocation,
                                              gpointer user_data);
static GVariant* terminal_bus_dbus_interface_get_property (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* property_name,
                                                    GError** error,
                                                    gpointer user_data);
static gboolean terminal_bus_dbus_interface_set_property (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* property_name,
                                                   GVariant* value,
                                                   GError** error,
                                                   gpointer user_data);
static void _dbus_terminal_bus_quit (GObject* _sender,
                              gpointer* _data);
static void _terminal_bus_unregister_object (gpointer user_data);
VALA_EXTERN GType widgets_appbar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsAppbar, g_object_unref)
VALA_EXTERN GType menu_menu_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MenuMenu, g_object_unref)
VALA_EXTERN GType widgets_tabbar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsTabbar, g_object_unref)
VALA_EXTERN GType widgets_config_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsConfigWindow, g_object_unref)
VALA_EXTERN GType widgets_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsWindow, g_object_unref)
VALA_EXTERN GType widgets_window_event_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsWindowEventArea, g_object_unref)
VALA_EXTERN GType widgets_click_event_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsClickEventBox, g_object_unref)
VALA_EXTERN GType widgets_window_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsWindowButton, g_object_unref)
VALA_EXTERN GType widgets_workspace_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsWorkspaceManager, g_object_unref)
VALA_EXTERN GType application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Application, g_object_unref)
VALA_EXTERN GType terminal_app_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TerminalApp, g_object_unref)
VALA_EXTERN guint terminal_app_register_object (void* object,
                                    GDBusConnection* connection,
                                    const gchar* path,
                                    GError** error);
VALA_EXTERN WidgetsAppbar* widgets_appbar_new (TerminalApp* app,
                                   WidgetsWindow* win,
                                   WidgetsTabbar* tab_bar,
                                   WidgetsWorkspaceManager* manager,
                                   gboolean has_start);
VALA_EXTERN WidgetsAppbar* widgets_appbar_construct (GType object_type,
                                         TerminalApp* app,
                                         WidgetsWindow* win,
                                         WidgetsTabbar* tab_bar,
                                         WidgetsWorkspaceManager* manager,
                                         gboolean has_start);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void ____lambda90_ (WidgetsAppbar* self);
VALA_EXTERN void widgets_config_window_quit (WidgetsConfigWindow* self);
static void _____lambda90__terminal_bus_quit (TerminalBus* _sender,
                                       gpointer self);
static void ____lambda91_ (Block5Data* _data5_);
static void _____lambda91__widgets_appbar_exit_terminal (WidgetsAppbar* _sender,
                                                  gpointer self);
static void ___lambda92_ (Block4Data* _data4_);
VALA_EXTERN void terminal_app_exit (TerminalApp* self);
static void ____lambda92__widgets_appbar_exit_terminal (WidgetsAppbar* _sender,
                                                 gpointer self);
VALA_EXTERN gboolean utils_is_tiling_wm (void);
VALA_EXTERN WidgetsWindowButton* widgets_window_button_new (const gchar* image_path,
                                                gboolean theme_button,
                                                gint width,
                                                gint height);
VALA_EXTERN WidgetsWindowButton* widgets_window_button_construct (GType object_type,
                                                      const gchar* image_path,
                                                      gboolean theme_button,
                                                      gint width,
                                                      gint height);
static void __lambda93_ (WidgetsAppbar* self,
                  GdkEventButton* w);
static void ___lambda93__widgets_click_event_box_clicked (WidgetsClickEventBox* _sender,
                                                   GdkEventButton* event,
                                                   gpointer self);
static void __lambda94_ (WidgetsAppbar* self,
                  GdkEventButton* w);
static void ___lambda94__widgets_click_event_box_clicked (WidgetsClickEventBox* _sender,
                                                   GdkEventButton* event,
                                                   gpointer self);
static void __lambda95_ (WidgetsAppbar* self,
                  GdkEventButton* b);
VALA_EXTERN GType menu_menu_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MenuMenuItem, g_object_unref)
VALA_EXTERN MenuMenuItem* menu_menu_item_new (const gchar* item_id,
                                  const gchar* item_text);
VALA_EXTERN MenuMenuItem* menu_menu_item_construct (GType object_type,
                                        const gchar* item_id,
                                        const gchar* item_text);
VALA_EXTERN gboolean utils_is_command_exist (const gchar* command_name);
VALA_EXTERN MenuMenu* menu_menu_new (void);
VALA_EXTERN MenuMenu* menu_menu_construct (GType object_type);
VALA_EXTERN void widgets_appbar_handle_menu_item_click (WidgetsAppbar* self,
                                            const gchar* item_id);
static void _widgets_appbar_handle_menu_item_click_menu_menu_click_item (MenuMenu* _sender,
                                                                  const gchar* item_id,
                                                                  gpointer self);
VALA_EXTERN void widgets_appbar_handle_menu_destroy (WidgetsAppbar* self);
static void _widgets_appbar_handle_menu_destroy_menu_menu_destroy (MenuMenu* _sender,
                                                            gpointer self);
VALA_EXTERN GType config_config_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigConfig, g_object_unref)
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN void menu_menu_set_prefer_deepin_menu (MenuMenu* self,
                                       gboolean _prefer_deepin_menu);
VALA_EXTERN void menu_menu_popup_at_position (MenuMenu* self,
                                  GList* menu_content,
                                  gint x,
                                  gint y);
static void ___lambda95__widgets_click_event_box_clicked (WidgetsClickEventBox* _sender,
                                                   GdkEventButton* event,
                                                   gpointer self);
static void __lambda182_ (WidgetsAppbar* self,
                   WidgetsClickEventBox* w,
                   GdkEventButton* e);
static void ___lambda182__widgets_click_event_box_clicked (WidgetsClickEventBox* _sender,
                                                    GdkEventButton* event,
                                                    gpointer self);
static void __lambda183_ (WidgetsAppbar* self,
                   WidgetsClickEventBox* w,
                   GdkEventButton* e);
static void ___lambda183__widgets_click_event_box_clicked (WidgetsClickEventBox* _sender,
                                                    GdkEventButton* event,
                                                    gpointer self);
static void __lambda184_ (WidgetsAppbar* self,
                   WidgetsClickEventBox* w,
                   GdkEventButton* e);
static void ___lambda184__widgets_click_event_box_clicked (WidgetsClickEventBox* _sender,
                                                    GdkEventButton* event,
                                                    gpointer self);
VALA_EXTERN gchar* utils_get_image_path (const gchar* image_name);
VALA_EXTERN void widgets_appbar_show_window_button (WidgetsAppbar* self);
VALA_EXTERN WidgetsWindowEventArea* widgets_window_event_area_new (GtkContainer* area);
VALA_EXTERN WidgetsWindowEventArea* widgets_window_event_area_construct (GType object_type,
                                                             GtkContainer* area);
static gboolean __lambda185_ (WidgetsAppbar* self,
                       gint x,
                       gint y);
VALA_EXTERN gint widgets_tabbar_is_at_tab_close_button (WidgetsTabbar* self,
                                            gint x);
static gboolean ___lambda185__widgets_window_event_area_filter_double_click (gint x,
                                                                      gint y,
                                                                      gpointer self);
static gboolean __lambda186_ (Block4Data* _data4_,
                       GtkWidget* w,
                       cairo_t* cr);
VALA_EXTERN void utils_hex_to_rgba (const gchar* hex_color,
                        gdouble alpha,
                        GdkRGBA* result);
VALA_EXTERN gboolean widgets_config_window_window_is_fullscreen (WidgetsConfigWindow* self);
VALA_EXTERN void draw_draw_rectangle (cairo_t* cr,
                          gint x,
                          gint y,
                          gint w,
                          gint h,
                          gboolean fill);
VALA_EXTERN void utils_propagate_draw (GtkContainer* widget,
                           cairo_t* cr);
static gboolean ___lambda186__gtk_widget_draw (GtkWidget* _sender,
                                        cairo_t* cr,
                                        gpointer self);
VALA_EXTERN void utils_remove_all_children (GtkContainer* container);
VALA_EXTERN void widgets_appbar_hide_window_button (WidgetsAppbar* self);
VALA_EXTERN GType widgets_workspace_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsWorkspace, g_object_unref)
VALA_EXTERN void widgets_workspace_show_command_panel (WidgetsWorkspace* self,
                                           WidgetsWorkspace* workspace);
VALA_EXTERN void widgets_workspace_show_remote_panel (WidgetsWorkspace* self,
                                          WidgetsWorkspace* workspace);
VALA_EXTERN void widgets_workspace_show_theme_panel (WidgetsWorkspace* self,
                                         WidgetsWorkspace* workspace);
VALA_EXTERN void utils_show_manual (void);
VALA_EXTERN GType widgets_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsDialog, g_object_unref)
VALA_EXTERN GType widgets_about_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsAboutDialog, g_object_unref)
VALA_EXTERN WidgetsAboutDialog* widgets_about_dialog_new (GtkWidget* widget);
VALA_EXTERN WidgetsAboutDialog* widgets_about_dialog_construct (GType object_type,
                                                    GtkWidget* widget);
VALA_EXTERN void widgets_dialog_transient_for_window (WidgetsDialog* self,
                                          WidgetsConfigWindow* window);
VALA_EXTERN GType widgets_preference_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsPreference, g_object_unref)
VALA_EXTERN WidgetsPreference* widgets_preference_new (WidgetsConfigWindow* window,
                                           GtkWidget* widget);
VALA_EXTERN WidgetsPreference* widgets_preference_construct (GType object_type,
                                                 WidgetsConfigWindow* window,
                                                 GtkWidget* widget);
VALA_EXTERN void widgets_appbar_update_max_button (WidgetsAppbar* self);
VALA_EXTERN gboolean widgets_config_window_window_is_max (WidgetsConfigWindow* self);
static void widgets_appbar_finalize (GObject * obj);
static GType widgets_appbar_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const GDBusArgInfo * const _terminal_bus_dbus_arg_info_exit_in[] = {NULL};
static const GDBusArgInfo * const _terminal_bus_dbus_arg_info_exit_out[] = {NULL};
static const GDBusMethodInfo _terminal_bus_dbus_method_info_exit = {-1, "Exit", (GDBusArgInfo **) (&_terminal_bus_dbus_arg_info_exit_in), (GDBusArgInfo **) (&_terminal_bus_dbus_arg_info_exit_out), NULL};
static const GDBusMethodInfo * const _terminal_bus_dbus_method_info[] = {&_terminal_bus_dbus_method_info_exit, NULL};
static const GDBusArgInfo * const _terminal_bus_dbus_arg_info_quit[] = {NULL};
static const GDBusSignalInfo _terminal_bus_dbus_signal_info_quit = {-1, "Quit", (GDBusArgInfo **) (&_terminal_bus_dbus_arg_info_quit), NULL};
static const GDBusSignalInfo * const _terminal_bus_dbus_signal_info[] = {&_terminal_bus_dbus_signal_info_quit, NULL};
static const GDBusPropertyInfo * const _terminal_bus_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _terminal_bus_dbus_interface_info = {-1, "com.deepin.terminal", (GDBusMethodInfo **) (&_terminal_bus_dbus_method_info), (GDBusSignalInfo **) (&_terminal_bus_dbus_signal_info), (GDBusPropertyInfo **) (&_terminal_bus_dbus_property_info), NULL};
static const GDBusInterfaceVTable _terminal_bus_dbus_interface_vtable = {terminal_bus_dbus_interface_method_call, terminal_bus_dbus_interface_get_property, terminal_bus_dbus_interface_set_property};

void
terminal_bus_exit (TerminalBus* self,
                   GError** error)
{
	TerminalBusIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = TERMINAL_BUS_GET_INTERFACE (self);
	if (_iface_->exit) {
		_iface_->exit (self, error);
	}
}

static void
terminal_bus_default_init (TerminalBusIface * iface,
                           gpointer iface_data)
{
	terminal_bus_signals[TERMINAL_BUS_QUIT_SIGNAL] = g_signal_new ("quit", TYPE_TERMINAL_BUS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static GType
terminal_bus_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TerminalBusIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) terminal_bus_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType terminal_bus_type_id;
	terminal_bus_type_id = g_type_register_static (G_TYPE_INTERFACE, "TerminalBus", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (terminal_bus_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (terminal_bus_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) terminal_bus_proxy_get_type);
	g_type_set_qdata (terminal_bus_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "com.deepin.terminal");
	g_type_set_qdata (terminal_bus_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_terminal_bus_dbus_interface_info));
	g_type_set_qdata (terminal_bus_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) terminal_bus_register_object);
	return terminal_bus_type_id;
}

GType
terminal_bus_get_type (void)
{
	static volatile gsize terminal_bus_type_id__once = 0;
	if (g_once_init_enter (&terminal_bus_type_id__once)) {
		GType terminal_bus_type_id;
		terminal_bus_type_id = terminal_bus_get_type_once ();
		g_once_init_leave (&terminal_bus_type_id__once, terminal_bus_type_id);
	}
	return terminal_bus_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (TerminalBusProxy, terminal_bus_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_TERMINAL_BUS, terminal_bus_proxy_terminal_bus_interface_init) )
static void
terminal_bus_proxy_class_init (TerminalBusProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = terminal_bus_proxy_g_signal;
}

static void
_dbus_handle_terminal_bus_quit (TerminalBus* self,
                                GVariant* parameters)
{
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "quit");
}

static void
terminal_bus_proxy_g_signal (GDBusProxy* proxy,
                             const gchar* sender_name,
                             const gchar* signal_name,
                             GVariant* parameters)
{
	if (strcmp (signal_name, "Quit") == 0) {
		_dbus_handle_terminal_bus_quit ((TerminalBus*) proxy, parameters);
	}
}

static void
terminal_bus_proxy_init (TerminalBusProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_terminal_bus_dbus_interface_info));
}

static void
terminal_bus_proxy_exit (TerminalBus* self,
                         GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.deepin.terminal", "Exit");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
terminal_bus_proxy_terminal_bus_interface_init (TerminalBusIface* iface)
{
	iface->exit = terminal_bus_proxy_exit;
}

static void
_dbus_terminal_bus_exit (TerminalBus* self,
                         GVariant* _parameters_,
                         GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	terminal_bus_exit (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
terminal_bus_dbus_interface_method_call (GDBusConnection* connection,
                                         const gchar* sender,
                                         const gchar* object_path,
                                         const gchar* interface_name,
                                         const gchar* method_name,
                                         GVariant* parameters,
                                         GDBusMethodInvocation* invocation,
                                         gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Exit") == 0) {
		_dbus_terminal_bus_exit (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
terminal_bus_dbus_interface_get_property (GDBusConnection* connection,
                                          const gchar* sender,
                                          const gchar* object_path,
                                          const gchar* interface_name,
                                          const gchar* property_name,
                                          GError** error,
                                          gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
terminal_bus_dbus_interface_set_property (GDBusConnection* connection,
                                          const gchar* sender,
                                          const gchar* object_path,
                                          const gchar* interface_name,
                                          const gchar* property_name,
                                          GVariant* value,
                                          GError** error,
                                          gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_terminal_bus_quit (GObject* _sender,
                         gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.deepin.terminal", "Quit", _arguments, NULL);
}

guint
terminal_bus_register_object (gpointer object,
                              GDBusConnection* connection,
                              const gchar* path,
                              GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_terminal_bus_dbus_interface_info), &_terminal_bus_dbus_interface_vtable, data, _terminal_bus_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "quit", (GCallback) _dbus_terminal_bus_quit, data);
	return result;
}

static void
_terminal_bus_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_terminal_bus_quit, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		WidgetsAppbar* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->app);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		WidgetsAppbar* self;
		self = _data5_->_data4_->self;
		_g_object_unref0 (_data5_->bus);
		block4_data_unref (_data5_->_data4_);
		_data5_->_data4_ = NULL;
		g_slice_free (Block5Data, _data5_);
	}
}

static void
____lambda90_ (WidgetsAppbar* self)
{
	WidgetsWindow* _tmp0_;
	_tmp0_ = self->window;
	widgets_config_window_quit ((WidgetsConfigWindow*) _tmp0_);
}

static void
_____lambda90__terminal_bus_quit (TerminalBus* _sender,
                                  gpointer self)
{
	____lambda90_ ((WidgetsAppbar*) self);
}

static void
____lambda91_ (Block5Data* _data5_)
{
	Block4Data* _data4_;
	WidgetsAppbar* self;
	GError* _inner_error0_ = NULL;
	_data4_ = _data5_->_data4_;
	self = _data4_->self;
	{
		TerminalBus* _tmp0_;
		_tmp0_ = _data5_->bus;
		terminal_bus_exit (_tmp0_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = stderr;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		fprintf (_tmp1_, "AppBar bus.ext: %s\n", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
_____lambda91__widgets_appbar_exit_terminal (WidgetsAppbar* _sender,
                                             gpointer self)
{
	____lambda91_ (self);
}

static void
___lambda92_ (Block4Data* _data4_)
{
	WidgetsAppbar* self;
	self = _data4_->self;
	terminal_app_exit (_data4_->app);
}

static void
____lambda92__widgets_appbar_exit_terminal (WidgetsAppbar* _sender,
                                            gpointer self)
{
	___lambda92_ (self);
}

static void
__lambda93_ (WidgetsAppbar* self,
             GdkEventButton* w)
{
	g_return_if_fail (w != NULL);
	g_signal_emit (self, widgets_appbar_signals[WIDGETS_APPBAR_CLOSE_WINDOW_SIGNAL], 0);
}

static void
___lambda93__widgets_click_event_box_clicked (WidgetsClickEventBox* _sender,
                                              GdkEventButton* event,
                                              gpointer self)
{
	__lambda93_ ((WidgetsAppbar*) self, event);
}

static void
__lambda94_ (WidgetsAppbar* self,
             GdkEventButton* w)
{
	g_return_if_fail (w != NULL);
	g_signal_emit (self, widgets_appbar_signals[WIDGETS_APPBAR_QUIT_FULLSCREEN_SIGNAL], 0);
}

static void
___lambda94__widgets_click_event_box_clicked (WidgetsClickEventBox* _sender,
                                              GdkEventButton* event,
                                              gpointer self)
{
	__lambda94_ ((WidgetsAppbar*) self, event);
}

static void
_widgets_appbar_handle_menu_item_click_menu_menu_click_item (MenuMenu* _sender,
                                                             const gchar* item_id,
                                                             gpointer self)
{
	widgets_appbar_handle_menu_item_click ((WidgetsAppbar*) self, item_id);
}

static void
_widgets_appbar_handle_menu_destroy_menu_menu_destroy (MenuMenu* _sender,
                                                       gpointer self)
{
	widgets_appbar_handle_menu_destroy ((WidgetsAppbar*) self);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
__lambda95_ (WidgetsAppbar* self,
             GdkEventButton* b)
{
	WidgetsWindowButton* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	GList* menu_content = NULL;
	MenuMenuItem* _tmp4_;
	MenuMenuItem* _tmp5_;
	MenuMenuItem* _tmp6_;
	MenuMenuItem* _tmp7_;
	MenuMenuItem* _tmp8_;
	MenuMenuItem* _tmp9_;
	MenuMenuItem* _tmp11_;
	MenuMenuItem* _tmp12_;
	gint menu_x = 0;
	gint menu_y = 0;
	WidgetsWindowButton* _tmp13_;
	WidgetsWindowButton* _tmp14_;
	GtkWidget* _tmp15_;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	GtkAllocation menu_rect = {0};
	WidgetsWindowButton* _tmp18_;
	GtkAllocation _tmp19_ = {0};
	gint window_x = 0;
	gint window_y = 0;
	WidgetsWindowButton* _tmp20_;
	GtkWidget* _tmp21_;
	GdkWindow* _tmp22_;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	MenuMenu* _tmp25_;
	MenuMenu* _tmp26_;
	MenuMenu* _tmp27_;
	gboolean _tmp28_ = FALSE;
	WidgetsWindow* _tmp29_;
	ConfigConfig* _tmp30_;
	GKeyFile* _tmp31_;
	MenuMenu* _tmp32_;
	MenuMenu* _tmp33_;
	GList* _tmp34_;
	GtkAllocation _tmp35_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (b != NULL);
	_tmp0_ = self->menu_button;
	_tmp1_ = gtk_widget_get_toplevel ((GtkWidget*) _tmp0_);
	_tmp2_ = gtk_window_get_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_window_get_type (), GtkWindow));
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->focus_widget);
	self->focus_widget = _tmp3_;
	menu_content = NULL;
	_tmp4_ = menu_menu_item_new ("new_window", _ ("New window"));
	menu_content = g_list_append (menu_content, _tmp4_);
	_tmp5_ = menu_menu_item_new ("switch_theme", _ ("Switch theme"));
	menu_content = g_list_append (menu_content, _tmp5_);
	_tmp6_ = menu_menu_item_new ("custom_commands", _ ("Custom commands"));
	menu_content = g_list_append (menu_content, _tmp6_);
	_tmp7_ = menu_menu_item_new ("remote_manage", _ ("Remote management"));
	menu_content = g_list_append (menu_content, _tmp7_);
	_tmp8_ = menu_menu_item_new ("", "");
	menu_content = g_list_append (menu_content, _tmp8_);
	_tmp9_ = menu_menu_item_new ("preference", _ ("Settings"));
	menu_content = g_list_append (menu_content, _tmp9_);
	if (utils_is_command_exist ("dman")) {
		MenuMenuItem* _tmp10_;
		_tmp10_ = menu_menu_item_new ("help", _ ("Help"));
		menu_content = g_list_append (menu_content, _tmp10_);
	}
	_tmp11_ = menu_menu_item_new ("about", _ ("About"));
	menu_content = g_list_append (menu_content, _tmp11_);
	_tmp12_ = menu_menu_item_new ("exit", _ ("Exit"));
	menu_content = g_list_append (menu_content, _tmp12_);
	_tmp13_ = self->menu_button;
	_tmp14_ = self->menu_button;
	_tmp15_ = gtk_widget_get_toplevel ((GtkWidget*) _tmp14_);
	gtk_widget_translate_coordinates ((GtkWidget*) _tmp13_, _tmp15_, 0, 0, &_tmp16_, &_tmp17_);
	menu_x = _tmp16_;
	menu_y = _tmp17_;
	_tmp18_ = self->menu_button;
	gtk_widget_get_allocation ((GtkWidget*) _tmp18_, &_tmp19_);
	menu_rect = _tmp19_;
	_tmp20_ = self->menu_button;
	_tmp21_ = gtk_widget_get_toplevel ((GtkWidget*) _tmp20_);
	_tmp22_ = gtk_widget_get_window (_tmp21_);
	gdk_window_get_origin (_tmp22_, &_tmp23_, &_tmp24_);
	window_x = _tmp23_;
	window_y = _tmp24_;
	_tmp25_ = menu_menu_new ();
	_g_object_unref0 (self->menu);
	self->menu = _tmp25_;
	_tmp26_ = self->menu;
	g_signal_connect_object (_tmp26_, "click-item", (GCallback) _widgets_appbar_handle_menu_item_click_menu_menu_click_item, self, 0);
	_tmp27_ = self->menu;
	g_signal_connect_object (_tmp27_, "destroy", (GCallback) _widgets_appbar_handle_menu_destroy_menu_menu_destroy, self, 0);
	_tmp29_ = self->window;
	_tmp30_ = ((WidgetsConfigWindow*) _tmp29_)->config;
	_tmp31_ = _tmp30_->config_file;
	_tmp28_ = g_key_file_get_boolean (_tmp31_, "advanced", "prefer_deepin_menu", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		(menu_content == NULL) ? NULL : (menu_content = (_g_list_free__g_object_unref0_ (menu_content), NULL));
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp32_ = self->menu;
	menu_menu_set_prefer_deepin_menu (_tmp32_, _tmp28_);
	_tmp33_ = self->menu;
	_tmp34_ = menu_content;
	_tmp35_ = menu_rect;
	menu_menu_popup_at_position (_tmp33_, _tmp34_, window_x + menu_x, (window_y + menu_y) + _tmp35_.height);
	(menu_content == NULL) ? NULL : (menu_content = (_g_list_free__g_object_unref0_ (menu_content), NULL));
}

static void
___lambda95__widgets_click_event_box_clicked (WidgetsClickEventBox* _sender,
                                              GdkEventButton* event,
                                              gpointer self)
{
	__lambda95_ ((WidgetsAppbar*) self, event);
}

static void
__lambda182_ (WidgetsAppbar* self,
              WidgetsClickEventBox* w,
              GdkEventButton* e)
{
	GtkWidget* _tmp0_;
	g_return_if_fail (w != NULL);
	g_return_if_fail (e != NULL);
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) w);
	gtk_window_iconify (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_window_get_type (), GtkWindow));
}

static void
___lambda182__widgets_click_event_box_clicked (WidgetsClickEventBox* _sender,
                                               GdkEventButton* event,
                                               gpointer self)
{
	__lambda182_ ((WidgetsAppbar*) self, _sender, event);
}

static void
__lambda183_ (WidgetsAppbar* self,
              WidgetsClickEventBox* w,
              GdkEventButton* e)
{
	GtkWidget* _tmp0_;
	g_return_if_fail (w != NULL);
	g_return_if_fail (e != NULL);
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) w);
	gtk_window_maximize (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_window_get_type (), GtkWindow));
}

static void
___lambda183__widgets_click_event_box_clicked (WidgetsClickEventBox* _sender,
                                               GdkEventButton* event,
                                               gpointer self)
{
	__lambda183_ ((WidgetsAppbar*) self, _sender, event);
}

static void
__lambda184_ (WidgetsAppbar* self,
              WidgetsClickEventBox* w,
              GdkEventButton* e)
{
	GtkWidget* _tmp0_;
	g_return_if_fail (w != NULL);
	g_return_if_fail (e != NULL);
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) w);
	gtk_window_unmaximize (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_window_get_type (), GtkWindow));
}

static void
___lambda184__widgets_click_event_box_clicked (WidgetsClickEventBox* _sender,
                                               GdkEventButton* event,
                                               gpointer self)
{
	__lambda184_ ((WidgetsAppbar*) self, _sender, event);
}

static gboolean
__lambda185_ (WidgetsAppbar* self,
              gint x,
              gint y)
{
	gint tabbar_x = 0;
	gint tabbar_y = 0;
	WidgetsTabbar* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	WidgetsTabbar* _tmp3_;
	gboolean result;
	_tmp0_ = self->tabbar;
	gtk_widget_translate_coordinates ((GtkWidget*) self, (GtkWidget*) _tmp0_, x, y, &_tmp1_, &_tmp2_);
	tabbar_x = _tmp1_;
	tabbar_y = _tmp2_;
	_tmp3_ = self->tabbar;
	result = widgets_tabbar_is_at_tab_close_button (_tmp3_, (gint) tabbar_x) != -1;
	return result;
}

static gboolean
___lambda185__widgets_window_event_area_filter_double_click (gint x,
                                                             gint y,
                                                             gpointer self)
{
	gboolean result;
	result = __lambda185_ ((WidgetsAppbar*) self, x, y);
	return result;
}

static gboolean
__lambda186_ (Block4Data* _data4_,
              GtkWidget* w,
              cairo_t* cr)
{
	WidgetsAppbar* self;
	GtkAllocation rect = {0};
	GtkAllocation _tmp0_ = {0};
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = _data4_->self;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (cr != NULL, FALSE);
	gtk_widget_get_allocation (w, &_tmp0_);
	rect = _tmp0_;
	{
		gchar* _tmp1_ = NULL;
		WidgetsWindow* _tmp2_;
		ConfigConfig* _tmp3_;
		GKeyFile* _tmp4_;
		gchar* _tmp5_;
		GdkRGBA _tmp6_ = {0};
		WidgetsWindow* _tmp7_;
		GtkAllocation _tmp18_;
		_tmp2_ = self->window;
		_tmp3_ = ((WidgetsConfigWindow*) _tmp2_)->config;
		_tmp4_ = _tmp3_->config_file;
		_tmp5_ = g_key_file_get_string (_tmp4_, "theme", "background", &_inner_error0_);
		_tmp1_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		utils_hex_to_rgba (_tmp1_, 1.0, &_tmp6_);
		_data4_->background_color = _tmp6_;
		_tmp7_ = self->window;
		if (widgets_config_window_window_is_fullscreen ((WidgetsConfigWindow*) _tmp7_)) {
			GdkRGBA _tmp8_;
			GdkRGBA _tmp9_;
			GdkRGBA _tmp10_;
			_tmp8_ = _data4_->background_color;
			_tmp9_ = _data4_->background_color;
			_tmp10_ = _data4_->background_color;
			cairo_set_source_rgba (cr, _tmp8_.red, _tmp9_.green, _tmp10_.blue, 0.8);
		} else {
			gdouble _tmp11_ = 0.0;
			WidgetsWindow* _tmp12_;
			ConfigConfig* _tmp13_;
			GKeyFile* _tmp14_;
			GdkRGBA _tmp15_;
			GdkRGBA _tmp16_;
			GdkRGBA _tmp17_;
			_tmp12_ = self->window;
			_tmp13_ = ((WidgetsConfigWindow*) _tmp12_)->config;
			_tmp14_ = _tmp13_->config_file;
			_tmp11_ = g_key_file_get_double (_tmp14_, "general", "opacity", &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (_tmp1_);
				goto __catch0_g_error;
			}
			_tmp15_ = _data4_->background_color;
			_tmp16_ = _data4_->background_color;
			_tmp17_ = _data4_->background_color;
			cairo_set_source_rgba (cr, _tmp15_.red, _tmp16_.green, _tmp17_.blue, _tmp11_);
		}
		_tmp18_ = rect;
		draw_draw_rectangle (cr, 0, 0, _tmp18_.width, constant_TITLEBAR_HEIGHT, TRUE);
		_g_free0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp19_;
		const gchar* _tmp20_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		g_print ("Main window: %s\n", _tmp20_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp21_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp21_;
	}
	utils_propagate_draw (G_TYPE_CHECK_INSTANCE_CAST (w, gtk_container_get_type (), GtkContainer), cr);
	result = TRUE;
	return result;
}

static gboolean
___lambda186__gtk_widget_draw (GtkWidget* _sender,
                               cairo_t* cr,
                               gpointer self)
{
	gboolean result;
	result = __lambda186_ (self, _sender, cr);
	return result;
}

WidgetsAppbar*
widgets_appbar_construct (GType object_type,
                          TerminalApp* app,
                          WidgetsWindow* win,
                          WidgetsTabbar* tab_bar,
                          WidgetsWorkspaceManager* manager,
                          gboolean has_start)
{
	WidgetsAppbar * self = NULL;
	Block4Data* _data4_;
	TerminalApp* _tmp0_;
	WidgetsWindow* _tmp1_;
	WidgetsWorkspaceManager* _tmp2_;
	WidgetsTabbar* _tmp10_;
	GtkBox* _tmp11_;
	GtkBox* _tmp12_;
	WidgetsWindowButton* _tmp13_;
	WidgetsWindowButton* _tmp14_;
	WidgetsWindowButton* _tmp15_;
	WidgetsWindowButton* _tmp16_;
	WidgetsWindowButton* _tmp17_;
	WidgetsWindowButton* _tmp18_;
	WidgetsWindowButton* _tmp19_;
	WidgetsWindowButton* _tmp20_;
	WidgetsWindowButton* _tmp21_;
	GtkBox* _tmp22_;
	WidgetsWindowButton* _tmp23_;
	WidgetsWindowButton* _tmp24_;
	WidgetsWindowButton* _tmp25_;
	GtkBox* box = NULL;
	GtkBox* _tmp26_;
	GtkBox* logo_box = NULL;
	GtkBox* _tmp27_;
	GtkImage* logo_image = NULL;
	gchar* _tmp28_;
	gchar* _tmp29_;
	GtkImage* _tmp30_;
	GtkImage* _tmp31_;
	GtkBox* _tmp32_;
	WidgetsWindowButton* _tmp33_;
	WidgetsTabbar* _tmp34_;
	GtkEventBox* cache_area = NULL;
	GtkEventBox* _tmp35_;
	GtkBox* _tmp36_;
	GtkBox* _tmp37_;
	WidgetsWindowEventArea* _tmp38_;
	WidgetsWindowEventArea* _tmp39_;
	WidgetsWindowEventArea* _tmp40_;
	WidgetsWindowEventArea* _tmp41_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (app != NULL, NULL);
	g_return_val_if_fail (win != NULL, NULL);
	g_return_val_if_fail (tab_bar != NULL, NULL);
	g_return_val_if_fail (manager != NULL, NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (app);
	_g_object_unref0 (_data4_->app);
	_data4_->app = _tmp0_;
	self = (WidgetsAppbar*) g_object_new (object_type, NULL);
	_data4_->self = g_object_ref (self);
	bindtextdomain (GETTEXT_PACKAGE, "/usr/share/locale");
	_tmp1_ = _g_object_ref0 (win);
	_g_object_unref0 (self->window);
	self->window = _tmp1_;
	_tmp2_ = _g_object_ref0 (manager);
	_g_object_unref0 (self->workspace_manager);
	self->workspace_manager = _tmp2_;
	gtk_widget_set_size_request ((GtkWidget*) self, -1, self->height);
	if (has_start) {
		Block5Data* _data5_;
		_data5_ = g_slice_new0 (Block5Data);
		_data5_->_ref_count_ = 1;
		_data5_->_data4_ = block4_data_ref (_data4_);
		_data5_->bus = NULL;
		{
			TerminalBus* _tmp3_ = NULL;
			TerminalBus* _tmp4_;
			TerminalBus* _tmp5_;
			TerminalBus* _tmp6_;
			_tmp4_ = (TerminalBus*) g_initable_new (TYPE_TERMINAL_BUS_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", "com.deepin.terminal", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/com/deepin/terminal", "g-interface-name", "com.deepin.terminal", NULL);
			_tmp3_ = (TerminalBus*) _tmp4_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp5_ = _tmp3_;
			_tmp3_ = NULL;
			_g_object_unref0 (_data5_->bus);
			_data5_->bus = _tmp5_;
			_tmp6_ = _data5_->bus;
			g_signal_connect_object (_tmp6_, "quit", (GCallback) _____lambda90__terminal_bus_quit, self, 0);
			g_signal_connect_data (self, "exit-terminal", (GCallback) _____lambda91__widgets_appbar_exit_terminal, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
			_g_object_unref0 (_tmp3_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			FILE* _tmp7_;
			GError* _tmp8_;
			const gchar* _tmp9_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp7_ = stderr;
			_tmp8_ = e;
			_tmp9_ = _tmp8_->message;
			fprintf (_tmp7_, "AppBar bus own: %s\n", _tmp9_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			block5_data_unref (_data5_);
			_data5_ = NULL;
			block4_data_unref (_data4_);
			_data4_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		block5_data_unref (_data5_);
		_data5_ = NULL;
	} else {
		g_signal_connect_data (self, "exit-terminal", (GCallback) ____lambda92__widgets_appbar_exit_terminal, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	}
	_tmp10_ = _g_object_ref0 (tab_bar);
	_g_object_unref0 (self->tabbar);
	self->tabbar = _tmp10_;
	_tmp11_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->window_button_box);
	self->window_button_box = _tmp11_;
	_tmp12_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->window_close_button_box);
	self->window_close_button_box = _tmp12_;
	if (utils_is_tiling_wm ()) {
		self->menu_button_width = 0;
	}
	_tmp13_ = widgets_window_button_new ("window_menu", TRUE, self->menu_button_width, constant_TITLEBAR_HEIGHT);
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->menu_button);
	self->menu_button = _tmp13_;
	_tmp14_ = widgets_window_button_new ("window_min", TRUE, self->menu_button_width, constant_TITLEBAR_HEIGHT);
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->min_button);
	self->min_button = _tmp14_;
	_tmp15_ = widgets_window_button_new ("window_max", TRUE, self->menu_button_width, constant_TITLEBAR_HEIGHT);
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->max_button);
	self->max_button = _tmp15_;
	_tmp16_ = widgets_window_button_new ("window_unmax", TRUE, self->menu_button_width, constant_TITLEBAR_HEIGHT);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->unmax_button);
	self->unmax_button = _tmp16_;
	_tmp17_ = widgets_window_button_new ("window_close", TRUE, self->menu_button_width + constant_CLOSE_BUTTON_MARGIN_RIGHT, constant_TITLEBAR_HEIGHT);
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->close_button);
	self->close_button = _tmp17_;
	_tmp18_ = widgets_window_button_new ("quit_fullscreen", TRUE, constant_WINDOW_BUTTON_WIDHT + constant_CLOSE_BUTTON_MARGIN_RIGHT, constant_TITLEBAR_HEIGHT);
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->quit_fullscreen_button);
	self->quit_fullscreen_button = _tmp18_;
	_tmp19_ = self->close_button;
	g_signal_connect_object ((WidgetsClickEventBox*) _tmp19_, "clicked", (GCallback) ___lambda93__widgets_click_event_box_clicked, self, 0);
	_tmp20_ = self->quit_fullscreen_button;
	g_signal_connect_object ((WidgetsClickEventBox*) _tmp20_, "clicked", (GCallback) ___lambda94__widgets_click_event_box_clicked, self, 0);
	_tmp21_ = self->menu_button;
	g_signal_connect_object ((WidgetsClickEventBox*) _tmp21_, "clicked", (GCallback) ___lambda95__widgets_click_event_box_clicked, self, 0);
	_tmp22_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->max_toggle_box);
	self->max_toggle_box = _tmp22_;
	_tmp23_ = self->min_button;
	g_signal_connect_object ((WidgetsClickEventBox*) _tmp23_, "clicked", (GCallback) ___lambda182__widgets_click_event_box_clicked, self, 0);
	_tmp24_ = self->max_button;
	g_signal_connect_object ((WidgetsClickEventBox*) _tmp24_, "clicked", (GCallback) ___lambda183__widgets_click_event_box_clicked, self, 0);
	_tmp25_ = self->unmax_button;
	g_signal_connect_object ((WidgetsClickEventBox*) _tmp25_, "clicked", (GCallback) ___lambda184__widgets_click_event_box_clicked, self, 0);
	_tmp26_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp26_);
	box = _tmp26_;
	_tmp27_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp27_);
	logo_box = _tmp27_;
	gtk_widget_set_size_request ((GtkWidget*) logo_box, self->logo_width, constant_TITLEBAR_HEIGHT);
	_tmp28_ = utils_get_image_path ("title_icon.svg");
	_tmp29_ = _tmp28_;
	_tmp30_ = (GtkImage*) gtk_image_new_from_file (_tmp29_);
	g_object_ref_sink (_tmp30_);
	_tmp31_ = _tmp30_;
	_g_free0 (_tmp29_);
	logo_image = _tmp31_;
	gtk_box_pack_start (logo_box, (GtkWidget*) logo_image, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start (box, (GtkWidget*) logo_box, FALSE, FALSE, (guint) 0);
	_tmp32_ = self->max_toggle_box;
	_tmp33_ = self->max_button;
	gtk_container_add ((GtkContainer*) _tmp32_, (GtkWidget*) _tmp33_);
	_tmp34_ = self->tabbar;
	gtk_box_pack_start (box, (GtkWidget*) _tmp34_, TRUE, TRUE, (guint) 0);
	_tmp35_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp35_);
	cache_area = _tmp35_;
	gtk_widget_set_size_request ((GtkWidget*) cache_area, self->titlebar_right_cache_width, -1);
	gtk_box_pack_start (box, (GtkWidget*) cache_area, FALSE, FALSE, (guint) 0);
	_tmp36_ = self->window_button_box;
	gtk_box_pack_start (box, (GtkWidget*) _tmp36_, FALSE, FALSE, (guint) 0);
	_tmp37_ = self->window_close_button_box;
	gtk_box_pack_start (box, (GtkWidget*) _tmp37_, FALSE, FALSE, (guint) 0);
	widgets_appbar_show_window_button (self);
	_tmp38_ = widgets_window_event_area_new ((GtkContainer*) self);
	g_object_ref_sink (_tmp38_);
	_g_object_unref0 (self->event_area);
	self->event_area = _tmp38_;
	_tmp39_ = self->event_area;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp39_, constant_CLOSE_BUTTON_WIDTH * 4);
	_tmp40_ = self->event_area;
	(_tmp40_->filter_double_click_callback_target_destroy_notify == NULL) ? NULL : (_tmp40_->filter_double_click_callback_target_destroy_notify (_tmp40_->filter_double_click_callback_target), NULL);
	_tmp40_->filter_double_click_callback = NULL;
	_tmp40_->filter_double_click_callback_target = NULL;
	_tmp40_->filter_double_click_callback_target_destroy_notify = NULL;
	_tmp40_->filter_double_click_callback = ___lambda185__widgets_window_event_area_filter_double_click;
	_tmp40_->filter_double_click_callback_target = g_object_ref (self);
	_tmp40_->filter_double_click_callback_target_destroy_notify = g_object_unref;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) box);
	_tmp41_ = self->event_area;
	gtk_overlay_add_overlay ((GtkOverlay*) self, (GtkWidget*) _tmp41_);
	memset (&_data4_->background_color, 0, sizeof (GdkRGBA));
	g_signal_connect_data ((GtkWidget*) box, "draw", (GCallback) ___lambda186__gtk_widget_draw, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_g_object_unref0 (cache_area);
	_g_object_unref0 (logo_image);
	_g_object_unref0 (logo_box);
	_g_object_unref0 (box);
	block4_data_unref (_data4_);
	_data4_ = NULL;
	return self;
}

WidgetsAppbar*
widgets_appbar_new (TerminalApp* app,
                    WidgetsWindow* win,
                    WidgetsTabbar* tab_bar,
                    WidgetsWorkspaceManager* manager,
                    gboolean has_start)
{
	return widgets_appbar_construct (WIDGETS_TYPE_APPBAR, app, win, tab_bar, manager, has_start);
}

void
widgets_appbar_show_window_button (WidgetsAppbar* self)
{
	GtkBox* _tmp0_;
	WidgetsWindowButton* _tmp1_;
	GtkBox* _tmp2_;
	WidgetsWindowButton* _tmp3_;
	GtkBox* _tmp4_;
	GtkBox* _tmp5_;
	GtkBox* _tmp6_;
	GtkBox* _tmp7_;
	WidgetsWindowButton* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->window_button_box;
	_tmp1_ = self->menu_button;
	gtk_box_pack_start (_tmp0_, (GtkWidget*) _tmp1_, FALSE, FALSE, (guint) 0);
	_tmp2_ = self->window_button_box;
	_tmp3_ = self->min_button;
	gtk_box_pack_start (_tmp2_, (GtkWidget*) _tmp3_, FALSE, FALSE, (guint) 0);
	_tmp4_ = self->window_button_box;
	_tmp5_ = self->max_toggle_box;
	gtk_box_pack_start (_tmp4_, (GtkWidget*) _tmp5_, FALSE, FALSE, (guint) 0);
	_tmp6_ = self->window_close_button_box;
	utils_remove_all_children ((GtkContainer*) _tmp6_);
	_tmp7_ = self->window_close_button_box;
	_tmp8_ = self->close_button;
	gtk_box_pack_start (_tmp7_, (GtkWidget*) _tmp8_, FALSE, FALSE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) self);
}

void
widgets_appbar_hide_window_button (WidgetsAppbar* self)
{
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkBox* _tmp2_;
	WidgetsWindowButton* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->window_button_box;
	utils_remove_all_children ((GtkContainer*) _tmp0_);
	_tmp1_ = self->window_close_button_box;
	utils_remove_all_children ((GtkContainer*) _tmp1_);
	_tmp2_ = self->window_close_button_box;
	_tmp3_ = self->quit_fullscreen_button;
	gtk_box_pack_start (_tmp2_, (GtkWidget*) _tmp3_, FALSE, FALSE, (guint) 0);
}

void
widgets_appbar_handle_menu_item_click (WidgetsAppbar* self,
                                       const gchar* item_id)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	static GQuark _tmp1_label6 = 0;
	static GQuark _tmp1_label7 = 0;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item_id != NULL);
	_tmp0_ = item_id;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("new_window")))) {
		switch (0) {
			default:
			{
				{
					GAppInfo* appinfo = NULL;
					GAppInfo* _tmp3_;
					GAppInfo* _tmp4_;
					_tmp3_ = g_app_info_create_from_commandline ("deepin-terminal-gtk", NULL, G_APP_INFO_CREATE_NONE, &_inner_error0_);
					appinfo = _tmp3_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_tmp4_ = appinfo;
					g_app_info_launch (_tmp4_, NULL, NULL, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (appinfo);
						goto __catch0_g_error;
					}
					_g_object_unref0 (appinfo);
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* e = NULL;
					GError* _tmp5_;
					const gchar* _tmp6_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp5_ = e;
					_tmp6_ = _tmp5_->message;
					g_print ("Appbar menu item 'new window': %s\n", _tmp6_);
					_g_error_free0 (e);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("custom_commands")))) {
		switch (0) {
			default:
			{
				WidgetsWorkspaceManager* _tmp7_;
				WidgetsWorkspace* _tmp8_;
				WidgetsWorkspaceManager* _tmp9_;
				WidgetsWorkspace* _tmp10_;
				_tmp7_ = self->workspace_manager;
				_tmp8_ = _tmp7_->focus_workspace;
				_tmp9_ = self->workspace_manager;
				_tmp10_ = _tmp9_->focus_workspace;
				widgets_workspace_show_command_panel (_tmp8_, _tmp10_);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("remote_manage")))) {
		switch (0) {
			default:
			{
				WidgetsWorkspaceManager* _tmp11_;
				WidgetsWorkspace* _tmp12_;
				WidgetsWorkspaceManager* _tmp13_;
				WidgetsWorkspace* _tmp14_;
				_tmp11_ = self->workspace_manager;
				_tmp12_ = _tmp11_->focus_workspace;
				_tmp13_ = self->workspace_manager;
				_tmp14_ = _tmp13_->focus_workspace;
				widgets_workspace_show_remote_panel (_tmp12_, _tmp14_);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("switch_theme")))) {
		switch (0) {
			default:
			{
				WidgetsWorkspaceManager* _tmp15_;
				WidgetsWorkspace* _tmp16_;
				WidgetsWorkspaceManager* _tmp17_;
				WidgetsWorkspace* _tmp18_;
				_tmp15_ = self->workspace_manager;
				_tmp16_ = _tmp15_->focus_workspace;
				_tmp17_ = self->workspace_manager;
				_tmp18_ = _tmp17_->focus_workspace;
				widgets_workspace_show_theme_panel (_tmp16_, _tmp18_);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("help")))) {
		switch (0) {
			default:
			{
				utils_show_manual ();
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("about")))) {
		switch (0) {
			default:
			{
				WidgetsAboutDialog* dialog = NULL;
				GtkWidget* _tmp19_;
				WidgetsAboutDialog* _tmp20_;
				WidgetsAboutDialog* _tmp21_;
				GtkWidget* _tmp22_;
				_tmp19_ = self->focus_widget;
				_tmp20_ = widgets_about_dialog_new (_tmp19_);
				g_object_ref_sink (_tmp20_);
				dialog = _tmp20_;
				_tmp21_ = dialog;
				_tmp22_ = gtk_widget_get_toplevel ((GtkWidget*) self);
				widgets_dialog_transient_for_window ((WidgetsDialog*) _tmp21_, G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindow));
				_g_object_unref0 (dialog);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label6) ? _tmp1_label6 : (_tmp1_label6 = g_quark_from_static_string ("exit")))) {
		switch (0) {
			default:
			{
				g_signal_emit (self, widgets_appbar_signals[WIDGETS_APPBAR_EXIT_TERMINAL_SIGNAL], 0);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label7) ? _tmp1_label7 : (_tmp1_label7 = g_quark_from_static_string ("preference")))) {
		switch (0) {
			default:
			{
				WidgetsPreference* preference = NULL;
				GtkWidget* _tmp23_;
				GtkWidget* _tmp24_;
				GtkWidget* _tmp25_;
				WidgetsPreference* _tmp26_;
				WidgetsPreference* _tmp27_;
				GtkWidget* _tmp28_;
				_tmp23_ = gtk_widget_get_toplevel ((GtkWidget*) self);
				_tmp24_ = gtk_widget_get_toplevel ((GtkWidget*) self);
				_tmp25_ = gtk_window_get_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_window_get_type (), GtkWindow));
				_tmp26_ = widgets_preference_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindow), _tmp25_);
				g_object_ref_sink (_tmp26_);
				preference = _tmp26_;
				_tmp27_ = preference;
				_tmp28_ = gtk_widget_get_toplevel ((GtkWidget*) self);
				widgets_dialog_transient_for_window ((WidgetsDialog*) _tmp27_, G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindow));
				_g_object_unref0 (preference);
				break;
			}
		}
	}
}

void
widgets_appbar_handle_menu_destroy (WidgetsAppbar* self)
{
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->menu);
	self->menu = NULL;
	_tmp0_ = self->focus_widget;
	if (_tmp0_ != NULL) {
		GtkWidget* _tmp1_;
		_tmp1_ = self->focus_widget;
		gtk_widget_grab_focus (_tmp1_);
	}
}

void
widgets_appbar_update_max_button (WidgetsAppbar* self)
{
	GtkBox* _tmp0_;
	GtkWidget* _tmp1_;
	GtkBox* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->max_toggle_box;
	utils_remove_all_children ((GtkContainer*) _tmp0_);
	_tmp1_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	if (widgets_config_window_window_is_max ((WidgetsConfigWindow*) G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, WIDGETS_TYPE_WINDOW, WidgetsWindow))) {
		GtkBox* _tmp2_;
		WidgetsWindowButton* _tmp3_;
		_tmp2_ = self->max_toggle_box;
		_tmp3_ = self->unmax_button;
		gtk_container_add ((GtkContainer*) _tmp2_, (GtkWidget*) _tmp3_);
	} else {
		GtkBox* _tmp4_;
		WidgetsWindowButton* _tmp5_;
		_tmp4_ = self->max_toggle_box;
		_tmp5_ = self->max_button;
		gtk_container_add ((GtkContainer*) _tmp4_, (GtkWidget*) _tmp5_);
	}
	_tmp6_ = self->max_toggle_box;
	gtk_widget_show_all ((GtkWidget*) _tmp6_);
}

static void
widgets_appbar_class_init (WidgetsAppbarClass * klass,
                           gpointer klass_data)
{
	widgets_appbar_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = widgets_appbar_finalize;
	widgets_appbar_signals[WIDGETS_APPBAR_CLOSE_WINDOW_SIGNAL] = g_signal_new ("close-window", WIDGETS_TYPE_APPBAR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	widgets_appbar_signals[WIDGETS_APPBAR_EXIT_TERMINAL_SIGNAL] = g_signal_new ("exit-terminal", WIDGETS_TYPE_APPBAR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	widgets_appbar_signals[WIDGETS_APPBAR_QUIT_FULLSCREEN_SIGNAL] = g_signal_new ("quit-fullscreen", WIDGETS_TYPE_APPBAR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
widgets_appbar_instance_init (WidgetsAppbar * self,
                              gpointer klass)
{
	self->height = constant_TITLEBAR_HEIGHT;
	self->logo_width = 48;
	self->titlebar_right_cache_width = 10;
	self->menu_button_width = constant_WINDOW_BUTTON_WIDHT;
}

static void
widgets_appbar_finalize (GObject * obj)
{
	WidgetsAppbar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WIDGETS_TYPE_APPBAR, WidgetsAppbar);
	_g_object_unref0 (self->max_toggle_box);
	_g_object_unref0 (self->window_button_box);
	_g_object_unref0 (self->window_close_button_box);
	_g_object_unref0 (self->focus_widget);
	_g_object_unref0 (self->menu);
	_g_object_unref0 (self->tabbar);
	_g_object_unref0 (self->window);
	_g_object_unref0 (self->event_area);
	_g_object_unref0 (self->close_button);
	_g_object_unref0 (self->max_button);
	_g_object_unref0 (self->menu_button);
	_g_object_unref0 (self->min_button);
	_g_object_unref0 (self->quit_fullscreen_button);
	_g_object_unref0 (self->unmax_button);
	_g_object_unref0 (self->workspace_manager);
	G_OBJECT_CLASS (widgets_appbar_parent_class)->finalize (obj);
}

static GType
widgets_appbar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WidgetsAppbarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) widgets_appbar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WidgetsAppbar), 0, (GInstanceInitFunc) widgets_appbar_instance_init, NULL };
	GType widgets_appbar_type_id;
	widgets_appbar_type_id = g_type_register_static (gtk_overlay_get_type (), "WidgetsAppbar", &g_define_type_info, 0);
	return widgets_appbar_type_id;
}

GType
widgets_appbar_get_type (void)
{
	static volatile gsize widgets_appbar_type_id__once = 0;
	if (g_once_init_enter (&widgets_appbar_type_id__once)) {
		GType widgets_appbar_type_id;
		widgets_appbar_type_id = widgets_appbar_get_type_once ();
		g_once_init_leave (&widgets_appbar_type_id__once, widgets_appbar_type_id);
	}
	return widgets_appbar_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

