/* command_panel.c generated by valac 0.56.17, the Vala compiler
 * generated from command_panel.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2011 ~ 2018 Deepin, Inc.
 *               2011 ~ 2018 Wang Yong
 *
 * Author:     Wang Yong <wangyong@deepin.com>
 * Maintainer: Wang Yong <wangyong@deepin.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gee.h>
#include <cairo-gobject.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <vte/vte.h>

#define GETTEXT_PACKAGE "deepin-terminal-gtk"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define WIDGETS_TYPE_BASE_PANEL (widgets_base_panel_get_type ())
#define WIDGETS_BASE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_BASE_PANEL, WidgetsBasePanel))
#define WIDGETS_BASE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_BASE_PANEL, WidgetsBasePanelClass))
#define WIDGETS_IS_BASE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_BASE_PANEL))
#define WIDGETS_IS_BASE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_BASE_PANEL))
#define WIDGETS_BASE_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_BASE_PANEL, WidgetsBasePanelClass))

typedef struct _WidgetsBasePanel WidgetsBasePanel;
typedef struct _WidgetsBasePanelClass WidgetsBasePanelClass;
typedef struct _WidgetsBasePanelPrivate WidgetsBasePanelPrivate;

#define WIDGETS_TYPE_CONFIG_WINDOW (widgets_config_window_get_type ())
#define WIDGETS_CONFIG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindow))
#define WIDGETS_CONFIG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindowClass))
#define WIDGETS_IS_CONFIG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_CONFIG_WINDOW))
#define WIDGETS_IS_CONFIG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_CONFIG_WINDOW))
#define WIDGETS_CONFIG_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindowClass))

typedef struct _WidgetsConfigWindow WidgetsConfigWindow;
typedef struct _WidgetsConfigWindowClass WidgetsConfigWindowClass;

#define WIDGETS_TYPE_WORKSPACE_MANAGER (widgets_workspace_manager_get_type ())
#define WIDGETS_WORKSPACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_WORKSPACE_MANAGER, WidgetsWorkspaceManager))
#define WIDGETS_WORKSPACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_WORKSPACE_MANAGER, WidgetsWorkspaceManagerClass))
#define WIDGETS_IS_WORKSPACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_WORKSPACE_MANAGER))
#define WIDGETS_IS_WORKSPACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_WORKSPACE_MANAGER))
#define WIDGETS_WORKSPACE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_WORKSPACE_MANAGER, WidgetsWorkspaceManagerClass))

typedef struct _WidgetsWorkspaceManager WidgetsWorkspaceManager;
typedef struct _WidgetsWorkspaceManagerClass WidgetsWorkspaceManagerClass;

#define WIDGETS_TYPE_SWITCHER (widgets_switcher_get_type ())
#define WIDGETS_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_SWITCHER, WidgetsSwitcher))
#define WIDGETS_SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_SWITCHER, WidgetsSwitcherClass))
#define WIDGETS_IS_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_SWITCHER))
#define WIDGETS_IS_SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_SWITCHER))
#define WIDGETS_SWITCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_SWITCHER, WidgetsSwitcherClass))

typedef struct _WidgetsSwitcher WidgetsSwitcher;
typedef struct _WidgetsSwitcherClass WidgetsSwitcherClass;

#define WIDGETS_TYPE_WORKSPACE (widgets_workspace_get_type ())
#define WIDGETS_WORKSPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_WORKSPACE, WidgetsWorkspace))
#define WIDGETS_WORKSPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_WORKSPACE, WidgetsWorkspaceClass))
#define WIDGETS_IS_WORKSPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_WORKSPACE))
#define WIDGETS_IS_WORKSPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_WORKSPACE))
#define WIDGETS_WORKSPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_WORKSPACE, WidgetsWorkspaceClass))

typedef struct _WidgetsWorkspace WidgetsWorkspace;
typedef struct _WidgetsWorkspaceClass WidgetsWorkspaceClass;

#define WIDGETS_TYPE_COMMAND_PANEL (widgets_command_panel_get_type ())
#define WIDGETS_COMMAND_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_COMMAND_PANEL, WidgetsCommandPanel))
#define WIDGETS_COMMAND_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_COMMAND_PANEL, WidgetsCommandPanelClass))
#define WIDGETS_IS_COMMAND_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_COMMAND_PANEL))
#define WIDGETS_IS_COMMAND_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_COMMAND_PANEL))
#define WIDGETS_COMMAND_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_COMMAND_PANEL, WidgetsCommandPanelClass))

typedef struct _WidgetsCommandPanel WidgetsCommandPanel;
typedef struct _WidgetsCommandPanelClass WidgetsCommandPanelClass;
typedef struct _WidgetsCommandPanelPrivate WidgetsCommandPanelPrivate;
enum  {
	WIDGETS_COMMAND_PANEL_0_PROPERTY,
	WIDGETS_COMMAND_PANEL_NUM_PROPERTIES
};
static GParamSpec* widgets_command_panel_properties[WIDGETS_COMMAND_PANEL_NUM_PROPERTIES];
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _WidgetsConfigWindowPrivate WidgetsConfigWindowPrivate;

#define CONFIG_TYPE_CONFIG (config_config_get_type ())
#define CONFIG_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_CONFIG, ConfigConfig))
#define CONFIG_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_CONFIG, ConfigConfigClass))
#define CONFIG_IS_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_CONFIG))
#define CONFIG_IS_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_CONFIG))
#define CONFIG_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_CONFIG, ConfigConfigClass))

typedef struct _ConfigConfig ConfigConfig;
typedef struct _ConfigConfigClass ConfigConfigClass;
typedef struct _ConfigConfigPrivate ConfigConfigPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define WIDGETS_TYPE_SEARCH_ENTRY (widgets_search_entry_get_type ())
#define WIDGETS_SEARCH_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_SEARCH_ENTRY, WidgetsSearchEntry))
#define WIDGETS_SEARCH_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_SEARCH_ENTRY, WidgetsSearchEntryClass))
#define WIDGETS_IS_SEARCH_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_SEARCH_ENTRY))
#define WIDGETS_IS_SEARCH_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_SEARCH_ENTRY))
#define WIDGETS_SEARCH_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_SEARCH_ENTRY, WidgetsSearchEntryClass))

typedef struct _WidgetsSearchEntry WidgetsSearchEntry;
typedef struct _WidgetsSearchEntryClass WidgetsSearchEntryClass;
typedef struct _WidgetsSearchEntryPrivate WidgetsSearchEntryPrivate;

#define ANIMATION_TYPE_ANIMATE_TIMER (animation_animate_timer_get_type ())
#define ANIMATION_ANIMATE_TIMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ANIMATION_TYPE_ANIMATE_TIMER, AnimationAnimateTimer))
#define ANIMATION_ANIMATE_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ANIMATION_TYPE_ANIMATE_TIMER, AnimationAnimateTimerClass))
#define ANIMATION_IS_ANIMATE_TIMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ANIMATION_TYPE_ANIMATE_TIMER))
#define ANIMATION_IS_ANIMATE_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ANIMATION_TYPE_ANIMATE_TIMER))
#define ANIMATION_ANIMATE_TIMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ANIMATION_TYPE_ANIMATE_TIMER, AnimationAnimateTimerClass))

typedef struct _AnimationAnimateTimer AnimationAnimateTimer;
typedef struct _AnimationAnimateTimerClass AnimationAnimateTimerClass;

#define WIDGETS_TYPE_CLICK_EVENT_BOX (widgets_click_event_box_get_type ())
#define WIDGETS_CLICK_EVENT_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_CLICK_EVENT_BOX, WidgetsClickEventBox))
#define WIDGETS_CLICK_EVENT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_CLICK_EVENT_BOX, WidgetsClickEventBoxClass))
#define WIDGETS_IS_CLICK_EVENT_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_CLICK_EVENT_BOX))
#define WIDGETS_IS_CLICK_EVENT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_CLICK_EVENT_BOX))
#define WIDGETS_CLICK_EVENT_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_CLICK_EVENT_BOX, WidgetsClickEventBoxClass))

typedef struct _WidgetsClickEventBox WidgetsClickEventBox;
typedef struct _WidgetsClickEventBoxClass WidgetsClickEventBoxClass;

#define WIDGETS_TYPE_IMAGE_BUTTON (widgets_image_button_get_type ())
#define WIDGETS_IMAGE_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_IMAGE_BUTTON, WidgetsImageButton))
#define WIDGETS_IMAGE_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_IMAGE_BUTTON, WidgetsImageButtonClass))
#define WIDGETS_IS_IMAGE_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_IMAGE_BUTTON))
#define WIDGETS_IS_IMAGE_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_IMAGE_BUTTON))
#define WIDGETS_IMAGE_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_IMAGE_BUTTON, WidgetsImageButtonClass))

typedef struct _WidgetsImageButton WidgetsImageButton;
typedef struct _WidgetsImageButtonClass WidgetsImageButtonClass;

#define WIDGETS_TYPE_ENTRY (widgets_entry_get_type ())
#define WIDGETS_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_ENTRY, WidgetsEntry))
#define WIDGETS_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_ENTRY, WidgetsEntryClass))
#define WIDGETS_IS_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_ENTRY))
#define WIDGETS_IS_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_ENTRY))
#define WIDGETS_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_ENTRY, WidgetsEntryClass))

typedef struct _WidgetsEntry WidgetsEntry;
typedef struct _WidgetsEntryClass WidgetsEntryClass;

#define WIDGETS_TYPE_SPLIT_LINE (widgets_split_line_get_type ())
#define WIDGETS_SPLIT_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_SPLIT_LINE, WidgetsSplitLine))
#define WIDGETS_SPLIT_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_SPLIT_LINE, WidgetsSplitLineClass))
#define WIDGETS_IS_SPLIT_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_SPLIT_LINE))
#define WIDGETS_IS_SPLIT_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_SPLIT_LINE))
#define WIDGETS_SPLIT_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_SPLIT_LINE, WidgetsSplitLineClass))

typedef struct _WidgetsSplitLine WidgetsSplitLine;
typedef struct _WidgetsSplitLineClass WidgetsSplitLineClass;

#define WIDGETS_TYPE_PANEL_BUTTON (widgets_panel_button_get_type ())
#define WIDGETS_PANEL_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_PANEL_BUTTON, WidgetsPanelButton))
#define WIDGETS_PANEL_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_PANEL_BUTTON, WidgetsPanelButtonClass))
#define WIDGETS_IS_PANEL_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_PANEL_BUTTON))
#define WIDGETS_IS_PANEL_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_PANEL_BUTTON))
#define WIDGETS_PANEL_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_PANEL_BUTTON, WidgetsPanelButtonClass))

typedef struct _WidgetsPanelButton WidgetsPanelButton;
typedef struct _WidgetsPanelButtonClass WidgetsPanelButtonClass;

#define WIDGETS_TYPE_COMMAND_BUTTON (widgets_command_button_get_type ())
#define WIDGETS_COMMAND_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_COMMAND_BUTTON, WidgetsCommandButton))
#define WIDGETS_COMMAND_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_COMMAND_BUTTON, WidgetsCommandButtonClass))
#define WIDGETS_IS_COMMAND_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_COMMAND_BUTTON))
#define WIDGETS_IS_COMMAND_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_COMMAND_BUTTON))
#define WIDGETS_COMMAND_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_COMMAND_BUTTON, WidgetsCommandButtonClass))

typedef struct _WidgetsCommandButton WidgetsCommandButton;
typedef struct _WidgetsCommandButtonClass WidgetsCommandButtonClass;
typedef void (*WidgetsCommandPanelUpdatePageAfterEdit) (gpointer user_data);

#define WIDGETS_TYPE_ADD_BUTTON (widgets_add_button_get_type ())
#define WIDGETS_ADD_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_ADD_BUTTON, WidgetsAddButton))
#define WIDGETS_ADD_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_ADD_BUTTON, WidgetsAddButtonClass))
#define WIDGETS_IS_ADD_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_ADD_BUTTON))
#define WIDGETS_IS_ADD_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_ADD_BUTTON))
#define WIDGETS_ADD_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_ADD_BUTTON, WidgetsAddButtonClass))

typedef struct _WidgetsAddButton WidgetsAddButton;
typedef struct _WidgetsAddButtonClass WidgetsAddButtonClass;
typedef struct _Block7Data Block7Data;
typedef struct _Block8Data Block8Data;

#define WIDGETS_TYPE_DIALOG (widgets_dialog_get_type ())
#define WIDGETS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_DIALOG, WidgetsDialog))
#define WIDGETS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_DIALOG, WidgetsDialogClass))
#define WIDGETS_IS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_DIALOG))
#define WIDGETS_IS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_DIALOG))
#define WIDGETS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_DIALOG, WidgetsDialogClass))

typedef struct _WidgetsDialog WidgetsDialog;
typedef struct _WidgetsDialogClass WidgetsDialogClass;

#define WIDGETS_TYPE_COMMAND_DIALOG (widgets_command_dialog_get_type ())
#define WIDGETS_COMMAND_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_COMMAND_DIALOG, WidgetsCommandDialog))
#define WIDGETS_COMMAND_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_COMMAND_DIALOG, WidgetsCommandDialogClass))
#define WIDGETS_IS_COMMAND_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_COMMAND_DIALOG))
#define WIDGETS_IS_COMMAND_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_COMMAND_DIALOG))
#define WIDGETS_COMMAND_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_COMMAND_DIALOG, WidgetsCommandDialogClass))

typedef struct _WidgetsCommandDialog WidgetsCommandDialog;
typedef struct _WidgetsCommandDialogClass WidgetsCommandDialogClass;
typedef struct _Block9Data Block9Data;

#define WIDGETS_TYPE_TERM (widgets_term_get_type ())
#define WIDGETS_TERM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_TERM, WidgetsTerm))
#define WIDGETS_TERM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_TERM, WidgetsTermClass))
#define WIDGETS_IS_TERM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_TERM))
#define WIDGETS_IS_TERM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_TERM))
#define WIDGETS_TERM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_TERM, WidgetsTermClass))

typedef struct _WidgetsTerm WidgetsTerm;
typedef struct _WidgetsTermClass WidgetsTermClass;
typedef struct _WidgetsWorkspaceManagerPrivate WidgetsWorkspaceManagerPrivate;

#define WIDGETS_TYPE_TABBAR (widgets_tabbar_get_type ())
#define WIDGETS_TABBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_TABBAR, WidgetsTabbar))
#define WIDGETS_TABBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_TABBAR, WidgetsTabbarClass))
#define WIDGETS_IS_TABBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_TABBAR))
#define WIDGETS_IS_TABBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_TABBAR))
#define WIDGETS_TABBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_TABBAR, WidgetsTabbarClass))

typedef struct _WidgetsTabbar WidgetsTabbar;
typedef struct _WidgetsTabbarClass WidgetsTabbarClass;
typedef struct _WidgetsTermPrivate WidgetsTermPrivate;

#define MENU_TYPE_MENU (menu_menu_get_type ())
#define MENU_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MENU_TYPE_MENU, MenuMenu))
#define MENU_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MENU_TYPE_MENU, MenuMenuClass))
#define MENU_IS_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MENU_TYPE_MENU))
#define MENU_IS_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MENU_TYPE_MENU))
#define MENU_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MENU_TYPE_MENU, MenuMenuClass))

typedef struct _MenuMenu MenuMenu;
typedef struct _MenuMenuClass MenuMenuClass;
typedef struct _Block10Data Block10Data;

struct _WidgetsBasePanel {
	GtkHBox parent_instance;
	WidgetsBasePanelPrivate * priv;
	WidgetsConfigWindow* parent_window;
	WidgetsWorkspaceManager* workspace_manager;
	GdkRGBA background_color;
	GdkRGBA line_dark_color;
	GdkRGBA line_light_color;
	GtkBox* home_page_box;
	GtkBox* search_page_box;
	GtkScrolledWindow* home_page_scrolledwindow;
	GtkScrolledWindow* search_page_scrolledwindow;
	GtkWidget* focus_widget;
	WidgetsSwitcher* switcher;
	WidgetsWorkspace* workspace;
	gint back_button_margin_left;
	gint back_button_margin_top;
};

struct _WidgetsBasePanelClass {
	GtkHBoxClass parent_class;
	void (*create_search_page) (WidgetsBasePanel* self, const gchar* search_text, const gchar* group_name);
	void (*create_home_page) (WidgetsBasePanel* self);
};

struct _WidgetsCommandPanel {
	WidgetsBasePanel parent_instance;
	WidgetsCommandPanelPrivate * priv;
	GKeyFile* config_file;
	gint width;
	gchar* config_file_path;
};

struct _WidgetsCommandPanelClass {
	WidgetsBasePanelClass parent_class;
};

struct _WidgetsConfigWindow {
	GtkWindow parent_instance;
	WidgetsConfigWindowPrivate * priv;
	ConfigConfig* config;
	GdkRGBA title_line_dark_color;
	GdkRGBA title_line_light_color;
	GdkScreen* screen_monitor;
	GtkBox* box;
	GtkBox* top_box;
	GtkBox* window_frame_box;
	GtkBox* window_widget_box;
	WidgetsWorkspaceManager* workspace_manager;
	gboolean quake_mode;
	gboolean show_quake_menu;
	gboolean* config_theme_is_light;
	gint active_tab_underline_width;
	gint active_tab_underline_x;
	gint cache_height;
	gint cache_width;
	gint reset_timeout_delay;
	gint resize_cache_x;
	gint resize_cache_y;
	gint resize_cache_width;
	gint resize_cache_height;
	gint resize_timeout_delay;
	guint* reset_timeout_source_id;
	guint* resize_timeout_source_id;
};

struct _WidgetsConfigWindowClass {
	GtkWindowClass parent_class;
	void (*toggle_fullscreen) (WidgetsConfigWindow* self);
	void (*window_save_before_quit) (WidgetsConfigWindow* self);
	GdkCursorType* (*get_frame_cursor_type) (WidgetsConfigWindow* self, gdouble x, gdouble y);
	void (*update_frame) (WidgetsConfigWindow* self);
	GdkCursorType* (*get_cursor_type) (WidgetsConfigWindow* self, gdouble x, gdouble y);
};

struct _ConfigConfig {
	GObject parent_instance;
	ConfigConfigPrivate * priv;
	GeeArrayList* backspace_key_erase_names;
	GeeArrayList* del_key_erase_names;
	GeeArrayList* encoding_names;
	GeeHashMap* erase_map;
	gdouble default_opacity;
	gint default_size;
	gchar* default_mono_font;
	GKeyFile* config_file;
	gchar* config_file_path;
	gchar* temp_theme;
};

struct _ConfigConfigClass {
	GObjectClass parent_class;
};

struct _WidgetsSearchEntry {
	GtkEventBox parent_instance;
	WidgetsSearchEntryPrivate * priv;
	AnimationAnimateTimer* timer;
	GtkBox* box;
	GtkBox* display_box;
	GtkLabel* search_label;
	WidgetsImageButton* clear_button;
	WidgetsEntry* search_entry;
	WidgetsImageButton* search_image;
	gint animation_time;
	gint clear_button_margin_right;
	gint height;
	gint search_image_animate_start_x;
	gint search_image_margin_right;
	gint search_image_margin_x;
};

struct _WidgetsSearchEntryClass {
	GtkEventBoxClass parent_class;
};

struct _Block7Data {
	int _ref_count_;
	WidgetsCommandPanel* self;
	gchar* search_text;
};

struct _Block8Data {
	int _ref_count_;
	Block7Data * _data7_;
	GtkLabel* search_label;
};

struct _Block9Data {
	int _ref_count_;
	WidgetsCommandPanel* self;
	WidgetsCommandDialog* command_dialog;
	gchar* command_name;
	WidgetsCommandPanelUpdatePageAfterEdit func;
	gpointer func_target;
};

struct _WidgetsWorkspaceManager {
	GtkBox parent_instance;
	WidgetsWorkspaceManagerPrivate * priv;
	GeeHashMap* workspace_map;
	WidgetsTabbar* tabbar;
	WidgetsWorkspace* focus_workspace;
	gint workspace_index;
};

struct _WidgetsWorkspaceManagerClass {
	GtkBoxClass parent_class;
};

struct _WidgetsTerm {
	GtkOverlay parent_instance;
	WidgetsTermPrivate * priv;
	GeeArrayList* command_execute_y_coordinates;
	GPid child_pid;
	GdkRGBA background_color;
	GdkRGBA foreground_color;
	GtkScrollbar* scrollbar;
	MenuMenu* menu;
	VteTerminal* term;
	WidgetsWorkspaceManager* workspace_manager;
	gboolean child_has_exit;
	gboolean has_print_exit_notify;
	gboolean has_select_all;
	gboolean is_first_term;
	gboolean is_press_scrollbar;
	gboolean login_remote_server;
	gboolean press_anything;
	gdouble zoom_factor;
	gint font_size;
	gint hide_scrollbar_offset;
	gint show_scrollbar_offset;
	gchar* current_dir;
	gchar* current_title;
	gchar* expect_file_path;
	gchar* customize_title;
	gchar* remote_server_title;
	gchar* uri_at_right_press;
	gchar* server_info;
	guint launch_idle_id;
	guint* hide_scrollbar_timeout_source_id;
	GKeyFile* search_engine_config_file;
	gchar* search_engine_config_file_path;
};

struct _WidgetsTermClass {
	GtkOverlayClass parent_class;
};

struct _Block10Data {
	int _ref_count_;
	WidgetsCommandPanel* self;
	WidgetsCommandDialog* command_dialog;
};

static gpointer widgets_command_panel_parent_class = NULL;
VALA_EXTERN gint constant_SLIDER_WIDTH;
VALA_EXTERN gint constant_REMOTE_PANEL_SEARCHBAR_HEIGHT;

VALA_EXTERN GType widgets_base_panel_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsBasePanel, g_object_unref)
VALA_EXTERN GType widgets_config_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsConfigWindow, g_object_unref)
VALA_EXTERN GType widgets_workspace_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsWorkspaceManager, g_object_unref)
VALA_EXTERN GType widgets_switcher_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsSwitcher, g_object_unref)
VALA_EXTERN GType widgets_workspace_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsWorkspace, g_object_unref)
VALA_EXTERN GType widgets_command_panel_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsCommandPanel, g_object_unref)
VALA_EXTERN void widgets_base_panel_create_home_page (WidgetsBasePanel* self);
VALA_EXTERN void widgets_base_panel_create_search_page (WidgetsBasePanel* self,
                                            const gchar* search_text,
                                            const gchar* group_name);
VALA_EXTERN gchar* utils_get_config_file_path (const gchar* config_name);
VALA_EXTERN WidgetsCommandPanel* widgets_command_panel_new (WidgetsWorkspace* space,
                                                WidgetsWorkspaceManager* manager);
VALA_EXTERN WidgetsCommandPanel* widgets_command_panel_construct (GType object_type,
                                                      WidgetsWorkspace* space,
                                                      WidgetsWorkspaceManager* manager);
VALA_EXTERN WidgetsBasePanel* widgets_base_panel_new (void);
VALA_EXTERN WidgetsBasePanel* widgets_base_panel_construct (GType object_type);
VALA_EXTERN GType config_config_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigConfig, g_object_unref)
VALA_EXTERN void utils_hex_to_rgba (const gchar* hex_color,
                        gdouble alpha,
                        GdkRGBA* result);
VALA_EXTERN WidgetsSwitcher* widgets_switcher_new (gint w);
VALA_EXTERN WidgetsSwitcher* widgets_switcher_construct (GType object_type,
                                             gint w);
VALA_EXTERN void widgets_base_panel_show_home_page (WidgetsBasePanel* self,
                                        GtkWidget* start_widget);
VALA_EXTERN gboolean widgets_base_panel_on_draw (WidgetsBasePanel* self,
                                     GtkWidget* widget,
                                     cairo_t* cr);
static gboolean _widgets_base_panel_on_draw_gtk_widget_draw (GtkWidget* _sender,
                                                      cairo_t* cr,
                                                      gpointer self);
VALA_EXTERN void widgets_command_panel_load_config (WidgetsCommandPanel* self);
VALA_EXTERN void utils_touch_dir (const gchar* dir);
VALA_EXTERN gchar* utils_get_config_dir (void);
VALA_EXTERN void utils_create_file (const gchar* file_path);
static void widgets_command_panel_real_create_home_page (WidgetsBasePanel* base);
VALA_EXTERN void utils_destroy_all_children (GtkContainer* container);
VALA_EXTERN void widgets_command_panel_add_group_item (WidgetsCommandPanel* self,
                                           const gchar* option,
                                           GeeArrayList* lists,
                                           GKeyFile* config_file);
VALA_EXTERN GType widgets_search_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsSearchEntry, g_object_unref)
VALA_EXTERN WidgetsSearchEntry* widgets_search_entry_new (void);
VALA_EXTERN WidgetsSearchEntry* widgets_search_entry_construct (GType object_type);
VALA_EXTERN GType animation_animate_timer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AnimationAnimateTimer, g_object_unref)
VALA_EXTERN GType widgets_click_event_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsClickEventBox, g_object_unref)
VALA_EXTERN GType widgets_image_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsImageButton, g_object_unref)
VALA_EXTERN GType widgets_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsEntry, g_object_unref)
static void ___lambda31_ (WidgetsCommandPanel* self,
                   GtkEntry* entry);
VALA_EXTERN void widgets_base_panel_show_search_page (WidgetsBasePanel* self,
                                          const gchar* search_text,
                                          const gchar* group_name,
                                          GtkWidget* start_widget);
static void ____lambda31__gtk_entry_activate (GtkEntry* _sender,
                                       gpointer self);
VALA_EXTERN GType widgets_split_line_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsSplitLine, g_object_unref)
VALA_EXTERN WidgetsSplitLine* widgets_split_line_new (void);
VALA_EXTERN WidgetsSplitLine* widgets_split_line_construct (GType object_type);
VALA_EXTERN GtkScrolledWindow* widgets_base_panel_create_scrolled_window (WidgetsBasePanel* self);
VALA_EXTERN GType widgets_panel_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsPanelButton, g_object_unref)
VALA_EXTERN GType widgets_command_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsCommandButton, g_object_unref)
VALA_EXTERN WidgetsCommandButton* widgets_command_panel_create_command_button (WidgetsCommandPanel* self,
                                                                   const gchar* name,
                                                                   const gchar* value,
                                                                   const gchar* shortcut);
static void _____lambda42_ (WidgetsCommandPanel* self,
                     WidgetsCommandButton* w,
                     const gchar* command_name);
VALA_EXTERN void widgets_command_panel_edit_command (WidgetsCommandPanel* self,
                                         const gchar* command_name,
                                         WidgetsCommandPanelUpdatePageAfterEdit func,
                                         gpointer func_target);
static void __lambda235_ (WidgetsCommandPanel* self);
VALA_EXTERN void widgets_base_panel_update_home_page (WidgetsBasePanel* self);
static void ___lambda235__widgets_command_panel_update_page_after_edit (gpointer self);
static void ______lambda42__widgets_command_button_edit_command (WidgetsCommandButton* _sender,
                                                          const gchar* command_name,
                                                          gpointer self);
VALA_EXTERN GType widgets_add_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsAddButton, g_object_unref)
VALA_EXTERN WidgetsAddButton* widgets_command_panel_create_add_command_button (WidgetsCommandPanel* self);
VALA_EXTERN void widgets_command_panel_add_command (WidgetsCommandPanel* self,
                                        const gchar* name,
                                        const gchar* command,
                                        const gchar* shortcut);
static void widgets_command_panel_real_create_search_page (WidgetsBasePanel* base,
                                                    const gchar* search_text,
                                                    const gchar* group_name);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
VALA_EXTERN WidgetsImageButton* widgets_image_button_new (const gchar* image_path,
                                              gboolean theme_button,
                                              const gchar* text,
                                              gint text_size);
VALA_EXTERN WidgetsImageButton* widgets_image_button_construct (GType object_type,
                                                    const gchar* image_path,
                                                    gboolean theme_button,
                                                    const gchar* text,
                                                    gint text_size);
static void ___lambda238_ (WidgetsCommandPanel* self,
                    GdkEventButton* w);
static void ____lambda238__widgets_click_event_box_clicked (WidgetsClickEventBox* _sender,
                                                     GdkEventButton* event,
                                                     gpointer self);
static void _____lambda239_ (Block8Data* _data8_,
                      WidgetsCommandButton* w,
                      const gchar* command_name);
static void __lambda240_ (Block8Data* _data8_);
VALA_EXTERN void widgets_base_panel_update_search_page (WidgetsBasePanel* self,
                                            const gchar* search_text,
                                            const gchar* group_name);
static void ___lambda240__widgets_command_panel_update_page_after_edit (gpointer self);
static void ______lambda239__widgets_command_button_edit_command (WidgetsCommandButton* _sender,
                                                           const gchar* command_name,
                                                           gpointer self);
static void ___lambda241_ (Block8Data* _data8_,
                    GtkWidget* w);
VALA_EXTERN gboolean widgets_config_window_is_light_theme (WidgetsConfigWindow* self);
static void ____lambda241__gtk_widget_realize (GtkWidget* _sender,
                                        gpointer self);
VALA_EXTERN GType widgets_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsDialog, g_object_unref)
VALA_EXTERN GType widgets_command_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsCommandDialog, g_object_unref)
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
VALA_EXTERN GType widgets_term_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsTerm, g_object_unref)
VALA_EXTERN WidgetsCommandDialog* widgets_command_dialog_new (WidgetsConfigWindow* window,
                                                  WidgetsTerm* term,
                                                  GtkWidget* widget,
                                                  const gchar* info,
                                                  GKeyFile* config_file);
VALA_EXTERN WidgetsCommandDialog* widgets_command_dialog_construct (GType object_type,
                                                        WidgetsConfigWindow* window,
                                                        WidgetsTerm* term,
                                                        GtkWidget* widget,
                                                        const gchar* info,
                                                        GKeyFile* config_file);
VALA_EXTERN void widgets_dialog_transient_for_window (WidgetsDialog* self,
                                          WidgetsConfigWindow* window);
static void __lambda233_ (Block9Data* _data9_,
                   const gchar* name);
static void ___lambda233__widgets_command_dialog_delete_command (WidgetsCommandDialog* _sender,
                                                          const gchar* name,
                                                          gpointer self);
static void __lambda234_ (Block9Data* _data9_,
                   const gchar* name,
                   const gchar* command,
                   const gchar* shortcut);
static void ___lambda234__widgets_command_dialog_edit_command (WidgetsCommandDialog* _sender,
                                                        const gchar* name,
                                                        const gchar* command,
                                                        const gchar* shortcut,
                                                        gpointer self);
VALA_EXTERN WidgetsCommandButton* widgets_command_button_new (const gchar* name,
                                                  const gchar* value,
                                                  const gchar* shortcut);
VALA_EXTERN WidgetsCommandButton* widgets_command_button_construct (GType object_type,
                                                        const gchar* name,
                                                        const gchar* value,
                                                        const gchar* shortcut);
static void __lambda41_ (WidgetsCommandPanel* self,
                  WidgetsCommandButton* w,
                  const gchar* command);
VALA_EXTERN void widgets_command_panel_execute_command (WidgetsCommandPanel* self,
                                            const gchar* command);
static void ___lambda41__widgets_command_button_execute_command (WidgetsCommandButton* _sender,
                                                          const gchar* command_value,
                                                          gpointer self);
VALA_EXTERN GType widgets_tabbar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsTabbar, g_object_unref)
VALA_EXTERN WidgetsTerm* widgets_workspace_get_focus_term (WidgetsWorkspace* self,
                                               GtkContainer* container);
VALA_EXTERN GType menu_menu_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MenuMenu, g_object_unref)
VALA_EXTERN guint8* utils_to_raw_data (const gchar* str,
                           gint* result_length1);
VALA_EXTERN void widgets_workspace_hide_command_panel (WidgetsWorkspace* self);
VALA_EXTERN WidgetsAddButton* widgets_add_button_new (const gchar* button_name);
VALA_EXTERN WidgetsAddButton* widgets_add_button_construct (GType object_type,
                                                const gchar* button_name);
static void __lambda236_ (WidgetsCommandPanel* self,
                   GtkButton* w);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static void __lambda237_ (Block10Data* _data10_,
                   const gchar* name,
                   const gchar* command,
                   const gchar* shortcut);
static void ___lambda237__widgets_command_dialog_add_command (WidgetsCommandDialog* _sender,
                                                       const gchar* name,
                                                       const gchar* command,
                                                       const gchar* shortcut,
                                                       gpointer self);
static void ___lambda236__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static void widgets_command_panel_finalize (GObject * obj);
static GType widgets_command_panel_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
_widgets_base_panel_on_draw_gtk_widget_draw (GtkWidget* _sender,
                                             cairo_t* cr,
                                             gpointer self)
{
	gboolean result;
	result = widgets_base_panel_on_draw ((WidgetsBasePanel*) self, _sender, cr);
	return result;
}

WidgetsCommandPanel*
widgets_command_panel_construct (GType object_type,
                                 WidgetsWorkspace* space,
                                 WidgetsWorkspaceManager* manager)
{
	WidgetsCommandPanel * self = NULL;
	WidgetsWorkspace* _tmp0_;
	WidgetsWorkspaceManager* _tmp1_;
	GKeyFile* _tmp2_;
	WidgetsWorkspace* _tmp3_;
	GtkWidget* _tmp4_;
	GtkWidget* _tmp5_;
	GtkWidget* _tmp6_;
	WidgetsWorkspace* _tmp7_;
	GtkWidget* _tmp8_;
	WidgetsConfigWindow* _tmp9_;
	WidgetsSwitcher* _tmp18_;
	GtkBox* _tmp19_;
	GtkBox* _tmp20_;
	WidgetsSwitcher* _tmp21_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (space != NULL, NULL);
	g_return_val_if_fail (manager != NULL, NULL);
	self = (WidgetsCommandPanel*) widgets_base_panel_construct (object_type);
	bindtextdomain (GETTEXT_PACKAGE, "/usr/share/locale");
	_tmp0_ = _g_object_ref0 (space);
	_g_object_unref0 (((WidgetsBasePanel*) self)->workspace);
	((WidgetsBasePanel*) self)->workspace = _tmp0_;
	_tmp1_ = _g_object_ref0 (manager);
	_g_object_unref0 (((WidgetsBasePanel*) self)->workspace_manager);
	((WidgetsBasePanel*) self)->workspace_manager = _tmp1_;
	_tmp2_ = g_key_file_new ();
	_g_key_file_unref0 (self->config_file);
	self->config_file = _tmp2_;
	_tmp3_ = ((WidgetsBasePanel*) self)->workspace;
	_tmp4_ = gtk_widget_get_toplevel ((GtkWidget*) _tmp3_);
	_tmp5_ = gtk_window_get_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_window_get_type (), GtkWindow));
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (((WidgetsBasePanel*) self)->focus_widget);
	((WidgetsBasePanel*) self)->focus_widget = _tmp6_;
	_tmp7_ = ((WidgetsBasePanel*) self)->workspace;
	_tmp8_ = gtk_widget_get_toplevel ((GtkWidget*) _tmp7_);
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindow));
	_g_object_unref0 (((WidgetsBasePanel*) self)->parent_window);
	((WidgetsBasePanel*) self)->parent_window = _tmp9_;
	{
		gchar* _tmp10_ = NULL;
		WidgetsConfigWindow* _tmp11_;
		ConfigConfig* _tmp12_;
		GKeyFile* _tmp13_;
		gchar* _tmp14_;
		GdkRGBA _tmp15_ = {0};
		_tmp11_ = ((WidgetsBasePanel*) self)->parent_window;
		_tmp12_ = _tmp11_->config;
		_tmp13_ = _tmp12_->config_file;
		_tmp14_ = g_key_file_get_string (_tmp13_, "theme", "background", &_inner_error0_);
		_tmp10_ = _tmp14_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		utils_hex_to_rgba (_tmp10_, 1.0, &_tmp15_);
		((WidgetsBasePanel*) self)->background_color = _tmp15_;
		_g_free0 (_tmp10_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_print ("CommandPanel init: %s\n", _tmp17_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp18_ = widgets_switcher_new (self->width);
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (((WidgetsBasePanel*) self)->switcher);
	((WidgetsBasePanel*) self)->switcher = _tmp18_;
	gtk_widget_set_size_request ((GtkWidget*) self, self->width, -1);
	_tmp19_ = ((WidgetsBasePanel*) self)->home_page_box;
	gtk_widget_set_size_request ((GtkWidget*) _tmp19_, self->width, -1);
	_tmp20_ = ((WidgetsBasePanel*) self)->search_page_box;
	gtk_widget_set_size_request ((GtkWidget*) _tmp20_, self->width, -1);
	_tmp21_ = ((WidgetsBasePanel*) self)->switcher;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp21_, TRUE, TRUE, (guint) 0);
	widgets_base_panel_show_home_page ((WidgetsBasePanel*) self, NULL);
	g_signal_connect_object ((GtkWidget*) self, "draw", (GCallback) _widgets_base_panel_on_draw_gtk_widget_draw, (WidgetsBasePanel*) self, 0);
	return self;
}

WidgetsCommandPanel*
widgets_command_panel_new (WidgetsWorkspace* space,
                           WidgetsWorkspaceManager* manager)
{
	return widgets_command_panel_construct (WIDGETS_TYPE_COMMAND_PANEL, space, manager);
}

void
widgets_command_panel_load_config (WidgetsCommandPanel* self)
{
	GFile* file = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->config_file_path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	file = _tmp1_;
	_tmp2_ = file;
	if (!g_file_query_exists (_tmp2_, NULL)) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp3_ = utils_get_config_dir ();
		_tmp4_ = _tmp3_;
		utils_touch_dir (_tmp4_);
		_g_free0 (_tmp4_);
		_tmp5_ = self->config_file_path;
		utils_create_file (_tmp5_);
	} else {
		{
			GKeyFile* _tmp6_;
			const gchar* _tmp7_;
			_tmp6_ = self->config_file;
			_tmp7_ = self->config_file_path;
			g_key_file_load_from_file (_tmp6_, _tmp7_, G_KEY_FILE_NONE, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp8_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp8_ = self->config_file_path;
			if (!g_file_test (_tmp8_, G_FILE_TEST_EXISTS)) {
				GError* _tmp9_;
				const gchar* _tmp10_;
				_tmp9_ = e;
				_tmp10_ = _tmp9_->message;
				g_print ("Config: %s\n", _tmp10_);
			}
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_object_unref0 (file);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
___lambda31_ (WidgetsCommandPanel* self,
              GtkEntry* entry)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (entry != NULL);
	_tmp0_ = gtk_entry_get_text (entry);
	_tmp1_ = string_strip (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, "") != 0;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		const gchar* _tmp4_;
		GtkBox* _tmp5_;
		_tmp4_ = gtk_entry_get_text (entry);
		_tmp5_ = ((WidgetsBasePanel*) self)->home_page_box;
		widgets_base_panel_show_search_page ((WidgetsBasePanel*) self, _tmp4_, "", (GtkWidget*) _tmp5_);
	}
}

static void
____lambda31__gtk_entry_activate (GtkEntry* _sender,
                                  gpointer self)
{
	___lambda31_ ((WidgetsCommandPanel*) self, _sender);
}

static void
__lambda235_ (WidgetsCommandPanel* self)
{
	widgets_base_panel_update_home_page ((WidgetsBasePanel*) self);
}

static void
___lambda235__widgets_command_panel_update_page_after_edit (gpointer self)
{
	__lambda235_ ((WidgetsCommandPanel*) self);
}

static void
_____lambda42_ (WidgetsCommandPanel* self,
                WidgetsCommandButton* w,
                const gchar* command_name)
{
	g_return_if_fail (w != NULL);
	g_return_if_fail (command_name != NULL);
	widgets_command_panel_edit_command (self, command_name, ___lambda235__widgets_command_panel_update_page_after_edit, self);
}

static void
______lambda42__widgets_command_button_edit_command (WidgetsCommandButton* _sender,
                                                     const gchar* command_name,
                                                     gpointer self)
{
	_____lambda42_ ((WidgetsCommandPanel*) self, _sender, command_name);
}

static void
widgets_command_panel_real_create_home_page (WidgetsBasePanel* base)
{
	WidgetsCommandPanel * self;
	GtkBox* _tmp0_;
	GeeArrayList* ungroups = NULL;
	GeeArrayList* _tmp1_;
	GKeyFile* _tmp2_;
	gsize _tmp3_ = 0;
	gchar** _tmp4_;
	GeeArrayList* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	GtkScrolledWindow* _tmp19_;
	GtkBox* _tmp20_;
	GtkScrolledWindow* _tmp21_;
	GtkBox* command_box = NULL;
	GtkBox* _tmp22_;
	GtkScrolledWindow* _tmp23_;
	GtkBox* _tmp24_;
	GeeArrayList* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	WidgetsSplitLine* split_line = NULL;
	WidgetsSplitLine* _tmp50_;
	GtkBox* _tmp51_;
	WidgetsAddButton* add_command_button = NULL;
	WidgetsAddButton* _tmp52_;
	GtkBox* _tmp53_;
	self = (WidgetsCommandPanel*) base;
	_tmp0_ = ((WidgetsBasePanel*) self)->home_page_box;
	utils_destroy_all_children ((GtkContainer*) _tmp0_);
	_g_object_unref0 (((WidgetsBasePanel*) self)->home_page_scrolledwindow);
	((WidgetsBasePanel*) self)->home_page_scrolledwindow = NULL;
	_tmp1_ = gee_array_list_new (GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	ungroups = _tmp1_;
	widgets_command_panel_load_config (self);
	_tmp2_ = self->config_file;
	_tmp4_ = g_key_file_get_groups (_tmp2_, &_tmp3_);
	{
		gchar** option_collection = NULL;
		gint option_collection_length1 = 0;
		gint _option_collection_size_ = 0;
		gint option_it = 0;
		option_collection = _tmp4_;
		option_collection_length1 = _tmp3_;
		for (option_it = 0; option_it < option_collection_length1; option_it = option_it + 1) {
			const gchar* option = NULL;
			option = option_collection[option_it];
			{
				const gchar* _tmp5_;
				GeeArrayList* _tmp6_;
				GKeyFile* _tmp7_;
				_tmp5_ = option;
				_tmp6_ = ungroups;
				_tmp7_ = self->config_file;
				widgets_command_panel_add_group_item (self, _tmp5_, _tmp6_, _tmp7_);
			}
		}
		option_collection = (_vala_array_free (option_collection, option_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp8_ = ungroups;
	_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_ > 1) {
		WidgetsSearchEntry* search_entry = NULL;
		WidgetsSearchEntry* _tmp11_;
		GtkBox* _tmp12_;
		WidgetsSearchEntry* _tmp13_;
		WidgetsSearchEntry* _tmp14_;
		WidgetsEntry* _tmp15_;
		WidgetsSplitLine* split_line = NULL;
		WidgetsSplitLine* _tmp16_;
		GtkBox* _tmp17_;
		WidgetsSplitLine* _tmp18_;
		_tmp11_ = widgets_search_entry_new ();
		g_object_ref_sink (_tmp11_);
		search_entry = _tmp11_;
		_tmp12_ = ((WidgetsBasePanel*) self)->home_page_box;
		_tmp13_ = search_entry;
		gtk_box_pack_start (_tmp12_, (GtkWidget*) _tmp13_, FALSE, FALSE, (guint) 0);
		_tmp14_ = search_entry;
		_tmp15_ = _tmp14_->search_entry;
		g_signal_connect_object ((GtkEntry*) _tmp15_, "activate", (GCallback) ____lambda31__gtk_entry_activate, self, 0);
		_tmp16_ = widgets_split_line_new ();
		g_object_ref_sink (_tmp16_);
		split_line = _tmp16_;
		_tmp17_ = ((WidgetsBasePanel*) self)->home_page_box;
		_tmp18_ = split_line;
		gtk_box_pack_start (_tmp17_, (GtkWidget*) _tmp18_, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (split_line);
		_g_object_unref0 (search_entry);
	}
	_tmp19_ = widgets_base_panel_create_scrolled_window ((WidgetsBasePanel*) self);
	_g_object_unref0 (((WidgetsBasePanel*) self)->home_page_scrolledwindow);
	((WidgetsBasePanel*) self)->home_page_scrolledwindow = _tmp19_;
	_tmp20_ = ((WidgetsBasePanel*) self)->home_page_box;
	_tmp21_ = ((WidgetsBasePanel*) self)->home_page_scrolledwindow;
	gtk_box_pack_start (_tmp20_, (GtkWidget*) _tmp21_, TRUE, TRUE, (guint) 0);
	_tmp22_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp22_);
	command_box = _tmp22_;
	_tmp23_ = ((WidgetsBasePanel*) self)->home_page_scrolledwindow;
	_tmp24_ = command_box;
	gtk_container_add ((GtkContainer*) _tmp23_, (GtkWidget*) _tmp24_);
	_tmp25_ = ungroups;
	_tmp26_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp25_);
	_tmp27_ = _tmp26_;
	if (_tmp27_ > 0) {
		{
			GeeArrayList* _ungroup_list_list = NULL;
			GeeArrayList* _tmp28_;
			gint _ungroup_list_size = 0;
			GeeArrayList* _tmp29_;
			gint _tmp30_;
			gint _tmp31_;
			gint _ungroup_list_index = 0;
			_tmp28_ = ungroups;
			_ungroup_list_list = _tmp28_;
			_tmp29_ = _ungroup_list_list;
			_tmp30_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp29_);
			_tmp31_ = _tmp30_;
			_ungroup_list_size = _tmp31_;
			_ungroup_list_index = -1;
			while (TRUE) {
				gint _tmp32_;
				gint _tmp33_;
				GeeArrayList* ungroup_list = NULL;
				GeeArrayList* _tmp34_;
				gpointer _tmp35_;
				WidgetsCommandButton* command_button = NULL;
				GeeArrayList* _tmp36_;
				gpointer _tmp37_;
				gchar* _tmp38_;
				GeeArrayList* _tmp39_;
				gpointer _tmp40_;
				gchar* _tmp41_;
				GeeArrayList* _tmp42_;
				gpointer _tmp43_;
				gchar* _tmp44_;
				WidgetsCommandButton* _tmp45_;
				WidgetsCommandButton* _tmp46_;
				WidgetsCommandButton* _tmp47_;
				GtkBox* _tmp48_;
				WidgetsCommandButton* _tmp49_;
				_ungroup_list_index = _ungroup_list_index + 1;
				_tmp32_ = _ungroup_list_index;
				_tmp33_ = _ungroup_list_size;
				if (!(_tmp32_ < _tmp33_)) {
					break;
				}
				_tmp34_ = _ungroup_list_list;
				_tmp35_ = gee_abstract_list_get ((GeeAbstractList*) _tmp34_, _ungroup_list_index);
				ungroup_list = (GeeArrayList*) _tmp35_;
				_tmp36_ = ungroup_list;
				_tmp37_ = gee_abstract_list_get ((GeeAbstractList*) _tmp36_, 0);
				_tmp38_ = (gchar*) _tmp37_;
				_tmp39_ = ungroup_list;
				_tmp40_ = gee_abstract_list_get ((GeeAbstractList*) _tmp39_, 1);
				_tmp41_ = (gchar*) _tmp40_;
				_tmp42_ = ungroup_list;
				_tmp43_ = gee_abstract_list_get ((GeeAbstractList*) _tmp42_, 2);
				_tmp44_ = (gchar*) _tmp43_;
				_tmp45_ = widgets_command_panel_create_command_button (self, _tmp38_, _tmp41_, _tmp44_);
				_tmp46_ = _tmp45_;
				_g_free0 (_tmp44_);
				_g_free0 (_tmp41_);
				_g_free0 (_tmp38_);
				command_button = _tmp46_;
				_tmp47_ = command_button;
				g_signal_connect_object (_tmp47_, "edit-command", (GCallback) ______lambda42__widgets_command_button_edit_command, self, 0);
				_tmp48_ = command_box;
				_tmp49_ = command_button;
				gtk_box_pack_start (_tmp48_, (GtkWidget*) _tmp49_, FALSE, FALSE, (guint) 0);
				_g_object_unref0 (command_button);
				_g_object_unref0 (ungroup_list);
			}
		}
	}
	_tmp50_ = widgets_split_line_new ();
	g_object_ref_sink (_tmp50_);
	split_line = _tmp50_;
	_tmp51_ = ((WidgetsBasePanel*) self)->home_page_box;
	gtk_box_pack_start (_tmp51_, (GtkWidget*) split_line, FALSE, FALSE, (guint) 0);
	_tmp52_ = widgets_command_panel_create_add_command_button (self);
	add_command_button = _tmp52_;
	gtk_widget_set_margin_left ((GtkWidget*) add_command_button, 16);
	gtk_widget_set_margin_right ((GtkWidget*) add_command_button, 16);
	gtk_widget_set_margin_top ((GtkWidget*) add_command_button, 16);
	gtk_widget_set_margin_bottom ((GtkWidget*) add_command_button, 16);
	_tmp53_ = ((WidgetsBasePanel*) self)->home_page_box;
	gtk_box_pack_start (_tmp53_, (GtkWidget*) add_command_button, FALSE, FALSE, (guint) 0);
	_g_object_unref0 (add_command_button);
	_g_object_unref0 (split_line);
	_g_object_unref0 (command_box);
	_g_object_unref0 (ungroups);
}

void
widgets_command_panel_add_command (WidgetsCommandPanel* self,
                                   const gchar* name,
                                   const gchar* command,
                                   const gchar* shortcut)
{
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (command != NULL);
	g_return_if_fail (shortcut != NULL);
	if (g_strcmp0 (name, "") != 0) {
		_tmp0_ = g_strcmp0 (command, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		GKeyFile* _tmp3_;
		GKeyFile* _tmp4_;
		GKeyFile* _tmp5_;
		_tmp1_ = utils_get_config_dir ();
		_tmp2_ = _tmp1_;
		utils_touch_dir (_tmp2_);
		_g_free0 (_tmp2_);
		widgets_command_panel_load_config (self);
		_tmp3_ = self->config_file;
		g_key_file_set_list_separator (_tmp3_, ',');
		_tmp4_ = self->config_file;
		g_key_file_set_string (_tmp4_, name, "Command", command);
		_tmp5_ = self->config_file;
		g_key_file_set_string (_tmp5_, name, "Shortcut", shortcut);
		{
			GKeyFile* _tmp6_;
			const gchar* _tmp7_;
			_tmp6_ = self->config_file;
			_tmp7_ = self->config_file_path;
			g_key_file_save_to_file (_tmp6_, _tmp7_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp8_;
			GError* _tmp9_;
			const gchar* _tmp10_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp8_ = self->config_file_path;
			_tmp9_ = e;
			_tmp10_ = _tmp9_->message;
			g_print ("add_command error occur when config_file.save_to_file %s: %s\n", _tmp8_, _tmp10_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		WidgetsCommandPanel* self;
		self = _data7_->self;
		_g_free0 (_data7_->search_text);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		WidgetsCommandPanel* self;
		self = _data8_->_data7_->self;
		_g_object_unref0 (_data8_->search_label);
		block7_data_unref (_data8_->_data7_);
		_data8_->_data7_ = NULL;
		g_slice_free (Block8Data, _data8_);
	}
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
___lambda238_ (WidgetsCommandPanel* self,
               GdkEventButton* w)
{
	GtkBox* _tmp0_;
	g_return_if_fail (w != NULL);
	_tmp0_ = ((WidgetsBasePanel*) self)->search_page_box;
	widgets_base_panel_show_home_page ((WidgetsBasePanel*) self, (GtkWidget*) _tmp0_);
}

static void
____lambda238__widgets_click_event_box_clicked (WidgetsClickEventBox* _sender,
                                                GdkEventButton* event,
                                                gpointer self)
{
	___lambda238_ ((WidgetsCommandPanel*) self, event);
}

static void
__lambda240_ (Block8Data* _data8_)
{
	Block7Data* _data7_;
	WidgetsCommandPanel* self;
	_data7_ = _data8_->_data7_;
	self = _data7_->self;
	widgets_base_panel_update_search_page ((WidgetsBasePanel*) self, _data7_->search_text, "");
}

static void
___lambda240__widgets_command_panel_update_page_after_edit (gpointer self)
{
	__lambda240_ (self);
}

static void
_____lambda239_ (Block8Data* _data8_,
                 WidgetsCommandButton* w,
                 const gchar* command_name)
{
	Block7Data* _data7_;
	WidgetsCommandPanel* self;
	_data7_ = _data8_->_data7_;
	self = _data7_->self;
	g_return_if_fail (w != NULL);
	g_return_if_fail (command_name != NULL);
	widgets_command_panel_edit_command (self, command_name, ___lambda240__widgets_command_panel_update_page_after_edit, _data8_);
}

static void
______lambda239__widgets_command_button_edit_command (WidgetsCommandButton* _sender,
                                                      const gchar* command_name,
                                                      gpointer self)
{
	_____lambda239_ (self, _sender, command_name);
}

static void
___lambda241_ (Block8Data* _data8_,
               GtkWidget* w)
{
	Block7Data* _data7_;
	WidgetsCommandPanel* self;
	gboolean is_light_theme = FALSE;
	GtkWidget* _tmp0_;
	_data7_ = _data8_->_data7_;
	self = _data7_->self;
	g_return_if_fail (w != NULL);
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	is_light_theme = widgets_config_window_is_light_theme (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindow));
	if (is_light_theme) {
		GtkLabel* _tmp1_;
		GtkStyleContext* _tmp2_;
		_tmp1_ = _data8_->search_label;
		_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _tmp1_);
		gtk_style_context_add_class (_tmp2_, "remote_search_label_light");
	} else {
		GtkLabel* _tmp3_;
		GtkStyleContext* _tmp4_;
		_tmp3_ = _data8_->search_label;
		_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
		gtk_style_context_add_class (_tmp4_, "remote_search_label_dark");
	}
}

static void
____lambda241__gtk_widget_realize (GtkWidget* _sender,
                                   gpointer self)
{
	___lambda241_ (self, _sender);
}

static void
widgets_command_panel_real_create_search_page (WidgetsBasePanel* base,
                                               const gchar* search_text,
                                               const gchar* group_name)
{
	WidgetsCommandPanel * self;
	Block7Data* _data7_;
	gchar* _tmp0_;
	GtkBox* _tmp1_;
	GError* _inner_error0_ = NULL;
	self = (WidgetsCommandPanel*) base;
	g_return_if_fail (search_text != NULL);
	g_return_if_fail (group_name != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = g_strdup (search_text);
	_g_free0 (_data7_->search_text);
	_data7_->search_text = _tmp0_;
	_tmp1_ = ((WidgetsBasePanel*) self)->search_page_box;
	utils_destroy_all_children ((GtkContainer*) _tmp1_);
	_g_object_unref0 (((WidgetsBasePanel*) self)->search_page_scrolledwindow);
	((WidgetsBasePanel*) self)->search_page_scrolledwindow = NULL;
	{
		Block8Data* _data8_;
		GeeArrayList* ungroups = NULL;
		GeeArrayList* _tmp2_;
		GKeyFile* _tmp3_;
		gsize _tmp4_ = 0;
		gchar** _tmp5_;
		GtkBox* top_box = NULL;
		GtkBox* _tmp41_;
		GtkBox* _tmp42_;
		GtkBox* _tmp43_;
		GtkBox* _tmp44_;
		WidgetsImageButton* back_button = NULL;
		WidgetsImageButton* _tmp45_;
		WidgetsImageButton* _tmp46_;
		WidgetsImageButton* _tmp47_;
		WidgetsImageButton* _tmp48_;
		GtkBox* _tmp49_;
		WidgetsImageButton* _tmp50_;
		GtkLabel* _tmp51_;
		GtkLabel* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		GtkBox* _tmp55_;
		GtkLabel* _tmp56_;
		WidgetsSplitLine* split_line = NULL;
		WidgetsSplitLine* _tmp57_;
		GtkBox* _tmp58_;
		WidgetsSplitLine* _tmp59_;
		GtkScrolledWindow* _tmp60_;
		GtkBox* _tmp61_;
		GtkScrolledWindow* _tmp62_;
		GtkBox* command_box = NULL;
		GtkBox* _tmp63_;
		GtkScrolledWindow* _tmp64_;
		GtkBox* _tmp65_;
		_data8_ = g_slice_new0 (Block8Data);
		_data8_->_ref_count_ = 1;
		_data8_->_data7_ = block7_data_ref (_data7_);
		widgets_command_panel_load_config (self);
		_tmp2_ = gee_array_list_new (GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		ungroups = _tmp2_;
		_tmp3_ = self->config_file;
		_tmp5_ = g_key_file_get_groups (_tmp3_, &_tmp4_);
		{
			gchar** option_collection = NULL;
			gint option_collection_length1 = 0;
			gint _option_collection_size_ = 0;
			gint option_it = 0;
			option_collection = _tmp5_;
			option_collection_length1 = _tmp4_;
			for (option_it = 0; option_it < option_collection_length1; option_it = option_it + 1) {
				const gchar* option = NULL;
				option = option_collection[option_it];
				{
					GeeArrayList* match_list = NULL;
					GeeArrayList* _tmp6_;
					GeeArrayList* _tmp7_;
					const gchar* _tmp8_;
					gchar** _tmp9_ = NULL;
					GKeyFile* _tmp10_;
					const gchar* _tmp11_;
					gsize _tmp12_ = 0;
					gchar** _tmp13_;
					gint _tmp9__length1;
					gint __tmp9__size_;
					_tmp6_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
					match_list = _tmp6_;
					_tmp7_ = match_list;
					_tmp8_ = option;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, _tmp8_);
					_tmp10_ = self->config_file;
					_tmp11_ = option;
					_tmp13_ = g_key_file_get_keys (_tmp10_, _tmp11_, &_tmp12_, &_inner_error0_);
					_tmp9_ = _tmp13_;
					_tmp9__length1 = _tmp12_;
					__tmp9__size_ = _tmp9__length1;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (match_list);
						option_collection = (_vala_array_free (option_collection, option_collection_length1, (GDestroyNotify) g_free), NULL);
						_g_object_unref0 (ungroups);
						block8_data_unref (_data8_);
						_data8_ = NULL;
						goto __catch0_g_error;
					}
					{
						gchar** key_collection = NULL;
						gint key_collection_length1 = 0;
						gint _key_collection_size_ = 0;
						gint key_it = 0;
						key_collection = _tmp9_;
						key_collection_length1 = _tmp9__length1;
						for (key_it = 0; key_it < key_collection_length1; key_it = key_it + 1) {
							gchar* _tmp14_;
							gchar* key = NULL;
							_tmp14_ = g_strdup (key_collection[key_it]);
							key = _tmp14_;
							{
								gboolean _tmp15_ = FALSE;
								const gchar* _tmp16_;
								_tmp16_ = key;
								if (g_strcmp0 (_tmp16_, "Command") == 0) {
									_tmp15_ = TRUE;
								} else {
									const gchar* _tmp17_;
									_tmp17_ = key;
									_tmp15_ = g_strcmp0 (_tmp17_, "Shortcut") == 0;
								}
								if (_tmp15_) {
									gchar* _tmp18_ = NULL;
									GKeyFile* _tmp19_;
									const gchar* _tmp20_;
									const gchar* _tmp21_;
									gchar* _tmp22_;
									GeeArrayList* _tmp23_;
									_tmp19_ = self->config_file;
									_tmp20_ = option;
									_tmp21_ = key;
									_tmp22_ = g_key_file_get_value (_tmp19_, _tmp20_, _tmp21_, &_inner_error0_);
									_tmp18_ = _tmp22_;
									if (G_UNLIKELY (_inner_error0_ != NULL)) {
										_g_free0 (key);
										_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
										_g_object_unref0 (match_list);
										option_collection = (_vala_array_free (option_collection, option_collection_length1, (GDestroyNotify) g_free), NULL);
										_g_object_unref0 (ungroups);
										block8_data_unref (_data8_);
										_data8_ = NULL;
										goto __catch0_g_error;
									}
									_tmp23_ = match_list;
									gee_abstract_collection_add ((GeeAbstractCollection*) _tmp23_, _tmp18_);
									_g_free0 (_tmp18_);
								}
								_g_free0 (key);
							}
						}
					}
					{
						GeeArrayList* _match_text_list = NULL;
						GeeArrayList* _tmp24_;
						gint _match_text_size = 0;
						GeeArrayList* _tmp25_;
						gint _tmp26_;
						gint _tmp27_;
						gint _match_text_index = 0;
						_tmp24_ = match_list;
						_match_text_list = _tmp24_;
						_tmp25_ = _match_text_list;
						_tmp26_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp25_);
						_tmp27_ = _tmp26_;
						_match_text_size = _tmp27_;
						_match_text_index = -1;
						while (TRUE) {
							gint _tmp28_;
							gint _tmp29_;
							gchar* match_text = NULL;
							GeeArrayList* _tmp30_;
							gpointer _tmp31_;
							const gchar* _tmp32_;
							gchar* _tmp33_;
							gchar* _tmp34_;
							gchar* _tmp35_;
							gchar* _tmp36_;
							gboolean _tmp37_;
							_match_text_index = _match_text_index + 1;
							_tmp28_ = _match_text_index;
							_tmp29_ = _match_text_size;
							if (!(_tmp28_ < _tmp29_)) {
								break;
							}
							_tmp30_ = _match_text_list;
							_tmp31_ = gee_abstract_list_get ((GeeAbstractList*) _tmp30_, _match_text_index);
							match_text = (gchar*) _tmp31_;
							_tmp32_ = match_text;
							_tmp33_ = g_utf8_strdown (_tmp32_, (gssize) -1);
							_tmp34_ = _tmp33_;
							_tmp35_ = g_utf8_strdown (_data7_->search_text, (gssize) -1);
							_tmp36_ = _tmp35_;
							_tmp37_ = string_contains (_tmp34_, _tmp36_);
							_g_free0 (_tmp36_);
							_g_free0 (_tmp34_);
							if (_tmp37_) {
								const gchar* _tmp38_;
								GeeArrayList* _tmp39_;
								GKeyFile* _tmp40_;
								_tmp38_ = option;
								_tmp39_ = ungroups;
								_tmp40_ = self->config_file;
								widgets_command_panel_add_group_item (self, _tmp38_, _tmp39_, _tmp40_);
								_g_free0 (match_text);
								break;
							}
							_g_free0 (match_text);
						}
					}
					_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (match_list);
				}
			}
			option_collection = (_vala_array_free (option_collection, option_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp41_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
		g_object_ref_sink (_tmp41_);
		top_box = _tmp41_;
		_tmp42_ = top_box;
		gtk_widget_set_size_request ((GtkWidget*) _tmp42_, -1, constant_REMOTE_PANEL_SEARCHBAR_HEIGHT);
		_tmp43_ = ((WidgetsBasePanel*) self)->search_page_box;
		_tmp44_ = top_box;
		gtk_box_pack_start (_tmp43_, (GtkWidget*) _tmp44_, FALSE, FALSE, (guint) 0);
		_tmp45_ = widgets_image_button_new ("back", TRUE, NULL, 12);
		g_object_ref_sink (_tmp45_);
		back_button = _tmp45_;
		_tmp46_ = back_button;
		gtk_widget_set_margin_left ((GtkWidget*) _tmp46_, ((WidgetsBasePanel*) self)->back_button_margin_left);
		_tmp47_ = back_button;
		gtk_widget_set_margin_top ((GtkWidget*) _tmp47_, ((WidgetsBasePanel*) self)->back_button_margin_top);
		_tmp48_ = back_button;
		g_signal_connect_object ((WidgetsClickEventBox*) _tmp48_, "clicked", (GCallback) ____lambda238__widgets_click_event_box_clicked, self, 0);
		_tmp49_ = top_box;
		_tmp50_ = back_button;
		gtk_box_pack_start (_tmp49_, (GtkWidget*) _tmp50_, FALSE, FALSE, (guint) 0);
		_tmp51_ = (GtkLabel*) gtk_label_new (NULL);
		g_object_ref_sink (_tmp51_);
		_data8_->search_label = _tmp51_;
		_tmp52_ = _data8_->search_label;
		_tmp53_ = g_strdup_printf ("%s %s", _ ("Search:"), _data7_->search_text);
		_tmp54_ = _tmp53_;
		gtk_label_set_text (_tmp52_, _tmp54_);
		_g_free0 (_tmp54_);
		_tmp55_ = top_box;
		_tmp56_ = _data8_->search_label;
		gtk_box_pack_start (_tmp55_, (GtkWidget*) _tmp56_, TRUE, TRUE, (guint) 0);
		_tmp57_ = widgets_split_line_new ();
		g_object_ref_sink (_tmp57_);
		split_line = _tmp57_;
		_tmp58_ = ((WidgetsBasePanel*) self)->search_page_box;
		_tmp59_ = split_line;
		gtk_box_pack_start (_tmp58_, (GtkWidget*) _tmp59_, FALSE, FALSE, (guint) 0);
		_tmp60_ = widgets_base_panel_create_scrolled_window ((WidgetsBasePanel*) self);
		_g_object_unref0 (((WidgetsBasePanel*) self)->search_page_scrolledwindow);
		((WidgetsBasePanel*) self)->search_page_scrolledwindow = _tmp60_;
		_tmp61_ = ((WidgetsBasePanel*) self)->search_page_box;
		_tmp62_ = ((WidgetsBasePanel*) self)->search_page_scrolledwindow;
		gtk_box_pack_start (_tmp61_, (GtkWidget*) _tmp62_, TRUE, TRUE, (guint) 0);
		_tmp63_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
		g_object_ref_sink (_tmp63_);
		command_box = _tmp63_;
		_tmp64_ = ((WidgetsBasePanel*) self)->search_page_scrolledwindow;
		_tmp65_ = command_box;
		gtk_container_add ((GtkContainer*) _tmp64_, (GtkWidget*) _tmp65_);
		{
			GeeArrayList* _ungroup_list_list = NULL;
			GeeArrayList* _tmp66_;
			gint _ungroup_list_size = 0;
			GeeArrayList* _tmp67_;
			gint _tmp68_;
			gint _tmp69_;
			gint _ungroup_list_index = 0;
			_tmp66_ = ungroups;
			_ungroup_list_list = _tmp66_;
			_tmp67_ = _ungroup_list_list;
			_tmp68_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp67_);
			_tmp69_ = _tmp68_;
			_ungroup_list_size = _tmp69_;
			_ungroup_list_index = -1;
			while (TRUE) {
				gint _tmp70_;
				gint _tmp71_;
				GeeArrayList* ungroup_list = NULL;
				GeeArrayList* _tmp72_;
				gpointer _tmp73_;
				WidgetsCommandButton* command_button = NULL;
				GeeArrayList* _tmp74_;
				gpointer _tmp75_;
				gchar* _tmp76_;
				GeeArrayList* _tmp77_;
				gpointer _tmp78_;
				gchar* _tmp79_;
				GeeArrayList* _tmp80_;
				gpointer _tmp81_;
				gchar* _tmp82_;
				WidgetsCommandButton* _tmp83_;
				WidgetsCommandButton* _tmp84_;
				WidgetsCommandButton* _tmp85_;
				GtkBox* _tmp86_;
				WidgetsCommandButton* _tmp87_;
				_ungroup_list_index = _ungroup_list_index + 1;
				_tmp70_ = _ungroup_list_index;
				_tmp71_ = _ungroup_list_size;
				if (!(_tmp70_ < _tmp71_)) {
					break;
				}
				_tmp72_ = _ungroup_list_list;
				_tmp73_ = gee_abstract_list_get ((GeeAbstractList*) _tmp72_, _ungroup_list_index);
				ungroup_list = (GeeArrayList*) _tmp73_;
				_tmp74_ = ungroup_list;
				_tmp75_ = gee_abstract_list_get ((GeeAbstractList*) _tmp74_, 0);
				_tmp76_ = (gchar*) _tmp75_;
				_tmp77_ = ungroup_list;
				_tmp78_ = gee_abstract_list_get ((GeeAbstractList*) _tmp77_, 1);
				_tmp79_ = (gchar*) _tmp78_;
				_tmp80_ = ungroup_list;
				_tmp81_ = gee_abstract_list_get ((GeeAbstractList*) _tmp80_, 2);
				_tmp82_ = (gchar*) _tmp81_;
				_tmp83_ = widgets_command_panel_create_command_button (self, _tmp76_, _tmp79_, _tmp82_);
				_tmp84_ = _tmp83_;
				_g_free0 (_tmp82_);
				_g_free0 (_tmp79_);
				_g_free0 (_tmp76_);
				command_button = _tmp84_;
				_tmp85_ = command_button;
				g_signal_connect_data (_tmp85_, "edit-command", (GCallback) ______lambda239__widgets_command_button_edit_command, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
				_tmp86_ = command_box;
				_tmp87_ = command_button;
				gtk_box_pack_start (_tmp86_, (GtkWidget*) _tmp87_, FALSE, FALSE, (guint) 0);
				_g_object_unref0 (command_button);
				_g_object_unref0 (ungroup_list);
			}
		}
		g_signal_connect_data ((GtkWidget*) self, "realize", (GCallback) ____lambda241__gtk_widget_realize, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
		_g_object_unref0 (command_box);
		_g_object_unref0 (split_line);
		_g_object_unref0 (back_button);
		_g_object_unref0 (top_box);
		_g_object_unref0 (ungroups);
		block8_data_unref (_data8_);
		_data8_ = NULL;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp88_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp88_ = self->config_file_path;
		if (!g_file_test (_tmp88_, G_FILE_TEST_EXISTS)) {
			GError* _tmp89_;
			const gchar* _tmp90_;
			_tmp89_ = e;
			_tmp90_ = _tmp89_->message;
			g_print ("CommandPanel create_search_page: %s\n", _tmp90_);
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		block7_data_unref (_data7_);
		_data7_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	block7_data_unref (_data7_);
	_data7_ = NULL;
}

void
widgets_command_panel_add_group_item (WidgetsCommandPanel* self,
                                      const gchar* option,
                                      GeeArrayList* lists,
                                      GKeyFile* config_file)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (option != NULL);
	g_return_if_fail (lists != NULL);
	g_return_if_fail (config_file != NULL);
	{
		GeeArrayList* list = NULL;
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		GeeArrayList* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		GeeArrayList* _tmp7_;
		GeeArrayList* _tmp8_;
		_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
		list = _tmp0_;
		_tmp1_ = list;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, option);
		_tmp3_ = g_key_file_get_value (config_file, option, "Command", &_inner_error0_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (list);
			goto __catch0_g_error;
		}
		_tmp4_ = list;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, _tmp2_);
		_tmp6_ = g_key_file_get_value (config_file, option, "Shortcut", &_inner_error0_);
		_tmp5_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp2_);
			_g_object_unref0 (list);
			goto __catch0_g_error;
		}
		_tmp7_ = list;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, _tmp5_);
		_tmp8_ = list;
		gee_abstract_collection_add ((GeeAbstractCollection*) lists, _tmp8_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp2_);
		_g_object_unref0 (list);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_print ("add_group_item error: %s\n", _tmp10_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		WidgetsCommandPanel* self;
		self = _data9_->self;
		_g_object_unref0 (_data9_->command_dialog);
		_g_free0 (_data9_->command_name);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static void
__lambda233_ (Block9Data* _data9_,
              const gchar* name)
{
	WidgetsCommandPanel* self;
	GError* _inner_error0_ = NULL;
	self = _data9_->self;
	g_return_if_fail (name != NULL);
	{
		GKeyFile* _tmp0_;
		_tmp0_ = self->config_file;
		if (g_key_file_has_group (_tmp0_, _data9_->command_name)) {
			GKeyFile* _tmp1_;
			GKeyFile* _tmp2_;
			const gchar* _tmp3_;
			_tmp1_ = self->config_file;
			g_key_file_remove_group (_tmp1_, _data9_->command_name, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp2_ = self->config_file;
			_tmp3_ = self->config_file_path;
			g_key_file_save_to_file (_tmp2_, _tmp3_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		_data9_->func (_data9_->func_target);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e->message;
		g_error ("command_panel.vala:266: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda233__widgets_command_dialog_delete_command (WidgetsCommandDialog* _sender,
                                                     const gchar* name,
                                                     gpointer self)
{
	__lambda233_ (self, name);
}

static void
__lambda234_ (Block9Data* _data9_,
              const gchar* name,
              const gchar* command,
              const gchar* shortcut)
{
	WidgetsCommandPanel* self;
	GError* _inner_error0_ = NULL;
	self = _data9_->self;
	g_return_if_fail (name != NULL);
	g_return_if_fail (command != NULL);
	g_return_if_fail (shortcut != NULL);
	{
		GKeyFile* _tmp0_;
		_tmp0_ = self->config_file;
		if (g_key_file_has_group (_tmp0_, _data9_->command_name)) {
			GKeyFile* _tmp1_;
			GKeyFile* _tmp2_;
			const gchar* _tmp3_;
			_tmp1_ = self->config_file;
			g_key_file_remove_group (_tmp1_, _data9_->command_name, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp2_ = self->config_file;
			_tmp3_ = self->config_file_path;
			g_key_file_save_to_file (_tmp2_, _tmp3_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		widgets_command_panel_add_command (self, name, command, shortcut);
		_data9_->func (_data9_->func_target);
		gtk_widget_destroy ((GtkWidget*) _data9_->command_dialog);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e->message;
		g_error ("command_panel.vala:284: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda234__widgets_command_dialog_edit_command (WidgetsCommandDialog* _sender,
                                                   const gchar* name,
                                                   const gchar* command,
                                                   const gchar* shortcut,
                                                   gpointer self)
{
	__lambda234_ (self, name, command, shortcut);
}

void
widgets_command_panel_edit_command (WidgetsCommandPanel* self,
                                    const gchar* command_name,
                                    WidgetsCommandPanelUpdatePageAfterEdit func,
                                    gpointer func_target)
{
	Block9Data* _data9_;
	gchar* _tmp0_;
	WidgetsConfigWindow* _tmp1_;
	GKeyFile* _tmp2_;
	WidgetsCommandDialog* _tmp3_;
	WidgetsConfigWindow* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (command_name != NULL);
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_tmp0_ = g_strdup (command_name);
	_g_free0 (_data9_->command_name);
	_data9_->command_name = _tmp0_;
	_data9_->func = func;
	_data9_->func_target = func_target;
	widgets_command_panel_load_config (self);
	_tmp1_ = ((WidgetsBasePanel*) self)->parent_window;
	_tmp2_ = self->config_file;
	_tmp3_ = widgets_command_dialog_new (_tmp1_, NULL, (GtkWidget*) self, _data9_->command_name, _tmp2_);
	g_object_ref_sink (_tmp3_);
	_data9_->command_dialog = _tmp3_;
	_tmp4_ = ((WidgetsBasePanel*) self)->parent_window;
	widgets_dialog_transient_for_window ((WidgetsDialog*) _data9_->command_dialog, _tmp4_);
	g_signal_connect_data (_data9_->command_dialog, "delete-command", (GCallback) ___lambda233__widgets_command_dialog_delete_command, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
	g_signal_connect_data (_data9_->command_dialog, "edit-command", (GCallback) ___lambda234__widgets_command_dialog_edit_command, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
	gtk_widget_show_all ((GtkWidget*) _data9_->command_dialog);
	block9_data_unref (_data9_);
	_data9_ = NULL;
}

static void
__lambda41_ (WidgetsCommandPanel* self,
             WidgetsCommandButton* w,
             const gchar* command)
{
	g_return_if_fail (w != NULL);
	g_return_if_fail (command != NULL);
	widgets_command_panel_execute_command (self, command);
}

static void
___lambda41__widgets_command_button_execute_command (WidgetsCommandButton* _sender,
                                                     const gchar* command_value,
                                                     gpointer self)
{
	__lambda41_ ((WidgetsCommandPanel*) self, _sender, command_value);
}

WidgetsCommandButton*
widgets_command_panel_create_command_button (WidgetsCommandPanel* self,
                                             const gchar* name,
                                             const gchar* value,
                                             const gchar* shortcut)
{
	WidgetsCommandButton* command_button = NULL;
	WidgetsCommandButton* _tmp0_;
	WidgetsCommandButton* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (value != NULL, NULL);
	g_return_val_if_fail (shortcut != NULL, NULL);
	_tmp0_ = widgets_command_button_new (name, value, shortcut);
	g_object_ref_sink (_tmp0_);
	command_button = _tmp0_;
	g_signal_connect_object (command_button, "execute-command", (GCallback) ___lambda41__widgets_command_button_execute_command, self, 0);
	result = command_button;
	return result;
}

void
widgets_command_panel_execute_command (WidgetsCommandPanel* self,
                                       const gchar* command)
{
	WidgetsTerm* focus_term = NULL;
	WidgetsWorkspaceManager* _tmp0_;
	WidgetsWorkspace* _tmp1_;
	WidgetsWorkspaceManager* _tmp2_;
	WidgetsWorkspace* _tmp3_;
	WidgetsTerm* _tmp4_;
	gchar* command_string = NULL;
	gchar* _tmp5_;
	WidgetsTerm* _tmp6_;
	VteTerminal* _tmp7_;
	const gchar* _tmp8_;
	gint _tmp9_ = 0;
	guint8* _tmp10_;
	guint8* _tmp11_;
	gint _tmp11__length1;
	WidgetsWorkspace* _tmp12_;
	GtkWidget* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (command != NULL);
	_tmp0_ = ((WidgetsBasePanel*) self)->workspace_manager;
	_tmp1_ = _tmp0_->focus_workspace;
	_tmp2_ = ((WidgetsBasePanel*) self)->workspace_manager;
	_tmp3_ = _tmp2_->focus_workspace;
	_tmp4_ = widgets_workspace_get_focus_term (_tmp1_, (GtkContainer*) _tmp3_);
	focus_term = _tmp4_;
	_tmp5_ = g_strdup_printf ("%s\n", command);
	command_string = _tmp5_;
	_tmp6_ = focus_term;
	_tmp7_ = _tmp6_->term;
	_tmp8_ = command_string;
	_tmp10_ = utils_to_raw_data (_tmp8_, &_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp11__length1 = _tmp9_;
	vte_terminal_feed_child (_tmp7_, _tmp11_, (gssize) _tmp9_);
	_tmp11_ = (g_free (_tmp11_), NULL);
	_tmp12_ = ((WidgetsBasePanel*) self)->workspace;
	widgets_workspace_hide_command_panel (_tmp12_);
	_tmp13_ = ((WidgetsBasePanel*) self)->focus_widget;
	if (_tmp13_ != NULL) {
		GtkWidget* _tmp14_;
		_tmp14_ = ((WidgetsBasePanel*) self)->focus_widget;
		gtk_widget_grab_focus (_tmp14_);
	}
	_g_free0 (command_string);
	_g_object_unref0 (focus_term);
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		WidgetsCommandPanel* self;
		self = _data10_->self;
		_g_object_unref0 (_data10_->command_dialog);
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}

static void
__lambda237_ (Block10Data* _data10_,
              const gchar* name,
              const gchar* command,
              const gchar* shortcut)
{
	WidgetsCommandPanel* self;
	self = _data10_->self;
	g_return_if_fail (name != NULL);
	g_return_if_fail (command != NULL);
	g_return_if_fail (shortcut != NULL);
	widgets_command_panel_add_command (self, name, command, shortcut);
	widgets_base_panel_update_home_page ((WidgetsBasePanel*) self);
	gtk_widget_destroy ((GtkWidget*) _data10_->command_dialog);
}

static void
___lambda237__widgets_command_dialog_add_command (WidgetsCommandDialog* _sender,
                                                  const gchar* name,
                                                  const gchar* command,
                                                  const gchar* shortcut,
                                                  gpointer self)
{
	__lambda237_ (self, name, command, shortcut);
}

static void
__lambda236_ (WidgetsCommandPanel* self,
              GtkButton* w)
{
	Block10Data* _data10_;
	WidgetsTerm* focus_term = NULL;
	WidgetsWorkspaceManager* _tmp0_;
	WidgetsWorkspace* _tmp1_;
	WidgetsWorkspaceManager* _tmp2_;
	WidgetsWorkspace* _tmp3_;
	WidgetsTerm* _tmp4_;
	WidgetsConfigWindow* _tmp5_;
	WidgetsCommandDialog* _tmp6_;
	WidgetsConfigWindow* _tmp7_;
	g_return_if_fail (w != NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_tmp0_ = ((WidgetsBasePanel*) self)->workspace_manager;
	_tmp1_ = _tmp0_->focus_workspace;
	_tmp2_ = ((WidgetsBasePanel*) self)->workspace_manager;
	_tmp3_ = _tmp2_->focus_workspace;
	_tmp4_ = widgets_workspace_get_focus_term (_tmp1_, (GtkContainer*) _tmp3_);
	focus_term = _tmp4_;
	_tmp5_ = ((WidgetsBasePanel*) self)->parent_window;
	_tmp6_ = widgets_command_dialog_new (_tmp5_, focus_term, (GtkWidget*) self, NULL, NULL);
	g_object_ref_sink (_tmp6_);
	_data10_->command_dialog = _tmp6_;
	_tmp7_ = ((WidgetsBasePanel*) self)->parent_window;
	widgets_dialog_transient_for_window ((WidgetsDialog*) _data10_->command_dialog, _tmp7_);
	g_signal_connect_data (_data10_->command_dialog, "add-command", (GCallback) ___lambda237__widgets_command_dialog_add_command, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	gtk_widget_show_all ((GtkWidget*) _data10_->command_dialog);
	_g_object_unref0 (focus_term);
	block10_data_unref (_data10_);
	_data10_ = NULL;
}

static void
___lambda236__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	__lambda236_ ((WidgetsCommandPanel*) self, _sender);
}

WidgetsAddButton*
widgets_command_panel_create_add_command_button (WidgetsCommandPanel* self)
{
	WidgetsAddButton* add_command_button = NULL;
	WidgetsAddButton* _tmp0_;
	WidgetsAddButton* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = widgets_add_button_new (_ ("Add command"));
	g_object_ref_sink (_tmp0_);
	add_command_button = _tmp0_;
	g_signal_connect_object ((GtkButton*) add_command_button, "clicked", (GCallback) ___lambda236__gtk_button_clicked, self, 0);
	result = add_command_button;
	return result;
}

static void
widgets_command_panel_class_init (WidgetsCommandPanelClass * klass,
                                  gpointer klass_data)
{
	widgets_command_panel_parent_class = g_type_class_peek_parent (klass);
	((WidgetsBasePanelClass *) klass)->create_home_page = (void (*) (WidgetsBasePanel*)) widgets_command_panel_real_create_home_page;
	((WidgetsBasePanelClass *) klass)->create_search_page = (void (*) (WidgetsBasePanel*, const gchar*, const gchar*)) widgets_command_panel_real_create_search_page;
	G_OBJECT_CLASS (klass)->finalize = widgets_command_panel_finalize;
}

static void
widgets_command_panel_instance_init (WidgetsCommandPanel * self,
                                     gpointer klass)
{
	gchar* _tmp0_;
	self->width = constant_SLIDER_WIDTH;
	_tmp0_ = utils_get_config_file_path ("command-config.conf");
	self->config_file_path = _tmp0_;
}

static void
widgets_command_panel_finalize (GObject * obj)
{
	WidgetsCommandPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WIDGETS_TYPE_COMMAND_PANEL, WidgetsCommandPanel);
	_g_key_file_unref0 (self->config_file);
	_g_free0 (self->config_file_path);
	G_OBJECT_CLASS (widgets_command_panel_parent_class)->finalize (obj);
}

static GType
widgets_command_panel_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WidgetsCommandPanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) widgets_command_panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WidgetsCommandPanel), 0, (GInstanceInitFunc) widgets_command_panel_instance_init, NULL };
	GType widgets_command_panel_type_id;
	widgets_command_panel_type_id = g_type_register_static (WIDGETS_TYPE_BASE_PANEL, "WidgetsCommandPanel", &g_define_type_info, 0);
	return widgets_command_panel_type_id;
}

GType
widgets_command_panel_get_type (void)
{
	static volatile gsize widgets_command_panel_type_id__once = 0;
	if (g_once_init_enter (&widgets_command_panel_type_id__once)) {
		GType widgets_command_panel_type_id;
		widgets_command_panel_type_id = widgets_command_panel_get_type_once ();
		g_once_init_leave (&widgets_command_panel_type_id__once, widgets_command_panel_type_id);
	}
	return widgets_command_panel_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

