/* progressbar.c generated by valac 0.56.17, the Vala compiler
 * generated from progressbar.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2011 ~ 2018 Deepin, Inc.
 *               2011 ~ 2018 Wang Yong
 *
 * Author:     Wang Yong <wangyong@deepin.com>
 * Maintainer: Wang Yong <wangyong@deepin.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define WIDGETS_TYPE_PROGRESS_BAR (widgets_progress_bar_get_type ())
#define WIDGETS_PROGRESS_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_PROGRESS_BAR, WidgetsProgressBar))
#define WIDGETS_PROGRESS_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_PROGRESS_BAR, WidgetsProgressBarClass))
#define WIDGETS_IS_PROGRESS_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_PROGRESS_BAR))
#define WIDGETS_IS_PROGRESS_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_PROGRESS_BAR))
#define WIDGETS_PROGRESS_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_PROGRESS_BAR, WidgetsProgressBarClass))

typedef struct _WidgetsProgressBar WidgetsProgressBar;
typedef struct _WidgetsProgressBarClass WidgetsProgressBarClass;
typedef struct _WidgetsProgressBarPrivate WidgetsProgressBarPrivate;
enum  {
	WIDGETS_PROGRESS_BAR_0_PROPERTY,
	WIDGETS_PROGRESS_BAR_NUM_PROPERTIES
};
static GParamSpec* widgets_progress_bar_properties[WIDGETS_PROGRESS_BAR_NUM_PROPERTIES];
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
enum  {
	WIDGETS_PROGRESS_BAR_UPDATE_SIGNAL,
	WIDGETS_PROGRESS_BAR_NUM_SIGNALS
};
static guint widgets_progress_bar_signals[WIDGETS_PROGRESS_BAR_NUM_SIGNALS] = {0};

struct _WidgetsProgressBar {
	GtkEventBox parent_instance;
	WidgetsProgressBarPrivate * priv;
	gdouble draw_percent;
	gdouble percent;
	gint height;
	cairo_surface_t* pointer_surface;
	GdkRGBA background_color;
	GdkRGBA foreground_color;
	gint draw_pointer_offset;
	gint line_height;
	gint line_margin_top;
	gint width;
};

struct _WidgetsProgressBarClass {
	GtkEventBoxClass parent_class;
};

static gpointer widgets_progress_bar_parent_class = NULL;
VALA_EXTERN gint constant_PREFERENCE_WIDGET_WIDTH;
VALA_EXTERN gdouble constant_TERMINAL_MIN_OPACITY;

VALA_EXTERN GType widgets_progress_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsProgressBar, g_object_unref)
VALA_EXTERN WidgetsProgressBar* widgets_progress_bar_new (gdouble init_percent);
VALA_EXTERN WidgetsProgressBar* widgets_progress_bar_construct (GType object_type,
                                                    gdouble init_percent);
VALA_EXTERN void utils_hex_to_rgba (const gchar* hex_color,
                        gdouble alpha,
                        GdkRGBA* result);
VALA_EXTERN cairo_surface_t* utils_create_image_surface (const gchar* surface_path);
static gboolean __lambda165_ (WidgetsProgressBar* self,
                       GtkWidget* w,
                       GdkEventButton* e);
VALA_EXTERN void widgets_progress_bar_set_percent (WidgetsProgressBar* self,
                                       gdouble new_percent);
static gboolean ___lambda165__gtk_widget_button_press_event (GtkWidget* _sender,
                                                      GdkEventButton* event,
                                                      gpointer self);
static gboolean __lambda166_ (WidgetsProgressBar* self,
                       GtkWidget* w,
                       GdkEventMotion* e);
static gboolean ___lambda166__gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                       GdkEventMotion* event,
                                                       gpointer self);
static gboolean widgets_progress_bar_on_draw (WidgetsProgressBar* self,
                                       GtkWidget* widget,
                                       cairo_t* cr);
static gboolean _widgets_progress_bar_on_draw_gtk_widget_draw (GtkWidget* _sender,
                                                        cairo_t* cr,
                                                        gpointer self);
VALA_EXTERN void utils_set_context_color (cairo_t* cr,
                              GdkRGBA* color);
VALA_EXTERN void draw_draw_rectangle (cairo_t* cr,
                          gint x,
                          gint y,
                          gint w,
                          gint h,
                          gboolean fill);
VALA_EXTERN void draw_draw_surface (cairo_t* cr,
                        cairo_surface_t* surface,
                        gint x,
                        gint y,
                        gint width,
                        gint height);
static void widgets_progress_bar_finalize (GObject * obj);
static GType widgets_progress_bar_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static gboolean
__lambda165_ (WidgetsProgressBar* self,
              GtkWidget* w,
              GdkEventButton* e)
{
	GtkAllocation rect = {0};
	GtkAllocation _tmp0_ = {0};
	GtkAllocation _tmp1_;
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	gtk_widget_get_allocation (w, &_tmp0_);
	rect = _tmp0_;
	_tmp1_ = rect;
	widgets_progress_bar_set_percent (self, (e->x * 1.0) / _tmp1_.width);
	result = FALSE;
	return result;
}

static gboolean
___lambda165__gtk_widget_button_press_event (GtkWidget* _sender,
                                             GdkEventButton* event,
                                             gpointer self)
{
	gboolean result;
	result = __lambda165_ ((WidgetsProgressBar*) self, _sender, event);
	return result;
}

static gboolean
__lambda166_ (WidgetsProgressBar* self,
              GtkWidget* w,
              GdkEventMotion* e)
{
	GtkAllocation rect = {0};
	GtkAllocation _tmp0_ = {0};
	GtkAllocation _tmp1_;
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	gtk_widget_get_allocation (w, &_tmp0_);
	rect = _tmp0_;
	_tmp1_ = rect;
	widgets_progress_bar_set_percent (self, (e->x * 1.0) / _tmp1_.width);
	result = FALSE;
	return result;
}

static gboolean
___lambda166__gtk_widget_motion_notify_event (GtkWidget* _sender,
                                              GdkEventMotion* event,
                                              gpointer self)
{
	gboolean result;
	result = __lambda166_ ((WidgetsProgressBar*) self, _sender, event);
	return result;
}

static gboolean
_widgets_progress_bar_on_draw_gtk_widget_draw (GtkWidget* _sender,
                                               cairo_t* cr,
                                               gpointer self)
{
	gboolean result;
	result = widgets_progress_bar_on_draw ((WidgetsProgressBar*) self, _sender, cr);
	return result;
}

WidgetsProgressBar*
widgets_progress_bar_construct (GType object_type,
                                gdouble init_percent)
{
	WidgetsProgressBar * self = NULL;
	GdkRGBA _tmp0_ = {0};
	GdkRGBA _tmp1_ = {0};
	cairo_surface_t* _tmp2_;
	self = (WidgetsProgressBar*) g_object_new (object_type, NULL);
	self->percent = init_percent;
	gtk_widget_set_size_request ((GtkWidget*) self, self->width, self->height);
	utils_hex_to_rgba ("#2ca7f8", 1.0, &_tmp0_);
	self->foreground_color = _tmp0_;
	utils_hex_to_rgba ("#A4A4A4", 1.0, &_tmp1_);
	self->background_color = _tmp1_;
	_tmp2_ = utils_create_image_surface ("progress_pointer.svg");
	_cairo_surface_destroy0 (self->pointer_surface);
	self->pointer_surface = _tmp2_;
	g_signal_connect_object ((GtkWidget*) self, "button-press-event", (GCallback) ___lambda165__gtk_widget_button_press_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "motion-notify-event", (GCallback) ___lambda166__gtk_widget_motion_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "draw", (GCallback) _widgets_progress_bar_on_draw_gtk_widget_draw, self, 0);
	gtk_widget_show_all ((GtkWidget*) self);
	return self;
}

WidgetsProgressBar*
widgets_progress_bar_new (gdouble init_percent)
{
	return widgets_progress_bar_construct (WIDGETS_TYPE_PROGRESS_BAR, init_percent);
}

void
widgets_progress_bar_set_percent (WidgetsProgressBar* self,
                                  gdouble new_percent)
{
	g_return_if_fail (self != NULL);
	self->percent = MAX (MIN (((1 - constant_TERMINAL_MIN_OPACITY) * new_percent) + constant_TERMINAL_MIN_OPACITY, (gdouble) 1), constant_TERMINAL_MIN_OPACITY);
	self->draw_percent = MAX (MIN (new_percent, (gdouble) 1), (gdouble) 0);
	g_signal_emit (self, widgets_progress_bar_signals[WIDGETS_PROGRESS_BAR_UPDATE_SIGNAL], 0, self->percent);
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static gboolean
widgets_progress_bar_on_draw (WidgetsProgressBar* self,
                              GtkWidget* widget,
                              cairo_t* cr)
{
	GtkAllocation rect = {0};
	GtkAllocation _tmp0_ = {0};
	gint left_offset = 0;
	gint right_offset = 0;
	GdkRGBA _tmp3_;
	GtkAllocation _tmp4_;
	cairo_surface_t* _tmp7_;
	GtkAllocation _tmp8_;
	cairo_surface_t* _tmp9_;
	GtkAllocation _tmp10_;
	cairo_surface_t* _tmp11_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (cr != NULL, FALSE);
	gtk_widget_get_allocation (widget, &_tmp0_);
	rect = _tmp0_;
	left_offset = 0;
	right_offset = 0;
	if (self->draw_percent == ((gdouble) 0)) {
		cairo_surface_t* _tmp1_;
		cairo_surface_t* _tmp2_;
		_tmp1_ = self->pointer_surface;
		left_offset = cairo_image_surface_get_width (_tmp1_) / 2;
		_tmp2_ = self->pointer_surface;
		right_offset = cairo_image_surface_get_width (_tmp2_) / 2;
	} else {
		if (self->draw_percent == ((gdouble) 1)) {
			left_offset = 0;
			right_offset = self->draw_pointer_offset;
		}
	}
	_tmp3_ = self->background_color;
	utils_set_context_color (cr, &_tmp3_);
	_tmp4_ = rect;
	draw_draw_rectangle (cr, left_offset, self->line_margin_top, _tmp4_.width - right_offset, self->line_height, TRUE);
	if (self->draw_percent > ((gdouble) 0)) {
		GdkRGBA _tmp5_;
		GtkAllocation _tmp6_;
		cairo_set_source_rgba (cr, (gdouble) 1, (gdouble) 0, (gdouble) 1, (gdouble) 1);
		_tmp5_ = self->foreground_color;
		utils_set_context_color (cr, &_tmp5_);
		_tmp6_ = rect;
		draw_draw_rectangle (cr, left_offset, self->line_margin_top, ((gint) (_tmp6_.width * self->draw_percent)) - right_offset, self->line_height, TRUE);
	}
	_tmp7_ = self->pointer_surface;
	_tmp8_ = rect;
	_tmp9_ = self->pointer_surface;
	_tmp10_ = rect;
	_tmp11_ = self->pointer_surface;
	draw_draw_surface (cr, _tmp7_, MAX (-self->draw_pointer_offset, MIN (((gint) (_tmp8_.width * self->draw_percent)) - ((cairo_image_surface_get_width (_tmp9_) / 2) / 2), (_tmp10_.width - cairo_image_surface_get_width (_tmp11_)) + self->draw_pointer_offset)), 0, 0, 0);
	result = TRUE;
	return result;
}

static void
widgets_progress_bar_class_init (WidgetsProgressBarClass * klass,
                                 gpointer klass_data)
{
	widgets_progress_bar_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = widgets_progress_bar_finalize;
	widgets_progress_bar_signals[WIDGETS_PROGRESS_BAR_UPDATE_SIGNAL] = g_signal_new ("update", WIDGETS_TYPE_PROGRESS_BAR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__DOUBLE, G_TYPE_NONE, 1, G_TYPE_DOUBLE);
}

static void
widgets_progress_bar_instance_init (WidgetsProgressBar * self,
                                    gpointer klass)
{
	self->height = 22;
	self->draw_pointer_offset = 3;
	self->line_height = 2;
	self->line_margin_top = 10;
	self->width = constant_PREFERENCE_WIDGET_WIDTH;
}

static void
widgets_progress_bar_finalize (GObject * obj)
{
	WidgetsProgressBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WIDGETS_TYPE_PROGRESS_BAR, WidgetsProgressBar);
	_cairo_surface_destroy0 (self->pointer_surface);
	G_OBJECT_CLASS (widgets_progress_bar_parent_class)->finalize (obj);
}

static GType
widgets_progress_bar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WidgetsProgressBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) widgets_progress_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WidgetsProgressBar), 0, (GInstanceInitFunc) widgets_progress_bar_instance_init, NULL };
	GType widgets_progress_bar_type_id;
	widgets_progress_bar_type_id = g_type_register_static (gtk_event_box_get_type (), "WidgetsProgressBar", &g_define_type_info, 0);
	return widgets_progress_bar_type_id;
}

GType
widgets_progress_bar_get_type (void)
{
	static volatile gsize widgets_progress_bar_type_id__once = 0;
	if (g_once_init_enter (&widgets_progress_bar_type_id__once)) {
		GType widgets_progress_bar_type_id;
		widgets_progress_bar_type_id = widgets_progress_bar_get_type_once ();
		g_once_init_leave (&widgets_progress_bar_type_id__once, widgets_progress_bar_type_id);
	}
	return widgets_progress_bar_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

