/* SearchProvider.c generated by valac 0.56.18, the Vala compiler
 * generated from SearchProvider.vala, do not modify */

/* SearchProvider.vala
 *
 * Copyright (C) 2020-2025 Jerry Casiano
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.
 *
 * If not, see <http://www.gnu.org/licenses/gpl-3.0.txt>.
*/

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <json-glib/json-glib.h>
#include "font-manager.h"
#include <sqlite3.h>

#define FONT_MANAGER_SEARCH_PROVIDER_SEARCH_PROVIDER_BUS_PATH "/com/github/FontManager/FontManager/SearchProvider"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FONT_MANAGER_TYPE_SEARCH_PROVIDER (font_manager_search_provider_get_type ())
#define FONT_MANAGER_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_SEARCH_PROVIDER, FontManagerSearchProvider))
#define FONT_MANAGER_SEARCH_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_SEARCH_PROVIDER, FontManagerSearchProviderClass))
#define FONT_MANAGER_IS_SEARCH_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_SEARCH_PROVIDER))
#define FONT_MANAGER_IS_SEARCH_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_SEARCH_PROVIDER))
#define FONT_MANAGER_SEARCH_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_SEARCH_PROVIDER, FontManagerSearchProviderClass))

typedef struct _FontManagerSearchProvider FontManagerSearchProvider;
typedef struct _FontManagerSearchProviderClass FontManagerSearchProviderClass;
typedef struct _FontManagerSearchProviderPrivate FontManagerSearchProviderPrivate;
enum  {
	FONT_MANAGER_SEARCH_PROVIDER_0_PROPERTY,
	FONT_MANAGER_SEARCH_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* font_manager_search_provider_properties[FONT_MANAGER_SEARCH_PROVIDER_NUM_PROPERTIES];
typedef enum  {
	FONT_MANAGER_SEARCH_PROVIDER_ID_FILEPATH,
	FONT_MANAGER_SEARCH_PROVIDER_ID_INDEX,
	FONT_MANAGER_SEARCH_PROVIDER_ID_FAMILY,
	FONT_MANAGER_SEARCH_PROVIDER_ID_STYLE
} FontManagerSearchProviderID;

#define FONT_MANAGER_SEARCH_PROVIDER_TYPE_ID (font_manager_search_provider_id_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _Block13Data Block13Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FontManagerSearchProviderGetInitialResultSetData FontManagerSearchProviderGetInitialResultSetData;
typedef struct _FontManagerSearchProviderGetSubsearchResultSetData FontManagerSearchProviderGetSubsearchResultSetData;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _FontManagerSearchProviderGetInitialResultSetReadyData FontManagerSearchProviderGetInitialResultSetReadyData;
typedef struct _FontManagerSearchProviderGetSubsearchResultSetReadyData FontManagerSearchProviderGetSubsearchResultSetReadyData;

struct _FontManagerSearchProvider {
	GObject parent_instance;
	FontManagerSearchProviderPrivate * priv;
};

struct _FontManagerSearchProviderClass {
	GObjectClass parent_class;
};

struct _FontManagerSearchProviderPrivate {
	guint dbus_id;
};

struct _Block13Data {
	int _ref_count_;
	FontManagerSearchProvider* self;
	gchar** result_set;
	gint result_set_length1;
	gint _result_set_size_;
};

struct _FontManagerSearchProviderGetInitialResultSetData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FontManagerSearchProvider* self;
	gchar** terms;
	gint terms_length1;
	gchar** result;
	gint result_length1;
	gchar** result_set;
	gchar** _tmp0_;
	gint result_set_length1;
	gint _result_set_size_;
	gchar** _tmp1_;
	gint _tmp1__length1;
};

struct _FontManagerSearchProviderGetSubsearchResultSetData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FontManagerSearchProvider* self;
	gchar** previous_results;
	gint previous_results_length1;
	gchar** terms;
	gint terms_length1;
	gchar** result;
	gint result_length1;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gint _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gint _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
};

struct _FontManagerSearchProviderGetInitialResultSetReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar** terms;
	gint terms_length1;
};

struct _FontManagerSearchProviderGetSubsearchResultSetReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar** previous_results;
	gint previous_results_length1;
	gchar** terms;
	gint terms_length1;
};

static gint FontManagerSearchProvider_private_offset;
static gpointer font_manager_search_provider_parent_class = NULL;

VALA_EXTERN GType font_manager_search_provider_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerSearchProvider, g_object_unref)
VALA_EXTERN guint font_manager_search_provider_register_object (void* object,
                                                    GDBusConnection* connection,
                                                    const gchar* path,
                                                    GError** error);
static GType font_manager_search_provider_id_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static gchar* font_manager_search_provider_get_search_term (FontManagerSearchProvider* self,
                                                     gchar** terms,
                                                     gint terms_length1);
static gchar** font_manager_search_provider_character_search (FontManagerSearchProvider* self,
                                                       const gchar* charset,
                                                       gint* result_length1);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
static void __lambda212_ (Block13Data* _data13_,
                   JsonObject* obj,
                   const gchar* name,
                   JsonNode* node);
static void __lambda213_ (Block13Data* _data13_,
                   JsonObject* obj,
                   const gchar* name,
                   JsonNode* node);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void ___lambda213__json_object_foreach (JsonObject* object,
                                        const gchar* member_name,
                                        JsonNode* member_node,
                                        gpointer self);
static void ___lambda212__json_object_foreach (JsonObject* object,
                                        const gchar* member_name,
                                        JsonNode* member_node,
                                        gpointer self);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
static gchar** font_manager_search_provider_database_search (FontManagerSearchProvider* self,
                                                      gchar** terms,
                                                      gint terms_length1,
                                                      gint* result_length1);
VALA_EXTERN FontManagerDatabase* font_manager_database_proxy_get_default_db (void);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void font_manager_search_provider_get_initial_result_set_data_free (gpointer _data);
VALA_EXTERN void font_manager_search_provider_get_initial_result_set (FontManagerSearchProvider* self,
                                                          gchar** terms,
                                                          gint terms_length1,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_);
VALA_EXTERN gchar** font_manager_search_provider_get_initial_result_set_finish (FontManagerSearchProvider* self,
                                                                    GAsyncResult* _res_,
                                                                    gint* result_length1,
                                                                    GError** error);
static gboolean font_manager_search_provider_get_initial_result_set_co (FontManagerSearchProviderGetInitialResultSetData* _data_);
static void font_manager_search_provider_get_subsearch_result_set_data_free (gpointer _data);
VALA_EXTERN void font_manager_search_provider_get_subsearch_result_set (FontManagerSearchProvider* self,
                                                            gchar** previous_results,
                                                            gint previous_results_length1,
                                                            gchar** terms,
                                                            gint terms_length1,
                                                            GAsyncReadyCallback _callback_,
                                                            gpointer _user_data_);
VALA_EXTERN gchar** font_manager_search_provider_get_subsearch_result_set_finish (FontManagerSearchProvider* self,
                                                                      GAsyncResult* _res_,
                                                                      gint* result_length1,
                                                                      GError** error);
static gboolean font_manager_search_provider_get_subsearch_result_set_co (FontManagerSearchProviderGetSubsearchResultSetData* _data_);
VALA_EXTERN GHashTable** font_manager_search_provider_get_result_metas (FontManagerSearchProvider* self,
                                                            gchar** results,
                                                            gint results_length1,
                                                            gint* result_length1,
                                                            GError** error);
static void _g_hash_table_unref0_ (gpointer var);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
static GVariant* _variant_new1 (gchar* value);
static GVariant* _variant_new2 (const gchar* value);
static GVariant* _variant_new3 (const gchar* value);
static GHashTable** _vala_array_dup3 (GHashTable** self,
                               gssize length);
VALA_EXTERN void font_manager_search_provider_activate_result (FontManagerSearchProvider* self,
                                                   const gchar* _result_,
                                                   gchar** terms,
                                                   gint terms_length1,
                                                   guint32 timestamp,
                                                   GError** error);
VALA_EXTERN void font_manager_search_provider_launch_search (FontManagerSearchProvider* self,
                                                 gchar** terms,
                                                 gint terms_length1,
                                                 guint32 timestamp,
                                                 GError** error);
VALA_EXTERN void font_manager_search_provider_dbus_register (FontManagerSearchProvider* self,
                                                 GDBusConnection* conn);
VALA_EXTERN void font_manager_search_provider_dbus_unregister (FontManagerSearchProvider* self,
                                                   GDBusConnection* conn);
VALA_EXTERN FontManagerSearchProvider* font_manager_search_provider_new (void);
VALA_EXTERN FontManagerSearchProvider* font_manager_search_provider_construct (GType object_type);
static void font_manager_search_provider_finalize (GObject * obj);
static GType font_manager_search_provider_get_type_once (void);
static void _dbus_font_manager_search_provider_get_initial_result_set (FontManagerSearchProvider* self,
                                                                GVariant* _parameters_,
                                                                GDBusMethodInvocation* invocation);
static void _dbus_font_manager_search_provider_get_initial_result_set_ready (GObject * source_object,
                                                                      GAsyncResult * _res_,
                                                                      gpointer _user_data_);
static void _dbus_font_manager_search_provider_get_subsearch_result_set (FontManagerSearchProvider* self,
                                                                  GVariant* _parameters_,
                                                                  GDBusMethodInvocation* invocation);
static void _dbus_font_manager_search_provider_get_subsearch_result_set_ready (GObject * source_object,
                                                                        GAsyncResult * _res_,
                                                                        gpointer _user_data_);
static void _dbus_font_manager_search_provider_get_result_metas (FontManagerSearchProvider* self,
                                                          GVariant* _parameters_,
                                                          GDBusMethodInvocation* invocation);
static void _dbus_font_manager_search_provider_activate_result (FontManagerSearchProvider* self,
                                                         GVariant* _parameters_,
                                                         GDBusMethodInvocation* invocation);
static void _dbus_font_manager_search_provider_launch_search (FontManagerSearchProvider* self,
                                                       GVariant* _parameters_,
                                                       GDBusMethodInvocation* invocation);
static void font_manager_search_provider_dbus_interface_method_call (GDBusConnection* connection,
                                                              const gchar* sender,
                                                              const gchar* object_path,
                                                              const gchar* interface_name,
                                                              const gchar* method_name,
                                                              GVariant* parameters,
                                                              GDBusMethodInvocation* invocation,
                                                              gpointer user_data);
static GVariant* font_manager_search_provider_dbus_interface_get_property (GDBusConnection* connection,
                                                                    const gchar* sender,
                                                                    const gchar* object_path,
                                                                    const gchar* interface_name,
                                                                    const gchar* property_name,
                                                                    GError** error,
                                                                    gpointer user_data);
static gboolean font_manager_search_provider_dbus_interface_set_property (GDBusConnection* connection,
                                                                   const gchar* sender,
                                                                   const gchar* object_path,
                                                                   const gchar* interface_name,
                                                                   const gchar* property_name,
                                                                   GVariant* value,
                                                                   GError** error,
                                                                   gpointer user_data);
static void _font_manager_search_provider_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const GDBusArgInfo _font_manager_search_provider_dbus_arg_info_get_initial_result_set_terms = {-1, "terms", "as", NULL};
static const GDBusArgInfo _font_manager_search_provider_dbus_arg_info_get_initial_result_set_result = {-1, "result", "as", NULL};
static const GDBusArgInfo * const _font_manager_search_provider_dbus_arg_info_get_initial_result_set_in[] = {&_font_manager_search_provider_dbus_arg_info_get_initial_result_set_terms, NULL};
static const GDBusArgInfo * const _font_manager_search_provider_dbus_arg_info_get_initial_result_set_out[] = {&_font_manager_search_provider_dbus_arg_info_get_initial_result_set_result, NULL};
static const GDBusMethodInfo _font_manager_search_provider_dbus_method_info_get_initial_result_set = {-1, "GetInitialResultSet", (GDBusArgInfo **) (&_font_manager_search_provider_dbus_arg_info_get_initial_result_set_in), (GDBusArgInfo **) (&_font_manager_search_provider_dbus_arg_info_get_initial_result_set_out), NULL};
static const GDBusArgInfo _font_manager_search_provider_dbus_arg_info_get_subsearch_result_set_previous_results = {-1, "previous_results", "as", NULL};
static const GDBusArgInfo _font_manager_search_provider_dbus_arg_info_get_subsearch_result_set_terms = {-1, "terms", "as", NULL};
static const GDBusArgInfo _font_manager_search_provider_dbus_arg_info_get_subsearch_result_set_result = {-1, "result", "as", NULL};
static const GDBusArgInfo * const _font_manager_search_provider_dbus_arg_info_get_subsearch_result_set_in[] = {&_font_manager_search_provider_dbus_arg_info_get_subsearch_result_set_previous_results, &_font_manager_search_provider_dbus_arg_info_get_subsearch_result_set_terms, NULL};
static const GDBusArgInfo * const _font_manager_search_provider_dbus_arg_info_get_subsearch_result_set_out[] = {&_font_manager_search_provider_dbus_arg_info_get_subsearch_result_set_result, NULL};
static const GDBusMethodInfo _font_manager_search_provider_dbus_method_info_get_subsearch_result_set = {-1, "GetSubsearchResultSet", (GDBusArgInfo **) (&_font_manager_search_provider_dbus_arg_info_get_subsearch_result_set_in), (GDBusArgInfo **) (&_font_manager_search_provider_dbus_arg_info_get_subsearch_result_set_out), NULL};
static const GDBusArgInfo _font_manager_search_provider_dbus_arg_info_get_result_metas_results = {-1, "results", "as", NULL};
static const GDBusArgInfo _font_manager_search_provider_dbus_arg_info_get_result_metas_result = {-1, "result", "aa{sv}", NULL};
static const GDBusArgInfo * const _font_manager_search_provider_dbus_arg_info_get_result_metas_in[] = {&_font_manager_search_provider_dbus_arg_info_get_result_metas_results, NULL};
static const GDBusArgInfo * const _font_manager_search_provider_dbus_arg_info_get_result_metas_out[] = {&_font_manager_search_provider_dbus_arg_info_get_result_metas_result, NULL};
static const GDBusMethodInfo _font_manager_search_provider_dbus_method_info_get_result_metas = {-1, "GetResultMetas", (GDBusArgInfo **) (&_font_manager_search_provider_dbus_arg_info_get_result_metas_in), (GDBusArgInfo **) (&_font_manager_search_provider_dbus_arg_info_get_result_metas_out), NULL};
static const GDBusArgInfo _font_manager_search_provider_dbus_arg_info_activate_result_result = {-1, "result", "s", NULL};
static const GDBusArgInfo _font_manager_search_provider_dbus_arg_info_activate_result_terms = {-1, "terms", "as", NULL};
static const GDBusArgInfo _font_manager_search_provider_dbus_arg_info_activate_result_timestamp = {-1, "timestamp", "u", NULL};
static const GDBusArgInfo * const _font_manager_search_provider_dbus_arg_info_activate_result_in[] = {&_font_manager_search_provider_dbus_arg_info_activate_result_result, &_font_manager_search_provider_dbus_arg_info_activate_result_terms, &_font_manager_search_provider_dbus_arg_info_activate_result_timestamp, NULL};
static const GDBusArgInfo * const _font_manager_search_provider_dbus_arg_info_activate_result_out[] = {NULL};
static const GDBusMethodInfo _font_manager_search_provider_dbus_method_info_activate_result = {-1, "ActivateResult", (GDBusArgInfo **) (&_font_manager_search_provider_dbus_arg_info_activate_result_in), (GDBusArgInfo **) (&_font_manager_search_provider_dbus_arg_info_activate_result_out), NULL};
static const GDBusArgInfo _font_manager_search_provider_dbus_arg_info_launch_search_terms = {-1, "terms", "as", NULL};
static const GDBusArgInfo _font_manager_search_provider_dbus_arg_info_launch_search_timestamp = {-1, "timestamp", "u", NULL};
static const GDBusArgInfo * const _font_manager_search_provider_dbus_arg_info_launch_search_in[] = {&_font_manager_search_provider_dbus_arg_info_launch_search_terms, &_font_manager_search_provider_dbus_arg_info_launch_search_timestamp, NULL};
static const GDBusArgInfo * const _font_manager_search_provider_dbus_arg_info_launch_search_out[] = {NULL};
static const GDBusMethodInfo _font_manager_search_provider_dbus_method_info_launch_search = {-1, "LaunchSearch", (GDBusArgInfo **) (&_font_manager_search_provider_dbus_arg_info_launch_search_in), (GDBusArgInfo **) (&_font_manager_search_provider_dbus_arg_info_launch_search_out), NULL};
static const GDBusMethodInfo * const _font_manager_search_provider_dbus_method_info[] = {&_font_manager_search_provider_dbus_method_info_get_initial_result_set, &_font_manager_search_provider_dbus_method_info_get_subsearch_result_set, &_font_manager_search_provider_dbus_method_info_get_result_metas, &_font_manager_search_provider_dbus_method_info_activate_result, &_font_manager_search_provider_dbus_method_info_launch_search, NULL};
static const GDBusSignalInfo * const _font_manager_search_provider_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _font_manager_search_provider_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _font_manager_search_provider_dbus_interface_info = {-1, "org.gnome.Shell.SearchProvider2", (GDBusMethodInfo **) (&_font_manager_search_provider_dbus_method_info), (GDBusSignalInfo **) (&_font_manager_search_provider_dbus_signal_info), (GDBusPropertyInfo **) (&_font_manager_search_provider_dbus_property_info), NULL};
static const GDBusInterfaceVTable _font_manager_search_provider_dbus_interface_vtable = {font_manager_search_provider_dbus_interface_method_call, font_manager_search_provider_dbus_interface_get_property, font_manager_search_provider_dbus_interface_set_property};

static inline gpointer
font_manager_search_provider_get_instance_private (FontManagerSearchProvider* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerSearchProvider_private_offset);
}

 G_GNUC_NO_INLINE static GType
font_manager_search_provider_id_get_type_once (void)
{
	static const GEnumValue values[] = {{FONT_MANAGER_SEARCH_PROVIDER_ID_FILEPATH, "FONT_MANAGER_SEARCH_PROVIDER_ID_FILEPATH", "filepath"}, {FONT_MANAGER_SEARCH_PROVIDER_ID_INDEX, "FONT_MANAGER_SEARCH_PROVIDER_ID_INDEX", "index"}, {FONT_MANAGER_SEARCH_PROVIDER_ID_FAMILY, "FONT_MANAGER_SEARCH_PROVIDER_ID_FAMILY", "family"}, {FONT_MANAGER_SEARCH_PROVIDER_ID_STYLE, "FONT_MANAGER_SEARCH_PROVIDER_ID_STYLE", "style"}, {0, NULL, NULL}};
	GType font_manager_search_provider_id_type_id;
	font_manager_search_provider_id_type_id = g_enum_register_static ("FontManagerSearchProviderID", values);
	return font_manager_search_provider_id_type_id;
}

static GType
font_manager_search_provider_id_get_type (void)
{
	static volatile gsize font_manager_search_provider_id_type_id__once = 0;
	if (g_once_init_enter (&font_manager_search_provider_id_type_id__once)) {
		GType font_manager_search_provider_id_type_id;
		font_manager_search_provider_id_type_id = font_manager_search_provider_id_get_type_once ();
		g_once_init_leave (&font_manager_search_provider_id_type_id__once, font_manager_search_provider_id_type_id);
	}
	return font_manager_search_provider_id_type_id__once;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gchar*
font_manager_search_provider_get_search_term (FontManagerSearchProvider* self,
                                              gchar** terms,
                                              gint terms_length1)
{
	GString* search_term = NULL;
	GString* _tmp0_;
	GString* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	search_term = _tmp0_;
	{
		gchar** term_collection = NULL;
		gint term_collection_length1 = 0;
		gint _term_collection_size_ = 0;
		gint term_it = 0;
		term_collection = terms;
		term_collection_length1 = terms_length1;
		for (term_it = 0; term_it < term_collection_length1; term_it = term_it + 1) {
			gchar* _tmp1_;
			gchar* term = NULL;
			_tmp1_ = g_strdup (term_collection[term_it]);
			term = _tmp1_;
			{
				GString* _tmp2_;
				GString* _tmp3_;
				const gchar* _tmp4_;
				_tmp2_ = search_term;
				g_string_append (_tmp2_, " ");
				_tmp3_ = search_term;
				_tmp4_ = term;
				g_string_append (_tmp3_, _tmp4_);
				_g_free0 (term);
			}
		}
	}
	_tmp5_ = search_term;
	_tmp6_ = _tmp5_->str;
	_tmp7_ = string_strip (_tmp6_);
	result = _tmp7_;
	_g_string_free0 (search_term);
	return result;
}

static Block13Data*
block13_data_ref (Block13Data* _data13_)
{
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}

static void
block13_data_unref (void * _userdata_)
{
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		FontManagerSearchProvider* self;
		self = _data13_->self;
		_data13_->result_set = (_vala_array_free (_data13_->result_set, _data13_->result_set_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block13Data, _data13_);
	}
}

static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
__lambda213_ (Block13Data* _data13_,
              JsonObject* obj,
              const gchar* name,
              JsonNode* node)
{
	FontManagerSearchProvider* self;
	JsonObject* font = NULL;
	JsonObject* _tmp0_;
	JsonObject* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	self = _data13_->self;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = json_node_get_object (node);
	_tmp1_ = _json_object_ref0 (_tmp0_);
	font = _tmp1_;
	_tmp2_ = json_object_get_string_member (font, "filepath");
	_tmp3_ = json_object_get_string_member (font, "family");
	_tmp4_ = json_object_get_string_member (font, "style");
	_tmp5_ = g_strdup_printf ("%s::%i::%s::%s", _tmp2_, (gint) json_object_get_int_member (font, "findex"), _tmp3_, _tmp4_);
	_vala_array_add1 (&_data13_->result_set, &_data13_->result_set_length1, &_data13_->_result_set_size_, _tmp5_);
	_json_object_unref0 (font);
}

static void
___lambda213__json_object_foreach (JsonObject* object,
                                   const gchar* member_name,
                                   JsonNode* member_node,
                                   gpointer self)
{
	__lambda213_ (self, object, member_name, member_node);
}

static void
__lambda212_ (Block13Data* _data13_,
              JsonObject* obj,
              const gchar* name,
              JsonNode* node)
{
	FontManagerSearchProvider* self;
	JsonObject* fonts = NULL;
	JsonObject* _tmp0_;
	JsonObject* _tmp1_;
	self = _data13_->self;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = json_node_get_object (node);
	_tmp1_ = _json_object_ref0 (_tmp0_);
	fonts = _tmp1_;
	json_object_foreach_member (fonts, ___lambda213__json_object_foreach, _data13_);
	_json_object_unref0 (fonts);
}

static void
___lambda212__json_object_foreach (JsonObject* object,
                                   const gchar* member_name,
                                   JsonNode* member_node,
                                   gpointer self)
{
	__lambda212_ (self, object, member_name, member_node);
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
font_manager_search_provider_character_search (FontManagerSearchProvider* self,
                                               const gchar* charset,
                                               gint* result_length1)
{
	Block13Data* _data13_;
	gchar** _tmp0_;
	JsonObject* fontset = NULL;
	JsonObject* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (charset != NULL, NULL);
	_data13_ = g_slice_new0 (Block13Data);
	_data13_->_ref_count_ = 1;
	_data13_->self = g_object_ref (self);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	_data13_->result_set = _tmp0_;
	_data13_->result_set_length1 = 0;
	_data13_->_result_set_size_ = _data13_->result_set_length1;
	_tmp1_ = font_manager_get_available_fonts_for_chars (charset);
	fontset = _tmp1_;
	json_object_foreach_member (fontset, ___lambda212__json_object_foreach, _data13_);
	_tmp2_ = (_data13_->result_set != NULL) ? _vala_array_dup2 (_data13_->result_set, _data13_->result_set_length1) : _data13_->result_set;
	_tmp2__length1 = _data13_->result_set_length1;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp2__length1;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	_json_object_unref0 (fontset);
	block13_data_unref (_data13_);
	_data13_ = NULL;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar**
font_manager_search_provider_database_search (FontManagerSearchProvider* self,
                                              gchar** terms,
                                              gint terms_length1,
                                              gint* result_length1)
{
	gchar** result_set = NULL;
	gchar** _tmp0_;
	gint result_set_length1;
	gint _result_set_size_;
	gchar* search_term = NULL;
	gchar* _tmp1_;
	gchar** _tmp29_;
	gint _tmp29__length1;
	GError* _inner_error0_ = NULL;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	result_set = _tmp0_;
	result_set_length1 = 0;
	_result_set_size_ = result_set_length1;
	_tmp1_ = font_manager_search_provider_get_search_term (self, terms, (gint) terms_length1);
	search_term = _tmp1_;
	{
		FontManagerDatabase* db = NULL;
		FontManagerDatabase* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* QUERY = NULL;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		FontManagerDatabase* _tmp11_;
		const gchar* _tmp12_;
		FontManagerDatabase* _tmp26_;
		_tmp2_ = font_manager_database_proxy_get_default_db ();
		db = _tmp2_;
		_tmp3_ = search_term;
		_tmp4_ = string_replace (_tmp3_, "'", "''");
		_g_free0 (search_term);
		search_term = _tmp4_;
		_tmp5_ = search_term;
		_tmp6_ = string_to_string (_tmp5_);
		_tmp7_ = g_strconcat ("WHERE family LIKE '%", _tmp6_, "%' ORDER BY weight;", NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat ("SELECT filepath, findex, family, style from Fonts ", _tmp8_, NULL);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		QUERY = _tmp10_;
		_tmp11_ = db;
		_tmp12_ = QUERY;
		font_manager_database_execute_query (_tmp11_, _tmp12_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (QUERY);
			_g_object_unref0 (db);
			goto __catch0_g_error;
		}
		{
			FontManagerDatabaseIterator* _row_it = NULL;
			FontManagerDatabase* _tmp13_;
			FontManagerDatabaseIterator* _tmp14_;
			_tmp13_ = db;
			_tmp14_ = font_manager_database_iterator (_tmp13_);
			_row_it = _tmp14_;
			while (TRUE) {
				FontManagerDatabaseIterator* _tmp15_;
				sqlite3_stmt* row = NULL;
				FontManagerDatabaseIterator* _tmp16_;
				sqlite3_stmt* _tmp17_;
				sqlite3_stmt* _tmp18_;
				const gchar* _tmp19_;
				sqlite3_stmt* _tmp20_;
				sqlite3_stmt* _tmp21_;
				const gchar* _tmp22_;
				sqlite3_stmt* _tmp23_;
				const gchar* _tmp24_;
				gchar* _tmp25_;
				_tmp15_ = _row_it;
				if (!font_manager_database_iterator_next (_tmp15_)) {
					break;
				}
				_tmp16_ = _row_it;
				_tmp17_ = font_manager_database_iterator_get (_tmp16_);
				row = _tmp17_;
				_tmp18_ = row;
				_tmp19_ = (const gchar*) sqlite3_column_text (_tmp18_, (gint) FONT_MANAGER_SEARCH_PROVIDER_ID_FILEPATH);
				_tmp20_ = row;
				_tmp21_ = row;
				_tmp22_ = (const gchar*) sqlite3_column_text (_tmp21_, (gint) FONT_MANAGER_SEARCH_PROVIDER_ID_FAMILY);
				_tmp23_ = row;
				_tmp24_ = (const gchar*) sqlite3_column_text (_tmp23_, (gint) FONT_MANAGER_SEARCH_PROVIDER_ID_STYLE);
				_tmp25_ = g_strdup_printf ("%s::%i::%s::%s", _tmp19_, sqlite3_column_int (_tmp20_, (gint) FONT_MANAGER_SEARCH_PROVIDER_ID_INDEX), _tmp22_, _tmp24_);
				_vala_array_add2 (&result_set, &result_set_length1, &_result_set_size_, _tmp25_);
			}
			_g_object_unref0 (_row_it);
		}
		_tmp26_ = db;
		font_manager_database_end_query (_tmp26_);
		_g_free0 (QUERY);
		_g_object_unref0 (db);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp27_;
		const gchar* _tmp28_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp27_ = e;
		_tmp28_ = _tmp27_->message;
		g_warning ("SearchProvider.vala:77: %s", _tmp28_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (search_term);
		result_set = (_vala_array_free (result_set, result_set_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp29_ = result_set;
	_tmp29__length1 = result_set_length1;
	if (result_length1) {
		*result_length1 = _tmp29__length1;
	}
	result = _tmp29_;
	_g_free0 (search_term);
	return result;
}

static void
font_manager_search_provider_get_initial_result_set_data_free (gpointer _data)
{
	FontManagerSearchProviderGetInitialResultSetData* _data_;
	_data_ = _data;
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (FontManagerSearchProviderGetInitialResultSetData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
font_manager_search_provider_get_initial_result_set (FontManagerSearchProvider* self,
                                                     gchar** terms,
                                                     gint terms_length1,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_)
{
	FontManagerSearchProviderGetInitialResultSetData* _data_;
	FontManagerSearchProvider* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (FontManagerSearchProviderGetInitialResultSetData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, font_manager_search_provider_get_initial_result_set_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->terms = terms;
	_data_->terms_length1 = terms_length1;
	font_manager_search_provider_get_initial_result_set_co (_data_);
}

gchar**
font_manager_search_provider_get_initial_result_set_finish (FontManagerSearchProvider* self,
                                                            GAsyncResult* _res_,
                                                            gint* result_length1,
                                                            GError** error)
{
	gchar** result;
	FontManagerSearchProviderGetInitialResultSetData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}

static gboolean
font_manager_search_provider_get_initial_result_set_co (FontManagerSearchProviderGetInitialResultSetData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_new0 (gchar*, 0 + 1);
	_data_->result_set = _data_->_tmp0_;
	_data_->result_set_length1 = 0;
	_data_->_result_set_size_ = _data_->result_set_length1;
	_data_->_tmp1_ = _data_->result_set;
	_data_->_tmp1__length1 = _data_->result_set_length1;
	_data_->result_length1 = _data_->_tmp1__length1;
	_data_->result = _data_->_tmp1_;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
font_manager_search_provider_get_subsearch_result_set_data_free (gpointer _data)
{
	FontManagerSearchProviderGetSubsearchResultSetData* _data_;
	_data_ = _data;
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (FontManagerSearchProviderGetSubsearchResultSetData, _data_);
}

void
font_manager_search_provider_get_subsearch_result_set (FontManagerSearchProvider* self,
                                                       gchar** previous_results,
                                                       gint previous_results_length1,
                                                       gchar** terms,
                                                       gint terms_length1,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_)
{
	FontManagerSearchProviderGetSubsearchResultSetData* _data_;
	FontManagerSearchProvider* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (FontManagerSearchProviderGetSubsearchResultSetData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, font_manager_search_provider_get_subsearch_result_set_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->previous_results = previous_results;
	_data_->previous_results_length1 = previous_results_length1;
	_data_->terms = terms;
	_data_->terms_length1 = terms_length1;
	font_manager_search_provider_get_subsearch_result_set_co (_data_);
}

gchar**
font_manager_search_provider_get_subsearch_result_set_finish (FontManagerSearchProvider* self,
                                                              GAsyncResult* _res_,
                                                              gint* result_length1,
                                                              GError** error)
{
	gchar** result;
	FontManagerSearchProviderGetSubsearchResultSetData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}

static gboolean
font_manager_search_provider_get_subsearch_result_set_co (FontManagerSearchProviderGetSubsearchResultSetData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->terms[0];
	if (g_str_has_prefix (_data_->_tmp0_, G_SEARCHPATH_SEPARATOR_S)) {
		_data_->_tmp1_ = _data_->terms[0];
		_data_->_tmp2_ = string_replace (_data_->_tmp1_, G_SEARCHPATH_SEPARATOR_S, "");
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp4_ = 0;
		_data_->_tmp5_ = font_manager_search_provider_character_search (_data_->self, _data_->_tmp3_, &_data_->_tmp4_);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp6__length1 = _data_->_tmp4_;
		_g_free0 (_data_->_tmp3_);
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_tmp7__length1 = _data_->_tmp6__length1;
		_data_->result_length1 = _data_->_tmp7__length1;
		_data_->result = _data_->_tmp7_;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp8_ = 0;
		_data_->_tmp9_ = font_manager_search_provider_database_search (_data_->self, _data_->terms, (gint) _data_->terms_length1, &_data_->_tmp8_);
		_data_->_tmp10_ = _data_->_tmp9_;
		_data_->_tmp10__length1 = _data_->_tmp8_;
		_data_->result_length1 = _data_->_tmp10__length1;
		_data_->result = _data_->_tmp10_;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
}

static void
_g_hash_table_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL));
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_variant_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}

static GVariant*
_variant_new1 (gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new2 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new3 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

static GHashTable**
_vala_array_dup3 (GHashTable** self,
                  gssize length)
{
	if (length >= 0) {
		GHashTable** result;
		gssize i;
		result = g_new0 (GHashTable*, length + 1);
		for (i = 0; i < length; i++) {
			GHashTable* _tmp0_;
			_tmp0_ = _g_hash_table_ref0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

GHashTable**
font_manager_search_provider_get_result_metas (FontManagerSearchProvider* self,
                                               gchar** results,
                                               gint results_length1,
                                               gint* result_length1,
                                               GError** error)
{
	GPtrArray* metas = NULL;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp30_;
	gpointer* _tmp31_;
	gint _tmp31__length1;
	GHashTable** _tmp32_;
	gint _tmp32__length1;
	GHashTable** _tmp33_;
	gint _tmp33__length1;
	GHashTable** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_hash_table_unref0_);
	metas = _tmp0_;
	{
		gchar** entry_collection = NULL;
		gint entry_collection_length1 = 0;
		gint _entry_collection_size_ = 0;
		gint entry_it = 0;
		entry_collection = results;
		entry_collection_length1 = results_length1;
		for (entry_it = 0; entry_it < entry_collection_length1; entry_it = entry_it + 1) {
			gchar* _tmp1_;
			gchar* entry = NULL;
			_tmp1_ = g_strdup (entry_collection[entry_it]);
			entry = _tmp1_;
			{
				gchar** data = NULL;
				const gchar* _tmp2_;
				gchar** _tmp3_;
				gchar** _tmp4_;
				gint data_length1;
				gint _data_size_;
				GHashTable* meta = NULL;
				GHashFunc _tmp5_;
				GEqualFunc _tmp6_;
				GHashTable* _tmp7_;
				GHashTable* _tmp8_;
				gchar* _tmp9_;
				gchar** _tmp10_;
				gint _tmp10__length1;
				const gchar* _tmp11_;
				gchar** _tmp12_;
				gint _tmp12__length1;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				GVariant* _tmp16_;
				GHashTable* _tmp17_;
				gchar* _tmp18_;
				gchar** _tmp19_;
				gint _tmp19__length1;
				const gchar* _tmp20_;
				GVariant* _tmp21_;
				GHashTable* _tmp22_;
				gchar* _tmp23_;
				gchar** _tmp24_;
				gint _tmp24__length1;
				const gchar* _tmp25_;
				GVariant* _tmp26_;
				GPtrArray* _tmp27_;
				GHashTable* _tmp28_;
				GHashTable* _tmp29_;
				_tmp2_ = entry;
				_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, "::", 0);
				data = _tmp4_;
				data_length1 = _vala_array_length (_tmp3_);
				_data_size_ = data_length1;
				_tmp5_ = g_str_hash;
				_tmp6_ = g_str_equal;
				_tmp7_ = g_hash_table_new_full (_tmp5_, _tmp6_, _g_free0_, _g_variant_unref0_);
				meta = _tmp7_;
				_tmp8_ = meta;
				_tmp9_ = g_strdup ("id");
				_tmp10_ = data;
				_tmp10__length1 = data_length1;
				_tmp11_ = _tmp10_[FONT_MANAGER_SEARCH_PROVIDER_ID_FILEPATH];
				_tmp12_ = data;
				_tmp12__length1 = data_length1;
				_tmp13_ = _tmp12_[FONT_MANAGER_SEARCH_PROVIDER_ID_INDEX];
				_tmp14_ = g_strdup_printf ("%s::%s", _tmp11_, _tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = _variant_new1 (_tmp15_);
				g_hash_table_insert (_tmp8_, _tmp9_, _tmp16_);
				_g_free0 (_tmp15_);
				_tmp17_ = meta;
				_tmp18_ = g_strdup ("name");
				_tmp19_ = data;
				_tmp19__length1 = data_length1;
				_tmp20_ = _tmp19_[FONT_MANAGER_SEARCH_PROVIDER_ID_FAMILY];
				_tmp21_ = _variant_new2 (_tmp20_);
				g_hash_table_insert (_tmp17_, _tmp18_, _tmp21_);
				_tmp22_ = meta;
				_tmp23_ = g_strdup ("description");
				_tmp24_ = data;
				_tmp24__length1 = data_length1;
				_tmp25_ = _tmp24_[FONT_MANAGER_SEARCH_PROVIDER_ID_STYLE];
				_tmp26_ = _variant_new3 (_tmp25_);
				g_hash_table_insert (_tmp22_, _tmp23_, _tmp26_);
				_tmp27_ = metas;
				_tmp28_ = meta;
				_tmp29_ = _g_hash_table_ref0 (_tmp28_);
				g_ptr_array_add (_tmp27_, _tmp29_);
				_g_hash_table_unref0 (meta);
				data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (entry);
			}
		}
	}
	_tmp30_ = metas;
	_tmp31_ = _tmp30_->pdata;
	_tmp31__length1 = _tmp30_->len;
	_tmp32_ = (_tmp31_ != NULL) ? _vala_array_dup3 (_tmp31_, _tmp31__length1) : _tmp31_;
	_tmp32__length1 = _tmp31__length1;
	_tmp33_ = _tmp32_;
	_tmp33__length1 = _tmp32__length1;
	if (result_length1) {
		*result_length1 = _tmp33__length1;
	}
	result = _tmp33_;
	_g_ptr_array_unref0 (metas);
	return result;
}

void
font_manager_search_provider_activate_result (FontManagerSearchProvider* self,
                                              const gchar* _result_,
                                              gchar** terms,
                                              gint terms_length1,
                                              guint32 timestamp,
                                              GError** error)
{
	gchar** data = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint data_length1;
	gint _data_size_;
	GFile* file = NULL;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	gint findex = 0;
	const gchar* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_result_ != NULL);
	_tmp1_ = _tmp0_ = g_strsplit (_result_, "::", 0);
	data = _tmp1_;
	data_length1 = _vala_array_length (_tmp0_);
	_data_size_ = data_length1;
	_tmp2_ = data[FONT_MANAGER_SEARCH_PROVIDER_ID_FILEPATH];
	_tmp3_ = g_file_new_for_path (_tmp2_);
	file = _tmp3_;
	_tmp4_ = data[FONT_MANAGER_SEARCH_PROVIDER_ID_INDEX];
	findex = atoi (_tmp4_);
	{
		GDBusConnection* conn = NULL;
		GDBusConnection* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GVariant* _tmp8_;
		GVariant* _tmp9_;
		_tmp5_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error0_);
		conn = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = g_file_get_uri (file);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_variant_new ("(si)", _tmp7_, findex, NULL);
		g_variant_ref_sink (_tmp8_);
		_tmp9_ = _tmp8_;
		g_dbus_connection_call (conn, FONT_MANAGER_FONT_VIEWER_BUS_ID, FONT_MANAGER_FONT_VIEWER_BUS_PATH, FONT_MANAGER_FONT_VIEWER_BUS_ID, "ShowUri", _tmp9_, NULL, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL, NULL);
		_g_variant_unref0 (_tmp9_);
		_g_free0 (_tmp7_);
		_g_object_unref0 (conn);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_critical ("SearchProvider.vala:133: Method call to %s failed : %s", FONT_MANAGER_FONT_VIEWER_BUS_ID, _tmp11_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if ((_inner_error0_->domain == G_DBUS_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (file);
			data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
			return;
		} else {
			_g_object_unref0 (file);
			data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_object_unref0 (file);
	data = (_vala_array_free (data, data_length1, (GDestroyNotify) g_free), NULL);
	return;
}

void
font_manager_search_provider_launch_search (FontManagerSearchProvider* self,
                                            gchar** terms,
                                            gint terms_length1,
                                            guint32 timestamp,
                                            GError** error)
{
	gchar* search_term = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = font_manager_search_provider_get_search_term (self, terms, (gint) terms_length1);
	search_term = _tmp0_;
	{
		GDBusConnection* conn = NULL;
		GDBusConnection* _tmp1_;
		GVariant* _tmp2_;
		GVariant* _tmp3_;
		_tmp1_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error0_);
		conn = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = g_variant_new ("(s)", search_term, NULL);
		g_variant_ref_sink (_tmp2_);
		_tmp3_ = _tmp2_;
		g_dbus_connection_call (conn, FONT_MANAGER_BUS_ID, FONT_MANAGER_BUS_PATH, FONT_MANAGER_BUS_ID, "Search", _tmp3_, NULL, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL, NULL);
		_g_variant_unref0 (_tmp3_);
		_g_object_unref0 (conn);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_critical ("SearchProvider.vala:154: Method call to %s failed : %s", FONT_MANAGER_BUS_ID, _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if ((_inner_error0_->domain == G_DBUS_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (search_term);
			return;
		} else {
			_g_free0 (search_term);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_free0 (search_term);
	return;
}

void
font_manager_search_provider_dbus_register (FontManagerSearchProvider* self,
                                            GDBusConnection* conn)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	{
		guint _tmp0_ = 0U;
		guint _tmp1_;
		_tmp1_ = font_manager_search_provider_register_object (self, conn, FONT_MANAGER_SEARCH_PROVIDER_SEARCH_PROVIDER_BUS_PATH, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		self->priv->dbus_id = _tmp0_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("SearchProvider.vala:164: Failed to register gnome shell search provide" \
"r : %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	return;
}

void
font_manager_search_provider_dbus_unregister (FontManagerSearchProvider* self,
                                              GDBusConnection* conn)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	if (self->priv->dbus_id != ((guint) 0)) {
		g_dbus_connection_unregister_object (conn, self->priv->dbus_id);
	}
	return;
}

FontManagerSearchProvider*
font_manager_search_provider_construct (GType object_type)
{
	FontManagerSearchProvider * self = NULL;
	self = (FontManagerSearchProvider*) g_object_new (object_type, NULL);
	return self;
}

FontManagerSearchProvider*
font_manager_search_provider_new (void)
{
	return font_manager_search_provider_construct (FONT_MANAGER_TYPE_SEARCH_PROVIDER);
}

static void
font_manager_search_provider_class_init (FontManagerSearchProviderClass * klass,
                                         gpointer klass_data)
{
	font_manager_search_provider_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerSearchProvider_private_offset);
	G_OBJECT_CLASS (klass)->finalize = font_manager_search_provider_finalize;
}

static void
font_manager_search_provider_instance_init (FontManagerSearchProvider * self,
                                            gpointer klass)
{
	self->priv = font_manager_search_provider_get_instance_private (self);
	self->priv->dbus_id = (guint) 0;
}

static void
font_manager_search_provider_finalize (GObject * obj)
{
	FontManagerSearchProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_SEARCH_PROVIDER, FontManagerSearchProvider);
	G_OBJECT_CLASS (font_manager_search_provider_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_search_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerSearchProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_search_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerSearchProvider), 0, (GInstanceInitFunc) font_manager_search_provider_instance_init, NULL };
	GType font_manager_search_provider_type_id;
	font_manager_search_provider_type_id = g_type_register_static (G_TYPE_OBJECT, "FontManagerSearchProvider", &g_define_type_info, 0);
	g_type_set_qdata (font_manager_search_provider_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) font_manager_search_provider_register_object);
	FontManagerSearchProvider_private_offset = g_type_add_instance_private (font_manager_search_provider_type_id, sizeof (FontManagerSearchProviderPrivate));
	return font_manager_search_provider_type_id;
}

GType
font_manager_search_provider_get_type (void)
{
	static volatile gsize font_manager_search_provider_type_id__once = 0;
	if (g_once_init_enter (&font_manager_search_provider_type_id__once)) {
		GType font_manager_search_provider_type_id;
		font_manager_search_provider_type_id = font_manager_search_provider_get_type_once ();
		g_once_init_leave (&font_manager_search_provider_type_id__once, font_manager_search_provider_type_id);
	}
	return font_manager_search_provider_type_id__once;
}

static void
_dbus_font_manager_search_provider_get_initial_result_set (FontManagerSearchProvider* self,
                                                           GVariant* _parameters_,
                                                           GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	FontManagerSearchProviderGetInitialResultSetReadyData* _ready_data;
	GVariant* _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length;
	gint _tmp14__size;
	gint _tmp14__length1;
	GVariantIter _tmp15_;
	GVariant* _tmp16_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (FontManagerSearchProviderGetInitialResultSetReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp13_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp14_ = g_new (gchar*, 5);
	_tmp14__length = 0;
	_tmp14__size = 4;
	_tmp14__length1 = 0;
	g_variant_iter_init (&_tmp15_, _tmp13_);
	for (; (_tmp16_ = g_variant_iter_next_value (&_tmp15_)) != NULL; _tmp14__length1++) {
		if (_tmp14__size == _tmp14__length) {
			_tmp14__size = 2 * _tmp14__size;
			_tmp14_ = g_renew (gchar*, _tmp14_, _tmp14__size + 1);
		}
		_tmp14_[_tmp14__length++] = g_variant_dup_string (_tmp16_, NULL);
		g_variant_unref (_tmp16_);
	}
	_ready_data->terms_length1 = _tmp14__length1;
	_tmp14_[_tmp14__length] = NULL;
	_ready_data->terms = _tmp14_;
	g_variant_unref (_tmp13_);
	font_manager_search_provider_get_initial_result_set (self, _ready_data->terms, _ready_data->terms_length1, (GAsyncReadyCallback) _dbus_font_manager_search_provider_get_initial_result_set_ready, _ready_data);
	_error:
	;
}

static void
_dbus_font_manager_search_provider_get_initial_result_set_ready (GObject * source_object,
                                                                 GAsyncResult * _res_,
                                                                 gpointer _user_data_)
{
	FontManagerSearchProviderGetInitialResultSetReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	gint result_length1 = 0;
	gchar** _tmp17_;
	GVariantBuilder _tmp18_;
	gint _tmp19_;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = font_manager_search_provider_get_initial_result_set_finish ((FontManagerSearchProvider*) source_object, _res_, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp17_ = result;
	g_variant_builder_init (&_tmp18_, G_VARIANT_TYPE ("as"));
	for (_tmp19_ = 0; _tmp19_ < result_length1; _tmp19_++) {
		g_variant_builder_add_value (&_tmp18_, g_variant_new_string (*_tmp17_));
		_tmp17_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp18_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_ready_data->terms = (_vala_array_free (_ready_data->terms, _ready_data->terms_length1, (GDestroyNotify) g_free), NULL);
	g_slice_free (FontManagerSearchProviderGetInitialResultSetReadyData, _ready_data);
}

static void
_dbus_font_manager_search_provider_get_subsearch_result_set (FontManagerSearchProvider* self,
                                                             GVariant* _parameters_,
                                                             GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	FontManagerSearchProviderGetSubsearchResultSetReadyData* _ready_data;
	GVariant* _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length;
	gint _tmp21__size;
	gint _tmp21__length1;
	GVariantIter _tmp22_;
	GVariant* _tmp23_;
	GVariant* _tmp24_;
	gchar** _tmp25_;
	gint _tmp25__length;
	gint _tmp25__size;
	gint _tmp25__length1;
	GVariantIter _tmp26_;
	GVariant* _tmp27_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (FontManagerSearchProviderGetSubsearchResultSetReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp20_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp21_ = g_new (gchar*, 5);
	_tmp21__length = 0;
	_tmp21__size = 4;
	_tmp21__length1 = 0;
	g_variant_iter_init (&_tmp22_, _tmp20_);
	for (; (_tmp23_ = g_variant_iter_next_value (&_tmp22_)) != NULL; _tmp21__length1++) {
		if (_tmp21__size == _tmp21__length) {
			_tmp21__size = 2 * _tmp21__size;
			_tmp21_ = g_renew (gchar*, _tmp21_, _tmp21__size + 1);
		}
		_tmp21_[_tmp21__length++] = g_variant_dup_string (_tmp23_, NULL);
		g_variant_unref (_tmp23_);
	}
	_ready_data->previous_results_length1 = _tmp21__length1;
	_tmp21_[_tmp21__length] = NULL;
	_ready_data->previous_results = _tmp21_;
	g_variant_unref (_tmp20_);
	_tmp24_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp25_ = g_new (gchar*, 5);
	_tmp25__length = 0;
	_tmp25__size = 4;
	_tmp25__length1 = 0;
	g_variant_iter_init (&_tmp26_, _tmp24_);
	for (; (_tmp27_ = g_variant_iter_next_value (&_tmp26_)) != NULL; _tmp25__length1++) {
		if (_tmp25__size == _tmp25__length) {
			_tmp25__size = 2 * _tmp25__size;
			_tmp25_ = g_renew (gchar*, _tmp25_, _tmp25__size + 1);
		}
		_tmp25_[_tmp25__length++] = g_variant_dup_string (_tmp27_, NULL);
		g_variant_unref (_tmp27_);
	}
	_ready_data->terms_length1 = _tmp25__length1;
	_tmp25_[_tmp25__length] = NULL;
	_ready_data->terms = _tmp25_;
	g_variant_unref (_tmp24_);
	font_manager_search_provider_get_subsearch_result_set (self, _ready_data->previous_results, _ready_data->previous_results_length1, _ready_data->terms, _ready_data->terms_length1, (GAsyncReadyCallback) _dbus_font_manager_search_provider_get_subsearch_result_set_ready, _ready_data);
	_error:
	;
}

static void
_dbus_font_manager_search_provider_get_subsearch_result_set_ready (GObject * source_object,
                                                                   GAsyncResult * _res_,
                                                                   gpointer _user_data_)
{
	FontManagerSearchProviderGetSubsearchResultSetReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	gint result_length1 = 0;
	gchar** _tmp28_;
	GVariantBuilder _tmp29_;
	gint _tmp30_;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = font_manager_search_provider_get_subsearch_result_set_finish ((FontManagerSearchProvider*) source_object, _res_, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp28_ = result;
	g_variant_builder_init (&_tmp29_, G_VARIANT_TYPE ("as"));
	for (_tmp30_ = 0; _tmp30_ < result_length1; _tmp30_++) {
		g_variant_builder_add_value (&_tmp29_, g_variant_new_string (*_tmp28_));
		_tmp28_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp29_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_ready_data->previous_results = (_vala_array_free (_ready_data->previous_results, _ready_data->previous_results_length1, (GDestroyNotify) g_free), NULL);
	_ready_data->terms = (_vala_array_free (_ready_data->terms, _ready_data->terms_length1, (GDestroyNotify) g_free), NULL);
	g_slice_free (FontManagerSearchProviderGetSubsearchResultSetReadyData, _ready_data);
}

static void
_dbus_font_manager_search_provider_get_result_metas (FontManagerSearchProvider* self,
                                                     GVariant* _parameters_,
                                                     GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar** results = NULL;
	gint results_length1 = 0;
	GVariant* _tmp31_;
	gchar** _tmp32_;
	gint _tmp32__length;
	gint _tmp32__size;
	gint _tmp32__length1;
	GVariantIter _tmp33_;
	GVariant* _tmp34_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GHashTable** result;
	gint result_length1 = 0;
	GHashTable** _tmp35_;
	GVariantBuilder _tmp36_;
	gint _tmp37_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp31_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp32_ = g_new (gchar*, 5);
	_tmp32__length = 0;
	_tmp32__size = 4;
	_tmp32__length1 = 0;
	g_variant_iter_init (&_tmp33_, _tmp31_);
	for (; (_tmp34_ = g_variant_iter_next_value (&_tmp33_)) != NULL; _tmp32__length1++) {
		if (_tmp32__size == _tmp32__length) {
			_tmp32__size = 2 * _tmp32__size;
			_tmp32_ = g_renew (gchar*, _tmp32_, _tmp32__size + 1);
		}
		_tmp32_[_tmp32__length++] = g_variant_dup_string (_tmp34_, NULL);
		g_variant_unref (_tmp34_);
	}
	results_length1 = _tmp32__length1;
	_tmp32_[_tmp32__length] = NULL;
	results = _tmp32_;
	g_variant_unref (_tmp31_);
	result = font_manager_search_provider_get_result_metas (self, results, results_length1, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp35_ = result;
	g_variant_builder_init (&_tmp36_, G_VARIANT_TYPE ("aa{sv}"));
	for (_tmp37_ = 0; _tmp37_ < result_length1; _tmp37_++) {
		GVariantBuilder _tmp38_;
		GHashTableIter _tmp39_;
		gpointer _tmp40_;
		gpointer _tmp41_;
		g_hash_table_iter_init (&_tmp39_, *_tmp35_);
		g_variant_builder_init (&_tmp38_, G_VARIANT_TYPE ("a{sv}"));
		while (g_hash_table_iter_next (&_tmp39_, &_tmp40_, &_tmp41_)) {
			gchar* _key;
			GVariant* _value;
			_key = (gchar*) _tmp40_;
			_value = (GVariant*) _tmp41_;
			g_variant_builder_add (&_tmp38_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
		}
		g_variant_builder_add_value (&_tmp36_, g_variant_builder_end (&_tmp38_));
		_tmp35_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp36_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	results = (_vala_array_free (results, results_length1, (GDestroyNotify) g_free), NULL);
	;
}

static void
_dbus_font_manager_search_provider_activate_result (FontManagerSearchProvider* self,
                                                    GVariant* _parameters_,
                                                    GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* _result_ = NULL;
	GVariant* _tmp42_;
	gchar** terms = NULL;
	gint terms_length1 = 0;
	GVariant* _tmp43_;
	gchar** _tmp44_;
	gint _tmp44__length;
	gint _tmp44__size;
	gint _tmp44__length1;
	GVariantIter _tmp45_;
	GVariant* _tmp46_;
	guint32 timestamp = 0U;
	GVariant* _tmp47_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp42_ = g_variant_iter_next_value (&_arguments_iter);
	_result_ = g_variant_dup_string (_tmp42_, NULL);
	g_variant_unref (_tmp42_);
	_tmp43_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp44_ = g_new (gchar*, 5);
	_tmp44__length = 0;
	_tmp44__size = 4;
	_tmp44__length1 = 0;
	g_variant_iter_init (&_tmp45_, _tmp43_);
	for (; (_tmp46_ = g_variant_iter_next_value (&_tmp45_)) != NULL; _tmp44__length1++) {
		if (_tmp44__size == _tmp44__length) {
			_tmp44__size = 2 * _tmp44__size;
			_tmp44_ = g_renew (gchar*, _tmp44_, _tmp44__size + 1);
		}
		_tmp44_[_tmp44__length++] = g_variant_dup_string (_tmp46_, NULL);
		g_variant_unref (_tmp46_);
	}
	terms_length1 = _tmp44__length1;
	_tmp44_[_tmp44__length] = NULL;
	terms = _tmp44_;
	g_variant_unref (_tmp43_);
	_tmp47_ = g_variant_iter_next_value (&_arguments_iter);
	timestamp = g_variant_get_uint32 (_tmp47_);
	g_variant_unref (_tmp47_);
	font_manager_search_provider_activate_result (self, _result_, terms, terms_length1, timestamp, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_result_);
	terms = (_vala_array_free (terms, terms_length1, (GDestroyNotify) g_free), NULL);
	;
}

static void
_dbus_font_manager_search_provider_launch_search (FontManagerSearchProvider* self,
                                                  GVariant* _parameters_,
                                                  GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar** terms = NULL;
	gint terms_length1 = 0;
	GVariant* _tmp48_;
	gchar** _tmp49_;
	gint _tmp49__length;
	gint _tmp49__size;
	gint _tmp49__length1;
	GVariantIter _tmp50_;
	GVariant* _tmp51_;
	guint32 timestamp = 0U;
	GVariant* _tmp52_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp48_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp49_ = g_new (gchar*, 5);
	_tmp49__length = 0;
	_tmp49__size = 4;
	_tmp49__length1 = 0;
	g_variant_iter_init (&_tmp50_, _tmp48_);
	for (; (_tmp51_ = g_variant_iter_next_value (&_tmp50_)) != NULL; _tmp49__length1++) {
		if (_tmp49__size == _tmp49__length) {
			_tmp49__size = 2 * _tmp49__size;
			_tmp49_ = g_renew (gchar*, _tmp49_, _tmp49__size + 1);
		}
		_tmp49_[_tmp49__length++] = g_variant_dup_string (_tmp51_, NULL);
		g_variant_unref (_tmp51_);
	}
	terms_length1 = _tmp49__length1;
	_tmp49_[_tmp49__length] = NULL;
	terms = _tmp49_;
	g_variant_unref (_tmp48_);
	_tmp52_ = g_variant_iter_next_value (&_arguments_iter);
	timestamp = g_variant_get_uint32 (_tmp52_);
	g_variant_unref (_tmp52_);
	font_manager_search_provider_launch_search (self, terms, terms_length1, timestamp, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	terms = (_vala_array_free (terms, terms_length1, (GDestroyNotify) g_free), NULL);
	;
}

static void
font_manager_search_provider_dbus_interface_method_call (GDBusConnection* connection,
                                                         const gchar* sender,
                                                         const gchar* object_path,
                                                         const gchar* interface_name,
                                                         const gchar* method_name,
                                                         GVariant* parameters,
                                                         GDBusMethodInvocation* invocation,
                                                         gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetInitialResultSet") == 0) {
		_dbus_font_manager_search_provider_get_initial_result_set (object, parameters, invocation);
	} else if (strcmp (method_name, "GetSubsearchResultSet") == 0) {
		_dbus_font_manager_search_provider_get_subsearch_result_set (object, parameters, invocation);
	} else if (strcmp (method_name, "GetResultMetas") == 0) {
		_dbus_font_manager_search_provider_get_result_metas (object, parameters, invocation);
	} else if (strcmp (method_name, "ActivateResult") == 0) {
		_dbus_font_manager_search_provider_activate_result (object, parameters, invocation);
	} else if (strcmp (method_name, "LaunchSearch") == 0) {
		_dbus_font_manager_search_provider_launch_search (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
font_manager_search_provider_dbus_interface_get_property (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* property_name,
                                                          GError** error,
                                                          gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
font_manager_search_provider_dbus_interface_set_property (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* property_name,
                                                          GVariant* value,
                                                          GError** error,
                                                          gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
font_manager_search_provider_register_object (gpointer object,
                                              GDBusConnection* connection,
                                              const gchar* path,
                                              GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_font_manager_search_provider_dbus_interface_info), &_font_manager_search_provider_dbus_interface_vtable, data, _font_manager_search_provider_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_font_manager_search_provider_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

