/* WindowListModel.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from WindowListModel.vala, do not modify */

/*
 * Copyright 2025 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 * Authored by: Leonhard Kargl <leo.kargl@proton.me>
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <meta/display.h>
#include <glib.h>
#include <meta/workspace.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <meta/window.h>
#include <meta/meta-window-actor.h>
#include "gala.h"
#include <meta/meta-workspace-manager.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_WINDOW_LIST_MODEL (gala_window_list_model_get_type ())
#define GALA_WINDOW_LIST_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_LIST_MODEL, GalaWindowListModel))
#define GALA_WINDOW_LIST_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_LIST_MODEL, GalaWindowListModelClass))
#define GALA_IS_WINDOW_LIST_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_LIST_MODEL))
#define GALA_IS_WINDOW_LIST_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_LIST_MODEL))
#define GALA_WINDOW_LIST_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_LIST_MODEL, GalaWindowListModelClass))

typedef struct _GalaWindowListModel GalaWindowListModel;
typedef struct _GalaWindowListModelClass GalaWindowListModelClass;
typedef struct _GalaWindowListModelPrivate GalaWindowListModelPrivate;
typedef enum  {
	GALA_WINDOW_LIST_MODEL_SORT_MODE_NONE,
	GALA_WINDOW_LIST_MODEL_SORT_MODE_STACKING
} GalaWindowListModelSortMode;

#define GALA_WINDOW_LIST_MODEL_TYPE_SORT_MODE (gala_window_list_model_sort_mode_get_type ())
enum  {
	GALA_WINDOW_LIST_MODEL_0_PROPERTY,
	GALA_WINDOW_LIST_MODEL_DISPLAY_PROPERTY,
	GALA_WINDOW_LIST_MODEL_SORT_MODE_PROPERTY,
	GALA_WINDOW_LIST_MODEL_NORMAL_FILTER_PROPERTY,
	GALA_WINDOW_LIST_MODEL_MONITOR_FILTER_PROPERTY,
	GALA_WINDOW_LIST_MODEL_WORKSPACE_FILTER_PROPERTY,
	GALA_WINDOW_LIST_MODEL_CUSTOM_FILTER_PROPERTY,
	GALA_WINDOW_LIST_MODEL_NUM_PROPERTIES
};
static GParamSpec* gala_window_list_model_properties[GALA_WINDOW_LIST_MODEL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef void (*GalaInternalUtilsWindowActorReadyCallback) (MetaWindowActor* window_actor, gpointer user_data);

#define GALA_TYPE_STATIC_WINDOW_CONTAINER (gala_static_window_container_get_type ())
#define GALA_STATIC_WINDOW_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_STATIC_WINDOW_CONTAINER, GalaStaticWindowContainer))
#define GALA_STATIC_WINDOW_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_STATIC_WINDOW_CONTAINER, GalaStaticWindowContainerClass))
#define GALA_IS_STATIC_WINDOW_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_STATIC_WINDOW_CONTAINER))
#define GALA_IS_STATIC_WINDOW_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_STATIC_WINDOW_CONTAINER))
#define GALA_STATIC_WINDOW_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_STATIC_WINDOW_CONTAINER, GalaStaticWindowContainerClass))

typedef struct _GalaStaticWindowContainer GalaStaticWindowContainer;
typedef struct _GalaStaticWindowContainerClass GalaStaticWindowContainerClass;

#define GALA_TYPE_WINDOW_LISTENER (gala_window_listener_get_type ())
#define GALA_WINDOW_LISTENER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_LISTENER, GalaWindowListener))
#define GALA_WINDOW_LISTENER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_LISTENER, GalaWindowListenerClass))
#define GALA_IS_WINDOW_LISTENER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_LISTENER))
#define GALA_IS_WINDOW_LISTENER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_LISTENER))
#define GALA_WINDOW_LISTENER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_LISTENER, GalaWindowListenerClass))

typedef struct _GalaWindowListener GalaWindowListener;
typedef struct _GalaWindowListenerClass GalaWindowListenerClass;

struct _GalaWindowListModel {
	GObject parent_instance;
	GalaWindowListModelPrivate * priv;
};

struct _GalaWindowListModelClass {
	GObjectClass parent_class;
};

struct _GalaWindowListModelPrivate {
	MetaDisplay* _display;
	GalaWindowListModelSortMode _sort_mode;
	gboolean _normal_filter;
	gint _monitor_filter;
	MetaWorkspace* _workspace_filter;
	GtkFilter* _custom_filter;
	GeeArrayList* windows;
};

static gint GalaWindowListModel_private_offset;
static gpointer gala_window_list_model_parent_class = NULL;
static GListModelInterface * gala_window_list_model_g_list_model_parent_iface = NULL;

VALA_EXTERN GType gala_window_list_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowListModel, g_object_unref)
VALA_EXTERN GType gala_window_list_model_sort_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GalaWindowListModel* gala_window_list_model_new (MetaDisplay* display,
                                                 GalaWindowListModelSortMode sort_mode,
                                                 gboolean normal_filter,
                                                 gint monitor_filter,
                                                 MetaWorkspace* workspace_filter,
                                                 GtkFilter* custom_filter);
VALA_EXTERN GalaWindowListModel* gala_window_list_model_construct (GType object_type,
                                                       MetaDisplay* display,
                                                       GalaWindowListModelSortMode sort_mode,
                                                       gboolean normal_filter,
                                                       gint monitor_filter,
                                                       MetaWorkspace* workspace_filter,
                                                       GtkFilter* custom_filter);
static void gala_window_list_model_on_window_created (GalaWindowListModel* self,
                                               MetaWindow* window);
static void gala_window_list_model_on_window_unmanaging (GalaWindowListModel* self,
                                                  MetaWindow* window);
static void _gala_window_list_model_on_window_unmanaging_meta_window_unmanaging (MetaWindow* _sender,
                                                                          gpointer self);
VALA_EXTERN void gala_internal_utils_wait_for_window_actor (MetaWindow* window,
                                                GalaInternalUtilsWindowActorReadyCallback callback,
                                                gpointer callback_target,
                                                GDestroyNotify callback_target_destroy_notify);
static void __lambda31_ (GalaWindowListModel* self,
                  MetaWindowActor* actor);
static void gala_window_list_model_check_window (GalaWindowListModel* self,
                                          MetaWindow* window);
static void ___lambda31__gala_internal_utils_window_actor_ready_callback (MetaWindowActor* window_actor,
                                                                   gpointer self);
static void gala_window_list_model_check_all (GalaWindowListModel* self);
VALA_EXTERN MetaDisplay* gala_window_list_model_get_display (GalaWindowListModel* self);
static gboolean gala_window_list_model_should_present_window (GalaWindowListModel* self,
                                                       MetaWindow* window);
VALA_EXTERN gint gala_window_list_model_get_monitor_filter (GalaWindowListModel* self);
VALA_EXTERN MetaWorkspace* gala_window_list_model_get_workspace_filter (GalaWindowListModel* self);
VALA_EXTERN GType gala_static_window_container_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaStaticWindowContainer, g_object_unref)
VALA_EXTERN GalaStaticWindowContainer* gala_static_window_container_get_instance (MetaDisplay* display);
VALA_EXTERN gboolean gala_static_window_container_is_static (GalaStaticWindowContainer* self,
                                                 MetaWindow* window);
VALA_EXTERN gboolean gala_window_list_model_get_normal_filter (GalaWindowListModel* self);
VALA_EXTERN GtkFilter* gala_window_list_model_get_custom_filter (GalaWindowListModel* self);
VALA_EXTERN void gala_window_list_model_sort (GalaWindowListModel* self);
VALA_EXTERN GalaWindowListModelSortMode gala_window_list_model_get_sort_mode (GalaWindowListModel* self);
static GSList* gala_window_list_model_get_sorted_windows (GalaWindowListModel* self);
static GObject* gala_window_list_model_real_get_item (GListModel* base,
                                               guint position);
static guint gala_window_list_model_real_get_n_items (GListModel* base);
static GType gala_window_list_model_real_get_item_type (GListModel* base);
static void _g_object_unref0_ (gpointer var);
static inline void _g_slist_free__g_object_unref0_ (GSList* self);
static void gala_window_list_model_set_display (GalaWindowListModel* self,
                                         MetaDisplay* value);
static void gala_window_list_model_set_sort_mode (GalaWindowListModel* self,
                                           GalaWindowListModelSortMode value);
VALA_EXTERN void gala_window_list_model_set_normal_filter (GalaWindowListModel* self,
                                               gboolean value);
VALA_EXTERN void gala_window_list_model_set_monitor_filter (GalaWindowListModel* self,
                                                gint value);
VALA_EXTERN void gala_window_list_model_set_workspace_filter (GalaWindowListModel* self,
                                                  MetaWorkspace* value);
VALA_EXTERN void gala_window_list_model_set_custom_filter (GalaWindowListModel* self,
                                               GtkFilter* value);
static GObject * gala_window_list_model_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static void _gala_window_list_model_on_window_created_meta_display_window_created (MetaDisplay* _sender,
                                                                            MetaWindow* object,
                                                                            gpointer self);
VALA_EXTERN GType gala_window_listener_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowListener, g_object_unref)
VALA_EXTERN GalaWindowListener* gala_window_listener_get_default (void);
static void _gala_window_list_model_check_window_gala_window_listener_window_workspace_changed (GalaWindowListener* _sender,
                                                                                         MetaWindow* window,
                                                                                         gpointer self);
static void _gala_window_list_model_check_window_gala_static_window_container_window_changed (GalaStaticWindowContainer* _sender,
                                                                                       MetaWindow* window,
                                                                                       gboolean is_static,
                                                                                       gpointer self);
static void _gala_window_list_model___lambda36_ (GalaWindowListModel* self,
                                          gint monitor,
                                          MetaWindow* win);
static void __gala_window_list_model___lambda36__meta_display_window_entered_monitor (MetaDisplay* _sender,
                                                                               gint object,
                                                                               MetaWindow* p0,
                                                                               gpointer self);
static void _gala_window_list_model_check_all_g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self);
static void gala_window_list_model_finalize (GObject * obj);
static GType gala_window_list_model_get_type_once (void);
static void _vala_gala_window_list_model_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_gala_window_list_model_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static inline gpointer
gala_window_list_model_get_instance_private (GalaWindowListModel* self)
{
	return G_STRUCT_MEMBER_P (self, GalaWindowListModel_private_offset);
}

 G_GNUC_NO_INLINE static GType
gala_window_list_model_sort_mode_get_type_once (void)
{
	static const GEnumValue values[] = {{GALA_WINDOW_LIST_MODEL_SORT_MODE_NONE, "GALA_WINDOW_LIST_MODEL_SORT_MODE_NONE", "none"}, {GALA_WINDOW_LIST_MODEL_SORT_MODE_STACKING, "GALA_WINDOW_LIST_MODEL_SORT_MODE_STACKING", "stacking"}, {0, NULL, NULL}};
	GType gala_window_list_model_sort_mode_type_id;
	gala_window_list_model_sort_mode_type_id = g_enum_register_static ("GalaWindowListModelSortMode", values);
	return gala_window_list_model_sort_mode_type_id;
}

GType
gala_window_list_model_sort_mode_get_type (void)
{
	static gsize gala_window_list_model_sort_mode_type_id__once = 0;
	if (g_once_init_enter (&gala_window_list_model_sort_mode_type_id__once)) {
		GType gala_window_list_model_sort_mode_type_id;
		gala_window_list_model_sort_mode_type_id = gala_window_list_model_sort_mode_get_type_once ();
		g_once_init_leave (&gala_window_list_model_sort_mode_type_id__once, gala_window_list_model_sort_mode_type_id);
	}
	return gala_window_list_model_sort_mode_type_id__once;
}

GalaWindowListModel*
gala_window_list_model_construct (GType object_type,
                                  MetaDisplay* display,
                                  GalaWindowListModelSortMode sort_mode,
                                  gboolean normal_filter,
                                  gint monitor_filter,
                                  MetaWorkspace* workspace_filter,
                                  GtkFilter* custom_filter)
{
	GalaWindowListModel * self = NULL;
	g_return_val_if_fail (display != NULL, NULL);
	self = (GalaWindowListModel*) g_object_new (object_type, "display", display, "sort-mode", sort_mode, "normal-filter", normal_filter, "monitor-filter", monitor_filter, "workspace-filter", workspace_filter, "custom-filter", custom_filter, NULL);
	return self;
}

GalaWindowListModel*
gala_window_list_model_new (MetaDisplay* display,
                            GalaWindowListModelSortMode sort_mode,
                            gboolean normal_filter,
                            gint monitor_filter,
                            MetaWorkspace* workspace_filter,
                            GtkFilter* custom_filter)
{
	return gala_window_list_model_construct (GALA_TYPE_WINDOW_LIST_MODEL, display, sort_mode, normal_filter, monitor_filter, workspace_filter, custom_filter);
}

static void
_gala_window_list_model_on_window_unmanaging_meta_window_unmanaging (MetaWindow* _sender,
                                                                     gpointer self)
{
	gala_window_list_model_on_window_unmanaging ((GalaWindowListModel*) self, _sender);
}

static void
__lambda31_ (GalaWindowListModel* self,
             MetaWindowActor* actor)
{
	MetaWindow* _tmp0_;
	MetaWindow* _tmp1_;
	g_return_if_fail (actor != NULL);
	_tmp0_ = meta_window_actor_get_meta_window (actor);
	_tmp1_ = _tmp0_;
	gala_window_list_model_check_window (self, _tmp1_);
}

static void
___lambda31__gala_internal_utils_window_actor_ready_callback (MetaWindowActor* window_actor,
                                                              gpointer self)
{
	__lambda31_ ((GalaWindowListModel*) self, window_actor);
}

static void
gala_window_list_model_on_window_created (GalaWindowListModel* self,
                                          MetaWindow* window)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	g_signal_connect_object (window, "unmanaging", (GCallback) _gala_window_list_model_on_window_unmanaging_meta_window_unmanaging, self, 0);
	gala_internal_utils_wait_for_window_actor (window, ___lambda31__gala_internal_utils_window_actor_ready_callback, g_object_ref (self), g_object_unref);
}

static void
gala_window_list_model_on_window_unmanaging (GalaWindowListModel* self,
                                             MetaWindow* window)
{
	gint pos = 0;
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->windows;
	pos = gee_abstract_list_index_of ((GeeAbstractList*) _tmp0_, window);
	if (pos >= 0) {
		GeeArrayList* _tmp1_;
		gpointer _tmp2_;
		MetaWindow* _tmp3_;
		_tmp1_ = self->priv->windows;
		_tmp2_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp1_, pos);
		_tmp3_ = (MetaWindow*) _tmp2_;
		_g_object_unref0 (_tmp3_);
		g_list_model_items_changed ((GListModel*) self, (guint) pos, (guint) 1, (guint) 0);
	}
}

static void
gala_window_list_model_check_all (GalaWindowListModel* self)
{
	MetaDisplay* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_display;
	_tmp1_ = meta_display_list_all_windows (_tmp0_);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp1_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MetaWindow* window = NULL;
			window = (MetaWindow*) window_it->data;
			{
				MetaWindow* _tmp2_;
				_tmp2_ = window;
				gala_window_list_model_check_window (self, _tmp2_);
			}
		}
		(window_collection == NULL) ? NULL : (window_collection = (g_list_free (window_collection), NULL));
	}
}

static void
gala_window_list_model_check_window (GalaWindowListModel* self,
                                     MetaWindow* window)
{
	gboolean exists = FALSE;
	GeeArrayList* _tmp0_;
	gboolean should_exist = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->windows;
	exists = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, window);
	should_exist = gala_window_list_model_should_present_window (self, window);
	if (!exists) {
		_tmp1_ = should_exist;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GeeArrayList* _tmp2_;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp2_ = self->priv->windows;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, window);
		_tmp3_ = self->priv->windows;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		g_list_model_items_changed ((GListModel*) self, (guint) (_tmp5_ - 1), (guint) 0, (guint) 1);
	} else {
		gboolean _tmp6_ = FALSE;
		if (exists) {
			_tmp6_ = !should_exist;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			gint pos = 0;
			GeeArrayList* _tmp7_;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			MetaWindow* _tmp10_;
			_tmp7_ = self->priv->windows;
			pos = gee_abstract_list_index_of ((GeeAbstractList*) _tmp7_, window);
			_tmp8_ = self->priv->windows;
			_tmp9_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp8_, pos);
			_tmp10_ = (MetaWindow*) _tmp9_;
			_g_object_unref0 (_tmp10_);
			g_list_model_items_changed ((GListModel*) self, (guint) pos, (guint) 1, (guint) 0);
		}
	}
}

static gboolean
gala_window_list_model_should_present_window (GalaWindowListModel* self,
                                              MetaWindow* window)
{
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gboolean _tmp3_ = FALSE;
	MetaWorkspace* _tmp4_;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_;
	GtkFilter* _tmp13_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (window != NULL, FALSE);
	_tmp1_ = self->priv->_monitor_filter;
	if (_tmp1_ >= 0) {
		gint _tmp2_;
		_tmp2_ = self->priv->_monitor_filter;
		_tmp0_ = _tmp2_ != meta_window_get_monitor (window);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = self->priv->_workspace_filter;
	if (_tmp4_ != NULL) {
		gboolean _tmp5_ = FALSE;
		MetaDisplay* _tmp6_;
		GalaStaticWindowContainer* _tmp7_;
		GalaStaticWindowContainer* _tmp8_;
		gboolean _tmp9_;
		_tmp6_ = self->priv->_display;
		_tmp7_ = gala_static_window_container_get_instance (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = gala_static_window_container_is_static (_tmp8_, window);
		_g_object_unref0 (_tmp8_);
		if (_tmp9_) {
			_tmp5_ = TRUE;
		} else {
			MetaWorkspace* _tmp10_;
			_tmp10_ = self->priv->_workspace_filter;
			_tmp5_ = !meta_window_located_on_workspace (window, _tmp10_);
		}
		_tmp3_ = _tmp5_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		result = FALSE;
		return result;
	}
	_tmp12_ = self->priv->_normal_filter;
	if (_tmp12_) {
		_tmp11_ = !gala_utils_get_window_is_normal (window);
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		result = FALSE;
		return result;
	}
	_tmp13_ = self->priv->_custom_filter;
	if (_tmp13_ != NULL) {
		GtkFilter* _tmp14_;
		_tmp14_ = self->priv->_custom_filter;
		result = gtk_filter_match (_tmp14_, (GObject*) window);
		return result;
	}
	result = TRUE;
	return result;
}

void
gala_window_list_model_sort (GalaWindowListModel* self)
{
	GalaWindowListModelSortMode _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_sort_mode;
	if (_tmp0_ == GALA_WINDOW_LIST_MODEL_SORT_MODE_STACKING) {
		gint i = 0;
		GSList* _tmp1_;
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		GeeArrayList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		i = 0;
		_tmp1_ = gala_window_list_model_get_sorted_windows (self);
		{
			GSList* window_collection = NULL;
			GSList* window_it = NULL;
			window_collection = _tmp1_;
			for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
				MetaWindow* window = NULL;
				window = (MetaWindow*) window_it->data;
				{
					GeeArrayList* _tmp2_;
					gint _tmp3_;
					MetaWindow* _tmp4_;
					_tmp2_ = self->priv->windows;
					_tmp3_ = i;
					i = _tmp3_ + 1;
					_tmp4_ = window;
					gee_abstract_list_set ((GeeAbstractList*) _tmp2_, _tmp3_, _tmp4_);
				}
			}
			(window_collection == NULL) ? NULL : (window_collection = (g_slist_free (window_collection), NULL));
		}
		_tmp5_ = self->priv->windows;
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = self->priv->windows;
		_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		g_list_model_items_changed ((GListModel*) self, (guint) 0, (guint) _tmp7_, (guint) _tmp10_);
	}
}

static GObject*
gala_window_list_model_real_get_item (GListModel* base,
                                      guint position)
{
	GalaWindowListModel * self;
	GeeArrayList* _tmp0_;
	gpointer _tmp1_;
	GObject* result;
	self = (GalaWindowListModel*) base;
	_tmp0_ = self->priv->windows;
	_tmp1_ = gee_abstract_list_get ((GeeAbstractList*) _tmp0_, (gint) position);
	result = (GObject*) ((MetaWindow*) _tmp1_);
	return result;
}

static guint
gala_window_list_model_real_get_n_items (GListModel* base)
{
	GalaWindowListModel * self;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint result;
	self = (GalaWindowListModel*) base;
	_tmp0_ = self->priv->windows;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = (guint) _tmp2_;
	return result;
}

static GType
gala_window_list_model_real_get_item_type (GListModel* base)
{
	GalaWindowListModel * self;
	GType result;
	self = (GalaWindowListModel*) base;
	result = meta_window_get_type ();
	return result;
}

/**
     * Sorts the windows by stacking order so that the window on active workspaces come first.
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_slist_free__g_object_unref0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static GSList*
gala_window_list_model_get_sorted_windows (GalaWindowListModel* self)
{
	GSList* windows_on_active_workspace = NULL;
	GSList* windows_on_other_workspaces = NULL;
	MetaWorkspace* active_workspace = NULL;
	MetaDisplay* _tmp0_;
	MetaWorkspaceManager* _tmp1_;
	MetaWorkspace* _tmp2_;
	GSList* sorted_windows = NULL;
	GSList* windows_on_active_workspace_sorted = NULL;
	MetaDisplay* _tmp18_;
	GSList* _tmp19_;
	GSList* _tmp20_;
	GSList* windows_on_other_workspaces_sorted = NULL;
	MetaDisplay* _tmp21_;
	GSList* _tmp22_;
	GSList* _tmp23_;
	GSList* _tmp24_;
	GSList* _tmp25_;
	GSList* result;
	g_return_val_if_fail (self != NULL, NULL);
	windows_on_active_workspace = NULL;
	windows_on_other_workspaces = NULL;
	_tmp0_ = self->priv->_display;
	_tmp1_ = meta_display_get_workspace_manager (_tmp0_);
	_tmp2_ = meta_workspace_manager_get_active_workspace (_tmp1_);
	active_workspace = _tmp2_;
	{
		GeeArrayList* _window_list = NULL;
		GeeArrayList* _tmp3_;
		gint _window_size = 0;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _window_index = 0;
		_tmp3_ = self->priv->windows;
		_window_list = _tmp3_;
		_tmp4_ = _window_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_window_size = _tmp6_;
		_window_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			MetaWindow* window = NULL;
			GeeArrayList* _tmp9_;
			gpointer _tmp10_;
			MetaWindow* _tmp11_;
			MetaWorkspace* _tmp12_;
			MetaWorkspace* _tmp13_;
			_window_index = _window_index + 1;
			_tmp7_ = _window_index;
			_tmp8_ = _window_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _window_list;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _window_index);
			window = (MetaWindow*) _tmp10_;
			_tmp11_ = window;
			_tmp12_ = meta_window_get_workspace (_tmp11_);
			_tmp13_ = active_workspace;
			if (_tmp12_ == _tmp13_) {
				MetaWindow* _tmp14_;
				MetaWindow* _tmp15_;
				_tmp14_ = window;
				_tmp15_ = _g_object_ref0 (_tmp14_);
				windows_on_active_workspace = g_slist_prepend (windows_on_active_workspace, _tmp15_);
			} else {
				MetaWindow* _tmp16_;
				MetaWindow* _tmp17_;
				_tmp16_ = window;
				_tmp17_ = _g_object_ref0 (_tmp16_);
				windows_on_other_workspaces = g_slist_prepend (windows_on_other_workspaces, _tmp17_);
			}
			_g_object_unref0 (window);
		}
	}
	sorted_windows = NULL;
	_tmp18_ = self->priv->_display;
	_tmp19_ = windows_on_active_workspace;
	_tmp20_ = meta_display_sort_windows_by_stacking (_tmp18_, _tmp19_);
	windows_on_active_workspace_sorted = _tmp20_;
	_tmp21_ = self->priv->_display;
	_tmp22_ = windows_on_other_workspaces;
	_tmp23_ = meta_display_sort_windows_by_stacking (_tmp21_, _tmp22_);
	windows_on_other_workspaces_sorted = _tmp23_;
	_tmp24_ = windows_on_other_workspaces_sorted;
	windows_on_other_workspaces_sorted = NULL;
	sorted_windows = g_slist_concat (sorted_windows, _tmp24_);
	_tmp25_ = windows_on_active_workspace_sorted;
	windows_on_active_workspace_sorted = NULL;
	sorted_windows = g_slist_concat (sorted_windows, _tmp25_);
	result = sorted_windows;
	(windows_on_other_workspaces_sorted == NULL) ? NULL : (windows_on_other_workspaces_sorted = (g_slist_free (windows_on_other_workspaces_sorted), NULL));
	(windows_on_active_workspace_sorted == NULL) ? NULL : (windows_on_active_workspace_sorted = (g_slist_free (windows_on_active_workspace_sorted), NULL));
	(windows_on_other_workspaces == NULL) ? NULL : (windows_on_other_workspaces = (_g_slist_free__g_object_unref0_ (windows_on_other_workspaces), NULL));
	(windows_on_active_workspace == NULL) ? NULL : (windows_on_active_workspace = (_g_slist_free__g_object_unref0_ (windows_on_active_workspace), NULL));
	return result;
}

MetaDisplay*
gala_window_list_model_get_display (GalaWindowListModel* self)
{
	MetaDisplay* result;
	MetaDisplay* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display;
	result = _tmp0_;
	return result;
}

static void
gala_window_list_model_set_display (GalaWindowListModel* self,
                                    MetaDisplay* value)
{
	MetaDisplay* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_list_model_get_display (self);
	if (old_value != value) {
		MetaDisplay* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_display);
		self->priv->_display = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_window_list_model_properties[GALA_WINDOW_LIST_MODEL_DISPLAY_PROPERTY]);
	}
}

GalaWindowListModelSortMode
gala_window_list_model_get_sort_mode (GalaWindowListModel* self)
{
	GalaWindowListModelSortMode result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_sort_mode;
	return result;
}

static void
gala_window_list_model_set_sort_mode (GalaWindowListModel* self,
                                      GalaWindowListModelSortMode value)
{
	GalaWindowListModelSortMode old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_list_model_get_sort_mode (self);
	if (old_value != value) {
		self->priv->_sort_mode = value;
		g_object_notify_by_pspec ((GObject *) self, gala_window_list_model_properties[GALA_WINDOW_LIST_MODEL_SORT_MODE_PROPERTY]);
	}
}

gboolean
gala_window_list_model_get_normal_filter (GalaWindowListModel* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_normal_filter;
	return result;
}

void
gala_window_list_model_set_normal_filter (GalaWindowListModel* self,
                                          gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_list_model_get_normal_filter (self);
	if (old_value != value) {
		self->priv->_normal_filter = value;
		g_object_notify_by_pspec ((GObject *) self, gala_window_list_model_properties[GALA_WINDOW_LIST_MODEL_NORMAL_FILTER_PROPERTY]);
	}
}

gint
gala_window_list_model_get_monitor_filter (GalaWindowListModel* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_monitor_filter;
	return result;
}

void
gala_window_list_model_set_monitor_filter (GalaWindowListModel* self,
                                           gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_list_model_get_monitor_filter (self);
	if (old_value != value) {
		self->priv->_monitor_filter = value;
		g_object_notify_by_pspec ((GObject *) self, gala_window_list_model_properties[GALA_WINDOW_LIST_MODEL_MONITOR_FILTER_PROPERTY]);
	}
}

MetaWorkspace*
gala_window_list_model_get_workspace_filter (GalaWindowListModel* self)
{
	MetaWorkspace* result;
	MetaWorkspace* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_workspace_filter;
	result = _tmp0_;
	return result;
}

void
gala_window_list_model_set_workspace_filter (GalaWindowListModel* self,
                                             MetaWorkspace* value)
{
	MetaWorkspace* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_list_model_get_workspace_filter (self);
	if (old_value != value) {
		MetaWorkspace* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_workspace_filter);
		self->priv->_workspace_filter = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_window_list_model_properties[GALA_WINDOW_LIST_MODEL_WORKSPACE_FILTER_PROPERTY]);
	}
}

GtkFilter*
gala_window_list_model_get_custom_filter (GalaWindowListModel* self)
{
	GtkFilter* result;
	GtkFilter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_custom_filter;
	result = _tmp0_;
	return result;
}

void
gala_window_list_model_set_custom_filter (GalaWindowListModel* self,
                                          GtkFilter* value)
{
	GtkFilter* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_list_model_get_custom_filter (self);
	if (old_value != value) {
		GtkFilter* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_custom_filter);
		self->priv->_custom_filter = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_window_list_model_properties[GALA_WINDOW_LIST_MODEL_CUSTOM_FILTER_PROPERTY]);
	}
}

static void
_gala_window_list_model_on_window_created_meta_display_window_created (MetaDisplay* _sender,
                                                                       MetaWindow* object,
                                                                       gpointer self)
{
	gala_window_list_model_on_window_created ((GalaWindowListModel*) self, object);
}

static void
_gala_window_list_model_check_window_gala_window_listener_window_workspace_changed (GalaWindowListener* _sender,
                                                                                    MetaWindow* window,
                                                                                    gpointer self)
{
	gala_window_list_model_check_window ((GalaWindowListModel*) self, window);
}

static void
_gala_window_list_model_check_window_gala_static_window_container_window_changed (GalaStaticWindowContainer* _sender,
                                                                                  MetaWindow* window,
                                                                                  gboolean is_static,
                                                                                  gpointer self)
{
	gala_window_list_model_check_window ((GalaWindowListModel*) self, window);
}

static void
_gala_window_list_model___lambda36_ (GalaWindowListModel* self,
                                     gint monitor,
                                     MetaWindow* win)
{
	g_return_if_fail (win != NULL);
	gala_window_list_model_check_window (self, win);
}

static void
__gala_window_list_model___lambda36__meta_display_window_entered_monitor (MetaDisplay* _sender,
                                                                          gint object,
                                                                          MetaWindow* p0,
                                                                          gpointer self)
{
	_gala_window_list_model___lambda36_ ((GalaWindowListModel*) self, object, p0);
}

static void
_gala_window_list_model_check_all_g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self)
{
	gala_window_list_model_check_all ((GalaWindowListModel*) self);
}

static GObject *
gala_window_list_model_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaWindowListModel * self;
	GeeArrayList* _tmp0_;
	MetaDisplay* _tmp1_;
	GalaWindowListener* _tmp2_;
	MetaDisplay* _tmp3_;
	GalaStaticWindowContainer* _tmp4_;
	GalaStaticWindowContainer* _tmp5_;
	MetaDisplay* _tmp6_;
	parent_class = G_OBJECT_CLASS (gala_window_list_model_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WINDOW_LIST_MODEL, GalaWindowListModel);
	_tmp0_ = gee_array_list_new (meta_window_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->windows);
	self->priv->windows = _tmp0_;
	_tmp1_ = self->priv->_display;
	g_signal_connect_object (_tmp1_, "window-created", (GCallback) _gala_window_list_model_on_window_created_meta_display_window_created, self, 0);
	_tmp2_ = gala_window_listener_get_default ();
	g_signal_connect_object (_tmp2_, "window-workspace-changed", (GCallback) _gala_window_list_model_check_window_gala_window_listener_window_workspace_changed, self, 0);
	_tmp3_ = self->priv->_display;
	_tmp4_ = gala_static_window_container_get_instance (_tmp3_);
	_tmp5_ = _tmp4_;
	g_signal_connect_object (_tmp5_, "window-changed", (GCallback) _gala_window_list_model_check_window_gala_static_window_container_window_changed, self, 0);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = self->priv->_display;
	g_signal_connect_object (_tmp6_, "window-entered-monitor", (GCallback) __gala_window_list_model___lambda36__meta_display_window_entered_monitor, self, 0);
	g_signal_connect_object ((GObject*) self, "notify", (GCallback) _gala_window_list_model_check_all_g_object_notify, self, 0);
	gala_window_list_model_check_all (self);
	return obj;
}

static void
gala_window_list_model_class_init (GalaWindowListModelClass * klass,
                                   gpointer klass_data)
{
	gala_window_list_model_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaWindowListModel_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_window_list_model_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_window_list_model_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_window_list_model_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_window_list_model_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_LIST_MODEL_DISPLAY_PROPERTY, gala_window_list_model_properties[GALA_WINDOW_LIST_MODEL_DISPLAY_PROPERTY] = g_param_spec_object ("display", "display", "display", meta_display_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_LIST_MODEL_SORT_MODE_PROPERTY, gala_window_list_model_properties[GALA_WINDOW_LIST_MODEL_SORT_MODE_PROPERTY] = g_param_spec_enum ("sort-mode", "sort-mode", "sort-mode", GALA_WINDOW_LIST_MODEL_TYPE_SORT_MODE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * If true only present windows that are normal as gotten by {@link Utils.get_window_is_normal}.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_LIST_MODEL_NORMAL_FILTER_PROPERTY, gala_window_list_model_properties[GALA_WINDOW_LIST_MODEL_NORMAL_FILTER_PROPERTY] = g_param_spec_boolean ("normal-filter", "normal-filter", "normal-filter", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	     * If >= 0 only present windows that are on this monitor.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_LIST_MODEL_MONITOR_FILTER_PROPERTY, gala_window_list_model_properties[GALA_WINDOW_LIST_MODEL_MONITOR_FILTER_PROPERTY] = g_param_spec_int ("monitor-filter", "monitor-filter", "monitor-filter", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	     * If not null only present windows that are on this workspace.
	     * This also excludes static windows as defined by {@link StaticWindowContainer.is_static}.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_LIST_MODEL_WORKSPACE_FILTER_PROPERTY, gala_window_list_model_properties[GALA_WINDOW_LIST_MODEL_WORKSPACE_FILTER_PROPERTY] = g_param_spec_object ("workspace-filter", "workspace-filter", "workspace-filter", meta_workspace_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_LIST_MODEL_CUSTOM_FILTER_PROPERTY, gala_window_list_model_properties[GALA_WINDOW_LIST_MODEL_CUSTOM_FILTER_PROPERTY] = g_param_spec_object ("custom-filter", "custom-filter", "custom-filter", gtk_filter_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
gala_window_list_model_g_list_model_interface_init (GListModelInterface * iface,
                                                    gpointer iface_data)
{
	gala_window_list_model_g_list_model_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_item = (GObject* (*) (GListModel*, guint)) gala_window_list_model_real_get_item;
	iface->get_n_items = (guint (*) (GListModel*)) gala_window_list_model_real_get_n_items;
	iface->get_item_type = (GType (*) (GListModel*)) gala_window_list_model_real_get_item_type;
}

static void
gala_window_list_model_instance_init (GalaWindowListModel * self,
                                      gpointer klass)
{
	self->priv = gala_window_list_model_get_instance_private (self);
}

static void
gala_window_list_model_finalize (GObject * obj)
{
	GalaWindowListModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WINDOW_LIST_MODEL, GalaWindowListModel);
	_g_object_unref0 (self->priv->_display);
	_g_object_unref0 (self->priv->_workspace_filter);
	_g_object_unref0 (self->priv->_custom_filter);
	_g_object_unref0 (self->priv->windows);
	G_OBJECT_CLASS (gala_window_list_model_parent_class)->finalize (obj);
}

/**
 * A list model that provides all current windows optionally filtered and sorted.
 * While a window is in the model it is guaranteed to have an associated actor, i.e.
 * {@link Meta.Window.get_compositor_private} will not return null.
 */
 G_GNUC_NO_INLINE static GType
gala_window_list_model_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaWindowListModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_window_list_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaWindowListModel), 0, (GInstanceInitFunc) gala_window_list_model_instance_init, NULL };
	static const GInterfaceInfo g_list_model_info = { (GInterfaceInitFunc) gala_window_list_model_g_list_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gala_window_list_model_type_id;
	gala_window_list_model_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaWindowListModel", &g_define_type_info, 0);
	g_type_add_interface_static (gala_window_list_model_type_id, g_list_model_get_type (), &g_list_model_info);
	GalaWindowListModel_private_offset = g_type_add_instance_private (gala_window_list_model_type_id, sizeof (GalaWindowListModelPrivate));
	return gala_window_list_model_type_id;
}

GType
gala_window_list_model_get_type (void)
{
	static gsize gala_window_list_model_type_id__once = 0;
	if (g_once_init_enter (&gala_window_list_model_type_id__once)) {
		GType gala_window_list_model_type_id;
		gala_window_list_model_type_id = gala_window_list_model_get_type_once ();
		g_once_init_leave (&gala_window_list_model_type_id__once, gala_window_list_model_type_id);
	}
	return gala_window_list_model_type_id__once;
}

static void
_vala_gala_window_list_model_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	GalaWindowListModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WINDOW_LIST_MODEL, GalaWindowListModel);
	switch (property_id) {
		case GALA_WINDOW_LIST_MODEL_DISPLAY_PROPERTY:
		g_value_set_object (value, gala_window_list_model_get_display (self));
		break;
		case GALA_WINDOW_LIST_MODEL_SORT_MODE_PROPERTY:
		g_value_set_enum (value, gala_window_list_model_get_sort_mode (self));
		break;
		case GALA_WINDOW_LIST_MODEL_NORMAL_FILTER_PROPERTY:
		g_value_set_boolean (value, gala_window_list_model_get_normal_filter (self));
		break;
		case GALA_WINDOW_LIST_MODEL_MONITOR_FILTER_PROPERTY:
		g_value_set_int (value, gala_window_list_model_get_monitor_filter (self));
		break;
		case GALA_WINDOW_LIST_MODEL_WORKSPACE_FILTER_PROPERTY:
		g_value_set_object (value, gala_window_list_model_get_workspace_filter (self));
		break;
		case GALA_WINDOW_LIST_MODEL_CUSTOM_FILTER_PROPERTY:
		g_value_set_object (value, gala_window_list_model_get_custom_filter (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_window_list_model_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	GalaWindowListModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WINDOW_LIST_MODEL, GalaWindowListModel);
	switch (property_id) {
		case GALA_WINDOW_LIST_MODEL_DISPLAY_PROPERTY:
		gala_window_list_model_set_display (self, g_value_get_object (value));
		break;
		case GALA_WINDOW_LIST_MODEL_SORT_MODE_PROPERTY:
		gala_window_list_model_set_sort_mode (self, g_value_get_enum (value));
		break;
		case GALA_WINDOW_LIST_MODEL_NORMAL_FILTER_PROPERTY:
		gala_window_list_model_set_normal_filter (self, g_value_get_boolean (value));
		break;
		case GALA_WINDOW_LIST_MODEL_MONITOR_FILTER_PROPERTY:
		gala_window_list_model_set_monitor_filter (self, g_value_get_int (value));
		break;
		case GALA_WINDOW_LIST_MODEL_WORKSPACE_FILTER_PROPERTY:
		gala_window_list_model_set_workspace_filter (self, g_value_get_object (value));
		break;
		case GALA_WINDOW_LIST_MODEL_CUSTOM_FILTER_PROPERTY:
		gala_window_list_model_set_custom_filter (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

