// Copyright (C) 2022 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#pragma once

#include <stdint.h>

#include "aemu/base/synchronization/Lock.h"

namespace gfxstream {

class DisplaySurface;
class DisplaySurfaceUser;

class DisplaySurfaceUser {
  public:
    virtual ~DisplaySurfaceUser();

  public:
    void bindToSurface(DisplaySurface* surface);

    void unbindFromSurface();

  protected:
    virtual void bindToSurfaceImpl(DisplaySurface* surface) = 0;

    virtual void surfaceUpdated(DisplaySurface* surface) = 0;

    virtual void unbindFromSurfaceImpl() = 0;

    const DisplaySurface* getBoundSurface() const { return mBoundSurface; }

   protected:
    android::base::Lock mMutex;

   private:
    friend class DisplaySurface;
    DisplaySurface* mBoundSurface = nullptr;
};

}  // namespace gfxstream
