/* gpx-parser-xml.c generated by valac 0.56.18, the Vala compiler
 * generated from gpx-parser-xml.vala, do not modify */

/* Gpx Viewer
 * Copyright (C) 2009-2015 Qball Cow <qball@sarine.nl>
 * Project homepage: http://blog.sarine.nl/

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include "gpx.h"
#include <gio/gio.h>
#include <glib.h>
#include <libxml/tree.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <libxml/xmlreader.h>
#include <libxml/xmlIO.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GPX_XML_FILE_0_PROPERTY,
	GPX_XML_FILE_NUM_PROPERTIES
};
static GParamSpec* gpx_xml_file_properties[GPX_XML_FILE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gpx_point_unref0(var) ((var == NULL) ? NULL : (var = (gpx_point_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _xmlFreeTextReader0(var) ((var == NULL) ? NULL : (var = (xmlFreeTextReader (var), NULL)))

struct _GpxXmlFilePrivate {
	GFileInputStream* stream;
};

static gint GpxXmlFile_private_offset;
static gpointer gpx_xml_file_parent_class = NULL;

static GpxPoint* gpx_xml_file_parse_point (GpxXmlFile* self,
                                    xmlNode* point);
static void gpx_xml_file_parse_metadata (GpxXmlFile* self,
                                  xmlNode* metadata);
static GpxTrack* gpx_xml_file_parse_track (GpxXmlFile* self,
                                    xmlNode* trk);
static void gpx_xml_file_parse_waypoint (GpxXmlFile* self,
                                  xmlNode* node);
static GpxTrack* gpx_xml_file_parse_route (GpxXmlFile* self,
                                    xmlNode* node);
static gint gpx_xml_file_read_file (GpxXmlFile* self,
                             guint8* buffer,
                             gint buffer_length1);
static gint gpx_xml_file_close_file (GpxXmlFile* self);
static void gpx_xml_file_finalize (GObject * obj);
static GType gpx_xml_file_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
gpx_xml_file_get_instance_private (GpxXmlFile* self)
{
	return G_STRUCT_MEMBER_P (self, GpxXmlFile_private_offset);
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
#line 1004 "glib-2.0.vapi"
	result = g_ascii_strtod (str, NULL);
#line 1004 "glib-2.0.vapi"
	return result;
#line 96 "gpx-parser-xml.c"
}

static GpxPoint*
gpx_xml_file_parse_point (GpxXmlFile* self,
                          xmlNode* point)
{
	gchar* lat = NULL;
	gchar* _tmp0_;
	gchar* lon = NULL;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	GpxPoint* result;
#line 31 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	_tmp0_ = (gchar*) xmlGetProp (point, (xmlChar*) "lat");
#line 31 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	lat = _tmp0_;
#line 32 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	_tmp1_ = (gchar*) xmlGetProp (point, (xmlChar*) "lon");
#line 32 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	lon = _tmp1_;
#line 33 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	_tmp3_ = lat;
#line 33 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	if (_tmp3_ != NULL) {
#line 122 "gpx-parser-xml.c"
		const gchar* _tmp4_;
#line 33 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp4_ = lon;
#line 33 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp2_ = _tmp4_ != NULL;
#line 128 "gpx-parser-xml.c"
	} else {
#line 33 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp2_ = FALSE;
#line 132 "gpx-parser-xml.c"
	}
#line 33 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	if (_tmp2_) {
#line 136 "gpx-parser-xml.c"
		GpxPoint* p = NULL;
		GpxPoint* _tmp5_;
		gdouble flat = 0.0;
		const gchar* _tmp6_;
		gdouble flon = 0.0;
		const gchar* _tmp7_;
		GpxPoint* _tmp8_;
		xmlNode* pointNode = NULL;
		xmlNode* _tmp9_;
		GpxPoint* _tmp59_;
		const gchar* _tmp60_;
#line 35 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp5_ = gpx_point_new ();
#line 35 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		p = _tmp5_;
#line 37 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp6_ = lat;
#line 37 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		flat = double_parse (_tmp6_);
#line 38 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp7_ = lon;
#line 38 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		flon = double_parse (_tmp7_);
#line 39 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp8_ = p;
#line 39 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		gpx_point_set_position (_tmp8_, flat, flon);
#line 40 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp9_ = point->children;
#line 40 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		pointNode = _tmp9_;
#line 41 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		while (TRUE) {
#line 170 "gpx-parser-xml.c"
			xmlNode* _tmp10_;
			xmlNode* _tmp11_;
			const gchar* _tmp12_;
			xmlNode* _tmp57_;
			xmlNode* _tmp58_;
#line 41 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			_tmp10_ = pointNode;
#line 41 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			if (!(_tmp10_ != NULL)) {
#line 41 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				break;
#line 182 "gpx-parser-xml.c"
			}
#line 44 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			_tmp11_ = pointNode;
#line 44 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			_tmp12_ = _tmp11_->name;
#line 44 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			if (g_strcmp0 (_tmp12_, "ele") == 0) {
#line 190 "gpx-parser-xml.c"
				gchar* content = NULL;
				xmlNode* _tmp13_;
				gchar* _tmp14_;
				const gchar* _tmp15_;
#line 46 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				_tmp13_ = pointNode;
#line 46 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				_tmp14_ = (gchar*) xmlNodeGetContent (_tmp13_);
#line 46 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				content = _tmp14_;
#line 47 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				_tmp15_ = content;
#line 47 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				if (_tmp15_ != NULL) {
#line 205 "gpx-parser-xml.c"
					GpxPoint* _tmp16_;
					const gchar* _tmp17_;
#line 48 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_tmp16_ = p;
#line 48 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_tmp17_ = content;
#line 48 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_tmp16_->elevation = double_parse (_tmp17_);
#line 214 "gpx-parser-xml.c"
				}
#line 44 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				_g_free0 (content);
#line 218 "gpx-parser-xml.c"
			} else {
				xmlNode* _tmp18_;
				const gchar* _tmp19_;
#line 50 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				_tmp18_ = pointNode;
#line 50 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				_tmp19_ = _tmp18_->name;
#line 50 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				if (g_strcmp0 (_tmp19_, "name") == 0) {
#line 228 "gpx-parser-xml.c"
					GpxPoint* _tmp20_;
					xmlNode* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
#line 52 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_tmp20_ = p;
#line 52 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_tmp21_ = pointNode;
#line 52 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_tmp22_ = (gchar*) xmlNodeGetContent (_tmp21_);
#line 52 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_tmp23_ = _tmp22_;
#line 52 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					gpx_point_set_name (_tmp20_, _tmp23_);
#line 52 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_g_free0 (_tmp23_);
#line 245 "gpx-parser-xml.c"
				} else {
					xmlNode* _tmp24_;
					const gchar* _tmp25_;
#line 54 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_tmp24_ = pointNode;
#line 54 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_tmp25_ = _tmp24_->name;
#line 54 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					if (g_strcmp0 (_tmp25_, "desc") == 0) {
#line 255 "gpx-parser-xml.c"
						GpxPoint* _tmp26_;
						xmlNode* _tmp27_;
						gchar* _tmp28_;
						gchar* _tmp29_;
#line 56 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						_tmp26_ = p;
#line 56 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						_tmp27_ = pointNode;
#line 56 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						_tmp28_ = (gchar*) xmlNodeGetContent (_tmp27_);
#line 56 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						_tmp29_ = _tmp28_;
#line 56 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						gpx_point_set_description (_tmp26_, _tmp29_);
#line 56 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						_g_free0 (_tmp29_);
#line 272 "gpx-parser-xml.c"
					} else {
						xmlNode* _tmp30_;
						const gchar* _tmp31_;
#line 58 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						_tmp30_ = pointNode;
#line 58 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						_tmp31_ = _tmp30_->name;
#line 58 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						if (g_strcmp0 (_tmp31_, "time") == 0) {
#line 282 "gpx-parser-xml.c"
							GpxPoint* _tmp32_;
							xmlNode* _tmp33_;
							gchar* _tmp34_;
#line 60 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
							_tmp32_ = p;
#line 60 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
							_tmp33_ = pointNode;
#line 60 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
							_tmp34_ = (gchar*) xmlNodeGetContent (_tmp33_);
#line 60 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
							_g_free0 (_tmp32_->time);
#line 60 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
							_tmp32_->time = _tmp34_;
#line 296 "gpx-parser-xml.c"
						} else {
							xmlNode* _tmp35_;
							const gchar* _tmp36_;
#line 62 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
							_tmp35_ = pointNode;
#line 62 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
							_tmp36_ = _tmp35_->name;
#line 62 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
							if (g_strcmp0 (_tmp36_, "extensions") == 0) {
#line 306 "gpx-parser-xml.c"
								xmlNode* exts = NULL;
								xmlNode* _tmp37_;
								xmlNode* _tmp38_;
#line 64 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
								_tmp37_ = pointNode;
#line 64 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
								_tmp38_ = _tmp37_->children;
#line 64 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
								exts = _tmp38_;
#line 316 "gpx-parser-xml.c"
								{
									gboolean _tmp39_ = FALSE;
#line 65 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
									_tmp39_ = TRUE;
#line 65 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
									while (TRUE) {
#line 323 "gpx-parser-xml.c"
										xmlNode* _tmp42_;
										xmlNode* _tmp43_;
										const gchar* _tmp44_;
#line 65 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
										if (!_tmp39_) {
#line 329 "gpx-parser-xml.c"
											xmlNode* _tmp40_;
											xmlNode* _tmp41_;
#line 65 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
											_tmp40_ = exts;
#line 65 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
											_tmp41_ = _tmp40_->next;
#line 65 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
											exts = _tmp41_;
#line 338 "gpx-parser-xml.c"
										}
#line 65 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
										_tmp39_ = FALSE;
#line 65 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
										_tmp42_ = exts;
#line 65 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
										if (!(_tmp42_ != NULL)) {
#line 65 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
											break;
#line 348 "gpx-parser-xml.c"
										}
#line 66 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
										_tmp43_ = exts;
#line 66 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
										_tmp44_ = _tmp43_->name;
#line 66 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
										if (g_strcmp0 (_tmp44_, "TrackPointExtension") == 0) {
#line 356 "gpx-parser-xml.c"
											xmlNode* ext = NULL;
											xmlNode* _tmp45_;
											xmlNode* _tmp46_;
#line 68 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
											_tmp45_ = exts;
#line 68 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
											_tmp46_ = _tmp45_->children;
#line 68 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
											ext = _tmp46_;
#line 366 "gpx-parser-xml.c"
											{
												gboolean _tmp47_ = FALSE;
#line 69 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
												_tmp47_ = TRUE;
#line 69 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
												while (TRUE) {
#line 373 "gpx-parser-xml.c"
													xmlNode* _tmp50_;
													xmlNode* _tmp51_;
													const gchar* _tmp52_;
#line 69 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
													if (!_tmp47_) {
#line 379 "gpx-parser-xml.c"
														xmlNode* _tmp48_;
														xmlNode* _tmp49_;
#line 69 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
														_tmp48_ = ext;
#line 69 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
														_tmp49_ = _tmp48_->next;
#line 69 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
														ext = _tmp49_;
#line 388 "gpx-parser-xml.c"
													}
#line 69 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
													_tmp47_ = FALSE;
#line 69 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
													_tmp50_ = ext;
#line 69 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
													if (!(_tmp50_ != NULL)) {
#line 69 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
														break;
#line 398 "gpx-parser-xml.c"
													}
#line 71 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
													_tmp51_ = ext;
#line 71 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
													_tmp52_ = _tmp51_->name;
#line 71 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
													if (g_strcmp0 (_tmp52_, "hr") == 0) {
#line 406 "gpx-parser-xml.c"
														gchar* val = NULL;
														xmlNode* _tmp53_;
														gchar* _tmp54_;
														GpxPoint* _tmp55_;
														const gchar* _tmp56_;
#line 72 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
														_tmp53_ = ext;
#line 72 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
														_tmp54_ = (gchar*) xmlNodeGetContent (_tmp53_);
#line 72 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
														val = _tmp54_;
#line 73 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
														_tmp55_ = p;
#line 73 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
														_tmp56_ = val;
#line 73 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
														_tmp55_->tpe.heartrate = atoi (_tmp56_);
#line 71 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
														_g_free0 (val);
#line 426 "gpx-parser-xml.c"
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
#line 79 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			_tmp57_ = pointNode;
#line 79 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			_tmp58_ = _tmp57_->next;
#line 79 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			pointNode = _tmp58_;
#line 444 "gpx-parser-xml.c"
		}
#line 82 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp59_ = p;
#line 82 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp60_ = _tmp59_->time;
#line 82 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		if (_tmp60_ != NULL) {
#line 83 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			result = p;
#line 83 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			_g_free0 (lon);
#line 83 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			_g_free0 (lat);
#line 83 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			return result;
#line 460 "gpx-parser-xml.c"
		}
#line 33 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_gpx_point_unref0 (p);
#line 464 "gpx-parser-xml.c"
	}
#line 86 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	result = NULL;
#line 86 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	_g_free0 (lon);
#line 86 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	_g_free0 (lat);
#line 86 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	return result;
#line 474 "gpx-parser-xml.c"
}

static void
gpx_xml_file_parse_metadata (GpxXmlFile* self,
                             xmlNode* metadata)
{
	xmlNode* metadataChild = NULL;
	xmlNode* _tmp0_;
#line 92 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	_tmp0_ = metadata->children;
#line 92 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	metadataChild = _tmp0_;
#line 94 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	while (TRUE) {
#line 489 "gpx-parser-xml.c"
		xmlNode* _tmp1_;
		xmlNode* _tmp2_;
		const gchar* _tmp3_;
		xmlNode* _tmp6_;
		const gchar* _tmp7_;
		xmlNode* _tmp10_;
		const gchar* _tmp11_;
		xmlNode* _tmp14_;
		const gchar* _tmp15_;
		xmlNode* _tmp18_;
		xmlNode* _tmp19_;
#line 94 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp1_ = metadataChild;
#line 94 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		if (!(_tmp1_ != NULL)) {
#line 94 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			break;
#line 507 "gpx-parser-xml.c"
		}
#line 102 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp2_ = metadataChild;
#line 102 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp3_ = _tmp2_->name;
#line 102 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		if (g_strcmp0 (_tmp3_, "name") == 0) {
#line 515 "gpx-parser-xml.c"
			xmlNode* _tmp4_;
			gchar* _tmp5_;
#line 103 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			_tmp4_ = metadataChild;
#line 103 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			_tmp5_ = (gchar*) xmlNodeGetContent (_tmp4_);
#line 103 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			_g_free0 (((GpxFileBase*) self)->name);
#line 103 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			((GpxFileBase*) self)->name = _tmp5_;
#line 526 "gpx-parser-xml.c"
		}
#line 104 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp6_ = metadataChild;
#line 104 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp7_ = _tmp6_->name;
#line 104 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		if (g_strcmp0 (_tmp7_, "desc") == 0) {
#line 534 "gpx-parser-xml.c"
			xmlNode* _tmp8_;
			gchar* _tmp9_;
#line 105 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			_tmp8_ = metadataChild;
#line 105 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			_tmp9_ = (gchar*) xmlNodeGetContent (_tmp8_);
#line 105 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			_g_free0 (((GpxFileBase*) self)->description);
#line 105 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			((GpxFileBase*) self)->description = _tmp9_;
#line 545 "gpx-parser-xml.c"
		}
#line 106 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp10_ = metadataChild;
#line 106 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp11_ = _tmp10_->name;
#line 106 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		if (g_strcmp0 (_tmp11_, "time") == 0) {
#line 553 "gpx-parser-xml.c"
			xmlNode* _tmp12_;
			gchar* _tmp13_;
#line 107 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			_tmp12_ = metadataChild;
#line 107 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			_tmp13_ = (gchar*) xmlNodeGetContent (_tmp12_);
#line 107 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			_g_free0 (((GpxFileBase*) self)->time);
#line 107 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			((GpxFileBase*) self)->time = _tmp13_;
#line 564 "gpx-parser-xml.c"
		}
#line 108 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp14_ = metadataChild;
#line 108 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp15_ = _tmp14_->name;
#line 108 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		if (g_strcmp0 (_tmp15_, "keywords") == 0) {
#line 572 "gpx-parser-xml.c"
			xmlNode* _tmp16_;
			gchar* _tmp17_;
#line 109 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			_tmp16_ = metadataChild;
#line 109 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			_tmp17_ = (gchar*) xmlNodeGetContent (_tmp16_);
#line 109 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			_g_free0 (((GpxFileBase*) self)->keywords);
#line 109 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			((GpxFileBase*) self)->keywords = _tmp17_;
#line 583 "gpx-parser-xml.c"
		}
#line 110 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp18_ = metadataChild;
#line 110 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp19_ = _tmp18_->next;
#line 110 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		metadataChild = _tmp19_;
#line 591 "gpx-parser-xml.c"
	}
}

static GpxTrack*
gpx_xml_file_parse_track (GpxXmlFile* self,
                          xmlNode* trk)
{
	GpxTrack* track = NULL;
	GpxTrack* _tmp0_;
	xmlNode* trkChild = NULL;
	xmlNode* _tmp1_;
	GpxTrack* result;
#line 117 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	_tmp0_ = gpx_track_new ();
#line 117 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	track = _tmp0_;
#line 119 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	_tmp1_ = trk->children;
#line 119 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	trkChild = _tmp1_;
#line 121 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	while (TRUE) {
#line 614 "gpx-parser-xml.c"
		xmlNode* _tmp2_;
		xmlNode* _tmp3_;
		const gchar* _tmp4_;
		xmlNode* _tmp56_;
		xmlNode* _tmp57_;
#line 121 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp2_ = trkChild;
#line 121 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		if (!(_tmp2_ != NULL)) {
#line 121 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			break;
#line 626 "gpx-parser-xml.c"
		}
#line 123 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp3_ = trkChild;
#line 123 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp4_ = _tmp3_->name;
#line 123 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		if (g_strcmp0 (_tmp4_, "trkseg") == 0) {
#line 634 "gpx-parser-xml.c"
			xmlNode* point = NULL;
			xmlNode* _tmp5_;
			xmlNode* _tmp6_;
#line 125 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			_tmp5_ = trkChild;
#line 125 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			_tmp6_ = _tmp5_->children;
#line 125 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			point = _tmp6_;
#line 126 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			while (TRUE) {
#line 646 "gpx-parser-xml.c"
				xmlNode* _tmp7_;
				xmlNode* _tmp8_;
				const gchar* _tmp9_;
				xmlNode* _tmp17_;
				xmlNode* _tmp18_;
#line 126 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				_tmp7_ = point;
#line 126 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				if (!(_tmp7_ != NULL)) {
#line 126 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					break;
#line 658 "gpx-parser-xml.c"
				}
#line 128 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				_tmp8_ = point;
#line 128 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				_tmp9_ = _tmp8_->name;
#line 128 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				if (g_strcmp0 (_tmp9_, "trkpt") == 0) {
#line 666 "gpx-parser-xml.c"
					GpxPoint* p = NULL;
					xmlNode* _tmp10_;
					GpxPoint* _tmp11_;
					GpxPoint* _tmp12_;
#line 130 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_tmp10_ = point;
#line 130 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_tmp11_ = gpx_xml_file_parse_point (self, _tmp10_);
#line 130 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					p = _tmp11_;
#line 131 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_tmp12_ = p;
#line 131 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					if (_tmp12_ != NULL) {
#line 681 "gpx-parser-xml.c"
						GpxTrack* _tmp13_;
						GpxPoint* _tmp14_;
#line 132 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						_tmp13_ = track;
#line 132 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						_tmp14_ = p;
#line 132 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						gpx_track_add_point (_tmp13_, _tmp14_);
#line 690 "gpx-parser-xml.c"
					} else {
						xmlNode* _tmp15_;
						const gchar* _tmp16_;
#line 136 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						_tmp15_ = point;
#line 136 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						_tmp16_ = _tmp15_->name;
#line 136 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						g_message ("gpx-parser-xml.vala:136: Failed to get point: %s\n", _tmp16_);
#line 700 "gpx-parser-xml.c"
					}
#line 128 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_gpx_point_unref0 (p);
#line 704 "gpx-parser-xml.c"
				}
#line 139 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				_tmp17_ = point;
#line 139 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				_tmp18_ = _tmp17_->next;
#line 139 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				point = _tmp18_;
#line 712 "gpx-parser-xml.c"
			}
		} else {
			xmlNode* _tmp19_;
			const gchar* _tmp20_;
#line 142 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			_tmp19_ = trkChild;
#line 142 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			_tmp20_ = _tmp19_->name;
#line 142 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			if (g_strcmp0 (_tmp20_, "name") == 0) {
#line 723 "gpx-parser-xml.c"
				GpxTrack* _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
#line 144 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				_tmp21_ = track;
#line 144 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				_tmp22_ = gpx_track_get_name (_tmp21_);
#line 144 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				_tmp23_ = _tmp22_;
#line 144 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				if (_tmp23_ == NULL) {
#line 735 "gpx-parser-xml.c"
					GpxTrack* _tmp24_;
					xmlNode* _tmp25_;
					gchar* _tmp26_;
					gchar* _tmp27_;
#line 146 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_tmp24_ = track;
#line 146 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_tmp25_ = trkChild;
#line 146 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_tmp26_ = (gchar*) xmlNodeGetContent (_tmp25_);
#line 146 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_tmp27_ = _tmp26_;
#line 146 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					gpx_track_set_name (_tmp24_, _tmp27_);
#line 146 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_g_free0 (_tmp27_);
#line 752 "gpx-parser-xml.c"
				} else {
					GpxTrack* _tmp28_;
					const gchar* _tmp29_;
					const gchar* _tmp30_;
#line 150 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_tmp28_ = track;
#line 150 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_tmp29_ = gpx_track_get_name (_tmp28_);
#line 150 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_tmp30_ = _tmp29_;
#line 150 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					g_warning ("gpx-parser-xml.vala:150: Track name allready set: %s\n", _tmp30_);
#line 765 "gpx-parser-xml.c"
				}
			} else {
				xmlNode* _tmp31_;
				const gchar* _tmp32_;
#line 153 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				_tmp31_ = trkChild;
#line 153 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				_tmp32_ = _tmp31_->name;
#line 153 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				if (g_strcmp0 (_tmp32_, "type") == 0) {
#line 776 "gpx-parser-xml.c"
					GpxTrack* _tmp33_;
					const gchar* _tmp34_;
					const gchar* _tmp35_;
#line 155 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_tmp33_ = track;
#line 155 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_tmp34_ = gpx_track_get_track_type (_tmp33_);
#line 155 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_tmp35_ = _tmp34_;
#line 155 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					if (_tmp35_ == NULL) {
#line 788 "gpx-parser-xml.c"
						GpxTrack* _tmp36_;
						xmlNode* _tmp37_;
						gchar* _tmp38_;
						gchar* _tmp39_;
#line 157 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						_tmp36_ = track;
#line 157 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						_tmp37_ = trkChild;
#line 157 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						_tmp38_ = (gchar*) xmlNodeGetContent (_tmp37_);
#line 157 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						_tmp39_ = _tmp38_;
#line 157 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						gpx_track_set_track_type (_tmp36_, _tmp39_);
#line 157 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						_g_free0 (_tmp39_);
#line 805 "gpx-parser-xml.c"
					} else {
						GpxTrack* _tmp40_;
						const gchar* _tmp41_;
						const gchar* _tmp42_;
#line 161 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						_tmp40_ = track;
#line 161 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						_tmp41_ = gpx_track_get_track_type (_tmp40_);
#line 161 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						_tmp42_ = _tmp41_;
#line 161 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						g_warning ("gpx-parser-xml.vala:161: Track type allready set: %s\n", _tmp42_);
#line 818 "gpx-parser-xml.c"
					}
				} else {
					xmlNode* _tmp43_;
					const gchar* _tmp44_;
#line 164 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_tmp43_ = trkChild;
#line 164 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_tmp44_ = _tmp43_->name;
#line 164 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					if (g_strcmp0 (_tmp44_, "number") == 0) {
#line 829 "gpx-parser-xml.c"
						GpxTrack* _tmp45_;
						gint* _tmp46_;
						gint* _tmp47_;
#line 166 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						_tmp45_ = track;
#line 166 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						_tmp46_ = gpx_track_get_number (_tmp45_);
#line 166 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						_tmp47_ = _tmp46_;
#line 166 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						if (_tmp47_ == NULL) {
#line 841 "gpx-parser-xml.c"
							GpxTrack* _tmp48_;
							xmlNode* _tmp49_;
							gchar* _tmp50_;
							gchar* _tmp51_;
							gint _tmp52_;
#line 168 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
							_tmp48_ = track;
#line 168 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
							_tmp49_ = trkChild;
#line 168 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
							_tmp50_ = (gchar*) xmlNodeGetContent (_tmp49_);
#line 168 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
							_tmp51_ = _tmp50_;
#line 168 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
							_tmp52_ = atoi (_tmp51_);
#line 168 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
							gpx_track_set_number (_tmp48_, &_tmp52_);
#line 168 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
							_g_free0 (_tmp51_);
#line 861 "gpx-parser-xml.c"
						} else {
							GpxTrack* _tmp53_;
							gint* _tmp54_;
							gint* _tmp55_;
#line 172 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
							_tmp53_ = track;
#line 172 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
							_tmp54_ = gpx_track_get_number (_tmp53_);
#line 172 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
							_tmp55_ = _tmp54_;
#line 172 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
							g_warning ("gpx-parser-xml.vala:172: Track number allready set: %d\n", *_tmp55_);
#line 874 "gpx-parser-xml.c"
						}
					}
				}
			}
		}
#line 176 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp56_ = trkChild;
#line 176 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp57_ = _tmp56_->next;
#line 176 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		trkChild = _tmp57_;
#line 886 "gpx-parser-xml.c"
	}
#line 178 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	result = track;
#line 178 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	return result;
#line 892 "gpx-parser-xml.c"
}

static gpointer
_gpx_point_ref0 (gpointer self)
{
#line 185 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	return self ? gpx_point_ref (self) : NULL;
#line 900 "gpx-parser-xml.c"
}

static void
gpx_xml_file_parse_waypoint (GpxXmlFile* self,
                             xmlNode* node)
{
	GpxPoint* p = NULL;
	GpxPoint* _tmp0_;
	GpxPoint* _tmp1_;
#line 183 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	_tmp0_ = gpx_xml_file_parse_point (self, node);
#line 183 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	p = _tmp0_;
#line 184 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	_tmp1_ = p;
#line 184 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	if (_tmp1_ != NULL) {
#line 918 "gpx-parser-xml.c"
		GpxPoint* _tmp2_;
		GpxPoint* _tmp3_;
#line 185 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp2_ = p;
#line 185 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp3_ = _gpx_point_ref0 (_tmp2_);
#line 185 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		((GpxFileBase*) self)->waypoints = g_list_append (((GpxFileBase*) self)->waypoints, _tmp3_);
#line 927 "gpx-parser-xml.c"
	}
#line 181 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	_gpx_point_unref0 (p);
#line 931 "gpx-parser-xml.c"
}

static GpxTrack*
gpx_xml_file_parse_route (GpxXmlFile* self,
                          xmlNode* node)
{
	GpxTrack* track = NULL;
	GpxTrack* _tmp0_;
	GpxTrack* _tmp1_;
	xmlNode* trkseg = NULL;
	xmlNode* _tmp2_;
	GpxTrack* result;
#line 192 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	_tmp0_ = gpx_track_new ();
#line 192 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	track = _tmp0_;
#line 193 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	_tmp1_ = track;
#line 193 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	gpx_track_set_is_route (_tmp1_, TRUE);
#line 195 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	_tmp2_ = node->children;
#line 195 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	trkseg = _tmp2_;
#line 197 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	while (TRUE) {
#line 958 "gpx-parser-xml.c"
		xmlNode* _tmp3_;
		xmlNode* _tmp4_;
		const gchar* _tmp5_;
		xmlNode* _tmp50_;
		xmlNode* _tmp51_;
#line 197 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp3_ = trkseg;
#line 197 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		if (!(_tmp3_ != NULL)) {
#line 197 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			break;
#line 970 "gpx-parser-xml.c"
		}
#line 199 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp4_ = trkseg;
#line 199 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp5_ = _tmp4_->name;
#line 199 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		if (g_strcmp0 (_tmp5_, "rtept") == 0) {
#line 978 "gpx-parser-xml.c"
			GpxPoint* p = NULL;
			xmlNode* _tmp6_;
			GpxPoint* _tmp7_;
			GpxPoint* _tmp8_;
#line 201 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			_tmp6_ = trkseg;
#line 201 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			_tmp7_ = gpx_xml_file_parse_point (self, _tmp6_);
#line 201 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			p = _tmp7_;
#line 202 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			_tmp8_ = p;
#line 202 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			if (_tmp8_ != NULL) {
#line 993 "gpx-parser-xml.c"
				GpxTrack* _tmp9_;
				GpxPoint* _tmp10_;
#line 203 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				_tmp9_ = track;
#line 203 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				_tmp10_ = p;
#line 203 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				gpx_track_add_point (_tmp9_, _tmp10_);
#line 1002 "gpx-parser-xml.c"
			} else {
				xmlNode* _tmp11_;
				const gchar* _tmp12_;
#line 207 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				_tmp11_ = trkseg;
#line 207 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				_tmp12_ = _tmp11_->name;
#line 207 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				g_message ("gpx-parser-xml.vala:207: Failed to get rtept: %s\n", _tmp12_);
#line 1012 "gpx-parser-xml.c"
			}
#line 199 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			_gpx_point_unref0 (p);
#line 1016 "gpx-parser-xml.c"
		} else {
			xmlNode* _tmp13_;
			const gchar* _tmp14_;
#line 210 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			_tmp13_ = trkseg;
#line 210 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			_tmp14_ = _tmp13_->name;
#line 210 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			if (g_strcmp0 (_tmp14_, "name") == 0) {
#line 1026 "gpx-parser-xml.c"
				GpxTrack* _tmp15_;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
#line 212 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				_tmp15_ = track;
#line 212 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				_tmp16_ = gpx_track_get_name (_tmp15_);
#line 212 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				_tmp17_ = _tmp16_;
#line 212 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				if (_tmp17_ == NULL) {
#line 1038 "gpx-parser-xml.c"
					GpxTrack* _tmp18_;
					xmlNode* _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
#line 214 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_tmp18_ = track;
#line 214 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_tmp19_ = trkseg;
#line 214 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_tmp20_ = (gchar*) xmlNodeGetContent (_tmp19_);
#line 214 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_tmp21_ = _tmp20_;
#line 214 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					gpx_track_set_name (_tmp18_, _tmp21_);
#line 214 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_g_free0 (_tmp21_);
#line 1055 "gpx-parser-xml.c"
				} else {
					GpxTrack* _tmp22_;
					const gchar* _tmp23_;
					const gchar* _tmp24_;
#line 218 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_tmp22_ = track;
#line 218 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_tmp23_ = gpx_track_get_name (_tmp22_);
#line 218 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_tmp24_ = _tmp23_;
#line 218 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					g_warning ("gpx-parser-xml.vala:218: Track name allready set: %s\n", _tmp24_);
#line 1068 "gpx-parser-xml.c"
				}
			} else {
				xmlNode* _tmp25_;
				const gchar* _tmp26_;
#line 221 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				_tmp25_ = trkseg;
#line 221 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				_tmp26_ = _tmp25_->name;
#line 221 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				if (g_strcmp0 (_tmp26_, "type") == 0) {
#line 1079 "gpx-parser-xml.c"
					GpxTrack* _tmp27_;
					const gchar* _tmp28_;
					const gchar* _tmp29_;
#line 223 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_tmp27_ = track;
#line 223 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_tmp28_ = gpx_track_get_track_type (_tmp27_);
#line 223 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_tmp29_ = _tmp28_;
#line 223 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					if (_tmp29_ == NULL) {
#line 1091 "gpx-parser-xml.c"
						GpxTrack* _tmp30_;
						xmlNode* _tmp31_;
						gchar* _tmp32_;
						gchar* _tmp33_;
#line 225 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						_tmp30_ = track;
#line 225 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						_tmp31_ = trkseg;
#line 225 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						_tmp32_ = (gchar*) xmlNodeGetContent (_tmp31_);
#line 225 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						_tmp33_ = _tmp32_;
#line 225 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						gpx_track_set_track_type (_tmp30_, _tmp33_);
#line 225 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						_g_free0 (_tmp33_);
#line 1108 "gpx-parser-xml.c"
					} else {
						GpxTrack* _tmp34_;
						const gchar* _tmp35_;
						const gchar* _tmp36_;
#line 229 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						_tmp34_ = track;
#line 229 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						_tmp35_ = gpx_track_get_track_type (_tmp34_);
#line 229 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						_tmp36_ = _tmp35_;
#line 229 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						g_warning ("gpx-parser-xml.vala:229: Track type allready set: %s\n", _tmp36_);
#line 1121 "gpx-parser-xml.c"
					}
				} else {
					xmlNode* _tmp37_;
					const gchar* _tmp38_;
#line 232 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_tmp37_ = trkseg;
#line 232 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_tmp38_ = _tmp37_->name;
#line 232 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					if (g_strcmp0 (_tmp38_, "number") == 0) {
#line 1132 "gpx-parser-xml.c"
						GpxTrack* _tmp39_;
						gint* _tmp40_;
						gint* _tmp41_;
#line 234 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						_tmp39_ = track;
#line 234 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						_tmp40_ = gpx_track_get_number (_tmp39_);
#line 234 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						_tmp41_ = _tmp40_;
#line 234 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						if (_tmp41_ == NULL) {
#line 1144 "gpx-parser-xml.c"
							GpxTrack* _tmp42_;
							xmlNode* _tmp43_;
							gchar* _tmp44_;
							gchar* _tmp45_;
							gint _tmp46_;
#line 236 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
							_tmp42_ = track;
#line 236 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
							_tmp43_ = trkseg;
#line 236 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
							_tmp44_ = (gchar*) xmlNodeGetContent (_tmp43_);
#line 236 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
							_tmp45_ = _tmp44_;
#line 236 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
							_tmp46_ = atoi (_tmp45_);
#line 236 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
							gpx_track_set_number (_tmp42_, &_tmp46_);
#line 236 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
							_g_free0 (_tmp45_);
#line 1164 "gpx-parser-xml.c"
						} else {
							GpxTrack* _tmp47_;
							gint* _tmp48_;
							gint* _tmp49_;
#line 240 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
							_tmp47_ = track;
#line 240 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
							_tmp48_ = gpx_track_get_number (_tmp47_);
#line 240 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
							_tmp49_ = _tmp48_;
#line 240 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
							g_warning ("gpx-parser-xml.vala:240: Track number allready set: %d\n", *_tmp49_);
#line 1177 "gpx-parser-xml.c"
						}
					}
				}
			}
		}
#line 243 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp50_ = trkseg;
#line 243 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp51_ = _tmp50_->next;
#line 243 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		trkseg = _tmp51_;
#line 1189 "gpx-parser-xml.c"
	}
#line 245 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	result = track;
#line 245 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	return result;
#line 1195 "gpx-parser-xml.c"
}

/**
         * Parse a file
         */
static gint
gpx_xml_file_read_file (GpxXmlFile* self,
                        guint8* buffer,
                        gint buffer_length1)
{
	gint _tmp3_ = -1;
	GError* _inner_error0_ = NULL;
	gint result;
	{
		gssize value = 0L;
		GFileInputStream* _tmp0_;
#line 255 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp0_ = self->priv->stream;
#line 255 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		value = g_input_stream_read ((GInputStream*) _tmp0_, buffer, (gsize) buffer_length1, NULL, &_inner_error0_);
#line 255 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1218 "gpx-parser-xml.c"
			goto __catch0_g_error;
		}
#line 256 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		result = (gint) value;
#line 256 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		return result;
#line 1225 "gpx-parser-xml.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
#line 253 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		e = _inner_error0_;
#line 253 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_inner_error0_ = NULL;
#line 260 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp1_ = e;
#line 260 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp2_ = _tmp1_->message;
#line 260 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		g_critical ("gpx-parser-xml.vala:260: error reading from stream: %s\n", _tmp2_);
#line 261 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		result = -1;
#line 261 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_g_error_free0 (e);
#line 261 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		return result;
#line 1249 "gpx-parser-xml.c"
	}
	__finally0:
#line 253 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 253 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	g_clear_error (&_inner_error0_);
#line 253 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	return _tmp3_;
#line 1258 "gpx-parser-xml.c"
}

static gint
gpx_xml_file_close_file (GpxXmlFile* self)
{
	gint result;
#line 266 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	g_log ("GPX PARSER", G_LOG_LEVEL_DEBUG, "gpx-parser-xml.vala:266: Close_file()");
#line 267 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	_g_object_unref0 (self->priv->stream);
#line 267 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	self->priv->stream = NULL;
#line 268 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	result = 0;
#line 268 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	return result;
#line 1275 "gpx-parser-xml.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 273 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	return self ? g_object_ref (self) : NULL;
#line 1283 "gpx-parser-xml.c"
}

GpxXmlFile*
gpx_xml_file_construct (GType object_type,
                        GFile* file)
{
	GpxXmlFile * self = NULL;
	GFile* _tmp0_;
	GError* _inner_error0_ = NULL;
#line 271 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	self = (GpxXmlFile*) gpx_file_base_construct (object_type);
#line 273 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	_tmp0_ = _g_object_ref0 (file);
#line 273 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	_g_object_unref0 (((GpxFileBase*) self)->file);
#line 273 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	((GpxFileBase*) self)->file = _tmp0_;
#line 1301 "gpx-parser-xml.c"
	{
		GFileInputStream* _tmp1_ = NULL;
		GFileInputStream* _tmp2_;
		GFileInputStream* _tmp3_;
		xmlTextReader* reader = NULL;
		GFile* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		xmlTextReader* _tmp7_;
		xmlTextReader* _tmp8_;
		xmlTextReader* _tmp9_;
		xmlTextReader* _tmp48_;
#line 276 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp2_ = g_file_read (file, NULL, &_inner_error0_);
#line 276 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp1_ = _tmp2_;
#line 276 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1320 "gpx-parser-xml.c"
			goto __catch0_g_error;
		}
#line 276 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp3_ = _tmp1_;
#line 276 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp1_ = NULL;
#line 276 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_g_object_unref0 (self->priv->stream);
#line 276 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		self->priv->stream = _tmp3_;
#line 277 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp4_ = ((GpxFileBase*) self)->file;
#line 277 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp5_ = g_file_get_uri (_tmp4_);
#line 277 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp6_ = _tmp5_;
#line 277 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp7_ = xmlReaderForIO ((xmlInputReadCallback) gpx_xml_file_read_file, (xmlInputCloseCallback) gpx_xml_file_close_file, self, _tmp6_, "", 0);
#line 277 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp8_ = _tmp7_;
#line 277 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_g_free0 (_tmp6_);
#line 277 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		reader = _tmp8_;
#line 281 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp9_ = reader;
#line 281 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		if (_tmp9_ != NULL) {
#line 1349 "gpx-parser-xml.c"
			gint doc = 0;
			xmlTextReader* _tmp10_;
#line 284 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			_tmp10_ = reader;
#line 284 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			doc = xmlTextReaderRead (_tmp10_);
#line 285 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			while (TRUE) {
#line 1358 "gpx-parser-xml.c"
				gchar* name = NULL;
				xmlTextReader* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				const gchar* _tmp14_;
#line 285 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				if (!(doc == 1)) {
#line 285 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					break;
#line 1368 "gpx-parser-xml.c"
				}
#line 287 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				_tmp11_ = reader;
#line 287 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				_tmp12_ = (const gchar*) xmlTextReaderConstName (_tmp11_);
#line 287 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				_tmp13_ = g_strdup (_tmp12_);
#line 287 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				name = _tmp13_;
#line 288 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				_tmp14_ = name;
#line 288 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				if (g_strcmp0 (_tmp14_, "gpx") == 0) {
#line 1382 "gpx-parser-xml.c"
					xmlNode* gpx = NULL;
					xmlTextReader* _tmp15_;
					xmlNode* _tmp16_;
					xmlNode* _tmp17_;
					gchar* _tmp18_;
					gint doc2 = 0;
					xmlTextReader* _tmp19_;
#line 290 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_tmp15_ = reader;
#line 290 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_tmp16_ = xmlTextReaderExpand (_tmp15_);
#line 290 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					gpx = _tmp16_;
#line 291 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_tmp17_ = gpx;
#line 291 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_tmp18_ = (gchar*) xmlGetProp (_tmp17_, (xmlChar*) "creator");
#line 291 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_g_free0 (((GpxFileBase*) self)->creator);
#line 291 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					((GpxFileBase*) self)->creator = _tmp18_;
#line 292 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_tmp19_ = reader;
#line 292 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					doc2 = xmlTextReaderRead (_tmp19_);
#line 293 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					while (TRUE) {
#line 1410 "gpx-parser-xml.c"
						gchar* name2 = NULL;
						xmlTextReader* _tmp20_;
						const gchar* _tmp21_;
						gchar* _tmp22_;
						const gchar* _tmp23_;
						xmlTextReader* _tmp46_;
#line 293 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						if (!(doc2 == 1)) {
#line 293 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
							break;
#line 1421 "gpx-parser-xml.c"
						}
#line 295 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						_tmp20_ = reader;
#line 295 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						_tmp21_ = (const gchar*) xmlTextReaderConstName (_tmp20_);
#line 295 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						_tmp22_ = g_strdup (_tmp21_);
#line 295 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						name2 = _tmp22_;
#line 297 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						_tmp23_ = name2;
#line 297 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						if (g_strcmp0 (_tmp23_, "metadata") == 0) {
#line 1435 "gpx-parser-xml.c"
							xmlNode* metadata = NULL;
							xmlTextReader* _tmp24_;
							xmlNode* _tmp25_;
							xmlNode* _tmp26_;
#line 299 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
							_tmp24_ = reader;
#line 299 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
							_tmp25_ = xmlTextReaderExpand (_tmp24_);
#line 299 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
							metadata = _tmp25_;
#line 300 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
							_tmp26_ = metadata;
#line 300 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
							gpx_xml_file_parse_metadata (self, _tmp26_);
#line 1450 "gpx-parser-xml.c"
						} else {
							const gchar* _tmp27_;
#line 302 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
							_tmp27_ = name2;
#line 302 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
							if (g_strcmp0 (_tmp27_, "trk") == 0) {
#line 1457 "gpx-parser-xml.c"
								xmlNode* trk = NULL;
								xmlTextReader* _tmp28_;
								xmlNode* _tmp29_;
								GpxTrack* track = NULL;
								xmlNode* _tmp30_;
								GpxTrack* _tmp31_;
								GpxTrack* _tmp32_;
								GpxTrack* _tmp33_;
								GpxTrack* _tmp34_;
#line 305 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
								_tmp28_ = reader;
#line 305 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
								_tmp29_ = xmlTextReaderExpand (_tmp28_);
#line 305 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
								trk = _tmp29_;
#line 306 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
								_tmp30_ = trk;
#line 306 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
								_tmp31_ = gpx_xml_file_parse_track (self, _tmp30_);
#line 306 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
								track = _tmp31_;
#line 307 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
								_tmp32_ = track;
#line 307 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
								gpx_track_filter_points (_tmp32_);
#line 308 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
								_tmp33_ = track;
#line 308 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
								_tmp34_ = _g_object_ref0 (_tmp33_);
#line 308 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
								((GpxFileBase*) self)->tracks = g_list_append (((GpxFileBase*) self)->tracks, _tmp34_);
#line 302 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
								_g_object_unref0 (track);
#line 1491 "gpx-parser-xml.c"
							} else {
								const gchar* _tmp35_;
#line 310 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
								_tmp35_ = name2;
#line 310 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
								if (g_strcmp0 (_tmp35_, "wpt") == 0) {
#line 1498 "gpx-parser-xml.c"
									xmlNode* node = NULL;
									xmlTextReader* _tmp36_;
									xmlNode* _tmp37_;
									xmlNode* _tmp38_;
#line 313 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
									_tmp36_ = reader;
#line 313 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
									_tmp37_ = xmlTextReaderExpand (_tmp36_);
#line 313 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
									node = _tmp37_;
#line 314 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
									_tmp38_ = node;
#line 314 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
									gpx_xml_file_parse_waypoint (self, _tmp38_);
#line 1513 "gpx-parser-xml.c"
								} else {
									const gchar* _tmp39_;
#line 316 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
									_tmp39_ = name2;
#line 316 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
									if (g_strcmp0 (_tmp39_, "rte") == 0) {
#line 1520 "gpx-parser-xml.c"
										xmlNode* node = NULL;
										xmlTextReader* _tmp40_;
										xmlNode* _tmp41_;
										GpxTrack* track = NULL;
										xmlNode* _tmp42_;
										GpxTrack* _tmp43_;
										GpxTrack* _tmp44_;
										GpxTrack* _tmp45_;
#line 318 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
										_tmp40_ = reader;
#line 318 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
										_tmp41_ = xmlTextReaderExpand (_tmp40_);
#line 318 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
										node = _tmp41_;
#line 320 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
										_tmp42_ = node;
#line 320 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
										_tmp43_ = gpx_xml_file_parse_route (self, _tmp42_);
#line 320 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
										track = _tmp43_;
#line 321 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
										_tmp44_ = track;
#line 321 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
										_tmp45_ = _g_object_ref0 (_tmp44_);
#line 321 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
										((GpxFileBase*) self)->routes = g_list_append (((GpxFileBase*) self)->routes, _tmp45_);
#line 316 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
										_g_object_unref0 (track);
#line 1549 "gpx-parser-xml.c"
									}
								}
							}
						}
#line 323 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						_tmp46_ = reader;
#line 323 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						doc2 = xmlTextReaderNext (_tmp46_);
#line 293 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
						_g_free0 (name2);
#line 1560 "gpx-parser-xml.c"
					}
				} else {
					xmlTextReader* _tmp47_;
#line 327 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					_tmp47_ = reader;
#line 327 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
					doc = xmlTextReaderRead (_tmp47_);
#line 1568 "gpx-parser-xml.c"
				}
#line 285 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
				_g_free0 (name);
#line 1572 "gpx-parser-xml.c"
			}
		} else {
#line 334 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
			g_message ("gpx-parser-xml.vala:334: Failed to open file");
#line 1577 "gpx-parser-xml.c"
		}
#line 336 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp48_ = reader;
#line 336 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		xmlTextReaderClose (_tmp48_);
#line 274 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_xmlFreeTextReader0 (reader);
#line 274 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_g_object_unref0 (_tmp1_);
#line 1587 "gpx-parser-xml.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GFile* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		GError* _tmp52_;
		const gchar* _tmp53_;
#line 274 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		e = _inner_error0_;
#line 274 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_inner_error0_ = NULL;
#line 340 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp49_ = ((GpxFileBase*) self)->file;
#line 340 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp50_ = g_file_get_uri (_tmp49_);
#line 340 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp51_ = _tmp50_;
#line 340 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp52_ = e;
#line 340 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_tmp53_ = _tmp52_->message;
#line 340 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		g_critical ("gpx-parser-xml.vala:340: failed to open file: '%s' error: %s", _tmp51_, _tmp53_);
#line 340 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_g_free0 (_tmp51_);
#line 274 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		_g_error_free0 (e);
#line 1618 "gpx-parser-xml.c"
	}
	__finally0:
#line 274 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 274 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 274 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		g_clear_error (&_inner_error0_);
#line 274 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
		return NULL;
#line 1629 "gpx-parser-xml.c"
	}
#line 271 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	return self;
#line 1633 "gpx-parser-xml.c"
}

GpxXmlFile*
gpx_xml_file_new (GFile* file)
{
#line 271 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	return gpx_xml_file_construct (GPX_TYPE_XML_FILE, file);
#line 1641 "gpx-parser-xml.c"
}

static void
gpx_xml_file_class_init (GpxXmlFileClass * klass,
                         gpointer klass_data)
{
#line 22 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	gpx_xml_file_parent_class = g_type_class_peek_parent (klass);
#line 22 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	g_type_class_adjust_private_offset (klass, &GpxXmlFile_private_offset);
#line 22 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	G_OBJECT_CLASS (klass)->finalize = gpx_xml_file_finalize;
#line 1654 "gpx-parser-xml.c"
}

static void
gpx_xml_file_instance_init (GpxXmlFile * self,
                            gpointer klass)
{
#line 22 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	self->priv = gpx_xml_file_get_instance_private (self);
#line 27 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	self->priv->stream = NULL;
#line 1665 "gpx-parser-xml.c"
}

static void
gpx_xml_file_finalize (GObject * obj)
{
	GpxXmlFile * self;
#line 22 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GPX_TYPE_XML_FILE, GpxXmlFile);
#line 27 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	_g_object_unref0 (self->priv->stream);
#line 22 "../gpx-viewer/libgpx/gpx-parser-xml.vala"
	G_OBJECT_CLASS (gpx_xml_file_parent_class)->finalize (obj);
#line 1678 "gpx-parser-xml.c"
}

static GType
gpx_xml_file_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GpxXmlFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gpx_xml_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GpxXmlFile), 0, (GInstanceInitFunc) gpx_xml_file_instance_init, NULL };
	GType gpx_xml_file_type_id;
	gpx_xml_file_type_id = g_type_register_static (GPX_TYPE_FILE_BASE, "GpxXmlFile", &g_define_type_info, 0);
	GpxXmlFile_private_offset = g_type_add_instance_private (gpx_xml_file_type_id, sizeof (GpxXmlFilePrivate));
	return gpx_xml_file_type_id;
}

GType
gpx_xml_file_get_type (void)
{
	static volatile gsize gpx_xml_file_type_id__once = 0;
	if (g_once_init_enter (&gpx_xml_file_type_id__once)) {
		GType gpx_xml_file_type_id;
		gpx_xml_file_type_id = gpx_xml_file_get_type_once ();
		g_once_init_leave (&gpx_xml_file_type_id__once, gpx_xml_file_type_id);
	}
	return gpx_xml_file_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

