/* Toast.c generated by valac 0.56.17, the Vala compiler
 * generated from Toast.vala, do not modify */

/*-
 * Copyright 2016-2017 elementary, Inc. (https://elementary.io)
 * Copyright 2016-2017 Artem Anufrij <artem.anufrij@live.de>
 * Copyright 2016-2017 Daniel Foré <daniel@elementary.io>
 * SPDX-License-Identifier: LGPL-3.0-or-later
 */

#include "granite.h"
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GRANITE_WIDGETS_TOAST_0_PROPERTY,
	GRANITE_WIDGETS_TOAST_TITLE_PROPERTY,
	GRANITE_WIDGETS_TOAST_NUM_PROPERTIES
};
static GParamSpec* granite_widgets_toast_properties[GRANITE_WIDGETS_TOAST_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	GRANITE_WIDGETS_TOAST_CLOSED_SIGNAL,
	GRANITE_WIDGETS_TOAST_DEFAULT_ACTION_SIGNAL,
	GRANITE_WIDGETS_TOAST_NUM_SIGNALS
};
static guint granite_widgets_toast_signals[GRANITE_WIDGETS_TOAST_NUM_SIGNALS] = {0};

struct _GraniteWidgetsToastPrivate {
	GtkLabel* notification_label;
	GtkButton* default_action_button;
	gchar* _title;
	guint timeout_id;
};

static gint GraniteWidgetsToast_private_offset;
static gpointer granite_widgets_toast_parent_class = NULL;

static void granite_widgets_toast_start_timeout (GraniteWidgetsToast* self);
static gboolean __lambda93_ (GraniteWidgetsToast* self);
static gboolean ___lambda93__gsource_func (gpointer self);
static void granite_widgets_toast_stop_timeout (GraniteWidgetsToast* self);
static GObject * granite_widgets_toast_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static void _granite_widgets_toast___lambda94_ (GraniteWidgetsToast* self);
static void __granite_widgets_toast___lambda94__gtk_button_clicked (GtkButton* _sender,
                                                             gpointer self);
static void _granite_widgets_toast___lambda95_ (GraniteWidgetsToast* self);
static void __granite_widgets_toast___lambda95__gtk_button_clicked (GtkButton* _sender,
                                                             gpointer self);
static gboolean _granite_widgets_toast___lambda96_ (GraniteWidgetsToast* self);
static gboolean __granite_widgets_toast___lambda96__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                                            GdkEventCrossing* event,
                                                                            gpointer self);
static gboolean _granite_widgets_toast___lambda97_ (GraniteWidgetsToast* self);
static gboolean __granite_widgets_toast___lambda97__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                                            GdkEventCrossing* event,
                                                                            gpointer self);
static void granite_widgets_toast_finalize (GObject * obj);
static GType granite_widgets_toast_get_type_once (void);
static void _vala_granite_widgets_toast_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_granite_widgets_toast_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
granite_widgets_toast_get_instance_private (GraniteWidgetsToast* self)
{
	return G_STRUCT_MEMBER_P (self, GraniteWidgetsToast_private_offset);
}

const gchar*
granite_widgets_toast_get_title (GraniteWidgetsToast* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}

void
granite_widgets_toast_set_title (GraniteWidgetsToast* self,
                                 const gchar* value)
{
	GtkLabel* _tmp0_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notification_label;
	if (_tmp0_ != NULL) {
		GtkLabel* _tmp1_;
		_tmp1_ = self->priv->notification_label;
		gtk_label_set_label (_tmp1_, value);
	}
	_tmp2_ = g_strdup (value);
	_g_free0 (self->priv->_title);
	self->priv->_title = _tmp2_;
	g_object_notify_by_pspec ((GObject *) self, granite_widgets_toast_properties[GRANITE_WIDGETS_TOAST_TITLE_PROPERTY]);
}

/**
         * Creates a new Toast with #title as its title
         */
GraniteWidgetsToast*
granite_widgets_toast_construct (GType object_type,
                                 const gchar* title)
{
	GraniteWidgetsToast * self = NULL;
	g_return_val_if_fail (title != NULL, NULL);
	self = (GraniteWidgetsToast*) g_object_new (object_type, "title", title, NULL);
	return self;
}

GraniteWidgetsToast*
granite_widgets_toast_new (const gchar* title)
{
	return granite_widgets_toast_construct (GRANITE_WIDGETS_TYPE_TOAST, title);
}

static gboolean
__lambda93_ (GraniteWidgetsToast* self)
{
	gboolean result;
	gtk_revealer_set_reveal_child ((GtkRevealer*) self, FALSE);
	self->priv->timeout_id = (guint) 0;
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda93__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda93_ ((GraniteWidgetsToast*) self);
	return result;
}

static void
granite_widgets_toast_start_timeout (GraniteWidgetsToast* self)
{
	guint duration = 0U;
	GtkButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->default_action_button;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		duration = (guint) 3500;
	} else {
		duration = (guint) 2000;
	}
	self->priv->timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, duration, ___lambda93__gsource_func, g_object_ref (self), g_object_unref);
}

static void
granite_widgets_toast_stop_timeout (GraniteWidgetsToast* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->timeout_id != ((guint) 0)) {
		g_source_remove (self->priv->timeout_id);
		self->priv->timeout_id = (guint) 0;
	}
}

/**
         * Sets the default action button label of #this to #label and hides the
         * button if #label is #null.
         */
void
granite_widgets_toast_set_default_action (GraniteWidgetsToast* self,
                                          const gchar* label)
{
	gboolean _tmp0_ = FALSE;
	GtkButton* _tmp5_;
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (label, "") == 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = label == NULL;
	}
	if (_tmp0_) {
		GtkButton* _tmp1_;
		GtkButton* _tmp2_;
		_tmp1_ = self->priv->default_action_button;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp1_, TRUE);
		_tmp2_ = self->priv->default_action_button;
		gtk_widget_set_visible ((GtkWidget*) _tmp2_, FALSE);
	} else {
		GtkButton* _tmp3_;
		GtkButton* _tmp4_;
		_tmp3_ = self->priv->default_action_button;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp3_, FALSE);
		_tmp4_ = self->priv->default_action_button;
		gtk_widget_set_visible ((GtkWidget*) _tmp4_, TRUE);
	}
	_tmp5_ = self->priv->default_action_button;
	gtk_button_set_label (_tmp5_, label);
}

/**
         * Sends the Toast on behalf of #this
         */
void
granite_widgets_toast_send_notification (GraniteWidgetsToast* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_revealer_get_child_revealed ((GtkRevealer*) self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		gtk_revealer_set_reveal_child ((GtkRevealer*) self, TRUE);
	}
	granite_widgets_toast_stop_timeout (self);
	granite_widgets_toast_start_timeout (self);
}

static void
_granite_widgets_toast___lambda94_ (GraniteWidgetsToast* self)
{
	gtk_revealer_set_reveal_child ((GtkRevealer*) self, FALSE);
	granite_widgets_toast_stop_timeout (self);
	g_signal_emit (self, granite_widgets_toast_signals[GRANITE_WIDGETS_TOAST_DEFAULT_ACTION_SIGNAL], 0);
}

static void
__granite_widgets_toast___lambda94__gtk_button_clicked (GtkButton* _sender,
                                                        gpointer self)
{
	_granite_widgets_toast___lambda94_ ((GraniteWidgetsToast*) self);
}

static void
_granite_widgets_toast___lambda95_ (GraniteWidgetsToast* self)
{
	gtk_revealer_set_reveal_child ((GtkRevealer*) self, FALSE);
	granite_widgets_toast_stop_timeout (self);
	g_signal_emit (self, granite_widgets_toast_signals[GRANITE_WIDGETS_TOAST_CLOSED_SIGNAL], 0);
}

static void
__granite_widgets_toast___lambda95__gtk_button_clicked (GtkButton* _sender,
                                                        gpointer self)
{
	_granite_widgets_toast___lambda95_ ((GraniteWidgetsToast*) self);
}

static gboolean
_granite_widgets_toast___lambda96_ (GraniteWidgetsToast* self)
{
	granite_widgets_toast_stop_timeout (self);
}

static gboolean
__granite_widgets_toast___lambda96__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                                   GdkEventCrossing* event,
                                                                   gpointer self)
{
	gboolean result;
	result = _granite_widgets_toast___lambda96_ ((GraniteWidgetsToast*) self);
	return result;
}

static gboolean
_granite_widgets_toast___lambda97_ (GraniteWidgetsToast* self)
{
	granite_widgets_toast_start_timeout (self);
}

static gboolean
__granite_widgets_toast___lambda97__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                                   GdkEventCrossing* event,
                                                                   gpointer self)
{
	gboolean result;
	result = _granite_widgets_toast___lambda97_ ((GraniteWidgetsToast*) self);
	return result;
}

static GObject *
granite_widgets_toast_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GraniteWidgetsToast * self;
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_;
	GtkButton* _tmp3_;
	GtkButton* close_button = NULL;
	GtkButton* _tmp4_;
	GtkButton* _tmp5_;
	GtkStyleContext* _tmp6_;
	GtkButton* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	GtkLabel* _tmp10_;
	GtkGrid* notification_box = NULL;
	GtkGrid* _tmp11_;
	GtkGrid* _tmp12_;
	GtkGrid* _tmp13_;
	GtkButton* _tmp14_;
	GtkGrid* _tmp15_;
	GtkLabel* _tmp16_;
	GtkGrid* _tmp17_;
	GtkButton* _tmp18_;
	GtkEventBox* event_box = NULL;
	GtkEventBox* _tmp19_;
	GtkEventBox* _tmp20_;
	GtkEventBox* _tmp21_;
	GdkEventMask _tmp22_;
	GdkEventMask _tmp23_;
	GtkEventBox* _tmp24_;
	GtkEventBox* _tmp25_;
	GdkEventMask _tmp26_;
	GdkEventMask _tmp27_;
	GtkEventBox* _tmp28_;
	GtkGrid* _tmp29_;
	GtkEventBox* _tmp30_;
	GtkEventBox* _tmp31_;
	GtkFrame* notification_frame = NULL;
	GtkFrame* _tmp32_;
	GtkFrame* _tmp33_;
	GtkStyleContext* _tmp34_;
	GtkFrame* _tmp35_;
	GtkEventBox* _tmp36_;
	GtkFrame* _tmp37_;
	parent_class = G_OBJECT_CLASS (granite_widgets_toast_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_TYPE_TOAST, GraniteWidgetsToast);
	g_object_set ((GtkWidget*) self, "margin", 3, NULL);
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_START);
	_tmp0_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->default_action_button);
	self->priv->default_action_button = _tmp0_;
	_tmp1_ = self->priv->default_action_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, FALSE);
	_tmp2_ = self->priv->default_action_button;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp2_, TRUE);
	_tmp3_ = self->priv->default_action_button;
	g_signal_connect_object (_tmp3_, "clicked", (GCallback) __granite_widgets_toast___lambda94__gtk_button_clicked, self, 0);
	_tmp4_ = (GtkButton*) gtk_button_new_from_icon_name ("window-close-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp4_);
	close_button = _tmp4_;
	_tmp5_ = close_button;
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) _tmp5_);
	gtk_style_context_add_class (_tmp6_, "close-button");
	_tmp7_ = close_button;
	g_signal_connect_object (_tmp7_, "clicked", (GCallback) __granite_widgets_toast___lambda95__gtk_button_clicked, self, 0);
	_tmp8_ = granite_widgets_toast_get_title (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = (GtkLabel*) gtk_label_new (_tmp9_);
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->notification_label);
	self->priv->notification_label = _tmp10_;
	_tmp11_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp11_);
	notification_box = _tmp11_;
	_tmp12_ = notification_box;
	gtk_grid_set_column_spacing (_tmp12_, 12);
	_tmp13_ = notification_box;
	_tmp14_ = close_button;
	gtk_container_add ((GtkContainer*) _tmp13_, (GtkWidget*) _tmp14_);
	_tmp15_ = notification_box;
	_tmp16_ = self->priv->notification_label;
	gtk_container_add ((GtkContainer*) _tmp15_, (GtkWidget*) _tmp16_);
	_tmp17_ = notification_box;
	_tmp18_ = self->priv->default_action_button;
	gtk_container_add ((GtkContainer*) _tmp17_, (GtkWidget*) _tmp18_);
	_tmp19_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp19_);
	event_box = _tmp19_;
	_tmp20_ = event_box;
	_tmp21_ = event_box;
	_tmp22_ = gtk_widget_get_events ((GtkWidget*) _tmp21_);
	_tmp23_ = _tmp22_;
	gtk_widget_set_events ((GtkWidget*) _tmp21_, _tmp23_ | GDK_ENTER_NOTIFY_MASK);
	_tmp24_ = event_box;
	_tmp25_ = event_box;
	_tmp26_ = gtk_widget_get_events ((GtkWidget*) _tmp25_);
	_tmp27_ = _tmp26_;
	gtk_widget_set_events ((GtkWidget*) _tmp25_, _tmp27_ | GDK_LEAVE_NOTIFY_MASK);
	_tmp28_ = event_box;
	_tmp29_ = notification_box;
	gtk_container_add ((GtkContainer*) _tmp28_, (GtkWidget*) _tmp29_);
	_tmp30_ = event_box;
	g_signal_connect_object ((GtkWidget*) _tmp30_, "enter-notify-event", (GCallback) __granite_widgets_toast___lambda96__gtk_widget_enter_notify_event, self, 0);
	_tmp31_ = event_box;
	g_signal_connect_object ((GtkWidget*) _tmp31_, "leave-notify-event", (GCallback) __granite_widgets_toast___lambda97__gtk_widget_leave_notify_event, self, 0);
	_tmp32_ = (GtkFrame*) gtk_frame_new (NULL);
	g_object_ref_sink (_tmp32_);
	notification_frame = _tmp32_;
	_tmp33_ = notification_frame;
	_tmp34_ = gtk_widget_get_style_context ((GtkWidget*) _tmp33_);
	gtk_style_context_add_class (_tmp34_, "app-notification");
	_tmp35_ = notification_frame;
	_tmp36_ = event_box;
	gtk_container_add ((GtkContainer*) _tmp35_, (GtkWidget*) _tmp36_);
	_tmp37_ = notification_frame;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp37_);
	_g_object_unref0 (notification_frame);
	_g_object_unref0 (event_box);
	_g_object_unref0 (notification_box);
	_g_object_unref0 (close_button);
	return obj;
}

static void
granite_widgets_toast_class_init (GraniteWidgetsToastClass * klass,
                                  gpointer klass_data)
{
	granite_widgets_toast_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GraniteWidgetsToast_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_granite_widgets_toast_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_granite_widgets_toast_set_property;
	G_OBJECT_CLASS (klass)->constructor = granite_widgets_toast_constructor;
	G_OBJECT_CLASS (klass)->finalize = granite_widgets_toast_finalize;
	/**
	         * The notification text label to be displayed inside of #this
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_TOAST_TITLE_PROPERTY, granite_widgets_toast_properties[GRANITE_WIDGETS_TOAST_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	         * Emitted when the Toast is closed by activating the close button
	         */
	granite_widgets_toast_signals[GRANITE_WIDGETS_TOAST_CLOSED_SIGNAL] = g_signal_new ("closed", GRANITE_WIDGETS_TYPE_TOAST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/**
	         * Emitted when the default action button is activated
	         */
	granite_widgets_toast_signals[GRANITE_WIDGETS_TOAST_DEFAULT_ACTION_SIGNAL] = g_signal_new ("default-action", GRANITE_WIDGETS_TYPE_TOAST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
granite_widgets_toast_instance_init (GraniteWidgetsToast * self,
                                     gpointer klass)
{
	self->priv = granite_widgets_toast_get_instance_private (self);
}

static void
granite_widgets_toast_finalize (GObject * obj)
{
	GraniteWidgetsToast * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_TYPE_TOAST, GraniteWidgetsToast);
	_g_object_unref0 (self->priv->notification_label);
	_g_object_unref0 (self->priv->default_action_button);
	_g_free0 (self->priv->_title);
	G_OBJECT_CLASS (granite_widgets_toast_parent_class)->finalize (obj);
}

/**
     * Toasts are small in-app notifications that provide feedback about an operation
     * in a small popup. They only fill the space required to show the message and do
     * not block the UI.
     *
     * Granite.Widgets.Toast will get the style class .app-notification
     *
     * {{../doc/images/Toast.png}}
     */
static GType
granite_widgets_toast_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteWidgetsToastClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_widgets_toast_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteWidgetsToast), 0, (GInstanceInitFunc) granite_widgets_toast_instance_init, NULL };
	GType granite_widgets_toast_type_id;
	granite_widgets_toast_type_id = g_type_register_static (gtk_revealer_get_type (), "GraniteWidgetsToast", &g_define_type_info, 0);
	GraniteWidgetsToast_private_offset = g_type_add_instance_private (granite_widgets_toast_type_id, sizeof (GraniteWidgetsToastPrivate));
	return granite_widgets_toast_type_id;
}

GType
granite_widgets_toast_get_type (void)
{
	static volatile gsize granite_widgets_toast_type_id__once = 0;
	if (g_once_init_enter (&granite_widgets_toast_type_id__once)) {
		GType granite_widgets_toast_type_id;
		granite_widgets_toast_type_id = granite_widgets_toast_get_type_once ();
		g_once_init_leave (&granite_widgets_toast_type_id__once, granite_widgets_toast_type_id);
	}
	return granite_widgets_toast_type_id__once;
}

static void
_vala_granite_widgets_toast_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	GraniteWidgetsToast * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_TYPE_TOAST, GraniteWidgetsToast);
	switch (property_id) {
		case GRANITE_WIDGETS_TOAST_TITLE_PROPERTY:
		g_value_set_string (value, granite_widgets_toast_get_title (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_granite_widgets_toast_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	GraniteWidgetsToast * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_TYPE_TOAST, GraniteWidgetsToast);
	switch (property_id) {
		case GRANITE_WIDGETS_TOAST_TITLE_PROPERTY:
		granite_widgets_toast_set_title (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

