{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Calls a callback function when the button is clicked.
-- 
-- \<picture>
--   \<source srcset=\"button-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkButton\" src=\"button.png\">
-- \<\/picture>
-- 
-- The @GtkButton@ widget can hold any valid child widget. That is, it can hold
-- almost any other standard @GtkWidget@. The most commonly used child is the
-- @GtkLabel@.
-- 
-- = Shortcuts and Gestures
-- 
-- The following signals have default keybindings:
-- 
-- * [Button::activate]("GI.Gtk.Objects.Button#g:signal:activate")
-- 
-- 
-- = CSS nodes
-- 
-- @GtkButton@ has a single CSS node with name button. The node will get the
-- style classes .image-button or .text-button, if the content is just an
-- image or label, respectively. It may also receive the .flat style class.
-- When activating a button via the keyboard, the button will temporarily
-- gain the .keyboard-activating style class.
-- 
-- Other style classes that are commonly used with @GtkButton@ include
-- .suggested-action and .destructive-action. In special cases, buttons
-- can be made round by adding the .circular style class.
-- 
-- Button-like widgets like t'GI.Gtk.Objects.ToggleButton.ToggleButton', t'GI.Gtk.Objects.MenuButton.MenuButton',
-- t'GI.Gtk.Objects.VolumeButton.VolumeButton', t'GI.Gtk.Objects.LockButton.LockButton', t'GI.Gtk.Objects.ColorButton.ColorButton'
-- or t'GI.Gtk.Objects.FontButton.FontButton' use style classes such as .toggle, .popup, .scale,
-- .lock, .color on the button node to differentiate themselves from a plain
-- @GtkButton@.
-- 
-- = Accessibility
-- 
-- @GtkButton@ uses the 'GI.Gtk.Enums.AccessibleRoleButton' role.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.Button
    ( 

-- * Exported types
    Button(..)                              ,
    IsButton                                ,
    toButton                                ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getActionName]("GI.Gtk.Interfaces.Actionable#g:method:getActionName"), [getActionTargetValue]("GI.Gtk.Interfaces.Actionable#g:method:getActionTargetValue"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanShrink]("GI.Gtk.Objects.Button#g:method:getCanShrink"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChild]("GI.Gtk.Objects.Button#g:method:getChild"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasFrame]("GI.Gtk.Objects.Button#g:method:getHasFrame"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getIconName]("GI.Gtk.Objects.Button#g:method:getIconName"), [getLabel]("GI.Gtk.Objects.Button#g:method:getLabel"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getUseUnderline]("GI.Gtk.Objects.Button#g:method:getUseUnderline"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setActionName]("GI.Gtk.Interfaces.Actionable#g:method:setActionName"), [setActionTargetValue]("GI.Gtk.Interfaces.Actionable#g:method:setActionTargetValue"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanShrink]("GI.Gtk.Objects.Button#g:method:setCanShrink"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChild]("GI.Gtk.Objects.Button#g:method:setChild"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDetailedActionName]("GI.Gtk.Interfaces.Actionable#g:method:setDetailedActionName"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasFrame]("GI.Gtk.Objects.Button#g:method:setHasFrame"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setIconName]("GI.Gtk.Objects.Button#g:method:setIconName"), [setLabel]("GI.Gtk.Objects.Button#g:method:setLabel"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setUseUnderline]("GI.Gtk.Objects.Button#g:method:setUseUnderline"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveButtonMethod                     ,
#endif

-- ** getCanShrink #method:getCanShrink#

#if defined(ENABLE_OVERLOADING)
    ButtonGetCanShrinkMethodInfo            ,
#endif
    buttonGetCanShrink                      ,


-- ** getChild #method:getChild#

#if defined(ENABLE_OVERLOADING)
    ButtonGetChildMethodInfo                ,
#endif
    buttonGetChild                          ,


-- ** getHasFrame #method:getHasFrame#

#if defined(ENABLE_OVERLOADING)
    ButtonGetHasFrameMethodInfo             ,
#endif
    buttonGetHasFrame                       ,


-- ** getIconName #method:getIconName#

#if defined(ENABLE_OVERLOADING)
    ButtonGetIconNameMethodInfo             ,
#endif
    buttonGetIconName                       ,


-- ** getLabel #method:getLabel#

#if defined(ENABLE_OVERLOADING)
    ButtonGetLabelMethodInfo                ,
#endif
    buttonGetLabel                          ,


-- ** getUseUnderline #method:getUseUnderline#

#if defined(ENABLE_OVERLOADING)
    ButtonGetUseUnderlineMethodInfo         ,
#endif
    buttonGetUseUnderline                   ,


-- ** new #method:new#

    buttonNew                               ,


-- ** newFromIconName #method:newFromIconName#

    buttonNewFromIconName                   ,


-- ** newWithLabel #method:newWithLabel#

    buttonNewWithLabel                      ,


-- ** newWithMnemonic #method:newWithMnemonic#

    buttonNewWithMnemonic                   ,


-- ** setCanShrink #method:setCanShrink#

#if defined(ENABLE_OVERLOADING)
    ButtonSetCanShrinkMethodInfo            ,
#endif
    buttonSetCanShrink                      ,


-- ** setChild #method:setChild#

#if defined(ENABLE_OVERLOADING)
    ButtonSetChildMethodInfo                ,
#endif
    buttonSetChild                          ,


-- ** setHasFrame #method:setHasFrame#

#if defined(ENABLE_OVERLOADING)
    ButtonSetHasFrameMethodInfo             ,
#endif
    buttonSetHasFrame                       ,


-- ** setIconName #method:setIconName#

#if defined(ENABLE_OVERLOADING)
    ButtonSetIconNameMethodInfo             ,
#endif
    buttonSetIconName                       ,


-- ** setLabel #method:setLabel#

#if defined(ENABLE_OVERLOADING)
    ButtonSetLabelMethodInfo                ,
#endif
    buttonSetLabel                          ,


-- ** setUseUnderline #method:setUseUnderline#

#if defined(ENABLE_OVERLOADING)
    ButtonSetUseUnderlineMethodInfo         ,
#endif
    buttonSetUseUnderline                   ,




 -- * Properties


-- ** canShrink #attr:canShrink#
-- | Whether the size of the button can be made smaller than the natural
-- size of its contents.
-- 
-- For text buttons, setting this property will allow ellipsizing the label.
-- 
-- If the contents of a button are an icon or a custom widget, setting this
-- property has no effect.
-- 
-- /Since: 4.12/

#if defined(ENABLE_OVERLOADING)
    ButtonCanShrinkPropertyInfo             ,
#endif
#if defined(ENABLE_OVERLOADING)
    buttonCanShrink                         ,
#endif
    constructButtonCanShrink                ,
    getButtonCanShrink                      ,
    setButtonCanShrink                      ,


-- ** child #attr:child#
-- | The child widget.

#if defined(ENABLE_OVERLOADING)
    ButtonChildPropertyInfo                 ,
#endif
#if defined(ENABLE_OVERLOADING)
    buttonChild                             ,
#endif
    clearButtonChild                        ,
    constructButtonChild                    ,
    getButtonChild                          ,
    setButtonChild                          ,


-- ** hasFrame #attr:hasFrame#
-- | Whether the button has a frame.

#if defined(ENABLE_OVERLOADING)
    ButtonHasFramePropertyInfo              ,
#endif
#if defined(ENABLE_OVERLOADING)
    buttonHasFrame                          ,
#endif
    constructButtonHasFrame                 ,
    getButtonHasFrame                       ,
    setButtonHasFrame                       ,


-- ** iconName #attr:iconName#
-- | The name of the icon used to automatically populate the button.

#if defined(ENABLE_OVERLOADING)
    ButtonIconNamePropertyInfo              ,
#endif
#if defined(ENABLE_OVERLOADING)
    buttonIconName                          ,
#endif
    constructButtonIconName                 ,
    getButtonIconName                       ,
    setButtonIconName                       ,


-- ** label #attr:label#
-- | Text of the label inside the button, if the button contains a label widget.

#if defined(ENABLE_OVERLOADING)
    ButtonLabelPropertyInfo                 ,
#endif
#if defined(ENABLE_OVERLOADING)
    buttonLabel                             ,
#endif
    constructButtonLabel                    ,
    getButtonLabel                          ,
    setButtonLabel                          ,


-- ** useUnderline #attr:useUnderline#
-- | If set, an underline in the text indicates that the following character is
-- to be used as mnemonic.

#if defined(ENABLE_OVERLOADING)
    ButtonUseUnderlinePropertyInfo          ,
#endif
#if defined(ENABLE_OVERLOADING)
    buttonUseUnderline                      ,
#endif
    constructButtonUseUnderline             ,
    getButtonUseUnderline                   ,
    setButtonUseUnderline                   ,




 -- * Signals


-- ** activate #signal:activate#

    ButtonActivateCallback                  ,
#if defined(ENABLE_OVERLOADING)
    ButtonActivateSignalInfo                ,
#endif
    afterButtonActivate                     ,
    onButtonActivate                        ,


-- ** clicked #signal:clicked#

    ButtonClickedCallback                   ,
#if defined(ENABLE_OVERLOADING)
    ButtonClickedSignalInfo                 ,
#endif
    afterButtonClicked                      ,
    onButtonClicked                         ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Actionable as Gtk.Actionable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Actionable as Gtk.Actionable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype Button = Button (SP.ManagedPtr Button)
    deriving (Eq)

instance SP.ManagedPtrNewtype Button where
    toManagedPtr (Button p) = p

foreign import ccall "gtk_button_get_type"
    c_gtk_button_get_type :: IO B.Types.GType

instance B.Types.TypedObject Button where
    glibType = c_gtk_button_get_type

instance B.Types.GObject Button

-- | Type class for types which can be safely cast to t'Button', for instance with `toButton`.
class (SP.GObject o, O.IsDescendantOf Button o) => IsButton o
instance (SP.GObject o, O.IsDescendantOf Button o) => IsButton o

instance O.HasParentTypes Button
type instance O.ParentTypes Button = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Actionable.Actionable, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget]

-- | Cast to t'Button', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toButton :: (MIO.MonadIO m, IsButton o) => o -> m Button
toButton = MIO.liftIO . B.ManagedPtr.unsafeCastTo Button

-- | Convert t'Button' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Button) where
    gvalueGType_ = c_gtk_button_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Button)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Button)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Button ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveButtonMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveButtonMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveButtonMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveButtonMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveButtonMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveButtonMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveButtonMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveButtonMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveButtonMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveButtonMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveButtonMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveButtonMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveButtonMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveButtonMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveButtonMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveButtonMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveButtonMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveButtonMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveButtonMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveButtonMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveButtonMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveButtonMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveButtonMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveButtonMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveButtonMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveButtonMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveButtonMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveButtonMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveButtonMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveButtonMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveButtonMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveButtonMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveButtonMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveButtonMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveButtonMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveButtonMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveButtonMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveButtonMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveButtonMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveButtonMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveButtonMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveButtonMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveButtonMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveButtonMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveButtonMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveButtonMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveButtonMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveButtonMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveButtonMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveButtonMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveButtonMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveButtonMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveButtonMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveButtonMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveButtonMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveButtonMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveButtonMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveButtonMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveButtonMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveButtonMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveButtonMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveButtonMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveButtonMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveButtonMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveButtonMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveButtonMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveButtonMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveButtonMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveButtonMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveButtonMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveButtonMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveButtonMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveButtonMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveButtonMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveButtonMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveButtonMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveButtonMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveButtonMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveButtonMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveButtonMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveButtonMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveButtonMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveButtonMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveButtonMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveButtonMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveButtonMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveButtonMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveButtonMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveButtonMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveButtonMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveButtonMethod "getActionName" o = Gtk.Actionable.ActionableGetActionNameMethodInfo
    ResolveButtonMethod "getActionTargetValue" o = Gtk.Actionable.ActionableGetActionTargetValueMethodInfo
    ResolveButtonMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveButtonMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveButtonMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveButtonMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveButtonMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveButtonMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveButtonMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveButtonMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveButtonMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveButtonMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveButtonMethod "getCanShrink" o = ButtonGetCanShrinkMethodInfo
    ResolveButtonMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveButtonMethod "getChild" o = ButtonGetChildMethodInfo
    ResolveButtonMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveButtonMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveButtonMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveButtonMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveButtonMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveButtonMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveButtonMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveButtonMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveButtonMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveButtonMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveButtonMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveButtonMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveButtonMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveButtonMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveButtonMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveButtonMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveButtonMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveButtonMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveButtonMethod "getHasFrame" o = ButtonGetHasFrameMethodInfo
    ResolveButtonMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveButtonMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveButtonMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveButtonMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveButtonMethod "getIconName" o = ButtonGetIconNameMethodInfo
    ResolveButtonMethod "getLabel" o = ButtonGetLabelMethodInfo
    ResolveButtonMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveButtonMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveButtonMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveButtonMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveButtonMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveButtonMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveButtonMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveButtonMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveButtonMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveButtonMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveButtonMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveButtonMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveButtonMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveButtonMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveButtonMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveButtonMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveButtonMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveButtonMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveButtonMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveButtonMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveButtonMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveButtonMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveButtonMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveButtonMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveButtonMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveButtonMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveButtonMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveButtonMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveButtonMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveButtonMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveButtonMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveButtonMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveButtonMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveButtonMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveButtonMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveButtonMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveButtonMethod "getUseUnderline" o = ButtonGetUseUnderlineMethodInfo
    ResolveButtonMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveButtonMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveButtonMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveButtonMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveButtonMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveButtonMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveButtonMethod "setActionName" o = Gtk.Actionable.ActionableSetActionNameMethodInfo
    ResolveButtonMethod "setActionTargetValue" o = Gtk.Actionable.ActionableSetActionTargetValueMethodInfo
    ResolveButtonMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveButtonMethod "setCanShrink" o = ButtonSetCanShrinkMethodInfo
    ResolveButtonMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveButtonMethod "setChild" o = ButtonSetChildMethodInfo
    ResolveButtonMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveButtonMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveButtonMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveButtonMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveButtonMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveButtonMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveButtonMethod "setDetailedActionName" o = Gtk.Actionable.ActionableSetDetailedActionNameMethodInfo
    ResolveButtonMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveButtonMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveButtonMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveButtonMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveButtonMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveButtonMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveButtonMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveButtonMethod "setHasFrame" o = ButtonSetHasFrameMethodInfo
    ResolveButtonMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveButtonMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveButtonMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveButtonMethod "setIconName" o = ButtonSetIconNameMethodInfo
    ResolveButtonMethod "setLabel" o = ButtonSetLabelMethodInfo
    ResolveButtonMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveButtonMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveButtonMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveButtonMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveButtonMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveButtonMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveButtonMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveButtonMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveButtonMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveButtonMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveButtonMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveButtonMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveButtonMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveButtonMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveButtonMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveButtonMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveButtonMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveButtonMethod "setUseUnderline" o = ButtonSetUseUnderlineMethodInfo
    ResolveButtonMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveButtonMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveButtonMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveButtonMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveButtonMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveButtonMethod t Button, O.OverloadedMethod info Button p) => OL.IsLabel t (Button -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveButtonMethod t Button, O.OverloadedMethod info Button p, R.HasField t Button p) => R.HasField t Button p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveButtonMethod t Button, O.OverloadedMethodInfo info Button) => OL.IsLabel t (O.MethodProxy info Button) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal Button::activate
-- | Emitted to animate press then release.
-- 
-- This is an action signal. Applications should never connect
-- to this signal, but use the [Button::clicked]("GI.Gtk.Objects.Button#g:signal:clicked") signal.
-- 
-- The default bindings for this signal are all forms of the
-- \<kbd>␣\<\/kbd> and \<kbd>Enter\<\/kbd> keys.
type ButtonActivateCallback =
    IO ()

type C_ButtonActivateCallback =
    Ptr Button ->                           -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ButtonActivateCallback`.
foreign import ccall "wrapper"
    mk_ButtonActivateCallback :: C_ButtonActivateCallback -> IO (FunPtr C_ButtonActivateCallback)

wrap_ButtonActivateCallback :: 
    GObject a => (a -> ButtonActivateCallback) ->
    C_ButtonActivateCallback
wrap_ButtonActivateCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [activate](#signal:activate) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' button #activate callback
-- @
-- 
-- 
onButtonActivate :: (IsButton a, MonadIO m) => a -> ((?self :: a) => ButtonActivateCallback) -> m SignalHandlerId
onButtonActivate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ButtonActivateCallback wrapped
    wrapped'' <- mk_ButtonActivateCallback wrapped'
    connectSignalFunPtr obj "activate" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [activate](#signal:activate) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' button #activate callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterButtonActivate :: (IsButton a, MonadIO m) => a -> ((?self :: a) => ButtonActivateCallback) -> m SignalHandlerId
afterButtonActivate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ButtonActivateCallback wrapped
    wrapped'' <- mk_ButtonActivateCallback wrapped'
    connectSignalFunPtr obj "activate" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ButtonActivateSignalInfo
instance SignalInfo ButtonActivateSignalInfo where
    type HaskellCallbackType ButtonActivateSignalInfo = ButtonActivateCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ButtonActivateCallback cb
        cb'' <- mk_ButtonActivateCallback cb'
        connectSignalFunPtr obj "activate" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Button::activate"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Button.html#g:signal:activate"})

#endif

-- signal Button::clicked
-- | Emitted when the button has been activated (pressed and released).
type ButtonClickedCallback =
    IO ()

type C_ButtonClickedCallback =
    Ptr Button ->                           -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ButtonClickedCallback`.
foreign import ccall "wrapper"
    mk_ButtonClickedCallback :: C_ButtonClickedCallback -> IO (FunPtr C_ButtonClickedCallback)

wrap_ButtonClickedCallback :: 
    GObject a => (a -> ButtonClickedCallback) ->
    C_ButtonClickedCallback
wrap_ButtonClickedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [clicked](#signal:clicked) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' button #clicked callback
-- @
-- 
-- 
onButtonClicked :: (IsButton a, MonadIO m) => a -> ((?self :: a) => ButtonClickedCallback) -> m SignalHandlerId
onButtonClicked obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ButtonClickedCallback wrapped
    wrapped'' <- mk_ButtonClickedCallback wrapped'
    connectSignalFunPtr obj "clicked" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [clicked](#signal:clicked) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' button #clicked callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterButtonClicked :: (IsButton a, MonadIO m) => a -> ((?self :: a) => ButtonClickedCallback) -> m SignalHandlerId
afterButtonClicked obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ButtonClickedCallback wrapped
    wrapped'' <- mk_ButtonClickedCallback wrapped'
    connectSignalFunPtr obj "clicked" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ButtonClickedSignalInfo
instance SignalInfo ButtonClickedSignalInfo where
    type HaskellCallbackType ButtonClickedSignalInfo = ButtonClickedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ButtonClickedCallback cb
        cb'' <- mk_ButtonClickedCallback cb'
        connectSignalFunPtr obj "clicked" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Button::clicked"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Button.html#g:signal:clicked"})

#endif

-- VVV Prop "can-shrink"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@can-shrink@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' button #canShrink
-- @
getButtonCanShrink :: (MonadIO m, IsButton o) => o -> m Bool
getButtonCanShrink obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "can-shrink"

-- | Set the value of the “@can-shrink@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' button [ #canShrink 'Data.GI.Base.Attributes.:=' value ]
-- @
setButtonCanShrink :: (MonadIO m, IsButton o) => o -> Bool -> m ()
setButtonCanShrink obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "can-shrink" val

-- | Construct a t'GValueConstruct' with valid value for the “@can-shrink@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructButtonCanShrink :: (IsButton o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructButtonCanShrink val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "can-shrink" val

#if defined(ENABLE_OVERLOADING)
data ButtonCanShrinkPropertyInfo
instance AttrInfo ButtonCanShrinkPropertyInfo where
    type AttrAllowedOps ButtonCanShrinkPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint ButtonCanShrinkPropertyInfo = IsButton
    type AttrSetTypeConstraint ButtonCanShrinkPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ButtonCanShrinkPropertyInfo = (~) Bool
    type AttrTransferType ButtonCanShrinkPropertyInfo = Bool
    type AttrGetType ButtonCanShrinkPropertyInfo = Bool
    type AttrLabel ButtonCanShrinkPropertyInfo = "can-shrink"
    type AttrOrigin ButtonCanShrinkPropertyInfo = Button
    attrGet = getButtonCanShrink
    attrSet = setButtonCanShrink
    attrPut = setButtonCanShrink
    attrTransfer _ v = do
        return v
    attrConstruct = constructButtonCanShrink
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Button.canShrink"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Button.html#g:attr:canShrink"
        })
#endif

-- VVV Prop "child"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Widget"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' button #child
-- @
getButtonChild :: (MonadIO m, IsButton o) => o -> m (Maybe Gtk.Widget.Widget)
getButtonChild obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "child" Gtk.Widget.Widget

-- | Set the value of the “@child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' button [ #child 'Data.GI.Base.Attributes.:=' value ]
-- @
setButtonChild :: (MonadIO m, IsButton o, Gtk.Widget.IsWidget a) => o -> a -> m ()
setButtonChild obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "child" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@child@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructButtonChild :: (IsButton o, MIO.MonadIO m, Gtk.Widget.IsWidget a) => a -> m (GValueConstruct o)
constructButtonChild val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "child" (P.Just val)

-- | Set the value of the “@child@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #child
-- @
clearButtonChild :: (MonadIO m, IsButton o) => o -> m ()
clearButtonChild obj = liftIO $ B.Properties.setObjectPropertyObject obj "child" (Nothing :: Maybe Gtk.Widget.Widget)

#if defined(ENABLE_OVERLOADING)
data ButtonChildPropertyInfo
instance AttrInfo ButtonChildPropertyInfo where
    type AttrAllowedOps ButtonChildPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ButtonChildPropertyInfo = IsButton
    type AttrSetTypeConstraint ButtonChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferTypeConstraint ButtonChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferType ButtonChildPropertyInfo = Gtk.Widget.Widget
    type AttrGetType ButtonChildPropertyInfo = (Maybe Gtk.Widget.Widget)
    type AttrLabel ButtonChildPropertyInfo = "child"
    type AttrOrigin ButtonChildPropertyInfo = Button
    attrGet = getButtonChild
    attrSet = setButtonChild
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gtk.Widget.Widget v
    attrConstruct = constructButtonChild
    attrClear = clearButtonChild
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Button.child"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Button.html#g:attr:child"
        })
#endif

-- VVV Prop "has-frame"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@has-frame@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' button #hasFrame
-- @
getButtonHasFrame :: (MonadIO m, IsButton o) => o -> m Bool
getButtonHasFrame obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "has-frame"

-- | Set the value of the “@has-frame@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' button [ #hasFrame 'Data.GI.Base.Attributes.:=' value ]
-- @
setButtonHasFrame :: (MonadIO m, IsButton o) => o -> Bool -> m ()
setButtonHasFrame obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "has-frame" val

-- | Construct a t'GValueConstruct' with valid value for the “@has-frame@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructButtonHasFrame :: (IsButton o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructButtonHasFrame val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "has-frame" val

#if defined(ENABLE_OVERLOADING)
data ButtonHasFramePropertyInfo
instance AttrInfo ButtonHasFramePropertyInfo where
    type AttrAllowedOps ButtonHasFramePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint ButtonHasFramePropertyInfo = IsButton
    type AttrSetTypeConstraint ButtonHasFramePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ButtonHasFramePropertyInfo = (~) Bool
    type AttrTransferType ButtonHasFramePropertyInfo = Bool
    type AttrGetType ButtonHasFramePropertyInfo = Bool
    type AttrLabel ButtonHasFramePropertyInfo = "has-frame"
    type AttrOrigin ButtonHasFramePropertyInfo = Button
    attrGet = getButtonHasFrame
    attrSet = setButtonHasFrame
    attrPut = setButtonHasFrame
    attrTransfer _ v = do
        return v
    attrConstruct = constructButtonHasFrame
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Button.hasFrame"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Button.html#g:attr:hasFrame"
        })
#endif

-- VVV Prop "icon-name"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just False)

-- | Get the value of the “@icon-name@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' button #iconName
-- @
getButtonIconName :: (MonadIO m, IsButton o) => o -> m (Maybe T.Text)
getButtonIconName obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "icon-name"

-- | Set the value of the “@icon-name@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' button [ #iconName 'Data.GI.Base.Attributes.:=' value ]
-- @
setButtonIconName :: (MonadIO m, IsButton o) => o -> T.Text -> m ()
setButtonIconName obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "icon-name" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@icon-name@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructButtonIconName :: (IsButton o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructButtonIconName val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "icon-name" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data ButtonIconNamePropertyInfo
instance AttrInfo ButtonIconNamePropertyInfo where
    type AttrAllowedOps ButtonIconNamePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ButtonIconNamePropertyInfo = IsButton
    type AttrSetTypeConstraint ButtonIconNamePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint ButtonIconNamePropertyInfo = (~) T.Text
    type AttrTransferType ButtonIconNamePropertyInfo = T.Text
    type AttrGetType ButtonIconNamePropertyInfo = (Maybe T.Text)
    type AttrLabel ButtonIconNamePropertyInfo = "icon-name"
    type AttrOrigin ButtonIconNamePropertyInfo = Button
    attrGet = getButtonIconName
    attrSet = setButtonIconName
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructButtonIconName
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Button.iconName"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Button.html#g:attr:iconName"
        })
#endif

-- VVV Prop "label"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just False)

-- | Get the value of the “@label@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' button #label
-- @
getButtonLabel :: (MonadIO m, IsButton o) => o -> m (Maybe T.Text)
getButtonLabel obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "label"

-- | Set the value of the “@label@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' button [ #label 'Data.GI.Base.Attributes.:=' value ]
-- @
setButtonLabel :: (MonadIO m, IsButton o) => o -> T.Text -> m ()
setButtonLabel obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "label" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@label@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructButtonLabel :: (IsButton o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructButtonLabel val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "label" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data ButtonLabelPropertyInfo
instance AttrInfo ButtonLabelPropertyInfo where
    type AttrAllowedOps ButtonLabelPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ButtonLabelPropertyInfo = IsButton
    type AttrSetTypeConstraint ButtonLabelPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint ButtonLabelPropertyInfo = (~) T.Text
    type AttrTransferType ButtonLabelPropertyInfo = T.Text
    type AttrGetType ButtonLabelPropertyInfo = (Maybe T.Text)
    type AttrLabel ButtonLabelPropertyInfo = "label"
    type AttrOrigin ButtonLabelPropertyInfo = Button
    attrGet = getButtonLabel
    attrSet = setButtonLabel
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructButtonLabel
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Button.label"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Button.html#g:attr:label"
        })
#endif

-- VVV Prop "use-underline"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@use-underline@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' button #useUnderline
-- @
getButtonUseUnderline :: (MonadIO m, IsButton o) => o -> m Bool
getButtonUseUnderline obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "use-underline"

-- | Set the value of the “@use-underline@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' button [ #useUnderline 'Data.GI.Base.Attributes.:=' value ]
-- @
setButtonUseUnderline :: (MonadIO m, IsButton o) => o -> Bool -> m ()
setButtonUseUnderline obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "use-underline" val

-- | Construct a t'GValueConstruct' with valid value for the “@use-underline@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructButtonUseUnderline :: (IsButton o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructButtonUseUnderline val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "use-underline" val

#if defined(ENABLE_OVERLOADING)
data ButtonUseUnderlinePropertyInfo
instance AttrInfo ButtonUseUnderlinePropertyInfo where
    type AttrAllowedOps ButtonUseUnderlinePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint ButtonUseUnderlinePropertyInfo = IsButton
    type AttrSetTypeConstraint ButtonUseUnderlinePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ButtonUseUnderlinePropertyInfo = (~) Bool
    type AttrTransferType ButtonUseUnderlinePropertyInfo = Bool
    type AttrGetType ButtonUseUnderlinePropertyInfo = Bool
    type AttrLabel ButtonUseUnderlinePropertyInfo = "use-underline"
    type AttrOrigin ButtonUseUnderlinePropertyInfo = Button
    attrGet = getButtonUseUnderline
    attrSet = setButtonUseUnderline
    attrPut = setButtonUseUnderline
    attrTransfer _ v = do
        return v
    attrConstruct = constructButtonUseUnderline
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Button.useUnderline"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Button.html#g:attr:useUnderline"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Button
type instance O.AttributeList Button = ButtonAttributeList
type ButtonAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("actionName", Gtk.Actionable.ActionableActionNamePropertyInfo), '("actionTarget", Gtk.Actionable.ActionableActionTargetPropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canShrink", ButtonCanShrinkPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("child", ButtonChildPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasFrame", ButtonHasFramePropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("iconName", ButtonIconNamePropertyInfo), '("label", ButtonLabelPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("useUnderline", ButtonUseUnderlinePropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
buttonCanShrink :: AttrLabelProxy "canShrink"
buttonCanShrink = AttrLabelProxy

buttonChild :: AttrLabelProxy "child"
buttonChild = AttrLabelProxy

buttonHasFrame :: AttrLabelProxy "hasFrame"
buttonHasFrame = AttrLabelProxy

buttonIconName :: AttrLabelProxy "iconName"
buttonIconName = AttrLabelProxy

buttonLabel :: AttrLabelProxy "label"
buttonLabel = AttrLabelProxy

buttonUseUnderline :: AttrLabelProxy "useUnderline"
buttonUseUnderline = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Button = ButtonSignalList
type ButtonSignalList = ('[ '("activate", ButtonActivateSignalInfo), '("clicked", ButtonClickedSignalInfo), '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Button::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Button" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_button_new" gtk_button_new :: 
    IO (Ptr Button)

-- | Creates a new @GtkButton@ widget.
-- 
-- To add a child widget to the button, use 'GI.Gtk.Objects.Button.buttonSetChild'.
buttonNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Button
    -- ^ __Returns:__ The newly created @GtkButton@ widget.
buttonNew  = liftIO $ do
    result <- gtk_button_new
    checkUnexpectedReturnNULL "buttonNew" result
    result' <- (newObject Button) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Button::new_from_icon_name
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "icon_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an icon name" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Button" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_button_new_from_icon_name" gtk_button_new_from_icon_name :: 
    CString ->                              -- icon_name : TBasicType TUTF8
    IO (Ptr Button)

-- | Creates a new button containing an icon from the current icon theme.
-- 
-- If the icon name isn’t known, a “broken image” icon will be
-- displayed instead. If the current icon theme is changed, the icon
-- will be updated appropriately.
buttonNewFromIconName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@iconName@/: an icon name
    -> m Button
    -- ^ __Returns:__ a new @GtkButton@ displaying the themed icon
buttonNewFromIconName iconName = liftIO $ do
    iconName' <- textToCString iconName
    result <- gtk_button_new_from_icon_name iconName'
    checkUnexpectedReturnNULL "buttonNewFromIconName" result
    result' <- (newObject Button) result
    freeMem iconName'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Button::new_with_label
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "label"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The text you want the `GtkLabel` to hold"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Button" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_button_new_with_label" gtk_button_new_with_label :: 
    CString ->                              -- label : TBasicType TUTF8
    IO (Ptr Button)

-- | Creates a @GtkButton@ widget with a @GtkLabel@ child.
buttonNewWithLabel ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@label@/: The text you want the @GtkLabel@ to hold
    -> m Button
    -- ^ __Returns:__ The newly created @GtkButton@ widget
buttonNewWithLabel label = liftIO $ do
    label' <- textToCString label
    result <- gtk_button_new_with_label label'
    checkUnexpectedReturnNULL "buttonNewWithLabel" result
    result' <- (newObject Button) result
    freeMem label'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Button::new_with_mnemonic
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "label"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The text of the button, with an underscore in front of the\n  mnemonic character"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Button" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_button_new_with_mnemonic" gtk_button_new_with_mnemonic :: 
    CString ->                              -- label : TBasicType TUTF8
    IO (Ptr Button)

-- | Creates a new @GtkButton@ containing a label.
-- 
-- If characters in /@label@/ are preceded by an underscore, they are underlined.
-- If you need a literal underscore character in a label, use “__” (two
-- underscores). The first underlined character represents a keyboard
-- accelerator called a mnemonic. Pressing \<kbd>Alt\<\/kbd> and that key
-- activates the button.
buttonNewWithMnemonic ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@label@/: The text of the button, with an underscore in front of the
    --   mnemonic character
    -> m Button
    -- ^ __Returns:__ a new @GtkButton@
buttonNewWithMnemonic label = liftIO $ do
    label' <- textToCString label
    result <- gtk_button_new_with_mnemonic label'
    checkUnexpectedReturnNULL "buttonNewWithMnemonic" result
    result' <- (newObject Button) result
    freeMem label'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Button::get_can_shrink
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "button"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Button" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a button" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_button_get_can_shrink" gtk_button_get_can_shrink :: 
    Ptr Button ->                           -- button : TInterface (Name {namespace = "Gtk", name = "Button"})
    IO CInt

-- | Retrieves whether the button can be smaller than the natural
-- size of its contents.
-- 
-- /Since: 4.12/
buttonGetCanShrink ::
    (B.CallStack.HasCallStack, MonadIO m, IsButton a) =>
    a
    -- ^ /@button@/: a button
    -> m Bool
    -- ^ __Returns:__ true if the button can shrink, and false otherwise
buttonGetCanShrink button = liftIO $ do
    button' <- unsafeManagedPtrCastPtr button
    result <- gtk_button_get_can_shrink button'
    let result' = (/= 0) result
    touchManagedPtr button
    return result'

#if defined(ENABLE_OVERLOADING)
data ButtonGetCanShrinkMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsButton a) => O.OverloadedMethod ButtonGetCanShrinkMethodInfo a signature where
    overloadedMethod = buttonGetCanShrink

instance O.OverloadedMethodInfo ButtonGetCanShrinkMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Button.buttonGetCanShrink",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Button.html#v:buttonGetCanShrink"
        })


#endif

-- method Button::get_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "button"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Button" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_button_get_child" gtk_button_get_child :: 
    Ptr Button ->                           -- button : TInterface (Name {namespace = "Gtk", name = "Button"})
    IO (Ptr Gtk.Widget.Widget)

-- | Gets the child widget of /@button@/.
buttonGetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsButton a) =>
    a
    -- ^ /@button@/: a @GtkButton@
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ the child widget of /@button@/
buttonGetChild button = liftIO $ do
    button' <- unsafeManagedPtrCastPtr button
    result <- gtk_button_get_child button'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr button
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ButtonGetChildMethodInfo
instance (signature ~ (m (Maybe Gtk.Widget.Widget)), MonadIO m, IsButton a) => O.OverloadedMethod ButtonGetChildMethodInfo a signature where
    overloadedMethod = buttonGetChild

instance O.OverloadedMethodInfo ButtonGetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Button.buttonGetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Button.html#v:buttonGetChild"
        })


#endif

-- method Button::get_has_frame
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "button"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Button" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_button_get_has_frame" gtk_button_get_has_frame :: 
    Ptr Button ->                           -- button : TInterface (Name {namespace = "Gtk", name = "Button"})
    IO CInt

-- | Returns whether the button has a frame.
buttonGetHasFrame ::
    (B.CallStack.HasCallStack, MonadIO m, IsButton a) =>
    a
    -- ^ /@button@/: a @GtkButton@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the button has a frame
buttonGetHasFrame button = liftIO $ do
    button' <- unsafeManagedPtrCastPtr button
    result <- gtk_button_get_has_frame button'
    let result' = (/= 0) result
    touchManagedPtr button
    return result'

#if defined(ENABLE_OVERLOADING)
data ButtonGetHasFrameMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsButton a) => O.OverloadedMethod ButtonGetHasFrameMethodInfo a signature where
    overloadedMethod = buttonGetHasFrame

instance O.OverloadedMethodInfo ButtonGetHasFrameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Button.buttonGetHasFrame",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Button.html#v:buttonGetHasFrame"
        })


#endif

-- method Button::get_icon_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "button"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Button" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_button_get_icon_name" gtk_button_get_icon_name :: 
    Ptr Button ->                           -- button : TInterface (Name {namespace = "Gtk", name = "Button"})
    IO CString

-- | Returns the icon name of the button.
-- 
-- If the icon name has not been set with 'GI.Gtk.Objects.Button.buttonSetIconName'
-- the return value will be 'P.Nothing'. This will be the case if you create
-- an empty button with 'GI.Gtk.Objects.Button.buttonNew' to use as a container.
buttonGetIconName ::
    (B.CallStack.HasCallStack, MonadIO m, IsButton a) =>
    a
    -- ^ /@button@/: A @GtkButton@
    -> m (Maybe T.Text)
    -- ^ __Returns:__ The icon name set via 'GI.Gtk.Objects.Button.buttonSetIconName'
buttonGetIconName button = liftIO $ do
    button' <- unsafeManagedPtrCastPtr button
    result <- gtk_button_get_icon_name button'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr button
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ButtonGetIconNameMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsButton a) => O.OverloadedMethod ButtonGetIconNameMethodInfo a signature where
    overloadedMethod = buttonGetIconName

instance O.OverloadedMethodInfo ButtonGetIconNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Button.buttonGetIconName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Button.html#v:buttonGetIconName"
        })


#endif

-- method Button::get_label
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "button"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Button" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_button_get_label" gtk_button_get_label :: 
    Ptr Button ->                           -- button : TInterface (Name {namespace = "Gtk", name = "Button"})
    IO CString

-- | Fetches the text from the label of the button.
-- 
-- If the label text has not been set with 'GI.Gtk.Objects.Button.buttonSetLabel'
-- the return value will be 'P.Nothing'. This will be the case if you create
-- an empty button with 'GI.Gtk.Objects.Button.buttonNew' to use as a container.
buttonGetLabel ::
    (B.CallStack.HasCallStack, MonadIO m, IsButton a) =>
    a
    -- ^ /@button@/: a @GtkButton@
    -> m (Maybe T.Text)
    -- ^ __Returns:__ The text of the label widget. This string is owned
    -- by the widget and must not be modified or freed.
buttonGetLabel button = liftIO $ do
    button' <- unsafeManagedPtrCastPtr button
    result <- gtk_button_get_label button'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr button
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ButtonGetLabelMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsButton a) => O.OverloadedMethod ButtonGetLabelMethodInfo a signature where
    overloadedMethod = buttonGetLabel

instance O.OverloadedMethodInfo ButtonGetLabelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Button.buttonGetLabel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Button.html#v:buttonGetLabel"
        })


#endif

-- method Button::get_use_underline
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "button"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Button" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_button_get_use_underline" gtk_button_get_use_underline :: 
    Ptr Button ->                           -- button : TInterface (Name {namespace = "Gtk", name = "Button"})
    IO CInt

-- | gets whether underlines are interpreted as mnemonics.
-- 
-- See 'GI.Gtk.Objects.Button.buttonSetUseUnderline'.
buttonGetUseUnderline ::
    (B.CallStack.HasCallStack, MonadIO m, IsButton a) =>
    a
    -- ^ /@button@/: a @GtkButton@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if an embedded underline in the button label
    --   indicates the mnemonic accelerator keys.
buttonGetUseUnderline button = liftIO $ do
    button' <- unsafeManagedPtrCastPtr button
    result <- gtk_button_get_use_underline button'
    let result' = (/= 0) result
    touchManagedPtr button
    return result'

#if defined(ENABLE_OVERLOADING)
data ButtonGetUseUnderlineMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsButton a) => O.OverloadedMethod ButtonGetUseUnderlineMethodInfo a signature where
    overloadedMethod = buttonGetUseUnderline

instance O.OverloadedMethodInfo ButtonGetUseUnderlineMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Button.buttonGetUseUnderline",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Button.html#v:buttonGetUseUnderline"
        })


#endif

-- method Button::set_can_shrink
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "button"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Button" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a button" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "can_shrink"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether the button can shrink"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_button_set_can_shrink" gtk_button_set_can_shrink :: 
    Ptr Button ->                           -- button : TInterface (Name {namespace = "Gtk", name = "Button"})
    CInt ->                                 -- can_shrink : TBasicType TBoolean
    IO ()

-- | Sets whether the button size can be smaller than the natural size of
-- its contents.
-- 
-- For text buttons, setting /@canShrink@/ to true will ellipsize the label.
-- 
-- For icons and custom children, this function has no effect.
-- 
-- /Since: 4.12/
buttonSetCanShrink ::
    (B.CallStack.HasCallStack, MonadIO m, IsButton a) =>
    a
    -- ^ /@button@/: a button
    -> Bool
    -- ^ /@canShrink@/: whether the button can shrink
    -> m ()
buttonSetCanShrink button canShrink = liftIO $ do
    button' <- unsafeManagedPtrCastPtr button
    let canShrink' = (P.fromIntegral . P.fromEnum) canShrink
    gtk_button_set_can_shrink button' canShrink'
    touchManagedPtr button
    return ()

#if defined(ENABLE_OVERLOADING)
data ButtonSetCanShrinkMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsButton a) => O.OverloadedMethod ButtonSetCanShrinkMethodInfo a signature where
    overloadedMethod = buttonSetCanShrink

instance O.OverloadedMethodInfo ButtonSetCanShrinkMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Button.buttonSetCanShrink",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Button.html#v:buttonSetCanShrink"
        })


#endif

-- method Button::set_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "button"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Button" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the child widget" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_button_set_child" gtk_button_set_child :: 
    Ptr Button ->                           -- button : TInterface (Name {namespace = "Gtk", name = "Button"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Sets the child widget of /@button@/.
-- 
-- Note that by using this API, you take full responsibility for setting
-- up the proper accessibility label and description information for /@button@/.
-- Most likely, you\'ll either set the accessibility label or description
-- for /@button@/ explicitly, or you\'ll set a labelled-by or described-by
-- relations from /@child@/ to /@button@/.
buttonSetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsButton a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@button@/: a @GtkButton@
    -> Maybe (b)
    -- ^ /@child@/: the child widget
    -> m ()
buttonSetChild button child = liftIO $ do
    button' <- unsafeManagedPtrCastPtr button
    maybeChild <- case child of
        Nothing -> return FP.nullPtr
        Just jChild -> do
            jChild' <- unsafeManagedPtrCastPtr jChild
            return jChild'
    gtk_button_set_child button' maybeChild
    touchManagedPtr button
    whenJust child touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ButtonSetChildMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsButton a, Gtk.Widget.IsWidget b) => O.OverloadedMethod ButtonSetChildMethodInfo a signature where
    overloadedMethod = buttonSetChild

instance O.OverloadedMethodInfo ButtonSetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Button.buttonSetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Button.html#v:buttonSetChild"
        })


#endif

-- method Button::set_has_frame
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "button"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Button" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "has_frame"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "whether the button should have a visible frame"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_button_set_has_frame" gtk_button_set_has_frame :: 
    Ptr Button ->                           -- button : TInterface (Name {namespace = "Gtk", name = "Button"})
    CInt ->                                 -- has_frame : TBasicType TBoolean
    IO ()

-- | Sets the style of the button.
-- 
-- Buttons can have a flat appearance or have a frame drawn around them.
buttonSetHasFrame ::
    (B.CallStack.HasCallStack, MonadIO m, IsButton a) =>
    a
    -- ^ /@button@/: a @GtkButton@
    -> Bool
    -- ^ /@hasFrame@/: whether the button should have a visible frame
    -> m ()
buttonSetHasFrame button hasFrame = liftIO $ do
    button' <- unsafeManagedPtrCastPtr button
    let hasFrame' = (P.fromIntegral . P.fromEnum) hasFrame
    gtk_button_set_has_frame button' hasFrame'
    touchManagedPtr button
    return ()

#if defined(ENABLE_OVERLOADING)
data ButtonSetHasFrameMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsButton a) => O.OverloadedMethod ButtonSetHasFrameMethodInfo a signature where
    overloadedMethod = buttonSetHasFrame

instance O.OverloadedMethodInfo ButtonSetHasFrameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Button.buttonSetHasFrame",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Button.html#v:buttonSetHasFrame"
        })


#endif

-- method Button::set_icon_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "button"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Button" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "icon_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "An icon name" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_button_set_icon_name" gtk_button_set_icon_name :: 
    Ptr Button ->                           -- button : TInterface (Name {namespace = "Gtk", name = "Button"})
    CString ->                              -- icon_name : TBasicType TUTF8
    IO ()

-- | Adds a @GtkImage@ with the given icon name as a child.
-- 
-- If /@button@/ already contains a child widget, that child widget will
-- be removed and replaced with the image.
buttonSetIconName ::
    (B.CallStack.HasCallStack, MonadIO m, IsButton a) =>
    a
    -- ^ /@button@/: A @GtkButton@
    -> T.Text
    -- ^ /@iconName@/: An icon name
    -> m ()
buttonSetIconName button iconName = liftIO $ do
    button' <- unsafeManagedPtrCastPtr button
    iconName' <- textToCString iconName
    gtk_button_set_icon_name button' iconName'
    touchManagedPtr button
    freeMem iconName'
    return ()

#if defined(ENABLE_OVERLOADING)
data ButtonSetIconNameMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsButton a) => O.OverloadedMethod ButtonSetIconNameMethodInfo a signature where
    overloadedMethod = buttonSetIconName

instance O.OverloadedMethodInfo ButtonSetIconNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Button.buttonSetIconName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Button.html#v:buttonSetIconName"
        })


#endif

-- method Button::set_label
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "button"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Button" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "label"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a string" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_button_set_label" gtk_button_set_label :: 
    Ptr Button ->                           -- button : TInterface (Name {namespace = "Gtk", name = "Button"})
    CString ->                              -- label : TBasicType TUTF8
    IO ()

-- | Sets the text of the label of the button to /@label@/.
-- 
-- This will also clear any previously set labels.
buttonSetLabel ::
    (B.CallStack.HasCallStack, MonadIO m, IsButton a) =>
    a
    -- ^ /@button@/: a @GtkButton@
    -> T.Text
    -- ^ /@label@/: a string
    -> m ()
buttonSetLabel button label = liftIO $ do
    button' <- unsafeManagedPtrCastPtr button
    label' <- textToCString label
    gtk_button_set_label button' label'
    touchManagedPtr button
    freeMem label'
    return ()

#if defined(ENABLE_OVERLOADING)
data ButtonSetLabelMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsButton a) => O.OverloadedMethod ButtonSetLabelMethodInfo a signature where
    overloadedMethod = buttonSetLabel

instance O.OverloadedMethodInfo ButtonSetLabelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Button.buttonSetLabel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Button.html#v:buttonSetLabel"
        })


#endif

-- method Button::set_use_underline
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "button"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Button" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "use_underline"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "%TRUE if underlines in the text indicate mnemonics"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_button_set_use_underline" gtk_button_set_use_underline :: 
    Ptr Button ->                           -- button : TInterface (Name {namespace = "Gtk", name = "Button"})
    CInt ->                                 -- use_underline : TBasicType TBoolean
    IO ()

-- | Sets whether to use underlines as mnemonics.
-- 
-- If true, an underline in the text of the button label indicates
-- the next character should be used for the mnemonic accelerator key.
buttonSetUseUnderline ::
    (B.CallStack.HasCallStack, MonadIO m, IsButton a) =>
    a
    -- ^ /@button@/: a @GtkButton@
    -> Bool
    -- ^ /@useUnderline@/: 'P.True' if underlines in the text indicate mnemonics
    -> m ()
buttonSetUseUnderline button useUnderline = liftIO $ do
    button' <- unsafeManagedPtrCastPtr button
    let useUnderline' = (P.fromIntegral . P.fromEnum) useUnderline
    gtk_button_set_use_underline button' useUnderline'
    touchManagedPtr button
    return ()

#if defined(ENABLE_OVERLOADING)
data ButtonSetUseUnderlineMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsButton a) => O.OverloadedMethod ButtonSetUseUnderlineMethodInfo a signature where
    overloadedMethod = buttonSetUseUnderline

instance O.OverloadedMethodInfo ButtonSetUseUnderlineMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Button.buttonSetUseUnderline",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Button.html#v:buttonSetUseUnderline"
        })


#endif


