#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 209
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 121
#define ALIAS_COUNT 0
#define TOKEN_COUNT 67
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 7
#define MAX_ALIAS_SEQUENCE_LENGTH 8
#define PRODUCTION_ID_COUNT 5

enum {
  sym_identifier = 1,
  anon_sym_LF = 2,
  anon_sym_POUND = 3,
  aux_sym_comment_token1 = 4,
  sym_if = 5,
  sym_elif = 6,
  sym_else = 7,
  sym_endif = 8,
  sym_foreach = 9,
  sym_endforeach = 10,
  sym_break = 11,
  sym_continue = 12,
  sym_and = 13,
  sym_or = 14,
  sym_not = 15,
  sym_in = 16,
  sym_boolean_literal = 17,
  sym_int_literal = 18,
  anon_sym_SQUOTE = 19,
  aux_sym_string_literal_token1 = 20,
  anon_sym_SQUOTE_SQUOTE_SQUOTE = 21,
  aux_sym_string_literal_token2 = 22,
  anon_sym_f_SQUOTE = 23,
  anon_sym_f_SQUOTE_SQUOTE_SQUOTE = 24,
  anon_sym_BSLASH_BSLASH = 25,
  anon_sym_BSLASH_SQUOTE = 26,
  anon_sym_BSLASHa = 27,
  anon_sym_BSLASHb = 28,
  anon_sym_BSLASHf = 29,
  anon_sym_BSLASHn = 30,
  anon_sym_BSLASHr = 31,
  anon_sym_BSLASHt = 32,
  anon_sym_BSLASHv = 33,
  aux_sym_escape_sequence_token1 = 34,
  aux_sym_escape_sequence_token2 = 35,
  aux_sym_escape_sequence_token3 = 36,
  aux_sym_escape_sequence_token4 = 37,
  aux_sym_escape_sequence_token5 = 38,
  aux_sym_bad_escape_token1 = 39,
  anon_sym_LBRACK = 40,
  anon_sym_RBRACK = 41,
  anon_sym_COMMA = 42,
  anon_sym_LBRACE = 43,
  anon_sym_RBRACE = 44,
  anon_sym_COLON = 45,
  anon_sym_EQ = 46,
  anon_sym_STAR_EQ = 47,
  anon_sym_SLASH_EQ = 48,
  anon_sym_PERCENT_EQ = 49,
  anon_sym_PLUS_EQ = 50,
  anon_sym_DASH_EQ = 51,
  anon_sym_QMARK = 52,
  anon_sym_EQ_EQ = 53,
  anon_sym_BANG_EQ = 54,
  anon_sym_GT = 55,
  anon_sym_LT = 56,
  anon_sym_GT_EQ = 57,
  anon_sym_LT_EQ = 58,
  anon_sym_PLUS = 59,
  anon_sym_DASH = 60,
  anon_sym_STAR = 61,
  anon_sym_SLASH = 62,
  anon_sym_PERCENT = 63,
  anon_sym_LPAREN = 64,
  anon_sym_RPAREN = 65,
  anon_sym_DOT = 66,
  sym_build_definition = 67,
  sym_comment = 68,
  sym_string_literal = 69,
  sym_fstring_literal = 70,
  sym_escape_sequence = 71,
  sym_bad_escape = 72,
  sym_array_literal = 73,
  sym__expression_list = 74,
  sym_dictionary_literal = 75,
  sym_key_value_item = 76,
  sym__key_value_list = 77,
  sym__literal = 78,
  sym_statement = 79,
  sym_expression_statement = 80,
  sym_expression = 81,
  sym_assignment_statement = 82,
  sym_assignment_operator = 83,
  sym_conditional_expression = 84,
  sym_logical_or_expression = 85,
  sym_logical_and_expression = 86,
  sym_equality_operator = 87,
  sym_equality_expression = 88,
  sym_relational_operator = 89,
  sym_relational_expression = 90,
  sym_additive_operator = 91,
  sym_additive_expression = 92,
  sym_multiplicative_operator = 93,
  sym_multiplicative_expression = 94,
  sym_unary_operator = 95,
  sym_unary_expression = 96,
  sym_primary_expression = 97,
  sym_subscript_expression = 98,
  sym_function_expression = 99,
  sym__argument_list = 100,
  sym__positional_arguments = 101,
  sym_argument = 102,
  sym__keyword_arguments = 103,
  sym_keyword_argument = 104,
  sym_method_expression = 105,
  sym_selection_statement = 106,
  sym_statement_list = 107,
  sym_condition = 108,
  sym_iteration_statement = 109,
  sym_identifier_list = 110,
  aux_sym_build_definition_repeat1 = 111,
  aux_sym_string_literal_repeat1 = 112,
  aux_sym_string_literal_repeat2 = 113,
  aux_sym__expression_list_repeat1 = 114,
  aux_sym__key_value_list_repeat1 = 115,
  aux_sym__positional_arguments_repeat1 = 116,
  aux_sym__keyword_arguments_repeat1 = 117,
  aux_sym_selection_statement_repeat1 = 118,
  aux_sym_statement_list_repeat1 = 119,
  aux_sym_identifier_list_repeat1 = 120,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_LF] = "\n",
  [anon_sym_POUND] = "#",
  [aux_sym_comment_token1] = "comment_token1",
  [sym_if] = "if",
  [sym_elif] = "elif",
  [sym_else] = "else",
  [sym_endif] = "endif",
  [sym_foreach] = "foreach",
  [sym_endforeach] = "endforeach",
  [sym_break] = "break",
  [sym_continue] = "continue",
  [sym_and] = "and",
  [sym_or] = "or",
  [sym_not] = "not",
  [sym_in] = "in",
  [sym_boolean_literal] = "boolean_literal",
  [sym_int_literal] = "int_literal",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_string_literal_token1] = "string_literal_token1",
  [anon_sym_SQUOTE_SQUOTE_SQUOTE] = "'''",
  [aux_sym_string_literal_token2] = "string_literal_token2",
  [anon_sym_f_SQUOTE] = "f'",
  [anon_sym_f_SQUOTE_SQUOTE_SQUOTE] = "f'''",
  [anon_sym_BSLASH_BSLASH] = "\\\\",
  [anon_sym_BSLASH_SQUOTE] = "\\'",
  [anon_sym_BSLASHa] = "\\a",
  [anon_sym_BSLASHb] = "\\b",
  [anon_sym_BSLASHf] = "\\f",
  [anon_sym_BSLASHn] = "\\n",
  [anon_sym_BSLASHr] = "\\r",
  [anon_sym_BSLASHt] = "\\t",
  [anon_sym_BSLASHv] = "\\v",
  [aux_sym_escape_sequence_token1] = "escape_sequence_token1",
  [aux_sym_escape_sequence_token2] = "escape_sequence_token2",
  [aux_sym_escape_sequence_token3] = "escape_sequence_token3",
  [aux_sym_escape_sequence_token4] = "escape_sequence_token4",
  [aux_sym_escape_sequence_token5] = "escape_sequence_token5",
  [aux_sym_bad_escape_token1] = "bad_escape_token1",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_COMMA] = ",",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_COLON] = ":",
  [anon_sym_EQ] = "=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_QMARK] = "\?",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_GT] = ">",
  [anon_sym_LT] = "<",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_DOT] = ".",
  [sym_build_definition] = "build_definition",
  [sym_comment] = "comment",
  [sym_string_literal] = "string_literal",
  [sym_fstring_literal] = "fstring_literal",
  [sym_escape_sequence] = "escape_sequence",
  [sym_bad_escape] = "bad_escape",
  [sym_array_literal] = "array_literal",
  [sym__expression_list] = "_expression_list",
  [sym_dictionary_literal] = "dictionary_literal",
  [sym_key_value_item] = "key_value_item",
  [sym__key_value_list] = "_key_value_list",
  [sym__literal] = "_literal",
  [sym_statement] = "statement",
  [sym_expression_statement] = "expression_statement",
  [sym_expression] = "expression",
  [sym_assignment_statement] = "assignment_statement",
  [sym_assignment_operator] = "assignment_operator",
  [sym_conditional_expression] = "conditional_expression",
  [sym_logical_or_expression] = "logical_or_expression",
  [sym_logical_and_expression] = "logical_and_expression",
  [sym_equality_operator] = "equality_operator",
  [sym_equality_expression] = "equality_expression",
  [sym_relational_operator] = "relational_operator",
  [sym_relational_expression] = "relational_expression",
  [sym_additive_operator] = "additive_operator",
  [sym_additive_expression] = "additive_expression",
  [sym_multiplicative_operator] = "multiplicative_operator",
  [sym_multiplicative_expression] = "multiplicative_expression",
  [sym_unary_operator] = "unary_operator",
  [sym_unary_expression] = "unary_expression",
  [sym_primary_expression] = "primary_expression",
  [sym_subscript_expression] = "subscript_expression",
  [sym_function_expression] = "function_expression",
  [sym__argument_list] = "_argument_list",
  [sym__positional_arguments] = "_positional_arguments",
  [sym_argument] = "argument",
  [sym__keyword_arguments] = "_keyword_arguments",
  [sym_keyword_argument] = "keyword_argument",
  [sym_method_expression] = "method_expression",
  [sym_selection_statement] = "selection_statement",
  [sym_statement_list] = "statement_list",
  [sym_condition] = "condition",
  [sym_iteration_statement] = "iteration_statement",
  [sym_identifier_list] = "identifier_list",
  [aux_sym_build_definition_repeat1] = "build_definition_repeat1",
  [aux_sym_string_literal_repeat1] = "string_literal_repeat1",
  [aux_sym_string_literal_repeat2] = "string_literal_repeat2",
  [aux_sym__expression_list_repeat1] = "_expression_list_repeat1",
  [aux_sym__key_value_list_repeat1] = "_key_value_list_repeat1",
  [aux_sym__positional_arguments_repeat1] = "_positional_arguments_repeat1",
  [aux_sym__keyword_arguments_repeat1] = "_keyword_arguments_repeat1",
  [aux_sym_selection_statement_repeat1] = "selection_statement_repeat1",
  [aux_sym_statement_list_repeat1] = "statement_list_repeat1",
  [aux_sym_identifier_list_repeat1] = "identifier_list_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_POUND] = anon_sym_POUND,
  [aux_sym_comment_token1] = aux_sym_comment_token1,
  [sym_if] = sym_if,
  [sym_elif] = sym_elif,
  [sym_else] = sym_else,
  [sym_endif] = sym_endif,
  [sym_foreach] = sym_foreach,
  [sym_endforeach] = sym_endforeach,
  [sym_break] = sym_break,
  [sym_continue] = sym_continue,
  [sym_and] = sym_and,
  [sym_or] = sym_or,
  [sym_not] = sym_not,
  [sym_in] = sym_in,
  [sym_boolean_literal] = sym_boolean_literal,
  [sym_int_literal] = sym_int_literal,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_string_literal_token1] = aux_sym_string_literal_token1,
  [anon_sym_SQUOTE_SQUOTE_SQUOTE] = anon_sym_SQUOTE_SQUOTE_SQUOTE,
  [aux_sym_string_literal_token2] = aux_sym_string_literal_token2,
  [anon_sym_f_SQUOTE] = anon_sym_f_SQUOTE,
  [anon_sym_f_SQUOTE_SQUOTE_SQUOTE] = anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
  [anon_sym_BSLASH_BSLASH] = anon_sym_BSLASH_BSLASH,
  [anon_sym_BSLASH_SQUOTE] = anon_sym_BSLASH_SQUOTE,
  [anon_sym_BSLASHa] = anon_sym_BSLASHa,
  [anon_sym_BSLASHb] = anon_sym_BSLASHb,
  [anon_sym_BSLASHf] = anon_sym_BSLASHf,
  [anon_sym_BSLASHn] = anon_sym_BSLASHn,
  [anon_sym_BSLASHr] = anon_sym_BSLASHr,
  [anon_sym_BSLASHt] = anon_sym_BSLASHt,
  [anon_sym_BSLASHv] = anon_sym_BSLASHv,
  [aux_sym_escape_sequence_token1] = aux_sym_escape_sequence_token1,
  [aux_sym_escape_sequence_token2] = aux_sym_escape_sequence_token2,
  [aux_sym_escape_sequence_token3] = aux_sym_escape_sequence_token3,
  [aux_sym_escape_sequence_token4] = aux_sym_escape_sequence_token4,
  [aux_sym_escape_sequence_token5] = aux_sym_escape_sequence_token5,
  [aux_sym_bad_escape_token1] = aux_sym_bad_escape_token1,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_DOT] = anon_sym_DOT,
  [sym_build_definition] = sym_build_definition,
  [sym_comment] = sym_comment,
  [sym_string_literal] = sym_string_literal,
  [sym_fstring_literal] = sym_fstring_literal,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_bad_escape] = sym_bad_escape,
  [sym_array_literal] = sym_array_literal,
  [sym__expression_list] = sym__expression_list,
  [sym_dictionary_literal] = sym_dictionary_literal,
  [sym_key_value_item] = sym_key_value_item,
  [sym__key_value_list] = sym__key_value_list,
  [sym__literal] = sym__literal,
  [sym_statement] = sym_statement,
  [sym_expression_statement] = sym_expression_statement,
  [sym_expression] = sym_expression,
  [sym_assignment_statement] = sym_assignment_statement,
  [sym_assignment_operator] = sym_assignment_operator,
  [sym_conditional_expression] = sym_conditional_expression,
  [sym_logical_or_expression] = sym_logical_or_expression,
  [sym_logical_and_expression] = sym_logical_and_expression,
  [sym_equality_operator] = sym_equality_operator,
  [sym_equality_expression] = sym_equality_expression,
  [sym_relational_operator] = sym_relational_operator,
  [sym_relational_expression] = sym_relational_expression,
  [sym_additive_operator] = sym_additive_operator,
  [sym_additive_expression] = sym_additive_expression,
  [sym_multiplicative_operator] = sym_multiplicative_operator,
  [sym_multiplicative_expression] = sym_multiplicative_expression,
  [sym_unary_operator] = sym_unary_operator,
  [sym_unary_expression] = sym_unary_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_subscript_expression] = sym_subscript_expression,
  [sym_function_expression] = sym_function_expression,
  [sym__argument_list] = sym__argument_list,
  [sym__positional_arguments] = sym__positional_arguments,
  [sym_argument] = sym_argument,
  [sym__keyword_arguments] = sym__keyword_arguments,
  [sym_keyword_argument] = sym_keyword_argument,
  [sym_method_expression] = sym_method_expression,
  [sym_selection_statement] = sym_selection_statement,
  [sym_statement_list] = sym_statement_list,
  [sym_condition] = sym_condition,
  [sym_iteration_statement] = sym_iteration_statement,
  [sym_identifier_list] = sym_identifier_list,
  [aux_sym_build_definition_repeat1] = aux_sym_build_definition_repeat1,
  [aux_sym_string_literal_repeat1] = aux_sym_string_literal_repeat1,
  [aux_sym_string_literal_repeat2] = aux_sym_string_literal_repeat2,
  [aux_sym__expression_list_repeat1] = aux_sym__expression_list_repeat1,
  [aux_sym__key_value_list_repeat1] = aux_sym__key_value_list_repeat1,
  [aux_sym__positional_arguments_repeat1] = aux_sym__positional_arguments_repeat1,
  [aux_sym__keyword_arguments_repeat1] = aux_sym__keyword_arguments_repeat1,
  [aux_sym_selection_statement_repeat1] = aux_sym_selection_statement_repeat1,
  [aux_sym_statement_list_repeat1] = aux_sym_statement_list_repeat1,
  [aux_sym_identifier_list_repeat1] = aux_sym_identifier_list_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_comment_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_if] = {
    .visible = true,
    .named = true,
  },
  [sym_elif] = {
    .visible = true,
    .named = true,
  },
  [sym_else] = {
    .visible = true,
    .named = true,
  },
  [sym_endif] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach] = {
    .visible = true,
    .named = true,
  },
  [sym_endforeach] = {
    .visible = true,
    .named = true,
  },
  [sym_break] = {
    .visible = true,
    .named = true,
  },
  [sym_continue] = {
    .visible = true,
    .named = true,
  },
  [sym_and] = {
    .visible = true,
    .named = true,
  },
  [sym_or] = {
    .visible = true,
    .named = true,
  },
  [sym_not] = {
    .visible = true,
    .named = true,
  },
  [sym_in] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_int_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_literal_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SQUOTE_SQUOTE_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_literal_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_f_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_f_SQUOTE_SQUOTE_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHa] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHb] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHf] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHv] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_escape_sequence_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_escape_sequence_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_escape_sequence_token3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_escape_sequence_token4] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_escape_sequence_token5] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_bad_escape_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [sym_build_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_fstring_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_bad_escape] = {
    .visible = true,
    .named = true,
  },
  [sym_array_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_list] = {
    .visible = false,
    .named = true,
  },
  [sym_dictionary_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_key_value_item] = {
    .visible = true,
    .named = true,
  },
  [sym__key_value_list] = {
    .visible = false,
    .named = true,
  },
  [sym__literal] = {
    .visible = false,
    .named = true,
  },
  [sym_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_logical_or_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_logical_and_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_equality_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_equality_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_relational_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_relational_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_additive_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_additive_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_multiplicative_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_multiplicative_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_primary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_function_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__argument_list] = {
    .visible = false,
    .named = true,
  },
  [sym__positional_arguments] = {
    .visible = false,
    .named = true,
  },
  [sym_argument] = {
    .visible = true,
    .named = true,
  },
  [sym__keyword_arguments] = {
    .visible = false,
    .named = true,
  },
  [sym_keyword_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_method_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_selection_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_statement_list] = {
    .visible = true,
    .named = true,
  },
  [sym_condition] = {
    .visible = true,
    .named = true,
  },
  [sym_iteration_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier_list] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_build_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_literal_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__expression_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__key_value_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__positional_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__keyword_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_selection_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_statement_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_identifier_list_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_alternative = 1,
  field_condition = 2,
  field_consequence = 3,
  field_function = 4,
  field_key = 5,
  field_keyword = 6,
  field_value = 7,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_function] = "function",
  [field_key] = "key",
  [field_keyword] = "keyword",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 2},
  [3] = {.index = 3, .length = 1},
  [4] = {.index = 4, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_function, 0},
  [1] =
    {field_key, 0},
    {field_value, 2},
  [3] =
    {field_keyword, 0},
  [4] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 12,
  [14] = 14,
  [15] = 14,
  [16] = 16,
  [17] = 16,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 22,
  [31] = 31,
  [32] = 26,
  [33] = 27,
  [34] = 28,
  [35] = 35,
  [36] = 36,
  [37] = 24,
  [38] = 38,
  [39] = 25,
  [40] = 40,
  [41] = 31,
  [42] = 42,
  [43] = 42,
  [44] = 35,
  [45] = 23,
  [46] = 46,
  [47] = 36,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 52,
  [58] = 56,
  [59] = 54,
  [60] = 49,
  [61] = 53,
  [62] = 55,
  [63] = 51,
  [64] = 50,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 74,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 65,
  [87] = 74,
  [88] = 69,
  [89] = 89,
  [90] = 66,
  [91] = 73,
  [92] = 92,
  [93] = 81,
  [94] = 94,
  [95] = 95,
  [96] = 79,
  [97] = 97,
  [98] = 75,
  [99] = 78,
  [100] = 97,
  [101] = 95,
  [102] = 89,
  [103] = 103,
  [104] = 80,
  [105] = 76,
  [106] = 70,
  [107] = 72,
  [108] = 71,
  [109] = 68,
  [110] = 67,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 114,
  [116] = 116,
  [117] = 117,
  [118] = 116,
  [119] = 119,
  [120] = 119,
  [121] = 121,
  [122] = 117,
  [123] = 123,
  [124] = 112,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 134,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 138,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 143,
  [144] = 144,
  [145] = 145,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 149,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 140,
  [155] = 145,
  [156] = 156,
  [157] = 146,
  [158] = 158,
  [159] = 151,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 164,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 185,
  [186] = 186,
  [187] = 187,
  [188] = 188,
  [189] = 189,
  [190] = 190,
  [191] = 191,
  [192] = 192,
  [193] = 193,
  [194] = 194,
  [195] = 195,
  [196] = 196,
  [197] = 192,
  [198] = 179,
  [199] = 199,
  [200] = 200,
  [201] = 201,
  [202] = 202,
  [203] = 203,
  [204] = 204,
  [205] = 203,
  [206] = 186,
  [207] = 202,
  [208] = 208,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(31);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (lookahead == '!') ADVANCE(6);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '%') ADVANCE(94);
      if (lookahead == '\'') ADVANCE(43);
      if (lookahead == '(') ADVANCE(95);
      if (lookahead == ')') ADVANCE(96);
      if (lookahead == '*') ADVANCE(92);
      if (lookahead == '+') ADVANCE(90);
      if (lookahead == ',') ADVANCE(71);
      if (lookahead == '-') ADVANCE(91);
      if (lookahead == '.') ADVANCE(97);
      if (lookahead == '/') ADVANCE(93);
      if (lookahead == '0') ADVANCE(37);
      if (lookahead == ':') ADVANCE(74);
      if (lookahead == '<') ADVANCE(87);
      if (lookahead == '=') ADVANCE(77);
      if (lookahead == '>') ADVANCE(86);
      if (lookahead == '?') ADVANCE(83);
      if (lookahead == '[') ADVANCE(69);
      if (lookahead == '\\') ADVANCE(1);
      if (lookahead == ']') ADVANCE(70);
      if (lookahead == 'f') ADVANCE(75);
      if (lookahead == '{') ADVANCE(72);
      if (lookahead == '}') ADVANCE(73);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(40);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(76);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(10)
      if (lookahead == '\'') ADVANCE(53);
      if (lookahead == 'N') ADVANCE(7);
      if (lookahead == 'U') ADVANCE(27);
      if (lookahead == '\\') ADVANCE(52);
      if (lookahead == 'a') ADVANCE(54);
      if (lookahead == 'b') ADVANCE(55);
      if (lookahead == 'f') ADVANCE(56);
      if (lookahead == 'n') ADVANCE(57);
      if (lookahead == 'r') ADVANCE(58);
      if (lookahead == 't') ADVANCE(59);
      if (lookahead == 'u') ADVANCE(22);
      if (lookahead == 'v') ADVANCE(60);
      if (lookahead == 'x') ADVANCE(17);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(66);
      if (lookahead != 0) ADVANCE(68);
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(11)
      if (lookahead == '\'') ADVANCE(53);
      if (lookahead == 'N') ADVANCE(7);
      if (lookahead == 'U') ADVANCE(27);
      if (lookahead == '\\') ADVANCE(52);
      if (lookahead == 'a') ADVANCE(54);
      if (lookahead == 'b') ADVANCE(55);
      if (lookahead == 'f') ADVANCE(56);
      if (lookahead == 'n') ADVANCE(57);
      if (lookahead == 'r') ADVANCE(58);
      if (lookahead == 't') ADVANCE(59);
      if (lookahead == 'u') ADVANCE(22);
      if (lookahead == 'v') ADVANCE(60);
      if (lookahead == 'x') ADVANCE(17);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(66);
      if (lookahead != 0) ADVANCE(68);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(3)
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '\'') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(47);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(48);
      if (lookahead != 0) ADVANCE(47);
      END_STATE();
    case 4:
      if (lookahead == '\'') ADVANCE(46);
      END_STATE();
    case 5:
      if (lookahead == '\'') ADVANCE(51);
      END_STATE();
    case 6:
      if (lookahead == '=') ADVANCE(85);
      END_STATE();
    case 7:
      if (lookahead == '{') ADVANCE(28);
      END_STATE();
    case 8:
      if (lookahead == '}') ADVANCE(67);
      if (lookahead == ' ' ||
          lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(8);
      END_STATE();
    case 9:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(38);
      END_STATE();
    case 10:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(10)
      if (lookahead == '!') ADVANCE(6);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '%') ADVANCE(94);
      if (lookahead == '\'') ADVANCE(43);
      if (lookahead == '(') ADVANCE(95);
      if (lookahead == ')') ADVANCE(96);
      if (lookahead == '*') ADVANCE(92);
      if (lookahead == '+') ADVANCE(90);
      if (lookahead == ',') ADVANCE(71);
      if (lookahead == '-') ADVANCE(91);
      if (lookahead == '.') ADVANCE(97);
      if (lookahead == '/') ADVANCE(93);
      if (lookahead == '0') ADVANCE(37);
      if (lookahead == ':') ADVANCE(74);
      if (lookahead == '<') ADVANCE(87);
      if (lookahead == '=') ADVANCE(77);
      if (lookahead == '>') ADVANCE(86);
      if (lookahead == '?') ADVANCE(83);
      if (lookahead == '[') ADVANCE(69);
      if (lookahead == '\\') ADVANCE(1);
      if (lookahead == ']') ADVANCE(70);
      if (lookahead == 'f') ADVANCE(75);
      if (lookahead == '{') ADVANCE(72);
      if (lookahead == '}') ADVANCE(73);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(40);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(76);
      END_STATE();
    case 11:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(45);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '\'') ADVANCE(42);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead != 0) ADVANCE(44);
      END_STATE();
    case 12:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(39);
      END_STATE();
    case 13:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(41);
      END_STATE();
    case 14:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(61);
      END_STATE();
    case 15:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(62);
      END_STATE();
    case 16:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(63);
      END_STATE();
    case 17:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(14);
      END_STATE();
    case 18:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(15);
      END_STATE();
    case 19:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(16);
      END_STATE();
    case 20:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(18);
      END_STATE();
    case 21:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(19);
      END_STATE();
    case 22:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(20);
      END_STATE();
    case 23:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(21);
      END_STATE();
    case 24:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(23);
      END_STATE();
    case 25:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(24);
      END_STATE();
    case 26:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(25);
      END_STATE();
    case 27:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(26);
      END_STATE();
    case 28:
      if (lookahead == ' ' ||
          lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(8);
      END_STATE();
    case 29:
      if (eof) ADVANCE(31);
      if (lookahead == '\n') SKIP(30)
      END_STATE();
    case 30:
      if (eof) ADVANCE(31);
      if (lookahead == '\n') ADVANCE(32);
      if (lookahead == '!') ADVANCE(6);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '%') ADVANCE(94);
      if (lookahead == '\'') ADVANCE(43);
      if (lookahead == '(') ADVANCE(95);
      if (lookahead == '*') ADVANCE(92);
      if (lookahead == '+') ADVANCE(90);
      if (lookahead == '-') ADVANCE(91);
      if (lookahead == '.') ADVANCE(97);
      if (lookahead == '/') ADVANCE(93);
      if (lookahead == '0') ADVANCE(37);
      if (lookahead == '<') ADVANCE(87);
      if (lookahead == '=') ADVANCE(77);
      if (lookahead == '>') ADVANCE(86);
      if (lookahead == '?') ADVANCE(83);
      if (lookahead == '[') ADVANCE(69);
      if (lookahead == '\\') SKIP(29)
      if (lookahead == 'f') ADVANCE(75);
      if (lookahead == '{') ADVANCE(72);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(30)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(40);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(76);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(32);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(36);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '\\') ADVANCE(36);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(35);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(36);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(36);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(9);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(12);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(13);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(38);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(sym_int_literal);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(39);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(sym_int_literal);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(40);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(sym_int_literal);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(41);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      if (lookahead == '\'') ADVANCE(4);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(aux_sym_string_literal_token1);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(45);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(44);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_SQUOTE_SQUOTE_SQUOTE);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(aux_sym_string_literal_token2);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(aux_sym_string_literal_token2);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '\'') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(47);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(48);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(47);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(aux_sym_string_literal_token2);
      if (lookahead == '\'') ADVANCE(4);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_f_SQUOTE);
      if (lookahead == '\'') ADVANCE(5);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_f_SQUOTE_SQUOTE_SQUOTE);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_BSLASH_BSLASH);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_BSLASH_SQUOTE);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_BSLASHa);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_BSLASHb);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_BSLASHf);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_BSLASHn);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_BSLASHr);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_BSLASHt);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_BSLASHv);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(aux_sym_escape_sequence_token1);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(aux_sym_escape_sequence_token2);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(aux_sym_escape_sequence_token3);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(aux_sym_escape_sequence_token4);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(aux_sym_escape_sequence_token4);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(64);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(aux_sym_escape_sequence_token4);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(65);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(aux_sym_escape_sequence_token5);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(aux_sym_bad_escape_token1);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\'') ADVANCE(50);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(76);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(76);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(84);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(88);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(89);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(81);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(82);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(78);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '=') ADVANCE(79);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(80);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (lookahead == '\\') SKIP(1)
      if (lookahead == 'a') ADVANCE(2);
      if (lookahead == 'b') ADVANCE(3);
      if (lookahead == 'c') ADVANCE(4);
      if (lookahead == 'e') ADVANCE(5);
      if (lookahead == 'f') ADVANCE(6);
      if (lookahead == 'i') ADVANCE(7);
      if (lookahead == 'n') ADVANCE(8);
      if (lookahead == 'o') ADVANCE(9);
      if (lookahead == 't') ADVANCE(10);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(0)
      END_STATE();
    case 2:
      if (lookahead == 'n') ADVANCE(11);
      END_STATE();
    case 3:
      if (lookahead == 'r') ADVANCE(12);
      END_STATE();
    case 4:
      if (lookahead == 'o') ADVANCE(13);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(14);
      if (lookahead == 'n') ADVANCE(15);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(16);
      if (lookahead == 'o') ADVANCE(17);
      END_STATE();
    case 7:
      if (lookahead == 'f') ADVANCE(18);
      if (lookahead == 'n') ADVANCE(19);
      END_STATE();
    case 8:
      if (lookahead == 'o') ADVANCE(20);
      END_STATE();
    case 9:
      if (lookahead == 'r') ADVANCE(21);
      END_STATE();
    case 10:
      if (lookahead == 'r') ADVANCE(22);
      END_STATE();
    case 11:
      if (lookahead == 'd') ADVANCE(23);
      END_STATE();
    case 12:
      if (lookahead == 'e') ADVANCE(24);
      END_STATE();
    case 13:
      if (lookahead == 'n') ADVANCE(25);
      END_STATE();
    case 14:
      if (lookahead == 'i') ADVANCE(26);
      if (lookahead == 's') ADVANCE(27);
      END_STATE();
    case 15:
      if (lookahead == 'd') ADVANCE(28);
      END_STATE();
    case 16:
      if (lookahead == 'l') ADVANCE(29);
      END_STATE();
    case 17:
      if (lookahead == 'r') ADVANCE(30);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(sym_if);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(sym_in);
      END_STATE();
    case 20:
      if (lookahead == 't') ADVANCE(31);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(sym_or);
      END_STATE();
    case 22:
      if (lookahead == 'u') ADVANCE(32);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(sym_and);
      END_STATE();
    case 24:
      if (lookahead == 'a') ADVANCE(33);
      END_STATE();
    case 25:
      if (lookahead == 't') ADVANCE(34);
      END_STATE();
    case 26:
      if (lookahead == 'f') ADVANCE(35);
      END_STATE();
    case 27:
      if (lookahead == 'e') ADVANCE(36);
      END_STATE();
    case 28:
      if (lookahead == 'f') ADVANCE(37);
      if (lookahead == 'i') ADVANCE(38);
      END_STATE();
    case 29:
      if (lookahead == 's') ADVANCE(39);
      END_STATE();
    case 30:
      if (lookahead == 'e') ADVANCE(40);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(sym_not);
      END_STATE();
    case 32:
      if (lookahead == 'e') ADVANCE(41);
      END_STATE();
    case 33:
      if (lookahead == 'k') ADVANCE(42);
      END_STATE();
    case 34:
      if (lookahead == 'i') ADVANCE(43);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(sym_elif);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(sym_else);
      END_STATE();
    case 37:
      if (lookahead == 'o') ADVANCE(44);
      END_STATE();
    case 38:
      if (lookahead == 'f') ADVANCE(45);
      END_STATE();
    case 39:
      if (lookahead == 'e') ADVANCE(41);
      END_STATE();
    case 40:
      if (lookahead == 'a') ADVANCE(46);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(sym_boolean_literal);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(sym_break);
      END_STATE();
    case 43:
      if (lookahead == 'n') ADVANCE(47);
      END_STATE();
    case 44:
      if (lookahead == 'r') ADVANCE(48);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(sym_endif);
      END_STATE();
    case 46:
      if (lookahead == 'c') ADVANCE(49);
      END_STATE();
    case 47:
      if (lookahead == 'u') ADVANCE(50);
      END_STATE();
    case 48:
      if (lookahead == 'e') ADVANCE(51);
      END_STATE();
    case 49:
      if (lookahead == 'h') ADVANCE(52);
      END_STATE();
    case 50:
      if (lookahead == 'e') ADVANCE(53);
      END_STATE();
    case 51:
      if (lookahead == 'a') ADVANCE(54);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(sym_foreach);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(sym_continue);
      END_STATE();
    case 54:
      if (lookahead == 'c') ADVANCE(55);
      END_STATE();
    case 55:
      if (lookahead == 'h') ADVANCE(56);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(sym_endforeach);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 30},
  [2] = {.lex_state = 0},
  [3] = {.lex_state = 0},
  [4] = {.lex_state = 0},
  [5] = {.lex_state = 0},
  [6] = {.lex_state = 30},
  [7] = {.lex_state = 0},
  [8] = {.lex_state = 0},
  [9] = {.lex_state = 0},
  [10] = {.lex_state = 0},
  [11] = {.lex_state = 30},
  [12] = {.lex_state = 0},
  [13] = {.lex_state = 0},
  [14] = {.lex_state = 0},
  [15] = {.lex_state = 0},
  [16] = {.lex_state = 0},
  [17] = {.lex_state = 0},
  [18] = {.lex_state = 0},
  [19] = {.lex_state = 0},
  [20] = {.lex_state = 0},
  [21] = {.lex_state = 0},
  [22] = {.lex_state = 0},
  [23] = {.lex_state = 0},
  [24] = {.lex_state = 0},
  [25] = {.lex_state = 0},
  [26] = {.lex_state = 0},
  [27] = {.lex_state = 0},
  [28] = {.lex_state = 0},
  [29] = {.lex_state = 0},
  [30] = {.lex_state = 0},
  [31] = {.lex_state = 0},
  [32] = {.lex_state = 0},
  [33] = {.lex_state = 0},
  [34] = {.lex_state = 0},
  [35] = {.lex_state = 0},
  [36] = {.lex_state = 0},
  [37] = {.lex_state = 0},
  [38] = {.lex_state = 0},
  [39] = {.lex_state = 0},
  [40] = {.lex_state = 0},
  [41] = {.lex_state = 0},
  [42] = {.lex_state = 0},
  [43] = {.lex_state = 0},
  [44] = {.lex_state = 0},
  [45] = {.lex_state = 0},
  [46] = {.lex_state = 0},
  [47] = {.lex_state = 0},
  [48] = {.lex_state = 30},
  [49] = {.lex_state = 30},
  [50] = {.lex_state = 30},
  [51] = {.lex_state = 30},
  [52] = {.lex_state = 30},
  [53] = {.lex_state = 30},
  [54] = {.lex_state = 30},
  [55] = {.lex_state = 30},
  [56] = {.lex_state = 30},
  [57] = {.lex_state = 0},
  [58] = {.lex_state = 0},
  [59] = {.lex_state = 0},
  [60] = {.lex_state = 0},
  [61] = {.lex_state = 0},
  [62] = {.lex_state = 0},
  [63] = {.lex_state = 0},
  [64] = {.lex_state = 0},
  [65] = {.lex_state = 30},
  [66] = {.lex_state = 30},
  [67] = {.lex_state = 30},
  [68] = {.lex_state = 30},
  [69] = {.lex_state = 30},
  [70] = {.lex_state = 30},
  [71] = {.lex_state = 30},
  [72] = {.lex_state = 30},
  [73] = {.lex_state = 30},
  [74] = {.lex_state = 30},
  [75] = {.lex_state = 30},
  [76] = {.lex_state = 30},
  [77] = {.lex_state = 0},
  [78] = {.lex_state = 30},
  [79] = {.lex_state = 30},
  [80] = {.lex_state = 30},
  [81] = {.lex_state = 30},
  [82] = {.lex_state = 0},
  [83] = {.lex_state = 0},
  [84] = {.lex_state = 0},
  [85] = {.lex_state = 0},
  [86] = {.lex_state = 0},
  [87] = {.lex_state = 0},
  [88] = {.lex_state = 0},
  [89] = {.lex_state = 0},
  [90] = {.lex_state = 0},
  [91] = {.lex_state = 0},
  [92] = {.lex_state = 30},
  [93] = {.lex_state = 0},
  [94] = {.lex_state = 0},
  [95] = {.lex_state = 0},
  [96] = {.lex_state = 0},
  [97] = {.lex_state = 0},
  [98] = {.lex_state = 0},
  [99] = {.lex_state = 0},
  [100] = {.lex_state = 0},
  [101] = {.lex_state = 0},
  [102] = {.lex_state = 0},
  [103] = {.lex_state = 30},
  [104] = {.lex_state = 0},
  [105] = {.lex_state = 0},
  [106] = {.lex_state = 0},
  [107] = {.lex_state = 0},
  [108] = {.lex_state = 0},
  [109] = {.lex_state = 0},
  [110] = {.lex_state = 0},
  [111] = {.lex_state = 0},
  [112] = {.lex_state = 0},
  [113] = {.lex_state = 0},
  [114] = {.lex_state = 11},
  [115] = {.lex_state = 11},
  [116] = {.lex_state = 11},
  [117] = {.lex_state = 11},
  [118] = {.lex_state = 11},
  [119] = {.lex_state = 11},
  [120] = {.lex_state = 11},
  [121] = {.lex_state = 11},
  [122] = {.lex_state = 11},
  [123] = {.lex_state = 30},
  [124] = {.lex_state = 30},
  [125] = {.lex_state = 11},
  [126] = {.lex_state = 11},
  [127] = {.lex_state = 11},
  [128] = {.lex_state = 0},
  [129] = {.lex_state = 0},
  [130] = {.lex_state = 0},
  [131] = {.lex_state = 0},
  [132] = {.lex_state = 0},
  [133] = {.lex_state = 0},
  [134] = {.lex_state = 0},
  [135] = {.lex_state = 0},
  [136] = {.lex_state = 0},
  [137] = {.lex_state = 0},
  [138] = {.lex_state = 0},
  [139] = {.lex_state = 0},
  [140] = {.lex_state = 3},
  [141] = {.lex_state = 0},
  [142] = {.lex_state = 0},
  [143] = {.lex_state = 0},
  [144] = {.lex_state = 0},
  [145] = {.lex_state = 3},
  [146] = {.lex_state = 3},
  [147] = {.lex_state = 0},
  [148] = {.lex_state = 0},
  [149] = {.lex_state = 0},
  [150] = {.lex_state = 0},
  [151] = {.lex_state = 3},
  [152] = {.lex_state = 0},
  [153] = {.lex_state = 0},
  [154] = {.lex_state = 3},
  [155] = {.lex_state = 3},
  [156] = {.lex_state = 0},
  [157] = {.lex_state = 3},
  [158] = {.lex_state = 3},
  [159] = {.lex_state = 3},
  [160] = {.lex_state = 0},
  [161] = {.lex_state = 0},
  [162] = {.lex_state = 0},
  [163] = {.lex_state = 0},
  [164] = {.lex_state = 0},
  [165] = {.lex_state = 0},
  [166] = {.lex_state = 0},
  [167] = {.lex_state = 3},
  [168] = {.lex_state = 0},
  [169] = {.lex_state = 0},
  [170] = {.lex_state = 0},
  [171] = {.lex_state = 0},
  [172] = {.lex_state = 0},
  [173] = {.lex_state = 0},
  [174] = {.lex_state = 0},
  [175] = {.lex_state = 0},
  [176] = {.lex_state = 0},
  [177] = {.lex_state = 0},
  [178] = {.lex_state = 30},
  [179] = {.lex_state = 0},
  [180] = {.lex_state = 30},
  [181] = {.lex_state = 30},
  [182] = {.lex_state = 0},
  [183] = {.lex_state = 0},
  [184] = {.lex_state = 0},
  [185] = {.lex_state = 0},
  [186] = {.lex_state = 30},
  [187] = {.lex_state = 30},
  [188] = {.lex_state = 30},
  [189] = {.lex_state = 30},
  [190] = {.lex_state = 30},
  [191] = {.lex_state = 30},
  [192] = {.lex_state = 0},
  [193] = {.lex_state = 0},
  [194] = {.lex_state = 0},
  [195] = {.lex_state = 30},
  [196] = {.lex_state = 30},
  [197] = {.lex_state = 0},
  [198] = {.lex_state = 0},
  [199] = {.lex_state = 35},
  [200] = {.lex_state = 30},
  [201] = {.lex_state = 0},
  [202] = {.lex_state = 0},
  [203] = {.lex_state = 0},
  [204] = {.lex_state = 0},
  [205] = {.lex_state = 0},
  [206] = {.lex_state = 30},
  [207] = {.lex_state = 0},
  [208] = {(TSStateId)(-1)},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_comment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(3),
    [sym_if] = ACTIONS(1),
    [sym_elif] = ACTIONS(1),
    [sym_else] = ACTIONS(1),
    [sym_endif] = ACTIONS(1),
    [sym_foreach] = ACTIONS(1),
    [sym_endforeach] = ACTIONS(1),
    [sym_break] = ACTIONS(1),
    [sym_continue] = ACTIONS(1),
    [sym_and] = ACTIONS(1),
    [sym_or] = ACTIONS(1),
    [sym_not] = ACTIONS(1),
    [sym_in] = ACTIONS(1),
    [sym_boolean_literal] = ACTIONS(1),
    [sym_int_literal] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(1),
    [anon_sym_f_SQUOTE] = ACTIONS(1),
    [anon_sym_f_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(1),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(1),
    [anon_sym_BSLASH_SQUOTE] = ACTIONS(1),
    [anon_sym_BSLASHa] = ACTIONS(1),
    [anon_sym_BSLASHb] = ACTIONS(1),
    [anon_sym_BSLASHf] = ACTIONS(1),
    [anon_sym_BSLASHn] = ACTIONS(1),
    [anon_sym_BSLASHr] = ACTIONS(1),
    [anon_sym_BSLASHt] = ACTIONS(1),
    [anon_sym_BSLASHv] = ACTIONS(1),
    [aux_sym_escape_sequence_token1] = ACTIONS(1),
    [aux_sym_escape_sequence_token2] = ACTIONS(1),
    [aux_sym_escape_sequence_token3] = ACTIONS(1),
    [aux_sym_escape_sequence_token4] = ACTIONS(1),
    [aux_sym_escape_sequence_token5] = ACTIONS(1),
    [aux_sym_bad_escape_token1] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
  },
  [1] = {
    [sym_build_definition] = STATE(182),
    [sym_comment] = STATE(1),
    [sym_string_literal] = STATE(67),
    [sym_fstring_literal] = STATE(67),
    [sym_array_literal] = STATE(67),
    [sym_dictionary_literal] = STATE(67),
    [sym__literal] = STATE(74),
    [sym_statement] = STATE(123),
    [sym_expression_statement] = STATE(206),
    [sym_expression] = STATE(48),
    [sym_assignment_statement] = STATE(206),
    [sym_conditional_expression] = STATE(74),
    [sym_logical_or_expression] = STATE(74),
    [sym_logical_and_expression] = STATE(74),
    [sym_equality_expression] = STATE(74),
    [sym_relational_expression] = STATE(74),
    [sym_additive_expression] = STATE(74),
    [sym_multiplicative_expression] = STATE(74),
    [sym_unary_operator] = STATE(24),
    [sym_unary_expression] = STATE(74),
    [sym_primary_expression] = STATE(74),
    [sym_subscript_expression] = STATE(74),
    [sym_function_expression] = STATE(74),
    [sym_method_expression] = STATE(74),
    [sym_selection_statement] = STATE(206),
    [sym_iteration_statement] = STATE(206),
    [aux_sym_build_definition_repeat1] = STATE(11),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_LF] = ACTIONS(9),
    [anon_sym_POUND] = ACTIONS(11),
    [sym_if] = ACTIONS(13),
    [sym_foreach] = ACTIONS(15),
    [sym_break] = ACTIONS(17),
    [sym_continue] = ACTIONS(17),
    [sym_not] = ACTIONS(19),
    [sym_boolean_literal] = ACTIONS(21),
    [sym_int_literal] = ACTIONS(21),
    [anon_sym_SQUOTE] = ACTIONS(23),
    [anon_sym_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(25),
    [anon_sym_f_SQUOTE] = ACTIONS(27),
    [anon_sym_f_SQUOTE_SQUOTE_SQUOTE] = ACTIONS(29),
    [anon_sym_LBRACK] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_PLUS] = ACTIONS(19),
    [anon_sym_DASH] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(35),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 29,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      sym_if,
    ACTIONS(15), 1,
      sym_foreach,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(21), 1,
      sym_boolean_literal,
    ACTIONS(23), 1,
      anon_sym_SQUOTE,
    ACTIONS(27), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(37), 1,
      sym_elif,
    ACTIONS(39), 1,
      sym_else,
    ACTIONS(41), 1,
      sym_endif,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_LBRACK,
    ACTIONS(53), 1,
      anon_sym_LBRACE,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    STATE(2), 1,
      sym_comment,
    STATE(5), 1,
      aux_sym_statement_list_repeat1,
    STATE(24), 1,
      sym_unary_operator,
    STATE(48), 1,
      sym_expression,
    STATE(113), 1,
      sym_statement,
    STATE(137), 1,
      sym_statement_list,
    STATE(138), 1,
      aux_sym_selection_statement_repeat1,
    ACTIONS(43), 2,
      sym_break,
      sym_continue,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(67), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(186), 4,
      sym_expression_statement,
      sym_assignment_statement,
      sym_selection_statement,
      sym_iteration_statement,
    STATE(74), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [108] = 26,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      sym_if,
    ACTIONS(15), 1,
      sym_foreach,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(21), 1,
      sym_boolean_literal,
    ACTIONS(23), 1,
      anon_sym_SQUOTE,
    ACTIONS(27), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_LBRACK,
    ACTIONS(53), 1,
      anon_sym_LBRACE,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    STATE(3), 1,
      sym_comment,
    STATE(5), 1,
      aux_sym_statement_list_repeat1,
    STATE(24), 1,
      sym_unary_operator,
    STATE(48), 1,
      sym_expression,
    STATE(113), 1,
      sym_statement,
    STATE(148), 1,
      sym_statement_list,
    ACTIONS(43), 2,
      sym_break,
      sym_continue,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(59), 3,
      sym_elif,
      sym_else,
      sym_endif,
    STATE(67), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(186), 4,
      sym_expression_statement,
      sym_assignment_statement,
      sym_selection_statement,
      sym_iteration_statement,
    STATE(74), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [209] = 24,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(61), 1,
      sym_identifier,
    ACTIONS(64), 1,
      sym_if,
    ACTIONS(69), 1,
      sym_foreach,
    ACTIONS(75), 1,
      sym_not,
    ACTIONS(78), 1,
      sym_boolean_literal,
    ACTIONS(81), 1,
      sym_int_literal,
    ACTIONS(84), 1,
      anon_sym_SQUOTE,
    ACTIONS(87), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(90), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(93), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(96), 1,
      anon_sym_LBRACK,
    ACTIONS(99), 1,
      anon_sym_LBRACE,
    ACTIONS(105), 1,
      anon_sym_LPAREN,
    STATE(24), 1,
      sym_unary_operator,
    STATE(48), 1,
      sym_expression,
    STATE(113), 1,
      sym_statement,
    ACTIONS(72), 2,
      sym_break,
      sym_continue,
    ACTIONS(102), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(4), 2,
      sym_comment,
      aux_sym_statement_list_repeat1,
    ACTIONS(67), 4,
      sym_elif,
      sym_else,
      sym_endif,
      sym_endforeach,
    STATE(67), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(186), 4,
      sym_expression_statement,
      sym_assignment_statement,
      sym_selection_statement,
      sym_iteration_statement,
    STATE(74), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [306] = 25,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      sym_if,
    ACTIONS(15), 1,
      sym_foreach,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(21), 1,
      sym_boolean_literal,
    ACTIONS(23), 1,
      anon_sym_SQUOTE,
    ACTIONS(27), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_LBRACK,
    ACTIONS(53), 1,
      anon_sym_LBRACE,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    STATE(4), 1,
      aux_sym_statement_list_repeat1,
    STATE(5), 1,
      sym_comment,
    STATE(24), 1,
      sym_unary_operator,
    STATE(48), 1,
      sym_expression,
    STATE(113), 1,
      sym_statement,
    ACTIONS(43), 2,
      sym_break,
      sym_continue,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(108), 4,
      sym_elif,
      sym_else,
      sym_endif,
      sym_endforeach,
    STATE(67), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(186), 4,
      sym_expression_statement,
      sym_assignment_statement,
      sym_selection_statement,
      sym_iteration_statement,
    STATE(74), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [405] = 23,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(110), 1,
      ts_builtin_sym_end,
    ACTIONS(112), 1,
      sym_identifier,
    ACTIONS(115), 1,
      anon_sym_LF,
    ACTIONS(118), 1,
      sym_if,
    ACTIONS(121), 1,
      sym_foreach,
    ACTIONS(133), 1,
      anon_sym_SQUOTE,
    ACTIONS(136), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(139), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(142), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(145), 1,
      anon_sym_LBRACK,
    ACTIONS(148), 1,
      anon_sym_LBRACE,
    ACTIONS(151), 1,
      anon_sym_LPAREN,
    STATE(24), 1,
      sym_unary_operator,
    STATE(48), 1,
      sym_expression,
    STATE(123), 1,
      sym_statement,
    ACTIONS(124), 2,
      sym_break,
      sym_continue,
    ACTIONS(130), 2,
      sym_boolean_literal,
      sym_int_literal,
    STATE(6), 2,
      sym_comment,
      aux_sym_build_definition_repeat1,
    ACTIONS(127), 3,
      sym_not,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(67), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(206), 4,
      sym_expression_statement,
      sym_assignment_statement,
      sym_selection_statement,
      sym_iteration_statement,
    STATE(74), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [498] = 26,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      sym_if,
    ACTIONS(15), 1,
      sym_foreach,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(21), 1,
      sym_boolean_literal,
    ACTIONS(23), 1,
      anon_sym_SQUOTE,
    ACTIONS(27), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_LBRACK,
    ACTIONS(53), 1,
      anon_sym_LBRACE,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    ACTIONS(154), 1,
      sym_endif,
    STATE(5), 1,
      aux_sym_statement_list_repeat1,
    STATE(7), 1,
      sym_comment,
    STATE(24), 1,
      sym_unary_operator,
    STATE(48), 1,
      sym_expression,
    STATE(113), 1,
      sym_statement,
    STATE(201), 1,
      sym_statement_list,
    ACTIONS(43), 2,
      sym_break,
      sym_continue,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(67), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(186), 4,
      sym_expression_statement,
      sym_assignment_statement,
      sym_selection_statement,
      sym_iteration_statement,
    STATE(74), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [597] = 26,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      sym_if,
    ACTIONS(15), 1,
      sym_foreach,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(21), 1,
      sym_boolean_literal,
    ACTIONS(23), 1,
      anon_sym_SQUOTE,
    ACTIONS(27), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_LBRACK,
    ACTIONS(53), 1,
      anon_sym_LBRACE,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    ACTIONS(156), 1,
      sym_endif,
    STATE(5), 1,
      aux_sym_statement_list_repeat1,
    STATE(8), 1,
      sym_comment,
    STATE(24), 1,
      sym_unary_operator,
    STATE(48), 1,
      sym_expression,
    STATE(113), 1,
      sym_statement,
    STATE(174), 1,
      sym_statement_list,
    ACTIONS(43), 2,
      sym_break,
      sym_continue,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(67), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(186), 4,
      sym_expression_statement,
      sym_assignment_statement,
      sym_selection_statement,
      sym_iteration_statement,
    STATE(74), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [696] = 26,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      sym_if,
    ACTIONS(15), 1,
      sym_foreach,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(21), 1,
      sym_boolean_literal,
    ACTIONS(23), 1,
      anon_sym_SQUOTE,
    ACTIONS(27), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_LBRACK,
    ACTIONS(53), 1,
      anon_sym_LBRACE,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    ACTIONS(158), 1,
      sym_endif,
    STATE(5), 1,
      aux_sym_statement_list_repeat1,
    STATE(9), 1,
      sym_comment,
    STATE(24), 1,
      sym_unary_operator,
    STATE(48), 1,
      sym_expression,
    STATE(113), 1,
      sym_statement,
    STATE(176), 1,
      sym_statement_list,
    ACTIONS(43), 2,
      sym_break,
      sym_continue,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(67), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(186), 4,
      sym_expression_statement,
      sym_assignment_statement,
      sym_selection_statement,
      sym_iteration_statement,
    STATE(74), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [795] = 26,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(13), 1,
      sym_if,
    ACTIONS(15), 1,
      sym_foreach,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(21), 1,
      sym_boolean_literal,
    ACTIONS(23), 1,
      anon_sym_SQUOTE,
    ACTIONS(27), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_LBRACK,
    ACTIONS(53), 1,
      anon_sym_LBRACE,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    ACTIONS(160), 1,
      sym_endforeach,
    STATE(5), 1,
      aux_sym_statement_list_repeat1,
    STATE(10), 1,
      sym_comment,
    STATE(24), 1,
      sym_unary_operator,
    STATE(48), 1,
      sym_expression,
    STATE(113), 1,
      sym_statement,
    STATE(194), 1,
      sym_statement_list,
    ACTIONS(43), 2,
      sym_break,
      sym_continue,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(67), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(186), 4,
      sym_expression_statement,
      sym_assignment_statement,
      sym_selection_statement,
      sym_iteration_statement,
    STATE(74), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [894] = 24,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      anon_sym_LF,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(13), 1,
      sym_if,
    ACTIONS(15), 1,
      sym_foreach,
    ACTIONS(23), 1,
      anon_sym_SQUOTE,
    ACTIONS(25), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(27), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(29), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(33), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      anon_sym_LPAREN,
    ACTIONS(162), 1,
      ts_builtin_sym_end,
    STATE(6), 1,
      aux_sym_build_definition_repeat1,
    STATE(11), 1,
      sym_comment,
    STATE(24), 1,
      sym_unary_operator,
    STATE(48), 1,
      sym_expression,
    STATE(123), 1,
      sym_statement,
    ACTIONS(17), 2,
      sym_break,
      sym_continue,
    ACTIONS(21), 2,
      sym_boolean_literal,
      sym_int_literal,
    ACTIONS(19), 3,
      sym_not,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(67), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(206), 4,
      sym_expression_statement,
      sym_assignment_statement,
      sym_selection_statement,
      sym_iteration_statement,
    STATE(74), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [989] = 24,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(164), 1,
      sym_identifier,
    ACTIONS(166), 1,
      sym_boolean_literal,
    ACTIONS(168), 1,
      sym_int_literal,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(172), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(174), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(176), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(178), 1,
      anon_sym_LBRACK,
    ACTIONS(180), 1,
      anon_sym_LBRACE,
    ACTIONS(182), 1,
      anon_sym_LPAREN,
    ACTIONS(184), 1,
      anon_sym_RPAREN,
    STATE(12), 1,
      sym_comment,
    STATE(37), 1,
      sym_unary_operator,
    STATE(85), 1,
      sym_expression,
    STATE(160), 1,
      sym_keyword_argument,
    STATE(161), 1,
      sym_argument,
    STATE(166), 1,
      sym__positional_arguments,
    STATE(202), 1,
      sym__argument_list,
    STATE(204), 1,
      sym__keyword_arguments,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(110), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(87), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [1078] = 24,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(164), 1,
      sym_identifier,
    ACTIONS(166), 1,
      sym_boolean_literal,
    ACTIONS(168), 1,
      sym_int_literal,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(172), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(174), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(176), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(178), 1,
      anon_sym_LBRACK,
    ACTIONS(180), 1,
      anon_sym_LBRACE,
    ACTIONS(182), 1,
      anon_sym_LPAREN,
    ACTIONS(186), 1,
      anon_sym_RPAREN,
    STATE(13), 1,
      sym_comment,
    STATE(37), 1,
      sym_unary_operator,
    STATE(85), 1,
      sym_expression,
    STATE(160), 1,
      sym_keyword_argument,
    STATE(161), 1,
      sym_argument,
    STATE(166), 1,
      sym__positional_arguments,
    STATE(204), 1,
      sym__keyword_arguments,
    STATE(207), 1,
      sym__argument_list,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(110), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(87), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [1167] = 21,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(166), 1,
      sym_boolean_literal,
    ACTIONS(168), 1,
      sym_int_literal,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(172), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(174), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(176), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(178), 1,
      anon_sym_LBRACK,
    ACTIONS(180), 1,
      anon_sym_LBRACE,
    ACTIONS(182), 1,
      anon_sym_LPAREN,
    ACTIONS(188), 1,
      sym_identifier,
    ACTIONS(190), 1,
      anon_sym_RBRACE,
    STATE(14), 1,
      sym_comment,
    STATE(37), 1,
      sym_unary_operator,
    STATE(94), 1,
      sym_expression,
    STATE(139), 1,
      sym_key_value_item,
    STATE(198), 1,
      sym__key_value_list,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(110), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(87), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [1247] = 21,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(166), 1,
      sym_boolean_literal,
    ACTIONS(168), 1,
      sym_int_literal,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(172), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(174), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(176), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(178), 1,
      anon_sym_LBRACK,
    ACTIONS(180), 1,
      anon_sym_LBRACE,
    ACTIONS(182), 1,
      anon_sym_LPAREN,
    ACTIONS(188), 1,
      sym_identifier,
    ACTIONS(192), 1,
      anon_sym_RBRACE,
    STATE(15), 1,
      sym_comment,
    STATE(37), 1,
      sym_unary_operator,
    STATE(94), 1,
      sym_expression,
    STATE(139), 1,
      sym_key_value_item,
    STATE(179), 1,
      sym__key_value_list,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(110), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(87), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [1327] = 20,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(166), 1,
      sym_boolean_literal,
    ACTIONS(168), 1,
      sym_int_literal,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(172), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(174), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(176), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(178), 1,
      anon_sym_LBRACK,
    ACTIONS(180), 1,
      anon_sym_LBRACE,
    ACTIONS(182), 1,
      anon_sym_LPAREN,
    ACTIONS(188), 1,
      sym_identifier,
    ACTIONS(194), 1,
      anon_sym_RBRACK,
    STATE(16), 1,
      sym_comment,
    STATE(37), 1,
      sym_unary_operator,
    STATE(77), 1,
      sym_expression,
    STATE(197), 1,
      sym__expression_list,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(110), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(87), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [1404] = 20,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(166), 1,
      sym_boolean_literal,
    ACTIONS(168), 1,
      sym_int_literal,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(172), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(174), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(176), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(178), 1,
      anon_sym_LBRACK,
    ACTIONS(180), 1,
      anon_sym_LBRACE,
    ACTIONS(182), 1,
      anon_sym_LPAREN,
    ACTIONS(188), 1,
      sym_identifier,
    ACTIONS(196), 1,
      anon_sym_RBRACK,
    STATE(17), 1,
      sym_comment,
    STATE(37), 1,
      sym_unary_operator,
    STATE(77), 1,
      sym_expression,
    STATE(192), 1,
      sym__expression_list,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(110), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(87), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [1481] = 19,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(166), 1,
      sym_boolean_literal,
    ACTIONS(168), 1,
      sym_int_literal,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(172), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(174), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(176), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(178), 1,
      anon_sym_LBRACK,
    ACTIONS(180), 1,
      anon_sym_LBRACE,
    ACTIONS(182), 1,
      anon_sym_LPAREN,
    ACTIONS(188), 1,
      sym_identifier,
    STATE(18), 1,
      sym_comment,
    STATE(37), 1,
      sym_unary_operator,
    STATE(85), 1,
      sym_expression,
    STATE(165), 1,
      sym_argument,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(110), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(87), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [1555] = 19,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(21), 1,
      sym_boolean_literal,
    ACTIONS(23), 1,
      anon_sym_SQUOTE,
    ACTIONS(27), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_LBRACK,
    ACTIONS(53), 1,
      anon_sym_LBRACE,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    STATE(19), 1,
      sym_comment,
    STATE(24), 1,
      sym_unary_operator,
    STATE(92), 1,
      sym_expression,
    STATE(189), 1,
      sym_condition,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(67), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(74), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [1629] = 19,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(21), 1,
      sym_boolean_literal,
    ACTIONS(23), 1,
      anon_sym_SQUOTE,
    ACTIONS(27), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_LBRACK,
    ACTIONS(53), 1,
      anon_sym_LBRACE,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    STATE(20), 1,
      sym_comment,
    STATE(24), 1,
      sym_unary_operator,
    STATE(92), 1,
      sym_expression,
    STATE(180), 1,
      sym_condition,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(67), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(74), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [1703] = 19,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(166), 1,
      sym_boolean_literal,
    ACTIONS(168), 1,
      sym_int_literal,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(172), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(174), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(176), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(178), 1,
      anon_sym_LBRACK,
    ACTIONS(180), 1,
      anon_sym_LBRACE,
    ACTIONS(182), 1,
      anon_sym_LPAREN,
    ACTIONS(188), 1,
      sym_identifier,
    STATE(21), 1,
      sym_comment,
    STATE(37), 1,
      sym_unary_operator,
    STATE(94), 1,
      sym_expression,
    STATE(171), 1,
      sym_key_value_item,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(110), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(87), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [1777] = 18,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(21), 1,
      sym_boolean_literal,
    ACTIONS(23), 1,
      anon_sym_SQUOTE,
    ACTIONS(27), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_LBRACK,
    ACTIONS(53), 1,
      anon_sym_LBRACE,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    STATE(22), 1,
      sym_comment,
    STATE(24), 1,
      sym_unary_operator,
    STATE(55), 1,
      sym_expression,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(67), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(74), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [1848] = 18,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(166), 1,
      sym_boolean_literal,
    ACTIONS(168), 1,
      sym_int_literal,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(172), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(174), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(176), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(178), 1,
      anon_sym_LBRACK,
    ACTIONS(180), 1,
      anon_sym_LBRACE,
    ACTIONS(182), 1,
      anon_sym_LPAREN,
    ACTIONS(188), 1,
      sym_identifier,
    STATE(23), 1,
      sym_comment,
    STATE(37), 1,
      sym_unary_operator,
    STATE(101), 1,
      sym_expression,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(110), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(87), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [1919] = 17,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(21), 1,
      sym_boolean_literal,
    ACTIONS(23), 1,
      anon_sym_SQUOTE,
    ACTIONS(27), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_LBRACK,
    ACTIONS(53), 1,
      anon_sym_LBRACE,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    STATE(56), 1,
      sym_expression,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(24), 2,
      sym_comment,
      sym_unary_operator,
    STATE(67), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(74), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [1988] = 18,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(166), 1,
      sym_boolean_literal,
    ACTIONS(168), 1,
      sym_int_literal,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(172), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(174), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(176), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(178), 1,
      anon_sym_LBRACK,
    ACTIONS(180), 1,
      anon_sym_LBRACE,
    ACTIONS(182), 1,
      anon_sym_LPAREN,
    ACTIONS(188), 1,
      sym_identifier,
    STATE(25), 1,
      sym_comment,
    STATE(37), 1,
      sym_unary_operator,
    STATE(64), 1,
      sym_expression,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(110), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(87), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [2059] = 18,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(21), 1,
      sym_boolean_literal,
    ACTIONS(23), 1,
      anon_sym_SQUOTE,
    ACTIONS(27), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_LBRACK,
    ACTIONS(53), 1,
      anon_sym_LBRACE,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    STATE(24), 1,
      sym_unary_operator,
    STATE(26), 1,
      sym_comment,
    STATE(52), 1,
      sym_expression,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(67), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(74), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [2130] = 18,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(21), 1,
      sym_boolean_literal,
    ACTIONS(23), 1,
      anon_sym_SQUOTE,
    ACTIONS(27), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_LBRACK,
    ACTIONS(53), 1,
      anon_sym_LBRACE,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    STATE(24), 1,
      sym_unary_operator,
    STATE(27), 1,
      sym_comment,
    STATE(51), 1,
      sym_expression,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(67), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(74), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [2201] = 18,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(21), 1,
      sym_boolean_literal,
    ACTIONS(23), 1,
      anon_sym_SQUOTE,
    ACTIONS(27), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_LBRACK,
    ACTIONS(53), 1,
      anon_sym_LBRACE,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    STATE(24), 1,
      sym_unary_operator,
    STATE(28), 1,
      sym_comment,
    STATE(53), 1,
      sym_expression,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(67), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(74), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [2272] = 18,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(21), 1,
      sym_boolean_literal,
    ACTIONS(23), 1,
      anon_sym_SQUOTE,
    ACTIONS(27), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_LBRACK,
    ACTIONS(53), 1,
      anon_sym_LBRACE,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    STATE(24), 1,
      sym_unary_operator,
    STATE(29), 1,
      sym_comment,
    STATE(103), 1,
      sym_expression,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(67), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(74), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [2343] = 18,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(166), 1,
      sym_boolean_literal,
    ACTIONS(168), 1,
      sym_int_literal,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(172), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(174), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(176), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(178), 1,
      anon_sym_LBRACK,
    ACTIONS(180), 1,
      anon_sym_LBRACE,
    ACTIONS(182), 1,
      anon_sym_LPAREN,
    ACTIONS(188), 1,
      sym_identifier,
    STATE(30), 1,
      sym_comment,
    STATE(37), 1,
      sym_unary_operator,
    STATE(62), 1,
      sym_expression,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(110), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(87), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [2414] = 18,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(166), 1,
      sym_boolean_literal,
    ACTIONS(168), 1,
      sym_int_literal,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(172), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(174), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(176), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(178), 1,
      anon_sym_LBRACK,
    ACTIONS(180), 1,
      anon_sym_LBRACE,
    ACTIONS(182), 1,
      anon_sym_LPAREN,
    ACTIONS(188), 1,
      sym_identifier,
    STATE(31), 1,
      sym_comment,
    STATE(37), 1,
      sym_unary_operator,
    STATE(97), 1,
      sym_expression,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(110), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(87), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [2485] = 18,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(166), 1,
      sym_boolean_literal,
    ACTIONS(168), 1,
      sym_int_literal,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(172), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(174), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(176), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(178), 1,
      anon_sym_LBRACK,
    ACTIONS(180), 1,
      anon_sym_LBRACE,
    ACTIONS(182), 1,
      anon_sym_LPAREN,
    ACTIONS(188), 1,
      sym_identifier,
    STATE(32), 1,
      sym_comment,
    STATE(37), 1,
      sym_unary_operator,
    STATE(57), 1,
      sym_expression,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(110), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(87), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [2556] = 18,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(166), 1,
      sym_boolean_literal,
    ACTIONS(168), 1,
      sym_int_literal,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(172), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(174), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(176), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(178), 1,
      anon_sym_LBRACK,
    ACTIONS(180), 1,
      anon_sym_LBRACE,
    ACTIONS(182), 1,
      anon_sym_LPAREN,
    ACTIONS(188), 1,
      sym_identifier,
    STATE(33), 1,
      sym_comment,
    STATE(37), 1,
      sym_unary_operator,
    STATE(63), 1,
      sym_expression,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(110), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(87), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [2627] = 18,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(166), 1,
      sym_boolean_literal,
    ACTIONS(168), 1,
      sym_int_literal,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(172), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(174), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(176), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(178), 1,
      anon_sym_LBRACK,
    ACTIONS(180), 1,
      anon_sym_LBRACE,
    ACTIONS(182), 1,
      anon_sym_LPAREN,
    ACTIONS(188), 1,
      sym_identifier,
    STATE(34), 1,
      sym_comment,
    STATE(37), 1,
      sym_unary_operator,
    STATE(61), 1,
      sym_expression,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(110), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(87), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [2698] = 18,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(166), 1,
      sym_boolean_literal,
    ACTIONS(168), 1,
      sym_int_literal,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(172), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(174), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(176), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(178), 1,
      anon_sym_LBRACK,
    ACTIONS(180), 1,
      anon_sym_LBRACE,
    ACTIONS(182), 1,
      anon_sym_LPAREN,
    ACTIONS(188), 1,
      sym_identifier,
    STATE(35), 1,
      sym_comment,
    STATE(37), 1,
      sym_unary_operator,
    STATE(60), 1,
      sym_expression,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(110), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(87), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [2769] = 18,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(166), 1,
      sym_boolean_literal,
    ACTIONS(168), 1,
      sym_int_literal,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(172), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(174), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(176), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(178), 1,
      anon_sym_LBRACK,
    ACTIONS(180), 1,
      anon_sym_LBRACE,
    ACTIONS(182), 1,
      anon_sym_LPAREN,
    ACTIONS(188), 1,
      sym_identifier,
    STATE(36), 1,
      sym_comment,
    STATE(37), 1,
      sym_unary_operator,
    STATE(59), 1,
      sym_expression,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(110), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(87), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [2840] = 17,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(166), 1,
      sym_boolean_literal,
    ACTIONS(168), 1,
      sym_int_literal,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(172), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(174), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(176), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(178), 1,
      anon_sym_LBRACK,
    ACTIONS(180), 1,
      anon_sym_LBRACE,
    ACTIONS(182), 1,
      anon_sym_LPAREN,
    ACTIONS(188), 1,
      sym_identifier,
    STATE(58), 1,
      sym_expression,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(37), 2,
      sym_comment,
      sym_unary_operator,
    STATE(110), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(87), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [2909] = 18,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(166), 1,
      sym_boolean_literal,
    ACTIONS(168), 1,
      sym_int_literal,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(172), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(174), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(176), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(178), 1,
      anon_sym_LBRACK,
    ACTIONS(180), 1,
      anon_sym_LBRACE,
    ACTIONS(182), 1,
      anon_sym_LPAREN,
    ACTIONS(188), 1,
      sym_identifier,
    STATE(37), 1,
      sym_unary_operator,
    STATE(38), 1,
      sym_comment,
    STATE(84), 1,
      sym_expression,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(110), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(87), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [2980] = 18,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(21), 1,
      sym_boolean_literal,
    ACTIONS(23), 1,
      anon_sym_SQUOTE,
    ACTIONS(27), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_LBRACK,
    ACTIONS(53), 1,
      anon_sym_LBRACE,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    STATE(24), 1,
      sym_unary_operator,
    STATE(39), 1,
      sym_comment,
    STATE(50), 1,
      sym_expression,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(67), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(74), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [3051] = 18,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(166), 1,
      sym_boolean_literal,
    ACTIONS(168), 1,
      sym_int_literal,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(172), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(174), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(176), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(178), 1,
      anon_sym_LBRACK,
    ACTIONS(180), 1,
      anon_sym_LBRACE,
    ACTIONS(182), 1,
      anon_sym_LPAREN,
    ACTIONS(188), 1,
      sym_identifier,
    STATE(37), 1,
      sym_unary_operator,
    STATE(40), 1,
      sym_comment,
    STATE(83), 1,
      sym_expression,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(110), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(87), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [3122] = 18,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(166), 1,
      sym_boolean_literal,
    ACTIONS(168), 1,
      sym_int_literal,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(172), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(174), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(176), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(178), 1,
      anon_sym_LBRACK,
    ACTIONS(180), 1,
      anon_sym_LBRACE,
    ACTIONS(182), 1,
      anon_sym_LPAREN,
    ACTIONS(188), 1,
      sym_identifier,
    STATE(37), 1,
      sym_unary_operator,
    STATE(41), 1,
      sym_comment,
    STATE(100), 1,
      sym_expression,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(110), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(87), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [3193] = 18,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(166), 1,
      sym_boolean_literal,
    ACTIONS(168), 1,
      sym_int_literal,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(172), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(174), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(176), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(178), 1,
      anon_sym_LBRACK,
    ACTIONS(180), 1,
      anon_sym_LBRACE,
    ACTIONS(182), 1,
      anon_sym_LPAREN,
    ACTIONS(188), 1,
      sym_identifier,
    STATE(37), 1,
      sym_unary_operator,
    STATE(42), 1,
      sym_comment,
    STATE(102), 1,
      sym_expression,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(110), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(87), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [3264] = 18,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(166), 1,
      sym_boolean_literal,
    ACTIONS(168), 1,
      sym_int_literal,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(172), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(174), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(176), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(178), 1,
      anon_sym_LBRACK,
    ACTIONS(180), 1,
      anon_sym_LBRACE,
    ACTIONS(182), 1,
      anon_sym_LPAREN,
    ACTIONS(188), 1,
      sym_identifier,
    STATE(37), 1,
      sym_unary_operator,
    STATE(43), 1,
      sym_comment,
    STATE(89), 1,
      sym_expression,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(110), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(87), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [3335] = 18,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(21), 1,
      sym_boolean_literal,
    ACTIONS(23), 1,
      anon_sym_SQUOTE,
    ACTIONS(27), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_LBRACK,
    ACTIONS(53), 1,
      anon_sym_LBRACE,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    STATE(24), 1,
      sym_unary_operator,
    STATE(44), 1,
      sym_comment,
    STATE(49), 1,
      sym_expression,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(67), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(74), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [3406] = 18,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(166), 1,
      sym_boolean_literal,
    ACTIONS(168), 1,
      sym_int_literal,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(172), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(174), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(176), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(178), 1,
      anon_sym_LBRACK,
    ACTIONS(180), 1,
      anon_sym_LBRACE,
    ACTIONS(182), 1,
      anon_sym_LPAREN,
    ACTIONS(188), 1,
      sym_identifier,
    STATE(37), 1,
      sym_unary_operator,
    STATE(45), 1,
      sym_comment,
    STATE(95), 1,
      sym_expression,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(110), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(87), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [3477] = 18,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(166), 1,
      sym_boolean_literal,
    ACTIONS(168), 1,
      sym_int_literal,
    ACTIONS(170), 1,
      anon_sym_SQUOTE,
    ACTIONS(172), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(174), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(176), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(178), 1,
      anon_sym_LBRACK,
    ACTIONS(180), 1,
      anon_sym_LBRACE,
    ACTIONS(182), 1,
      anon_sym_LPAREN,
    ACTIONS(188), 1,
      sym_identifier,
    STATE(37), 1,
      sym_unary_operator,
    STATE(46), 1,
      sym_comment,
    STATE(82), 1,
      sym_expression,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(110), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(87), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [3548] = 18,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      sym_not,
    ACTIONS(21), 1,
      sym_boolean_literal,
    ACTIONS(23), 1,
      anon_sym_SQUOTE,
    ACTIONS(27), 1,
      anon_sym_f_SQUOTE,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(51), 1,
      anon_sym_LBRACK,
    ACTIONS(53), 1,
      anon_sym_LBRACE,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    STATE(24), 1,
      sym_unary_operator,
    STATE(47), 1,
      sym_comment,
    STATE(54), 1,
      sym_expression,
    ACTIONS(55), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    STATE(67), 4,
      sym_string_literal,
      sym_fstring_literal,
      sym_array_literal,
      sym_dictionary_literal,
    STATE(74), 13,
      sym__literal,
      sym_conditional_expression,
      sym_logical_or_expression,
      sym_logical_and_expression,
      sym_equality_expression,
      sym_relational_expression,
      sym_additive_expression,
      sym_multiplicative_expression,
      sym_unary_expression,
      sym_primary_expression,
      sym_subscript_expression,
      sym_function_expression,
      sym_method_expression,
  [3619] = 19,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(198), 1,
      anon_sym_LF,
    ACTIONS(200), 1,
      sym_and,
    ACTIONS(202), 1,
      sym_or,
    ACTIONS(204), 1,
      sym_not,
    ACTIONS(208), 1,
      anon_sym_LBRACK,
    ACTIONS(212), 1,
      anon_sym_QMARK,
    ACTIONS(220), 1,
      anon_sym_DOT,
    STATE(22), 1,
      sym_multiplicative_operator,
    STATE(26), 1,
      sym_additive_operator,
    STATE(27), 1,
      sym_relational_operator,
    STATE(28), 1,
      sym_equality_operator,
    STATE(29), 1,
      sym_assignment_operator,
    STATE(48), 1,
      sym_comment,
    ACTIONS(214), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(216), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(218), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(206), 5,
      sym_in,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(210), 6,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
  [3690] = 14,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(200), 1,
      sym_and,
    ACTIONS(204), 1,
      sym_not,
    ACTIONS(222), 1,
      anon_sym_LF,
    STATE(22), 1,
      sym_multiplicative_operator,
    STATE(26), 1,
      sym_additive_operator,
    STATE(27), 1,
      sym_relational_operator,
    STATE(28), 1,
      sym_equality_operator,
    STATE(49), 1,
      sym_comment,
    ACTIONS(214), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(216), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(218), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(206), 5,
      sym_in,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(224), 10,
      sym_or,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_QMARK,
      anon_sym_DOT,
  [3750] = 18,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(200), 1,
      sym_and,
    ACTIONS(202), 1,
      sym_or,
    ACTIONS(204), 1,
      sym_not,
    ACTIONS(208), 1,
      anon_sym_LBRACK,
    ACTIONS(212), 1,
      anon_sym_QMARK,
    ACTIONS(220), 1,
      anon_sym_DOT,
    ACTIONS(226), 1,
      anon_sym_LF,
    STATE(22), 1,
      sym_multiplicative_operator,
    STATE(26), 1,
      sym_additive_operator,
    STATE(27), 1,
      sym_relational_operator,
    STATE(28), 1,
      sym_equality_operator,
    STATE(50), 1,
      sym_comment,
    ACTIONS(214), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(216), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(218), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(206), 5,
      sym_in,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(228), 6,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
  [3818] = 10,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(230), 1,
      anon_sym_LF,
    STATE(22), 1,
      sym_multiplicative_operator,
    STATE(26), 1,
      sym_additive_operator,
    STATE(27), 1,
      sym_relational_operator,
    STATE(28), 1,
      sym_equality_operator,
    STATE(51), 1,
      sym_comment,
    ACTIONS(216), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(218), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(232), 19,
      sym_and,
      sym_or,
      sym_not,
      sym_in,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_DOT,
  [3870] = 9,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(234), 1,
      anon_sym_LF,
    STATE(22), 1,
      sym_multiplicative_operator,
    STATE(26), 1,
      sym_additive_operator,
    STATE(27), 1,
      sym_relational_operator,
    STATE(28), 1,
      sym_equality_operator,
    STATE(52), 1,
      sym_comment,
    ACTIONS(218), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(236), 21,
      sym_and,
      sym_or,
      sym_not,
      sym_in,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_DOT,
  [3920] = 12,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(204), 1,
      sym_not,
    ACTIONS(238), 1,
      anon_sym_LF,
    STATE(22), 1,
      sym_multiplicative_operator,
    STATE(26), 1,
      sym_additive_operator,
    STATE(27), 1,
      sym_relational_operator,
    STATE(28), 1,
      sym_equality_operator,
    STATE(53), 1,
      sym_comment,
    ACTIONS(216), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(218), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(206), 5,
      sym_in,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(240), 13,
      sym_and,
      sym_or,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DOT,
  [3976] = 13,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(204), 1,
      sym_not,
    ACTIONS(242), 1,
      anon_sym_LF,
    STATE(22), 1,
      sym_multiplicative_operator,
    STATE(26), 1,
      sym_additive_operator,
    STATE(27), 1,
      sym_relational_operator,
    STATE(28), 1,
      sym_equality_operator,
    STATE(54), 1,
      sym_comment,
    ACTIONS(214), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(216), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(218), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(206), 5,
      sym_in,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(244), 11,
      sym_and,
      sym_or,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_QMARK,
      anon_sym_DOT,
  [4034] = 8,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(246), 1,
      anon_sym_LF,
    STATE(22), 1,
      sym_multiplicative_operator,
    STATE(26), 1,
      sym_additive_operator,
    STATE(27), 1,
      sym_relational_operator,
    STATE(28), 1,
      sym_equality_operator,
    STATE(55), 1,
      sym_comment,
    ACTIONS(248), 24,
      sym_and,
      sym_or,
      sym_not,
      sym_in,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT,
  [4082] = 18,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(200), 1,
      sym_and,
    ACTIONS(202), 1,
      sym_or,
    ACTIONS(204), 1,
      sym_not,
    ACTIONS(208), 1,
      anon_sym_LBRACK,
    ACTIONS(212), 1,
      anon_sym_QMARK,
    ACTIONS(220), 1,
      anon_sym_DOT,
    ACTIONS(250), 1,
      anon_sym_LF,
    STATE(22), 1,
      sym_multiplicative_operator,
    STATE(26), 1,
      sym_additive_operator,
    STATE(27), 1,
      sym_relational_operator,
    STATE(28), 1,
      sym_equality_operator,
    STATE(56), 1,
      sym_comment,
    ACTIONS(214), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(216), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(218), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(206), 5,
      sym_in,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(252), 6,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
  [4150] = 9,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(30), 1,
      sym_multiplicative_operator,
    STATE(32), 1,
      sym_additive_operator,
    STATE(33), 1,
      sym_relational_operator,
    STATE(34), 1,
      sym_equality_operator,
    STATE(57), 1,
      sym_comment,
    ACTIONS(236), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(254), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(234), 18,
      sym_and,
      sym_or,
      sym_not,
      sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_RPAREN,
      anon_sym_DOT,
  [4198] = 18,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(256), 1,
      sym_and,
    ACTIONS(258), 1,
      sym_or,
    ACTIONS(260), 1,
      sym_not,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_QMARK,
    ACTIONS(272), 1,
      anon_sym_DOT,
    STATE(30), 1,
      sym_multiplicative_operator,
    STATE(32), 1,
      sym_additive_operator,
    STATE(33), 1,
      sym_relational_operator,
    STATE(34), 1,
      sym_equality_operator,
    STATE(58), 1,
      sym_comment,
    ACTIONS(206), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(268), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(270), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(254), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(262), 3,
      sym_in,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(250), 5,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
  [4264] = 13,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(260), 1,
      sym_not,
    STATE(30), 1,
      sym_multiplicative_operator,
    STATE(32), 1,
      sym_additive_operator,
    STATE(33), 1,
      sym_relational_operator,
    STATE(34), 1,
      sym_equality_operator,
    STATE(59), 1,
      sym_comment,
    ACTIONS(206), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(268), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(270), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(254), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(262), 3,
      sym_in,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(242), 10,
      sym_and,
      sym_or,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_RPAREN,
      anon_sym_DOT,
  [4320] = 14,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(256), 1,
      sym_and,
    ACTIONS(260), 1,
      sym_not,
    STATE(30), 1,
      sym_multiplicative_operator,
    STATE(32), 1,
      sym_additive_operator,
    STATE(33), 1,
      sym_relational_operator,
    STATE(34), 1,
      sym_equality_operator,
    STATE(60), 1,
      sym_comment,
    ACTIONS(206), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(268), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(270), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(254), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(262), 3,
      sym_in,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(222), 9,
      sym_or,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_RPAREN,
      anon_sym_DOT,
  [4378] = 12,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(260), 1,
      sym_not,
    STATE(30), 1,
      sym_multiplicative_operator,
    STATE(32), 1,
      sym_additive_operator,
    STATE(33), 1,
      sym_relational_operator,
    STATE(34), 1,
      sym_equality_operator,
    STATE(61), 1,
      sym_comment,
    ACTIONS(206), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(270), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(254), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(262), 3,
      sym_in,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(238), 12,
      sym_and,
      sym_or,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_RPAREN,
      anon_sym_DOT,
  [4432] = 8,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(30), 1,
      sym_multiplicative_operator,
    STATE(32), 1,
      sym_additive_operator,
    STATE(33), 1,
      sym_relational_operator,
    STATE(34), 1,
      sym_equality_operator,
    STATE(62), 1,
      sym_comment,
    ACTIONS(248), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(246), 21,
      sym_and,
      sym_or,
      sym_not,
      sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_RPAREN,
      anon_sym_DOT,
  [4478] = 10,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(30), 1,
      sym_multiplicative_operator,
    STATE(32), 1,
      sym_additive_operator,
    STATE(33), 1,
      sym_relational_operator,
    STATE(34), 1,
      sym_equality_operator,
    STATE(63), 1,
      sym_comment,
    ACTIONS(232), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(270), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(254), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(230), 16,
      sym_and,
      sym_or,
      sym_not,
      sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_RPAREN,
      anon_sym_DOT,
  [4528] = 18,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(256), 1,
      sym_and,
    ACTIONS(258), 1,
      sym_or,
    ACTIONS(260), 1,
      sym_not,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_QMARK,
    ACTIONS(272), 1,
      anon_sym_DOT,
    STATE(30), 1,
      sym_multiplicative_operator,
    STATE(32), 1,
      sym_additive_operator,
    STATE(33), 1,
      sym_relational_operator,
    STATE(34), 1,
      sym_equality_operator,
    STATE(64), 1,
      sym_comment,
    ACTIONS(206), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(268), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(270), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(254), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(262), 3,
      sym_in,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
    ACTIONS(226), 5,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
  [4594] = 5,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(274), 1,
      anon_sym_LF,
    ACTIONS(278), 1,
      anon_sym_LPAREN,
    STATE(65), 1,
      sym_comment,
    ACTIONS(276), 24,
      sym_and,
      sym_or,
      sym_not,
      sym_in,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT,
  [4633] = 4,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(280), 1,
      anon_sym_LF,
    STATE(66), 1,
      sym_comment,
    ACTIONS(282), 24,
      sym_and,
      sym_or,
      sym_not,
      sym_in,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT,
  [4669] = 4,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(284), 1,
      anon_sym_LF,
    STATE(67), 1,
      sym_comment,
    ACTIONS(286), 24,
      sym_and,
      sym_or,
      sym_not,
      sym_in,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT,
  [4705] = 4,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(288), 1,
      anon_sym_LF,
    STATE(68), 1,
      sym_comment,
    ACTIONS(290), 24,
      sym_and,
      sym_or,
      sym_not,
      sym_in,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT,
  [4741] = 4,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(292), 1,
      anon_sym_LF,
    STATE(69), 1,
      sym_comment,
    ACTIONS(294), 24,
      sym_and,
      sym_or,
      sym_not,
      sym_in,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT,
  [4777] = 4,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(296), 1,
      anon_sym_LF,
    STATE(70), 1,
      sym_comment,
    ACTIONS(298), 24,
      sym_and,
      sym_or,
      sym_not,
      sym_in,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT,
  [4813] = 4,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(300), 1,
      anon_sym_LF,
    STATE(71), 1,
      sym_comment,
    ACTIONS(302), 24,
      sym_and,
      sym_or,
      sym_not,
      sym_in,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT,
  [4849] = 4,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(304), 1,
      anon_sym_LF,
    STATE(72), 1,
      sym_comment,
    ACTIONS(306), 24,
      sym_and,
      sym_or,
      sym_not,
      sym_in,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT,
  [4885] = 4,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(308), 1,
      anon_sym_LF,
    STATE(73), 1,
      sym_comment,
    ACTIONS(310), 24,
      sym_and,
      sym_or,
      sym_not,
      sym_in,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT,
  [4921] = 4,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(274), 1,
      anon_sym_LF,
    STATE(74), 1,
      sym_comment,
    ACTIONS(276), 24,
      sym_and,
      sym_or,
      sym_not,
      sym_in,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT,
  [4957] = 4,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(312), 1,
      anon_sym_LF,
    STATE(75), 1,
      sym_comment,
    ACTIONS(314), 24,
      sym_and,
      sym_or,
      sym_not,
      sym_in,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT,
  [4993] = 4,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(316), 1,
      anon_sym_LF,
    STATE(76), 1,
      sym_comment,
    ACTIONS(318), 24,
      sym_and,
      sym_or,
      sym_not,
      sym_in,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT,
  [5029] = 20,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(256), 1,
      sym_and,
    ACTIONS(258), 1,
      sym_or,
    ACTIONS(260), 1,
      sym_not,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_QMARK,
    ACTIONS(272), 1,
      anon_sym_DOT,
    ACTIONS(320), 1,
      anon_sym_RBRACK,
    ACTIONS(322), 1,
      anon_sym_COMMA,
    STATE(30), 1,
      sym_multiplicative_operator,
    STATE(32), 1,
      sym_additive_operator,
    STATE(33), 1,
      sym_relational_operator,
    STATE(34), 1,
      sym_equality_operator,
    STATE(77), 1,
      sym_comment,
    STATE(163), 1,
      aux_sym__expression_list_repeat1,
    ACTIONS(206), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(268), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(270), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(254), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(262), 3,
      sym_in,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [5097] = 4,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(324), 1,
      anon_sym_LF,
    STATE(78), 1,
      sym_comment,
    ACTIONS(326), 24,
      sym_and,
      sym_or,
      sym_not,
      sym_in,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT,
  [5133] = 4,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(328), 1,
      anon_sym_LF,
    STATE(79), 1,
      sym_comment,
    ACTIONS(330), 24,
      sym_and,
      sym_or,
      sym_not,
      sym_in,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT,
  [5169] = 4,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(332), 1,
      anon_sym_LF,
    STATE(80), 1,
      sym_comment,
    ACTIONS(334), 24,
      sym_and,
      sym_or,
      sym_not,
      sym_in,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT,
  [5205] = 4,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(336), 1,
      anon_sym_LF,
    STATE(81), 1,
      sym_comment,
    ACTIONS(338), 24,
      sym_and,
      sym_or,
      sym_not,
      sym_in,
      anon_sym_LBRACK,
      anon_sym_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_DOT,
  [5241] = 18,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(256), 1,
      sym_and,
    ACTIONS(258), 1,
      sym_or,
    ACTIONS(260), 1,
      sym_not,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_QMARK,
    ACTIONS(272), 1,
      anon_sym_DOT,
    STATE(30), 1,
      sym_multiplicative_operator,
    STATE(32), 1,
      sym_additive_operator,
    STATE(33), 1,
      sym_relational_operator,
    STATE(34), 1,
      sym_equality_operator,
    STATE(82), 1,
      sym_comment,
    ACTIONS(206), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(268), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(270), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(340), 2,
      anon_sym_RBRACK,
      anon_sym_COMMA,
    ACTIONS(254), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(262), 3,
      sym_in,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [5304] = 18,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(256), 1,
      sym_and,
    ACTIONS(258), 1,
      sym_or,
    ACTIONS(260), 1,
      sym_not,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_QMARK,
    ACTIONS(272), 1,
      anon_sym_DOT,
    STATE(30), 1,
      sym_multiplicative_operator,
    STATE(32), 1,
      sym_additive_operator,
    STATE(33), 1,
      sym_relational_operator,
    STATE(34), 1,
      sym_equality_operator,
    STATE(83), 1,
      sym_comment,
    ACTIONS(206), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(268), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(270), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(342), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
    ACTIONS(254), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(262), 3,
      sym_in,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [5367] = 18,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(256), 1,
      sym_and,
    ACTIONS(258), 1,
      sym_or,
    ACTIONS(260), 1,
      sym_not,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_QMARK,
    ACTIONS(272), 1,
      anon_sym_DOT,
    STATE(30), 1,
      sym_multiplicative_operator,
    STATE(32), 1,
      sym_additive_operator,
    STATE(33), 1,
      sym_relational_operator,
    STATE(34), 1,
      sym_equality_operator,
    STATE(84), 1,
      sym_comment,
    ACTIONS(206), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(268), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(270), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(344), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(254), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(262), 3,
      sym_in,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [5430] = 18,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(256), 1,
      sym_and,
    ACTIONS(258), 1,
      sym_or,
    ACTIONS(260), 1,
      sym_not,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_QMARK,
    ACTIONS(272), 1,
      anon_sym_DOT,
    STATE(30), 1,
      sym_multiplicative_operator,
    STATE(32), 1,
      sym_additive_operator,
    STATE(33), 1,
      sym_relational_operator,
    STATE(34), 1,
      sym_equality_operator,
    STATE(85), 1,
      sym_comment,
    ACTIONS(206), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(268), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(270), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(346), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(254), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(262), 3,
      sym_in,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [5493] = 5,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(348), 1,
      anon_sym_LPAREN,
    STATE(86), 1,
      sym_comment,
    ACTIONS(276), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(274), 21,
      sym_and,
      sym_or,
      sym_not,
      sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_RPAREN,
      anon_sym_DOT,
  [5530] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(87), 1,
      sym_comment,
    ACTIONS(276), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(274), 21,
      sym_and,
      sym_or,
      sym_not,
      sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_RPAREN,
      anon_sym_DOT,
  [5564] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(88), 1,
      sym_comment,
    ACTIONS(294), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(292), 21,
      sym_and,
      sym_or,
      sym_not,
      sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_RPAREN,
      anon_sym_DOT,
  [5598] = 18,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(256), 1,
      sym_and,
    ACTIONS(258), 1,
      sym_or,
    ACTIONS(260), 1,
      sym_not,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_QMARK,
    ACTIONS(272), 1,
      anon_sym_DOT,
    ACTIONS(350), 1,
      anon_sym_RPAREN,
    STATE(30), 1,
      sym_multiplicative_operator,
    STATE(32), 1,
      sym_additive_operator,
    STATE(33), 1,
      sym_relational_operator,
    STATE(34), 1,
      sym_equality_operator,
    STATE(89), 1,
      sym_comment,
    ACTIONS(206), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(268), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(270), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(254), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(262), 3,
      sym_in,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [5660] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(90), 1,
      sym_comment,
    ACTIONS(282), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(280), 21,
      sym_and,
      sym_or,
      sym_not,
      sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_RPAREN,
      anon_sym_DOT,
  [5694] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(91), 1,
      sym_comment,
    ACTIONS(310), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(308), 21,
      sym_and,
      sym_or,
      sym_not,
      sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_RPAREN,
      anon_sym_DOT,
  [5728] = 17,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(200), 1,
      sym_and,
    ACTIONS(202), 1,
      sym_or,
    ACTIONS(204), 1,
      sym_not,
    ACTIONS(208), 1,
      anon_sym_LBRACK,
    ACTIONS(212), 1,
      anon_sym_QMARK,
    ACTIONS(220), 1,
      anon_sym_DOT,
    ACTIONS(352), 1,
      anon_sym_LF,
    STATE(22), 1,
      sym_multiplicative_operator,
    STATE(26), 1,
      sym_additive_operator,
    STATE(27), 1,
      sym_relational_operator,
    STATE(28), 1,
      sym_equality_operator,
    STATE(92), 1,
      sym_comment,
    ACTIONS(214), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(216), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(218), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(206), 5,
      sym_in,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [5788] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(93), 1,
      sym_comment,
    ACTIONS(338), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(336), 21,
      sym_and,
      sym_or,
      sym_not,
      sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_RPAREN,
      anon_sym_DOT,
  [5822] = 18,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(256), 1,
      sym_and,
    ACTIONS(258), 1,
      sym_or,
    ACTIONS(260), 1,
      sym_not,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_QMARK,
    ACTIONS(272), 1,
      anon_sym_DOT,
    ACTIONS(354), 1,
      anon_sym_COLON,
    STATE(30), 1,
      sym_multiplicative_operator,
    STATE(32), 1,
      sym_additive_operator,
    STATE(33), 1,
      sym_relational_operator,
    STATE(34), 1,
      sym_equality_operator,
    STATE(94), 1,
      sym_comment,
    ACTIONS(206), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(268), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(270), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(254), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(262), 3,
      sym_in,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [5884] = 18,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(256), 1,
      sym_and,
    ACTIONS(258), 1,
      sym_or,
    ACTIONS(260), 1,
      sym_not,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_QMARK,
    ACTIONS(272), 1,
      anon_sym_DOT,
    ACTIONS(356), 1,
      anon_sym_COLON,
    STATE(30), 1,
      sym_multiplicative_operator,
    STATE(32), 1,
      sym_additive_operator,
    STATE(33), 1,
      sym_relational_operator,
    STATE(34), 1,
      sym_equality_operator,
    STATE(95), 1,
      sym_comment,
    ACTIONS(206), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(268), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(270), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(254), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(262), 3,
      sym_in,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [5946] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(96), 1,
      sym_comment,
    ACTIONS(330), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(328), 21,
      sym_and,
      sym_or,
      sym_not,
      sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_RPAREN,
      anon_sym_DOT,
  [5980] = 18,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(256), 1,
      sym_and,
    ACTIONS(258), 1,
      sym_or,
    ACTIONS(260), 1,
      sym_not,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_QMARK,
    ACTIONS(272), 1,
      anon_sym_DOT,
    ACTIONS(358), 1,
      anon_sym_RBRACK,
    STATE(30), 1,
      sym_multiplicative_operator,
    STATE(32), 1,
      sym_additive_operator,
    STATE(33), 1,
      sym_relational_operator,
    STATE(34), 1,
      sym_equality_operator,
    STATE(97), 1,
      sym_comment,
    ACTIONS(206), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(268), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(270), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(254), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(262), 3,
      sym_in,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [6042] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(98), 1,
      sym_comment,
    ACTIONS(314), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(312), 21,
      sym_and,
      sym_or,
      sym_not,
      sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_RPAREN,
      anon_sym_DOT,
  [6076] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(99), 1,
      sym_comment,
    ACTIONS(326), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(324), 21,
      sym_and,
      sym_or,
      sym_not,
      sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_RPAREN,
      anon_sym_DOT,
  [6110] = 18,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(256), 1,
      sym_and,
    ACTIONS(258), 1,
      sym_or,
    ACTIONS(260), 1,
      sym_not,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_QMARK,
    ACTIONS(272), 1,
      anon_sym_DOT,
    ACTIONS(360), 1,
      anon_sym_RBRACK,
    STATE(30), 1,
      sym_multiplicative_operator,
    STATE(32), 1,
      sym_additive_operator,
    STATE(33), 1,
      sym_relational_operator,
    STATE(34), 1,
      sym_equality_operator,
    STATE(100), 1,
      sym_comment,
    ACTIONS(206), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(268), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(270), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(254), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(262), 3,
      sym_in,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [6172] = 18,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(256), 1,
      sym_and,
    ACTIONS(258), 1,
      sym_or,
    ACTIONS(260), 1,
      sym_not,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_QMARK,
    ACTIONS(272), 1,
      anon_sym_DOT,
    ACTIONS(362), 1,
      anon_sym_COLON,
    STATE(30), 1,
      sym_multiplicative_operator,
    STATE(32), 1,
      sym_additive_operator,
    STATE(33), 1,
      sym_relational_operator,
    STATE(34), 1,
      sym_equality_operator,
    STATE(101), 1,
      sym_comment,
    ACTIONS(206), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(268), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(270), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(254), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(262), 3,
      sym_in,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [6234] = 18,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(256), 1,
      sym_and,
    ACTIONS(258), 1,
      sym_or,
    ACTIONS(260), 1,
      sym_not,
    ACTIONS(264), 1,
      anon_sym_LBRACK,
    ACTIONS(266), 1,
      anon_sym_QMARK,
    ACTIONS(272), 1,
      anon_sym_DOT,
    ACTIONS(364), 1,
      anon_sym_RPAREN,
    STATE(30), 1,
      sym_multiplicative_operator,
    STATE(32), 1,
      sym_additive_operator,
    STATE(33), 1,
      sym_relational_operator,
    STATE(34), 1,
      sym_equality_operator,
    STATE(102), 1,
      sym_comment,
    ACTIONS(206), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(268), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(270), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(254), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(262), 3,
      sym_in,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [6296] = 17,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(200), 1,
      sym_and,
    ACTIONS(202), 1,
      sym_or,
    ACTIONS(204), 1,
      sym_not,
    ACTIONS(208), 1,
      anon_sym_LBRACK,
    ACTIONS(212), 1,
      anon_sym_QMARK,
    ACTIONS(220), 1,
      anon_sym_DOT,
    ACTIONS(366), 1,
      anon_sym_LF,
    STATE(22), 1,
      sym_multiplicative_operator,
    STATE(26), 1,
      sym_additive_operator,
    STATE(27), 1,
      sym_relational_operator,
    STATE(28), 1,
      sym_equality_operator,
    STATE(103), 1,
      sym_comment,
    ACTIONS(214), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(216), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(218), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(206), 5,
      sym_in,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
  [6356] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(104), 1,
      sym_comment,
    ACTIONS(334), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(332), 21,
      sym_and,
      sym_or,
      sym_not,
      sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_RPAREN,
      anon_sym_DOT,
  [6390] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(105), 1,
      sym_comment,
    ACTIONS(318), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(316), 21,
      sym_and,
      sym_or,
      sym_not,
      sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_RPAREN,
      anon_sym_DOT,
  [6424] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(106), 1,
      sym_comment,
    ACTIONS(298), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(296), 21,
      sym_and,
      sym_or,
      sym_not,
      sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_RPAREN,
      anon_sym_DOT,
  [6458] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(107), 1,
      sym_comment,
    ACTIONS(306), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(304), 21,
      sym_and,
      sym_or,
      sym_not,
      sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_RPAREN,
      anon_sym_DOT,
  [6492] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(108), 1,
      sym_comment,
    ACTIONS(302), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(300), 21,
      sym_and,
      sym_or,
      sym_not,
      sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_RPAREN,
      anon_sym_DOT,
  [6526] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(109), 1,
      sym_comment,
    ACTIONS(290), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(288), 21,
      sym_and,
      sym_or,
      sym_not,
      sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_RPAREN,
      anon_sym_DOT,
  [6560] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(110), 1,
      sym_comment,
    ACTIONS(286), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(284), 21,
      sym_and,
      sym_or,
      sym_not,
      sym_in,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_RPAREN,
      anon_sym_DOT,
  [6594] = 6,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(348), 1,
      anon_sym_LPAREN,
    ACTIONS(368), 1,
      anon_sym_COLON,
    STATE(111), 1,
      sym_comment,
    ACTIONS(276), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(274), 18,
      sym_and,
      sym_or,
      sym_not,
      sym_in,
      anon_sym_LBRACK,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_RPAREN,
      anon_sym_DOT,
  [6631] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(112), 1,
      sym_comment,
    ACTIONS(372), 8,
      sym_int_literal,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LPAREN,
    ACTIONS(370), 13,
      sym_if,
      sym_elif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_endforeach,
      sym_break,
      sym_continue,
      sym_not,
      sym_boolean_literal,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      sym_identifier,
  [6663] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(113), 1,
      sym_comment,
    ACTIONS(376), 8,
      sym_int_literal,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LPAREN,
    ACTIONS(374), 13,
      sym_if,
      sym_elif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_endforeach,
      sym_break,
      sym_continue,
      sym_not,
      sym_boolean_literal,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      sym_identifier,
  [6695] = 8,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(378), 1,
      anon_sym_SQUOTE,
    ACTIONS(380), 1,
      aux_sym_string_literal_token1,
    ACTIONS(384), 1,
      aux_sym_bad_escape_token1,
    STATE(114), 1,
      sym_comment,
    STATE(121), 1,
      aux_sym_string_literal_repeat1,
    STATE(127), 2,
      sym_escape_sequence,
      sym_bad_escape,
    ACTIONS(382), 14,
      anon_sym_BSLASH_BSLASH,
      anon_sym_BSLASH_SQUOTE,
      anon_sym_BSLASHa,
      anon_sym_BSLASHb,
      anon_sym_BSLASHf,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASHv,
      aux_sym_escape_sequence_token1,
      aux_sym_escape_sequence_token2,
      aux_sym_escape_sequence_token3,
      aux_sym_escape_sequence_token4,
      aux_sym_escape_sequence_token5,
  [6734] = 8,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(380), 1,
      aux_sym_string_literal_token1,
    ACTIONS(384), 1,
      aux_sym_bad_escape_token1,
    ACTIONS(386), 1,
      anon_sym_SQUOTE,
    STATE(115), 1,
      sym_comment,
    STATE(121), 1,
      aux_sym_string_literal_repeat1,
    STATE(127), 2,
      sym_escape_sequence,
      sym_bad_escape,
    ACTIONS(382), 14,
      anon_sym_BSLASH_BSLASH,
      anon_sym_BSLASH_SQUOTE,
      anon_sym_BSLASHa,
      anon_sym_BSLASHb,
      anon_sym_BSLASHf,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASHv,
      aux_sym_escape_sequence_token1,
      aux_sym_escape_sequence_token2,
      aux_sym_escape_sequence_token3,
      aux_sym_escape_sequence_token4,
      aux_sym_escape_sequence_token5,
  [6773] = 8,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(380), 1,
      aux_sym_string_literal_token1,
    ACTIONS(384), 1,
      aux_sym_bad_escape_token1,
    ACTIONS(388), 1,
      anon_sym_SQUOTE,
    STATE(116), 1,
      sym_comment,
    STATE(121), 1,
      aux_sym_string_literal_repeat1,
    STATE(127), 2,
      sym_escape_sequence,
      sym_bad_escape,
    ACTIONS(382), 14,
      anon_sym_BSLASH_BSLASH,
      anon_sym_BSLASH_SQUOTE,
      anon_sym_BSLASHa,
      anon_sym_BSLASHb,
      anon_sym_BSLASHf,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASHv,
      aux_sym_escape_sequence_token1,
      aux_sym_escape_sequence_token2,
      aux_sym_escape_sequence_token3,
      aux_sym_escape_sequence_token4,
      aux_sym_escape_sequence_token5,
  [6812] = 8,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(380), 1,
      aux_sym_string_literal_token1,
    ACTIONS(384), 1,
      aux_sym_bad_escape_token1,
    ACTIONS(390), 1,
      anon_sym_SQUOTE,
    STATE(117), 1,
      sym_comment,
    STATE(118), 1,
      aux_sym_string_literal_repeat1,
    STATE(127), 2,
      sym_escape_sequence,
      sym_bad_escape,
    ACTIONS(382), 14,
      anon_sym_BSLASH_BSLASH,
      anon_sym_BSLASH_SQUOTE,
      anon_sym_BSLASHa,
      anon_sym_BSLASHb,
      anon_sym_BSLASHf,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASHv,
      aux_sym_escape_sequence_token1,
      aux_sym_escape_sequence_token2,
      aux_sym_escape_sequence_token3,
      aux_sym_escape_sequence_token4,
      aux_sym_escape_sequence_token5,
  [6851] = 8,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(380), 1,
      aux_sym_string_literal_token1,
    ACTIONS(384), 1,
      aux_sym_bad_escape_token1,
    ACTIONS(392), 1,
      anon_sym_SQUOTE,
    STATE(118), 1,
      sym_comment,
    STATE(121), 1,
      aux_sym_string_literal_repeat1,
    STATE(127), 2,
      sym_escape_sequence,
      sym_bad_escape,
    ACTIONS(382), 14,
      anon_sym_BSLASH_BSLASH,
      anon_sym_BSLASH_SQUOTE,
      anon_sym_BSLASHa,
      anon_sym_BSLASHb,
      anon_sym_BSLASHf,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASHv,
      aux_sym_escape_sequence_token1,
      aux_sym_escape_sequence_token2,
      aux_sym_escape_sequence_token3,
      aux_sym_escape_sequence_token4,
      aux_sym_escape_sequence_token5,
  [6890] = 8,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(380), 1,
      aux_sym_string_literal_token1,
    ACTIONS(384), 1,
      aux_sym_bad_escape_token1,
    ACTIONS(394), 1,
      anon_sym_SQUOTE,
    STATE(115), 1,
      aux_sym_string_literal_repeat1,
    STATE(119), 1,
      sym_comment,
    STATE(127), 2,
      sym_escape_sequence,
      sym_bad_escape,
    ACTIONS(382), 14,
      anon_sym_BSLASH_BSLASH,
      anon_sym_BSLASH_SQUOTE,
      anon_sym_BSLASHa,
      anon_sym_BSLASHb,
      anon_sym_BSLASHf,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASHv,
      aux_sym_escape_sequence_token1,
      aux_sym_escape_sequence_token2,
      aux_sym_escape_sequence_token3,
      aux_sym_escape_sequence_token4,
      aux_sym_escape_sequence_token5,
  [6929] = 8,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(380), 1,
      aux_sym_string_literal_token1,
    ACTIONS(384), 1,
      aux_sym_bad_escape_token1,
    ACTIONS(396), 1,
      anon_sym_SQUOTE,
    STATE(114), 1,
      aux_sym_string_literal_repeat1,
    STATE(120), 1,
      sym_comment,
    STATE(127), 2,
      sym_escape_sequence,
      sym_bad_escape,
    ACTIONS(382), 14,
      anon_sym_BSLASH_BSLASH,
      anon_sym_BSLASH_SQUOTE,
      anon_sym_BSLASHa,
      anon_sym_BSLASHb,
      anon_sym_BSLASHf,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASHv,
      aux_sym_escape_sequence_token1,
      aux_sym_escape_sequence_token2,
      aux_sym_escape_sequence_token3,
      aux_sym_escape_sequence_token4,
      aux_sym_escape_sequence_token5,
  [6968] = 7,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(398), 1,
      anon_sym_SQUOTE,
    ACTIONS(400), 1,
      aux_sym_string_literal_token1,
    ACTIONS(406), 1,
      aux_sym_bad_escape_token1,
    STATE(121), 2,
      sym_comment,
      aux_sym_string_literal_repeat1,
    STATE(127), 2,
      sym_escape_sequence,
      sym_bad_escape,
    ACTIONS(403), 14,
      anon_sym_BSLASH_BSLASH,
      anon_sym_BSLASH_SQUOTE,
      anon_sym_BSLASHa,
      anon_sym_BSLASHb,
      anon_sym_BSLASHf,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASHv,
      aux_sym_escape_sequence_token1,
      aux_sym_escape_sequence_token2,
      aux_sym_escape_sequence_token3,
      aux_sym_escape_sequence_token4,
      aux_sym_escape_sequence_token5,
  [7005] = 8,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(380), 1,
      aux_sym_string_literal_token1,
    ACTIONS(384), 1,
      aux_sym_bad_escape_token1,
    ACTIONS(409), 1,
      anon_sym_SQUOTE,
    STATE(116), 1,
      aux_sym_string_literal_repeat1,
    STATE(122), 1,
      sym_comment,
    STATE(127), 2,
      sym_escape_sequence,
      sym_bad_escape,
    ACTIONS(382), 14,
      anon_sym_BSLASH_BSLASH,
      anon_sym_BSLASH_SQUOTE,
      anon_sym_BSLASHa,
      anon_sym_BSLASHb,
      anon_sym_BSLASHf,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASHv,
      aux_sym_escape_sequence_token1,
      aux_sym_escape_sequence_token2,
      aux_sym_escape_sequence_token3,
      aux_sym_escape_sequence_token4,
      aux_sym_escape_sequence_token5,
  [7044] = 4,
    ACTIONS(11), 1,
      anon_sym_POUND,
    STATE(123), 1,
      sym_comment,
    ACTIONS(411), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(413), 17,
      sym_if,
      sym_foreach,
      sym_break,
      sym_continue,
      sym_not,
      sym_boolean_literal,
      sym_int_literal,
      anon_sym_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LPAREN,
  [7074] = 4,
    ACTIONS(11), 1,
      anon_sym_POUND,
    STATE(124), 1,
      sym_comment,
    ACTIONS(372), 2,
      ts_builtin_sym_end,
      anon_sym_LF,
    ACTIONS(370), 17,
      sym_if,
      sym_foreach,
      sym_break,
      sym_continue,
      sym_not,
      sym_boolean_literal,
      sym_int_literal,
      anon_sym_SQUOTE,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_f_SQUOTE,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_identifier,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LPAREN,
  [7104] = 3,
    ACTIONS(11), 1,
      anon_sym_POUND,
    STATE(125), 1,
      sym_comment,
    ACTIONS(415), 17,
      anon_sym_SQUOTE,
      aux_sym_string_literal_token1,
      anon_sym_BSLASH_BSLASH,
      anon_sym_BSLASH_SQUOTE,
      anon_sym_BSLASHa,
      anon_sym_BSLASHb,
      anon_sym_BSLASHf,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASHv,
      aux_sym_escape_sequence_token1,
      aux_sym_escape_sequence_token2,
      aux_sym_escape_sequence_token3,
      aux_sym_escape_sequence_token4,
      aux_sym_escape_sequence_token5,
      aux_sym_bad_escape_token1,
  [7130] = 3,
    ACTIONS(11), 1,
      anon_sym_POUND,
    STATE(126), 1,
      sym_comment,
    ACTIONS(417), 17,
      anon_sym_SQUOTE,
      aux_sym_string_literal_token1,
      anon_sym_BSLASH_BSLASH,
      anon_sym_BSLASH_SQUOTE,
      anon_sym_BSLASHa,
      anon_sym_BSLASHb,
      anon_sym_BSLASHf,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASHv,
      aux_sym_escape_sequence_token1,
      aux_sym_escape_sequence_token2,
      aux_sym_escape_sequence_token3,
      aux_sym_escape_sequence_token4,
      aux_sym_escape_sequence_token5,
      aux_sym_bad_escape_token1,
  [7156] = 3,
    ACTIONS(11), 1,
      anon_sym_POUND,
    STATE(127), 1,
      sym_comment,
    ACTIONS(419), 17,
      anon_sym_SQUOTE,
      aux_sym_string_literal_token1,
      anon_sym_BSLASH_BSLASH,
      anon_sym_BSLASH_SQUOTE,
      anon_sym_BSLASHa,
      anon_sym_BSLASHb,
      anon_sym_BSLASHf,
      anon_sym_BSLASHn,
      anon_sym_BSLASHr,
      anon_sym_BSLASHt,
      anon_sym_BSLASHv,
      aux_sym_escape_sequence_token1,
      aux_sym_escape_sequence_token2,
      aux_sym_escape_sequence_token3,
      aux_sym_escape_sequence_token4,
      aux_sym_escape_sequence_token5,
      aux_sym_bad_escape_token1,
  [7182] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(128), 1,
      sym_comment,
    ACTIONS(421), 5,
      sym_not,
      sym_boolean_literal,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      sym_identifier,
    ACTIONS(423), 8,
      sym_int_literal,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LPAREN,
  [7206] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(129), 1,
      sym_comment,
    ACTIONS(425), 5,
      sym_not,
      sym_boolean_literal,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      sym_identifier,
    ACTIONS(427), 8,
      sym_int_literal,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LPAREN,
  [7230] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(130), 1,
      sym_comment,
    ACTIONS(429), 5,
      sym_not,
      sym_boolean_literal,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      sym_identifier,
    ACTIONS(431), 8,
      sym_int_literal,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LPAREN,
  [7254] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(131), 1,
      sym_comment,
    ACTIONS(433), 5,
      sym_not,
      sym_boolean_literal,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      sym_identifier,
    ACTIONS(435), 8,
      sym_int_literal,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LPAREN,
  [7278] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(132), 1,
      sym_comment,
    ACTIONS(437), 5,
      sym_not,
      sym_boolean_literal,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      sym_identifier,
    ACTIONS(439), 8,
      sym_int_literal,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LPAREN,
  [7302] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(133), 1,
      sym_comment,
    ACTIONS(441), 5,
      sym_not,
      sym_boolean_literal,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      sym_identifier,
    ACTIONS(443), 8,
      sym_int_literal,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LPAREN,
  [7326] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(134), 1,
      sym_comment,
    ACTIONS(445), 5,
      sym_not,
      sym_boolean_literal,
      anon_sym_SQUOTE,
      anon_sym_f_SQUOTE,
      sym_identifier,
    ACTIONS(447), 8,
      sym_int_literal,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_f_SQUOTE_SQUOTE_SQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_LPAREN,
  [7350] = 6,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(449), 1,
      sym_elif,
    ACTIONS(451), 1,
      sym_else,
    ACTIONS(453), 1,
      sym_endif,
    STATE(135), 1,
      sym_comment,
    STATE(136), 1,
      aux_sym_selection_statement_repeat1,
  [7369] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(455), 1,
      sym_elif,
    ACTIONS(458), 2,
      sym_else,
      sym_endif,
    STATE(136), 2,
      sym_comment,
      aux_sym_selection_statement_repeat1,
  [7384] = 6,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(449), 1,
      sym_elif,
    ACTIONS(460), 1,
      sym_else,
    ACTIONS(462), 1,
      sym_endif,
    STATE(135), 1,
      aux_sym_selection_statement_repeat1,
    STATE(137), 1,
      sym_comment,
  [7403] = 6,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(449), 1,
      sym_elif,
    ACTIONS(460), 1,
      sym_else,
    ACTIONS(462), 1,
      sym_endif,
    STATE(136), 1,
      aux_sym_selection_statement_repeat1,
    STATE(138), 1,
      sym_comment,
  [7422] = 5,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(464), 1,
      anon_sym_COMMA,
    ACTIONS(466), 1,
      anon_sym_RBRACE,
    STATE(139), 1,
      sym_comment,
    STATE(162), 1,
      aux_sym__key_value_list_repeat1,
  [7438] = 5,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(386), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(468), 1,
      aux_sym_string_literal_token2,
    STATE(140), 1,
      sym_comment,
    STATE(158), 1,
      aux_sym_string_literal_repeat2,
  [7454] = 5,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(470), 1,
      anon_sym_COMMA,
    ACTIONS(473), 1,
      anon_sym_RPAREN,
    STATE(141), 1,
      sym_comment,
    STATE(152), 1,
      aux_sym__positional_arguments_repeat1,
  [7470] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(475), 1,
      anon_sym_COMMA,
    ACTIONS(478), 1,
      anon_sym_RPAREN,
    STATE(142), 2,
      sym_comment,
      aux_sym__keyword_arguments_repeat1,
  [7484] = 5,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(480), 1,
      anon_sym_COMMA,
    ACTIONS(482), 1,
      anon_sym_COLON,
    STATE(143), 1,
      sym_comment,
    STATE(150), 1,
      aux_sym_identifier_list_repeat1,
  [7500] = 5,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(484), 1,
      sym_identifier,
    STATE(144), 1,
      sym_comment,
    STATE(160), 1,
      sym_keyword_argument,
    STATE(183), 1,
      sym__keyword_arguments,
  [7516] = 5,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(396), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(468), 1,
      aux_sym_string_literal_token2,
    STATE(145), 1,
      sym_comment,
    STATE(154), 1,
      aux_sym_string_literal_repeat2,
  [7532] = 5,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(390), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(468), 1,
      aux_sym_string_literal_token2,
    STATE(146), 1,
      sym_comment,
    STATE(159), 1,
      aux_sym_string_literal_repeat2,
  [7548] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(486), 1,
      anon_sym_COMMA,
    ACTIONS(489), 1,
      anon_sym_RBRACE,
    STATE(147), 2,
      sym_comment,
      aux_sym__key_value_list_repeat1,
  [7562] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(148), 1,
      sym_comment,
    ACTIONS(491), 3,
      sym_elif,
      sym_else,
      sym_endif,
  [7574] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(340), 1,
      anon_sym_RBRACK,
    ACTIONS(493), 1,
      anon_sym_COMMA,
    STATE(149), 2,
      sym_comment,
      aux_sym__expression_list_repeat1,
  [7588] = 5,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(480), 1,
      anon_sym_COMMA,
    ACTIONS(496), 1,
      anon_sym_COLON,
    STATE(150), 1,
      sym_comment,
    STATE(153), 1,
      aux_sym_identifier_list_repeat1,
  [7604] = 5,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(388), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(468), 1,
      aux_sym_string_literal_token2,
    STATE(151), 1,
      sym_comment,
    STATE(158), 1,
      aux_sym_string_literal_repeat2,
  [7620] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(498), 1,
      anon_sym_COMMA,
    ACTIONS(501), 1,
      anon_sym_RPAREN,
    STATE(152), 2,
      sym_comment,
      aux_sym__positional_arguments_repeat1,
  [7634] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(503), 1,
      anon_sym_COMMA,
    ACTIONS(506), 1,
      anon_sym_COLON,
    STATE(153), 2,
      sym_comment,
      aux_sym_identifier_list_repeat1,
  [7648] = 5,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(378), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(468), 1,
      aux_sym_string_literal_token2,
    STATE(154), 1,
      sym_comment,
    STATE(158), 1,
      aux_sym_string_literal_repeat2,
  [7664] = 5,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(394), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(468), 1,
      aux_sym_string_literal_token2,
    STATE(140), 1,
      aux_sym_string_literal_repeat2,
    STATE(155), 1,
      sym_comment,
  [7680] = 5,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(508), 1,
      anon_sym_COMMA,
    ACTIONS(510), 1,
      anon_sym_RPAREN,
    STATE(142), 1,
      aux_sym__keyword_arguments_repeat1,
    STATE(156), 1,
      sym_comment,
  [7696] = 5,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(409), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(468), 1,
      aux_sym_string_literal_token2,
    STATE(151), 1,
      aux_sym_string_literal_repeat2,
    STATE(157), 1,
      sym_comment,
  [7712] = 4,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(512), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(514), 1,
      aux_sym_string_literal_token2,
    STATE(158), 2,
      sym_comment,
      aux_sym_string_literal_repeat2,
  [7726] = 5,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(392), 1,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
    ACTIONS(468), 1,
      aux_sym_string_literal_token2,
    STATE(158), 1,
      aux_sym_string_literal_repeat2,
    STATE(159), 1,
      sym_comment,
  [7742] = 5,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(508), 1,
      anon_sym_COMMA,
    ACTIONS(517), 1,
      anon_sym_RPAREN,
    STATE(156), 1,
      aux_sym__keyword_arguments_repeat1,
    STATE(160), 1,
      sym_comment,
  [7758] = 5,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(519), 1,
      anon_sym_COMMA,
    ACTIONS(522), 1,
      anon_sym_RPAREN,
    STATE(141), 1,
      aux_sym__positional_arguments_repeat1,
    STATE(161), 1,
      sym_comment,
  [7774] = 5,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(464), 1,
      anon_sym_COMMA,
    ACTIONS(524), 1,
      anon_sym_RBRACE,
    STATE(147), 1,
      aux_sym__key_value_list_repeat1,
    STATE(162), 1,
      sym_comment,
  [7790] = 5,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(322), 1,
      anon_sym_COMMA,
    ACTIONS(526), 1,
      anon_sym_RBRACK,
    STATE(149), 1,
      aux_sym__expression_list_repeat1,
    STATE(163), 1,
      sym_comment,
  [7806] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(528), 1,
      sym_identifier,
    STATE(81), 1,
      sym_function_expression,
    STATE(164), 1,
      sym_comment,
  [7819] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(165), 1,
      sym_comment,
    ACTIONS(501), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [7830] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(530), 1,
      anon_sym_COMMA,
    ACTIONS(532), 1,
      anon_sym_RPAREN,
    STATE(166), 1,
      sym_comment,
  [7843] = 3,
    ACTIONS(11), 1,
      anon_sym_POUND,
    STATE(167), 1,
      sym_comment,
    ACTIONS(534), 2,
      anon_sym_SQUOTE_SQUOTE_SQUOTE,
      aux_sym_string_literal_token2,
  [7854] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(536), 1,
      sym_identifier,
    STATE(168), 1,
      sym_comment,
    STATE(177), 1,
      sym_identifier_list,
  [7867] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(538), 1,
      sym_identifier,
    STATE(93), 1,
      sym_function_expression,
    STATE(169), 1,
      sym_comment,
  [7880] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(170), 1,
      sym_comment,
    ACTIONS(506), 2,
      anon_sym_COMMA,
      anon_sym_COLON,
  [7891] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(171), 1,
      sym_comment,
    ACTIONS(489), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [7902] = 4,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(484), 1,
      sym_identifier,
    STATE(172), 1,
      sym_comment,
    STATE(173), 1,
      sym_keyword_argument,
  [7915] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    STATE(173), 1,
      sym_comment,
    ACTIONS(478), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [7926] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(453), 1,
      sym_endif,
    STATE(174), 1,
      sym_comment,
  [7936] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(540), 1,
      sym_identifier,
    STATE(175), 1,
      sym_comment,
  [7946] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(542), 1,
      sym_endif,
    STATE(176), 1,
      sym_comment,
  [7956] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(544), 1,
      anon_sym_COLON,
    STATE(177), 1,
      sym_comment,
  [7966] = 3,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(546), 1,
      anon_sym_LF,
    STATE(178), 1,
      sym_comment,
  [7976] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(548), 1,
      anon_sym_RBRACE,
    STATE(179), 1,
      sym_comment,
  [7986] = 3,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(550), 1,
      anon_sym_LF,
    STATE(180), 1,
      sym_comment,
  [7996] = 3,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(552), 1,
      anon_sym_LF,
    STATE(181), 1,
      sym_comment,
  [8006] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(554), 1,
      ts_builtin_sym_end,
    STATE(182), 1,
      sym_comment,
  [8016] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(556), 1,
      anon_sym_RPAREN,
    STATE(183), 1,
      sym_comment,
  [8026] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(368), 1,
      anon_sym_COLON,
    STATE(184), 1,
      sym_comment,
  [8036] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(558), 1,
      sym_in,
    STATE(185), 1,
      sym_comment,
  [8046] = 3,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(560), 1,
      anon_sym_LF,
    STATE(186), 1,
      sym_comment,
  [8056] = 3,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(562), 1,
      anon_sym_LF,
    STATE(187), 1,
      sym_comment,
  [8066] = 3,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(564), 1,
      anon_sym_LF,
    STATE(188), 1,
      sym_comment,
  [8076] = 3,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(566), 1,
      anon_sym_LF,
    STATE(189), 1,
      sym_comment,
  [8086] = 3,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      anon_sym_LF,
    STATE(190), 1,
      sym_comment,
  [8096] = 3,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(570), 1,
      anon_sym_LF,
    STATE(191), 1,
      sym_comment,
  [8106] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(572), 1,
      anon_sym_RBRACK,
    STATE(192), 1,
      sym_comment,
  [8116] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(574), 1,
      sym_identifier,
    STATE(193), 1,
      sym_comment,
  [8126] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(576), 1,
      sym_endforeach,
    STATE(194), 1,
      sym_comment,
  [8136] = 3,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(578), 1,
      anon_sym_LF,
    STATE(195), 1,
      sym_comment,
  [8146] = 3,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(580), 1,
      anon_sym_LF,
    STATE(196), 1,
      sym_comment,
  [8156] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(582), 1,
      anon_sym_RBRACK,
    STATE(197), 1,
      sym_comment,
  [8166] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(584), 1,
      anon_sym_RBRACE,
    STATE(198), 1,
      sym_comment,
  [8176] = 3,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(586), 1,
      aux_sym_comment_token1,
    STATE(199), 1,
      sym_comment,
  [8186] = 3,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(588), 1,
      anon_sym_LF,
    STATE(200), 1,
      sym_comment,
  [8196] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(590), 1,
      sym_endif,
    STATE(201), 1,
      sym_comment,
  [8206] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(592), 1,
      anon_sym_RPAREN,
    STATE(202), 1,
      sym_comment,
  [8216] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(594), 1,
      anon_sym_LPAREN,
    STATE(203), 1,
      sym_comment,
  [8226] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(532), 1,
      anon_sym_RPAREN,
    STATE(204), 1,
      sym_comment,
  [8236] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(348), 1,
      anon_sym_LPAREN,
    STATE(205), 1,
      sym_comment,
  [8246] = 3,
    ACTIONS(11), 1,
      anon_sym_POUND,
    ACTIONS(596), 1,
      anon_sym_LF,
    STATE(206), 1,
      sym_comment,
  [8256] = 3,
    ACTIONS(3), 1,
      anon_sym_POUND,
    ACTIONS(598), 1,
      anon_sym_RPAREN,
    STATE(207), 1,
      sym_comment,
  [8266] = 1,
    ACTIONS(600), 1,
      ts_builtin_sym_end,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 108,
  [SMALL_STATE(4)] = 209,
  [SMALL_STATE(5)] = 306,
  [SMALL_STATE(6)] = 405,
  [SMALL_STATE(7)] = 498,
  [SMALL_STATE(8)] = 597,
  [SMALL_STATE(9)] = 696,
  [SMALL_STATE(10)] = 795,
  [SMALL_STATE(11)] = 894,
  [SMALL_STATE(12)] = 989,
  [SMALL_STATE(13)] = 1078,
  [SMALL_STATE(14)] = 1167,
  [SMALL_STATE(15)] = 1247,
  [SMALL_STATE(16)] = 1327,
  [SMALL_STATE(17)] = 1404,
  [SMALL_STATE(18)] = 1481,
  [SMALL_STATE(19)] = 1555,
  [SMALL_STATE(20)] = 1629,
  [SMALL_STATE(21)] = 1703,
  [SMALL_STATE(22)] = 1777,
  [SMALL_STATE(23)] = 1848,
  [SMALL_STATE(24)] = 1919,
  [SMALL_STATE(25)] = 1988,
  [SMALL_STATE(26)] = 2059,
  [SMALL_STATE(27)] = 2130,
  [SMALL_STATE(28)] = 2201,
  [SMALL_STATE(29)] = 2272,
  [SMALL_STATE(30)] = 2343,
  [SMALL_STATE(31)] = 2414,
  [SMALL_STATE(32)] = 2485,
  [SMALL_STATE(33)] = 2556,
  [SMALL_STATE(34)] = 2627,
  [SMALL_STATE(35)] = 2698,
  [SMALL_STATE(36)] = 2769,
  [SMALL_STATE(37)] = 2840,
  [SMALL_STATE(38)] = 2909,
  [SMALL_STATE(39)] = 2980,
  [SMALL_STATE(40)] = 3051,
  [SMALL_STATE(41)] = 3122,
  [SMALL_STATE(42)] = 3193,
  [SMALL_STATE(43)] = 3264,
  [SMALL_STATE(44)] = 3335,
  [SMALL_STATE(45)] = 3406,
  [SMALL_STATE(46)] = 3477,
  [SMALL_STATE(47)] = 3548,
  [SMALL_STATE(48)] = 3619,
  [SMALL_STATE(49)] = 3690,
  [SMALL_STATE(50)] = 3750,
  [SMALL_STATE(51)] = 3818,
  [SMALL_STATE(52)] = 3870,
  [SMALL_STATE(53)] = 3920,
  [SMALL_STATE(54)] = 3976,
  [SMALL_STATE(55)] = 4034,
  [SMALL_STATE(56)] = 4082,
  [SMALL_STATE(57)] = 4150,
  [SMALL_STATE(58)] = 4198,
  [SMALL_STATE(59)] = 4264,
  [SMALL_STATE(60)] = 4320,
  [SMALL_STATE(61)] = 4378,
  [SMALL_STATE(62)] = 4432,
  [SMALL_STATE(63)] = 4478,
  [SMALL_STATE(64)] = 4528,
  [SMALL_STATE(65)] = 4594,
  [SMALL_STATE(66)] = 4633,
  [SMALL_STATE(67)] = 4669,
  [SMALL_STATE(68)] = 4705,
  [SMALL_STATE(69)] = 4741,
  [SMALL_STATE(70)] = 4777,
  [SMALL_STATE(71)] = 4813,
  [SMALL_STATE(72)] = 4849,
  [SMALL_STATE(73)] = 4885,
  [SMALL_STATE(74)] = 4921,
  [SMALL_STATE(75)] = 4957,
  [SMALL_STATE(76)] = 4993,
  [SMALL_STATE(77)] = 5029,
  [SMALL_STATE(78)] = 5097,
  [SMALL_STATE(79)] = 5133,
  [SMALL_STATE(80)] = 5169,
  [SMALL_STATE(81)] = 5205,
  [SMALL_STATE(82)] = 5241,
  [SMALL_STATE(83)] = 5304,
  [SMALL_STATE(84)] = 5367,
  [SMALL_STATE(85)] = 5430,
  [SMALL_STATE(86)] = 5493,
  [SMALL_STATE(87)] = 5530,
  [SMALL_STATE(88)] = 5564,
  [SMALL_STATE(89)] = 5598,
  [SMALL_STATE(90)] = 5660,
  [SMALL_STATE(91)] = 5694,
  [SMALL_STATE(92)] = 5728,
  [SMALL_STATE(93)] = 5788,
  [SMALL_STATE(94)] = 5822,
  [SMALL_STATE(95)] = 5884,
  [SMALL_STATE(96)] = 5946,
  [SMALL_STATE(97)] = 5980,
  [SMALL_STATE(98)] = 6042,
  [SMALL_STATE(99)] = 6076,
  [SMALL_STATE(100)] = 6110,
  [SMALL_STATE(101)] = 6172,
  [SMALL_STATE(102)] = 6234,
  [SMALL_STATE(103)] = 6296,
  [SMALL_STATE(104)] = 6356,
  [SMALL_STATE(105)] = 6390,
  [SMALL_STATE(106)] = 6424,
  [SMALL_STATE(107)] = 6458,
  [SMALL_STATE(108)] = 6492,
  [SMALL_STATE(109)] = 6526,
  [SMALL_STATE(110)] = 6560,
  [SMALL_STATE(111)] = 6594,
  [SMALL_STATE(112)] = 6631,
  [SMALL_STATE(113)] = 6663,
  [SMALL_STATE(114)] = 6695,
  [SMALL_STATE(115)] = 6734,
  [SMALL_STATE(116)] = 6773,
  [SMALL_STATE(117)] = 6812,
  [SMALL_STATE(118)] = 6851,
  [SMALL_STATE(119)] = 6890,
  [SMALL_STATE(120)] = 6929,
  [SMALL_STATE(121)] = 6968,
  [SMALL_STATE(122)] = 7005,
  [SMALL_STATE(123)] = 7044,
  [SMALL_STATE(124)] = 7074,
  [SMALL_STATE(125)] = 7104,
  [SMALL_STATE(126)] = 7130,
  [SMALL_STATE(127)] = 7156,
  [SMALL_STATE(128)] = 7182,
  [SMALL_STATE(129)] = 7206,
  [SMALL_STATE(130)] = 7230,
  [SMALL_STATE(131)] = 7254,
  [SMALL_STATE(132)] = 7278,
  [SMALL_STATE(133)] = 7302,
  [SMALL_STATE(134)] = 7326,
  [SMALL_STATE(135)] = 7350,
  [SMALL_STATE(136)] = 7369,
  [SMALL_STATE(137)] = 7384,
  [SMALL_STATE(138)] = 7403,
  [SMALL_STATE(139)] = 7422,
  [SMALL_STATE(140)] = 7438,
  [SMALL_STATE(141)] = 7454,
  [SMALL_STATE(142)] = 7470,
  [SMALL_STATE(143)] = 7484,
  [SMALL_STATE(144)] = 7500,
  [SMALL_STATE(145)] = 7516,
  [SMALL_STATE(146)] = 7532,
  [SMALL_STATE(147)] = 7548,
  [SMALL_STATE(148)] = 7562,
  [SMALL_STATE(149)] = 7574,
  [SMALL_STATE(150)] = 7588,
  [SMALL_STATE(151)] = 7604,
  [SMALL_STATE(152)] = 7620,
  [SMALL_STATE(153)] = 7634,
  [SMALL_STATE(154)] = 7648,
  [SMALL_STATE(155)] = 7664,
  [SMALL_STATE(156)] = 7680,
  [SMALL_STATE(157)] = 7696,
  [SMALL_STATE(158)] = 7712,
  [SMALL_STATE(159)] = 7726,
  [SMALL_STATE(160)] = 7742,
  [SMALL_STATE(161)] = 7758,
  [SMALL_STATE(162)] = 7774,
  [SMALL_STATE(163)] = 7790,
  [SMALL_STATE(164)] = 7806,
  [SMALL_STATE(165)] = 7819,
  [SMALL_STATE(166)] = 7830,
  [SMALL_STATE(167)] = 7843,
  [SMALL_STATE(168)] = 7854,
  [SMALL_STATE(169)] = 7867,
  [SMALL_STATE(170)] = 7880,
  [SMALL_STATE(171)] = 7891,
  [SMALL_STATE(172)] = 7902,
  [SMALL_STATE(173)] = 7915,
  [SMALL_STATE(174)] = 7926,
  [SMALL_STATE(175)] = 7936,
  [SMALL_STATE(176)] = 7946,
  [SMALL_STATE(177)] = 7956,
  [SMALL_STATE(178)] = 7966,
  [SMALL_STATE(179)] = 7976,
  [SMALL_STATE(180)] = 7986,
  [SMALL_STATE(181)] = 7996,
  [SMALL_STATE(182)] = 8006,
  [SMALL_STATE(183)] = 8016,
  [SMALL_STATE(184)] = 8026,
  [SMALL_STATE(185)] = 8036,
  [SMALL_STATE(186)] = 8046,
  [SMALL_STATE(187)] = 8056,
  [SMALL_STATE(188)] = 8066,
  [SMALL_STATE(189)] = 8076,
  [SMALL_STATE(190)] = 8086,
  [SMALL_STATE(191)] = 8096,
  [SMALL_STATE(192)] = 8106,
  [SMALL_STATE(193)] = 8116,
  [SMALL_STATE(194)] = 8126,
  [SMALL_STATE(195)] = 8136,
  [SMALL_STATE(196)] = 8146,
  [SMALL_STATE(197)] = 8156,
  [SMALL_STATE(198)] = 8166,
  [SMALL_STATE(199)] = 8176,
  [SMALL_STATE(200)] = 8186,
  [SMALL_STATE(201)] = 8196,
  [SMALL_STATE(202)] = 8206,
  [SMALL_STATE(203)] = 8216,
  [SMALL_STATE(204)] = 8226,
  [SMALL_STATE(205)] = 8236,
  [SMALL_STATE(206)] = 8246,
  [SMALL_STATE(207)] = 8256,
  [SMALL_STATE(208)] = 8266,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_build_definition, 0),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(65),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(199),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(20),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(168),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(206),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(132),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(67),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(117),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(146),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(119),
  [29] = {.entry = {.count = 1, .reusable = false}}, SHIFT(155),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(17),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(15),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(43),
  [37] = {.entry = {.count = 1, .reusable = false}}, SHIFT(19),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT(8),
  [41] = {.entry = {.count = 1, .reusable = false}}, SHIFT(200),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(186),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [53] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [55] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [57] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [59] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_selection_statement_repeat1, 3),
  [61] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_statement_list_repeat1, 2), SHIFT_REPEAT(65),
  [64] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_statement_list_repeat1, 2), SHIFT_REPEAT(20),
  [67] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_statement_list_repeat1, 2),
  [69] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_statement_list_repeat1, 2), SHIFT_REPEAT(168),
  [72] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_statement_list_repeat1, 2), SHIFT_REPEAT(186),
  [75] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_statement_list_repeat1, 2), SHIFT_REPEAT(132),
  [78] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_statement_list_repeat1, 2), SHIFT_REPEAT(67),
  [81] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_list_repeat1, 2), SHIFT_REPEAT(67),
  [84] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_statement_list_repeat1, 2), SHIFT_REPEAT(117),
  [87] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_list_repeat1, 2), SHIFT_REPEAT(146),
  [90] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_statement_list_repeat1, 2), SHIFT_REPEAT(119),
  [93] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_list_repeat1, 2), SHIFT_REPEAT(155),
  [96] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_list_repeat1, 2), SHIFT_REPEAT(17),
  [99] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_list_repeat1, 2), SHIFT_REPEAT(15),
  [102] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_list_repeat1, 2), SHIFT_REPEAT(132),
  [105] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_statement_list_repeat1, 2), SHIFT_REPEAT(43),
  [108] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement_list, 1),
  [110] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_build_definition_repeat1, 2),
  [112] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_build_definition_repeat1, 2), SHIFT_REPEAT(65),
  [115] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_build_definition_repeat1, 2), SHIFT_REPEAT(123),
  [118] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_build_definition_repeat1, 2), SHIFT_REPEAT(20),
  [121] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_build_definition_repeat1, 2), SHIFT_REPEAT(168),
  [124] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_build_definition_repeat1, 2), SHIFT_REPEAT(206),
  [127] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_build_definition_repeat1, 2), SHIFT_REPEAT(132),
  [130] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_build_definition_repeat1, 2), SHIFT_REPEAT(67),
  [133] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_build_definition_repeat1, 2), SHIFT_REPEAT(117),
  [136] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_build_definition_repeat1, 2), SHIFT_REPEAT(146),
  [139] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_build_definition_repeat1, 2), SHIFT_REPEAT(119),
  [142] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_build_definition_repeat1, 2), SHIFT_REPEAT(155),
  [145] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_build_definition_repeat1, 2), SHIFT_REPEAT(17),
  [148] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_build_definition_repeat1, 2), SHIFT_REPEAT(15),
  [151] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_build_definition_repeat1, 2), SHIFT_REPEAT(43),
  [154] = {.entry = {.count = 1, .reusable = false}}, SHIFT(196),
  [156] = {.entry = {.count = 1, .reusable = false}}, SHIFT(188),
  [158] = {.entry = {.count = 1, .reusable = false}}, SHIFT(178),
  [160] = {.entry = {.count = 1, .reusable = false}}, SHIFT(191),
  [162] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_build_definition, 1),
  [164] = {.entry = {.count = 1, .reusable = false}}, SHIFT(111),
  [166] = {.entry = {.count = 1, .reusable = false}}, SHIFT(110),
  [168] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [170] = {.entry = {.count = 1, .reusable = false}}, SHIFT(122),
  [172] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [174] = {.entry = {.count = 1, .reusable = false}}, SHIFT(120),
  [176] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [178] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [180] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [182] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [184] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [186] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [188] = {.entry = {.count = 1, .reusable = false}}, SHIFT(86),
  [190] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [192] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [194] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [196] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [198] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expression_statement, 1),
  [200] = {.entry = {.count = 1, .reusable = false}}, SHIFT(47),
  [202] = {.entry = {.count = 1, .reusable = false}}, SHIFT(44),
  [204] = {.entry = {.count = 1, .reusable = false}}, SHIFT(185),
  [206] = {.entry = {.count = 1, .reusable = false}}, SHIFT(130),
  [208] = {.entry = {.count = 1, .reusable = false}}, SHIFT(41),
  [210] = {.entry = {.count = 1, .reusable = false}}, SHIFT(134),
  [212] = {.entry = {.count = 1, .reusable = false}}, SHIFT(23),
  [214] = {.entry = {.count = 1, .reusable = false}}, SHIFT(128),
  [216] = {.entry = {.count = 1, .reusable = false}}, SHIFT(133),
  [218] = {.entry = {.count = 1, .reusable = false}}, SHIFT(129),
  [220] = {.entry = {.count = 1, .reusable = false}}, SHIFT(164),
  [222] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_logical_or_expression, 3),
  [224] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_logical_or_expression, 3),
  [226] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_conditional_expression, 5, .production_id = 4),
  [228] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_conditional_expression, 5, .production_id = 4),
  [230] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_relational_expression, 3),
  [232] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_relational_expression, 3),
  [234] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_additive_expression, 3),
  [236] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_additive_expression, 3),
  [238] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_equality_expression, 3),
  [240] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_equality_expression, 3),
  [242] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_logical_and_expression, 3),
  [244] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_logical_and_expression, 3),
  [246] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_multiplicative_expression, 3),
  [248] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_multiplicative_expression, 3),
  [250] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_expression, 2),
  [252] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_expression, 2),
  [254] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [256] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [258] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [260] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [262] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [264] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [266] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [268] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [270] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [272] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [274] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expression, 1),
  [276] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expression, 1),
  [278] = {.entry = {.count = 1, .reusable = false}}, SHIFT(13),
  [280] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_subscript_expression, 4),
  [282] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_subscript_expression, 4),
  [284] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__literal, 1),
  [286] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__literal, 1),
  [288] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string_literal, 3),
  [290] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_literal, 3),
  [292] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_primary_expression, 3),
  [294] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_primary_expression, 3),
  [296] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string_literal, 2),
  [298] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_literal, 2),
  [300] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fstring_literal, 3),
  [302] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_fstring_literal, 3),
  [304] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array_literal, 3),
  [306] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array_literal, 3),
  [308] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_expression, 4, .production_id = 1),
  [310] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_expression, 4, .production_id = 1),
  [312] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dictionary_literal, 2),
  [314] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dictionary_literal, 2),
  [316] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dictionary_literal, 3),
  [318] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dictionary_literal, 3),
  [320] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression_list, 1),
  [322] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [324] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array_literal, 2),
  [326] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array_literal, 2),
  [328] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_expression, 3, .production_id = 1),
  [330] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_expression, 3, .production_id = 1),
  [332] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_fstring_literal, 2),
  [334] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_fstring_literal, 2),
  [336] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method_expression, 3),
  [338] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method_expression, 3),
  [340] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__expression_list_repeat1, 2),
  [342] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_key_value_item, 3, .production_id = 2),
  [344] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_keyword_argument, 3, .production_id = 3),
  [346] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument, 1),
  [348] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [350] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [352] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition, 1),
  [354] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [356] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [358] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [360] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [362] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [364] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [366] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment_statement, 3),
  [368] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [370] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 2),
  [372] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 2),
  [374] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_statement_list_repeat1, 1),
  [376] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_statement_list_repeat1, 1),
  [378] = {.entry = {.count = 1, .reusable = false}}, SHIFT(108),
  [380] = {.entry = {.count = 1, .reusable = false}}, SHIFT(127),
  [382] = {.entry = {.count = 1, .reusable = false}}, SHIFT(126),
  [384] = {.entry = {.count = 1, .reusable = false}}, SHIFT(125),
  [386] = {.entry = {.count = 1, .reusable = false}}, SHIFT(71),
  [388] = {.entry = {.count = 1, .reusable = false}}, SHIFT(109),
  [390] = {.entry = {.count = 1, .reusable = false}}, SHIFT(70),
  [392] = {.entry = {.count = 1, .reusable = false}}, SHIFT(68),
  [394] = {.entry = {.count = 1, .reusable = false}}, SHIFT(80),
  [396] = {.entry = {.count = 1, .reusable = false}}, SHIFT(104),
  [398] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_literal_repeat1, 2),
  [400] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_literal_repeat1, 2), SHIFT_REPEAT(127),
  [403] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_literal_repeat1, 2), SHIFT_REPEAT(126),
  [406] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_literal_repeat1, 2), SHIFT_REPEAT(125),
  [409] = {.entry = {.count = 1, .reusable = false}}, SHIFT(106),
  [411] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_build_definition_repeat1, 1),
  [413] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_build_definition_repeat1, 1),
  [415] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bad_escape, 1),
  [417] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_escape_sequence, 1),
  [419] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_literal_repeat1, 1),
  [421] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_equality_operator, 1),
  [423] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_equality_operator, 1),
  [425] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_multiplicative_operator, 1),
  [427] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_multiplicative_operator, 1),
  [429] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_relational_operator, 1),
  [431] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_relational_operator, 1),
  [433] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_relational_operator, 2),
  [435] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_relational_operator, 2),
  [437] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_operator, 1),
  [439] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_operator, 1),
  [441] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_additive_operator, 1),
  [443] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_additive_operator, 1),
  [445] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assignment_operator, 1),
  [447] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment_operator, 1),
  [449] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [451] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [453] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [455] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_selection_statement_repeat1, 2), SHIFT_REPEAT(19),
  [458] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_selection_statement_repeat1, 2),
  [460] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [462] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [464] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [466] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__key_value_list, 1),
  [468] = {.entry = {.count = 1, .reusable = false}}, SHIFT(167),
  [470] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym__positional_arguments, 2), SHIFT(18),
  [473] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__positional_arguments, 2),
  [475] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__keyword_arguments_repeat1, 2), SHIFT_REPEAT(172),
  [478] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__keyword_arguments_repeat1, 2),
  [480] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [482] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_identifier_list, 1),
  [484] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [486] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__key_value_list_repeat1, 2), SHIFT_REPEAT(21),
  [489] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__key_value_list_repeat1, 2),
  [491] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_selection_statement_repeat1, 4),
  [493] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__expression_list_repeat1, 2), SHIFT_REPEAT(46),
  [496] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_identifier_list, 2),
  [498] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__positional_arguments_repeat1, 2), SHIFT_REPEAT(18),
  [501] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__positional_arguments_repeat1, 2),
  [503] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_identifier_list_repeat1, 2), SHIFT_REPEAT(193),
  [506] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_identifier_list_repeat1, 2),
  [508] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [510] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__keyword_arguments, 2),
  [512] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_literal_repeat2, 2),
  [514] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_literal_repeat2, 2), SHIFT_REPEAT(167),
  [517] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__keyword_arguments, 1),
  [519] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym__positional_arguments, 1), SHIFT(18),
  [522] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__positional_arguments, 1),
  [524] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__key_value_list, 2),
  [526] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression_list, 2),
  [528] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [530] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [532] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__argument_list, 1),
  [534] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_literal_repeat2, 1),
  [536] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [538] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [540] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [542] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [544] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [546] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_selection_statement, 6),
  [548] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [550] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [552] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [554] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [556] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__argument_list, 3),
  [558] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [560] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [562] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_selection_statement, 8),
  [564] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_selection_statement, 5),
  [566] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [568] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_iteration_statement, 7),
  [570] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_iteration_statement, 6),
  [572] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [574] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [576] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [578] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [580] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_selection_statement, 7),
  [582] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [584] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [586] = {.entry = {.count = 1, .reusable = false}}, SHIFT(181),
  [588] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_selection_statement, 4),
  [590] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [592] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [594] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [596] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [598] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [600] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comment, 3),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_meson(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_identifier,
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
