//                     usage.cc

#include "main.ih"

namespace {
char const info[] = R"_( [options] arg
Where:
    [options] - optional arguments (short options between parentheses):
        --colors (-c)       - the compiler uses diagnostic colors 
                              (default: no colors).
        --dependencies (-d) - no compilation, merely show the dependencies
        --ignore (-i) list  - all subdirs except for those listed in 'list'
                              are visited, CLASSES is not used. 
                              Use --ignore '' to visit all subdirs.
        --help (-h)         - provide this help.
        --module (-m) file  - file: source file name defining the module's
                              interface (default: module.cc).
        --subdir (-s)       - the compiled module.cc files are located in the
                              directories containing the module.cc files.
                              (default: in the project's tmp/o sub-directory,
                              where each module.o file is then prefixed by a
                              unique number (e.g., 1module.o, 2module.o, ...).
        --version (-v)      - show version information and terminate.
        --verbose (-V)      - show details of performed steps.

    arg - starting directory. Use . for the current working directory.

    Files are compiled using the standard specified bu the ICMAKE_CPPSTD
    environment variable. If that standard isn't specified the compiler's
    default C++ standard is used.
)_";

}

void usage(std::string const &progname)
{
    Tools::usageTop(progname) << info;
}




