/* Generated by wayland-scanner 1.24.0 */

#ifndef SLIDE_CLIENT_PROTOCOL_H
#define SLIDE_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client-core.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_slide The slide protocol
 * @section page_ifaces_slide Interfaces
 * - @subpage page_iface_org_kde_kwin_slide_manager - 
 * - @subpage page_iface_org_kde_kwin_slide - slide a surface from a location to another
 * @section page_copyright_slide Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2015 Martin Gräßlin
 * SPDX-FileCopyrightText: 2015 Marco Martin
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 * </pre>
 */
struct org_kde_kwin_slide;
struct org_kde_kwin_slide_manager;
struct wl_surface;

#ifndef ORG_KDE_KWIN_SLIDE_MANAGER_INTERFACE
#define ORG_KDE_KWIN_SLIDE_MANAGER_INTERFACE
/**
 * @page page_iface_org_kde_kwin_slide_manager org_kde_kwin_slide_manager
 * @section page_iface_org_kde_kwin_slide_manager_api API
 * See @ref iface_org_kde_kwin_slide_manager.
 */
/**
 * @defgroup iface_org_kde_kwin_slide_manager The org_kde_kwin_slide_manager interface
 */
extern const struct wl_interface org_kde_kwin_slide_manager_interface;
#endif
#ifndef ORG_KDE_KWIN_SLIDE_INTERFACE
#define ORG_KDE_KWIN_SLIDE_INTERFACE
/**
 * @page page_iface_org_kde_kwin_slide org_kde_kwin_slide
 * @section page_iface_org_kde_kwin_slide_desc Description
 *
 * Ask the compositor to move the surface from a location to another
 * with a slide animation.
 *
 * The from argument provides a clue about where the slide animation
 * begins, offset is the distance from screen edge to begin the animation.
 * @section page_iface_org_kde_kwin_slide_api API
 * See @ref iface_org_kde_kwin_slide.
 */
/**
 * @defgroup iface_org_kde_kwin_slide The org_kde_kwin_slide interface
 *
 * Ask the compositor to move the surface from a location to another
 * with a slide animation.
 *
 * The from argument provides a clue about where the slide animation
 * begins, offset is the distance from screen edge to begin the animation.
 */
extern const struct wl_interface org_kde_kwin_slide_interface;
#endif

#define ORG_KDE_KWIN_SLIDE_MANAGER_CREATE 0
#define ORG_KDE_KWIN_SLIDE_MANAGER_UNSET 1


/**
 * @ingroup iface_org_kde_kwin_slide_manager
 */
#define ORG_KDE_KWIN_SLIDE_MANAGER_CREATE_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_slide_manager
 */
#define ORG_KDE_KWIN_SLIDE_MANAGER_UNSET_SINCE_VERSION 1

/** @ingroup iface_org_kde_kwin_slide_manager */
static inline void
org_kde_kwin_slide_manager_set_user_data(struct org_kde_kwin_slide_manager *org_kde_kwin_slide_manager, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) org_kde_kwin_slide_manager, user_data);
}

/** @ingroup iface_org_kde_kwin_slide_manager */
static inline void *
org_kde_kwin_slide_manager_get_user_data(struct org_kde_kwin_slide_manager *org_kde_kwin_slide_manager)
{
	return wl_proxy_get_user_data((struct wl_proxy *) org_kde_kwin_slide_manager);
}

static inline uint32_t
org_kde_kwin_slide_manager_get_version(struct org_kde_kwin_slide_manager *org_kde_kwin_slide_manager)
{
	return wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_slide_manager);
}

/** @ingroup iface_org_kde_kwin_slide_manager */
static inline void
org_kde_kwin_slide_manager_destroy(struct org_kde_kwin_slide_manager *org_kde_kwin_slide_manager)
{
	wl_proxy_destroy((struct wl_proxy *) org_kde_kwin_slide_manager);
}

/**
 * @ingroup iface_org_kde_kwin_slide_manager
 */
static inline struct org_kde_kwin_slide *
org_kde_kwin_slide_manager_create(struct org_kde_kwin_slide_manager *org_kde_kwin_slide_manager, struct wl_surface *surface)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) org_kde_kwin_slide_manager,
			 ORG_KDE_KWIN_SLIDE_MANAGER_CREATE, &org_kde_kwin_slide_interface, wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_slide_manager), 0, NULL, surface);

	return (struct org_kde_kwin_slide *) id;
}

/**
 * @ingroup iface_org_kde_kwin_slide_manager
 */
static inline void
org_kde_kwin_slide_manager_unset(struct org_kde_kwin_slide_manager *org_kde_kwin_slide_manager, struct wl_surface *surface)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_kwin_slide_manager,
			 ORG_KDE_KWIN_SLIDE_MANAGER_UNSET, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_slide_manager), 0, surface);
}

#ifndef ORG_KDE_KWIN_SLIDE_LOCATION_ENUM
#define ORG_KDE_KWIN_SLIDE_LOCATION_ENUM
enum org_kde_kwin_slide_location {
	ORG_KDE_KWIN_SLIDE_LOCATION_LEFT = 0,
	ORG_KDE_KWIN_SLIDE_LOCATION_TOP = 1,
	ORG_KDE_KWIN_SLIDE_LOCATION_RIGHT = 2,
	ORG_KDE_KWIN_SLIDE_LOCATION_BOTTOM = 3,
};
#endif /* ORG_KDE_KWIN_SLIDE_LOCATION_ENUM */

#define ORG_KDE_KWIN_SLIDE_COMMIT 0
#define ORG_KDE_KWIN_SLIDE_SET_LOCATION 1
#define ORG_KDE_KWIN_SLIDE_SET_OFFSET 2
#define ORG_KDE_KWIN_SLIDE_RELEASE 3


/**
 * @ingroup iface_org_kde_kwin_slide
 */
#define ORG_KDE_KWIN_SLIDE_COMMIT_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_slide
 */
#define ORG_KDE_KWIN_SLIDE_SET_LOCATION_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_slide
 */
#define ORG_KDE_KWIN_SLIDE_SET_OFFSET_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_slide
 */
#define ORG_KDE_KWIN_SLIDE_RELEASE_SINCE_VERSION 1

/** @ingroup iface_org_kde_kwin_slide */
static inline void
org_kde_kwin_slide_set_user_data(struct org_kde_kwin_slide *org_kde_kwin_slide, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) org_kde_kwin_slide, user_data);
}

/** @ingroup iface_org_kde_kwin_slide */
static inline void *
org_kde_kwin_slide_get_user_data(struct org_kde_kwin_slide *org_kde_kwin_slide)
{
	return wl_proxy_get_user_data((struct wl_proxy *) org_kde_kwin_slide);
}

static inline uint32_t
org_kde_kwin_slide_get_version(struct org_kde_kwin_slide *org_kde_kwin_slide)
{
	return wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_slide);
}

/** @ingroup iface_org_kde_kwin_slide */
static inline void
org_kde_kwin_slide_destroy(struct org_kde_kwin_slide *org_kde_kwin_slide)
{
	wl_proxy_destroy((struct wl_proxy *) org_kde_kwin_slide);
}

/**
 * @ingroup iface_org_kde_kwin_slide
 */
static inline void
org_kde_kwin_slide_commit(struct org_kde_kwin_slide *org_kde_kwin_slide)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_kwin_slide,
			 ORG_KDE_KWIN_SLIDE_COMMIT, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_slide), 0);
}

/**
 * @ingroup iface_org_kde_kwin_slide
 */
static inline void
org_kde_kwin_slide_set_location(struct org_kde_kwin_slide *org_kde_kwin_slide, uint32_t location)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_kwin_slide,
			 ORG_KDE_KWIN_SLIDE_SET_LOCATION, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_slide), 0, location);
}

/**
 * @ingroup iface_org_kde_kwin_slide
 */
static inline void
org_kde_kwin_slide_set_offset(struct org_kde_kwin_slide *org_kde_kwin_slide, int32_t offset)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_kwin_slide,
			 ORG_KDE_KWIN_SLIDE_SET_OFFSET, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_slide), 0, offset);
}

/**
 * @ingroup iface_org_kde_kwin_slide
 */
static inline void
org_kde_kwin_slide_release(struct org_kde_kwin_slide *org_kde_kwin_slide)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_kwin_slide,
			 ORG_KDE_KWIN_SLIDE_RELEASE, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_slide), WL_MARSHAL_FLAG_DESTROY);
}

#ifdef  __cplusplus
}
#endif

#endif
