// Copyright (c) 2005-2023 Code Synthesis.
//
// This program was generated by CodeSynthesis XSD, an XML Schema to
// C++ data binding compiler.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//
// In addition, as a special exception, Code Synthesis gives permission
// to link this program with the Xerces-C++ library (or with modified
// versions of Xerces-C++ that use the same license as Xerces-C++), and
// distribute linked combinations including the two. You must obey the GNU
// General Public License version 2 in all respects for all of the code
// used other than Xerces-C++. If you modify this copy of the program, you
// may extend this exception to your version of the program, but you are
// not obligated to do so. If you do not wish to do so, delete this
// exception statement from your version.
//
// Furthermore, Code Synthesis makes a special exception for the Free/Libre
// and Open Source Software (FLOSS) which is described in the accompanying
// FLOSSE file.
//

#ifndef CXX_BUILD_LIBKOLABXML_SRC_LKX_SCHEMAS_ICAL_I_CALENDAR_PARAMS_HXX
#define CXX_BUILD_LIBKOLABXML_SRC_LKX_SCHEMAS_ICAL_I_CALENDAR_PARAMS_HXX

#ifndef XSD_CXX11
#define XSD_CXX11
#endif

#ifndef XSD_USE_CHAR
#define XSD_USE_CHAR
#endif

#ifndef XSD_CXX_TREE_USE_CHAR
#define XSD_CXX_TREE_USE_CHAR
#endif

// Begin prologue.
//
//
// End prologue.

#include <xsd/cxx/config.hxx>

#if (LIBXSD_VERSION != 400002000000000L)
#error XSD runtime version mismatch
#endif

#include <xsd/cxx/pre.hxx>

#include <xsd/cxx/xml/char-utf8.hxx>

#include <xsd/cxx/tree/exceptions.hxx>
#include <xsd/cxx/tree/elements.hxx>
#include <xsd/cxx/tree/types.hxx>

#include <xsd/cxx/xml/error-handler.hxx>

#include <xsd/cxx/xml/dom/auto-ptr.hxx>

#include <xsd/cxx/tree/parsing.hxx>
#include <xsd/cxx/tree/parsing/byte.hxx>
#include <xsd/cxx/tree/parsing/unsigned-byte.hxx>
#include <xsd/cxx/tree/parsing/short.hxx>
#include <xsd/cxx/tree/parsing/unsigned-short.hxx>
#include <xsd/cxx/tree/parsing/int.hxx>
#include <xsd/cxx/tree/parsing/unsigned-int.hxx>
#include <xsd/cxx/tree/parsing/long.hxx>
#include <xsd/cxx/tree/parsing/unsigned-long.hxx>
#include <xsd/cxx/tree/parsing/boolean.hxx>
#include <xsd/cxx/tree/parsing/float.hxx>
#include <xsd/cxx/tree/parsing/double.hxx>
#include <xsd/cxx/tree/parsing/decimal.hxx>

#include <xsd/cxx/xml/dom/serialization-header.hxx>
#include <xsd/cxx/tree/serialization.hxx>
#include <xsd/cxx/tree/serialization/byte.hxx>
#include <xsd/cxx/tree/serialization/unsigned-byte.hxx>
#include <xsd/cxx/tree/serialization/short.hxx>
#include <xsd/cxx/tree/serialization/unsigned-short.hxx>
#include <xsd/cxx/tree/serialization/int.hxx>
#include <xsd/cxx/tree/serialization/unsigned-int.hxx>
#include <xsd/cxx/tree/serialization/long.hxx>
#include <xsd/cxx/tree/serialization/unsigned-long.hxx>
#include <xsd/cxx/tree/serialization/boolean.hxx>
#include <xsd/cxx/tree/serialization/float.hxx>
#include <xsd/cxx/tree/serialization/double.hxx>
#include <xsd/cxx/tree/serialization/decimal.hxx>

namespace xml_schema
{
  // anyType and anySimpleType.
  //
  typedef ::xsd::cxx::tree::type type;
  typedef ::xsd::cxx::tree::simple_type< char, type > simple_type;
  typedef ::xsd::cxx::tree::type container;

  // 8-bit
  //
  typedef signed char byte;
  typedef unsigned char unsigned_byte;

  // 16-bit
  //
  typedef short short_;
  typedef unsigned short unsigned_short;

  // 32-bit
  //
  typedef int int_;
  typedef unsigned int unsigned_int;

  // 64-bit
  //
  typedef long long long_;
  typedef unsigned long long unsigned_long;

  // Supposed to be arbitrary-length integral types.
  //
  typedef long long integer;
  typedef long long non_positive_integer;
  typedef unsigned long long non_negative_integer;
  typedef unsigned long long positive_integer;
  typedef long long negative_integer;

  // Boolean.
  //
  typedef bool boolean;

  // Floating-point types.
  //
  typedef float float_;
  typedef double double_;
  typedef double decimal;

  // String types.
  //
  typedef ::xsd::cxx::tree::string< char, simple_type > string;
  typedef ::xsd::cxx::tree::normalized_string< char, string > normalized_string;
  typedef ::xsd::cxx::tree::token< char, normalized_string > token;
  typedef ::xsd::cxx::tree::name< char, token > name;
  typedef ::xsd::cxx::tree::nmtoken< char, token > nmtoken;
  typedef ::xsd::cxx::tree::nmtokens< char, simple_type, nmtoken > nmtokens;
  typedef ::xsd::cxx::tree::ncname< char, name > ncname;
  typedef ::xsd::cxx::tree::language< char, token > language;

  // ID/IDREF.
  //
  typedef ::xsd::cxx::tree::id< char, ncname > id;
  typedef ::xsd::cxx::tree::idref< char, ncname, type > idref;
  typedef ::xsd::cxx::tree::idrefs< char, simple_type, idref > idrefs;

  // URI.
  //
  typedef ::xsd::cxx::tree::uri< char, simple_type > uri;

  // Qualified name.
  //
  typedef ::xsd::cxx::tree::qname< char, simple_type, uri, ncname > qname;

  // Binary.
  //
  typedef ::xsd::cxx::tree::buffer< char > buffer;
  typedef ::xsd::cxx::tree::base64_binary< char, simple_type > base64_binary;
  typedef ::xsd::cxx::tree::hex_binary< char, simple_type > hex_binary;

  // Date/time.
  //
  typedef ::xsd::cxx::tree::time_zone time_zone;
  typedef ::xsd::cxx::tree::date< char, simple_type > date;
  typedef ::xsd::cxx::tree::date_time< char, simple_type > date_time;
  typedef ::xsd::cxx::tree::duration< char, simple_type > duration;
  typedef ::xsd::cxx::tree::gday< char, simple_type > gday;
  typedef ::xsd::cxx::tree::gmonth< char, simple_type > gmonth;
  typedef ::xsd::cxx::tree::gmonth_day< char, simple_type > gmonth_day;
  typedef ::xsd::cxx::tree::gyear< char, simple_type > gyear;
  typedef ::xsd::cxx::tree::gyear_month< char, simple_type > gyear_month;
  typedef ::xsd::cxx::tree::time< char, simple_type > time;

  // Entity.
  //
  typedef ::xsd::cxx::tree::entity< char, ncname > entity;
  typedef ::xsd::cxx::tree::entities< char, simple_type, entity > entities;

  typedef ::xsd::cxx::tree::content_order content_order;
  // Namespace information and list stream. Used in
  // serialization functions.
  //
  typedef ::xsd::cxx::xml::dom::namespace_info< char > namespace_info;
  typedef ::xsd::cxx::xml::dom::namespace_infomap< char > namespace_infomap;
  typedef ::xsd::cxx::tree::list_stream< char > list_stream;
  typedef ::xsd::cxx::tree::as_double< double_ > as_double;
  typedef ::xsd::cxx::tree::as_decimal< decimal > as_decimal;
  typedef ::xsd::cxx::tree::facet facet;

  // Flags and properties.
  //
  typedef ::xsd::cxx::tree::flags flags;
  typedef ::xsd::cxx::tree::properties< char > properties;

  // Parsing/serialization diagnostics.
  //
  typedef ::xsd::cxx::tree::severity severity;
  typedef ::xsd::cxx::tree::error< char > error;
  typedef ::xsd::cxx::tree::diagnostics< char > diagnostics;

  // Exceptions.
  //
  typedef ::xsd::cxx::tree::exception< char > exception;
  typedef ::xsd::cxx::tree::bounds< char > bounds;
  typedef ::xsd::cxx::tree::duplicate_id< char > duplicate_id;
  typedef ::xsd::cxx::tree::parsing< char > parsing;
  typedef ::xsd::cxx::tree::expected_element< char > expected_element;
  typedef ::xsd::cxx::tree::unexpected_element< char > unexpected_element;
  typedef ::xsd::cxx::tree::expected_attribute< char > expected_attribute;
  typedef ::xsd::cxx::tree::unexpected_enumerator< char > unexpected_enumerator;
  typedef ::xsd::cxx::tree::expected_text_content< char > expected_text_content;
  typedef ::xsd::cxx::tree::no_prefix_mapping< char > no_prefix_mapping;
  typedef ::xsd::cxx::tree::no_type_info< char > no_type_info;
  typedef ::xsd::cxx::tree::not_derived< char > not_derived;
  typedef ::xsd::cxx::tree::serialization< char > serialization;

  // Error handler callback interface.
  //
  typedef ::xsd::cxx::xml::error_handler< char > error_handler;

  // DOM interaction.
  //
  namespace dom
  {
    // Automatic pointer for DOMDocument.
    //
    using ::xsd::cxx::xml::dom::unique_ptr;

#ifndef XSD_CXX_TREE_TREE_NODE_KEY__XML_SCHEMA
#define XSD_CXX_TREE_TREE_NODE_KEY__XML_SCHEMA
    // DOM user data key for back pointers to tree nodes.
    //
    const XMLCh* const tree_node_key = ::xsd::cxx::tree::user_data_keys::node;
#endif
  }
}

// Forward declarations.
//
namespace icalendar_2_0
{
  class BaseParameterType;
  class ArrayOfParameters;
  class BooleanParameterType;
  class TextParameterType;
  class UriParameterType;
  class CalAddressListParamType;
  class CalAddressParamType;
  class AltrepParamType;
  class CnParamType;
  class CutypeParamType;
  class DelegatedFromParamType;
  class DelegatedToParamType;
  class DirParamType;
  class EncodingParamType;
  class FmttypeParamType;
  class FbtypeParamType;
  class LanguageParamType;
  class MemberParamType;
  class PartstatParamType;
  class RangeValueType;
  class RangeParamType;
  class RelatedParamType;
  class ReltypeParamType;
  class RoleParamType;
  class RsvpParamType;
  class SentByParamType;
  class TzidParamType;
  class ScheduleAgentParamType;
  class ScheduleForceSendParamType;
  class ScheduleStatusParamType;
}


#include <memory>    // ::std::unique_ptr
#include <limits>    // std::numeric_limits
#include <algorithm> // std::binary_search
#include <utility>   // std::move

#include <xsd/cxx/xml/char-utf8.hxx>

#include <xsd/cxx/tree/exceptions.hxx>
#include <xsd/cxx/tree/elements.hxx>
#include <xsd/cxx/tree/containers.hxx>
#include <xsd/cxx/tree/list.hxx>

#include <xsd/cxx/xml/dom/parsing-header.hxx>

#include "iCalendar-valtypes.hxx"

namespace icalendar_2_0
{
  class BaseParameterType: public ::xml_schema::type
  {
    public:
    // Constructors.
    //
    BaseParameterType ();

    BaseParameterType (const ::xercesc::DOMElement& e,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    BaseParameterType (const ::xercesc::DOMAttr& a,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    BaseParameterType (const ::std::string& s,
                       const ::xercesc::DOMElement* e,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    BaseParameterType (const BaseParameterType& x,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    virtual BaseParameterType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const = 0;

#ifdef XSD_CXX11
    BaseParameterType&
    operator= (const BaseParameterType&) = default;
#endif

    virtual 
    ~BaseParameterType ();
  };

  class ArrayOfParameters: public ::xml_schema::type
  {
    public:
    // baseParameter
    //
    typedef ::icalendar_2_0::BaseParameterType baseParameter_type;
    typedef ::xsd::cxx::tree::sequence< baseParameter_type > baseParameter_sequence;
    typedef baseParameter_sequence::iterator baseParameter_iterator;
    typedef baseParameter_sequence::const_iterator baseParameter_const_iterator;
    typedef ::xsd::cxx::tree::traits< baseParameter_type, char > baseParameter_traits;

    const baseParameter_sequence&
    baseParameter () const;

    baseParameter_sequence&
    baseParameter ();

    void
    baseParameter (const baseParameter_sequence& s);

    // Constructors.
    //
    ArrayOfParameters ();

    ArrayOfParameters (const ::xercesc::DOMElement& e,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    ArrayOfParameters (const ArrayOfParameters& x,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    virtual ArrayOfParameters*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    ArrayOfParameters&
    operator= (const ArrayOfParameters& x);

    virtual 
    ~ArrayOfParameters ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    baseParameter_sequence baseParameter_;
  };

  class BooleanParameterType: public ::icalendar_2_0::BaseParameterType
  {
    public:
    // boolean
    //
    typedef ::xml_schema::boolean boolean_type;
    typedef ::xsd::cxx::tree::traits< boolean_type, char > boolean_traits;

    const boolean_type&
    boolean () const;

    boolean_type&
    boolean ();

    void
    boolean (const boolean_type& x);

    // Constructors.
    //
    BooleanParameterType (const boolean_type&);

    BooleanParameterType (const ::xercesc::DOMElement& e,
                          ::xml_schema::flags f = 0,
                          ::xml_schema::container* c = 0);

    BooleanParameterType (const BooleanParameterType& x,
                          ::xml_schema::flags f = 0,
                          ::xml_schema::container* c = 0);

    virtual BooleanParameterType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    BooleanParameterType&
    operator= (const BooleanParameterType& x);

    virtual 
    ~BooleanParameterType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< boolean_type > boolean_;
  };

  class TextParameterType: public ::icalendar_2_0::BaseParameterType
  {
    public:
    // text
    //
    typedef ::xml_schema::string text_type;
    typedef ::xsd::cxx::tree::traits< text_type, char > text_traits;

    const text_type&
    text () const;

    text_type&
    text ();

    void
    text (const text_type& x);

    void
    text (::std::unique_ptr< text_type > p);

    // Constructors.
    //
    TextParameterType (const text_type&);

    TextParameterType (const ::xercesc::DOMElement& e,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    TextParameterType (const TextParameterType& x,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    virtual TextParameterType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    TextParameterType&
    operator= (const TextParameterType& x);

    virtual 
    ~TextParameterType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< text_type > text_;
  };

  class UriParameterType: public ::icalendar_2_0::BaseParameterType
  {
    public:
    // uri
    //
    typedef ::icalendar_2_0::UriType uri_type;
    typedef ::xsd::cxx::tree::traits< uri_type, char > uri_traits;

    const uri_type&
    uri () const;

    uri_type&
    uri ();

    void
    uri (const uri_type& x);

    void
    uri (::std::unique_ptr< uri_type > p);

    // Constructors.
    //
    UriParameterType (const uri_type&);

    UriParameterType (const ::xercesc::DOMElement& e,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    UriParameterType (const UriParameterType& x,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    virtual UriParameterType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    UriParameterType&
    operator= (const UriParameterType& x);

    virtual 
    ~UriParameterType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< uri_type > uri_;
  };

  class CalAddressListParamType: public ::icalendar_2_0::BaseParameterType
  {
    public:
    // cal-address
    //
    typedef ::icalendar_2_0::CalAddressType cal_address_type;
    typedef ::xsd::cxx::tree::sequence< cal_address_type > cal_address_sequence;
    typedef cal_address_sequence::iterator cal_address_iterator;
    typedef cal_address_sequence::const_iterator cal_address_const_iterator;
    typedef ::xsd::cxx::tree::traits< cal_address_type, char > cal_address_traits;

    const cal_address_sequence&
    cal_address () const;

    cal_address_sequence&
    cal_address ();

    void
    cal_address (const cal_address_sequence& s);

    // Constructors.
    //
    CalAddressListParamType ();

    CalAddressListParamType (const ::xercesc::DOMElement& e,
                             ::xml_schema::flags f = 0,
                             ::xml_schema::container* c = 0);

    CalAddressListParamType (const CalAddressListParamType& x,
                             ::xml_schema::flags f = 0,
                             ::xml_schema::container* c = 0);

    virtual CalAddressListParamType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    CalAddressListParamType&
    operator= (const CalAddressListParamType& x);

    virtual 
    ~CalAddressListParamType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    cal_address_sequence cal_address_;
  };

  class CalAddressParamType: public ::icalendar_2_0::BaseParameterType
  {
    public:
    // cal-address
    //
    typedef ::icalendar_2_0::CalAddressType cal_address_type;
    typedef ::xsd::cxx::tree::traits< cal_address_type, char > cal_address_traits;

    const cal_address_type&
    cal_address () const;

    cal_address_type&
    cal_address ();

    void
    cal_address (const cal_address_type& x);

    void
    cal_address (::std::unique_ptr< cal_address_type > p);

    // Constructors.
    //
    CalAddressParamType (const cal_address_type&);

    CalAddressParamType (const ::xercesc::DOMElement& e,
                         ::xml_schema::flags f = 0,
                         ::xml_schema::container* c = 0);

    CalAddressParamType (const CalAddressParamType& x,
                         ::xml_schema::flags f = 0,
                         ::xml_schema::container* c = 0);

    virtual CalAddressParamType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    CalAddressParamType&
    operator= (const CalAddressParamType& x);

    virtual 
    ~CalAddressParamType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< cal_address_type > cal_address_;
  };

  class AltrepParamType: public ::icalendar_2_0::UriParameterType
  {
    public:
    // Constructors.
    //
    AltrepParamType (const uri_type&);

    AltrepParamType (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    AltrepParamType (const AltrepParamType& x,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    virtual AltrepParamType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    AltrepParamType&
    operator= (const AltrepParamType&) = default;
#endif

    virtual 
    ~AltrepParamType ();
  };

  class CnParamType: public ::icalendar_2_0::TextParameterType
  {
    public:
    // Constructors.
    //
    CnParamType (const text_type&);

    CnParamType (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    CnParamType (const CnParamType& x,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    virtual CnParamType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    CnParamType&
    operator= (const CnParamType&) = default;
#endif

    virtual 
    ~CnParamType ();
  };

  class CutypeParamType: public ::icalendar_2_0::TextParameterType
  {
    public:
    // Constructors.
    //
    CutypeParamType (const text_type&);

    CutypeParamType (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    CutypeParamType (const CutypeParamType& x,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    virtual CutypeParamType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    CutypeParamType&
    operator= (const CutypeParamType&) = default;
#endif

    virtual 
    ~CutypeParamType ();
  };

  class DelegatedFromParamType: public ::icalendar_2_0::CalAddressListParamType
  {
    public:
    // Constructors.
    //
    DelegatedFromParamType ();

    DelegatedFromParamType (const ::xercesc::DOMElement& e,
                            ::xml_schema::flags f = 0,
                            ::xml_schema::container* c = 0);

    DelegatedFromParamType (const DelegatedFromParamType& x,
                            ::xml_schema::flags f = 0,
                            ::xml_schema::container* c = 0);

    virtual DelegatedFromParamType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    DelegatedFromParamType&
    operator= (const DelegatedFromParamType&) = default;
#endif

    virtual 
    ~DelegatedFromParamType ();
  };

  class DelegatedToParamType: public ::icalendar_2_0::CalAddressListParamType
  {
    public:
    // Constructors.
    //
    DelegatedToParamType ();

    DelegatedToParamType (const ::xercesc::DOMElement& e,
                          ::xml_schema::flags f = 0,
                          ::xml_schema::container* c = 0);

    DelegatedToParamType (const DelegatedToParamType& x,
                          ::xml_schema::flags f = 0,
                          ::xml_schema::container* c = 0);

    virtual DelegatedToParamType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    DelegatedToParamType&
    operator= (const DelegatedToParamType&) = default;
#endif

    virtual 
    ~DelegatedToParamType ();
  };

  class DirParamType: public ::icalendar_2_0::UriParameterType
  {
    public:
    // Constructors.
    //
    DirParamType (const uri_type&);

    DirParamType (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    DirParamType (const DirParamType& x,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    virtual DirParamType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    DirParamType&
    operator= (const DirParamType&) = default;
#endif

    virtual 
    ~DirParamType ();
  };

  class EncodingParamType: public ::icalendar_2_0::TextParameterType
  {
    public:
    // Constructors.
    //
    EncodingParamType (const text_type&);

    EncodingParamType (const ::xercesc::DOMElement& e,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    EncodingParamType (const EncodingParamType& x,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    virtual EncodingParamType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    EncodingParamType&
    operator= (const EncodingParamType&) = default;
#endif

    virtual 
    ~EncodingParamType ();
  };

  class FmttypeParamType: public ::icalendar_2_0::TextParameterType
  {
    public:
    // Constructors.
    //
    FmttypeParamType (const text_type&);

    FmttypeParamType (const ::xercesc::DOMElement& e,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    FmttypeParamType (const FmttypeParamType& x,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    virtual FmttypeParamType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    FmttypeParamType&
    operator= (const FmttypeParamType&) = default;
#endif

    virtual 
    ~FmttypeParamType ();
  };

  class FbtypeParamType: public ::icalendar_2_0::TextParameterType
  {
    public:
    // Constructors.
    //
    FbtypeParamType (const text_type&);

    FbtypeParamType (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    FbtypeParamType (const FbtypeParamType& x,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    virtual FbtypeParamType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    FbtypeParamType&
    operator= (const FbtypeParamType&) = default;
#endif

    virtual 
    ~FbtypeParamType ();
  };

  class LanguageParamType: public ::icalendar_2_0::TextParameterType
  {
    public:
    // Constructors.
    //
    LanguageParamType (const text_type&);

    LanguageParamType (const ::xercesc::DOMElement& e,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    LanguageParamType (const LanguageParamType& x,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    virtual LanguageParamType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    LanguageParamType&
    operator= (const LanguageParamType&) = default;
#endif

    virtual 
    ~LanguageParamType ();
  };

  class MemberParamType: public ::icalendar_2_0::CalAddressListParamType
  {
    public:
    // Constructors.
    //
    MemberParamType ();

    MemberParamType (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    MemberParamType (const MemberParamType& x,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    virtual MemberParamType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    MemberParamType&
    operator= (const MemberParamType&) = default;
#endif

    virtual 
    ~MemberParamType ();
  };

  class PartstatParamType: public ::icalendar_2_0::TextParameterType
  {
    public:
    // Constructors.
    //
    PartstatParamType (const text_type&);

    PartstatParamType (const ::xercesc::DOMElement& e,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    PartstatParamType (const PartstatParamType& x,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    virtual PartstatParamType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    PartstatParamType&
    operator= (const PartstatParamType&) = default;
#endif

    virtual 
    ~PartstatParamType ();
  };

  class RangeValueType: public ::xml_schema::token
  {
    public:
    enum value
    {
      THISANDFUTURE
    };

    RangeValueType (value v);

    RangeValueType (const char* v);

    RangeValueType (const ::std::string& v);

    RangeValueType (const ::xml_schema::token& v);

    RangeValueType (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    RangeValueType (const ::xercesc::DOMAttr& a,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    RangeValueType (const ::std::string& s,
                    const ::xercesc::DOMElement* e,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    RangeValueType (const RangeValueType& x,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

#ifdef XSD_CXX11
    RangeValueType&
    operator= (const RangeValueType&) = default;
#endif

    virtual RangeValueType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    RangeValueType&
    operator= (value v);

    virtual
    operator value () const
    {
      return _xsd_RangeValueType_convert ();
    }

    protected:
    value
    _xsd_RangeValueType_convert () const;

    public:
    static const char* const _xsd_RangeValueType_literals_[1];
    static const value _xsd_RangeValueType_indexes_[1];
  };

  class RangeParamType: public ::icalendar_2_0::BaseParameterType
  {
    public:
    // text
    //
    typedef ::icalendar_2_0::RangeValueType text_type;
    typedef ::xsd::cxx::tree::traits< text_type, char > text_traits;

    const text_type&
    text () const;

    text_type&
    text ();

    void
    text (const text_type& x);

    void
    text (::std::unique_ptr< text_type > p);

    // Constructors.
    //
    RangeParamType (const text_type&);

    RangeParamType (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    RangeParamType (const RangeParamType& x,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    virtual RangeParamType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    RangeParamType&
    operator= (const RangeParamType& x);

    virtual 
    ~RangeParamType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< text_type > text_;
  };

  class RelatedParamType: public ::icalendar_2_0::TextParameterType
  {
    public:
    // Constructors.
    //
    RelatedParamType (const text_type&);

    RelatedParamType (const ::xercesc::DOMElement& e,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    RelatedParamType (const RelatedParamType& x,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    virtual RelatedParamType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    RelatedParamType&
    operator= (const RelatedParamType&) = default;
#endif

    virtual 
    ~RelatedParamType ();
  };

  class ReltypeParamType: public ::icalendar_2_0::TextParameterType
  {
    public:
    // Constructors.
    //
    ReltypeParamType (const text_type&);

    ReltypeParamType (const ::xercesc::DOMElement& e,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    ReltypeParamType (const ReltypeParamType& x,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    virtual ReltypeParamType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    ReltypeParamType&
    operator= (const ReltypeParamType&) = default;
#endif

    virtual 
    ~ReltypeParamType ();
  };

  class RoleParamType: public ::icalendar_2_0::TextParameterType
  {
    public:
    // Constructors.
    //
    RoleParamType (const text_type&);

    RoleParamType (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    RoleParamType (const RoleParamType& x,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    virtual RoleParamType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    RoleParamType&
    operator= (const RoleParamType&) = default;
#endif

    virtual 
    ~RoleParamType ();
  };

  class RsvpParamType: public ::icalendar_2_0::BooleanParameterType
  {
    public:
    // Constructors.
    //
    RsvpParamType (const boolean_type&);

    RsvpParamType (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    RsvpParamType (const RsvpParamType& x,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    virtual RsvpParamType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    RsvpParamType&
    operator= (const RsvpParamType&) = default;
#endif

    virtual 
    ~RsvpParamType ();
  };

  class SentByParamType: public ::icalendar_2_0::CalAddressParamType
  {
    public:
    // Constructors.
    //
    SentByParamType (const cal_address_type&);

    SentByParamType (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    SentByParamType (const SentByParamType& x,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    virtual SentByParamType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    SentByParamType&
    operator= (const SentByParamType&) = default;
#endif

    virtual 
    ~SentByParamType ();
  };

  class TzidParamType: public ::icalendar_2_0::TextParameterType
  {
    public:
    // Constructors.
    //
    TzidParamType (const text_type&);

    TzidParamType (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    TzidParamType (const TzidParamType& x,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    virtual TzidParamType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    TzidParamType&
    operator= (const TzidParamType&) = default;
#endif

    virtual 
    ~TzidParamType ();
  };

  class ScheduleAgentParamType: public ::icalendar_2_0::TextParameterType
  {
    public:
    // Constructors.
    //
    ScheduleAgentParamType (const text_type&);

    ScheduleAgentParamType (const ::xercesc::DOMElement& e,
                            ::xml_schema::flags f = 0,
                            ::xml_schema::container* c = 0);

    ScheduleAgentParamType (const ScheduleAgentParamType& x,
                            ::xml_schema::flags f = 0,
                            ::xml_schema::container* c = 0);

    virtual ScheduleAgentParamType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    ScheduleAgentParamType&
    operator= (const ScheduleAgentParamType&) = default;
#endif

    virtual 
    ~ScheduleAgentParamType ();
  };

  class ScheduleForceSendParamType: public ::icalendar_2_0::TextParameterType
  {
    public:
    // Constructors.
    //
    ScheduleForceSendParamType (const text_type&);

    ScheduleForceSendParamType (const ::xercesc::DOMElement& e,
                                ::xml_schema::flags f = 0,
                                ::xml_schema::container* c = 0);

    ScheduleForceSendParamType (const ScheduleForceSendParamType& x,
                                ::xml_schema::flags f = 0,
                                ::xml_schema::container* c = 0);

    virtual ScheduleForceSendParamType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    ScheduleForceSendParamType&
    operator= (const ScheduleForceSendParamType&) = default;
#endif

    virtual 
    ~ScheduleForceSendParamType ();
  };

  class ScheduleStatusParamType: public ::icalendar_2_0::TextParameterType
  {
    public:
    // Constructors.
    //
    ScheduleStatusParamType (const text_type&);

    ScheduleStatusParamType (const ::xercesc::DOMElement& e,
                             ::xml_schema::flags f = 0,
                             ::xml_schema::container* c = 0);

    ScheduleStatusParamType (const ScheduleStatusParamType& x,
                             ::xml_schema::flags f = 0,
                             ::xml_schema::container* c = 0);

    virtual ScheduleStatusParamType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

#ifdef XSD_CXX11
    ScheduleStatusParamType&
    operator= (const ScheduleStatusParamType&) = default;
#endif

    virtual 
    ~ScheduleStatusParamType ();
  };
}

#include <iosfwd>

#include <xercesc/sax/InputSource.hpp>
#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMErrorHandler.hpp>

namespace icalendar_2_0
{
}

#include <iosfwd>

#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMErrorHandler.hpp>
#include <xercesc/framework/XMLFormatter.hpp>

#include <xsd/cxx/xml/dom/auto-ptr.hxx>

namespace icalendar_2_0
{
  void
  operator<< (::xercesc::DOMElement&, const BaseParameterType&);

  void
  operator<< (::xercesc::DOMAttr&, const BaseParameterType&);

  void
  operator<< (::xml_schema::list_stream&,
              const BaseParameterType&);

  void
  operator<< (::xercesc::DOMElement&, const ArrayOfParameters&);

  void
  operator<< (::xercesc::DOMElement&, const BooleanParameterType&);

  void
  operator<< (::xercesc::DOMElement&, const TextParameterType&);

  void
  operator<< (::xercesc::DOMElement&, const UriParameterType&);

  void
  operator<< (::xercesc::DOMElement&, const CalAddressListParamType&);

  void
  operator<< (::xercesc::DOMElement&, const CalAddressParamType&);

  void
  operator<< (::xercesc::DOMElement&, const AltrepParamType&);

  void
  operator<< (::xercesc::DOMElement&, const CnParamType&);

  void
  operator<< (::xercesc::DOMElement&, const CutypeParamType&);

  void
  operator<< (::xercesc::DOMElement&, const DelegatedFromParamType&);

  void
  operator<< (::xercesc::DOMElement&, const DelegatedToParamType&);

  void
  operator<< (::xercesc::DOMElement&, const DirParamType&);

  void
  operator<< (::xercesc::DOMElement&, const EncodingParamType&);

  void
  operator<< (::xercesc::DOMElement&, const FmttypeParamType&);

  void
  operator<< (::xercesc::DOMElement&, const FbtypeParamType&);

  void
  operator<< (::xercesc::DOMElement&, const LanguageParamType&);

  void
  operator<< (::xercesc::DOMElement&, const MemberParamType&);

  void
  operator<< (::xercesc::DOMElement&, const PartstatParamType&);

  void
  operator<< (::xercesc::DOMElement&, const RangeValueType&);

  void
  operator<< (::xercesc::DOMAttr&, const RangeValueType&);

  void
  operator<< (::xml_schema::list_stream&,
              const RangeValueType&);

  void
  operator<< (::xercesc::DOMElement&, const RangeParamType&);

  void
  operator<< (::xercesc::DOMElement&, const RelatedParamType&);

  void
  operator<< (::xercesc::DOMElement&, const ReltypeParamType&);

  void
  operator<< (::xercesc::DOMElement&, const RoleParamType&);

  void
  operator<< (::xercesc::DOMElement&, const RsvpParamType&);

  void
  operator<< (::xercesc::DOMElement&, const SentByParamType&);

  void
  operator<< (::xercesc::DOMElement&, const TzidParamType&);

  void
  operator<< (::xercesc::DOMElement&, const ScheduleAgentParamType&);

  void
  operator<< (::xercesc::DOMElement&, const ScheduleForceSendParamType&);

  void
  operator<< (::xercesc::DOMElement&, const ScheduleStatusParamType&);
}

#include <xsd/cxx/post.hxx>

// Begin epilogue.
//
//
// End epilogue.

#endif // CXX_BUILD_LIBKOLABXML_SRC_LKX_SCHEMAS_ICAL_I_CALENDAR_PARAMS_HXX
