// Copyright (c) 2005-2023 Code Synthesis.
//
// This program was generated by CodeSynthesis XSD, an XML Schema to
// C++ data binding compiler.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//
// In addition, as a special exception, Code Synthesis gives permission
// to link this program with the Xerces-C++ library (or with modified
// versions of Xerces-C++ that use the same license as Xerces-C++), and
// distribute linked combinations including the two. You must obey the GNU
// General Public License version 2 in all respects for all of the code
// used other than Xerces-C++. If you modify this copy of the program, you
// may extend this exception to your version of the program, but you are
// not obligated to do so. If you do not wish to do so, delete this
// exception statement from your version.
//
// Furthermore, Code Synthesis makes a special exception for the Free/Libre
// and Open Source Software (FLOSS) which is described in the accompanying
// FLOSSE file.
//

// Begin prologue.
//
//
// End prologue.

#include <xsd/cxx/pre.hxx>

#include "kolabformat.hxx"

namespace KolabXSD
{
  // KolabBase
  //

  const KolabBase::version_type& KolabBase::
  version () const
  {
    return this->version_.get ();
  }

  KolabBase::version_type& KolabBase::
  version ()
  {
    return this->version_.get ();
  }

  void KolabBase::
  version (const version_type& x)
  {
    this->version_.set (x);
  }

  void KolabBase::
  version (::std::unique_ptr< version_type > x)
  {
    this->version_.set (std::move (x));
  }

  const KolabBase::version_type& KolabBase::
  version_default_value ()
  {
    return version_default_value_;
  }


  // attachmentPropType
  //

  const attachmentPropType::parameters_type& attachmentPropType::
  parameters () const
  {
    return this->parameters_.get ();
  }

  attachmentPropType::parameters_type& attachmentPropType::
  parameters ()
  {
    return this->parameters_.get ();
  }

  void attachmentPropType::
  parameters (const parameters_type& x)
  {
    this->parameters_.set (x);
  }

  void attachmentPropType::
  parameters (::std::unique_ptr< parameters_type > x)
  {
    this->parameters_.set (std::move (x));
  }

  const attachmentPropType::uri_optional& attachmentPropType::
  uri () const
  {
    return this->uri_;
  }

  attachmentPropType::uri_optional& attachmentPropType::
  uri ()
  {
    return this->uri_;
  }

  void attachmentPropType::
  uri (const uri_type& x)
  {
    this->uri_.set (x);
  }

  void attachmentPropType::
  uri (const uri_optional& x)
  {
    this->uri_ = x;
  }

  void attachmentPropType::
  uri (::std::unique_ptr< uri_type > x)
  {
    this->uri_.set (std::move (x));
  }

  const attachmentPropType::binary_optional& attachmentPropType::
  binary () const
  {
    return this->binary_;
  }

  attachmentPropType::binary_optional& attachmentPropType::
  binary ()
  {
    return this->binary_;
  }

  void attachmentPropType::
  binary (const binary_type& x)
  {
    this->binary_.set (x);
  }

  void attachmentPropType::
  binary (const binary_optional& x)
  {
    this->binary_ = x;
  }

  void attachmentPropType::
  binary (::std::unique_ptr< binary_type > x)
  {
    this->binary_.set (std::move (x));
  }


  // classifcationPropType
  //

  classifcationPropType::
  classifcationPropType (value v)
  : ::xml_schema::token (_xsd_classifcationPropType_literals_[v])
  {
  }

  classifcationPropType::
  classifcationPropType (const char* v)
  : ::xml_schema::token (v)
  {
  }

  classifcationPropType::
  classifcationPropType (const ::std::string& v)
  : ::xml_schema::token (v)
  {
  }

  classifcationPropType::
  classifcationPropType (const ::xml_schema::token& v)
  : ::xml_schema::token (v)
  {
  }

  classifcationPropType::
  classifcationPropType (const classifcationPropType& v,
                         ::xml_schema::flags f,
                         ::xml_schema::container* c)
  : ::xml_schema::token (v, f, c)
  {
  }

  classifcationPropType& classifcationPropType::
  operator= (value v)
  {
    static_cast< ::xml_schema::token& > (*this) = 
    ::xml_schema::token (_xsd_classifcationPropType_literals_[v]);

    return *this;
  }


  // CustomType
  //

  const CustomType::identifier_type& CustomType::
  identifier () const
  {
    return this->identifier_.get ();
  }

  CustomType::identifier_type& CustomType::
  identifier ()
  {
    return this->identifier_.get ();
  }

  void CustomType::
  identifier (const identifier_type& x)
  {
    this->identifier_.set (x);
  }

  void CustomType::
  identifier (::std::unique_ptr< identifier_type > x)
  {
    this->identifier_.set (std::move (x));
  }

  const CustomType::value_type& CustomType::
  value () const
  {
    return this->value_.get ();
  }

  CustomType::value_type& CustomType::
  value ()
  {
    return this->value_.get ();
  }

  void CustomType::
  value (const value_type& x)
  {
    this->value_.set (x);
  }

  void CustomType::
  value (::std::unique_ptr< value_type > x)
  {
    this->value_.set (std::move (x));
  }


  // Note
  //

  const Note::uid_type& Note::
  uid () const
  {
    return this->uid_.get ();
  }

  Note::uid_type& Note::
  uid ()
  {
    return this->uid_.get ();
  }

  void Note::
  uid (const uid_type& x)
  {
    this->uid_.set (x);
  }

  void Note::
  uid (::std::unique_ptr< uid_type > x)
  {
    this->uid_.set (std::move (x));
  }

  const Note::prodid_type& Note::
  prodid () const
  {
    return this->prodid_.get ();
  }

  Note::prodid_type& Note::
  prodid ()
  {
    return this->prodid_.get ();
  }

  void Note::
  prodid (const prodid_type& x)
  {
    this->prodid_.set (x);
  }

  void Note::
  prodid (::std::unique_ptr< prodid_type > x)
  {
    this->prodid_.set (std::move (x));
  }

  const Note::creation_date_type& Note::
  creation_date () const
  {
    return this->creation_date_.get ();
  }

  Note::creation_date_type& Note::
  creation_date ()
  {
    return this->creation_date_.get ();
  }

  void Note::
  creation_date (const creation_date_type& x)
  {
    this->creation_date_.set (x);
  }

  void Note::
  creation_date (::std::unique_ptr< creation_date_type > x)
  {
    this->creation_date_.set (std::move (x));
  }

  const Note::last_modification_date_type& Note::
  last_modification_date () const
  {
    return this->last_modification_date_.get ();
  }

  Note::last_modification_date_type& Note::
  last_modification_date ()
  {
    return this->last_modification_date_.get ();
  }

  void Note::
  last_modification_date (const last_modification_date_type& x)
  {
    this->last_modification_date_.set (x);
  }

  void Note::
  last_modification_date (::std::unique_ptr< last_modification_date_type > x)
  {
    this->last_modification_date_.set (std::move (x));
  }

  const Note::categories_sequence& Note::
  categories () const
  {
    return this->categories_;
  }

  Note::categories_sequence& Note::
  categories ()
  {
    return this->categories_;
  }

  void Note::
  categories (const categories_sequence& s)
  {
    this->categories_ = s;
  }

  const Note::classification_optional& Note::
  classification () const
  {
    return this->classification_;
  }

  Note::classification_optional& Note::
  classification ()
  {
    return this->classification_;
  }

  void Note::
  classification (const classification_type& x)
  {
    this->classification_.set (x);
  }

  void Note::
  classification (const classification_optional& x)
  {
    this->classification_ = x;
  }

  void Note::
  classification (::std::unique_ptr< classification_type > x)
  {
    this->classification_.set (std::move (x));
  }

  const Note::attachment_sequence& Note::
  attachment () const
  {
    return this->attachment_;
  }

  Note::attachment_sequence& Note::
  attachment ()
  {
    return this->attachment_;
  }

  void Note::
  attachment (const attachment_sequence& s)
  {
    this->attachment_ = s;
  }

  const Note::summary_optional& Note::
  summary () const
  {
    return this->summary_;
  }

  Note::summary_optional& Note::
  summary ()
  {
    return this->summary_;
  }

  void Note::
  summary (const summary_type& x)
  {
    this->summary_.set (x);
  }

  void Note::
  summary (const summary_optional& x)
  {
    this->summary_ = x;
  }

  void Note::
  summary (::std::unique_ptr< summary_type > x)
  {
    this->summary_.set (std::move (x));
  }

  const Note::description_optional& Note::
  description () const
  {
    return this->description_;
  }

  Note::description_optional& Note::
  description ()
  {
    return this->description_;
  }

  void Note::
  description (const description_type& x)
  {
    this->description_.set (x);
  }

  void Note::
  description (const description_optional& x)
  {
    this->description_ = x;
  }

  void Note::
  description (::std::unique_ptr< description_type > x)
  {
    this->description_.set (std::move (x));
  }

  const Note::color_optional& Note::
  color () const
  {
    return this->color_;
  }

  Note::color_optional& Note::
  color ()
  {
    return this->color_;
  }

  void Note::
  color (const color_type& x)
  {
    this->color_.set (x);
  }

  void Note::
  color (const color_optional& x)
  {
    this->color_ = x;
  }

  void Note::
  color (::std::unique_ptr< color_type > x)
  {
    this->color_.set (std::move (x));
  }

  const Note::x_custom_sequence& Note::
  x_custom () const
  {
    return this->x_custom_;
  }

  Note::x_custom_sequence& Note::
  x_custom ()
  {
    return this->x_custom_;
  }

  void Note::
  x_custom (const x_custom_sequence& s)
  {
    this->x_custom_ = s;
  }


  // File
  //

  const File::uid_type& File::
  uid () const
  {
    return this->uid_.get ();
  }

  File::uid_type& File::
  uid ()
  {
    return this->uid_.get ();
  }

  void File::
  uid (const uid_type& x)
  {
    this->uid_.set (x);
  }

  void File::
  uid (::std::unique_ptr< uid_type > x)
  {
    this->uid_.set (std::move (x));
  }

  const File::prodid_type& File::
  prodid () const
  {
    return this->prodid_.get ();
  }

  File::prodid_type& File::
  prodid ()
  {
    return this->prodid_.get ();
  }

  void File::
  prodid (const prodid_type& x)
  {
    this->prodid_.set (x);
  }

  void File::
  prodid (::std::unique_ptr< prodid_type > x)
  {
    this->prodid_.set (std::move (x));
  }

  const File::creation_date_type& File::
  creation_date () const
  {
    return this->creation_date_.get ();
  }

  File::creation_date_type& File::
  creation_date ()
  {
    return this->creation_date_.get ();
  }

  void File::
  creation_date (const creation_date_type& x)
  {
    this->creation_date_.set (x);
  }

  void File::
  creation_date (::std::unique_ptr< creation_date_type > x)
  {
    this->creation_date_.set (std::move (x));
  }

  const File::last_modification_date_type& File::
  last_modification_date () const
  {
    return this->last_modification_date_.get ();
  }

  File::last_modification_date_type& File::
  last_modification_date ()
  {
    return this->last_modification_date_.get ();
  }

  void File::
  last_modification_date (const last_modification_date_type& x)
  {
    this->last_modification_date_.set (x);
  }

  void File::
  last_modification_date (::std::unique_ptr< last_modification_date_type > x)
  {
    this->last_modification_date_.set (std::move (x));
  }

  const File::categories_sequence& File::
  categories () const
  {
    return this->categories_;
  }

  File::categories_sequence& File::
  categories ()
  {
    return this->categories_;
  }

  void File::
  categories (const categories_sequence& s)
  {
    this->categories_ = s;
  }

  const File::classification_optional& File::
  classification () const
  {
    return this->classification_;
  }

  File::classification_optional& File::
  classification ()
  {
    return this->classification_;
  }

  void File::
  classification (const classification_type& x)
  {
    this->classification_.set (x);
  }

  void File::
  classification (const classification_optional& x)
  {
    this->classification_ = x;
  }

  void File::
  classification (::std::unique_ptr< classification_type > x)
  {
    this->classification_.set (std::move (x));
  }

  const File::file_type& File::
  file () const
  {
    return this->file_.get ();
  }

  File::file_type& File::
  file ()
  {
    return this->file_.get ();
  }

  void File::
  file (const file_type& x)
  {
    this->file_.set (x);
  }

  void File::
  file (::std::unique_ptr< file_type > x)
  {
    this->file_.set (std::move (x));
  }

  const File::note_optional& File::
  note () const
  {
    return this->note_;
  }

  File::note_optional& File::
  note ()
  {
    return this->note_;
  }

  void File::
  note (const note_type& x)
  {
    this->note_.set (x);
  }

  void File::
  note (const note_optional& x)
  {
    this->note_ = x;
  }

  void File::
  note (::std::unique_ptr< note_type > x)
  {
    this->note_.set (std::move (x));
  }

  const File::x_custom_sequence& File::
  x_custom () const
  {
    return this->x_custom_;
  }

  File::x_custom_sequence& File::
  x_custom ()
  {
    return this->x_custom_;
  }

  void File::
  x_custom (const x_custom_sequence& s)
  {
    this->x_custom_ = s;
  }


  // ConfigurationType
  //

  ConfigurationType::
  ConfigurationType (value v)
  : ::xml_schema::token (_xsd_ConfigurationType_literals_[v])
  {
  }

  ConfigurationType::
  ConfigurationType (const char* v)
  : ::xml_schema::token (v)
  {
  }

  ConfigurationType::
  ConfigurationType (const ::std::string& v)
  : ::xml_schema::token (v)
  {
  }

  ConfigurationType::
  ConfigurationType (const ::xml_schema::token& v)
  : ::xml_schema::token (v)
  {
  }

  ConfigurationType::
  ConfigurationType (const ConfigurationType& v,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xml_schema::token (v, f, c)
  {
  }

  ConfigurationType& ConfigurationType::
  operator= (value v)
  {
    static_cast< ::xml_schema::token& > (*this) = 
    ::xml_schema::token (_xsd_ConfigurationType_literals_[v]);

    return *this;
  }


  // CategoryColor
  //

  const CategoryColor::category_type& CategoryColor::
  category () const
  {
    return this->category_.get ();
  }

  CategoryColor::category_type& CategoryColor::
  category ()
  {
    return this->category_.get ();
  }

  void CategoryColor::
  category (const category_type& x)
  {
    this->category_.set (x);
  }

  void CategoryColor::
  category (::std::unique_ptr< category_type > x)
  {
    this->category_.set (std::move (x));
  }

  const CategoryColor::categorycolor_sequence& CategoryColor::
  categorycolor () const
  {
    return this->categorycolor_;
  }

  CategoryColor::categorycolor_sequence& CategoryColor::
  categorycolor ()
  {
    return this->categorycolor_;
  }

  void CategoryColor::
  categorycolor (const categorycolor_sequence& s)
  {
    this->categorycolor_ = s;
  }

  const CategoryColor::color_optional& CategoryColor::
  color () const
  {
    return this->color_;
  }

  CategoryColor::color_optional& CategoryColor::
  color ()
  {
    return this->color_;
  }

  void CategoryColor::
  color (const color_type& x)
  {
    this->color_.set (x);
  }

  void CategoryColor::
  color (const color_optional& x)
  {
    this->color_ = x;
  }

  void CategoryColor::
  color (::std::unique_ptr< color_type > x)
  {
    this->color_.set (std::move (x));
  }


  // textformatType
  //

  textformatType::
  textformatType (value v)
  : ::xml_schema::token (_xsd_textformatType_literals_[v])
  {
  }

  textformatType::
  textformatType (const char* v)
  : ::xml_schema::token (v)
  {
  }

  textformatType::
  textformatType (const ::std::string& v)
  : ::xml_schema::token (v)
  {
  }

  textformatType::
  textformatType (const ::xml_schema::token& v)
  : ::xml_schema::token (v)
  {
  }

  textformatType::
  textformatType (const textformatType& v,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::xml_schema::token (v, f, c)
  {
  }

  textformatType& textformatType::
  operator= (value v)
  {
    static_cast< ::xml_schema::token& > (*this) = 
    ::xml_schema::token (_xsd_textformatType_literals_[v]);

    return *this;
  }


  // Snippet
  //

  const Snippet::name_type& Snippet::
  name () const
  {
    return this->name_.get ();
  }

  Snippet::name_type& Snippet::
  name ()
  {
    return this->name_.get ();
  }

  void Snippet::
  name (const name_type& x)
  {
    this->name_.set (x);
  }

  void Snippet::
  name (::std::unique_ptr< name_type > x)
  {
    this->name_.set (std::move (x));
  }

  const Snippet::text_type& Snippet::
  text () const
  {
    return this->text_.get ();
  }

  Snippet::text_type& Snippet::
  text ()
  {
    return this->text_.get ();
  }

  void Snippet::
  text (const text_type& x)
  {
    this->text_.set (x);
  }

  void Snippet::
  text (::std::unique_ptr< text_type > x)
  {
    this->text_.set (std::move (x));
  }

  const Snippet::textformat_type& Snippet::
  textformat () const
  {
    return this->textformat_.get ();
  }

  Snippet::textformat_type& Snippet::
  textformat ()
  {
    return this->textformat_.get ();
  }

  void Snippet::
  textformat (const textformat_type& x)
  {
    this->textformat_.set (x);
  }

  void Snippet::
  textformat (::std::unique_ptr< textformat_type > x)
  {
    this->textformat_.set (std::move (x));
  }

  const Snippet::shortcut_optional& Snippet::
  shortcut () const
  {
    return this->shortcut_;
  }

  Snippet::shortcut_optional& Snippet::
  shortcut ()
  {
    return this->shortcut_;
  }

  void Snippet::
  shortcut (const shortcut_type& x)
  {
    this->shortcut_.set (x);
  }

  void Snippet::
  shortcut (const shortcut_optional& x)
  {
    this->shortcut_ = x;
  }

  void Snippet::
  shortcut (::std::unique_ptr< shortcut_type > x)
  {
    this->shortcut_.set (std::move (x));
  }

  const Snippet::color_optional& Snippet::
  color () const
  {
    return this->color_;
  }

  Snippet::color_optional& Snippet::
  color ()
  {
    return this->color_;
  }

  void Snippet::
  color (const color_type& x)
  {
    this->color_.set (x);
  }

  void Snippet::
  color (const color_optional& x)
  {
    this->color_ = x;
  }

  void Snippet::
  color (::std::unique_ptr< color_type > x)
  {
    this->color_.set (std::move (x));
  }


  // FileDriverSettings
  //

  const FileDriverSettings::host_optional& FileDriverSettings::
  host () const
  {
    return this->host_;
  }

  FileDriverSettings::host_optional& FileDriverSettings::
  host ()
  {
    return this->host_;
  }

  void FileDriverSettings::
  host (const host_type& x)
  {
    this->host_.set (x);
  }

  void FileDriverSettings::
  host (const host_optional& x)
  {
    this->host_ = x;
  }

  void FileDriverSettings::
  host (::std::unique_ptr< host_type > x)
  {
    this->host_.set (std::move (x));
  }

  const FileDriverSettings::port_optional& FileDriverSettings::
  port () const
  {
    return this->port_;
  }

  FileDriverSettings::port_optional& FileDriverSettings::
  port ()
  {
    return this->port_;
  }

  void FileDriverSettings::
  port (const port_type& x)
  {
    this->port_.set (x);
  }

  void FileDriverSettings::
  port (const port_optional& x)
  {
    this->port_ = x;
  }

  const FileDriverSettings::username_optional& FileDriverSettings::
  username () const
  {
    return this->username_;
  }

  FileDriverSettings::username_optional& FileDriverSettings::
  username ()
  {
    return this->username_;
  }

  void FileDriverSettings::
  username (const username_type& x)
  {
    this->username_.set (x);
  }

  void FileDriverSettings::
  username (const username_optional& x)
  {
    this->username_ = x;
  }

  void FileDriverSettings::
  username (::std::unique_ptr< username_type > x)
  {
    this->username_.set (std::move (x));
  }

  const FileDriverSettings::password_optional& FileDriverSettings::
  password () const
  {
    return this->password_;
  }

  FileDriverSettings::password_optional& FileDriverSettings::
  password ()
  {
    return this->password_;
  }

  void FileDriverSettings::
  password (const password_type& x)
  {
    this->password_.set (x);
  }

  void FileDriverSettings::
  password (const password_optional& x)
  {
    this->password_ = x;
  }

  void FileDriverSettings::
  password (::std::unique_ptr< password_type > x)
  {
    this->password_.set (std::move (x));
  }


  // Configuration
  //

  const Configuration::uid_type& Configuration::
  uid () const
  {
    return this->uid_.get ();
  }

  Configuration::uid_type& Configuration::
  uid ()
  {
    return this->uid_.get ();
  }

  void Configuration::
  uid (const uid_type& x)
  {
    this->uid_.set (x);
  }

  void Configuration::
  uid (::std::unique_ptr< uid_type > x)
  {
    this->uid_.set (std::move (x));
  }

  const Configuration::prodid_type& Configuration::
  prodid () const
  {
    return this->prodid_.get ();
  }

  Configuration::prodid_type& Configuration::
  prodid ()
  {
    return this->prodid_.get ();
  }

  void Configuration::
  prodid (const prodid_type& x)
  {
    this->prodid_.set (x);
  }

  void Configuration::
  prodid (::std::unique_ptr< prodid_type > x)
  {
    this->prodid_.set (std::move (x));
  }

  const Configuration::creation_date_type& Configuration::
  creation_date () const
  {
    return this->creation_date_.get ();
  }

  Configuration::creation_date_type& Configuration::
  creation_date ()
  {
    return this->creation_date_.get ();
  }

  void Configuration::
  creation_date (const creation_date_type& x)
  {
    this->creation_date_.set (x);
  }

  void Configuration::
  creation_date (::std::unique_ptr< creation_date_type > x)
  {
    this->creation_date_.set (std::move (x));
  }

  const Configuration::last_modification_date_type& Configuration::
  last_modification_date () const
  {
    return this->last_modification_date_.get ();
  }

  Configuration::last_modification_date_type& Configuration::
  last_modification_date ()
  {
    return this->last_modification_date_.get ();
  }

  void Configuration::
  last_modification_date (const last_modification_date_type& x)
  {
    this->last_modification_date_.set (x);
  }

  void Configuration::
  last_modification_date (::std::unique_ptr< last_modification_date_type > x)
  {
    this->last_modification_date_.set (std::move (x));
  }

  const Configuration::type_type& Configuration::
  type () const
  {
    return this->type_.get ();
  }

  Configuration::type_type& Configuration::
  type ()
  {
    return this->type_.get ();
  }

  void Configuration::
  type (const type_type& x)
  {
    this->type_.set (x);
  }

  void Configuration::
  type (::std::unique_ptr< type_type > x)
  {
    this->type_.set (std::move (x));
  }

  const Configuration::language_optional& Configuration::
  language () const
  {
    return this->language_;
  }

  Configuration::language_optional& Configuration::
  language ()
  {
    return this->language_;
  }

  void Configuration::
  language (const language_type& x)
  {
    this->language_.set (x);
  }

  void Configuration::
  language (const language_optional& x)
  {
    this->language_ = x;
  }

  void Configuration::
  language (::std::unique_ptr< language_type > x)
  {
    this->language_.set (std::move (x));
  }

  const Configuration::e_sequence& Configuration::
  e () const
  {
    return this->e_;
  }

  Configuration::e_sequence& Configuration::
  e ()
  {
    return this->e_;
  }

  void Configuration::
  e (const e_sequence& s)
  {
    this->e_ = s;
  }

  const Configuration::categorycolor_sequence& Configuration::
  categorycolor () const
  {
    return this->categorycolor_;
  }

  Configuration::categorycolor_sequence& Configuration::
  categorycolor ()
  {
    return this->categorycolor_;
  }

  void Configuration::
  categorycolor (const categorycolor_sequence& s)
  {
    this->categorycolor_ = s;
  }

  const Configuration::name_optional& Configuration::
  name () const
  {
    return this->name_;
  }

  Configuration::name_optional& Configuration::
  name ()
  {
    return this->name_;
  }

  void Configuration::
  name (const name_type& x)
  {
    this->name_.set (x);
  }

  void Configuration::
  name (const name_optional& x)
  {
    this->name_ = x;
  }

  void Configuration::
  name (::std::unique_ptr< name_type > x)
  {
    this->name_.set (std::move (x));
  }

  const Configuration::snippet_sequence& Configuration::
  snippet () const
  {
    return this->snippet_;
  }

  Configuration::snippet_sequence& Configuration::
  snippet ()
  {
    return this->snippet_;
  }

  void Configuration::
  snippet (const snippet_sequence& s)
  {
    this->snippet_ = s;
  }

  const Configuration::relationType_optional& Configuration::
  relationType () const
  {
    return this->relationType_;
  }

  Configuration::relationType_optional& Configuration::
  relationType ()
  {
    return this->relationType_;
  }

  void Configuration::
  relationType (const relationType_type& x)
  {
    this->relationType_.set (x);
  }

  void Configuration::
  relationType (const relationType_optional& x)
  {
    this->relationType_ = x;
  }

  void Configuration::
  relationType (::std::unique_ptr< relationType_type > x)
  {
    this->relationType_.set (std::move (x));
  }

  const Configuration::color_optional& Configuration::
  color () const
  {
    return this->color_;
  }

  Configuration::color_optional& Configuration::
  color ()
  {
    return this->color_;
  }

  void Configuration::
  color (const color_type& x)
  {
    this->color_.set (x);
  }

  void Configuration::
  color (const color_optional& x)
  {
    this->color_ = x;
  }

  void Configuration::
  color (::std::unique_ptr< color_type > x)
  {
    this->color_.set (std::move (x));
  }

  const Configuration::iconName_optional& Configuration::
  iconName () const
  {
    return this->iconName_;
  }

  Configuration::iconName_optional& Configuration::
  iconName ()
  {
    return this->iconName_;
  }

  void Configuration::
  iconName (const iconName_type& x)
  {
    this->iconName_.set (x);
  }

  void Configuration::
  iconName (const iconName_optional& x)
  {
    this->iconName_ = x;
  }

  void Configuration::
  iconName (::std::unique_ptr< iconName_type > x)
  {
    this->iconName_.set (std::move (x));
  }

  const Configuration::priority_optional& Configuration::
  priority () const
  {
    return this->priority_;
  }

  Configuration::priority_optional& Configuration::
  priority ()
  {
    return this->priority_;
  }

  void Configuration::
  priority (const priority_type& x)
  {
    this->priority_.set (x);
  }

  void Configuration::
  priority (const priority_optional& x)
  {
    this->priority_ = x;
  }

  const Configuration::parent_optional& Configuration::
  parent () const
  {
    return this->parent_;
  }

  Configuration::parent_optional& Configuration::
  parent ()
  {
    return this->parent_;
  }

  void Configuration::
  parent (const parent_type& x)
  {
    this->parent_.set (x);
  }

  void Configuration::
  parent (const parent_optional& x)
  {
    this->parent_ = x;
  }

  void Configuration::
  parent (::std::unique_ptr< parent_type > x)
  {
    this->parent_.set (std::move (x));
  }

  const Configuration::member_sequence& Configuration::
  member () const
  {
    return this->member_;
  }

  Configuration::member_sequence& Configuration::
  member ()
  {
    return this->member_;
  }

  void Configuration::
  member (const member_sequence& s)
  {
    this->member_ = s;
  }

  const Configuration::driver_optional& Configuration::
  driver () const
  {
    return this->driver_;
  }

  Configuration::driver_optional& Configuration::
  driver ()
  {
    return this->driver_;
  }

  void Configuration::
  driver (const driver_type& x)
  {
    this->driver_.set (x);
  }

  void Configuration::
  driver (const driver_optional& x)
  {
    this->driver_ = x;
  }

  void Configuration::
  driver (::std::unique_ptr< driver_type > x)
  {
    this->driver_.set (std::move (x));
  }

  const Configuration::title_optional& Configuration::
  title () const
  {
    return this->title_;
  }

  Configuration::title_optional& Configuration::
  title ()
  {
    return this->title_;
  }

  void Configuration::
  title (const title_type& x)
  {
    this->title_.set (x);
  }

  void Configuration::
  title (const title_optional& x)
  {
    this->title_ = x;
  }

  void Configuration::
  title (::std::unique_ptr< title_type > x)
  {
    this->title_.set (std::move (x));
  }

  const Configuration::enabled_optional& Configuration::
  enabled () const
  {
    return this->enabled_;
  }

  Configuration::enabled_optional& Configuration::
  enabled ()
  {
    return this->enabled_;
  }

  void Configuration::
  enabled (const enabled_type& x)
  {
    this->enabled_.set (x);
  }

  void Configuration::
  enabled (const enabled_optional& x)
  {
    this->enabled_ = x;
  }

  const Configuration::settings_optional& Configuration::
  settings () const
  {
    return this->settings_;
  }

  Configuration::settings_optional& Configuration::
  settings ()
  {
    return this->settings_;
  }

  void Configuration::
  settings (const settings_type& x)
  {
    this->settings_.set (x);
  }

  void Configuration::
  settings (const settings_optional& x)
  {
    this->settings_ = x;
  }

  void Configuration::
  settings (::std::unique_ptr< settings_type > x)
  {
    this->settings_.set (std::move (x));
  }


  // parameters
  //

  const parameters::fmttype_type& parameters::
  fmttype () const
  {
    return this->fmttype_.get ();
  }

  parameters::fmttype_type& parameters::
  fmttype ()
  {
    return this->fmttype_.get ();
  }

  void parameters::
  fmttype (const fmttype_type& x)
  {
    this->fmttype_.set (x);
  }

  void parameters::
  fmttype (::std::unique_ptr< fmttype_type > x)
  {
    this->fmttype_.set (std::move (x));
  }

  const parameters::x_label_optional& parameters::
  x_label () const
  {
    return this->x_label_;
  }

  parameters::x_label_optional& parameters::
  x_label ()
  {
    return this->x_label_;
  }

  void parameters::
  x_label (const x_label_type& x)
  {
    this->x_label_.set (x);
  }

  void parameters::
  x_label (const x_label_optional& x)
  {
    this->x_label_ = x;
  }

  void parameters::
  x_label (::std::unique_ptr< x_label_type > x)
  {
    this->x_label_.set (std::move (x));
  }

  const parameters::encoding_optional& parameters::
  encoding () const
  {
    return this->encoding_;
  }

  parameters::encoding_optional& parameters::
  encoding ()
  {
    return this->encoding_;
  }

  void parameters::
  encoding (const encoding_type& x)
  {
    this->encoding_.set (x);
  }

  void parameters::
  encoding (const encoding_optional& x)
  {
    this->encoding_ = x;
  }

  void parameters::
  encoding (::std::unique_ptr< encoding_type > x)
  {
    this->encoding_.set (std::move (x));
  }

  const parameters::encoding_type& parameters::
  encoding_default_value ()
  {
    return encoding_default_value_;
  }
}

#include <xsd/cxx/xml/dom/parsing-source.hxx>

#include <xsd/cxx/tree/type-factory-map.hxx>

namespace _xsd
{
  static
  const ::xsd::cxx::tree::type_factory_plate< 0, char >
  type_factory_plate_init;
}

namespace KolabXSD
{
  // KolabBase
  //

  const KolabBase::version_type KolabBase::version_default_value_ (
    "3.0");

  KolabBase::
  KolabBase ()
  : ::xml_schema::type (),
    version_ (version_default_value (), this)
  {
  }

  KolabBase::
  KolabBase (const KolabBase& x,
             ::xml_schema::flags f,
             ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    version_ (x.version_, f, this)
  {
  }

  KolabBase::
  KolabBase (const ::xercesc::DOMElement& e,
             ::xml_schema::flags f,
             ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    version_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, false, false, true);
      this->parse (p, f);
    }
  }

  void KolabBase::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    while (p.more_attributes ())
    {
      const ::xercesc::DOMAttr& i (p.next_attribute ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      if (n.name () == "version" && n.namespace_ ().empty ())
      {
        this->version_.set (version_traits::create (i, f, this));
        continue;
      }
    }

    if (!version_.present ())
    {
      this->version_.set (version_default_value ());
    }
  }

  KolabBase* KolabBase::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class KolabBase (*this, f, c);
  }

  KolabBase& KolabBase::
  operator= (const KolabBase& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->version_ = x.version_;
    }

    return *this;
  }

  KolabBase::
  ~KolabBase ()
  {
  }

  // attachmentPropType
  //

  attachmentPropType::
  attachmentPropType (const parameters_type& parameters)
  : ::xml_schema::type (),
    parameters_ (parameters, this),
    uri_ (this),
    binary_ (this)
  {
  }

  attachmentPropType::
  attachmentPropType (::std::unique_ptr< parameters_type > parameters)
  : ::xml_schema::type (),
    parameters_ (std::move (parameters), this),
    uri_ (this),
    binary_ (this)
  {
  }

  attachmentPropType::
  attachmentPropType (const attachmentPropType& x,
                      ::xml_schema::flags f,
                      ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    parameters_ (x.parameters_, f, this),
    uri_ (x.uri_, f, this),
    binary_ (x.binary_, f, this)
  {
  }

  attachmentPropType::
  attachmentPropType (const ::xercesc::DOMElement& e,
                      ::xml_schema::flags f,
                      ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    parameters_ (this),
    uri_ (this),
    binary_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void attachmentPropType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // parameters
      //
      if (n.name () == "parameters" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< parameters_type > r (
          parameters_traits::create (i, f, this));

        if (!parameters_.present ())
        {
          this->parameters_.set (::std::move (r));
          continue;
        }
      }

      // uri
      //
      if (n.name () == "uri" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< uri_type > r (
          uri_traits::create (i, f, this));

        if (!this->uri_)
        {
          this->uri_.set (::std::move (r));
          continue;
        }
      }

      // binary
      //
      if (n.name () == "binary" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< binary_type > r (
          binary_traits::create (i, f, this));

        if (!this->binary_)
        {
          this->binary_.set (::std::move (r));
          continue;
        }
      }

      break;
    }

    if (!parameters_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "parameters",
        "http://kolab.org");
    }
  }

  attachmentPropType* attachmentPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class attachmentPropType (*this, f, c);
  }

  attachmentPropType& attachmentPropType::
  operator= (const attachmentPropType& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->parameters_ = x.parameters_;
      this->uri_ = x.uri_;
      this->binary_ = x.binary_;
    }

    return *this;
  }

  attachmentPropType::
  ~attachmentPropType ()
  {
  }

  // classifcationPropType
  //

  classifcationPropType::
  classifcationPropType (const ::xercesc::DOMElement& e,
                         ::xml_schema::flags f,
                         ::xml_schema::container* c)
  : ::xml_schema::token (e, f, c)
  {
    _xsd_classifcationPropType_convert ();
  }

  classifcationPropType::
  classifcationPropType (const ::xercesc::DOMAttr& a,
                         ::xml_schema::flags f,
                         ::xml_schema::container* c)
  : ::xml_schema::token (a, f, c)
  {
    _xsd_classifcationPropType_convert ();
  }

  classifcationPropType::
  classifcationPropType (const ::std::string& s,
                         const ::xercesc::DOMElement* e,
                         ::xml_schema::flags f,
                         ::xml_schema::container* c)
  : ::xml_schema::token (s, e, f, c)
  {
    _xsd_classifcationPropType_convert ();
  }

  classifcationPropType* classifcationPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class classifcationPropType (*this, f, c);
  }

  classifcationPropType::value classifcationPropType::
  _xsd_classifcationPropType_convert () const
  {
    ::xsd::cxx::tree::enum_comparator< char > c (_xsd_classifcationPropType_literals_);
    const value* i (::std::lower_bound (
                      _xsd_classifcationPropType_indexes_,
                      _xsd_classifcationPropType_indexes_ + 3,
                      *this,
                      c));

    if (i == _xsd_classifcationPropType_indexes_ + 3 || _xsd_classifcationPropType_literals_[*i] != *this)
    {
      throw ::xsd::cxx::tree::unexpected_enumerator < char > (*this);
    }

    return *i;
  }

  const char* const classifcationPropType::
  _xsd_classifcationPropType_literals_[3] =
  {
    "PUBLIC",
    "PRIVATE",
    "CONFIDENTIAL"
  };

  const classifcationPropType::value classifcationPropType::
  _xsd_classifcationPropType_indexes_[3] =
  {
    ::KolabXSD::classifcationPropType::CONFIDENTIAL,
    ::KolabXSD::classifcationPropType::PRIVATE,
    ::KolabXSD::classifcationPropType::PUBLIC
  };

  // CustomType
  //

  CustomType::
  CustomType (const identifier_type& identifier,
              const value_type& value)
  : ::xml_schema::type (),
    identifier_ (identifier, this),
    value_ (value, this)
  {
  }

  CustomType::
  CustomType (const CustomType& x,
              ::xml_schema::flags f,
              ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    identifier_ (x.identifier_, f, this),
    value_ (x.value_, f, this)
  {
  }

  CustomType::
  CustomType (const ::xercesc::DOMElement& e,
              ::xml_schema::flags f,
              ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    identifier_ (this),
    value_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void CustomType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // identifier
      //
      if (n.name () == "identifier" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< identifier_type > r (
          identifier_traits::create (i, f, this));

        if (!identifier_.present ())
        {
          this->identifier_.set (::std::move (r));
          continue;
        }
      }

      // value
      //
      if (n.name () == "value" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< value_type > r (
          value_traits::create (i, f, this));

        if (!value_.present ())
        {
          this->value_.set (::std::move (r));
          continue;
        }
      }

      break;
    }

    if (!identifier_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "identifier",
        "http://kolab.org");
    }

    if (!value_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "value",
        "http://kolab.org");
    }
  }

  CustomType* CustomType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class CustomType (*this, f, c);
  }

  CustomType& CustomType::
  operator= (const CustomType& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->identifier_ = x.identifier_;
      this->value_ = x.value_;
    }

    return *this;
  }

  CustomType::
  ~CustomType ()
  {
  }

  // Note
  //

  Note::
  Note (const uid_type& uid,
        const prodid_type& prodid,
        const creation_date_type& creation_date,
        const last_modification_date_type& last_modification_date)
  : ::KolabXSD::KolabBase (),
    uid_ (uid, this),
    prodid_ (prodid, this),
    creation_date_ (creation_date, this),
    last_modification_date_ (last_modification_date, this),
    categories_ (this),
    classification_ (this),
    attachment_ (this),
    summary_ (this),
    description_ (this),
    color_ (this),
    x_custom_ (this)
  {
  }

  Note::
  Note (const Note& x,
        ::xml_schema::flags f,
        ::xml_schema::container* c)
  : ::KolabXSD::KolabBase (x, f, c),
    uid_ (x.uid_, f, this),
    prodid_ (x.prodid_, f, this),
    creation_date_ (x.creation_date_, f, this),
    last_modification_date_ (x.last_modification_date_, f, this),
    categories_ (x.categories_, f, this),
    classification_ (x.classification_, f, this),
    attachment_ (x.attachment_, f, this),
    summary_ (x.summary_, f, this),
    description_ (x.description_, f, this),
    color_ (x.color_, f, this),
    x_custom_ (x.x_custom_, f, this)
  {
  }

  Note::
  Note (const ::xercesc::DOMElement& e,
        ::xml_schema::flags f,
        ::xml_schema::container* c)
  : ::KolabXSD::KolabBase (e, f | ::xml_schema::flags::base, c),
    uid_ (this),
    prodid_ (this),
    creation_date_ (this),
    last_modification_date_ (this),
    categories_ (this),
    classification_ (this),
    attachment_ (this),
    summary_ (this),
    description_ (this),
    color_ (this),
    x_custom_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, true);
      this->parse (p, f);
    }
  }

  void Note::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::KolabXSD::KolabBase::parse (p, f);

    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // uid
      //
      if (n.name () == "uid" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< uid_type > r (
          uid_traits::create (i, f, this));

        if (!uid_.present ())
        {
          this->uid_.set (::std::move (r));
          continue;
        }
      }

      // prodid
      //
      if (n.name () == "prodid" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< prodid_type > r (
          prodid_traits::create (i, f, this));

        if (!prodid_.present ())
        {
          this->prodid_.set (::std::move (r));
          continue;
        }
      }

      // creation-date
      //
      if (n.name () == "creation-date" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< creation_date_type > r (
          creation_date_traits::create (i, f, this));

        if (!creation_date_.present ())
        {
          this->creation_date_.set (::std::move (r));
          continue;
        }
      }

      // last-modification-date
      //
      if (n.name () == "last-modification-date" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< last_modification_date_type > r (
          last_modification_date_traits::create (i, f, this));

        if (!last_modification_date_.present ())
        {
          this->last_modification_date_.set (::std::move (r));
          continue;
        }
      }

      // categories
      //
      if (n.name () == "categories" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< categories_type > r (
          categories_traits::create (i, f, this));

        this->categories_.push_back (::std::move (r));
        continue;
      }

      // classification
      //
      if (n.name () == "classification" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< classification_type > r (
          classification_traits::create (i, f, this));

        if (!this->classification_)
        {
          this->classification_.set (::std::move (r));
          continue;
        }
      }

      // attachment
      //
      if (n.name () == "attachment" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< attachment_type > r (
          attachment_traits::create (i, f, this));

        this->attachment_.push_back (::std::move (r));
        continue;
      }

      // summary
      //
      if (n.name () == "summary" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< summary_type > r (
          summary_traits::create (i, f, this));

        if (!this->summary_)
        {
          this->summary_.set (::std::move (r));
          continue;
        }
      }

      // description
      //
      if (n.name () == "description" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< description_type > r (
          description_traits::create (i, f, this));

        if (!this->description_)
        {
          this->description_.set (::std::move (r));
          continue;
        }
      }

      // color
      //
      if (n.name () == "color" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< color_type > r (
          color_traits::create (i, f, this));

        if (!this->color_)
        {
          this->color_.set (::std::move (r));
          continue;
        }
      }

      // x-custom
      //
      if (n.name () == "x-custom" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< x_custom_type > r (
          x_custom_traits::create (i, f, this));

        this->x_custom_.push_back (::std::move (r));
        continue;
      }

      break;
    }

    if (!uid_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "uid",
        "http://kolab.org");
    }

    if (!prodid_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "prodid",
        "http://kolab.org");
    }

    if (!creation_date_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "creation-date",
        "http://kolab.org");
    }

    if (!last_modification_date_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "last-modification-date",
        "http://kolab.org");
    }
  }

  Note* Note::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class Note (*this, f, c);
  }

  Note& Note::
  operator= (const Note& x)
  {
    if (this != &x)
    {
      static_cast< ::KolabXSD::KolabBase& > (*this) = x;
      this->uid_ = x.uid_;
      this->prodid_ = x.prodid_;
      this->creation_date_ = x.creation_date_;
      this->last_modification_date_ = x.last_modification_date_;
      this->categories_ = x.categories_;
      this->classification_ = x.classification_;
      this->attachment_ = x.attachment_;
      this->summary_ = x.summary_;
      this->description_ = x.description_;
      this->color_ = x.color_;
      this->x_custom_ = x.x_custom_;
    }

    return *this;
  }

  Note::
  ~Note ()
  {
  }

  // File
  //

  File::
  File (const uid_type& uid,
        const prodid_type& prodid,
        const creation_date_type& creation_date,
        const last_modification_date_type& last_modification_date,
        const file_type& file)
  : ::KolabXSD::KolabBase (),
    uid_ (uid, this),
    prodid_ (prodid, this),
    creation_date_ (creation_date, this),
    last_modification_date_ (last_modification_date, this),
    categories_ (this),
    classification_ (this),
    file_ (file, this),
    note_ (this),
    x_custom_ (this)
  {
  }

  File::
  File (const uid_type& uid,
        const prodid_type& prodid,
        const creation_date_type& creation_date,
        const last_modification_date_type& last_modification_date,
        ::std::unique_ptr< file_type > file)
  : ::KolabXSD::KolabBase (),
    uid_ (uid, this),
    prodid_ (prodid, this),
    creation_date_ (creation_date, this),
    last_modification_date_ (last_modification_date, this),
    categories_ (this),
    classification_ (this),
    file_ (std::move (file), this),
    note_ (this),
    x_custom_ (this)
  {
  }

  File::
  File (const File& x,
        ::xml_schema::flags f,
        ::xml_schema::container* c)
  : ::KolabXSD::KolabBase (x, f, c),
    uid_ (x.uid_, f, this),
    prodid_ (x.prodid_, f, this),
    creation_date_ (x.creation_date_, f, this),
    last_modification_date_ (x.last_modification_date_, f, this),
    categories_ (x.categories_, f, this),
    classification_ (x.classification_, f, this),
    file_ (x.file_, f, this),
    note_ (x.note_, f, this),
    x_custom_ (x.x_custom_, f, this)
  {
  }

  File::
  File (const ::xercesc::DOMElement& e,
        ::xml_schema::flags f,
        ::xml_schema::container* c)
  : ::KolabXSD::KolabBase (e, f | ::xml_schema::flags::base, c),
    uid_ (this),
    prodid_ (this),
    creation_date_ (this),
    last_modification_date_ (this),
    categories_ (this),
    classification_ (this),
    file_ (this),
    note_ (this),
    x_custom_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, true);
      this->parse (p, f);
    }
  }

  void File::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::KolabXSD::KolabBase::parse (p, f);

    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // uid
      //
      if (n.name () == "uid" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< uid_type > r (
          uid_traits::create (i, f, this));

        if (!uid_.present ())
        {
          this->uid_.set (::std::move (r));
          continue;
        }
      }

      // prodid
      //
      if (n.name () == "prodid" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< prodid_type > r (
          prodid_traits::create (i, f, this));

        if (!prodid_.present ())
        {
          this->prodid_.set (::std::move (r));
          continue;
        }
      }

      // creation-date
      //
      if (n.name () == "creation-date" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< creation_date_type > r (
          creation_date_traits::create (i, f, this));

        if (!creation_date_.present ())
        {
          this->creation_date_.set (::std::move (r));
          continue;
        }
      }

      // last-modification-date
      //
      if (n.name () == "last-modification-date" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< last_modification_date_type > r (
          last_modification_date_traits::create (i, f, this));

        if (!last_modification_date_.present ())
        {
          this->last_modification_date_.set (::std::move (r));
          continue;
        }
      }

      // categories
      //
      if (n.name () == "categories" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< categories_type > r (
          categories_traits::create (i, f, this));

        this->categories_.push_back (::std::move (r));
        continue;
      }

      // classification
      //
      if (n.name () == "classification" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< classification_type > r (
          classification_traits::create (i, f, this));

        if (!this->classification_)
        {
          this->classification_.set (::std::move (r));
          continue;
        }
      }

      // file
      //
      if (n.name () == "file" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< file_type > r (
          file_traits::create (i, f, this));

        if (!file_.present ())
        {
          this->file_.set (::std::move (r));
          continue;
        }
      }

      // note
      //
      if (n.name () == "note" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< note_type > r (
          note_traits::create (i, f, this));

        if (!this->note_)
        {
          this->note_.set (::std::move (r));
          continue;
        }
      }

      // x-custom
      //
      if (n.name () == "x-custom" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< x_custom_type > r (
          x_custom_traits::create (i, f, this));

        this->x_custom_.push_back (::std::move (r));
        continue;
      }

      break;
    }

    if (!uid_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "uid",
        "http://kolab.org");
    }

    if (!prodid_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "prodid",
        "http://kolab.org");
    }

    if (!creation_date_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "creation-date",
        "http://kolab.org");
    }

    if (!last_modification_date_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "last-modification-date",
        "http://kolab.org");
    }

    if (!file_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "file",
        "http://kolab.org");
    }
  }

  File* File::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class File (*this, f, c);
  }

  File& File::
  operator= (const File& x)
  {
    if (this != &x)
    {
      static_cast< ::KolabXSD::KolabBase& > (*this) = x;
      this->uid_ = x.uid_;
      this->prodid_ = x.prodid_;
      this->creation_date_ = x.creation_date_;
      this->last_modification_date_ = x.last_modification_date_;
      this->categories_ = x.categories_;
      this->classification_ = x.classification_;
      this->file_ = x.file_;
      this->note_ = x.note_;
      this->x_custom_ = x.x_custom_;
    }

    return *this;
  }

  File::
  ~File ()
  {
  }

  // ConfigurationType
  //

  ConfigurationType::
  ConfigurationType (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xml_schema::token (e, f, c)
  {
    _xsd_ConfigurationType_convert ();
  }

  ConfigurationType::
  ConfigurationType (const ::xercesc::DOMAttr& a,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xml_schema::token (a, f, c)
  {
    _xsd_ConfigurationType_convert ();
  }

  ConfigurationType::
  ConfigurationType (const ::std::string& s,
                     const ::xercesc::DOMElement* e,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xml_schema::token (s, e, f, c)
  {
    _xsd_ConfigurationType_convert ();
  }

  ConfigurationType* ConfigurationType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class ConfigurationType (*this, f, c);
  }

  ConfigurationType::value ConfigurationType::
  _xsd_ConfigurationType_convert () const
  {
    ::xsd::cxx::tree::enum_comparator< char > c (_xsd_ConfigurationType_literals_);
    const value* i (::std::lower_bound (
                      _xsd_ConfigurationType_indexes_,
                      _xsd_ConfigurationType_indexes_ + 5,
                      *this,
                      c));

    if (i == _xsd_ConfigurationType_indexes_ + 5 || _xsd_ConfigurationType_literals_[*i] != *this)
    {
      throw ::xsd::cxx::tree::unexpected_enumerator < char > (*this);
    }

    return *i;
  }

  const char* const ConfigurationType::
  _xsd_ConfigurationType_literals_[5] =
  {
    "dictionary",
    "categorycolor",
    "snippets",
    "relation",
    "file_driver"
  };

  const ConfigurationType::value ConfigurationType::
  _xsd_ConfigurationType_indexes_[5] =
  {
    ::KolabXSD::ConfigurationType::categorycolor,
    ::KolabXSD::ConfigurationType::dictionary,
    ::KolabXSD::ConfigurationType::file_driver,
    ::KolabXSD::ConfigurationType::relation,
    ::KolabXSD::ConfigurationType::snippets
  };

  // CategoryColor
  //

  CategoryColor::
  CategoryColor (const category_type& category)
  : ::xml_schema::type (),
    category_ (category, this),
    categorycolor_ (this),
    color_ (this)
  {
  }

  CategoryColor::
  CategoryColor (const CategoryColor& x,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    category_ (x.category_, f, this),
    categorycolor_ (x.categorycolor_, f, this),
    color_ (x.color_, f, this)
  {
  }

  CategoryColor::
  CategoryColor (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    category_ (this),
    categorycolor_ (this),
    color_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, true);
      this->parse (p, f);
    }
  }

  void CategoryColor::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // category
      //
      if (n.name () == "category" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< category_type > r (
          category_traits::create (i, f, this));

        if (!category_.present ())
        {
          this->category_.set (::std::move (r));
          continue;
        }
      }

      // categorycolor
      //
      if (n.name () == "categorycolor" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< categorycolor_type > r (
          categorycolor_traits::create (i, f, this));

        this->categorycolor_.push_back (::std::move (r));
        continue;
      }

      break;
    }

    if (!category_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "category",
        "http://kolab.org");
    }

    while (p.more_attributes ())
    {
      const ::xercesc::DOMAttr& i (p.next_attribute ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      if (n.name () == "color" && n.namespace_ ().empty ())
      {
        this->color_.set (color_traits::create (i, f, this));
        continue;
      }
    }
  }

  CategoryColor* CategoryColor::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class CategoryColor (*this, f, c);
  }

  CategoryColor& CategoryColor::
  operator= (const CategoryColor& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->category_ = x.category_;
      this->categorycolor_ = x.categorycolor_;
      this->color_ = x.color_;
    }

    return *this;
  }

  CategoryColor::
  ~CategoryColor ()
  {
  }

  // textformatType
  //

  textformatType::
  textformatType (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::xml_schema::token (e, f, c)
  {
    _xsd_textformatType_convert ();
  }

  textformatType::
  textformatType (const ::xercesc::DOMAttr& a,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::xml_schema::token (a, f, c)
  {
    _xsd_textformatType_convert ();
  }

  textformatType::
  textformatType (const ::std::string& s,
                  const ::xercesc::DOMElement* e,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::xml_schema::token (s, e, f, c)
  {
    _xsd_textformatType_convert ();
  }

  textformatType* textformatType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class textformatType (*this, f, c);
  }

  textformatType::value textformatType::
  _xsd_textformatType_convert () const
  {
    ::xsd::cxx::tree::enum_comparator< char > c (_xsd_textformatType_literals_);
    const value* i (::std::lower_bound (
                      _xsd_textformatType_indexes_,
                      _xsd_textformatType_indexes_ + 2,
                      *this,
                      c));

    if (i == _xsd_textformatType_indexes_ + 2 || _xsd_textformatType_literals_[*i] != *this)
    {
      throw ::xsd::cxx::tree::unexpected_enumerator < char > (*this);
    }

    return *i;
  }

  const char* const textformatType::
  _xsd_textformatType_literals_[2] =
  {
    "PLAIN",
    "HTML"
  };

  const textformatType::value textformatType::
  _xsd_textformatType_indexes_[2] =
  {
    ::KolabXSD::textformatType::HTML,
    ::KolabXSD::textformatType::PLAIN
  };

  // Snippet
  //

  Snippet::
  Snippet (const name_type& name,
           const text_type& text,
           const textformat_type& textformat)
  : ::xml_schema::type (),
    name_ (name, this),
    text_ (text, this),
    textformat_ (textformat, this),
    shortcut_ (this),
    color_ (this)
  {
  }

  Snippet::
  Snippet (const Snippet& x,
           ::xml_schema::flags f,
           ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    name_ (x.name_, f, this),
    text_ (x.text_, f, this),
    textformat_ (x.textformat_, f, this),
    shortcut_ (x.shortcut_, f, this),
    color_ (x.color_, f, this)
  {
  }

  Snippet::
  Snippet (const ::xercesc::DOMElement& e,
           ::xml_schema::flags f,
           ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    name_ (this),
    text_ (this),
    textformat_ (this),
    shortcut_ (this),
    color_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, true);
      this->parse (p, f);
    }
  }

  void Snippet::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // name
      //
      if (n.name () == "name" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< name_type > r (
          name_traits::create (i, f, this));

        if (!name_.present ())
        {
          this->name_.set (::std::move (r));
          continue;
        }
      }

      // text
      //
      if (n.name () == "text" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< text_type > r (
          text_traits::create (i, f, this));

        if (!text_.present ())
        {
          this->text_.set (::std::move (r));
          continue;
        }
      }

      // textformat
      //
      if (n.name () == "textformat" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< textformat_type > r (
          textformat_traits::create (i, f, this));

        if (!textformat_.present ())
        {
          this->textformat_.set (::std::move (r));
          continue;
        }
      }

      // shortcut
      //
      if (n.name () == "shortcut" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< shortcut_type > r (
          shortcut_traits::create (i, f, this));

        if (!this->shortcut_)
        {
          this->shortcut_.set (::std::move (r));
          continue;
        }
      }

      break;
    }

    if (!name_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "name",
        "http://kolab.org");
    }

    if (!text_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "text",
        "http://kolab.org");
    }

    if (!textformat_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "textformat",
        "http://kolab.org");
    }

    while (p.more_attributes ())
    {
      const ::xercesc::DOMAttr& i (p.next_attribute ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      if (n.name () == "color" && n.namespace_ ().empty ())
      {
        this->color_.set (color_traits::create (i, f, this));
        continue;
      }
    }
  }

  Snippet* Snippet::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class Snippet (*this, f, c);
  }

  Snippet& Snippet::
  operator= (const Snippet& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->name_ = x.name_;
      this->text_ = x.text_;
      this->textformat_ = x.textformat_;
      this->shortcut_ = x.shortcut_;
      this->color_ = x.color_;
    }

    return *this;
  }

  Snippet::
  ~Snippet ()
  {
  }

  // FileDriverSettings
  //

  FileDriverSettings::
  FileDriverSettings ()
  : ::xml_schema::type (),
    host_ (this),
    port_ (this),
    username_ (this),
    password_ (this)
  {
  }

  FileDriverSettings::
  FileDriverSettings (const FileDriverSettings& x,
                      ::xml_schema::flags f,
                      ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    host_ (x.host_, f, this),
    port_ (x.port_, f, this),
    username_ (x.username_, f, this),
    password_ (x.password_, f, this)
  {
  }

  FileDriverSettings::
  FileDriverSettings (const ::xercesc::DOMElement& e,
                      ::xml_schema::flags f,
                      ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    host_ (this),
    port_ (this),
    username_ (this),
    password_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void FileDriverSettings::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // host
      //
      if (n.name () == "host" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< host_type > r (
          host_traits::create (i, f, this));

        if (!this->host_)
        {
          this->host_.set (::std::move (r));
          continue;
        }
      }

      // port
      //
      if (n.name () == "port" && n.namespace_ () == "http://kolab.org")
      {
        if (!this->port_)
        {
          this->port_.set (port_traits::create (i, f, this));
          continue;
        }
      }

      // username
      //
      if (n.name () == "username" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< username_type > r (
          username_traits::create (i, f, this));

        if (!this->username_)
        {
          this->username_.set (::std::move (r));
          continue;
        }
      }

      // password
      //
      if (n.name () == "password" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< password_type > r (
          password_traits::create (i, f, this));

        if (!this->password_)
        {
          this->password_.set (::std::move (r));
          continue;
        }
      }

      break;
    }
  }

  FileDriverSettings* FileDriverSettings::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class FileDriverSettings (*this, f, c);
  }

  FileDriverSettings& FileDriverSettings::
  operator= (const FileDriverSettings& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->host_ = x.host_;
      this->port_ = x.port_;
      this->username_ = x.username_;
      this->password_ = x.password_;
    }

    return *this;
  }

  FileDriverSettings::
  ~FileDriverSettings ()
  {
  }

  // Configuration
  //

  Configuration::
  Configuration (const uid_type& uid,
                 const prodid_type& prodid,
                 const creation_date_type& creation_date,
                 const last_modification_date_type& last_modification_date,
                 const type_type& type)
  : ::KolabXSD::KolabBase (),
    uid_ (uid, this),
    prodid_ (prodid, this),
    creation_date_ (creation_date, this),
    last_modification_date_ (last_modification_date, this),
    type_ (type, this),
    language_ (this),
    e_ (this),
    categorycolor_ (this),
    name_ (this),
    snippet_ (this),
    relationType_ (this),
    color_ (this),
    iconName_ (this),
    priority_ (this),
    parent_ (this),
    member_ (this),
    driver_ (this),
    title_ (this),
    enabled_ (this),
    settings_ (this)
  {
  }

  Configuration::
  Configuration (const Configuration& x,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::KolabXSD::KolabBase (x, f, c),
    uid_ (x.uid_, f, this),
    prodid_ (x.prodid_, f, this),
    creation_date_ (x.creation_date_, f, this),
    last_modification_date_ (x.last_modification_date_, f, this),
    type_ (x.type_, f, this),
    language_ (x.language_, f, this),
    e_ (x.e_, f, this),
    categorycolor_ (x.categorycolor_, f, this),
    name_ (x.name_, f, this),
    snippet_ (x.snippet_, f, this),
    relationType_ (x.relationType_, f, this),
    color_ (x.color_, f, this),
    iconName_ (x.iconName_, f, this),
    priority_ (x.priority_, f, this),
    parent_ (x.parent_, f, this),
    member_ (x.member_, f, this),
    driver_ (x.driver_, f, this),
    title_ (x.title_, f, this),
    enabled_ (x.enabled_, f, this),
    settings_ (x.settings_, f, this)
  {
  }

  Configuration::
  Configuration (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::KolabXSD::KolabBase (e, f | ::xml_schema::flags::base, c),
    uid_ (this),
    prodid_ (this),
    creation_date_ (this),
    last_modification_date_ (this),
    type_ (this),
    language_ (this),
    e_ (this),
    categorycolor_ (this),
    name_ (this),
    snippet_ (this),
    relationType_ (this),
    color_ (this),
    iconName_ (this),
    priority_ (this),
    parent_ (this),
    member_ (this),
    driver_ (this),
    title_ (this),
    enabled_ (this),
    settings_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, true);
      this->parse (p, f);
    }
  }

  void Configuration::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::KolabXSD::KolabBase::parse (p, f);

    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // uid
      //
      if (n.name () == "uid" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< uid_type > r (
          uid_traits::create (i, f, this));

        if (!uid_.present ())
        {
          this->uid_.set (::std::move (r));
          continue;
        }
      }

      // prodid
      //
      if (n.name () == "prodid" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< prodid_type > r (
          prodid_traits::create (i, f, this));

        if (!prodid_.present ())
        {
          this->prodid_.set (::std::move (r));
          continue;
        }
      }

      // creation-date
      //
      if (n.name () == "creation-date" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< creation_date_type > r (
          creation_date_traits::create (i, f, this));

        if (!creation_date_.present ())
        {
          this->creation_date_.set (::std::move (r));
          continue;
        }
      }

      // last-modification-date
      //
      if (n.name () == "last-modification-date" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< last_modification_date_type > r (
          last_modification_date_traits::create (i, f, this));

        if (!last_modification_date_.present ())
        {
          this->last_modification_date_.set (::std::move (r));
          continue;
        }
      }

      // type
      //
      if (n.name () == "type" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< type_type > r (
          type_traits::create (i, f, this));

        if (!type_.present ())
        {
          this->type_.set (::std::move (r));
          continue;
        }
      }

      // language
      //
      if (n.name () == "language" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< language_type > r (
          language_traits::create (i, f, this));

        if (!this->language_)
        {
          this->language_.set (::std::move (r));
          continue;
        }
      }

      // e
      //
      if (n.name () == "e" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< e_type > r (
          e_traits::create (i, f, this));

        this->e_.push_back (::std::move (r));
        continue;
      }

      // categorycolor
      //
      if (n.name () == "categorycolor" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< categorycolor_type > r (
          categorycolor_traits::create (i, f, this));

        this->categorycolor_.push_back (::std::move (r));
        continue;
      }

      // name
      //
      if (n.name () == "name" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< name_type > r (
          name_traits::create (i, f, this));

        if (!this->name_)
        {
          this->name_.set (::std::move (r));
          continue;
        }
      }

      // snippet
      //
      if (n.name () == "snippet" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< snippet_type > r (
          snippet_traits::create (i, f, this));

        this->snippet_.push_back (::std::move (r));
        continue;
      }

      // relationType
      //
      if (n.name () == "relationType" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< relationType_type > r (
          relationType_traits::create (i, f, this));

        if (!this->relationType_)
        {
          this->relationType_.set (::std::move (r));
          continue;
        }
      }

      // color
      //
      if (n.name () == "color" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< color_type > r (
          color_traits::create (i, f, this));

        if (!this->color_)
        {
          this->color_.set (::std::move (r));
          continue;
        }
      }

      // iconName
      //
      if (n.name () == "iconName" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< iconName_type > r (
          iconName_traits::create (i, f, this));

        if (!this->iconName_)
        {
          this->iconName_.set (::std::move (r));
          continue;
        }
      }

      // priority
      //
      if (n.name () == "priority" && n.namespace_ () == "http://kolab.org")
      {
        if (!this->priority_)
        {
          this->priority_.set (priority_traits::create (i, f, this));
          continue;
        }
      }

      // parent
      //
      if (n.name () == "parent" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< parent_type > r (
          parent_traits::create (i, f, this));

        if (!this->parent_)
        {
          this->parent_.set (::std::move (r));
          continue;
        }
      }

      // member
      //
      if (n.name () == "member" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< member_type > r (
          member_traits::create (i, f, this));

        this->member_.push_back (::std::move (r));
        continue;
      }

      // driver
      //
      if (n.name () == "driver" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< driver_type > r (
          driver_traits::create (i, f, this));

        if (!this->driver_)
        {
          this->driver_.set (::std::move (r));
          continue;
        }
      }

      // title
      //
      if (n.name () == "title" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< title_type > r (
          title_traits::create (i, f, this));

        if (!this->title_)
        {
          this->title_.set (::std::move (r));
          continue;
        }
      }

      // enabled
      //
      if (n.name () == "enabled" && n.namespace_ () == "http://kolab.org")
      {
        if (!this->enabled_)
        {
          this->enabled_.set (enabled_traits::create (i, f, this));
          continue;
        }
      }

      // settings
      //
      if (n.name () == "settings" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< settings_type > r (
          settings_traits::create (i, f, this));

        if (!this->settings_)
        {
          this->settings_.set (::std::move (r));
          continue;
        }
      }

      break;
    }

    if (!uid_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "uid",
        "http://kolab.org");
    }

    if (!prodid_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "prodid",
        "http://kolab.org");
    }

    if (!creation_date_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "creation-date",
        "http://kolab.org");
    }

    if (!last_modification_date_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "last-modification-date",
        "http://kolab.org");
    }

    if (!type_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "type",
        "http://kolab.org");
    }
  }

  Configuration* Configuration::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class Configuration (*this, f, c);
  }

  Configuration& Configuration::
  operator= (const Configuration& x)
  {
    if (this != &x)
    {
      static_cast< ::KolabXSD::KolabBase& > (*this) = x;
      this->uid_ = x.uid_;
      this->prodid_ = x.prodid_;
      this->creation_date_ = x.creation_date_;
      this->last_modification_date_ = x.last_modification_date_;
      this->type_ = x.type_;
      this->language_ = x.language_;
      this->e_ = x.e_;
      this->categorycolor_ = x.categorycolor_;
      this->name_ = x.name_;
      this->snippet_ = x.snippet_;
      this->relationType_ = x.relationType_;
      this->color_ = x.color_;
      this->iconName_ = x.iconName_;
      this->priority_ = x.priority_;
      this->parent_ = x.parent_;
      this->member_ = x.member_;
      this->driver_ = x.driver_;
      this->title_ = x.title_;
      this->enabled_ = x.enabled_;
      this->settings_ = x.settings_;
    }

    return *this;
  }

  Configuration::
  ~Configuration ()
  {
  }

  // parameters
  //

  const parameters::encoding_type parameters::encoding_default_value_ (
    "BASE64");

  parameters::
  parameters (const fmttype_type& fmttype)
  : ::xml_schema::type (),
    fmttype_ (fmttype, this),
    x_label_ (this),
    encoding_ (this)
  {
  }

  parameters::
  parameters (const parameters& x,
              ::xml_schema::flags f,
              ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    fmttype_ (x.fmttype_, f, this),
    x_label_ (x.x_label_, f, this),
    encoding_ (x.encoding_, f, this)
  {
  }

  parameters::
  parameters (const ::xercesc::DOMElement& e,
              ::xml_schema::flags f,
              ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    fmttype_ (this),
    x_label_ (this),
    encoding_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void parameters::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // fmttype
      //
      if (n.name () == "fmttype" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< fmttype_type > r (
          fmttype_traits::create (i, f, this));

        if (!fmttype_.present ())
        {
          this->fmttype_.set (::std::move (r));
          continue;
        }
      }

      // x-label
      //
      if (n.name () == "x-label" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< x_label_type > r (
          x_label_traits::create (i, f, this));

        if (!this->x_label_)
        {
          this->x_label_.set (::std::move (r));
          continue;
        }
      }

      // encoding
      //
      if (n.name () == "encoding" && n.namespace_ () == "http://kolab.org")
      {
        ::std::unique_ptr< encoding_type > r (
          encoding_traits::create (i, f, this));

        if (!this->encoding_)
        {
          this->encoding_.set (::std::move (r));
          continue;
        }
      }

      break;
    }

    if (!fmttype_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "fmttype",
        "http://kolab.org");
    }
  }

  parameters* parameters::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class parameters (*this, f, c);
  }

  parameters& parameters::
  operator= (const parameters& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->fmttype_ = x.fmttype_;
      this->x_label_ = x.x_label_;
      this->encoding_ = x.encoding_;
    }

    return *this;
  }

  parameters::
  ~parameters ()
  {
  }
}

#include <istream>
#include <xsd/cxx/xml/sax/std-input-source.hxx>
#include <xsd/cxx/tree/error-handler.hxx>

namespace KolabXSD
{
  ::std::unique_ptr< ::KolabXSD::Note >
  note (const ::std::string& u,
        ::xml_schema::flags f,
        const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::tree::error_handler< char > h;

    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        u, h, p, f));

    h.throw_if_failed< ::xsd::cxx::tree::parsing< char > > ();

    return ::std::unique_ptr< ::KolabXSD::Note > (
      ::KolabXSD::note (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::KolabXSD::Note >
  note (const ::std::string& u,
        ::xml_schema::error_handler& h,
        ::xml_schema::flags f,
        const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        u, h, p, f));

    if (!d.get ())
      throw ::xsd::cxx::tree::parsing< char > ();

    return ::std::unique_ptr< ::KolabXSD::Note > (
      ::KolabXSD::note (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::KolabXSD::Note >
  note (const ::std::string& u,
        ::xercesc::DOMErrorHandler& h,
        ::xml_schema::flags f,
        const ::xml_schema::properties& p)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        u, h, p, f));

    if (!d.get ())
      throw ::xsd::cxx::tree::parsing< char > ();

    return ::std::unique_ptr< ::KolabXSD::Note > (
      ::KolabXSD::note (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::KolabXSD::Note >
  note (::std::istream& is,
        ::xml_schema::flags f,
        const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is);
    return ::KolabXSD::note (isrc, f, p);
  }

  ::std::unique_ptr< ::KolabXSD::Note >
  note (::std::istream& is,
        ::xml_schema::error_handler& h,
        ::xml_schema::flags f,
        const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is);
    return ::KolabXSD::note (isrc, h, f, p);
  }

  ::std::unique_ptr< ::KolabXSD::Note >
  note (::std::istream& is,
        ::xercesc::DOMErrorHandler& h,
        ::xml_schema::flags f,
        const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::sax::std_input_source isrc (is);
    return ::KolabXSD::note (isrc, h, f, p);
  }

  ::std::unique_ptr< ::KolabXSD::Note >
  note (::std::istream& is,
        const ::std::string& sid,
        ::xml_schema::flags f,
        const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is, sid);
    return ::KolabXSD::note (isrc, f, p);
  }

  ::std::unique_ptr< ::KolabXSD::Note >
  note (::std::istream& is,
        const ::std::string& sid,
        ::xml_schema::error_handler& h,
        ::xml_schema::flags f,
        const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is, sid);
    return ::KolabXSD::note (isrc, h, f, p);
  }

  ::std::unique_ptr< ::KolabXSD::Note >
  note (::std::istream& is,
        const ::std::string& sid,
        ::xercesc::DOMErrorHandler& h,
        ::xml_schema::flags f,
        const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::sax::std_input_source isrc (is, sid);
    return ::KolabXSD::note (isrc, h, f, p);
  }

  ::std::unique_ptr< ::KolabXSD::Note >
  note (::xercesc::InputSource& i,
        ::xml_schema::flags f,
        const ::xml_schema::properties& p)
  {
    ::xsd::cxx::tree::error_handler< char > h;

    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        i, h, p, f));

    h.throw_if_failed< ::xsd::cxx::tree::parsing< char > > ();

    return ::std::unique_ptr< ::KolabXSD::Note > (
      ::KolabXSD::note (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::KolabXSD::Note >
  note (::xercesc::InputSource& i,
        ::xml_schema::error_handler& h,
        ::xml_schema::flags f,
        const ::xml_schema::properties& p)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        i, h, p, f));

    if (!d.get ())
      throw ::xsd::cxx::tree::parsing< char > ();

    return ::std::unique_ptr< ::KolabXSD::Note > (
      ::KolabXSD::note (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::KolabXSD::Note >
  note (::xercesc::InputSource& i,
        ::xercesc::DOMErrorHandler& h,
        ::xml_schema::flags f,
        const ::xml_schema::properties& p)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        i, h, p, f));

    if (!d.get ())
      throw ::xsd::cxx::tree::parsing< char > ();

    return ::std::unique_ptr< ::KolabXSD::Note > (
      ::KolabXSD::note (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::KolabXSD::Note >
  note (const ::xercesc::DOMDocument& doc,
        ::xml_schema::flags f,
        const ::xml_schema::properties& p)
  {
    if (f & ::xml_schema::flags::keep_dom)
    {
      ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
        static_cast< ::xercesc::DOMDocument* > (doc.cloneNode (true)));

      return ::std::unique_ptr< ::KolabXSD::Note > (
        ::KolabXSD::note (
          std::move (d), f | ::xml_schema::flags::own_dom, p));
    }

    const ::xercesc::DOMElement& e (*doc.getDocumentElement ());
    const ::xsd::cxx::xml::qualified_name< char > n (
      ::xsd::cxx::xml::dom::name< char > (e));

    if (n.name () == "note" &&
        n.namespace_ () == "http://kolab.org")
    {
      ::std::unique_ptr< ::KolabXSD::Note > r (
        ::xsd::cxx::tree::traits< ::KolabXSD::Note, char >::create (
          e, f, 0));
      return r;
    }

    throw ::xsd::cxx::tree::unexpected_element < char > (
      n.name (),
      n.namespace_ (),
      "note",
      "http://kolab.org");
  }

  ::std::unique_ptr< ::KolabXSD::Note >
  note (::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d,
        ::xml_schema::flags f,
        const ::xml_schema::properties&)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > c (
      ((f & ::xml_schema::flags::keep_dom) &&
       !(f & ::xml_schema::flags::own_dom))
      ? static_cast< ::xercesc::DOMDocument* > (d->cloneNode (true))
      : 0);

    ::xercesc::DOMDocument& doc (c.get () ? *c : *d);
    const ::xercesc::DOMElement& e (*doc.getDocumentElement ());

    const ::xsd::cxx::xml::qualified_name< char > n (
      ::xsd::cxx::xml::dom::name< char > (e));

    if (f & ::xml_schema::flags::keep_dom)
      doc.setUserData (::xml_schema::dom::tree_node_key,
                       (c.get () ? &c : &d),
                       0);

    if (n.name () == "note" &&
        n.namespace_ () == "http://kolab.org")
    {
      ::std::unique_ptr< ::KolabXSD::Note > r (
        ::xsd::cxx::tree::traits< ::KolabXSD::Note, char >::create (
          e, f, 0));
      return r;
    }

    throw ::xsd::cxx::tree::unexpected_element < char > (
      n.name (),
      n.namespace_ (),
      "note",
      "http://kolab.org");
  }

  ::std::unique_ptr< ::KolabXSD::File >
  file (const ::std::string& u,
        ::xml_schema::flags f,
        const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::tree::error_handler< char > h;

    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        u, h, p, f));

    h.throw_if_failed< ::xsd::cxx::tree::parsing< char > > ();

    return ::std::unique_ptr< ::KolabXSD::File > (
      ::KolabXSD::file (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::KolabXSD::File >
  file (const ::std::string& u,
        ::xml_schema::error_handler& h,
        ::xml_schema::flags f,
        const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        u, h, p, f));

    if (!d.get ())
      throw ::xsd::cxx::tree::parsing< char > ();

    return ::std::unique_ptr< ::KolabXSD::File > (
      ::KolabXSD::file (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::KolabXSD::File >
  file (const ::std::string& u,
        ::xercesc::DOMErrorHandler& h,
        ::xml_schema::flags f,
        const ::xml_schema::properties& p)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        u, h, p, f));

    if (!d.get ())
      throw ::xsd::cxx::tree::parsing< char > ();

    return ::std::unique_ptr< ::KolabXSD::File > (
      ::KolabXSD::file (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::KolabXSD::File >
  file (::std::istream& is,
        ::xml_schema::flags f,
        const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is);
    return ::KolabXSD::file (isrc, f, p);
  }

  ::std::unique_ptr< ::KolabXSD::File >
  file (::std::istream& is,
        ::xml_schema::error_handler& h,
        ::xml_schema::flags f,
        const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is);
    return ::KolabXSD::file (isrc, h, f, p);
  }

  ::std::unique_ptr< ::KolabXSD::File >
  file (::std::istream& is,
        ::xercesc::DOMErrorHandler& h,
        ::xml_schema::flags f,
        const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::sax::std_input_source isrc (is);
    return ::KolabXSD::file (isrc, h, f, p);
  }

  ::std::unique_ptr< ::KolabXSD::File >
  file (::std::istream& is,
        const ::std::string& sid,
        ::xml_schema::flags f,
        const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is, sid);
    return ::KolabXSD::file (isrc, f, p);
  }

  ::std::unique_ptr< ::KolabXSD::File >
  file (::std::istream& is,
        const ::std::string& sid,
        ::xml_schema::error_handler& h,
        ::xml_schema::flags f,
        const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is, sid);
    return ::KolabXSD::file (isrc, h, f, p);
  }

  ::std::unique_ptr< ::KolabXSD::File >
  file (::std::istream& is,
        const ::std::string& sid,
        ::xercesc::DOMErrorHandler& h,
        ::xml_schema::flags f,
        const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::sax::std_input_source isrc (is, sid);
    return ::KolabXSD::file (isrc, h, f, p);
  }

  ::std::unique_ptr< ::KolabXSD::File >
  file (::xercesc::InputSource& i,
        ::xml_schema::flags f,
        const ::xml_schema::properties& p)
  {
    ::xsd::cxx::tree::error_handler< char > h;

    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        i, h, p, f));

    h.throw_if_failed< ::xsd::cxx::tree::parsing< char > > ();

    return ::std::unique_ptr< ::KolabXSD::File > (
      ::KolabXSD::file (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::KolabXSD::File >
  file (::xercesc::InputSource& i,
        ::xml_schema::error_handler& h,
        ::xml_schema::flags f,
        const ::xml_schema::properties& p)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        i, h, p, f));

    if (!d.get ())
      throw ::xsd::cxx::tree::parsing< char > ();

    return ::std::unique_ptr< ::KolabXSD::File > (
      ::KolabXSD::file (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::KolabXSD::File >
  file (::xercesc::InputSource& i,
        ::xercesc::DOMErrorHandler& h,
        ::xml_schema::flags f,
        const ::xml_schema::properties& p)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        i, h, p, f));

    if (!d.get ())
      throw ::xsd::cxx::tree::parsing< char > ();

    return ::std::unique_ptr< ::KolabXSD::File > (
      ::KolabXSD::file (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::KolabXSD::File >
  file (const ::xercesc::DOMDocument& doc,
        ::xml_schema::flags f,
        const ::xml_schema::properties& p)
  {
    if (f & ::xml_schema::flags::keep_dom)
    {
      ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
        static_cast< ::xercesc::DOMDocument* > (doc.cloneNode (true)));

      return ::std::unique_ptr< ::KolabXSD::File > (
        ::KolabXSD::file (
          std::move (d), f | ::xml_schema::flags::own_dom, p));
    }

    const ::xercesc::DOMElement& e (*doc.getDocumentElement ());
    const ::xsd::cxx::xml::qualified_name< char > n (
      ::xsd::cxx::xml::dom::name< char > (e));

    if (n.name () == "file" &&
        n.namespace_ () == "http://kolab.org")
    {
      ::std::unique_ptr< ::KolabXSD::File > r (
        ::xsd::cxx::tree::traits< ::KolabXSD::File, char >::create (
          e, f, 0));
      return r;
    }

    throw ::xsd::cxx::tree::unexpected_element < char > (
      n.name (),
      n.namespace_ (),
      "file",
      "http://kolab.org");
  }

  ::std::unique_ptr< ::KolabXSD::File >
  file (::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d,
        ::xml_schema::flags f,
        const ::xml_schema::properties&)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > c (
      ((f & ::xml_schema::flags::keep_dom) &&
       !(f & ::xml_schema::flags::own_dom))
      ? static_cast< ::xercesc::DOMDocument* > (d->cloneNode (true))
      : 0);

    ::xercesc::DOMDocument& doc (c.get () ? *c : *d);
    const ::xercesc::DOMElement& e (*doc.getDocumentElement ());

    const ::xsd::cxx::xml::qualified_name< char > n (
      ::xsd::cxx::xml::dom::name< char > (e));

    if (f & ::xml_schema::flags::keep_dom)
      doc.setUserData (::xml_schema::dom::tree_node_key,
                       (c.get () ? &c : &d),
                       0);

    if (n.name () == "file" &&
        n.namespace_ () == "http://kolab.org")
    {
      ::std::unique_ptr< ::KolabXSD::File > r (
        ::xsd::cxx::tree::traits< ::KolabXSD::File, char >::create (
          e, f, 0));
      return r;
    }

    throw ::xsd::cxx::tree::unexpected_element < char > (
      n.name (),
      n.namespace_ (),
      "file",
      "http://kolab.org");
  }

  ::std::unique_ptr< ::KolabXSD::Configuration >
  configuration (const ::std::string& u,
                 ::xml_schema::flags f,
                 const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::tree::error_handler< char > h;

    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        u, h, p, f));

    h.throw_if_failed< ::xsd::cxx::tree::parsing< char > > ();

    return ::std::unique_ptr< ::KolabXSD::Configuration > (
      ::KolabXSD::configuration (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::KolabXSD::Configuration >
  configuration (const ::std::string& u,
                 ::xml_schema::error_handler& h,
                 ::xml_schema::flags f,
                 const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        u, h, p, f));

    if (!d.get ())
      throw ::xsd::cxx::tree::parsing< char > ();

    return ::std::unique_ptr< ::KolabXSD::Configuration > (
      ::KolabXSD::configuration (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::KolabXSD::Configuration >
  configuration (const ::std::string& u,
                 ::xercesc::DOMErrorHandler& h,
                 ::xml_schema::flags f,
                 const ::xml_schema::properties& p)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        u, h, p, f));

    if (!d.get ())
      throw ::xsd::cxx::tree::parsing< char > ();

    return ::std::unique_ptr< ::KolabXSD::Configuration > (
      ::KolabXSD::configuration (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::KolabXSD::Configuration >
  configuration (::std::istream& is,
                 ::xml_schema::flags f,
                 const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is);
    return ::KolabXSD::configuration (isrc, f, p);
  }

  ::std::unique_ptr< ::KolabXSD::Configuration >
  configuration (::std::istream& is,
                 ::xml_schema::error_handler& h,
                 ::xml_schema::flags f,
                 const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is);
    return ::KolabXSD::configuration (isrc, h, f, p);
  }

  ::std::unique_ptr< ::KolabXSD::Configuration >
  configuration (::std::istream& is,
                 ::xercesc::DOMErrorHandler& h,
                 ::xml_schema::flags f,
                 const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::sax::std_input_source isrc (is);
    return ::KolabXSD::configuration (isrc, h, f, p);
  }

  ::std::unique_ptr< ::KolabXSD::Configuration >
  configuration (::std::istream& is,
                 const ::std::string& sid,
                 ::xml_schema::flags f,
                 const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is, sid);
    return ::KolabXSD::configuration (isrc, f, p);
  }

  ::std::unique_ptr< ::KolabXSD::Configuration >
  configuration (::std::istream& is,
                 const ::std::string& sid,
                 ::xml_schema::error_handler& h,
                 ::xml_schema::flags f,
                 const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is, sid);
    return ::KolabXSD::configuration (isrc, h, f, p);
  }

  ::std::unique_ptr< ::KolabXSD::Configuration >
  configuration (::std::istream& is,
                 const ::std::string& sid,
                 ::xercesc::DOMErrorHandler& h,
                 ::xml_schema::flags f,
                 const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::sax::std_input_source isrc (is, sid);
    return ::KolabXSD::configuration (isrc, h, f, p);
  }

  ::std::unique_ptr< ::KolabXSD::Configuration >
  configuration (::xercesc::InputSource& i,
                 ::xml_schema::flags f,
                 const ::xml_schema::properties& p)
  {
    ::xsd::cxx::tree::error_handler< char > h;

    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        i, h, p, f));

    h.throw_if_failed< ::xsd::cxx::tree::parsing< char > > ();

    return ::std::unique_ptr< ::KolabXSD::Configuration > (
      ::KolabXSD::configuration (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::KolabXSD::Configuration >
  configuration (::xercesc::InputSource& i,
                 ::xml_schema::error_handler& h,
                 ::xml_schema::flags f,
                 const ::xml_schema::properties& p)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        i, h, p, f));

    if (!d.get ())
      throw ::xsd::cxx::tree::parsing< char > ();

    return ::std::unique_ptr< ::KolabXSD::Configuration > (
      ::KolabXSD::configuration (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::KolabXSD::Configuration >
  configuration (::xercesc::InputSource& i,
                 ::xercesc::DOMErrorHandler& h,
                 ::xml_schema::flags f,
                 const ::xml_schema::properties& p)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        i, h, p, f));

    if (!d.get ())
      throw ::xsd::cxx::tree::parsing< char > ();

    return ::std::unique_ptr< ::KolabXSD::Configuration > (
      ::KolabXSD::configuration (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::KolabXSD::Configuration >
  configuration (const ::xercesc::DOMDocument& doc,
                 ::xml_schema::flags f,
                 const ::xml_schema::properties& p)
  {
    if (f & ::xml_schema::flags::keep_dom)
    {
      ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
        static_cast< ::xercesc::DOMDocument* > (doc.cloneNode (true)));

      return ::std::unique_ptr< ::KolabXSD::Configuration > (
        ::KolabXSD::configuration (
          std::move (d), f | ::xml_schema::flags::own_dom, p));
    }

    const ::xercesc::DOMElement& e (*doc.getDocumentElement ());
    const ::xsd::cxx::xml::qualified_name< char > n (
      ::xsd::cxx::xml::dom::name< char > (e));

    if (n.name () == "configuration" &&
        n.namespace_ () == "http://kolab.org")
    {
      ::std::unique_ptr< ::KolabXSD::Configuration > r (
        ::xsd::cxx::tree::traits< ::KolabXSD::Configuration, char >::create (
          e, f, 0));
      return r;
    }

    throw ::xsd::cxx::tree::unexpected_element < char > (
      n.name (),
      n.namespace_ (),
      "configuration",
      "http://kolab.org");
  }

  ::std::unique_ptr< ::KolabXSD::Configuration >
  configuration (::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d,
                 ::xml_schema::flags f,
                 const ::xml_schema::properties&)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > c (
      ((f & ::xml_schema::flags::keep_dom) &&
       !(f & ::xml_schema::flags::own_dom))
      ? static_cast< ::xercesc::DOMDocument* > (d->cloneNode (true))
      : 0);

    ::xercesc::DOMDocument& doc (c.get () ? *c : *d);
    const ::xercesc::DOMElement& e (*doc.getDocumentElement ());

    const ::xsd::cxx::xml::qualified_name< char > n (
      ::xsd::cxx::xml::dom::name< char > (e));

    if (f & ::xml_schema::flags::keep_dom)
      doc.setUserData (::xml_schema::dom::tree_node_key,
                       (c.get () ? &c : &d),
                       0);

    if (n.name () == "configuration" &&
        n.namespace_ () == "http://kolab.org")
    {
      ::std::unique_ptr< ::KolabXSD::Configuration > r (
        ::xsd::cxx::tree::traits< ::KolabXSD::Configuration, char >::create (
          e, f, 0));
      return r;
    }

    throw ::xsd::cxx::tree::unexpected_element < char > (
      n.name (),
      n.namespace_ (),
      "configuration",
      "http://kolab.org");
  }
}

#include <ostream>
#include <xsd/cxx/tree/error-handler.hxx>
#include <xsd/cxx/xml/dom/serialization-source.hxx>

#include <xsd/cxx/tree/type-serializer-map.hxx>

namespace _xsd
{
  static
  const ::xsd::cxx::tree::type_serializer_plate< 0, char >
  type_serializer_plate_init;
}

namespace KolabXSD
{
  void
  operator<< (::xercesc::DOMElement& e, const KolabBase& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // version
    //
    {
      ::xercesc::DOMAttr& a (
        ::xsd::cxx::xml::dom::create_attribute (
          "version",
          e));

      a << i.version ();
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const attachmentPropType& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // parameters
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "parameters",
          "http://kolab.org",
          e));

      s << i.parameters ();
    }

    // uri
    //
    if (i.uri ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "uri",
          "http://kolab.org",
          e));

      s << *i.uri ();
    }

    // binary
    //
    if (i.binary ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "binary",
          "http://kolab.org",
          e));

      s << *i.binary ();
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const classifcationPropType& i)
  {
    e << static_cast< const ::xml_schema::token& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr& a, const classifcationPropType& i)
  {
    a << static_cast< const ::xml_schema::token& > (i);
  }

  void
  operator<< (::xml_schema::list_stream& l,
              const classifcationPropType& i)
  {
    l << static_cast< const ::xml_schema::token& > (i);
  }

  void
  operator<< (::xercesc::DOMElement& e, const CustomType& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // identifier
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "identifier",
          "http://kolab.org",
          e));

      s << i.identifier ();
    }

    // value
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "value",
          "http://kolab.org",
          e));

      s << i.value ();
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const Note& i)
  {
    e << static_cast< const ::KolabXSD::KolabBase& > (i);

    // uid
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "uid",
          "http://kolab.org",
          e));

      s << i.uid ();
    }

    // prodid
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "prodid",
          "http://kolab.org",
          e));

      s << i.prodid ();
    }

    // creation-date
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "creation-date",
          "http://kolab.org",
          e));

      s << i.creation_date ();
    }

    // last-modification-date
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "last-modification-date",
          "http://kolab.org",
          e));

      s << i.last_modification_date ();
    }

    // categories
    //
    for (Note::categories_const_iterator
         b (i.categories ().begin ()), n (i.categories ().end ());
         b != n; ++b)
    {
      const Note::categories_type& x (*b);

      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "categories",
          "http://kolab.org",
          e));

      s << x;
    }

    // classification
    //
    if (i.classification ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "classification",
          "http://kolab.org",
          e));

      s << *i.classification ();
    }

    // attachment
    //
    for (Note::attachment_const_iterator
         b (i.attachment ().begin ()), n (i.attachment ().end ());
         b != n; ++b)
    {
      const Note::attachment_type& x (*b);

      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "attachment",
          "http://kolab.org",
          e));

      s << x;
    }

    // summary
    //
    if (i.summary ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "summary",
          "http://kolab.org",
          e));

      s << *i.summary ();
    }

    // description
    //
    if (i.description ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "description",
          "http://kolab.org",
          e));

      s << *i.description ();
    }

    // color
    //
    if (i.color ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "color",
          "http://kolab.org",
          e));

      s << *i.color ();
    }

    // x-custom
    //
    for (Note::x_custom_const_iterator
         b (i.x_custom ().begin ()), n (i.x_custom ().end ());
         b != n; ++b)
    {
      const Note::x_custom_type& x (*b);

      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "x-custom",
          "http://kolab.org",
          e));

      s << x;
    }
  }

  void
  note (::std::ostream& o,
        const ::KolabXSD::Note& s,
        const ::xml_schema::namespace_infomap& m,
        const ::std::string& e,
        ::xml_schema::flags f)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0);

    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::KolabXSD::note (s, m, f));

    ::xsd::cxx::tree::error_handler< char > h;

    ::xsd::cxx::xml::dom::ostream_format_target t (o);
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      h.throw_if_failed< ::xsd::cxx::tree::serialization< char > > ();
    }
  }

  void
  note (::std::ostream& o,
        const ::KolabXSD::Note& s,
        ::xml_schema::error_handler& h,
        const ::xml_schema::namespace_infomap& m,
        const ::std::string& e,
        ::xml_schema::flags f)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0);

    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::KolabXSD::note (s, m, f));
    ::xsd::cxx::xml::dom::ostream_format_target t (o);
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  note (::std::ostream& o,
        const ::KolabXSD::Note& s,
        ::xercesc::DOMErrorHandler& h,
        const ::xml_schema::namespace_infomap& m,
        const ::std::string& e,
        ::xml_schema::flags f)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::KolabXSD::note (s, m, f));
    ::xsd::cxx::xml::dom::ostream_format_target t (o);
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  note (::xercesc::XMLFormatTarget& t,
        const ::KolabXSD::Note& s,
        const ::xml_schema::namespace_infomap& m,
        const ::std::string& e,
        ::xml_schema::flags f)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::KolabXSD::note (s, m, f));

    ::xsd::cxx::tree::error_handler< char > h;

    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      h.throw_if_failed< ::xsd::cxx::tree::serialization< char > > ();
    }
  }

  void
  note (::xercesc::XMLFormatTarget& t,
        const ::KolabXSD::Note& s,
        ::xml_schema::error_handler& h,
        const ::xml_schema::namespace_infomap& m,
        const ::std::string& e,
        ::xml_schema::flags f)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::KolabXSD::note (s, m, f));
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  note (::xercesc::XMLFormatTarget& t,
        const ::KolabXSD::Note& s,
        ::xercesc::DOMErrorHandler& h,
        const ::xml_schema::namespace_infomap& m,
        const ::std::string& e,
        ::xml_schema::flags f)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::KolabXSD::note (s, m, f));
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  note (::xercesc::DOMDocument& d,
        const ::KolabXSD::Note& s,
        ::xml_schema::flags)
  {
    ::xercesc::DOMElement& e (*d.getDocumentElement ());
    const ::xsd::cxx::xml::qualified_name< char > n (
      ::xsd::cxx::xml::dom::name< char > (e));

    if (n.name () == "note" &&
        n.namespace_ () == "http://kolab.org")
    {
      e << s;
    }
    else
    {
      throw ::xsd::cxx::tree::unexpected_element < char > (
        n.name (),
        n.namespace_ (),
        "note",
        "http://kolab.org");
    }
  }

  ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument >
  note (const ::KolabXSD::Note& s,
        const ::xml_schema::namespace_infomap& m,
        ::xml_schema::flags f)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::serialize< char > (
        "note",
        "http://kolab.org",
        m, f));

    ::KolabXSD::note (*d, s, f);
    return d;
  }

  void
  operator<< (::xercesc::DOMElement& e, const File& i)
  {
    e << static_cast< const ::KolabXSD::KolabBase& > (i);

    // uid
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "uid",
          "http://kolab.org",
          e));

      s << i.uid ();
    }

    // prodid
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "prodid",
          "http://kolab.org",
          e));

      s << i.prodid ();
    }

    // creation-date
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "creation-date",
          "http://kolab.org",
          e));

      s << i.creation_date ();
    }

    // last-modification-date
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "last-modification-date",
          "http://kolab.org",
          e));

      s << i.last_modification_date ();
    }

    // categories
    //
    for (File::categories_const_iterator
         b (i.categories ().begin ()), n (i.categories ().end ());
         b != n; ++b)
    {
      const File::categories_type& x (*b);

      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "categories",
          "http://kolab.org",
          e));

      s << x;
    }

    // classification
    //
    if (i.classification ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "classification",
          "http://kolab.org",
          e));

      s << *i.classification ();
    }

    // file
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "file",
          "http://kolab.org",
          e));

      s << i.file ();
    }

    // note
    //
    if (i.note ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "note",
          "http://kolab.org",
          e));

      s << *i.note ();
    }

    // x-custom
    //
    for (File::x_custom_const_iterator
         b (i.x_custom ().begin ()), n (i.x_custom ().end ());
         b != n; ++b)
    {
      const File::x_custom_type& x (*b);

      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "x-custom",
          "http://kolab.org",
          e));

      s << x;
    }
  }

  void
  file (::std::ostream& o,
        const ::KolabXSD::File& s,
        const ::xml_schema::namespace_infomap& m,
        const ::std::string& e,
        ::xml_schema::flags f)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0);

    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::KolabXSD::file (s, m, f));

    ::xsd::cxx::tree::error_handler< char > h;

    ::xsd::cxx::xml::dom::ostream_format_target t (o);
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      h.throw_if_failed< ::xsd::cxx::tree::serialization< char > > ();
    }
  }

  void
  file (::std::ostream& o,
        const ::KolabXSD::File& s,
        ::xml_schema::error_handler& h,
        const ::xml_schema::namespace_infomap& m,
        const ::std::string& e,
        ::xml_schema::flags f)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0);

    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::KolabXSD::file (s, m, f));
    ::xsd::cxx::xml::dom::ostream_format_target t (o);
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  file (::std::ostream& o,
        const ::KolabXSD::File& s,
        ::xercesc::DOMErrorHandler& h,
        const ::xml_schema::namespace_infomap& m,
        const ::std::string& e,
        ::xml_schema::flags f)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::KolabXSD::file (s, m, f));
    ::xsd::cxx::xml::dom::ostream_format_target t (o);
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  file (::xercesc::XMLFormatTarget& t,
        const ::KolabXSD::File& s,
        const ::xml_schema::namespace_infomap& m,
        const ::std::string& e,
        ::xml_schema::flags f)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::KolabXSD::file (s, m, f));

    ::xsd::cxx::tree::error_handler< char > h;

    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      h.throw_if_failed< ::xsd::cxx::tree::serialization< char > > ();
    }
  }

  void
  file (::xercesc::XMLFormatTarget& t,
        const ::KolabXSD::File& s,
        ::xml_schema::error_handler& h,
        const ::xml_schema::namespace_infomap& m,
        const ::std::string& e,
        ::xml_schema::flags f)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::KolabXSD::file (s, m, f));
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  file (::xercesc::XMLFormatTarget& t,
        const ::KolabXSD::File& s,
        ::xercesc::DOMErrorHandler& h,
        const ::xml_schema::namespace_infomap& m,
        const ::std::string& e,
        ::xml_schema::flags f)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::KolabXSD::file (s, m, f));
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  file (::xercesc::DOMDocument& d,
        const ::KolabXSD::File& s,
        ::xml_schema::flags)
  {
    ::xercesc::DOMElement& e (*d.getDocumentElement ());
    const ::xsd::cxx::xml::qualified_name< char > n (
      ::xsd::cxx::xml::dom::name< char > (e));

    if (n.name () == "file" &&
        n.namespace_ () == "http://kolab.org")
    {
      e << s;
    }
    else
    {
      throw ::xsd::cxx::tree::unexpected_element < char > (
        n.name (),
        n.namespace_ (),
        "file",
        "http://kolab.org");
    }
  }

  ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument >
  file (const ::KolabXSD::File& s,
        const ::xml_schema::namespace_infomap& m,
        ::xml_schema::flags f)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::serialize< char > (
        "file",
        "http://kolab.org",
        m, f));

    ::KolabXSD::file (*d, s, f);
    return d;
  }

  void
  operator<< (::xercesc::DOMElement& e, const ConfigurationType& i)
  {
    e << static_cast< const ::xml_schema::token& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr& a, const ConfigurationType& i)
  {
    a << static_cast< const ::xml_schema::token& > (i);
  }

  void
  operator<< (::xml_schema::list_stream& l,
              const ConfigurationType& i)
  {
    l << static_cast< const ::xml_schema::token& > (i);
  }

  void
  operator<< (::xercesc::DOMElement& e, const CategoryColor& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // category
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "category",
          "http://kolab.org",
          e));

      s << i.category ();
    }

    // categorycolor
    //
    for (CategoryColor::categorycolor_const_iterator
         b (i.categorycolor ().begin ()), n (i.categorycolor ().end ());
         b != n; ++b)
    {
      const CategoryColor::categorycolor_type& x (*b);

      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "categorycolor",
          "http://kolab.org",
          e));

      s << x;
    }

    // color
    //
    if (i.color ())
    {
      ::xercesc::DOMAttr& a (
        ::xsd::cxx::xml::dom::create_attribute (
          "color",
          e));

      a << *i.color ();
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const textformatType& i)
  {
    e << static_cast< const ::xml_schema::token& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr& a, const textformatType& i)
  {
    a << static_cast< const ::xml_schema::token& > (i);
  }

  void
  operator<< (::xml_schema::list_stream& l,
              const textformatType& i)
  {
    l << static_cast< const ::xml_schema::token& > (i);
  }

  void
  operator<< (::xercesc::DOMElement& e, const Snippet& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // name
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "name",
          "http://kolab.org",
          e));

      s << i.name ();
    }

    // text
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "text",
          "http://kolab.org",
          e));

      s << i.text ();
    }

    // textformat
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "textformat",
          "http://kolab.org",
          e));

      s << i.textformat ();
    }

    // shortcut
    //
    if (i.shortcut ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "shortcut",
          "http://kolab.org",
          e));

      s << *i.shortcut ();
    }

    // color
    //
    if (i.color ())
    {
      ::xercesc::DOMAttr& a (
        ::xsd::cxx::xml::dom::create_attribute (
          "color",
          e));

      a << *i.color ();
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const FileDriverSettings& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // host
    //
    if (i.host ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "host",
          "http://kolab.org",
          e));

      s << *i.host ();
    }

    // port
    //
    if (i.port ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "port",
          "http://kolab.org",
          e));

      s << *i.port ();
    }

    // username
    //
    if (i.username ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "username",
          "http://kolab.org",
          e));

      s << *i.username ();
    }

    // password
    //
    if (i.password ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "password",
          "http://kolab.org",
          e));

      s << *i.password ();
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const Configuration& i)
  {
    e << static_cast< const ::KolabXSD::KolabBase& > (i);

    // uid
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "uid",
          "http://kolab.org",
          e));

      s << i.uid ();
    }

    // prodid
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "prodid",
          "http://kolab.org",
          e));

      s << i.prodid ();
    }

    // creation-date
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "creation-date",
          "http://kolab.org",
          e));

      s << i.creation_date ();
    }

    // last-modification-date
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "last-modification-date",
          "http://kolab.org",
          e));

      s << i.last_modification_date ();
    }

    // type
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "type",
          "http://kolab.org",
          e));

      s << i.type ();
    }

    // language
    //
    if (i.language ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "language",
          "http://kolab.org",
          e));

      s << *i.language ();
    }

    // e
    //
    for (Configuration::e_const_iterator
         b (i.e ().begin ()), n (i.e ().end ());
         b != n; ++b)
    {
      const Configuration::e_type& x (*b);

      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "e",
          "http://kolab.org",
          e));

      s << x;
    }

    // categorycolor
    //
    for (Configuration::categorycolor_const_iterator
         b (i.categorycolor ().begin ()), n (i.categorycolor ().end ());
         b != n; ++b)
    {
      const Configuration::categorycolor_type& x (*b);

      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "categorycolor",
          "http://kolab.org",
          e));

      s << x;
    }

    // name
    //
    if (i.name ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "name",
          "http://kolab.org",
          e));

      s << *i.name ();
    }

    // snippet
    //
    for (Configuration::snippet_const_iterator
         b (i.snippet ().begin ()), n (i.snippet ().end ());
         b != n; ++b)
    {
      const Configuration::snippet_type& x (*b);

      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "snippet",
          "http://kolab.org",
          e));

      s << x;
    }

    // relationType
    //
    if (i.relationType ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "relationType",
          "http://kolab.org",
          e));

      s << *i.relationType ();
    }

    // color
    //
    if (i.color ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "color",
          "http://kolab.org",
          e));

      s << *i.color ();
    }

    // iconName
    //
    if (i.iconName ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "iconName",
          "http://kolab.org",
          e));

      s << *i.iconName ();
    }

    // priority
    //
    if (i.priority ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "priority",
          "http://kolab.org",
          e));

      s << *i.priority ();
    }

    // parent
    //
    if (i.parent ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "parent",
          "http://kolab.org",
          e));

      s << *i.parent ();
    }

    // member
    //
    for (Configuration::member_const_iterator
         b (i.member ().begin ()), n (i.member ().end ());
         b != n; ++b)
    {
      const Configuration::member_type& x (*b);

      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "member",
          "http://kolab.org",
          e));

      s << x;
    }

    // driver
    //
    if (i.driver ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "driver",
          "http://kolab.org",
          e));

      s << *i.driver ();
    }

    // title
    //
    if (i.title ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "title",
          "http://kolab.org",
          e));

      s << *i.title ();
    }

    // enabled
    //
    if (i.enabled ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "enabled",
          "http://kolab.org",
          e));

      s << *i.enabled ();
    }

    // settings
    //
    if (i.settings ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "settings",
          "http://kolab.org",
          e));

      s << *i.settings ();
    }
  }

  void
  configuration (::std::ostream& o,
                 const ::KolabXSD::Configuration& s,
                 const ::xml_schema::namespace_infomap& m,
                 const ::std::string& e,
                 ::xml_schema::flags f)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0);

    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::KolabXSD::configuration (s, m, f));

    ::xsd::cxx::tree::error_handler< char > h;

    ::xsd::cxx::xml::dom::ostream_format_target t (o);
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      h.throw_if_failed< ::xsd::cxx::tree::serialization< char > > ();
    }
  }

  void
  configuration (::std::ostream& o,
                 const ::KolabXSD::Configuration& s,
                 ::xml_schema::error_handler& h,
                 const ::xml_schema::namespace_infomap& m,
                 const ::std::string& e,
                 ::xml_schema::flags f)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0);

    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::KolabXSD::configuration (s, m, f));
    ::xsd::cxx::xml::dom::ostream_format_target t (o);
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  configuration (::std::ostream& o,
                 const ::KolabXSD::Configuration& s,
                 ::xercesc::DOMErrorHandler& h,
                 const ::xml_schema::namespace_infomap& m,
                 const ::std::string& e,
                 ::xml_schema::flags f)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::KolabXSD::configuration (s, m, f));
    ::xsd::cxx::xml::dom::ostream_format_target t (o);
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  configuration (::xercesc::XMLFormatTarget& t,
                 const ::KolabXSD::Configuration& s,
                 const ::xml_schema::namespace_infomap& m,
                 const ::std::string& e,
                 ::xml_schema::flags f)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::KolabXSD::configuration (s, m, f));

    ::xsd::cxx::tree::error_handler< char > h;

    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      h.throw_if_failed< ::xsd::cxx::tree::serialization< char > > ();
    }
  }

  void
  configuration (::xercesc::XMLFormatTarget& t,
                 const ::KolabXSD::Configuration& s,
                 ::xml_schema::error_handler& h,
                 const ::xml_schema::namespace_infomap& m,
                 const ::std::string& e,
                 ::xml_schema::flags f)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::KolabXSD::configuration (s, m, f));
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  configuration (::xercesc::XMLFormatTarget& t,
                 const ::KolabXSD::Configuration& s,
                 ::xercesc::DOMErrorHandler& h,
                 const ::xml_schema::namespace_infomap& m,
                 const ::std::string& e,
                 ::xml_schema::flags f)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::KolabXSD::configuration (s, m, f));
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  configuration (::xercesc::DOMDocument& d,
                 const ::KolabXSD::Configuration& s,
                 ::xml_schema::flags)
  {
    ::xercesc::DOMElement& e (*d.getDocumentElement ());
    const ::xsd::cxx::xml::qualified_name< char > n (
      ::xsd::cxx::xml::dom::name< char > (e));

    if (n.name () == "configuration" &&
        n.namespace_ () == "http://kolab.org")
    {
      e << s;
    }
    else
    {
      throw ::xsd::cxx::tree::unexpected_element < char > (
        n.name (),
        n.namespace_ (),
        "configuration",
        "http://kolab.org");
    }
  }

  ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument >
  configuration (const ::KolabXSD::Configuration& s,
                 const ::xml_schema::namespace_infomap& m,
                 ::xml_schema::flags f)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::serialize< char > (
        "configuration",
        "http://kolab.org",
        m, f));

    ::KolabXSD::configuration (*d, s, f);
    return d;
  }

  void
  operator<< (::xercesc::DOMElement& e, const parameters& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // fmttype
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "fmttype",
          "http://kolab.org",
          e));

      s << i.fmttype ();
    }

    // x-label
    //
    if (i.x_label ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "x-label",
          "http://kolab.org",
          e));

      s << *i.x_label ();
    }

    // encoding
    //
    if (i.encoding ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "encoding",
          "http://kolab.org",
          e));

      s << *i.encoding ();
    }
  }
}

#include <xsd/cxx/post.hxx>

// Begin epilogue.
//
//
// End epilogue.

