/* Utils.c generated by valac 0.56.18, the Vala compiler
 * generated from Utils.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gstdio.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <granite.h>
#include <gio/gio.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <gtksourceview/gtksource.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_UTILS (utils_get_type ())
#define UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UTILS, Utils))
#define UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UTILS, UtilsClass))
#define IS_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UTILS))
#define IS_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UTILS))
#define UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UTILS, UtilsClass))

typedef struct _Utils Utils;
typedef struct _UtilsClass UtilsClass;
typedef struct _UtilsPrivate UtilsPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _pango_layout_line_unref0(var) ((var == NULL) ? NULL : (var = (pango_layout_line_unref (var), NULL)))
typedef struct _ParamSpecUtils ParamSpecUtils;

struct _Utils {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UtilsPrivate * priv;
};

struct _UtilsClass {
	GTypeClass parent_class;
	void (*finalize) (Utils *self);
};

struct _ParamSpecUtils {
	GParamSpec parent_instance;
};

static gpointer utils_parent_class = NULL;
VALA_EXTERN GSettings* minder_settings;

VALA_EXTERN gpointer utils_ref (gpointer instance);
VALA_EXTERN void utils_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_utils (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags);
VALA_EXTERN void value_set_utils (GValue* value,
                      gpointer v_object);
VALA_EXTERN void value_take_utils (GValue* value,
                       gpointer v_object);
VALA_EXTERN gpointer value_get_utils (const GValue* value);
VALA_EXTERN GType utils_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Utils, utils_unref)
VALA_EXTERN gboolean utils_create_dir (const gchar* path);
VALA_EXTERN gchar* utils_url_re (void);
VALA_EXTERN gchar* utils_color_from_rgba (GdkRGBA* rgba);
VALA_EXTERN void utils_color_from_string (const gchar* value,
                              GdkRGBA* result);
VALA_EXTERN void utils_set_context_color (cairo_t* ctx,
                              GdkRGBA* color);
VALA_EXTERN void utils_set_context_color_with_alpha (cairo_t* ctx,
                                         GdkRGBA* color,
                                         gdouble alpha);
VALA_EXTERN void utils_get_attribute_color (GdkRGBA* color,
                                guint16* red,
                                guint16* green,
                                guint16* blue);
VALA_EXTERN void utils_add_accel_label (GtkMenuItem* item,
                            guint key,
                            GdkModifierType mods);
VALA_EXTERN gchar* utils_match_string (const gchar* pattern,
                           const gchar* value);
VALA_EXTERN gchar* utils_rootname (const gchar* filename);
VALA_EXTERN gboolean utils_is_within_bounds (gdouble x,
                                 gdouble y,
                                 gdouble bx,
                                 gdouble by,
                                 gdouble bw,
                                 gdouble bh);
VALA_EXTERN gchar* utils_make_title (const gchar* str);
VALA_EXTERN gchar* utils_tooltip_with_accel (const gchar* tooltip,
                                 const gchar* accel);
VALA_EXTERN void utils_open_url (const gchar* url);
VALA_EXTERN gchar* utils_prepare_note_markup (const gchar* note);
VALA_EXTERN gchar* utils_markdown_to_html (const gchar* md,
                               const gchar* tag);
VALA_EXTERN gdouble utils_get_line_height (PangoLayout* layout);
VALA_EXTERN gint utils_find_word (const gchar* str,
                      gint cursor,
                      gboolean wordstart);
VALA_EXTERN gboolean utils_is_url (const gchar* str);
VALA_EXTERN gboolean utils_is_read_only (const gchar* fname);
VALA_EXTERN void utils_show_popover (GtkPopover* popover);
VALA_EXTERN void utils_hide_popover (GtkPopover* popover);
VALA_EXTERN void utils_popup_menu (GtkMenu* menu,
                       GdkEvent* e);
VALA_EXTERN void utils_set_chooser_folder (GtkFileChooser* chooser);
VALA_EXTERN void utils_store_chooser_folder (const gchar* file,
                                 gboolean is_dir);
VALA_EXTERN Utils* utils_new (void);
VALA_EXTERN Utils* utils_construct (GType object_type);
static void utils_finalize (Utils * obj);
static GType utils_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

gboolean
utils_create_dir (const gchar* path)
{
	gboolean result;
	g_return_val_if_fail (path != NULL, FALSE);
	result = g_mkdir_with_parents (path, 0755) == 0;
	return result;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

gchar*
utils_url_re (void)
{
	gchar** res = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gint res_length1;
	gint _res_size_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* result;
	_tmp0_ = g_strdup ("mailto:.+@[a-z0-9-]+\\.[a-z0-9.-]+");
	_tmp1_ = g_strdup ("[a-zA-Z0-9]+://[a-z0-9-]+\\.[a-z0-9.-]+(?:/|(?:/[][a-zA-Z0-9!#$%&'*+,." \
":;=?@_~-]+)*)");
	_tmp2_ = g_strdup ("file:///([^,\\/:*\\?\\<>\"\\|]+(/|\\\\){0,1})+");
	_tmp3_ = g_new0 (gchar*, 3 + 1);
	_tmp3_[0] = _tmp0_;
	_tmp3_[1] = _tmp1_;
	_tmp3_[2] = _tmp2_;
	res = _tmp3_;
	res_length1 = 3;
	_res_size_ = res_length1;
	_tmp4_ = _vala_g_strjoinv ("|", res, (gint) res_length1);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat ("(", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, ")", NULL);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	result = _tmp9_;
	res = (_vala_array_free (res, res_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

gchar*
utils_color_from_rgba (GdkRGBA* rgba)
{
	GdkRGBA _tmp0_;
	GdkRGBA _tmp1_;
	GdkRGBA _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (rgba != NULL, NULL);
	_tmp0_ = *rgba;
	_tmp1_ = *rgba;
	_tmp2_ = *rgba;
	_tmp3_ = g_strdup_printf ("#%02x%02x%02x", (guint) ((gint) (_tmp0_.red * 255)), (guint) ((gint) (_tmp1_.green * 255)), (guint) ((gint) (_tmp2_.blue * 255)));
	result = _tmp3_;
	return result;
}

void
utils_color_from_string (const gchar* value,
                         GdkRGBA* result)
{
	GdkRGBA c = {0};
	GdkRGBA _tmp0_ = {0};
	g_return_if_fail (value != NULL);
	_tmp0_.red = 1.0;
	_tmp0_.green = 1.0;
	_tmp0_.blue = 1.0;
	_tmp0_.alpha = 1.0;
	c = _tmp0_;
	gdk_rgba_parse (&c, value);
	*result = c;
	return;
}

void
utils_set_context_color (cairo_t* ctx,
                         GdkRGBA* color)
{
	GdkRGBA _tmp0_;
	GdkRGBA _tmp1_;
	GdkRGBA _tmp2_;
	GdkRGBA _tmp3_;
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (color != NULL);
	_tmp0_ = *color;
	_tmp1_ = *color;
	_tmp2_ = *color;
	_tmp3_ = *color;
	cairo_set_source_rgba (ctx, _tmp0_.red, _tmp1_.green, _tmp2_.blue, _tmp3_.alpha);
}

void
utils_set_context_color_with_alpha (cairo_t* ctx,
                                    GdkRGBA* color,
                                    gdouble alpha)
{
	GdkRGBA _tmp0_;
	GdkRGBA _tmp1_;
	GdkRGBA _tmp2_;
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (color != NULL);
	_tmp0_ = *color;
	_tmp1_ = *color;
	_tmp2_ = *color;
	cairo_set_source_rgba (ctx, _tmp0_.red, _tmp1_.green, _tmp2_.blue, alpha);
}

void
utils_get_attribute_color (GdkRGBA* color,
                           guint16* red,
                           guint16* green,
                           guint16* blue)
{
	guint16 _vala_red = 0U;
	guint16 _vala_green = 0U;
	guint16 _vala_blue = 0U;
	gint maxval = 0;
	GdkRGBA _tmp0_;
	GdkRGBA _tmp1_;
	GdkRGBA _tmp2_;
	g_return_if_fail (color != NULL);
	maxval = 65535;
	_tmp0_ = *color;
	_vala_red = (guint16) (_tmp0_.red * maxval);
	_tmp1_ = *color;
	_vala_green = (guint16) (_tmp1_.green * maxval);
	_tmp2_ = *color;
	_vala_blue = (guint16) (_tmp2_.blue * maxval);
	if (red) {
		*red = _vala_red;
	}
	if (green) {
		*green = _vala_green;
	}
	if (blue) {
		*blue = _vala_blue;
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
utils_add_accel_label (GtkMenuItem* item,
                       guint key,
                       GdkModifierType mods)
{
	GtkAccelLabel* label = NULL;
	GtkWidget* _tmp0_;
	GtkAccelLabel* _tmp1_;
	GtkAccelLabel* _tmp2_;
	GtkAccelLabel* _tmp3_;
	GtkAccelLabel* _tmp4_;
	g_return_if_fail (item != NULL);
	_tmp0_ = gtk_bin_get_child ((GtkBin*) item);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_accel_label_get_type ()) ? ((GtkAccelLabel*) _tmp0_) : NULL);
	label = _tmp1_;
	_tmp2_ = label;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (label);
		return;
	}
	_tmp3_ = label;
	gtk_accel_label_set_accel (_tmp3_, key, mods);
	_tmp4_ = label;
	gtk_accel_label_refetch (_tmp4_);
	_g_object_unref0 (label);
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gboolean
string_get_prev_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (0 < (*index)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_prev_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		_vala_c = (gunichar) 0;
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
	if (_vala_c != ((gunichar) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_next_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

gchar*
utils_match_string (const gchar* pattern,
                    const gchar* value)
{
	gint pattern_byte_idx = 0;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_;
	gchar* _tmp34_;
	gchar* result;
	g_return_val_if_fail (pattern != NULL, NULL);
	g_return_val_if_fail (value != NULL, NULL);
	_tmp0_ = g_utf8_casefold (value, (gssize) -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_index_of (_tmp1_, pattern, 0);
	_g_free0 (_tmp1_);
	pattern_byte_idx = _tmp2_;
	if (pattern_byte_idx != -1) {
		gunichar c = 0U;
		gint i = 0;
		gint current_index = 0;
		gint _tmp7_ = 0;
		gint start = 0;
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp14_ = 0;
		gint end = 0;
		const gchar* _tmp17_ = NULL;
		gchar* str = NULL;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		c = (gunichar) 0;
		i = 0;
		current_index = pattern_byte_idx;
		while (TRUE) {
			gboolean _tmp3_ = FALSE;
			gunichar _tmp4_ = 0U;
			gboolean _tmp5_;
			gint _tmp6_;
			_tmp5_ = string_get_prev_char (value, &current_index, &_tmp4_);
			c = _tmp4_;
			if (_tmp5_) {
				_tmp3_ = i < 10;
			} else {
				_tmp3_ = FALSE;
			}
			if (!_tmp3_) {
				break;
			}
			_tmp6_ = i;
			i = _tmp6_ + 1;
		}
		if (i < 10) {
			_tmp7_ = 0;
		} else {
			_tmp7_ = current_index;
		}
		start = _tmp7_;
		i = 0;
		_tmp8_ = strlen (pattern);
		_tmp9_ = _tmp8_;
		current_index = pattern_byte_idx + _tmp9_;
		while (TRUE) {
			gboolean _tmp10_ = FALSE;
			gunichar _tmp11_ = 0U;
			gboolean _tmp12_;
			gint _tmp13_;
			_tmp12_ = string_get_next_char (value, &current_index, &_tmp11_);
			c = _tmp11_;
			if (_tmp12_) {
				_tmp10_ = i < 10;
			} else {
				_tmp10_ = FALSE;
			}
			if (!_tmp10_) {
				break;
			}
			_tmp13_ = i;
			i = _tmp13_ + 1;
		}
		if (i < 10) {
			_tmp14_ = -1;
		} else {
			gint _tmp15_;
			gint _tmp16_;
			_tmp15_ = strlen (pattern);
			_tmp16_ = _tmp15_;
			_tmp14_ = current_index - (pattern_byte_idx + _tmp16_);
		}
		end = _tmp14_;
		if (start > 0) {
			_tmp17_ = "...";
		} else {
			_tmp17_ = "";
		}
		_tmp18_ = string_substring (value, (glong) start, (glong) (pattern_byte_idx - start));
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat (_tmp17_, _tmp19_, NULL);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strconcat (_tmp21_, "<u>", NULL);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strconcat (_tmp23_, pattern, NULL);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_strconcat (_tmp25_, "</u>", NULL);
		_tmp27_ = _tmp26_;
		_tmp28_ = strlen (pattern);
		_tmp29_ = _tmp28_;
		_tmp30_ = string_substring (value, (glong) (pattern_byte_idx + _tmp29_), (glong) -1);
		_tmp31_ = _tmp30_;
		_tmp32_ = g_strconcat (_tmp27_, _tmp31_, NULL);
		_tmp33_ = _tmp32_;
		_g_free0 (_tmp31_);
		_g_free0 (_tmp27_);
		_g_free0 (_tmp25_);
		_g_free0 (_tmp23_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp19_);
		str = _tmp33_;
		result = str;
		return result;
	}
	_tmp34_ = g_strdup ("");
	result = _tmp34_;
	return result;
}

gchar*
utils_rootname (const gchar* filename)
{
	gchar* basename = NULL;
	gchar* _tmp0_;
	gchar** parts = NULL;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint parts_length1;
	gint _parts_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar* result;
	g_return_val_if_fail (filename != NULL, NULL);
	_tmp0_ = g_path_get_basename (filename);
	basename = _tmp0_;
	_tmp1_ = basename;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, ".", 0);
	parts = _tmp3_;
	parts_length1 = _vala_array_length (_tmp2_);
	_parts_size_ = parts_length1;
	_tmp4_ = parts;
	_tmp4__length1 = parts_length1;
	if (_tmp4__length1 > 2) {
		gchar** _tmp5_;
		gint _tmp5__length1;
		gchar** _tmp6_;
		gint _tmp6__length1;
		gchar* _tmp7_;
		_tmp5_ = parts;
		_tmp5__length1 = parts_length1;
		_tmp6_ = parts;
		_tmp6__length1 = parts_length1;
		_tmp7_ = _vala_g_strjoinv (".", _tmp5_ + 0, (gint) ((_tmp6__length1 - 1) - 0));
		result = _tmp7_;
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (basename);
		return result;
	} else {
		gchar** _tmp8_;
		gint _tmp8__length1;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = parts;
		_tmp8__length1 = parts_length1;
		_tmp9_ = _tmp8_[0];
		_tmp10_ = g_strdup (_tmp9_);
		result = _tmp10_;
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (basename);
		return result;
	}
}

gboolean
utils_is_within_bounds (gdouble x,
                        gdouble y,
                        gdouble bx,
                        gdouble by,
                        gdouble bw,
                        gdouble bh)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean result;
	if (bx < x) {
		_tmp2_ = x < (bx + bw);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = by < y;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = y < (by + bh);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gchar*
utils_make_title (const gchar* str)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = g_strconcat ("<b>", str, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, "</b>", NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

gchar*
utils_tooltip_with_accel (const gchar* tooltip,
                          const gchar* accel)
{
	gchar** accels = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gint accels_length1;
	gint _accels_size_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (tooltip != NULL, NULL);
	g_return_val_if_fail (accel != NULL, NULL);
	_tmp0_ = g_strdup (accel);
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	accels = _tmp1_;
	accels_length1 = 1;
	_accels_size_ = accels_length1;
	_tmp2_ = granite_markup_accel_tooltip (accels, (gint) accels_length1, tooltip);
	result = _tmp2_;
	accels = (_vala_array_free (accels, accels_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

void
utils_open_url (const gchar* url)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (url != NULL);
	{
		g_app_info_launch_default_for_uri (url, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp0_;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = stdout;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		fprintf (_tmp0_, _ ("error: %s\n"), _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gchar*
string_splice (const gchar* self,
               glong start,
               glong end,
               const gchar* str)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gsize str_size = 0UL;
	const gchar* _result_ = NULL;
	void* _tmp6_;
	gchar* dest = NULL;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	if (str == NULL) {
		str_size = (gsize) 0;
	} else {
		gint _tmp4_;
		gint _tmp5_;
		_tmp4_ = strlen ((const gchar*) str);
		_tmp5_ = _tmp4_;
		str_size = (gsize) _tmp5_;
	}
	_tmp6_ = g_malloc0 (((string_length - (end - start)) + str_size) + 1);
	_result_ = _tmp6_;
	_tmp7_ = _result_;
	dest = (gchar*) _tmp7_;
	_tmp8_ = dest;
	memcpy (_tmp8_, self, (gsize) start);
	_tmp9_ = dest;
	dest = _tmp9_ + start;
	if (str != NULL) {
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = dest;
		memcpy (_tmp10_, str, str_size);
		_tmp11_ = dest;
		dest = _tmp11_ + str_size;
	}
	_tmp12_ = dest;
	memcpy (_tmp12_, ((gchar*) self) + end, (gsize) (string_length - end));
	_tmp13_ = _result_;
	_result_ = NULL;
	result = (gchar*) _tmp13_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
utils_prepare_note_markup (const gchar* note)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	const gchar* _tmp73_;
	gchar* _tmp74_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (note != NULL, NULL);
	_tmp0_ = utils_markdown_to_html (note, NULL);
	str = _tmp0_;
	{
		GMatchInfo* match_info = NULL;
		GRegex* re = NULL;
		GRegex* _tmp1_;
		gint start = 0;
		GQueue* list = NULL;
		GQueue* _tmp2_;
		_tmp1_ = g_regex_new ("</?(\\w+)[^>]*>", 0, 0, &_inner_error0_);
		re = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_match_info_unref0 (match_info);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			_g_free0 (str);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		start = 0;
		_tmp2_ = g_queue_new ();
		list = _tmp2_;
		while (TRUE) {
			gboolean _tmp3_ = FALSE;
			GRegex* _tmp4_;
			const gchar* _tmp5_;
			GMatchInfo* _tmp6_ = NULL;
			gboolean _tmp7_;
			gint tag_start = 0;
			gint tag_end = 0;
			gint name_start = 0;
			gint name_end = 0;
			GMatchInfo* _tmp8_;
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			GMatchInfo* _tmp11_;
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
			gchar* old_tag = NULL;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* new_tag = NULL;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* name = NULL;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			gboolean end_tag = FALSE;
			const gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gboolean _tmp23_;
			const gchar* _tmp24_;
			const gchar* _tmp25_;
			GQuark _tmp27_ = 0U;
			static GQuark _tmp26_label0 = 0;
			static GQuark _tmp26_label1 = 0;
			static GQuark _tmp26_label2 = 0;
			static GQuark _tmp26_label3 = 0;
			static GQuark _tmp26_label4 = 0;
			static GQuark _tmp26_label5 = 0;
			static GQuark _tmp26_label6 = 0;
			static GQuark _tmp26_label7 = 0;
			static GQuark _tmp26_label8 = 0;
			static GQuark _tmp26_label9 = 0;
			static GQuark _tmp26_label10 = 0;
			static GQuark _tmp26_label11 = 0;
			static GQuark _tmp26_label12 = 0;
			static GQuark _tmp26_label13 = 0;
			static GQuark _tmp26_label14 = 0;
			static GQuark _tmp26_label15 = 0;
			const gchar* _tmp63_;
			const gchar* _tmp64_;
			gchar* _tmp65_;
			const gchar* _tmp66_;
			gint _tmp67_;
			gint _tmp68_;
			const gchar* _tmp69_;
			gint _tmp70_;
			gint _tmp71_;
			_tmp4_ = re;
			_tmp5_ = str;
			_tmp7_ = g_regex_match_full (_tmp4_, _tmp5_, (gssize) -1, start, 0, &_tmp6_, &_inner_error0_);
			_g_match_info_unref0 (match_info);
			match_info = _tmp6_;
			_tmp3_ = _tmp7_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				(list == NULL) ? NULL : (list = (g_queue_free (list), NULL));
				_g_regex_unref0 (re);
				_g_match_info_unref0 (match_info);
				if (_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch0_g_regex_error;
				}
				_g_free0 (str);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			if (!_tmp3_) {
				break;
			}
			_tmp8_ = match_info;
			g_match_info_fetch_pos (_tmp8_, 0, &_tmp9_, &_tmp10_);
			tag_start = _tmp9_;
			tag_end = _tmp10_;
			_tmp11_ = match_info;
			g_match_info_fetch_pos (_tmp11_, 1, &_tmp12_, &_tmp13_);
			name_start = _tmp12_;
			name_end = _tmp13_;
			_tmp14_ = str;
			_tmp15_ = string_slice (_tmp14_, (glong) tag_start, (glong) tag_end);
			old_tag = _tmp15_;
			_tmp16_ = old_tag;
			_tmp17_ = g_strdup (_tmp16_);
			new_tag = _tmp17_;
			_tmp18_ = str;
			_tmp19_ = string_slice (_tmp18_, (glong) name_start, (glong) name_end);
			name = _tmp19_;
			_tmp20_ = str;
			_tmp21_ = string_substring (_tmp20_, (glong) (name_start - 1), (glong) 1);
			_tmp22_ = _tmp21_;
			_tmp23_ = g_strcmp0 (_tmp22_, "/") == 0;
			_g_free0 (_tmp22_);
			end_tag = _tmp23_;
			_tmp24_ = name;
			_tmp25_ = _tmp24_;
			_tmp27_ = (NULL == _tmp25_) ? 0 : g_quark_from_string (_tmp25_);
			if (_tmp27_ == ((0 != _tmp26_label0) ? _tmp26_label0 : (_tmp26_label0 = g_quark_from_static_string ("h1")))) {
				switch (0) {
					default:
					{
						const gchar* _tmp28_ = NULL;
						gchar* _tmp29_;
						if (end_tag) {
							_tmp28_ = "</span>";
						} else {
							_tmp28_ = "<span weight=\"bold\" size=\"xx-large\">";
						}
						_tmp29_ = g_strdup (_tmp28_);
						_g_free0 (new_tag);
						new_tag = _tmp29_;
						break;
					}
				}
			} else if (_tmp27_ == ((0 != _tmp26_label1) ? _tmp26_label1 : (_tmp26_label1 = g_quark_from_static_string ("h2")))) {
				switch (0) {
					default:
					{
						const gchar* _tmp30_ = NULL;
						gchar* _tmp31_;
						if (end_tag) {
							_tmp30_ = "</span>";
						} else {
							_tmp30_ = "<span weight=\"bold\" size=\"x-large\">";
						}
						_tmp31_ = g_strdup (_tmp30_);
						_g_free0 (new_tag);
						new_tag = _tmp31_;
						break;
					}
				}
			} else if (_tmp27_ == ((0 != _tmp26_label2) ? _tmp26_label2 : (_tmp26_label2 = g_quark_from_static_string ("h3")))) {
				switch (0) {
					default:
					{
						const gchar* _tmp32_ = NULL;
						gchar* _tmp33_;
						if (end_tag) {
							_tmp32_ = "</span>";
						} else {
							_tmp32_ = "<span weight=\"bold\" size=\"large\">";
						}
						_tmp33_ = g_strdup (_tmp32_);
						_g_free0 (new_tag);
						new_tag = _tmp33_;
						break;
					}
				}
			} else if (((_tmp27_ == ((0 != _tmp26_label3) ? _tmp26_label3 : (_tmp26_label3 = g_quark_from_static_string ("h4")))) || (_tmp27_ == ((0 != _tmp26_label4) ? _tmp26_label4 : (_tmp26_label4 = g_quark_from_static_string ("h5"))))) || (_tmp27_ == ((0 != _tmp26_label5) ? _tmp26_label5 : (_tmp26_label5 = g_quark_from_static_string ("h6"))))) {
				switch (0) {
					default:
					{
						const gchar* _tmp34_ = NULL;
						gchar* _tmp35_;
						if (end_tag) {
							_tmp34_ = "</span>";
						} else {
							_tmp34_ = "<span weight=\"bold\" size=\"medium\">";
						}
						_tmp35_ = g_strdup (_tmp34_);
						_g_free0 (new_tag);
						new_tag = _tmp35_;
						break;
					}
				}
			} else if (_tmp27_ == ((0 != _tmp26_label6) ? _tmp26_label6 : (_tmp26_label6 = g_quark_from_static_string ("strong")))) {
				switch (0) {
					default:
					{
						const gchar* _tmp36_ = NULL;
						gchar* _tmp37_;
						if (end_tag) {
							_tmp36_ = "</b>";
						} else {
							_tmp36_ = "<b>";
						}
						_tmp37_ = g_strdup (_tmp36_);
						_g_free0 (new_tag);
						new_tag = _tmp37_;
						break;
					}
				}
			} else if (_tmp27_ == ((0 != _tmp26_label7) ? _tmp26_label7 : (_tmp26_label7 = g_quark_from_static_string ("em")))) {
				switch (0) {
					default:
					{
						const gchar* _tmp38_ = NULL;
						gchar* _tmp39_;
						if (end_tag) {
							_tmp38_ = "</i>";
						} else {
							_tmp38_ = "<i>";
						}
						_tmp39_ = g_strdup (_tmp38_);
						_g_free0 (new_tag);
						new_tag = _tmp39_;
						break;
					}
				}
			} else if (_tmp27_ == ((0 != _tmp26_label8) ? _tmp26_label8 : (_tmp26_label8 = g_quark_from_static_string ("code")))) {
				switch (0) {
					default:
					{
						const gchar* _tmp40_ = NULL;
						gchar* _tmp41_;
						if (end_tag) {
							_tmp40_ = "</tt>";
						} else {
							_tmp40_ = "<tt>";
						}
						_tmp41_ = g_strdup (_tmp40_);
						_g_free0 (new_tag);
						new_tag = _tmp41_;
						break;
					}
				}
			} else if (_tmp27_ == ((0 != _tmp26_label9) ? _tmp26_label9 : (_tmp26_label9 = g_quark_from_static_string ("blockquote")))) {
				switch (0) {
					default:
					{
						const gchar* _tmp42_ = NULL;
						gchar* _tmp43_;
						if (end_tag) {
							_tmp42_ = "</i>";
						} else {
							_tmp42_ = "<i>";
						}
						_tmp43_ = g_strdup (_tmp42_);
						_g_free0 (new_tag);
						new_tag = _tmp43_;
						break;
					}
				}
			} else if (_tmp27_ == ((0 != _tmp26_label10) ? _tmp26_label10 : (_tmp26_label10 = g_quark_from_static_string ("hr")))) {
				switch (0) {
					default:
					{
						const gchar* _tmp44_ = NULL;
						gchar* _tmp45_;
						if (end_tag) {
							_tmp44_ = "";
						} else {
							_tmp44_ = "---";
						}
						_tmp45_ = g_strdup (_tmp44_);
						_g_free0 (new_tag);
						new_tag = _tmp45_;
						break;
					}
				}
			} else if (_tmp27_ == ((0 != _tmp26_label11) ? _tmp26_label11 : (_tmp26_label11 = g_quark_from_static_string ("p")))) {
				switch (0) {
					default:
					{
						gchar* _tmp46_;
						_tmp46_ = g_strdup ("");
						_g_free0 (new_tag);
						new_tag = _tmp46_;
						break;
					}
				}
			} else if (_tmp27_ == ((0 != _tmp26_label12) ? _tmp26_label12 : (_tmp26_label12 = g_quark_from_static_string ("br")))) {
				switch (0) {
					default:
					{
						gchar* _tmp47_;
						_tmp47_ = g_strdup ("");
						_g_free0 (new_tag);
						new_tag = _tmp47_;
						break;
					}
				}
			} else if ((_tmp27_ == ((0 != _tmp26_label13) ? _tmp26_label13 : (_tmp26_label13 = g_quark_from_static_string ("ul")))) || (_tmp27_ == ((0 != _tmp26_label14) ? _tmp26_label14 : (_tmp26_label14 = g_quark_from_static_string ("ol"))))) {
				switch (0) {
					default:
					{
						gchar* _tmp48_;
						_tmp48_ = g_strdup ("");
						_g_free0 (new_tag);
						new_tag = _tmp48_;
						if (end_tag) {
							GQueue* _tmp49_;
							_tmp49_ = list;
							g_queue_pop_tail (_tmp49_);
						} else {
							gint _tmp50_ = 0;
							const gchar* _tmp51_;
							GQueue* _tmp52_;
							_tmp51_ = name;
							if (g_strcmp0 (_tmp51_, "ul") == 0) {
								_tmp50_ = 1000000;
							} else {
								_tmp50_ = 1;
							}
							_tmp52_ = list;
							g_queue_push_tail (_tmp52_, (gpointer) ((gintptr) _tmp50_));
						}
						break;
					}
				}
			} else if (_tmp27_ == ((0 != _tmp26_label15) ? _tmp26_label15 : (_tmp26_label15 = g_quark_from_static_string ("li")))) {
				switch (0) {
					default:
					{
						if (end_tag) {
							gchar* _tmp53_;
							_tmp53_ = g_strdup ("");
							_g_free0 (new_tag);
							new_tag = _tmp53_;
						} else {
							gint val = 0;
							GQueue* _tmp54_;
							gpointer _tmp55_;
							gchar* prefix = NULL;
							GQueue* _tmp56_;
							gchar* _tmp57_;
							GQueue* _tmp62_;
							_tmp54_ = list;
							_tmp55_ = g_queue_pop_tail (_tmp54_);
							val = (gint) ((gintptr) _tmp55_);
							_tmp56_ = list;
							_tmp57_ = g_strnfill ((gsize) g_queue_get_length (_tmp56_), ' ');
							prefix = _tmp57_;
							if (val >= 1000000) {
								const gchar* _tmp58_;
								gchar* _tmp59_;
								_tmp58_ = prefix;
								_tmp59_ = g_strdup_printf ("%s* ", _tmp58_);
								_g_free0 (new_tag);
								new_tag = _tmp59_;
							} else {
								const gchar* _tmp60_;
								gchar* _tmp61_;
								_tmp60_ = prefix;
								_tmp61_ = g_strdup_printf ("%s%d. ", _tmp60_, val);
								_g_free0 (new_tag);
								new_tag = _tmp61_;
							}
							_tmp62_ = list;
							g_queue_push_tail (_tmp62_, (gpointer) ((gintptr) (val + 1)));
							_g_free0 (prefix);
						}
						break;
					}
				}
			}
			_tmp63_ = str;
			_tmp64_ = new_tag;
			_tmp65_ = string_splice (_tmp63_, (glong) tag_start, (glong) tag_end, _tmp64_);
			_g_free0 (str);
			str = _tmp65_;
			_tmp66_ = new_tag;
			_tmp67_ = strlen (_tmp66_);
			_tmp68_ = _tmp67_;
			_tmp69_ = old_tag;
			_tmp70_ = strlen (_tmp69_);
			_tmp71_ = _tmp70_;
			start = tag_end + (_tmp68_ - _tmp71_);
			_g_free0 (name);
			_g_free0 (new_tag);
			_g_free0 (old_tag);
		}
		(list == NULL) ? NULL : (list = (g_queue_free (list), NULL));
		_g_regex_unref0 (re);
		_g_match_info_unref0 (match_info);
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		gchar* _tmp72_;
		g_clear_error (&_inner_error0_);
		_tmp72_ = string_replace (note, "<", "&lt;");
		result = _tmp72_;
		_g_free0 (str);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (str);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp73_ = str;
	_tmp74_ = string_replace (_tmp73_, "\n\n\n", "\n\n");
	result = _tmp74_;
	_g_free0 (str);
	return result;
}

gchar*
utils_markdown_to_html (const gchar* md,
                        const gchar* tag)
{
	gchar* html = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (md != NULL, NULL);
	_tmp0_ = g_markup_escape_text (md, (gssize) -1);
	_g_free0 (html);
	html = _tmp0_;
	if (tag == NULL) {
		result = html;
		return result;
	} else {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp1_ = g_strconcat ("<", tag, NULL);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strconcat (_tmp2_, ">", NULL);
		_tmp4_ = _tmp3_;
		_tmp5_ = html;
		_tmp6_ = g_strconcat (_tmp4_, _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat (_tmp7_, "</", NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat (_tmp9_, tag, NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strconcat (_tmp11_, ">", NULL);
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
		_g_free0 (_tmp4_);
		_g_free0 (_tmp2_);
		result = _tmp13_;
		_g_free0 (html);
		return result;
	}
}

static gpointer
_pango_layout_line_ref0 (gpointer self)
{
	return self ? pango_layout_line_ref (self) : NULL;
}

gdouble
utils_get_line_height (PangoLayout* layout)
{
	gint height = 0;
	PangoLayoutLine* line = NULL;
	PangoLayoutLine* _tmp0_;
	PangoLayoutLine* _tmp1_;
	PangoLayoutLine* _tmp2_;
	gdouble result;
	g_return_val_if_fail (layout != NULL, 0.0);
	_tmp0_ = pango_layout_get_line_readonly (layout, 0);
	_tmp1_ = _pango_layout_line_ref0 (_tmp0_);
	line = _tmp1_;
	_tmp2_ = line;
	if (_tmp2_ == NULL) {
		gint width = 0;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		pango_layout_get_size (layout, &_tmp3_, &_tmp4_);
		width = _tmp3_;
		height = _tmp4_;
	} else {
		PangoRectangle ink_rect = {0};
		PangoRectangle log_rect = {0};
		PangoLayoutLine* _tmp5_;
		PangoRectangle _tmp6_ = {0};
		PangoRectangle _tmp7_ = {0};
		PangoRectangle _tmp8_;
		_tmp5_ = line;
		pango_layout_line_get_extents (_tmp5_, &_tmp6_, &_tmp7_);
		ink_rect = _tmp6_;
		log_rect = _tmp7_;
		_tmp8_ = log_rect;
		height = _tmp8_.height;
	}
	result = (gdouble) (height / PANGO_SCALE);
	_pango_layout_line_unref0 (line);
	return result;
}

gint
utils_find_word (const gchar* str,
                 gint cursor,
                 gboolean wordstart)
{
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (str != NULL, 0);
	{
		GMatchInfo* match_info = NULL;
		gchar* _tmp0_ = NULL;
		gchar* substr = NULL;
		gchar* _tmp3_;
		const gchar* _tmp4_ = NULL;
		GRegex* re = NULL;
		GRegex* _tmp5_;
		GRegex* _tmp7_;
		const gchar* _tmp8_;
		GMatchInfo* _tmp9_ = NULL;
		gboolean _tmp10_;
		if (wordstart) {
			gchar* _tmp1_;
			_tmp1_ = string_substring (str, (glong) 0, (glong) cursor);
			_g_free0 (_tmp0_);
			_tmp0_ = _tmp1_;
		} else {
			gchar* _tmp2_;
			_tmp2_ = string_substring (str, (glong) cursor, (glong) -1);
			_g_free0 (_tmp0_);
			_tmp0_ = _tmp2_;
		}
		_tmp3_ = g_strdup (_tmp0_);
		substr = _tmp3_;
		if (wordstart) {
			_tmp4_ = ".*(\\W\\w|[\\w\\s][^\\w\\s])";
		} else {
			_tmp4_ = "(\\w\\W|[^\\w\\s][\\w\\s])";
		}
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		re = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp6_ = -1;
			_g_free0 (substr);
			_g_free0 (_tmp0_);
			_g_match_info_unref0 (match_info);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp6_;
		}
		_tmp7_ = re;
		_tmp8_ = substr;
		_tmp10_ = g_regex_match (_tmp7_, _tmp8_, 0, &_tmp9_);
		_g_match_info_unref0 (match_info);
		match_info = _tmp9_;
		if (_tmp10_) {
			gint start_pos = 0;
			gint end_pos = 0;
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
			g_match_info_fetch_pos (match_info, 1, &_tmp11_, &_tmp12_);
			start_pos = _tmp11_;
			end_pos = _tmp12_;
			if (wordstart) {
				_tmp13_ = start_pos + 1;
			} else {
				_tmp13_ = (cursor + start_pos) + 1;
			}
			result = _tmp13_;
			_g_regex_unref0 (re);
			_g_free0 (substr);
			_g_free0 (_tmp0_);
			_g_match_info_unref0 (match_info);
			return result;
		}
		_g_regex_unref0 (re);
		_g_free0 (substr);
		_g_free0 (_tmp0_);
		_g_match_info_unref0 (match_info);
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp14_ = -1;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp14_;
	}
	result = -1;
	return result;
}

gboolean
utils_is_url (const gchar* str)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = utils_url_re ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_regex_match_simple (_tmp1_, str, 0, 0);
	_g_free0 (_tmp1_);
	result = _tmp2_;
	return result;
}

gboolean
utils_is_read_only (const gchar* fname)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GtkSourceFile* src = NULL;
	GtkSourceFile* _tmp1_;
	gboolean result;
	g_return_val_if_fail (fname != NULL, FALSE);
	_tmp0_ = g_file_new_for_path (fname);
	file = _tmp0_;
	_tmp1_ = gtk_source_file_new ();
	src = _tmp1_;
	gtk_source_file_set_location (src, file);
	gtk_source_file_check_file_on_disk (src);
	result = gtk_source_file_is_readonly (src);
	_g_object_unref0 (src);
	_g_object_unref0 (file);
	return result;
}

void
utils_show_popover (GtkPopover* popover)
{
	g_return_if_fail (popover != NULL);
	gtk_popover_popup (popover);
}

void
utils_hide_popover (GtkPopover* popover)
{
	g_return_if_fail (popover != NULL);
	gtk_popover_popdown (popover);
}

void
utils_popup_menu (GtkMenu* menu,
                  GdkEvent* e)
{
	g_return_if_fail (menu != NULL);
	g_return_if_fail (e != NULL);
	gtk_menu_popup_at_pointer (menu, e);
}

void
utils_set_chooser_folder (GtkFileChooser* chooser)
{
	gchar* dir = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (chooser != NULL);
	_tmp0_ = minder_settings;
	_tmp1_ = g_settings_get_string (_tmp0_, "last-directory");
	dir = _tmp1_;
	_tmp2_ = dir;
	if (g_strcmp0 (_tmp2_, "") != 0) {
		const gchar* _tmp3_;
		_tmp3_ = dir;
		gtk_file_chooser_set_current_folder (chooser, _tmp3_);
	}
	_g_free0 (dir);
}

void
utils_store_chooser_folder (const gchar* file,
                            gboolean is_dir)
{
	gchar* _tmp0_ = NULL;
	gchar* dir = NULL;
	gchar* _tmp3_;
	GSettings* _tmp4_;
	g_return_if_fail (file != NULL);
	if (is_dir) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (file);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		gchar* _tmp2_;
		_tmp2_ = g_path_get_dirname (file);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	_tmp3_ = g_strdup (_tmp0_);
	dir = _tmp3_;
	_tmp4_ = minder_settings;
	g_settings_set_string (_tmp4_, "last-directory", dir);
	_g_free0 (dir);
	_g_free0 (_tmp0_);
}

Utils*
utils_construct (GType object_type)
{
	Utils* self = NULL;
	self = (Utils*) g_type_create_instance (object_type);
	return self;
}

Utils*
utils_new (void)
{
	return utils_construct (TYPE_UTILS);
}

static void
value_utils_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_utils_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		utils_unref (value->data[0].v_pointer);
	}
}

static void
value_utils_copy_value (const GValue* src_value,
                        GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = utils_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_utils_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_utils_collect_value (GValue* value,
                           guint n_collect_values,
                           GTypeCValue* collect_values,
                           guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		Utils * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = utils_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_utils_lcopy_value (const GValue* value,
                         guint n_collect_values,
                         GTypeCValue* collect_values,
                         guint collect_flags)
{
	Utils ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = utils_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_utils (const gchar* name,
                  const gchar* nick,
                  const gchar* blurb,
                  GType object_type,
                  GParamFlags flags)
{
	ParamSpecUtils* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_UTILS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_utils (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_UTILS), NULL);
	return value->data[0].v_pointer;
}

void
value_set_utils (GValue* value,
                 gpointer v_object)
{
	Utils * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		utils_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		utils_unref (old);
	}
}

void
value_take_utils (GValue* value,
                  gpointer v_object)
{
	Utils * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		utils_unref (old);
	}
}

static void
utils_class_init (UtilsClass * klass,
                  gpointer klass_data)
{
	utils_parent_class = g_type_class_peek_parent (klass);
	((UtilsClass *) klass)->finalize = utils_finalize;
}

static void
utils_instance_init (Utils * self,
                     gpointer klass)
{
	self->ref_count = 1;
}

static void
utils_finalize (Utils * obj)
{
	Utils * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_UTILS, Utils);
	g_signal_handlers_destroy (self);
}

static GType
utils_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_utils_init, value_utils_free_value, value_utils_copy_value, value_utils_peek_pointer, "p", value_utils_collect_value, "p", value_utils_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (UtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Utils), 0, (GInstanceInitFunc) utils_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType utils_type_id;
	utils_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Utils", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return utils_type_id;
}

GType
utils_get_type (void)
{
	static volatile gsize utils_type_id__once = 0;
	if (g_once_init_enter (&utils_type_id__once)) {
		GType utils_type_id;
		utils_type_id = utils_get_type_once ();
		g_once_init_leave (&utils_type_id__once, utils_type_id);
	}
	return utils_type_id__once;
}

gpointer
utils_ref (gpointer instance)
{
	Utils * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
utils_unref (gpointer instance)
{
	Utils * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		UTILS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

