/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 11 "trafgen_parser.y"


#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <stdbool.h>
#include <errno.h>
#include <libgen.h>
#include <signal.h>
#include <unistd.h>
#include <net/if_arp.h>
#include <netinet/in.h>
#include <linux/icmp.h>
#include <linux/if_ether.h>
#include <linux/icmpv6.h>

#include "xmalloc.h"
#include "trafgen_parser.tab.h"
#include "trafgen_conf.h"
#include "trafgen_proto.h"
#include "trafgen_l2.h"
#include "trafgen_l3.h"
#include "trafgen_l4.h"
#include "trafgen_l7.h"
#include "built_in.h"
#include "die.h"
#include "str.h"
#include "csum.h"
#include "cpp.h"

#ifndef ETH_P_8021AD
#define ETH_P_8021AD	0x88A8
#endif

#define YYERROR_VERBOSE		0
#define YYDEBUG			0
#define YYLTYPE_IS_TRIVIAL	1

extern FILE *yyin;
extern int yylex(void);
extern void yy_scan_string(char *);
extern void yylex_destroy();
extern void yyerror(const char *);
extern int yylineno;
extern char *yytext;

extern struct packet *packets;
extern size_t plen;

#define packet_last		(plen - 1)

#define payload_last		(packets[packet_last].len - 1)

extern struct packet_dyn *packet_dyn;
extern size_t dlen;

#define packetd_last		(dlen - 1)

#define packetdc_last		(packet_dyn[packetd_last].clen - 1)
#define packetdr_last		(packet_dyn[packetd_last].rlen - 1)
#define packetds_last		(packet_dyn[packetd_last].slen - 1)

static int our_cpu, min_cpu = -1, max_cpu = -1;

enum field_expr_type_t {
	FIELD_EXPR_UNKNOWN	= 0,
	FIELD_EXPR_NUMB		= 1 << 0,
	FIELD_EXPR_MAC		= 1 << 1,
	FIELD_EXPR_IP4_ADDR	= 1 << 2,
	FIELD_EXPR_IP6_ADDR	= 1 << 3,
	FIELD_EXPR_INC		= 1 << 4,
	FIELD_EXPR_RND		= 1 << 5,
	FIELD_EXPR_OFFSET	= 1 << 6,
	FIELD_EXPR_STRING	= 1 << 7,
	FIELD_EXPR_FQDN		= 1 << 8,
};

struct proto_field_expr {
	enum field_expr_type_t type;
	struct proto_field *field;

	union {
		struct in_addr ip4_addr;
		struct in6_addr ip6_addr;
		long long int number;
		uint8_t mac[256];
		char *str;
		struct proto_field_func func;
	} val;
};

static struct proto_field_expr field_expr;
static struct proto_hdr *hdr;

static inline int test_ignore(void)
{
	if (min_cpu < 0 && max_cpu < 0)
		return 0;
	else if (max_cpu >= our_cpu && min_cpu <= our_cpu)
		return 0;
	else
		return 1;
}

static inline void __init_new_packet_slot(struct packet *slot)
{
	memset(slot, 0, sizeof(*slot));
}

static inline void __init_new_counter_slot(struct packet_dyn *slot)
{
	slot->cnt = NULL;
	slot->clen = 0;
}

static inline void __init_new_randomizer_slot(struct packet_dyn *slot)
{
	slot->rnd = NULL;
	slot->rlen = 0;
}

static inline void __init_new_csum_slot(struct packet_dyn *slot)
{
	slot->csum = NULL;
	slot->slen = 0;
}

static inline void __init_new_fields_slot(struct packet_dyn *slot)
{
	slot->fields = NULL;
	slot->flen = 0;
}

static inline void __setup_new_counter(struct counter *c, uint8_t start,
				       uint8_t stop, uint8_t stepping,
				       int type)
{
	c->min = start;
	c->max = stop;
	c->inc = (type == TYPE_INC) ? stepping : -stepping;
	c->val = (type == TYPE_INC) ? start : stop;
	c->off = payload_last;
	c->type = type;
}

static inline void __setup_new_randomizer(struct randomizer *r)
{
	r->off = payload_last;
}

static inline void __setup_new_csum16(struct csum16 *s, off_t from, off_t to,
				      enum csum which)
{
	s->off = payload_last - 1;
	s->from = from;
	s->to = to;
	s->which = which;
}

struct packet *realloc_packet(void)
{
	uint32_t i;

	if (test_ignore())
		return NULL;

	plen++;
	packets = xrealloc(packets, plen * sizeof(*packets));

	__init_new_packet_slot(&packets[packet_last]);

	dlen++;
	packet_dyn = xrealloc(packet_dyn, dlen * sizeof(*packet_dyn));

	__init_new_counter_slot(&packet_dyn[packetd_last]);
	__init_new_randomizer_slot(&packet_dyn[packetd_last]);
	__init_new_csum_slot(&packet_dyn[packetd_last]);
	__init_new_fields_slot(&packet_dyn[packetd_last]);

	for (i = 0; i < plen; i++)
		packets[i].id = i;

	return &packets[packet_last];
}

struct packet *current_packet(void)
{
	return &packets[packet_last];
}

uint32_t current_packet_id(void)
{
	return packet_last;
}

struct packet *packet_get(uint32_t id)
{
	return &packets[id];
}

static void set_byte(uint8_t val)
{
	struct packet *pkt = &packets[packet_last];

	if (test_ignore())
		return;

	pkt->len++;
	pkt->payload = xrealloc(pkt->payload, pkt->len);
	pkt->payload[payload_last] = val;
}

static void set_multi_byte(uint8_t *s, size_t len)
{
	size_t i;

	for (i = 0; i < len; ++i)
		set_byte(s[i]);
}

void set_fill(uint8_t val, size_t len)
{
	size_t i;
	struct packet *pkt = &packets[packet_last];

	if (test_ignore())
		return;

	pkt->len += len;
	pkt->payload = xrealloc(pkt->payload, pkt->len);
	for (i = 0; i < len; ++i)
		pkt->payload[payload_last - i] = val;
}

static void __set_csum16_dynamic(size_t from, size_t to, enum csum which)
{
	struct packet *pkt = &packets[packet_last];
	struct packet_dyn *pktd = &packet_dyn[packetd_last];

	pkt->len += 2;
	pkt->payload = xrealloc(pkt->payload, pkt->len);

	pktd->slen++;
	pktd->csum = xrealloc(pktd->csum, pktd->slen * sizeof(struct csum16));

	__setup_new_csum16(&pktd->csum[packetds_last], from, to, which);
}

static void __set_csum16_static(size_t from, size_t to, enum csum which __maybe_unused)
{
	struct packet *pkt = &packets[packet_last];
	uint16_t sum;
	uint8_t *psum;

	sum = htons(calc_csum(pkt->payload + from, to - from));
	psum = (uint8_t *) &sum;

	set_byte(psum[0]);
	set_byte(psum[1]);
}

static inline bool is_dynamic_csum(enum csum which)
{
	switch (which) {
	case CSUM_UDP:
	case CSUM_TCP:
	case CSUM_UDP6:
	case CSUM_TCP6:
	case CSUM_ICMP6:
		return true;
	default:
		return false;
	}
}

static void set_csum16(size_t from, size_t to, enum csum which)
{
	struct packet *pkt = &packets[packet_last];
	struct packet_dyn *pktd = &packet_dyn[packetd_last];

	if (test_ignore())
		return;

	if (to < from) {
		size_t tmp = to;

		to = from;
		from = tmp;
	}

	bug_on(!(from < to));

	if (packet_dyn_has_elems(pktd) || to >= pkt->len || is_dynamic_csum(which))
		__set_csum16_dynamic(from, to, which);
	else
		__set_csum16_static(from, to, which);
}

static void set_rnd(size_t len)
{
	size_t i;
	struct packet *pkt = &packets[packet_last];

	if (test_ignore())
		return;

	pkt->len += len;
	pkt->payload = xrealloc(pkt->payload, pkt->len);
	for (i = 0; i < len; ++i)
		pkt->payload[payload_last - i] = (uint8_t) rand();
}

static void set_sequential_inc(uint8_t start, size_t len, uint8_t stepping)
{
	size_t i;
	struct packet *pkt = &packets[packet_last];

	if (test_ignore())
		return;

	pkt->len += len;
	pkt->payload = xrealloc(pkt->payload, pkt->len);
	for (i = 0; i < len; ++i) {
		off_t off = len - 1 - i;

		pkt->payload[payload_last - off] = start;
		start += stepping;
	}
}

static void set_sequential_dec(uint8_t start, size_t len, uint8_t stepping)
{
	size_t i;
	struct packet *pkt = &packets[packet_last];

	if (test_ignore())
		return;

	pkt->len += len;
	pkt->payload = xrealloc(pkt->payload, pkt->len);
	for (i = 0; i < len; ++i) {
		int off = len - 1 - i;

		pkt->payload[payload_last - off] = start;
		start -= stepping;
	}
}

static void set_dynamic_rnd(void)
{
	struct packet *pkt = &packets[packet_last];
	struct packet_dyn *pktd = &packet_dyn[packetd_last];

	if (test_ignore())
		return;

	pkt->len++;
	pkt->payload = xrealloc(pkt->payload, pkt->len);

	pktd->rlen++;
	pktd->rnd = xrealloc(pktd->rnd, pktd->rlen * sizeof(struct randomizer));

	__setup_new_randomizer(&pktd->rnd[packetdr_last]);
}

static void set_dynamic_incdec(uint8_t start, uint8_t stop, uint8_t stepping,
			       int type)
{
	struct packet *pkt = &packets[packet_last];
	struct packet_dyn *pktd = &packet_dyn[packetd_last];

	if (test_ignore())
		return;

	pkt->len++;
	pkt->payload = xrealloc(pkt->payload, pkt->len);

	pktd->clen++;
	pktd->cnt = xrealloc(pktd->cnt, pktd->clen * sizeof(struct counter));

	__setup_new_counter(&pktd->cnt[packetdc_last], start, stop, stepping, type);
}

static void proto_add(enum proto_id pid)
{
	hdr = proto_header_push(pid);
}

static void proto_field_set(uint32_t fid)
{
	memset(&field_expr, 0, sizeof(field_expr));
	field_expr.field = proto_hdr_field_by_id(hdr, fid);
}

static void proto_field_func_setup(struct proto_field *field, struct proto_field_func *func)
{
	struct proto_field *field_copy;
	struct packet_dyn *pkt_dyn;

	field_copy = xmalloc(sizeof(*field));
	memcpy(field_copy, field, sizeof(*field));

	field_copy->pkt_offset += func->offset;
	if (func->len)
		field_copy->len = func->len;

	proto_field_func_add(field_copy, func);

	pkt_dyn = &packet_dyn[packetd_last];
	pkt_dyn->flen++;
	pkt_dyn->fields = xrealloc(pkt_dyn->fields, pkt_dyn->flen *
				   sizeof(struct proto_field *));

	pkt_dyn->fields[pkt_dyn->flen - 1] = field_copy;
}

static void proto_field_expr_eval(void)
{
	struct proto_field *field = field_expr.field;

	if ((field_expr.type & FIELD_EXPR_OFFSET) &&
			!((field_expr.type & FIELD_EXPR_INC) ||
				(field_expr.type & FIELD_EXPR_RND))) {

		panic("Field offset expression is valid only with function expression\n");
	}

	if (field_expr.type & FIELD_EXPR_NUMB) {
		if (field->len == 1)
			proto_field_set_u8(field, field_expr.val.number);
		else if (field->len == 2)
			proto_field_set_be16(field, field_expr.val.number);
		else if (field->len == 4)
			proto_field_set_be32(field, field_expr.val.number);
		else
			panic("Invalid value length %zu, can be 1,2 or 4\n", field->len);
	} else if (field_expr.type & FIELD_EXPR_MAC) {
		proto_field_set_bytes(field, field_expr.val.mac, 6);
	} else if (field_expr.type & FIELD_EXPR_FQDN) {
		char *fqdn = str2fqdn(field_expr.val.str);
		proto_field_set_bytes(field, (uint8_t *) fqdn, strlen(fqdn) + 1);
		xfree(field_expr.val.str);
		xfree(fqdn);
	} else if (field_expr.type & FIELD_EXPR_STRING) {
		proto_field_set_string(field, field_expr.val.str);
		xfree(field_expr.val.str);
	} else if (field_expr.type & FIELD_EXPR_IP4_ADDR) {
		proto_field_set_u32(field, field_expr.val.ip4_addr.s_addr);
	} else if (field_expr.type & FIELD_EXPR_IP6_ADDR) {
		proto_field_set_bytes(field, (uint8_t *)&field_expr.val.ip6_addr.s6_addr, 16);
	} else if ((field_expr.type & FIELD_EXPR_INC) ||
			(field_expr.type & FIELD_EXPR_RND)) {

		if (field_expr.val.func.min
			&& field_expr.val.func.min >= field_expr.val.func.max)
			panic("dinc(): min(%u) can't be >= max(%u)\n",
				field_expr.val.func.min, field_expr.val.func.max);

		proto_field_func_setup(field, &field_expr.val.func);
	} else if ((field_expr.type & FIELD_EXPR_OFFSET) &&
			!((field_expr.type & FIELD_EXPR_INC) ||
				(field_expr.type & FIELD_EXPR_RND))) {

		panic("Field expression is valid only for function value expression\n");
	} else {
		bug();
	}

	memset(&field_expr, 0, sizeof(field_expr));
}

static void field_index_validate(struct proto_field *field, uint16_t index, size_t len)
{
	if (field_expr.field->len <= index) {
		yyerror("Invalid [index] parameter");
		panic("Index (%u) is bigger than field's length (%zu)\n",
		       index, field->len);
	}
	if (len != 1 && len != 2 && len != 4) {
		yyerror("Invalid [index:len] parameter");
		panic("Invalid index length - 1,2 or 4 is only allowed\n");
	}
}

static void proto_push_sub_hdr(uint32_t id)
{
	hdr = proto_hdr_push_sub_header(hdr, id);
}

static void proto_pop_sub_hdr(void)
{
	if (hdr->ops->header_finish)
		hdr->ops->header_finish(hdr);

	hdr = hdr->parent;
}


#line 570 "trafgen/trafgen_parser.tab.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "trafgen_parser.tab.h"
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_K_COMMENT = 3,                  /* K_COMMENT  */
  YYSYMBOL_K_FILL = 4,                     /* K_FILL  */
  YYSYMBOL_K_RND = 5,                      /* K_RND  */
  YYSYMBOL_K_SEQINC = 6,                   /* K_SEQINC  */
  YYSYMBOL_K_SEQDEC = 7,                   /* K_SEQDEC  */
  YYSYMBOL_K_DRND = 8,                     /* K_DRND  */
  YYSYMBOL_K_DINC = 9,                     /* K_DINC  */
  YYSYMBOL_K_DDEC = 10,                    /* K_DDEC  */
  YYSYMBOL_K_WHITE = 11,                   /* K_WHITE  */
  YYSYMBOL_K_CPU = 12,                     /* K_CPU  */
  YYSYMBOL_K_CSUMIP = 13,                  /* K_CSUMIP  */
  YYSYMBOL_K_CSUMUDP = 14,                 /* K_CSUMUDP  */
  YYSYMBOL_K_CSUMTCP = 15,                 /* K_CSUMTCP  */
  YYSYMBOL_K_CSUMUDP6 = 16,                /* K_CSUMUDP6  */
  YYSYMBOL_K_CSUMTCP6 = 17,                /* K_CSUMTCP6  */
  YYSYMBOL_K_CSUMICMP6 = 18,               /* K_CSUMICMP6  */
  YYSYMBOL_K_CONST8 = 19,                  /* K_CONST8  */
  YYSYMBOL_K_CONST16 = 20,                 /* K_CONST16  */
  YYSYMBOL_K_CONST32 = 21,                 /* K_CONST32  */
  YYSYMBOL_K_CONST64 = 22,                 /* K_CONST64  */
  YYSYMBOL_K_DADDR = 23,                   /* K_DADDR  */
  YYSYMBOL_K_SADDR = 24,                   /* K_SADDR  */
  YYSYMBOL_K_ETYPE = 25,                   /* K_ETYPE  */
  YYSYMBOL_K_TYPE = 26,                    /* K_TYPE  */
  YYSYMBOL_K_TIME = 27,                    /* K_TIME  */
  YYSYMBOL_K_PRIO = 28,                    /* K_PRIO  */
  YYSYMBOL_K_OPER = 29,                    /* K_OPER  */
  YYSYMBOL_K_SHA = 30,                     /* K_SHA  */
  YYSYMBOL_K_SPA = 31,                     /* K_SPA  */
  YYSYMBOL_K_THA = 32,                     /* K_THA  */
  YYSYMBOL_K_TPA = 33,                     /* K_TPA  */
  YYSYMBOL_K_REQUEST = 34,                 /* K_REQUEST  */
  YYSYMBOL_K_REPLY = 35,                   /* K_REPLY  */
  YYSYMBOL_K_PTYPE = 36,                   /* K_PTYPE  */
  YYSYMBOL_K_HTYPE = 37,                   /* K_HTYPE  */
  YYSYMBOL_K_PROT = 38,                    /* K_PROT  */
  YYSYMBOL_K_TTL = 39,                     /* K_TTL  */
  YYSYMBOL_K_DSCP = 40,                    /* K_DSCP  */
  YYSYMBOL_K_ECN = 41,                     /* K_ECN  */
  YYSYMBOL_K_TOS = 42,                     /* K_TOS  */
  YYSYMBOL_K_LEN = 43,                     /* K_LEN  */
  YYSYMBOL_K_ID = 44,                      /* K_ID  */
  YYSYMBOL_K_FLAGS = 45,                   /* K_FLAGS  */
  YYSYMBOL_K_FRAG = 46,                    /* K_FRAG  */
  YYSYMBOL_K_IHL = 47,                     /* K_IHL  */
  YYSYMBOL_K_VER = 48,                     /* K_VER  */
  YYSYMBOL_K_CSUM = 49,                    /* K_CSUM  */
  YYSYMBOL_K_DF = 50,                      /* K_DF  */
  YYSYMBOL_K_MF = 51,                      /* K_MF  */
  YYSYMBOL_K_FLOW = 52,                    /* K_FLOW  */
  YYSYMBOL_K_NEXT_HDR = 53,                /* K_NEXT_HDR  */
  YYSYMBOL_K_HOP_LIMIT = 54,               /* K_HOP_LIMIT  */
  YYSYMBOL_K_CODE = 55,                    /* K_CODE  */
  YYSYMBOL_K_ECHO_REQUEST = 56,            /* K_ECHO_REQUEST  */
  YYSYMBOL_K_ECHO_REPLY = 57,              /* K_ECHO_REPLY  */
  YYSYMBOL_K_SPORT = 58,                   /* K_SPORT  */
  YYSYMBOL_K_DPORT = 59,                   /* K_DPORT  */
  YYSYMBOL_K_SEQ = 60,                     /* K_SEQ  */
  YYSYMBOL_K_ACK_SEQ = 61,                 /* K_ACK_SEQ  */
  YYSYMBOL_K_DOFF = 62,                    /* K_DOFF  */
  YYSYMBOL_K_CWR = 63,                     /* K_CWR  */
  YYSYMBOL_K_ECE = 64,                     /* K_ECE  */
  YYSYMBOL_K_URG = 65,                     /* K_URG  */
  YYSYMBOL_K_ACK = 66,                     /* K_ACK  */
  YYSYMBOL_K_PSH = 67,                     /* K_PSH  */
  YYSYMBOL_K_RST = 68,                     /* K_RST  */
  YYSYMBOL_K_SYN = 69,                     /* K_SYN  */
  YYSYMBOL_K_FIN = 70,                     /* K_FIN  */
  YYSYMBOL_K_WINDOW = 71,                  /* K_WINDOW  */
  YYSYMBOL_K_URG_PTR = 72,                 /* K_URG_PTR  */
  YYSYMBOL_K_TPID = 73,                    /* K_TPID  */
  YYSYMBOL_K_TCI = 74,                     /* K_TCI  */
  YYSYMBOL_K_PCP = 75,                     /* K_PCP  */
  YYSYMBOL_K_DEI = 76,                     /* K_DEI  */
  YYSYMBOL_K_1Q = 77,                      /* K_1Q  */
  YYSYMBOL_K_1AD = 78,                     /* K_1AD  */
  YYSYMBOL_K_LABEL = 79,                   /* K_LABEL  */
  YYSYMBOL_K_TC = 80,                      /* K_TC  */
  YYSYMBOL_K_LAST = 81,                    /* K_LAST  */
  YYSYMBOL_K_EXP = 82,                     /* K_EXP  */
  YYSYMBOL_K_ADDR = 83,                    /* K_ADDR  */
  YYSYMBOL_K_MTU = 84,                     /* K_MTU  */
  YYSYMBOL_K_QR = 85,                      /* K_QR  */
  YYSYMBOL_K_AANSWER = 86,                 /* K_AANSWER  */
  YYSYMBOL_K_TRUNC = 87,                   /* K_TRUNC  */
  YYSYMBOL_K_RAVAIL = 88,                  /* K_RAVAIL  */
  YYSYMBOL_K_RDESIRED = 89,                /* K_RDESIRED  */
  YYSYMBOL_K_ZERO = 90,                    /* K_ZERO  */
  YYSYMBOL_K_RCODE = 91,                   /* K_RCODE  */
  YYSYMBOL_K_QDCOUNT = 92,                 /* K_QDCOUNT  */
  YYSYMBOL_K_ANCOUNT = 93,                 /* K_ANCOUNT  */
  YYSYMBOL_K_NSCOUNT = 94,                 /* K_NSCOUNT  */
  YYSYMBOL_K_ARCOUNT = 95,                 /* K_ARCOUNT  */
  YYSYMBOL_K_QUERY = 96,                   /* K_QUERY  */
  YYSYMBOL_K_ANSWER = 97,                  /* K_ANSWER  */
  YYSYMBOL_K_AUTH = 98,                    /* K_AUTH  */
  YYSYMBOL_K_ADD = 99,                     /* K_ADD  */
  YYSYMBOL_K_NAME = 100,                   /* K_NAME  */
  YYSYMBOL_K_CLASS = 101,                  /* K_CLASS  */
  YYSYMBOL_K_DATA = 102,                   /* K_DATA  */
  YYSYMBOL_K_NS = 103,                     /* K_NS  */
  YYSYMBOL_K_CNAME = 104,                  /* K_CNAME  */
  YYSYMBOL_K_PTR = 105,                    /* K_PTR  */
  YYSYMBOL_K_ETH = 106,                    /* K_ETH  */
  YYSYMBOL_K_PAUSE = 107,                  /* K_PAUSE  */
  YYSYMBOL_K_PFC = 108,                    /* K_PFC  */
  YYSYMBOL_K_VLAN = 109,                   /* K_VLAN  */
  YYSYMBOL_K_MPLS = 110,                   /* K_MPLS  */
  YYSYMBOL_K_ARP = 111,                    /* K_ARP  */
  YYSYMBOL_K_IP4 = 112,                    /* K_IP4  */
  YYSYMBOL_K_IP6 = 113,                    /* K_IP6  */
  YYSYMBOL_K_ICMP4 = 114,                  /* K_ICMP4  */
  YYSYMBOL_K_ICMP6 = 115,                  /* K_ICMP6  */
  YYSYMBOL_K_UDP = 116,                    /* K_UDP  */
  YYSYMBOL_K_TCP = 117,                    /* K_TCP  */
  YYSYMBOL_K_DNS = 118,                    /* K_DNS  */
  YYSYMBOL_119_ = 119,                     /* ','  */
  YYSYMBOL_120_ = 120,                     /* '{'  */
  YYSYMBOL_121_ = 121,                     /* '}'  */
  YYSYMBOL_122_ = 122,                     /* '('  */
  YYSYMBOL_123_ = 123,                     /* ')'  */
  YYSYMBOL_124_ = 124,                     /* '['  */
  YYSYMBOL_125_ = 125,                     /* ']'  */
  YYSYMBOL_126_ = 126,                     /* ':'  */
  YYSYMBOL_127_ = 127,                     /* '-'  */
  YYSYMBOL_128_ = 128,                     /* '+'  */
  YYSYMBOL_129_ = 129,                     /* '*'  */
  YYSYMBOL_130_ = 130,                     /* '/'  */
  YYSYMBOL_131_ = 131,                     /* '%'  */
  YYSYMBOL_132_ = 132,                     /* '&'  */
  YYSYMBOL_133_ = 133,                     /* '|'  */
  YYSYMBOL_134_ = 134,                     /* '<'  */
  YYSYMBOL_135_ = 135,                     /* '>'  */
  YYSYMBOL_136_ = 136,                     /* '^'  */
  YYSYMBOL_number = 137,                   /* number  */
  YYSYMBOL_string = 138,                   /* string  */
  YYSYMBOL_mac = 139,                      /* mac  */
  YYSYMBOL_ip4_addr = 140,                 /* ip4_addr  */
  YYSYMBOL_ip6_addr = 141,                 /* ip6_addr  */
  YYSYMBOL_142_ = 142,                     /* '='  */
  YYSYMBOL_YYACCEPT = 143,                 /* $accept  */
  YYSYMBOL_packets = 144,                  /* packets  */
  YYSYMBOL_inline_comment = 145,           /* inline_comment  */
  YYSYMBOL_cpu_delim = 146,                /* cpu_delim  */
  YYSYMBOL_delimiter_nowhite = 147,        /* delimiter_nowhite  */
  YYSYMBOL_noenforce_white = 148,          /* noenforce_white  */
  YYSYMBOL_skip_white = 149,               /* skip_white  */
  YYSYMBOL_packet = 150,                   /* packet  */
  YYSYMBOL_payload = 151,                  /* payload  */
  YYSYMBOL_delimiter = 152,                /* delimiter  */
  YYSYMBOL_elem_delimiter = 153,           /* elem_delimiter  */
  YYSYMBOL_elem = 154,                     /* elem  */
  YYSYMBOL_expression = 155,               /* expression  */
  YYSYMBOL_fill = 156,                     /* fill  */
  YYSYMBOL_const = 157,                    /* const  */
  YYSYMBOL_rnd = 158,                      /* rnd  */
  YYSYMBOL_csum = 159,                     /* csum  */
  YYSYMBOL_seqinc = 160,                   /* seqinc  */
  YYSYMBOL_seqdec = 161,                   /* seqdec  */
  YYSYMBOL_drnd = 162,                     /* drnd  */
  YYSYMBOL_dinc = 163,                     /* dinc  */
  YYSYMBOL_ddec = 164,                     /* ddec  */
  YYSYMBOL_proto = 165,                    /* proto  */
  YYSYMBOL_field_expr = 166,               /* field_expr  */
  YYSYMBOL_field_value_expr = 167,         /* field_value_expr  */
  YYSYMBOL_eth_proto = 168,                /* eth_proto  */
  YYSYMBOL_eth = 169,                      /* eth  */
  YYSYMBOL_eth_param_list = 170,           /* eth_param_list  */
  YYSYMBOL_eth_type = 171,                 /* eth_type  */
  YYSYMBOL_eth_field = 172,                /* eth_field  */
  YYSYMBOL_eth_expr = 173,                 /* eth_expr  */
  YYSYMBOL_pause_proto = 174,              /* pause_proto  */
  YYSYMBOL_pause = 175,                    /* pause  */
  YYSYMBOL_pause_param_list = 176,         /* pause_param_list  */
  YYSYMBOL_pause_field = 177,              /* pause_field  */
  YYSYMBOL_pause_expr = 178,               /* pause_expr  */
  YYSYMBOL_pfc_proto = 179,                /* pfc_proto  */
  YYSYMBOL_pfc = 180,                      /* pfc  */
  YYSYMBOL_pfc_param_list = 181,           /* pfc_param_list  */
  YYSYMBOL_pfc_field = 182,                /* pfc_field  */
  YYSYMBOL_pfc_expr = 183,                 /* pfc_expr  */
  YYSYMBOL_vlan_proto = 184,               /* vlan_proto  */
  YYSYMBOL_vlan = 185,                     /* vlan  */
  YYSYMBOL_vlan_param_list = 186,          /* vlan_param_list  */
  YYSYMBOL_vlan_type = 187,                /* vlan_type  */
  YYSYMBOL_vlan_field = 188,               /* vlan_field  */
  YYSYMBOL_vlan_expr = 189,                /* vlan_expr  */
  YYSYMBOL_mpls_proto = 190,               /* mpls_proto  */
  YYSYMBOL_mpls = 191,                     /* mpls  */
  YYSYMBOL_mpls_param_list = 192,          /* mpls_param_list  */
  YYSYMBOL_mpls_tc = 193,                  /* mpls_tc  */
  YYSYMBOL_mpls_field = 194,               /* mpls_field  */
  YYSYMBOL_mpls_expr = 195,                /* mpls_expr  */
  YYSYMBOL_arp_proto = 196,                /* arp_proto  */
  YYSYMBOL_arp_param_list = 197,           /* arp_param_list  */
  YYSYMBOL_arp_field = 198,                /* arp_field  */
  YYSYMBOL_arp_expr = 199,                 /* arp_expr  */
  YYSYMBOL_arp = 200,                      /* arp  */
  YYSYMBOL_ip4_proto = 201,                /* ip4_proto  */
  YYSYMBOL_ip4_param_list = 202,           /* ip4_param_list  */
  YYSYMBOL_ip4_field = 203,                /* ip4_field  */
  YYSYMBOL_ip4_expr = 204,                 /* ip4_expr  */
  YYSYMBOL_ip4 = 205,                      /* ip4  */
  YYSYMBOL_ip6_proto = 206,                /* ip6_proto  */
  YYSYMBOL_ip6_param_list = 207,           /* ip6_param_list  */
  YYSYMBOL_ip6_hop_limit = 208,            /* ip6_hop_limit  */
  YYSYMBOL_ip6_field = 209,                /* ip6_field  */
  YYSYMBOL_ip6_expr = 210,                 /* ip6_expr  */
  YYSYMBOL_ip6 = 211,                      /* ip6  */
  YYSYMBOL_icmp4_proto = 212,              /* icmp4_proto  */
  YYSYMBOL_icmp4_param_list = 213,         /* icmp4_param_list  */
  YYSYMBOL_icmp4_field = 214,              /* icmp4_field  */
  YYSYMBOL_icmp4_expr = 215,               /* icmp4_expr  */
  YYSYMBOL_icmp4 = 216,                    /* icmp4  */
  YYSYMBOL_icmpv6_proto = 217,             /* icmpv6_proto  */
  YYSYMBOL_icmp6_param_list = 218,         /* icmp6_param_list  */
  YYSYMBOL_icmp6_field = 219,              /* icmp6_field  */
  YYSYMBOL_icmp6_expr = 220,               /* icmp6_expr  */
  YYSYMBOL_icmp6 = 221,                    /* icmp6  */
  YYSYMBOL_udp_proto = 222,                /* udp_proto  */
  YYSYMBOL_udp_param_list = 223,           /* udp_param_list  */
  YYSYMBOL_udp_field = 224,                /* udp_field  */
  YYSYMBOL_udp_expr = 225,                 /* udp_expr  */
  YYSYMBOL_udp = 226,                      /* udp  */
  YYSYMBOL_tcp_proto = 227,                /* tcp_proto  */
  YYSYMBOL_tcp_param_list = 228,           /* tcp_param_list  */
  YYSYMBOL_tcp_field = 229,                /* tcp_field  */
  YYSYMBOL_tcp_expr = 230,                 /* tcp_expr  */
  YYSYMBOL_tcp = 231,                      /* tcp  */
  YYSYMBOL_dns_proto = 232,                /* dns_proto  */
  YYSYMBOL_dns_param_list = 233,           /* dns_param_list  */
  YYSYMBOL_dns_field = 234,                /* dns_field  */
  YYSYMBOL_dns_query = 235,                /* dns_query  */
  YYSYMBOL_dns_query_name = 236,           /* dns_query_name  */
  YYSYMBOL_dns_query_field = 237,          /* dns_query_field  */
  YYSYMBOL_dns_query_expr = 238,           /* dns_query_expr  */
  YYSYMBOL_dns_query_param_list = 239,     /* dns_query_param_list  */
  YYSYMBOL_dns_query_hdr = 240,            /* dns_query_hdr  */
  YYSYMBOL_dns_rrecord = 241,              /* dns_rrecord  */
  YYSYMBOL_dns_rrecord_name = 242,         /* dns_rrecord_name  */
  YYSYMBOL_dns_rrecord_data_addr = 243,    /* dns_rrecord_data_addr  */
  YYSYMBOL_dns_rrecord_data_fqdn = 244,    /* dns_rrecord_data_fqdn  */
  YYSYMBOL_dns_rrecord_data_expr = 245,    /* dns_rrecord_data_expr  */
  YYSYMBOL_dns_rrecord_field = 246,        /* dns_rrecord_field  */
  YYSYMBOL_dns_rrecord_expr = 247,         /* dns_rrecord_expr  */
  YYSYMBOL_dns_rrecord_param_list = 248,   /* dns_rrecord_param_list  */
  YYSYMBOL_dns_rrecord_hdr = 249,          /* dns_rrecord_hdr  */
  YYSYMBOL_dns_expr = 250,                 /* dns_expr  */
  YYSYMBOL_dns = 251                       /* dns  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if !defined yyoverflow

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* !defined yyoverflow */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  2
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   835

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  143
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  109
/* YYNRULES -- Number of rules.  */
#define YYNRULES  341
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  704

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   378


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   131,   132,     2,
     122,   123,   129,   128,   119,   127,     2,   130,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   126,     2,
     134,   142,   135,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   124,     2,   125,   136,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   120,   133,   121,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   137,   138,   139,   140,   141
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   563,   563,   564,   565,   566,   570,   574,   575,   579,
     580,   584,   585,   586,   590,   591,   594,   601,   616,   626,
     627,   631,   632,   636,   640,   641,   642,   643,   644,   645,
     646,   647,   648,   649,   650,   651,   652,   656,   658,   660,
     662,   664,   666,   668,   670,   672,   674,   676,   678,   680,
     685,   690,   692,   697,   702,   710,   715,   717,   719,   721,
     723,   725,   730,   732,   737,   739,   744,   746,   755,   757,
     762,   764,   769,   770,   771,   772,   773,   774,   775,   776,
     777,   778,   779,   780,   781,   785,   790,   798,   800,   802,
     805,   807,   809,   812,   816,   823,   830,   832,   840,   844,
     848,   849,   850,   854,   855,   856,   860,   861,   862,   865,
     867,   872,   876,   880,   881,   882,   886,   887,   891,   893,
     898,   902,   906,   907,   908,   912,   913,   914,   920,   929,
     931,   936,   940,   944,   945,   946,   950,   951,   955,   956,
     957,   958,   959,   963,   965,   967,   969,   974,   978,   982,
     983,   984,   988,   989,   993,   994,   995,   996,  1000,  1002,
    1007,  1011,  1012,  1013,  1017,  1019,  1021,  1023,  1025,  1027,
    1032,  1034,  1036,  1039,  1042,  1044,  1046,  1048,  1053,  1057,
    1061,  1062,  1063,  1067,  1068,  1069,  1070,  1071,  1072,  1073,
    1074,  1075,  1076,  1077,  1078,  1079,  1080,  1084,  1086,  1088,
    1089,  1093,  1097,  1101,  1102,  1103,  1107,  1108,  1112,  1113,
    1114,  1115,  1116,  1117,  1118,  1119,  1123,  1125,  1130,  1134,
    1138,  1139,  1140,  1144,  1145,  1146,  1147,  1148,  1149,  1153,
    1155,  1157,  1160,  1166,  1170,  1174,  1175,  1176,  1180,  1181,
    1185,  1187,  1189,  1192,  1195,  1197,  1199,  1201,  1205,  1209,
    1213,  1214,  1215,  1219,  1220,  1221,  1222,  1226,  1228,  1233,
    1237,  1241,  1242,  1243,  1247,  1248,  1249,  1250,  1251,  1252,
    1253,  1254,  1258,  1260,  1262,  1263,  1264,  1265,  1266,  1267,
    1268,  1269,  1273,  1277,  1281,  1282,  1283,  1287,  1288,  1289,
    1290,  1291,  1292,  1293,  1294,  1295,  1296,  1297,  1298,  1299,
    1303,  1307,  1311,  1312,  1316,  1318,  1320,  1324,  1331,  1332,
    1333,  1337,  1341,  1342,  1343,  1347,  1351,  1354,  1360,  1371,
    1373,  1375,  1377,  1382,  1383,  1384,  1385,  1386,  1390,  1392,
    1394,  1398,  1402,  1407,  1408,  1409,  1413,  1417,  1419,  1421,
    1422,  1426
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if YYDEBUG || 0
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "K_COMMENT", "K_FILL",
  "K_RND", "K_SEQINC", "K_SEQDEC", "K_DRND", "K_DINC", "K_DDEC", "K_WHITE",
  "K_CPU", "K_CSUMIP", "K_CSUMUDP", "K_CSUMTCP", "K_CSUMUDP6",
  "K_CSUMTCP6", "K_CSUMICMP6", "K_CONST8", "K_CONST16", "K_CONST32",
  "K_CONST64", "K_DADDR", "K_SADDR", "K_ETYPE", "K_TYPE", "K_TIME",
  "K_PRIO", "K_OPER", "K_SHA", "K_SPA", "K_THA", "K_TPA", "K_REQUEST",
  "K_REPLY", "K_PTYPE", "K_HTYPE", "K_PROT", "K_TTL", "K_DSCP", "K_ECN",
  "K_TOS", "K_LEN", "K_ID", "K_FLAGS", "K_FRAG", "K_IHL", "K_VER",
  "K_CSUM", "K_DF", "K_MF", "K_FLOW", "K_NEXT_HDR", "K_HOP_LIMIT",
  "K_CODE", "K_ECHO_REQUEST", "K_ECHO_REPLY", "K_SPORT", "K_DPORT",
  "K_SEQ", "K_ACK_SEQ", "K_DOFF", "K_CWR", "K_ECE", "K_URG", "K_ACK",
  "K_PSH", "K_RST", "K_SYN", "K_FIN", "K_WINDOW", "K_URG_PTR", "K_TPID",
  "K_TCI", "K_PCP", "K_DEI", "K_1Q", "K_1AD", "K_LABEL", "K_TC", "K_LAST",
  "K_EXP", "K_ADDR", "K_MTU", "K_QR", "K_AANSWER", "K_TRUNC", "K_RAVAIL",
  "K_RDESIRED", "K_ZERO", "K_RCODE", "K_QDCOUNT", "K_ANCOUNT", "K_NSCOUNT",
  "K_ARCOUNT", "K_QUERY", "K_ANSWER", "K_AUTH", "K_ADD", "K_NAME",
  "K_CLASS", "K_DATA", "K_NS", "K_CNAME", "K_PTR", "K_ETH", "K_PAUSE",
  "K_PFC", "K_VLAN", "K_MPLS", "K_ARP", "K_IP4", "K_IP6", "K_ICMP4",
  "K_ICMP6", "K_UDP", "K_TCP", "K_DNS", "','", "'{'", "'}'", "'('", "')'",
  "'['", "']'", "':'", "'-'", "'+'", "'*'", "'/'", "'%'", "'&'", "'|'",
  "'<'", "'>'", "'^'", "number", "string", "mac", "ip4_addr", "ip6_addr",
  "'='", "$accept", "packets", "inline_comment", "cpu_delim",
  "delimiter_nowhite", "noenforce_white", "skip_white", "packet",
  "payload", "delimiter", "elem_delimiter", "elem", "expression", "fill",
  "const", "rnd", "csum", "seqinc", "seqdec", "drnd", "dinc", "ddec",
  "proto", "field_expr", "field_value_expr", "eth_proto", "eth",
  "eth_param_list", "eth_type", "eth_field", "eth_expr", "pause_proto",
  "pause", "pause_param_list", "pause_field", "pause_expr", "pfc_proto",
  "pfc", "pfc_param_list", "pfc_field", "pfc_expr", "vlan_proto", "vlan",
  "vlan_param_list", "vlan_type", "vlan_field", "vlan_expr", "mpls_proto",
  "mpls", "mpls_param_list", "mpls_tc", "mpls_field", "mpls_expr",
  "arp_proto", "arp_param_list", "arp_field", "arp_expr", "arp",
  "ip4_proto", "ip4_param_list", "ip4_field", "ip4_expr", "ip4",
  "ip6_proto", "ip6_param_list", "ip6_hop_limit", "ip6_field", "ip6_expr",
  "ip6", "icmp4_proto", "icmp4_param_list", "icmp4_field", "icmp4_expr",
  "icmp4", "icmpv6_proto", "icmp6_param_list", "icmp6_field", "icmp6_expr",
  "icmp6", "udp_proto", "udp_param_list", "udp_field", "udp_expr", "udp",
  "tcp_proto", "tcp_param_list", "tcp_field", "tcp_expr", "tcp",
  "dns_proto", "dns_param_list", "dns_field", "dns_query",
  "dns_query_name", "dns_query_field", "dns_query_expr",
  "dns_query_param_list", "dns_query_hdr", "dns_rrecord",
  "dns_rrecord_name", "dns_rrecord_data_addr", "dns_rrecord_data_fqdn",
  "dns_rrecord_data_expr", "dns_rrecord_field", "dns_rrecord_expr",
  "dns_rrecord_param_list", "dns_rrecord_hdr", "dns_expr", "dns", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-507)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-14)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
    -507,    19,  -507,  -507,  -507,   -95,    -3,  -507,  -507,   -98,
    -507,    46,  -507,   697,   -79,  -507,   -47,   -28,   -25,   -17,
      -8,     3,     5,    14,    26,    29,    41,    50,    51,    54,
      56,    60,    64,  -507,  -507,  -507,  -507,  -507,  -507,  -507,
    -507,  -507,  -507,  -507,  -507,  -507,  -507,  -507,  -507,     7,
    -507,  -507,  -507,  -507,  -507,  -507,  -507,  -507,  -507,  -507,
    -507,  -507,    65,  -507,    67,  -507,    70,  -507,    71,  -507,
      76,  -507,    77,  -507,    78,  -507,    79,  -507,    80,  -507,
      82,  -507,    84,  -507,    87,  -507,    88,   -13,  -507,  -507,
     -18,     1,    81,    86,    95,   -71,    96,    97,    98,    99,
     100,   101,   103,   104,   -19,   -19,   -19,   -19,    93,    94,
     122,   697,  -507,    66,   -22,    22,   153,     6,   231,   603,
     131,    16,    25,    10,   516,   431,    -3,    24,    12,   102,
      12,    12,  -507,   128,    12,    12,    12,    12,    12,    12,
      12,    12,   -19,   -19,  -507,   228,   290,   307,   376,  -507,
    -507,  -507,  -507,  -507,  -507,  -507,   132,  -507,    -9,    12,
    -507,  -507,   133,    -9,    12,   135,   136,  -507,   152,    -9,
      12,  -507,  -507,  -507,  -507,  -507,  -507,  -507,  -507,   154,
    -507,    -9,    12,  -507,  -507,  -507,  -507,  -507,   155,  -507,
      -9,    12,    -9,  -507,  -507,  -507,  -507,  -507,  -507,  -507,
    -507,   161,    -9,    12,  -507,  -507,  -507,  -507,  -507,  -507,
    -507,  -507,  -507,  -507,  -507,  -507,  -507,  -507,  -507,  -507,
     163,    -9,    12,  -507,  -507,  -507,  -507,  -507,  -507,  -507,
    -507,  -507,   164,  -507,    -9,    12,  -507,  -507,  -507,  -507,
    -507,  -507,  -507,  -507,   165,    -9,    12,    -9,  -507,  -507,
    -507,  -507,   167,    -9,    12,  -507,  -507,  -507,  -507,   168,
      -9,    12,  -507,  -507,  -507,  -507,  -507,  -507,  -507,  -507,
    -507,  -507,  -507,  -507,  -507,  -507,  -507,  -507,   170,    -9,
      12,  -507,  -507,  -507,  -507,  -507,  -507,  -507,  -507,  -507,
    -507,  -507,  -507,  -507,  -507,  -507,  -507,  -507,   171,    -9,
     174,  -507,   175,  -507,    12,   134,    17,  -507,  -507,   139,
    -507,   173,   177,  -507,   178,   179,   181,   182,   183,   185,
     186,   188,   532,  -507,  -507,   -19,   -19,   -19,   -19,   -19,
     -19,   -19,    83,    89,   -19,  -507,  -507,  -507,  -507,  -507,
     205,   150,   205,    66,  -507,   156,   205,   -22,   189,   191,
    -507,   158,   205,    22,  -507,   159,   205,   153,  -507,   160,
     205,     6,   162,   205,  -507,   166,   205,   231,  -507,   187,
     205,   603,  -507,   190,   205,   131,  -507,   192,   205,    16,
     194,   205,  -507,   195,   205,    25,  -507,   196,   205,    10,
    -507,   200,   205,   516,  -507,   201,   205,    -5,   169,   431,
      -3,    -3,   184,    -2,     9,    21,    23,   207,   210,   221,
     222,   223,   224,  -507,  -507,  -507,  -507,  -507,  -507,  -507,
    -507,   -19,   -19,  -507,   211,   205,   212,  -507,   205,   225,
    -507,   226,   243,   205,   227,  -507,   205,   230,  -507,   205,
     232,  -507,   205,   233,   205,   235,  -507,   205,   236,  -507,
     205,   238,  -507,   205,   239,  -507,    27,   241,   205,   242,
    -507,   205,   244,  -507,   205,   246,  -507,   205,   247,  -507,
    -507,  -507,    -9,    -9,    12,   250,  -507,  -507,  -507,   248,
    -507,  -507,  -507,   269,   270,   275,    -9,  -507,    -9,    12,
     277,  -507,   697,   278,  -507,  -507,   265,  -507,   266,  -507,
     268,  -507,   271,  -507,  -507,  -507,  -507,  -507,  -507,  -507,
    -507,   205,    28,   205,    28,   205,  -507,  -507,    28,   205,
      28,   205,    28,   205,    20,   205,    28,   205,    28,   205,
      28,   205,    28,   205,  -507,  -507,    28,   205,    28,   205,
      28,   205,    28,   205,    28,   205,   264,   205,   267,   205,
      -5,  -507,   205,   205,   205,   205,   272,   205,   285,   205,
     169,  -507,     7,    -3,   288,   289,   305,   321,   -61,   323,
     325,  -507,  -507,  -507,  -507,  -507,  -507,    28,  -507,    28,
    -507,    28,  -507,    28,  -507,    28,  -507,  -507,  -507,    28,
    -507,    28,  -507,    28,  -507,    28,  -507,    28,  -507,    28,
    -507,    28,  -507,    28,  -507,    28,  -507,    28,   205,   308,
     205,   309,  -507,   -39,   311,   311,   311,   205,   310,   205,
     313,  -507,   332,   697,  -507,  -507,  -507,  -507,  -507,   205,
     -67,   -30,  -507,  -507,  -507,  -507,  -507,  -507,  -507,  -507,
    -507,  -507,  -507,  -507,  -507,  -507,  -507,    28,   205,    28,
     205,  -507,  -507,   205,  -507,   205,   205,   205,    28,   205,
      28,   205,  -507,     7,   320,  -507,    12,  -507,    30,  -507,
      28,  -507,    28,   336,   338,   340,   342,  -507,    28,  -507,
      28,   346,   205,   334,  -507,   341,  -507,  -507,  -507,  -507,
    -507,  -507,  -507,  -507,  -507,   180,   350,    52,  -507,  -507,
    -507,   344,   354,  -507
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int16 yydefact[] =
{
       2,     0,     1,     6,     5,     0,    11,     4,     3,     0,
      12,     9,    13,     0,     0,    10,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    99,   112,   121,   132,   148,   178,   201,
     218,   233,   248,   259,   282,   341,    24,    25,    36,    11,
      19,    26,    34,    27,    33,    29,    30,    28,    31,    32,
      35,    72,     0,    73,     0,    74,     0,    75,     0,    76,
       0,    77,     0,    78,     0,    79,     0,    80,     0,    81,
       0,    82,     0,    83,     0,    84,     0,     0,     7,     8,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    22,    21,
       0,     0,    20,   100,   113,   122,   133,   149,   161,   180,
     203,   220,   235,   250,   261,   284,    11,     0,     0,     0,
       0,     0,    66,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    37,     0,     0,     0,     0,    16,
      23,   106,   107,   103,   104,   105,     0,   108,    14,   101,
     117,   116,     0,    14,   114,     0,   126,   125,     0,    14,
     123,   137,   142,   136,   139,   140,   141,   145,   146,     0,
     138,    14,   134,   157,   154,   152,   156,   153,     0,   155,
      14,   150,    14,   166,   168,   167,   169,   176,   177,   165,
     164,     0,    14,   162,   185,   186,   187,   188,   189,   190,
     191,   192,   193,   194,   195,   184,   183,   196,   199,   200,
       0,    14,   181,   215,   214,   207,   211,   208,   210,   212,
     206,   209,     0,   213,    14,   204,   223,   225,   224,   231,
     232,   226,   228,   227,     0,    14,   221,    14,   239,   238,
     245,   247,     0,    14,   236,   255,   256,   253,   254,     0,
      14,   251,   270,   264,   265,   266,   267,   268,   274,   275,
     276,   277,   278,   279,   280,   281,   269,   271,     0,    14,
     262,   289,   287,   288,   290,   291,   293,   292,   294,   295,
     296,   297,   298,   299,   300,   312,   313,   314,     0,    14,
       0,   339,     0,   340,   285,     0,     0,    22,    21,     0,
      55,     0,     0,    67,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    48,    51,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    52,    53,    54,    98,    15,
      14,     0,    14,   100,   111,     0,    14,   113,     0,     0,
     120,     0,    14,   122,   131,     0,    14,   133,   147,     0,
      14,   149,     0,    14,   160,     0,    14,   161,   179,     0,
      14,   180,   202,     0,    14,   203,   219,     0,    14,   220,
       0,    14,   234,     0,    14,   235,   249,     0,    14,   250,
     260,     0,    14,   261,   283,     0,    14,   308,   333,   284,
      11,    11,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    49,    39,    38,    40,    41,    42,    43,
      44,     0,     0,    45,     0,    14,     0,   102,    14,     0,
     115,     0,     0,    14,     0,   124,    14,     0,   135,    14,
       0,   151,    14,     0,    14,     0,   163,    14,     0,   182,
      14,     0,   205,    14,     0,   222,    14,     0,    14,     0,
     237,    14,     0,   252,    14,     0,   263,    14,     0,   302,
     301,   303,    14,    14,   309,     0,   323,   325,   326,     0,
     315,   324,   327,     0,     0,     0,    14,   332,    14,   334,
       0,   286,     0,     0,    50,    62,     0,    64,     0,    68,
       0,    70,     0,    56,    58,    57,    60,    59,    61,    46,
      47,    14,     0,    14,     0,    14,   128,   127,     0,    14,
       0,    14,     0,    14,     0,    14,     0,    14,     0,    14,
       0,    14,     0,    14,   244,   246,     0,    14,     0,    14,
       0,    14,     0,    14,     0,    14,     0,    14,     0,    14,
     308,   311,    14,    14,    14,    14,     0,    14,     0,    14,
     333,   336,    11,    11,     0,     0,     0,     0,     0,     0,
       0,    87,    89,    88,    90,    91,   110,     0,   119,     0,
     130,     0,   144,     0,   159,     0,   174,   175,   173,     0,
     171,     0,   198,     0,   217,     0,   230,     0,   243,     0,
     241,     0,   258,     0,   273,     0,   338,     0,    14,     0,
      14,     0,   310,     0,     0,     0,     0,    14,     0,    14,
       0,   335,     0,     0,    63,    65,    69,    71,    85,    14,
       0,     0,   109,   118,   129,   143,   158,   172,   170,   197,
     216,   229,   242,   240,   257,   272,   337,     0,    14,     0,
      14,   316,   317,    14,   318,    14,    14,    14,     0,    14,
       0,    14,    18,    11,     0,    96,     0,    92,     0,   307,
       0,   305,     0,     0,     0,     0,     0,   331,     0,   329,
       0,     0,    14,     0,    93,     0,   306,   304,   319,   320,
     321,   322,   330,   328,    17,     0,     0,     0,    86,    97,
      94,     0,     0,    95
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -507,  -507,   218,  -507,    -6,   -48,   -57,  -507,  -489,  -124,
    -507,   110,   -81,  -507,  -507,  -507,  -507,  -507,  -507,  -507,
    -507,  -507,  -507,   -40,    92,  -507,  -507,   -32,  -507,  -507,
    -507,  -507,  -507,   -35,  -507,  -507,  -507,  -507,   116,  -507,
    -507,  -507,  -507,   126,  -507,  -507,  -507,  -507,  -507,   118,
    -507,  -507,  -507,  -507,   120,  -507,  -507,  -507,  -507,   114,
    -507,  -507,  -507,  -507,   119,  -507,  -507,  -507,  -507,  -507,
     112,  -507,  -507,  -507,  -507,   108,  -507,  -507,  -507,  -507,
     124,  -507,  -507,  -507,  -507,   138,  -507,  -507,  -507,  -507,
      90,  -507,  -507,  -507,  -507,  -507,   -49,  -507,  -507,  -507,
    -507,  -506,  -507,  -507,  -507,   -27,  -507,  -507,  -507
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,     1,    48,    90,   308,    13,   341,     8,    49,   111,
     112,    50,   145,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,   342,   576,    61,    62,   156,   157,   158,
     159,    63,    64,   162,   163,   164,    65,    66,   168,   169,
     170,    67,    68,   179,   180,   181,   182,    69,    70,   188,
     189,   190,   191,    71,   201,   202,   203,    72,    73,   220,
     221,   222,    74,    75,   232,   233,   234,   235,    76,    77,
     244,   245,   246,    78,    79,   252,   253,   254,    80,    81,
     259,   260,   261,    82,    83,   278,   279,   280,    84,    85,
     298,   299,   300,   472,   473,   474,   475,   301,   302,   486,
     653,   655,   487,   488,   489,   490,   303,   304,    86
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
      12,   110,   339,   562,   309,   160,   311,   312,    10,   307,
     314,   315,   316,   317,   318,   319,   320,   321,   108,     2,
     307,   469,     3,   307,   146,   147,   148,     9,   569,   570,
       4,     5,   307,   161,   307,   343,   569,   570,   339,    14,
     347,   307,   236,   109,    87,   183,   353,    88,    89,   165,
     166,   247,   132,   255,   586,   587,   665,    15,   357,   256,
     237,   322,   323,   307,   628,   629,   133,   361,   257,   258,
     666,   238,   239,   240,   248,    91,   241,   167,   305,   367,
     249,   250,   251,   534,   535,   184,   185,   186,   187,   151,
     152,   153,   154,   667,    92,   470,   471,    93,   371,   242,
     243,   651,   652,   142,   155,    94,   345,   668,   143,   656,
     657,   375,   351,   126,    95,   340,    11,    11,   144,   127,
      12,   495,   379,   346,   355,    96,    11,    97,    11,   352,
     385,    11,   497,   359,   663,   362,    98,   389,   128,     6,
      11,   356,    11,   401,   499,   365,   501,   306,    99,    11,
     360,   100,   363,   684,   223,   224,   393,   571,   572,   573,
     574,   575,   366,   101,   369,   571,   572,   573,   574,   575,
     225,    11,   102,   103,   226,   700,   104,   373,   105,   227,
     399,   370,   106,   228,   229,   230,   107,   113,   377,   114,
     380,   171,   115,   116,   374,   476,   383,   172,   117,   118,
     119,   120,   121,   387,   122,   378,   123,   381,   477,   124,
     125,   231,   478,   384,   -12,   -13,   339,   421,   129,     7,
     388,   150,   391,   130,   422,   310,   173,   174,   175,   176,
     177,   178,   131,   134,   135,   136,   137,   138,   139,   392,
     140,   141,   395,   149,   414,   415,   416,   417,   418,   419,
     420,   313,   479,   423,   400,   338,   344,   348,   349,   396,
     192,   193,   194,   195,   196,   197,   198,   199,   200,   480,
     481,   482,   483,   484,   485,   350,   402,   354,   358,   496,
     498,   500,   502,   424,   364,   426,   368,   372,   376,   429,
     382,   386,   425,   390,   394,   434,   397,   398,   428,   437,
     433,   436,   439,   440,   442,   698,   443,   494,   444,   445,
     403,   427,   430,   448,   404,   405,   406,   451,   407,   408,
     409,   454,   410,   411,   457,   412,   431,   459,   432,   447,
     503,   462,   450,   504,   453,   465,   456,   458,   461,   468,
     509,   510,   464,   467,   505,   506,   507,   508,   511,   516,
     550,   324,   492,   493,   513,   325,   326,   327,   328,   329,
     330,   331,   332,   333,   334,   560,   517,   515,   512,   519,
     552,   514,   521,   551,   523,   525,   518,   527,   529,   520,
     531,   533,   522,   537,   539,   524,   541,   526,   543,   545,
     528,   553,   554,   530,    12,    12,   532,   555,   563,   536,
     561,   538,   564,   565,   540,   566,   608,   542,   567,   610,
     544,   624,   625,   335,   617,   546,   548,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   619,   626,   556,
     336,   558,   547,   549,   325,   326,   327,   328,   329,   330,
     331,   332,   333,   334,   627,   630,   557,   631,   559,   654,
     648,   650,   659,   662,   568,   661,   577,   682,   579,   688,
     281,   689,   581,   690,   583,   691,   585,   694,   589,   435,
     591,   696,   593,   699,   595,   282,   597,   703,   697,   441,
     599,   702,   601,   438,   603,   449,   605,   446,   607,   491,
     609,   455,   611,   460,   452,   613,   614,   615,   616,   337,
     618,   612,   620,   325,   326,   327,   328,   329,   330,   331,
     332,   333,   334,   463,   622,   623,   283,   284,   285,   286,
     287,   288,   289,   290,   291,   292,   293,   294,   295,   296,
     297,   466,     0,   621,     0,     0,     0,     0,     0,     0,
       0,     0,   683,     0,   685,     0,     0,     0,     0,     0,
       0,   647,     0,   649,     0,     0,   109,    12,     0,     0,
     658,     0,   660,     0,     0,   262,     0,     0,     0,     0,
       0,     0,   664,   701,   263,   264,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,     0,
       0,   670,     0,   672,     0,     0,   673,     0,   674,   675,
     676,     0,   678,     0,   680,     0,   578,     0,     0,     0,
     580,     0,   582,     0,   584,   681,   588,     0,   590,     0,
     592,     0,   594,     0,   596,   695,   204,   205,   598,     0,
     600,     0,   602,     0,   604,     0,   606,     0,     0,     0,
       0,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   413,     0,   109,     0,   325,
     326,   327,   328,   329,   330,   331,   332,   333,   334,   632,
       0,   633,     0,   634,     0,   635,     0,   636,     0,     0,
       0,   637,     0,   638,     0,   639,     0,   640,     0,   641,
       0,   642,     0,   643,     0,   644,     0,   645,     0,   646,
       3,    16,    17,    18,    19,    20,    21,    22,     0,     0,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   669,
       0,   671,     0,     0,     0,     0,     0,     0,     0,     0,
     677,     0,   679,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   686,     0,   687,     0,     0,     0,     0,     0,
     692,     0,   693,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    33,    34,    35,    36,    37,    38,    39,
      40,    41,    42,    43,    44,    45,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    46,    47
};

static const yytype_int16 yycheck[] =
{
       6,    49,    11,   492,   128,    27,   130,   131,    11,    11,
     134,   135,   136,   137,   138,   139,   140,   141,    11,     0,
      11,    26,     3,    11,   105,   106,   107,   122,     8,     9,
      11,    12,    11,    55,    11,   159,     8,     9,    11,   137,
     164,    11,    26,    49,   123,    39,   170,   126,   127,    27,
      28,    26,   123,    43,    34,    35,   123,    11,   182,    49,
      44,   142,   143,    11,   125,   126,   137,   191,    58,    59,
     137,    55,    56,    57,    49,   122,    60,    55,   126,   203,
      55,    56,    57,    56,    57,    79,    80,    81,    82,    23,
      24,    25,    26,   123,   122,   100,   101,   122,   222,    83,
      84,   140,   141,   122,    38,   122,   163,   137,   127,   615,
     616,   235,   169,   126,   122,   124,   119,   119,   137,   137,
     126,   123,   246,   163,   181,   122,   119,   122,   119,   169,
     254,   119,   123,   190,   623,   192,   122,   261,   137,   120,
     119,   181,   119,   126,   123,   202,   123,   123,   122,   119,
     190,   122,   192,   123,    23,    24,   280,   137,   138,   139,
     140,   141,   202,   122,   221,   137,   138,   139,   140,   141,
      39,   119,   122,   122,    43,   123,   122,   234,   122,    48,
     304,   221,   122,    52,    53,    54,   122,   122,   245,   122,
     247,    38,   122,   122,   234,    26,   253,    44,   122,   122,
     122,   122,   122,   260,   122,   245,   122,   247,    39,   122,
     122,    80,    43,   253,   121,   121,    11,   134,   137,     1,
     260,   111,   279,   137,   135,   123,    73,    74,    75,    76,
      77,    78,   137,   137,   137,   137,   137,   137,   137,   279,
     137,   137,   299,   121,   325,   326,   327,   328,   329,   330,
     331,   123,    83,   334,   120,   123,   123,   122,   122,   299,
      29,    30,    31,    32,    33,    34,    35,    36,    37,   100,
     101,   102,   103,   104,   105,   123,   137,   123,   123,   403,
     404,   405,   406,   340,   123,   342,   123,   123,   123,   346,
     123,   123,   142,   123,   123,   352,   122,   122,   142,   356,
     142,   142,   142,   360,   142,   125,   363,   123,   142,   366,
     137,   343,   347,   370,   137,   137,   137,   374,   137,   137,
     137,   378,   137,   137,   381,   137,   137,   384,   137,   142,
     123,   388,   142,   123,   142,   392,   142,   142,   142,   396,
     421,   422,   142,   142,   123,   123,   123,   123,   137,   123,
     474,   123,   400,   401,   142,   127,   128,   129,   130,   131,
     132,   133,   134,   135,   136,   489,   123,   142,   425,   142,
     122,   428,   142,   123,   142,   142,   433,   142,   142,   436,
     142,   142,   439,   142,   142,   442,   142,   444,   142,   142,
     447,   122,   122,   450,   400,   401,   453,   122,   120,   456,
     123,   458,   137,   137,   461,   137,   142,   464,   137,   142,
     467,   123,   123,   123,   142,   472,   473,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   142,   123,   486,
     123,   488,   472,   473,   127,   128,   129,   130,   131,   132,
     133,   134,   135,   136,   123,   122,   486,   122,   488,   138,
     142,   142,   142,   121,   511,   142,   513,   137,   515,   123,
      29,   123,   519,   123,   521,   123,   523,   121,   525,   353,
     527,   137,   529,   123,   531,    44,   533,   123,   137,   361,
     537,   137,   539,   357,   541,   371,   543,   367,   545,   399,
     547,   379,   549,   385,   375,   552,   553,   554,   555,   123,
     557,   550,   559,   127,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   389,   562,   563,    85,    86,    87,    88,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    98,
      99,   393,    -1,   560,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   666,    -1,   668,    -1,    -1,    -1,    -1,    -1,
      -1,   608,    -1,   610,    -1,    -1,   562,   563,    -1,    -1,
     617,    -1,   619,    -1,    -1,    49,    -1,    -1,    -1,    -1,
      -1,    -1,   629,   697,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    -1,
      -1,   648,    -1,   650,    -1,    -1,   653,    -1,   655,   656,
     657,    -1,   659,    -1,   661,    -1,   514,    -1,    -1,    -1,
     518,    -1,   520,    -1,   522,   663,   524,    -1,   526,    -1,
     528,    -1,   530,    -1,   532,   682,    23,    24,   536,    -1,
     538,    -1,   540,    -1,   542,    -1,   544,    -1,    -1,    -1,
      -1,    38,    39,    40,    41,    42,    43,    44,    45,    46,
      47,    48,    49,    50,    51,   123,    -1,   663,    -1,   127,
     128,   129,   130,   131,   132,   133,   134,   135,   136,   577,
      -1,   579,    -1,   581,    -1,   583,    -1,   585,    -1,    -1,
      -1,   589,    -1,   591,    -1,   593,    -1,   595,    -1,   597,
      -1,   599,    -1,   601,    -1,   603,    -1,   605,    -1,   607,
       3,     4,     5,     6,     7,     8,     9,    10,    -1,    -1,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   647,
      -1,   649,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     658,    -1,   660,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   670,    -1,   672,    -1,    -1,    -1,    -1,    -1,
     678,    -1,   680,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,   116,   117,   118,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   137,   138
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,   144,     0,     3,    11,    12,   120,   145,   150,   122,
      11,   119,   147,   148,   137,    11,     4,     5,     6,     7,
       8,     9,    10,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,   106,   107,   108,   109,   110,   111,   112,
     113,   114,   115,   116,   117,   118,   137,   138,   145,   151,
     154,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   168,   169,   174,   175,   179,   180,   184,   185,   190,
     191,   196,   200,   201,   205,   206,   211,   212,   216,   217,
     221,   222,   226,   227,   231,   232,   251,   123,   126,   127,
     146,   122,   122,   122,   122,   122,   122,   122,   122,   122,
     122,   122,   122,   122,   122,   122,   122,   122,    11,   147,
     148,   152,   153,   122,   122,   122,   122,   122,   122,   122,
     122,   122,   122,   122,   122,   122,   126,   137,   137,   137,
     137,   137,   123,   137,   137,   137,   137,   137,   137,   137,
     137,   137,   122,   127,   137,   155,   155,   155,   155,   121,
     154,    23,    24,    25,    26,    38,   170,   171,   172,   173,
      27,    55,   176,   177,   178,    27,    28,    55,   181,   182,
     183,    38,    44,    73,    74,    75,    76,    77,    78,   186,
     187,   188,   189,    39,    79,    80,    81,    82,   192,   193,
     194,   195,    29,    30,    31,    32,    33,    34,    35,    36,
      37,   197,   198,   199,    23,    24,    38,    39,    40,    41,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
     202,   203,   204,    23,    24,    39,    43,    48,    52,    53,
      54,    80,   207,   208,   209,   210,    26,    44,    55,    56,
      57,    60,    83,    84,   213,   214,   215,    26,    49,    55,
      56,    57,   218,   219,   220,    43,    49,    58,    59,   223,
     224,   225,    49,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,   228,   229,
     230,    29,    44,    85,    86,    87,    88,    89,    90,    91,
      92,    93,    94,    95,    96,    97,    98,    99,   233,   234,
     235,   240,   241,   249,   250,   148,   123,    11,   147,   152,
     123,   152,   152,   123,   152,   152,   152,   152,   152,   152,
     152,   152,   155,   155,   123,   127,   128,   129,   130,   131,
     132,   133,   134,   135,   136,   123,   123,   123,   123,    11,
     124,   149,   166,   152,   123,   149,   166,   152,   122,   122,
     123,   149,   166,   152,   123,   149,   166,   152,   123,   149,
     166,   152,   149,   166,   123,   149,   166,   152,   123,   149,
     166,   152,   123,   149,   166,   152,   123,   149,   166,   152,
     149,   166,   123,   149,   166,   152,   123,   149,   166,   152,
     123,   149,   166,   152,   123,   149,   166,   122,   122,   152,
     120,   126,   137,   137,   137,   137,   137,   137,   137,   137,
     137,   137,   137,   123,   155,   155,   155,   155,   155,   155,
     155,   134,   135,   155,   149,   142,   149,   170,   142,   149,
     176,   137,   137,   142,   149,   181,   142,   149,   186,   142,
     149,   192,   142,   149,   142,   149,   197,   142,   149,   202,
     142,   149,   207,   142,   149,   213,   142,   149,   142,   149,
     218,   142,   149,   223,   142,   149,   228,   142,   149,    26,
     100,   101,   236,   237,   238,   239,    26,    39,    43,    83,
     100,   101,   102,   103,   104,   105,   242,   245,   246,   247,
     248,   233,   148,   148,   123,   123,   152,   123,   152,   123,
     152,   123,   152,   123,   123,   123,   123,   123,   123,   155,
     155,   137,   149,   142,   149,   142,   123,   123,   149,   142,
     149,   142,   149,   142,   149,   142,   149,   142,   149,   142,
     149,   142,   149,   142,    56,    57,   149,   142,   149,   142,
     149,   142,   149,   142,   149,   142,   149,   166,   149,   166,
     152,   123,   122,   122,   122,   122,   149,   166,   149,   166,
     152,   123,   151,   120,   137,   137,   137,   137,   149,     8,
       9,   137,   138,   139,   140,   141,   167,   149,   167,   149,
     167,   149,   167,   149,   167,   149,    34,    35,   167,   149,
     167,   149,   167,   149,   167,   149,   167,   149,   167,   149,
     167,   149,   167,   149,   167,   149,   167,   149,   142,   149,
     142,   149,   239,   149,   149,   149,   149,   142,   149,   142,
     149,   248,   148,   148,   123,   123,   123,   123,   125,   126,
     122,   122,   167,   167,   167,   167,   167,   167,   167,   167,
     167,   167,   167,   167,   167,   167,   167,   149,   142,   149,
     142,   140,   141,   243,   138,   244,   244,   244,   149,   142,
     149,   142,   121,   151,   149,   123,   137,   123,   137,   167,
     149,   167,   149,   149,   149,   149,   149,   167,   149,   167,
     149,   148,   137,   152,   123,   152,   167,   167,   123,   123,
     123,   123,   167,   167,   121,   149,   137,   137,   125,   123,
     123,   152,   137,   123
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_uint8 yyr1[] =
{
       0,   143,   144,   144,   144,   144,   145,   146,   146,   147,
     147,   148,   148,   148,   149,   149,   150,   150,   150,   151,
     151,   152,   152,   153,   154,   154,   154,   154,   154,   154,
     154,   154,   154,   154,   154,   154,   154,   155,   155,   155,
     155,   155,   155,   155,   155,   155,   155,   155,   155,   155,
     156,   157,   157,   157,   157,   158,   159,   159,   159,   159,
     159,   159,   160,   160,   161,   161,   162,   162,   163,   163,
     164,   164,   165,   165,   165,   165,   165,   165,   165,   165,
     165,   165,   165,   165,   165,   166,   166,   167,   167,   167,
     167,   167,   167,   167,   167,   167,   167,   167,   168,   169,
     170,   170,   170,   171,   171,   171,   172,   172,   172,   173,
     173,   174,   175,   176,   176,   176,   177,   177,   178,   178,
     179,   180,   181,   181,   181,   182,   182,   182,   182,   183,
     183,   184,   185,   186,   186,   186,   187,   187,   188,   188,
     188,   188,   188,   189,   189,   189,   189,   190,   191,   192,
     192,   192,   193,   193,   194,   194,   194,   194,   195,   195,
     196,   197,   197,   197,   198,   198,   198,   198,   198,   198,
     199,   199,   199,   199,   199,   199,   199,   199,   200,   201,
     202,   202,   202,   203,   203,   203,   203,   203,   203,   203,
     203,   203,   203,   203,   203,   203,   203,   204,   204,   204,
     204,   205,   206,   207,   207,   207,   208,   208,   209,   209,
     209,   209,   209,   209,   209,   209,   210,   210,   211,   212,
     213,   213,   213,   214,   214,   214,   214,   214,   214,   215,
     215,   215,   215,   216,   217,   218,   218,   218,   219,   219,
     220,   220,   220,   220,   220,   220,   220,   220,   221,   222,
     223,   223,   223,   224,   224,   224,   224,   225,   225,   226,
     227,   228,   228,   228,   229,   229,   229,   229,   229,   229,
     229,   229,   230,   230,   230,   230,   230,   230,   230,   230,
     230,   230,   231,   232,   233,   233,   233,   234,   234,   234,
     234,   234,   234,   234,   234,   234,   234,   234,   234,   234,
     235,   236,   237,   237,   238,   238,   238,   238,   239,   239,
     239,   240,   241,   241,   241,   242,   243,   243,   244,   245,
     245,   245,   245,   246,   246,   246,   246,   246,   247,   247,
     247,   247,   247,   248,   248,   248,   249,   250,   250,   250,
     250,   251
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     0,     2,     2,     2,     1,     1,     1,     1,
       2,     0,     1,     1,     0,     1,     5,    13,    11,     1,
       2,     1,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     3,     3,
       3,     3,     3,     3,     3,     3,     4,     4,     2,     3,
       6,     4,     4,     4,     4,     4,     6,     6,     6,     6,
       6,     6,     6,     8,     6,     8,     3,     4,     6,     8,
       6,     8,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     5,     9,     1,     1,     1,
       1,     1,     3,     4,     6,     8,     3,     6,     4,     1,
       0,     1,     3,     1,     1,     1,     1,     1,     1,     6,
       5,     4,     1,     0,     1,     3,     1,     1,     6,     5,
       4,     1,     0,     1,     3,     1,     1,     4,     4,     6,
       5,     4,     1,     0,     1,     3,     1,     1,     1,     1,
       1,     1,     1,     6,     5,     1,     1,     4,     1,     0,
       1,     3,     1,     1,     1,     1,     1,     1,     6,     5,
       4,     0,     1,     3,     1,     1,     1,     1,     1,     1,
       6,     5,     6,     5,     5,     5,     1,     1,     1,     4,
       0,     1,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     6,     5,     1,
       1,     1,     4,     0,     1,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     6,     5,     1,     4,
       0,     1,     3,     1,     1,     1,     1,     1,     1,     6,
       5,     1,     1,     1,     4,     0,     1,     3,     1,     1,
       6,     5,     6,     5,     4,     1,     4,     1,     1,     4,
       0,     1,     3,     1,     1,     1,     1,     6,     5,     1,
       4,     0,     1,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     6,     5,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     4,     0,     1,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     6,     5,     6,     5,     0,     1,
       3,     4,     1,     1,     1,     1,     1,     1,     1,     6,
       6,     6,     6,     1,     1,     1,     1,     1,     6,     5,
       6,     5,     1,     0,     1,     3,     4,     6,     5,     1,
       1,     1
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)]);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif






/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep)
{
  YY_USE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 2: /* packets: %empty  */
#line 563 "trafgen_parser.y"
          { }
#line 2346 "trafgen/trafgen_parser.tab.c"
    break;

  case 3: /* packets: packets packet  */
#line 564 "trafgen_parser.y"
                         { }
#line 2352 "trafgen/trafgen_parser.tab.c"
    break;

  case 4: /* packets: packets inline_comment  */
#line 565 "trafgen_parser.y"
                                 { }
#line 2358 "trafgen/trafgen_parser.tab.c"
    break;

  case 5: /* packets: packets K_WHITE  */
#line 566 "trafgen_parser.y"
                          { }
#line 2364 "trafgen/trafgen_parser.tab.c"
    break;

  case 6: /* inline_comment: K_COMMENT  */
#line 570 "trafgen_parser.y"
                    { }
#line 2370 "trafgen/trafgen_parser.tab.c"
    break;

  case 7: /* cpu_delim: ':'  */
#line 574 "trafgen_parser.y"
              { }
#line 2376 "trafgen/trafgen_parser.tab.c"
    break;

  case 8: /* cpu_delim: '-'  */
#line 575 "trafgen_parser.y"
              { }
#line 2382 "trafgen/trafgen_parser.tab.c"
    break;

  case 9: /* delimiter_nowhite: ','  */
#line 579 "trafgen_parser.y"
              { }
#line 2388 "trafgen/trafgen_parser.tab.c"
    break;

  case 10: /* delimiter_nowhite: ',' K_WHITE  */
#line 580 "trafgen_parser.y"
                      { }
#line 2394 "trafgen/trafgen_parser.tab.c"
    break;

  case 11: /* noenforce_white: %empty  */
#line 584 "trafgen_parser.y"
          { }
#line 2400 "trafgen/trafgen_parser.tab.c"
    break;

  case 12: /* noenforce_white: K_WHITE  */
#line 585 "trafgen_parser.y"
                  { }
#line 2406 "trafgen/trafgen_parser.tab.c"
    break;

  case 13: /* noenforce_white: delimiter_nowhite  */
#line 586 "trafgen_parser.y"
                            { }
#line 2412 "trafgen/trafgen_parser.tab.c"
    break;

  case 14: /* skip_white: %empty  */
#line 590 "trafgen_parser.y"
          { }
#line 2418 "trafgen/trafgen_parser.tab.c"
    break;

  case 15: /* skip_white: K_WHITE  */
#line 591 "trafgen_parser.y"
                  { }
#line 2424 "trafgen/trafgen_parser.tab.c"
    break;

  case 16: /* packet: '{' noenforce_white payload noenforce_white '}'  */
#line 594 "trafgen_parser.y"
                                                          {
			min_cpu = max_cpu = -1;

			proto_packet_finish();

			realloc_packet();
		}
#line 2436 "trafgen/trafgen_parser.tab.c"
    break;

  case 17: /* packet: K_CPU '(' number cpu_delim number ')' ':' noenforce_white '{' noenforce_white payload noenforce_white '}'  */
#line 601 "trafgen_parser.y"
                                                                                                                    {
			min_cpu = (yyvsp[-10].number);
			max_cpu = (yyvsp[-8].number);

			if (min_cpu > max_cpu) {
				int tmp = min_cpu;

				min_cpu = max_cpu;
				max_cpu = tmp;
			}

			proto_packet_finish();

			realloc_packet();
		}
#line 2456 "trafgen/trafgen_parser.tab.c"
    break;

  case 18: /* packet: K_CPU '(' number ')' ':' noenforce_white '{' noenforce_white payload noenforce_white '}'  */
#line 616 "trafgen_parser.y"
                                                                                                   {
			min_cpu = max_cpu = (yyvsp[-8].number);

			proto_packet_finish();

			realloc_packet();
		}
#line 2468 "trafgen/trafgen_parser.tab.c"
    break;

  case 19: /* payload: elem  */
#line 626 "trafgen_parser.y"
               { }
#line 2474 "trafgen/trafgen_parser.tab.c"
    break;

  case 20: /* payload: payload elem_delimiter  */
#line 627 "trafgen_parser.y"
                                 { }
#line 2480 "trafgen/trafgen_parser.tab.c"
    break;

  case 21: /* delimiter: delimiter_nowhite  */
#line 631 "trafgen_parser.y"
                            { }
#line 2486 "trafgen/trafgen_parser.tab.c"
    break;

  case 22: /* delimiter: K_WHITE  */
#line 632 "trafgen_parser.y"
                  { }
#line 2492 "trafgen/trafgen_parser.tab.c"
    break;

  case 23: /* elem_delimiter: delimiter elem  */
#line 636 "trafgen_parser.y"
                         { }
#line 2498 "trafgen/trafgen_parser.tab.c"
    break;

  case 24: /* elem: number  */
#line 640 "trafgen_parser.y"
                 { set_byte((uint8_t) (yyvsp[0].number)); }
#line 2504 "trafgen/trafgen_parser.tab.c"
    break;

  case 25: /* elem: string  */
#line 641 "trafgen_parser.y"
                 { set_multi_byte((uint8_t *) (yyvsp[0].str) + 1, strlen((yyvsp[0].str)) - 2); }
#line 2510 "trafgen/trafgen_parser.tab.c"
    break;

  case 26: /* elem: fill  */
#line 642 "trafgen_parser.y"
               { }
#line 2516 "trafgen/trafgen_parser.tab.c"
    break;

  case 27: /* elem: rnd  */
#line 643 "trafgen_parser.y"
              { }
#line 2522 "trafgen/trafgen_parser.tab.c"
    break;

  case 28: /* elem: drnd  */
#line 644 "trafgen_parser.y"
               { }
#line 2528 "trafgen/trafgen_parser.tab.c"
    break;

  case 29: /* elem: seqinc  */
#line 645 "trafgen_parser.y"
                 { }
#line 2534 "trafgen/trafgen_parser.tab.c"
    break;

  case 30: /* elem: seqdec  */
#line 646 "trafgen_parser.y"
                 { }
#line 2540 "trafgen/trafgen_parser.tab.c"
    break;

  case 31: /* elem: dinc  */
#line 647 "trafgen_parser.y"
               { }
#line 2546 "trafgen/trafgen_parser.tab.c"
    break;

  case 32: /* elem: ddec  */
#line 648 "trafgen_parser.y"
               { }
#line 2552 "trafgen/trafgen_parser.tab.c"
    break;

  case 33: /* elem: csum  */
#line 649 "trafgen_parser.y"
               { }
#line 2558 "trafgen/trafgen_parser.tab.c"
    break;

  case 34: /* elem: const  */
#line 650 "trafgen_parser.y"
                { }
#line 2564 "trafgen/trafgen_parser.tab.c"
    break;

  case 35: /* elem: proto  */
#line 651 "trafgen_parser.y"
                { proto_header_finish(hdr); }
#line 2570 "trafgen/trafgen_parser.tab.c"
    break;

  case 36: /* elem: inline_comment  */
#line 652 "trafgen_parser.y"
                         { }
#line 2576 "trafgen/trafgen_parser.tab.c"
    break;

  case 37: /* expression: number  */
#line 657 "trafgen_parser.y"
                { (yyval.number) = (yyvsp[0].number); }
#line 2582 "trafgen/trafgen_parser.tab.c"
    break;

  case 38: /* expression: expression '+' expression  */
#line 659 "trafgen_parser.y"
                { (yyval.number) = (yyvsp[-2].number) + (yyvsp[0].number); }
#line 2588 "trafgen/trafgen_parser.tab.c"
    break;

  case 39: /* expression: expression '-' expression  */
#line 661 "trafgen_parser.y"
                { (yyval.number) = (yyvsp[-2].number) - (yyvsp[0].number); }
#line 2594 "trafgen/trafgen_parser.tab.c"
    break;

  case 40: /* expression: expression '*' expression  */
#line 663 "trafgen_parser.y"
                { (yyval.number) = (yyvsp[-2].number) * (yyvsp[0].number); }
#line 2600 "trafgen/trafgen_parser.tab.c"
    break;

  case 41: /* expression: expression '/' expression  */
#line 665 "trafgen_parser.y"
                { (yyval.number) = (yyvsp[-2].number) / (yyvsp[0].number); }
#line 2606 "trafgen/trafgen_parser.tab.c"
    break;

  case 42: /* expression: expression '%' expression  */
#line 667 "trafgen_parser.y"
                { (yyval.number) = (yyvsp[-2].number) % (yyvsp[0].number); }
#line 2612 "trafgen/trafgen_parser.tab.c"
    break;

  case 43: /* expression: expression '&' expression  */
#line 669 "trafgen_parser.y"
                { (yyval.number) = (yyvsp[-2].number) & (yyvsp[0].number); }
#line 2618 "trafgen/trafgen_parser.tab.c"
    break;

  case 44: /* expression: expression '|' expression  */
#line 671 "trafgen_parser.y"
                { (yyval.number) = (yyvsp[-2].number) | (yyvsp[0].number); }
#line 2624 "trafgen/trafgen_parser.tab.c"
    break;

  case 45: /* expression: expression '^' expression  */
#line 673 "trafgen_parser.y"
                { (yyval.number) = (yyvsp[-2].number) ^ (yyvsp[0].number); }
#line 2630 "trafgen/trafgen_parser.tab.c"
    break;

  case 46: /* expression: expression '<' '<' expression  */
#line 675 "trafgen_parser.y"
                { (yyval.number) = (yyvsp[-3].number) << (yyvsp[0].number); }
#line 2636 "trafgen/trafgen_parser.tab.c"
    break;

  case 47: /* expression: expression '>' '>' expression  */
#line 677 "trafgen_parser.y"
                { (yyval.number) = (yyvsp[-3].number) >> (yyvsp[0].number); }
#line 2642 "trafgen/trafgen_parser.tab.c"
    break;

  case 48: /* expression: '-' expression  */
#line 679 "trafgen_parser.y"
                { (yyval.number) = -1 * (yyvsp[0].number); }
#line 2648 "trafgen/trafgen_parser.tab.c"
    break;

  case 49: /* expression: '(' expression ')'  */
#line 681 "trafgen_parser.y"
                { (yyval.number) = (yyvsp[-1].number);}
#line 2654 "trafgen/trafgen_parser.tab.c"
    break;

  case 50: /* fill: K_FILL '(' number delimiter number ')'  */
#line 686 "trafgen_parser.y"
                { set_fill((yyvsp[-3].number), (yyvsp[-1].number)); }
#line 2660 "trafgen/trafgen_parser.tab.c"
    break;

  case 51: /* const: K_CONST8 '(' expression ')'  */
#line 691 "trafgen_parser.y"
                { set_byte((uint8_t) (yyvsp[-1].number)); }
#line 2666 "trafgen/trafgen_parser.tab.c"
    break;

  case 52: /* const: K_CONST16 '(' expression ')'  */
#line 692 "trafgen_parser.y"
                                       {
			uint16_t __c = cpu_to_be16((uint16_t) (yyvsp[-1].number));

			set_multi_byte((uint8_t *) &__c, sizeof(__c));
		}
#line 2676 "trafgen/trafgen_parser.tab.c"
    break;

  case 53: /* const: K_CONST32 '(' expression ')'  */
#line 697 "trafgen_parser.y"
                                       {
			uint32_t __c = cpu_to_be32((uint32_t) (yyvsp[-1].number));

			set_multi_byte((uint8_t *) &__c, sizeof(__c));
		}
#line 2686 "trafgen/trafgen_parser.tab.c"
    break;

  case 54: /* const: K_CONST64 '(' expression ')'  */
#line 702 "trafgen_parser.y"
                                       {
			uint64_t __c = cpu_to_be64((uint64_t) (yyvsp[-1].number));

			set_multi_byte((uint8_t *) &__c, sizeof(__c));
		}
#line 2696 "trafgen/trafgen_parser.tab.c"
    break;

  case 55: /* rnd: K_RND '(' number ')'  */
#line 711 "trafgen_parser.y"
                { set_rnd((yyvsp[-1].number)); }
#line 2702 "trafgen/trafgen_parser.tab.c"
    break;

  case 56: /* csum: K_CSUMIP '(' number delimiter number ')'  */
#line 716 "trafgen_parser.y"
                { set_csum16((yyvsp[-3].number), (yyvsp[-1].number), CSUM_IP); }
#line 2708 "trafgen/trafgen_parser.tab.c"
    break;

  case 57: /* csum: K_CSUMTCP '(' number delimiter number ')'  */
#line 718 "trafgen_parser.y"
                { set_csum16((yyvsp[-3].number), (yyvsp[-1].number), CSUM_TCP); }
#line 2714 "trafgen/trafgen_parser.tab.c"
    break;

  case 58: /* csum: K_CSUMUDP '(' number delimiter number ')'  */
#line 720 "trafgen_parser.y"
                { set_csum16((yyvsp[-3].number), (yyvsp[-1].number), CSUM_UDP); }
#line 2720 "trafgen/trafgen_parser.tab.c"
    break;

  case 59: /* csum: K_CSUMTCP6 '(' number delimiter number ')'  */
#line 722 "trafgen_parser.y"
                { set_csum16((yyvsp[-3].number), (yyvsp[-1].number), CSUM_TCP6); }
#line 2726 "trafgen/trafgen_parser.tab.c"
    break;

  case 60: /* csum: K_CSUMUDP6 '(' number delimiter number ')'  */
#line 724 "trafgen_parser.y"
                { set_csum16((yyvsp[-3].number), (yyvsp[-1].number), CSUM_UDP6); }
#line 2732 "trafgen/trafgen_parser.tab.c"
    break;

  case 61: /* csum: K_CSUMICMP6 '(' number delimiter number ')'  */
#line 726 "trafgen_parser.y"
                { set_csum16((yyvsp[-3].number), (yyvsp[-1].number), CSUM_ICMP6); }
#line 2738 "trafgen/trafgen_parser.tab.c"
    break;

  case 62: /* seqinc: K_SEQINC '(' number delimiter number ')'  */
#line 731 "trafgen_parser.y"
                { set_sequential_inc((yyvsp[-3].number), (yyvsp[-1].number), 1); }
#line 2744 "trafgen/trafgen_parser.tab.c"
    break;

  case 63: /* seqinc: K_SEQINC '(' number delimiter number delimiter number ')'  */
#line 733 "trafgen_parser.y"
                { set_sequential_inc((yyvsp[-5].number), (yyvsp[-3].number), (yyvsp[-1].number)); }
#line 2750 "trafgen/trafgen_parser.tab.c"
    break;

  case 64: /* seqdec: K_SEQDEC '(' number delimiter number ')'  */
#line 738 "trafgen_parser.y"
                { set_sequential_dec((yyvsp[-3].number), (yyvsp[-1].number), 1); }
#line 2756 "trafgen/trafgen_parser.tab.c"
    break;

  case 65: /* seqdec: K_SEQDEC '(' number delimiter number delimiter number ')'  */
#line 740 "trafgen_parser.y"
                { set_sequential_dec((yyvsp[-5].number), (yyvsp[-3].number), (yyvsp[-1].number)); }
#line 2762 "trafgen/trafgen_parser.tab.c"
    break;

  case 66: /* drnd: K_DRND '(' ')'  */
#line 745 "trafgen_parser.y"
                { set_dynamic_rnd(); }
#line 2768 "trafgen/trafgen_parser.tab.c"
    break;

  case 67: /* drnd: K_DRND '(' number ')'  */
#line 747 "trafgen_parser.y"
                {
			int i, max = (yyvsp[-1].number);
			for (i = 0; i < max; ++i)
				set_dynamic_rnd();
		}
#line 2778 "trafgen/trafgen_parser.tab.c"
    break;

  case 68: /* dinc: K_DINC '(' number delimiter number ')'  */
#line 756 "trafgen_parser.y"
                { set_dynamic_incdec((yyvsp[-3].number), (yyvsp[-1].number), 1, TYPE_INC); }
#line 2784 "trafgen/trafgen_parser.tab.c"
    break;

  case 69: /* dinc: K_DINC '(' number delimiter number delimiter number ')'  */
#line 758 "trafgen_parser.y"
                { set_dynamic_incdec((yyvsp[-5].number), (yyvsp[-3].number), (yyvsp[-1].number), TYPE_INC); }
#line 2790 "trafgen/trafgen_parser.tab.c"
    break;

  case 70: /* ddec: K_DDEC '(' number delimiter number ')'  */
#line 763 "trafgen_parser.y"
                { set_dynamic_incdec((yyvsp[-3].number), (yyvsp[-1].number), 1, TYPE_DEC); }
#line 2796 "trafgen/trafgen_parser.tab.c"
    break;

  case 71: /* ddec: K_DDEC '(' number delimiter number delimiter number ')'  */
#line 765 "trafgen_parser.y"
                { set_dynamic_incdec((yyvsp[-5].number), (yyvsp[-3].number), (yyvsp[-1].number), TYPE_DEC); }
#line 2802 "trafgen/trafgen_parser.tab.c"
    break;

  case 72: /* proto: eth_proto  */
#line 769 "trafgen_parser.y"
                    { }
#line 2808 "trafgen/trafgen_parser.tab.c"
    break;

  case 73: /* proto: pause_proto  */
#line 770 "trafgen_parser.y"
                      { }
#line 2814 "trafgen/trafgen_parser.tab.c"
    break;

  case 74: /* proto: pfc_proto  */
#line 771 "trafgen_parser.y"
                    { }
#line 2820 "trafgen/trafgen_parser.tab.c"
    break;

  case 75: /* proto: vlan_proto  */
#line 772 "trafgen_parser.y"
                     { }
#line 2826 "trafgen/trafgen_parser.tab.c"
    break;

  case 76: /* proto: mpls_proto  */
#line 773 "trafgen_parser.y"
                     { }
#line 2832 "trafgen/trafgen_parser.tab.c"
    break;

  case 77: /* proto: arp_proto  */
#line 774 "trafgen_parser.y"
                    { }
#line 2838 "trafgen/trafgen_parser.tab.c"
    break;

  case 78: /* proto: ip4_proto  */
#line 775 "trafgen_parser.y"
                    { }
#line 2844 "trafgen/trafgen_parser.tab.c"
    break;

  case 79: /* proto: ip6_proto  */
#line 776 "trafgen_parser.y"
                    { }
#line 2850 "trafgen/trafgen_parser.tab.c"
    break;

  case 80: /* proto: icmp4_proto  */
#line 777 "trafgen_parser.y"
                      { }
#line 2856 "trafgen/trafgen_parser.tab.c"
    break;

  case 81: /* proto: icmpv6_proto  */
#line 778 "trafgen_parser.y"
                       { }
#line 2862 "trafgen/trafgen_parser.tab.c"
    break;

  case 82: /* proto: udp_proto  */
#line 779 "trafgen_parser.y"
                    { }
#line 2868 "trafgen/trafgen_parser.tab.c"
    break;

  case 83: /* proto: tcp_proto  */
#line 780 "trafgen_parser.y"
                    { }
#line 2874 "trafgen/trafgen_parser.tab.c"
    break;

  case 84: /* proto: dns_proto  */
#line 781 "trafgen_parser.y"
                    { }
#line 2880 "trafgen/trafgen_parser.tab.c"
    break;

  case 85: /* field_expr: '[' skip_white number skip_white ']'  */
#line 786 "trafgen_parser.y"
                { field_index_validate(field_expr.field, (yyvsp[-2].number), 1);
		  field_expr.type |= FIELD_EXPR_OFFSET;
		  field_expr.val.func.offset = (yyvsp[-2].number);
		  field_expr.val.func.len = 1; }
#line 2889 "trafgen/trafgen_parser.tab.c"
    break;

  case 86: /* field_expr: '[' skip_white number skip_white ':' skip_white number skip_white ']'  */
#line 791 "trafgen_parser.y"
                { field_index_validate(field_expr.field, (yyvsp[-6].number), (yyvsp[-2].number));
		  field_expr.type |= FIELD_EXPR_OFFSET;
		  field_expr.val.func.offset = (yyvsp[-6].number);
		  field_expr.val.func.len = (yyvsp[-2].number); }
#line 2898 "trafgen/trafgen_parser.tab.c"
    break;

  case 87: /* field_value_expr: number  */
#line 798 "trafgen_parser.y"
                 { field_expr.type |= FIELD_EXPR_NUMB;
		   field_expr.val.number = (yyvsp[0].number); }
#line 2905 "trafgen/trafgen_parser.tab.c"
    break;

  case 88: /* field_value_expr: mac  */
#line 800 "trafgen_parser.y"
              { field_expr.type |= FIELD_EXPR_MAC;
		memcpy(field_expr.val.mac, (yyvsp[0].mac), sizeof(field_expr.val.mac)); }
#line 2912 "trafgen/trafgen_parser.tab.c"
    break;

  case 89: /* field_value_expr: string  */
#line 802 "trafgen_parser.y"
                 { field_expr.type |= FIELD_EXPR_STRING;
		   field_expr.val.str = xstrdup((yyvsp[0].str) + 1);
		   field_expr.val.str[strlen((yyvsp[0].str) + 1) - 1] = '\0'; }
#line 2920 "trafgen/trafgen_parser.tab.c"
    break;

  case 90: /* field_value_expr: ip4_addr  */
#line 805 "trafgen_parser.y"
                   { field_expr.type |= FIELD_EXPR_IP4_ADDR;
		     field_expr.val.ip4_addr = (yyvsp[0].ip4_addr); }
#line 2927 "trafgen/trafgen_parser.tab.c"
    break;

  case 91: /* field_value_expr: ip6_addr  */
#line 807 "trafgen_parser.y"
                   { field_expr.type |= FIELD_EXPR_IP6_ADDR;
		     field_expr.val.ip6_addr = (yyvsp[0].ip6_addr); }
#line 2934 "trafgen/trafgen_parser.tab.c"
    break;

  case 92: /* field_value_expr: K_DINC '(' ')'  */
#line 809 "trafgen_parser.y"
                         { field_expr.type |= FIELD_EXPR_INC;
			   field_expr.val.func.type = PROTO_FIELD_FUNC_INC;
			   field_expr.val.func.inc = 1; }
#line 2942 "trafgen/trafgen_parser.tab.c"
    break;

  case 93: /* field_value_expr: K_DINC '(' number ')'  */
#line 813 "trafgen_parser.y"
                        { field_expr.type |= FIELD_EXPR_INC;
			  field_expr.val.func.type = PROTO_FIELD_FUNC_INC;
			  field_expr.val.func.inc = (yyvsp[-1].number); }
#line 2950 "trafgen/trafgen_parser.tab.c"
    break;

  case 94: /* field_value_expr: K_DINC '(' number delimiter number ')'  */
#line 817 "trafgen_parser.y"
                        { field_expr.type |= FIELD_EXPR_INC;
			  field_expr.val.func.type  = PROTO_FIELD_FUNC_INC;
			  field_expr.val.func.type |= PROTO_FIELD_FUNC_MIN;
			  field_expr.val.func.min = (yyvsp[-3].number);
			  field_expr.val.func.max = (yyvsp[-1].number);
			  field_expr.val.func.inc = 1; }
#line 2961 "trafgen/trafgen_parser.tab.c"
    break;

  case 95: /* field_value_expr: K_DINC '(' number delimiter number delimiter number ')'  */
#line 824 "trafgen_parser.y"
                        { field_expr.type |= FIELD_EXPR_INC;
			  field_expr.val.func.type  = PROTO_FIELD_FUNC_INC;
			  field_expr.val.func.type |= PROTO_FIELD_FUNC_MIN;
			  field_expr.val.func.min = (yyvsp[-5].number);
			  field_expr.val.func.max = (yyvsp[-3].number);
			  field_expr.val.func.inc = (yyvsp[-1].number); }
#line 2972 "trafgen/trafgen_parser.tab.c"
    break;

  case 96: /* field_value_expr: K_DRND '(' ')'  */
#line 830 "trafgen_parser.y"
                         { field_expr.type |= FIELD_EXPR_RND;
			  field_expr.val.func.type = PROTO_FIELD_FUNC_RND; }
#line 2979 "trafgen/trafgen_parser.tab.c"
    break;

  case 97: /* field_value_expr: K_DRND '(' number delimiter number ')'  */
#line 833 "trafgen_parser.y"
                        { field_expr.type |= FIELD_EXPR_RND;
			  field_expr.val.func.type = PROTO_FIELD_FUNC_RND;
			  field_expr.val.func.min = (yyvsp[-3].number);
			  field_expr.val.func.max = (yyvsp[-1].number); }
#line 2988 "trafgen/trafgen_parser.tab.c"
    break;

  case 98: /* eth_proto: eth '(' eth_param_list ')'  */
#line 840 "trafgen_parser.y"
                                     { }
#line 2994 "trafgen/trafgen_parser.tab.c"
    break;

  case 99: /* eth: K_ETH  */
#line 844 "trafgen_parser.y"
                { proto_add(PROTO_ETH); }
#line 3000 "trafgen/trafgen_parser.tab.c"
    break;

  case 100: /* eth_param_list: %empty  */
#line 848 "trafgen_parser.y"
          { }
#line 3006 "trafgen/trafgen_parser.tab.c"
    break;

  case 101: /* eth_param_list: eth_expr  */
#line 849 "trafgen_parser.y"
                   { }
#line 3012 "trafgen/trafgen_parser.tab.c"
    break;

  case 102: /* eth_param_list: eth_expr delimiter eth_param_list  */
#line 850 "trafgen_parser.y"
                                            { }
#line 3018 "trafgen/trafgen_parser.tab.c"
    break;

  case 103: /* eth_type: K_ETYPE  */
#line 854 "trafgen_parser.y"
                  { }
#line 3024 "trafgen/trafgen_parser.tab.c"
    break;

  case 104: /* eth_type: K_TYPE  */
#line 855 "trafgen_parser.y"
                 { }
#line 3030 "trafgen/trafgen_parser.tab.c"
    break;

  case 105: /* eth_type: K_PROT  */
#line 856 "trafgen_parser.y"
                 { }
#line 3036 "trafgen/trafgen_parser.tab.c"
    break;

  case 106: /* eth_field: K_DADDR  */
#line 860 "trafgen_parser.y"
                  { proto_field_set(ETH_DST_ADDR); }
#line 3042 "trafgen/trafgen_parser.tab.c"
    break;

  case 107: /* eth_field: K_SADDR  */
#line 861 "trafgen_parser.y"
                  { proto_field_set(ETH_SRC_ADDR); }
#line 3048 "trafgen/trafgen_parser.tab.c"
    break;

  case 108: /* eth_field: eth_type  */
#line 862 "trafgen_parser.y"
                   { proto_field_set(ETH_TYPE); }
#line 3054 "trafgen/trafgen_parser.tab.c"
    break;

  case 109: /* eth_expr: eth_field field_expr skip_white '=' skip_white field_value_expr  */
#line 866 "trafgen_parser.y"
                { proto_field_expr_eval(); }
#line 3060 "trafgen/trafgen_parser.tab.c"
    break;

  case 110: /* eth_expr: eth_field skip_white '=' skip_white field_value_expr  */
#line 868 "trafgen_parser.y"
                { proto_field_expr_eval(); }
#line 3066 "trafgen/trafgen_parser.tab.c"
    break;

  case 111: /* pause_proto: pause '(' pause_param_list ')'  */
#line 872 "trafgen_parser.y"
                                         { }
#line 3072 "trafgen/trafgen_parser.tab.c"
    break;

  case 112: /* pause: K_PAUSE  */
#line 876 "trafgen_parser.y"
                  { proto_add(PROTO_PAUSE); }
#line 3078 "trafgen/trafgen_parser.tab.c"
    break;

  case 113: /* pause_param_list: %empty  */
#line 880 "trafgen_parser.y"
          { }
#line 3084 "trafgen/trafgen_parser.tab.c"
    break;

  case 114: /* pause_param_list: pause_expr  */
#line 881 "trafgen_parser.y"
                     { }
#line 3090 "trafgen/trafgen_parser.tab.c"
    break;

  case 115: /* pause_param_list: pause_expr delimiter pause_param_list  */
#line 882 "trafgen_parser.y"
                                                { }
#line 3096 "trafgen/trafgen_parser.tab.c"
    break;

  case 116: /* pause_field: K_CODE  */
#line 886 "trafgen_parser.y"
                 { proto_field_set(PAUSE_OPCODE); }
#line 3102 "trafgen/trafgen_parser.tab.c"
    break;

  case 117: /* pause_field: K_TIME  */
#line 887 "trafgen_parser.y"
                 { proto_field_set(PAUSE_TIME); }
#line 3108 "trafgen/trafgen_parser.tab.c"
    break;

  case 118: /* pause_expr: pause_field field_expr skip_white '=' skip_white field_value_expr  */
#line 892 "trafgen_parser.y"
                { proto_field_expr_eval(); }
#line 3114 "trafgen/trafgen_parser.tab.c"
    break;

  case 119: /* pause_expr: pause_field skip_white '=' skip_white field_value_expr  */
#line 894 "trafgen_parser.y"
                { proto_field_expr_eval(); }
#line 3120 "trafgen/trafgen_parser.tab.c"
    break;

  case 120: /* pfc_proto: pfc '(' pfc_param_list ')'  */
#line 898 "trafgen_parser.y"
                                     { }
#line 3126 "trafgen/trafgen_parser.tab.c"
    break;

  case 121: /* pfc: K_PFC  */
#line 902 "trafgen_parser.y"
                { proto_add(PROTO_PFC); }
#line 3132 "trafgen/trafgen_parser.tab.c"
    break;

  case 122: /* pfc_param_list: %empty  */
#line 906 "trafgen_parser.y"
          { }
#line 3138 "trafgen/trafgen_parser.tab.c"
    break;

  case 123: /* pfc_param_list: pfc_expr  */
#line 907 "trafgen_parser.y"
                   { }
#line 3144 "trafgen/trafgen_parser.tab.c"
    break;

  case 124: /* pfc_param_list: pfc_expr delimiter pfc_param_list  */
#line 908 "trafgen_parser.y"
                                            { }
#line 3150 "trafgen/trafgen_parser.tab.c"
    break;

  case 125: /* pfc_field: K_CODE  */
#line 912 "trafgen_parser.y"
                 { proto_field_set(PFC_OPCODE); }
#line 3156 "trafgen/trafgen_parser.tab.c"
    break;

  case 126: /* pfc_field: K_PRIO  */
#line 913 "trafgen_parser.y"
                 { proto_field_set(PFC_PRIO); }
#line 3162 "trafgen/trafgen_parser.tab.c"
    break;

  case 127: /* pfc_field: K_PRIO '(' number ')'  */
#line 915 "trafgen_parser.y"
                { if ((yyvsp[-1].number) > 7) {
		      yyerror("pfc: Invalid prio(index) parameter");
		      panic("pfc: prio(0)..prio(7) is allowed only\n");
		  }
		  proto_field_set(PFC_PRIO_0 + (yyvsp[-1].number)); }
#line 3172 "trafgen/trafgen_parser.tab.c"
    break;

  case 128: /* pfc_field: K_TIME '(' number ')'  */
#line 921 "trafgen_parser.y"
                { if ((yyvsp[-1].number) > 7) {
		      yyerror("pfc: Invalid time(index) parameter");
		      panic("pfc: time(0)..time(7) is allowed only\n");
		  }
		  proto_field_set(PFC_TIME_0 + (yyvsp[-1].number)); }
#line 3182 "trafgen/trafgen_parser.tab.c"
    break;

  case 129: /* pfc_expr: pfc_field field_expr skip_white '=' skip_white field_value_expr  */
#line 930 "trafgen_parser.y"
                { proto_field_expr_eval(); }
#line 3188 "trafgen/trafgen_parser.tab.c"
    break;

  case 130: /* pfc_expr: pfc_field skip_white '=' skip_white field_value_expr  */
#line 932 "trafgen_parser.y"
                { proto_field_expr_eval(); }
#line 3194 "trafgen/trafgen_parser.tab.c"
    break;

  case 131: /* vlan_proto: vlan '(' vlan_param_list ')'  */
#line 936 "trafgen_parser.y"
                                       { }
#line 3200 "trafgen/trafgen_parser.tab.c"
    break;

  case 132: /* vlan: K_VLAN  */
#line 940 "trafgen_parser.y"
                 { proto_add(PROTO_VLAN); }
#line 3206 "trafgen/trafgen_parser.tab.c"
    break;

  case 133: /* vlan_param_list: %empty  */
#line 944 "trafgen_parser.y"
          { }
#line 3212 "trafgen/trafgen_parser.tab.c"
    break;

  case 134: /* vlan_param_list: vlan_expr  */
#line 945 "trafgen_parser.y"
                    { }
#line 3218 "trafgen/trafgen_parser.tab.c"
    break;

  case 135: /* vlan_param_list: vlan_expr delimiter vlan_param_list  */
#line 946 "trafgen_parser.y"
                                              { }
#line 3224 "trafgen/trafgen_parser.tab.c"
    break;

  case 136: /* vlan_type: K_TPID  */
#line 950 "trafgen_parser.y"
                 { }
#line 3230 "trafgen/trafgen_parser.tab.c"
    break;

  case 138: /* vlan_field: vlan_type  */
#line 955 "trafgen_parser.y"
                    { proto_field_set(VLAN_TPID); }
#line 3236 "trafgen/trafgen_parser.tab.c"
    break;

  case 139: /* vlan_field: K_TCI  */
#line 956 "trafgen_parser.y"
                { proto_field_set(VLAN_TCI); }
#line 3242 "trafgen/trafgen_parser.tab.c"
    break;

  case 140: /* vlan_field: K_PCP  */
#line 957 "trafgen_parser.y"
                { proto_field_set(VLAN_PCP); }
#line 3248 "trafgen/trafgen_parser.tab.c"
    break;

  case 141: /* vlan_field: K_DEI  */
#line 958 "trafgen_parser.y"
                { proto_field_set(VLAN_DEI); }
#line 3254 "trafgen/trafgen_parser.tab.c"
    break;

  case 142: /* vlan_field: K_ID  */
#line 959 "trafgen_parser.y"
               { proto_field_set(VLAN_VID); }
#line 3260 "trafgen/trafgen_parser.tab.c"
    break;

  case 143: /* vlan_expr: vlan_field field_expr skip_white '=' skip_white field_value_expr  */
#line 964 "trafgen_parser.y"
                { proto_field_expr_eval(); }
#line 3266 "trafgen/trafgen_parser.tab.c"
    break;

  case 144: /* vlan_expr: vlan_field skip_white '=' skip_white field_value_expr  */
#line 966 "trafgen_parser.y"
                { proto_field_expr_eval(); }
#line 3272 "trafgen/trafgen_parser.tab.c"
    break;

  case 145: /* vlan_expr: K_1Q  */
#line 968 "trafgen_parser.y"
                { proto_hdr_field_set_be16(hdr, VLAN_TPID, ETH_P_8021Q); }
#line 3278 "trafgen/trafgen_parser.tab.c"
    break;

  case 146: /* vlan_expr: K_1AD  */
#line 970 "trafgen_parser.y"
                { proto_hdr_field_set_be16(hdr, VLAN_TPID, ETH_P_8021AD); }
#line 3284 "trafgen/trafgen_parser.tab.c"
    break;

  case 147: /* mpls_proto: mpls '(' mpls_param_list ')'  */
#line 974 "trafgen_parser.y"
                                       { }
#line 3290 "trafgen/trafgen_parser.tab.c"
    break;

  case 148: /* mpls: K_MPLS  */
#line 978 "trafgen_parser.y"
                 { proto_add(PROTO_MPLS); }
#line 3296 "trafgen/trafgen_parser.tab.c"
    break;

  case 149: /* mpls_param_list: %empty  */
#line 982 "trafgen_parser.y"
          { }
#line 3302 "trafgen/trafgen_parser.tab.c"
    break;

  case 150: /* mpls_param_list: mpls_expr  */
#line 983 "trafgen_parser.y"
                    { }
#line 3308 "trafgen/trafgen_parser.tab.c"
    break;

  case 151: /* mpls_param_list: mpls_expr delimiter mpls_param_list  */
#line 984 "trafgen_parser.y"
                                              { }
#line 3314 "trafgen/trafgen_parser.tab.c"
    break;

  case 152: /* mpls_tc: K_TC  */
#line 988 "trafgen_parser.y"
               { }
#line 3320 "trafgen/trafgen_parser.tab.c"
    break;

  case 153: /* mpls_tc: K_EXP  */
#line 989 "trafgen_parser.y"
                { }
#line 3326 "trafgen/trafgen_parser.tab.c"
    break;

  case 154: /* mpls_field: K_LABEL  */
#line 993 "trafgen_parser.y"
                  { proto_field_set(MPLS_LABEL); }
#line 3332 "trafgen/trafgen_parser.tab.c"
    break;

  case 155: /* mpls_field: mpls_tc  */
#line 994 "trafgen_parser.y"
                  { proto_field_set(MPLS_TC); }
#line 3338 "trafgen/trafgen_parser.tab.c"
    break;

  case 156: /* mpls_field: K_LAST  */
#line 995 "trafgen_parser.y"
                 { proto_field_set(MPLS_LAST); }
#line 3344 "trafgen/trafgen_parser.tab.c"
    break;

  case 157: /* mpls_field: K_TTL  */
#line 996 "trafgen_parser.y"
                { proto_field_set(MPLS_TTL); }
#line 3350 "trafgen/trafgen_parser.tab.c"
    break;

  case 158: /* mpls_expr: mpls_field field_expr skip_white '=' skip_white field_value_expr  */
#line 1001 "trafgen_parser.y"
                { proto_field_expr_eval(); }
#line 3356 "trafgen/trafgen_parser.tab.c"
    break;

  case 159: /* mpls_expr: mpls_field skip_white '=' skip_white field_value_expr  */
#line 1003 "trafgen_parser.y"
                { proto_field_expr_eval(); }
#line 3362 "trafgen/trafgen_parser.tab.c"
    break;

  case 160: /* arp_proto: arp '(' arp_param_list ')'  */
#line 1007 "trafgen_parser.y"
                                     { }
#line 3368 "trafgen/trafgen_parser.tab.c"
    break;

  case 161: /* arp_param_list: %empty  */
#line 1011 "trafgen_parser.y"
          { }
#line 3374 "trafgen/trafgen_parser.tab.c"
    break;

  case 162: /* arp_param_list: arp_expr  */
#line 1012 "trafgen_parser.y"
                   { }
#line 3380 "trafgen/trafgen_parser.tab.c"
    break;

  case 163: /* arp_param_list: arp_expr delimiter arp_param_list  */
#line 1013 "trafgen_parser.y"
                                            { }
#line 3386 "trafgen/trafgen_parser.tab.c"
    break;

  case 164: /* arp_field: K_HTYPE  */
#line 1018 "trafgen_parser.y"
                { proto_field_set(ARP_HTYPE); }
#line 3392 "trafgen/trafgen_parser.tab.c"
    break;

  case 165: /* arp_field: K_PTYPE  */
#line 1020 "trafgen_parser.y"
                { proto_field_set(ARP_PTYPE); }
#line 3398 "trafgen/trafgen_parser.tab.c"
    break;

  case 166: /* arp_field: K_SHA  */
#line 1022 "trafgen_parser.y"
                { proto_field_set(ARP_SHA); }
#line 3404 "trafgen/trafgen_parser.tab.c"
    break;

  case 167: /* arp_field: K_THA  */
#line 1024 "trafgen_parser.y"
                { proto_field_set(ARP_THA); }
#line 3410 "trafgen/trafgen_parser.tab.c"
    break;

  case 168: /* arp_field: K_SPA  */
#line 1026 "trafgen_parser.y"
                { proto_field_set(ARP_SPA); }
#line 3416 "trafgen/trafgen_parser.tab.c"
    break;

  case 169: /* arp_field: K_TPA  */
#line 1028 "trafgen_parser.y"
                { proto_field_set(ARP_TPA); }
#line 3422 "trafgen/trafgen_parser.tab.c"
    break;

  case 170: /* arp_expr: arp_field field_expr skip_white '=' skip_white field_value_expr  */
#line 1033 "trafgen_parser.y"
                { proto_field_expr_eval(); }
#line 3428 "trafgen/trafgen_parser.tab.c"
    break;

  case 171: /* arp_expr: arp_field skip_white '=' skip_white field_value_expr  */
#line 1035 "trafgen_parser.y"
                { proto_field_expr_eval(); }
#line 3434 "trafgen/trafgen_parser.tab.c"
    break;

  case 172: /* arp_expr: K_OPER field_expr skip_white '=' skip_white field_value_expr  */
#line 1037 "trafgen_parser.y"
                { proto_field_set(ARP_OPER);
		  proto_field_expr_eval(); }
#line 3441 "trafgen/trafgen_parser.tab.c"
    break;

  case 173: /* arp_expr: K_OPER skip_white '=' skip_white field_value_expr  */
#line 1040 "trafgen_parser.y"
                { proto_field_set(ARP_OPER);
		  proto_field_expr_eval(); }
#line 3448 "trafgen/trafgen_parser.tab.c"
    break;

  case 174: /* arp_expr: K_OPER skip_white '=' skip_white K_REQUEST  */
#line 1043 "trafgen_parser.y"
                { proto_hdr_field_set_be16(hdr, ARP_OPER, ARPOP_REQUEST); }
#line 3454 "trafgen/trafgen_parser.tab.c"
    break;

  case 175: /* arp_expr: K_OPER skip_white '=' skip_white K_REPLY  */
#line 1045 "trafgen_parser.y"
                { proto_hdr_field_set_be16(hdr, ARP_OPER, ARPOP_REPLY); }
#line 3460 "trafgen/trafgen_parser.tab.c"
    break;

  case 176: /* arp_expr: K_REQUEST  */
#line 1047 "trafgen_parser.y"
                { proto_hdr_field_set_be16(hdr, ARP_OPER, ARPOP_REQUEST); }
#line 3466 "trafgen/trafgen_parser.tab.c"
    break;

  case 177: /* arp_expr: K_REPLY  */
#line 1049 "trafgen_parser.y"
                { proto_hdr_field_set_be16(hdr, ARP_OPER, ARPOP_REPLY); }
#line 3472 "trafgen/trafgen_parser.tab.c"
    break;

  case 178: /* arp: K_ARP  */
#line 1053 "trafgen_parser.y"
                { proto_add(PROTO_ARP); }
#line 3478 "trafgen/trafgen_parser.tab.c"
    break;

  case 179: /* ip4_proto: ip4 '(' ip4_param_list ')'  */
#line 1057 "trafgen_parser.y"
                                     { }
#line 3484 "trafgen/trafgen_parser.tab.c"
    break;

  case 180: /* ip4_param_list: %empty  */
#line 1061 "trafgen_parser.y"
          { }
#line 3490 "trafgen/trafgen_parser.tab.c"
    break;

  case 181: /* ip4_param_list: ip4_expr  */
#line 1062 "trafgen_parser.y"
                   { }
#line 3496 "trafgen/trafgen_parser.tab.c"
    break;

  case 182: /* ip4_param_list: ip4_expr delimiter ip4_param_list  */
#line 1063 "trafgen_parser.y"
                                            { }
#line 3502 "trafgen/trafgen_parser.tab.c"
    break;

  case 183: /* ip4_field: K_VER  */
#line 1067 "trafgen_parser.y"
                { proto_field_set(IP4_VER); }
#line 3508 "trafgen/trafgen_parser.tab.c"
    break;

  case 184: /* ip4_field: K_IHL  */
#line 1068 "trafgen_parser.y"
                { proto_field_set(IP4_IHL); }
#line 3514 "trafgen/trafgen_parser.tab.c"
    break;

  case 185: /* ip4_field: K_DADDR  */
#line 1069 "trafgen_parser.y"
                  { proto_field_set(IP4_DADDR); }
#line 3520 "trafgen/trafgen_parser.tab.c"
    break;

  case 186: /* ip4_field: K_SADDR  */
#line 1070 "trafgen_parser.y"
                  { proto_field_set(IP4_SADDR); }
#line 3526 "trafgen/trafgen_parser.tab.c"
    break;

  case 187: /* ip4_field: K_PROT  */
#line 1071 "trafgen_parser.y"
                 { proto_field_set(IP4_PROTO); }
#line 3532 "trafgen/trafgen_parser.tab.c"
    break;

  case 188: /* ip4_field: K_TTL  */
#line 1072 "trafgen_parser.y"
                { proto_field_set(IP4_TTL); }
#line 3538 "trafgen/trafgen_parser.tab.c"
    break;

  case 189: /* ip4_field: K_DSCP  */
#line 1073 "trafgen_parser.y"
                 { proto_field_set(IP4_DSCP); }
#line 3544 "trafgen/trafgen_parser.tab.c"
    break;

  case 190: /* ip4_field: K_ECN  */
#line 1074 "trafgen_parser.y"
                { proto_field_set(IP4_ECN); }
#line 3550 "trafgen/trafgen_parser.tab.c"
    break;

  case 191: /* ip4_field: K_TOS  */
#line 1075 "trafgen_parser.y"
                { proto_field_set(IP4_TOS); }
#line 3556 "trafgen/trafgen_parser.tab.c"
    break;

  case 192: /* ip4_field: K_LEN  */
#line 1076 "trafgen_parser.y"
                { proto_field_set(IP4_LEN); }
#line 3562 "trafgen/trafgen_parser.tab.c"
    break;

  case 193: /* ip4_field: K_ID  */
#line 1077 "trafgen_parser.y"
               { proto_field_set(IP4_ID); }
#line 3568 "trafgen/trafgen_parser.tab.c"
    break;

  case 194: /* ip4_field: K_FLAGS  */
#line 1078 "trafgen_parser.y"
                  { proto_field_set(IP4_FLAGS); }
#line 3574 "trafgen/trafgen_parser.tab.c"
    break;

  case 195: /* ip4_field: K_FRAG  */
#line 1079 "trafgen_parser.y"
                 { proto_field_set(IP4_FRAG_OFFS); }
#line 3580 "trafgen/trafgen_parser.tab.c"
    break;

  case 196: /* ip4_field: K_CSUM  */
#line 1080 "trafgen_parser.y"
                 { proto_field_set(IP4_CSUM); }
#line 3586 "trafgen/trafgen_parser.tab.c"
    break;

  case 197: /* ip4_expr: ip4_field field_expr skip_white '=' skip_white field_value_expr  */
#line 1085 "trafgen_parser.y"
                { proto_field_expr_eval(); }
#line 3592 "trafgen/trafgen_parser.tab.c"
    break;

  case 198: /* ip4_expr: ip4_field skip_white '=' skip_white field_value_expr  */
#line 1087 "trafgen_parser.y"
                { proto_field_expr_eval(); }
#line 3598 "trafgen/trafgen_parser.tab.c"
    break;

  case 199: /* ip4_expr: K_DF  */
#line 1088 "trafgen_parser.y"
                { proto_hdr_field_set_be16(hdr, IP4_DF, 1); }
#line 3604 "trafgen/trafgen_parser.tab.c"
    break;

  case 200: /* ip4_expr: K_MF  */
#line 1089 "trafgen_parser.y"
                { proto_hdr_field_set_be16(hdr, IP4_MF, 1); }
#line 3610 "trafgen/trafgen_parser.tab.c"
    break;

  case 201: /* ip4: K_IP4  */
#line 1093 "trafgen_parser.y"
                { proto_add(PROTO_IP4); }
#line 3616 "trafgen/trafgen_parser.tab.c"
    break;

  case 202: /* ip6_proto: ip6 '(' ip6_param_list ')'  */
#line 1097 "trafgen_parser.y"
                                     { }
#line 3622 "trafgen/trafgen_parser.tab.c"
    break;

  case 203: /* ip6_param_list: %empty  */
#line 1101 "trafgen_parser.y"
          { }
#line 3628 "trafgen/trafgen_parser.tab.c"
    break;

  case 204: /* ip6_param_list: ip6_expr  */
#line 1102 "trafgen_parser.y"
                   { }
#line 3634 "trafgen/trafgen_parser.tab.c"
    break;

  case 205: /* ip6_param_list: ip6_expr delimiter ip6_param_list  */
#line 1103 "trafgen_parser.y"
                                            { }
#line 3640 "trafgen/trafgen_parser.tab.c"
    break;

  case 206: /* ip6_hop_limit: K_HOP_LIMIT  */
#line 1107 "trafgen_parser.y"
                      { }
#line 3646 "trafgen/trafgen_parser.tab.c"
    break;

  case 207: /* ip6_hop_limit: K_TTL  */
#line 1108 "trafgen_parser.y"
                { }
#line 3652 "trafgen/trafgen_parser.tab.c"
    break;

  case 208: /* ip6_field: K_VER  */
#line 1112 "trafgen_parser.y"
                { proto_field_set(IP6_VER); }
#line 3658 "trafgen/trafgen_parser.tab.c"
    break;

  case 209: /* ip6_field: K_TC  */
#line 1113 "trafgen_parser.y"
               { proto_field_set(IP6_CLASS); }
#line 3664 "trafgen/trafgen_parser.tab.c"
    break;

  case 210: /* ip6_field: K_FLOW  */
#line 1114 "trafgen_parser.y"
                 { proto_field_set(IP6_FLOW_LBL); }
#line 3670 "trafgen/trafgen_parser.tab.c"
    break;

  case 211: /* ip6_field: K_LEN  */
#line 1115 "trafgen_parser.y"
                { proto_field_set(IP6_LEN); }
#line 3676 "trafgen/trafgen_parser.tab.c"
    break;

  case 212: /* ip6_field: K_NEXT_HDR  */
#line 1116 "trafgen_parser.y"
                     { proto_field_set(IP6_NEXT_HDR); }
#line 3682 "trafgen/trafgen_parser.tab.c"
    break;

  case 213: /* ip6_field: ip6_hop_limit  */
#line 1117 "trafgen_parser.y"
                        { proto_field_set(IP6_HOP_LIMIT); }
#line 3688 "trafgen/trafgen_parser.tab.c"
    break;

  case 214: /* ip6_field: K_SADDR  */
#line 1118 "trafgen_parser.y"
                  { proto_field_set(IP6_SADDR); }
#line 3694 "trafgen/trafgen_parser.tab.c"
    break;

  case 215: /* ip6_field: K_DADDR  */
#line 1119 "trafgen_parser.y"
                  { proto_field_set(IP6_DADDR) ; }
#line 3700 "trafgen/trafgen_parser.tab.c"
    break;

  case 216: /* ip6_expr: ip6_field field_expr skip_white '=' skip_white field_value_expr  */
#line 1124 "trafgen_parser.y"
                { proto_field_expr_eval(); }
#line 3706 "trafgen/trafgen_parser.tab.c"
    break;

  case 217: /* ip6_expr: ip6_field skip_white '=' skip_white field_value_expr  */
#line 1126 "trafgen_parser.y"
                { proto_field_expr_eval(); }
#line 3712 "trafgen/trafgen_parser.tab.c"
    break;

  case 218: /* ip6: K_IP6  */
#line 1130 "trafgen_parser.y"
                { proto_add(PROTO_IP6); }
#line 3718 "trafgen/trafgen_parser.tab.c"
    break;

  case 219: /* icmp4_proto: icmp4 '(' icmp4_param_list ')'  */
#line 1134 "trafgen_parser.y"
                                         { }
#line 3724 "trafgen/trafgen_parser.tab.c"
    break;

  case 220: /* icmp4_param_list: %empty  */
#line 1138 "trafgen_parser.y"
          { }
#line 3730 "trafgen/trafgen_parser.tab.c"
    break;

  case 221: /* icmp4_param_list: icmp4_expr  */
#line 1139 "trafgen_parser.y"
                     { }
#line 3736 "trafgen/trafgen_parser.tab.c"
    break;

  case 222: /* icmp4_param_list: icmp4_expr delimiter icmp4_param_list  */
#line 1140 "trafgen_parser.y"
                                                { }
#line 3742 "trafgen/trafgen_parser.tab.c"
    break;

  case 223: /* icmp4_field: K_TYPE  */
#line 1144 "trafgen_parser.y"
                 { proto_field_set(ICMPV4_TYPE); }
#line 3748 "trafgen/trafgen_parser.tab.c"
    break;

  case 224: /* icmp4_field: K_CODE  */
#line 1145 "trafgen_parser.y"
                 { proto_field_set(ICMPV4_CODE); }
#line 3754 "trafgen/trafgen_parser.tab.c"
    break;

  case 225: /* icmp4_field: K_ID  */
#line 1146 "trafgen_parser.y"
               { proto_field_set(ICMPV4_ID); }
#line 3760 "trafgen/trafgen_parser.tab.c"
    break;

  case 226: /* icmp4_field: K_SEQ  */
#line 1147 "trafgen_parser.y"
                { proto_field_set(ICMPV4_SEQ); }
#line 3766 "trafgen/trafgen_parser.tab.c"
    break;

  case 227: /* icmp4_field: K_MTU  */
#line 1148 "trafgen_parser.y"
                { proto_field_set(ICMPV4_MTU); }
#line 3772 "trafgen/trafgen_parser.tab.c"
    break;

  case 228: /* icmp4_field: K_ADDR  */
#line 1149 "trafgen_parser.y"
                 { proto_field_set(ICMPV4_REDIR_ADDR); }
#line 3778 "trafgen/trafgen_parser.tab.c"
    break;

  case 229: /* icmp4_expr: icmp4_field field_expr skip_white '=' skip_white field_value_expr  */
#line 1154 "trafgen_parser.y"
                { proto_field_expr_eval(); }
#line 3784 "trafgen/trafgen_parser.tab.c"
    break;

  case 230: /* icmp4_expr: icmp4_field skip_white '=' skip_white field_value_expr  */
#line 1156 "trafgen_parser.y"
                { proto_field_expr_eval(); }
#line 3790 "trafgen/trafgen_parser.tab.c"
    break;

  case 231: /* icmp4_expr: K_ECHO_REQUEST  */
#line 1158 "trafgen_parser.y"
                { proto_hdr_field_set_u8(hdr, ICMPV4_TYPE, ICMP_ECHO);
		  proto_hdr_field_set_u8(hdr, ICMPV4_CODE, 0); }
#line 3797 "trafgen/trafgen_parser.tab.c"
    break;

  case 232: /* icmp4_expr: K_ECHO_REPLY  */
#line 1161 "trafgen_parser.y"
                { proto_hdr_field_set_u8(hdr, ICMPV4_TYPE, ICMP_ECHOREPLY);
		  proto_hdr_field_set_u8(hdr, ICMPV4_CODE, 0); }
#line 3804 "trafgen/trafgen_parser.tab.c"
    break;

  case 233: /* icmp4: K_ICMP4  */
#line 1166 "trafgen_parser.y"
                        { proto_add(PROTO_ICMP4); }
#line 3810 "trafgen/trafgen_parser.tab.c"
    break;

  case 234: /* icmpv6_proto: icmp6 '(' icmp6_param_list ')'  */
#line 1170 "trafgen_parser.y"
                                         { }
#line 3816 "trafgen/trafgen_parser.tab.c"
    break;

  case 235: /* icmp6_param_list: %empty  */
#line 1174 "trafgen_parser.y"
          { }
#line 3822 "trafgen/trafgen_parser.tab.c"
    break;

  case 236: /* icmp6_param_list: icmp6_expr  */
#line 1175 "trafgen_parser.y"
                     { }
#line 3828 "trafgen/trafgen_parser.tab.c"
    break;

  case 237: /* icmp6_param_list: icmp6_expr delimiter icmp6_param_list  */
#line 1176 "trafgen_parser.y"
                                                { }
#line 3834 "trafgen/trafgen_parser.tab.c"
    break;

  case 238: /* icmp6_field: K_CODE  */
#line 1180 "trafgen_parser.y"
                 { proto_field_set(ICMPV6_CODE); }
#line 3840 "trafgen/trafgen_parser.tab.c"
    break;

  case 239: /* icmp6_field: K_CSUM  */
#line 1181 "trafgen_parser.y"
                 { proto_field_set(ICMPV6_CSUM); }
#line 3846 "trafgen/trafgen_parser.tab.c"
    break;

  case 240: /* icmp6_expr: icmp6_field field_expr skip_white '=' skip_white field_value_expr  */
#line 1186 "trafgen_parser.y"
                { proto_field_expr_eval(); }
#line 3852 "trafgen/trafgen_parser.tab.c"
    break;

  case 241: /* icmp6_expr: icmp6_field skip_white '=' skip_white field_value_expr  */
#line 1188 "trafgen_parser.y"
                { proto_field_expr_eval(); }
#line 3858 "trafgen/trafgen_parser.tab.c"
    break;

  case 242: /* icmp6_expr: K_TYPE field_expr skip_white '=' skip_white field_value_expr  */
#line 1190 "trafgen_parser.y"
                { proto_field_set(ICMPV6_TYPE);
		  proto_field_expr_eval(); }
#line 3865 "trafgen/trafgen_parser.tab.c"
    break;

  case 243: /* icmp6_expr: K_TYPE skip_white '=' skip_white field_value_expr  */
#line 1193 "trafgen_parser.y"
                { proto_field_set(ICMPV6_TYPE);
		  proto_field_expr_eval(); }
#line 3872 "trafgen/trafgen_parser.tab.c"
    break;

  case 244: /* icmp6_expr: K_TYPE skip_white '=' K_ECHO_REQUEST  */
#line 1196 "trafgen_parser.y"
                { proto_hdr_field_set_u8(hdr, ICMPV6_TYPE, ICMPV6_ECHO_REQUEST); }
#line 3878 "trafgen/trafgen_parser.tab.c"
    break;

  case 245: /* icmp6_expr: K_ECHO_REQUEST  */
#line 1198 "trafgen_parser.y"
                { proto_hdr_field_set_u8(hdr, ICMPV6_TYPE, ICMPV6_ECHO_REQUEST); }
#line 3884 "trafgen/trafgen_parser.tab.c"
    break;

  case 246: /* icmp6_expr: K_TYPE skip_white '=' K_ECHO_REPLY  */
#line 1200 "trafgen_parser.y"
                { proto_hdr_field_set_u8(hdr, ICMPV6_TYPE, ICMPV6_ECHO_REPLY); }
#line 3890 "trafgen/trafgen_parser.tab.c"
    break;

  case 247: /* icmp6_expr: K_ECHO_REPLY  */
#line 1202 "trafgen_parser.y"
                { proto_hdr_field_set_u8(hdr, ICMPV6_TYPE, ICMPV6_ECHO_REPLY); }
#line 3896 "trafgen/trafgen_parser.tab.c"
    break;

  case 248: /* icmp6: K_ICMP6  */
#line 1205 "trafgen_parser.y"
                  { proto_add(PROTO_ICMP6); }
#line 3902 "trafgen/trafgen_parser.tab.c"
    break;

  case 249: /* udp_proto: udp '(' udp_param_list ')'  */
#line 1209 "trafgen_parser.y"
                                     { }
#line 3908 "trafgen/trafgen_parser.tab.c"
    break;

  case 250: /* udp_param_list: %empty  */
#line 1213 "trafgen_parser.y"
          { }
#line 3914 "trafgen/trafgen_parser.tab.c"
    break;

  case 251: /* udp_param_list: udp_expr  */
#line 1214 "trafgen_parser.y"
                   { }
#line 3920 "trafgen/trafgen_parser.tab.c"
    break;

  case 252: /* udp_param_list: udp_expr delimiter udp_param_list  */
#line 1215 "trafgen_parser.y"
                                            { }
#line 3926 "trafgen/trafgen_parser.tab.c"
    break;

  case 253: /* udp_field: K_SPORT  */
#line 1219 "trafgen_parser.y"
                  { proto_field_set(UDP_SPORT); }
#line 3932 "trafgen/trafgen_parser.tab.c"
    break;

  case 254: /* udp_field: K_DPORT  */
#line 1220 "trafgen_parser.y"
                  { proto_field_set(UDP_DPORT); }
#line 3938 "trafgen/trafgen_parser.tab.c"
    break;

  case 255: /* udp_field: K_LEN  */
#line 1221 "trafgen_parser.y"
                { proto_field_set(UDP_LEN); }
#line 3944 "trafgen/trafgen_parser.tab.c"
    break;

  case 256: /* udp_field: K_CSUM  */
#line 1222 "trafgen_parser.y"
                 { proto_field_set(UDP_CSUM); }
#line 3950 "trafgen/trafgen_parser.tab.c"
    break;

  case 257: /* udp_expr: udp_field field_expr skip_white '=' skip_white field_value_expr  */
#line 1227 "trafgen_parser.y"
                { proto_field_expr_eval(); }
#line 3956 "trafgen/trafgen_parser.tab.c"
    break;

  case 258: /* udp_expr: udp_field skip_white '=' skip_white field_value_expr  */
#line 1229 "trafgen_parser.y"
                { proto_field_expr_eval(); }
#line 3962 "trafgen/trafgen_parser.tab.c"
    break;

  case 259: /* udp: K_UDP  */
#line 1233 "trafgen_parser.y"
                { proto_add(PROTO_UDP); }
#line 3968 "trafgen/trafgen_parser.tab.c"
    break;

  case 260: /* tcp_proto: tcp '(' tcp_param_list ')'  */
#line 1237 "trafgen_parser.y"
                                     { }
#line 3974 "trafgen/trafgen_parser.tab.c"
    break;

  case 261: /* tcp_param_list: %empty  */
#line 1241 "trafgen_parser.y"
          { }
#line 3980 "trafgen/trafgen_parser.tab.c"
    break;

  case 262: /* tcp_param_list: tcp_expr  */
#line 1242 "trafgen_parser.y"
                   { }
#line 3986 "trafgen/trafgen_parser.tab.c"
    break;

  case 263: /* tcp_param_list: tcp_expr delimiter tcp_param_list  */
#line 1243 "trafgen_parser.y"
                                            { }
#line 3992 "trafgen/trafgen_parser.tab.c"
    break;

  case 264: /* tcp_field: K_SPORT  */
#line 1247 "trafgen_parser.y"
                  { proto_field_set(TCP_SPORT); }
#line 3998 "trafgen/trafgen_parser.tab.c"
    break;

  case 265: /* tcp_field: K_DPORT  */
#line 1248 "trafgen_parser.y"
                  { proto_field_set(TCP_DPORT); }
#line 4004 "trafgen/trafgen_parser.tab.c"
    break;

  case 266: /* tcp_field: K_SEQ  */
#line 1249 "trafgen_parser.y"
                { proto_field_set(TCP_SEQ); }
#line 4010 "trafgen/trafgen_parser.tab.c"
    break;

  case 267: /* tcp_field: K_ACK_SEQ  */
#line 1250 "trafgen_parser.y"
                    { proto_field_set(TCP_ACK_SEQ); }
#line 4016 "trafgen/trafgen_parser.tab.c"
    break;

  case 268: /* tcp_field: K_DOFF  */
#line 1251 "trafgen_parser.y"
                 { proto_field_set(TCP_DOFF); }
#line 4022 "trafgen/trafgen_parser.tab.c"
    break;

  case 269: /* tcp_field: K_WINDOW  */
#line 1252 "trafgen_parser.y"
                   { proto_field_set(TCP_WINDOW); }
#line 4028 "trafgen/trafgen_parser.tab.c"
    break;

  case 270: /* tcp_field: K_CSUM  */
#line 1253 "trafgen_parser.y"
                 { proto_field_set(TCP_CSUM); }
#line 4034 "trafgen/trafgen_parser.tab.c"
    break;

  case 271: /* tcp_field: K_URG_PTR  */
#line 1254 "trafgen_parser.y"
                    { proto_field_set(TCP_URG_PTR); }
#line 4040 "trafgen/trafgen_parser.tab.c"
    break;

  case 272: /* tcp_expr: tcp_field field_expr skip_white '=' skip_white field_value_expr  */
#line 1259 "trafgen_parser.y"
                { proto_field_expr_eval(); }
#line 4046 "trafgen/trafgen_parser.tab.c"
    break;

  case 273: /* tcp_expr: tcp_field skip_white '=' skip_white field_value_expr  */
#line 1261 "trafgen_parser.y"
                { proto_field_expr_eval(); }
#line 4052 "trafgen/trafgen_parser.tab.c"
    break;

  case 274: /* tcp_expr: K_CWR  */
#line 1262 "trafgen_parser.y"
                { proto_hdr_field_set_be16(hdr, TCP_CWR, 1); }
#line 4058 "trafgen/trafgen_parser.tab.c"
    break;

  case 275: /* tcp_expr: K_ECE  */
#line 1263 "trafgen_parser.y"
                { proto_hdr_field_set_be16(hdr, TCP_ECE, 1); }
#line 4064 "trafgen/trafgen_parser.tab.c"
    break;

  case 276: /* tcp_expr: K_URG  */
#line 1264 "trafgen_parser.y"
                { proto_hdr_field_set_be16(hdr, TCP_URG, 1); }
#line 4070 "trafgen/trafgen_parser.tab.c"
    break;

  case 277: /* tcp_expr: K_ACK  */
#line 1265 "trafgen_parser.y"
                { proto_hdr_field_set_be16(hdr, TCP_ACK, 1); }
#line 4076 "trafgen/trafgen_parser.tab.c"
    break;

  case 278: /* tcp_expr: K_PSH  */
#line 1266 "trafgen_parser.y"
                { proto_hdr_field_set_be16(hdr, TCP_PSH, 1); }
#line 4082 "trafgen/trafgen_parser.tab.c"
    break;

  case 279: /* tcp_expr: K_RST  */
#line 1267 "trafgen_parser.y"
                { proto_hdr_field_set_be16(hdr, TCP_RST, 1); }
#line 4088 "trafgen/trafgen_parser.tab.c"
    break;

  case 280: /* tcp_expr: K_SYN  */
#line 1268 "trafgen_parser.y"
                { proto_hdr_field_set_be16(hdr, TCP_SYN, 1); }
#line 4094 "trafgen/trafgen_parser.tab.c"
    break;

  case 281: /* tcp_expr: K_FIN  */
#line 1269 "trafgen_parser.y"
                { proto_hdr_field_set_be16(hdr, TCP_FIN, 1); }
#line 4100 "trafgen/trafgen_parser.tab.c"
    break;

  case 282: /* tcp: K_TCP  */
#line 1273 "trafgen_parser.y"
                { proto_add(PROTO_TCP); }
#line 4106 "trafgen/trafgen_parser.tab.c"
    break;

  case 283: /* dns_proto: dns '(' dns_param_list ')'  */
#line 1277 "trafgen_parser.y"
                                     { }
#line 4112 "trafgen/trafgen_parser.tab.c"
    break;

  case 284: /* dns_param_list: %empty  */
#line 1281 "trafgen_parser.y"
          { }
#line 4118 "trafgen/trafgen_parser.tab.c"
    break;

  case 285: /* dns_param_list: dns_expr  */
#line 1282 "trafgen_parser.y"
                   { }
#line 4124 "trafgen/trafgen_parser.tab.c"
    break;

  case 286: /* dns_param_list: dns_expr delimiter dns_param_list  */
#line 1283 "trafgen_parser.y"
                                            { }
#line 4130 "trafgen/trafgen_parser.tab.c"
    break;

  case 287: /* dns_field: K_ID  */
#line 1287 "trafgen_parser.y"
               { proto_field_set(DNS_ID); }
#line 4136 "trafgen/trafgen_parser.tab.c"
    break;

  case 288: /* dns_field: K_QR  */
#line 1288 "trafgen_parser.y"
               { proto_field_set(DNS_QR); }
#line 4142 "trafgen/trafgen_parser.tab.c"
    break;

  case 289: /* dns_field: K_OPER  */
#line 1289 "trafgen_parser.y"
                 { proto_field_set(DNS_OPCODE); }
#line 4148 "trafgen/trafgen_parser.tab.c"
    break;

  case 290: /* dns_field: K_AANSWER  */
#line 1290 "trafgen_parser.y"
                    { proto_field_set(DNS_AA); }
#line 4154 "trafgen/trafgen_parser.tab.c"
    break;

  case 291: /* dns_field: K_TRUNC  */
#line 1291 "trafgen_parser.y"
                  { proto_field_set(DNS_TC); }
#line 4160 "trafgen/trafgen_parser.tab.c"
    break;

  case 292: /* dns_field: K_RDESIRED  */
#line 1292 "trafgen_parser.y"
                     { proto_field_set(DNS_RD); }
#line 4166 "trafgen/trafgen_parser.tab.c"
    break;

  case 293: /* dns_field: K_RAVAIL  */
#line 1293 "trafgen_parser.y"
                   { proto_field_set(DNS_RA); }
#line 4172 "trafgen/trafgen_parser.tab.c"
    break;

  case 294: /* dns_field: K_ZERO  */
#line 1294 "trafgen_parser.y"
                 { proto_field_set(DNS_ZERO); }
#line 4178 "trafgen/trafgen_parser.tab.c"
    break;

  case 295: /* dns_field: K_RCODE  */
#line 1295 "trafgen_parser.y"
                  { proto_field_set(DNS_RCODE); }
#line 4184 "trafgen/trafgen_parser.tab.c"
    break;

  case 296: /* dns_field: K_QDCOUNT  */
#line 1296 "trafgen_parser.y"
                    { proto_field_set(DNS_QD_COUNT); }
#line 4190 "trafgen/trafgen_parser.tab.c"
    break;

  case 297: /* dns_field: K_ANCOUNT  */
#line 1297 "trafgen_parser.y"
                    { proto_field_set(DNS_AN_COUNT); }
#line 4196 "trafgen/trafgen_parser.tab.c"
    break;

  case 298: /* dns_field: K_NSCOUNT  */
#line 1298 "trafgen_parser.y"
                    { proto_field_set(DNS_NS_COUNT); }
#line 4202 "trafgen/trafgen_parser.tab.c"
    break;

  case 299: /* dns_field: K_ARCOUNT  */
#line 1299 "trafgen_parser.y"
                    { proto_field_set(DNS_AR_COUNT); }
#line 4208 "trafgen/trafgen_parser.tab.c"
    break;

  case 300: /* dns_query: K_QUERY  */
#line 1303 "trafgen_parser.y"
                  { proto_push_sub_hdr(DNS_QUERY_HDR); }
#line 4214 "trafgen/trafgen_parser.tab.c"
    break;

  case 301: /* dns_query_name: K_NAME  */
#line 1307 "trafgen_parser.y"
                 { proto_field_set(DNS_QUERY_NAME); }
#line 4220 "trafgen/trafgen_parser.tab.c"
    break;

  case 302: /* dns_query_field: K_TYPE  */
#line 1311 "trafgen_parser.y"
                 { proto_field_set(DNS_QUERY_TYPE); }
#line 4226 "trafgen/trafgen_parser.tab.c"
    break;

  case 303: /* dns_query_field: K_CLASS  */
#line 1312 "trafgen_parser.y"
                  { proto_field_set(DNS_QUERY_CLASS); }
#line 4232 "trafgen/trafgen_parser.tab.c"
    break;

  case 304: /* dns_query_expr: dns_query_field field_expr skip_white '=' skip_white field_value_expr  */
#line 1317 "trafgen_parser.y"
                { proto_field_expr_eval(); }
#line 4238 "trafgen/trafgen_parser.tab.c"
    break;

  case 305: /* dns_query_expr: dns_query_field skip_white '=' skip_white field_value_expr  */
#line 1319 "trafgen_parser.y"
                { proto_field_expr_eval(); }
#line 4244 "trafgen/trafgen_parser.tab.c"
    break;

  case 306: /* dns_query_expr: dns_query_name field_expr skip_white '=' skip_white field_value_expr  */
#line 1321 "trafgen_parser.y"
                { if (field_expr.type & FIELD_EXPR_STRING)
			field_expr.type = FIELD_EXPR_FQDN;
		  proto_field_expr_eval(); }
#line 4252 "trafgen/trafgen_parser.tab.c"
    break;

  case 307: /* dns_query_expr: dns_query_name skip_white '=' skip_white field_value_expr  */
#line 1325 "trafgen_parser.y"
                { if (field_expr.type & FIELD_EXPR_STRING)
			field_expr.type = FIELD_EXPR_FQDN;
		  proto_field_expr_eval(); }
#line 4260 "trafgen/trafgen_parser.tab.c"
    break;

  case 308: /* dns_query_param_list: %empty  */
#line 1331 "trafgen_parser.y"
          { }
#line 4266 "trafgen/trafgen_parser.tab.c"
    break;

  case 309: /* dns_query_param_list: dns_query_expr  */
#line 1332 "trafgen_parser.y"
                         { }
#line 4272 "trafgen/trafgen_parser.tab.c"
    break;

  case 310: /* dns_query_param_list: dns_query_expr delimiter dns_query_param_list  */
#line 1333 "trafgen_parser.y"
                                                        { }
#line 4278 "trafgen/trafgen_parser.tab.c"
    break;

  case 311: /* dns_query_hdr: dns_query '(' dns_query_param_list ')'  */
#line 1337 "trafgen_parser.y"
                                                 { }
#line 4284 "trafgen/trafgen_parser.tab.c"
    break;

  case 312: /* dns_rrecord: K_ANSWER  */
#line 1341 "trafgen_parser.y"
                   { proto_push_sub_hdr(DNS_ANSWER_HDR); }
#line 4290 "trafgen/trafgen_parser.tab.c"
    break;

  case 313: /* dns_rrecord: K_AUTH  */
#line 1342 "trafgen_parser.y"
                 { proto_push_sub_hdr(DNS_AUTH_HDR); }
#line 4296 "trafgen/trafgen_parser.tab.c"
    break;

  case 314: /* dns_rrecord: K_ADD  */
#line 1343 "trafgen_parser.y"
                { proto_push_sub_hdr(DNS_ADD_HDR); }
#line 4302 "trafgen/trafgen_parser.tab.c"
    break;

  case 315: /* dns_rrecord_name: K_NAME  */
#line 1347 "trafgen_parser.y"
                 { proto_field_set(DNS_RRECORD_NAME); }
#line 4308 "trafgen/trafgen_parser.tab.c"
    break;

  case 316: /* dns_rrecord_data_addr: ip4_addr  */
#line 1352 "trafgen_parser.y"
                { proto_hdr_field_set_u32(hdr, DNS_RRECORD_DATA, (yyvsp[0].ip4_addr).s_addr);
		  proto_hdr_field_set_be16(hdr, DNS_RRECORD_TYPE, 1); }
#line 4315 "trafgen/trafgen_parser.tab.c"
    break;

  case 317: /* dns_rrecord_data_addr: ip6_addr  */
#line 1355 "trafgen_parser.y"
                { proto_hdr_field_set_bytes(hdr, DNS_RRECORD_DATA, (uint8_t *)&(yyvsp[0].ip6_addr).s6_addr, 16);
		  proto_hdr_field_set_be16(hdr, DNS_RRECORD_TYPE, 28); }
#line 4322 "trafgen/trafgen_parser.tab.c"
    break;

  case 318: /* dns_rrecord_data_fqdn: string  */
#line 1361 "trafgen_parser.y"
                { char *str = xstrdup((yyvsp[0].str) + 1);
		  char *fqdn;
		  str[strlen((yyvsp[0].str) + 1) - 1] = '\0';
		  fqdn = str2fqdn(str);
		  proto_hdr_field_set_bytes(hdr, DNS_RRECORD_DATA, (uint8_t *) fqdn, strlen(fqdn) + 1);
		  xfree(str);
		  xfree(fqdn); }
#line 4334 "trafgen/trafgen_parser.tab.c"
    break;

  case 319: /* dns_rrecord_data_expr: K_ADDR '(' skip_white dns_rrecord_data_addr skip_white ')'  */
#line 1372 "trafgen_parser.y"
                { }
#line 4340 "trafgen/trafgen_parser.tab.c"
    break;

  case 320: /* dns_rrecord_data_expr: K_NS '(' skip_white dns_rrecord_data_fqdn skip_white ')'  */
#line 1374 "trafgen_parser.y"
                { proto_hdr_field_set_be16(hdr, DNS_RRECORD_TYPE, 2); }
#line 4346 "trafgen/trafgen_parser.tab.c"
    break;

  case 321: /* dns_rrecord_data_expr: K_CNAME '(' skip_white dns_rrecord_data_fqdn skip_white ')'  */
#line 1376 "trafgen_parser.y"
                { proto_hdr_field_set_be16(hdr, DNS_RRECORD_TYPE, 5); }
#line 4352 "trafgen/trafgen_parser.tab.c"
    break;

  case 322: /* dns_rrecord_data_expr: K_PTR '(' skip_white dns_rrecord_data_fqdn skip_white ')'  */
#line 1378 "trafgen_parser.y"
                { proto_hdr_field_set_be16(hdr, DNS_RRECORD_TYPE, 12); }
#line 4358 "trafgen/trafgen_parser.tab.c"
    break;

  case 323: /* dns_rrecord_field: K_TYPE  */
#line 1382 "trafgen_parser.y"
                 { proto_field_set(DNS_RRECORD_TYPE); }
#line 4364 "trafgen/trafgen_parser.tab.c"
    break;

  case 324: /* dns_rrecord_field: K_CLASS  */
#line 1383 "trafgen_parser.y"
                  { proto_field_set(DNS_RRECORD_CLASS); }
#line 4370 "trafgen/trafgen_parser.tab.c"
    break;

  case 325: /* dns_rrecord_field: K_TTL  */
#line 1384 "trafgen_parser.y"
                { proto_field_set(DNS_RRECORD_TTL); }
#line 4376 "trafgen/trafgen_parser.tab.c"
    break;

  case 326: /* dns_rrecord_field: K_LEN  */
#line 1385 "trafgen_parser.y"
                { proto_field_set(DNS_RRECORD_LEN); }
#line 4382 "trafgen/trafgen_parser.tab.c"
    break;

  case 327: /* dns_rrecord_field: K_DATA  */
#line 1386 "trafgen_parser.y"
                 { proto_field_set(DNS_RRECORD_DATA); }
#line 4388 "trafgen/trafgen_parser.tab.c"
    break;

  case 328: /* dns_rrecord_expr: dns_rrecord_field field_expr skip_white '=' skip_white field_value_expr  */
#line 1391 "trafgen_parser.y"
                { proto_field_expr_eval(); }
#line 4394 "trafgen/trafgen_parser.tab.c"
    break;

  case 329: /* dns_rrecord_expr: dns_rrecord_field skip_white '=' skip_white field_value_expr  */
#line 1393 "trafgen_parser.y"
                { proto_field_expr_eval(); }
#line 4400 "trafgen/trafgen_parser.tab.c"
    break;

  case 330: /* dns_rrecord_expr: dns_rrecord_name field_expr skip_white '=' skip_white field_value_expr  */
#line 1395 "trafgen_parser.y"
                { if (field_expr.type & FIELD_EXPR_STRING)
			field_expr.type = FIELD_EXPR_FQDN;
		  proto_field_expr_eval(); }
#line 4408 "trafgen/trafgen_parser.tab.c"
    break;

  case 331: /* dns_rrecord_expr: dns_rrecord_name skip_white '=' skip_white field_value_expr  */
#line 1399 "trafgen_parser.y"
                { if (field_expr.type & FIELD_EXPR_STRING)
			field_expr.type = FIELD_EXPR_FQDN;
		  proto_field_expr_eval(); }
#line 4416 "trafgen/trafgen_parser.tab.c"
    break;

  case 332: /* dns_rrecord_expr: dns_rrecord_data_expr  */
#line 1403 "trafgen_parser.y"
                { }
#line 4422 "trafgen/trafgen_parser.tab.c"
    break;

  case 333: /* dns_rrecord_param_list: %empty  */
#line 1407 "trafgen_parser.y"
          { }
#line 4428 "trafgen/trafgen_parser.tab.c"
    break;

  case 334: /* dns_rrecord_param_list: dns_rrecord_expr  */
#line 1408 "trafgen_parser.y"
                           { }
#line 4434 "trafgen/trafgen_parser.tab.c"
    break;

  case 335: /* dns_rrecord_param_list: dns_rrecord_expr delimiter dns_rrecord_param_list  */
#line 1409 "trafgen_parser.y"
                                                            { }
#line 4440 "trafgen/trafgen_parser.tab.c"
    break;

  case 336: /* dns_rrecord_hdr: dns_rrecord '(' dns_rrecord_param_list ')'  */
#line 1413 "trafgen_parser.y"
                                                     { }
#line 4446 "trafgen/trafgen_parser.tab.c"
    break;

  case 337: /* dns_expr: dns_field field_expr skip_white '=' skip_white field_value_expr  */
#line 1418 "trafgen_parser.y"
                { proto_field_expr_eval(); }
#line 4452 "trafgen/trafgen_parser.tab.c"
    break;

  case 338: /* dns_expr: dns_field skip_white '=' skip_white field_value_expr  */
#line 1420 "trafgen_parser.y"
                { proto_field_expr_eval(); }
#line 4458 "trafgen/trafgen_parser.tab.c"
    break;

  case 339: /* dns_expr: dns_query_hdr  */
#line 1421 "trafgen_parser.y"
                        { proto_pop_sub_hdr(); }
#line 4464 "trafgen/trafgen_parser.tab.c"
    break;

  case 340: /* dns_expr: dns_rrecord_hdr  */
#line 1422 "trafgen_parser.y"
                          { proto_pop_sub_hdr(); }
#line 4470 "trafgen/trafgen_parser.tab.c"
    break;

  case 341: /* dns: K_DNS  */
#line 1426 "trafgen_parser.y"
                { proto_add(PROTO_DNS); }
#line 4476 "trafgen/trafgen_parser.tab.c"
    break;


#line 4480 "trafgen/trafgen_parser.tab.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      yyerror (YY_("syntax error"));
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif

  return yyresult;
}

#line 1428 "trafgen_parser.y"


static void finalize_packet(void)
{
	/* XXX hack ... we allocated one packet pointer too much */
	plen--;
	dlen--;
}

static void dump_conf(void)
{
	size_t i, j;

	for (i = 0; i < plen; ++i) {
		printf("[%zu] pkt\n", i);
		printf(" len %zu cnts %zu rnds %zu\n",
		       packets[i].len,
		       packet_dyn[i].clen,
		       packet_dyn[i].rlen);

		printf(" payload ");
		for (j = 0; j < packets[i].len; ++j)
			printf("%02x ", packets[i].payload[j]);
		printf("\n");

		for (j = 0; j < packet_dyn[i].clen; ++j)
			printf(" cnt%zu [%u,%u], inc %u, off %jd type %s\n", j,
			       packet_dyn[i].cnt[j].min,
			       packet_dyn[i].cnt[j].max,
			       packet_dyn[i].cnt[j].inc,
			       (intmax_t)packet_dyn[i].cnt[j].off,
			       packet_dyn[i].cnt[j].type == TYPE_INC ?
			       "inc" : "dec");

		for (j = 0; j < packet_dyn[i].rlen; ++j)
			printf(" rnd%zu off %jd\n", j,
			       (intmax_t)packet_dyn[i].rnd[j].off);
	}
}

void cleanup_packets(void)
{
	size_t i, j;

	for (i = 0; i < plen; ++i) {
		struct packet *pkt = &packets[i];

		if (pkt->len > 0)
			xfree(pkt->payload);

		for (j = 0; j < pkt->headers_count; j++) {
			struct proto_hdr *hdr = pkt->headers[j];
			uint32_t k;

			for (k = 0; k < hdr->sub_headers_count; k++)
				xfree(hdr->sub_headers[k]);

			if (hdr->sub_headers)
				xfree(hdr->sub_headers);

			if (hdr->fields)
				xfree(hdr->fields);

			xfree(hdr);
		}
	}

	free(packets);

	for (i = 0; i < dlen; ++i) {
		free(packet_dyn[i].cnt);
		free(packet_dyn[i].rnd);

		for (j = 0; j < packet_dyn[j].flen; j++)
			xfree(packet_dyn[i].fields[j]);

		free(packet_dyn[i].fields);
	}

	free(packet_dyn);
}

void compile_packets(char *file, bool verbose, unsigned int cpu,
		     bool invoke_cpp, char *const cpp_argv[])
{
	char tmp_file[128];
	int ret = -1;

	if (strncmp("-", file, strlen("-")) && access(file, R_OK)) {
		fprintf(stderr, "Cannot access %s: %s!\n", file, strerror(errno));
		die();
	}

	memset(tmp_file, 0, sizeof(tmp_file));
	our_cpu = cpu;

	if (invoke_cpp) {
		if (cpp_exec(file, tmp_file, sizeof(tmp_file), cpp_argv)) {
			fprintf(stderr, "Failed to invoke C preprocessor!\n");
			goto err;
		}
		file = tmp_file;
	}

	if (!strncmp("-", file, strlen("-")))
		yyin = stdin;
	else
		yyin = fopen(file, "r");
	if (!yyin) {
		fprintf(stderr, "Cannot open %s: %s!\n", file, strerror(errno));
		goto err;
	}

	realloc_packet();
	if (yyparse() != 0)
		goto err;
	finalize_packet();

	if (our_cpu == 0 && verbose)
		dump_conf();

	ret = 0;
err:
	if (yyin && yyin != stdin)
		fclose(yyin);

	if (invoke_cpp)
		unlink(tmp_file);
	if (ret)
		die();
}

void compile_packets_str(char *str, bool verbose, unsigned int cpu)
{
	int ret = 1;

	our_cpu = cpu;
	realloc_packet();

	yy_scan_string(str);
	if (yyparse() != 0)
		goto err;

	finalize_packet();
	if (our_cpu == 0 && verbose)
		dump_conf();

	ret = 0;
err:
	yylex_destroy();

	if (ret)
		die();
}

void yyerror(const char *err)
{
	fprintf(stderr, "Syntax error at line %d, char '%s': %s\n", yylineno, yytext, err);
}
