/* VideoSupport.c generated by valac 0.56.18, the Vala compiler
 * generated from VideoSupport.vala, do not modify */

/*
* Copyright (c) 2010-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gobject/gvaluecollector.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gst/pbutils/pbutils.h>
#include <gst/gst.h>
#include <signal.h>
#include <sys/types.h>
#include <unistd.h>
#include <gio/gunixinputstream.h>
#include <sys/wait.h>
#include <glib/gstdio.h>
#include <gee.h>
#include <glib/gi18n-lib.h>

#define VIDEO_READER_UNKNOWN_CLIP_DURATION (-1.0)
#define VIDEO_READER_THUMBNAILER_TIMEOUT ((guint) 10000)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _thumbnails_unref0(var) ((var == NULL) ? NULL : (var = (thumbnails_unref (var), NULL)))
#define _video_row_unref0(var) ((var == NULL) ? NULL : (var = (video_row_unref (var), NULL)))
typedef struct _ParamSpecVideoImportParams ParamSpecVideoImportParams;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _video_reader_unref0(var) ((var == NULL) ? NULL : (var = (video_reader_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _metadata_date_time_unref0(var) ((var == NULL) ? NULL : (var = (metadata_date_time_unref (var), NULL)))
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
#define _gst_date_time_unref0(var) ((var == NULL) ? NULL : (var = (gst_date_time_unref (var), NULL)))
typedef struct _ParamSpecVideoReader ParamSpecVideoReader;
enum  {
	VIDEO_0_PROPERTY,
	VIDEO_NUM_PROPERTIES
};
static GParamSpec* video_properties[VIDEO_NUM_PROPERTIES];
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define _exporter_ui_unref0(var) ((var == NULL) ? NULL : (var = (exporter_ui_unref (var), NULL)))
#define _backing_file_state_unref0(var) ((var == NULL) ? NULL : (var = (backing_file_state_unref (var), NULL)))
#define _alteration_unref0(var) ((var == NULL) ? NULL : (var = (alteration_unref (var), NULL)))
#define _video_interpretable_results_unref0(var) ((var == NULL) ? NULL : (var = (video_interpretable_results_unref (var), NULL)))
typedef struct _VideoParamSpecInterpretableResults VideoParamSpecInterpretableResults;
#define _transaction_controller_unref0(var) ((var == NULL) ? NULL : (var = (transaction_controller_unref (var), NULL)))
#define _source_holding_tank_unref0(var) ((var == NULL) ? NULL : (var = (source_holding_tank_unref (var), NULL)))

#define TYPE_VIDEO_MONITOR (video_monitor_get_type ())
#define VIDEO_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_MONITOR, VideoMonitor))
#define VIDEO_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_MONITOR, VideoMonitorClass))
#define IS_VIDEO_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_MONITOR))
#define IS_VIDEO_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_MONITOR))
#define VIDEO_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_MONITOR, VideoMonitorClass))

typedef struct _VideoMonitor VideoMonitor;
typedef struct _VideoMonitorClass VideoMonitorClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ParamSpecVideoImportParams {
	GParamSpec parent_instance;
};

struct _VideoReaderPrivate {
	gdouble clip_duration;
	GdkPixbuf* preview_frame;
	GFile* file;
	GPid thumbnailer_pid;
	gint64 _timestamp;
};

struct _ParamSpecVideoReader {
	GParamSpec parent_instance;
};

struct _VideoPrivate {
	VideoRow* backing_row;
	GRecMutex __lock_backing_row;
};

struct _VideoParamSpecInterpretableResults {
	GParamSpec parent_instance;
};

struct _VideoSourceCollectionPrivate {
	TransactionController* _transaction_controller;
	GeeMultiMap* filesize_to_video;
};

static gpointer video_import_params_parent_class = NULL;
static gint VideoReader_private_offset;
static gpointer video_reader_parent_class = NULL;
static gint Video_private_offset;
static gpointer video_parent_class = NULL;
static gboolean video_interpreter_state_changed;
static gboolean video_interpreter_state_changed = FALSE;
static gint video_current_state;
static gint video_current_state = 0;
static gboolean video_normal_regen_complete;
static gboolean video_normal_regen_complete = FALSE;
static gboolean video_offline_regen_complete;
static gboolean video_offline_regen_complete = FALSE;
static GSettings* video_video_settings;
static GSettings* video_video_settings = NULL;
VideoSourceCollection* video_global = NULL;
static gpointer video_interpretable_results_parent_class = NULL;
static FlaggableIface * video_flaggable_parent_iface = NULL;
static MonitorableIface * video_monitorable_parent_iface = NULL;
static DateableIface * video_dateable_parent_iface = NULL;
static gint VideoSourceCollection_private_offset;
static gpointer video_source_collection_parent_class = NULL;

static void video_import_params_finalize (VideoImportParams * obj);
static GType video_import_params_get_type_once (void);
static void video_reader_read_internal (VideoReader* self,
                                 GError** error);
static gboolean video_reader_does_file_exist (VideoReader* self);
static void video_reader_set_timestamp (VideoReader* self,
                                 gint64 value);
static gboolean video_reader_on_thumbnailer_timer (VideoReader* self);
static GdkPixbuf* video_reader_thumbnailer (VideoReader* self,
                                     const gchar* video_file);
VALA_EXTERN GFile* app_dirs_get_thumbnailer_bin (void);
static gboolean _video_reader_on_thumbnailer_timer_gsource_func (gpointer self);
VALA_EXTERN gint posix_wexitstatus (gint status);
static void video_reader_finalize (VideoReader * obj);
static GType video_reader_get_type_once (void);
static void video_set_is_interpretable (Video* self,
                                 gboolean is_interpretable);
static void video_save_interpreter_state (void);
static void video_real_commit_backlinks (DataSource* base,
                                  SourceCollection* sources,
                                  const gchar* backlinks);
static gboolean video_real_set_event_id (MediaSource* base,
                                  EventID* event_id);
static BackingFileState** video_real_get_backing_files_state (MediaSource* base,
                                                       gint* result_length1);
static GdkPixbuf* video_real_get_thumbnail (ThumbnailSource* base,
                                     gint scale,
                                     GError** error);
static gchar* video_real_get_master_md5 (MediaSource* base);
static GdkPixbuf* video_real_get_preview_pixbuf (MediaSource* base,
                                          Scaling* scaling,
                                          GError** error);
static GdkPixbuf* video_real_create_thumbnail (ThumbnailSource* base,
                                        gint scale,
                                        GError** error);
static gchar* video_real_get_typename (DataSource* base);
static gint64 video_real_get_instance_id (DataSource* base);
static void video_real_get_import_id (MediaSource* base,
                               ImportID* result);
static PhotoFileFormat video_real_get_preferred_thumbnail_format (ThumbnailSource* base);
static gchar* video_real_get_title (MediaSource* base);
static void video_real_set_title (MediaSource* base,
                           const gchar* title);
static gchar* video_real_get_comment (MediaSource* base);
static gboolean video_real_set_comment (MediaSource* base,
                                 const gchar* comment);
static gboolean video_real_is_trashed (MediaSource* base);
static gboolean video_real_is_offline (Monitorable* base);
static void video_real_mark_offline (Monitorable* base);
static void video_real_mark_online (Monitorable* base);
static void video_real_trash (MediaSource* base);
static void video_real_untrash (MediaSource* base);
static gboolean video_real_is_flagged (Flaggable* base);
static void video_real_mark_flagged (Flaggable* base);
static void video_real_mark_unflagged (Flaggable* base);
static void video_real_get_event_id (MediaSource* base,
                              EventID* result);
static gchar* video_real_to_string (DataObject* base);
static gint64 video_real_get_exposure_time (Dateable* base);
static void video_real_set_exposure_time (Dateable* base,
                                   gint64 time);
static void video_real_get_dimensions (MediaSource* base,
                                PhotoException disallowed_steps,
                                Dimensions* result);
static guint64 video_real_get_filesize (MediaSource* base);
static guint64 video_real_get_master_filesize (MediaSource* base);
static gint64 video_real_get_timestamp (MediaSource* base);
static void video_real_set_master_timestamp (Monitorable* base,
                                      GFileInfo* info);
static GFile* video_real_get_file (MediaSource* base);
static GFile* video_real_get_master_file (MediaSource* base);
static void video_real_destroy (DataSource* base);
static gboolean video_real_internal_delete_backing (DataSource* base,
                                             GError** error);
static void video_notify_flags_altered (Video* self,
                                 Alteration* additional_alteration);
static void video_real_set_master_file (Monitorable* base,
                                 GFile* file);
static void video_interpretable_results_finalize (VideoInterpretableResults * obj);
static GType video_interpretable_results_get_type_once (void);
static void video_finalize (GObject * obj);
static GType video_get_type_once (void);
static gint _uint64_compare_gcompare_data_func (gconstpointer a,
                                         gconstpointer b,
                                         gpointer self);
static guint64* _uint64_dup (guint64* self);
static gint64 _video_source_collection_get_video_key_get_source_database_key (DataSource* source,
                                                                       gpointer self);
static void video_source_collection_on_trashcan_contents_altered (VideoSourceCollection* self,
                                                           GeeCollection* added,
                                                           GeeCollection* removed);
static void _video_source_collection_on_trashcan_contents_altered_source_holding_tank_contents_altered (SourceHoldingTank* _sender,
                                                                                                 GeeCollection* added,
                                                                                                 GeeCollection* removed,
                                                                                                 gpointer self);
static void video_source_collection_on_offline_contents_altered (VideoSourceCollection* self,
                                                          GeeCollection* added,
                                                          GeeCollection* removed);
static void _video_source_collection_on_offline_contents_altered_source_holding_tank_contents_altered (SourceHoldingTank* _sender,
                                                                                                GeeCollection* added,
                                                                                                GeeCollection* removed,
                                                                                                gpointer self);
static MediaSourceHoldingTank* video_source_collection_real_create_trashcan (MediaSourceCollection* base);
static gboolean _video_source_collection_is_video_trashed_source_holding_tank_check_to_keep (DataSource* source,
                                                                                      Alteration* alteration,
                                                                                      gpointer self);
static MediaSourceHoldingTank* video_source_collection_real_create_offline_bin (MediaSourceCollection* base);
static gboolean _video_source_collection_is_video_offline_source_holding_tank_check_to_keep (DataSource* source,
                                                                                      Alteration* alteration,
                                                                                      gpointer self);
static MediaMonitor* video_source_collection_real_create_media_monitor (MediaSourceCollection* base,
                                                                 Workers* workers,
                                                                 GCancellable* cancellable);
VALA_EXTERN VideoMonitor* video_monitor_new (GCancellable* cancellable);
VALA_EXTERN VideoMonitor* video_monitor_construct (GType object_type,
                                       GCancellable* cancellable);
VALA_EXTERN GType video_monitor_get_type (void) G_GNUC_CONST ;
static gboolean video_source_collection_real_holds_type_of_source (SourceCollection* base,
                                                            DataSource* source);
static gchar* video_source_collection_real_get_typename (MediaSourceCollection* base);
static gboolean video_source_collection_real_is_file_recognized (MediaSourceCollection* base,
                                                          GFile* file);
static MediaSource* video_source_collection_real_fetch_by_numeric_id (MediaSourceCollection* base,
                                                               gint64 numeric_id);
static GeeCollection* video_source_collection_real_get_event_source_ids (MediaSourceCollection* base,
                                                                  EventID* event_id);
static void video_source_collection_compare_backing (VideoSourceCollection* self,
                                              Video* video,
                                              GFileInfo* info,
                                              GeeCollection* matching_master);
static void video_source_collection_real_notify_contents_altered (DataCollection* base,
                                                           GeeIterable* added,
                                                           GeeIterable* removed);
static void video_source_collection_finalize (DataCollection * obj);
static GType video_source_collection_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const gchar* VIDEO_READER_METADATA_ONLY_FILE_EXTENSIONS[4] = {"bdm", "bdmv", "cpi", "mpl"};

GQuark
video_error_quark (void)
{
	return g_quark_from_static_string ("video-error-quark");
}

static GType
video_error_get_type_once (void)
{
	static const GEnumValue values[] = {{VIDEO_ERROR_FILE, "VIDEO_ERROR_FILE", "file"}, {VIDEO_ERROR_CONTENTS, "VIDEO_ERROR_CONTENTS", "contents"}, {0, NULL, NULL}};
	GType video_error_type_id;
	video_error_type_id = g_enum_register_static ("VideoError", values);
	return video_error_type_id;
}

GType
video_error_get_type (void)
{
	static volatile gsize video_error_type_id__once = 0;
	if (g_once_init_enter (&video_error_type_id__once)) {
		GType video_error_type_id;
		video_error_type_id = video_error_get_type_once ();
		g_once_init_leave (&video_error_type_id__once, video_error_type_id);
	}
	return video_error_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_thumbnails_ref0 (gpointer self)
{
	return self ? thumbnails_ref (self) : NULL;
}

VideoImportParams*
video_import_params_construct (GType object_type,
                               GFile* file,
                               ImportID* import_id,
                               const gchar* md5,
                               Thumbnails* thumbnails,
                               gint64 exposure_time_override)
{
	VideoImportParams* self = NULL;
	GFile* _tmp0_;
	ImportID _tmp1_;
	gchar* _tmp2_;
	Thumbnails* _tmp3_;
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (import_id != NULL, NULL);
	self = (VideoImportParams*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (self->file);
	self->file = _tmp0_;
	_tmp1_ = *import_id;
	self->import_id = _tmp1_;
	_tmp2_ = g_strdup (md5);
	_g_free0 (self->md5);
	self->md5 = _tmp2_;
	_tmp3_ = _thumbnails_ref0 (thumbnails);
	_thumbnails_unref0 (self->thumbnails);
	self->thumbnails = _tmp3_;
	self->exposure_time_override = exposure_time_override;
	return self;
}

VideoImportParams*
video_import_params_new (GFile* file,
                         ImportID* import_id,
                         const gchar* md5,
                         Thumbnails* thumbnails,
                         gint64 exposure_time_override)
{
	return video_import_params_construct (TYPE_VIDEO_IMPORT_PARAMS, file, import_id, md5, thumbnails, exposure_time_override);
}

static void
value_video_import_params_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_video_import_params_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		video_import_params_unref (value->data[0].v_pointer);
	}
}

static void
value_video_import_params_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = video_import_params_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_video_import_params_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_video_import_params_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		VideoImportParams * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = video_import_params_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_video_import_params_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	VideoImportParams ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = video_import_params_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_video_import_params (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	ParamSpecVideoImportParams* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_VIDEO_IMPORT_PARAMS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_video_import_params (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIDEO_IMPORT_PARAMS), NULL);
	return value->data[0].v_pointer;
}

void
value_set_video_import_params (GValue* value,
                               gpointer v_object)
{
	VideoImportParams * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIDEO_IMPORT_PARAMS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_VIDEO_IMPORT_PARAMS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		video_import_params_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		video_import_params_unref (old);
	}
}

void
value_take_video_import_params (GValue* value,
                                gpointer v_object)
{
	VideoImportParams * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIDEO_IMPORT_PARAMS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_VIDEO_IMPORT_PARAMS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		video_import_params_unref (old);
	}
}

static void
video_import_params_class_init (VideoImportParamsClass * klass,
                                gpointer klass_data)
{
	video_import_params_parent_class = g_type_class_peek_parent (klass);
	((VideoImportParamsClass *) klass)->finalize = video_import_params_finalize;
}

static void
video_import_params_instance_init (VideoImportParams * self,
                                   gpointer klass)
{
	VideoRow* _tmp0_;
	import_id_init (&self->import_id, IMPORT_ID_INVALID);
	_tmp0_ = video_row_new ();
	self->row = _tmp0_;
	self->ref_count = 1;
}

static void
video_import_params_finalize (VideoImportParams * obj)
{
	VideoImportParams * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIDEO_IMPORT_PARAMS, VideoImportParams);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->file);
	_g_free0 (self->md5);
	_thumbnails_unref0 (self->thumbnails);
	_video_row_unref0 (self->row);
}

static GType
video_import_params_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_video_import_params_init, value_video_import_params_free_value, value_video_import_params_copy_value, value_video_import_params_peek_pointer, "p", value_video_import_params_collect_value, "p", value_video_import_params_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (VideoImportParamsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_import_params_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoImportParams), 0, (GInstanceInitFunc) video_import_params_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType video_import_params_type_id;
	video_import_params_type_id = g_type_register_fundamental (g_type_fundamental_next (), "VideoImportParams", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return video_import_params_type_id;
}

GType
video_import_params_get_type (void)
{
	static volatile gsize video_import_params_type_id__once = 0;
	if (g_once_init_enter (&video_import_params_type_id__once)) {
		GType video_import_params_type_id;
		video_import_params_type_id = video_import_params_get_type_once ();
		g_once_init_leave (&video_import_params_type_id__once, video_import_params_type_id);
	}
	return video_import_params_type_id__once;
}

gpointer
video_import_params_ref (gpointer instance)
{
	VideoImportParams * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
video_import_params_unref (gpointer instance)
{
	VideoImportParams * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VIDEO_IMPORT_PARAMS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
video_reader_get_instance_private (VideoReader* self)
{
	return G_STRUCT_MEMBER_P (self, VideoReader_private_offset);
}

VideoReader*
video_reader_construct (GType object_type,
                        GFile* file)
{
	VideoReader* self = NULL;
	GFile* _tmp0_;
	g_return_val_if_fail (file != NULL, NULL);
	self = (VideoReader*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp0_;
	return self;
}

VideoReader*
video_reader_new (GFile* file)
{
	return video_reader_construct (TYPE_VIDEO_READER, file);
}

gboolean
video_reader_is_supported_video_file (GFile* file)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp0_ = g_file_get_basename (file);
	_tmp1_ = _tmp0_;
	_tmp2_ = video_reader_is_supported_video_filename (_tmp1_);
	_g_free0 (_tmp1_);
	result = _tmp2_;
	return result;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

gboolean
video_reader_is_supported_video_filename (const gchar* filename)
{
	gchar* mime_type = NULL;
	guchar* _tmp0_;
	guchar* _tmp1_;
	gint _tmp1__length1;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gboolean result;
	g_return_val_if_fail (filename != NULL, FALSE);
	_tmp0_ = g_new0 (guchar, 0);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 0;
	_tmp2_ = g_content_type_guess (filename, _tmp1_, (gsize) 0, NULL);
	_g_free0 (mime_type);
	mime_type = _tmp2_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	_tmp4_ = mime_type;
	_tmp5_ = strlen (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ >= 6) {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = mime_type;
		_tmp8_ = string_slice (_tmp7_, (glong) 0, (glong) 6);
		_tmp9_ = _tmp8_;
		_tmp3_ = g_strcmp0 (_tmp9_, "video/") == 0;
		_g_free0 (_tmp9_);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gchar* extension = NULL;
		gchar* name = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		const gchar* _tmp12_;
		extension = NULL;
		name = NULL;
		disassemble_filename (filename, &_tmp10_, &_tmp11_);
		_g_free0 (name);
		name = _tmp10_;
		_g_free0 (extension);
		extension = _tmp11_;
		_tmp12_ = extension;
		if (_tmp12_ == NULL) {
			result = TRUE;
			_g_free0 (name);
			_g_free0 (extension);
			_g_free0 (mime_type);
			return result;
		}
		{
			const gchar** s_collection = NULL;
			gint s_collection_length1 = 0;
			gint _s_collection_size_ = 0;
			gint s_it = 0;
			s_collection = VIDEO_READER_METADATA_ONLY_FILE_EXTENSIONS;
			s_collection_length1 = G_N_ELEMENTS (VIDEO_READER_METADATA_ONLY_FILE_EXTENSIONS);
			for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
				gchar* _tmp13_;
				gchar* s = NULL;
				_tmp13_ = g_strdup (s_collection[s_it]);
				s = _tmp13_;
				{
					const gchar* _tmp14_;
					const gchar* _tmp15_;
					_tmp14_ = s;
					_tmp15_ = extension;
					if (utf8_ci_compare (_tmp14_, _tmp15_) == 0) {
						result = FALSE;
						_g_free0 (s);
						_g_free0 (name);
						_g_free0 (extension);
						_g_free0 (mime_type);
						return result;
					}
					_g_free0 (s);
				}
			}
		}
		result = TRUE;
		_g_free0 (name);
		_g_free0 (extension);
		_g_free0 (mime_type);
		return result;
	} else {
		result = FALSE;
		_g_free0 (mime_type);
		return result;
	}
}

ImportResult
video_reader_prepare_for_import (VideoImportParams* params)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFileInfo* info = NULL;
	GFileInfo* _tmp6_;
	GFile* _tmp7_;
	gint64 timestamp = 0LL;
	GFileInfo* _tmp11_;
	GDateTime* _tmp12_;
	GDateTime* _tmp13_;
	gint64 _tmp14_;
	const gchar* _tmp15_;
	gint64 exposure_time = 0LL;
	gchar* title = NULL;
	gchar* _tmp16_;
	gchar* comment = NULL;
	gchar* _tmp17_;
	VideoReader* reader = NULL;
	GFile* _tmp18_;
	VideoReader* _tmp19_;
	gboolean is_interpretable = FALSE;
	gdouble clip_duration = 0.0;
	GdkPixbuf* preview_frame = NULL;
	VideoReader* _tmp20_;
	GdkPixbuf* _tmp21_;
	VideoRow* _tmp51_;
	VideoRow* _tmp52_;
	GFile* _tmp53_;
	gchar* _tmp54_;
	VideoRow* _tmp55_;
	GFileInfo* _tmp56_;
	VideoRow* _tmp57_;
	VideoRow* _tmp58_;
	GdkPixbuf* _tmp59_;
	gint _tmp60_;
	gint _tmp61_;
	VideoRow* _tmp62_;
	GdkPixbuf* _tmp63_;
	gint _tmp64_;
	gint _tmp65_;
	VideoRow* _tmp66_;
	VideoRow* _tmp67_;
	VideoRow* _tmp68_;
	VideoRow* _tmp69_;
	ImportID _tmp70_;
	VideoRow* _tmp71_;
	VideoRow* _tmp72_;
	const gchar* _tmp73_;
	gchar* _tmp74_;
	VideoRow* _tmp75_;
	VideoRow* _tmp76_;
	const gchar* _tmp77_;
	gchar* _tmp78_;
	VideoRow* _tmp79_;
	const gchar* _tmp80_;
	gchar* _tmp81_;
	VideoRow* _tmp82_;
	gchar* _tmp83_;
	VideoRow* _tmp84_;
	VideoRow* _tmp85_;
	Thumbnails* _tmp86_;
	GError* _inner_error0_ = NULL;
	ImportResult result;
	g_return_val_if_fail (params != NULL, 0);
	_tmp0_ = params->file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	file = _tmp1_;
	info = NULL;
	{
		GFileInfo* _tmp2_ = NULL;
		GFile* _tmp3_;
		GFileInfo* _tmp4_;
		GFileInfo* _tmp5_;
		_tmp3_ = file;
		_tmp4_ = g_file_query_info (_tmp3_, DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
		_tmp2_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp2_;
		_tmp2_ = NULL;
		_g_object_unref0 (info);
		info = _tmp5_;
		_g_object_unref0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = IMPORT_RESULT_FILE_ERROR;
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return 0;
	}
	_tmp6_ = info;
	if (g_file_info_get_file_type (_tmp6_) != G_FILE_TYPE_REGULAR) {
		result = IMPORT_RESULT_NOT_A_FILE;
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return result;
	}
	_tmp7_ = file;
	if (!video_reader_is_supported_video_file (_tmp7_)) {
		GFile* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = file;
		_tmp9_ = g_file_get_path (_tmp8_);
		_tmp10_ = _tmp9_;
		g_message ("Not importing %s: file is marked as a video file but doesn't have a" "supported extension", _tmp10_);
		_g_free0 (_tmp10_);
		result = IMPORT_RESULT_UNSUPPORTED_FORMAT;
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return result;
	}
	_tmp11_ = info;
	_tmp12_ = g_file_info_get_modification_date_time (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_date_time_to_unix (_tmp13_);
	_g_date_time_unref0 (_tmp13_);
	timestamp = _tmp14_;
	_tmp15_ = params->md5;
	_vala_assert (_tmp15_ != NULL, "params.md5 != null");
	exposure_time = params->exposure_time_override;
	_tmp16_ = g_strdup ("");
	title = _tmp16_;
	_tmp17_ = g_strdup ("");
	comment = _tmp17_;
	_tmp18_ = file;
	_tmp19_ = video_reader_new (_tmp18_);
	reader = _tmp19_;
	is_interpretable = TRUE;
	clip_duration = 0.0;
	_tmp20_ = reader;
	_tmp21_ = video_reader_read_preview_frame (_tmp20_);
	preview_frame = _tmp21_;
	{
		gdouble _tmp22_ = 0.0;
		VideoReader* _tmp23_;
		_tmp23_ = reader;
		_tmp22_ = video_reader_read_clip_duration (_tmp23_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VIDEO_ERROR) {
				goto __catch1_video_error;
			}
			_g_object_unref0 (preview_frame);
			_video_reader_unref0 (reader);
			_g_free0 (comment);
			_g_free0 (title);
			_g_object_unref0 (info);
			_g_object_unref0 (file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return 0;
		}
		clip_duration = _tmp22_;
	}
	goto __finally1;
	__catch1_video_error:
	{
		GError* err = NULL;
		GError* _tmp24_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp24_ = err;
		if (g_error_matches (_tmp24_, VIDEO_ERROR, VIDEO_ERROR_FILE)) {
			result = IMPORT_RESULT_FILE_ERROR;
			_g_error_free0 (err);
			_g_object_unref0 (preview_frame);
			_video_reader_unref0 (reader);
			_g_free0 (comment);
			_g_free0 (title);
			_g_object_unref0 (info);
			_g_object_unref0 (file);
			return result;
		} else {
			GError* _tmp25_;
			_tmp25_ = err;
			if (g_error_matches (_tmp25_, VIDEO_ERROR, VIDEO_ERROR_CONTENTS)) {
				is_interpretable = FALSE;
				clip_duration = 0.0;
			} else {
				g_error ("VideoSupport.vala:144: can't prepare video for import: an unknown kind" \
" of video error occurred");
			}
		}
		_g_error_free0 (err);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (preview_frame);
		_video_reader_unref0 (reader);
		_g_free0 (comment);
		_g_free0 (title);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return 0;
	}
	{
		VideoMetadata* metadata = NULL;
		VideoReader* _tmp26_;
		VideoMetadata* _tmp27_;
		MetadataDateTime* creation_date_time = NULL;
		VideoMetadata* _tmp28_;
		MetadataDateTime* _tmp29_;
		gboolean _tmp30_ = FALSE;
		MetadataDateTime* _tmp31_;
		gchar* video_title = NULL;
		VideoMetadata* _tmp34_;
		gchar* _tmp35_;
		gchar* video_comment = NULL;
		VideoMetadata* _tmp36_;
		gchar* _tmp37_;
		const gchar* _tmp38_;
		const gchar* _tmp41_;
		_tmp26_ = reader;
		_tmp27_ = video_reader_read_metadata (_tmp26_, &_inner_error0_);
		metadata = _tmp27_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp28_ = metadata;
		_tmp29_ = media_metadata_get_creation_date_time ((MediaMetadata*) _tmp28_);
		creation_date_time = _tmp29_;
		_tmp31_ = creation_date_time;
		if (_tmp31_ != NULL) {
			MetadataDateTime* _tmp32_;
			_tmp32_ = creation_date_time;
			_tmp30_ = metadata_date_time_get_timestamp (_tmp32_) != ((gint64) 0);
		} else {
			_tmp30_ = FALSE;
		}
		if (_tmp30_) {
			MetadataDateTime* _tmp33_;
			_tmp33_ = creation_date_time;
			exposure_time = metadata_date_time_get_timestamp (_tmp33_);
		}
		_tmp34_ = metadata;
		_tmp35_ = media_metadata_get_title ((MediaMetadata*) _tmp34_);
		video_title = _tmp35_;
		_tmp36_ = metadata;
		_tmp37_ = media_metadata_get_comment ((MediaMetadata*) _tmp36_);
		video_comment = _tmp37_;
		_tmp38_ = video_title;
		if (_tmp38_ != NULL) {
			const gchar* _tmp39_;
			gchar* _tmp40_;
			_tmp39_ = video_title;
			_tmp40_ = g_strdup (_tmp39_);
			_g_free0 (title);
			title = _tmp40_;
		}
		_tmp41_ = video_comment;
		if (_tmp41_ != NULL) {
			const gchar* _tmp42_;
			gchar* _tmp43_;
			_tmp42_ = video_comment;
			_tmp43_ = g_strdup (_tmp42_);
			_g_free0 (comment);
			comment = _tmp43_;
		}
		_g_free0 (video_comment);
		_g_free0 (video_title);
		_metadata_date_time_unref0 (creation_date_time);
		_media_metadata_unref0 (metadata);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* err = NULL;
		GError* _tmp44_;
		const gchar* _tmp45_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp44_ = err;
		_tmp45_ = _tmp44_->message;
		g_warning ("VideoSupport.vala:162: Unable to read video metadata: %s", _tmp45_);
		_g_error_free0 (err);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (preview_frame);
		_video_reader_unref0 (reader);
		_g_free0 (comment);
		_g_free0 (title);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return 0;
	}
	if (exposure_time == ((gint64) 0)) {
		gint64 _tmp46_ = 0LL;
		VideoReader* _tmp47_;
		gint64 _tmp48_;
		_tmp47_ = reader;
		_tmp48_ = _tmp47_->priv->_timestamp;
		if (_tmp48_ > ((gint64) 0)) {
			VideoReader* _tmp49_;
			gint64 _tmp50_;
			_tmp49_ = reader;
			_tmp50_ = _tmp49_->priv->_timestamp;
			_tmp46_ = _tmp50_;
		} else {
			_tmp46_ = (gint64) 0;
		}
		exposure_time = _tmp46_;
	}
	_tmp51_ = params->row;
	video_id_init (&_tmp51_->video_id, VIDEO_ID_INVALID);
	_tmp52_ = params->row;
	_tmp53_ = file;
	_tmp54_ = g_file_get_path (_tmp53_);
	_g_free0 (_tmp52_->filepath);
	_tmp52_->filepath = _tmp54_;
	_tmp55_ = params->row;
	_tmp56_ = info;
	_tmp55_->filesize = g_file_info_get_size (_tmp56_);
	_tmp57_ = params->row;
	_tmp57_->timestamp = timestamp;
	_tmp58_ = params->row;
	_tmp59_ = preview_frame;
	_tmp60_ = gdk_pixbuf_get_width (_tmp59_);
	_tmp61_ = _tmp60_;
	_tmp58_->width = _tmp61_;
	_tmp62_ = params->row;
	_tmp63_ = preview_frame;
	_tmp64_ = gdk_pixbuf_get_height (_tmp63_);
	_tmp65_ = _tmp64_;
	_tmp62_->height = _tmp65_;
	_tmp66_ = params->row;
	_tmp66_->clip_duration = clip_duration;
	_tmp67_ = params->row;
	_tmp67_->is_interpretable = is_interpretable;
	_tmp68_ = params->row;
	_tmp68_->exposure_time = exposure_time;
	_tmp69_ = params->row;
	_tmp70_ = params->import_id;
	_tmp69_->import_id = _tmp70_;
	_tmp71_ = params->row;
	event_id_init (&_tmp71_->event_id, EVENT_ID_INVALID);
	_tmp72_ = params->row;
	_tmp73_ = params->md5;
	_tmp74_ = g_strdup (_tmp73_);
	_g_free0 (_tmp72_->md5);
	_tmp72_->md5 = _tmp74_;
	_tmp75_ = params->row;
	_tmp75_->time_created = (gint64) 0;
	_tmp76_ = params->row;
	_tmp77_ = title;
	_tmp78_ = g_strdup (_tmp77_);
	_g_free0 (_tmp76_->title);
	_tmp76_->title = _tmp78_;
	_tmp79_ = params->row;
	_tmp80_ = comment;
	_tmp81_ = g_strdup (_tmp80_);
	_g_free0 (_tmp79_->comment);
	_tmp79_->comment = _tmp81_;
	_tmp82_ = params->row;
	_tmp83_ = g_strdup ("");
	_g_free0 (_tmp82_->backlinks);
	_tmp82_->backlinks = _tmp83_;
	_tmp84_ = params->row;
	_tmp84_->time_reimported = (gint64) 0;
	_tmp85_ = params->row;
	_tmp85_->flags = (guint64) 0;
	_tmp86_ = params->thumbnails;
	if (_tmp86_ != NULL) {
		Thumbnails* _tmp87_;
		Thumbnails* _tmp88_;
		GdkPixbuf* _tmp89_;
		_tmp87_ = thumbnails_new ();
		_thumbnails_unref0 (params->thumbnails);
		params->thumbnails = _tmp87_;
		_tmp88_ = params->thumbnails;
		_tmp89_ = preview_frame;
		thumbnail_cache_generate_for_video_frame (_tmp88_, _tmp89_);
	}
	result = IMPORT_RESULT_SUCCESS;
	_g_object_unref0 (preview_frame);
	_video_reader_unref0 (reader);
	_g_free0 (comment);
	_g_free0 (title);
	_g_object_unref0 (info);
	_g_object_unref0 (file);
	return result;
}

static void
video_reader_read_internal (VideoReader* self,
                            GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (!video_reader_does_file_exist (self)) {
		GFile* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GError* _tmp5_;
		GError* _tmp6_;
		_tmp0_ = self->priv->file;
		_tmp1_ = g_file_get_path (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strdup_printf ("video file '%s' does not exist or is inaccessible", _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_error_new_literal (VIDEO_ERROR, VIDEO_ERROR_FILE, _tmp4_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		_g_free0 (_tmp2_);
		_inner_error0_ = _tmp6_;
		if (_inner_error0_->domain == VIDEO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	{
		GstDiscoverer* d = NULL;
		GstDiscoverer* _tmp7_;
		GstDiscovererInfo* info = NULL;
		GstDiscoverer* _tmp8_;
		GFile* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		GstDiscovererInfo* _tmp12_;
		GstDiscovererInfo* _tmp13_;
		GstDiscovererInfo* _tmp14_;
		GDateTime* _tmp15_;
		GDateTime* _tmp16_;
		GstDateTime* video_date = NULL;
		gboolean _tmp17_ = FALSE;
		GstDiscovererInfo* _tmp18_;
		GstTagList* _tmp19_;
		_tmp7_ = gst_discoverer_new ((GstClockTime) (GST_SECOND * 5), &_inner_error0_);
		d = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp8_ = d;
		_tmp9_ = self->priv->file;
		_tmp10_ = g_file_get_uri (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = gst_discoverer_discover_uri (_tmp8_, _tmp11_, &_inner_error0_);
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp11_);
		info = _tmp13_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (d);
			goto __catch0_g_error;
		}
		_tmp14_ = info;
		self->priv->clip_duration = ((gdouble) gst_discoverer_info_get_duration (_tmp14_)) / 1000000000.0;
		_tmp15_ = g_date_time_new_now_local ();
		_tmp16_ = _tmp15_;
		video_reader_set_timestamp (self, g_date_time_to_unix (_tmp16_));
		_g_date_time_unref0 (_tmp16_);
		video_date = NULL;
		_tmp18_ = info;
		_tmp19_ = gst_discoverer_info_get_tags (_tmp18_);
		if (_tmp19_ != NULL) {
			GstDiscovererInfo* _tmp20_;
			GstTagList* _tmp21_;
			GstDateTime* _tmp22_ = NULL;
			gboolean _tmp23_;
			_tmp20_ = info;
			_tmp21_ = gst_discoverer_info_get_tags (_tmp20_);
			_tmp23_ = gst_tag_list_get_date_time (_tmp21_, GST_TAG_DATE, &_tmp22_);
			_gst_date_time_unref0 (video_date);
			video_date = _tmp22_;
			_tmp17_ = _tmp23_;
		} else {
			_tmp17_ = FALSE;
		}
		if (_tmp17_) {
			GstDateTime* _tmp24_;
			_tmp24_ = video_date;
			if (_tmp24_ != NULL) {
				GDateTime* g_date_time = NULL;
				GstDateTime* _tmp25_;
				GDateTime* _tmp26_;
				GDateTime* _tmp27_;
				_tmp25_ = video_date;
				_tmp26_ = gst_date_time_to_g_date_time (_tmp25_);
				g_date_time = _tmp26_;
				_tmp27_ = g_date_time;
				if (_tmp27_ != NULL) {
					GDateTime* _tmp28_;
					_tmp28_ = g_date_time;
					video_reader_set_timestamp (self, g_date_time_to_unix (_tmp28_));
				}
				_g_date_time_unref0 (g_date_time);
			}
		}
		_gst_date_time_unref0 (video_date);
		_g_object_unref0 (info);
		_g_object_unref0 (d);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp29_;
		const gchar* _tmp30_;
		GError* _tmp31_;
		const gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		GError* _tmp35_;
		GError* _tmp36_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp29_ = e;
		_tmp30_ = _tmp29_->message;
		g_debug ("VideoSupport.vala:224: Video read error: %s", _tmp30_);
		_tmp31_ = e;
		_tmp32_ = _tmp31_->message;
		_tmp33_ = g_strdup_printf ("GStreamer couldn't extract clip information: %s", _tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = g_error_new_literal (VIDEO_ERROR, VIDEO_ERROR_CONTENTS, _tmp34_);
		_tmp36_ = _tmp35_;
		_g_free0 (_tmp34_);
		_inner_error0_ = _tmp36_;
		_g_error_free0 (e);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VIDEO_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static gboolean
video_reader_on_thumbnailer_timer (VideoReader* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_debug ("VideoSupport.vala:232: Thumbnailer timer called");
	if (self->priv->thumbnailer_pid != ((GPid) 0)) {
		g_debug ("VideoSupport.vala:234: Killing thumbnailer process: %d", (gint) self->priv->thumbnailer_pid);
		kill ((pid_t) self->priv->thumbnailer_pid, (gint) SIGKILL);
	}
	result = FALSE;
	return result;
}

static gboolean
_video_reader_on_thumbnailer_timer_gsource_func (gpointer self)
{
	gboolean result;
	result = video_reader_on_thumbnailer_timer ((VideoReader*) self);
	return result;
}

static GdkPixbuf*
video_reader_thumbnailer (VideoReader* self,
                          const gchar* video_file)
{
	gint* pipefd = NULL;
	gint* _tmp0_;
	gint pipefd_length1;
	gint _pipefd_size_;
	gint* _tmp1_;
	gint _tmp1__length1;
	gint* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar** argv = NULL;
	GFile* _tmp8_;
	GFile* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar** _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gint argv_length1;
	gint _argv_size_;
	GdkPixbuf* buf = NULL;
	gint child_status = 0;
	gint ret_waitpid = 0;
	gint _tmp29_ = 0;
	pid_t _tmp30_;
	gint* _tmp31_;
	gint _tmp31__length1;
	gint _tmp32_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (video_file != NULL, NULL);
	_tmp0_ = g_new0 (gint, 2);
	_tmp0_[0] = 0;
	_tmp0_[1] = 0;
	pipefd = _tmp0_;
	pipefd_length1 = 2;
	_pipefd_size_ = pipefd_length1;
	_tmp1_ = pipefd;
	_tmp1__length1 = pipefd_length1;
	if (pipe (_tmp1_) < 0) {
		g_warning ("VideoSupport.vala:246: Error: unable to open pipe.");
		result = NULL;
		pipefd = (g_free (pipefd), NULL);
		return result;
	}
	_tmp2_ = pipefd;
	_tmp2__length1 = pipefd_length1;
	_tmp3_ = _tmp2_[1];
	close (_tmp3_);
	_tmp4_ = app_dirs_get_thumbnailer_bin ();
	_tmp5_ = _tmp4_;
	_tmp6_ = g_file_get_path (_tmp5_);
	_tmp7_ = _tmp6_;
	g_debug ("VideoSupport.vala:252: Launching thumbnailer process: %s", _tmp7_);
	_g_free0 (_tmp7_);
	_g_object_unref0 (_tmp5_);
	_tmp8_ = app_dirs_get_thumbnailer_bin ();
	_tmp9_ = _tmp8_;
	_tmp10_ = g_file_get_path (_tmp9_);
	_tmp11_ = g_strdup (video_file);
	_tmp12_ = g_new0 (gchar*, 2 + 1);
	_tmp12_[0] = _tmp10_;
	_tmp12_[1] = _tmp11_;
	_tmp13_ = _tmp12_;
	_tmp13__length1 = 2;
	_g_object_unref0 (_tmp9_);
	argv = _tmp13_;
	argv_length1 = _tmp13__length1;
	_argv_size_ = argv_length1;
	{
		gchar** _tmp14_;
		gint _tmp14__length1;
		gint* _tmp15_;
		gint _tmp15__length1;
		GPid _tmp16_ = 0;
		gint _tmp17_ = 0;
		_tmp14_ = argv;
		_tmp14__length1 = argv_length1;
		_tmp15_ = pipefd;
		_tmp15__length1 = pipefd_length1;
		g_spawn_async_with_pipes (NULL, _tmp14_, NULL, G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_tmp16_, NULL, &_tmp17_, NULL, &_inner_error0_);
		self->priv->thumbnailer_pid = _tmp16_;
		_tmp15_[0] = _tmp17_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		g_debug ("VideoSupport.vala:257: Spawned thumbnailer, child pid: %d", (gint) self->priv->thumbnailer_pid);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		g_debug ("VideoSupport.vala:259: Error spawning process: %s", _tmp19_);
		if (self->priv->thumbnailer_pid != ((GPid) 0)) {
			g_spawn_close_pid (self->priv->thumbnailer_pid);
		}
		result = NULL;
		_g_error_free0 (e);
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		pipefd = (g_free (pipefd), NULL);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		pipefd = (g_free (pipefd), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	g_timeout_add_full (G_PRIORITY_DEFAULT, VIDEO_READER_THUMBNAILER_TIMEOUT, _video_reader_on_thumbnailer_timer_gsource_func, video_reader_ref (self), video_reader_unref);
	buf = NULL;
	{
		GUnixInputStream* unix_input = NULL;
		gint* _tmp20_;
		gint _tmp20__length1;
		gint _tmp21_;
		GUnixInputStream* _tmp22_;
		GdkPixbuf* _tmp23_ = NULL;
		GUnixInputStream* _tmp24_;
		GdkPixbuf* _tmp25_;
		GdkPixbuf* _tmp26_;
		_tmp20_ = pipefd;
		_tmp20__length1 = pipefd_length1;
		_tmp21_ = _tmp20_[0];
		_tmp22_ = (GUnixInputStream*) g_unix_input_stream_new (_tmp21_, TRUE);
		unix_input = _tmp22_;
		_tmp24_ = unix_input;
		_tmp25_ = gdk_pixbuf_new_from_stream ((GInputStream*) _tmp24_, NULL, &_inner_error0_);
		_tmp23_ = _tmp25_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (unix_input);
			goto __catch1_g_error;
		}
		_tmp26_ = _tmp23_;
		_tmp23_ = NULL;
		_g_object_unref0 (buf);
		buf = _tmp26_;
		_g_object_unref0 (_tmp23_);
		_g_object_unref0 (unix_input);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp27_;
		const gchar* _tmp28_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp27_ = e;
		_tmp28_ = _tmp27_->message;
		g_warning ("VideoSupport.vala:274: Error creating pixbuf: %s", _tmp28_);
		_g_object_unref0 (buf);
		buf = NULL;
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (buf);
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		pipefd = (g_free (pipefd), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	child_status = 0;
	_tmp30_ = waitpid ((pid_t) self->priv->thumbnailer_pid, &_tmp29_, 0);
	child_status = _tmp29_;
	ret_waitpid = (gint) _tmp30_;
	if (ret_waitpid < 0) {
		g_debug ("VideoSupport.vala:282: waitpid returned error code: %d", ret_waitpid);
		_g_object_unref0 (buf);
		buf = NULL;
	} else {
		if (0 != posix_wexitstatus (child_status)) {
			g_debug ("VideoSupport.vala:285: Thumbnailer exited with error code: %d", posix_wexitstatus (child_status));
			_g_object_unref0 (buf);
			buf = NULL;
		}
	}
	_tmp31_ = pipefd;
	_tmp31__length1 = pipefd_length1;
	_tmp32_ = _tmp31_[0];
	close (_tmp32_);
	g_spawn_close_pid (self->priv->thumbnailer_pid);
	self->priv->thumbnailer_pid = (GPid) 0;
	result = buf;
	argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
	pipefd = (g_free (pipefd), NULL);
	return result;
}

static gboolean
video_reader_does_file_exist (VideoReader* self)
{
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->file;
	_tmp1_ = g_file_get_path (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_test (_tmp2_, G_FILE_TEST_EXISTS | G_FILE_TEST_IS_REGULAR);
	_g_free0 (_tmp2_);
	result = _tmp3_;
	return result;
}

GdkPixbuf*
video_reader_read_preview_frame (VideoReader* self)
{
	GdkPixbuf* _tmp0_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GdkPixbuf* _tmp6_;
	GdkPixbuf* _tmp7_;
	GdkPixbuf* _tmp9_;
	GdkPixbuf* _tmp10_;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->preview_frame;
	if (_tmp0_ != NULL) {
		GdkPixbuf* _tmp1_;
		GdkPixbuf* _tmp2_;
		_tmp1_ = self->priv->preview_frame;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	if (!video_reader_does_file_exist (self)) {
		result = NULL;
		return result;
	}
	_tmp3_ = self->priv->file;
	_tmp4_ = g_file_get_path (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = video_reader_thumbnailer (self, _tmp5_);
	_g_object_unref0 (self->priv->preview_frame);
	self->priv->preview_frame = _tmp6_;
	_g_free0 (_tmp5_);
	_tmp7_ = self->priv->preview_frame;
	if (NULL == _tmp7_) {
		GdkPixbuf* _tmp8_;
		_tmp8_ = resources_get_noninterpretable_badge_pixbuf ();
		_g_object_unref0 (self->priv->preview_frame);
		self->priv->preview_frame = _tmp8_;
	}
	_tmp9_ = self->priv->preview_frame;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	result = _tmp10_;
	return result;
}

gdouble
video_reader_read_clip_duration (VideoReader* self,
                                 GError** error)
{
	GError* _inner_error0_ = NULL;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	if (self->priv->clip_duration == VIDEO_READER_UNKNOWN_CLIP_DURATION) {
		video_reader_read_internal (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VIDEO_ERROR) {
				gdouble _tmp0_ = -1.0;
				g_propagate_error (error, _inner_error0_);
				return _tmp0_;
			} else {
				gdouble _tmp1_ = -1.0;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp1_;
			}
		}
	}
	result = self->priv->clip_duration;
	return result;
}

VideoMetadata*
video_reader_read_metadata (VideoReader* self,
                            GError** error)
{
	VideoMetadata* metadata = NULL;
	VideoMetadata* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GError* _inner_error0_ = NULL;
	VideoMetadata* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = video_metadata_new ();
	metadata = _tmp0_;
	_tmp1_ = self->priv->file;
	_tmp2_ = g_file_get_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_new_for_path (_tmp3_);
	_tmp5_ = _tmp4_;
	media_metadata_read_from_file ((MediaMetadata*) metadata, _tmp5_, &_inner_error0_);
	_g_object_unref0 (_tmp5_);
	_g_free0 (_tmp3_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_media_metadata_unref0 (metadata);
		return NULL;
	}
	result = metadata;
	return result;
}

gint64
video_reader_get_timestamp (VideoReader* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_timestamp;
	return result;
}

static void
video_reader_set_timestamp (VideoReader* self,
                            gint64 value)
{
	g_return_if_fail (self != NULL);
	self->priv->_timestamp = value;
}

static void
value_video_reader_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_video_reader_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		video_reader_unref (value->data[0].v_pointer);
	}
}

static void
value_video_reader_copy_value (const GValue* src_value,
                               GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = video_reader_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_video_reader_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_video_reader_collect_value (GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		VideoReader * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = video_reader_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_video_reader_lcopy_value (const GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	VideoReader ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = video_reader_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_video_reader (const gchar* name,
                         const gchar* nick,
                         const gchar* blurb,
                         GType object_type,
                         GParamFlags flags)
{
	ParamSpecVideoReader* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_VIDEO_READER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_video_reader (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIDEO_READER), NULL);
	return value->data[0].v_pointer;
}

void
value_set_video_reader (GValue* value,
                        gpointer v_object)
{
	VideoReader * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIDEO_READER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_VIDEO_READER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		video_reader_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		video_reader_unref (old);
	}
}

void
value_take_video_reader (GValue* value,
                         gpointer v_object)
{
	VideoReader * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIDEO_READER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_VIDEO_READER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		video_reader_unref (old);
	}
}

static void
video_reader_class_init (VideoReaderClass * klass,
                         gpointer klass_data)
{
	video_reader_parent_class = g_type_class_peek_parent (klass);
	((VideoReaderClass *) klass)->finalize = video_reader_finalize;
	g_type_class_adjust_private_offset (klass, &VideoReader_private_offset);
}

static void
video_reader_instance_init (VideoReader * self,
                            gpointer klass)
{
	self->priv = video_reader_get_instance_private (self);
	self->priv->clip_duration = VIDEO_READER_UNKNOWN_CLIP_DURATION;
	self->priv->preview_frame = NULL;
	self->priv->file = NULL;
	self->priv->thumbnailer_pid = (GPid) 0;
	self->priv->_timestamp = (gint64) -1;
	self->ref_count = 1;
}

static void
video_reader_finalize (VideoReader * obj)
{
	VideoReader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIDEO_READER, VideoReader);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->preview_frame);
	_g_object_unref0 (self->priv->file);
}

static GType
video_reader_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_video_reader_init, value_video_reader_free_value, value_video_reader_copy_value, value_video_reader_peek_pointer, "p", value_video_reader_collect_value, "p", value_video_reader_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (VideoReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoReader), 0, (GInstanceInitFunc) video_reader_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType video_reader_type_id;
	video_reader_type_id = g_type_register_fundamental (g_type_fundamental_next (), "VideoReader", &g_define_type_info, &g_define_type_fundamental_info, 0);
	VideoReader_private_offset = g_type_add_instance_private (video_reader_type_id, sizeof (VideoReaderPrivate));
	return video_reader_type_id;
}

GType
video_reader_get_type (void)
{
	static volatile gsize video_reader_type_id__once = 0;
	if (g_once_init_enter (&video_reader_type_id__once)) {
		GType video_reader_type_id;
		video_reader_type_id = video_reader_get_type_once ();
		g_once_init_leave (&video_reader_type_id__once, video_reader_type_id);
	}
	return video_reader_type_id__once;
}

gpointer
video_reader_ref (gpointer instance)
{
	VideoReader * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
video_reader_unref (gpointer instance)
{
	VideoReader * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VIDEO_READER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
video_get_instance_private (Video* self)
{
	return G_STRUCT_MEMBER_P (self, Video_private_offset);
}

static gpointer
_video_row_ref0 (gpointer self)
{
	return self ? video_row_ref (self) : NULL;
}

Video*
video_construct (GType object_type,
                 VideoRow* row)
{
	Video * self = NULL;
	VideoRow* _tmp0_;
	VideoRow* _tmp1_;
	VideoRow* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (row != NULL, NULL);
	self = (Video*) video_source_construct (object_type);
	_tmp0_ = _video_row_ref0 (row);
	_video_row_unref0 (self->priv->backing_row);
	self->priv->backing_row = _tmp0_;
	_tmp1_ = self->priv->backing_row;
	_tmp2_ = self->priv->backing_row;
	_tmp3_ = _tmp2_->title;
	_tmp4_ = media_source_prep_title (_tmp3_);
	_g_free0 (_tmp1_->title);
	_tmp1_->title = _tmp4_;
	if ((row->flags & VIDEO_FLAG_TRASH) != ((guint64) 0)) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = (row->flags & VIDEO_FLAG_OFFLINE) != ((guint64) 0);
	}
	if (_tmp5_) {
		VideoSourceCollection* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = video_global;
		_tmp7_ = row->backlinks;
		data_source_rehydrate_backlinks ((DataSource*) self, (SourceCollection*) _tmp6_, _tmp7_);
	}
	return self;
}

Video*
video_new (VideoRow* row)
{
	return video_construct (TYPE_VIDEO, row);
}

void
video_init (ProgressMonitor monitor,
            gpointer monitor_target)
{
	GSettings* _tmp0_;
	gchar** fake_args = NULL;
	gchar** _tmp1_;
	gint fake_args_length1;
	gint _fake_args_size_;
	gchar** fake_unowned_args = NULL;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gint fake_unowned_args_length1;
	gint _fake_unowned_args_size_;
	gint saved_state = 0;
	GSettings* _tmp3_;
	GstRegistry* _tmp4_;
	VideoSourceCollection* _tmp5_;
	GeeArrayList* all = NULL;
	VideoTable* _tmp6_;
	VideoTable* _tmp7_;
	GeeArrayList* _tmp8_;
	GeeArrayList* _tmp9_;
	GeeArrayList* all_videos = NULL;
	GeeArrayList* _tmp10_;
	GeeArrayList* trashed_videos = NULL;
	GeeArrayList* _tmp11_;
	GeeArrayList* offline_videos = NULL;
	GeeArrayList* _tmp12_;
	gint count = 0;
	GeeArrayList* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	VideoSourceCollection* _tmp32_;
	GeeArrayList* _tmp33_;
	VideoSourceCollection* _tmp34_;
	GeeArrayList* _tmp35_;
	VideoSourceCollection* _tmp36_;
	GeeArrayList* _tmp37_;
	GeeCollection* _tmp38_;
	GeeCollection* _tmp39_;
	video_interpreter_state_changed = FALSE;
	video_current_state = -1;
	video_normal_regen_complete = FALSE;
	video_offline_regen_complete = FALSE;
	_tmp0_ = g_settings_new (GSETTINGS_CONFIGURATION_ENGINE_VIDEO_SCHEMA_NAME);
	_g_object_unref0 (video_video_settings);
	video_video_settings = _tmp0_;
	_tmp1_ = g_new0 (gchar*, 0 + 1);
	fake_args = _tmp1_;
	fake_args_length1 = 0;
	_fake_args_size_ = fake_args_length1;
	_tmp2_ = fake_args;
	_tmp2__length1 = fake_args_length1;
	fake_unowned_args = _tmp2_;
	fake_unowned_args_length1 = _tmp2__length1;
	_fake_unowned_args_size_ = fake_unowned_args_length1;
	gst_init ((gint*) (&fake_unowned_args_length1), &fake_unowned_args);
	_fake_unowned_args_size_ = fake_unowned_args_length1;
	_tmp3_ = video_video_settings;
	saved_state = g_settings_get_int (_tmp3_, "interpreter-state-cookie");
	_tmp4_ = gst_registry_get ();
	video_current_state = (gint) gst_registry_get_feature_list_cookie (_tmp4_);
	if (saved_state == VIDEO_NO_VIDEO_INTERPRETER_STATE) {
		g_message ("VideoSupport.vala:403: interpreter state cookie not found; assuming al" \
"l video thumbnails are out of date");
		video_interpreter_state_changed = TRUE;
	} else {
		if (saved_state != video_current_state) {
			g_message ("VideoSupport.vala:406: interpreter state has changed; video thumbnails" \
" may be out of date");
			video_interpreter_state_changed = TRUE;
		}
	}
	_tmp5_ = video_source_collection_new ();
	_data_collection_unref0 (video_global);
	video_global = _tmp5_;
	_tmp6_ = video_table_get_instance ();
	_tmp7_ = _tmp6_;
	_tmp8_ = video_table_get_all (_tmp7_);
	_tmp9_ = _tmp8_;
	_database_table_unref0 (_tmp7_);
	all = _tmp9_;
	_tmp10_ = gee_array_list_new (TYPE_VIDEO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	all_videos = _tmp10_;
	_tmp11_ = gee_array_list_new (TYPE_VIDEO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	trashed_videos = _tmp11_;
	_tmp12_ = gee_array_list_new (TYPE_VIDEO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	offline_videos = _tmp12_;
	_tmp13_ = all;
	_tmp14_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp13_);
	_tmp15_ = _tmp14_;
	count = _tmp15_;
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp16_ = FALSE;
			_tmp16_ = TRUE;
			while (TRUE) {
				Video* video = NULL;
				GeeArrayList* _tmp18_;
				gpointer _tmp19_;
				VideoRow* _tmp20_;
				Video* _tmp21_;
				Video* _tmp22_;
				Video* _tmp24_;
				if (!_tmp16_) {
					gint _tmp17_;
					_tmp17_ = ctr;
					ctr = _tmp17_ + 1;
				}
				_tmp16_ = FALSE;
				if (!(ctr < count)) {
					break;
				}
				_tmp18_ = all;
				_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, ctr);
				_tmp20_ = (VideoRow*) _tmp19_;
				_tmp21_ = video_new (_tmp20_);
				_tmp22_ = _tmp21_;
				_video_row_unref0 (_tmp20_);
				video = _tmp22_;
				if (video_interpreter_state_changed) {
					Video* _tmp23_;
					_tmp23_ = video;
					video_set_is_interpretable (_tmp23_, FALSE);
				}
				_tmp24_ = video;
				if (media_source_is_trashed ((MediaSource*) _tmp24_)) {
					GeeArrayList* _tmp25_;
					Video* _tmp26_;
					_tmp25_ = trashed_videos;
					_tmp26_ = video;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, _tmp26_);
				} else {
					Video* _tmp27_;
					_tmp27_ = video;
					if (media_source_is_offline ((MediaSource*) _tmp27_)) {
						GeeArrayList* _tmp28_;
						Video* _tmp29_;
						_tmp28_ = offline_videos;
						_tmp29_ = video;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp28_, _tmp29_);
					} else {
						GeeArrayList* _tmp30_;
						Video* _tmp31_;
						_tmp30_ = all_videos;
						_tmp31_ = video;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp30_, _tmp31_);
					}
				}
				if (monitor != NULL) {
					monitor ((guint64) ctr, (guint64) count, TRUE, monitor_target);
				}
				_g_object_unref0 (video);
			}
		}
	}
	_tmp32_ = video_global;
	_tmp33_ = trashed_videos;
	media_source_collection_add_many_to_trash ((MediaSourceCollection*) _tmp32_, (GeeCollection*) _tmp33_);
	_tmp34_ = video_global;
	_tmp35_ = offline_videos;
	media_source_collection_add_many_to_offline ((MediaSourceCollection*) _tmp34_, (GeeCollection*) _tmp35_);
	_tmp36_ = video_global;
	_tmp37_ = all_videos;
	_tmp38_ = data_collection_add_many ((DataCollection*) _tmp36_, (GeeCollection*) _tmp37_, NULL, NULL);
	_tmp39_ = _tmp38_;
	_g_object_unref0 (_tmp39_);
	_g_object_unref0 (offline_videos);
	_g_object_unref0 (trashed_videos);
	_g_object_unref0 (all_videos);
	_g_object_unref0 (all);
	fake_args = (_vala_array_free (fake_args, fake_args_length1, (GDestroyNotify) g_free), NULL);
}

gboolean
video_has_interpreter_state_changed (void)
{
	gboolean result;
	result = video_interpreter_state_changed;
	return result;
}

void
video_notify_normal_thumbs_regenerated (void)
{
	gboolean _tmp0_ = FALSE;
	if (video_normal_regen_complete) {
		return;
	}
	g_message ("VideoSupport.vala:447: normal video thumbnail regeneration completed");
	video_normal_regen_complete = TRUE;
	if (video_normal_regen_complete) {
		_tmp0_ = video_offline_regen_complete;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		video_save_interpreter_state ();
	}
}

void
video_notify_offline_thumbs_regenerated (void)
{
	gboolean _tmp0_ = FALSE;
	if (video_offline_regen_complete) {
		return;
	}
	g_message ("VideoSupport.vala:458: offline video thumbnail regeneration completed");
	video_offline_regen_complete = TRUE;
	if (video_normal_regen_complete) {
		_tmp0_ = video_offline_regen_complete;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		video_save_interpreter_state ();
	}
}

static void
video_save_interpreter_state (void)
{
	if (video_interpreter_state_changed) {
		GSettings* _tmp0_;
		g_message ("VideoSupport.vala:467: saving video interpreter state to configuration" \
" system");
		_tmp0_ = video_video_settings;
		g_settings_set_int (_tmp0_, "interpreter-state-cookie", video_current_state);
		video_interpreter_state_changed = FALSE;
	}
}

void
video_terminate (void)
{
}

ExporterUI*
video_export_many (GeeCollection* videos,
                   ExporterCompletionCallback done,
                   gpointer done_target,
                   gboolean export_in_place)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp9_;
	gint _tmp10_;
	GFile* export_dir = NULL;
	GFile* _tmp32_;
	GFile* _tmp33_;
	ExporterUI* exporter = NULL;
	GFile* _tmp34_;
	Scaling _tmp35_ = {0};
	ExportFormatParameters _tmp36_ = {0};
	Exporter* _tmp37_;
	Exporter* _tmp38_;
	ExporterUI* _tmp39_;
	ExporterUI* _tmp40_;
	ExporterUI* _tmp41_;
	GError* _inner_error0_ = NULL;
	ExporterUI* result;
	g_return_val_if_fail (videos != NULL, NULL);
	_tmp0_ = gee_collection_get_size (videos);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0) {
		result = NULL;
		return result;
	}
	if (export_in_place) {
		ExporterUI* temp_exporter = NULL;
		Scaling _tmp2_ = {0};
		ExportFormatParameters _tmp3_ = {0};
		Exporter* _tmp4_;
		Exporter* _tmp5_;
		ExporterUI* _tmp6_;
		ExporterUI* _tmp7_;
		ExporterUI* _tmp8_;
		scaling_for_original (&_tmp2_);
		export_format_parameters_unmodified (&_tmp3_);
		_tmp4_ = exporter_new_for_temp_file (videos, &_tmp2_, &_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = exporter_ui_new (_tmp5_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
		temp_exporter = _tmp7_;
		_tmp8_ = temp_exporter;
		exporter_ui_export (_tmp8_, done, done_target);
		result = temp_exporter;
		return result;
	}
	_tmp9_ = gee_collection_get_size (videos);
	_tmp10_ = _tmp9_;
	if (_tmp10_ == 1) {
		Video* video = NULL;
		GFile* save_as = NULL;
		Video* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		GFile* _tmp20_;
		GFile* _tmp21_;
		GFile* _tmp22_;
		video = NULL;
		{
			GeeIterator* _v_it = NULL;
			GeeIterator* _tmp11_;
			_tmp11_ = gee_iterable_iterator ((GeeIterable*) videos);
			_v_it = _tmp11_;
			while (TRUE) {
				GeeIterator* _tmp12_;
				Video* v = NULL;
				GeeIterator* _tmp13_;
				gpointer _tmp14_;
				Video* _tmp15_;
				Video* _tmp16_;
				_tmp12_ = _v_it;
				if (!gee_iterator_next (_tmp12_)) {
					break;
				}
				_tmp13_ = _v_it;
				_tmp14_ = gee_iterator_get (_tmp13_);
				v = (Video*) _tmp14_;
				_tmp15_ = v;
				_tmp16_ = _g_object_ref0 (_tmp15_);
				_g_object_unref0 (video);
				video = _tmp16_;
				_g_object_unref0 (v);
				break;
			}
			_g_object_unref0 (_v_it);
		}
		_tmp17_ = video;
		_tmp18_ = media_source_get_basename ((MediaSource*) _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = export_ui_choose_file (_tmp19_);
		_tmp21_ = _tmp20_;
		_g_free0 (_tmp19_);
		save_as = _tmp21_;
		_tmp22_ = save_as;
		if (_tmp22_ == NULL) {
			result = NULL;
			_g_object_unref0 (save_as);
			_g_object_unref0 (video);
			return result;
		}
		{
			AppWindow* _tmp23_;
			AppWindow* _tmp24_;
			Video* _tmp25_;
			GFile* _tmp26_;
			AppWindow* _tmp27_;
			AppWindow* _tmp28_;
			_tmp23_ = app_window_get_instance ();
			_tmp24_ = _tmp23_;
			page_window_set_busy_cursor ((PageWindow*) _tmp24_);
			_g_object_unref0 (_tmp24_);
			_tmp25_ = video;
			_tmp26_ = save_as;
			video_export (_tmp25_, _tmp26_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp27_ = app_window_get_instance ();
			_tmp28_ = _tmp27_;
			page_window_set_normal_cursor ((PageWindow*) _tmp28_);
			_g_object_unref0 (_tmp28_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			AppWindow* _tmp29_;
			AppWindow* _tmp30_;
			GFile* _tmp31_;
			g_clear_error (&_inner_error0_);
			_tmp29_ = app_window_get_instance ();
			_tmp30_ = _tmp29_;
			page_window_set_normal_cursor ((PageWindow*) _tmp30_);
			_g_object_unref0 (_tmp30_);
			_tmp31_ = save_as;
			export_error_dialog (_tmp31_, FALSE);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (save_as);
			_g_object_unref0 (video);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		result = NULL;
		_g_object_unref0 (save_as);
		_g_object_unref0 (video);
		return result;
	}
	_tmp32_ = export_ui_choose_dir (_ ("Export Videos"));
	export_dir = _tmp32_;
	_tmp33_ = export_dir;
	if (_tmp33_ == NULL) {
		result = NULL;
		_g_object_unref0 (export_dir);
		return result;
	}
	_tmp34_ = export_dir;
	scaling_for_original (&_tmp35_);
	export_format_parameters_unmodified (&_tmp36_);
	_tmp37_ = exporter_new (videos, _tmp34_, &_tmp35_, &_tmp36_, FALSE);
	_tmp38_ = _tmp37_;
	_tmp39_ = exporter_ui_new (_tmp38_);
	_tmp40_ = _tmp39_;
	_g_object_unref0 (_tmp38_);
	exporter = _tmp40_;
	_tmp41_ = exporter;
	exporter_ui_export (_tmp41_, done, done_target);
	result = exporter;
	_g_object_unref0 (export_dir);
	return result;
}

static void
video_real_commit_backlinks (DataSource* base,
                             SourceCollection* sources,
                             const gchar* backlinks)
{
	Video * self;
	GError* _inner_error0_ = NULL;
	self = (Video*) base;
	{
		VideoTable* _tmp0_;
		VideoTable* _tmp1_;
		VideoID _tmp2_ = {0};
		_tmp0_ = video_table_get_instance ();
		_tmp1_ = _tmp0_;
		video_get_video_id (self, &_tmp2_);
		video_table_update_backlinks (_tmp1_, &_tmp2_, backlinks, &_inner_error0_);
		_database_table_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		{
			VideoRow* _tmp3_;
			_tmp3_ = self->priv->backing_row;
			g_rec_mutex_lock (&self->priv->__lock_backing_row);
			{
				VideoRow* _tmp4_;
				gchar* _tmp5_;
				_tmp4_ = self->priv->backing_row;
				_tmp5_ = g_strdup (backlinks);
				_g_free0 (_tmp4_->backlinks);
				_tmp4_->backlinks = _tmp5_;
			}
			__finally1:
			{
				VideoRow* _tmp6_;
				_tmp6_ = self->priv->backing_row;
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
			}
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == DATABASE_ERROR) {
					goto __catch0_database_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GError* _tmp9_;
		const gchar* _tmp10_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = data_object_to_string ((DataObject*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = err;
		_tmp10_ = _tmp9_->message;
		g_warning ("VideoSupport.vala:533: Unable to update link state for %s: %s", _tmp8_, _tmp10_);
		_g_free0 (_tmp8_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gboolean
video_real_set_event_id (MediaSource* base,
                         EventID* event_id)
{
	Video * self;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (Video*) base;
	g_return_val_if_fail (event_id != NULL, FALSE);
	{
		VideoRow* _tmp0_;
		gboolean _tmp11_ = FALSE;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			gboolean committed = FALSE;
			VideoTable* _tmp1_;
			VideoTable* _tmp2_;
			VideoRow* _tmp3_;
			VideoID _tmp4_;
			EventID _tmp5_;
			gboolean _tmp6_;
			_tmp1_ = video_table_get_instance ();
			_tmp2_ = _tmp1_;
			_tmp3_ = self->priv->backing_row;
			_tmp4_ = _tmp3_->video_id;
			_tmp5_ = *event_id;
			_tmp6_ = video_table_set_event (_tmp2_, &_tmp4_, &_tmp5_);
			_database_table_unref0 (_tmp2_);
			committed = _tmp6_;
			if (committed) {
				VideoRow* _tmp7_;
				EventID _tmp8_;
				_tmp7_ = self->priv->backing_row;
				_tmp8_ = *event_id;
				_tmp7_->event_id = _tmp8_;
			}
			result = committed;
			{
				VideoRow* _tmp9_;
				_tmp9_ = self->priv->backing_row;
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
			}
			return result;
		}
		__finally0:
		{
			VideoRow* _tmp10_;
			_tmp10_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp11_;
	}
}

gboolean
video_is_duplicate (GFile* file,
                    const gchar* full_md5)
{
	gboolean _tmp0_ = FALSE;
	VideoTable* _tmp1_;
	VideoTable* _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	if (file != NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = full_md5 != NULL;
	}
	_vala_assert (_tmp0_, "file != null || full_md5 != null");
	_tmp1_ = video_table_get_instance ();
	_tmp2_ = _tmp1_;
	_tmp3_ = video_table_has_duplicate (_tmp2_, file, full_md5);
	_database_table_unref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

ImportResult
video_import_create (VideoImportParams* params,
                     Video** video)
{
	Video* _vala_video = NULL;
	VideoRow* _tmp6_;
	Video* _tmp7_;
	GError* _inner_error0_ = NULL;
	ImportResult result;
	g_return_val_if_fail (params != NULL, 0);
	_g_object_unref0 (_vala_video);
	_vala_video = NULL;
	{
		VideoID _tmp0_ = {0};
		VideoTable* _tmp1_;
		VideoTable* _tmp2_;
		VideoRow* _tmp3_;
		VideoID _tmp4_ = {0};
		VideoID _tmp5_;
		_tmp1_ = video_table_get_instance ();
		_tmp2_ = _tmp1_;
		_tmp3_ = params->row;
		video_table_add (_tmp2_, _tmp3_, &_tmp4_, &_inner_error0_);
		_tmp5_ = _tmp4_;
		_database_table_unref0 (_tmp2_);
		_tmp0_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			_g_object_unref0 (_vala_video);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return 0;
		}
		if (video_id_is_invalid (&_tmp0_)) {
			result = IMPORT_RESULT_DATABASE_ERROR;
			if (video) {
				*video = _vala_video;
			} else {
				_g_object_unref0 (_vala_video);
			}
			return result;
		}
	}
	goto __finally0;
	__catch0_database_error:
	{
		g_clear_error (&_inner_error0_);
		result = IMPORT_RESULT_DATABASE_ERROR;
		if (video) {
			*video = _vala_video;
		} else {
			_g_object_unref0 (_vala_video);
		}
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (_vala_video);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return 0;
	}
	_tmp6_ = params->row;
	_tmp7_ = video_new (_tmp6_);
	_g_object_unref0 (_vala_video);
	_vala_video = _tmp7_;
	result = IMPORT_RESULT_SUCCESS;
	if (video) {
		*video = _vala_video;
	} else {
		_g_object_unref0 (_vala_video);
	}
	return result;
}

void
video_import_failed (Video* video)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (video != NULL);
	{
		VideoTable* _tmp0_;
		VideoTable* _tmp1_;
		VideoID _tmp2_ = {0};
		_tmp0_ = video_table_get_instance ();
		_tmp1_ = _tmp0_;
		video_get_video_id (video, &_tmp2_);
		video_table_remove (_tmp1_, &_tmp2_, &_inner_error0_);
		_database_table_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = err;
		app_window_database_error (_tmp3_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static BackingFileState**
video_real_get_backing_files_state (MediaSource* base,
                                    gint* result_length1)
{
	Video * self;
	BackingFileState** backing = NULL;
	BackingFileState** _tmp0_;
	gint backing_length1;
	gint _backing_size_;
	BackingFileState** _tmp10_;
	gint _tmp10__length1;
	GError* _inner_error0_ = NULL;
	BackingFileState** result;
	self = (Video*) base;
	_tmp0_ = g_new0 (BackingFileState*, 1 + 1);
	backing = _tmp0_;
	backing_length1 = 1;
	_backing_size_ = backing_length1;
	{
		VideoRow* _tmp1_;
		_tmp1_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp2_;
			const gchar* _tmp3_;
			VideoRow* _tmp4_;
			VideoRow* _tmp5_;
			VideoRow* _tmp6_;
			const gchar* _tmp7_;
			BackingFileState* _tmp8_;
			_tmp2_ = self->priv->backing_row;
			_tmp3_ = _tmp2_->filepath;
			_tmp4_ = self->priv->backing_row;
			_tmp5_ = self->priv->backing_row;
			_tmp6_ = self->priv->backing_row;
			_tmp7_ = _tmp6_->md5;
			_tmp8_ = backing_file_state_new (_tmp3_, _tmp4_->filesize, _tmp5_->timestamp, _tmp7_);
			_backing_file_state_unref0 (backing[0]);
			backing[0] = _tmp8_;
		}
		__finally0:
		{
			VideoRow* _tmp9_;
			_tmp9_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			backing = (_vala_array_free (backing, backing_length1, (GDestroyNotify) backing_file_state_unref), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp10_ = backing;
	_tmp10__length1 = backing_length1;
	if (result_length1) {
		*result_length1 = _tmp10__length1;
	}
	result = _tmp10_;
	return result;
}

static GdkPixbuf*
video_real_get_thumbnail (ThumbnailSource* base,
                          gint scale,
                          GError** error)
{
	Video * self;
	GdkPixbuf* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	self = (Video*) base;
	_tmp1_ = thumbnail_cache_fetch ((ThumbnailSource*) self, scale, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp2_;
	_g_object_unref0 (_tmp0_);
	return result;
}

static gchar*
video_real_get_master_md5 (MediaSource* base)
{
	Video * self;
	GError* _inner_error0_ = NULL;
	gchar* result;
	self = (Video*) base;
	{
		VideoRow* _tmp0_;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp1_ = self->priv->backing_row;
			_tmp2_ = _tmp1_->md5;
			_tmp3_ = g_strdup (_tmp2_);
			result = _tmp3_;
			{
				VideoRow* _tmp4_;
				_tmp4_ = self->priv->backing_row;
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
			}
			return result;
		}
		__finally0:
		{
			VideoRow* _tmp5_;
			_tmp5_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static GdkPixbuf*
video_real_get_preview_pixbuf (MediaSource* base,
                               Scaling* scaling,
                               GError** error)
{
	Video * self;
	GdkPixbuf* pixbuf = NULL;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	self = (Video*) base;
	g_return_val_if_fail (scaling != NULL, NULL);
	_tmp0_ = thumbnail_source_get_thumbnail ((ThumbnailSource*) self, (gint) THUMBNAIL_CACHE_SIZE_BIG, &_inner_error0_);
	pixbuf = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp1_ = scaling_perform_on_pixbuf (scaling, pixbuf, GDK_INTERP_NEAREST, TRUE);
	result = _tmp1_;
	_g_object_unref0 (pixbuf);
	return result;
}

static GdkPixbuf*
video_real_create_thumbnail (ThumbnailSource* base,
                             gint scale,
                             GError** error)
{
	Video * self;
	VideoReader* reader = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	VideoReader* _tmp2_;
	VideoReader* _tmp3_;
	GdkPixbuf* frame = NULL;
	VideoReader* _tmp4_;
	GdkPixbuf* _tmp5_;
	GdkPixbuf* _tmp6_ = NULL;
	GdkPixbuf* _tmp7_;
	GdkPixbuf* result;
	self = (Video*) base;
	_tmp0_ = media_source_get_file ((MediaSource*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = video_reader_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	reader = _tmp3_;
	_tmp4_ = reader;
	_tmp5_ = video_reader_read_preview_frame (_tmp4_);
	frame = _tmp5_;
	_tmp7_ = frame;
	if (_tmp7_ != NULL) {
		GdkPixbuf* _tmp8_;
		GdkPixbuf* _tmp9_;
		_tmp8_ = frame;
		_tmp9_ = _g_object_ref0 (_tmp8_);
		_g_object_unref0 (_tmp6_);
		_tmp6_ = _tmp9_;
	} else {
		GdkPixbuf* _tmp10_;
		GdkPixbuf* _tmp11_;
		GdkPixbuf* _tmp12_;
		_tmp10_ = resources_get_noninterpretable_badge_pixbuf ();
		_tmp11_ = _tmp10_;
		_tmp12_ = gdk_pixbuf_copy (_tmp11_);
		_g_object_unref0 (_tmp6_);
		_tmp6_ = _tmp12_;
		_g_object_unref0 (_tmp11_);
	}
	result = _tmp6_;
	_g_object_unref0 (frame);
	_video_reader_unref0 (reader);
	return result;
}

static gchar*
video_real_get_typename (DataSource* base)
{
	Video * self;
	gchar* _tmp0_;
	gchar* result;
	self = (Video*) base;
	_tmp0_ = g_strdup (VIDEO_TYPENAME);
	result = _tmp0_;
	return result;
}

static gint64
video_real_get_instance_id (DataSource* base)
{
	Video * self;
	VideoID _tmp0_ = {0};
	gint64 result;
	self = (Video*) base;
	video_get_video_id (self, &_tmp0_);
	result = _tmp0_.id;
	return result;
}

static void
video_real_get_import_id (MediaSource* base,
                          ImportID* result)
{
	Video * self;
	GError* _inner_error0_ = NULL;
	self = (Video*) base;
	{
		VideoRow* _tmp0_;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp1_;
			ImportID _tmp2_;
			_tmp1_ = self->priv->backing_row;
			_tmp2_ = _tmp1_->import_id;
			*result = _tmp2_;
			{
				VideoRow* _tmp3_;
				_tmp3_ = self->priv->backing_row;
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
			}
			return;
		}
		__finally0:
		{
			VideoRow* _tmp4_;
			_tmp4_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static PhotoFileFormat
video_real_get_preferred_thumbnail_format (ThumbnailSource* base)
{
	Video * self;
	PhotoFileFormat result;
	self = (Video*) base;
	result = photo_file_format_get_system_default_format ();
	return result;
}

static gchar*
video_real_get_title (MediaSource* base)
{
	Video * self;
	GError* _inner_error0_ = NULL;
	gchar* result;
	self = (Video*) base;
	{
		VideoRow* _tmp0_;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp1_ = self->priv->backing_row;
			_tmp2_ = _tmp1_->title;
			_tmp3_ = g_strdup (_tmp2_);
			result = _tmp3_;
			{
				VideoRow* _tmp4_;
				_tmp4_ = self->priv->backing_row;
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
			}
			return result;
		}
		__finally0:
		{
			VideoRow* _tmp5_;
			_tmp5_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static void
video_real_set_title (MediaSource* base,
                      const gchar* title)
{
	Video * self;
	gchar* new_title = NULL;
	gchar* _tmp0_;
	Alteration* _tmp18_;
	Alteration* _tmp19_;
	GError* _inner_error0_ = NULL;
	self = (Video*) base;
	_tmp0_ = media_source_prep_title (title);
	new_title = _tmp0_;
	{
		VideoRow* _tmp1_;
		_tmp1_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp2_;
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			VideoRow* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp2_ = self->priv->backing_row;
			_tmp3_ = _tmp2_->title;
			_tmp4_ = new_title;
			if (g_strcmp0 (_tmp3_, _tmp4_) == 0) {
				{
					VideoRow* _tmp5_;
					_tmp5_ = self->priv->backing_row;
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
				}
				_g_free0 (new_title);
				return;
			}
			{
				VideoTable* _tmp6_;
				VideoTable* _tmp7_;
				VideoRow* _tmp8_;
				VideoID _tmp9_;
				const gchar* _tmp10_;
				_tmp6_ = video_table_get_instance ();
				_tmp7_ = _tmp6_;
				_tmp8_ = self->priv->backing_row;
				_tmp9_ = _tmp8_->video_id;
				_tmp10_ = new_title;
				video_table_set_title (_tmp7_, &_tmp9_, _tmp10_, &_inner_error0_);
				_database_table_unref0 (_tmp7_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == DATABASE_ERROR) {
						goto __catch1_database_error;
					}
					{
						VideoRow* _tmp11_;
						_tmp11_ = self->priv->backing_row;
						g_rec_mutex_unlock (&self->priv->__lock_backing_row);
					}
					_g_free0 (new_title);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			goto __finally1;
			__catch1_database_error:
			{
				GError* e = NULL;
				GError* _tmp12_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp12_ = e;
				app_window_database_error (_tmp12_);
				_g_error_free0 (e);
				{
					VideoRow* _tmp13_;
					_tmp13_ = self->priv->backing_row;
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
				}
				_g_free0 (new_title);
				return;
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (new_title);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp14_ = self->priv->backing_row;
			_tmp15_ = new_title;
			_tmp16_ = g_strdup (_tmp15_);
			_g_free0 (_tmp14_->title);
			_tmp14_->title = _tmp16_;
		}
		__finally0:
		{
			VideoRow* _tmp17_;
			_tmp17_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (new_title);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp18_ = alteration_new ("metadata", "name");
	_tmp19_ = _tmp18_;
	data_object_notify_altered ((DataObject*) self, _tmp19_);
	_alteration_unref0 (_tmp19_);
	_g_free0 (new_title);
}

static gchar*
video_real_get_comment (MediaSource* base)
{
	Video * self;
	GError* _inner_error0_ = NULL;
	gchar* result;
	self = (Video*) base;
	{
		VideoRow* _tmp0_;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp1_ = self->priv->backing_row;
			_tmp2_ = _tmp1_->comment;
			_tmp3_ = g_strdup (_tmp2_);
			result = _tmp3_;
			{
				VideoRow* _tmp4_;
				_tmp4_ = self->priv->backing_row;
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
			}
			return result;
		}
		__finally0:
		{
			VideoRow* _tmp5_;
			_tmp5_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static gboolean
video_real_set_comment (MediaSource* base,
                        const gchar* comment)
{
	Video * self;
	gchar* new_comment = NULL;
	gchar* _tmp0_;
	Alteration* _tmp21_;
	Alteration* _tmp22_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (Video*) base;
	_tmp0_ = media_source_prep_title (comment);
	new_comment = _tmp0_;
	{
		VideoRow* _tmp1_;
		_tmp1_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp2_;
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			VideoRow* _tmp16_;
			const gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp2_ = self->priv->backing_row;
			_tmp3_ = _tmp2_->comment;
			_tmp4_ = new_comment;
			if (g_strcmp0 (_tmp3_, _tmp4_) == 0) {
				result = TRUE;
				{
					VideoRow* _tmp5_;
					_tmp5_ = self->priv->backing_row;
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
				}
				_g_free0 (new_comment);
				return result;
			}
			{
				VideoTable* _tmp6_;
				VideoTable* _tmp7_;
				VideoRow* _tmp8_;
				VideoID _tmp9_;
				const gchar* _tmp10_;
				_tmp6_ = video_table_get_instance ();
				_tmp7_ = _tmp6_;
				_tmp8_ = self->priv->backing_row;
				_tmp9_ = _tmp8_->video_id;
				_tmp10_ = new_comment;
				video_table_set_comment (_tmp7_, &_tmp9_, _tmp10_, &_inner_error0_);
				_database_table_unref0 (_tmp7_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gboolean _tmp12_ = FALSE;
					if (_inner_error0_->domain == DATABASE_ERROR) {
						goto __catch1_database_error;
					}
					{
						VideoRow* _tmp11_;
						_tmp11_ = self->priv->backing_row;
						g_rec_mutex_unlock (&self->priv->__lock_backing_row);
					}
					_g_free0 (new_comment);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp12_;
				}
			}
			goto __finally1;
			__catch1_database_error:
			{
				GError* e = NULL;
				GError* _tmp13_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp13_ = e;
				app_window_database_error (_tmp13_);
				result = FALSE;
				_g_error_free0 (e);
				{
					VideoRow* _tmp14_;
					_tmp14_ = self->priv->backing_row;
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
				}
				_g_free0 (new_comment);
				return result;
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp15_ = FALSE;
				_g_free0 (new_comment);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp15_;
			}
			_tmp16_ = self->priv->backing_row;
			_tmp17_ = new_comment;
			_tmp18_ = g_strdup (_tmp17_);
			_g_free0 (_tmp16_->comment);
			_tmp16_->comment = _tmp18_;
		}
		__finally0:
		{
			VideoRow* _tmp19_;
			_tmp19_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp20_ = FALSE;
			_g_free0 (new_comment);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp20_;
		}
	}
	_tmp21_ = alteration_new ("metadata", "comment");
	_tmp22_ = _tmp21_;
	data_object_notify_altered ((DataObject*) self, _tmp22_);
	_alteration_unref0 (_tmp22_);
	result = TRUE;
	_g_free0 (new_comment);
	return result;
}

static gboolean
video_real_is_trashed (MediaSource* base)
{
	Video * self;
	gboolean result;
	self = (Video*) base;
	result = video_is_flag_set (self, VIDEO_FLAG_TRASH);
	return result;
}

static gboolean
video_real_is_offline (Monitorable* base)
{
	Video * self;
	gboolean result;
	self = (Video*) base;
	result = video_is_flag_set (self, VIDEO_FLAG_OFFLINE);
	return result;
}

static void
video_real_mark_offline (Monitorable* base)
{
	Video * self;
	self = (Video*) base;
	video_add_flags (self, VIDEO_FLAG_OFFLINE, NULL);
}

static void
video_real_mark_online (Monitorable* base)
{
	Video * self;
	gboolean _tmp0_ = FALSE;
	self = (Video*) base;
	video_remove_flags (self, VIDEO_FLAG_OFFLINE, NULL);
	if (!video_get_is_interpretable (self)) {
		_tmp0_ = video_has_interpreter_state_changed ();
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		VideoInterpretableResults* _tmp1_;
		VideoInterpretableResults* _tmp2_;
		_tmp1_ = video_check_is_interpretable (self);
		_tmp2_ = _tmp1_;
		video_interpretable_results_foreground_finish (_tmp2_);
		_video_interpretable_results_unref0 (_tmp2_);
	}
}

static void
video_real_trash (MediaSource* base)
{
	Video * self;
	self = (Video*) base;
	video_add_flags (self, VIDEO_FLAG_TRASH, NULL);
}

static void
video_real_untrash (MediaSource* base)
{
	Video * self;
	self = (Video*) base;
	video_remove_flags (self, VIDEO_FLAG_TRASH, NULL);
}

static gboolean
video_real_is_flagged (Flaggable* base)
{
	Video * self;
	gboolean result;
	self = (Video*) base;
	result = video_is_flag_set (self, VIDEO_FLAG_FLAGGED);
	return result;
}

static void
video_real_mark_flagged (Flaggable* base)
{
	Video * self;
	Alteration* _tmp0_;
	Alteration* _tmp1_;
	self = (Video*) base;
	_tmp0_ = alteration_new ("metadata", "flagged");
	_tmp1_ = _tmp0_;
	video_add_flags (self, VIDEO_FLAG_FLAGGED, _tmp1_);
	_alteration_unref0 (_tmp1_);
}

static void
video_real_mark_unflagged (Flaggable* base)
{
	Video * self;
	Alteration* _tmp0_;
	Alteration* _tmp1_;
	self = (Video*) base;
	_tmp0_ = alteration_new ("metadata", "flagged");
	_tmp1_ = _tmp0_;
	video_remove_flags (self, VIDEO_FLAG_FLAGGED, _tmp1_);
	_alteration_unref0 (_tmp1_);
}

static void
video_real_get_event_id (MediaSource* base,
                         EventID* result)
{
	Video * self;
	GError* _inner_error0_ = NULL;
	self = (Video*) base;
	{
		VideoRow* _tmp0_;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp1_;
			EventID _tmp2_;
			_tmp1_ = self->priv->backing_row;
			_tmp2_ = _tmp1_->event_id;
			*result = _tmp2_;
			{
				VideoRow* _tmp3_;
				_tmp3_ = self->priv->backing_row;
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
			}
			return;
		}
		__finally0:
		{
			VideoRow* _tmp4_;
			_tmp4_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gchar*
video_real_to_string (DataObject* base)
{
	Video * self;
	GError* _inner_error0_ = NULL;
	gchar* result;
	self = (Video*) base;
	{
		VideoRow* _tmp0_;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp1_;
			VideoID _tmp2_;
			gchar* _tmp3_;
			gchar* _tmp4_;
			VideoRow* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp1_ = self->priv->backing_row;
			_tmp2_ = _tmp1_->video_id;
			_tmp3_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp2_.id);
			_tmp4_ = _tmp3_;
			_tmp5_ = self->priv->backing_row;
			_tmp6_ = _tmp5_->filepath;
			_tmp7_ = g_strdup_printf ("[%s] %s", _tmp4_, _tmp6_);
			_tmp8_ = _tmp7_;
			_g_free0 (_tmp4_);
			result = _tmp8_;
			{
				VideoRow* _tmp9_;
				_tmp9_ = self->priv->backing_row;
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
			}
			return result;
		}
		__finally0:
		{
			VideoRow* _tmp10_;
			_tmp10_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

void
video_get_video_id (Video* self,
                    VideoID* result)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		VideoRow* _tmp0_;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp1_;
			VideoID _tmp2_;
			_tmp1_ = self->priv->backing_row;
			_tmp2_ = _tmp1_->video_id;
			*result = _tmp2_;
			{
				VideoRow* _tmp3_;
				_tmp3_ = self->priv->backing_row;
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
			}
			return;
		}
		__finally0:
		{
			VideoRow* _tmp4_;
			_tmp4_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gint64
video_real_get_exposure_time (Dateable* base)
{
	Video * self;
	GError* _inner_error0_ = NULL;
	gint64 result;
	self = (Video*) base;
	{
		VideoRow* _tmp0_;
		gint64 _tmp4_ = -1LL;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp1_;
			_tmp1_ = self->priv->backing_row;
			result = _tmp1_->exposure_time;
			{
				VideoRow* _tmp2_;
				_tmp2_ = self->priv->backing_row;
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
			}
			return result;
		}
		__finally0:
		{
			VideoRow* _tmp3_;
			_tmp3_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
}

static void
video_real_set_exposure_time (Dateable* base,
                              gint64 time)
{
	Video * self;
	Alteration* _tmp9_;
	Alteration* _tmp10_;
	GError* _inner_error0_ = NULL;
	self = (Video*) base;
	{
		VideoRow* _tmp0_;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp7_;
			{
				VideoTable* _tmp1_;
				VideoTable* _tmp2_;
				VideoRow* _tmp3_;
				VideoID _tmp4_;
				_tmp1_ = video_table_get_instance ();
				_tmp2_ = _tmp1_;
				_tmp3_ = self->priv->backing_row;
				_tmp4_ = _tmp3_->video_id;
				video_table_set_exposure_time (_tmp2_, &_tmp4_, time, &_inner_error0_);
				_database_table_unref0 (_tmp2_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* e = NULL;
				GError* _tmp5_;
				const gchar* _tmp6_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp5_ = e;
				_tmp6_ = _tmp5_->message;
				g_debug ("VideoSupport.vala:757: Warning - %s", _tmp6_);
				_g_error_free0 (e);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp7_ = self->priv->backing_row;
			_tmp7_->exposure_time = time;
		}
		__finally0:
		{
			VideoRow* _tmp8_;
			_tmp8_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp9_ = alteration_new ("metadata", "exposure-time");
	_tmp10_ = _tmp9_;
	data_object_notify_altered ((DataObject*) self, _tmp10_);
	_alteration_unref0 (_tmp10_);
}

void
video_get_frame_dimensions (Video* self,
                            Dimensions* result)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		VideoRow* _tmp0_;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp1_;
			VideoRow* _tmp2_;
			Dimensions _tmp3_ = {0};
			_tmp1_ = self->priv->backing_row;
			_tmp2_ = self->priv->backing_row;
			dimensions_init (&_tmp3_, _tmp1_->width, _tmp2_->height);
			*result = _tmp3_;
			{
				VideoRow* _tmp4_;
				_tmp4_ = self->priv->backing_row;
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
			}
			return;
		}
		__finally0:
		{
			VideoRow* _tmp5_;
			_tmp5_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
video_real_get_dimensions (MediaSource* base,
                           PhotoException disallowed_steps,
                           Dimensions* result)
{
	Video * self;
	Dimensions _tmp0_ = {0};
	self = (Video*) base;
	video_get_frame_dimensions (self, &_tmp0_);
	*result = _tmp0_;
	return;
}

static guint64
video_real_get_filesize (MediaSource* base)
{
	Video * self;
	guint64 result;
	self = (Video*) base;
	result = media_source_get_master_filesize ((MediaSource*) self);
	return result;
}

static guint64
video_real_get_master_filesize (MediaSource* base)
{
	Video * self;
	GError* _inner_error0_ = NULL;
	guint64 result;
	self = (Video*) base;
	{
		VideoRow* _tmp0_;
		guint64 _tmp4_ = 0ULL;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp1_;
			_tmp1_ = self->priv->backing_row;
			result = (guint64) _tmp1_->filesize;
			{
				VideoRow* _tmp2_;
				_tmp2_ = self->priv->backing_row;
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
			}
			return result;
		}
		__finally0:
		{
			VideoRow* _tmp3_;
			_tmp3_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
}

static gint64
video_real_get_timestamp (MediaSource* base)
{
	Video * self;
	GError* _inner_error0_ = NULL;
	gint64 result;
	self = (Video*) base;
	{
		VideoRow* _tmp0_;
		gint64 _tmp4_ = -1LL;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp1_;
			_tmp1_ = self->priv->backing_row;
			result = _tmp1_->timestamp;
			{
				VideoRow* _tmp2_;
				_tmp2_ = self->priv->backing_row;
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
			}
			return result;
		}
		__finally0:
		{
			VideoRow* _tmp3_;
			_tmp3_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
}

static void
video_real_set_master_timestamp (Monitorable* base,
                                 GFileInfo* info)
{
	Video * self;
	gint64 mod_time = 0LL;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	gint64 _tmp2_;
	Alteration* _tmp14_;
	Alteration* _tmp15_;
	GError* _inner_error0_ = NULL;
	self = (Video*) base;
	g_return_if_fail (info != NULL);
	_tmp0_ = g_file_info_get_modification_date_time (info);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_date_time_to_unix (_tmp1_);
	_g_date_time_unref0 (_tmp1_);
	mod_time = _tmp2_;
	{
		{
			VideoRow* _tmp3_;
			_tmp3_ = self->priv->backing_row;
			g_rec_mutex_lock (&self->priv->__lock_backing_row);
			{
				VideoRow* _tmp4_;
				VideoTable* _tmp6_;
				VideoTable* _tmp7_;
				VideoRow* _tmp8_;
				VideoID _tmp9_;
				VideoRow* _tmp10_;
				_tmp4_ = self->priv->backing_row;
				if (_tmp4_->timestamp == mod_time) {
					{
						GError* _inner_error0_ = NULL;
						VideoRow* _tmp5_;
						_tmp5_ = self->priv->backing_row;
						g_rec_mutex_unlock (&self->priv->__lock_backing_row);
					}
					return;
				}
				_tmp6_ = video_table_get_instance ();
				_tmp7_ = _tmp6_;
				_tmp8_ = self->priv->backing_row;
				_tmp9_ = _tmp8_->video_id;
				video_table_set_timestamp (_tmp7_, &_tmp9_, mod_time, &_inner_error0_);
				_database_table_unref0 (_tmp7_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				_tmp10_ = self->priv->backing_row;
				_tmp10_->timestamp = mod_time;
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* _lock_error_ = NULL;
				GError* _tmp11_;
				_lock_error_ = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp11_ = _lock_error_;
				_lock_error_ = NULL;
				_inner_error0_ = _tmp11_;
				_g_error_free0 (_lock_error_);
				goto __finally1;
			}
			__finally1:
			{
				GError* _inner_error1_ = NULL;
				VideoRow* _tmp12_;
				_tmp12_ = self->priv->backing_row;
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
			}
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == DATABASE_ERROR) {
					goto __catch0_database_error;
				}
				goto __finally0;
			}
		}
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		GError* _tmp13_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = err;
		app_window_database_error (_tmp13_);
		_g_error_free0 (err);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp14_ = alteration_new ("metadata", "master-timestamp");
	_tmp15_ = _tmp14_;
	data_object_notify_altered ((DataObject*) self, _tmp15_);
	_alteration_unref0 (_tmp15_);
}

gchar*
video_get_filename (Video* self)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		VideoRow* _tmp0_;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp1_ = self->priv->backing_row;
			_tmp2_ = _tmp1_->filepath;
			_tmp3_ = g_strdup (_tmp2_);
			result = _tmp3_;
			{
				VideoRow* _tmp4_;
				_tmp4_ = self->priv->backing_row;
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
			}
			return result;
		}
		__finally0:
		{
			VideoRow* _tmp5_;
			_tmp5_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static GFile*
video_real_get_file (MediaSource* base)
{
	Video * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* result;
	self = (Video*) base;
	_tmp0_ = video_get_filename (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static GFile*
video_real_get_master_file (MediaSource* base)
{
	Video * self;
	GFile* _tmp0_;
	GFile* result;
	self = (Video*) base;
	_tmp0_ = media_source_get_file ((MediaSource*) self);
	result = _tmp0_;
	return result;
}

void
video_export (Video* self,
              GFile* dest_file,
              GError** error)
{
	GFile* source_file = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dest_file != NULL);
	_tmp0_ = video_get_filename (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	source_file = _tmp3_;
	g_file_copy (source_file, dest_file, G_FILE_COPY_OVERWRITE | G_FILE_COPY_TARGET_DEFAULT_PERMS, NULL, NULL, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (source_file);
		return;
	}
	_g_object_unref0 (source_file);
}

gdouble
video_get_clip_duration (Video* self)
{
	GError* _inner_error0_ = NULL;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	{
		VideoRow* _tmp0_;
		gdouble _tmp4_ = -1.0;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp1_;
			_tmp1_ = self->priv->backing_row;
			result = _tmp1_->clip_duration;
			{
				VideoRow* _tmp2_;
				_tmp2_ = self->priv->backing_row;
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
			}
			return result;
		}
		__finally0:
		{
			VideoRow* _tmp3_;
			_tmp3_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
}

gboolean
video_get_is_interpretable (Video* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		VideoRow* _tmp0_;
		gboolean _tmp4_ = FALSE;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp1_;
			_tmp1_ = self->priv->backing_row;
			result = _tmp1_->is_interpretable;
			{
				VideoRow* _tmp2_;
				_tmp2_ = self->priv->backing_row;
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
			}
			return result;
		}
		__finally0:
		{
			VideoRow* _tmp3_;
			_tmp3_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
}

static void
video_set_is_interpretable (Video* self,
                            gboolean is_interpretable)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		VideoRow* _tmp0_;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp1_;
			VideoRow* _tmp3_;
			_tmp1_ = self->priv->backing_row;
			if (_tmp1_->is_interpretable == is_interpretable) {
				{
					VideoRow* _tmp2_;
					_tmp2_ = self->priv->backing_row;
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
				}
				return;
			}
			_tmp3_ = self->priv->backing_row;
			_tmp3_->is_interpretable = is_interpretable;
		}
		__finally0:
		{
			VideoRow* _tmp4_;
			_tmp4_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	{
		VideoTable* _tmp5_;
		VideoTable* _tmp6_;
		VideoID _tmp7_ = {0};
		_tmp5_ = video_table_get_instance ();
		_tmp6_ = _tmp5_;
		video_get_video_id (self, &_tmp7_);
		video_table_update_is_interpretable (_tmp6_, &_tmp7_, is_interpretable, &_inner_error0_);
		_database_table_unref0 (_tmp6_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch1_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally1;
	__catch1_database_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		app_window_database_error (_tmp8_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

VideoInterpretableResults*
video_check_is_interpretable (Video* self)
{
	VideoInterpretableResults* results = NULL;
	VideoInterpretableResults* _tmp0_;
	gdouble clip_duration = 0.0;
	GdkPixbuf* preview_frame = NULL;
	VideoReader* backing_file_reader = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	VideoReader* _tmp3_;
	VideoReader* _tmp4_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	VideoInterpretableResults* _tmp20_;
	VideoInterpretableResults* _tmp21_;
	VideoInterpretableResults* _tmp22_;
	GdkPixbuf* _tmp23_;
	GdkPixbuf* _tmp24_;
	GError* _inner_error0_ = NULL;
	VideoInterpretableResults* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = video_interpretable_results_new (self);
	results = _tmp0_;
	clip_duration = -1.0;
	preview_frame = NULL;
	_tmp1_ = media_source_get_file ((MediaSource*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = video_reader_new (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	backing_file_reader = _tmp4_;
	{
		gdouble _tmp5_ = 0.0;
		VideoReader* _tmp6_;
		VideoReader* _tmp7_;
		GdkPixbuf* _tmp8_;
		_tmp6_ = backing_file_reader;
		_tmp5_ = video_reader_read_clip_duration (_tmp6_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VIDEO_ERROR) {
				goto __catch0_video_error;
			}
			_video_reader_unref0 (backing_file_reader);
			_g_object_unref0 (preview_frame);
			_video_interpretable_results_unref0 (results);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		clip_duration = _tmp5_;
		_tmp7_ = backing_file_reader;
		_tmp8_ = video_reader_read_preview_frame (_tmp7_);
		_g_object_unref0 (preview_frame);
		preview_frame = _tmp8_;
	}
	goto __finally0;
	__catch0_video_error:
	{
		VideoInterpretableResults* _tmp9_;
		VideoInterpretableResults* _tmp10_;
		g_clear_error (&_inner_error0_);
		_tmp9_ = results;
		_tmp9_->update_interpretable = video_get_is_interpretable (self);
		_tmp10_ = results;
		_tmp10_->is_interpretable = FALSE;
		result = results;
		_video_reader_unref0 (backing_file_reader);
		_g_object_unref0 (preview_frame);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_video_reader_unref0 (backing_file_reader);
		_g_object_unref0 (preview_frame);
		_video_interpretable_results_unref0 (results);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	if (video_get_is_interpretable (self)) {
		VideoInterpretableResults* _tmp11_;
		VideoInterpretableResults* _tmp12_;
		_tmp11_ = results;
		_tmp11_->update_interpretable = FALSE;
		_tmp12_ = results;
		_tmp12_->is_interpretable = TRUE;
		result = results;
		_video_reader_unref0 (backing_file_reader);
		_g_object_unref0 (preview_frame);
		return result;
	}
	_tmp13_ = media_source_get_file ((MediaSource*) self);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_file_get_basename (_tmp14_);
	_tmp16_ = _tmp15_;
	g_debug ("VideoSupport.vala:888: video %s has become interpretable", _tmp16_);
	_g_free0 (_tmp16_);
	_g_object_unref0 (_tmp14_);
	{
		VideoRow* _tmp17_;
		_tmp17_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp18_;
			_tmp18_ = self->priv->backing_row;
			_tmp18_->clip_duration = clip_duration;
		}
		__finally1:
		{
			VideoRow* _tmp19_;
			_tmp19_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_video_reader_unref0 (backing_file_reader);
			_g_object_unref0 (preview_frame);
			_video_interpretable_results_unref0 (results);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp20_ = results;
	_tmp20_->update_interpretable = TRUE;
	_tmp21_ = results;
	_tmp21_->is_interpretable = TRUE;
	_tmp22_ = results;
	_tmp23_ = preview_frame;
	_tmp24_ = _g_object_ref0 (_tmp23_);
	_g_object_unref0 (_tmp22_->new_thumbnail);
	_tmp22_->new_thumbnail = _tmp24_;
	result = results;
	_video_reader_unref0 (backing_file_reader);
	_g_object_unref0 (preview_frame);
	return result;
}

static void
video_real_destroy (DataSource* base)
{
	Video * self;
	VideoID video_id = {0};
	VideoID _tmp0_ = {0};
	GError* _inner_error0_ = NULL;
	self = (Video*) base;
	video_get_video_id (self, &_tmp0_);
	video_id = _tmp0_;
	thumbnail_cache_remove ((ThumbnailSource*) self);
	{
		VideoTable* _tmp1_;
		VideoTable* _tmp2_;
		VideoID _tmp3_;
		_tmp1_ = video_table_get_instance ();
		_tmp2_ = _tmp1_;
		_tmp3_ = video_id;
		video_table_remove (_tmp2_, &_tmp3_, &_inner_error0_);
		_database_table_unref0 (_tmp2_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_database_error:
	{
		gchar* _tmp4_;
		gchar* _tmp5_;
		g_clear_error (&_inner_error0_);
		_tmp4_ = data_object_to_string ((DataObject*) self);
		_tmp5_ = _tmp4_;
		g_error ("VideoSupport.vala:910: failed to remove video %s from video table", _tmp5_);
		_g_free0 (_tmp5_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	DATA_SOURCE_CLASS (video_parent_class)->destroy ((DataSource*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_VIDEO_SOURCE, VideoSource));
}

static gboolean
video_real_internal_delete_backing (DataSource* base,
                                    GError** error)
{
	Video * self;
	gboolean ret = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (Video*) base;
	ret = media_source_delete_original_file ((MediaSource*) self);
	_tmp1_ = DATA_SOURCE_CLASS (video_parent_class)->internal_delete_backing ((DataSource*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_VIDEO_SOURCE, VideoSource), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp2_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp2_;
	}
	if (_tmp1_) {
		_tmp0_ = ret;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
video_notify_flags_altered (Video* self,
                            Alteration* additional_alteration)
{
	Alteration* alteration = NULL;
	Alteration* _tmp0_;
	Alteration* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = alteration_new ("metadata", "flags");
	alteration = _tmp0_;
	if (additional_alteration != NULL) {
		Alteration* _tmp1_;
		Alteration* _tmp2_;
		_tmp1_ = alteration;
		_tmp2_ = alteration_compress (_tmp1_, additional_alteration);
		_alteration_unref0 (alteration);
		alteration = _tmp2_;
	}
	_tmp3_ = alteration;
	data_object_notify_altered ((DataObject*) self, _tmp3_);
	_alteration_unref0 (alteration);
}

guint64
video_add_flags (Video* self,
                 guint64 flags_to_add,
                 Alteration* additional_alteration)
{
	guint64 new_flags = 0ULL;
	GError* _inner_error0_ = NULL;
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	{
		VideoRow* _tmp0_;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp1_;
			VideoRow* _tmp2_;
			VideoRow* _tmp14_;
			_tmp1_ = self->priv->backing_row;
			new_flags = media_source_internal_add_flags (_tmp1_->flags, flags_to_add);
			_tmp2_ = self->priv->backing_row;
			if (_tmp2_->flags == new_flags) {
				VideoRow* _tmp3_;
				_tmp3_ = self->priv->backing_row;
				result = _tmp3_->flags;
				{
					VideoRow* _tmp4_;
					_tmp4_ = self->priv->backing_row;
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
				}
				return result;
			}
			{
				VideoTable* _tmp5_;
				VideoTable* _tmp6_;
				VideoID _tmp7_ = {0};
				_tmp5_ = video_table_get_instance ();
				_tmp6_ = _tmp5_;
				video_get_video_id (self, &_tmp7_);
				video_table_set_flags (_tmp6_, &_tmp7_, new_flags, &_inner_error0_);
				_database_table_unref0 (_tmp6_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					guint64 _tmp9_ = 0ULL;
					if (_inner_error0_->domain == DATABASE_ERROR) {
						goto __catch1_database_error;
					}
					{
						VideoRow* _tmp8_;
						_tmp8_ = self->priv->backing_row;
						g_rec_mutex_unlock (&self->priv->__lock_backing_row);
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp9_;
				}
			}
			goto __finally1;
			__catch1_database_error:
			{
				GError* e = NULL;
				GError* _tmp10_;
				VideoRow* _tmp11_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp10_ = e;
				app_window_database_error (_tmp10_);
				_tmp11_ = self->priv->backing_row;
				result = _tmp11_->flags;
				_g_error_free0 (e);
				{
					VideoRow* _tmp12_;
					_tmp12_ = self->priv->backing_row;
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
				}
				return result;
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				guint64 _tmp13_ = 0ULL;
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp13_;
			}
			_tmp14_ = self->priv->backing_row;
			_tmp14_->flags = new_flags;
		}
		__finally0:
		{
			VideoRow* _tmp15_;
			_tmp15_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			guint64 _tmp16_ = 0ULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp16_;
		}
	}
	video_notify_flags_altered (self, additional_alteration);
	result = new_flags;
	return result;
}

guint64
video_remove_flags (Video* self,
                    guint64 flags_to_remove,
                    Alteration* additional_alteration)
{
	guint64 new_flags = 0ULL;
	GError* _inner_error0_ = NULL;
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	{
		VideoRow* _tmp0_;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp1_;
			VideoRow* _tmp2_;
			VideoRow* _tmp14_;
			_tmp1_ = self->priv->backing_row;
			new_flags = media_source_internal_remove_flags (_tmp1_->flags, flags_to_remove);
			_tmp2_ = self->priv->backing_row;
			if (_tmp2_->flags == new_flags) {
				VideoRow* _tmp3_;
				_tmp3_ = self->priv->backing_row;
				result = _tmp3_->flags;
				{
					VideoRow* _tmp4_;
					_tmp4_ = self->priv->backing_row;
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
				}
				return result;
			}
			{
				VideoTable* _tmp5_;
				VideoTable* _tmp6_;
				VideoID _tmp7_ = {0};
				_tmp5_ = video_table_get_instance ();
				_tmp6_ = _tmp5_;
				video_get_video_id (self, &_tmp7_);
				video_table_set_flags (_tmp6_, &_tmp7_, new_flags, &_inner_error0_);
				_database_table_unref0 (_tmp6_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					guint64 _tmp9_ = 0ULL;
					if (_inner_error0_->domain == DATABASE_ERROR) {
						goto __catch1_database_error;
					}
					{
						VideoRow* _tmp8_;
						_tmp8_ = self->priv->backing_row;
						g_rec_mutex_unlock (&self->priv->__lock_backing_row);
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp9_;
				}
			}
			goto __finally1;
			__catch1_database_error:
			{
				GError* e = NULL;
				GError* _tmp10_;
				VideoRow* _tmp11_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp10_ = e;
				app_window_database_error (_tmp10_);
				_tmp11_ = self->priv->backing_row;
				result = _tmp11_->flags;
				_g_error_free0 (e);
				{
					VideoRow* _tmp12_;
					_tmp12_ = self->priv->backing_row;
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
				}
				return result;
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				guint64 _tmp13_ = 0ULL;
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp13_;
			}
			_tmp14_ = self->priv->backing_row;
			_tmp14_->flags = new_flags;
		}
		__finally0:
		{
			VideoRow* _tmp15_;
			_tmp15_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			guint64 _tmp16_ = 0ULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp16_;
		}
	}
	video_notify_flags_altered (self, additional_alteration);
	result = new_flags;
	return result;
}

gboolean
video_is_flag_set (Video* self,
                   guint64 flag)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		VideoRow* _tmp0_;
		gboolean _tmp4_ = FALSE;
		_tmp0_ = self->priv->backing_row;
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
		{
			VideoRow* _tmp1_;
			_tmp1_ = self->priv->backing_row;
			result = media_source_internal_is_flag_set (_tmp1_->flags, flag);
			{
				VideoRow* _tmp2_;
				_tmp2_ = self->priv->backing_row;
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
			}
			return result;
		}
		__finally0:
		{
			VideoRow* _tmp3_;
			_tmp3_ = self->priv->backing_row;
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
}

static void
video_real_set_master_file (Monitorable* base,
                            GFile* file)
{
	Video * self;
	gchar* new_filepath = NULL;
	gchar* _tmp0_;
	gchar* old_filepath = NULL;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	GFile* _tmp22_;
	GFile* _tmp23_;
	Alteration* _tmp24_;
	Alteration* _tmp25_;
	GError* _inner_error0_ = NULL;
	self = (Video*) base;
	g_return_if_fail (file != NULL);
	_tmp0_ = g_file_get_path (file);
	new_filepath = _tmp0_;
	old_filepath = NULL;
	{
		{
			VideoRow* _tmp1_;
			_tmp1_ = self->priv->backing_row;
			g_rec_mutex_lock (&self->priv->__lock_backing_row);
			{
				VideoRow* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				VideoRow* _tmp6_;
				const gchar* _tmp7_;
				gchar* _tmp8_;
				VideoTable* _tmp9_;
				VideoTable* _tmp10_;
				VideoRow* _tmp11_;
				VideoID _tmp12_;
				const gchar* _tmp13_;
				VideoRow* _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp2_ = self->priv->backing_row;
				_tmp3_ = _tmp2_->filepath;
				_tmp4_ = new_filepath;
				if (g_strcmp0 (_tmp3_, _tmp4_) == 0) {
					{
						GError* _inner_error0_ = NULL;
						VideoRow* _tmp5_;
						_tmp5_ = self->priv->backing_row;
						g_rec_mutex_unlock (&self->priv->__lock_backing_row);
					}
					_g_free0 (old_filepath);
					_g_free0 (new_filepath);
					return;
				}
				_tmp6_ = self->priv->backing_row;
				_tmp7_ = _tmp6_->filepath;
				_tmp8_ = g_strdup (_tmp7_);
				_g_free0 (old_filepath);
				old_filepath = _tmp8_;
				_tmp9_ = video_table_get_instance ();
				_tmp10_ = _tmp9_;
				_tmp11_ = self->priv->backing_row;
				_tmp12_ = _tmp11_->video_id;
				_tmp13_ = new_filepath;
				video_table_set_filepath (_tmp10_, &_tmp12_, _tmp13_, &_inner_error0_);
				_database_table_unref0 (_tmp10_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				_tmp14_ = self->priv->backing_row;
				_tmp15_ = new_filepath;
				_tmp16_ = g_strdup (_tmp15_);
				_g_free0 (_tmp14_->filepath);
				_tmp14_->filepath = _tmp16_;
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* _lock_error_ = NULL;
				GError* _tmp17_;
				_lock_error_ = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp17_ = _lock_error_;
				_lock_error_ = NULL;
				_inner_error0_ = _tmp17_;
				_g_error_free0 (_lock_error_);
				goto __finally1;
			}
			__finally1:
			{
				GError* _inner_error1_ = NULL;
				VideoRow* _tmp18_;
				_tmp18_ = self->priv->backing_row;
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
			}
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == DATABASE_ERROR) {
					goto __catch0_database_error;
				}
				goto __finally0;
			}
		}
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		GError* _tmp19_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp19_ = err;
		app_window_database_error (_tmp19_);
		_g_error_free0 (err);
		_g_free0 (old_filepath);
		_g_free0 (new_filepath);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (old_filepath);
		_g_free0 (new_filepath);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp20_ = old_filepath;
	_vala_assert (_tmp20_ != NULL, "old_filepath != null");
	_tmp21_ = old_filepath;
	_tmp22_ = g_file_new_for_path (_tmp21_);
	_tmp23_ = _tmp22_;
	media_source_notify_master_replaced ((MediaSource*) self, _tmp23_, file);
	_g_object_unref0 (_tmp23_);
	_tmp24_ = alteration_new_from_list ("backing:master,metadata:name");
	_tmp25_ = _tmp24_;
	data_object_notify_altered ((DataObject*) self, _tmp25_);
	_alteration_unref0 (_tmp25_);
	_g_free0 (old_filepath);
	_g_free0 (new_filepath);
}

VideoMetadata*
video_read_metadata (Video* self,
                     GError** error)
{
	VideoMetadata* _tmp0_ = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	VideoReader* _tmp3_;
	VideoReader* _tmp4_;
	VideoMetadata* _tmp5_;
	VideoMetadata* _tmp6_;
	VideoMetadata* _tmp7_;
	GError* _inner_error0_ = NULL;
	VideoMetadata* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = media_source_get_file ((MediaSource*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = video_reader_new (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = video_reader_read_metadata (_tmp4_, &_inner_error0_);
	_tmp6_ = _tmp5_;
	_video_reader_unref0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	_tmp0_ = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp7_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp7_;
	_media_metadata_unref0 (_tmp0_);
	return result;
}

VideoInterpretableResults*
video_interpretable_results_construct (GType object_type,
                                       Video* video)
{
	VideoInterpretableResults* self = NULL;
	Video* _tmp0_;
	g_return_val_if_fail (video != NULL, NULL);
	self = (VideoInterpretableResults*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (video);
	_g_object_unref0 (self->video);
	self->video = _tmp0_;
	return self;
}

VideoInterpretableResults*
video_interpretable_results_new (Video* video)
{
	return video_interpretable_results_construct (VIDEO_TYPE_INTERPRETABLE_RESULTS, video);
}

void
video_interpretable_results_foreground_finish (VideoInterpretableResults* self)
{
	GdkPixbuf* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->update_interpretable) {
		Video* _tmp0_;
		_tmp0_ = self->video;
		video_set_is_interpretable (_tmp0_, self->is_interpretable);
	}
	_tmp1_ = self->new_thumbnail;
	if (_tmp1_ != NULL) {
		{
			Video* _tmp2_;
			GdkPixbuf* _tmp3_;
			Video* _tmp4_;
			GdkPixbuf* _tmp5_;
			Video* _tmp6_;
			_tmp2_ = self->video;
			_tmp3_ = self->new_thumbnail;
			thumbnail_cache_replace ((ThumbnailSource*) _tmp2_, THUMBNAIL_CACHE_SIZE_BIG, _tmp3_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp4_ = self->video;
			_tmp5_ = self->new_thumbnail;
			thumbnail_cache_replace ((ThumbnailSource*) _tmp4_, THUMBNAIL_CACHE_SIZE_MEDIUM, _tmp5_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp6_ = self->video;
			thumbnail_source_notify_thumbnail_altered ((ThumbnailSource*) _tmp6_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			Video* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			GError* _tmp10_;
			const gchar* _tmp11_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp7_ = self->video;
			_tmp8_ = data_object_to_string ((DataObject*) _tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = err;
			_tmp11_ = _tmp10_->message;
			g_message ("VideoSupport.vala:358: Unable to update video thumbnails for %s: %s", _tmp9_, _tmp11_);
			_g_free0 (_tmp9_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
video_value_interpretable_results_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
video_value_interpretable_results_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		video_interpretable_results_unref (value->data[0].v_pointer);
	}
}

static void
video_value_interpretable_results_copy_value (const GValue* src_value,
                                              GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = video_interpretable_results_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
video_value_interpretable_results_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
video_value_interpretable_results_collect_value (GValue* value,
                                                 guint n_collect_values,
                                                 GTypeCValue* collect_values,
                                                 guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		VideoInterpretableResults * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = video_interpretable_results_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
video_value_interpretable_results_lcopy_value (const GValue* value,
                                               guint n_collect_values,
                                               GTypeCValue* collect_values,
                                               guint collect_flags)
{
	VideoInterpretableResults ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = video_interpretable_results_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
video_param_spec_interpretable_results (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags)
{
	VideoParamSpecInterpretableResults* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VIDEO_TYPE_INTERPRETABLE_RESULTS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
video_value_get_interpretable_results (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VIDEO_TYPE_INTERPRETABLE_RESULTS), NULL);
	return value->data[0].v_pointer;
}

void
video_value_set_interpretable_results (GValue* value,
                                       gpointer v_object)
{
	VideoInterpretableResults * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VIDEO_TYPE_INTERPRETABLE_RESULTS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VIDEO_TYPE_INTERPRETABLE_RESULTS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		video_interpretable_results_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		video_interpretable_results_unref (old);
	}
}

void
video_value_take_interpretable_results (GValue* value,
                                        gpointer v_object)
{
	VideoInterpretableResults * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VIDEO_TYPE_INTERPRETABLE_RESULTS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VIDEO_TYPE_INTERPRETABLE_RESULTS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		video_interpretable_results_unref (old);
	}
}

static void
video_interpretable_results_class_init (VideoInterpretableResultsClass * klass,
                                        gpointer klass_data)
{
	video_interpretable_results_parent_class = g_type_class_peek_parent (klass);
	((VideoInterpretableResultsClass *) klass)->finalize = video_interpretable_results_finalize;
}

static void
video_interpretable_results_instance_init (VideoInterpretableResults * self,
                                           gpointer klass)
{
	self->update_interpretable = FALSE;
	self->is_interpretable = FALSE;
	self->new_thumbnail = NULL;
	self->ref_count = 1;
}

static void
video_interpretable_results_finalize (VideoInterpretableResults * obj)
{
	VideoInterpretableResults * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VIDEO_TYPE_INTERPRETABLE_RESULTS, VideoInterpretableResults);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->video);
	_g_object_unref0 (self->new_thumbnail);
}

static GType
video_interpretable_results_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { video_value_interpretable_results_init, video_value_interpretable_results_free_value, video_value_interpretable_results_copy_value, video_value_interpretable_results_peek_pointer, "p", video_value_interpretable_results_collect_value, "p", video_value_interpretable_results_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (VideoInterpretableResultsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_interpretable_results_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoInterpretableResults), 0, (GInstanceInitFunc) video_interpretable_results_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType video_interpretable_results_type_id;
	video_interpretable_results_type_id = g_type_register_fundamental (g_type_fundamental_next (), "VideoInterpretableResults", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return video_interpretable_results_type_id;
}

GType
video_interpretable_results_get_type (void)
{
	static volatile gsize video_interpretable_results_type_id__once = 0;
	if (g_once_init_enter (&video_interpretable_results_type_id__once)) {
		GType video_interpretable_results_type_id;
		video_interpretable_results_type_id = video_interpretable_results_get_type_once ();
		g_once_init_leave (&video_interpretable_results_type_id__once, video_interpretable_results_type_id);
	}
	return video_interpretable_results_type_id__once;
}

gpointer
video_interpretable_results_ref (gpointer instance)
{
	VideoInterpretableResults * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
video_interpretable_results_unref (gpointer instance)
{
	VideoInterpretableResults * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VIDEO_INTERPRETABLE_RESULTS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
video_class_init (VideoClass * klass,
                  gpointer klass_data)
{
	video_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Video_private_offset);
	((DataSourceClass *) klass)->commit_backlinks = (void (*) (DataSource*, SourceCollection*, const gchar*)) video_real_commit_backlinks;
	((MediaSourceClass *) klass)->set_event_id = (gboolean (*) (MediaSource*, EventID*)) video_real_set_event_id;
	((MediaSourceClass *) klass)->get_backing_files_state = (BackingFileState** (*) (MediaSource*, gint*)) video_real_get_backing_files_state;
	((ThumbnailSourceClass *) klass)->get_thumbnail = (GdkPixbuf* (*) (ThumbnailSource*, gint, GError**)) video_real_get_thumbnail;
	((MediaSourceClass *) klass)->get_master_md5 = (gchar* (*) (MediaSource*)) video_real_get_master_md5;
	((MediaSourceClass *) klass)->get_preview_pixbuf = (GdkPixbuf* (*) (MediaSource*, Scaling*, GError**)) video_real_get_preview_pixbuf;
	((ThumbnailSourceClass *) klass)->create_thumbnail = (GdkPixbuf* (*) (ThumbnailSource*, gint, GError**)) video_real_create_thumbnail;
	((DataSourceClass *) klass)->get_typename = (gchar* (*) (DataSource*)) video_real_get_typename;
	((DataSourceClass *) klass)->get_instance_id = (gint64 (*) (DataSource*)) video_real_get_instance_id;
	((MediaSourceClass *) klass)->get_import_id = (void (*) (MediaSource*, ImportID*)) video_real_get_import_id;
	((ThumbnailSourceClass *) klass)->get_preferred_thumbnail_format = (PhotoFileFormat (*) (ThumbnailSource*)) video_real_get_preferred_thumbnail_format;
	((MediaSourceClass *) klass)->get_title = (gchar* (*) (MediaSource*)) video_real_get_title;
	((MediaSourceClass *) klass)->set_title = (void (*) (MediaSource*, const gchar*)) video_real_set_title;
	((MediaSourceClass *) klass)->get_comment = (gchar* (*) (MediaSource*)) video_real_get_comment;
	((MediaSourceClass *) klass)->set_comment = (gboolean (*) (MediaSource*, const gchar*)) video_real_set_comment;
	((MediaSourceClass *) klass)->is_trashed = (gboolean (*) (MediaSource*)) video_real_is_trashed;
	((MediaSourceClass *) klass)->is_offline = (gboolean (*) (MediaSource*)) video_real_is_offline;
	((MediaSourceClass *) klass)->mark_offline = (void (*) (MediaSource*)) video_real_mark_offline;
	((MediaSourceClass *) klass)->mark_online = (void (*) (MediaSource*)) video_real_mark_online;
	((MediaSourceClass *) klass)->trash = (void (*) (MediaSource*)) video_real_trash;
	((MediaSourceClass *) klass)->untrash = (void (*) (MediaSource*)) video_real_untrash;
	((MediaSourceClass *) klass)->get_event_id = (void (*) (MediaSource*, EventID*)) video_real_get_event_id;
	((DataObjectClass *) klass)->to_string = (gchar* (*) (DataObject*)) video_real_to_string;
	((MediaSourceClass *) klass)->get_exposure_time = (gint64 (*) (MediaSource*)) video_real_get_exposure_time;
	((MediaSourceClass *) klass)->get_dimensions = (void (*) (MediaSource*, PhotoException, Dimensions*)) video_real_get_dimensions;
	((MediaSourceClass *) klass)->get_filesize = (guint64 (*) (MediaSource*)) video_real_get_filesize;
	((MediaSourceClass *) klass)->get_master_filesize = (guint64 (*) (MediaSource*)) video_real_get_master_filesize;
	((MediaSourceClass *) klass)->get_timestamp = (gint64 (*) (MediaSource*)) video_real_get_timestamp;
	((MediaSourceClass *) klass)->get_file = (GFile* (*) (MediaSource*)) video_real_get_file;
	((MediaSourceClass *) klass)->get_master_file = (GFile* (*) (MediaSource*)) video_real_get_master_file;
	((DataSourceClass *) klass)->destroy = (void (*) (DataSource*)) video_real_destroy;
	((DataSourceClass *) klass)->internal_delete_backing = (gboolean (*) (DataSource*, GError**)) video_real_internal_delete_backing;
	G_OBJECT_CLASS (klass)->finalize = video_finalize;
}

static void
video_flaggable_interface_init (FlaggableIface * iface,
                                gpointer iface_data)
{
	video_flaggable_parent_iface = g_type_interface_peek_parent (iface);
	iface->is_flagged = (gboolean (*) (Flaggable*)) video_real_is_flagged;
	iface->mark_flagged = (void (*) (Flaggable*)) video_real_mark_flagged;
	iface->mark_unflagged = (void (*) (Flaggable*)) video_real_mark_unflagged;
}

static void
video_monitorable_interface_init (MonitorableIface * iface,
                                  gpointer iface_data)
{
	video_monitorable_parent_iface = g_type_interface_peek_parent (iface);
	iface->is_offline = (gboolean (*) (Monitorable*)) video_real_is_offline;
	iface->mark_offline = (void (*) (Monitorable*)) video_real_mark_offline;
	iface->mark_online = (void (*) (Monitorable*)) video_real_mark_online;
	iface->set_master_timestamp = (void (*) (Monitorable*, GFileInfo*)) video_real_set_master_timestamp;
	iface->set_master_file = (void (*) (Monitorable*, GFile*)) video_real_set_master_file;
}

static void
video_dateable_interface_init (DateableIface * iface,
                               gpointer iface_data)
{
	video_dateable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_exposure_time = (gint64 (*) (Dateable*)) video_real_get_exposure_time;
	iface->set_exposure_time = (void (*) (Dateable*, gint64)) video_real_set_exposure_time;
}

static void
video_instance_init (Video * self,
                     gpointer klass)
{
	self->priv = video_get_instance_private (self);
	g_rec_mutex_init (&self->priv->__lock_backing_row);
}

static void
video_finalize (GObject * obj)
{
	Video * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIDEO, Video);
	g_rec_mutex_clear (&self->priv->__lock_backing_row);
	_video_row_unref0 (self->priv->backing_row);
	G_OBJECT_CLASS (video_parent_class)->finalize (obj);
}

static GType
video_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (VideoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Video), 0, (GInstanceInitFunc) video_instance_init, NULL };
	static const GInterfaceInfo flaggable_info = { (GInterfaceInitFunc) video_flaggable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo monitorable_info = { (GInterfaceInitFunc) video_monitorable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo dateable_info = { (GInterfaceInitFunc) video_dateable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType video_type_id;
	video_type_id = g_type_register_static (TYPE_VIDEO_SOURCE, "Video", &g_define_type_info, 0);
	g_type_add_interface_static (video_type_id, TYPE_FLAGGABLE, &flaggable_info);
	g_type_add_interface_static (video_type_id, TYPE_MONITORABLE, &monitorable_info);
	g_type_add_interface_static (video_type_id, TYPE_DATEABLE, &dateable_info);
	Video_private_offset = g_type_add_instance_private (video_type_id, sizeof (VideoPrivate));
	return video_type_id;
}

GType
video_get_type (void)
{
	static volatile gsize video_type_id__once = 0;
	if (g_once_init_enter (&video_type_id__once)) {
		GType video_type_id;
		video_type_id = video_get_type_once ();
		g_once_init_leave (&video_type_id__once, video_type_id);
	}
	return video_type_id__once;
}

static inline gpointer
video_source_collection_get_instance_private (VideoSourceCollection* self)
{
	return G_STRUCT_MEMBER_P (self, VideoSourceCollection_private_offset);
}

static GType
video_source_collection_state_get_type_once (void)
{
	static const GEnumValue values[] = {{VIDEO_SOURCE_COLLECTION_STATE_UNKNOWN, "VIDEO_SOURCE_COLLECTION_STATE_UNKNOWN", "unknown"}, {VIDEO_SOURCE_COLLECTION_STATE_ONLINE, "VIDEO_SOURCE_COLLECTION_STATE_ONLINE", "online"}, {VIDEO_SOURCE_COLLECTION_STATE_OFFLINE, "VIDEO_SOURCE_COLLECTION_STATE_OFFLINE", "offline"}, {VIDEO_SOURCE_COLLECTION_STATE_TRASH, "VIDEO_SOURCE_COLLECTION_STATE_TRASH", "trash"}, {0, NULL, NULL}};
	GType video_source_collection_state_type_id;
	video_source_collection_state_type_id = g_enum_register_static ("VideoSourceCollectionState", values);
	return video_source_collection_state_type_id;
}

GType
video_source_collection_state_get_type (void)
{
	static volatile gsize video_source_collection_state_type_id__once = 0;
	if (g_once_init_enter (&video_source_collection_state_type_id__once)) {
		GType video_source_collection_state_type_id;
		video_source_collection_state_type_id = video_source_collection_state_get_type_once ();
		g_once_init_leave (&video_source_collection_state_type_id__once, video_source_collection_state_type_id);
	}
	return video_source_collection_state_type_id__once;
}

static gint
_uint64_compare_gcompare_data_func (gconstpointer a,
                                    gconstpointer b,
                                    gpointer self)
{
	gint result;
	result = uint64_compare ((guint64*) a, (guint64*) b);
	return result;
}

static guint64*
_uint64_dup (guint64* self)
{
	guint64* dup;
	dup = g_new0 (guint64, 1);
	memcpy (dup, self, sizeof (guint64));
	return dup;
}

static gint64
_video_source_collection_get_video_key_get_source_database_key (DataSource* source,
                                                                gpointer self)
{
	gint64 result;
	result = video_source_collection_get_video_key (source);
	return result;
}

static void
_video_source_collection_on_trashcan_contents_altered_source_holding_tank_contents_altered (SourceHoldingTank* _sender,
                                                                                            GeeCollection* added,
                                                                                            GeeCollection* removed,
                                                                                            gpointer self)
{
	video_source_collection_on_trashcan_contents_altered ((VideoSourceCollection*) self, added, removed);
}

static void
_video_source_collection_on_offline_contents_altered_source_holding_tank_contents_altered (SourceHoldingTank* _sender,
                                                                                           GeeCollection* added,
                                                                                           GeeCollection* removed,
                                                                                           gpointer self)
{
	video_source_collection_on_offline_contents_altered ((VideoSourceCollection*) self, added, removed);
}

VideoSourceCollection*
video_source_collection_construct (GType object_type)
{
	VideoSourceCollection* self = NULL;
	MediaSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* _tmp1_;
	MediaSourceHoldingTank* _tmp2_;
	MediaSourceHoldingTank* _tmp3_;
	self = (VideoSourceCollection*) media_source_collection_construct (object_type, "VideoSourceCollection", _video_source_collection_get_video_key_get_source_database_key, NULL);
	_tmp0_ = media_source_collection_get_trashcan ((MediaSourceCollection*) self);
	_tmp1_ = _tmp0_;
	g_signal_connect ((SourceHoldingTank*) _tmp1_, "contents-altered", (GCallback) _video_source_collection_on_trashcan_contents_altered_source_holding_tank_contents_altered, self);
	_source_holding_tank_unref0 (_tmp1_);
	_tmp2_ = media_source_collection_get_offline_bin ((MediaSourceCollection*) self);
	_tmp3_ = _tmp2_;
	g_signal_connect ((SourceHoldingTank*) _tmp3_, "contents-altered", (GCallback) _video_source_collection_on_offline_contents_altered_source_holding_tank_contents_altered, self);
	_source_holding_tank_unref0 (_tmp3_);
	return self;
}

VideoSourceCollection*
video_source_collection_new (void)
{
	return video_source_collection_construct (TYPE_VIDEO_SOURCE_COLLECTION);
}

static gboolean
_video_source_collection_is_video_trashed_source_holding_tank_check_to_keep (DataSource* source,
                                                                             Alteration* alteration,
                                                                             gpointer self)
{
	gboolean result;
	result = video_source_collection_is_video_trashed (source);
	return result;
}

static MediaSourceHoldingTank*
video_source_collection_real_create_trashcan (MediaSourceCollection* base)
{
	VideoSourceCollection * self;
	MediaSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* result;
	self = (VideoSourceCollection*) base;
	_tmp0_ = media_source_holding_tank_new ((MediaSourceCollection*) self, _video_source_collection_is_video_trashed_source_holding_tank_check_to_keep, NULL, _video_source_collection_get_video_key_get_source_database_key, NULL);
	result = _tmp0_;
	return result;
}

static gboolean
_video_source_collection_is_video_offline_source_holding_tank_check_to_keep (DataSource* source,
                                                                             Alteration* alteration,
                                                                             gpointer self)
{
	gboolean result;
	result = video_source_collection_is_video_offline (source);
	return result;
}

static MediaSourceHoldingTank*
video_source_collection_real_create_offline_bin (MediaSourceCollection* base)
{
	VideoSourceCollection * self;
	MediaSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* result;
	self = (VideoSourceCollection*) base;
	_tmp0_ = media_source_holding_tank_new ((MediaSourceCollection*) self, _video_source_collection_is_video_offline_source_holding_tank_check_to_keep, NULL, _video_source_collection_get_video_key_get_source_database_key, NULL);
	result = _tmp0_;
	return result;
}

static MediaMonitor*
video_source_collection_real_create_media_monitor (MediaSourceCollection* base,
                                                   Workers* workers,
                                                   GCancellable* cancellable)
{
	VideoSourceCollection * self;
	VideoMonitor* _tmp0_;
	MediaMonitor* result;
	self = (VideoSourceCollection*) base;
	g_return_val_if_fail (workers != NULL, NULL);
	g_return_val_if_fail (cancellable != NULL, NULL);
	_tmp0_ = video_monitor_new (cancellable);
	result = (MediaMonitor*) _tmp0_;
	return result;
}

static gboolean
video_source_collection_real_holds_type_of_source (SourceCollection* base,
                                                   DataSource* source)
{
	VideoSourceCollection * self;
	gboolean result;
	self = (VideoSourceCollection*) base;
	g_return_val_if_fail (source != NULL, FALSE);
	result = IS_VIDEO (source);
	return result;
}

static gchar*
video_source_collection_real_get_typename (MediaSourceCollection* base)
{
	VideoSourceCollection * self;
	gchar* _tmp0_;
	gchar* result;
	self = (VideoSourceCollection*) base;
	_tmp0_ = g_strdup (VIDEO_TYPENAME);
	result = _tmp0_;
	return result;
}

static gboolean
video_source_collection_real_is_file_recognized (MediaSourceCollection* base,
                                                 GFile* file)
{
	VideoSourceCollection * self;
	gboolean result;
	self = (VideoSourceCollection*) base;
	g_return_val_if_fail (file != NULL, FALSE);
	result = video_reader_is_supported_video_file (file);
	return result;
}

static void
video_source_collection_on_trashcan_contents_altered (VideoSourceCollection* self,
                                                      GeeCollection* added,
                                                      GeeCollection* removed)
{
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name ((MediaSourceCollection*) self, "trashcan-contents-altered", G_TYPE_CHECK_INSTANCE_CAST (added, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (removed, GEE_TYPE_COLLECTION, GeeCollection));
}

static void
video_source_collection_on_offline_contents_altered (VideoSourceCollection* self,
                                                     GeeCollection* added,
                                                     GeeCollection* removed)
{
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name ((MediaSourceCollection*) self, "offline-contents-altered", G_TYPE_CHECK_INSTANCE_CAST (added, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (removed, GEE_TYPE_COLLECTION, GeeCollection));
}

static MediaSource*
video_source_collection_real_fetch_by_numeric_id (MediaSourceCollection* base,
                                                  gint64 numeric_id)
{
	VideoSourceCollection * self;
	VideoID _tmp0_ = {0};
	Video* _tmp1_;
	MediaSource* result;
	self = (VideoSourceCollection*) base;
	video_id_init (&_tmp0_, numeric_id);
	_tmp1_ = video_source_collection_fetch (self, &_tmp0_);
	result = (MediaSource*) _tmp1_;
	return result;
}

gint64
video_source_collection_get_video_key (DataSource* source)
{
	Video* video = NULL;
	Video* _tmp0_;
	VideoID video_id = {0};
	VideoID _tmp1_ = {0};
	VideoID _tmp2_;
	gint64 result;
	g_return_val_if_fail (source != NULL, 0LL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_VIDEO, Video));
	video = _tmp0_;
	video_get_video_id (video, &_tmp1_);
	video_id = _tmp1_;
	_tmp2_ = video_id;
	result = _tmp2_.id;
	_g_object_unref0 (video);
	return result;
}

gboolean
video_source_collection_is_video_trashed (DataSource* source)
{
	gboolean result;
	g_return_val_if_fail (source != NULL, FALSE);
	result = media_source_is_trashed ((MediaSource*) G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_VIDEO, Video));
	return result;
}

gboolean
video_source_collection_is_video_offline (DataSource* source)
{
	gboolean result;
	g_return_val_if_fail (source != NULL, FALSE);
	result = media_source_is_offline ((MediaSource*) G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_VIDEO, Video));
	return result;
}

Video*
video_source_collection_fetch (VideoSourceCollection* self,
                               VideoID* video_id)
{
	VideoID _tmp0_;
	DataSource* _tmp1_;
	Video* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (video_id != NULL, NULL);
	_tmp0_ = *video_id;
	_tmp1_ = database_source_collection_fetch_by_key ((DatabaseSourceCollection*) self, _tmp0_.id);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_VIDEO, Video);
	return result;
}

static GeeCollection*
video_source_collection_real_get_event_source_ids (MediaSourceCollection* base,
                                                   EventID* event_id)
{
	VideoSourceCollection * self;
	VideoTable* _tmp0_;
	VideoTable* _tmp1_;
	EventID _tmp2_;
	GeeArrayList* _tmp3_;
	GeeCollection* _tmp4_;
	GeeCollection* result;
	self = (VideoSourceCollection*) base;
	g_return_val_if_fail (event_id != NULL, NULL);
	_tmp0_ = video_table_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = *event_id;
	_tmp3_ = video_table_get_event_source_ids (_tmp1_, &_tmp2_);
	_tmp4_ = (GeeCollection*) _tmp3_;
	_database_table_unref0 (_tmp1_);
	result = _tmp4_;
	return result;
}

Video*
video_source_collection_get_state_by_file (VideoSourceCollection* self,
                                           GFile* file,
                                           VideoSourceCollectionState* state)
{
	VideoSourceCollectionState _vala_state = 0;
	Video* video = NULL;
	MediaSource* _tmp0_;
	Video* _tmp1_;
	MediaSourceHoldingTank* _tmp2_;
	MediaSourceHoldingTank* _tmp3_;
	MediaSource* _tmp4_;
	Video* _tmp5_;
	MediaSourceHoldingTank* _tmp6_;
	MediaSourceHoldingTank* _tmp7_;
	MediaSource* _tmp8_;
	Video* _tmp9_;
	Video* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = media_source_collection_fetch_by_master_file ((MediaSourceCollection*) self, file);
	video = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_VIDEO, Video);
	_tmp1_ = video;
	if (_tmp1_ != NULL) {
		_vala_state = VIDEO_SOURCE_COLLECTION_STATE_ONLINE;
		result = video;
		if (state) {
			*state = _vala_state;
		}
		return result;
	}
	_tmp2_ = media_source_collection_get_trashcan ((MediaSourceCollection*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = media_source_holding_tank_fetch_by_master_file (_tmp3_, file);
	_g_object_unref0 (video);
	video = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_VIDEO, Video);
	_source_holding_tank_unref0 (_tmp3_);
	_tmp5_ = video;
	if (_tmp5_ != NULL) {
		_vala_state = VIDEO_SOURCE_COLLECTION_STATE_TRASH;
		result = video;
		if (state) {
			*state = _vala_state;
		}
		return result;
	}
	_tmp6_ = media_source_collection_get_offline_bin ((MediaSourceCollection*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = media_source_holding_tank_fetch_by_master_file (_tmp7_, file);
	_g_object_unref0 (video);
	video = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_VIDEO, Video);
	_source_holding_tank_unref0 (_tmp7_);
	_tmp9_ = video;
	if (_tmp9_ != NULL) {
		_vala_state = VIDEO_SOURCE_COLLECTION_STATE_OFFLINE;
		result = video;
		if (state) {
			*state = _vala_state;
		}
		return result;
	}
	_vala_state = VIDEO_SOURCE_COLLECTION_STATE_UNKNOWN;
	result = NULL;
	_g_object_unref0 (video);
	if (state) {
		*state = _vala_state;
	}
	return result;
}

static void
video_source_collection_compare_backing (VideoSourceCollection* self,
                                         Video* video,
                                         GFileInfo* info,
                                         GeeCollection* matching_master)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (video != NULL);
	g_return_if_fail (info != NULL);
	g_return_if_fail (matching_master != NULL);
	if (media_source_get_filesize ((MediaSource*) video) != ((guint64) g_file_info_get_size (info))) {
		return;
	}
	_tmp0_ = g_file_info_get_modification_date_time (info);
	_tmp1_ = _tmp0_;
	_tmp2_ = media_source_get_timestamp ((MediaSource*) video) == g_date_time_to_unix (_tmp1_);
	_g_date_time_unref0 (_tmp1_);
	if (_tmp2_) {
		gee_collection_add (matching_master, video);
	}
}

void
video_source_collection_fetch_by_matching_backing (VideoSourceCollection* self,
                                                   GFileInfo* info,
                                                   GeeCollection* matching_master)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	g_return_if_fail (matching_master != NULL);
	{
		GeeIterator* _object_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = data_collection_get_all ((DataCollection*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_object_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			DataObject* object = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			DataObject* _tmp7_;
			_tmp4_ = _object_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _object_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			object = (DataObject*) _tmp6_;
			_tmp7_ = object;
			video_source_collection_compare_backing (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_VIDEO, Video), info, matching_master);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	{
		GeeIterator* _media_it = NULL;
		GeeCollection* _tmp8_;
		GeeCollection* _tmp9_;
		GeeIterator* _tmp10_;
		GeeIterator* _tmp11_;
		_tmp8_ = media_source_collection_get_offline_bin_contents ((MediaSourceCollection*) self);
		_tmp9_ = _tmp8_;
		_tmp10_ = gee_iterable_iterator ((GeeIterable*) _tmp9_);
		_tmp11_ = _tmp10_;
		_g_object_unref0 (_tmp9_);
		_media_it = _tmp11_;
		while (TRUE) {
			GeeIterator* _tmp12_;
			MediaSource* media = NULL;
			GeeIterator* _tmp13_;
			gpointer _tmp14_;
			MediaSource* _tmp15_;
			_tmp12_ = _media_it;
			if (!gee_iterator_next (_tmp12_)) {
				break;
			}
			_tmp13_ = _media_it;
			_tmp14_ = gee_iterator_get (_tmp13_);
			media = (MediaSource*) _tmp14_;
			_tmp15_ = media;
			video_source_collection_compare_backing (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_VIDEO, Video), info, matching_master);
			_g_object_unref0 (media);
		}
		_g_object_unref0 (_media_it);
	}
}

static void
video_source_collection_real_notify_contents_altered (DataCollection* base,
                                                      GeeIterable* added,
                                                      GeeIterable* removed)
{
	VideoSourceCollection * self;
	self = (VideoSourceCollection*) base;
	if (added != NULL) {
		{
			GeeIterator* _object_it = NULL;
			GeeIterator* _tmp0_;
			_tmp0_ = gee_iterable_iterator (added);
			_object_it = _tmp0_;
			while (TRUE) {
				GeeIterator* _tmp1_;
				DataObject* object = NULL;
				GeeIterator* _tmp2_;
				gpointer _tmp3_;
				Video* video = NULL;
				DataObject* _tmp4_;
				Video* _tmp5_;
				GeeMultiMap* _tmp6_;
				Video* _tmp7_;
				guint64 _tmp8_;
				Video* _tmp9_;
				_tmp1_ = _object_it;
				if (!gee_iterator_next (_tmp1_)) {
					break;
				}
				_tmp2_ = _object_it;
				_tmp3_ = gee_iterator_get (_tmp2_);
				object = (DataObject*) _tmp3_;
				_tmp4_ = object;
				_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_VIDEO, Video));
				video = _tmp5_;
				_tmp6_ = self->priv->filesize_to_video;
				_tmp7_ = video;
				_tmp8_ = media_source_get_master_filesize ((MediaSource*) _tmp7_);
				_tmp9_ = video;
				gee_multi_map_set (_tmp6_, &_tmp8_, _tmp9_);
				_g_object_unref0 (video);
				_g_object_unref0 (object);
			}
			_g_object_unref0 (_object_it);
		}
	}
	if (removed != NULL) {
		{
			GeeIterator* _object_it = NULL;
			GeeIterator* _tmp10_;
			_tmp10_ = gee_iterable_iterator (removed);
			_object_it = _tmp10_;
			while (TRUE) {
				GeeIterator* _tmp11_;
				DataObject* object = NULL;
				GeeIterator* _tmp12_;
				gpointer _tmp13_;
				Video* video = NULL;
				DataObject* _tmp14_;
				Video* _tmp15_;
				GeeMultiMap* _tmp16_;
				Video* _tmp17_;
				guint64 _tmp18_;
				Video* _tmp19_;
				_tmp11_ = _object_it;
				if (!gee_iterator_next (_tmp11_)) {
					break;
				}
				_tmp12_ = _object_it;
				_tmp13_ = gee_iterator_get (_tmp12_);
				object = (DataObject*) _tmp13_;
				_tmp14_ = object;
				_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_VIDEO, Video));
				video = _tmp15_;
				_tmp16_ = self->priv->filesize_to_video;
				_tmp17_ = video;
				_tmp18_ = media_source_get_master_filesize ((MediaSource*) _tmp17_);
				_tmp19_ = video;
				gee_multi_map_remove (_tmp16_, &_tmp18_, _tmp19_);
				_g_object_unref0 (video);
				_g_object_unref0 (object);
			}
			_g_object_unref0 (_object_it);
		}
	}
	DATA_COLLECTION_CLASS (video_source_collection_parent_class)->notify_contents_altered ((DataCollection*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), added, removed);
}

void
video_source_collection_get_basename_filesize_duplicate (VideoSourceCollection* self,
                                                         const gchar* basename,
                                                         guint64 filesize,
                                                         VideoID* result)
{
	VideoID _tmp16_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (basename != NULL);
	{
		GeeIterator* _video_it = NULL;
		GeeMultiMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = self->priv->filesize_to_video;
		_tmp1_ = gee_multi_map_get (_tmp0_, &filesize);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_video_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			Video* video = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			Video* _tmp8_;
			GFile* _tmp9_;
			GFile* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gboolean _tmp13_;
			_tmp5_ = _video_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _video_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			video = (Video*) _tmp7_;
			_tmp8_ = video;
			_tmp9_ = media_source_get_master_file ((MediaSource*) _tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_file_get_basename (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = utf8_ci_compare (_tmp12_, basename) == 0;
			_g_free0 (_tmp12_);
			_g_object_unref0 (_tmp10_);
			if (_tmp13_) {
				Video* _tmp14_;
				VideoID _tmp15_ = {0};
				_tmp14_ = video;
				video_get_video_id (_tmp14_, &_tmp15_);
				*result = _tmp15_;
				_g_object_unref0 (video);
				_g_object_unref0 (_video_it);
				return;
			}
			_g_object_unref0 (video);
		}
		_g_object_unref0 (_video_it);
	}
	video_id_init (&_tmp16_, VIDEO_ID_INVALID);
	*result = _tmp16_;
	return;
}

gboolean
video_source_collection_has_basename_filesize_duplicate (VideoSourceCollection* self,
                                                         const gchar* basename,
                                                         guint64 filesize)
{
	VideoID _tmp0_ = {0};
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (basename != NULL, FALSE);
	video_source_collection_get_basename_filesize_duplicate (self, basename, filesize, &_tmp0_);
	result = video_id_is_valid (&_tmp0_);
	return result;
}

static TransactionController*
video_source_collection_real_get_transaction_controller (MediaSourceCollection* base)
{
	TransactionController* result;
	VideoSourceCollection* self;
	TransactionController* _tmp0_;
	TransactionController* _tmp2_;
	self = (VideoSourceCollection*) base;
	_tmp0_ = self->priv->_transaction_controller;
	if (_tmp0_ == NULL) {
		MediaSourceTransactionController* _tmp1_;
		_tmp1_ = media_source_transaction_controller_new ((MediaSourceCollection*) self);
		_transaction_controller_unref0 (self->priv->_transaction_controller);
		self->priv->_transaction_controller = (TransactionController*) _tmp1_;
	}
	_tmp2_ = self->priv->_transaction_controller;
	result = _tmp2_;
	return result;
}

static void
video_source_collection_class_init (VideoSourceCollectionClass * klass,
                                    gpointer klass_data)
{
	video_source_collection_parent_class = g_type_class_peek_parent (klass);
	((DataCollectionClass *) klass)->finalize = video_source_collection_finalize;
	g_type_class_adjust_private_offset (klass, &VideoSourceCollection_private_offset);
	((MediaSourceCollectionClass *) klass)->create_trashcan = (MediaSourceHoldingTank* (*) (MediaSourceCollection*)) video_source_collection_real_create_trashcan;
	((MediaSourceCollectionClass *) klass)->create_offline_bin = (MediaSourceHoldingTank* (*) (MediaSourceCollection*)) video_source_collection_real_create_offline_bin;
	((MediaSourceCollectionClass *) klass)->create_media_monitor = (MediaMonitor* (*) (MediaSourceCollection*, Workers*, GCancellable*)) video_source_collection_real_create_media_monitor;
	((SourceCollectionClass *) klass)->holds_type_of_source = (gboolean (*) (SourceCollection*, DataSource*)) video_source_collection_real_holds_type_of_source;
	((MediaSourceCollectionClass *) klass)->get_typename = (gchar* (*) (MediaSourceCollection*)) video_source_collection_real_get_typename;
	((MediaSourceCollectionClass *) klass)->is_file_recognized = (gboolean (*) (MediaSourceCollection*, GFile*)) video_source_collection_real_is_file_recognized;
	((MediaSourceCollectionClass *) klass)->fetch_by_numeric_id = (MediaSource* (*) (MediaSourceCollection*, gint64)) video_source_collection_real_fetch_by_numeric_id;
	((MediaSourceCollectionClass *) klass)->get_event_source_ids = (GeeCollection* (*) (MediaSourceCollection*, EventID*)) video_source_collection_real_get_event_source_ids;
	((DataCollectionClass *) klass)->notify_contents_altered = (void (*) (DataCollection*, GeeIterable*, GeeIterable*)) video_source_collection_real_notify_contents_altered;
	MEDIA_SOURCE_COLLECTION_CLASS (klass)->get_transaction_controller = (TransactionController* (*) (MediaSourceCollection*)) video_source_collection_real_get_transaction_controller;
}

static void
video_source_collection_instance_init (VideoSourceCollection * self,
                                       gpointer klass)
{
	GeeTreeMultiMap* _tmp0_;
	self->priv = video_source_collection_get_instance_private (self);
	self->priv->_transaction_controller = NULL;
	_tmp0_ = gee_tree_multi_map_new (G_TYPE_UINT64, (GBoxedCopyFunc) _uint64_dup, (GDestroyNotify) g_free, TYPE_VIDEO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _uint64_compare_gcompare_data_func, NULL, NULL, NULL, NULL, NULL);
	self->priv->filesize_to_video = (GeeMultiMap*) _tmp0_;
}

static void
video_source_collection_finalize (DataCollection * obj)
{
	VideoSourceCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
	_transaction_controller_unref0 (self->priv->_transaction_controller);
	_g_object_unref0 (self->priv->filesize_to_video);
	DATA_COLLECTION_CLASS (video_source_collection_parent_class)->finalize (obj);
}

static GType
video_source_collection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (VideoSourceCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_source_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoSourceCollection), 0, (GInstanceInitFunc) video_source_collection_instance_init, NULL };
	GType video_source_collection_type_id;
	video_source_collection_type_id = g_type_register_static (TYPE_MEDIA_SOURCE_COLLECTION, "VideoSourceCollection", &g_define_type_info, 0);
	VideoSourceCollection_private_offset = g_type_add_instance_private (video_source_collection_type_id, sizeof (VideoSourceCollectionPrivate));
	return video_source_collection_type_id;
}

GType
video_source_collection_get_type (void)
{
	static volatile gsize video_source_collection_type_id__once = 0;
	if (g_once_init_enter (&video_source_collection_type_id__once)) {
		GType video_source_collection_type_id;
		video_source_collection_type_id = video_source_collection_get_type_once ();
		g_once_init_leave (&video_source_collection_type_id__once, video_source_collection_type_id);
	}
	return video_source_collection_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

