/* ImportPage.c generated by valac 0.56.18, the Vala compiler
 * generated from ImportPage.vala, do not modify */

/*
* Copyright (c) 2009-2013 Yorba Foundation
*               2018 elementary LLC. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gphoto2/gphoto2-camera.h>
#include <gphoto.h>
#include <gphoto2/gphoto2-result.h>
#include <gphoto2/gphoto2-port-result.h>
#include <gphoto2/gphoto2-context.h>
#include <pango/pango.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gee.h>
#include <gphoto2/gphoto2-abilities-list.h>
#include <granite.h>
#include <gphoto2/gphoto2-list.h>
#include <gphoto2/gphoto2-filesys.h>
#include <float.h>
#include <math.h>

#define PHOTO_IMPORT_SOURCE_INTERP GDK_INTERP_BILINEAR
#define IMPORT_PREVIEW_MAX_SCALE 128
#define IMPORT_PAGE_UNMOUNT_FAILED_MSG _ ("Unable to unmount camera. Try unmounting the camera from the file mana" \
"ger.")
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define TYPE_IMPORT_SOURCE_COLLECTION (import_source_collection_get_type ())
#define IMPORT_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMPORT_SOURCE_COLLECTION, ImportSourceCollection))
#define IMPORT_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IMPORT_SOURCE_COLLECTION, ImportSourceCollectionClass))
#define IS_IMPORT_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMPORT_SOURCE_COLLECTION))
#define IS_IMPORT_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IMPORT_SOURCE_COLLECTION))
#define IMPORT_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IMPORT_SOURCE_COLLECTION, ImportSourceCollectionClass))

typedef struct _ImportSourceCollection ImportSourceCollection;
typedef struct _ImportSourceCollectionClass ImportSourceCollectionClass;
typedef struct _ImportSourceCollectionPrivate ImportSourceCollectionPrivate;

#define TYPE_IMPORT_SOURCE (import_source_get_type ())
#define IMPORT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMPORT_SOURCE, ImportSource))
#define IMPORT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IMPORT_SOURCE, ImportSourceClass))
#define IS_IMPORT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMPORT_SOURCE))
#define IS_IMPORT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IMPORT_SOURCE))
#define IMPORT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IMPORT_SOURCE, ImportSourceClass))

typedef struct _ImportSource ImportSource;
typedef struct _ImportSourceClass ImportSourceClass;
typedef struct _ImportSourcePrivate ImportSourcePrivate;
enum  {
	IMPORT_SOURCE_0_PROPERTY,
	IMPORT_SOURCE_CAMERA_PROPERTY,
	IMPORT_SOURCE_FSID_PROPERTY,
	IMPORT_SOURCE_CAMERA_NAME_PROPERTY,
	IMPORT_SOURCE_FILENAME_PROPERTY,
	IMPORT_SOURCE_FOLDER_PROPERTY,
	IMPORT_SOURCE_FILE_SIZE_PROPERTY,
	IMPORT_SOURCE_NUM_PROPERTIES
};
static GParamSpec* import_source_properties[IMPORT_SOURCE_NUM_PROPERTIES];
#define _gp_camera_unref0(var) ((var == NULL) ? NULL : (var = (gp_camera_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_VIDEO_IMPORT_SOURCE (video_import_source_get_type ())
#define VIDEO_IMPORT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_IMPORT_SOURCE, VideoImportSource))
#define VIDEO_IMPORT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_IMPORT_SOURCE, VideoImportSourceClass))
#define IS_VIDEO_IMPORT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_IMPORT_SOURCE))
#define IS_VIDEO_IMPORT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_IMPORT_SOURCE))
#define VIDEO_IMPORT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_IMPORT_SOURCE, VideoImportSourceClass))

typedef struct _VideoImportSource VideoImportSource;
typedef struct _VideoImportSourceClass VideoImportSourceClass;
typedef struct _VideoImportSourcePrivate VideoImportSourcePrivate;
enum  {
	VIDEO_IMPORT_SOURCE_0_PROPERTY,
	VIDEO_IMPORT_SOURCE_NUM_PROPERTIES
};
static GParamSpec* video_import_source_properties[VIDEO_IMPORT_SOURCE_NUM_PROPERTIES];

#define TYPE_PHOTO_IMPORT_SOURCE (photo_import_source_get_type ())
#define PHOTO_IMPORT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_IMPORT_SOURCE, PhotoImportSource))
#define PHOTO_IMPORT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_IMPORT_SOURCE, PhotoImportSourceClass))
#define IS_PHOTO_IMPORT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_IMPORT_SOURCE))
#define IS_PHOTO_IMPORT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_IMPORT_SOURCE))
#define PHOTO_IMPORT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_IMPORT_SOURCE, PhotoImportSourceClass))

typedef struct _PhotoImportSource PhotoImportSource;
typedef struct _PhotoImportSourceClass PhotoImportSourceClass;
typedef struct _PhotoImportSourcePrivate PhotoImportSourcePrivate;
enum  {
	PHOTO_IMPORT_SOURCE_0_PROPERTY,
	PHOTO_IMPORT_SOURCE_NUM_PROPERTIES
};
static GParamSpec* photo_import_source_properties[PHOTO_IMPORT_SOURCE_NUM_PROPERTIES];
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
#define _metadata_date_time_unref0(var) ((var == NULL) ? NULL : (var = (metadata_date_time_unref (var), NULL)))

#define TYPE_IMPORT_PREVIEW (import_preview_get_type ())
#define IMPORT_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMPORT_PREVIEW, ImportPreview))
#define IMPORT_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IMPORT_PREVIEW, ImportPreviewClass))
#define IS_IMPORT_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMPORT_PREVIEW))
#define IS_IMPORT_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IMPORT_PREVIEW))
#define IMPORT_PREVIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IMPORT_PREVIEW, ImportPreviewClass))

typedef struct _ImportPreview ImportPreview;
typedef struct _ImportPreviewClass ImportPreviewClass;
typedef struct _ImportPreviewPrivate ImportPreviewPrivate;
enum  {
	IMPORT_PREVIEW_0_PROPERTY,
	IMPORT_PREVIEW_NUM_PROPERTIES
};
static GParamSpec* import_preview_properties[IMPORT_PREVIEW_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	CAMERA_ACCUMULATOR_0_PROPERTY,
	CAMERA_ACCUMULATOR_TOTAL_PROPERTY,
	CAMERA_ACCUMULATOR_PHOTOS_PROPERTY,
	CAMERA_ACCUMULATOR_VIDEOS_PROPERTY,
	CAMERA_ACCUMULATOR_RAW_PROPERTY,
	CAMERA_ACCUMULATOR_NUM_PROPERTIES
};
static GParamSpec* camera_accumulator_properties[CAMERA_ACCUMULATOR_NUM_PROPERTIES];

#define IMPORT_PAGE_TYPE_IMPORT_PAGE_SEARCH_VIEW_FILTER (import_page_import_page_search_view_filter_get_type ())
#define IMPORT_PAGE_IMPORT_PAGE_SEARCH_VIEW_FILTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IMPORT_PAGE_TYPE_IMPORT_PAGE_SEARCH_VIEW_FILTER, ImportPageImportPageSearchViewFilter))
#define IMPORT_PAGE_IMPORT_PAGE_SEARCH_VIEW_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), IMPORT_PAGE_TYPE_IMPORT_PAGE_SEARCH_VIEW_FILTER, ImportPageImportPageSearchViewFilterClass))
#define IMPORT_PAGE_IS_IMPORT_PAGE_SEARCH_VIEW_FILTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IMPORT_PAGE_TYPE_IMPORT_PAGE_SEARCH_VIEW_FILTER))
#define IMPORT_PAGE_IS_IMPORT_PAGE_SEARCH_VIEW_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), IMPORT_PAGE_TYPE_IMPORT_PAGE_SEARCH_VIEW_FILTER))
#define IMPORT_PAGE_IMPORT_PAGE_SEARCH_VIEW_FILTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), IMPORT_PAGE_TYPE_IMPORT_PAGE_SEARCH_VIEW_FILTER, ImportPageImportPageSearchViewFilterClass))

typedef struct _ImportPageImportPageSearchViewFilter ImportPageImportPageSearchViewFilter;
typedef struct _ImportPageImportPageSearchViewFilterClass ImportPageImportPageSearchViewFilterClass;

#define IMPORT_PAGE_TYPE_HIDE_IMPORTED_VIEW_FILTER (import_page_hide_imported_view_filter_get_type ())
#define IMPORT_PAGE_HIDE_IMPORTED_VIEW_FILTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IMPORT_PAGE_TYPE_HIDE_IMPORTED_VIEW_FILTER, ImportPageHideImportedViewFilter))
#define IMPORT_PAGE_HIDE_IMPORTED_VIEW_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), IMPORT_PAGE_TYPE_HIDE_IMPORTED_VIEW_FILTER, ImportPageHideImportedViewFilterClass))
#define IMPORT_PAGE_IS_HIDE_IMPORTED_VIEW_FILTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IMPORT_PAGE_TYPE_HIDE_IMPORTED_VIEW_FILTER))
#define IMPORT_PAGE_IS_HIDE_IMPORTED_VIEW_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), IMPORT_PAGE_TYPE_HIDE_IMPORTED_VIEW_FILTER))
#define IMPORT_PAGE_HIDE_IMPORTED_VIEW_FILTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), IMPORT_PAGE_TYPE_HIDE_IMPORTED_VIEW_FILTER, ImportPageHideImportedViewFilterClass))

typedef struct _ImportPageHideImportedViewFilter ImportPageHideImportedViewFilter;
typedef struct _ImportPageHideImportedViewFilterClass ImportPageHideImportedViewFilterClass;
enum  {
	IMPORT_PAGE_0_PROPERTY,
	IMPORT_PAGE_NUM_PROPERTIES
};
static GParamSpec* import_page_properties[IMPORT_PAGE_NUM_PROPERTIES];
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
#define _view_filter_unref0(var) ((var == NULL) ? NULL : (var = (view_filter_unref (var), NULL)))
#define _core_tracker_unref0(var) ((var == NULL) ? NULL : (var = (core_tracker_unref (var), NULL)))
#define _gp_context_wrapper_unref0(var) ((var == NULL) ? NULL : (var = (gp_context_wrapper_unref (var), NULL)))

#define IMPORT_PAGE_TYPE_IMPORT_VIEW_MANAGER (import_page_import_view_manager_get_type ())
#define IMPORT_PAGE_IMPORT_VIEW_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IMPORT_PAGE_TYPE_IMPORT_VIEW_MANAGER, ImportPageImportViewManager))
#define IMPORT_PAGE_IMPORT_VIEW_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), IMPORT_PAGE_TYPE_IMPORT_VIEW_MANAGER, ImportPageImportViewManagerClass))
#define IMPORT_PAGE_IS_IMPORT_VIEW_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IMPORT_PAGE_TYPE_IMPORT_VIEW_MANAGER))
#define IMPORT_PAGE_IS_IMPORT_VIEW_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), IMPORT_PAGE_TYPE_IMPORT_VIEW_MANAGER))
#define IMPORT_PAGE_IMPORT_VIEW_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), IMPORT_PAGE_TYPE_IMPORT_VIEW_MANAGER, ImportPageImportViewManagerClass))

typedef struct _ImportPageImportViewManager ImportPageImportViewManager;
typedef struct _ImportPageImportViewManagerClass ImportPageImportViewManagerClass;
#define _view_collection_monitor_unref0(var) ((var == NULL) ? NULL : (var = (view_collection_monitor_unref (var), NULL)))
#define _view_manager_unref0(var) ((var == NULL) ? NULL : (var = (view_manager_unref (var), NULL)))
typedef struct _Block16Data Block16Data;
typedef struct _Block17Data Block17Data;

#define IMPORT_PAGE_TYPE_CAMERA_IMPORT_JOB (import_page_camera_import_job_get_type ())
#define IMPORT_PAGE_CAMERA_IMPORT_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IMPORT_PAGE_TYPE_CAMERA_IMPORT_JOB, ImportPageCameraImportJob))
#define IMPORT_PAGE_CAMERA_IMPORT_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), IMPORT_PAGE_TYPE_CAMERA_IMPORT_JOB, ImportPageCameraImportJobClass))
#define IMPORT_PAGE_IS_CAMERA_IMPORT_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IMPORT_PAGE_TYPE_CAMERA_IMPORT_JOB))
#define IMPORT_PAGE_IS_CAMERA_IMPORT_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), IMPORT_PAGE_TYPE_CAMERA_IMPORT_JOB))
#define IMPORT_PAGE_CAMERA_IMPORT_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), IMPORT_PAGE_TYPE_CAMERA_IMPORT_JOB, ImportPageCameraImportJobClass))

typedef struct _ImportPageCameraImportJob ImportPageCameraImportJob;
typedef struct _ImportPageCameraImportJobClass ImportPageCameraImportJobClass;
#define _gp_list_unref0(var) ((var == NULL) ? NULL : (var = (gp_list_unref (var), NULL)))
#define _batch_import_job_unref0(var) ((var == NULL) ? NULL : (var = (batch_import_job_unref (var), NULL)))
#define _import_manifest_unref0(var) ((var == NULL) ? NULL : (var = (import_manifest_unref (var), NULL)))
#define _import_ui_question_params_unref0(var) ((var == NULL) ? NULL : (var = (import_ui_question_params_unref (var), NULL)))
#define _batch_import_result_unref0(var) ((var == NULL) ? NULL : (var = (batch_import_result_unref (var), NULL)))
typedef struct _ImportPageImportViewManagerPrivate ImportPageImportViewManagerPrivate;
typedef struct _ImportPageCameraImportJobPrivate ImportPageCameraImportJobPrivate;
#define _backing_photo_row_unref0(var) ((var == NULL) ? NULL : (var = (backing_photo_row_unref (var), NULL)))
typedef struct _ImportPageImportPageSearchViewFilterPrivate ImportPageImportPageSearchViewFilterPrivate;
typedef struct _ImportPageHideImportedViewFilterPrivate ImportPageHideImportedViewFilterPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ImportSourceCollection {
	SourceCollection parent_instance;
	ImportSourceCollectionPrivate * priv;
};

struct _ImportSourceCollectionClass {
	SourceCollectionClass parent_class;
};

struct _ImportSource {
	ThumbnailSource parent_instance;
	ImportSourcePrivate * priv;
};

struct _ImportSourceClass {
	ThumbnailSourceClass parent_class;
	GdkPixbuf* (*get_preview) (ImportSource* self);
	gint64 (*get_exposure_time) (ImportSource* self);
};

struct _ImportSourcePrivate {
	Camera* _camera;
	gint _fsid;
	gchar* _camera_name;
	gchar* _filename;
	gchar* _folder;
	gulong _file_size;
	gint64 modification_time;
	GdkPixbuf* preview;
	gchar* indexable_keywords;
};

struct _VideoImportSource {
	ImportSource parent_instance;
	VideoImportSourcePrivate * priv;
};

struct _VideoImportSourceClass {
	ImportSourceClass parent_class;
};

struct _PhotoImportSource {
	ImportSource parent_instance;
	PhotoImportSourcePrivate * priv;
};

struct _PhotoImportSourceClass {
	ImportSourceClass parent_class;
};

struct _PhotoImportSourcePrivate {
	PhotoFileFormat file_format;
	gchar* preview_md5;
	PhotoMetadata* metadata;
	gchar* exif_md5;
	PhotoImportSource* associated;
};

struct _ImportPreview {
	CheckerboardItem parent_instance;
	ImportPreviewPrivate * priv;
};

struct _ImportPreviewClass {
	CheckerboardItemClass parent_class;
};

struct _ImportPreviewPrivate {
	DuplicatedFile* duplicated_file;
};

struct _CameraAccumulatorPrivate {
	gint _total;
	gint _photos;
	gint _videos;
	gint _raw;
};

struct _ImportPagePrivate {
	SourceCollection* import_sources;
	GtkLabel* camera_label;
	GtkCheckButton* hide_imported;
	GtkProgressBar* progress_bar;
	Camera* camera;
	gchar* uri;
	gboolean busy;
	gboolean refreshed;
	int refresh_result;
	gchar* refresh_error;
	gchar* camera_name;
	GVolumeMonitor* volume_monitor;
	ImportPage* local_ref;
	GIcon* icon;
	ImportPageImportPageSearchViewFilter* search_filter;
	ImportPageHideImportedViewFilter* hide_imported_filter;
	CameraViewTracker* tracker;
	GtkMenu* page_context_menu;
	GtkMenu* import_context_menu;
};

struct _Block16Data {
	int _ref_count_;
	ImportPage* self;
	GtkRadioMenuItem* ascending_menu_item;
	GtkAction* ascending_action;
	GtkRadioMenuItem* descending_menu_item;
	GtkAction* descending_action;
	GAction* select_action;
};

struct _Block17Data {
	int _ref_count_;
	ImportPage* self;
	GtkAction* selected_action;
	GtkAction* all_action;
};

struct _ImportPageImportViewManager {
	ViewManager parent_instance;
	ImportPageImportViewManagerPrivate * priv;
};

struct _ImportPageImportViewManagerClass {
	ViewManagerClass parent_class;
};

struct _ImportPageImportViewManagerPrivate {
	ImportPage* owner;
};

struct _ImportPageCameraImportJob {
	BatchImportJob parent_instance;
	ImportPageCameraImportJobPrivate * priv;
};

struct _ImportPageCameraImportJobClass {
	BatchImportJobClass parent_class;
};

struct _ImportPageCameraImportJobPrivate {
	GPContextWrapper* context;
	ImportSource* import_file;
	Camera* camera;
	gchar* fulldir;
	gchar* filename;
	guint64 filesize;
	PhotoMetadata* metadata;
	gint64 exposure_time;
	ImportPageCameraImportJob* associated;
	BackingPhotoRow* associated_file;
	DuplicatedFile* duplicated_file;
	GSettings* file_settings;
};

struct _ImportPageImportPageSearchViewFilter {
	SearchViewFilter parent_instance;
	ImportPageImportPageSearchViewFilterPrivate * priv;
};

struct _ImportPageImportPageSearchViewFilterClass {
	SearchViewFilterClass parent_class;
};

struct _ImportPageHideImportedViewFilter {
	ViewFilter parent_instance;
	ImportPageHideImportedViewFilterPrivate * priv;
};

struct _ImportPageHideImportedViewFilterClass {
	ViewFilterClass parent_class;
};

static gpointer import_source_collection_parent_class = NULL;
static gint ImportSource_private_offset;
static gpointer import_source_parent_class = NULL;
static IndexableIface * import_source_indexable_parent_iface = NULL;
static gpointer video_import_source_parent_class = NULL;
static gint PhotoImportSource_private_offset;
static gpointer photo_import_source_parent_class = NULL;
static gint ImportPreview_private_offset;
static gpointer import_preview_parent_class = NULL;
static GdkPixbuf* import_preview_placeholder_preview;
static GdkPixbuf* import_preview_placeholder_preview = NULL;
static gpointer camera_view_tracker_parent_class = NULL;
static gint CameraAccumulator_private_offset;
static gpointer camera_accumulator_parent_class = NULL;
static CoreTrackerAccumulatorIface * camera_accumulator_core_tracker_accumulator_parent_iface = NULL;
static gint ImportPage_private_offset;
static gpointer import_page_parent_class = NULL;
GPContextWrapper* import_page_null_context = NULL;
GPSpinIdleWrapper* import_page_spin_idle_context = NULL;
static gint ImportPageImportViewManager_private_offset;
static gpointer import_page_import_view_manager_parent_class = NULL;
static gint ImportPageCameraImportJob_private_offset;
static gpointer import_page_camera_import_job_parent_class = NULL;
static gpointer import_page_import_page_search_view_filter_parent_class = NULL;
static gpointer import_page_hide_imported_view_filter_parent_class = NULL;

VALA_EXTERN GType import_source_collection_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ImportSourceCollection* import_source_collection_new (const gchar* name);
VALA_EXTERN ImportSourceCollection* import_source_collection_construct (GType object_type,
                                                            const gchar* name);
static gboolean import_source_collection_real_holds_type_of_source (SourceCollection* base,
                                                             DataSource* source);
VALA_EXTERN GType import_source_get_type (void) G_GNUC_CONST ;
static GType import_source_collection_get_type_once (void);
VALA_EXTERN GdkPixbuf* import_source_get_preview (ImportSource* self);
VALA_EXTERN gint64 import_source_get_exposure_time (ImportSource* self);
VALA_EXTERN ImportSource* import_source_construct (GType object_type,
                                       const gchar* camera_name,
                                       Camera* camera,
                                       gint fsid,
                                       const gchar* folder,
                                       const gchar* filename,
                                       gulong file_size,
                                       gint64 modification_time);
VALA_EXTERN void import_source_set_preview (ImportSource* self,
                                GdkPixbuf* preview);
VALA_EXTERN gint64 import_source_get_modification_time (ImportSource* self);
static GdkPixbuf* import_source_real_get_preview (ImportSource* self);
static gint64 import_source_real_get_exposure_time (ImportSource* self);
VALA_EXTERN gchar* import_source_get_fulldir (ImportSource* self);
VALA_EXTERN Camera* import_source_get_camera (ImportSource* self);
VALA_EXTERN const gchar* import_source_get_camera_name (ImportSource* self);
VALA_EXTERN gint import_source_get_fsid (ImportSource* self);
VALA_EXTERN const gchar* import_source_get_folder (ImportSource* self);
static gchar* import_source_real_to_string (DataObject* base);
VALA_EXTERN const gchar* import_source_get_filename (ImportSource* self);
static gboolean import_source_real_internal_delete_backing (DataSource* base,
                                                     GError** error);
static const gchar* import_source_real_get_indexable_keywords (Indexable* base);
static void import_source_set_camera (ImportSource* self,
                               Camera* value);
static void import_source_set_fsid (ImportSource* self,
                             gint value);
static void import_source_set_camera_name (ImportSource* self,
                                    const gchar* value);
static void import_source_set_filename (ImportSource* self,
                                 const gchar* value);
static void import_source_set_folder (ImportSource* self,
                               const gchar* value);
VALA_EXTERN gulong import_source_get_file_size (ImportSource* self);
static void import_source_set_file_size (ImportSource* self,
                                  gulong value);
static void import_source_finalize (GObject * obj);
static GType import_source_get_type_once (void);
static void _vala_import_source_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_import_source_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);
VALA_EXTERN GType video_import_source_get_type (void) G_GNUC_CONST ;
VALA_EXTERN VideoImportSource* video_import_source_new (const gchar* camera_name,
                                            Camera* camera,
                                            gint fsid,
                                            const gchar* folder,
                                            const gchar* filename,
                                            gulong file_size,
                                            gint64 modification_time);
VALA_EXTERN VideoImportSource* video_import_source_construct (GType object_type,
                                                  const gchar* camera_name,
                                                  Camera* camera,
                                                  gint fsid,
                                                  const gchar* folder,
                                                  const gchar* filename,
                                                  gulong file_size,
                                                  gint64 modification_time);
static GdkPixbuf* video_import_source_real_get_thumbnail (ThumbnailSource* base,
                                                   gint scale,
                                                   GError** error);
static GdkPixbuf* video_import_source_real_create_thumbnail (ThumbnailSource* base,
                                                      gint scale,
                                                      GError** error);
VALA_EXTERN GdkPixbuf* scale_pixbuf (GdkPixbuf* pixbuf,
                         gint scale,
                         GdkInterpType interp,
                         gboolean scale_up);
static gchar* video_import_source_real_get_typename (DataSource* base);
static gint64 video_import_source_real_get_instance_id (DataSource* base);
static PhotoFileFormat video_import_source_real_get_preferred_thumbnail_format (ThumbnailSource* base);
static gchar* video_import_source_real_get_name (DataObject* base);
VALA_EXTERN void video_import_source_update (VideoImportSource* self,
                                 GdkPixbuf* preview);
static GType video_import_source_get_type_once (void);
VALA_EXTERN GType photo_import_source_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PhotoImportSource* photo_import_source_new (const gchar* camera_name,
                                            Camera* camera,
                                            gint fsid,
                                            const gchar* folder,
                                            const gchar* filename,
                                            gulong file_size,
                                            gint64 modification_time,
                                            PhotoFileFormat file_format);
VALA_EXTERN PhotoImportSource* photo_import_source_construct (GType object_type,
                                                  const gchar* camera_name,
                                                  Camera* camera,
                                                  gint fsid,
                                                  const gchar* folder,
                                                  const gchar* filename,
                                                  gulong file_size,
                                                  gint64 modification_time,
                                                  PhotoFileFormat file_format);
static gchar* photo_import_source_real_get_name (DataObject* base);
VALA_EXTERN gchar* photo_import_source_get_title (PhotoImportSource* self);
static gchar* photo_import_source_real_get_typename (DataSource* base);
static gint64 photo_import_source_real_get_instance_id (DataSource* base);
static PhotoFileFormat photo_import_source_real_get_preferred_thumbnail_format (ThumbnailSource* base);
static GdkPixbuf* photo_import_source_real_create_thumbnail (ThumbnailSource* base,
                                                      gint scale,
                                                      GError** error);
VALA_EXTERN void photo_import_source_update (PhotoImportSource* self,
                                 GdkPixbuf* preview,
                                 const gchar* preview_md5,
                                 PhotoMetadata* metadata,
                                 const gchar* exif_md5);
static gint64 photo_import_source_real_get_exposure_time (ImportSource* base);
VALA_EXTERN PhotoMetadata* photo_import_source_get_metadata (PhotoImportSource* self);
static GdkPixbuf* photo_import_source_real_get_preview (ImportSource* base);
static GdkPixbuf* photo_import_source_real_get_thumbnail (ThumbnailSource* base,
                                                   gint scale,
                                                   GError** error);
VALA_EXTERN PhotoFileFormat photo_import_source_get_file_format (PhotoImportSource* self);
VALA_EXTERN gchar* photo_import_source_get_preview_md5 (PhotoImportSource* self);
VALA_EXTERN void photo_import_source_set_associated (PhotoImportSource* self,
                                         PhotoImportSource* associated);
VALA_EXTERN PhotoImportSource* photo_import_source_get_associated (PhotoImportSource* self);
static gboolean photo_import_source_real_internal_delete_backing (DataSource* base,
                                                           GError** error);
static void photo_import_source_finalize (GObject * obj);
static GType photo_import_source_get_type_once (void);
VALA_EXTERN GType import_preview_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ImportPreview* import_preview_new (ImportSource* source);
VALA_EXTERN ImportPreview* import_preview_construct (GType object_type,
                                         ImportSource* source);
static GdkPixbuf* import_preview_get_placeholder_pixbuf (ImportPreview* self);
VALA_EXTERN gboolean import_preview_is_already_imported (ImportPreview* self);
VALA_EXTERN ImportSource* import_preview_get_import_source (ImportPreview* self);
VALA_EXTERN DuplicatedFile* import_preview_get_duplicated_file (ImportPreview* self);
static void import_preview_finalize (GObject * obj);
static GType import_preview_get_type_once (void);
static void camera_view_tracker_finalize (CoreTracker * obj);
static GType camera_view_tracker_get_type_once (void);
static gboolean camera_accumulator_real_include (CoreTrackerAccumulator* base,
                                          DataObject* object);
static void camera_accumulator_set_total (CameraAccumulator* self,
                                   gint value);
static void camera_accumulator_set_photos (CameraAccumulator* self,
                                    gint value);
static void camera_accumulator_set_raw (CameraAccumulator* self,
                                 gint value);
static void camera_accumulator_set_videos (CameraAccumulator* self,
                                    gint value);
static gboolean camera_accumulator_real_uninclude (CoreTrackerAccumulator* base,
                                            DataObject* object);
static gboolean camera_accumulator_real_altered (CoreTrackerAccumulator* base,
                                          DataObject* object,
                                          Alteration* alteration);
static void camera_accumulator_finalize (GObject * obj);
static GType camera_accumulator_get_type_once (void);
static void _vala_camera_accumulator_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_camera_accumulator_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static GType import_page_import_page_search_view_filter_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GType import_page_hide_imported_view_filter_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void import_page_on_media_added_removed (ImportPage* self);
static void _import_page_on_media_added_removed_data_collection_contents_altered (DataCollection* _sender,
                                                                           GeeIterable* added,
                                                                           GeeIterable* removed,
                                                                           gpointer self);
static ImportPageImportPageSearchViewFilter* import_page_import_page_search_view_filter_new (void);
static ImportPageImportPageSearchViewFilter* import_page_import_page_search_view_filter_construct (GType object_type);
static ImportPageHideImportedViewFilter* import_page_hide_imported_view_filter_new (void);
static ImportPageHideImportedViewFilter* import_page_hide_imported_view_filter_construct (GType object_type);
static ImportPageImportViewManager* import_page_import_view_manager_new (ImportPage* owner);
static ImportPageImportViewManager* import_page_import_view_manager_construct (GType object_type,
                                                                        ImportPage* owner);
static GType import_page_import_view_manager_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static gint64 import_page_preview_comparator (void* a,
                                       void* b);
static gint64 _import_page_preview_comparator_comparator (void* a,
                                                   void* b,
                                                   gpointer self);
static gboolean import_page_preview_comparator_predicate (DataObject* object,
                                                   Alteration* alteration);
static gboolean _import_page_preview_comparator_predicate_comparator_predicate (DataObject* object,
                                                                         Alteration* alteration,
                                                                         gpointer self);
static void import_page_on_view_changed (ImportPage* self);
static void _import_page_on_view_changed_view_collection_items_state_changed (ViewCollection* _sender,
                                                                       GeeIterable* changed,
                                                                       gpointer self);
static void _import_page_on_view_changed_data_collection_contents_altered (DataCollection* _sender,
                                                                    GeeIterable* added,
                                                                    GeeIterable* removed,
                                                                    gpointer self);
static void _import_page_on_view_changed_view_collection_items_visibility_changed (ViewCollection* _sender,
                                                                            GeeCollection* changed,
                                                                            gpointer self);
static void import_page_real_add_toolbar_widgets (Page* base,
                                           GtkActionBar* toolbar);
static void import_page_on_hide_imported (ImportPage* self);
static void _import_page_on_hide_imported_gtk_button_clicked (GtkButton* _sender,
                                                       gpointer self);
static void import_page_update_toolbar_state (ImportPage* self);
static GtkMenu* import_page_real_get_item_context_menu (CheckerboardPage* base);
static void import_page_create_import_context_menu (ImportPage* self);
static GtkMenu* import_page_real_get_page_context_menu (Page* base);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
static void ___lambda119_ (Block16Data* _data16_);
static void ____lambda119__gtk_menu_item_activate (GtkMenuItem* _sender,
                                            gpointer self);
static void ___lambda120_ (Block16Data* _data16_);
static void ____lambda120__gtk_menu_item_activate (GtkMenuItem* _sender,
                                            gpointer self);
static void ___lambda121_ (Block16Data* _data16_);
static void ____lambda121__gtk_menu_item_activate (GtkMenuItem* _sender,
                                            gpointer self);
static GtkMenu* import_page_real_get_page_sidebar_menu (Page* base);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
static void __lambda117_ (Block17Data* _data17_);
static void ___lambda117__gtk_menu_item_activate (GtkMenuItem* _sender,
                                           gpointer self);
static void __lambda118_ (Block17Data* _data17_);
static void ___lambda118__gtk_menu_item_activate (GtkMenuItem* _sender,
                                           gpointer self);
static CoreViewTracker* import_page_real_get_view_tracker (CheckerboardPage* base);
static gchar* import_page_real_get_view_empty_message (CheckerboardPage* base);
static gint64 import_page_import_job_comparator (ImportPage* self,
                                          void* a,
                                          void* b);
static GType import_page_camera_import_job_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static gint64 import_page_camera_import_job_get_exposure_time (ImportPageCameraImportJob* self);
static GtkToggleActionEntry* import_page_real_init_collect_toggle_action_entries (Page* base,
                                                                           gint* result_length1);
static void import_page_on_display_titles (ImportPage* self,
                                    GtkAction* action);
static void _import_page_on_display_titles_gcallback (GtkAction* action,
                                               gpointer self);
static void _vala_array_add153 (GtkToggleActionEntry* * array,
                         gint* length,
                         gint* size,
                         const GtkToggleActionEntry* value);
static GtkActionEntry* import_page_real_init_collect_action_entries (Page* base,
                                                              gint* result_length1);
static void import_page_on_import_selected (ImportPage* self);
static void _import_page_on_import_selected_gcallback (GtkAction* action,
                                                gpointer self);
static void _vala_array_add154 (GtkActionEntry* * array,
                         gint* length,
                         gint* size,
                         const GtkActionEntry* value);
static void import_page_on_import_all (ImportPage* self);
static void _import_page_on_import_all_gcallback (GtkAction* action,
                                           gpointer self);
static void _vala_array_add155 (GtkActionEntry* * array,
                         gint* length,
                         gint* size,
                         const GtkActionEntry* value);
static void import_page_real_init_actions (Page* base,
                                    gint selected_count,
                                    gint count);
static void import_page_update_status (ImportPage* self,
                                gboolean busy,
                                gboolean refreshed);
static void import_page_real_switched_to (Page* base);
static void import_page_real_ready (Page* base);
static void import_page_try_refreshing_camera (ImportPage* self,
                                        gboolean fail_on_locked);
static ImportPageRefreshResult import_page_refresh_camera (ImportPage* self);
static void import_page_on_unmounted (ImportPage* self,
                               GMount* mount);
static void _import_page_on_unmounted_g_mount_unmounted (GMount* _sender,
                                                  gpointer self);
static void import_page_on_unmount_finished (ImportPage* self,
                                      GObject* source,
                                      GAsyncResult* aresult);
static void _import_page_on_unmount_finished_gasync_ready_callback (GObject* source_object,
                                                             GAsyncResult* res,
                                                             gpointer self);
static void import_page_clear_all_import_sources (ImportPage* self);
static gboolean import_page_check_directory_exists (ImportPage* self,
                                             gint fsid,
                                             const gchar* dir,
                                             const gchar* search_target);
static gboolean import_page_enumerate_files (ImportPage* self,
                                      gint fsid,
                                      const gchar* dir,
                                      GeeArrayList* import_list);
static void import_page_auto_match_raw_jpeg (ImportPage* self,
                                      GeeArrayList* import_list);
static void import_page_load_previews_and_metadata (ImportPage* self,
                                             GeeList* import_list);
static gchar* import_page_chomp_ch (const gchar* str,
                             gchar ch);
static void import_page_import (ImportPage* self,
                         GeeIterable* items);
static gint64 _import_page_import_job_comparator_comparator (void* a,
                                                      void* b,
                                                      gpointer self);
static ImportPageCameraImportJob* import_page_camera_import_job_new (GPContextWrapper* context,
                                                              ImportSource* import_file,
                                                              DuplicatedFile* duplicated_file);
static ImportPageCameraImportJob* import_page_camera_import_job_construct (GType object_type,
                                                                    GPContextWrapper* context,
                                                                    ImportSource* import_file,
                                                                    DuplicatedFile* duplicated_file);
static void import_page_import_reporter (ImportPage* self,
                                  ImportManifest* manifest);
static void _import_page_import_reporter_batch_import_import_reporter (ImportManifest* manifest,
                                                                BatchImportRoll* import_roll,
                                                                gpointer self);
static void import_page_on_import_job_failed (ImportPage* self,
                                       BatchImportResult* _result_);
static void _import_page_on_import_job_failed_batch_import_import_job_failed (BatchImport* _sender,
                                                                       BatchImportResult* _result_,
                                                                       gpointer self);
static void import_page_close_import (ImportPage* self);
static void _import_page_close_import_batch_import_import_complete (BatchImport* _sender,
                                                             ImportManifest* manifest,
                                                             BatchImportRoll* import_roll,
                                                             gpointer self);
static ImportSource* import_page_camera_import_job_get_source (ImportPageCameraImportJob* self);
static gboolean _progress_dialog_monitor_progress_monitor (guint64 current,
                                                    guint64 total,
                                                    gboolean do_event_loop,
                                                    gpointer self);
static void import_page_real_set_display_titles (CheckerboardPage* base,
                                          gboolean display);
static SearchViewFilter* import_page_real_get_search_view_filter (CheckerboardPage* base);
static DataView* import_page_import_view_manager_real_create_view (ViewManager* base,
                                                            DataSource* source);
static void import_page_import_view_manager_finalize (ViewManager * obj);
static GType import_page_import_view_manager_get_type_once (void);
static DuplicatedFile* import_page_camera_import_job_real_get_duplicated_file (BatchImportJob* base);
static gint64 import_page_camera_import_job_real_get_exposure_time_override (BatchImportJob* base);
static gchar* import_page_camera_import_job_real_get_dest_identifier (BatchImportJob* base);
static gchar* import_page_camera_import_job_real_get_source_identifier (BatchImportJob* base);
static gchar* import_page_camera_import_job_real_get_basename (BatchImportJob* base);
static gchar* import_page_camera_import_job_real_get_path (BatchImportJob* base);
static void import_page_camera_import_job_real_set_associated (BatchImportJob* base,
                                                        BatchImportJob* associated);
static gboolean import_page_camera_import_job_real_is_directory (BatchImportJob* base);
static gboolean import_page_camera_import_job_real_determine_file_size (BatchImportJob* base,
                                                                 guint64* filesize,
                                                                 GFile** file);
static gboolean import_page_camera_import_job_real_prepare (BatchImportJob* base,
                                                     GFile** file_to_import,
                                                     gboolean* copy_to_library,
                                                     GError** error);
static gboolean import_page_camera_import_job_real_complete (BatchImportJob* base,
                                                      MediaSource* source,
                                                      BatchImportRoll* import_roll,
                                                      GError** error);
static void import_page_camera_import_job_finalize (BatchImportJob * obj);
static GType import_page_camera_import_job_get_type_once (void);
static guint import_page_import_page_search_view_filter_real_get_criteria (SearchViewFilter* base);
static gboolean import_page_import_page_search_view_filter_real_predicate (ViewFilter* base,
                                                                    DataView* view);
static GType import_page_import_page_search_view_filter_get_type_once (void);
static gboolean import_page_hide_imported_view_filter_real_predicate (ViewFilter* base,
                                                               DataView* view);
static GType import_page_hide_imported_view_filter_get_type_once (void);
static void import_page_finalize (GObject * obj);
static GType import_page_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

ImportSourceCollection*
import_source_collection_construct (GType object_type,
                                    const gchar* name)
{
	ImportSourceCollection* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ImportSourceCollection*) source_collection_construct (object_type, name);
	return self;
}

ImportSourceCollection*
import_source_collection_new (const gchar* name)
{
	return import_source_collection_construct (TYPE_IMPORT_SOURCE_COLLECTION, name);
}

static gboolean
import_source_collection_real_holds_type_of_source (SourceCollection* base,
                                                    DataSource* source)
{
	ImportSourceCollection * self;
	gboolean result;
	self = (ImportSourceCollection*) base;
	g_return_val_if_fail (source != NULL, FALSE);
	result = IS_IMPORT_SOURCE (source);
	return result;
}

static void
import_source_collection_class_init (ImportSourceCollectionClass * klass,
                                     gpointer klass_data)
{
	import_source_collection_parent_class = g_type_class_peek_parent (klass);
	((SourceCollectionClass *) klass)->holds_type_of_source = (gboolean (*) (SourceCollection*, DataSource*)) import_source_collection_real_holds_type_of_source;
}

static void
import_source_collection_instance_init (ImportSourceCollection * self,
                                        gpointer klass)
{
}

static GType
import_source_collection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ImportSourceCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) import_source_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ImportSourceCollection), 0, (GInstanceInitFunc) import_source_collection_instance_init, NULL };
	GType import_source_collection_type_id;
	import_source_collection_type_id = g_type_register_static (TYPE_SOURCE_COLLECTION, "ImportSourceCollection", &g_define_type_info, 0);
	return import_source_collection_type_id;
}

GType
import_source_collection_get_type (void)
{
	static volatile gsize import_source_collection_type_id__once = 0;
	if (g_once_init_enter (&import_source_collection_type_id__once)) {
		GType import_source_collection_type_id;
		import_source_collection_type_id = import_source_collection_get_type_once ();
		g_once_init_leave (&import_source_collection_type_id__once, import_source_collection_type_id);
	}
	return import_source_collection_type_id__once;
}

static inline gpointer
import_source_get_instance_private (ImportSource* self)
{
	return G_STRUCT_MEMBER_P (self, ImportSource_private_offset);
}

ImportSource*
import_source_construct (GType object_type,
                         const gchar* camera_name,
                         Camera* camera,
                         gint fsid,
                         const gchar* folder,
                         const gchar* filename,
                         gulong file_size,
                         gint64 modification_time)
{
	ImportSource * self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (camera_name != NULL, NULL);
	g_return_val_if_fail (camera != NULL, NULL);
	g_return_val_if_fail (folder != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	self = (ImportSource*) g_object_new (object_type, "camera", camera, "camera-name", camera_name, "filename", filename, "file-size", file_size, "folder", folder, "fsid", fsid, NULL);
	self->priv->modification_time = modification_time;
	_tmp0_ = indexable_prepare_indexable_string (filename);
	_g_free0 (self->priv->indexable_keywords);
	self->priv->indexable_keywords = _tmp0_;
	return self;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
import_source_set_preview (ImportSource* self,
                           GdkPixbuf* preview)
{
	GdkPixbuf* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (preview);
	_g_object_unref0 (self->priv->preview);
	self->priv->preview = _tmp0_;
}

gint64
import_source_get_modification_time (ImportSource* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->modification_time;
	return result;
}

static GdkPixbuf*
import_source_real_get_preview (ImportSource* self)
{
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* result;
	_tmp0_ = self->priv->preview;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

GdkPixbuf*
import_source_get_preview (ImportSource* self)
{
	ImportSourceClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = IMPORT_SOURCE_GET_CLASS (self);
	if (_klass_->get_preview) {
		return _klass_->get_preview (self);
	}
	return NULL;
}

static gint64
import_source_real_get_exposure_time (ImportSource* self)
{
	gint64 result;
	result = import_source_get_modification_time (self);
	return result;
}

gint64
import_source_get_exposure_time (ImportSource* self)
{
	ImportSourceClass* _klass_;
	g_return_val_if_fail (self != NULL, 0LL);
	_klass_ = IMPORT_SOURCE_GET_CLASS (self);
	if (_klass_->get_exposure_time) {
		return _klass_->get_exposure_time (self);
	}
	return -1LL;
}

gchar*
import_source_get_fulldir (ImportSource* self)
{
	Camera* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_camera;
	_tmp1_ = self->priv->_camera_name;
	_tmp2_ = self->priv->_fsid;
	_tmp3_ = self->priv->_folder;
	_tmp4_ = import_page_get_fulldir (_tmp0_, _tmp1_, _tmp2_, _tmp3_);
	result = _tmp4_;
	return result;
}

static gchar*
import_source_real_to_string (DataObject* base)
{
	ImportSource * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	self = (ImportSource*) base;
	_tmp0_ = self->priv->_camera_name;
	_tmp1_ = self->priv->_folder;
	_tmp2_ = self->priv->_filename;
	_tmp3_ = g_strdup_printf ("%s %s/%s", _tmp0_, _tmp1_, _tmp2_);
	result = _tmp3_;
	return result;
}

static gchar*
gp_result_to_full_string (int self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	_tmp0_ = gp_port_result_as_string (self);
	_tmp1_ = g_strdup_printf ("%s (%d)", _tmp0_, (gint) self);
	result = _tmp1_;
	return result;
}

static gboolean
import_source_real_internal_delete_backing (DataSource* base,
                                            GError** error)
{
	ImportSource * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* fulldir = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	int _result_ = 0;
	Camera* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GPSpinIdleWrapper* _tmp13_;
	GPContext* _tmp14_;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (ImportSource*) base;
	_tmp0_ = data_object_to_string ((DataObject*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->_camera_name;
	g_debug ("ImportPage.vala:82: Deleting %s from %s", _tmp1_, _tmp2_);
	_g_free0 (_tmp1_);
	_tmp3_ = import_source_get_fulldir (self);
	fulldir = _tmp3_;
	_tmp4_ = fulldir;
	if (_tmp4_ == NULL) {
		gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp5_ = data_object_to_string ((DataObject*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->priv->_camera_name;
		g_warning ("ImportPage.vala:86: Skipping deleting %s from %s: invalid folder name", _tmp6_, _tmp7_);
		_g_free0 (_tmp6_);
		_tmp8_ = DATA_SOURCE_CLASS (import_source_parent_class)->internal_delete_backing ((DataSource*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp9_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_free0 (fulldir);
			return _tmp9_;
		}
		result = _tmp8_;
		_g_free0 (fulldir);
		return result;
	}
	_tmp10_ = self->priv->_camera;
	_tmp11_ = fulldir;
	_tmp12_ = self->priv->_filename;
	_tmp13_ = import_page_spin_idle_context;
	_tmp14_ = ((GPContextWrapper*) _tmp13_)->context;
	_result_ = gp_camera_file_delete (_tmp10_, _tmp11_, _tmp12_, _tmp14_);
	if (_result_ != GP_OK) {
		gchar* _tmp15_;
		gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp15_ = data_object_to_string ((DataObject*) self);
		_tmp16_ = _tmp15_;
		_tmp17_ = self->priv->_camera_name;
		_tmp18_ = gp_result_to_full_string (_result_);
		_tmp19_ = _tmp18_;
		g_warning ("ImportPage.vala:94: Error deleting %s from %s: %s", _tmp16_, _tmp17_, _tmp19_);
		_g_free0 (_tmp19_);
		_g_free0 (_tmp16_);
	}
	_tmp21_ = DATA_SOURCE_CLASS (import_source_parent_class)->internal_delete_backing ((DataSource*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp22_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (fulldir);
		return _tmp22_;
	}
	if (_tmp21_) {
		_tmp20_ = _result_ == GP_OK;
	} else {
		_tmp20_ = FALSE;
	}
	result = _tmp20_;
	_g_free0 (fulldir);
	return result;
}

static const gchar*
import_source_real_get_indexable_keywords (Indexable* base)
{
	ImportSource * self;
	const gchar* _tmp0_;
	const gchar* result;
	self = (ImportSource*) base;
	_tmp0_ = self->priv->indexable_keywords;
	result = _tmp0_;
	return result;
}

Camera*
import_source_get_camera (ImportSource* self)
{
	Camera* result;
	Camera* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_camera;
	result = _tmp0_;
	return result;
}

static gpointer
_GPHOTO_REF_CAMERA0 (gpointer self)
{
	return self ? GPHOTO_REF_CAMERA (self) : NULL;
}

static void
import_source_set_camera (ImportSource* self,
                          Camera* value)
{
	Camera* old_value;
	g_return_if_fail (self != NULL);
	old_value = import_source_get_camera (self);
	if (old_value != value) {
		Camera* _tmp0_;
		_tmp0_ = _GPHOTO_REF_CAMERA0 (value);
		_gp_camera_unref0 (self->priv->_camera);
		self->priv->_camera = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, import_source_properties[IMPORT_SOURCE_CAMERA_PROPERTY]);
	}
}

gint
import_source_get_fsid (ImportSource* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_fsid;
	return result;
}

static void
import_source_set_fsid (ImportSource* self,
                        gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = import_source_get_fsid (self);
	if (old_value != value) {
		self->priv->_fsid = value;
		g_object_notify_by_pspec ((GObject *) self, import_source_properties[IMPORT_SOURCE_FSID_PROPERTY]);
	}
}

const gchar*
import_source_get_camera_name (ImportSource* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_camera_name;
	result = _tmp0_;
	return result;
}

static void
import_source_set_camera_name (ImportSource* self,
                               const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = import_source_get_camera_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_camera_name);
		self->priv->_camera_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, import_source_properties[IMPORT_SOURCE_CAMERA_NAME_PROPERTY]);
	}
}

const gchar*
import_source_get_filename (ImportSource* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_filename;
	result = _tmp0_;
	return result;
}

static void
import_source_set_filename (ImportSource* self,
                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = import_source_get_filename (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_filename);
		self->priv->_filename = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, import_source_properties[IMPORT_SOURCE_FILENAME_PROPERTY]);
	}
}

const gchar*
import_source_get_folder (ImportSource* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_folder;
	result = _tmp0_;
	return result;
}

static void
import_source_set_folder (ImportSource* self,
                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = import_source_get_folder (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_folder);
		self->priv->_folder = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, import_source_properties[IMPORT_SOURCE_FOLDER_PROPERTY]);
	}
}

gulong
import_source_get_file_size (ImportSource* self)
{
	gulong result;
	g_return_val_if_fail (self != NULL, 0UL);
	result = self->priv->_file_size;
	return result;
}

static void
import_source_set_file_size (ImportSource* self,
                             gulong value)
{
	gulong old_value;
	g_return_if_fail (self != NULL);
	old_value = import_source_get_file_size (self);
	if (old_value != value) {
		self->priv->_file_size = value;
		g_object_notify_by_pspec ((GObject *) self, import_source_properties[IMPORT_SOURCE_FILE_SIZE_PROPERTY]);
	}
}

static void
import_source_class_init (ImportSourceClass * klass,
                          gpointer klass_data)
{
	import_source_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ImportSource_private_offset);
	((ImportSourceClass *) klass)->get_preview = (GdkPixbuf* (*) (ImportSource*)) import_source_real_get_preview;
	((ImportSourceClass *) klass)->get_exposure_time = (gint64 (*) (ImportSource*)) import_source_real_get_exposure_time;
	((DataObjectClass *) klass)->to_string = (gchar* (*) (DataObject*)) import_source_real_to_string;
	((DataSourceClass *) klass)->internal_delete_backing = (gboolean (*) (DataSource*, GError**)) import_source_real_internal_delete_backing;
	G_OBJECT_CLASS (klass)->get_property = _vala_import_source_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_import_source_set_property;
	G_OBJECT_CLASS (klass)->finalize = import_source_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), IMPORT_SOURCE_CAMERA_PROPERTY, import_source_properties[IMPORT_SOURCE_CAMERA_PROPERTY] = g_param_spec_pointer ("camera", "camera", "camera", G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), IMPORT_SOURCE_FSID_PROPERTY, import_source_properties[IMPORT_SOURCE_FSID_PROPERTY] = g_param_spec_int ("fsid", "fsid", "fsid", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), IMPORT_SOURCE_CAMERA_NAME_PROPERTY, import_source_properties[IMPORT_SOURCE_CAMERA_NAME_PROPERTY] = g_param_spec_string ("camera-name", "camera-name", "camera-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), IMPORT_SOURCE_FILENAME_PROPERTY, import_source_properties[IMPORT_SOURCE_FILENAME_PROPERTY] = g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), IMPORT_SOURCE_FOLDER_PROPERTY, import_source_properties[IMPORT_SOURCE_FOLDER_PROPERTY] = g_param_spec_string ("folder", "folder", "folder", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), IMPORT_SOURCE_FILE_SIZE_PROPERTY, import_source_properties[IMPORT_SOURCE_FILE_SIZE_PROPERTY] = g_param_spec_ulong ("file-size", "file-size", "file-size", 0, G_MAXULONG, 0UL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
import_source_indexable_interface_init (IndexableIface * iface,
                                        gpointer iface_data)
{
	import_source_indexable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_indexable_keywords = (const gchar* (*) (Indexable*)) import_source_real_get_indexable_keywords;
}

static void
import_source_instance_init (ImportSource * self,
                             gpointer klass)
{
	self->priv = import_source_get_instance_private (self);
	self->priv->preview = NULL;
	self->priv->indexable_keywords = NULL;
}

static void
import_source_finalize (GObject * obj)
{
	ImportSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_IMPORT_SOURCE, ImportSource);
	_gp_camera_unref0 (self->priv->_camera);
	_g_free0 (self->priv->_camera_name);
	_g_free0 (self->priv->_filename);
	_g_free0 (self->priv->_folder);
	_g_object_unref0 (self->priv->preview);
	_g_free0 (self->priv->indexable_keywords);
	G_OBJECT_CLASS (import_source_parent_class)->finalize (obj);
}

static GType
import_source_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ImportSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) import_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ImportSource), 0, (GInstanceInitFunc) import_source_instance_init, NULL };
	static const GInterfaceInfo indexable_info = { (GInterfaceInitFunc) import_source_indexable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType import_source_type_id;
	import_source_type_id = g_type_register_static (TYPE_THUMBNAIL_SOURCE, "ImportSource", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (import_source_type_id, TYPE_INDEXABLE, &indexable_info);
	ImportSource_private_offset = g_type_add_instance_private (import_source_type_id, sizeof (ImportSourcePrivate));
	return import_source_type_id;
}

GType
import_source_get_type (void)
{
	static volatile gsize import_source_type_id__once = 0;
	if (g_once_init_enter (&import_source_type_id__once)) {
		GType import_source_type_id;
		import_source_type_id = import_source_get_type_once ();
		g_once_init_leave (&import_source_type_id__once, import_source_type_id);
	}
	return import_source_type_id__once;
}

static void
_vala_import_source_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	ImportSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_IMPORT_SOURCE, ImportSource);
	switch (property_id) {
		case IMPORT_SOURCE_CAMERA_PROPERTY:
		g_value_set_pointer (value, import_source_get_camera (self));
		break;
		case IMPORT_SOURCE_FSID_PROPERTY:
		g_value_set_int (value, import_source_get_fsid (self));
		break;
		case IMPORT_SOURCE_CAMERA_NAME_PROPERTY:
		g_value_set_string (value, import_source_get_camera_name (self));
		break;
		case IMPORT_SOURCE_FILENAME_PROPERTY:
		g_value_set_string (value, import_source_get_filename (self));
		break;
		case IMPORT_SOURCE_FOLDER_PROPERTY:
		g_value_set_string (value, import_source_get_folder (self));
		break;
		case IMPORT_SOURCE_FILE_SIZE_PROPERTY:
		g_value_set_ulong (value, import_source_get_file_size (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_import_source_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	ImportSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_IMPORT_SOURCE, ImportSource);
	switch (property_id) {
		case IMPORT_SOURCE_CAMERA_PROPERTY:
		import_source_set_camera (self, g_value_get_pointer (value));
		break;
		case IMPORT_SOURCE_FSID_PROPERTY:
		import_source_set_fsid (self, g_value_get_int (value));
		break;
		case IMPORT_SOURCE_CAMERA_NAME_PROPERTY:
		import_source_set_camera_name (self, g_value_get_string (value));
		break;
		case IMPORT_SOURCE_FILENAME_PROPERTY:
		import_source_set_filename (self, g_value_get_string (value));
		break;
		case IMPORT_SOURCE_FOLDER_PROPERTY:
		import_source_set_folder (self, g_value_get_string (value));
		break;
		case IMPORT_SOURCE_FILE_SIZE_PROPERTY:
		import_source_set_file_size (self, g_value_get_ulong (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

VideoImportSource*
video_import_source_construct (GType object_type,
                               const gchar* camera_name,
                               Camera* camera,
                               gint fsid,
                               const gchar* folder,
                               const gchar* filename,
                               gulong file_size,
                               gint64 modification_time)
{
	VideoImportSource * self = NULL;
	g_return_val_if_fail (camera_name != NULL, NULL);
	g_return_val_if_fail (camera != NULL, NULL);
	g_return_val_if_fail (folder != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	self = (VideoImportSource*) import_source_construct (object_type, camera_name, camera, fsid, folder, filename, file_size, modification_time);
	return self;
}

VideoImportSource*
video_import_source_new (const gchar* camera_name,
                         Camera* camera,
                         gint fsid,
                         const gchar* folder,
                         const gchar* filename,
                         gulong file_size,
                         gint64 modification_time)
{
	return video_import_source_construct (TYPE_VIDEO_IMPORT_SOURCE, camera_name, camera, fsid, folder, filename, file_size, modification_time);
}

static GdkPixbuf*
video_import_source_real_get_thumbnail (ThumbnailSource* base,
                                        gint scale,
                                        GError** error)
{
	VideoImportSource * self;
	GdkPixbuf* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	self = (VideoImportSource*) base;
	_tmp1_ = thumbnail_source_create_thumbnail ((ThumbnailSource*) self, scale, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp2_;
	_g_object_unref0 (_tmp0_);
	return result;
}

static GdkPixbuf*
video_import_source_real_create_thumbnail (ThumbnailSource* base,
                                           gint scale,
                                           GError** error)
{
	VideoImportSource * self;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	gboolean _tmp2_;
	GdkPixbuf* _tmp3_ = NULL;
	GdkPixbuf* result;
	self = (VideoImportSource*) base;
	_tmp0_ = import_source_get_preview ((ImportSource*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ == NULL;
	_g_object_unref0 (_tmp1_);
	if (_tmp2_) {
		result = NULL;
		return result;
	}
	if (scale > 0) {
		GdkPixbuf* _tmp4_;
		GdkPixbuf* _tmp5_;
		GdkPixbuf* _tmp6_;
		_tmp4_ = import_source_get_preview ((ImportSource*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = scale_pixbuf (_tmp5_, scale, GDK_INTERP_BILINEAR, TRUE);
		_g_object_unref0 (_tmp3_);
		_tmp3_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
	} else {
		GdkPixbuf* _tmp7_;
		_tmp7_ = import_source_get_preview ((ImportSource*) self);
		_g_object_unref0 (_tmp3_);
		_tmp3_ = _tmp7_;
	}
	result = _tmp3_;
	return result;
}

static gchar*
video_import_source_real_get_typename (DataSource* base)
{
	VideoImportSource * self;
	gchar* _tmp0_;
	gchar* result;
	self = (VideoImportSource*) base;
	_tmp0_ = g_strdup ("videoimport");
	result = _tmp0_;
	return result;
}

static gint64
video_import_source_real_get_instance_id (DataSource* base)
{
	VideoImportSource * self;
	gint64 result;
	self = (VideoImportSource*) base;
	result = data_object_get_object_id ((DataObject*) self);
	return result;
}

static PhotoFileFormat
video_import_source_real_get_preferred_thumbnail_format (ThumbnailSource* base)
{
	VideoImportSource * self;
	PhotoFileFormat result;
	self = (VideoImportSource*) base;
	result = photo_file_format_get_system_default_format ();
	return result;
}

static gchar*
video_import_source_real_get_name (DataObject* base)
{
	VideoImportSource * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	self = (VideoImportSource*) base;
	_tmp0_ = import_source_get_filename ((ImportSource*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

void
video_import_source_update (VideoImportSource* self,
                            GdkPixbuf* preview)
{
	GdkPixbuf* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	if (preview != NULL) {
		GdkPixbuf* _tmp1_;
		_tmp1_ = _g_object_ref0 (preview);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		GdkPixbuf* _tmp2_;
		_tmp2_ = resources_get_noninterpretable_badge_pixbuf ();
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	import_source_set_preview ((ImportSource*) self, _tmp0_);
	_g_object_unref0 (_tmp0_);
}

static void
video_import_source_class_init (VideoImportSourceClass * klass,
                                gpointer klass_data)
{
	video_import_source_parent_class = g_type_class_peek_parent (klass);
	((ThumbnailSourceClass *) klass)->get_thumbnail = (GdkPixbuf* (*) (ThumbnailSource*, gint, GError**)) video_import_source_real_get_thumbnail;
	((ThumbnailSourceClass *) klass)->create_thumbnail = (GdkPixbuf* (*) (ThumbnailSource*, gint, GError**)) video_import_source_real_create_thumbnail;
	((DataSourceClass *) klass)->get_typename = (gchar* (*) (DataSource*)) video_import_source_real_get_typename;
	((DataSourceClass *) klass)->get_instance_id = (gint64 (*) (DataSource*)) video_import_source_real_get_instance_id;
	((ThumbnailSourceClass *) klass)->get_preferred_thumbnail_format = (PhotoFileFormat (*) (ThumbnailSource*)) video_import_source_real_get_preferred_thumbnail_format;
	((DataObjectClass *) klass)->get_name = (gchar* (*) (DataObject*)) video_import_source_real_get_name;
}

static void
video_import_source_instance_init (VideoImportSource * self,
                                   gpointer klass)
{
}

static GType
video_import_source_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (VideoImportSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_import_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoImportSource), 0, (GInstanceInitFunc) video_import_source_instance_init, NULL };
	GType video_import_source_type_id;
	video_import_source_type_id = g_type_register_static (TYPE_IMPORT_SOURCE, "VideoImportSource", &g_define_type_info, 0);
	return video_import_source_type_id;
}

GType
video_import_source_get_type (void)
{
	static volatile gsize video_import_source_type_id__once = 0;
	if (g_once_init_enter (&video_import_source_type_id__once)) {
		GType video_import_source_type_id;
		video_import_source_type_id = video_import_source_get_type_once ();
		g_once_init_leave (&video_import_source_type_id__once, video_import_source_type_id);
	}
	return video_import_source_type_id__once;
}

static inline gpointer
photo_import_source_get_instance_private (PhotoImportSource* self)
{
	return G_STRUCT_MEMBER_P (self, PhotoImportSource_private_offset);
}

PhotoImportSource*
photo_import_source_construct (GType object_type,
                               const gchar* camera_name,
                               Camera* camera,
                               gint fsid,
                               const gchar* folder,
                               const gchar* filename,
                               gulong file_size,
                               gint64 modification_time,
                               PhotoFileFormat file_format)
{
	PhotoImportSource * self = NULL;
	g_return_val_if_fail (camera_name != NULL, NULL);
	g_return_val_if_fail (camera != NULL, NULL);
	g_return_val_if_fail (folder != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	self = (PhotoImportSource*) import_source_construct (object_type, camera_name, camera, fsid, folder, filename, file_size, modification_time);
	self->priv->file_format = file_format;
	return self;
}

PhotoImportSource*
photo_import_source_new (const gchar* camera_name,
                         Camera* camera,
                         gint fsid,
                         const gchar* folder,
                         const gchar* filename,
                         gulong file_size,
                         gint64 modification_time,
                         PhotoFileFormat file_format)
{
	return photo_import_source_construct (TYPE_PHOTO_IMPORT_SOURCE, camera_name, camera, fsid, folder, filename, file_size, modification_time, file_format);
}

static gchar*
photo_import_source_real_get_name (DataObject* base)
{
	PhotoImportSource * self;
	gchar* title = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	gchar* _tmp6_;
	gchar* result;
	self = (PhotoImportSource*) base;
	_tmp0_ = photo_import_source_get_title (self);
	title = _tmp0_;
	_tmp2_ = title;
	if (!is_string_empty (_tmp2_)) {
		const gchar* _tmp3_;
		_tmp3_ = title;
		_tmp1_ = _tmp3_;
	} else {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = import_source_get_filename ((ImportSource*) self);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_;
	}
	_tmp6_ = g_strdup (_tmp1_);
	result = _tmp6_;
	_g_free0 (title);
	return result;
}

static gchar*
photo_import_source_real_get_typename (DataSource* base)
{
	PhotoImportSource * self;
	gchar* _tmp0_;
	gchar* result;
	self = (PhotoImportSource*) base;
	_tmp0_ = g_strdup ("photoimport");
	result = _tmp0_;
	return result;
}

static gint64
photo_import_source_real_get_instance_id (DataSource* base)
{
	PhotoImportSource * self;
	gint64 result;
	self = (PhotoImportSource*) base;
	result = data_object_get_object_id ((DataObject*) self);
	return result;
}

static PhotoFileFormat
photo_import_source_real_get_preferred_thumbnail_format (ThumbnailSource* base)
{
	PhotoImportSource * self;
	PhotoFileFormat _tmp0_ = 0;
	PhotoFileFormat result;
	self = (PhotoImportSource*) base;
	if (photo_file_format_can_write (self->priv->file_format)) {
		_tmp0_ = self->priv->file_format;
	} else {
		_tmp0_ = photo_file_format_get_system_default_format ();
	}
	result = _tmp0_;
	return result;
}

static GdkPixbuf*
photo_import_source_real_create_thumbnail (ThumbnailSource* base,
                                           gint scale,
                                           GError** error)
{
	PhotoImportSource * self;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	gboolean _tmp2_;
	GdkPixbuf* _tmp3_ = NULL;
	GdkPixbuf* result;
	self = (PhotoImportSource*) base;
	_tmp0_ = import_source_get_preview ((ImportSource*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ == NULL;
	_g_object_unref0 (_tmp1_);
	if (_tmp2_) {
		result = NULL;
		return result;
	}
	if (scale > 0) {
		GdkPixbuf* _tmp4_;
		GdkPixbuf* _tmp5_;
		GdkPixbuf* _tmp6_;
		_tmp4_ = import_source_get_preview ((ImportSource*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = scale_pixbuf (_tmp5_, scale, PHOTO_IMPORT_SOURCE_INTERP, TRUE);
		_g_object_unref0 (_tmp3_);
		_tmp3_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
	} else {
		GdkPixbuf* _tmp7_;
		_tmp7_ = import_source_get_preview ((ImportSource*) self);
		_g_object_unref0 (_tmp3_);
		_tmp3_ = _tmp7_;
	}
	result = _tmp3_;
	return result;
}

static gpointer
_media_metadata_ref0 (gpointer self)
{
	return self ? media_metadata_ref (self) : NULL;
}

void
photo_import_source_update (PhotoImportSource* self,
                            GdkPixbuf* preview,
                            const gchar* preview_md5,
                            PhotoMetadata* metadata,
                            const gchar* exif_md5)
{
	gchar* _tmp0_;
	PhotoMetadata* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	import_source_set_preview ((ImportSource*) self, preview);
	_tmp0_ = g_strdup (preview_md5);
	_g_free0 (self->priv->preview_md5);
	self->priv->preview_md5 = _tmp0_;
	_tmp1_ = _media_metadata_ref0 (metadata);
	_media_metadata_unref0 (self->priv->metadata);
	self->priv->metadata = _tmp1_;
	_tmp2_ = g_strdup (exif_md5);
	_g_free0 (self->priv->exif_md5);
	self->priv->exif_md5 = _tmp2_;
}

static gint64
photo_import_source_real_get_exposure_time (ImportSource* base)
{
	PhotoImportSource * self;
	PhotoMetadata* _tmp0_;
	MetadataDateTime* date_time = NULL;
	PhotoMetadata* _tmp1_;
	MetadataDateTime* _tmp2_;
	gint64 _tmp3_ = 0LL;
	MetadataDateTime* _tmp4_;
	gint64 result;
	self = (PhotoImportSource*) base;
	_tmp0_ = self->priv->metadata;
	if (_tmp0_ == NULL) {
		result = import_source_get_modification_time ((ImportSource*) self);
		return result;
	}
	_tmp1_ = self->priv->metadata;
	_tmp2_ = photo_metadata_get_exposure_date_time (_tmp1_);
	date_time = _tmp2_;
	_tmp4_ = date_time;
	if (_tmp4_ != NULL) {
		MetadataDateTime* _tmp5_;
		_tmp5_ = date_time;
		_tmp3_ = metadata_date_time_get_timestamp (_tmp5_);
	} else {
		_tmp3_ = import_source_get_modification_time ((ImportSource*) self);
	}
	result = _tmp3_;
	_metadata_date_time_unref0 (date_time);
	return result;
}

gchar*
photo_import_source_get_title (PhotoImportSource* self)
{
	gchar* _tmp0_ = NULL;
	PhotoMetadata* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->metadata;
	if (_tmp1_ != NULL) {
		PhotoMetadata* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->metadata;
		_tmp3_ = media_metadata_get_title ((MediaMetadata*) _tmp2_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		_g_free0 (_tmp0_);
		_tmp0_ = NULL;
	}
	result = _tmp0_;
	return result;
}

PhotoMetadata*
photo_import_source_get_metadata (PhotoImportSource* self)
{
	PhotoImportSource* _tmp0_;
	PhotoMetadata* _tmp3_;
	PhotoMetadata* _tmp4_;
	PhotoMetadata* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->associated;
	if (_tmp0_ != NULL) {
		PhotoImportSource* _tmp1_;
		PhotoMetadata* _tmp2_;
		_tmp1_ = self->priv->associated;
		_tmp2_ = photo_import_source_get_metadata (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = self->priv->metadata;
	_tmp4_ = _media_metadata_ref0 (_tmp3_);
	result = _tmp4_;
	return result;
}

static GdkPixbuf*
photo_import_source_real_get_preview (ImportSource* base)
{
	PhotoImportSource * self;
	PhotoImportSource* _tmp0_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
	gboolean _tmp5_;
	GdkPixbuf* result;
	self = (PhotoImportSource*) base;
	_tmp0_ = self->priv->associated;
	if (_tmp0_ != NULL) {
		PhotoImportSource* _tmp1_;
		GdkPixbuf* _tmp2_;
		_tmp1_ = self->priv->associated;
		_tmp2_ = import_source_get_preview ((ImportSource*) _tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = IMPORT_SOURCE_CLASS (photo_import_source_parent_class)->get_preview (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IMPORT_SOURCE, ImportSource));
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_ != NULL;
	_g_object_unref0 (_tmp4_);
	if (_tmp5_) {
		GdkPixbuf* _tmp6_;
		_tmp6_ = IMPORT_SOURCE_CLASS (photo_import_source_parent_class)->get_preview (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IMPORT_SOURCE, ImportSource));
		result = _tmp6_;
		return result;
	}
	result = NULL;
	return result;
}

static GdkPixbuf*
photo_import_source_real_get_thumbnail (ThumbnailSource* base,
                                        gint scale,
                                        GError** error)
{
	PhotoImportSource * self;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	gboolean _tmp2_;
	GdkPixbuf* _tmp3_ = NULL;
	GdkPixbuf* result;
	self = (PhotoImportSource*) base;
	_tmp0_ = import_source_get_preview ((ImportSource*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ == NULL;
	_g_object_unref0 (_tmp1_);
	if (_tmp2_) {
		result = NULL;
		return result;
	}
	if (scale > 0) {
		GdkPixbuf* _tmp4_;
		GdkPixbuf* _tmp5_;
		GdkPixbuf* _tmp6_;
		_tmp4_ = import_source_get_preview ((ImportSource*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = scale_pixbuf (_tmp5_, scale, PHOTO_IMPORT_SOURCE_INTERP, TRUE);
		_g_object_unref0 (_tmp3_);
		_tmp3_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
	} else {
		GdkPixbuf* _tmp7_;
		_tmp7_ = import_source_get_preview ((ImportSource*) self);
		_g_object_unref0 (_tmp3_);
		_tmp3_ = _tmp7_;
	}
	result = _tmp3_;
	return result;
}

PhotoFileFormat
photo_import_source_get_file_format (PhotoImportSource* self)
{
	PhotoFileFormat result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->file_format;
	return result;
}

gchar*
photo_import_source_get_preview_md5 (PhotoImportSource* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->preview_md5;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

void
photo_import_source_set_associated (PhotoImportSource* self,
                                    PhotoImportSource* associated)
{
	PhotoImportSource* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (associated);
	_g_object_unref0 (self->priv->associated);
	self->priv->associated = _tmp0_;
}

PhotoImportSource*
photo_import_source_get_associated (PhotoImportSource* self)
{
	PhotoImportSource* _tmp0_;
	PhotoImportSource* _tmp1_;
	PhotoImportSource* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->associated;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static gboolean
photo_import_source_real_internal_delete_backing (DataSource* base,
                                                  GError** error)
{
	PhotoImportSource * self;
	gboolean ret = FALSE;
	PhotoImportSource* _tmp1_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (PhotoImportSource*) base;
	ret = DATA_SOURCE_CLASS (photo_import_source_parent_class)->internal_delete_backing ((DataSource*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IMPORT_SOURCE, ImportSource), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp0_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp0_;
	}
	_tmp1_ = self->priv->associated;
	if (_tmp1_ != NULL) {
		gboolean _tmp2_ = FALSE;
		PhotoImportSource* _tmp3_;
		_tmp3_ = self->priv->associated;
		_tmp2_ = data_source_internal_delete_backing ((DataSource*) _tmp3_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp4_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			return _tmp4_;
		}
		ret &= _tmp2_;
	}
	result = ret;
	return result;
}

static void
photo_import_source_class_init (PhotoImportSourceClass * klass,
                                gpointer klass_data)
{
	photo_import_source_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PhotoImportSource_private_offset);
	((DataObjectClass *) klass)->get_name = (gchar* (*) (DataObject*)) photo_import_source_real_get_name;
	((DataSourceClass *) klass)->get_typename = (gchar* (*) (DataSource*)) photo_import_source_real_get_typename;
	((DataSourceClass *) klass)->get_instance_id = (gint64 (*) (DataSource*)) photo_import_source_real_get_instance_id;
	((ThumbnailSourceClass *) klass)->get_preferred_thumbnail_format = (PhotoFileFormat (*) (ThumbnailSource*)) photo_import_source_real_get_preferred_thumbnail_format;
	((ThumbnailSourceClass *) klass)->create_thumbnail = (GdkPixbuf* (*) (ThumbnailSource*, gint, GError**)) photo_import_source_real_create_thumbnail;
	((ImportSourceClass *) klass)->get_exposure_time = (gint64 (*) (ImportSource*)) photo_import_source_real_get_exposure_time;
	((ImportSourceClass *) klass)->get_preview = (GdkPixbuf* (*) (ImportSource*)) photo_import_source_real_get_preview;
	((ThumbnailSourceClass *) klass)->get_thumbnail = (GdkPixbuf* (*) (ThumbnailSource*, gint, GError**)) photo_import_source_real_get_thumbnail;
	((DataSourceClass *) klass)->internal_delete_backing = (gboolean (*) (DataSource*, GError**)) photo_import_source_real_internal_delete_backing;
	G_OBJECT_CLASS (klass)->finalize = photo_import_source_finalize;
}

static void
photo_import_source_instance_init (PhotoImportSource * self,
                                   gpointer klass)
{
	self->priv = photo_import_source_get_instance_private (self);
	self->priv->preview_md5 = NULL;
	self->priv->metadata = NULL;
	self->priv->exif_md5 = NULL;
	self->priv->associated = NULL;
}

static void
photo_import_source_finalize (GObject * obj)
{
	PhotoImportSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_IMPORT_SOURCE, PhotoImportSource);
	_g_free0 (self->priv->preview_md5);
	_media_metadata_unref0 (self->priv->metadata);
	_g_free0 (self->priv->exif_md5);
	_g_object_unref0 (self->priv->associated);
	G_OBJECT_CLASS (photo_import_source_parent_class)->finalize (obj);
}

static GType
photo_import_source_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PhotoImportSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_import_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoImportSource), 0, (GInstanceInitFunc) photo_import_source_instance_init, NULL };
	GType photo_import_source_type_id;
	photo_import_source_type_id = g_type_register_static (TYPE_IMPORT_SOURCE, "PhotoImportSource", &g_define_type_info, 0);
	PhotoImportSource_private_offset = g_type_add_instance_private (photo_import_source_type_id, sizeof (PhotoImportSourcePrivate));
	return photo_import_source_type_id;
}

GType
photo_import_source_get_type (void)
{
	static volatile gsize photo_import_source_type_id__once = 0;
	if (g_once_init_enter (&photo_import_source_type_id__once)) {
		GType photo_import_source_type_id;
		photo_import_source_type_id = photo_import_source_get_type_once ();
		g_once_init_leave (&photo_import_source_type_id__once, photo_import_source_type_id);
	}
	return photo_import_source_type_id__once;
}

static inline gpointer
import_preview_get_instance_private (ImportPreview* self)
{
	return G_STRUCT_MEMBER_P (self, ImportPreview_private_offset);
}

ImportPreview*
import_preview_construct (GType object_type,
                          ImportSource* source)
{
	ImportPreview * self = NULL;
	Dimensions _tmp0_ = {0};
	gchar* _tmp1_;
	gchar* _tmp2_;
	GdkPixbuf* pixbuf = NULL;
	gboolean using_placeholder = FALSE;
	GdkPixbuf* _tmp10_;
	GdkPixbuf* _tmp11_;
	gboolean _tmp18_ = FALSE;
	GdkPixbuf* _tmp19_;
	GdkPixbuf* _tmp39_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (source != NULL, NULL);
	dimensions_init (&_tmp0_, 0, 0);
	_tmp1_ = data_object_get_name ((DataObject*) source);
	_tmp2_ = _tmp1_;
	self = (ImportPreview*) checkerboard_item_construct (object_type, (ThumbnailSource*) source, &_tmp0_, _tmp2_, NULL, FALSE, PANGO_ALIGN_LEFT);
	_g_free0 (_tmp2_);
	_g_object_unref0 (self->priv->duplicated_file);
	self->priv->duplicated_file = NULL;
	pixbuf = NULL;
	{
		GdkPixbuf* _tmp3_ = NULL;
		GdkPixbuf* _tmp4_;
		GdkPixbuf* _tmp5_;
		_tmp4_ = thumbnail_source_get_thumbnail ((ThumbnailSource*) source, 0, &_inner_error0_);
		_tmp3_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp3_;
		_tmp3_ = NULL;
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp5_;
		_g_object_unref0 (_tmp3_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GError* _tmp8_;
		const gchar* _tmp9_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = data_object_to_string ((DataObject*) self);
		_tmp7_ = _tmp6_;
		_tmp8_ = err;
		_tmp9_ = _tmp8_->message;
		g_warning ("ImportPage.vala:274: Unable to fetch loaded import preview for %s: %s", _tmp7_, _tmp9_);
		_g_free0 (_tmp7_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (pixbuf);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp10_ = pixbuf;
	using_placeholder = _tmp10_ == NULL;
	_tmp11_ = pixbuf;
	if (_tmp11_ == NULL) {
		GdkPixbuf* _tmp12_;
		GdkPixbuf* _tmp16_;
		GdkPixbuf* _tmp17_;
		_tmp12_ = import_preview_placeholder_preview;
		if (_tmp12_ == NULL) {
			GdkPixbuf* _tmp13_;
			GdkPixbuf* _tmp14_;
			GdkPixbuf* _tmp15_;
			_tmp13_ = import_preview_get_placeholder_pixbuf (self);
			_g_object_unref0 (import_preview_placeholder_preview);
			import_preview_placeholder_preview = _tmp13_;
			_tmp14_ = import_preview_placeholder_preview;
			_tmp15_ = scale_pixbuf (_tmp14_, IMPORT_PREVIEW_MAX_SCALE, GDK_INTERP_BILINEAR, TRUE);
			_g_object_unref0 (import_preview_placeholder_preview);
			import_preview_placeholder_preview = _tmp15_;
		}
		_tmp16_ = import_preview_placeholder_preview;
		_tmp17_ = _g_object_ref0 (_tmp16_);
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp17_;
	}
	_tmp19_ = pixbuf;
	if (gdk_pixbuf_get_width (_tmp19_) > IMPORT_PREVIEW_MAX_SCALE) {
		_tmp18_ = TRUE;
	} else {
		GdkPixbuf* _tmp20_;
		_tmp20_ = pixbuf;
		_tmp18_ = gdk_pixbuf_get_height (_tmp20_) > IMPORT_PREVIEW_MAX_SCALE;
	}
	if (_tmp18_) {
		GdkPixbuf* _tmp21_;
		GdkPixbuf* _tmp22_;
		_tmp21_ = pixbuf;
		_tmp22_ = scale_pixbuf (_tmp21_, IMPORT_PREVIEW_MAX_SCALE, PHOTO_IMPORT_SOURCE_INTERP, FALSE);
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp22_;
	}
	if (IS_PHOTO_IMPORT_SOURCE (source)) {
		PhotoImportSource* photo_import_source = NULL;
		PhotoImportSource* _tmp23_;
		gboolean _tmp24_ = FALSE;
		PhotoImportSource* _tmp33_;
		PhotoImportSource* _tmp34_;
		PhotoImportSource* _tmp35_;
		gboolean _tmp36_;
		_tmp23_ = _g_object_ref0 (IS_PHOTO_IMPORT_SOURCE (source) ? ((PhotoImportSource*) source) : NULL);
		photo_import_source = _tmp23_;
		if (!using_placeholder) {
			PhotoImportSource* _tmp25_;
			PhotoMetadata* _tmp26_;
			PhotoMetadata* _tmp27_;
			_tmp25_ = photo_import_source;
			_tmp26_ = photo_import_source_get_metadata (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp24_ = _tmp27_ != NULL;
			_media_metadata_unref0 (_tmp27_);
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			PhotoImportSource* _tmp28_;
			PhotoMetadata* _tmp29_;
			PhotoMetadata* _tmp30_;
			GdkPixbuf* _tmp31_;
			GdkPixbuf* _tmp32_;
			_tmp28_ = photo_import_source;
			_tmp29_ = photo_import_source_get_metadata (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = pixbuf;
			_tmp32_ = orientation_rotate_pixbuf (photo_metadata_get_orientation (_tmp30_), _tmp31_);
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp32_;
			_media_metadata_unref0 (_tmp30_);
		}
		_tmp33_ = photo_import_source;
		_tmp34_ = photo_import_source_get_associated (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = _tmp35_ != NULL;
		_g_object_unref0 (_tmp35_);
		if (_tmp36_) {
			gchar* _tmp37_;
			gchar* _tmp38_;
			_tmp37_ = g_strdup_printf ("<small>%s</small>", _ ("RAW+JPEG"));
			_tmp38_ = _tmp37_;
			checkerboard_item_set_subtitle ((CheckerboardItem*) self, _tmp38_, TRUE, PANGO_ALIGN_LEFT);
			_g_free0 (_tmp38_);
		}
		_g_object_unref0 (photo_import_source);
	}
	_tmp39_ = pixbuf;
	checkerboard_item_set_image ((CheckerboardItem*) self, _tmp39_);
	_g_object_unref0 (pixbuf);
	return self;
}

ImportPreview*
import_preview_new (ImportSource* source)
{
	return import_preview_construct (TYPE_IMPORT_PREVIEW, source);
}

static GdkPixbuf*
import_preview_get_placeholder_pixbuf (ImportPreview* self)
{
	GdkPixbuf* pixbuf = NULL;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	pixbuf = NULL;
	{
		GtkIconTheme* icon_theme = NULL;
		GtkIconTheme* _tmp0_;
		GtkIconTheme* _tmp1_;
		GdkPixbuf* _tmp2_ = NULL;
		GdkPixbuf* _tmp3_;
		GdkPixbuf* _tmp4_;
		_tmp0_ = gtk_icon_theme_get_default ();
		_tmp1_ = _g_object_ref0 (_tmp0_);
		icon_theme = _tmp1_;
		_tmp3_ = gtk_icon_theme_load_icon (icon_theme, "image-missing", 48, 0, &_inner_error0_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (icon_theme);
			goto __catch0_g_error;
		}
		_tmp4_ = _tmp2_;
		_tmp2_ = NULL;
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp4_;
		_g_object_unref0 (_tmp2_);
		_g_object_unref0 (icon_theme);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GdkPixbuf* _tmp5_;
		GdkPixbuf* _tmp6_;
		g_clear_error (&_inner_error0_);
		_tmp5_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, 48, 48);
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp5_;
		_tmp6_ = pixbuf;
		gdk_pixbuf_fill (_tmp6_, (guint32) 0);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (pixbuf);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = pixbuf;
	return result;
}

gboolean
import_preview_is_already_imported (ImportPreview* self)
{
	PhotoImportSource* photo_import_source = NULL;
	ImportSource* _tmp0_;
	PhotoImportSource* _tmp1_;
	PhotoImportSource* _tmp2_;
	VideoImportSource* video_import_source = NULL;
	ImportSource* _tmp30_;
	VideoImportSource* _tmp31_;
	VideoImportSource* _tmp32_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = import_preview_get_import_source (self);
	_tmp1_ = IS_PHOTO_IMPORT_SOURCE (_tmp0_) ? ((PhotoImportSource*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (_tmp0_);
	}
	photo_import_source = _tmp1_;
	_tmp2_ = photo_import_source;
	if (_tmp2_ != NULL) {
		gchar* preview_md5 = NULL;
		PhotoImportSource* _tmp3_;
		gchar* _tmp4_;
		PhotoFileFormat file_format = 0;
		PhotoImportSource* _tmp5_;
		gboolean _tmp6_ = FALSE;
		const gchar* _tmp7_;
		_tmp3_ = photo_import_source;
		_tmp4_ = photo_import_source_get_preview_md5 (_tmp3_);
		preview_md5 = _tmp4_;
		_tmp5_ = photo_import_source;
		file_format = photo_import_source_get_file_format (_tmp5_);
		_tmp7_ = preview_md5;
		if (!is_string_empty (_tmp7_)) {
			const gchar* _tmp8_;
			_tmp8_ = preview_md5;
			_tmp6_ = library_photo_has_nontrash_duplicate (NULL, _tmp8_, NULL, file_format);
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			const gchar* _tmp9_;
			PhotoID _tmp10_ = {0};
			DuplicatedFile* _tmp11_;
			_tmp9_ = preview_md5;
			library_photo_get_nontrash_duplicate (NULL, _tmp9_, NULL, file_format, &_tmp10_);
			_tmp11_ = duplicated_file_create_from_photo_id (&_tmp10_);
			_g_object_unref0 (self->priv->duplicated_file);
			self->priv->duplicated_file = _tmp11_;
			result = TRUE;
			_g_free0 (preview_md5);
			_g_object_unref0 (photo_import_source);
			return result;
		}
		if (file_format == PHOTO_FILE_FORMAT_RAW) {
			guint64 filesize = 0ULL;
			ImportSource* _tmp12_;
			ImportSource* _tmp13_;
			gulong _tmp14_;
			gulong _tmp15_;
			guint64 _tmp16_;
			_tmp12_ = import_preview_get_import_source (self);
			_tmp13_ = _tmp12_;
			_tmp14_ = import_source_get_file_size (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = (guint64) _tmp15_;
			_g_object_unref0 (_tmp13_);
			filesize = _tmp16_;
			if (filesize <= ((guint64) G_MAXINT64)) {
				LibraryPhotoSourceCollection* _tmp17_;
				ImportSource* _tmp18_;
				ImportSource* _tmp19_;
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				gboolean _tmp22_;
				_tmp17_ = library_photo_global;
				_tmp18_ = import_preview_get_import_source (self);
				_tmp19_ = _tmp18_;
				_tmp20_ = import_source_get_filename (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = library_photo_source_collection_has_basename_filesize_duplicate (_tmp17_, _tmp21_, (gint64) filesize);
				_g_object_unref0 (_tmp19_);
				if (_tmp22_) {
					LibraryPhotoSourceCollection* _tmp23_;
					ImportSource* _tmp24_;
					ImportSource* _tmp25_;
					const gchar* _tmp26_;
					const gchar* _tmp27_;
					PhotoID _tmp28_ = {0};
					DuplicatedFile* _tmp29_;
					_tmp23_ = library_photo_global;
					_tmp24_ = import_preview_get_import_source (self);
					_tmp25_ = _tmp24_;
					_tmp26_ = import_source_get_filename (_tmp25_);
					_tmp27_ = _tmp26_;
					library_photo_source_collection_get_basename_filesize_duplicate (_tmp23_, _tmp27_, (gint64) filesize, &_tmp28_);
					_tmp29_ = duplicated_file_create_from_photo_id (&_tmp28_);
					_g_object_unref0 (self->priv->duplicated_file);
					self->priv->duplicated_file = _tmp29_;
					_g_object_unref0 (_tmp25_);
					result = TRUE;
					_g_free0 (preview_md5);
					_g_object_unref0 (photo_import_source);
					return result;
				}
			}
		}
		result = FALSE;
		_g_free0 (preview_md5);
		_g_object_unref0 (photo_import_source);
		return result;
	}
	_tmp30_ = import_preview_get_import_source (self);
	_tmp31_ = IS_VIDEO_IMPORT_SOURCE (_tmp30_) ? ((VideoImportSource*) _tmp30_) : NULL;
	if (_tmp31_ == NULL) {
		_g_object_unref0 (_tmp30_);
	}
	video_import_source = _tmp31_;
	_tmp32_ = video_import_source;
	if (_tmp32_ != NULL) {
		VideoSourceCollection* _tmp33_;
		VideoImportSource* _tmp34_;
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		VideoImportSource* _tmp37_;
		gulong _tmp38_;
		gulong _tmp39_;
		_tmp33_ = video_global;
		_tmp34_ = video_import_source;
		_tmp35_ = import_source_get_filename ((ImportSource*) _tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = video_import_source;
		_tmp38_ = import_source_get_file_size ((ImportSource*) _tmp37_);
		_tmp39_ = _tmp38_;
		if (video_source_collection_has_basename_filesize_duplicate (_tmp33_, _tmp36_, (guint64) _tmp39_)) {
			VideoSourceCollection* _tmp40_;
			VideoImportSource* _tmp41_;
			const gchar* _tmp42_;
			const gchar* _tmp43_;
			VideoImportSource* _tmp44_;
			gulong _tmp45_;
			gulong _tmp46_;
			VideoID _tmp47_ = {0};
			DuplicatedFile* _tmp48_;
			_tmp40_ = video_global;
			_tmp41_ = video_import_source;
			_tmp42_ = import_source_get_filename ((ImportSource*) _tmp41_);
			_tmp43_ = _tmp42_;
			_tmp44_ = video_import_source;
			_tmp45_ = import_source_get_file_size ((ImportSource*) _tmp44_);
			_tmp46_ = _tmp45_;
			video_source_collection_get_basename_filesize_duplicate (_tmp40_, _tmp43_, (guint64) _tmp46_, &_tmp47_);
			_tmp48_ = duplicated_file_create_from_video_id (&_tmp47_);
			_g_object_unref0 (self->priv->duplicated_file);
			self->priv->duplicated_file = _tmp48_;
			result = TRUE;
			_g_object_unref0 (video_import_source);
			_g_object_unref0 (photo_import_source);
			return result;
		}
		result = FALSE;
		_g_object_unref0 (video_import_source);
		_g_object_unref0 (photo_import_source);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (video_import_source);
	_g_object_unref0 (photo_import_source);
	return result;
}

DuplicatedFile*
import_preview_get_duplicated_file (ImportPreview* self)
{
	DuplicatedFile* _tmp0_;
	DuplicatedFile* _tmp1_;
	DuplicatedFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (!import_preview_is_already_imported (self)) {
		result = NULL;
		return result;
	}
	_tmp0_ = self->priv->duplicated_file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

ImportSource*
import_preview_get_import_source (ImportPreview* self)
{
	DataSource* _tmp0_;
	DataSource* _tmp1_;
	ImportSource* _tmp2_;
	ImportSource* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = data_view_get_source ((DataView*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_IMPORT_SOURCE, ImportSource));
	result = _tmp2_;
	return result;
}

static void
import_preview_class_init (ImportPreviewClass * klass,
                           gpointer klass_data)
{
	import_preview_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ImportPreview_private_offset);
	G_OBJECT_CLASS (klass)->finalize = import_preview_finalize;
}

static void
import_preview_instance_init (ImportPreview * self,
                              gpointer klass)
{
	self->priv = import_preview_get_instance_private (self);
}

static void
import_preview_finalize (GObject * obj)
{
	ImportPreview * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_IMPORT_PREVIEW, ImportPreview);
	_g_object_unref0 (self->priv->duplicated_file);
	G_OBJECT_CLASS (import_preview_parent_class)->finalize (obj);
}

static GType
import_preview_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ImportPreviewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) import_preview_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ImportPreview), 0, (GInstanceInitFunc) import_preview_instance_init, NULL };
	GType import_preview_type_id;
	import_preview_type_id = g_type_register_static (TYPE_CHECKERBOARD_ITEM, "ImportPreview", &g_define_type_info, 0);
	ImportPreview_private_offset = g_type_add_instance_private (import_preview_type_id, sizeof (ImportPreviewPrivate));
	return import_preview_type_id;
}

GType
import_preview_get_type (void)
{
	static volatile gsize import_preview_type_id__once = 0;
	if (g_once_init_enter (&import_preview_type_id__once)) {
		GType import_preview_type_id;
		import_preview_type_id = import_preview_get_type_once ();
		g_once_init_leave (&import_preview_type_id__once, import_preview_type_id);
	}
	return import_preview_type_id__once;
}

CameraViewTracker*
camera_view_tracker_construct (GType object_type,
                               ViewCollection* collection)
{
	CameraViewTracker* self = NULL;
	CameraAccumulator* _tmp0_;
	CameraAccumulator* _tmp1_;
	CameraAccumulator* _tmp2_;
	g_return_val_if_fail (collection != NULL, NULL);
	self = (CameraViewTracker*) core_view_tracker_construct (object_type, collection);
	_tmp0_ = self->all;
	_tmp1_ = self->visible;
	_tmp2_ = self->selected;
	core_view_tracker_start ((CoreViewTracker*) self, (CoreTrackerAccumulator*) _tmp0_, (CoreTrackerAccumulator*) _tmp1_, (CoreTrackerAccumulator*) _tmp2_);
	return self;
}

CameraViewTracker*
camera_view_tracker_new (ViewCollection* collection)
{
	return camera_view_tracker_construct (TYPE_CAMERA_VIEW_TRACKER, collection);
}

static void
camera_view_tracker_class_init (CameraViewTrackerClass * klass,
                                gpointer klass_data)
{
	camera_view_tracker_parent_class = g_type_class_peek_parent (klass);
	((CoreTrackerClass *) klass)->finalize = camera_view_tracker_finalize;
}

static void
camera_view_tracker_instance_init (CameraViewTracker * self,
                                   gpointer klass)
{
	CameraAccumulator* _tmp0_;
	CameraAccumulator* _tmp1_;
	CameraAccumulator* _tmp2_;
	_tmp0_ = camera_accumulator_new ();
	self->all = _tmp0_;
	_tmp1_ = camera_accumulator_new ();
	self->visible = _tmp1_;
	_tmp2_ = camera_accumulator_new ();
	self->selected = _tmp2_;
}

static void
camera_view_tracker_finalize (CoreTracker * obj)
{
	CameraViewTracker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CAMERA_VIEW_TRACKER, CameraViewTracker);
	_g_object_unref0 (self->all);
	_g_object_unref0 (self->visible);
	_g_object_unref0 (self->selected);
	CORE_TRACKER_CLASS (camera_view_tracker_parent_class)->finalize (obj);
}

static GType
camera_view_tracker_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CameraViewTrackerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) camera_view_tracker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CameraViewTracker), 0, (GInstanceInitFunc) camera_view_tracker_instance_init, NULL };
	GType camera_view_tracker_type_id;
	camera_view_tracker_type_id = g_type_register_static (CORE_TYPE_VIEW_TRACKER, "CameraViewTracker", &g_define_type_info, 0);
	return camera_view_tracker_type_id;
}

GType
camera_view_tracker_get_type (void)
{
	static volatile gsize camera_view_tracker_type_id__once = 0;
	if (g_once_init_enter (&camera_view_tracker_type_id__once)) {
		GType camera_view_tracker_type_id;
		camera_view_tracker_type_id = camera_view_tracker_get_type_once ();
		g_once_init_leave (&camera_view_tracker_type_id__once, camera_view_tracker_type_id);
	}
	return camera_view_tracker_type_id__once;
}

static inline gpointer
camera_accumulator_get_instance_private (CameraAccumulator* self)
{
	return G_STRUCT_MEMBER_P (self, CameraAccumulator_private_offset);
}

static gboolean
camera_accumulator_real_include (CoreTrackerAccumulator* base,
                                 DataObject* object)
{
	CameraAccumulator * self;
	ImportSource* source = NULL;
	DataSource* _tmp0_;
	DataSource* _tmp1_;
	ImportSource* _tmp2_;
	gint _tmp3_;
	PhotoImportSource* photo = NULL;
	ImportSource* _tmp4_;
	PhotoImportSource* _tmp5_;
	gboolean _tmp6_ = FALSE;
	PhotoImportSource* _tmp7_;
	gboolean result;
	self = (CameraAccumulator*) base;
	g_return_val_if_fail (object != NULL, FALSE);
	_tmp0_ = data_view_get_source (G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DATA_VIEW, DataView));
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_IMPORT_SOURCE, ImportSource));
	source = _tmp2_;
	_tmp3_ = self->priv->_total;
	camera_accumulator_set_total (self, _tmp3_ + 1);
	_tmp4_ = source;
	_tmp5_ = _g_object_ref0 (IS_PHOTO_IMPORT_SOURCE (_tmp4_) ? ((PhotoImportSource*) _tmp4_) : NULL);
	photo = _tmp5_;
	_tmp7_ = photo;
	if (_tmp7_ != NULL) {
		PhotoImportSource* _tmp8_;
		_tmp8_ = photo;
		_tmp6_ = photo_import_source_get_file_format (_tmp8_) != PHOTO_FILE_FORMAT_RAW;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		gint _tmp9_;
		_tmp9_ = self->priv->_photos;
		camera_accumulator_set_photos (self, _tmp9_ + 1);
	} else {
		gboolean _tmp10_ = FALSE;
		PhotoImportSource* _tmp11_;
		_tmp11_ = photo;
		if (_tmp11_ != NULL) {
			PhotoImportSource* _tmp12_;
			_tmp12_ = photo;
			_tmp10_ = photo_import_source_get_file_format (_tmp12_) == PHOTO_FILE_FORMAT_RAW;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			gint _tmp13_;
			_tmp13_ = self->priv->_raw;
			camera_accumulator_set_raw (self, _tmp13_ + 1);
		} else {
			ImportSource* _tmp14_;
			_tmp14_ = source;
			if (IS_VIDEO_IMPORT_SOURCE (_tmp14_)) {
				gint _tmp15_;
				_tmp15_ = self->priv->_videos;
				camera_accumulator_set_videos (self, _tmp15_ + 1);
			}
		}
	}
	result = TRUE;
	_g_object_unref0 (photo);
	_g_object_unref0 (source);
	return result;
}

static gboolean
camera_accumulator_real_uninclude (CoreTrackerAccumulator* base,
                                   DataObject* object)
{
	CameraAccumulator * self;
	ImportSource* source = NULL;
	DataSource* _tmp0_;
	DataSource* _tmp1_;
	ImportSource* _tmp2_;
	gint _tmp3_;
	PhotoImportSource* photo = NULL;
	ImportSource* _tmp4_;
	PhotoImportSource* _tmp5_;
	gboolean _tmp6_ = FALSE;
	PhotoImportSource* _tmp7_;
	gboolean result;
	self = (CameraAccumulator*) base;
	g_return_val_if_fail (object != NULL, FALSE);
	_tmp0_ = data_view_get_source (G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DATA_VIEW, DataView));
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_IMPORT_SOURCE, ImportSource));
	source = _tmp2_;
	_tmp3_ = self->priv->_total;
	camera_accumulator_set_total (self, _tmp3_ + 1);
	_tmp4_ = source;
	_tmp5_ = _g_object_ref0 (IS_PHOTO_IMPORT_SOURCE (_tmp4_) ? ((PhotoImportSource*) _tmp4_) : NULL);
	photo = _tmp5_;
	_tmp7_ = photo;
	if (_tmp7_ != NULL) {
		PhotoImportSource* _tmp8_;
		_tmp8_ = photo;
		_tmp6_ = photo_import_source_get_file_format (_tmp8_) != PHOTO_FILE_FORMAT_RAW;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		gint _tmp9_;
		gint _tmp10_;
		_tmp9_ = self->priv->_photos;
		_vala_assert (_tmp9_ > 0, "photos > 0");
		_tmp10_ = self->priv->_photos;
		camera_accumulator_set_photos (self, _tmp10_ - 1);
	} else {
		gboolean _tmp11_ = FALSE;
		PhotoImportSource* _tmp12_;
		_tmp12_ = photo;
		if (_tmp12_ != NULL) {
			PhotoImportSource* _tmp13_;
			_tmp13_ = photo;
			_tmp11_ = photo_import_source_get_file_format (_tmp13_) == PHOTO_FILE_FORMAT_RAW;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			gint _tmp14_;
			gint _tmp15_;
			_tmp14_ = self->priv->_raw;
			_vala_assert (_tmp14_ > 0, "raw > 0");
			_tmp15_ = self->priv->_raw;
			camera_accumulator_set_raw (self, _tmp15_ - 1);
		} else {
			ImportSource* _tmp16_;
			_tmp16_ = source;
			if (IS_VIDEO_IMPORT_SOURCE (_tmp16_)) {
				gint _tmp17_;
				gint _tmp18_;
				_tmp17_ = self->priv->_videos;
				_vala_assert (_tmp17_ > 0, "videos > 0");
				_tmp18_ = self->priv->_videos;
				camera_accumulator_set_videos (self, _tmp18_ - 1);
			}
		}
	}
	result = TRUE;
	_g_object_unref0 (photo);
	_g_object_unref0 (source);
	return result;
}

static gboolean
camera_accumulator_real_altered (CoreTrackerAccumulator* base,
                                 DataObject* object,
                                 Alteration* alteration)
{
	CameraAccumulator * self;
	gboolean result;
	self = (CameraAccumulator*) base;
	g_return_val_if_fail (object != NULL, FALSE);
	g_return_val_if_fail (alteration != NULL, FALSE);
	result = FALSE;
	return result;
}

gchar*
camera_accumulator_to_string (CameraAccumulator* self)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_total;
	_tmp1_ = self->priv->_photos;
	_tmp2_ = self->priv->_videos;
	_tmp3_ = self->priv->_raw;
	_tmp4_ = g_strdup_printf ("%d total/%d photos/%d videos/%d raw", _tmp0_, _tmp1_, _tmp2_, _tmp3_);
	result = _tmp4_;
	return result;
}

CameraAccumulator*
camera_accumulator_construct (GType object_type)
{
	CameraAccumulator * self = NULL;
	self = (CameraAccumulator*) g_object_new (object_type, NULL);
	return self;
}

CameraAccumulator*
camera_accumulator_new (void)
{
	return camera_accumulator_construct (TYPE_CAMERA_ACCUMULATOR);
}

gint
camera_accumulator_get_total (CameraAccumulator* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_total;
	return result;
}

static void
camera_accumulator_set_total (CameraAccumulator* self,
                              gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = camera_accumulator_get_total (self);
	if (old_value != value) {
		self->priv->_total = value;
		g_object_notify_by_pspec ((GObject *) self, camera_accumulator_properties[CAMERA_ACCUMULATOR_TOTAL_PROPERTY]);
	}
}

gint
camera_accumulator_get_photos (CameraAccumulator* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_photos;
	return result;
}

static void
camera_accumulator_set_photos (CameraAccumulator* self,
                               gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = camera_accumulator_get_photos (self);
	if (old_value != value) {
		self->priv->_photos = value;
		g_object_notify_by_pspec ((GObject *) self, camera_accumulator_properties[CAMERA_ACCUMULATOR_PHOTOS_PROPERTY]);
	}
}

gint
camera_accumulator_get_videos (CameraAccumulator* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_videos;
	return result;
}

static void
camera_accumulator_set_videos (CameraAccumulator* self,
                               gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = camera_accumulator_get_videos (self);
	if (old_value != value) {
		self->priv->_videos = value;
		g_object_notify_by_pspec ((GObject *) self, camera_accumulator_properties[CAMERA_ACCUMULATOR_VIDEOS_PROPERTY]);
	}
}

gint
camera_accumulator_get_raw (CameraAccumulator* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_raw;
	return result;
}

static void
camera_accumulator_set_raw (CameraAccumulator* self,
                            gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = camera_accumulator_get_raw (self);
	if (old_value != value) {
		self->priv->_raw = value;
		g_object_notify_by_pspec ((GObject *) self, camera_accumulator_properties[CAMERA_ACCUMULATOR_RAW_PROPERTY]);
	}
}

static void
camera_accumulator_class_init (CameraAccumulatorClass * klass,
                               gpointer klass_data)
{
	camera_accumulator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CameraAccumulator_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_camera_accumulator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_camera_accumulator_set_property;
	G_OBJECT_CLASS (klass)->finalize = camera_accumulator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CAMERA_ACCUMULATOR_TOTAL_PROPERTY, camera_accumulator_properties[CAMERA_ACCUMULATOR_TOTAL_PROPERTY] = g_param_spec_int ("total", "total", "total", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CAMERA_ACCUMULATOR_PHOTOS_PROPERTY, camera_accumulator_properties[CAMERA_ACCUMULATOR_PHOTOS_PROPERTY] = g_param_spec_int ("photos", "photos", "photos", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CAMERA_ACCUMULATOR_VIDEOS_PROPERTY, camera_accumulator_properties[CAMERA_ACCUMULATOR_VIDEOS_PROPERTY] = g_param_spec_int ("videos", "videos", "videos", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CAMERA_ACCUMULATOR_RAW_PROPERTY, camera_accumulator_properties[CAMERA_ACCUMULATOR_RAW_PROPERTY] = g_param_spec_int ("raw", "raw", "raw", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
camera_accumulator_core_tracker_accumulator_interface_init (CoreTrackerAccumulatorIface * iface,
                                                            gpointer iface_data)
{
	camera_accumulator_core_tracker_accumulator_parent_iface = g_type_interface_peek_parent (iface);
	iface->include = (gboolean (*) (CoreTrackerAccumulator*, DataObject*)) camera_accumulator_real_include;
	iface->uninclude = (gboolean (*) (CoreTrackerAccumulator*, DataObject*)) camera_accumulator_real_uninclude;
	iface->altered = (gboolean (*) (CoreTrackerAccumulator*, DataObject*, Alteration*)) camera_accumulator_real_altered;
}

static void
camera_accumulator_instance_init (CameraAccumulator * self,
                                  gpointer klass)
{
	self->priv = camera_accumulator_get_instance_private (self);
	self->priv->_total = 0;
	self->priv->_photos = 0;
	self->priv->_videos = 0;
	self->priv->_raw = 0;
}

static void
camera_accumulator_finalize (GObject * obj)
{
	CameraAccumulator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CAMERA_ACCUMULATOR, CameraAccumulator);
	G_OBJECT_CLASS (camera_accumulator_parent_class)->finalize (obj);
}

static GType
camera_accumulator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CameraAccumulatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) camera_accumulator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CameraAccumulator), 0, (GInstanceInitFunc) camera_accumulator_instance_init, NULL };
	static const GInterfaceInfo core_tracker_accumulator_info = { (GInterfaceInitFunc) camera_accumulator_core_tracker_accumulator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType camera_accumulator_type_id;
	camera_accumulator_type_id = g_type_register_static (G_TYPE_OBJECT, "CameraAccumulator", &g_define_type_info, 0);
	g_type_add_interface_static (camera_accumulator_type_id, CORE_TYPE_TRACKER_ACCUMULATOR, &core_tracker_accumulator_info);
	CameraAccumulator_private_offset = g_type_add_instance_private (camera_accumulator_type_id, sizeof (CameraAccumulatorPrivate));
	return camera_accumulator_type_id;
}

GType
camera_accumulator_get_type (void)
{
	static volatile gsize camera_accumulator_type_id__once = 0;
	if (g_once_init_enter (&camera_accumulator_type_id__once)) {
		GType camera_accumulator_type_id;
		camera_accumulator_type_id = camera_accumulator_get_type_once ();
		g_once_init_leave (&camera_accumulator_type_id__once, camera_accumulator_type_id);
	}
	return camera_accumulator_type_id__once;
}

static void
_vala_camera_accumulator_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	CameraAccumulator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CAMERA_ACCUMULATOR, CameraAccumulator);
	switch (property_id) {
		case CAMERA_ACCUMULATOR_TOTAL_PROPERTY:
		g_value_set_int (value, camera_accumulator_get_total (self));
		break;
		case CAMERA_ACCUMULATOR_PHOTOS_PROPERTY:
		g_value_set_int (value, camera_accumulator_get_photos (self));
		break;
		case CAMERA_ACCUMULATOR_VIDEOS_PROPERTY:
		g_value_set_int (value, camera_accumulator_get_videos (self));
		break;
		case CAMERA_ACCUMULATOR_RAW_PROPERTY:
		g_value_set_int (value, camera_accumulator_get_raw (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_camera_accumulator_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	CameraAccumulator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CAMERA_ACCUMULATOR, CameraAccumulator);
	switch (property_id) {
		case CAMERA_ACCUMULATOR_TOTAL_PROPERTY:
		camera_accumulator_set_total (self, g_value_get_int (value));
		break;
		case CAMERA_ACCUMULATOR_PHOTOS_PROPERTY:
		camera_accumulator_set_photos (self, g_value_get_int (value));
		break;
		case CAMERA_ACCUMULATOR_VIDEOS_PROPERTY:
		camera_accumulator_set_videos (self, g_value_get_int (value));
		break;
		case CAMERA_ACCUMULATOR_RAW_PROPERTY:
		camera_accumulator_set_raw (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
import_page_get_instance_private (ImportPage* self)
{
	return G_STRUCT_MEMBER_P (self, ImportPage_private_offset);
}

static void
_import_page_on_media_added_removed_data_collection_contents_altered (DataCollection* _sender,
                                                                      GeeIterable* added,
                                                                      GeeIterable* removed,
                                                                      gpointer self)
{
	import_page_on_media_added_removed ((ImportPage*) self);
}

static GType
import_page_refresh_result_get_type_once (void)
{
	static const GEnumValue values[] = {{IMPORT_PAGE_REFRESH_RESULT_OK, "IMPORT_PAGE_REFRESH_RESULT_OK", "ok"}, {IMPORT_PAGE_REFRESH_RESULT_BUSY, "IMPORT_PAGE_REFRESH_RESULT_BUSY", "busy"}, {IMPORT_PAGE_REFRESH_RESULT_LOCKED, "IMPORT_PAGE_REFRESH_RESULT_LOCKED", "locked"}, {IMPORT_PAGE_REFRESH_RESULT_LIBRARY_ERROR, "IMPORT_PAGE_REFRESH_RESULT_LIBRARY_ERROR", "library-error"}, {0, NULL, NULL}};
	GType import_page_refresh_result_type_id;
	import_page_refresh_result_type_id = g_enum_register_static ("ImportPageRefreshResult", values);
	return import_page_refresh_result_type_id;
}

GType
import_page_refresh_result_get_type (void)
{
	static volatile gsize import_page_refresh_result_type_id__once = 0;
	if (g_once_init_enter (&import_page_refresh_result_type_id__once)) {
		GType import_page_refresh_result_type_id;
		import_page_refresh_result_type_id = import_page_refresh_result_get_type_once ();
		g_once_init_leave (&import_page_refresh_result_type_id__once, import_page_refresh_result_type_id);
	}
	return import_page_refresh_result_type_id__once;
}

static gint64
_import_page_preview_comparator_comparator (void* a,
                                            void* b,
                                            gpointer self)
{
	gint64 result;
	result = import_page_preview_comparator (a, b);
	return result;
}

static gboolean
_import_page_preview_comparator_predicate_comparator_predicate (DataObject* object,
                                                                Alteration* alteration,
                                                                gpointer self)
{
	gboolean result;
	result = import_page_preview_comparator_predicate (object, alteration);
	return result;
}

static void
_import_page_on_view_changed_view_collection_items_state_changed (ViewCollection* _sender,
                                                                  GeeIterable* changed,
                                                                  gpointer self)
{
	import_page_on_view_changed ((ImportPage*) self);
}

static void
_import_page_on_view_changed_data_collection_contents_altered (DataCollection* _sender,
                                                               GeeIterable* added,
                                                               GeeIterable* removed,
                                                               gpointer self)
{
	import_page_on_view_changed ((ImportPage*) self);
}

static void
_import_page_on_view_changed_view_collection_items_visibility_changed (ViewCollection* _sender,
                                                                       GeeCollection* changed,
                                                                       gpointer self)
{
	import_page_on_view_changed ((ImportPage*) self);
}

ImportPage*
import_page_construct (GType object_type,
                       Camera* camera,
                       const gchar* uri,
                       const gchar* display_name,
                       GIcon* icon)
{
	ImportPage * self = NULL;
	Camera* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	ImportSourceCollection* _tmp4_;
	GIcon* _tmp5_;
	ViewCollection* _tmp6_;
	ViewCollection* _tmp7_;
	CameraViewTracker* _tmp8_;
	GtkLabel* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	GVolumeMonitor* _tmp18_;
	GPContextWrapper* _tmp19_;
	GPSpinIdleWrapper* _tmp21_;
	ViewCollection* _tmp23_;
	ViewCollection* _tmp24_;
	SourceCollection* _tmp25_;
	ImportPageImportViewManager* _tmp26_;
	ImportPageImportViewManager* _tmp27_;
	ViewCollectionMonitor* _tmp28_;
	ViewCollectionMonitor* _tmp29_;
	ViewCollection* _tmp30_;
	ViewCollection* _tmp31_;
	ViewCollection* _tmp32_;
	ViewCollection* _tmp33_;
	ViewCollection* _tmp34_;
	ViewCollection* _tmp35_;
	ViewCollection* _tmp36_;
	ViewCollection* _tmp37_;
	ViewCollection* _tmp38_;
	ViewCollection* _tmp39_;
	GValue _tmp40_ = {0};
	LibraryPhotoSourceCollection* _tmp41_;
	VideoSourceCollection* _tmp42_;
	g_return_val_if_fail (camera != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	self = (ImportPage*) checkerboard_page_construct (object_type, _ ("Camera"));
	_tmp0_ = _GPHOTO_REF_CAMERA0 (camera);
	_gp_camera_unref0 (self->priv->camera);
	self->priv->camera = _tmp0_;
	_tmp1_ = g_strdup (uri);
	_g_free0 (self->priv->uri);
	self->priv->uri = _tmp1_;
	_tmp2_ = g_strdup_printf ("ImportSources for %s", uri);
	_tmp3_ = _tmp2_;
	_tmp4_ = import_source_collection_new (_tmp3_);
	_data_collection_unref0 (self->priv->import_sources);
	self->priv->import_sources = (SourceCollection*) _tmp4_;
	_g_free0 (_tmp3_);
	_tmp5_ = _g_object_ref0 (icon);
	_g_object_unref0 (self->priv->icon);
	self->priv->icon = _tmp5_;
	_tmp6_ = page_get_view ((Page*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = camera_view_tracker_new (_tmp7_);
	_core_tracker_unref0 (self->priv->tracker);
	self->priv->tracker = _tmp8_;
	_data_collection_unref0 (_tmp7_);
	if (NULL != display_name) {
		gchar* _tmp9_;
		_tmp9_ = g_strdup (display_name);
		_g_free0 (self->priv->camera_name);
		self->priv->camera_name = _tmp9_;
	} else {
		CameraAbilities abilities = {0};
		int res = 0;
		CameraAbilities _tmp10_ = {0};
		int _tmp11_;
		_tmp11_ = gp_camera_get_abilities (camera, &_tmp10_);
		 (abilities);
		abilities = _tmp10_;
		res = _tmp11_;
		if (res != GP_OK) {
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp12_ = gp_result_to_full_string (res);
			_tmp13_ = _tmp12_;
			g_debug ("ImportPage.vala:749: Unable to get camera abilities: %s", _tmp13_);
			_g_free0 (_tmp13_);
			_tmp14_ = g_strdup (_ ("Camera"));
			_g_free0 (self->priv->camera_name);
			self->priv->camera_name = _tmp14_;
		}
		 (abilities);
	}
	_tmp15_ = self->priv->camera_label;
	_tmp16_ = self->priv->camera_name;
	gtk_label_set_text (_tmp15_, _tmp16_);
	_tmp17_ = self->priv->camera_name;
	page_set_page_name ((Page*) self, _tmp17_);
	_tmp18_ = g_volume_monitor_get ();
	_g_object_unref0 (self->priv->volume_monitor);
	self->priv->volume_monitor = _tmp18_;
	_tmp19_ = import_page_null_context;
	if (_tmp19_ == NULL) {
		GPContextWrapper* _tmp20_;
		_tmp20_ = gp_context_wrapper_new ();
		_gp_context_wrapper_unref0 (import_page_null_context);
		import_page_null_context = _tmp20_;
	}
	_tmp21_ = import_page_spin_idle_context;
	if (_tmp21_ == NULL) {
		GPSpinIdleWrapper* _tmp22_;
		_tmp22_ = gp_spin_idle_wrapper_new ();
		_gp_context_wrapper_unref0 (import_page_spin_idle_context);
		import_page_spin_idle_context = _tmp22_;
	}
	_tmp23_ = page_get_view ((Page*) self);
	_tmp24_ = _tmp23_;
	_tmp25_ = self->priv->import_sources;
	_tmp26_ = import_page_import_view_manager_new (self);
	_tmp27_ = _tmp26_;
	_tmp28_ = view_collection_monitor_source_collection (_tmp24_, _tmp25_, (ViewManager*) _tmp27_, NULL, NULL, NULL, NULL);
	_tmp29_ = _tmp28_;
	_view_collection_monitor_unref0 (_tmp29_);
	_view_manager_unref0 (_tmp27_);
	_data_collection_unref0 (_tmp24_);
	_tmp30_ = page_get_view ((Page*) self);
	_tmp31_ = _tmp30_;
	data_collection_set_comparator ((DataCollection*) _tmp31_, _import_page_preview_comparator_comparator, NULL, _import_page_preview_comparator_predicate_comparator_predicate, NULL);
	_data_collection_unref0 (_tmp31_);
	_tmp32_ = page_get_view ((Page*) self);
	_tmp33_ = _tmp32_;
	g_signal_connect_object (_tmp33_, "items-state-changed", (GCallback) _import_page_on_view_changed_view_collection_items_state_changed, self, 0);
	_data_collection_unref0 (_tmp33_);
	_tmp34_ = page_get_view ((Page*) self);
	_tmp35_ = _tmp34_;
	g_signal_connect_object ((DataCollection*) _tmp35_, "contents-altered", (GCallback) _import_page_on_view_changed_data_collection_contents_altered, self, 0);
	_data_collection_unref0 (_tmp35_);
	_tmp36_ = page_get_view ((Page*) self);
	_tmp37_ = _tmp36_;
	g_signal_connect_object (_tmp37_, "items-visibility-changed", (GCallback) _import_page_on_view_changed_view_collection_items_visibility_changed, self, 0);
	_data_collection_unref0 (_tmp37_);
	_tmp38_ = page_get_view ((Page*) self);
	_tmp39_ = _tmp38_;
	g_value_init (&_tmp40_, G_TYPE_BOOLEAN);
	g_value_set_boolean (&_tmp40_, TRUE);
	data_collection_set_property ((DataCollection*) _tmp39_, CHECKERBOARD_ITEM_PROP_SHOW_SUBTITLES, &_tmp40_, NULL, NULL);
	G_IS_VALUE (&_tmp40_) ? (g_value_unset (&_tmp40_), NULL) : NULL;
	_data_collection_unref0 (_tmp39_);
	_tmp41_ = library_photo_global;
	g_signal_connect_object ((DataCollection*) _tmp41_, "contents-altered", (GCallback) _import_page_on_media_added_removed_data_collection_contents_altered, self, 0);
	_tmp42_ = video_global;
	g_signal_connect_object ((DataCollection*) _tmp42_, "contents-altered", (GCallback) _import_page_on_media_added_removed_data_collection_contents_altered, self, 0);
	return self;
}

ImportPage*
import_page_new (Camera* camera,
                 const gchar* uri,
                 const gchar* display_name,
                 GIcon* icon)
{
	return import_page_construct (TYPE_IMPORT_PAGE, camera, uri, display_name, icon);
}

static void
_import_page_on_hide_imported_gtk_button_clicked (GtkButton* _sender,
                                                  gpointer self)
{
	import_page_on_hide_imported ((ImportPage*) self);
}

static void
import_page_real_add_toolbar_widgets (Page* base,
                                      GtkActionBar* toolbar)
{
	ImportPage * self;
	GtkCheckButton* _tmp0_;
	GtkCheckButton* _tmp1_;
	GSettings* _tmp2_;
	GtkCheckButton* _tmp3_;
	GtkCheckButton* _tmp4_;
	GtkCheckButton* _tmp5_;
	GtkToolItem* hide_item = NULL;
	GtkToolItem* _tmp6_;
	GtkCheckButton* _tmp7_;
	GtkSeparatorToolItem* separator = NULL;
	GtkSeparatorToolItem* _tmp8_;
	GtkProgressBar* _tmp9_;
	GtkProgressBar* _tmp10_;
	GtkProgressBar* _tmp11_;
	GtkProgressBar* _tmp12_;
	GtkToolItem* progress_item = NULL;
	GtkToolItem* _tmp13_;
	GtkProgressBar* _tmp14_;
	GtkButton* import_selected_button = NULL;
	GtkButton* _tmp15_;
	GtkAction* _tmp16_;
	GtkAction* _tmp17_;
	GtkToolItem* import_sel_ti = NULL;
	GtkToolItem* _tmp18_;
	GtkButton* import_all_button = NULL;
	GtkButton* _tmp19_;
	GtkAction* _tmp20_;
	GtkAction* _tmp21_;
	GtkToolItem* import_all_ti = NULL;
	GtkToolItem* _tmp22_;
	GtkSeparator* _tmp23_;
	GtkSeparator* _tmp24_;
	self = (ImportPage*) base;
	g_return_if_fail (toolbar != NULL);
	_tmp0_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("Hide photos already imported"));
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->hide_imported);
	self->priv->hide_imported = _tmp0_;
	_tmp1_ = self->priv->hide_imported;
	_tmp2_ = ((Page*) self)->ui_settings;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp1_, g_settings_get_boolean (_tmp2_, "hide-photos-already-imported"));
	_tmp3_ = self->priv->hide_imported;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, FALSE);
	_tmp4_ = self->priv->hide_imported;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp4_, _ ("Only display photos that have not been imported"));
	_tmp5_ = self->priv->hide_imported;
	g_signal_connect_object ((GtkButton*) _tmp5_, "clicked", (GCallback) _import_page_on_hide_imported_gtk_button_clicked, self, 0);
	_tmp6_ = gtk_tool_item_new ();
	g_object_ref_sink (_tmp6_);
	hide_item = _tmp6_;
	_tmp7_ = self->priv->hide_imported;
	gtk_container_add ((GtkContainer*) hide_item, (GtkWidget*) _tmp7_);
	_tmp8_ = (GtkSeparatorToolItem*) gtk_separator_tool_item_new ();
	g_object_ref_sink (_tmp8_);
	separator = _tmp8_;
	gtk_separator_tool_item_set_draw (separator, FALSE);
	_tmp9_ = self->priv->progress_bar;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp9_, GTK_ORIENTATION_HORIZONTAL);
	_tmp10_ = self->priv->progress_bar;
	gtk_widget_set_visible ((GtkWidget*) _tmp10_, FALSE);
	_tmp11_ = self->priv->progress_bar;
	gtk_progress_bar_set_show_text (_tmp11_, TRUE);
	_tmp12_ = self->priv->progress_bar;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp12_, TRUE);
	_tmp13_ = gtk_tool_item_new ();
	g_object_ref_sink (_tmp13_);
	progress_item = _tmp13_;
	gtk_tool_item_set_expand (progress_item, TRUE);
	_tmp14_ = self->priv->progress_bar;
	gtk_container_add ((GtkContainer*) progress_item, (GtkWidget*) _tmp14_);
	_tmp15_ = (GtkButton*) gtk_button_new_with_label ("Import Selected");
	g_object_ref_sink (_tmp15_);
	import_selected_button = _tmp15_;
	_tmp16_ = page_get_action ((Page*) self, "ImportSelected");
	_tmp17_ = _tmp16_;
	gtk_activatable_set_related_action ((GtkActivatable*) import_selected_button, _tmp17_);
	_g_object_unref0 (_tmp17_);
	_tmp18_ = gtk_tool_item_new ();
	g_object_ref_sink (_tmp18_);
	import_sel_ti = _tmp18_;
	gtk_container_add ((GtkContainer*) import_sel_ti, (GtkWidget*) import_selected_button);
	_tmp19_ = (GtkButton*) gtk_button_new_with_label ("Import All");
	g_object_ref_sink (_tmp19_);
	import_all_button = _tmp19_;
	_tmp20_ = page_get_action ((Page*) self, "ImportAll");
	_tmp21_ = _tmp20_;
	gtk_activatable_set_related_action ((GtkActivatable*) import_all_button, _tmp21_);
	_g_object_unref0 (_tmp21_);
	_tmp22_ = gtk_tool_item_new ();
	g_object_ref_sink (_tmp22_);
	import_all_ti = _tmp22_;
	gtk_widget_set_margin_start ((GtkWidget*) import_all_ti, 6);
	gtk_container_add ((GtkContainer*) import_all_ti, (GtkWidget*) import_all_button);
	gtk_action_bar_pack_start (toolbar, (GtkWidget*) hide_item);
	gtk_action_bar_pack_start (toolbar, (GtkWidget*) separator);
	gtk_action_bar_pack_start (toolbar, (GtkWidget*) progress_item);
	_tmp23_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_VERTICAL);
	g_object_ref_sink (_tmp23_);
	_tmp24_ = _tmp23_;
	gtk_action_bar_pack_start (toolbar, (GtkWidget*) _tmp24_);
	_g_object_unref0 (_tmp24_);
	gtk_action_bar_pack_start (toolbar, (GtkWidget*) import_sel_ti);
	gtk_action_bar_pack_start (toolbar, (GtkWidget*) import_all_ti);
	import_page_update_toolbar_state (self);
	PAGE_CLASS (import_page_parent_class)->add_toolbar_widgets ((Page*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_PAGE, CheckerboardPage), toolbar);
	_g_object_unref0 (import_all_ti);
	_g_object_unref0 (import_all_button);
	_g_object_unref0 (import_sel_ti);
	_g_object_unref0 (import_selected_button);
	_g_object_unref0 (progress_item);
	_g_object_unref0 (separator);
	_g_object_unref0 (hide_item);
}

static GtkMenu*
import_page_real_get_item_context_menu (CheckerboardPage* base)
{
	ImportPage * self;
	GtkMenu* _tmp0_;
	GtkMenu* _tmp1_;
	GtkMenu* _tmp2_;
	GtkMenu* result;
	self = (ImportPage*) base;
	_tmp0_ = self->priv->import_context_menu;
	if (_tmp0_ == NULL) {
		import_page_create_import_context_menu (self);
	}
	_tmp1_ = self->priv->import_context_menu;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

static Block16Data*
block16_data_ref (Block16Data* _data16_)
{
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}

static void
block16_data_unref (void * _userdata_)
{
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		ImportPage* self;
		self = _data16_->self;
		_g_object_unref0 (_data16_->select_action);
		_g_object_unref0 (_data16_->descending_action);
		_g_object_unref0 (_data16_->descending_menu_item);
		_g_object_unref0 (_data16_->ascending_action);
		_g_object_unref0 (_data16_->ascending_menu_item);
		_g_object_unref0 (self);
		g_slice_free (Block16Data, _data16_);
	}
}

static void
___lambda119_ (Block16Data* _data16_)
{
	ImportPage* self;
	GtkRadioMenuItem* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = _data16_->self;
	_tmp0_ = _data16_->ascending_menu_item;
	_tmp1_ = gtk_check_menu_item_get_active ((GtkCheckMenuItem*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkAction* _tmp3_;
		_tmp3_ = _data16_->ascending_action;
		gtk_action_activate (_tmp3_);
	}
}

static void
____lambda119__gtk_menu_item_activate (GtkMenuItem* _sender,
                                       gpointer self)
{
	___lambda119_ (self);
}

static void
___lambda120_ (Block16Data* _data16_)
{
	ImportPage* self;
	GtkRadioMenuItem* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = _data16_->self;
	_tmp0_ = _data16_->descending_menu_item;
	_tmp1_ = gtk_check_menu_item_get_active ((GtkCheckMenuItem*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkAction* _tmp3_;
		_tmp3_ = _data16_->descending_action;
		gtk_action_activate (_tmp3_);
	}
}

static void
____lambda120__gtk_menu_item_activate (GtkMenuItem* _sender,
                                       gpointer self)
{
	___lambda120_ (self);
}

static void
___lambda121_ (Block16Data* _data16_)
{
	ImportPage* self;
	GAction* _tmp0_;
	self = _data16_->self;
	_tmp0_ = _data16_->select_action;
	g_action_activate (_tmp0_, NULL);
}

static void
____lambda121__gtk_menu_item_activate (GtkMenuItem* _sender,
                                       gpointer self)
{
	___lambda121_ (self);
}

static GtkMenu*
import_page_real_get_page_context_menu (Page* base)
{
	ImportPage * self;
	GtkMenu* _tmp0_;
	GtkMenu* _tmp47_;
	GtkMenu* _tmp48_;
	GtkMenu* result;
	self = (ImportPage*) base;
	_tmp0_ = self->priv->page_context_menu;
	if (_tmp0_ == NULL) {
		Block16Data* _data16_;
		GtkMenu* _tmp1_;
		GtkCheckMenuItem* viewtitle_menu_item = NULL;
		GtkCheckMenuItem* _tmp2_;
		GtkAction* viewtitle_action = NULL;
		GtkAction* _tmp3_;
		GtkAction* _tmp4_;
		GtkCheckMenuItem* _tmp5_;
		GtkMenuItem* sort_menu_item = NULL;
		GtkMenuItem* _tmp6_;
		GtkRadioMenuItem* _tmp7_;
		GtkAction* _tmp8_;
		GtkAction* _tmp9_;
		GtkRadioMenuItem* _tmp10_;
		GtkRadioMenuItem* _tmp11_;
		GtkRadioMenuItem* _tmp12_;
		GtkRadioMenuItem* _tmp13_;
		GtkAction* _tmp14_;
		GtkAction* _tmp15_;
		GtkRadioMenuItem* _tmp16_;
		GtkRadioMenuItem* _tmp17_;
		GtkMenu* sort_menu = NULL;
		GtkMenu* _tmp18_;
		GtkMenu* _tmp19_;
		GtkRadioMenuItem* _tmp20_;
		GtkMenu* _tmp21_;
		GtkRadioMenuItem* _tmp22_;
		GtkMenuItem* _tmp23_;
		GtkMenu* _tmp24_;
		GtkMenuItem* select_menu_item = NULL;
		GtkMenuItem* _tmp25_;
		AppWindow* _tmp26_;
		AppWindow* _tmp27_;
		GAction* _tmp28_;
		GAction* _tmp29_;
		GAction* _tmp30_;
		GAction* _tmp31_;
		GtkMenuItem* _tmp32_;
		GtkMenuItem* _tmp33_;
		GtkMenu* _tmp34_;
		GtkCheckMenuItem* _tmp35_;
		GtkMenu* _tmp36_;
		GtkSeparatorMenuItem* _tmp37_;
		GtkSeparatorMenuItem* _tmp38_;
		GtkMenu* _tmp39_;
		GtkMenuItem* _tmp40_;
		GtkMenu* _tmp41_;
		GtkSeparatorMenuItem* _tmp42_;
		GtkSeparatorMenuItem* _tmp43_;
		GtkMenu* _tmp44_;
		GtkMenuItem* _tmp45_;
		GtkMenu* _tmp46_;
		_data16_ = g_slice_new0 (Block16Data);
		_data16_->_ref_count_ = 1;
		_data16_->self = g_object_ref (self);
		_tmp1_ = (GtkMenu*) gtk_menu_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->page_context_menu);
		self->priv->page_context_menu = _tmp1_;
		_tmp2_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_mnemonic (_ ("_Titles"));
		g_object_ref_sink (_tmp2_);
		viewtitle_menu_item = _tmp2_;
		_tmp3_ = page_get_action ((Page*) self, "ViewTitle");
		viewtitle_action = _tmp3_;
		_tmp4_ = viewtitle_action;
		_tmp5_ = viewtitle_menu_item;
		g_object_bind_property_with_closures ((GObject*) _tmp4_, "active", (GObject*) _tmp5_, "active", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
		_tmp6_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("Sort _Events"));
		g_object_ref_sink (_tmp6_);
		sort_menu_item = _tmp6_;
		_tmp7_ = (GtkRadioMenuItem*) gtk_radio_menu_item_new_with_mnemonic (NULL, _ ("_Ascending"));
		g_object_ref_sink (_tmp7_);
		_data16_->ascending_menu_item = _tmp7_;
		_tmp8_ = page_get_common_action ((Page*) self, "CommonSortEventsAscending", TRUE);
		_data16_->ascending_action = _tmp8_;
		_tmp9_ = _data16_->ascending_action;
		_tmp10_ = _data16_->ascending_menu_item;
		g_object_bind_property_with_closures ((GObject*) _tmp9_, "active", (GObject*) _tmp10_, "active", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
		_tmp11_ = _data16_->ascending_menu_item;
		g_signal_connect_data ((GtkMenuItem*) _tmp11_, "activate", (GCallback) ____lambda119__gtk_menu_item_activate, block16_data_ref (_data16_), (GClosureNotify) block16_data_unref, 0);
		_tmp12_ = _data16_->ascending_menu_item;
		_tmp13_ = (GtkRadioMenuItem*) gtk_radio_menu_item_new_with_mnemonic_from_widget (_tmp12_, _ ("D_escending"));
		g_object_ref_sink (_tmp13_);
		_data16_->descending_menu_item = _tmp13_;
		_tmp14_ = page_get_common_action ((Page*) self, "CommonSortEventsDescending", TRUE);
		_data16_->descending_action = _tmp14_;
		_tmp15_ = _data16_->descending_action;
		_tmp16_ = _data16_->descending_menu_item;
		g_object_bind_property_with_closures ((GObject*) _tmp15_, "active", (GObject*) _tmp16_, "active", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
		_tmp17_ = _data16_->descending_menu_item;
		g_signal_connect_data ((GtkMenuItem*) _tmp17_, "activate", (GCallback) ____lambda120__gtk_menu_item_activate, block16_data_ref (_data16_), (GClosureNotify) block16_data_unref, 0);
		_tmp18_ = (GtkMenu*) gtk_menu_new ();
		g_object_ref_sink (_tmp18_);
		sort_menu = _tmp18_;
		_tmp19_ = sort_menu;
		_tmp20_ = _data16_->ascending_menu_item;
		gtk_container_add ((GtkContainer*) _tmp19_, (GtkWidget*) _tmp20_);
		_tmp21_ = sort_menu;
		_tmp22_ = _data16_->descending_menu_item;
		gtk_container_add ((GtkContainer*) _tmp21_, (GtkWidget*) _tmp22_);
		_tmp23_ = sort_menu_item;
		_tmp24_ = sort_menu;
		gtk_menu_item_set_submenu (_tmp23_, _tmp24_);
		_tmp25_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (RESOURCES_SELECT_ALL_MENU);
		g_object_ref_sink (_tmp25_);
		select_menu_item = _tmp25_;
		_tmp26_ = app_window_get_instance ();
		_tmp27_ = _tmp26_;
		_tmp28_ = g_action_map_lookup_action ((GActionMap*) _tmp27_, APP_WINDOW_ACTION_SELECT_ALL);
		_tmp29_ = _g_object_ref0 (_tmp28_);
		_tmp30_ = _tmp29_;
		_g_object_unref0 (_tmp27_);
		_data16_->select_action = _tmp30_;
		_tmp31_ = _data16_->select_action;
		_tmp32_ = select_menu_item;
		g_object_bind_property_with_closures ((GObject*) _tmp31_, "enabled", (GObject*) _tmp32_, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
		_tmp33_ = select_menu_item;
		g_signal_connect_data (_tmp33_, "activate", (GCallback) ____lambda121__gtk_menu_item_activate, block16_data_ref (_data16_), (GClosureNotify) block16_data_unref, 0);
		_tmp34_ = self->priv->page_context_menu;
		_tmp35_ = viewtitle_menu_item;
		gtk_container_add ((GtkContainer*) _tmp34_, (GtkWidget*) _tmp35_);
		_tmp36_ = self->priv->page_context_menu;
		_tmp37_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
		g_object_ref_sink (_tmp37_);
		_tmp38_ = _tmp37_;
		gtk_container_add ((GtkContainer*) _tmp36_, (GtkWidget*) _tmp38_);
		_g_object_unref0 (_tmp38_);
		_tmp39_ = self->priv->page_context_menu;
		_tmp40_ = sort_menu_item;
		gtk_container_add ((GtkContainer*) _tmp39_, (GtkWidget*) _tmp40_);
		_tmp41_ = self->priv->page_context_menu;
		_tmp42_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
		g_object_ref_sink (_tmp42_);
		_tmp43_ = _tmp42_;
		gtk_container_add ((GtkContainer*) _tmp41_, (GtkWidget*) _tmp43_);
		_g_object_unref0 (_tmp43_);
		_tmp44_ = self->priv->page_context_menu;
		_tmp45_ = select_menu_item;
		gtk_container_add ((GtkContainer*) _tmp44_, (GtkWidget*) _tmp45_);
		_tmp46_ = self->priv->page_context_menu;
		gtk_widget_show_all ((GtkWidget*) _tmp46_);
		_g_object_unref0 (select_menu_item);
		_g_object_unref0 (sort_menu);
		_g_object_unref0 (sort_menu_item);
		_g_object_unref0 (viewtitle_action);
		_g_object_unref0 (viewtitle_menu_item);
		block16_data_unref (_data16_);
		_data16_ = NULL;
	}
	_tmp47_ = self->priv->page_context_menu;
	_tmp48_ = _g_object_ref0 (_tmp47_);
	result = _tmp48_;
	return result;
}

static GtkMenu*
import_page_real_get_page_sidebar_menu (Page* base)
{
	ImportPage * self;
	GtkMenu* _tmp0_;
	GtkMenu* _tmp1_;
	GtkMenu* _tmp2_;
	GtkMenu* result;
	self = (ImportPage*) base;
	_tmp0_ = self->priv->import_context_menu;
	if (_tmp0_ == NULL) {
		import_page_create_import_context_menu (self);
	}
	_tmp1_ = self->priv->import_context_menu;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

static Block17Data*
block17_data_ref (Block17Data* _data17_)
{
	g_atomic_int_inc (&_data17_->_ref_count_);
	return _data17_;
}

static void
block17_data_unref (void * _userdata_)
{
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
		ImportPage* self;
		self = _data17_->self;
		_g_object_unref0 (_data17_->all_action);
		_g_object_unref0 (_data17_->selected_action);
		_g_object_unref0 (self);
		g_slice_free (Block17Data, _data17_);
	}
}

static void
__lambda117_ (Block17Data* _data17_)
{
	ImportPage* self;
	self = _data17_->self;
	gtk_action_activate (_data17_->selected_action);
}

static void
___lambda117__gtk_menu_item_activate (GtkMenuItem* _sender,
                                      gpointer self)
{
	__lambda117_ (self);
}

static void
__lambda118_ (Block17Data* _data17_)
{
	ImportPage* self;
	self = _data17_->self;
	gtk_action_activate (_data17_->all_action);
}

static void
___lambda118__gtk_menu_item_activate (GtkMenuItem* _sender,
                                      gpointer self)
{
	__lambda118_ (self);
}

static void
import_page_create_import_context_menu (ImportPage* self)
{
	Block17Data* _data17_;
	GtkMenu* _tmp0_;
	GtkMenuItem* selected_menu_item = NULL;
	GtkMenuItem* _tmp1_;
	GtkAction* _tmp2_;
	GtkMenuItem* all_menu_item = NULL;
	GtkMenuItem* _tmp3_;
	GtkAction* _tmp4_;
	GtkMenu* _tmp5_;
	GtkMenu* _tmp6_;
	GtkMenu* _tmp7_;
	g_return_if_fail (self != NULL);
	_data17_ = g_slice_new0 (Block17Data);
	_data17_->_ref_count_ = 1;
	_data17_->self = g_object_ref (self);
	_tmp0_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->import_context_menu);
	self->priv->import_context_menu = _tmp0_;
	_tmp1_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("Import _Selected"));
	g_object_ref_sink (_tmp1_);
	selected_menu_item = _tmp1_;
	_tmp2_ = page_get_common_action ((Page*) self, "ImportSelected", TRUE);
	_data17_->selected_action = _tmp2_;
	g_object_bind_property_with_closures ((GObject*) _data17_->selected_action, "sensitive", (GObject*) selected_menu_item, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	g_signal_connect_data (selected_menu_item, "activate", (GCallback) ___lambda117__gtk_menu_item_activate, block17_data_ref (_data17_), (GClosureNotify) block17_data_unref, 0);
	_tmp3_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("Import _All"));
	g_object_ref_sink (_tmp3_);
	all_menu_item = _tmp3_;
	_tmp4_ = page_get_common_action ((Page*) self, "ImportAll", TRUE);
	_data17_->all_action = _tmp4_;
	g_object_bind_property_with_closures ((GObject*) _data17_->all_action, "sensitive", (GObject*) all_menu_item, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	g_signal_connect_data (all_menu_item, "activate", (GCallback) ___lambda118__gtk_menu_item_activate, block17_data_ref (_data17_), (GClosureNotify) block17_data_unref, 0);
	_tmp5_ = self->priv->import_context_menu;
	gtk_container_add ((GtkContainer*) _tmp5_, (GtkWidget*) selected_menu_item);
	_tmp6_ = self->priv->import_context_menu;
	gtk_container_add ((GtkContainer*) _tmp6_, (GtkWidget*) all_menu_item);
	_tmp7_ = self->priv->import_context_menu;
	gtk_widget_show_all ((GtkWidget*) _tmp7_);
	_g_object_unref0 (all_menu_item);
	_g_object_unref0 (selected_menu_item);
	block17_data_unref (_data17_);
	_data17_ = NULL;
}

static gpointer
_core_tracker_ref0 (gpointer self)
{
	return self ? core_tracker_ref (self) : NULL;
}

static CoreViewTracker*
import_page_real_get_view_tracker (CheckerboardPage* base)
{
	ImportPage * self;
	CameraViewTracker* _tmp0_;
	CoreViewTracker* _tmp1_;
	CoreViewTracker* result;
	self = (ImportPage*) base;
	_tmp0_ = self->priv->tracker;
	_tmp1_ = _core_tracker_ref0 ((CoreViewTracker*) _tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
import_page_real_get_view_empty_message (CheckerboardPage* base)
{
	ImportPage * self;
	gchar* _tmp0_;
	gchar* result;
	self = (ImportPage*) base;
	_tmp0_ = g_strdup (_ ("Starting import, please wait…"));
	result = _tmp0_;
	return result;
}

static gint64
import_page_preview_comparator (void* a,
                                void* b)
{
	ImportSource* _tmp0_;
	ImportSource* _tmp1_;
	ImportSource* _tmp2_;
	ImportSource* _tmp3_;
	gint64 _tmp4_;
	gint64 result;
	_tmp0_ = import_preview_get_import_source ((ImportPreview*) a);
	_tmp1_ = _tmp0_;
	_tmp2_ = import_preview_get_import_source ((ImportPreview*) b);
	_tmp3_ = _tmp2_;
	_tmp4_ = import_source_get_exposure_time (_tmp1_) - import_source_get_exposure_time (_tmp3_);
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	result = _tmp4_;
	return result;
}

static gboolean
import_page_preview_comparator_predicate (DataObject* object,
                                          Alteration* alteration)
{
	gboolean result;
	g_return_val_if_fail (object != NULL, FALSE);
	g_return_val_if_fail (alteration != NULL, FALSE);
	result = alteration_has_detail (alteration, "metadata", "exposure-time");
	return result;
}

static gint64
import_page_import_job_comparator (ImportPage* self,
                                   void* a,
                                   void* b)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = import_page_camera_import_job_get_exposure_time ((ImportPageCameraImportJob*) a) - import_page_camera_import_job_get_exposure_time ((ImportPageCameraImportJob*) b);
	return result;
}

static void
_import_page_on_display_titles_gcallback (GtkAction* action,
                                          gpointer self)
{
	import_page_on_display_titles ((ImportPage*) self, action);
}

static void
_vala_array_add153 (GtkToggleActionEntry* * array,
                    gint* length,
                    gint* size,
                    const GtkToggleActionEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkToggleActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static GtkToggleActionEntry*
import_page_real_init_collect_toggle_action_entries (Page* base,
                                                     gint* result_length1)
{
	ImportPage * self;
	GtkToggleActionEntry* toggle_actions = NULL;
	gint _tmp0_ = 0;
	GtkToggleActionEntry* _tmp1_;
	gint toggle_actions_length1;
	gint _toggle_actions_size_;
	GtkToggleActionEntry titles = {0};
	GSettings* _tmp2_;
	GtkToggleActionEntry _tmp3_ = {0};
	GtkToggleActionEntry _tmp4_;
	GtkToggleActionEntry* _tmp5_;
	gint _tmp5__length1;
	GtkToggleActionEntry* result;
	self = (ImportPage*) base;
	_tmp1_ = PAGE_CLASS (import_page_parent_class)->init_collect_toggle_action_entries ((Page*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_PAGE, CheckerboardPage), &_tmp0_);
	toggle_actions = _tmp1_;
	toggle_actions_length1 = _tmp0_;
	_toggle_actions_size_ = toggle_actions_length1;
	_tmp2_ = ((Page*) self)->ui_settings;
	_tmp3_.name = "ViewTitle";
	_tmp3_.stock_id = NULL;
	_tmp3_.label = _ ("_Titles");
	_tmp3_.accelerator = "<Ctrl><Shift>T";
	_tmp3_.tooltip = _ ("Display the title of each photo");
	_tmp3_.callback = (GCallback) _import_page_on_display_titles_gcallback;
	_tmp3_.is_active = g_settings_get_boolean (_tmp2_, "display-photo-titles");
	titles = _tmp3_;
	_tmp4_ = titles;
	_vala_array_add153 (&toggle_actions, &toggle_actions_length1, &_toggle_actions_size_, &_tmp4_);
	_tmp5_ = toggle_actions;
	_tmp5__length1 = toggle_actions_length1;
	if (result_length1) {
		*result_length1 = _tmp5__length1;
	}
	result = _tmp5_;
	return result;
}

static void
_import_page_on_import_selected_gcallback (GtkAction* action,
                                           gpointer self)
{
	import_page_on_import_selected ((ImportPage*) self);
}

static void
_vala_array_add154 (GtkActionEntry* * array,
                    gint* length,
                    gint* size,
                    const GtkActionEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_import_page_on_import_all_gcallback (GtkAction* action,
                                      gpointer self)
{
	import_page_on_import_all ((ImportPage*) self);
}

static void
_vala_array_add155 (GtkActionEntry* * array,
                    gint* length,
                    gint* size,
                    const GtkActionEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static GtkActionEntry*
import_page_real_init_collect_action_entries (Page* base,
                                              gint* result_length1)
{
	ImportPage * self;
	GtkActionEntry* actions = NULL;
	gint _tmp0_ = 0;
	GtkActionEntry* _tmp1_;
	gint actions_length1;
	gint _actions_size_;
	GtkActionEntry import_selected = {0};
	GtkActionEntry _tmp2_ = {0};
	GtkActionEntry _tmp3_;
	GtkActionEntry import_all = {0};
	GtkActionEntry _tmp4_ = {0};
	GtkActionEntry _tmp5_;
	GtkActionEntry* _tmp6_;
	gint _tmp6__length1;
	GtkActionEntry* result;
	self = (ImportPage*) base;
	_tmp1_ = PAGE_CLASS (import_page_parent_class)->init_collect_action_entries ((Page*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_PAGE, CheckerboardPage), &_tmp0_);
	actions = _tmp1_;
	actions_length1 = _tmp0_;
	_actions_size_ = actions_length1;
	_tmp2_.name = "ImportSelected";
	_tmp2_.stock_id = RESOURCES_IMPORT;
	_tmp2_.label = _ ("Import _Selected");
	_tmp2_.accelerator = NULL;
	_tmp2_.tooltip = _ ("Import the selected photos into your library");
	_tmp2_.callback = (GCallback) _import_page_on_import_selected_gcallback;
	import_selected = _tmp2_;
	_tmp3_ = import_selected;
	_vala_array_add154 (&actions, &actions_length1, &_actions_size_, &_tmp3_);
	_tmp4_.name = "ImportAll";
	_tmp4_.stock_id = RESOURCES_IMPORT_ALL;
	_tmp4_.label = _ ("Import _All");
	_tmp4_.accelerator = NULL;
	_tmp4_.tooltip = _ ("Import all the photos into your library");
	_tmp4_.callback = (GCallback) _import_page_on_import_all_gcallback;
	import_all = _tmp4_;
	_tmp5_ = import_all;
	_vala_array_add155 (&actions, &actions_length1, &_actions_size_, &_tmp5_);
	_tmp6_ = actions;
	_tmp6__length1 = actions_length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

Camera*
import_page_get_camera (ImportPage* self)
{
	Camera* _tmp0_;
	Camera* _tmp1_;
	Camera* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->camera;
	_tmp1_ = _GPHOTO_REF_CAMERA0 (_tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
import_page_get_uri (ImportPage* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->uri;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

gboolean
import_page_is_busy (ImportPage* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->busy;
	return result;
}

static void
import_page_real_init_actions (Page* base,
                               gint selected_count,
                               gint count)
{
	ImportPage * self;
	self = (ImportPage*) base;
	import_page_on_view_changed (self);
	PAGE_CLASS (import_page_parent_class)->init_actions ((Page*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_PAGE, CheckerboardPage), selected_count, count);
}

gboolean
import_page_is_refreshed (ImportPage* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->refreshed) {
		_tmp0_ = !self->priv->busy;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gchar*
import_page_get_refresh_message (ImportPage* self)
{
	gchar* msg = NULL;
	const gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	msg = NULL;
	_tmp0_ = self->priv->refresh_error;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->priv->refresh_error;
		_tmp2_ = g_strdup (_tmp1_);
		_g_free0 (msg);
		msg = _tmp2_;
	} else {
		if (self->priv->refresh_result == GP_OK) {
		} else {
			gchar* _tmp3_;
			_tmp3_ = gp_result_to_full_string (self->priv->refresh_result);
			_g_free0 (msg);
			msg = _tmp3_;
		}
	}
	result = msg;
	return result;
}

static void
import_page_update_status (ImportPage* self,
                           gboolean busy,
                           gboolean refreshed)
{
	g_return_if_fail (self != NULL);
	self->priv->busy = busy;
	self->priv->refreshed = refreshed;
	import_page_on_view_changed (self);
}

static void
import_page_update_toolbar_state (ImportPage* self)
{
	GtkCheckButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->hide_imported;
	if (_tmp0_ != NULL) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		GtkCheckButton* _tmp5_;
		if (!self->priv->busy) {
			_tmp2_ = self->priv->refreshed;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			ViewCollection* _tmp3_;
			ViewCollection* _tmp4_;
			_tmp3_ = page_get_view ((Page*) self);
			_tmp4_ = _tmp3_;
			_tmp1_ = view_collection_get_unfiltered_count (_tmp4_) > 0;
			_data_collection_unref0 (_tmp4_);
		} else {
			_tmp1_ = FALSE;
		}
		_tmp5_ = self->priv->hide_imported;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, _tmp1_);
	}
}

static void
import_page_on_view_changed (ImportPage* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean has_files = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp7_ = FALSE;
	AppWindow* _tmp8_;
	AppWindow* _tmp9_;
	GAction* _tmp10_;
	g_return_if_fail (self != NULL);
	if (!self->priv->busy) {
		ViewCollection* _tmp1_;
		ViewCollection* _tmp2_;
		_tmp1_ = page_get_view ((Page*) self);
		_tmp2_ = _tmp1_;
		_tmp0_ = data_collection_get_count ((DataCollection*) _tmp2_) > 0;
		_data_collection_unref0 (_tmp2_);
	} else {
		_tmp0_ = FALSE;
	}
	has_files = _tmp0_;
	if (!self->priv->busy) {
		_tmp4_ = self->priv->refreshed;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ViewCollection* _tmp5_;
		ViewCollection* _tmp6_;
		_tmp5_ = page_get_view ((Page*) self);
		_tmp6_ = _tmp5_;
		_tmp3_ = view_collection_get_selected_count (_tmp6_) > 0;
		_data_collection_unref0 (_tmp6_);
	} else {
		_tmp3_ = FALSE;
	}
	page_set_action_sensitive ((Page*) self, "ImportSelected", _tmp3_);
	if (self->priv->refreshed) {
		_tmp7_ = has_files;
	} else {
		_tmp7_ = FALSE;
	}
	page_set_action_sensitive ((Page*) self, "ImportAll", _tmp7_);
	_tmp8_ = app_window_get_instance ();
	_tmp9_ = _tmp8_;
	_tmp10_ = g_action_map_lookup_action ((GActionMap*) _tmp9_, APP_WINDOW_ACTION_SELECT_ALL);
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, g_simple_action_get_type (), GSimpleAction), has_files);
	_g_object_unref0 (_tmp9_);
	import_page_update_toolbar_state (self);
}

static void
import_page_on_media_added_removed (ImportPage* self)
{
	ImportPageImportPageSearchViewFilter* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->search_filter;
	g_signal_emit_by_name ((ViewFilter*) _tmp0_, "refresh");
}

static void
import_page_on_display_titles (ImportPage* self,
                               GtkAction* action)
{
	gboolean display = FALSE;
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	display = gtk_toggle_action_get_active (G_TYPE_CHECK_INSTANCE_CAST (action, gtk_toggle_action_get_type (), GtkToggleAction));
	checkerboard_page_set_display_titles ((CheckerboardPage*) self, display);
	_tmp0_ = ((Page*) self)->ui_settings;
	g_settings_set_boolean (_tmp0_, "display-photo-titles", display);
}

static void
import_page_real_switched_to (Page* base)
{
	ImportPage * self;
	GSettings* _tmp0_;
	self = (ImportPage*) base;
	_tmp0_ = ((Page*) self)->ui_settings;
	checkerboard_page_set_display_titles ((CheckerboardPage*) self, g_settings_get_boolean (_tmp0_, "display-photo-titles"));
	PAGE_CLASS (import_page_parent_class)->switched_to ((Page*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_PAGE, CheckerboardPage));
}

static void
import_page_real_ready (Page* base)
{
	ImportPage * self;
	ImportPageHideImportedViewFilter* _tmp0_;
	self = (ImportPage*) base;
	import_page_try_refreshing_camera (self, FALSE);
	_tmp0_ = self->priv->hide_imported_filter;
	g_signal_emit_by_name ((ViewFilter*) _tmp0_, "refresh");
}

static void
import_page_try_refreshing_camera (ImportPage* self,
                                   gboolean fail_on_locked)
{
	gboolean _tmp0_ = FALSE;
	ImportPageRefreshResult res = 0;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->refreshed) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->busy;
	}
	if (_tmp0_) {
		return;
	}
	res = import_page_refresh_camera (self);
	switch (res) {
		case IMPORT_PAGE_REFRESH_RESULT_OK:
		case IMPORT_PAGE_REFRESH_RESULT_BUSY:
		{
			break;
		}
		case IMPORT_PAGE_REFRESH_RESULT_LOCKED:
		{
			const gchar* _tmp1_;
			GFile* uri = NULL;
			const gchar* _tmp2_;
			GFile* _tmp3_;
			GMount* mount = NULL;
			GMount* _tmp8_;
			if (fail_on_locked) {
				app_window_error_message (IMPORT_PAGE_UNMOUNT_FAILED_MSG, NULL, NULL);
				break;
			}
			_tmp1_ = self->priv->uri;
			g_debug ("ImportPage.vala:1075: Checking if %s is mounted …", _tmp1_);
			_tmp2_ = self->priv->uri;
			_tmp3_ = g_file_new_for_uri (_tmp2_);
			uri = _tmp3_;
			mount = NULL;
			{
				GMount* _tmp4_ = NULL;
				GFile* _tmp5_;
				GMount* _tmp6_;
				GMount* _tmp7_;
				_tmp5_ = uri;
				_tmp6_ = g_file_find_enclosing_mount (_tmp5_, NULL, &_inner_error0_);
				_tmp4_ = _tmp6_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp7_ = _tmp4_;
				_tmp4_ = NULL;
				_g_object_unref0 (mount);
				mount = _tmp7_;
				_g_object_unref0 (_tmp4_);
			}
			goto __finally0;
			__catch0_g_error:
			{
				g_clear_error (&_inner_error0_);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (mount);
				_g_object_unref0 (uri);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp8_ = mount;
			if (_tmp8_ != NULL) {
				GraniteMessageDialog* dialog = NULL;
				GraniteMessageDialog* _tmp9_;
				GraniteMessageDialog* _tmp10_;
				AppWindow* _tmp11_;
				AppWindow* _tmp12_;
				GraniteMessageDialog* _tmp13_;
				gint dialog_res = 0;
				GraniteMessageDialog* _tmp14_;
				GraniteMessageDialog* _tmp15_;
				_tmp9_ = granite_message_dialog_new_with_image_from_icon_name (_ ("The Camera Cannot Be Accessed While Mounted"), _ ("Photos needs to unmount the camera from the filesystem in order to acc" \
"ess it."), "media-eject", GTK_BUTTONS_CANCEL);
				g_object_ref_sink (_tmp9_);
				dialog = _tmp9_;
				_tmp10_ = dialog;
				_tmp11_ = app_window_get_instance ();
				_tmp12_ = _tmp11_;
				gtk_window_set_transient_for ((GtkWindow*) _tmp10_, (GtkWindow*) _tmp12_);
				_g_object_unref0 (_tmp12_);
				_tmp13_ = dialog;
				gtk_dialog_add_button ((GtkDialog*) _tmp13_, _ ("_Unmount"), (gint) GTK_RESPONSE_YES);
				_tmp14_ = dialog;
				dialog_res = gtk_dialog_run ((GtkDialog*) _tmp14_);
				_tmp15_ = dialog;
				gtk_widget_destroy ((GtkWidget*) _tmp15_);
				if (dialog_res != ((gint) GTK_RESPONSE_YES)) {
					checkerboard_page_set_page_message ((CheckerboardPage*) self, _ ("Please unmount the camera."));
				} else {
					GMount* _tmp16_;
					_tmp16_ = mount;
					import_page_unmount_camera (self, _tmp16_);
				}
				_g_object_unref0 (dialog);
			} else {
				GraniteMessageDialog* dialog = NULL;
				GraniteMessageDialog* _tmp17_;
				GraniteMessageDialog* _tmp18_;
				AppWindow* _tmp19_;
				AppWindow* _tmp20_;
				GraniteMessageDialog* _tmp21_;
				GraniteMessageDialog* _tmp22_;
				_tmp17_ = granite_message_dialog_new_with_image_from_icon_name (_ ("The Camera Is Locked By Another Application"), _ ("Photos can only access the camera when it's unlocked. Please close any" \
" other application using the camera and try again."), "dialog-warning", GTK_BUTTONS_CLOSE);
				g_object_ref_sink (_tmp17_);
				dialog = _tmp17_;
				_tmp18_ = dialog;
				_tmp19_ = app_window_get_instance ();
				_tmp20_ = _tmp19_;
				gtk_window_set_transient_for ((GtkWindow*) _tmp18_, (GtkWindow*) _tmp20_);
				_g_object_unref0 (_tmp20_);
				_tmp21_ = dialog;
				gtk_dialog_run ((GtkDialog*) _tmp21_);
				_tmp22_ = dialog;
				gtk_widget_destroy ((GtkWidget*) _tmp22_);
				checkerboard_page_set_page_message ((CheckerboardPage*) self, _ ("Please close any other application using the camera."));
				_g_object_unref0 (dialog);
			}
			_g_object_unref0 (mount);
			_g_object_unref0 (uri);
			break;
		}
		case IMPORT_PAGE_REFRESH_RESULT_LIBRARY_ERROR:
		{
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp23_ = import_page_get_refresh_message (self);
			_tmp24_ = _tmp23_;
			_tmp25_ = g_strdup_printf (_ ("Unable to fetch previews from the camera:\n%s"), _tmp24_);
			_tmp26_ = _tmp25_;
			app_window_error_message (_tmp26_, NULL, NULL);
			_g_free0 (_tmp26_);
			_g_free0 (_tmp24_);
			break;
		}
		default:
		{
			g_error ("ImportPage.vala:1126: Unknown result type %d", (gint) res);
		}
	}
}

static void
_import_page_on_unmounted_g_mount_unmounted (GMount* _sender,
                                             gpointer self)
{
	import_page_on_unmounted ((ImportPage*) self, _sender);
}

static void
_import_page_on_unmount_finished_gasync_ready_callback (GObject* source_object,
                                                        GAsyncResult* res,
                                                        gpointer self)
{
	import_page_on_unmount_finished ((ImportPage*) self, source_object, res);
	g_object_unref (self);
}

gboolean
import_page_unmount_camera (ImportPage* self,
                            GMount* mount)
{
	GtkProgressBar* _tmp0_;
	GtkProgressBar* _tmp1_;
	GtkProgressBar* _tmp2_;
	GtkProgressBar* _tmp3_;
	AppWindow* _tmp4_;
	AppWindow* _tmp5_;
	GtkMountOperation* _tmp6_;
	GtkMountOperation* _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (mount != NULL, FALSE);
	if (self->priv->busy) {
		result = FALSE;
		return result;
	}
	import_page_update_status (self, TRUE, FALSE);
	_tmp0_ = self->priv->progress_bar;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, TRUE);
	_tmp1_ = self->priv->progress_bar;
	gtk_progress_bar_set_fraction (_tmp1_, 0.0);
	_tmp2_ = self->priv->progress_bar;
	gtk_progress_bar_set_ellipsize (_tmp2_, PANGO_ELLIPSIZE_NONE);
	_tmp3_ = self->priv->progress_bar;
	gtk_progress_bar_set_text (_tmp3_, _ ("Unmounting…"));
	g_signal_connect_object (mount, "unmounted", (GCallback) _import_page_on_unmounted_g_mount_unmounted, self, 0);
	g_debug ("ImportPage.vala:1145: Unmounting camera …");
	_tmp4_ = app_window_get_instance ();
	_tmp5_ = _tmp4_;
	_tmp6_ = (GtkMountOperation*) gtk_mount_operation_new ((GtkWindow*) _tmp5_);
	_tmp7_ = _tmp6_;
	g_mount_unmount_with_operation (mount, G_MOUNT_UNMOUNT_NONE, (GMountOperation*) _tmp7_, NULL, _import_page_on_unmount_finished_gasync_ready_callback, g_object_ref (self));
	_g_object_unref0 (_tmp7_);
	_g_object_unref0 (_tmp5_);
	result = TRUE;
	return result;
}

static void
import_page_on_unmount_finished (ImportPage* self,
                                 GObject* source,
                                 GAsyncResult* aresult)
{
	GMount* mount = NULL;
	GMount* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (aresult != NULL);
	g_debug ("ImportPage.vala:1153: Async unmount finished");
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (source, g_mount_get_type (), GMount));
	mount = _tmp0_;
	{
		g_mount_unmount_with_operation_finish (mount, aresult, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		guint _tmp1_;
		GtkProgressBar* _tmp2_;
		GtkProgressBar* _tmp3_;
		GtkProgressBar* _tmp4_;
		g_clear_error (&_inner_error0_);
		app_window_error_message (IMPORT_PAGE_UNMOUNT_FAILED_MSG, NULL, NULL);
		g_signal_parse_name ("unmounted", g_mount_get_type (), &_tmp1_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (mount, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _import_page_on_unmounted_g_mount_unmounted, self);
		import_page_update_status (self, FALSE, self->priv->refreshed);
		_tmp2_ = self->priv->progress_bar;
		gtk_progress_bar_set_ellipsize (_tmp2_, PANGO_ELLIPSIZE_NONE);
		_tmp3_ = self->priv->progress_bar;
		gtk_progress_bar_set_text (_tmp3_, "");
		_tmp4_ = self->priv->progress_bar;
		gtk_widget_set_visible ((GtkWidget*) _tmp4_, FALSE);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (mount);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (mount);
}

static void
import_page_on_unmounted (ImportPage* self,
                          GMount* mount)
{
	GtkProgressBar* _tmp0_;
	GtkProgressBar* _tmp1_;
	GtkProgressBar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mount != NULL);
	g_debug ("ImportPage.vala:1172: on_unmounted");
	import_page_update_status (self, FALSE, self->priv->refreshed);
	_tmp0_ = self->priv->progress_bar;
	gtk_progress_bar_set_ellipsize (_tmp0_, PANGO_ELLIPSIZE_NONE);
	_tmp1_ = self->priv->progress_bar;
	gtk_progress_bar_set_text (_tmp1_, "");
	_tmp2_ = self->priv->progress_bar;
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, FALSE);
	import_page_try_refreshing_camera (self, TRUE);
}

static void
import_page_clear_all_import_sources (ImportPage* self)
{
	Marker* marker = NULL;
	SourceCollection* _tmp0_;
	Marker* _tmp1_;
	SourceCollection* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->import_sources;
	_tmp1_ = data_collection_start_marking ((DataCollection*) _tmp0_);
	marker = _tmp1_;
	marker_mark_all (marker);
	_tmp2_ = self->priv->import_sources;
	source_collection_destroy_marked (_tmp2_, marker, FALSE, NULL, NULL, NULL);
	_g_object_unref0 (marker);
}

/**
     * @brief Returns whether the current device has a given directory or not.
     *
     * @param fsid The file system id of the camera or other device to search.
     * @param dir The path to start searching from.
     * @param search_target The name of the directory to look for.
     */
static gboolean
import_page_check_directory_exists (ImportPage* self,
                                    gint fsid,
                                    const gchar* dir,
                                    const gchar* search_target)
{
	gchar* fulldir = NULL;
	Camera* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	int _result_ = 0;
	CameraList* folders = NULL;
	CameraList* _tmp3_ = NULL;
	int _tmp4_;
	Camera* _tmp5_;
	const gchar* _tmp6_;
	CameraList* _tmp7_;
	GPSpinIdleWrapper* _tmp8_;
	GPContext* _tmp9_;
	gint list_len = 0;
	CameraList* _tmp10_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (dir != NULL, FALSE);
	g_return_val_if_fail (search_target != NULL, FALSE);
	_tmp0_ = self->priv->camera;
	_tmp1_ = self->priv->camera_name;
	_tmp2_ = import_page_get_fulldir (_tmp0_, _tmp1_, fsid, dir);
	fulldir = _tmp2_;
	_tmp4_ = gp_list_new (&_tmp3_);
	_gp_list_unref0 (folders);
	folders = _tmp3_;
	_result_ = _tmp4_;
	if (_result_ != GP_OK) {
		result = FALSE;
		_gp_list_unref0 (folders);
		_g_free0 (fulldir);
		return result;
	}
	_tmp5_ = self->priv->camera;
	_tmp6_ = fulldir;
	_tmp7_ = folders;
	_tmp8_ = import_page_spin_idle_context;
	_tmp9_ = ((GPContextWrapper*) _tmp8_)->context;
	_result_ = gp_camera_folder_list_folders (_tmp5_, _tmp6_, _tmp7_, _tmp9_);
	if (_result_ != GP_OK) {
		result = FALSE;
		_gp_list_unref0 (folders);
		_g_free0 (fulldir);
		return result;
	}
	_tmp10_ = folders;
	list_len = gp_list_count (_tmp10_);
	{
		gint list_index = 0;
		list_index = 0;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				gchar* tmp = NULL;
				CameraList* _tmp13_;
				const gchar* _tmp14_ = NULL;
				gchar* _tmp15_;
				const gchar* _tmp16_;
				if (!_tmp11_) {
					gint _tmp12_;
					_tmp12_ = list_index;
					list_index = _tmp12_ + 1;
				}
				_tmp11_ = FALSE;
				if (!(list_index < list_len)) {
					break;
				}
				_tmp13_ = folders;
				gp_list_get_name (_tmp13_, list_index, &_tmp14_);
				_g_free0 (tmp);
				_tmp15_ = g_strdup (_tmp14_);
				tmp = _tmp15_;
				_tmp16_ = tmp;
				if (g_strcmp0 (_tmp16_, search_target) == 0) {
					result = TRUE;
					_g_free0 (tmp);
					_gp_list_unref0 (folders);
					_g_free0 (fulldir);
					return result;
				}
				_g_free0 (tmp);
			}
		}
	}
	result = FALSE;
	_gp_list_unref0 (folders);
	_g_free0 (fulldir);
	return result;
}

static ImportPageRefreshResult
import_page_refresh_camera (ImportPage* self)
{
	Camera* _tmp0_;
	GPSpinIdleWrapper* _tmp1_;
	GPContext* _tmp2_;
	GtkProgressBar* _tmp6_;
	GtkProgressBar* _tmp7_;
	GtkProgressBar* _tmp8_;
	GtkProgressBar* _tmp9_;
	GtkProgressBar* _tmp10_;
	GeeArrayList* import_list = NULL;
	GeeArrayList* _tmp11_;
	CameraStorageInformation* sifs = NULL;
	gint sifs_length1;
	gint _sifs_size_;
	Camera* _tmp12_;
	GPSpinIdleWrapper* _tmp13_;
	GPContext* _tmp14_;
	CameraStorageInformation* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	int _tmp17_;
	GeeArrayList* _tmp32_;
	GeeArrayList* _tmp33_;
	GtkProgressBar* _tmp34_;
	GtkProgressBar* _tmp35_;
	GtkProgressBar* _tmp36_;
	GtkProgressBar* _tmp37_;
	int res = 0;
	Camera* _tmp38_;
	GPSpinIdleWrapper* _tmp39_;
	GPContext* _tmp40_;
	ImportPageRefreshResult result;
	g_return_val_if_fail (self != NULL, 0);
	if (self->priv->busy) {
		result = IMPORT_PAGE_REFRESH_RESULT_BUSY;
		return result;
	}
	import_page_update_status (self, self->priv->busy, FALSE);
	_g_free0 (self->priv->refresh_error);
	self->priv->refresh_error = NULL;
	_tmp0_ = self->priv->camera;
	_tmp1_ = import_page_spin_idle_context;
	_tmp2_ = ((GPContextWrapper*) _tmp1_)->context;
	self->priv->refresh_result = gp_camera_init (_tmp0_, _tmp2_);
	if (self->priv->refresh_result != GP_OK) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		ImportPageRefreshResult _tmp5_ = 0;
		_tmp3_ = gp_result_to_full_string (self->priv->refresh_result);
		_tmp4_ = _tmp3_;
		g_warning ("ImportPage.vala:1234: Unable to initialize camera: %s", _tmp4_);
		_g_free0 (_tmp4_);
		if (self->priv->refresh_result == GP_ERROR_IO_LOCK) {
			_tmp5_ = IMPORT_PAGE_REFRESH_RESULT_LOCKED;
		} else {
			_tmp5_ = IMPORT_PAGE_REFRESH_RESULT_LIBRARY_ERROR;
		}
		result = _tmp5_;
		return result;
	}
	import_page_update_status (self, TRUE, self->priv->refreshed);
	import_page_on_view_changed (self);
	_tmp6_ = self->priv->progress_bar;
	gtk_progress_bar_set_ellipsize (_tmp6_, PANGO_ELLIPSIZE_NONE);
	_tmp7_ = self->priv->progress_bar;
	gtk_progress_bar_set_text (_tmp7_, _ ("Fetching photo information"));
	_tmp8_ = self->priv->progress_bar;
	gtk_progress_bar_set_fraction (_tmp8_, 0.0);
	_tmp9_ = self->priv->progress_bar;
	gtk_progress_bar_set_pulse_step (_tmp9_, 0.01);
	_tmp10_ = self->priv->progress_bar;
	gtk_widget_set_visible ((GtkWidget*) _tmp10_, TRUE);
	_tmp11_ = gee_array_list_new (TYPE_IMPORT_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	import_list = _tmp11_;
	sifs = NULL;
	sifs_length1 = 0;
	_sifs_size_ = sifs_length1;
	_tmp12_ = self->priv->camera;
	_tmp13_ = import_page_spin_idle_context;
	_tmp14_ = ((GPContextWrapper*) _tmp13_)->context;
	_tmp17_ = gp_camera_get_storageinfo (_tmp12_, &_tmp15_, &_tmp16_, _tmp14_);
	sifs = (g_free (sifs), NULL);
	sifs = _tmp15_;
	sifs_length1 = _tmp16_;
	_sifs_size_ = sifs_length1;
	self->priv->refresh_result = _tmp17_;
	if (self->priv->refresh_result == GP_OK) {
		{
			gint fsid = 0;
			fsid = 0;
			{
				gboolean _tmp18_ = FALSE;
				_tmp18_ = TRUE;
				while (TRUE) {
					CameraStorageInformation* _tmp20_;
					gint _tmp20__length1;
					gboolean got_well_known_dir = FALSE;
					if (!_tmp18_) {
						gint _tmp19_;
						_tmp19_ = fsid;
						fsid = _tmp19_ + 1;
					}
					_tmp18_ = FALSE;
					_tmp20_ = sifs;
					_tmp20__length1 = sifs_length1;
					if (!(fsid < _tmp20__length1)) {
						break;
					}
					got_well_known_dir = FALSE;
					if (import_page_check_directory_exists (self, fsid, "/", "DCIM")) {
						GeeArrayList* _tmp21_;
						_tmp21_ = import_list;
						import_page_enumerate_files (self, fsid, "/DCIM", _tmp21_);
						got_well_known_dir = TRUE;
					}
					if (import_page_check_directory_exists (self, fsid, "/", "dcim")) {
						GeeArrayList* _tmp22_;
						_tmp22_ = import_list;
						import_page_enumerate_files (self, fsid, "/dcim", _tmp22_);
						got_well_known_dir = TRUE;
					}
					if (import_page_check_directory_exists (self, fsid, "/PRIVATE/", "AVCHD")) {
						GeeArrayList* _tmp23_;
						_tmp23_ = import_list;
						import_page_enumerate_files (self, fsid, "/PRIVATE/AVCHD", _tmp23_);
						got_well_known_dir = TRUE;
					}
					if (import_page_check_directory_exists (self, fsid, "/private/", "avchd")) {
						GeeArrayList* _tmp24_;
						_tmp24_ = import_list;
						import_page_enumerate_files (self, fsid, "/private/avchd", _tmp24_);
						got_well_known_dir = TRUE;
					}
					if (import_page_check_directory_exists (self, fsid, "/", "AVCHD")) {
						GeeArrayList* _tmp25_;
						_tmp25_ = import_list;
						import_page_enumerate_files (self, fsid, "/AVCHD", _tmp25_);
						got_well_known_dir = TRUE;
					}
					if (import_page_check_directory_exists (self, fsid, "/", "avchd")) {
						GeeArrayList* _tmp26_;
						_tmp26_ = import_list;
						import_page_enumerate_files (self, fsid, "/avchd", _tmp26_);
						got_well_known_dir = TRUE;
					}
					if (import_page_check_directory_exists (self, fsid, "/PRIVATE/", "SONY")) {
						GeeArrayList* _tmp27_;
						_tmp27_ = import_list;
						import_page_enumerate_files (self, fsid, "/PRIVATE/SONY", _tmp27_);
						got_well_known_dir = TRUE;
					}
					if (import_page_check_directory_exists (self, fsid, "/private/", "sony")) {
						GeeArrayList* _tmp28_;
						_tmp28_ = import_list;
						import_page_enumerate_files (self, fsid, "/private/sony", _tmp28_);
						got_well_known_dir = TRUE;
					}
					if (import_page_check_directory_exists (self, fsid, "/", "MP_ROOT")) {
						GeeArrayList* _tmp29_;
						_tmp29_ = import_list;
						import_page_enumerate_files (self, fsid, "/MP_ROOT", _tmp29_);
						got_well_known_dir = TRUE;
					}
					if (import_page_check_directory_exists (self, fsid, "/", "mp_root")) {
						GeeArrayList* _tmp30_;
						_tmp30_ = import_list;
						import_page_enumerate_files (self, fsid, "/mp_root", _tmp30_);
						got_well_known_dir = TRUE;
					}
					if (!got_well_known_dir) {
						GeeArrayList* _tmp31_;
						_tmp31_ = import_list;
						if (!import_page_enumerate_files (self, fsid, "/", _tmp31_)) {
							break;
						}
					}
				}
			}
		}
	}
	import_page_clear_all_import_sources (self);
	_tmp32_ = import_list;
	import_page_auto_match_raw_jpeg (self, _tmp32_);
	granite_services_application_set_progress_visible (TRUE, NULL, NULL);
	_tmp33_ = import_list;
	import_page_load_previews_and_metadata (self, (GeeList*) _tmp33_);
	granite_services_application_set_progress_visible (FALSE, NULL, NULL);
	granite_services_application_set_progress (0.0, NULL, NULL);
	_tmp34_ = self->priv->progress_bar;
	gtk_widget_set_visible ((GtkWidget*) _tmp34_, FALSE);
	_tmp35_ = self->priv->progress_bar;
	gtk_progress_bar_set_ellipsize (_tmp35_, PANGO_ELLIPSIZE_NONE);
	_tmp36_ = self->priv->progress_bar;
	gtk_progress_bar_set_text (_tmp36_, "");
	_tmp37_ = self->priv->progress_bar;
	gtk_progress_bar_set_fraction (_tmp37_, 0.0);
	_tmp38_ = self->priv->camera;
	_tmp39_ = import_page_spin_idle_context;
	_tmp40_ = ((GPContextWrapper*) _tmp39_)->context;
	res = gp_camera_exit (_tmp38_, _tmp40_);
	if (res != GP_OK) {
		gchar* _tmp41_;
		gchar* _tmp42_;
		_tmp41_ = gp_result_to_full_string (res);
		_tmp42_ = _tmp41_;
		g_warning ("ImportPage.vala:1341: Unable to unlock camera: %s", _tmp42_);
		_g_free0 (_tmp42_);
	}
	if (self->priv->refresh_result == GP_OK) {
		import_page_update_status (self, FALSE, TRUE);
	} else {
		import_page_update_status (self, FALSE, FALSE);
		import_page_clear_all_import_sources (self);
	}
	import_page_on_view_changed (self);
	switch (self->priv->refresh_result) {
		case GP_OK:
		{
			result = IMPORT_PAGE_REFRESH_RESULT_OK;
			sifs = (g_free (sifs), NULL);
			_g_object_unref0 (import_list);
			return result;
		}
		case GP_ERROR_IO_LOCK:
		{
			result = IMPORT_PAGE_REFRESH_RESULT_LOCKED;
			sifs = (g_free (sifs), NULL);
			_g_object_unref0 (import_list);
			return result;
		}
		default:
		{
			result = IMPORT_PAGE_REFRESH_RESULT_LIBRARY_ERROR;
			sifs = (g_free (sifs), NULL);
			_g_object_unref0 (import_list);
			return result;
		}
	}
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gchar*
import_page_chomp_ch (const gchar* str,
                      gchar ch)
{
	glong offset = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = strlen (str);
	_tmp1_ = _tmp0_;
	offset = (glong) _tmp1_;
	while (TRUE) {
		glong _tmp2_;
		offset = offset - 1;
		_tmp2_ = offset;
		if (!(_tmp2_ >= ((glong) 0))) {
			break;
		}
		if (string_get (str, offset) != ch) {
			gchar* _tmp3_;
			_tmp3_ = string_slice (str, (glong) 0, offset);
			result = _tmp3_;
			return result;
		}
	}
	_tmp4_ = g_strdup ("");
	result = _tmp4_;
	return result;
}

gchar*
import_page_append_path (const gchar* basepath,
                         const gchar* addition)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	g_return_val_if_fail (basepath != NULL, NULL);
	g_return_val_if_fail (addition != NULL, NULL);
	if (!g_str_has_suffix (basepath, "/")) {
		_tmp0_ = !g_str_has_prefix (addition, "/");
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = g_strconcat (basepath, "/", NULL);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strconcat (_tmp2_, addition, NULL);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		result = _tmp4_;
		return result;
	} else {
		gboolean _tmp5_ = FALSE;
		if (g_str_has_suffix (basepath, "/")) {
			_tmp5_ = g_str_has_prefix (addition, "/");
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp6_ = import_page_chomp_ch (basepath, '/');
			_tmp7_ = _tmp6_;
			_tmp8_ = g_strconcat (_tmp7_, addition, NULL);
			_tmp9_ = _tmp8_;
			_g_free0 (_tmp7_);
			result = _tmp9_;
			return result;
		} else {
			gchar* _tmp10_;
			_tmp10_ = g_strconcat (basepath, addition, NULL);
			result = _tmp10_;
			return result;
		}
	}
}

gchar*
import_page_get_fs_basedir (Camera* camera,
                            gint fsid)
{
	CameraStorageInformation* sifs = NULL;
	gint sifs_length1;
	gint _sifs_size_;
	int res = 0;
	GPContextWrapper* _tmp0_;
	GPContext* _tmp1_;
	CameraStorageInformation* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	int _tmp4_;
	CameraStorageInformation* _tmp5_;
	gint _tmp5__length1;
	const gchar* _tmp6_ = NULL;
	CameraStorageInformation* _tmp7_;
	gint _tmp7__length1;
	CameraStorageInformation _tmp8_;
	gchar* _tmp11_;
	gchar* result;
	g_return_val_if_fail (camera != NULL, NULL);
	sifs = NULL;
	sifs_length1 = 0;
	_sifs_size_ = sifs_length1;
	_tmp0_ = import_page_null_context;
	_tmp1_ = _tmp0_->context;
	_tmp4_ = gp_camera_get_storageinfo (camera, &_tmp2_, &_tmp3_, _tmp1_);
	sifs = (g_free (sifs), NULL);
	sifs = _tmp2_;
	sifs_length1 = _tmp3_;
	_sifs_size_ = sifs_length1;
	res = _tmp4_;
	if (res != GP_OK) {
		result = NULL;
		sifs = (g_free (sifs), NULL);
		return result;
	}
	_tmp5_ = sifs;
	_tmp5__length1 = sifs_length1;
	if (fsid >= _tmp5__length1) {
		result = NULL;
		sifs = (g_free (sifs), NULL);
		return result;
	}
	_tmp7_ = sifs;
	_tmp7__length1 = sifs_length1;
	_tmp8_ = _tmp7_[fsid];
	if ((_tmp8_.fields & GP_STORAGEINFO_BASE) != 0) {
		CameraStorageInformation* _tmp9_;
		gint _tmp9__length1;
		CameraStorageInformation _tmp10_;
		_tmp9_ = sifs;
		_tmp9__length1 = sifs_length1;
		_tmp10_ = _tmp9_[fsid];
		_tmp6_ = (const gchar*) _tmp10_.basedir;
	} else {
		_tmp6_ = "/";
	}
	_tmp11_ = g_strdup (_tmp6_);
	result = _tmp11_;
	sifs = (g_free (sifs), NULL);
	return result;
}

gchar*
import_page_get_fulldir (Camera* camera,
                         const gchar* camera_name,
                         gint fsid,
                         const gchar* folder)
{
	gint _tmp0_;
	gint _tmp1_;
	gchar* basedir = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* result;
	g_return_val_if_fail (camera != NULL, NULL);
	g_return_val_if_fail (camera_name != NULL, NULL);
	g_return_val_if_fail (folder != NULL, NULL);
	_tmp0_ = strlen (folder);
	_tmp1_ = _tmp0_;
	if (_tmp1_ > GP_MAX_BASEDIR_LENGTH) {
		result = NULL;
		return result;
	}
	_tmp2_ = import_page_get_fs_basedir (camera, fsid);
	basedir = _tmp2_;
	_tmp3_ = basedir;
	if (_tmp3_ == NULL) {
		gchar* _tmp4_;
		g_debug ("ImportPage.vala:1406: Unable to find base directory for %s fsid %d", camera_name, fsid);
		_tmp4_ = g_strdup (folder);
		result = _tmp4_;
		_g_free0 (basedir);
		return result;
	}
	_tmp5_ = basedir;
	_tmp6_ = import_page_append_path (_tmp5_, folder);
	result = _tmp6_;
	_g_free0 (basedir);
	return result;
}

static gboolean
import_page_enumerate_files (ImportPage* self,
                             gint fsid,
                             const gchar* dir,
                             GeeArrayList* import_list)
{
	gchar* fulldir = NULL;
	Camera* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	CameraList* files = NULL;
	CameraList* _tmp4_ = NULL;
	int _tmp5_;
	Camera* _tmp8_;
	const gchar* _tmp9_;
	CameraList* _tmp10_;
	GPSpinIdleWrapper* _tmp11_;
	GPContext* _tmp12_;
	CameraList* folders = NULL;
	CameraList* _tmp60_ = NULL;
	int _tmp61_;
	Camera* _tmp64_;
	const gchar* _tmp65_;
	CameraList* _tmp66_;
	GPSpinIdleWrapper* _tmp67_;
	GPContext* _tmp68_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (dir != NULL, FALSE);
	g_return_val_if_fail (import_list != NULL, FALSE);
	_tmp0_ = self->priv->camera;
	_tmp1_ = self->priv->camera_name;
	_tmp2_ = import_page_get_fulldir (_tmp0_, _tmp1_, fsid, dir);
	fulldir = _tmp2_;
	_tmp3_ = fulldir;
	if (_tmp3_ == NULL) {
		g_warning ("ImportPage.vala:1417: Skipping enumerating %s: invalid folder name", dir);
		result = TRUE;
		_g_free0 (fulldir);
		return result;
	}
	_tmp5_ = gp_list_new (&_tmp4_);
	_gp_list_unref0 (files);
	files = _tmp4_;
	self->priv->refresh_result = _tmp5_;
	if (self->priv->refresh_result != GP_OK) {
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = gp_result_to_full_string (self->priv->refresh_result);
		_tmp7_ = _tmp6_;
		g_warning ("ImportPage.vala:1425: Unable to create file list: %s", _tmp7_);
		_g_free0 (_tmp7_);
		result = FALSE;
		_gp_list_unref0 (files);
		_g_free0 (fulldir);
		return result;
	}
	_tmp8_ = self->priv->camera;
	_tmp9_ = fulldir;
	_tmp10_ = files;
	_tmp11_ = import_page_spin_idle_context;
	_tmp12_ = ((GPContextWrapper*) _tmp11_)->context;
	self->priv->refresh_result = gp_camera_folder_list_files (_tmp8_, _tmp9_, _tmp10_, _tmp12_);
	if (self->priv->refresh_result != GP_OK) {
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp13_ = fulldir;
		_tmp14_ = gp_result_to_full_string (self->priv->refresh_result);
		_tmp15_ = _tmp14_;
		g_warning ("ImportPage.vala:1432: Unable to list files in %s: %s", _tmp13_, _tmp15_);
		_g_free0 (_tmp15_);
		self->priv->refresh_result = GP_OK;
		result = TRUE;
		_gp_list_unref0 (files);
		_g_free0 (fulldir);
		return result;
	}
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp16_ = FALSE;
			_tmp16_ = TRUE;
			while (TRUE) {
				CameraList* _tmp18_;
				gchar* filename = NULL;
				CameraList* _tmp19_;
				const gchar* _tmp20_ = NULL;
				int _tmp21_;
				gchar* _tmp22_;
				if (!_tmp16_) {
					gint _tmp17_;
					_tmp17_ = ctr;
					ctr = _tmp17_ + 1;
				}
				_tmp16_ = FALSE;
				_tmp18_ = files;
				if (!(ctr < gp_list_count (_tmp18_))) {
					break;
				}
				_tmp19_ = files;
				_tmp21_ = gp_list_get_name (_tmp19_, ctr, &_tmp20_);
				_g_free0 (filename);
				_tmp22_ = g_strdup (_tmp20_);
				filename = _tmp22_;
				self->priv->refresh_result = _tmp21_;
				if (self->priv->refresh_result != GP_OK) {
					const gchar* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					_tmp23_ = fulldir;
					_tmp24_ = gp_result_to_full_string (self->priv->refresh_result);
					_tmp25_ = _tmp24_;
					g_warning ("ImportPage.vala:1444: Unable to get the name of file %d in %s: %s", ctr, _tmp23_, _tmp25_);
					_g_free0 (_tmp25_);
					result = FALSE;
					_g_free0 (filename);
					_gp_list_unref0 (files);
					_g_free0 (fulldir);
					return result;
				}
				{
					CameraFileInfo info = {0};
					gboolean _tmp26_ = FALSE;
					GPSpinIdleWrapper* _tmp27_;
					GPContext* _tmp28_;
					Camera* _tmp29_;
					const gchar* _tmp30_;
					const gchar* _tmp31_;
					CameraFileInfo _tmp32_ = {0};
					gboolean _tmp33_;
					const gchar* _tmp38_;
					GtkProgressBar* _tmp52_;
					_tmp27_ = import_page_spin_idle_context;
					_tmp28_ = ((GPContextWrapper*) _tmp27_)->context;
					_tmp29_ = self->priv->camera;
					_tmp30_ = fulldir;
					_tmp31_ = filename;
					_tmp33_ = gp_get_info (_tmp28_, _tmp29_, _tmp30_, _tmp31_, &_tmp32_, &_inner_error0_);
					 (info);
					info = _tmp32_;
					_tmp26_ = _tmp33_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						 (info);
						goto __catch0_g_error;
					}
					if (!_tmp26_) {
						const gchar* _tmp34_;
						const gchar* _tmp35_;
						_tmp34_ = fulldir;
						_tmp35_ = filename;
						g_warning ("ImportPage.vala:1453: Skipping import of %s/%s: name too long", _tmp34_, _tmp35_);
						 (info);
						_g_free0 (filename);
						continue;
					}
					if ((info.file.fields & GP_FILE_INFO_TYPE) == 0) {
						const gchar* _tmp36_;
						const gchar* _tmp37_;
						_tmp36_ = fulldir;
						_tmp37_ = filename;
						g_message ("ImportPage.vala:1459: Skipping %s/%s: No file (file=%02Xh)", _tmp36_, _tmp37_, (guint) info.file.fields);
						 (info);
						_g_free0 (filename);
						continue;
					}
					_tmp38_ = filename;
					if (video_reader_is_supported_video_filename (_tmp38_)) {
						VideoImportSource* video_source = NULL;
						const gchar* _tmp39_;
						Camera* _tmp40_;
						const gchar* _tmp41_;
						VideoImportSource* _tmp42_;
						VideoImportSource* _tmp43_;
						_tmp39_ = self->priv->camera_name;
						_tmp40_ = self->priv->camera;
						_tmp41_ = filename;
						_tmp42_ = video_import_source_new (_tmp39_, _tmp40_, fsid, dir, _tmp41_, info.file.size, (gint64) info.file.mtime);
						video_source = _tmp42_;
						_tmp43_ = video_source;
						gee_abstract_collection_add ((GeeAbstractCollection*) import_list, (ImportSource*) _tmp43_);
						_g_object_unref0 (video_source);
					} else {
						PhotoFileFormat file_format = 0;
						const gchar* _tmp47_;
						Camera* _tmp48_;
						const gchar* _tmp49_;
						PhotoImportSource* _tmp50_;
						PhotoImportSource* _tmp51_;
						file_format = photo_file_format_from_gphoto_type ((const gchar*) info.file.type);
						if (file_format == PHOTO_FILE_FORMAT_UNKNOWN) {
							const gchar* _tmp44_;
							_tmp44_ = filename;
							file_format = photo_file_format_get_by_basename_extension (_tmp44_);
							if (file_format == PHOTO_FILE_FORMAT_UNKNOWN) {
								const gchar* _tmp45_;
								const gchar* _tmp46_;
								_tmp45_ = fulldir;
								_tmp46_ = filename;
								g_message ("ImportPage.vala:1475: Skipping %s/%s: Not a supported file extension (" \
"%s)", _tmp45_, _tmp46_, (const gchar*) info.file.type);
								 (info);
								_g_free0 (filename);
								continue;
							}
						}
						_tmp47_ = self->priv->camera_name;
						_tmp48_ = self->priv->camera;
						_tmp49_ = filename;
						_tmp50_ = photo_import_source_new (_tmp47_, _tmp48_, fsid, dir, _tmp49_, info.file.size, (gint64) info.file.mtime, file_format);
						_tmp51_ = _tmp50_;
						gee_abstract_collection_add ((GeeAbstractCollection*) import_list, (ImportSource*) _tmp51_);
						_g_object_unref0 (_tmp51_);
					}
					_tmp52_ = self->priv->progress_bar;
					gtk_progress_bar_pulse (_tmp52_);
					spin_event_loop ();
					 (info);
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* err = NULL;
					const gchar* _tmp53_;
					GError* _tmp54_;
					const gchar* _tmp55_;
					GError* _tmp56_;
					const gchar* _tmp57_;
					gchar* _tmp58_;
					err = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp53_ = fulldir;
					_tmp54_ = err;
					_tmp55_ = _tmp54_->message;
					g_warning ("ImportPage.vala:1490: Error while enumerating files in %s: %s", _tmp53_, _tmp55_);
					_tmp56_ = err;
					_tmp57_ = _tmp56_->message;
					_tmp58_ = g_strdup (_tmp57_);
					_g_free0 (self->priv->refresh_error);
					self->priv->refresh_error = _tmp58_;
					result = FALSE;
					_g_error_free0 (err);
					_g_free0 (filename);
					_gp_list_unref0 (files);
					_g_free0 (fulldir);
					return result;
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gboolean _tmp59_ = FALSE;
					_g_free0 (filename);
					_gp_list_unref0 (files);
					_g_free0 (fulldir);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp59_;
				}
				_g_free0 (filename);
			}
		}
	}
	_tmp61_ = gp_list_new (&_tmp60_);
	_gp_list_unref0 (folders);
	folders = _tmp60_;
	self->priv->refresh_result = _tmp61_;
	if (self->priv->refresh_result != GP_OK) {
		gchar* _tmp62_;
		gchar* _tmp63_;
		_tmp62_ = gp_result_to_full_string (self->priv->refresh_result);
		_tmp63_ = _tmp62_;
		g_warning ("ImportPage.vala:1501: Unable to create folder list: %s", _tmp63_);
		_g_free0 (_tmp63_);
		result = FALSE;
		_gp_list_unref0 (folders);
		_gp_list_unref0 (files);
		_g_free0 (fulldir);
		return result;
	}
	_tmp64_ = self->priv->camera;
	_tmp65_ = fulldir;
	_tmp66_ = folders;
	_tmp67_ = import_page_spin_idle_context;
	_tmp68_ = ((GPContextWrapper*) _tmp67_)->context;
	self->priv->refresh_result = gp_camera_folder_list_folders (_tmp64_, _tmp65_, _tmp66_, _tmp68_);
	if (self->priv->refresh_result != GP_OK) {
		const gchar* _tmp69_;
		gchar* _tmp70_;
		gchar* _tmp71_;
		_tmp69_ = fulldir;
		_tmp70_ = gp_result_to_full_string (self->priv->refresh_result);
		_tmp71_ = _tmp70_;
		g_warning ("ImportPage.vala:1508: Unable to list folders in %s: %s", _tmp69_, _tmp71_);
		_g_free0 (_tmp71_);
		self->priv->refresh_result = GP_OK;
		result = TRUE;
		_gp_list_unref0 (folders);
		_gp_list_unref0 (files);
		_g_free0 (fulldir);
		return result;
	}
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp72_ = FALSE;
			_tmp72_ = TRUE;
			while (TRUE) {
				CameraList* _tmp74_;
				gchar* subdir = NULL;
				CameraList* _tmp75_;
				const gchar* _tmp76_ = NULL;
				int _tmp77_;
				gchar* _tmp78_;
				const gchar* _tmp81_;
				gchar* _tmp82_;
				gchar* _tmp83_;
				gboolean _tmp84_;
				if (!_tmp72_) {
					gint _tmp73_;
					_tmp73_ = ctr;
					ctr = _tmp73_ + 1;
				}
				_tmp72_ = FALSE;
				_tmp74_ = folders;
				if (!(ctr < gp_list_count (_tmp74_))) {
					break;
				}
				_tmp75_ = folders;
				_tmp77_ = gp_list_get_name (_tmp75_, ctr, &_tmp76_);
				_g_free0 (subdir);
				_tmp78_ = g_strdup (_tmp76_);
				subdir = _tmp78_;
				self->priv->refresh_result = _tmp77_;
				if (self->priv->refresh_result != GP_OK) {
					gchar* _tmp79_;
					gchar* _tmp80_;
					_tmp79_ = gp_result_to_full_string (self->priv->refresh_result);
					_tmp80_ = _tmp79_;
					g_warning ("ImportPage.vala:1520: Unable to get name of folder %d: %s", ctr, _tmp80_);
					_g_free0 (_tmp80_);
					result = FALSE;
					_g_free0 (subdir);
					_gp_list_unref0 (folders);
					_gp_list_unref0 (files);
					_g_free0 (fulldir);
					return result;
				}
				_tmp81_ = subdir;
				_tmp82_ = import_page_append_path (dir, _tmp81_);
				_tmp83_ = _tmp82_;
				_tmp84_ = !import_page_enumerate_files (self, fsid, _tmp83_, import_list);
				_g_free0 (_tmp83_);
				if (_tmp84_) {
					result = FALSE;
					_g_free0 (subdir);
					_gp_list_unref0 (folders);
					_gp_list_unref0 (files);
					_g_free0 (fulldir);
					return result;
				}
				_g_free0 (subdir);
			}
		}
	}
	result = TRUE;
	_gp_list_unref0 (folders);
	_gp_list_unref0 (files);
	_g_free0 (fulldir);
	return result;
}

static void
import_page_auto_match_raw_jpeg (ImportPage* self,
                                 GeeArrayList* import_list)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (import_list != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gint _tmp3_;
				PhotoImportSource* current = NULL;
				gpointer _tmp4_;
				ImportSource* _tmp5_;
				PhotoImportSource* _tmp6_;
				PhotoImportSource* _tmp7_ = NULL;
				gint _tmp8_;
				gint _tmp9_;
				PhotoImportSource* next = NULL;
				PhotoImportSource* _tmp13_;
				PhotoImportSource* _tmp14_ = NULL;
				PhotoImportSource* prev = NULL;
				PhotoImportSource* _tmp18_;
				gboolean _tmp19_ = FALSE;
				PhotoImportSource* _tmp20_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) import_list);
				_tmp3_ = _tmp2_;
				if (!(i < _tmp3_)) {
					break;
				}
				_tmp4_ = gee_abstract_list_get ((GeeAbstractList*) import_list, i);
				_tmp5_ = (ImportSource*) _tmp4_;
				_tmp6_ = IS_PHOTO_IMPORT_SOURCE (_tmp5_) ? ((PhotoImportSource*) _tmp5_) : NULL;
				if (_tmp6_ == NULL) {
					_g_object_unref0 (_tmp5_);
				}
				current = _tmp6_;
				_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) import_list);
				_tmp9_ = _tmp8_;
				if ((i + 1) < _tmp9_) {
					gpointer _tmp10_;
					ImportSource* _tmp11_;
					PhotoImportSource* _tmp12_;
					_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) import_list, i + 1);
					_tmp11_ = (ImportSource*) _tmp10_;
					_tmp12_ = IS_PHOTO_IMPORT_SOURCE (_tmp11_) ? ((PhotoImportSource*) _tmp11_) : NULL;
					if (_tmp12_ == NULL) {
						_g_object_unref0 (_tmp11_);
					}
					_g_object_unref0 (_tmp7_);
					_tmp7_ = _tmp12_;
				} else {
					_g_object_unref0 (_tmp7_);
					_tmp7_ = NULL;
				}
				_tmp13_ = _g_object_ref0 (_tmp7_);
				next = _tmp13_;
				if (i > 0) {
					gpointer _tmp15_;
					ImportSource* _tmp16_;
					PhotoImportSource* _tmp17_;
					_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) import_list, i - 1);
					_tmp16_ = (ImportSource*) _tmp15_;
					_tmp17_ = IS_PHOTO_IMPORT_SOURCE (_tmp16_) ? ((PhotoImportSource*) _tmp16_) : NULL;
					if (_tmp17_ == NULL) {
						_g_object_unref0 (_tmp16_);
					}
					_g_object_unref0 (_tmp14_);
					_tmp14_ = _tmp17_;
				} else {
					_g_object_unref0 (_tmp14_);
					_tmp14_ = NULL;
				}
				_tmp18_ = _g_object_ref0 (_tmp14_);
				prev = _tmp18_;
				_tmp20_ = current;
				if (_tmp20_ != NULL) {
					PhotoImportSource* _tmp21_;
					_tmp21_ = current;
					_tmp19_ = photo_import_source_get_file_format (_tmp21_) == PHOTO_FILE_FORMAT_RAW;
				} else {
					_tmp19_ = FALSE;
				}
				if (_tmp19_) {
					gchar* current_name = NULL;
					gchar* ext = NULL;
					PhotoImportSource* _tmp22_;
					const gchar* _tmp23_;
					const gchar* _tmp24_;
					gchar* _tmp25_ = NULL;
					gchar* _tmp26_ = NULL;
					PhotoImportSource* associated = NULL;
					gboolean _tmp27_ = FALSE;
					PhotoImportSource* _tmp28_;
					gboolean _tmp39_ = FALSE;
					PhotoImportSource* _tmp40_;
					PhotoImportSource* _tmp51_;
					_tmp22_ = current;
					_tmp23_ = import_source_get_filename ((ImportSource*) _tmp22_);
					_tmp24_ = _tmp23_;
					disassemble_filename (_tmp24_, &_tmp25_, &_tmp26_);
					_g_free0 (current_name);
					current_name = _tmp25_;
					_g_free0 (ext);
					ext = _tmp26_;
					associated = NULL;
					_tmp28_ = next;
					if (_tmp28_ != NULL) {
						PhotoImportSource* _tmp29_;
						_tmp29_ = next;
						_tmp27_ = photo_import_source_get_file_format (_tmp29_) == PHOTO_FILE_FORMAT_JFIF;
					} else {
						_tmp27_ = FALSE;
					}
					if (_tmp27_) {
						gchar* next_name = NULL;
						PhotoImportSource* _tmp30_;
						const gchar* _tmp31_;
						const gchar* _tmp32_;
						gchar* _tmp33_ = NULL;
						gchar* _tmp34_ = NULL;
						const gchar* _tmp35_;
						const gchar* _tmp36_;
						_tmp30_ = next;
						_tmp31_ = import_source_get_filename ((ImportSource*) _tmp30_);
						_tmp32_ = _tmp31_;
						disassemble_filename (_tmp32_, &_tmp33_, &_tmp34_);
						_g_free0 (next_name);
						next_name = _tmp33_;
						_g_free0 (ext);
						ext = _tmp34_;
						_tmp35_ = next_name;
						_tmp36_ = current_name;
						if (g_strcmp0 (_tmp35_, _tmp36_) == 0) {
							PhotoImportSource* _tmp37_;
							PhotoImportSource* _tmp38_;
							_tmp37_ = next;
							_tmp38_ = _g_object_ref0 (_tmp37_);
							_g_object_unref0 (associated);
							associated = _tmp38_;
						}
						_g_free0 (next_name);
					}
					_tmp40_ = prev;
					if (_tmp40_ != NULL) {
						PhotoImportSource* _tmp41_;
						_tmp41_ = prev;
						_tmp39_ = photo_import_source_get_file_format (_tmp41_) == PHOTO_FILE_FORMAT_JFIF;
					} else {
						_tmp39_ = FALSE;
					}
					if (_tmp39_) {
						gchar* prev_name = NULL;
						PhotoImportSource* _tmp42_;
						const gchar* _tmp43_;
						const gchar* _tmp44_;
						gchar* _tmp45_ = NULL;
						gchar* _tmp46_ = NULL;
						const gchar* _tmp47_;
						const gchar* _tmp48_;
						_tmp42_ = prev;
						_tmp43_ = import_source_get_filename ((ImportSource*) _tmp42_);
						_tmp44_ = _tmp43_;
						disassemble_filename (_tmp44_, &_tmp45_, &_tmp46_);
						_g_free0 (prev_name);
						prev_name = _tmp45_;
						_g_free0 (ext);
						ext = _tmp46_;
						_tmp47_ = prev_name;
						_tmp48_ = current_name;
						if (g_strcmp0 (_tmp47_, _tmp48_) == 0) {
							PhotoImportSource* _tmp49_;
							PhotoImportSource* _tmp50_;
							_tmp49_ = prev;
							_tmp50_ = _g_object_ref0 (_tmp49_);
							_g_object_unref0 (associated);
							associated = _tmp50_;
						}
						_g_free0 (prev_name);
					}
					_tmp51_ = associated;
					if (_tmp51_ != NULL) {
						PhotoImportSource* _tmp52_;
						const gchar* _tmp53_;
						const gchar* _tmp54_;
						PhotoImportSource* _tmp55_;
						const gchar* _tmp56_;
						const gchar* _tmp57_;
						PhotoImportSource* _tmp58_;
						PhotoImportSource* _tmp59_;
						PhotoImportSource* _tmp60_;
						_tmp52_ = current;
						_tmp53_ = import_source_get_filename ((ImportSource*) _tmp52_);
						_tmp54_ = _tmp53_;
						_tmp55_ = associated;
						_tmp56_ = import_source_get_filename ((ImportSource*) _tmp55_);
						_tmp57_ = _tmp56_;
						g_debug ("ImportPage.vala:1562: Found RAW+JPEG pair: %s and %s", _tmp54_, _tmp57_);
						_tmp58_ = current;
						_tmp59_ = associated;
						photo_import_source_set_associated (_tmp58_, _tmp59_);
						_tmp60_ = associated;
						if (!gee_abstract_collection_remove ((GeeAbstractCollection*) import_list, (ImportSource*) _tmp60_)) {
							PhotoImportSource* _tmp61_;
							g_debug ("ImportPage.vala:1565: Unable to associate files");
							_tmp61_ = current;
							photo_import_source_set_associated (_tmp61_, NULL);
						}
					}
					_g_object_unref0 (associated);
					_g_free0 (ext);
					_g_free0 (current_name);
				}
				_g_object_unref0 (prev);
				_g_object_unref0 (_tmp14_);
				_g_object_unref0 (next);
				_g_object_unref0 (_tmp7_);
				_g_object_unref0 (current);
			}
		}
	}
}

static void
import_page_load_previews_and_metadata (ImportPage* self,
                                        GeeList* import_list)
{
	gint loaded_photos = 0;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (import_list != NULL);
	loaded_photos = 0;
	{
		GeeList* _import_source_list = NULL;
		gint _import_source_size = 0;
		GeeList* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		gint _import_source_index = 0;
		_import_source_list = import_list;
		_tmp0_ = _import_source_list;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
		_tmp2_ = _tmp1_;
		_import_source_size = _tmp2_;
		_import_source_index = -1;
		while (TRUE) {
			gint _tmp3_;
			gint _tmp4_;
			ImportSource* import_source = NULL;
			GeeList* _tmp5_;
			gpointer _tmp6_;
			gchar* filename = NULL;
			ImportSource* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* fulldir = NULL;
			ImportSource* _tmp11_;
			gchar* _tmp12_;
			const gchar* _tmp13_;
			PhotoImportSource* associated = NULL;
			gboolean _tmp17_ = FALSE;
			ImportSource* _tmp18_;
			GtkProgressBar* _tmp24_;
			GtkProgressBar* _tmp25_;
			ImportSource* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			PhotoMetadata* metadata = NULL;
			const gchar* _tmp31_;
			gchar* exif_only_md5 = NULL;
			PhotoMetadata* _tmp44_;
			GdkPixbuf* preview = NULL;
			gchar* preview_md5 = NULL;
			ImportSource* _tmp79_;
			ImportSource* _tmp82_;
			PhotoImportSource* _tmp88_;
			SourceCollection* _tmp112_;
			ImportSource* _tmp113_;
			GtkProgressBar* _tmp114_;
			gint _tmp115_;
			gint _tmp116_;
			gint _tmp117_;
			gint _tmp118_;
			gint _tmp119_;
			_import_source_index = _import_source_index + 1;
			_tmp3_ = _import_source_index;
			_tmp4_ = _import_source_size;
			if (!(_tmp3_ < _tmp4_)) {
				break;
			}
			_tmp5_ = _import_source_list;
			_tmp6_ = gee_list_get (_tmp5_, _import_source_index);
			import_source = (ImportSource*) _tmp6_;
			_tmp7_ = import_source;
			_tmp8_ = import_source_get_filename (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_strdup (_tmp9_);
			filename = _tmp10_;
			_tmp11_ = import_source;
			_tmp12_ = import_source_get_fulldir (_tmp11_);
			fulldir = _tmp12_;
			_tmp13_ = fulldir;
			if (_tmp13_ == NULL) {
				ImportSource* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp14_ = import_source;
				_tmp15_ = data_object_to_string ((DataObject*) _tmp14_);
				_tmp16_ = _tmp15_;
				g_warning ("ImportPage.vala:1579: Skipping loading preview of %s: invalid folder n" \
"ame", _tmp16_);
				_g_free0 (_tmp16_);
				_g_free0 (fulldir);
				_g_free0 (filename);
				_g_object_unref0 (import_source);
				continue;
			}
			associated = NULL;
			_tmp18_ = import_source;
			if (IS_PHOTO_IMPORT_SOURCE (_tmp18_)) {
				ImportSource* _tmp19_;
				PhotoImportSource* _tmp20_;
				PhotoImportSource* _tmp21_;
				_tmp19_ = import_source;
				_tmp20_ = photo_import_source_get_associated (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_PHOTO_IMPORT_SOURCE, PhotoImportSource));
				_tmp21_ = _tmp20_;
				_tmp17_ = _tmp21_ != NULL;
				_g_object_unref0 (_tmp21_);
			} else {
				_tmp17_ = FALSE;
			}
			if (_tmp17_) {
				ImportSource* _tmp22_;
				PhotoImportSource* _tmp23_;
				_tmp22_ = import_source;
				_tmp23_ = photo_import_source_get_associated (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, TYPE_PHOTO_IMPORT_SOURCE, PhotoImportSource));
				_g_object_unref0 (associated);
				associated = _tmp23_;
			}
			_tmp24_ = self->priv->progress_bar;
			gtk_progress_bar_set_ellipsize (_tmp24_, PANGO_ELLIPSIZE_MIDDLE);
			_tmp25_ = self->priv->progress_bar;
			_tmp26_ = import_source;
			_tmp27_ = data_object_get_name ((DataObject*) _tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = g_strdup_printf (_ ("Fetching preview for %s"), _tmp28_);
			_tmp30_ = _tmp29_;
			gtk_progress_bar_set_text (_tmp25_, _tmp30_);
			_g_free0 (_tmp30_);
			_g_free0 (_tmp28_);
			metadata = NULL;
			_tmp31_ = filename;
			if (!video_reader_is_supported_video_filename (_tmp31_)) {
				{
					PhotoMetadata* _tmp32_ = NULL;
					GPSpinIdleWrapper* _tmp33_;
					GPContext* _tmp34_;
					Camera* _tmp35_;
					const gchar* _tmp36_;
					const gchar* _tmp37_;
					PhotoMetadata* _tmp38_;
					PhotoMetadata* _tmp39_;
					_tmp33_ = import_page_spin_idle_context;
					_tmp34_ = ((GPContextWrapper*) _tmp33_)->context;
					_tmp35_ = self->priv->camera;
					_tmp36_ = fulldir;
					_tmp37_ = filename;
					_tmp38_ = gp_load_metadata (_tmp34_, _tmp35_, _tmp36_, _tmp37_, &_inner_error0_);
					_tmp32_ = _tmp38_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_tmp39_ = _tmp32_;
					_tmp32_ = NULL;
					_media_metadata_unref0 (metadata);
					metadata = _tmp39_;
					_media_metadata_unref0 (_tmp32_);
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* err = NULL;
					const gchar* _tmp40_;
					const gchar* _tmp41_;
					GError* _tmp42_;
					const gchar* _tmp43_;
					err = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp40_ = fulldir;
					_tmp41_ = filename;
					_tmp42_ = err;
					_tmp43_ = _tmp42_->message;
					g_warning ("ImportPage.vala:1605: Unable to fetch metadata for %s/%s: %s", _tmp40_, _tmp41_, _tmp43_);
					_g_error_free0 (err);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_media_metadata_unref0 (metadata);
					_g_object_unref0 (associated);
					_g_free0 (fulldir);
					_g_free0 (filename);
					_g_object_unref0 (import_source);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			exif_only_md5 = NULL;
			_tmp44_ = metadata;
			if (_tmp44_ != NULL) {
				guint8* flattened_sans_thumbnail = NULL;
				PhotoMetadata* _tmp45_;
				gint _tmp46_ = 0;
				guint8* _tmp47_;
				gint flattened_sans_thumbnail_length1;
				gint _flattened_sans_thumbnail_size_;
				gboolean _tmp48_ = FALSE;
				guint8* _tmp49_;
				gint _tmp49__length1;
				_tmp45_ = metadata;
				_tmp47_ = photo_metadata_flatten_exif (_tmp45_, FALSE, &_tmp46_);
				flattened_sans_thumbnail = _tmp47_;
				flattened_sans_thumbnail_length1 = _tmp46_;
				_flattened_sans_thumbnail_size_ = flattened_sans_thumbnail_length1;
				_tmp49_ = flattened_sans_thumbnail;
				_tmp49__length1 = flattened_sans_thumbnail_length1;
				if (_tmp49_ != NULL) {
					guint8* _tmp50_;
					gint _tmp50__length1;
					_tmp50_ = flattened_sans_thumbnail;
					_tmp50__length1 = flattened_sans_thumbnail_length1;
					_tmp48_ = _tmp50__length1 > 0;
				} else {
					_tmp48_ = FALSE;
				}
				if (_tmp48_) {
					guint8* _tmp51_;
					gint _tmp51__length1;
					guint8* _tmp52_;
					gint _tmp52__length1;
					gchar* _tmp53_;
					_tmp51_ = flattened_sans_thumbnail;
					_tmp51__length1 = flattened_sans_thumbnail_length1;
					_tmp52_ = flattened_sans_thumbnail;
					_tmp52__length1 = flattened_sans_thumbnail_length1;
					_tmp53_ = md5_binary (_tmp51_, (gsize) _tmp52__length1);
					_g_free0 (exif_only_md5);
					exif_only_md5 = _tmp53_;
				}
				flattened_sans_thumbnail = (g_free (flattened_sans_thumbnail), NULL);
			}
			preview = NULL;
			preview_md5 = NULL;
			{
				gchar* preview_fulldir = NULL;
				const gchar* _tmp54_;
				gchar* _tmp55_;
				gchar* preview_filename = NULL;
				const gchar* _tmp56_;
				gchar* _tmp57_;
				PhotoImportSource* _tmp58_;
				GdkPixbuf* _tmp65_ = NULL;
				GPSpinIdleWrapper* _tmp66_;
				GPContext* _tmp67_;
				Camera* _tmp68_;
				const gchar* _tmp69_;
				const gchar* _tmp70_;
				gchar* _tmp71_ = NULL;
				GdkPixbuf* _tmp72_;
				GdkPixbuf* _tmp73_;
				_tmp54_ = fulldir;
				_tmp55_ = g_strdup (_tmp54_);
				preview_fulldir = _tmp55_;
				_tmp56_ = filename;
				_tmp57_ = g_strdup (_tmp56_);
				preview_filename = _tmp57_;
				_tmp58_ = associated;
				if (_tmp58_ != NULL) {
					PhotoImportSource* _tmp59_;
					gchar* _tmp60_;
					PhotoImportSource* _tmp61_;
					const gchar* _tmp62_;
					const gchar* _tmp63_;
					gchar* _tmp64_;
					_tmp59_ = associated;
					_tmp60_ = import_source_get_fulldir ((ImportSource*) _tmp59_);
					_g_free0 (preview_fulldir);
					preview_fulldir = _tmp60_;
					_tmp61_ = associated;
					_tmp62_ = import_source_get_filename ((ImportSource*) _tmp61_);
					_tmp63_ = _tmp62_;
					_tmp64_ = g_strdup (_tmp63_);
					_g_free0 (preview_filename);
					preview_filename = _tmp64_;
				}
				_tmp66_ = import_page_spin_idle_context;
				_tmp67_ = ((GPContextWrapper*) _tmp66_)->context;
				_tmp68_ = self->priv->camera;
				_tmp69_ = preview_fulldir;
				_tmp70_ = preview_filename;
				_tmp72_ = gp_load_preview (_tmp67_, _tmp68_, _tmp69_, _tmp70_, &_tmp71_, &_inner_error0_);
				_g_free0 (preview_md5);
				preview_md5 = _tmp71_;
				_tmp65_ = _tmp72_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (preview_filename);
					_g_free0 (preview_fulldir);
					goto __catch1_g_error;
				}
				_tmp73_ = _tmp65_;
				_tmp65_ = NULL;
				_g_object_unref0 (preview);
				preview = _tmp73_;
				_g_object_unref0 (_tmp65_);
				_g_free0 (preview_filename);
				_g_free0 (preview_fulldir);
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* err = NULL;
				const gchar* _tmp74_;
				err = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp74_ = filename;
				if (!video_reader_is_supported_video_filename (_tmp74_)) {
					const gchar* _tmp75_;
					const gchar* _tmp76_;
					GError* _tmp77_;
					const gchar* _tmp78_;
					_tmp75_ = fulldir;
					_tmp76_ = filename;
					_tmp77_ = err;
					_tmp78_ = _tmp77_->message;
					g_warning ("ImportPage.vala:1642: Unable to fetch preview for %s/%s: %s", _tmp75_, _tmp76_, _tmp78_);
				}
				_g_error_free0 (err);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (preview_md5);
				_g_object_unref0 (preview);
				_g_free0 (exif_only_md5);
				_media_metadata_unref0 (metadata);
				_g_object_unref0 (associated);
				_g_free0 (fulldir);
				_g_free0 (filename);
				_g_object_unref0 (import_source);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp79_ = import_source;
			if (IS_VIDEO_IMPORT_SOURCE (_tmp79_)) {
				ImportSource* _tmp80_;
				GdkPixbuf* _tmp81_;
				_tmp80_ = import_source;
				_tmp81_ = preview;
				video_import_source_update (G_TYPE_CHECK_INSTANCE_CAST (_tmp80_, TYPE_VIDEO_IMPORT_SOURCE, VideoImportSource), _tmp81_);
			}
			_tmp82_ = import_source;
			if (IS_PHOTO_IMPORT_SOURCE (_tmp82_)) {
				ImportSource* _tmp83_;
				GdkPixbuf* _tmp84_;
				const gchar* _tmp85_;
				PhotoMetadata* _tmp86_;
				const gchar* _tmp87_;
				_tmp83_ = import_source;
				_tmp84_ = preview;
				_tmp85_ = preview_md5;
				_tmp86_ = metadata;
				_tmp87_ = exif_only_md5;
				photo_import_source_update (G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, TYPE_PHOTO_IMPORT_SOURCE, PhotoImportSource), _tmp84_, _tmp85_, _tmp86_, _tmp87_);
			}
			_tmp88_ = associated;
			if (_tmp88_ != NULL) {
				{
					PhotoMetadata* associated_metadata = NULL;
					GPSpinIdleWrapper* _tmp89_;
					GPContext* _tmp90_;
					Camera* _tmp91_;
					PhotoImportSource* _tmp92_;
					gchar* _tmp93_;
					gchar* _tmp94_;
					PhotoImportSource* _tmp95_;
					const gchar* _tmp96_;
					const gchar* _tmp97_;
					PhotoMetadata* _tmp98_;
					PhotoMetadata* _tmp99_;
					PhotoImportSource* _tmp100_;
					GdkPixbuf* _tmp101_;
					const gchar* _tmp102_;
					PhotoMetadata* _tmp103_;
					_tmp89_ = import_page_spin_idle_context;
					_tmp90_ = ((GPContextWrapper*) _tmp89_)->context;
					_tmp91_ = self->priv->camera;
					_tmp92_ = associated;
					_tmp93_ = import_source_get_fulldir ((ImportSource*) _tmp92_);
					_tmp94_ = _tmp93_;
					_tmp95_ = associated;
					_tmp96_ = import_source_get_filename ((ImportSource*) _tmp95_);
					_tmp97_ = _tmp96_;
					_tmp98_ = gp_load_metadata (_tmp90_, _tmp91_, _tmp94_, _tmp97_, &_inner_error0_);
					_tmp99_ = _tmp98_;
					_g_free0 (_tmp94_);
					associated_metadata = _tmp99_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch2_g_error;
					}
					_tmp100_ = associated;
					_tmp101_ = preview;
					_tmp102_ = preview_md5;
					_tmp103_ = associated_metadata;
					photo_import_source_update (_tmp100_, _tmp101_, _tmp102_, _tmp103_, NULL);
					_media_metadata_unref0 (associated_metadata);
				}
				goto __finally2;
				__catch2_g_error:
				{
					GError* err = NULL;
					PhotoImportSource* _tmp104_;
					gchar* _tmp105_;
					gchar* _tmp106_;
					PhotoImportSource* _tmp107_;
					const gchar* _tmp108_;
					const gchar* _tmp109_;
					GError* _tmp110_;
					const gchar* _tmp111_;
					err = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp104_ = associated;
					_tmp105_ = import_source_get_fulldir ((ImportSource*) _tmp104_);
					_tmp106_ = _tmp105_;
					_tmp107_ = associated;
					_tmp108_ = import_source_get_filename ((ImportSource*) _tmp107_);
					_tmp109_ = _tmp108_;
					_tmp110_ = err;
					_tmp111_ = _tmp110_->message;
					g_warning ("ImportPage.vala:1663: Unable to fetch metadata for %s/%s: %s", _tmp106_, _tmp109_, _tmp111_);
					_g_free0 (_tmp106_);
					_g_error_free0 (err);
				}
				__finally2:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (preview_md5);
					_g_object_unref0 (preview);
					_g_free0 (exif_only_md5);
					_media_metadata_unref0 (metadata);
					_g_object_unref0 (associated);
					_g_free0 (fulldir);
					_g_free0 (filename);
					_g_object_unref0 (import_source);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			_tmp112_ = self->priv->import_sources;
			_tmp113_ = import_source;
			data_collection_add ((DataCollection*) _tmp112_, (DataObject*) _tmp113_);
			_tmp114_ = self->priv->progress_bar;
			loaded_photos = loaded_photos + 1;
			_tmp115_ = loaded_photos;
			_tmp116_ = gee_collection_get_size ((GeeCollection*) import_list);
			_tmp117_ = _tmp116_;
			gtk_progress_bar_set_fraction (_tmp114_, ((gdouble) _tmp115_) / ((gdouble) _tmp117_));
			_tmp118_ = gee_collection_get_size ((GeeCollection*) import_list);
			_tmp119_ = _tmp118_;
			granite_services_application_set_progress (((gdouble) loaded_photos) / ((gdouble) _tmp119_), NULL, NULL);
			spin_event_loop ();
			_g_free0 (preview_md5);
			_g_object_unref0 (preview);
			_g_free0 (exif_only_md5);
			_media_metadata_unref0 (metadata);
			_g_object_unref0 (associated);
			_g_free0 (fulldir);
			_g_free0 (filename);
			_g_object_unref0 (import_source);
		}
	}
}

static void
import_page_on_hide_imported (ImportPage* self)
{
	GtkCheckButton* _tmp0_;
	GSettings* _tmp7_;
	GtkCheckButton* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->hide_imported;
	if (gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_)) {
		ViewCollection* _tmp1_;
		ViewCollection* _tmp2_;
		ImportPageHideImportedViewFilter* _tmp3_;
		_tmp1_ = page_get_view ((Page*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = self->priv->hide_imported_filter;
		view_collection_install_view_filter (_tmp2_, (ViewFilter*) _tmp3_);
		_data_collection_unref0 (_tmp2_);
	} else {
		ViewCollection* _tmp4_;
		ViewCollection* _tmp5_;
		ImportPageHideImportedViewFilter* _tmp6_;
		_tmp4_ = page_get_view ((Page*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->hide_imported_filter;
		view_collection_remove_view_filter (_tmp5_, (ViewFilter*) _tmp6_);
		_data_collection_unref0 (_tmp5_);
	}
	_tmp7_ = ((Page*) self)->ui_settings;
	_tmp8_ = self->priv->hide_imported;
	g_settings_set_boolean (_tmp7_, "hide-photos-already-imported", gtk_toggle_button_get_active ((GtkToggleButton*) _tmp8_));
}

static void
import_page_on_import_selected (ImportPage* self)
{
	ViewCollection* _tmp0_;
	ViewCollection* _tmp1_;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = page_get_view ((Page*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = view_collection_get_selected (_tmp1_);
	_tmp3_ = _tmp2_;
	import_page_import (self, (GeeIterable*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	_data_collection_unref0 (_tmp1_);
}

static void
import_page_on_import_all (ImportPage* self)
{
	ViewCollection* _tmp0_;
	ViewCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = page_get_view ((Page*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = data_collection_get_all ((DataCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	import_page_import (self, (GeeIterable*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	_data_collection_unref0 (_tmp1_);
}

static gint64
_import_page_import_job_comparator_comparator (void* a,
                                               void* b,
                                               gpointer self)
{
	gint64 result;
	result = import_page_import_job_comparator ((ImportPage*) self, a, b);
	return result;
}

static void
_import_page_import_reporter_batch_import_import_reporter (ImportManifest* manifest,
                                                           BatchImportRoll* import_roll,
                                                           gpointer self)
{
	import_page_import_reporter ((ImportPage*) self, manifest);
}

static void
_import_page_on_import_job_failed_batch_import_import_job_failed (BatchImport* _sender,
                                                                  BatchImportResult* _result_,
                                                                  gpointer self)
{
	import_page_on_import_job_failed ((ImportPage*) self, _result_);
}

static void
_import_page_close_import_batch_import_import_complete (BatchImport* _sender,
                                                        ImportManifest* manifest,
                                                        BatchImportRoll* import_roll,
                                                        gpointer self)
{
	import_page_close_import ((ImportPage*) self);
}

static void
import_page_import (ImportPage* self,
                    GeeIterable* items)
{
	int res = 0;
	Camera* _tmp0_;
	GPSpinIdleWrapper* _tmp1_;
	GPContext* _tmp2_;
	GtkProgressBar* _tmp7_;
	SortedList* jobs = NULL;
	SortedList* _tmp8_;
	GeeArrayList* already_imported = NULL;
	GeeArrayList* _tmp9_;
	SortedList* _tmp49_;
	gint _tmp50_;
	gint _tmp51_;
	const gchar* _tmp52_;
	SortedList* _tmp53_;
	gint _tmp54_;
	gint _tmp55_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (items != NULL);
	_tmp0_ = self->priv->camera;
	_tmp1_ = import_page_spin_idle_context;
	_tmp2_ = ((GPContextWrapper*) _tmp1_)->context;
	res = gp_camera_init (_tmp0_, _tmp2_);
	if (res != GP_OK) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp3_ = gp_result_to_full_string (res);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf (_ ("Unable to lock camera: %s"), _tmp4_);
		_tmp6_ = _tmp5_;
		app_window_error_message (_tmp6_, NULL, NULL);
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
		return;
	}
	import_page_update_status (self, TRUE, self->priv->refreshed);
	import_page_on_view_changed (self);
	_tmp7_ = self->priv->progress_bar;
	gtk_widget_set_visible ((GtkWidget*) _tmp7_, FALSE);
	_tmp8_ = sorted_list_new (IMPORT_PAGE_TYPE_CAMERA_IMPORT_JOB, (GBoxedCopyFunc) batch_import_job_ref, (GDestroyNotify) batch_import_job_unref, _import_page_import_job_comparator_comparator, self);
	jobs = _tmp8_;
	_tmp9_ = gee_array_list_new (IMPORT_PAGE_TYPE_CAMERA_IMPORT_JOB, (GBoxedCopyFunc) batch_import_job_ref, (GDestroyNotify) batch_import_job_unref, NULL, NULL, NULL);
	already_imported = _tmp9_;
	{
		GeeIterator* _object_it = NULL;
		GeeIterator* _tmp10_;
		_tmp10_ = gee_iterable_iterator (items);
		_object_it = _tmp10_;
		while (TRUE) {
			GeeIterator* _tmp11_;
			DataObject* object = NULL;
			GeeIterator* _tmp12_;
			gpointer _tmp13_;
			ImportPreview* preview = NULL;
			DataObject* _tmp14_;
			ImportPreview* _tmp15_;
			ImportSource* import_file = NULL;
			ImportPreview* _tmp16_;
			DataSource* _tmp17_;
			DataSource* _tmp18_;
			ImportSource* _tmp19_;
			ImportPreview* _tmp20_;
			ImportPageCameraImportJob* import_job = NULL;
			GPContextWrapper* _tmp32_;
			ImportSource* _tmp33_;
			ImportPageCameraImportJob* _tmp34_;
			gboolean _tmp35_ = FALSE;
			ImportSource* _tmp36_;
			SortedList* _tmp47_;
			ImportPageCameraImportJob* _tmp48_;
			_tmp11_ = _object_it;
			if (!gee_iterator_next (_tmp11_)) {
				break;
			}
			_tmp12_ = _object_it;
			_tmp13_ = gee_iterator_get (_tmp12_);
			object = (DataObject*) _tmp13_;
			_tmp14_ = object;
			_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_IMPORT_PREVIEW, ImportPreview));
			preview = _tmp15_;
			_tmp16_ = preview;
			_tmp17_ = data_view_get_source ((DataView*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, TYPE_IMPORT_SOURCE, ImportSource));
			import_file = _tmp19_;
			_tmp20_ = preview;
			if (import_preview_is_already_imported (_tmp20_)) {
				ImportSource* _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				GeeArrayList* _tmp24_;
				GPContextWrapper* _tmp25_;
				ImportSource* _tmp26_;
				ImportPreview* _tmp27_;
				DuplicatedFile* _tmp28_;
				DuplicatedFile* _tmp29_;
				ImportPageCameraImportJob* _tmp30_;
				ImportPageCameraImportJob* _tmp31_;
				_tmp21_ = import_file;
				_tmp22_ = import_source_get_filename (_tmp21_);
				_tmp23_ = _tmp22_;
				g_message ("ImportPage.vala:1723: Skipping import of %s: checksum detected in libr" \
"ary", _tmp23_);
				_tmp24_ = already_imported;
				_tmp25_ = import_page_null_context;
				_tmp26_ = import_file;
				_tmp27_ = preview;
				_tmp28_ = import_preview_get_duplicated_file (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = import_page_camera_import_job_new (_tmp25_, _tmp26_, _tmp29_);
				_tmp31_ = _tmp30_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp24_, _tmp31_);
				_batch_import_job_unref0 (_tmp31_);
				_g_object_unref0 (_tmp29_);
				_g_object_unref0 (import_file);
				_g_object_unref0 (preview);
				_g_object_unref0 (object);
				continue;
			}
			_tmp32_ = import_page_null_context;
			_tmp33_ = import_file;
			_tmp34_ = import_page_camera_import_job_new (_tmp32_, _tmp33_, NULL);
			import_job = _tmp34_;
			_tmp36_ = import_file;
			if (IS_PHOTO_IMPORT_SOURCE (_tmp36_)) {
				ImportSource* _tmp37_;
				PhotoImportSource* _tmp38_;
				PhotoImportSource* _tmp39_;
				_tmp37_ = import_file;
				_tmp38_ = photo_import_source_get_associated (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, TYPE_PHOTO_IMPORT_SOURCE, PhotoImportSource));
				_tmp39_ = _tmp38_;
				_tmp35_ = _tmp39_ != NULL;
				_g_object_unref0 (_tmp39_);
			} else {
				_tmp35_ = FALSE;
			}
			if (_tmp35_) {
				ImportPageCameraImportJob* _tmp40_;
				GPContextWrapper* _tmp41_;
				ImportSource* _tmp42_;
				PhotoImportSource* _tmp43_;
				PhotoImportSource* _tmp44_;
				ImportPageCameraImportJob* _tmp45_;
				ImportPageCameraImportJob* _tmp46_;
				_tmp40_ = import_job;
				_tmp41_ = import_page_null_context;
				_tmp42_ = import_file;
				_tmp43_ = photo_import_source_get_associated (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, TYPE_PHOTO_IMPORT_SOURCE, PhotoImportSource));
				_tmp44_ = _tmp43_;
				_tmp45_ = import_page_camera_import_job_new (_tmp41_, (ImportSource*) _tmp44_, NULL);
				_tmp46_ = _tmp45_;
				batch_import_job_set_associated ((BatchImportJob*) _tmp40_, (BatchImportJob*) _tmp46_);
				_batch_import_job_unref0 (_tmp46_);
				_g_object_unref0 (_tmp44_);
			}
			_tmp47_ = jobs;
			_tmp48_ = import_job;
			gee_collection_add ((GeeCollection*) _tmp47_, _tmp48_);
			_batch_import_job_unref0 (import_job);
			_g_object_unref0 (import_file);
			_g_object_unref0 (preview);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	_tmp49_ = jobs;
	_tmp50_ = gee_collection_get_size ((GeeCollection*) _tmp49_);
	_tmp51_ = _tmp50_;
	_tmp52_ = self->priv->camera_name;
	g_debug ("ImportPage.vala:1744: Importing %d files from %s", _tmp51_, _tmp52_);
	_tmp53_ = jobs;
	_tmp54_ = gee_collection_get_size ((GeeCollection*) _tmp53_);
	_tmp55_ = _tmp54_;
	if (_tmp55_ > 0) {
		ImportPage* _tmp56_;
		ImportPage* _tmp57_;
		BatchImport* batch_import = NULL;
		SortedList* _tmp58_;
		const gchar* _tmp59_;
		GeeArrayList* _tmp60_;
		BatchImport* _tmp61_;
		BatchImport* _tmp62_;
		BatchImport* _tmp63_;
		LibraryWindow* _tmp64_;
		LibraryWindow* _tmp65_;
		BatchImport* _tmp66_;
		LibraryWindow* _tmp67_;
		LibraryWindow* _tmp68_;
		_tmp56_ = self->priv->local_ref;
		_vala_assert (_tmp56_ == NULL, "local_ref == null");
		_tmp57_ = _g_object_ref0 (self);
		_g_object_unref0 (self->priv->local_ref);
		self->priv->local_ref = _tmp57_;
		_tmp58_ = jobs;
		_tmp59_ = self->priv->camera_name;
		_tmp60_ = already_imported;
		_tmp61_ = batch_import_new ((GeeIterable*) _tmp58_, _tmp59_, _import_page_import_reporter_batch_import_import_reporter, self, NULL, _tmp60_, NULL, NULL, NULL);
		batch_import = _tmp61_;
		_tmp62_ = batch_import;
		g_signal_connect_object (_tmp62_, "import-job-failed", (GCallback) _import_page_on_import_job_failed_batch_import_import_job_failed, self, 0);
		_tmp63_ = batch_import;
		g_signal_connect_object (_tmp63_, "import-complete", (GCallback) _import_page_close_import_batch_import_import_complete, self, 0);
		_tmp64_ = library_window_get_app ();
		_tmp65_ = _tmp64_;
		_tmp66_ = batch_import;
		library_window_enqueue_batch_import (_tmp65_, _tmp66_, TRUE);
		_g_object_unref0 (_tmp65_);
		_tmp67_ = library_window_get_app ();
		_tmp68_ = _tmp67_;
		library_window_switch_to_import_queue_page (_tmp68_);
		_g_object_unref0 (_tmp68_);
		_g_object_unref0 (batch_import);
	} else {
		GeeArrayList* _tmp69_;
		gint _tmp70_;
		gint _tmp71_;
		_tmp69_ = already_imported;
		_tmp70_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp69_);
		_tmp71_ = _tmp70_;
		if (_tmp71_ > 0) {
			GeeArrayList* _tmp72_;
			ImportManifest* _tmp73_;
			ImportManifest* _tmp74_;
			_tmp72_ = already_imported;
			_tmp73_ = import_manifest_new (NULL, (GeeList*) _tmp72_);
			_tmp74_ = _tmp73_;
			import_page_import_reporter (self, _tmp74_);
			_import_manifest_unref0 (_tmp74_);
		}
		import_page_close_import (self);
	}
	_g_object_unref0 (already_imported);
	_g_object_unref0 (jobs);
}

static void
import_page_on_import_job_failed (ImportPage* self,
                                  BatchImportResult* _result_)
{
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_result_ != NULL);
	_tmp1_ = _result_->file;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = _result_->result == IMPORT_RESULT_SUCCESS;
	}
	if (_tmp0_) {
		return;
	}
	{
		GFile* _tmp2_;
		_tmp2_ = _result_->file;
		g_file_delete (_tmp2_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GFile* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = _result_->file;
		_tmp4_ = g_file_get_path (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = err;
		_tmp7_ = _tmp6_->message;
		g_message ("ImportPage.vala:1776: Unable to delete downloaded file %s: %s", _tmp5_, _tmp7_);
		_g_free0 (_tmp5_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gpointer
_batch_import_job_ref0 (gpointer self)
{
	return self ? batch_import_job_ref (self) : NULL;
}

static gboolean
_progress_dialog_monitor_progress_monitor (guint64 current,
                                           guint64 total,
                                           gboolean do_event_loop,
                                           gpointer self)
{
	gboolean result;
	result = progress_dialog_monitor ((ProgressDialog*) self, current, total, do_event_loop);
	return result;
}

static void
import_page_import_reporter (ImportPage* self,
                             ImportManifest* manifest)
{
	ImportPage* local_ref = NULL;
	ImportPage* _tmp0_;
	ImportPage* _tmp1_;
	GeeList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	Marker* marker = NULL;
	SourceCollection* _tmp42_;
	Marker* _tmp43_;
	ProgressDialog* progress = NULL;
	AppWindow* _tmp59_;
	AppWindow* _tmp60_;
	GCancellable* _tmp61_;
	GCancellable* _tmp62_;
	ProgressDialog* _tmp63_;
	ProgressDialog* _tmp64_;
	gint error_count = 0;
	SourceCollection* _tmp65_;
	Marker* _tmp66_;
	ProgressDialog* _tmp67_;
	ProgressDialog* _tmp70_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (manifest != NULL);
	_tmp0_ = self->priv->local_ref;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	local_ref = _tmp1_;
	_g_object_unref0 (self->priv->local_ref);
	self->priv->local_ref = NULL;
	_tmp2_ = manifest->success;
	_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ > 0) {
		gchar* photos_string = NULL;
		GeeList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		GeeList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gchar* _tmp11_;
		gchar* videos_string = NULL;
		GeeList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		GeeList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gchar* _tmp18_;
		gchar* both_string = NULL;
		GeeList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		GeeList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gchar* _tmp25_;
		gchar* neither_string = NULL;
		GeeList* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		GeeList* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		gchar* _tmp32_;
		gchar* question_string = NULL;
		GeeList* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		const gchar* _tmp37_;
		gchar* _tmp38_;
		ImportUIQuestionParams* question = NULL;
		const gchar* _tmp39_;
		ImportUIQuestionParams* _tmp40_;
		ImportUIQuestionParams* _tmp41_;
		_tmp5_ = manifest->success;
		_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = manifest->success;
		_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strdup_printf (ngettext ("Delete this photo from camera?", "Delete these %d photos from camera?", (gulong) _tmp7_), _tmp10_);
		photos_string = _tmp11_;
		_tmp12_ = manifest->success;
		_tmp13_ = gee_collection_get_size ((GeeCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = manifest->success;
		_tmp16_ = gee_collection_get_size ((GeeCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strdup_printf (ngettext ("Delete this video from camera?", "Delete these %d videos from camera?", (gulong) _tmp14_), _tmp17_);
		videos_string = _tmp18_;
		_tmp19_ = manifest->success;
		_tmp20_ = gee_collection_get_size ((GeeCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = manifest->success;
		_tmp23_ = gee_collection_get_size ((GeeCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_strdup_printf (ngettext ("Delete this photo/video from camera?", "Delete these %d photos/videos from camera?", (gulong) _tmp21_), _tmp24_);
		both_string = _tmp25_;
		_tmp26_ = manifest->success;
		_tmp27_ = gee_collection_get_size ((GeeCollection*) _tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = manifest->success;
		_tmp30_ = gee_collection_get_size ((GeeCollection*) _tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = g_strdup_printf (ngettext ("Delete these files from camera?", "Delete these %d files from camera?", (gulong) _tmp28_), _tmp31_);
		neither_string = _tmp32_;
		_tmp33_ = manifest->success;
		_tmp34_ = photos_string;
		_tmp35_ = videos_string;
		_tmp36_ = both_string;
		_tmp37_ = neither_string;
		_tmp38_ = import_ui_get_media_specific_string ((GeeCollection*) _tmp33_, _tmp34_, _tmp35_, _tmp36_, _tmp37_);
		question_string = _tmp38_;
		_tmp39_ = question_string;
		_tmp40_ = import_ui_question_params_new (_tmp39_, _ ("Delete"), _ ("_Keep"));
		question = _tmp40_;
		_tmp41_ = question;
		if (!import_ui_report_manifest (manifest, FALSE, _tmp41_)) {
			_import_ui_question_params_unref0 (question);
			_g_free0 (question_string);
			_g_free0 (neither_string);
			_g_free0 (both_string);
			_g_free0 (videos_string);
			_g_free0 (photos_string);
			_g_object_unref0 (local_ref);
			return;
		}
		_import_ui_question_params_unref0 (question);
		_g_free0 (question_string);
		_g_free0 (neither_string);
		_g_free0 (both_string);
		_g_free0 (videos_string);
		_g_free0 (photos_string);
	} else {
		import_ui_report_manifest (manifest, FALSE, NULL);
		_g_object_unref0 (local_ref);
		return;
	}
	_tmp42_ = self->priv->import_sources;
	_tmp43_ = data_collection_start_marking ((DataCollection*) _tmp42_);
	marker = _tmp43_;
	{
		GeeList* _batch_result_list = NULL;
		GeeList* _tmp44_;
		gint _batch_result_size = 0;
		GeeList* _tmp45_;
		gint _tmp46_;
		gint _tmp47_;
		gint _batch_result_index = 0;
		_tmp44_ = manifest->success;
		_batch_result_list = _tmp44_;
		_tmp45_ = _batch_result_list;
		_tmp46_ = gee_collection_get_size ((GeeCollection*) _tmp45_);
		_tmp47_ = _tmp46_;
		_batch_result_size = _tmp47_;
		_batch_result_index = -1;
		while (TRUE) {
			gint _tmp48_;
			gint _tmp49_;
			BatchImportResult* batch_result = NULL;
			GeeList* _tmp50_;
			gpointer _tmp51_;
			ImportPageCameraImportJob* job = NULL;
			BatchImportResult* _tmp52_;
			BatchImportJob* _tmp53_;
			ImportPageCameraImportJob* _tmp54_;
			Marker* _tmp55_;
			ImportPageCameraImportJob* _tmp56_;
			ImportSource* _tmp57_;
			ImportSource* _tmp58_;
			_batch_result_index = _batch_result_index + 1;
			_tmp48_ = _batch_result_index;
			_tmp49_ = _batch_result_size;
			if (!(_tmp48_ < _tmp49_)) {
				break;
			}
			_tmp50_ = _batch_result_list;
			_tmp51_ = gee_list_get (_tmp50_, _batch_result_index);
			batch_result = (BatchImportResult*) _tmp51_;
			_tmp52_ = batch_result;
			_tmp53_ = _tmp52_->job;
			_tmp54_ = _batch_import_job_ref0 (IMPORT_PAGE_IS_CAMERA_IMPORT_JOB (_tmp53_) ? ((ImportPageCameraImportJob*) _tmp53_) : NULL);
			job = _tmp54_;
			_tmp55_ = marker;
			_tmp56_ = job;
			_tmp57_ = import_page_camera_import_job_get_source (_tmp56_);
			_tmp58_ = _tmp57_;
			marker_mark (_tmp55_, (DataObject*) _tmp58_);
			_g_object_unref0 (_tmp58_);
			_batch_import_job_unref0 (job);
			_batch_import_result_unref0 (batch_result);
		}
	}
	_tmp59_ = app_window_get_instance ();
	_tmp60_ = _tmp59_;
	_tmp61_ = g_cancellable_new ();
	_tmp62_ = _tmp61_;
	_tmp63_ = progress_dialog_new ((GtkWindow*) _tmp60_, _ ("Removing photos/videos from camera"), _tmp62_);
	g_object_ref_sink (_tmp63_);
	_tmp64_ = _tmp63_;
	_g_object_unref0 (_tmp62_);
	_g_object_unref0 (_tmp60_);
	progress = _tmp64_;
	_tmp65_ = self->priv->import_sources;
	_tmp66_ = marker;
	_tmp67_ = progress;
	error_count = source_collection_destroy_marked (_tmp65_, _tmp66_, TRUE, _progress_dialog_monitor_progress_monitor, _tmp67_, NULL);
	if (error_count > 0) {
		gchar* error_string = NULL;
		gchar* _tmp68_;
		const gchar* _tmp69_;
		_tmp68_ = g_strdup_printf (ngettext ("Unable to delete %d photo/video from the camera due to errors.", "Unable to delete %d photos/videos from the camera due to errors.", (gulong) error_count), error_count);
		error_string = _tmp68_;
		_tmp69_ = error_string;
		app_window_error_message (_tmp69_, NULL, NULL);
		_g_free0 (error_string);
	}
	_tmp70_ = progress;
	progress_dialog_close (_tmp70_);
	_g_object_unref0 (local_ref);
	local_ref = NULL;
	_g_object_unref0 (progress);
	_g_object_unref0 (marker);
	_g_object_unref0 (local_ref);
}

static void
import_page_close_import (ImportPage* self)
{
	int res = 0;
	Camera* _tmp0_;
	GPSpinIdleWrapper* _tmp1_;
	GPContext* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->camera;
	_tmp1_ = import_page_spin_idle_context;
	_tmp2_ = ((GPContextWrapper*) _tmp1_)->context;
	res = gp_camera_exit (_tmp0_, _tmp2_);
	if (res != GP_OK) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = gp_result_to_full_string (res);
		_tmp4_ = _tmp3_;
		g_message ("ImportPage.vala:1846: Unable to unlock camera: %s", _tmp4_);
		_g_free0 (_tmp4_);
	}
	import_page_update_status (self, FALSE, self->priv->refreshed);
	import_page_on_view_changed (self);
}

static void
import_page_real_set_display_titles (CheckerboardPage* base,
                                     gboolean display)
{
	ImportPage * self;
	GtkToggleAction* action = NULL;
	GtkAction* _tmp0_;
	GtkToggleAction* _tmp1_;
	GtkToggleAction* _tmp2_;
	self = (ImportPage*) base;
	CHECKERBOARD_PAGE_CLASS (import_page_parent_class)->set_display_titles (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_PAGE, CheckerboardPage), display);
	_tmp0_ = page_get_action ((Page*) self, "ViewTitle");
	_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (_tmp0_);
	}
	action = _tmp1_;
	_tmp2_ = action;
	if (_tmp2_ != NULL) {
		GtkToggleAction* _tmp3_;
		_tmp3_ = action;
		gtk_toggle_action_set_active (_tmp3_, display);
	}
	_g_object_unref0 (action);
}

static gpointer
_view_filter_ref0 (gpointer self)
{
	return self ? view_filter_ref (self) : NULL;
}

static SearchViewFilter*
import_page_real_get_search_view_filter (CheckerboardPage* base)
{
	ImportPage * self;
	ImportPageImportPageSearchViewFilter* _tmp0_;
	SearchViewFilter* _tmp1_;
	SearchViewFilter* result;
	self = (ImportPage*) base;
	_tmp0_ = self->priv->search_filter;
	_tmp1_ = _view_filter_ref0 ((SearchViewFilter*) _tmp0_);
	result = _tmp1_;
	return result;
}

static inline gpointer
import_page_import_view_manager_get_instance_private (ImportPageImportViewManager* self)
{
	return G_STRUCT_MEMBER_P (self, ImportPageImportViewManager_private_offset);
}

static ImportPageImportViewManager*
import_page_import_view_manager_construct (GType object_type,
                                           ImportPage* owner)
{
	ImportPageImportViewManager* self = NULL;
	ImportPage* _tmp0_;
	g_return_val_if_fail (owner != NULL, NULL);
	self = (ImportPageImportViewManager*) view_manager_construct (object_type);
	_tmp0_ = _g_object_ref0 (owner);
	_g_object_unref0 (self->priv->owner);
	self->priv->owner = _tmp0_;
	return self;
}

static ImportPageImportViewManager*
import_page_import_view_manager_new (ImportPage* owner)
{
	return import_page_import_view_manager_construct (IMPORT_PAGE_TYPE_IMPORT_VIEW_MANAGER, owner);
}

static DataView*
import_page_import_view_manager_real_create_view (ViewManager* base,
                                                  DataSource* source)
{
	ImportPageImportViewManager * self;
	ImportPreview* _tmp0_;
	DataView* result;
	self = (ImportPageImportViewManager*) base;
	g_return_val_if_fail (source != NULL, NULL);
	_tmp0_ = import_preview_new (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_IMPORT_SOURCE, ImportSource));
	result = (DataView*) _tmp0_;
	return result;
}

static void
import_page_import_view_manager_class_init (ImportPageImportViewManagerClass * klass,
                                            gpointer klass_data)
{
	import_page_import_view_manager_parent_class = g_type_class_peek_parent (klass);
	((ViewManagerClass *) klass)->finalize = import_page_import_view_manager_finalize;
	g_type_class_adjust_private_offset (klass, &ImportPageImportViewManager_private_offset);
	((ViewManagerClass *) klass)->create_view = (DataView* (*) (ViewManager*, DataSource*)) import_page_import_view_manager_real_create_view;
}

static void
import_page_import_view_manager_instance_init (ImportPageImportViewManager * self,
                                               gpointer klass)
{
	self->priv = import_page_import_view_manager_get_instance_private (self);
}

static void
import_page_import_view_manager_finalize (ViewManager * obj)
{
	ImportPageImportViewManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, IMPORT_PAGE_TYPE_IMPORT_VIEW_MANAGER, ImportPageImportViewManager);
	_g_object_unref0 (self->priv->owner);
	VIEW_MANAGER_CLASS (import_page_import_view_manager_parent_class)->finalize (obj);
}

static GType
import_page_import_view_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ImportPageImportViewManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) import_page_import_view_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ImportPageImportViewManager), 0, (GInstanceInitFunc) import_page_import_view_manager_instance_init, NULL };
	GType import_page_import_view_manager_type_id;
	import_page_import_view_manager_type_id = g_type_register_static (TYPE_VIEW_MANAGER, "ImportPageImportViewManager", &g_define_type_info, 0);
	ImportPageImportViewManager_private_offset = g_type_add_instance_private (import_page_import_view_manager_type_id, sizeof (ImportPageImportViewManagerPrivate));
	return import_page_import_view_manager_type_id;
}

static GType
import_page_import_view_manager_get_type (void)
{
	static volatile gsize import_page_import_view_manager_type_id__once = 0;
	if (g_once_init_enter (&import_page_import_view_manager_type_id__once)) {
		GType import_page_import_view_manager_type_id;
		import_page_import_view_manager_type_id = import_page_import_view_manager_get_type_once ();
		g_once_init_leave (&import_page_import_view_manager_type_id__once, import_page_import_view_manager_type_id);
	}
	return import_page_import_view_manager_type_id__once;
}

static inline gpointer
import_page_camera_import_job_get_instance_private (ImportPageCameraImportJob* self)
{
	return G_STRUCT_MEMBER_P (self, ImportPageCameraImportJob_private_offset);
}

static gpointer
_gp_context_wrapper_ref0 (gpointer self)
{
	return self ? gp_context_wrapper_ref (self) : NULL;
}

static ImportPageCameraImportJob*
import_page_camera_import_job_construct (GType object_type,
                                         GPContextWrapper* context,
                                         ImportSource* import_file,
                                         DuplicatedFile* duplicated_file)
{
	ImportPageCameraImportJob* self = NULL;
	GSettings* _tmp0_;
	GPContextWrapper* _tmp1_;
	ImportSource* _tmp2_;
	DuplicatedFile* _tmp3_;
	Camera* _tmp4_;
	Camera* _tmp5_;
	Camera* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gulong _tmp12_;
	gulong _tmp13_;
	PhotoMetadata* _tmp14_ = NULL;
	PhotoMetadata* _tmp16_;
	g_return_val_if_fail (context != NULL, NULL);
	g_return_val_if_fail (import_file != NULL, NULL);
	self = (ImportPageCameraImportJob*) batch_import_job_construct (object_type);
	_tmp0_ = g_settings_new (GSETTINGS_CONFIGURATION_ENGINE_FILES_PREFS_SCHEMA_NAME);
	_g_object_unref0 (self->priv->file_settings);
	self->priv->file_settings = _tmp0_;
	_tmp1_ = _gp_context_wrapper_ref0 (context);
	_gp_context_wrapper_unref0 (self->priv->context);
	self->priv->context = _tmp1_;
	_tmp2_ = _g_object_ref0 (import_file);
	_g_object_unref0 (self->priv->import_file);
	self->priv->import_file = _tmp2_;
	_tmp3_ = _g_object_ref0 (duplicated_file);
	_g_object_unref0 (self->priv->duplicated_file);
	self->priv->duplicated_file = _tmp3_;
	_tmp4_ = import_source_get_camera (import_file);
	_tmp5_ = _tmp4_;
	_tmp6_ = _GPHOTO_REF_CAMERA0 (_tmp5_);
	_gp_camera_unref0 (self->priv->camera);
	self->priv->camera = _tmp6_;
	_tmp7_ = import_source_get_fulldir (import_file);
	_g_free0 (self->priv->fulldir);
	self->priv->fulldir = _tmp7_;
	_tmp8_ = self->priv->fulldir;
	_vala_assert (_tmp8_ != NULL, "fulldir != null");
	_tmp9_ = import_source_get_filename (import_file);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strdup (_tmp10_);
	_g_free0 (self->priv->filename);
	self->priv->filename = _tmp11_;
	_tmp12_ = import_source_get_file_size (import_file);
	_tmp13_ = _tmp12_;
	self->priv->filesize = (guint64) _tmp13_;
	if (IS_PHOTO_IMPORT_SOURCE (import_file)) {
		PhotoMetadata* _tmp15_;
		_tmp15_ = photo_import_source_get_metadata (G_TYPE_CHECK_INSTANCE_CAST (import_file, TYPE_PHOTO_IMPORT_SOURCE, PhotoImportSource));
		_media_metadata_unref0 (_tmp14_);
		_tmp14_ = _tmp15_;
	} else {
		_media_metadata_unref0 (_tmp14_);
		_tmp14_ = NULL;
	}
	_tmp16_ = _media_metadata_ref0 (_tmp14_);
	_media_metadata_unref0 (self->priv->metadata);
	self->priv->metadata = _tmp16_;
	self->priv->exposure_time = import_source_get_exposure_time (import_file);
	_media_metadata_unref0 (_tmp14_);
	return self;
}

static ImportPageCameraImportJob*
import_page_camera_import_job_new (GPContextWrapper* context,
                                   ImportSource* import_file,
                                   DuplicatedFile* duplicated_file)
{
	return import_page_camera_import_job_construct (IMPORT_PAGE_TYPE_CAMERA_IMPORT_JOB, context, import_file, duplicated_file);
}

static gint64
import_page_camera_import_job_get_exposure_time (ImportPageCameraImportJob* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->exposure_time;
	return result;
}

static DuplicatedFile*
import_page_camera_import_job_real_get_duplicated_file (BatchImportJob* base)
{
	ImportPageCameraImportJob * self;
	DuplicatedFile* _tmp0_;
	DuplicatedFile* _tmp1_;
	DuplicatedFile* result;
	self = (ImportPageCameraImportJob*) base;
	_tmp0_ = self->priv->duplicated_file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static gint64
import_page_camera_import_job_real_get_exposure_time_override (BatchImportJob* base)
{
	ImportPageCameraImportJob * self;
	gint64 _tmp0_ = 0LL;
	ImportSource* _tmp1_;
	gint64 result;
	self = (ImportPageCameraImportJob*) base;
	_tmp1_ = self->priv->import_file;
	if (IS_VIDEO_IMPORT_SOURCE (_tmp1_)) {
		_tmp0_ = import_page_camera_import_job_get_exposure_time (self);
	} else {
		_tmp0_ = (gint64) 0;
	}
	result = _tmp0_;
	return result;
}

static gchar*
import_page_camera_import_job_real_get_dest_identifier (BatchImportJob* base)
{
	ImportPageCameraImportJob * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (ImportPageCameraImportJob*) base;
	_tmp0_ = self->priv->filename;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
import_page_camera_import_job_real_get_source_identifier (BatchImportJob* base)
{
	ImportPageCameraImportJob * self;
	ImportSource* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	self = (ImportPageCameraImportJob*) base;
	_tmp0_ = self->priv->import_file;
	_tmp1_ = import_source_get_filename (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}

static gchar*
import_page_camera_import_job_real_get_basename (BatchImportJob* base)
{
	ImportPageCameraImportJob * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (ImportPageCameraImportJob*) base;
	_tmp0_ = self->priv->filename;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
import_page_camera_import_job_real_get_path (BatchImportJob* base)
{
	ImportPageCameraImportJob * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (ImportPageCameraImportJob*) base;
	_tmp0_ = self->priv->fulldir;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
import_page_camera_import_job_real_set_associated (BatchImportJob* base,
                                                   BatchImportJob* associated)
{
	ImportPageCameraImportJob * self;
	ImportPageCameraImportJob* _tmp0_;
	self = (ImportPageCameraImportJob*) base;
	g_return_if_fail (associated != NULL);
	_tmp0_ = _batch_import_job_ref0 (IMPORT_PAGE_IS_CAMERA_IMPORT_JOB (associated) ? ((ImportPageCameraImportJob*) associated) : NULL);
	_batch_import_job_unref0 (self->priv->associated);
	self->priv->associated = _tmp0_;
}

static ImportSource*
import_page_camera_import_job_get_source (ImportPageCameraImportJob* self)
{
	ImportSource* _tmp0_;
	ImportSource* _tmp1_;
	ImportSource* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->import_file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static gboolean
import_page_camera_import_job_real_is_directory (BatchImportJob* base)
{
	ImportPageCameraImportJob * self;
	gboolean result;
	self = (ImportPageCameraImportJob*) base;
	result = FALSE;
	return result;
}

static gboolean
import_page_camera_import_job_real_determine_file_size (BatchImportJob* base,
                                                        guint64* filesize,
                                                        GFile** file)
{
	ImportPageCameraImportJob * self;
	guint64 _vala_filesize = 0ULL;
	GFile* _vala_file = NULL;
	gboolean result;
	self = (ImportPageCameraImportJob*) base;
	_g_object_unref0 (_vala_file);
	_vala_file = NULL;
	_vala_filesize = self->priv->filesize;
	result = TRUE;
	if (filesize) {
		*filesize = _vala_filesize;
	}
	if (file) {
		*file = _vala_file;
	} else {
		_g_object_unref0 (_vala_file);
	}
	return result;
}

static gboolean
import_page_camera_import_job_real_prepare (BatchImportJob* base,
                                            GFile** file_to_import,
                                            gboolean* copy_to_library,
                                            GError** error)
{
	ImportPageCameraImportJob * self;
	GFile* _vala_file_to_import = NULL;
	gboolean _vala_copy_to_library = FALSE;
	GFile* dest_file = NULL;
	GFile* _tmp12_;
	GFile* _tmp16_;
	ImportPageCameraImportJob* _tmp25_;
	GFile* _tmp58_;
	GFile* _tmp59_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (ImportPageCameraImportJob*) base;
	_g_object_unref0 (_vala_file_to_import);
	_vala_file_to_import = NULL;
	_vala_copy_to_library = FALSE;
	dest_file = NULL;
	{
		gboolean collision = FALSE;
		GFile* _tmp0_ = NULL;
		const gchar* _tmp1_;
		PhotoMetadata* _tmp2_;
		gboolean _tmp3_ = FALSE;
		GFile* _tmp4_;
		GFile* _tmp5_;
		_tmp1_ = self->priv->filename;
		_tmp2_ = self->priv->metadata;
		_tmp4_ = library_files_generate_unique_file (_tmp1_, (MediaMetadata*) _tmp2_, self->priv->exposure_time, &_tmp3_, &_inner_error0_);
		collision = _tmp3_;
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (dest_file);
		dest_file = _tmp5_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		ImportSource* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		GError* _tmp9_;
		const gchar* _tmp10_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = self->priv->import_file;
		_tmp7_ = import_source_get_filename (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = err;
		_tmp10_ = _tmp9_->message;
		g_warning ("ImportPage.vala:583: Unable to generate local file for %s: %s", _tmp8_, _tmp10_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp11_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (dest_file);
		_g_object_unref0 (_vala_file_to_import);
		return _tmp11_;
	}
	_tmp12_ = dest_file;
	if (_tmp12_ == NULL) {
		ImportSource* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		_tmp13_ = self->priv->import_file;
		_tmp14_ = import_source_get_filename (_tmp13_);
		_tmp15_ = _tmp14_;
		g_message ("ImportPage.vala:588: Unable to generate local file for %s", _tmp15_);
		result = FALSE;
		_g_object_unref0 (dest_file);
		if (file_to_import) {
			*file_to_import = _vala_file_to_import;
		} else {
			_g_object_unref0 (_vala_file_to_import);
		}
		if (copy_to_library) {
			*copy_to_library = _vala_copy_to_library;
		}
		return result;
	}
	_tmp16_ = dest_file;
	library_monitor_blacklist_file (_tmp16_, "CameraImportJob.prepare");
	{
		GPContextWrapper* _tmp17_;
		GPContext* _tmp18_;
		Camera* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		GFile* _tmp22_;
		_tmp17_ = self->priv->context;
		_tmp18_ = _tmp17_->context;
		_tmp19_ = self->priv->camera;
		_tmp20_ = self->priv->fulldir;
		_tmp21_ = self->priv->filename;
		_tmp22_ = dest_file;
		gp_save_image (_tmp18_, _tmp19_, _tmp20_, _tmp21_, _tmp22_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __finally1;
		}
	}
	__finally1:
	{
		GError* _inner_error1_ = NULL;
		GFile* _tmp23_;
		_tmp23_ = dest_file;
		library_monitor_unblacklist_file (_tmp23_);
	}
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp24_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (dest_file);
		_g_object_unref0 (_vala_file_to_import);
		return _tmp24_;
	}
	_tmp25_ = self->priv->associated;
	if (_tmp25_ != NULL) {
		BackingPhotoRow* _tmp41_;
		GFile* assoc_dest = NULL;
		BackingPhotoRow* _tmp44_;
		const gchar* _tmp45_;
		GFile* _tmp46_;
		GFile* _tmp47_;
		{
			BackingPhotoRow* _tmp26_ = NULL;
			GFile* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			ImportPageCameraImportJob* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			BackingPhotoRow* _tmp33_;
			BackingPhotoRow* _tmp34_;
			BackingPhotoRow* _tmp35_;
			_tmp27_ = dest_file;
			_tmp28_ = g_file_get_path (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = self->priv->associated;
			_tmp31_ = batch_import_job_get_basename ((BatchImportJob*) _tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = raw_developer_create_backing_row_for_development (RAW_DEVELOPER_CAMERA, _tmp29_, _tmp32_, &_inner_error0_);
			_tmp34_ = _tmp33_;
			_g_free0 (_tmp32_);
			_g_free0 (_tmp29_);
			_tmp26_ = _tmp34_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch2_g_error;
			}
			_tmp35_ = _tmp26_;
			_tmp26_ = NULL;
			_backing_photo_row_unref0 (self->priv->associated_file);
			self->priv->associated_file = _tmp35_;
			_backing_photo_row_unref0 (_tmp26_);
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError* err = NULL;
			ImportPageCameraImportJob* _tmp36_;
			const gchar* _tmp37_;
			GError* _tmp38_;
			const gchar* _tmp39_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp36_ = self->priv->associated;
			_tmp37_ = _tmp36_->priv->filename;
			_tmp38_ = err;
			_tmp39_ = _tmp38_->message;
			g_warning ("ImportPage.vala:609: Unable to generate backing associated file for %s" \
": %s", _tmp37_, _tmp39_);
			_g_error_free0 (err);
		}
		__finally2:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp40_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (dest_file);
			_g_object_unref0 (_vala_file_to_import);
			return _tmp40_;
		}
		_tmp41_ = self->priv->associated_file;
		if (_tmp41_ == NULL) {
			ImportPageCameraImportJob* _tmp42_;
			const gchar* _tmp43_;
			_tmp42_ = self->priv->associated;
			_tmp43_ = _tmp42_->priv->filename;
			g_message ("ImportPage.vala:614: Unable to generate backing associated file for %s", _tmp43_);
			result = FALSE;
			_g_object_unref0 (dest_file);
			if (file_to_import) {
				*file_to_import = _vala_file_to_import;
			} else {
				_g_object_unref0 (_vala_file_to_import);
			}
			if (copy_to_library) {
				*copy_to_library = _vala_copy_to_library;
			}
			return result;
		}
		_tmp44_ = self->priv->associated_file;
		_tmp45_ = _tmp44_->filepath;
		_tmp46_ = g_file_new_for_path (_tmp45_);
		assoc_dest = _tmp46_;
		_tmp47_ = assoc_dest;
		library_monitor_blacklist_file (_tmp47_, "CameraImportJob.prepare");
		{
			GPContextWrapper* _tmp48_;
			GPContext* _tmp49_;
			Camera* _tmp50_;
			ImportPageCameraImportJob* _tmp51_;
			const gchar* _tmp52_;
			ImportPageCameraImportJob* _tmp53_;
			const gchar* _tmp54_;
			GFile* _tmp55_;
			_tmp48_ = self->priv->context;
			_tmp49_ = _tmp48_->context;
			_tmp50_ = self->priv->camera;
			_tmp51_ = self->priv->associated;
			_tmp52_ = _tmp51_->priv->fulldir;
			_tmp53_ = self->priv->associated;
			_tmp54_ = _tmp53_->priv->filename;
			_tmp55_ = assoc_dest;
			gp_save_image (_tmp49_, _tmp50_, _tmp52_, _tmp54_, _tmp55_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __finally3;
			}
		}
		__finally3:
		{
			GError* _inner_error1_ = NULL;
			GFile* _tmp56_;
			_tmp56_ = assoc_dest;
			library_monitor_unblacklist_file (_tmp56_);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp57_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (assoc_dest);
			_g_object_unref0 (dest_file);
			_g_object_unref0 (_vala_file_to_import);
			return _tmp57_;
		}
		_g_object_unref0 (assoc_dest);
	}
	_tmp58_ = dest_file;
	_tmp59_ = _g_object_ref0 (_tmp58_);
	_g_object_unref0 (_vala_file_to_import);
	_vala_file_to_import = _tmp59_;
	_vala_copy_to_library = FALSE;
	result = TRUE;
	_g_object_unref0 (dest_file);
	if (file_to_import) {
		*file_to_import = _vala_file_to_import;
	} else {
		_g_object_unref0 (_vala_file_to_import);
	}
	if (copy_to_library) {
		*copy_to_library = _vala_copy_to_library;
	}
	return result;
}

static gboolean
import_page_camera_import_job_real_complete (BatchImportJob* base,
                                             MediaSource* source,
                                             BatchImportRoll* import_roll,
                                             GError** error)
{
	ImportPageCameraImportJob * self;
	gboolean ret = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (ImportPageCameraImportJob*) base;
	g_return_val_if_fail (source != NULL, FALSE);
	g_return_val_if_fail (import_roll != NULL, FALSE);
	ret = FALSE;
	if (IS_PHOTO (source)) {
		Photo* photo = NULL;
		Photo* _tmp0_;
		BackingPhotoRow* _tmp1_;
		_tmp0_ = _g_object_ref0 (IS_PHOTO (source) ? ((Photo*) source) : NULL);
		photo = _tmp0_;
		_tmp1_ = self->priv->associated_file;
		if (_tmp1_ != NULL) {
			Photo* _tmp2_;
			BackingPhotoRow* _tmp3_;
			Photo* _tmp5_;
			GSettings* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp2_ = photo;
			_tmp3_ = self->priv->associated_file;
			photo_add_backing_photo_for_development (_tmp2_, RAW_DEVELOPER_CAMERA, _tmp3_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp4_ = FALSE;
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (photo);
				return _tmp4_;
			}
			ret = TRUE;
			_tmp5_ = photo;
			_tmp6_ = self->priv->file_settings;
			_tmp7_ = g_settings_get_string (_tmp6_, "raw-developer-default");
			_tmp8_ = _tmp7_;
			photo_set_raw_developer (_tmp5_, raw_developer_from_string (_tmp8_));
			_g_free0 (_tmp8_);
		}
		_g_object_unref0 (photo);
	}
	result = ret;
	return result;
}

static void
import_page_camera_import_job_class_init (ImportPageCameraImportJobClass * klass,
                                          gpointer klass_data)
{
	import_page_camera_import_job_parent_class = g_type_class_peek_parent (klass);
	((BatchImportJobClass *) klass)->finalize = import_page_camera_import_job_finalize;
	g_type_class_adjust_private_offset (klass, &ImportPageCameraImportJob_private_offset);
	((BatchImportJobClass *) klass)->get_duplicated_file = (DuplicatedFile* (*) (BatchImportJob*)) import_page_camera_import_job_real_get_duplicated_file;
	((BatchImportJobClass *) klass)->get_exposure_time_override = (gint64 (*) (BatchImportJob*)) import_page_camera_import_job_real_get_exposure_time_override;
	((BatchImportJobClass *) klass)->get_dest_identifier = (gchar* (*) (BatchImportJob*)) import_page_camera_import_job_real_get_dest_identifier;
	((BatchImportJobClass *) klass)->get_source_identifier = (gchar* (*) (BatchImportJob*)) import_page_camera_import_job_real_get_source_identifier;
	((BatchImportJobClass *) klass)->get_basename = (gchar* (*) (BatchImportJob*)) import_page_camera_import_job_real_get_basename;
	((BatchImportJobClass *) klass)->get_path = (gchar* (*) (BatchImportJob*)) import_page_camera_import_job_real_get_path;
	((BatchImportJobClass *) klass)->set_associated = (void (*) (BatchImportJob*, BatchImportJob*)) import_page_camera_import_job_real_set_associated;
	((BatchImportJobClass *) klass)->is_directory = (gboolean (*) (BatchImportJob*)) import_page_camera_import_job_real_is_directory;
	((BatchImportJobClass *) klass)->determine_file_size = (gboolean (*) (BatchImportJob*, guint64*, GFile**)) import_page_camera_import_job_real_determine_file_size;
	((BatchImportJobClass *) klass)->prepare = (gboolean (*) (BatchImportJob*, GFile**, gboolean*, GError**)) import_page_camera_import_job_real_prepare;
	((BatchImportJobClass *) klass)->complete = (gboolean (*) (BatchImportJob*, MediaSource*, BatchImportRoll*, GError**)) import_page_camera_import_job_real_complete;
}

static void
import_page_camera_import_job_instance_init (ImportPageCameraImportJob * self,
                                             gpointer klass)
{
	self->priv = import_page_camera_import_job_get_instance_private (self);
	self->priv->associated = NULL;
	self->priv->associated_file = NULL;
}

static void
import_page_camera_import_job_finalize (BatchImportJob * obj)
{
	ImportPageCameraImportJob * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, IMPORT_PAGE_TYPE_CAMERA_IMPORT_JOB, ImportPageCameraImportJob);
	_gp_context_wrapper_unref0 (self->priv->context);
	_g_object_unref0 (self->priv->import_file);
	_gp_camera_unref0 (self->priv->camera);
	_g_free0 (self->priv->fulldir);
	_g_free0 (self->priv->filename);
	_media_metadata_unref0 (self->priv->metadata);
	_batch_import_job_unref0 (self->priv->associated);
	_backing_photo_row_unref0 (self->priv->associated_file);
	_g_object_unref0 (self->priv->duplicated_file);
	_g_object_unref0 (self->priv->file_settings);
	BATCH_IMPORT_JOB_CLASS (import_page_camera_import_job_parent_class)->finalize (obj);
}

static GType
import_page_camera_import_job_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ImportPageCameraImportJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) import_page_camera_import_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ImportPageCameraImportJob), 0, (GInstanceInitFunc) import_page_camera_import_job_instance_init, NULL };
	GType import_page_camera_import_job_type_id;
	import_page_camera_import_job_type_id = g_type_register_static (TYPE_BATCH_IMPORT_JOB, "ImportPageCameraImportJob", &g_define_type_info, 0);
	ImportPageCameraImportJob_private_offset = g_type_add_instance_private (import_page_camera_import_job_type_id, sizeof (ImportPageCameraImportJobPrivate));
	return import_page_camera_import_job_type_id;
}

static GType
import_page_camera_import_job_get_type (void)
{
	static volatile gsize import_page_camera_import_job_type_id__once = 0;
	if (g_once_init_enter (&import_page_camera_import_job_type_id__once)) {
		GType import_page_camera_import_job_type_id;
		import_page_camera_import_job_type_id = import_page_camera_import_job_get_type_once ();
		g_once_init_leave (&import_page_camera_import_job_type_id__once, import_page_camera_import_job_type_id);
	}
	return import_page_camera_import_job_type_id__once;
}

static guint
import_page_import_page_search_view_filter_real_get_criteria (SearchViewFilter* base)
{
	ImportPageImportPageSearchViewFilter * self;
	guint result;
	self = (ImportPageImportPageSearchViewFilter*) base;
	result = (guint) (SEARCH_FILTER_CRITERIA_TEXT | SEARCH_FILTER_CRITERIA_MEDIA);
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
import_page_import_page_search_view_filter_real_predicate (ViewFilter* base,
                                                           DataView* view)
{
	ImportPageImportPageSearchViewFilter * self;
	ImportSource* source = NULL;
	ImportSource* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	self = (ImportPageImportPageSearchViewFilter*) base;
	g_return_val_if_fail (view != NULL, FALSE);
	_tmp0_ = import_preview_get_import_source (G_TYPE_CHECK_INSTANCE_CAST (view, TYPE_IMPORT_PREVIEW, ImportPreview));
	source = _tmp0_;
	if ((gboolean) (SEARCH_FILTER_CRITERIA_MEDIA & search_view_filter_get_criteria ((SearchViewFilter*) self))) {
		_tmp1_ = search_view_filter_filter_by_media_type ((SearchViewFilter*) self);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ImportSource* _tmp2_;
		_tmp2_ = source;
		if (IS_VIDEO_IMPORT_SOURCE (_tmp2_)) {
			gboolean _tmp3_;
			gboolean _tmp4_;
			_tmp3_ = search_view_filter_get_show_media_video ((SearchViewFilter*) self);
			_tmp4_ = _tmp3_;
			if (!_tmp4_) {
				result = FALSE;
				_g_object_unref0 (source);
				return result;
			}
		} else {
			ImportSource* _tmp5_;
			_tmp5_ = source;
			if (IS_PHOTO_IMPORT_SOURCE (_tmp5_)) {
				PhotoImportSource* photo = NULL;
				ImportSource* _tmp6_;
				PhotoImportSource* _tmp7_;
				PhotoImportSource* _tmp8_;
				_tmp6_ = source;
				_tmp7_ = _g_object_ref0 (IS_PHOTO_IMPORT_SOURCE (_tmp6_) ? ((PhotoImportSource*) _tmp6_) : NULL);
				photo = _tmp7_;
				_tmp8_ = photo;
				if (photo_import_source_get_file_format (_tmp8_) == PHOTO_FILE_FORMAT_RAW) {
					PhotoImportSource* _tmp9_;
					PhotoImportSource* _tmp10_;
					PhotoImportSource* _tmp11_;
					gboolean _tmp12_;
					_tmp9_ = photo;
					_tmp10_ = photo_import_source_get_associated (_tmp9_);
					_tmp11_ = _tmp10_;
					_tmp12_ = _tmp11_ != NULL;
					_g_object_unref0 (_tmp11_);
					if (_tmp12_) {
						gboolean _tmp13_ = FALSE;
						gboolean _tmp14_;
						gboolean _tmp15_;
						_tmp14_ = search_view_filter_get_show_media_photos ((SearchViewFilter*) self);
						_tmp15_ = _tmp14_;
						if (!_tmp15_) {
							gboolean _tmp16_;
							gboolean _tmp17_;
							_tmp16_ = search_view_filter_get_show_media_raw ((SearchViewFilter*) self);
							_tmp17_ = _tmp16_;
							_tmp13_ = !_tmp17_;
						} else {
							_tmp13_ = FALSE;
						}
						if (_tmp13_) {
							result = FALSE;
							_g_object_unref0 (photo);
							_g_object_unref0 (source);
							return result;
						}
					} else {
						gboolean _tmp18_;
						gboolean _tmp19_;
						_tmp18_ = search_view_filter_get_show_media_raw ((SearchViewFilter*) self);
						_tmp19_ = _tmp18_;
						if (!_tmp19_) {
							result = FALSE;
							_g_object_unref0 (photo);
							_g_object_unref0 (source);
							return result;
						}
					}
				} else {
					gboolean _tmp20_;
					gboolean _tmp21_;
					_tmp20_ = search_view_filter_get_show_media_photos ((SearchViewFilter*) self);
					_tmp21_ = _tmp20_;
					if (!_tmp21_) {
						result = FALSE;
						_g_object_unref0 (photo);
						_g_object_unref0 (source);
						return result;
					}
				}
				_g_object_unref0 (photo);
			}
		}
	}
	if ((gboolean) (SEARCH_FILTER_CRITERIA_TEXT & search_view_filter_get_criteria ((SearchViewFilter*) self))) {
		const gchar* keywords = NULL;
		ImportSource* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		gint _tmp25_ = 0;
		gchar** _tmp26_;
		_tmp22_ = source;
		_tmp23_ = indexable_get_indexable_keywords ((Indexable*) _tmp22_);
		keywords = _tmp23_;
		_tmp24_ = keywords;
		if (is_string_empty (_tmp24_)) {
			result = FALSE;
			_g_object_unref0 (source);
			return result;
		}
		_tmp26_ = search_view_filter_get_search_filter_words ((SearchViewFilter*) self, &_tmp25_);
		{
			gchar** word_collection = NULL;
			gint word_collection_length1 = 0;
			gint _word_collection_size_ = 0;
			gint word_it = 0;
			word_collection = _tmp26_;
			word_collection_length1 = _tmp25_;
			for (word_it = 0; word_it < word_collection_length1; word_it = word_it + 1) {
				const gchar* word = NULL;
				word = word_collection[word_it];
				{
					const gchar* _tmp27_;
					const gchar* _tmp28_;
					_tmp27_ = keywords;
					_tmp28_ = word;
					if (!string_contains (_tmp27_, _tmp28_)) {
						result = FALSE;
						_g_object_unref0 (source);
						return result;
					}
				}
			}
		}
	}
	result = TRUE;
	_g_object_unref0 (source);
	return result;
}

static ImportPageImportPageSearchViewFilter*
import_page_import_page_search_view_filter_construct (GType object_type)
{
	ImportPageImportPageSearchViewFilter* self = NULL;
	self = (ImportPageImportPageSearchViewFilter*) search_view_filter_construct (object_type);
	return self;
}

static ImportPageImportPageSearchViewFilter*
import_page_import_page_search_view_filter_new (void)
{
	return import_page_import_page_search_view_filter_construct (IMPORT_PAGE_TYPE_IMPORT_PAGE_SEARCH_VIEW_FILTER);
}

static void
import_page_import_page_search_view_filter_class_init (ImportPageImportPageSearchViewFilterClass * klass,
                                                       gpointer klass_data)
{
	import_page_import_page_search_view_filter_parent_class = g_type_class_peek_parent (klass);
	((SearchViewFilterClass *) klass)->get_criteria = (guint (*) (SearchViewFilter*)) import_page_import_page_search_view_filter_real_get_criteria;
	((ViewFilterClass *) klass)->predicate = (gboolean (*) (ViewFilter*, DataView*)) import_page_import_page_search_view_filter_real_predicate;
}

static void
import_page_import_page_search_view_filter_instance_init (ImportPageImportPageSearchViewFilter * self,
                                                          gpointer klass)
{
}

static GType
import_page_import_page_search_view_filter_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ImportPageImportPageSearchViewFilterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) import_page_import_page_search_view_filter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ImportPageImportPageSearchViewFilter), 0, (GInstanceInitFunc) import_page_import_page_search_view_filter_instance_init, NULL };
	GType import_page_import_page_search_view_filter_type_id;
	import_page_import_page_search_view_filter_type_id = g_type_register_static (TYPE_SEARCH_VIEW_FILTER, "ImportPageImportPageSearchViewFilter", &g_define_type_info, 0);
	return import_page_import_page_search_view_filter_type_id;
}

static GType
import_page_import_page_search_view_filter_get_type (void)
{
	static volatile gsize import_page_import_page_search_view_filter_type_id__once = 0;
	if (g_once_init_enter (&import_page_import_page_search_view_filter_type_id__once)) {
		GType import_page_import_page_search_view_filter_type_id;
		import_page_import_page_search_view_filter_type_id = import_page_import_page_search_view_filter_get_type_once ();
		g_once_init_leave (&import_page_import_page_search_view_filter_type_id__once, import_page_import_page_search_view_filter_type_id);
	}
	return import_page_import_page_search_view_filter_type_id__once;
}

static gboolean
import_page_hide_imported_view_filter_real_predicate (ViewFilter* base,
                                                      DataView* view)
{
	ImportPageHideImportedViewFilter * self;
	gboolean result;
	self = (ImportPageHideImportedViewFilter*) base;
	g_return_val_if_fail (view != NULL, FALSE);
	result = !import_preview_is_already_imported (G_TYPE_CHECK_INSTANCE_CAST (view, TYPE_IMPORT_PREVIEW, ImportPreview));
	return result;
}

static ImportPageHideImportedViewFilter*
import_page_hide_imported_view_filter_construct (GType object_type)
{
	ImportPageHideImportedViewFilter* self = NULL;
	self = (ImportPageHideImportedViewFilter*) view_filter_construct (object_type);
	return self;
}

static ImportPageHideImportedViewFilter*
import_page_hide_imported_view_filter_new (void)
{
	return import_page_hide_imported_view_filter_construct (IMPORT_PAGE_TYPE_HIDE_IMPORTED_VIEW_FILTER);
}

static void
import_page_hide_imported_view_filter_class_init (ImportPageHideImportedViewFilterClass * klass,
                                                  gpointer klass_data)
{
	import_page_hide_imported_view_filter_parent_class = g_type_class_peek_parent (klass);
	((ViewFilterClass *) klass)->predicate = (gboolean (*) (ViewFilter*, DataView*)) import_page_hide_imported_view_filter_real_predicate;
}

static void
import_page_hide_imported_view_filter_instance_init (ImportPageHideImportedViewFilter * self,
                                                     gpointer klass)
{
}

static GType
import_page_hide_imported_view_filter_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ImportPageHideImportedViewFilterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) import_page_hide_imported_view_filter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ImportPageHideImportedViewFilter), 0, (GInstanceInitFunc) import_page_hide_imported_view_filter_instance_init, NULL };
	GType import_page_hide_imported_view_filter_type_id;
	import_page_hide_imported_view_filter_type_id = g_type_register_static (TYPE_VIEW_FILTER, "ImportPageHideImportedViewFilter", &g_define_type_info, 0);
	return import_page_hide_imported_view_filter_type_id;
}

static GType
import_page_hide_imported_view_filter_get_type (void)
{
	static volatile gsize import_page_hide_imported_view_filter_type_id__once = 0;
	if (g_once_init_enter (&import_page_hide_imported_view_filter_type_id__once)) {
		GType import_page_hide_imported_view_filter_type_id;
		import_page_hide_imported_view_filter_type_id = import_page_hide_imported_view_filter_get_type_once ();
		g_once_init_leave (&import_page_hide_imported_view_filter_type_id__once, import_page_hide_imported_view_filter_type_id);
	}
	return import_page_hide_imported_view_filter_type_id__once;
}

static void
import_page_class_init (ImportPageClass * klass,
                        gpointer klass_data)
{
	import_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ImportPage_private_offset);
	((PageClass *) klass)->add_toolbar_widgets = (void (*) (Page*, GtkActionBar*)) import_page_real_add_toolbar_widgets;
	((CheckerboardPageClass *) klass)->get_item_context_menu = (GtkMenu* (*) (CheckerboardPage*)) import_page_real_get_item_context_menu;
	((PageClass *) klass)->get_page_context_menu = (GtkMenu* (*) (Page*)) import_page_real_get_page_context_menu;
	((PageClass *) klass)->get_page_sidebar_menu = (GtkMenu* (*) (Page*)) import_page_real_get_page_sidebar_menu;
	((CheckerboardPageClass *) klass)->get_view_tracker = (CoreViewTracker* (*) (CheckerboardPage*)) import_page_real_get_view_tracker;
	((CheckerboardPageClass *) klass)->get_view_empty_message = (gchar* (*) (CheckerboardPage*)) import_page_real_get_view_empty_message;
	((PageClass *) klass)->init_collect_toggle_action_entries = (GtkToggleActionEntry* (*) (Page*, gint*)) import_page_real_init_collect_toggle_action_entries;
	((PageClass *) klass)->init_collect_action_entries = (GtkActionEntry* (*) (Page*, gint*)) import_page_real_init_collect_action_entries;
	((PageClass *) klass)->init_actions = (void (*) (Page*, gint, gint)) import_page_real_init_actions;
	((PageClass *) klass)->switched_to = (void (*) (Page*)) import_page_real_switched_to;
	((PageClass *) klass)->ready = (void (*) (Page*)) import_page_real_ready;
	((CheckerboardPageClass *) klass)->set_display_titles = (void (*) (CheckerboardPage*, gboolean)) import_page_real_set_display_titles;
	((CheckerboardPageClass *) klass)->get_search_view_filter = (SearchViewFilter* (*) (CheckerboardPage*)) import_page_real_get_search_view_filter;
	G_OBJECT_CLASS (klass)->finalize = import_page_finalize;
}

static void
import_page_instance_init (ImportPage * self,
                           gpointer klass)
{
	GtkLabel* _tmp0_;
	GtkProgressBar* _tmp1_;
	ImportPageImportPageSearchViewFilter* _tmp2_;
	ImportPageHideImportedViewFilter* _tmp3_;
	self->priv = import_page_get_instance_private (self);
	self->priv->import_sources = NULL;
	_tmp0_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp0_);
	self->priv->camera_label = _tmp0_;
	_tmp1_ = (GtkProgressBar*) gtk_progress_bar_new ();
	g_object_ref_sink (_tmp1_);
	self->priv->progress_bar = _tmp1_;
	self->priv->busy = FALSE;
	self->priv->refreshed = FALSE;
	self->priv->refresh_result = GP_OK;
	self->priv->refresh_error = NULL;
	self->priv->volume_monitor = NULL;
	self->priv->local_ref = NULL;
	_tmp2_ = import_page_import_page_search_view_filter_new ();
	self->priv->search_filter = _tmp2_;
	_tmp3_ = import_page_hide_imported_view_filter_new ();
	self->priv->hide_imported_filter = _tmp3_;
}

static void
import_page_finalize (GObject * obj)
{
	ImportPage * self;
	LibraryPhotoSourceCollection* _tmp0_;
	guint _tmp1_;
	VideoSourceCollection* _tmp2_;
	guint _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_IMPORT_PAGE, ImportPage);
	_tmp0_ = library_photo_global;
	g_signal_parse_name ("contents-altered", TYPE_DATA_COLLECTION, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((DataCollection*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _import_page_on_media_added_removed_data_collection_contents_altered, self);
	_tmp2_ = video_global;
	g_signal_parse_name ("contents-altered", TYPE_DATA_COLLECTION, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((DataCollection*) _tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _import_page_on_media_added_removed_data_collection_contents_altered, self);
	_data_collection_unref0 (self->priv->import_sources);
	_g_object_unref0 (self->priv->camera_label);
	_g_object_unref0 (self->priv->hide_imported);
	_g_object_unref0 (self->priv->progress_bar);
	_gp_camera_unref0 (self->priv->camera);
	_g_free0 (self->priv->uri);
	_g_free0 (self->priv->refresh_error);
	_g_free0 (self->priv->camera_name);
	_g_object_unref0 (self->priv->volume_monitor);
	_g_object_unref0 (self->priv->local_ref);
	_g_object_unref0 (self->priv->icon);
	_view_filter_unref0 (self->priv->search_filter);
	_view_filter_unref0 (self->priv->hide_imported_filter);
	_core_tracker_unref0 (self->priv->tracker);
	_g_object_unref0 (self->priv->page_context_menu);
	_g_object_unref0 (self->priv->import_context_menu);
	G_OBJECT_CLASS (import_page_parent_class)->finalize (obj);
}

static GType
import_page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ImportPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) import_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ImportPage), 0, (GInstanceInitFunc) import_page_instance_init, NULL };
	GType import_page_type_id;
	import_page_type_id = g_type_register_static (TYPE_CHECKERBOARD_PAGE, "ImportPage", &g_define_type_info, 0);
	ImportPage_private_offset = g_type_add_instance_private (import_page_type_id, sizeof (ImportPagePrivate));
	return import_page_type_id;
}

GType
import_page_get_type (void)
{
	static volatile gsize import_page_type_id__once = 0;
	if (g_once_init_enter (&import_page_type_id__once)) {
		GType import_page_type_id;
		import_page_type_id = import_page_get_type_once ();
		g_once_init_leave (&import_page_type_id__once, import_page_type_id);
	}
	return import_page_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

