/* LibraryWindow.c generated by valac 0.56.18, the Vala compiler
 * generated from LibraryWindow.vala, do not modify */

/*
* Copyright (c) 2018 elementary, Inc. (https://elementary.io)
*               2009-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <granite.h>
#include <gee.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <handy.h>

#define LIBRARY_WINDOW_MIN_PROGRESS_BAR_FILES 20
#define LIBRARY_WINDOW_STARTUP_SCAN_PROGRESS_PRIORITY 35
#define LIBRARY_WINDOW_REALTIME_UPDATE_PROGRESS_PRIORITY 40
#define LIBRARY_WINDOW_REALTIME_IMPORT_PROGRESS_PRIORITY 50
#define LIBRARY_WINDOW_METADATA_WRITER_PROGRESS_PRIORITY 30
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	LIBRARY_WINDOW_0_PROPERTY,
	LIBRARY_WINDOW_NUM_PROPERTIES
};
static GParamSpec* library_window_properties[LIBRARY_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _media_collection_registry_unref0(var) ((var == NULL) ? NULL : (var = (media_collection_registry_unref (var), NULL)))
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
#define _library_monitor_pool_unref0(var) ((var == NULL) ? NULL : (var = (library_monitor_pool_unref (var), NULL)))
#define _camera_table_unref0(var) ((var == NULL) ? NULL : (var = (camera_table_unref (var), NULL)))
typedef enum  {
	LIBRARY_WINDOW_SIDEBAR_ROOT_POSITION_LIBRARY,
	LIBRARY_WINDOW_SIDEBAR_ROOT_POSITION_CAMERAS,
	LIBRARY_WINDOW_SIDEBAR_ROOT_POSITION_SAVED_SEARCH,
	LIBRARY_WINDOW_SIDEBAR_ROOT_POSITION_EVENTS,
	LIBRARY_WINDOW_SIDEBAR_ROOT_POSITION_TAGS
} LibraryWindowSidebarRootPosition;

#define LIBRARY_WINDOW_TYPE_SIDEBAR_ROOT_POSITION (library_window_sidebar_root_position_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _one_shot_scheduler_unref0(var) ((var == NULL) ? NULL : (var = (one_shot_scheduler_unref (var), NULL)))

#define LIBRARY_WINDOW_TYPE_FULLSCREEN_PHOTO_PAGE (library_window_fullscreen_photo_page_get_type ())
#define LIBRARY_WINDOW_FULLSCREEN_PHOTO_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LIBRARY_WINDOW_TYPE_FULLSCREEN_PHOTO_PAGE, LibraryWindowFullscreenPhotoPage))
#define LIBRARY_WINDOW_FULLSCREEN_PHOTO_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LIBRARY_WINDOW_TYPE_FULLSCREEN_PHOTO_PAGE, LibraryWindowFullscreenPhotoPageClass))
#define LIBRARY_WINDOW_IS_FULLSCREEN_PHOTO_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LIBRARY_WINDOW_TYPE_FULLSCREEN_PHOTO_PAGE))
#define LIBRARY_WINDOW_IS_FULLSCREEN_PHOTO_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LIBRARY_WINDOW_TYPE_FULLSCREEN_PHOTO_PAGE))
#define LIBRARY_WINDOW_FULLSCREEN_PHOTO_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LIBRARY_WINDOW_TYPE_FULLSCREEN_PHOTO_PAGE, LibraryWindowFullscreenPhotoPageClass))

typedef struct _LibraryWindowFullscreenPhotoPage LibraryWindowFullscreenPhotoPage;
typedef struct _LibraryWindowFullscreenPhotoPageClass LibraryWindowFullscreenPhotoPageClass;
#define _batch_import_job_unref0(var) ((var == NULL) ? NULL : (var = (batch_import_job_unref (var), NULL)))
#define _view_filter_unref0(var) ((var == NULL) ? NULL : (var = (view_filter_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _LibraryWindowFullscreenPhotoPagePrivate LibraryWindowFullscreenPhotoPagePrivate;
enum  {
	LIBRARY_WINDOW_FULLSCREEN_PHOTO_PAGE_0_PROPERTY,
	LIBRARY_WINDOW_FULLSCREEN_PHOTO_PAGE_NUM_PROPERTIES
};
static GParamSpec* library_window_fullscreen_photo_page_properties[LIBRARY_WINDOW_FULLSCREEN_PHOTO_PAGE_NUM_PROPERTIES];
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _LibraryWindowPrivate {
	gchar* import_dir;
	GtkPaned* client_paned;
	GtkPaned* right_client_paned;
	MetadataView* metadata_sidebar;
	GtkScrolledWindow* scrolled_sidebar;
	GtkActionGroup* common_action_group;
	OneShotScheduler* properties_scheduler;
	gboolean notify_library_is_home_dir;
	GraniteWidgetsWelcome* welcome_page;
	GtkFrame* right_frame;
	SidebarTree* sidebar_tree;
	LibraryBranch* library_branch;
	TagsBranch* tags_branch;
	EventsBranch* events_branch;
	CameraBranch* camera_branch;
	SearchesBranch* saved_search_branch;
	gboolean page_switching_enabled;
	GeeHashMap* page_map;
	LibraryPhotoPage* photo_page;
	SearchFilterEntry* search_entry;
	GtkBox* page_header_box;
	TopDisplay* top_display;
	GtkNotebook* notebook;
	GtkBox* right_vbox;
};

struct _LibraryWindowFullscreenPhotoPage {
	LibraryPhotoPage parent_instance;
	LibraryWindowFullscreenPhotoPagePrivate * priv;
};

struct _LibraryWindowFullscreenPhotoPageClass {
	LibraryPhotoPageClass parent_class;
};

struct _LibraryWindowFullscreenPhotoPagePrivate {
	CollectionPage* collection;
	Photo* start;
	ViewCollection* view;
};

static gint LibraryWindow_private_offset;
static gpointer library_window_parent_class = NULL;
static GeeHashSet* library_window_initial_camera_uris;
static GeeHashSet* library_window_initial_camera_uris = NULL;
static GSettings* library_window_ui_settings;
static GSettings* library_window_ui_settings = NULL;
static gint LibraryWindowFullscreenPhotoPage_private_offset;
static gpointer library_window_fullscreen_photo_page_parent_class = NULL;

static void library_window_on_page_created (LibraryWindow* self,
                                     SidebarPageRepresentative* entry,
                                     Page* page);
static void _library_window_on_page_created_sidebar_tree_page_created (SidebarTree* _sender,
                                                                SidebarPageRepresentative* entry,
                                                                Page* page,
                                                                gpointer self);
static void library_window_on_destroying_page (LibraryWindow* self,
                                        SidebarPageRepresentative* entry,
                                        Page* page);
static void _library_window_on_destroying_page_sidebar_tree_destroying_page (SidebarTree* _sender,
                                                                      SidebarPageRepresentative* entry,
                                                                      Page* page,
                                                                      gpointer self);
static void library_window_on_sidebar_entry_selected (LibraryWindow* self,
                                               SidebarSelectableEntry* selectable);
static void _library_window_on_sidebar_entry_selected_sidebar_tree_entry_selected (SidebarTree* _sender,
                                                                            SidebarSelectableEntry* selectable,
                                                                            gpointer self);
static void library_window_on_sidebar_selected_entry_removed (LibraryWindow* self,
                                                       SidebarSelectableEntry* selectable);
static void _library_window_on_sidebar_selected_entry_removed_sidebar_tree_selected_entry_removed (SidebarTree* _sender,
                                                                                            SidebarSelectableEntry* removed,
                                                                                            gpointer self);
static void library_window_unsubscribe_from_basic_information (LibraryWindow* self,
                                                        Page* page);
static void library_window_on_media_altered (LibraryWindow* self);
static void _library_window_on_media_altered_data_collection_items_altered (DataCollection* _sender,
                                                                     GeeMap* items,
                                                                     gpointer self);
static void library_window_on_metadata_writer_progress (LibraryWindow* self,
                                                 guint completed,
                                                 guint total);
static void _library_window_on_metadata_writer_progress_metadata_writer_progress (MetadataWriter* _sender,
                                                                           guint completed,
                                                                           guint total,
                                                                           gpointer self);
static void library_window_on_library_monitor_destroyed (LibraryWindow* self,
                                                  LibraryMonitor* monitor);
static void library_window_on_library_monitor_installed (LibraryWindow* self,
                                                  LibraryMonitor* monitor);
static void _library_window_on_library_monitor_installed_library_monitor_pool_monitor_installed (LibraryMonitorPool* _sender,
                                                                                          LibraryMonitor* monitor,
                                                                                          gpointer self);
static void _library_window_on_library_monitor_destroyed_library_monitor_pool_monitor_destroyed (LibraryMonitorPool* _sender,
                                                                                          LibraryMonitor* monitor,
                                                                                          gpointer self);
static void library_window_on_camera_added (LibraryWindow* self,
                                     DiscoveredCamera* camera);
static void _library_window_on_camera_added_camera_table_camera_added (CameraTable* _sender,
                                                                DiscoveredCamera* camera,
                                                                gpointer self);
static GType library_window_sidebar_root_position_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void library_window_on_update_properties_now (LibraryWindow* self);
static void _library_window_on_update_properties_now_one_shot_callback (gpointer self);
static void library_window_load_configuration (LibraryWindow* self);
static void library_window_on_library_monitor_discovery_started (LibraryWindow* self);
static void _library_window_on_library_monitor_discovery_started_directory_monitor_discovery_started (DirectoryMonitor* _sender,
                                                                                               gpointer self);
static void library_window_on_library_monitor_discovery_completed (LibraryWindow* self);
static void _library_window_on_library_monitor_discovery_completed_directory_monitor_discovery_completed (DirectoryMonitor* _sender,
                                                                                                   gpointer self);
static void _library_window_on_library_monitor_discovery_completed_directory_monitor_closed (DirectoryMonitor* _sender,
                                                                                      gpointer self);
static void library_window_on_library_monitor_auto_update_progress (LibraryWindow* self,
                                                             gint completed_files,
                                                             gint total_files);
static void _library_window_on_library_monitor_auto_update_progress_library_monitor_auto_update_progress (LibraryMonitor* _sender,
                                                                                                   gint completed_files,
                                                                                                   gint total_files,
                                                                                                   gpointer self);
static void library_window_on_library_monitor_auto_import_preparing (LibraryWindow* self);
static void _library_window_on_library_monitor_auto_import_preparing_library_monitor_auto_import_preparing (LibraryMonitor* _sender,
                                                                                                     gpointer self);
static void library_window_on_library_monitor_auto_import_progress (LibraryWindow* self,
                                                             guint64 completed_bytes,
                                                             guint64 total_bytes);
static void _library_window_on_library_monitor_auto_import_progress_library_monitor_auto_import_progress (LibraryMonitor* _sender,
                                                                                                   guint64 completed_bytes,
                                                                                                   guint64 total_bytes,
                                                                                                   gpointer self);
static GtkActionEntry* library_window_create_common_actions (LibraryWindow* self,
                                                      gint* result_length1);
static void library_window_on_file_import (LibraryWindow* self);
static void _library_window_on_file_import_gcallback (GtkAction* action,
                                               gpointer self);
static void library_window_on_preferences (LibraryWindow* self);
static void _library_window_on_preferences_gcallback (GtkAction* action,
                                               gpointer self);
static void library_window_on_jump_to_event (LibraryWindow* self);
static void _library_window_on_jump_to_event_gcallback (GtkAction* action,
                                                 gpointer self);
static void library_window_on_find (LibraryWindow* self);
static void _library_window_on_find_gcallback (GtkAction* action,
                                        gpointer self);
static void library_window_on_new_search (LibraryWindow* self);
static void _library_window_on_new_search_gcallback (GtkAction* action,
                                              gpointer self);
static void _vala_array_add80 (GtkActionEntry* * array,
                        gint* length,
                        gint* size,
                        const GtkActionEntry* value);
static void _vala_array_add81 (GtkActionEntry* * array,
                        gint* length,
                        gint* size,
                        const GtkActionEntry* value);
static void _vala_array_add82 (GtkActionEntry* * array,
                        gint* length,
                        gint* size,
                        const GtkActionEntry* value);
static void _vala_array_add83 (GtkActionEntry* * array,
                        gint* length,
                        gint* size,
                        const GtkActionEntry* value);
static void _vala_array_add84 (GtkActionEntry* * array,
                        gint* length,
                        gint* size,
                        const GtkActionEntry* value);
static void _vala_array_add85 (GtkActionEntry* * array,
                        gint* length,
                        gint* size,
                        const GtkActionEntry* value);
static void _vala_array_add86 (GtkActionEntry* * array,
                        gint* length,
                        gint* size,
                        const GtkActionEntry* value);
static GtkToggleActionEntry* library_window_create_common_toggle_actions (LibraryWindow* self,
                                                                   gint* result_length1);
static void library_window_on_focus_search_entry (LibraryWindow* self,
                                           GtkAction* action);
static void _library_window_on_focus_search_entry_gcallback (GtkAction* action,
                                                      gpointer self);
static void _vala_array_add87 (GtkToggleActionEntry* * array,
                        gint* length,
                        gint* size,
                        const GtkToggleActionEntry* value);
static void library_window_on_display_sidebar (LibraryWindow* self,
                                        GtkAction* action);
static void _library_window_on_display_sidebar_gcallback (GtkAction* action,
                                                   gpointer self);
static gboolean library_window_is_sidebar_visible (LibraryWindow* self);
static void _vala_array_add88 (GtkToggleActionEntry* * array,
                        gint* length,
                        gint* size,
                        const GtkToggleActionEntry* value);
static void library_window_on_display_metadata_sidebar (LibraryWindow* self,
                                                 GtkAction* action);
static void _library_window_on_display_metadata_sidebar_gcallback (GtkAction* action,
                                                            gpointer self);
static void _vala_array_add89 (GtkToggleActionEntry* * array,
                        gint* length,
                        gint* size,
                        const GtkToggleActionEntry* value);
static void library_window_add_common_radio_actions (LibraryWindow* self,
                                              GtkActionGroup* group);
static void _vala_array_add90 (GtkRadioActionEntry* * array,
                        gint* length,
                        gint* size,
                        const GtkRadioActionEntry* value);
static void _vala_array_add91 (GtkRadioActionEntry* * array,
                        gint* length,
                        gint* size,
                        const GtkRadioActionEntry* value);
static void library_window_on_events_sort_changed (LibraryWindow* self,
                                            GtkAction* action,
                                            GtkAction* c);
static void _library_window_on_events_sort_changed_gcallback (GtkAction* action,
                                                       GtkAction* current,
                                                       gpointer self);
static GtkActionGroup** library_window_real_create_common_action_groups (AppWindow* base,
                                                                  gint* result_length1);
static void _vala_array_add92 (GtkActionGroup** * array,
                        gint* length,
                        gint* size,
                        GtkActionGroup* value);
static void library_window_real_switched_pages (PageWindow* base,
                                         Page* old_page,
                                         Page* new_page);
static void library_window_on_view_filter_installed (LibraryWindow* self,
                                              ViewFilter* filter);
static void _library_window_on_view_filter_installed_view_collection_view_filter_installed (ViewCollection* _sender,
                                                                                     ViewFilter* filer,
                                                                                     gpointer self);
static void library_window_on_view_filter_removed (LibraryWindow* self,
                                            ViewFilter* filter);
static void _library_window_on_view_filter_removed_view_collection_view_filter_removed (ViewCollection* _sender,
                                                                                 ViewFilter* filer,
                                                                                 gpointer self);
static void library_window_on_view_filter_refreshed (LibraryWindow* self);
static void _library_window_on_view_filter_refreshed_view_filter_refresh (ViewFilter* _sender,
                                                                   gpointer self);
static void library_window_real_show_all (GtkWidget* base);
static void library_window_init_view_filter (LibraryWindow* self,
                                      CheckerboardPage* page);
static void library_window_set_sidebar_visible (LibraryWindow* self,
                                         gboolean visible);
static gchar* library_window_real_get_app_role (AppWindow* base);
static void library_window_real_on_quit (AppWindow* base);
static Photo* library_window_get_start_fullscreen_photo (LibraryWindow* self,
                                                  CollectionPage* page);
static gboolean library_window_get_fullscreen_photo (LibraryWindow* self,
                                              Page* page,
                                              CollectionPage** collection,
                                              Photo** start,
                                              ViewCollection** view_collection);
static void library_window_real_on_fullscreen (AppWindow* base);
static GType library_window_fullscreen_photo_page_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static LibraryWindowFullscreenPhotoPage* library_window_fullscreen_photo_page_new (CollectionPage* collection,
                                                                            Photo* start,
                                                                            ViewCollection* view);
static LibraryWindowFullscreenPhotoPage* library_window_fullscreen_photo_page_construct (GType object_type,
                                                                                  CollectionPage* collection,
                                                                                  Photo* start,
                                                                                  ViewCollection* view);
VALA_EXTERN gboolean app_dirs_is_in_import_dir (GFile* file);
static void library_window_dispatch_import_jobs (LibraryWindow* self,
                                          GSList* uris,
                                          const gchar* job_name,
                                          gboolean copy_to_library);
static void _g_free0_ (gpointer var);
static inline void _g_slist_free__g_free0_ (GSList* self);
static void library_window_real_update_common_action_availability (AppWindow* base,
                                                            Page* old_page,
                                                            Page* new_page);
static void library_window_real_update_common_actions (AppWindow* base,
                                                Page* page,
                                                gint selected_count,
                                                gint count);
static gboolean library_window_can_jump_to_event (LibraryWindow* self);
static void _library_window_on_display_metadata_sidebar_gtk_toggle_action_toggled (GtkToggleAction* _sender,
                                                                            gpointer self);
static void library_window_import_reporter (LibraryWindow* self,
                                     ImportManifest* manifest);
VALA_EXTERN GFile* app_dirs_get_import_dir (void);
static void _library_window_import_reporter_batch_import_import_reporter (ImportManifest* manifest,
                                                                   BatchImportRoll* import_roll,
                                                                   gpointer self);
static GdkDragAction library_window_get_drag_action (LibraryWindow* self);
static gboolean library_window_real_drag_motion (GtkWidget* base,
                                          GdkDragContext* context,
                                          gint x,
                                          gint y,
                                          guint time);
static void library_window_real_drag_data_received (GtkWidget* base,
                                             GdkDragContext* context,
                                             gint x,
                                             gint y,
                                             GtkSelectionData* selection_data,
                                             guint info,
                                             guint time);
static void library_window_external_drop_handler (LibraryWindow* self,
                                           GdkDragContext* context,
                                           SidebarEntry* entry,
                                           GtkSelectionData* data,
                                           guint info,
                                           guint time);
static void library_window_remove_from_notebook (LibraryWindow* self,
                                          Page* page);
static void library_window_real_set_current_page (PageWindow* base,
                                           Page* page);
static gboolean library_window_is_search_sensitive (LibraryWindow* self);
static void library_window_on_update_properties (LibraryWindow* self);
static void library_window_subscribe_for_basic_information (LibraryWindow* self,
                                                     Page* page);
static void ____lambda17_ (LibraryWindow* self,
                    gint index);
static void _____lambda17__granite_widgets_welcome_activated (GraniteWidgetsWelcome* _sender,
                                                       gint index,
                                                       gpointer self);
static void _library_window_on_update_properties_view_collection_items_state_changed (ViewCollection* _sender,
                                                                               GeeIterable* changed,
                                                                               gpointer self);
static void _library_window_on_update_properties_data_collection_items_altered (DataCollection* _sender,
                                                                         GeeMap* items,
                                                                         gpointer self);
static void _library_window_on_update_properties_data_collection_contents_altered (DataCollection* _sender,
                                                                            GeeIterable* added,
                                                                            GeeIterable* removed,
                                                                            gpointer self);
static void _library_window_on_update_properties_view_collection_items_visibility_changed (ViewCollection* _sender,
                                                                                    GeeCollection* changed,
                                                                                    gpointer self);
static gboolean library_window_real_key_press_event (GtkWidget* base,
                                              GdkEventKey* event);
static void library_window_fullscreen_photo_page_real_switched_to (Page* base);
static void library_window_fullscreen_photo_page_finalize (GObject * obj);
static GType library_window_fullscreen_photo_page_get_type_once (void);
static GObject * library_window_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties);
static void _library_window_external_drop_handler_sidebar_tree_external_drop_handler (GdkDragContext* context,
                                                                               SidebarEntry* entry,
                                                                               GtkSelectionData* data,
                                                                               guint info,
                                                                               guint time,
                                                                               gpointer self);
static void _library_window___lambda123_ (LibraryWindow* self);
static void __library_window___lambda123__gtk_entry_activate (GtkEntry* _sender,
                                                       gpointer self);
static void library_window_finalize (GObject * obj);
static GType library_window_get_type_once (void);
static void _vala_library_window_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const gchar* LIBRARY_WINDOW_SUPPORTED_MOUNT_SCHEMES[3] = {"gphoto2:", "disk:", "file:"};
const GtkTargetEntry LIBRARY_WINDOW_DND_TARGET_ENTRIES[3] = {{"text/uri-list", (guint) GTK_TARGET_OTHER_APP, (guint) LIBRARY_WINDOW_TARGET_TYPE_URI_LIST}, {LIBRARY_WINDOW_MEDIA_LIST_MIME_TYPE, (guint) GTK_TARGET_SAME_APP, (guint) LIBRARY_WINDOW_TARGET_TYPE_MEDIA_LIST}, {LIBRARY_WINDOW_TAG_PATH_MIME_TYPE, (guint) GTK_TARGET_SAME_WIDGET, (guint) LIBRARY_WINDOW_TARGET_TYPE_TAG_PATH}};

static inline gpointer
library_window_get_instance_private (LibraryWindow* self)
{
	return G_STRUCT_MEMBER_P (self, LibraryWindow_private_offset);
}

static void
_library_window_on_page_created_sidebar_tree_page_created (SidebarTree* _sender,
                                                           SidebarPageRepresentative* entry,
                                                           Page* page,
                                                           gpointer self)
{
	library_window_on_page_created ((LibraryWindow*) self, entry, page);
}

static void
_library_window_on_destroying_page_sidebar_tree_destroying_page (SidebarTree* _sender,
                                                                 SidebarPageRepresentative* entry,
                                                                 Page* page,
                                                                 gpointer self)
{
	library_window_on_destroying_page ((LibraryWindow*) self, entry, page);
}

static void
_library_window_on_sidebar_entry_selected_sidebar_tree_entry_selected (SidebarTree* _sender,
                                                                       SidebarSelectableEntry* selectable,
                                                                       gpointer self)
{
	library_window_on_sidebar_entry_selected ((LibraryWindow*) self, selectable);
}

static void
_library_window_on_sidebar_selected_entry_removed_sidebar_tree_selected_entry_removed (SidebarTree* _sender,
                                                                                       SidebarSelectableEntry* removed,
                                                                                       gpointer self)
{
	library_window_on_sidebar_selected_entry_removed ((LibraryWindow*) self, removed);
}

static void
_library_window_on_media_altered_data_collection_items_altered (DataCollection* _sender,
                                                                GeeMap* items,
                                                                gpointer self)
{
	library_window_on_media_altered ((LibraryWindow*) self);
}

static void
_library_window_on_metadata_writer_progress_metadata_writer_progress (MetadataWriter* _sender,
                                                                      guint completed,
                                                                      guint total,
                                                                      gpointer self)
{
	library_window_on_metadata_writer_progress ((LibraryWindow*) self, completed, total);
}

static void
_library_window_on_library_monitor_installed_library_monitor_pool_monitor_installed (LibraryMonitorPool* _sender,
                                                                                     LibraryMonitor* monitor,
                                                                                     gpointer self)
{
	library_window_on_library_monitor_installed ((LibraryWindow*) self, monitor);
}

static void
_library_window_on_library_monitor_destroyed_library_monitor_pool_monitor_destroyed (LibraryMonitorPool* _sender,
                                                                                     LibraryMonitor* monitor,
                                                                                     gpointer self)
{
	library_window_on_library_monitor_destroyed ((LibraryWindow*) self, monitor);
}

static void
_library_window_on_camera_added_camera_table_camera_added (CameraTable* _sender,
                                                           DiscoveredCamera* camera,
                                                           gpointer self)
{
	library_window_on_camera_added ((LibraryWindow*) self, camera);
}

static GType
library_window_sidebar_root_position_get_type_once (void)
{
	static const GEnumValue values[] = {{LIBRARY_WINDOW_SIDEBAR_ROOT_POSITION_LIBRARY, "LIBRARY_WINDOW_SIDEBAR_ROOT_POSITION_LIBRARY", "library"}, {LIBRARY_WINDOW_SIDEBAR_ROOT_POSITION_CAMERAS, "LIBRARY_WINDOW_SIDEBAR_ROOT_POSITION_CAMERAS", "cameras"}, {LIBRARY_WINDOW_SIDEBAR_ROOT_POSITION_SAVED_SEARCH, "LIBRARY_WINDOW_SIDEBAR_ROOT_POSITION_SAVED_SEARCH", "saved-search"}, {LIBRARY_WINDOW_SIDEBAR_ROOT_POSITION_EVENTS, "LIBRARY_WINDOW_SIDEBAR_ROOT_POSITION_EVENTS", "events"}, {LIBRARY_WINDOW_SIDEBAR_ROOT_POSITION_TAGS, "LIBRARY_WINDOW_SIDEBAR_ROOT_POSITION_TAGS", "tags"}, {0, NULL, NULL}};
	GType library_window_sidebar_root_position_type_id;
	library_window_sidebar_root_position_type_id = g_enum_register_static ("LibraryWindowSidebarRootPosition", values);
	return library_window_sidebar_root_position_type_id;
}

static GType
library_window_sidebar_root_position_get_type (void)
{
	static volatile gsize library_window_sidebar_root_position_type_id__once = 0;
	if (g_once_init_enter (&library_window_sidebar_root_position_type_id__once)) {
		GType library_window_sidebar_root_position_type_id;
		library_window_sidebar_root_position_type_id = library_window_sidebar_root_position_get_type_once ();
		g_once_init_leave (&library_window_sidebar_root_position_type_id__once, library_window_sidebar_root_position_type_id);
	}
	return library_window_sidebar_root_position_type_id__once;
}

static GType
library_window_target_type_get_type_once (void)
{
	static const GEnumValue values[] = {{LIBRARY_WINDOW_TARGET_TYPE_URI_LIST, "LIBRARY_WINDOW_TARGET_TYPE_URI_LIST", "uri-list"}, {LIBRARY_WINDOW_TARGET_TYPE_MEDIA_LIST, "LIBRARY_WINDOW_TARGET_TYPE_MEDIA_LIST", "media-list"}, {LIBRARY_WINDOW_TARGET_TYPE_TAG_PATH, "LIBRARY_WINDOW_TARGET_TYPE_TAG_PATH", "tag-path"}, {0, NULL, NULL}};
	GType library_window_target_type_type_id;
	library_window_target_type_type_id = g_enum_register_static ("LibraryWindowTargetType", values);
	return library_window_target_type_type_id;
}

GType
library_window_target_type_get_type (void)
{
	static volatile gsize library_window_target_type_type_id__once = 0;
	if (g_once_init_enter (&library_window_target_type_type_id__once)) {
		GType library_window_target_type_type_id;
		library_window_target_type_type_id = library_window_target_type_get_type_once ();
		g_once_init_leave (&library_window_target_type_type_id__once, library_window_target_type_type_id);
	}
	return library_window_target_type_type_id__once;
}

static void
_library_window_on_update_properties_now_one_shot_callback (gpointer self)
{
	library_window_on_update_properties_now ((LibraryWindow*) self);
}

LibraryWindow*
library_window_construct (GType object_type,
                          ProgressMonitor progress_monitor,
                          gpointer progress_monitor_target)
{
	LibraryWindow * self = NULL;
	OneShotScheduler* _tmp0_;
	Page* start_page = NULL;
	LibraryBranch* _tmp1_;
	LibraryPhotosEntry* _tmp2_;
	LibraryPhotosEntry* _tmp3_;
	Page* _tmp4_;
	Page* _tmp5_;
	Page* _tmp6_;
	GtkTargetEntry* main_window_dnd_targets = NULL;
	GtkTargetEntry _tmp17_;
	GtkTargetEntry _tmp18_;
	GtkTargetEntry* _tmp19_;
	gint main_window_dnd_targets_length1;
	gint _main_window_dnd_targets_size_;
	GtkTargetEntry* _tmp20_;
	gint _tmp20__length1;
	MetadataWriter* _tmp21_;
	MetadataWriter* _tmp22_;
	LibraryMonitor* monitor = NULL;
	LibraryMonitorPool* _tmp23_;
	LibraryMonitorPool* _tmp24_;
	LibraryMonitor* _tmp25_;
	LibraryMonitor* _tmp26_;
	LibraryMonitor* _tmp27_;
	LibraryMonitorPool* _tmp29_;
	LibraryMonitorPool* _tmp30_;
	LibraryMonitorPool* _tmp31_;
	LibraryMonitorPool* _tmp32_;
	CameraTable* _tmp33_;
	CameraTable* _tmp34_;
	self = (LibraryWindow*) app_window_construct (object_type);
	thumbnail_cache_set_scale_factor (gtk_widget_get_scale_factor ((GtkWidget*) self));
	_tmp0_ = one_shot_scheduler_new ("LibraryWindow properties", _library_window_on_update_properties_now_one_shot_callback, self);
	_one_shot_scheduler_unref0 (self->priv->properties_scheduler);
	self->priv->properties_scheduler = _tmp0_;
	_tmp1_ = self->priv->library_branch;
	_tmp2_ = library_branch_get_photos_entry (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = sidebar_page_representative_get_page ((SidebarPageRepresentative*) _tmp3_);
	start_page = _tmp4_;
	_tmp5_ = start_page;
	library_window_switch_to_page (self, _tmp5_);
	_tmp6_ = start_page;
	gtk_widget_grab_focus ((GtkWidget*) _tmp6_);
	library_window_load_configuration (self);
	{
		GeeIterator* _media_sources_it = NULL;
		MediaCollectionRegistry* _tmp7_;
		MediaCollectionRegistry* _tmp8_;
		GeeCollection* _tmp9_;
		GeeCollection* _tmp10_;
		GeeIterator* _tmp11_;
		GeeIterator* _tmp12_;
		_tmp7_ = media_collection_registry_get_instance ();
		_tmp8_ = _tmp7_;
		_tmp9_ = media_collection_registry_get_all (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = gee_iterable_iterator ((GeeIterable*) _tmp10_);
		_tmp12_ = _tmp11_;
		_g_object_unref0 (_tmp10_);
		_media_collection_registry_unref0 (_tmp8_);
		_media_sources_it = _tmp12_;
		while (TRUE) {
			GeeIterator* _tmp13_;
			MediaSourceCollection* media_sources = NULL;
			GeeIterator* _tmp14_;
			gpointer _tmp15_;
			MediaSourceCollection* _tmp16_;
			_tmp13_ = _media_sources_it;
			if (!gee_iterator_next (_tmp13_)) {
				break;
			}
			_tmp14_ = _media_sources_it;
			_tmp15_ = gee_iterator_get (_tmp14_);
			media_sources = (MediaSourceCollection*) _tmp15_;
			_tmp16_ = media_sources;
			g_signal_connect_object ((DataCollection*) _tmp16_, "items-altered", (GCallback) _library_window_on_media_altered_data_collection_items_altered, self, 0);
			_data_collection_unref0 (media_sources);
		}
		_g_object_unref0 (_media_sources_it);
	}
	_tmp17_ = LIBRARY_WINDOW_DND_TARGET_ENTRIES[LIBRARY_WINDOW_TARGET_TYPE_URI_LIST];
	_tmp18_ = LIBRARY_WINDOW_DND_TARGET_ENTRIES[LIBRARY_WINDOW_TARGET_TYPE_MEDIA_LIST];
	_tmp19_ = g_new0 (GtkTargetEntry, 2);
	_tmp19_[0] = _tmp17_;
	_tmp19_[1] = _tmp18_;
	main_window_dnd_targets = _tmp19_;
	main_window_dnd_targets_length1 = 2;
	_main_window_dnd_targets_size_ = main_window_dnd_targets_length1;
	_tmp20_ = main_window_dnd_targets;
	_tmp20__length1 = main_window_dnd_targets_length1;
	gtk_drag_dest_set ((GtkWidget*) self, GTK_DEST_DEFAULT_ALL, _tmp20_, (gint) _tmp20__length1, (GDK_ACTION_COPY | GDK_ACTION_LINK) | GDK_ACTION_ASK);
	_tmp21_ = metadata_writer_get_instance ();
	_tmp22_ = _tmp21_;
	g_signal_connect_object (_tmp22_, "progress", (GCallback) _library_window_on_metadata_writer_progress_metadata_writer_progress, self, 0);
	_g_object_unref0 (_tmp22_);
	_tmp23_ = library_monitor_pool_get_instance ();
	_tmp24_ = _tmp23_;
	_tmp25_ = library_monitor_pool_get_monitor (_tmp24_);
	_tmp26_ = _tmp25_;
	_library_monitor_pool_unref0 (_tmp24_);
	monitor = _tmp26_;
	_tmp27_ = monitor;
	if (_tmp27_ != NULL) {
		LibraryMonitor* _tmp28_;
		_tmp28_ = monitor;
		library_window_on_library_monitor_installed (self, _tmp28_);
	}
	_tmp29_ = library_monitor_pool_get_instance ();
	_tmp30_ = _tmp29_;
	g_signal_connect_object (_tmp30_, "monitor-installed", (GCallback) _library_window_on_library_monitor_installed_library_monitor_pool_monitor_installed, self, 0);
	_library_monitor_pool_unref0 (_tmp30_);
	_tmp31_ = library_monitor_pool_get_instance ();
	_tmp32_ = _tmp31_;
	g_signal_connect_object (_tmp32_, "monitor-destroyed", (GCallback) _library_window_on_library_monitor_destroyed_library_monitor_pool_monitor_destroyed, self, 0);
	_library_monitor_pool_unref0 (_tmp32_);
	_tmp33_ = camera_table_get_instance ();
	_tmp34_ = _tmp33_;
	g_signal_connect_object (_tmp34_, "camera-added", (GCallback) _library_window_on_camera_added_camera_table_camera_added, self, 0);
	_camera_table_unref0 (_tmp34_);
	_g_object_unref0 (monitor);
	main_window_dnd_targets = (g_free (main_window_dnd_targets), NULL);
	_g_object_unref0 (start_page);
	return self;
}

LibraryWindow*
library_window_new (ProgressMonitor progress_monitor,
                    gpointer progress_monitor_target)
{
	return library_window_construct (TYPE_LIBRARY_WINDOW, progress_monitor, progress_monitor_target);
}

static void
_library_window_on_library_monitor_discovery_started_directory_monitor_discovery_started (DirectoryMonitor* _sender,
                                                                                          gpointer self)
{
	library_window_on_library_monitor_discovery_started ((LibraryWindow*) self);
}

static void
_library_window_on_library_monitor_discovery_completed_directory_monitor_discovery_completed (DirectoryMonitor* _sender,
                                                                                              gpointer self)
{
	library_window_on_library_monitor_discovery_completed ((LibraryWindow*) self);
}

static void
_library_window_on_library_monitor_discovery_completed_directory_monitor_closed (DirectoryMonitor* _sender,
                                                                                 gpointer self)
{
	library_window_on_library_monitor_discovery_completed ((LibraryWindow*) self);
}

static void
_library_window_on_library_monitor_auto_update_progress_library_monitor_auto_update_progress (LibraryMonitor* _sender,
                                                                                              gint completed_files,
                                                                                              gint total_files,
                                                                                              gpointer self)
{
	library_window_on_library_monitor_auto_update_progress ((LibraryWindow*) self, completed_files, total_files);
}

static void
_library_window_on_library_monitor_auto_import_preparing_library_monitor_auto_import_preparing (LibraryMonitor* _sender,
                                                                                                gpointer self)
{
	library_window_on_library_monitor_auto_import_preparing ((LibraryWindow*) self);
}

static void
_library_window_on_library_monitor_auto_import_progress_library_monitor_auto_import_progress (LibraryMonitor* _sender,
                                                                                              guint64 completed_bytes,
                                                                                              guint64 total_bytes,
                                                                                              gpointer self)
{
	library_window_on_library_monitor_auto_import_progress ((LibraryWindow*) self, completed_bytes, total_bytes);
}

static void
library_window_on_library_monitor_installed (LibraryWindow* self,
                                             LibraryMonitor* monitor)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitor != NULL);
	_tmp0_ = directory_monitor_get_root ((DirectoryMonitor*) monitor);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_get_path (_tmp1_);
	_tmp3_ = _tmp2_;
	g_debug ("LibraryWindow.vala:362: on_library_monitor_installed: %s", _tmp3_);
	_g_free0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	g_signal_connect_object ((DirectoryMonitor*) monitor, "discovery-started", (GCallback) _library_window_on_library_monitor_discovery_started_directory_monitor_discovery_started, self, 0);
	g_signal_connect_object ((DirectoryMonitor*) monitor, "discovery-completed", (GCallback) _library_window_on_library_monitor_discovery_completed_directory_monitor_discovery_completed, self, 0);
	g_signal_connect_object ((DirectoryMonitor*) monitor, "closed", (GCallback) _library_window_on_library_monitor_discovery_completed_directory_monitor_closed, self, 0);
	g_signal_connect_object (monitor, "auto-update-progress", (GCallback) _library_window_on_library_monitor_auto_update_progress_library_monitor_auto_update_progress, self, 0);
	g_signal_connect_object (monitor, "auto-import-preparing", (GCallback) _library_window_on_library_monitor_auto_import_preparing_library_monitor_auto_import_preparing, self, 0);
	g_signal_connect_object (monitor, "auto-import-progress", (GCallback) _library_window_on_library_monitor_auto_import_progress_library_monitor_auto_import_progress, self, 0);
}

static void
library_window_on_library_monitor_destroyed (LibraryWindow* self,
                                             LibraryMonitor* monitor)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitor != NULL);
	_tmp0_ = directory_monitor_get_root ((DirectoryMonitor*) monitor);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_get_path (_tmp1_);
	_tmp3_ = _tmp2_;
	g_debug ("LibraryWindow.vala:373: on_library_monitor_destroyed: %s", _tmp3_);
	_g_free0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	g_signal_parse_name ("discovery-started", TYPE_DIRECTORY_MONITOR, &_tmp4_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((DirectoryMonitor*) monitor, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _library_window_on_library_monitor_discovery_started_directory_monitor_discovery_started, self);
	g_signal_parse_name ("discovery-completed", TYPE_DIRECTORY_MONITOR, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((DirectoryMonitor*) monitor, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _library_window_on_library_monitor_discovery_completed_directory_monitor_discovery_completed, self);
	g_signal_parse_name ("closed", TYPE_DIRECTORY_MONITOR, &_tmp6_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((DirectoryMonitor*) monitor, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _library_window_on_library_monitor_discovery_completed_directory_monitor_closed, self);
	g_signal_parse_name ("auto-update-progress", TYPE_LIBRARY_MONITOR, &_tmp7_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (monitor, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _library_window_on_library_monitor_auto_update_progress_library_monitor_auto_update_progress, self);
	g_signal_parse_name ("auto-import-preparing", TYPE_LIBRARY_MONITOR, &_tmp8_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (monitor, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _library_window_on_library_monitor_auto_import_preparing_library_monitor_auto_import_preparing, self);
	g_signal_parse_name ("auto-import-progress", TYPE_LIBRARY_MONITOR, &_tmp9_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (monitor, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _library_window_on_library_monitor_auto_import_progress_library_monitor_auto_import_progress, self);
}

static void
_library_window_on_file_import_gcallback (GtkAction* action,
                                          gpointer self)
{
	library_window_on_file_import ((LibraryWindow*) self);
}

static void
_library_window_on_preferences_gcallback (GtkAction* action,
                                          gpointer self)
{
	library_window_on_preferences ((LibraryWindow*) self);
}

static void
_library_window_on_jump_to_event_gcallback (GtkAction* action,
                                            gpointer self)
{
	library_window_on_jump_to_event ((LibraryWindow*) self);
}

static void
_library_window_on_find_gcallback (GtkAction* action,
                                   gpointer self)
{
	library_window_on_find ((LibraryWindow*) self);
}

static void
_library_window_on_new_search_gcallback (GtkAction* action,
                                         gpointer self)
{
	library_window_on_new_search ((LibraryWindow*) self);
}

static void
_vala_array_add80 (GtkActionEntry* * array,
                   gint* length,
                   gint* size,
                   const GtkActionEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_array_add81 (GtkActionEntry* * array,
                   gint* length,
                   gint* size,
                   const GtkActionEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_array_add82 (GtkActionEntry* * array,
                   gint* length,
                   gint* size,
                   const GtkActionEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_array_add83 (GtkActionEntry* * array,
                   gint* length,
                   gint* size,
                   const GtkActionEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_array_add84 (GtkActionEntry* * array,
                   gint* length,
                   gint* size,
                   const GtkActionEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_array_add85 (GtkActionEntry* * array,
                   gint* length,
                   gint* size,
                   const GtkActionEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_array_add86 (GtkActionEntry* * array,
                   gint* length,
                   gint* size,
                   const GtkActionEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static GtkActionEntry*
library_window_create_common_actions (LibraryWindow* self,
                                      gint* result_length1)
{
	GtkActionEntry import = {0};
	GtkActionEntry _tmp0_ = {0};
	GtkActionEntry sort = {0};
	GtkActionEntry _tmp1_ = {0};
	GtkActionEntry preferences = {0};
	GtkActionEntry _tmp2_ = {0};
	GtkActionEntry jump_to_event = {0};
	GtkActionEntry _tmp3_ = {0};
	GtkActionEntry find = {0};
	GtkActionEntry _tmp4_ = {0};
	GtkActionEntry filter_photos = {0};
	GtkActionEntry _tmp5_ = {0};
	GtkActionEntry new_search = {0};
	GtkActionEntry _tmp6_ = {0};
	GtkActionEntry* actions = NULL;
	GtkActionEntry* _tmp7_;
	gint actions_length1;
	gint _actions_size_;
	GtkActionEntry _tmp8_;
	GtkActionEntry _tmp9_;
	GtkActionEntry _tmp10_;
	GtkActionEntry _tmp11_;
	GtkActionEntry _tmp12_;
	GtkActionEntry _tmp13_;
	GtkActionEntry _tmp14_;
	GtkActionEntry* _tmp15_;
	gint _tmp15__length1;
	GtkActionEntry* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_.name = "CommonFileImport";
	_tmp0_.stock_id = NULL;
	_tmp0_.label = NULL;
	_tmp0_.accelerator = "<Ctrl>I";
	_tmp0_.tooltip = NULL;
	_tmp0_.callback = (GCallback) _library_window_on_file_import_gcallback;
	import = _tmp0_;
	_tmp1_.name = "CommonSortEvents";
	_tmp1_.stock_id = NULL;
	_tmp1_.label = _ ("Sort _Events");
	_tmp1_.accelerator = NULL;
	_tmp1_.tooltip = NULL;
	_tmp1_.callback = (GCallback) NULL;
	sort = _tmp1_;
	_tmp2_.name = "CommonPreferences";
	_tmp2_.stock_id = NULL;
	_tmp2_.label = NULL;
	_tmp2_.accelerator = NULL;
	_tmp2_.tooltip = NULL;
	_tmp2_.callback = (GCallback) _library_window_on_preferences_gcallback;
	preferences = _tmp2_;
	_tmp3_.name = "CommonJumpToEvent";
	_tmp3_.stock_id = NULL;
	_tmp3_.label = _ ("View Eve_nt for Photo");
	_tmp3_.accelerator = NULL;
	_tmp3_.tooltip = NULL;
	_tmp3_.callback = (GCallback) _library_window_on_jump_to_event_gcallback;
	jump_to_event = _tmp3_;
	_tmp4_.name = "CommonFind";
	_tmp4_.stock_id = NULL;
	_tmp4_.label = NULL;
	_tmp4_.accelerator = NULL;
	_tmp4_.tooltip = NULL;
	_tmp4_.callback = (GCallback) _library_window_on_find_gcallback;
	find = _tmp4_;
	_tmp5_.name = "CommonFilterPhotos";
	_tmp5_.stock_id = NULL;
	_tmp5_.label = RESOURCES_FILTER_PHOTOS_MENU;
	_tmp5_.accelerator = NULL;
	_tmp5_.tooltip = NULL;
	_tmp5_.callback = (GCallback) NULL;
	filter_photos = _tmp5_;
	_tmp6_.name = "CommonNewSearch";
	_tmp6_.stock_id = NULL;
	_tmp6_.label = _ ("New Smart Album…");
	_tmp6_.accelerator = "<Ctrl>S";
	_tmp6_.tooltip = NULL;
	_tmp6_.callback = (GCallback) _library_window_on_new_search_gcallback;
	new_search = _tmp6_;
	_tmp7_ = g_new0 (GtkActionEntry, 0);
	actions = _tmp7_;
	actions_length1 = 0;
	_actions_size_ = actions_length1;
	_tmp8_ = import;
	_vala_array_add80 (&actions, &actions_length1, &_actions_size_, &_tmp8_);
	_tmp9_ = sort;
	_vala_array_add81 (&actions, &actions_length1, &_actions_size_, &_tmp9_);
	_tmp10_ = preferences;
	_vala_array_add82 (&actions, &actions_length1, &_actions_size_, &_tmp10_);
	_tmp11_ = jump_to_event;
	_vala_array_add83 (&actions, &actions_length1, &_actions_size_, &_tmp11_);
	_tmp12_ = find;
	_vala_array_add84 (&actions, &actions_length1, &_actions_size_, &_tmp12_);
	_tmp13_ = filter_photos;
	_vala_array_add85 (&actions, &actions_length1, &_actions_size_, &_tmp13_);
	_tmp14_ = new_search;
	_vala_array_add86 (&actions, &actions_length1, &_actions_size_, &_tmp14_);
	_tmp15_ = actions;
	_tmp15__length1 = actions_length1;
	if (result_length1) {
		*result_length1 = _tmp15__length1;
	}
	result = _tmp15_;
	return result;
}

static void
_library_window_on_focus_search_entry_gcallback (GtkAction* action,
                                                 gpointer self)
{
	library_window_on_focus_search_entry ((LibraryWindow*) self, action);
}

static void
_vala_array_add87 (GtkToggleActionEntry* * array,
                   gint* length,
                   gint* size,
                   const GtkToggleActionEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkToggleActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_library_window_on_display_sidebar_gcallback (GtkAction* action,
                                              gpointer self)
{
	library_window_on_display_sidebar ((LibraryWindow*) self, action);
}

static void
_vala_array_add88 (GtkToggleActionEntry* * array,
                   gint* length,
                   gint* size,
                   const GtkToggleActionEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkToggleActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_library_window_on_display_metadata_sidebar_gcallback (GtkAction* action,
                                                       gpointer self)
{
	library_window_on_display_metadata_sidebar ((LibraryWindow*) self, action);
}

static void
_vala_array_add89 (GtkToggleActionEntry* * array,
                   gint* length,
                   gint* size,
                   const GtkToggleActionEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkToggleActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static GtkToggleActionEntry*
library_window_create_common_toggle_actions (LibraryWindow* self,
                                             gint* result_length1)
{
	GtkToggleActionEntry* actions = NULL;
	GtkToggleActionEntry* _tmp0_;
	gint actions_length1;
	gint _actions_size_;
	GtkToggleActionEntry searchbar = {0};
	GtkToggleActionEntry _tmp1_ = {0};
	GtkToggleActionEntry _tmp2_;
	GtkToggleActionEntry sidebar = {0};
	GtkToggleActionEntry _tmp3_ = {0};
	GtkToggleActionEntry _tmp4_;
	GtkToggleActionEntry meta_sidebar = {0};
	GtkToggleActionEntry _tmp5_ = {0};
	GtkToggleActionEntry _tmp6_;
	GtkToggleActionEntry* _tmp7_;
	gint _tmp7__length1;
	GtkToggleActionEntry* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (GtkToggleActionEntry, 0);
	actions = _tmp0_;
	actions_length1 = 0;
	_actions_size_ = actions_length1;
	_tmp1_.name = "CommonDisplaySearchbar";
	_tmp1_.stock_id = NULL;
	_tmp1_.label = TRANSLATABLE;
	_tmp1_.accelerator = "<Ctrl>F";
	_tmp1_.tooltip = TRANSLATABLE;
	_tmp1_.callback = (GCallback) _library_window_on_focus_search_entry_gcallback;
	_tmp1_.is_active = TRUE;
	searchbar = _tmp1_;
	_tmp2_ = searchbar;
	_vala_array_add87 (&actions, &actions_length1, &_actions_size_, &_tmp2_);
	_tmp3_.name = "CommonDisplaySidebar";
	_tmp3_.stock_id = NULL;
	_tmp3_.label = NULL;
	_tmp3_.accelerator = "F9";
	_tmp3_.tooltip = NULL;
	_tmp3_.callback = (GCallback) _library_window_on_display_sidebar_gcallback;
	_tmp3_.is_active = library_window_is_sidebar_visible (self);
	sidebar = _tmp3_;
	_tmp4_ = sidebar;
	_vala_array_add88 (&actions, &actions_length1, &_actions_size_, &_tmp4_);
	_tmp5_.name = "CommonDisplayMetadataSidebar";
	_tmp5_.stock_id = NULL;
	_tmp5_.label = _ ("Edit Photo In_fo");
	_tmp5_.accelerator = "F10";
	_tmp5_.tooltip = _ ("Edit Photo In_fo");
	_tmp5_.callback = (GCallback) _library_window_on_display_metadata_sidebar_gcallback;
	_tmp5_.is_active = library_window_is_metadata_sidebar_visible (self);
	meta_sidebar = _tmp5_;
	_tmp6_ = meta_sidebar;
	_vala_array_add89 (&actions, &actions_length1, &_actions_size_, &_tmp6_);
	_tmp7_ = actions;
	_tmp7__length1 = actions_length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	return result;
}

static void
_vala_array_add90 (GtkRadioActionEntry* * array,
                   gint* length,
                   gint* size,
                   const GtkRadioActionEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkRadioActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_array_add91 (GtkRadioActionEntry* * array,
                   gint* length,
                   gint* size,
                   const GtkRadioActionEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkRadioActionEntry, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_library_window_on_events_sort_changed_gcallback (GtkAction* action,
                                                  GtkAction* current,
                                                  gpointer self)
{
	library_window_on_events_sort_changed ((LibraryWindow*) self, action, current);
}

static void
library_window_add_common_radio_actions (LibraryWindow* self,
                                         GtkActionGroup* group)
{
	GtkRadioActionEntry* actions = NULL;
	GtkRadioActionEntry* _tmp0_;
	gint actions_length1;
	gint _actions_size_;
	GtkRadioActionEntry ascending = {0};
	GtkRadioActionEntry _tmp1_ = {0};
	GtkRadioActionEntry _tmp2_;
	GtkRadioActionEntry descending = {0};
	GtkRadioActionEntry _tmp3_ = {0};
	GtkRadioActionEntry _tmp4_;
	GtkRadioActionEntry* _tmp5_;
	gint _tmp5__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	_tmp0_ = g_new0 (GtkRadioActionEntry, 0);
	actions = _tmp0_;
	actions_length1 = 0;
	_actions_size_ = actions_length1;
	_tmp1_.name = "CommonSortEventsAscending";
	_tmp1_.stock_id = NULL;
	_tmp1_.label = _ ("_Ascending");
	_tmp1_.accelerator = NULL;
	_tmp1_.tooltip = _ ("Sort photos in an ascending order");
	_tmp1_.value = LIBRARY_WINDOW_SORT_EVENTS_ORDER_ASCENDING;
	ascending = _tmp1_;
	_tmp2_ = ascending;
	_vala_array_add90 (&actions, &actions_length1, &_actions_size_, &_tmp2_);
	_tmp3_.name = "CommonSortEventsDescending";
	_tmp3_.stock_id = NULL;
	_tmp3_.label = _ ("D_escending");
	_tmp3_.accelerator = NULL;
	_tmp3_.tooltip = _ ("Sort photos in a descending order");
	_tmp3_.value = LIBRARY_WINDOW_SORT_EVENTS_ORDER_DESCENDING;
	descending = _tmp3_;
	_tmp4_ = descending;
	_vala_array_add91 (&actions, &actions_length1, &_actions_size_, &_tmp4_);
	_tmp5_ = actions;
	_tmp5__length1 = actions_length1;
	gtk_action_group_add_radio_actions (group, _tmp5_, (guint) _tmp5__length1, LIBRARY_WINDOW_SORT_EVENTS_ORDER_ASCENDING, (GCallback) _library_window_on_events_sort_changed_gcallback, self);
	actions = (g_free (actions), NULL);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_vala_array_add92 (GtkActionGroup** * array,
                   gint* length,
                   gint* size,
                   GtkActionGroup* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkActionGroup*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static GtkActionGroup**
library_window_real_create_common_action_groups (AppWindow* base,
                                                 gint* result_length1)
{
	LibraryWindow * self;
	GtkActionGroup** groups = NULL;
	gint _tmp0_ = 0;
	GtkActionGroup** _tmp1_;
	gint groups_length1;
	gint _groups_size_;
	GtkActionGroup* _tmp2_;
	gint _tmp3_ = 0;
	GtkActionEntry* _tmp4_;
	GtkActionEntry* _tmp5_;
	gint _tmp5__length1;
	GtkActionGroup* _tmp6_;
	gint _tmp7_ = 0;
	GtkToggleActionEntry* _tmp8_;
	GtkToggleActionEntry* _tmp9_;
	gint _tmp9__length1;
	GtkActionGroup* _tmp10_;
	GtkAction* action = NULL;
	GtkActionGroup* _tmp11_;
	GtkAction* _tmp12_;
	GtkAction* _tmp13_;
	GtkAction* _tmp14_;
	GtkActionGroup* _tmp17_;
	GtkActionGroup* _tmp18_;
	GtkActionGroup** _tmp19_;
	gint _tmp19__length1;
	GtkActionGroup** result;
	self = (LibraryWindow*) base;
	_tmp1_ = APP_WINDOW_CLASS (library_window_parent_class)->create_common_action_groups (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_APP_WINDOW, AppWindow), &_tmp0_);
	groups = _tmp1_;
	groups_length1 = _tmp0_;
	_groups_size_ = groups_length1;
	_tmp2_ = self->priv->common_action_group;
	_tmp4_ = library_window_create_common_actions (self, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp3_;
	gtk_action_group_add_actions (_tmp2_, _tmp5_, (guint) _tmp3_, self);
	_tmp5_ = (g_free (_tmp5_), NULL);
	_tmp6_ = self->priv->common_action_group;
	_tmp8_ = library_window_create_common_toggle_actions (self, &_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp9__length1 = _tmp7_;
	gtk_action_group_add_toggle_actions (_tmp6_, _tmp9_, (guint) _tmp7_, self);
	_tmp9_ = (g_free (_tmp9_), NULL);
	_tmp10_ = self->priv->common_action_group;
	library_window_add_common_radio_actions (self, _tmp10_);
	_tmp11_ = self->priv->common_action_group;
	_tmp12_ = gtk_action_group_get_action (_tmp11_, "CommonDisplaySearchbar");
	_tmp13_ = _g_object_ref0 (_tmp12_);
	action = _tmp13_;
	_tmp14_ = action;
	if (_tmp14_ != NULL) {
		GtkAction* _tmp15_;
		GtkAction* _tmp16_;
		_tmp15_ = action;
		gtk_action_set_short_label (_tmp15_, RESOURCES_FIND_LABEL);
		_tmp16_ = action;
		gtk_action_set_is_important (_tmp16_, TRUE);
	}
	_tmp17_ = self->priv->common_action_group;
	_tmp18_ = _g_object_ref0 (_tmp17_);
	_vala_array_add92 (&groups, &groups_length1, &_groups_size_, _tmp18_);
	_tmp19_ = groups;
	_tmp19__length1 = groups_length1;
	if (result_length1) {
		*result_length1 = _tmp19__length1;
	}
	result = _tmp19_;
	_g_object_unref0 (action);
	return result;
}

static void
_library_window_on_view_filter_installed_view_collection_view_filter_installed (ViewCollection* _sender,
                                                                                ViewFilter* filer,
                                                                                gpointer self)
{
	library_window_on_view_filter_installed ((LibraryWindow*) self, filer);
}

static void
_library_window_on_view_filter_removed_view_collection_view_filter_removed (ViewCollection* _sender,
                                                                            ViewFilter* filer,
                                                                            gpointer self)
{
	library_window_on_view_filter_removed ((LibraryWindow*) self, filer);
}

static void
library_window_real_switched_pages (PageWindow* base,
                                    Page* old_page,
                                    Page* new_page)
{
	LibraryWindow * self;
	self = (LibraryWindow*) base;
	PAGE_WINDOW_CLASS (library_window_parent_class)->switched_pages ((PageWindow*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_APP_WINDOW, AppWindow), old_page, new_page);
	if (old_page != NULL) {
		ViewCollection* _tmp0_;
		ViewCollection* _tmp1_;
		guint _tmp2_;
		ViewCollection* _tmp3_;
		ViewCollection* _tmp4_;
		guint _tmp5_;
		_tmp0_ = page_get_view (old_page);
		_tmp1_ = _tmp0_;
		g_signal_parse_name ("view-filter-installed", TYPE_VIEW_COLLECTION, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _library_window_on_view_filter_installed_view_collection_view_filter_installed, self);
		_data_collection_unref0 (_tmp1_);
		_tmp3_ = page_get_view (old_page);
		_tmp4_ = _tmp3_;
		g_signal_parse_name ("view-filter-removed", TYPE_VIEW_COLLECTION, &_tmp5_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _library_window_on_view_filter_removed_view_collection_view_filter_removed, self);
		_data_collection_unref0 (_tmp4_);
	}
	if (new_page != NULL) {
		ViewCollection* _tmp6_;
		ViewCollection* _tmp7_;
		ViewCollection* _tmp8_;
		ViewCollection* _tmp9_;
		_tmp6_ = page_get_view (new_page);
		_tmp7_ = _tmp6_;
		g_signal_connect_object (_tmp7_, "view-filter-installed", (GCallback) _library_window_on_view_filter_installed_view_collection_view_filter_installed, self, 0);
		_data_collection_unref0 (_tmp7_);
		_tmp8_ = page_get_view (new_page);
		_tmp9_ = _tmp8_;
		g_signal_connect_object (_tmp9_, "view-filter-removed", (GCallback) _library_window_on_view_filter_removed_view_collection_view_filter_removed, self, 0);
		_data_collection_unref0 (_tmp9_);
	}
}

static void
_library_window_on_view_filter_refreshed_view_filter_refresh (ViewFilter* _sender,
                                                              gpointer self)
{
	library_window_on_view_filter_refreshed ((LibraryWindow*) self);
}

static void
library_window_on_view_filter_installed (LibraryWindow* self,
                                         ViewFilter* filter)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (filter != NULL);
	g_signal_connect_object (filter, "refresh", (GCallback) _library_window_on_view_filter_refreshed_view_filter_refresh, self, 0);
}

static void
library_window_on_view_filter_removed (LibraryWindow* self,
                                       ViewFilter* filter)
{
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filter != NULL);
	g_signal_parse_name ("refresh", TYPE_VIEW_FILTER, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (filter, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _library_window_on_view_filter_refreshed_view_filter_refresh, self);
}

static void
library_window_on_view_filter_refreshed (LibraryWindow* self)
{
	Page* _tmp0_;
	Page* _tmp1_;
	ViewCollection* _tmp2_;
	ViewCollection* _tmp3_;
	gboolean _tmp4_;
	GtkToggleAction* display_searchbar = NULL;
	GtkAction* _tmp5_;
	GtkToggleAction* _tmp6_;
	GtkToggleAction* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = page_window_get_current_page ((PageWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = page_get_view (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = !view_collection_are_items_filtered_out (_tmp3_);
	_data_collection_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	if (_tmp4_) {
		return;
	}
	_tmp5_ = app_window_get_common_action ((AppWindow*) self, "CommonDisplaySearchbar");
	_tmp6_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp5_) : NULL;
	if (_tmp6_ == NULL) {
		_g_object_unref0 (_tmp5_);
	}
	display_searchbar = _tmp6_;
	_tmp7_ = display_searchbar;
	if (_tmp7_ != NULL) {
		GtkToggleAction* _tmp8_;
		_tmp8_ = display_searchbar;
		gtk_toggle_action_set_active (_tmp8_, TRUE);
	}
	_g_object_unref0 (display_searchbar);
}

static void
library_window_real_show_all (GtkWidget* base)
{
	LibraryWindow * self;
	CheckerboardPage* current_page = NULL;
	Page* _tmp0_;
	CheckerboardPage* _tmp1_;
	CheckerboardPage* _tmp2_;
	self = (LibraryWindow*) base;
	GTK_WIDGET_CLASS (library_window_parent_class)->show_all ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_APP_WINDOW, AppWindow));
	_tmp0_ = page_window_get_current_page ((PageWindow*) self);
	_tmp1_ = IS_CHECKERBOARD_PAGE (_tmp0_) ? ((CheckerboardPage*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (_tmp0_);
	}
	current_page = _tmp1_;
	_tmp2_ = current_page;
	if (_tmp2_ != NULL) {
		CheckerboardPage* _tmp3_;
		_tmp3_ = current_page;
		library_window_init_view_filter (self, _tmp3_);
	}
	library_window_set_sidebar_visible (self, library_window_is_sidebar_visible (self));
	library_window_set_metadata_sidebar_visible (self, library_window_is_metadata_sidebar_visible (self));
	_g_object_unref0 (current_page);
}

LibraryWindow*
library_window_get_app (void)
{
	AppWindow* _tmp0_;
	AppWindow* _tmp1_;
	LibraryWindow* _tmp2_;
	LibraryWindow* result;
	_tmp0_ = app_window_instance;
	_vala_assert (IS_LIBRARY_WINDOW (_tmp0_), "instance is LibraryWindow");
	_tmp1_ = app_window_instance;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_LIBRARY_WINDOW, LibraryWindow));
	result = _tmp2_;
	return result;
}

gboolean
library_window_is_mount_uri_supported (const gchar* uri)
{
	gboolean result;
	g_return_val_if_fail (uri != NULL, FALSE);
	{
		const gchar** scheme_collection = NULL;
		gint scheme_collection_length1 = 0;
		gint _scheme_collection_size_ = 0;
		gint scheme_it = 0;
		scheme_collection = LIBRARY_WINDOW_SUPPORTED_MOUNT_SCHEMES;
		scheme_collection_length1 = G_N_ELEMENTS (LIBRARY_WINDOW_SUPPORTED_MOUNT_SCHEMES);
		for (scheme_it = 0; scheme_it < scheme_collection_length1; scheme_it = scheme_it + 1) {
			gchar* _tmp0_;
			gchar* scheme = NULL;
			_tmp0_ = g_strdup (scheme_collection[scheme_it]);
			scheme = _tmp0_;
			{
				const gchar* _tmp1_;
				_tmp1_ = scheme;
				if (g_str_has_prefix (uri, _tmp1_)) {
					result = TRUE;
					_g_free0 (scheme);
					return result;
				}
				_g_free0 (scheme);
			}
		}
	}
	result = FALSE;
	return result;
}

static gchar*
library_window_real_get_app_role (AppWindow* base)
{
	LibraryWindow * self;
	gchar* _tmp0_;
	gchar* result;
	self = (LibraryWindow*) base;
	_tmp0_ = g_strdup (RESOURCES_APP_LIBRARY_ROLE);
	result = _tmp0_;
	return result;
}

void
library_window_rename_tag_in_sidebar (LibraryWindow* self,
                                      Tag* tag)
{
	TagsSidebarEntry* entry = NULL;
	TagsBranch* _tmp0_;
	TagsSidebarEntry* _tmp1_;
	TagsSidebarEntry* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag != NULL);
	_tmp0_ = self->priv->tags_branch;
	_tmp1_ = tags_branch_get_entry_for_tag (_tmp0_, tag);
	entry = _tmp1_;
	_tmp2_ = entry;
	if (_tmp2_ != NULL) {
		SidebarTree* _tmp3_;
		TagsSidebarEntry* _tmp4_;
		_tmp3_ = self->priv->sidebar_tree;
		_tmp4_ = entry;
		sidebar_tree_rename_entry_in_place (_tmp3_, (SidebarEntry*) _tmp4_);
	} else {
		g_debug ("LibraryWindow.vala:540: No tag entry found for rename");
	}
	_g_object_unref0 (entry);
}

void
library_window_rename_event_in_sidebar (LibraryWindow* self,
                                        Event* event)
{
	EventsEventEntry* entry = NULL;
	EventsBranch* _tmp0_;
	EventsEventEntry* _tmp1_;
	EventsEventEntry* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = self->priv->events_branch;
	_tmp1_ = events_branch_get_entry_for_event (_tmp0_, event);
	entry = _tmp1_;
	_tmp2_ = entry;
	if (_tmp2_ != NULL) {
		SidebarTree* _tmp3_;
		EventsEventEntry* _tmp4_;
		_tmp3_ = self->priv->sidebar_tree;
		_tmp4_ = entry;
		sidebar_tree_rename_entry_in_place (_tmp3_, (SidebarEntry*) _tmp4_);
	} else {
		g_debug ("LibraryWindow.vala:548: No event entry found for rename");
	}
	_g_object_unref0 (entry);
}

void
library_window_rename_search_in_sidebar (LibraryWindow* self,
                                         SavedSearch* search)
{
	SearchesSidebarEntry* entry = NULL;
	SearchesBranch* _tmp0_;
	SearchesSidebarEntry* _tmp1_;
	SearchesSidebarEntry* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (search != NULL);
	_tmp0_ = self->priv->saved_search_branch;
	_tmp1_ = searches_branch_get_entry_for_saved_search (_tmp0_, search);
	entry = _tmp1_;
	_tmp2_ = entry;
	if (_tmp2_ != NULL) {
		SidebarTree* _tmp3_;
		SearchesSidebarEntry* _tmp4_;
		_tmp3_ = self->priv->sidebar_tree;
		_tmp4_ = entry;
		sidebar_tree_rename_entry_in_place (_tmp3_, (SidebarEntry*) _tmp4_);
	} else {
		g_debug ("LibraryWindow.vala:556: No search entry found for rename");
	}
	_g_object_unref0 (entry);
}

static void
library_window_real_on_quit (AppWindow* base)
{
	LibraryWindow * self;
	GSettings* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GSettings* _tmp3_;
	Dimensions _tmp4_;
	GSettings* _tmp5_;
	Dimensions _tmp6_;
	self = (LibraryWindow*) base;
	_tmp0_ = ((AppWindow*) self)->window_settings;
	g_object_get ((GtkWindow*) self, "is-maximized", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	g_settings_set_boolean (_tmp0_, "library-maximize", _tmp2_);
	_tmp3_ = ((AppWindow*) self)->window_settings;
	_tmp4_ = ((AppWindow*) self)->dimensions;
	g_settings_set_int (_tmp3_, "library-width", _tmp4_.width);
	_tmp5_ = ((AppWindow*) self)->window_settings;
	_tmp6_ = ((AppWindow*) self)->dimensions;
	g_settings_set_int (_tmp5_, "library-height", _tmp6_.height);
	APP_WINDOW_CLASS (library_window_parent_class)->on_quit (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_APP_WINDOW, AppWindow));
}

static Photo*
library_window_get_start_fullscreen_photo (LibraryWindow* self,
                                           CollectionPage* page)
{
	ViewCollection* view = NULL;
	ViewCollection* _tmp0_;
	GeeList* _tmp1_ = NULL;
	ViewCollection* _tmp2_;
	GeeList* sources = NULL;
	GeeList* _tmp7_;
	Photo* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	GeeList* _tmp10_;
	Photo* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (page != NULL, NULL);
	_tmp0_ = page_get_view ((Page*) page);
	view = _tmp0_;
	_tmp2_ = view;
	if (view_collection_get_selected_count (_tmp2_) > 0) {
		ViewCollection* _tmp3_;
		GeeList* _tmp4_;
		_tmp3_ = view;
		_tmp4_ = view_collection_get_selected_sources_of_type (_tmp3_, TYPE_LIBRARY_PHOTO);
		_g_object_unref0 (_tmp1_);
		_tmp1_ = _tmp4_;
	} else {
		ViewCollection* _tmp5_;
		GeeList* _tmp6_;
		_tmp5_ = view;
		_tmp6_ = view_collection_get_sources_of_type (_tmp5_, TYPE_LIBRARY_PHOTO);
		_g_object_unref0 (_tmp1_);
		_tmp1_ = _tmp6_;
	}
	_tmp7_ = _g_object_ref0 (_tmp1_);
	sources = _tmp7_;
	_tmp10_ = sources;
	if (_tmp10_ != NULL) {
		GeeList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		_tmp11_ = sources;
		_tmp12_ = gee_collection_get_size ((GeeCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp9_ = _tmp13_ != 0;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		GeeList* _tmp14_;
		gpointer _tmp15_;
		_tmp14_ = sources;
		_tmp15_ = gee_list_get (_tmp14_, 0);
		_g_object_unref0 (_tmp8_);
		_tmp8_ = G_TYPE_CHECK_INSTANCE_CAST ((DataSource*) _tmp15_, TYPE_PHOTO, Photo);
	} else {
		_g_object_unref0 (_tmp8_);
		_tmp8_ = NULL;
	}
	result = _tmp8_;
	_g_object_unref0 (sources);
	_g_object_unref0 (_tmp1_);
	_data_collection_unref0 (view);
	return result;
}

static gboolean
library_window_get_fullscreen_photo (LibraryWindow* self,
                                     Page* page,
                                     CollectionPage** collection,
                                     Photo** start,
                                     ViewCollection** view_collection)
{
	CollectionPage* _vala_collection = NULL;
	Photo* _vala_start = NULL;
	ViewCollection* _vala_view_collection = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (page != NULL, FALSE);
	_g_object_unref0 (_vala_collection);
	_vala_collection = NULL;
	_g_object_unref0 (_vala_start);
	_vala_start = NULL;
	_data_collection_unref0 (_vala_view_collection);
	_vala_view_collection = NULL;
	if (IS_COLLECTION_PAGE (page)) {
		CollectionPage* _tmp0_;
		Photo* photo = NULL;
		CollectionPage* _tmp1_;
		Photo* _tmp2_;
		Photo* _tmp3_;
		Photo* _tmp4_;
		Photo* _tmp5_;
		_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (page, TYPE_COLLECTION_PAGE, CollectionPage));
		_g_object_unref0 (_vala_collection);
		_vala_collection = _tmp0_;
		_tmp1_ = _vala_collection;
		_tmp2_ = library_window_get_start_fullscreen_photo (self, _tmp1_);
		photo = _tmp2_;
		_tmp3_ = photo;
		if (_tmp3_ == NULL) {
			result = FALSE;
			_g_object_unref0 (photo);
			if (collection) {
				*collection = _vala_collection;
			} else {
				_g_object_unref0 (_vala_collection);
			}
			if (start) {
				*start = _vala_start;
			} else {
				_g_object_unref0 (_vala_start);
			}
			if (view_collection) {
				*view_collection = _vala_view_collection;
			} else {
				_data_collection_unref0 (_vala_view_collection);
			}
			return result;
		}
		_tmp4_ = photo;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		_g_object_unref0 (_vala_start);
		_vala_start = _tmp5_;
		_data_collection_unref0 (_vala_view_collection);
		_vala_view_collection = NULL;
		result = TRUE;
		_g_object_unref0 (photo);
		if (collection) {
			*collection = _vala_collection;
		} else {
			_g_object_unref0 (_vala_collection);
		}
		if (start) {
			*start = _vala_start;
		} else {
			_g_object_unref0 (_vala_start);
		}
		if (view_collection) {
			*view_collection = _vala_view_collection;
		} else {
			_data_collection_unref0 (_vala_view_collection);
		}
		return result;
	}
	if (IS_EVENTS_DIRECTORY_PAGE (page)) {
		ViewCollection* view = NULL;
		ViewCollection* _tmp6_;
		ViewCollection* _tmp7_;
		Event* event = NULL;
		ViewCollection* _tmp8_;
		DataObject* _tmp9_;
		DataView* _tmp10_;
		DataSource* _tmp11_;
		DataSource* _tmp12_;
		Event* _tmp13_;
		Event* _tmp14_;
		Event* _tmp15_;
		EventsEventEntry* entry = NULL;
		EventsBranch* _tmp16_;
		Event* _tmp17_;
		EventsEventEntry* _tmp18_;
		EventsEventEntry* _tmp19_;
		EventsEventEntry* _tmp20_;
		Page* _tmp21_;
		Photo* photo = NULL;
		CollectionPage* _tmp22_;
		Photo* _tmp23_;
		Photo* _tmp24_;
		Photo* _tmp25_;
		Photo* _tmp26_;
		_tmp6_ = page_get_view (page);
		view = _tmp6_;
		_tmp7_ = view;
		if (data_collection_get_count ((DataCollection*) _tmp7_) == 0) {
			result = FALSE;
			_data_collection_unref0 (view);
			if (collection) {
				*collection = _vala_collection;
			} else {
				_g_object_unref0 (_vala_collection);
			}
			if (start) {
				*start = _vala_start;
			} else {
				_g_object_unref0 (_vala_start);
			}
			if (view_collection) {
				*view_collection = _vala_view_collection;
			} else {
				_data_collection_unref0 (_vala_view_collection);
			}
			return result;
		}
		_tmp8_ = view;
		_tmp9_ = data_collection_get_at ((DataCollection*) _tmp8_, 0);
		_tmp10_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_DATA_VIEW, DataView);
		_tmp11_ = data_view_get_source (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_EVENT, Event));
		_tmp14_ = _tmp13_;
		_g_object_unref0 (_tmp10_);
		event = _tmp14_;
		_tmp15_ = event;
		if (_tmp15_ == NULL) {
			result = FALSE;
			_g_object_unref0 (event);
			_data_collection_unref0 (view);
			if (collection) {
				*collection = _vala_collection;
			} else {
				_g_object_unref0 (_vala_collection);
			}
			if (start) {
				*start = _vala_start;
			} else {
				_g_object_unref0 (_vala_start);
			}
			if (view_collection) {
				*view_collection = _vala_view_collection;
			} else {
				_data_collection_unref0 (_vala_view_collection);
			}
			return result;
		}
		_tmp16_ = self->priv->events_branch;
		_tmp17_ = event;
		_tmp18_ = events_branch_get_entry_for_event (_tmp16_, _tmp17_);
		entry = _tmp18_;
		_tmp19_ = entry;
		if (_tmp19_ == NULL) {
			result = FALSE;
			_g_object_unref0 (entry);
			_g_object_unref0 (event);
			_data_collection_unref0 (view);
			if (collection) {
				*collection = _vala_collection;
			} else {
				_g_object_unref0 (_vala_collection);
			}
			if (start) {
				*start = _vala_start;
			} else {
				_g_object_unref0 (_vala_start);
			}
			if (view_collection) {
				*view_collection = _vala_view_collection;
			} else {
				_data_collection_unref0 (_vala_view_collection);
			}
			return result;
		}
		_tmp20_ = entry;
		_tmp21_ = sidebar_page_representative_get_page ((SidebarPageRepresentative*) _tmp20_);
		_g_object_unref0 (_vala_collection);
		_vala_collection = (CollectionPage*) G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, TYPE_EVENT_PAGE, EventPage);
		_tmp22_ = _vala_collection;
		_tmp23_ = library_window_get_start_fullscreen_photo (self, _tmp22_);
		photo = _tmp23_;
		_tmp24_ = photo;
		if (_tmp24_ == NULL) {
			result = FALSE;
			_g_object_unref0 (photo);
			_g_object_unref0 (entry);
			_g_object_unref0 (event);
			_data_collection_unref0 (view);
			if (collection) {
				*collection = _vala_collection;
			} else {
				_g_object_unref0 (_vala_collection);
			}
			if (start) {
				*start = _vala_start;
			} else {
				_g_object_unref0 (_vala_start);
			}
			if (view_collection) {
				*view_collection = _vala_view_collection;
			} else {
				_data_collection_unref0 (_vala_view_collection);
			}
			return result;
		}
		_tmp25_ = photo;
		_tmp26_ = _g_object_ref0 (_tmp25_);
		_g_object_unref0 (_vala_start);
		_vala_start = _tmp26_;
		_data_collection_unref0 (_vala_view_collection);
		_vala_view_collection = NULL;
		result = TRUE;
		_g_object_unref0 (photo);
		_g_object_unref0 (entry);
		_g_object_unref0 (event);
		_data_collection_unref0 (view);
		if (collection) {
			*collection = _vala_collection;
		} else {
			_g_object_unref0 (_vala_collection);
		}
		if (start) {
			*start = _vala_start;
		} else {
			_g_object_unref0 (_vala_start);
		}
		if (view_collection) {
			*view_collection = _vala_view_collection;
		} else {
			_data_collection_unref0 (_vala_view_collection);
		}
		return result;
	}
	if (IS_LIBRARY_PHOTO_PAGE (page)) {
		LibraryPhotoPage* photo_page = NULL;
		LibraryPhotoPage* _tmp27_;
		CollectionPage* controller = NULL;
		LibraryPhotoPage* _tmp28_;
		CollectionPage* _tmp29_;
		CollectionPage* _tmp30_;
		LibraryPhotoPage* _tmp31_;
		CollectionPage* _tmp32_;
		CollectionPage* _tmp33_;
		LibraryPhotoPage* _tmp34_;
		Photo* _tmp35_;
		LibraryPhotoPage* _tmp36_;
		ViewCollection* _tmp37_;
		_tmp27_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (page, TYPE_LIBRARY_PHOTO_PAGE, LibraryPhotoPage));
		photo_page = _tmp27_;
		_tmp28_ = photo_page;
		_tmp29_ = library_photo_page_get_controller_page (_tmp28_);
		controller = _tmp29_;
		_tmp30_ = controller;
		if (_tmp30_ == NULL) {
			result = FALSE;
			_g_object_unref0 (controller);
			_g_object_unref0 (photo_page);
			if (collection) {
				*collection = _vala_collection;
			} else {
				_g_object_unref0 (_vala_collection);
			}
			if (start) {
				*start = _vala_start;
			} else {
				_g_object_unref0 (_vala_start);
			}
			if (view_collection) {
				*view_collection = _vala_view_collection;
			} else {
				_data_collection_unref0 (_vala_view_collection);
			}
			return result;
		}
		_tmp31_ = photo_page;
		if (!editing_host_page_has_photo ((EditingHostPage*) _tmp31_)) {
			result = FALSE;
			_g_object_unref0 (controller);
			_g_object_unref0 (photo_page);
			if (collection) {
				*collection = _vala_collection;
			} else {
				_g_object_unref0 (_vala_collection);
			}
			if (start) {
				*start = _vala_start;
			} else {
				_g_object_unref0 (_vala_start);
			}
			if (view_collection) {
				*view_collection = _vala_view_collection;
			} else {
				_data_collection_unref0 (_vala_view_collection);
			}
			return result;
		}
		_tmp32_ = controller;
		_tmp33_ = _g_object_ref0 (_tmp32_);
		_g_object_unref0 (_vala_collection);
		_vala_collection = _tmp33_;
		_tmp34_ = photo_page;
		_tmp35_ = editing_host_page_get_photo ((EditingHostPage*) _tmp34_);
		_g_object_unref0 (_vala_start);
		_vala_start = _tmp35_;
		_tmp36_ = photo_page;
		_tmp37_ = page_get_view ((Page*) _tmp36_);
		_data_collection_unref0 (_vala_view_collection);
		_vala_view_collection = _tmp37_;
		result = TRUE;
		_g_object_unref0 (controller);
		_g_object_unref0 (photo_page);
		if (collection) {
			*collection = _vala_collection;
		} else {
			_g_object_unref0 (_vala_collection);
		}
		if (start) {
			*start = _vala_start;
		} else {
			_g_object_unref0 (_vala_start);
		}
		if (view_collection) {
			*view_collection = _vala_view_collection;
		} else {
			_data_collection_unref0 (_vala_view_collection);
		}
		return result;
	}
	result = FALSE;
	if (collection) {
		*collection = _vala_collection;
	} else {
		_g_object_unref0 (_vala_collection);
	}
	if (start) {
		*start = _vala_start;
	} else {
		_g_object_unref0 (_vala_start);
	}
	if (view_collection) {
		*view_collection = _vala_view_collection;
	} else {
		_data_collection_unref0 (_vala_view_collection);
	}
	return result;
}

static void
library_window_real_on_fullscreen (AppWindow* base)
{
	LibraryWindow * self;
	Page* current_page = NULL;
	Page* _tmp0_;
	Page* _tmp1_;
	CollectionPage* collection = NULL;
	Photo* start = NULL;
	ViewCollection* view = NULL;
	Page* _tmp2_;
	CollectionPage* _tmp3_ = NULL;
	Photo* _tmp4_ = NULL;
	ViewCollection* _tmp5_ = NULL;
	gboolean _tmp6_;
	LibraryWindowFullscreenPhotoPage* fs_photo = NULL;
	CollectionPage* _tmp7_;
	Photo* _tmp8_;
	ViewCollection* _tmp9_;
	LibraryWindowFullscreenPhotoPage* _tmp10_;
	LibraryWindowFullscreenPhotoPage* _tmp11_;
	self = (LibraryWindow*) base;
	_tmp0_ = page_window_get_current_page ((PageWindow*) self);
	current_page = _tmp0_;
	_tmp1_ = current_page;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (current_page);
		return;
	}
	view = NULL;
	_tmp2_ = current_page;
	_tmp6_ = library_window_get_fullscreen_photo (self, _tmp2_, &_tmp3_, &_tmp4_, &_tmp5_);
	_g_object_unref0 (collection);
	collection = _tmp3_;
	_g_object_unref0 (start);
	start = _tmp4_;
	_data_collection_unref0 (view);
	view = _tmp5_;
	if (!_tmp6_) {
		_data_collection_unref0 (view);
		_g_object_unref0 (start);
		_g_object_unref0 (collection);
		_g_object_unref0 (current_page);
		return;
	}
	_tmp7_ = collection;
	_tmp8_ = start;
	_tmp9_ = view;
	_tmp10_ = library_window_fullscreen_photo_page_new (_tmp7_, _tmp8_, _tmp9_);
	g_object_ref_sink (_tmp10_);
	fs_photo = _tmp10_;
	_tmp11_ = fs_photo;
	app_window_go_fullscreen ((AppWindow*) self, (Page*) _tmp11_);
	_g_object_unref0 (fs_photo);
	_data_collection_unref0 (view);
	_g_object_unref0 (start);
	_g_object_unref0 (collection);
	_g_object_unref0 (current_page);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_slist_free__g_free0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_free0_);
}

static void
library_window_on_file_import (LibraryWindow* self)
{
	GtkFileChooserNative* import_dialog = NULL;
	GtkFileChooserNative* _tmp0_;
	GtkFileChooserNative* _tmp1_;
	GtkFileChooserNative* _tmp2_;
	GtkFileChooserNative* _tmp3_;
	const gchar* _tmp4_;
	GtkFileChooserNative* _tmp5_;
	GtkFileChooserNative* _tmp17_;
	gchar* _tmp18_;
	GtkFileChooserNative* _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_file_chooser_native_new (_ ("Import From Folder"), NULL, GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER, _ ("Import"), _ ("Cancel"));
	import_dialog = _tmp0_;
	_tmp1_ = import_dialog;
	gtk_file_chooser_set_local_only ((GtkFileChooser*) _tmp1_, FALSE);
	_tmp2_ = import_dialog;
	gtk_file_chooser_set_select_multiple ((GtkFileChooser*) _tmp2_, TRUE);
	_tmp3_ = import_dialog;
	_tmp4_ = self->priv->import_dir;
	gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp3_, _tmp4_);
	_tmp5_ = import_dialog;
	if (gtk_native_dialog_run ((GtkNativeDialog*) _tmp5_) == ((gint) GTK_RESPONSE_ACCEPT)) {
		GtkFileChooserNative* _tmp6_;
		GtkResponseType _tmp7_ = 0;
		GtkFileChooserNative* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		GFile* _tmp11_;
		GFile* _tmp12_;
		gboolean _tmp13_;
		GtkResponseType copy_files_response = 0;
		_tmp6_ = import_dialog;
		g_object_set ((GtkNativeDialog*) _tmp6_, "visible", FALSE, NULL);
		_tmp8_ = import_dialog;
		_tmp9_ = gtk_file_chooser_get_uri ((GtkFileChooser*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_file_new_for_uri (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = app_dirs_is_in_import_dir (_tmp12_);
		_g_object_unref0 (_tmp12_);
		_g_free0 (_tmp10_);
		if (_tmp13_) {
			_tmp7_ = GTK_RESPONSE_REJECT;
		} else {
			_tmp7_ = copy_files_dialog ();
		}
		copy_files_response = _tmp7_;
		if (copy_files_response != GTK_RESPONSE_CANCEL) {
			GtkFileChooserNative* _tmp14_;
			GSList* _tmp15_;
			GSList* _tmp16_;
			_tmp14_ = import_dialog;
			_tmp15_ = gtk_file_chooser_get_uris ((GtkFileChooser*) _tmp14_);
			_tmp16_ = _tmp15_;
			library_window_dispatch_import_jobs (self, _tmp16_, "folders", copy_files_response == GTK_RESPONSE_ACCEPT);
			(_tmp16_ == NULL) ? NULL : (_tmp16_ = (_g_slist_free__g_free0_ (_tmp16_), NULL));
		}
	}
	_tmp17_ = import_dialog;
	_tmp18_ = gtk_file_chooser_get_current_folder ((GtkFileChooser*) _tmp17_);
	_g_free0 (self->priv->import_dir);
	self->priv->import_dir = _tmp18_;
	_tmp19_ = import_dialog;
	gtk_native_dialog_destroy ((GtkNativeDialog*) _tmp19_);
	_g_object_unref0 (import_dialog);
}

static void
library_window_real_update_common_action_availability (AppWindow* base,
                                                       Page* old_page,
                                                       Page* new_page)
{
	LibraryWindow * self;
	gboolean is_checkerboard = FALSE;
	self = (LibraryWindow*) base;
	APP_WINDOW_CLASS (library_window_parent_class)->update_common_action_availability (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_APP_WINDOW, AppWindow), old_page, new_page);
	is_checkerboard = IS_CHECKERBOARD_PAGE (new_page);
	app_window_set_common_action_sensitive ((AppWindow*) self, "CommonDisplaySearchbar", is_checkerboard);
	app_window_set_common_action_sensitive ((AppWindow*) self, "CommonFind", is_checkerboard);
}

static void
library_window_real_update_common_actions (AppWindow* base,
                                           Page* page,
                                           gint selected_count,
                                           gint count)
{
	LibraryWindow * self;
	CollectionPage* collection = NULL;
	Photo* start = NULL;
	gboolean can_fullscreen = FALSE;
	CollectionPage* _tmp0_ = NULL;
	Photo* _tmp1_ = NULL;
	gboolean _tmp2_;
	AppWindow* _tmp3_;
	AppWindow* _tmp4_;
	GAction* _tmp5_;
	self = (LibraryWindow*) base;
	g_return_if_fail (page != NULL);
	_tmp2_ = library_window_get_fullscreen_photo (self, page, &_tmp0_, &_tmp1_, NULL);
	_g_object_unref0 (collection);
	collection = _tmp0_;
	_g_object_unref0 (start);
	start = _tmp1_;
	can_fullscreen = _tmp2_;
	app_window_set_common_action_visible ((AppWindow*) self, "CommonJumpToEvent", TRUE);
	app_window_set_common_action_sensitive ((AppWindow*) self, "CommonJumpToEvent", library_window_can_jump_to_event (self));
	_tmp3_ = app_window_get_instance ();
	_tmp4_ = _tmp3_;
	_tmp5_ = g_action_map_lookup_action ((GActionMap*) _tmp4_, APP_WINDOW_ACTION_FULLSCREEN);
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, g_simple_action_get_type (), GSimpleAction), can_fullscreen);
	_g_object_unref0 (_tmp4_);
	APP_WINDOW_CLASS (library_window_parent_class)->update_common_actions (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_APP_WINDOW, AppWindow), page, selected_count, count);
	_g_object_unref0 (start);
	_g_object_unref0 (collection);
}

static void
_library_window_on_display_metadata_sidebar_gtk_toggle_action_toggled (GtkToggleAction* _sender,
                                                                       gpointer self)
{
	library_window_on_display_metadata_sidebar ((LibraryWindow*) self, _sender);
}

void
library_window_update_common_toggle_actions (LibraryWindow* self)
{
	GtkToggleAction* sidebar_action = NULL;
	GtkAction* _tmp0_;
	GtkToggleAction* _tmp1_;
	GtkToggleAction* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = app_window_get_common_action ((AppWindow*) self, "CommonDisplayMetadataSidebar");
	_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (_tmp0_);
	}
	sidebar_action = _tmp1_;
	_tmp2_ = sidebar_action;
	if (_tmp2_ != NULL) {
		GtkToggleAction* _tmp3_;
		guint _tmp4_;
		GtkToggleAction* _tmp5_;
		GtkToggleAction* _tmp6_;
		_tmp3_ = sidebar_action;
		g_signal_parse_name ("toggled", gtk_toggle_action_get_type (), &_tmp4_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _library_window_on_display_metadata_sidebar_gtk_toggle_action_toggled, self);
		_tmp5_ = sidebar_action;
		gtk_toggle_action_set_active (_tmp5_, library_window_is_metadata_sidebar_visible (self));
		_tmp6_ = sidebar_action;
		g_signal_connect_object (_tmp6_, "toggled", (GCallback) _library_window_on_display_metadata_sidebar_gtk_toggle_action_toggled, self, 0);
	}
	_g_object_unref0 (sidebar_action);
}

static void
library_window_on_new_search (LibraryWindow* self)
{
	SavedSearchDialog* _tmp0_;
	SavedSearchDialog* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = saved_search_dialog_new ();
	_tmp1_ = _tmp0_;
	saved_search_dialog_show (_tmp1_);
	_g_object_unref0 (_tmp1_);
}

static gboolean
library_window_can_jump_to_event (LibraryWindow* self)
{
	ViewCollection* view = NULL;
	Page* _tmp0_;
	Page* _tmp1_;
	ViewCollection* _tmp2_;
	ViewCollection* _tmp3_;
	ViewCollection* _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = page_window_get_current_page ((PageWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = page_get_view (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	view = _tmp3_;
	_tmp4_ = view;
	if (view_collection_get_selected_count (_tmp4_) == 1) {
		DataSource* selected_source = NULL;
		ViewCollection* _tmp5_;
		DataSource* _tmp6_;
		DataSource* _tmp7_;
		_tmp5_ = view;
		_tmp6_ = view_collection_get_selected_source_at (_tmp5_, 0);
		selected_source = _tmp6_;
		_tmp7_ = selected_source;
		if (IS_EVENT (_tmp7_)) {
			result = TRUE;
			_g_object_unref0 (selected_source);
			_data_collection_unref0 (view);
			return result;
		} else {
			DataSource* _tmp8_;
			_tmp8_ = selected_source;
			if (IS_MEDIA_SOURCE (_tmp8_)) {
				ViewCollection* _tmp9_;
				DataSource* _tmp10_;
				MediaSource* _tmp11_;
				Event* _tmp12_;
				Event* _tmp13_;
				gboolean _tmp14_;
				_tmp9_ = view;
				_tmp10_ = view_collection_get_selected_source_at (_tmp9_, 0);
				_tmp11_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_MEDIA_SOURCE, MediaSource);
				_tmp12_ = media_source_get_event (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = _tmp13_ != NULL;
				_g_object_unref0 (_tmp13_);
				_g_object_unref0 (_tmp11_);
				result = _tmp14_;
				_g_object_unref0 (selected_source);
				_data_collection_unref0 (view);
				return result;
			} else {
				result = FALSE;
				_g_object_unref0 (selected_source);
				_data_collection_unref0 (view);
				return result;
			}
		}
		_g_object_unref0 (selected_source);
	} else {
		result = FALSE;
		_data_collection_unref0 (view);
		return result;
	}
}

static void
library_window_on_jump_to_event (LibraryWindow* self)
{
	ViewCollection* view = NULL;
	Page* _tmp0_;
	Page* _tmp1_;
	ViewCollection* _tmp2_;
	ViewCollection* _tmp3_;
	ViewCollection* _tmp4_;
	MediaSource* media = NULL;
	ViewCollection* _tmp5_;
	DataSource* _tmp6_;
	MediaSource* _tmp7_;
	MediaSource* _tmp8_;
	MediaSource* _tmp9_;
	Event* _tmp10_;
	Event* _tmp11_;
	gboolean _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = page_window_get_current_page ((PageWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = page_get_view (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	view = _tmp3_;
	_tmp4_ = view;
	if (view_collection_get_selected_count (_tmp4_) != 1) {
		_data_collection_unref0 (view);
		return;
	}
	_tmp5_ = view;
	_tmp6_ = view_collection_get_selected_source_at (_tmp5_, 0);
	_tmp7_ = IS_MEDIA_SOURCE (_tmp6_) ? ((MediaSource*) _tmp6_) : NULL;
	if (_tmp7_ == NULL) {
		_g_object_unref0 (_tmp6_);
	}
	media = _tmp7_;
	_tmp8_ = media;
	if (_tmp8_ == NULL) {
		_g_object_unref0 (media);
		_data_collection_unref0 (view);
		return;
	}
	_tmp9_ = media;
	_tmp10_ = media_source_get_event (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_ != NULL;
	_g_object_unref0 (_tmp11_);
	if (_tmp12_) {
		MediaSource* _tmp13_;
		Event* _tmp14_;
		Event* _tmp15_;
		_tmp13_ = media;
		_tmp14_ = media_source_get_event (_tmp13_);
		_tmp15_ = _tmp14_;
		library_window_switch_to_event (self, _tmp15_);
		_g_object_unref0 (_tmp15_);
	}
	_g_object_unref0 (media);
	_data_collection_unref0 (view);
}

static void
library_window_on_find (LibraryWindow* self)
{
	GtkToggleAction* action = NULL;
	Page* _tmp0_;
	Page* _tmp1_;
	GtkAction* _tmp2_;
	GtkToggleAction* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = page_window_get_current_page ((PageWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = page_get_common_action (_tmp1_, "CommonDisplaySearchbar", TRUE);
	_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_toggle_action_get_type (), GtkToggleAction);
	_g_object_unref0 (_tmp1_);
	action = _tmp3_;
	_tmp4_ = gtk_toggle_action_get_active (action);
	_tmp5_ = _tmp4_;
	gtk_toggle_action_set_active (action, !_tmp5_);
	_g_object_unref0 (action);
}

static void
library_window_on_media_altered (LibraryWindow* self)
{
	g_return_if_fail (self != NULL);
	app_window_set_common_action_sensitive ((AppWindow*) self, "CommonJumpToEvent", library_window_can_jump_to_event (self));
}

gint
library_window_get_events_sort (LibraryWindow* self)
{
	GtkRadioAction* action = NULL;
	GtkAction* _tmp0_;
	GtkRadioAction* _tmp1_;
	gint _tmp2_ = 0;
	GtkRadioAction* _tmp3_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = app_window_get_common_action ((AppWindow*) self, "CommonSortEventsAscending");
	_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_radio_action_get_type ()) ? ((GtkRadioAction*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (_tmp0_);
	}
	action = _tmp1_;
	_tmp3_ = action;
	if (_tmp3_ != NULL) {
		GtkRadioAction* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp4_ = action;
		_tmp5_ = gtk_radio_action_get_current_value (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = LIBRARY_WINDOW_SORT_EVENTS_ORDER_DESCENDING;
	}
	result = _tmp2_;
	_g_object_unref0 (action);
	return result;
}

static void
library_window_on_events_sort_changed (LibraryWindow* self,
                                       GtkAction* action,
                                       GtkAction* c)
{
	GtkRadioAction* current = NULL;
	GtkRadioAction* _tmp0_;
	GSettings* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (c, gtk_radio_action_get_type (), GtkRadioAction));
	current = _tmp0_;
	_tmp1_ = library_window_ui_settings;
	_tmp2_ = gtk_radio_action_get_current_value (current);
	_tmp3_ = _tmp2_;
	g_settings_set_boolean (_tmp1_, "events-sort-ascending", _tmp3_ == LIBRARY_WINDOW_SORT_EVENTS_ORDER_ASCENDING);
	_g_object_unref0 (current);
}

static void
library_window_on_preferences (LibraryWindow* self)
{
	g_return_if_fail (self != NULL);
	preferences_dialog_show ();
}

static void
library_window_on_display_sidebar (LibraryWindow* self,
                                   GtkAction* action)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	library_window_set_sidebar_visible (self, gtk_toggle_action_get_active (G_TYPE_CHECK_INSTANCE_CAST (action, gtk_toggle_action_get_type (), GtkToggleAction)));
}

static void
library_window_on_focus_search_entry (LibraryWindow* self,
                                      GtkAction* action)
{
	SearchFilterEntry* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->search_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
}

static void
library_window_on_display_metadata_sidebar (LibraryWindow* self,
                                            GtkAction* action)
{
	Page* _tmp0_;
	Page* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	library_window_set_metadata_sidebar_visible (self, gtk_toggle_action_get_active (G_TYPE_CHECK_INSTANCE_CAST (action, gtk_toggle_action_get_type (), GtkToggleAction)));
	_tmp0_ = page_window_get_current_page ((PageWindow*) self);
	_tmp1_ = _tmp0_;
	page_update_sidebar_action (_tmp1_, !library_window_is_metadata_sidebar_visible (self));
	_g_object_unref0 (_tmp1_);
}

static void
library_window_set_sidebar_visible (LibraryWindow* self,
                                    gboolean visible)
{
	GtkScrolledWindow* _tmp0_;
	GSettings* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->scrolled_sidebar;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, visible);
	_tmp1_ = library_window_ui_settings;
	g_settings_set_boolean (_tmp1_, "display-sidebar", visible);
}

static gboolean
library_window_is_sidebar_visible (LibraryWindow* self)
{
	GSettings* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = library_window_ui_settings;
	result = g_settings_get_boolean (_tmp0_, "display-sidebar");
	return result;
}

void
library_window_set_metadata_sidebar_visible (LibraryWindow* self,
                                             gboolean visible)
{
	MetadataView* _tmp0_;
	GSettings* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->metadata_sidebar;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, visible);
	_tmp1_ = library_window_ui_settings;
	g_settings_set_boolean (_tmp1_, "display-metadata-sidebar", visible);
}

gboolean
library_window_is_metadata_sidebar_visible (LibraryWindow* self)
{
	GSettings* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = library_window_ui_settings;
	result = g_settings_get_boolean (_tmp0_, "display-metadata-sidebar");
	return result;
}

void
library_window_enqueue_batch_import (LibraryWindow* self,
                                     BatchImport* batch_import,
                                     gboolean allow_user_cancel)
{
	LibraryBranch* _tmp0_;
	LibraryImportQueueSidebarEntry* _tmp1_;
	LibraryImportQueueSidebarEntry* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (batch_import != NULL);
	_tmp0_ = self->priv->library_branch;
	_tmp1_ = library_branch_get_import_queue_entry (_tmp0_);
	_tmp2_ = _tmp1_;
	library_import_queue_sidebar_entry_enqueue_and_schedule (_tmp2_, batch_import, allow_user_cancel);
}

static void
library_window_import_reporter (LibraryWindow* self,
                                ImportManifest* manifest)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (manifest != NULL);
	import_ui_report_manifest (manifest, TRUE, NULL);
}

static void
_library_window_import_reporter_batch_import_import_reporter (ImportManifest* manifest,
                                                              BatchImportRoll* import_roll,
                                                              gpointer self)
{
	library_window_import_reporter ((LibraryWindow*) self, manifest);
}

static void
library_window_dispatch_import_jobs (LibraryWindow* self,
                                     GSList* uris,
                                     const gchar* job_name,
                                     gboolean copy_to_library)
{
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	GeeArrayList* jobs = NULL;
	GeeArrayList* _tmp10_;
	GeeArrayList* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (job_name != NULL);
	_tmp1_ = app_dirs_get_import_dir ();
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_get_path (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_get_home_dir ();
	_tmp6_ = g_strcmp0 (_tmp4_, _tmp5_) == 0;
	_g_free0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	if (_tmp6_) {
		_tmp0_ = self->priv->notify_library_is_home_dir;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkResponseType response = 0;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GtkResponseType _tmp9_;
		_tmp7_ = g_strdup_printf (_ ("Photos is configured to import photos to your home directory.\n" "We recommend changing this in <span weight=\"bold\">Edit %s Preference" \
"s</span>.\n" "Do you want to continue importing photos?"), "▸");
		_tmp8_ = _tmp7_;
		_tmp9_ = app_window_cancel_affirm_question (_tmp8_, _ ("_Import"), _ ("Library Location"));
		_g_free0 (_tmp8_);
		response = _tmp9_;
		if (response == GTK_RESPONSE_CANCEL) {
			return;
		}
		self->priv->notify_library_is_home_dir = FALSE;
	}
	_tmp10_ = gee_array_list_new (TYPE_FILE_IMPORT_JOB, (GBoxedCopyFunc) batch_import_job_ref, (GDestroyNotify) batch_import_job_unref, NULL, NULL, NULL);
	jobs = _tmp10_;
	{
		GSList* uri_collection = NULL;
		GSList* uri_it = NULL;
		uri_collection = uris;
		for (uri_it = uri_collection; uri_it != NULL; uri_it = uri_it->next) {
			gchar* _tmp11_;
			gchar* uri = NULL;
			_tmp11_ = g_strdup ((const gchar*) uri_it->data);
			uri = _tmp11_;
			{
				GFile* file_or_dir = NULL;
				const gchar* _tmp12_;
				GFile* _tmp13_;
				GFile* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gboolean _tmp17_;
				GeeArrayList* _tmp18_;
				GFile* _tmp19_;
				FileImportJob* _tmp20_;
				FileImportJob* _tmp21_;
				_tmp12_ = uri;
				_tmp13_ = g_file_new_for_uri (_tmp12_);
				file_or_dir = _tmp13_;
				_tmp14_ = file_or_dir;
				_tmp15_ = g_file_get_path (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = _tmp16_ == NULL;
				_g_free0 (_tmp16_);
				if (_tmp17_) {
					app_window_error_message (_ ("Photos cannot be imported from this directory."), NULL, NULL);
					_g_object_unref0 (file_or_dir);
					_g_free0 (uri);
					continue;
				}
				_tmp18_ = jobs;
				_tmp19_ = file_or_dir;
				_tmp20_ = file_import_job_new (_tmp19_, copy_to_library);
				_tmp21_ = _tmp20_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, _tmp21_);
				_batch_import_job_unref0 (_tmp21_);
				_g_object_unref0 (file_or_dir);
				_g_free0 (uri);
			}
		}
	}
	_tmp22_ = jobs;
	_tmp23_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp22_);
	_tmp24_ = _tmp23_;
	if (_tmp24_ > 0) {
		BatchImport* batch_import = NULL;
		GeeArrayList* _tmp25_;
		BatchImport* _tmp26_;
		BatchImport* _tmp27_;
		_tmp25_ = jobs;
		_tmp26_ = batch_import_new ((GeeIterable*) _tmp25_, job_name, _library_window_import_reporter_batch_import_import_reporter, self, NULL, NULL, NULL, NULL, NULL);
		batch_import = _tmp26_;
		_tmp27_ = batch_import;
		library_window_enqueue_batch_import (self, _tmp27_, TRUE);
		library_window_switch_to_import_queue_page (self);
		_g_object_unref0 (batch_import);
	}
	_g_object_unref0 (jobs);
}

static GdkDragAction
library_window_get_drag_action (LibraryWindow* self)
{
	GdkModifierType mask = 0U;
	GdkSeat* seat = NULL;
	GdkDisplay* _tmp0_;
	GdkSeat* _tmp1_;
	GdkSeat* _tmp2_;
	GdkWindow* _tmp3_;
	GdkSeat* _tmp4_;
	GdkDevice* _tmp5_;
	GdkModifierType _tmp6_ = 0U;
	gboolean ctrl = FALSE;
	gboolean alt = FALSE;
	gboolean shift = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	GdkDragAction result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = gdk_display_get_default_seat (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	seat = _tmp2_;
	_tmp3_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp4_ = seat;
	_tmp5_ = gdk_seat_get_pointer (_tmp4_);
	gdk_window_get_device_position (_tmp3_, _tmp5_, NULL, NULL, &_tmp6_);
	mask = _tmp6_;
	ctrl = (mask & GDK_CONTROL_MASK) != 0;
	alt = (mask & GDK_MOD1_MASK) != 0;
	shift = (mask & GDK_SHIFT_MASK) != 0;
	if (ctrl) {
		_tmp8_ = !alt;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		_tmp7_ = !shift;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		result = GDK_ACTION_COPY;
		_g_object_unref0 (seat);
		return result;
	} else {
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		if (!ctrl) {
			_tmp10_ = alt;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			_tmp9_ = !shift;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			result = GDK_ACTION_ASK;
			_g_object_unref0 (seat);
			return result;
		} else {
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_ = FALSE;
			if (ctrl) {
				_tmp12_ = !alt;
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				_tmp11_ = shift;
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				result = GDK_ACTION_LINK;
				_g_object_unref0 (seat);
				return result;
			} else {
				result = GDK_ACTION_DEFAULT;
				_g_object_unref0 (seat);
				return result;
			}
		}
	}
}

static gboolean
library_window_real_drag_motion (GtkWidget* base,
                                 GdkDragContext* context,
                                 gint x,
                                 gint y,
                                 guint time)
{
	LibraryWindow * self;
	GdkAtom target = (GdkAtom) 0U;
	GtkTargetList* _tmp0_;
	GtkWidget* _tmp1_;
	GdkDragAction drag_action = 0U;
	gboolean result;
	self = (LibraryWindow*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = gtk_drag_dest_get_target_list ((GtkWidget*) self);
	target = gtk_drag_dest_find_target ((GtkWidget*) self, context, _tmp0_);
	if (((gint) target) == 0) {
		g_debug ("LibraryWindow.vala:886: drag target is GDK_NONE");
		gdk_drag_status (context, 0, (guint32) time);
		result = TRUE;
		return result;
	}
	_tmp1_ = gtk_drag_get_source_widget (context);
	if (_tmp1_ != NULL) {
		gdk_drag_status (context, GDK_ACTION_PRIVATE, (guint32) time);
		result = TRUE;
		return result;
	}
	drag_action = library_window_get_drag_action (self);
	if (drag_action == GDK_ACTION_DEFAULT) {
		drag_action = GDK_ACTION_ASK;
	}
	gdk_drag_status (context, drag_action, (guint32) time);
	result = TRUE;
	return result;
}

static void
library_window_real_drag_data_received (GtkWidget* base,
                                        GdkDragContext* context,
                                        gint x,
                                        gint y,
                                        GtkSelectionData* selection_data,
                                        guint info,
                                        guint time)
{
	LibraryWindow * self;
	guint8* _tmp0_;
	GtkWidget* _tmp1_;
	self = (LibraryWindow*) base;
	g_return_if_fail (context != NULL);
	g_return_if_fail (selection_data != NULL);
	_tmp0_ = gtk_selection_data_get_data (selection_data);
	if (-1 < 0) {
		g_debug ("LibraryWindow.vala:913: failed to retrieve SelectionData");
	}
	_tmp1_ = gtk_drag_get_source_widget (context);
	if (_tmp1_ == NULL) {
		library_window_external_drop_handler (self, context, NULL, selection_data, info, time);
	} else {
		gtk_drag_finish (context, FALSE, FALSE, (guint32) time);
	}
}

static void
library_window_external_drop_handler (LibraryWindow* self,
                                      GdkDragContext* context,
                                      SidebarEntry* entry,
                                      GtkSelectionData* data,
                                      guint info,
                                      guint time)
{
	gchar** uris_array = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint uris_array_length1;
	gint _uris_array_size_;
	GSList* uris = NULL;
	gchar** _tmp2_;
	gint _tmp2__length1;
	GdkDragAction selected_action = 0U;
	GSList* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (data != NULL);
	_tmp1_ = _tmp0_ = gtk_selection_data_get_uris (data);
	uris_array = _tmp1_;
	uris_array_length1 = _vala_array_length (_tmp0_);
	_uris_array_size_ = uris_array_length1;
	uris = NULL;
	_tmp2_ = uris_array;
	_tmp2__length1 = uris_array_length1;
	{
		gchar** uri_collection = NULL;
		gint uri_collection_length1 = 0;
		gint _uri_collection_size_ = 0;
		gint uri_it = 0;
		uri_collection = _tmp2_;
		uri_collection_length1 = _tmp2__length1;
		for (uri_it = 0; uri_it < uri_collection_length1; uri_it = uri_it + 1) {
			gchar* _tmp3_;
			gchar* uri = NULL;
			_tmp3_ = g_strdup (uri_collection[uri_it]);
			uri = _tmp3_;
			{
				const gchar* _tmp4_;
				gchar* _tmp5_;
				_tmp4_ = uri;
				_tmp5_ = g_strdup (_tmp4_);
				uris = g_slist_append (uris, _tmp5_);
				_g_free0 (uri);
			}
		}
	}
	selected_action = gdk_drag_context_get_selected_action (context);
	if (selected_action == GDK_ACTION_ASK) {
		GtkResponseType _result_ = 0;
		GSList* _tmp6_;
		_result_ = GTK_RESPONSE_REJECT;
		_tmp6_ = uris;
		{
			GSList* uri_collection = NULL;
			GSList* uri_it = NULL;
			uri_collection = _tmp6_;
			for (uri_it = uri_collection; uri_it != NULL; uri_it = uri_it->next) {
				gchar* _tmp7_;
				gchar* uri = NULL;
				_tmp7_ = g_strdup ((const gchar*) uri_it->data);
				uri = _tmp7_;
				{
					const gchar* _tmp8_;
					GFile* _tmp9_;
					GFile* _tmp10_;
					gboolean _tmp11_;
					_tmp8_ = uri;
					_tmp9_ = g_file_new_for_uri (_tmp8_);
					_tmp10_ = _tmp9_;
					_tmp11_ = !app_dirs_is_in_import_dir (_tmp10_);
					_g_object_unref0 (_tmp10_);
					if (_tmp11_) {
						_result_ = copy_files_dialog ();
						_g_free0 (uri);
						break;
					}
					_g_free0 (uri);
				}
			}
		}
		switch (_result_) {
			case GTK_RESPONSE_ACCEPT:
			{
				selected_action = GDK_ACTION_COPY;
				break;
			}
			case GTK_RESPONSE_REJECT:
			{
				selected_action = GDK_ACTION_LINK;
				break;
			}
			default:
			{
				gtk_drag_finish (context, FALSE, FALSE, (guint32) time);
				(uris == NULL) ? NULL : (uris = (_g_slist_free__g_free0_ (uris), NULL));
				uris_array = (_vala_array_free (uris_array, uris_array_length1, (GDestroyNotify) g_free), NULL);
				return;
			}
		}
	}
	_tmp12_ = uris;
	library_window_dispatch_import_jobs (self, _tmp12_, "drag-and-drop", selected_action == GDK_ACTION_COPY);
	gtk_drag_finish (context, TRUE, FALSE, (guint32) time);
	(uris == NULL) ? NULL : (uris = (_g_slist_free__g_free0_ (uris), NULL));
	uris_array = (_vala_array_free (uris_array, uris_array_length1, (GDestroyNotify) g_free), NULL);
}

void
library_window_switch_to_library_page (LibraryWindow* self)
{
	LibraryBranch* _tmp0_;
	LibraryPhotosEntry* _tmp1_;
	LibraryPhotosEntry* _tmp2_;
	Page* _tmp3_;
	Page* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->library_branch;
	_tmp1_ = library_branch_get_photos_entry (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = sidebar_page_representative_get_page ((SidebarPageRepresentative*) _tmp2_);
	_tmp4_ = _tmp3_;
	library_window_switch_to_page (self, _tmp4_);
	_g_object_unref0 (_tmp4_);
}

void
library_window_switch_to_event_directory (LibraryWindow* self)
{
	EventsBranch* _tmp0_;
	EventsMasterDirectoryEntry* _tmp1_;
	EventsMasterDirectoryEntry* _tmp2_;
	Page* _tmp3_;
	Page* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->events_branch;
	_tmp1_ = events_branch_get_master_entry (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = sidebar_page_representative_get_page ((SidebarPageRepresentative*) _tmp2_);
	_tmp4_ = _tmp3_;
	library_window_switch_to_page (self, _tmp4_);
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
}

void
library_window_switch_to_event (LibraryWindow* self,
                                Event* event)
{
	EventsEventEntry* entry = NULL;
	EventsBranch* _tmp0_;
	EventsEventEntry* _tmp1_;
	EventsEventEntry* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = self->priv->events_branch;
	_tmp1_ = events_branch_get_entry_for_event (_tmp0_, event);
	entry = _tmp1_;
	_tmp2_ = entry;
	if (_tmp2_ != NULL) {
		EventsEventEntry* _tmp3_;
		Page* _tmp4_;
		Page* _tmp5_;
		_tmp3_ = entry;
		_tmp4_ = sidebar_page_representative_get_page ((SidebarPageRepresentative*) _tmp3_);
		_tmp5_ = _tmp4_;
		library_window_switch_to_page (self, _tmp5_);
		_g_object_unref0 (_tmp5_);
	}
	_g_object_unref0 (entry);
}

void
library_window_switch_to_tag (LibraryWindow* self,
                              Tag* tag)
{
	TagsSidebarEntry* entry = NULL;
	TagsBranch* _tmp0_;
	TagsSidebarEntry* _tmp1_;
	TagsSidebarEntry* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag != NULL);
	_tmp0_ = self->priv->tags_branch;
	_tmp1_ = tags_branch_get_entry_for_tag (_tmp0_, tag);
	entry = _tmp1_;
	_tmp2_ = entry;
	if (_tmp2_ != NULL) {
		TagsSidebarEntry* _tmp3_;
		Page* _tmp4_;
		Page* _tmp5_;
		_tmp3_ = entry;
		_tmp4_ = sidebar_page_representative_get_page ((SidebarPageRepresentative*) _tmp3_);
		_tmp5_ = _tmp4_;
		library_window_switch_to_page (self, _tmp5_);
		_g_object_unref0 (_tmp5_);
	}
	_g_object_unref0 (entry);
}

void
library_window_switch_to_saved_search (LibraryWindow* self,
                                       SavedSearch* search)
{
	SearchesSidebarEntry* entry = NULL;
	SearchesBranch* _tmp0_;
	SearchesSidebarEntry* _tmp1_;
	SearchesSidebarEntry* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (search != NULL);
	_tmp0_ = self->priv->saved_search_branch;
	_tmp1_ = searches_branch_get_entry_for_saved_search (_tmp0_, search);
	entry = _tmp1_;
	_tmp2_ = entry;
	if (_tmp2_ != NULL) {
		SearchesSidebarEntry* _tmp3_;
		Page* _tmp4_;
		Page* _tmp5_;
		_tmp3_ = entry;
		_tmp4_ = sidebar_page_representative_get_page ((SidebarPageRepresentative*) _tmp3_);
		_tmp5_ = _tmp4_;
		library_window_switch_to_page (self, _tmp5_);
		_g_object_unref0 (_tmp5_);
	}
	_g_object_unref0 (entry);
}

void
library_window_switch_to_photo_page (LibraryWindow* self,
                                     CollectionPage* controller,
                                     Photo* current)
{
	ViewCollection* _tmp0_;
	ViewCollection* _tmp1_;
	DataView* _tmp2_;
	DataView* _tmp3_;
	LibraryPhotoPage* _tmp4_;
	LibraryPhotoPage* _tmp7_;
	GtkActionBar* _tmp8_;
	GtkActionBar* _tmp9_;
	LibraryPhotoPage* _tmp10_;
	LibraryPhotoPage* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (controller != NULL);
	g_return_if_fail (current != NULL);
	_tmp0_ = page_get_view ((Page*) controller);
	_tmp1_ = _tmp0_;
	_tmp2_ = view_collection_get_view_for_source (_tmp1_, (DataSource*) current);
	_tmp3_ = _tmp2_;
	_vala_assert (_tmp3_ != NULL, "controller.get_view ().get_view_for_source (current) != null");
	_g_object_unref0 (_tmp3_);
	_data_collection_unref0 (_tmp1_);
	_tmp4_ = self->priv->photo_page;
	if (_tmp4_ == NULL) {
		LibraryPhotoPage* _tmp5_;
		LibraryPhotoPage* _tmp6_;
		_tmp5_ = library_photo_page_new ();
		g_object_ref_sink (_tmp5_);
		_g_object_unref0 (self->priv->photo_page);
		self->priv->photo_page = _tmp5_;
		_tmp6_ = self->priv->photo_page;
		library_window_add_to_notebook (self, (Page*) _tmp6_);
		spin_event_loop ();
	}
	_tmp7_ = self->priv->photo_page;
	_tmp8_ = page_get_toolbar ((Page*) _tmp7_, NULL, GTK_PACK_START);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (_tmp9_);
	_tmp10_ = self->priv->photo_page;
	library_photo_page_display_for_collection (_tmp10_, controller, current, NULL);
	_tmp11_ = self->priv->photo_page;
	library_window_switch_to_page (self, (Page*) _tmp11_);
}

void
library_window_switch_to_import_queue_page (LibraryWindow* self)
{
	LibraryBranch* _tmp0_;
	LibraryImportQueueSidebarEntry* _tmp1_;
	LibraryImportQueueSidebarEntry* _tmp2_;
	Page* _tmp3_;
	Page* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->library_branch;
	_tmp1_ = library_branch_get_import_queue_entry (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = sidebar_page_representative_get_page ((SidebarPageRepresentative*) _tmp2_);
	_tmp4_ = _tmp3_;
	library_window_switch_to_page (self, _tmp4_);
	_g_object_unref0 (_tmp4_);
}

static void
library_window_on_camera_added (LibraryWindow* self,
                                DiscoveredCamera* camera)
{
	CameraSidebarEntry* entry = NULL;
	CameraBranch* _tmp0_;
	CameraSidebarEntry* _tmp1_;
	CameraSidebarEntry* _tmp2_;
	ImportPage* page = NULL;
	CameraSidebarEntry* _tmp3_;
	Page* _tmp4_;
	GFile* uri_file = NULL;
	const gchar* _tmp5_;
	GFile* _tmp6_;
	GMount* mount = NULL;
	gboolean _tmp11_ = FALSE;
	GMount* _tmp12_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (camera != NULL);
	_tmp0_ = self->priv->camera_branch;
	_tmp1_ = camera_branch_get_entry_for_camera (_tmp0_, camera);
	entry = _tmp1_;
	_tmp2_ = entry;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (entry);
		return;
	}
	_tmp3_ = entry;
	_tmp4_ = sidebar_page_representative_get_page ((SidebarPageRepresentative*) _tmp3_);
	page = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_IMPORT_PAGE, ImportPage);
	_tmp5_ = camera->uri;
	_tmp6_ = g_file_new_for_uri (_tmp5_);
	uri_file = _tmp6_;
	mount = NULL;
	{
		GMount* _tmp7_ = NULL;
		GFile* _tmp8_;
		GMount* _tmp9_;
		GMount* _tmp10_;
		_tmp8_ = uri_file;
		_tmp9_ = g_file_find_enclosing_mount (_tmp8_, NULL, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		_g_object_unref0 (mount);
		mount = _tmp10_;
		_g_object_unref0 (_tmp7_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (mount);
		_g_object_unref0 (uri_file);
		_g_object_unref0 (page);
		_g_object_unref0 (entry);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp12_ = mount;
	if (_tmp12_ != NULL) {
		const gchar* _tmp13_;
		_tmp13_ = camera->uri;
		_tmp11_ = !g_str_has_prefix (_tmp13_, "file://");
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		ImportPage* _tmp14_;
		GMount* _tmp15_;
		_tmp14_ = page;
		_tmp15_ = mount;
		if (import_page_unmount_camera (_tmp14_, _tmp15_)) {
			ImportPage* _tmp16_;
			_tmp16_ = page;
			library_window_switch_to_page (self, (Page*) _tmp16_);
		} else {
			app_window_error_message ("Unable to unmount the camera at this time.", NULL, NULL);
		}
	} else {
		ImportPage* _tmp17_;
		_tmp17_ = page;
		library_window_switch_to_page (self, (Page*) _tmp17_);
	}
	_g_object_unref0 (mount);
	_g_object_unref0 (uri_file);
	_g_object_unref0 (page);
	_g_object_unref0 (entry);
}

void
library_window_add_to_notebook (LibraryWindow* self,
                                Page* page)
{
	gint pos = 0;
	GtkNotebook* _tmp0_;
	GtkNotebook* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	gtk_widget_show_all ((GtkWidget*) page);
	_tmp0_ = self->priv->notebook;
	pos = gtk_notebook_append_page (_tmp0_, (GtkWidget*) page, NULL);
	_vala_assert (pos >= 0, "pos >= 0");
	_tmp1_ = self->priv->notebook;
	gtk_widget_show_all ((GtkWidget*) _tmp1_);
}

static void
library_window_remove_from_notebook (LibraryWindow* self,
                                     Page* page)
{
	GtkNotebook* _tmp0_;
	GtkNotebook* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = self->priv->notebook;
	gtk_container_remove ((GtkContainer*) _tmp0_, (GtkWidget*) page);
	_tmp1_ = self->priv->notebook;
	gtk_widget_show_all ((GtkWidget*) _tmp1_);
}

static void
library_window_load_configuration (LibraryWindow* self)
{
	GtkRadioAction* sort_events_action = NULL;
	GtkAction* _tmp0_;
	GtkRadioAction* _tmp1_;
	GtkRadioAction* _tmp2_;
	gint _tmp3_ = 0;
	GSettings* _tmp4_;
	gint event_sort_val = 0;
	GtkRadioAction* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = app_window_get_common_action ((AppWindow*) self, "CommonSortEventsAscending");
	_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_radio_action_get_type ()) ? ((GtkRadioAction*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (_tmp0_);
	}
	sort_events_action = _tmp1_;
	_tmp2_ = sort_events_action;
	_vala_assert (_tmp2_ != NULL, "sort_events_action != null");
	_tmp4_ = library_window_ui_settings;
	if (g_settings_get_boolean (_tmp4_, "events-sort-ascending")) {
		_tmp3_ = LIBRARY_WINDOW_SORT_EVENTS_ORDER_ASCENDING;
	} else {
		_tmp3_ = LIBRARY_WINDOW_SORT_EVENTS_ORDER_DESCENDING;
	}
	event_sort_val = _tmp3_;
	_tmp5_ = sort_events_action;
	gtk_radio_action_set_current_value (_tmp5_, event_sort_val);
	_g_object_unref0 (sort_events_action);
}

static void
library_window_on_library_monitor_discovery_started (LibraryWindow* self)
{
	TopDisplay* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->top_display;
	top_display_start_pulse_background_progress_bar (_tmp0_, _ ("Updating library…"), LIBRARY_WINDOW_STARTUP_SCAN_PROGRESS_PRIORITY);
}

static void
library_window_on_library_monitor_discovery_completed (LibraryWindow* self)
{
	TopDisplay* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->top_display;
	top_display_stop_pulse_background_progress_bar (_tmp0_, LIBRARY_WINDOW_STARTUP_SCAN_PROGRESS_PRIORITY, TRUE);
}

static void
library_window_on_library_monitor_auto_update_progress (LibraryWindow* self,
                                                        gint completed_files,
                                                        gint total_files)
{
	g_return_if_fail (self != NULL);
	if (total_files < LIBRARY_WINDOW_MIN_PROGRESS_BAR_FILES) {
		TopDisplay* _tmp0_;
		_tmp0_ = self->priv->top_display;
		top_display_clear_background_progress_bar (_tmp0_, LIBRARY_WINDOW_REALTIME_UPDATE_PROGRESS_PRIORITY);
	} else {
		TopDisplay* _tmp1_;
		_tmp1_ = self->priv->top_display;
		top_display_update_background_progress_bar (_tmp1_, _ ("Updating library…"), LIBRARY_WINDOW_REALTIME_UPDATE_PROGRESS_PRIORITY, (gdouble) completed_files, (gdouble) total_files);
	}
}

static void
library_window_on_library_monitor_auto_import_preparing (LibraryWindow* self)
{
	TopDisplay* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->top_display;
	top_display_start_pulse_background_progress_bar (_tmp0_, _ ("Preparing to auto-import photos…"), LIBRARY_WINDOW_REALTIME_IMPORT_PROGRESS_PRIORITY);
}

static void
library_window_on_library_monitor_auto_import_progress (LibraryWindow* self,
                                                        guint64 completed_bytes,
                                                        guint64 total_bytes)
{
	TopDisplay* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->top_display;
	top_display_update_background_progress_bar (_tmp0_, _ ("Auto-importing photos…"), LIBRARY_WINDOW_REALTIME_IMPORT_PROGRESS_PRIORITY, (gdouble) completed_bytes, (gdouble) total_bytes);
}

static void
library_window_on_metadata_writer_progress (LibraryWindow* self,
                                            guint completed,
                                            guint total)
{
	g_return_if_fail (self != NULL);
	if (total < ((guint) LIBRARY_WINDOW_MIN_PROGRESS_BAR_FILES)) {
		TopDisplay* _tmp0_;
		_tmp0_ = self->priv->top_display;
		top_display_clear_background_progress_bar (_tmp0_, LIBRARY_WINDOW_METADATA_WRITER_PROGRESS_PRIORITY);
	} else {
		TopDisplay* _tmp1_;
		_tmp1_ = self->priv->top_display;
		top_display_update_background_progress_bar (_tmp1_, _ ("Writing metadata to files…"), LIBRARY_WINDOW_METADATA_WRITER_PROGRESS_PRIORITY, (gdouble) completed, (gdouble) total);
	}
}

static void
library_window_real_set_current_page (PageWindow* base,
                                      Page* page)
{
	LibraryWindow * self;
	self = (LibraryWindow*) base;
	g_return_if_fail (page != NULL);
	library_window_switch_to_page (self, page);
}

void
library_window_set_page_switching_enabled (LibraryWindow* self,
                                           gboolean should_enable)
{
	g_return_if_fail (self != NULL);
	self->priv->page_switching_enabled = should_enable;
}

void
library_window_switch_to_page (LibraryWindow* self,
                               Page* page)
{
	Page* _tmp0_;
	Page* _tmp1_;
	gboolean _tmp2_;
	MetadataView* _tmp3_;
	Page* current_page = NULL;
	Page* _tmp4_;
	Page* _tmp5_;
	GtkNotebook* _tmp17_;
	GtkNotebook* _tmp18_;
	GtkBox* _tmp19_;
	HdyHeaderBar* _tmp20_;
	GtkBox* _tmp21_;
	HdyHeaderBar* _tmp22_;
	SearchFilterEntry* _tmp24_;
	SidebarEntry* entry = NULL;
	GeeHashMap* _tmp25_;
	gpointer _tmp26_;
	SidebarEntry* _tmp27_;
	Page* _tmp37_;
	Page* _tmp38_;
	GtkActionBar* toolbar = NULL;
	GtkActionBar* _tmp39_;
	GtkActionBar* _tmp40_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	if (!self->priv->page_switching_enabled) {
		return;
	}
	_tmp0_ = page_window_get_current_page ((PageWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = page == _tmp1_;
	_g_object_unref0 (_tmp1_);
	if (_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->metadata_sidebar;
	metadata_view_save_changes (_tmp3_);
	_tmp4_ = page_window_get_current_page ((PageWindow*) self);
	current_page = _tmp4_;
	_tmp5_ = current_page;
	if (_tmp5_ != NULL) {
		GtkActionBar* toolbar = NULL;
		Page* _tmp6_;
		GtkActionBar* _tmp7_;
		GtkActionBar* _tmp8_;
		GtkBox* _tmp10_;
		Page* _tmp13_;
		Page* _tmp14_;
		Page* _tmp16_;
		_tmp6_ = current_page;
		_tmp7_ = page_get_toolbar (_tmp6_, NULL, GTK_PACK_START);
		toolbar = _tmp7_;
		_tmp8_ = toolbar;
		if (_tmp8_ != NULL) {
			GtkActionBar* _tmp9_;
			_tmp9_ = toolbar;
			gtk_widget_destroy ((GtkWidget*) _tmp9_);
		}
		_tmp10_ = self->priv->page_header_box;
		if (_tmp10_ != NULL) {
			HdyHeaderBar* _tmp11_;
			GtkBox* _tmp12_;
			_tmp11_ = ((AppWindow*) self)->header;
			_tmp12_ = self->priv->page_header_box;
			gtk_container_remove ((GtkContainer*) _tmp11_, (GtkWidget*) _tmp12_);
		}
		_tmp13_ = current_page;
		page_switching_from (_tmp13_);
		_tmp14_ = current_page;
		if (IS_LIBRARY_PHOTO_PAGE (_tmp14_)) {
			SidebarTree* _tmp15_;
			_tmp15_ = self->priv->sidebar_tree;
			sidebar_tree_enable_editing (_tmp15_);
		}
		_tmp16_ = current_page;
		library_window_unsubscribe_from_basic_information (self, _tmp16_);
		_g_object_unref0 (toolbar);
	}
	_tmp17_ = self->priv->notebook;
	_tmp18_ = self->priv->notebook;
	gtk_notebook_set_current_page (_tmp17_, gtk_notebook_page_num (_tmp18_, (GtkWidget*) page));
	PAGE_WINDOW_CLASS (library_window_parent_class)->set_current_page ((PageWindow*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_APP_WINDOW, AppWindow), page);
	_tmp19_ = page_get_header_buttons (page);
	_g_object_unref0 (self->priv->page_header_box);
	self->priv->page_header_box = _tmp19_;
	_tmp20_ = ((AppWindow*) self)->header;
	_tmp21_ = self->priv->page_header_box;
	hdy_header_bar_pack_start (_tmp20_, (GtkWidget*) _tmp21_);
	_tmp22_ = ((AppWindow*) self)->header;
	gtk_widget_show_all ((GtkWidget*) _tmp22_);
	if (IS_LIBRARY_PHOTO_PAGE (page)) {
		SidebarTree* _tmp23_;
		_tmp23_ = self->priv->sidebar_tree;
		sidebar_tree_disable_editing (_tmp23_);
	}
	_tmp24_ = self->priv->search_entry;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp24_, library_window_is_search_sensitive (self));
	_tmp25_ = self->priv->page_map;
	_tmp26_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp25_, page);
	entry = (SidebarEntry*) _tmp26_;
	_tmp27_ = entry;
	if (_tmp27_ != NULL) {
		SidebarExpandableEntry* expandable_entry = NULL;
		SidebarEntry* _tmp28_;
		SidebarExpandableEntry* _tmp29_;
		gboolean _tmp30_ = FALSE;
		SidebarExpandableEntry* _tmp31_;
		SidebarTree* _tmp35_;
		SidebarEntry* _tmp36_;
		_tmp28_ = entry;
		_tmp29_ = _g_object_ref0 (SIDEBAR_IS_EXPANDABLE_ENTRY (_tmp28_) ? ((SidebarExpandableEntry*) _tmp28_) : NULL);
		expandable_entry = _tmp29_;
		_tmp31_ = expandable_entry;
		if (_tmp31_ != NULL) {
			SidebarExpandableEntry* _tmp32_;
			_tmp32_ = expandable_entry;
			_tmp30_ = sidebar_expandable_entry_expand_on_select (_tmp32_);
		} else {
			_tmp30_ = FALSE;
		}
		if (_tmp30_) {
			SidebarTree* _tmp33_;
			SidebarEntry* _tmp34_;
			_tmp33_ = self->priv->sidebar_tree;
			_tmp34_ = entry;
			sidebar_tree_expand_to_entry (_tmp33_, _tmp34_);
		}
		_tmp35_ = self->priv->sidebar_tree;
		_tmp36_ = entry;
		sidebar_tree_place_cursor (_tmp35_, _tmp36_, TRUE);
		_g_object_unref0 (expandable_entry);
	}
	library_window_on_update_properties (self);
	if (IS_CHECKERBOARD_PAGE (page)) {
		library_window_init_view_filter (self, G_TYPE_CHECK_INSTANCE_CAST (page, TYPE_CHECKERBOARD_PAGE, CheckerboardPage));
	}
	gtk_widget_show_all ((GtkWidget*) page);
	_tmp37_ = page_window_get_current_page ((PageWindow*) self);
	_tmp38_ = _tmp37_;
	library_window_subscribe_for_basic_information (self, _tmp38_);
	_g_object_unref0 (_tmp38_);
	page_switched_to (page);
	_tmp39_ = page_get_toolbar (page, NULL, GTK_PACK_START);
	toolbar = _tmp39_;
	_tmp40_ = toolbar;
	if (_tmp40_ != NULL) {
		GtkBox* _tmp41_;
		GtkActionBar* _tmp42_;
		GtkActionBar* _tmp43_;
		_tmp41_ = self->priv->right_vbox;
		_tmp42_ = toolbar;
		gtk_container_add ((GtkContainer*) _tmp41_, (GtkWidget*) _tmp42_);
		_tmp43_ = toolbar;
		gtk_widget_show_all ((GtkWidget*) _tmp43_);
	}
	page_ready (page);
	_g_object_unref0 (toolbar);
	_g_object_unref0 (entry);
	_g_object_unref0 (current_page);
}

static void
library_window_init_view_filter (LibraryWindow* self,
                                 CheckerboardPage* page)
{
	SearchFilterEntry* _tmp0_;
	SearchViewFilter* _tmp1_;
	SearchViewFilter* _tmp2_;
	ViewCollection* _tmp3_;
	ViewCollection* _tmp4_;
	SearchViewFilter* _tmp5_;
	SearchViewFilter* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = self->priv->search_entry;
	_tmp1_ = checkerboard_page_get_search_view_filter (page);
	_tmp2_ = _tmp1_;
	search_filter_entry_set_view_filter (_tmp0_, _tmp2_);
	_view_filter_unref0 (_tmp2_);
	_tmp3_ = page_get_view ((Page*) page);
	_tmp4_ = _tmp3_;
	_tmp5_ = checkerboard_page_get_search_view_filter (page);
	_tmp6_ = _tmp5_;
	view_collection_install_view_filter (_tmp4_, (ViewFilter*) _tmp6_);
	_view_filter_unref0 (_tmp6_);
	_data_collection_unref0 (_tmp4_);
}

static gboolean
library_window_is_search_sensitive (LibraryWindow* self)
{
	Page* _tmp0_;
	Page* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = page_window_get_current_page ((PageWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = IS_CHECKERBOARD_PAGE (_tmp1_);
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

static void
____lambda17_ (LibraryWindow* self,
               gint index)
{
	switch (index) {
		case 0:
		{
			library_window_on_file_import (self);
			break;
		}
		case 1:
		{
			library_window_on_preferences (self);
			break;
		}
		default:
		break;
	}
}

static void
_____lambda17__granite_widgets_welcome_activated (GraniteWidgetsWelcome* _sender,
                                                  gint index,
                                                  gpointer self)
{
	____lambda17_ ((LibraryWindow*) self, index);
}

void
library_window_toggle_welcome_page (LibraryWindow* self,
                                    gboolean show,
                                    const gchar* title,
                                    const gchar* subtitle,
                                    gboolean show_import)
{
	GtkFrame* _tmp4_;
	gboolean _tmp15_ = FALSE;
	Page* _tmp16_;
	Page* _tmp17_;
	gboolean _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (title != NULL);
	g_return_if_fail (subtitle != NULL);
	if (show == TRUE) {
		GraniteWidgetsWelcome* _tmp0_;
		_g_object_unref0 (self->priv->welcome_page);
		self->priv->welcome_page = NULL;
		_tmp0_ = granite_widgets_welcome_new (title, subtitle);
		g_object_ref_sink (_tmp0_);
		_g_object_unref0 (self->priv->welcome_page);
		self->priv->welcome_page = _tmp0_;
		if (show_import) {
			GraniteWidgetsWelcome* _tmp1_;
			GraniteWidgetsWelcome* _tmp2_;
			GraniteWidgetsWelcome* _tmp3_;
			_tmp1_ = self->priv->welcome_page;
			granite_widgets_welcome_append (_tmp1_, "document-import", _ ("Import Photos"), _ ("Copy photos from a folder or external device."));
			_tmp2_ = self->priv->welcome_page;
			granite_widgets_welcome_append (_tmp2_, "folder-pictures", _ ("Change Library Folder"), _ ("Choose where to keep your photos."));
			_tmp3_ = self->priv->welcome_page;
			g_signal_connect_object (_tmp3_, "activated", (GCallback) _____lambda17__granite_widgets_welcome_activated, self, 0);
		}
	}
	_tmp4_ = self->priv->right_frame;
	if (_tmp4_ != NULL) {
		GtkFrame* _tmp5_;
		GtkWidget* _tmp6_;
		GtkFrame* _tmp14_;
		_tmp5_ = self->priv->right_frame;
		_tmp6_ = gtk_bin_get_child ((GtkBin*) _tmp5_);
		if (_tmp6_ != NULL) {
			GtkFrame* _tmp7_;
			GtkFrame* _tmp8_;
			GtkWidget* _tmp9_;
			_tmp7_ = self->priv->right_frame;
			_tmp8_ = self->priv->right_frame;
			_tmp9_ = gtk_bin_get_child ((GtkBin*) _tmp8_);
			gtk_container_remove ((GtkContainer*) _tmp7_, _tmp9_);
		}
		if (show) {
			GtkFrame* _tmp10_;
			GraniteWidgetsWelcome* _tmp11_;
			_tmp10_ = self->priv->right_frame;
			_tmp11_ = self->priv->welcome_page;
			gtk_container_add ((GtkContainer*) _tmp10_, (GtkWidget*) _tmp11_);
		} else {
			GtkFrame* _tmp12_;
			GtkBox* _tmp13_;
			_tmp12_ = self->priv->right_frame;
			_tmp13_ = self->priv->right_vbox;
			gtk_container_add ((GtkContainer*) _tmp12_, (GtkWidget*) _tmp13_);
		}
		_tmp14_ = self->priv->right_frame;
		gtk_widget_show_all ((GtkWidget*) _tmp14_);
	}
	library_window_set_metadata_sidebar_visible (self, library_window_is_metadata_sidebar_visible (self));
	_tmp16_ = page_window_get_current_page ((PageWindow*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = _tmp17_ != NULL;
	_g_object_unref0 (_tmp17_);
	if (_tmp18_) {
		SearchFilterEntry* _tmp19_;
		gboolean _tmp20_;
		gboolean _tmp21_;
		_tmp19_ = self->priv->search_entry;
		g_object_get ((GtkWidget*) _tmp19_, "has-focus", &_tmp20_, NULL);
		_tmp21_ = _tmp20_;
		_tmp15_ = !_tmp21_;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		Page* _tmp22_;
		Page* _tmp23_;
		_tmp22_ = page_window_get_current_page ((PageWindow*) self);
		_tmp23_ = _tmp22_;
		gtk_widget_grab_focus ((GtkWidget*) _tmp23_);
		_g_object_unref0 (_tmp23_);
	}
}

static void
library_window_on_page_created (LibraryWindow* self,
                                SidebarPageRepresentative* entry,
                                Page* page)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = self->priv->page_map;
	_vala_assert (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, page), "!page_map.has_key (page)");
	_tmp1_ = self->priv->page_map;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp1_, page, (SidebarEntry*) entry);
	library_window_add_to_notebook (self, page);
}

static void
library_window_on_destroying_page (LibraryWindow* self,
                                   SidebarPageRepresentative* entry,
                                   Page* page)
{
	Page* _tmp0_;
	Page* _tmp1_;
	gboolean _tmp2_;
	gboolean removed = FALSE;
	GeeHashMap* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = page_window_get_current_page ((PageWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = page == _tmp1_;
	_g_object_unref0 (_tmp1_);
	if (_tmp2_) {
		LibraryBranch* _tmp3_;
		LibraryPhotosEntry* _tmp4_;
		LibraryPhotosEntry* _tmp5_;
		Page* _tmp6_;
		Page* _tmp7_;
		_tmp3_ = self->priv->library_branch;
		_tmp4_ = library_branch_get_photos_entry (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = sidebar_page_representative_get_page ((SidebarPageRepresentative*) _tmp5_);
		_tmp7_ = _tmp6_;
		library_window_switch_to_page (self, _tmp7_);
		_g_object_unref0 (_tmp7_);
	}
	library_window_remove_from_notebook (self, page);
	_tmp8_ = self->priv->page_map;
	removed = gee_abstract_map_unset ((GeeAbstractMap*) _tmp8_, page, NULL);
	_vala_assert (removed, "removed");
}

static void
library_window_on_sidebar_entry_selected (LibraryWindow* self,
                                          SidebarSelectableEntry* selectable)
{
	SidebarPageRepresentative* page_rep = NULL;
	SidebarPageRepresentative* _tmp0_;
	SidebarPageRepresentative* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (selectable != NULL);
	_tmp0_ = _g_object_ref0 (SIDEBAR_IS_PAGE_REPRESENTATIVE (selectable) ? ((SidebarPageRepresentative*) selectable) : NULL);
	page_rep = _tmp0_;
	_tmp1_ = page_rep;
	if (_tmp1_ != NULL) {
		SidebarPageRepresentative* _tmp2_;
		Page* _tmp3_;
		Page* _tmp4_;
		_tmp2_ = page_rep;
		_tmp3_ = sidebar_page_representative_get_page (_tmp2_);
		_tmp4_ = _tmp3_;
		library_window_switch_to_page (self, _tmp4_);
		_g_object_unref0 (_tmp4_);
	}
	_g_object_unref0 (page_rep);
}

static void
library_window_on_sidebar_selected_entry_removed (LibraryWindow* self,
                                                  SidebarSelectableEntry* selectable)
{
	LibraryLastImportSidebarEntry* last_import_entry = NULL;
	LibraryBranch* _tmp0_;
	LibraryLastImportSidebarEntry* _tmp1_;
	LibraryLastImportSidebarEntry* _tmp2_;
	LibraryLastImportSidebarEntry* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp18_ = FALSE;
	LibraryBranch* _tmp25_;
	LibraryPhotosEntry* _tmp26_;
	LibraryPhotosEntry* _tmp27_;
	Page* _tmp28_;
	Page* _tmp29_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (selectable != NULL);
	_tmp0_ = self->priv->library_branch;
	_tmp1_ = library_branch_get_last_imported_entry (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	last_import_entry = _tmp3_;
	if (LIBRARY_IS_IMPORT_QUEUE_SIDEBAR_ENTRY (selectable)) {
		LibraryLastImportSidebarEntry* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = last_import_entry;
		_tmp6_ = library_hideable_page_entry_get_visible ((LibraryHideablePageEntry*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp4_ = _tmp7_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		LibraryLastImportSidebarEntry* _tmp8_;
		Page* _tmp9_;
		Page* _tmp10_;
		_tmp8_ = last_import_entry;
		_tmp9_ = sidebar_page_representative_get_page ((SidebarPageRepresentative*) _tmp8_);
		_tmp10_ = _tmp9_;
		library_window_switch_to_page (self, _tmp10_);
		_g_object_unref0 (_tmp10_);
		_g_object_unref0 (last_import_entry);
		return;
	}
	if (EVENTS_IS_EVENT_ENTRY (selectable)) {
		EventsBranch* _tmp12_;
		_tmp12_ = self->priv->events_branch;
		_tmp11_ = sidebar_branch_get_show_branch ((SidebarBranch*) _tmp12_);
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		EventsBranch* _tmp13_;
		EventsMasterDirectoryEntry* _tmp14_;
		EventsMasterDirectoryEntry* _tmp15_;
		Page* _tmp16_;
		Page* _tmp17_;
		_tmp13_ = self->priv->events_branch;
		_tmp14_ = events_branch_get_master_entry (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = sidebar_page_representative_get_page ((SidebarPageRepresentative*) _tmp15_);
		_tmp17_ = _tmp16_;
		library_window_switch_to_page (self, _tmp17_);
		_g_object_unref0 (_tmp17_);
		_g_object_unref0 (_tmp15_);
		_g_object_unref0 (last_import_entry);
		return;
	}
	if (EVENTS_IS_DIRECTORY_ENTRY (selectable)) {
		EventsBranch* _tmp19_;
		_tmp19_ = self->priv->events_branch;
		_tmp18_ = sidebar_branch_get_show_branch ((SidebarBranch*) _tmp19_);
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		EventsBranch* _tmp20_;
		EventsMasterDirectoryEntry* _tmp21_;
		EventsMasterDirectoryEntry* _tmp22_;
		Page* _tmp23_;
		Page* _tmp24_;
		_tmp20_ = self->priv->events_branch;
		_tmp21_ = events_branch_get_master_entry (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = sidebar_page_representative_get_page ((SidebarPageRepresentative*) _tmp22_);
		_tmp24_ = _tmp23_;
		library_window_switch_to_page (self, _tmp24_);
		_g_object_unref0 (_tmp24_);
		_g_object_unref0 (_tmp22_);
		_g_object_unref0 (last_import_entry);
		return;
	}
	_tmp25_ = self->priv->library_branch;
	_tmp26_ = library_branch_get_photos_entry (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = sidebar_page_representative_get_page ((SidebarPageRepresentative*) _tmp27_);
	_tmp29_ = _tmp28_;
	library_window_switch_to_page (self, _tmp29_);
	_g_object_unref0 (_tmp29_);
	_g_object_unref0 (last_import_entry);
}

static void
_library_window_on_update_properties_view_collection_items_state_changed (ViewCollection* _sender,
                                                                          GeeIterable* changed,
                                                                          gpointer self)
{
	library_window_on_update_properties ((LibraryWindow*) self);
}

static void
_library_window_on_update_properties_data_collection_items_altered (DataCollection* _sender,
                                                                    GeeMap* items,
                                                                    gpointer self)
{
	library_window_on_update_properties ((LibraryWindow*) self);
}

static void
_library_window_on_update_properties_data_collection_contents_altered (DataCollection* _sender,
                                                                       GeeIterable* added,
                                                                       GeeIterable* removed,
                                                                       gpointer self)
{
	library_window_on_update_properties ((LibraryWindow*) self);
}

static void
_library_window_on_update_properties_view_collection_items_visibility_changed (ViewCollection* _sender,
                                                                               GeeCollection* changed,
                                                                               gpointer self)
{
	library_window_on_update_properties ((LibraryWindow*) self);
}

static void
library_window_subscribe_for_basic_information (LibraryWindow* self,
                                                Page* page)
{
	ViewCollection* view = NULL;
	ViewCollection* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = page_get_view (page);
	view = _tmp0_;
	g_signal_connect_object (view, "items-state-changed", (GCallback) _library_window_on_update_properties_view_collection_items_state_changed, self, 0);
	g_signal_connect_object ((DataCollection*) view, "items-altered", (GCallback) _library_window_on_update_properties_data_collection_items_altered, self, 0);
	g_signal_connect_object ((DataCollection*) view, "contents-altered", (GCallback) _library_window_on_update_properties_data_collection_contents_altered, self, 0);
	g_signal_connect_object (view, "items-visibility-changed", (GCallback) _library_window_on_update_properties_view_collection_items_visibility_changed, self, 0);
	_data_collection_unref0 (view);
}

static void
library_window_unsubscribe_from_basic_information (LibraryWindow* self,
                                                   Page* page)
{
	ViewCollection* view = NULL;
	ViewCollection* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = page_get_view (page);
	view = _tmp0_;
	g_signal_parse_name ("items-state-changed", TYPE_VIEW_COLLECTION, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (view, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _library_window_on_update_properties_view_collection_items_state_changed, self);
	g_signal_parse_name ("items-altered", TYPE_DATA_COLLECTION, &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((DataCollection*) view, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _library_window_on_update_properties_data_collection_items_altered, self);
	g_signal_parse_name ("contents-altered", TYPE_DATA_COLLECTION, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((DataCollection*) view, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _library_window_on_update_properties_data_collection_contents_altered, self);
	g_signal_parse_name ("items-visibility-changed", TYPE_VIEW_COLLECTION, &_tmp4_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (view, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _library_window_on_update_properties_view_collection_items_visibility_changed, self);
	_data_collection_unref0 (view);
}

static void
library_window_on_update_properties (LibraryWindow* self)
{
	OneShotScheduler* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->properties_scheduler;
	one_shot_scheduler_at_idle (_tmp0_);
}

static void
library_window_on_update_properties_now (LibraryWindow* self)
{
	MetadataView* _tmp0_;
	Page* _tmp1_;
	Page* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->metadata_sidebar;
	_tmp1_ = page_window_get_current_page ((PageWindow*) self);
	_tmp2_ = _tmp1_;
	metadata_view_update_properties (_tmp0_, _tmp2_);
	_g_object_unref0 (_tmp2_);
	library_window_update_window_title (self);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

void
library_window_mounted_camera_shell_notification (LibraryWindow* self,
                                                  const gchar* uri,
                                                  gboolean at_startup)
{
	GFile* uri_file = NULL;
	GFile* _tmp0_;
	GMount* mount = NULL;
	gchar* alt_uri = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	g_debug ("LibraryWindow.vala:1328: mount point reported: %s", uri);
	if (!library_window_is_mount_uri_supported (uri)) {
		g_debug ("LibraryWindow.vala:1332: Unsupported mount scheme: %s", uri);
		return;
	}
	_tmp0_ = g_file_new_for_uri (uri);
	uri_file = _tmp0_;
	mount = NULL;
	{
		GMount* _tmp1_ = NULL;
		GFile* _tmp2_;
		GMount* _tmp3_;
		GMount* _tmp4_;
		_tmp2_ = uri_file;
		_tmp3_ = g_file_find_enclosing_mount (_tmp2_, NULL, &_inner_error0_);
		_tmp1_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (mount);
		mount = _tmp4_;
		_g_object_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = err;
		_tmp6_ = _tmp5_->message;
		g_debug ("LibraryWindow.vala:1344: %s", _tmp6_);
		_g_error_free0 (err);
		_g_object_unref0 (mount);
		_g_object_unref0 (uri_file);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (mount);
		_g_object_unref0 (uri_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	alt_uri = NULL;
	if (g_str_has_prefix (uri, "file://")) {
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = string_replace (uri, "file://", "disk:");
		_tmp8_ = _tmp7_;
		_tmp9_ = camera_table_get_port_uri (_tmp8_);
		_g_free0 (alt_uri);
		alt_uri = _tmp9_;
		_g_free0 (_tmp8_);
	}
	if (at_startup) {
		const gchar* _tmp11_;
		if (!is_string_empty (uri)) {
			GeeHashSet* _tmp10_;
			_tmp10_ = library_window_initial_camera_uris;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, uri);
		}
		_tmp11_ = alt_uri;
		if (!is_string_empty (_tmp11_)) {
			GeeHashSet* _tmp12_;
			const gchar* _tmp13_;
			_tmp12_ = library_window_initial_camera_uris;
			_tmp13_ = alt_uri;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, _tmp13_);
		}
	}
	_g_free0 (alt_uri);
	_g_object_unref0 (mount);
	_g_object_unref0 (uri_file);
}

static gboolean
library_window_real_key_press_event (GtkWidget* base,
                                     GdkEventKey* event)
{
	LibraryWindow * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	SidebarTree* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean result;
	self = (LibraryWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp2_ = self->priv->sidebar_tree;
	g_object_get ((GtkWidget*) _tmp2_, "has-focus", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		SidebarTree* _tmp5_;
		_tmp5_ = self->priv->sidebar_tree;
		_tmp1_ = sidebar_tree_is_keypress_interpreted (_tmp5_, event);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		SidebarTree* _tmp6_;
		gboolean _tmp7_ = FALSE;
		_tmp6_ = self->priv->sidebar_tree;
		g_signal_emit_by_name ((GtkWidget*) _tmp6_, "key-press-event", event, &_tmp7_);
		_tmp0_ = _tmp7_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	if (GTK_WIDGET_CLASS (library_window_parent_class)->key_press_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_APP_WINDOW, AppWindow), event)) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

void
library_window_update_window_title (LibraryWindow* self)
{
	Page* current_page = NULL;
	Page* _tmp0_;
	Page* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = page_window_get_current_page ((PageWindow*) self);
	current_page = _tmp0_;
	_tmp1_ = current_page;
	if (_tmp1_ != NULL) {
		Page* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = current_page;
		_tmp3_ = page_get_page_name (_tmp2_);
		_tmp4_ = _tmp3_;
		gtk_window_set_title ((GtkWindow*) self, _tmp4_);
	} else {
		gtk_window_set_title ((GtkWindow*) self, _ (RESOURCES_APP_TITLE));
	}
	_g_object_unref0 (current_page);
}

gint
library_window_get_PAGE_MIN_WIDTH (void)
{
	gint result;
	gint _tmp0_;
	gint _tmp1_;
	_tmp0_ = thumbnail_get_MAX_SCALE ();
	_tmp1_ = _tmp0_;
	result = _tmp1_ + (CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING * 2);
	return result;
}

static inline gpointer
library_window_fullscreen_photo_page_get_instance_private (LibraryWindowFullscreenPhotoPage* self)
{
	return G_STRUCT_MEMBER_P (self, LibraryWindowFullscreenPhotoPage_private_offset);
}

static gpointer
_data_collection_ref0 (gpointer self)
{
	return self ? data_collection_ref (self) : NULL;
}

static LibraryWindowFullscreenPhotoPage*
library_window_fullscreen_photo_page_construct (GType object_type,
                                                CollectionPage* collection,
                                                Photo* start,
                                                ViewCollection* view)
{
	LibraryWindowFullscreenPhotoPage * self = NULL;
	CollectionPage* _tmp0_;
	Photo* _tmp1_;
	ViewCollection* _tmp2_;
	g_return_val_if_fail (collection != NULL, NULL);
	g_return_val_if_fail (start != NULL, NULL);
	self = (LibraryWindowFullscreenPhotoPage*) library_photo_page_construct (object_type);
	_tmp0_ = _g_object_ref0 (collection);
	_g_object_unref0 (self->priv->collection);
	self->priv->collection = _tmp0_;
	_tmp1_ = _g_object_ref0 (start);
	_g_object_unref0 (self->priv->start);
	self->priv->start = _tmp1_;
	_tmp2_ = _data_collection_ref0 (view);
	_data_collection_unref0 (self->priv->view);
	self->priv->view = _tmp2_;
	return self;
}

static LibraryWindowFullscreenPhotoPage*
library_window_fullscreen_photo_page_new (CollectionPage* collection,
                                          Photo* start,
                                          ViewCollection* view)
{
	return library_window_fullscreen_photo_page_construct (LIBRARY_WINDOW_TYPE_FULLSCREEN_PHOTO_PAGE, collection, start, view);
}

static void
library_window_fullscreen_photo_page_real_switched_to (Page* base)
{
	LibraryWindowFullscreenPhotoPage * self;
	CollectionPage* _tmp0_;
	Photo* _tmp1_;
	ViewCollection* _tmp2_;
	self = (LibraryWindowFullscreenPhotoPage*) base;
	_tmp0_ = self->priv->collection;
	_tmp1_ = self->priv->start;
	_tmp2_ = self->priv->view;
	library_photo_page_display_for_collection ((LibraryPhotoPage*) self, _tmp0_, _tmp1_, _tmp2_);
	PAGE_CLASS (library_window_fullscreen_photo_page_parent_class)->switched_to ((Page*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_LIBRARY_PHOTO_PAGE, LibraryPhotoPage));
}

static void
library_window_fullscreen_photo_page_class_init (LibraryWindowFullscreenPhotoPageClass * klass,
                                                 gpointer klass_data)
{
	library_window_fullscreen_photo_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &LibraryWindowFullscreenPhotoPage_private_offset);
	((PageClass *) klass)->switched_to = (void (*) (Page*)) library_window_fullscreen_photo_page_real_switched_to;
	G_OBJECT_CLASS (klass)->finalize = library_window_fullscreen_photo_page_finalize;
}

static void
library_window_fullscreen_photo_page_instance_init (LibraryWindowFullscreenPhotoPage * self,
                                                    gpointer klass)
{
	self->priv = library_window_fullscreen_photo_page_get_instance_private (self);
}

static void
library_window_fullscreen_photo_page_finalize (GObject * obj)
{
	LibraryWindowFullscreenPhotoPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, LIBRARY_WINDOW_TYPE_FULLSCREEN_PHOTO_PAGE, LibraryWindowFullscreenPhotoPage);
	_g_object_unref0 (self->priv->collection);
	_g_object_unref0 (self->priv->start);
	_data_collection_unref0 (self->priv->view);
	G_OBJECT_CLASS (library_window_fullscreen_photo_page_parent_class)->finalize (obj);
}

static GType
library_window_fullscreen_photo_page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (LibraryWindowFullscreenPhotoPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) library_window_fullscreen_photo_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LibraryWindowFullscreenPhotoPage), 0, (GInstanceInitFunc) library_window_fullscreen_photo_page_instance_init, NULL };
	GType library_window_fullscreen_photo_page_type_id;
	library_window_fullscreen_photo_page_type_id = g_type_register_static (TYPE_LIBRARY_PHOTO_PAGE, "LibraryWindowFullscreenPhotoPage", &g_define_type_info, 0);
	LibraryWindowFullscreenPhotoPage_private_offset = g_type_add_instance_private (library_window_fullscreen_photo_page_type_id, sizeof (LibraryWindowFullscreenPhotoPagePrivate));
	return library_window_fullscreen_photo_page_type_id;
}

static GType
library_window_fullscreen_photo_page_get_type (void)
{
	static volatile gsize library_window_fullscreen_photo_page_type_id__once = 0;
	if (g_once_init_enter (&library_window_fullscreen_photo_page_type_id__once)) {
		GType library_window_fullscreen_photo_page_type_id;
		library_window_fullscreen_photo_page_type_id = library_window_fullscreen_photo_page_get_type_once ();
		g_once_init_leave (&library_window_fullscreen_photo_page_type_id__once, library_window_fullscreen_photo_page_type_id);
	}
	return library_window_fullscreen_photo_page_type_id__once;
}

static void
_library_window_external_drop_handler_sidebar_tree_external_drop_handler (GdkDragContext* context,
                                                                          SidebarEntry* entry,
                                                                          GtkSelectionData* data,
                                                                          guint info,
                                                                          guint time,
                                                                          gpointer self)
{
	library_window_external_drop_handler ((LibraryWindow*) self, context, entry, data, info, time);
}

static void
_library_window___lambda123_ (LibraryWindow* self)
{
	Page* _tmp0_;
	Page* _tmp1_;
	_tmp0_ = page_window_get_current_page ((PageWindow*) self);
	_tmp1_ = _tmp0_;
	gtk_widget_grab_focus ((GtkWidget*) _tmp1_);
	_g_object_unref0 (_tmp1_);
}

static void
__library_window___lambda123__gtk_entry_activate (GtkEntry* _sender,
                                                  gpointer self)
{
	_library_window___lambda123_ ((LibraryWindow*) self);
}

static GObject *
library_window_constructor (GType type,
                            guint n_construct_properties,
                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	LibraryWindow * self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	TopDisplay* _tmp3_;
	GtkModelButton* import_menu_item = NULL;
	GtkAction* _tmp4_;
	gchar* _tmp5_;
	GtkModelButton* _tmp6_ = NULL;
	GtkSeparator* separator = NULL;
	GtkSeparator* _tmp7_ = NULL;
	GtkModelButton* sidebar_modelbutton = NULL;
	GtkAction* _tmp8_;
	GtkModelButton* _tmp9_ = NULL;
	GtkModelButton* _tmp10_;
	GtkWidget* _tmp11_;
	GtkModelButton* _tmp12_;
	GraniteAccelLabel* _tmp13_;
	GraniteAccelLabel* _tmp14_;
	GtkModelButton* metadata_modelbutton = NULL;
	GtkAction* _tmp15_;
	GtkModelButton* _tmp16_ = NULL;
	GtkModelButton* _tmp17_;
	GtkWidget* _tmp18_;
	GtkModelButton* _tmp19_;
	GraniteAccelLabel* _tmp20_;
	GraniteAccelLabel* _tmp21_;
	GtkModelButton* preferences_menu_item = NULL;
	GtkAction* _tmp22_;
	gchar* _tmp23_;
	GtkModelButton* _tmp24_ = NULL;
	GtkGrid* menu_popover_grid = NULL;
	GtkGrid* _tmp25_ = NULL;
	GtkGrid* _tmp26_;
	GtkModelButton* _tmp27_;
	GtkGrid* _tmp28_;
	GtkSeparator* _tmp29_;
	GtkGrid* _tmp30_;
	GtkModelButton* _tmp31_;
	GtkGrid* _tmp32_;
	GtkModelButton* _tmp33_;
	GtkGrid* _tmp34_;
	GtkModelButton* _tmp35_;
	GtkGrid* _tmp36_;
	GtkPopover* menu_popover = NULL;
	GtkPopover* _tmp37_;
	GtkPopover* _tmp38_;
	GtkGrid* _tmp39_;
	GtkMenuButton* settings = NULL;
	GtkImage* _tmp40_;
	gchar* _tmp41_;
	GtkPopover* _tmp42_;
	GtkPopover* _tmp43_;
	GtkMenuButton* _tmp44_ = NULL;
	GtkMenuButton* _tmp45_;
	SearchFilterEntry* _tmp46_ = NULL;
	HdyHeaderBar* _tmp47_;
	GtkMenuButton* _tmp48_;
	HdyHeaderBar* _tmp49_;
	GtkButton* _tmp50_;
	HdyHeaderBar* _tmp51_;
	GtkButton* _tmp52_;
	HdyHeaderBar* _tmp53_;
	SearchFilterEntry* _tmp54_;
	HdyHeaderBar* _tmp55_;
	TopDisplay* _tmp56_;
	SidebarTree* _tmp57_ = NULL;
	GtkScrolledWindow* _tmp58_ = NULL;
	GtkScrolledWindow* _tmp59_;
	GtkStyleContext* _tmp60_;
	GtkScrolledWindow* _tmp61_;
	SidebarTree* _tmp62_;
	gint _tmp63_;
	gint _tmp64_;
	GtkNotebook* _tmp65_ = NULL;
	GtkNotebook* _tmp66_;
	GtkNotebook* _tmp67_;
	MetadataView* _tmp68_ = NULL;
	GtkPaned* _tmp69_ = NULL;
	GtkPaned* _tmp70_;
	GtkNotebook* _tmp71_;
	GtkPaned* _tmp72_;
	MetadataView* _tmp73_;
	GtkBox* _tmp74_;
	GtkBox* _tmp75_;
	GtkPaned* _tmp76_;
	GtkFrame* _tmp77_;
	GtkFrame* _tmp78_;
	GtkStyleContext* _tmp79_;
	GtkFrame* _tmp80_;
	GtkBox* _tmp81_;
	GtkPaned* _tmp82_ = NULL;
	GtkPaned* _tmp83_;
	GtkScrolledWindow* _tmp84_;
	GtkPaned* _tmp85_;
	GtkFrame* _tmp86_;
	GtkGrid* layout = NULL;
	GtkGrid* _tmp87_ = NULL;
	GtkGrid* _tmp88_;
	HdyHeaderBar* _tmp89_;
	GtkGrid* _tmp90_;
	GtkPaned* _tmp91_;
	GtkGrid* _tmp92_;
	GSettings* _tmp93_;
	GtkPaned* _tmp94_;
	GSettings* _tmp95_;
	GtkPaned* _tmp96_;
	TopDisplay* _tmp97_;
	SearchFilterEntry* _tmp98_;
	SidebarTree* _tmp99_;
	SidebarTree* _tmp100_;
	SidebarTree* _tmp101_;
	SidebarTree* _tmp102_;
	SidebarTree* _tmp103_;
	LibraryBranch* _tmp104_;
	SidebarTree* _tmp105_;
	TagsBranch* _tmp106_;
	SidebarTree* _tmp107_;
	EventsBranch* _tmp108_;
	SidebarTree* _tmp109_;
	CameraBranch* _tmp110_;
	SidebarTree* _tmp111_;
	SearchesBranch* _tmp112_;
	parent_class = G_OBJECT_CLASS (library_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LIBRARY_WINDOW, LibraryWindow);
	_tmp0_ = ((AppWindow*) self)->window_settings;
	_tmp1_ = ((AppWindow*) self)->window_settings;
	gtk_window_set_default_size ((GtkWindow*) self, g_settings_get_int (_tmp0_, "library-width"), g_settings_get_int (_tmp1_, "library-height"));
	_tmp2_ = ((AppWindow*) self)->window_settings;
	if (g_settings_get_boolean (_tmp2_, "library-maximize")) {
		gtk_window_maximize ((GtkWindow*) self);
	}
	_tmp3_ = top_display_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->top_display);
	self->priv->top_display = _tmp3_;
	_tmp4_ = app_window_get_common_action ((AppWindow*) self, "CommonFileImport");
	_tmp5_ = g_strdup (_ ("_Import From Folder…"));
	_tmp6_ = (GtkModelButton*) gtk_model_button_new ();
	gtk_activatable_set_related_action ((GtkActivatable*) _tmp6_, _tmp4_);
	_g_object_unref0 (_tmp4_);
	g_object_set (_tmp6_, "text", _tmp5_, NULL);
	_g_free0 (_tmp5_);
	g_object_ref_sink (_tmp6_);
	import_menu_item = _tmp6_;
	_tmp7_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp7_, 3);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp7_, 3);
	g_object_ref_sink (_tmp7_);
	separator = _tmp7_;
	_tmp8_ = app_window_get_common_action ((AppWindow*) self, "CommonDisplaySidebar");
	_tmp9_ = (GtkModelButton*) gtk_model_button_new ();
	gtk_activatable_set_related_action ((GtkActivatable*) _tmp9_, _tmp8_);
	_g_object_unref0 (_tmp8_);
	g_object_ref_sink (_tmp9_);
	sidebar_modelbutton = _tmp9_;
	_tmp10_ = sidebar_modelbutton;
	_tmp11_ = gtk_bin_get_child ((GtkBin*) _tmp10_);
	gtk_widget_destroy (_tmp11_);
	_tmp12_ = sidebar_modelbutton;
	_tmp13_ = granite_accel_label_new (_ ("Toggle Sidebar"), "F9");
	g_object_ref_sink (_tmp13_);
	_tmp14_ = _tmp13_;
	gtk_container_add ((GtkContainer*) _tmp12_, (GtkWidget*) _tmp14_);
	_g_object_unref0 (_tmp14_);
	_tmp15_ = app_window_get_common_action ((AppWindow*) self, "CommonDisplayMetadataSidebar");
	_tmp16_ = (GtkModelButton*) gtk_model_button_new ();
	gtk_activatable_set_related_action ((GtkActivatable*) _tmp16_, _tmp15_);
	_g_object_unref0 (_tmp15_);
	g_object_ref_sink (_tmp16_);
	metadata_modelbutton = _tmp16_;
	_tmp17_ = metadata_modelbutton;
	_tmp18_ = gtk_bin_get_child ((GtkBin*) _tmp17_);
	gtk_widget_destroy (_tmp18_);
	_tmp19_ = metadata_modelbutton;
	_tmp20_ = granite_accel_label_new (_ ("Toggle Photo Info"), "F10");
	g_object_ref_sink (_tmp20_);
	_tmp21_ = _tmp20_;
	gtk_container_add ((GtkContainer*) _tmp19_, (GtkWidget*) _tmp21_);
	_g_object_unref0 (_tmp21_);
	_tmp22_ = app_window_get_common_action ((AppWindow*) self, "CommonPreferences");
	_tmp23_ = g_strdup (_ ("_Preferences"));
	_tmp24_ = (GtkModelButton*) gtk_model_button_new ();
	gtk_activatable_set_related_action ((GtkActivatable*) _tmp24_, _tmp22_);
	_g_object_unref0 (_tmp22_);
	g_object_set (_tmp24_, "text", _tmp23_, NULL);
	_g_free0 (_tmp23_);
	g_object_ref_sink (_tmp24_);
	preferences_menu_item = _tmp24_;
	_tmp25_ = (GtkGrid*) gtk_grid_new ();
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp25_, 3);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp25_, 3);
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp25_, GTK_ORIENTATION_VERTICAL);
	g_object_ref_sink (_tmp25_);
	menu_popover_grid = _tmp25_;
	_tmp26_ = menu_popover_grid;
	_tmp27_ = import_menu_item;
	gtk_container_add ((GtkContainer*) _tmp26_, (GtkWidget*) _tmp27_);
	_tmp28_ = menu_popover_grid;
	_tmp29_ = separator;
	gtk_container_add ((GtkContainer*) _tmp28_, (GtkWidget*) _tmp29_);
	_tmp30_ = menu_popover_grid;
	_tmp31_ = sidebar_modelbutton;
	gtk_container_add ((GtkContainer*) _tmp30_, (GtkWidget*) _tmp31_);
	_tmp32_ = menu_popover_grid;
	_tmp33_ = metadata_modelbutton;
	gtk_container_add ((GtkContainer*) _tmp32_, (GtkWidget*) _tmp33_);
	_tmp34_ = menu_popover_grid;
	_tmp35_ = preferences_menu_item;
	gtk_container_add ((GtkContainer*) _tmp34_, (GtkWidget*) _tmp35_);
	_tmp36_ = menu_popover_grid;
	gtk_widget_show_all ((GtkWidget*) _tmp36_);
	_tmp37_ = (GtkPopover*) gtk_popover_new (NULL);
	g_object_ref_sink (_tmp37_);
	menu_popover = _tmp37_;
	_tmp38_ = menu_popover;
	_tmp39_ = menu_popover_grid;
	gtk_container_add ((GtkContainer*) _tmp38_, (GtkWidget*) _tmp39_);
	_tmp40_ = (GtkImage*) gtk_image_new_from_icon_name ("open-menu", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	g_object_ref_sink (_tmp40_);
	_tmp41_ = g_strdup (_ ("Settings"));
	_tmp42_ = menu_popover;
	_tmp43_ = _g_object_ref0 (_tmp42_);
	_tmp44_ = (GtkMenuButton*) gtk_menu_button_new ();
	gtk_button_set_image ((GtkButton*) _tmp44_, (GtkWidget*) _tmp40_);
	_g_object_unref0 (_tmp40_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp44_, _tmp41_);
	_g_free0 (_tmp41_);
	gtk_menu_button_set_popover (_tmp44_, _tmp43_);
	_g_object_unref0 (_tmp43_);
	g_object_ref_sink (_tmp44_);
	settings = _tmp44_;
	_tmp45_ = settings;
	gtk_widget_show_all ((GtkWidget*) _tmp45_);
	_tmp46_ = search_filter_entry_new ();
	gtk_widget_set_valign ((GtkWidget*) _tmp46_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp46_);
	_g_object_unref0 (self->priv->search_entry);
	self->priv->search_entry = _tmp46_;
	_tmp47_ = ((AppWindow*) self)->header;
	_tmp48_ = settings;
	hdy_header_bar_pack_end (_tmp47_, (GtkWidget*) _tmp48_);
	_tmp49_ = ((AppWindow*) self)->header;
	_tmp50_ = ((AppWindow*) self)->redo_btn;
	hdy_header_bar_pack_end (_tmp49_, (GtkWidget*) _tmp50_);
	_tmp51_ = ((AppWindow*) self)->header;
	_tmp52_ = ((AppWindow*) self)->undo_btn;
	hdy_header_bar_pack_end (_tmp51_, (GtkWidget*) _tmp52_);
	_tmp53_ = ((AppWindow*) self)->header;
	_tmp54_ = self->priv->search_entry;
	hdy_header_bar_pack_end (_tmp53_, (GtkWidget*) _tmp54_);
	_tmp55_ = ((AppWindow*) self)->header;
	_tmp56_ = self->priv->top_display;
	hdy_header_bar_set_custom_title (_tmp55_, (GtkWidget*) _tmp56_);
	_tmp57_ = sidebar_tree_new (LIBRARY_WINDOW_DND_TARGET_ENTRIES, G_N_ELEMENTS (LIBRARY_WINDOW_DND_TARGET_ENTRIES), GDK_ACTION_ASK, _library_window_external_drop_handler_sidebar_tree_external_drop_handler, self);
	g_object_set ((GtkWidget*) _tmp57_, "width-request", LIBRARY_WINDOW_SIDEBAR_MIN_WIDTH, NULL);
	g_object_ref_sink (_tmp57_);
	_g_object_unref0 (self->priv->sidebar_tree);
	self->priv->sidebar_tree = _tmp57_;
	_tmp58_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_set (_tmp58_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	g_object_ref_sink (_tmp58_);
	_g_object_unref0 (self->priv->scrolled_sidebar);
	self->priv->scrolled_sidebar = _tmp58_;
	_tmp59_ = self->priv->scrolled_sidebar;
	_tmp60_ = gtk_widget_get_style_context ((GtkWidget*) _tmp59_);
	gtk_style_context_add_class (_tmp60_, GTK_STYLE_CLASS_SIDEBAR);
	_tmp61_ = self->priv->scrolled_sidebar;
	_tmp62_ = self->priv->sidebar_tree;
	gtk_container_add ((GtkContainer*) _tmp61_, (GtkWidget*) _tmp62_);
	_tmp63_ = library_window_get_PAGE_MIN_WIDTH ();
	_tmp64_ = _tmp63_;
	_tmp65_ = (GtkNotebook*) gtk_notebook_new ();
	g_object_set ((GtkWidget*) _tmp65_, "width-request", _tmp64_, NULL);
	g_object_ref_sink (_tmp65_);
	_g_object_unref0 (self->priv->notebook);
	self->priv->notebook = _tmp65_;
	_tmp66_ = self->priv->notebook;
	gtk_notebook_set_show_tabs (_tmp66_, FALSE);
	_tmp67_ = self->priv->notebook;
	gtk_notebook_set_show_border (_tmp67_, FALSE);
	_tmp68_ = metadata_view_new ();
	g_object_set ((GtkWidget*) _tmp68_, "width-request", LIBRARY_WINDOW_METADATA_SIDEBAR_MIN_WIDTH, NULL);
	g_object_ref_sink (_tmp68_);
	_g_object_unref0 (self->priv->metadata_sidebar);
	self->priv->metadata_sidebar = _tmp68_;
	_tmp69_ = (GtkPaned*) gtk_paned_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_set ((GtkWidget*) _tmp69_, "width-request", LIBRARY_WINDOW_METADATA_SIDEBAR_MIN_WIDTH, NULL);
	g_object_ref_sink (_tmp69_);
	_g_object_unref0 (self->priv->right_client_paned);
	self->priv->right_client_paned = _tmp69_;
	_tmp70_ = self->priv->right_client_paned;
	_tmp71_ = self->priv->notebook;
	gtk_paned_pack1 (_tmp70_, (GtkWidget*) _tmp71_, TRUE, FALSE);
	_tmp72_ = self->priv->right_client_paned;
	_tmp73_ = self->priv->metadata_sidebar;
	gtk_paned_pack2 (_tmp72_, (GtkWidget*) _tmp73_, FALSE, FALSE);
	_tmp74_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp74_);
	_g_object_unref0 (self->priv->right_vbox);
	self->priv->right_vbox = _tmp74_;
	_tmp75_ = self->priv->right_vbox;
	_tmp76_ = self->priv->right_client_paned;
	gtk_box_pack_start (_tmp75_, (GtkWidget*) _tmp76_, TRUE, TRUE, (guint) 0);
	_tmp77_ = (GtkFrame*) gtk_frame_new (NULL);
	g_object_ref_sink (_tmp77_);
	_g_object_unref0 (self->priv->right_frame);
	self->priv->right_frame = _tmp77_;
	_tmp78_ = self->priv->right_frame;
	_tmp79_ = gtk_widget_get_style_context ((GtkWidget*) _tmp78_);
	gtk_style_context_add_class (_tmp79_, GTK_STYLE_CLASS_FLAT);
	_tmp80_ = self->priv->right_frame;
	_tmp81_ = self->priv->right_vbox;
	gtk_container_add ((GtkContainer*) _tmp80_, (GtkWidget*) _tmp81_);
	_tmp82_ = (GtkPaned*) gtk_paned_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_set ((GtkWidget*) _tmp82_, "expand", TRUE, NULL);
	g_object_ref_sink (_tmp82_);
	_g_object_unref0 (self->priv->client_paned);
	self->priv->client_paned = _tmp82_;
	_tmp83_ = self->priv->client_paned;
	_tmp84_ = self->priv->scrolled_sidebar;
	gtk_paned_pack1 (_tmp83_, (GtkWidget*) _tmp84_, FALSE, FALSE);
	_tmp85_ = self->priv->client_paned;
	_tmp86_ = self->priv->right_frame;
	gtk_paned_pack2 (_tmp85_, (GtkWidget*) _tmp86_, TRUE, FALSE);
	_tmp87_ = (GtkGrid*) gtk_grid_new ();
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp87_, GTK_ORIENTATION_VERTICAL);
	g_object_ref_sink (_tmp87_);
	layout = _tmp87_;
	_tmp88_ = layout;
	_tmp89_ = ((AppWindow*) self)->header;
	gtk_container_add ((GtkContainer*) _tmp88_, (GtkWidget*) _tmp89_);
	_tmp90_ = layout;
	_tmp91_ = self->priv->client_paned;
	gtk_container_add ((GtkContainer*) _tmp90_, (GtkWidget*) _tmp91_);
	_tmp92_ = layout;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp92_);
	_tmp93_ = library_window_ui_settings;
	_tmp94_ = self->priv->client_paned;
	g_settings_bind (_tmp93_, "sidebar-position", (GObject*) _tmp94_, "position", G_SETTINGS_BIND_DEFAULT);
	_tmp95_ = library_window_ui_settings;
	_tmp96_ = self->priv->right_client_paned;
	g_settings_bind (_tmp95_, "metadata-sidebar-position", (GObject*) _tmp96_, "position", G_SETTINGS_BIND_DEFAULT);
	_tmp97_ = self->priv->top_display;
	g_object_bind_property_with_closures ((GObject*) self, "title", (GObject*) _tmp97_, "title", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp98_ = self->priv->search_entry;
	g_signal_connect_object ((GtkEntry*) _tmp98_, "activate", (GCallback) __library_window___lambda123__gtk_entry_activate, self, 0);
	_tmp99_ = self->priv->sidebar_tree;
	g_signal_connect_object (_tmp99_, "page-created", (GCallback) _library_window_on_page_created_sidebar_tree_page_created, self, 0);
	_tmp100_ = self->priv->sidebar_tree;
	g_signal_connect_object (_tmp100_, "destroying-page", (GCallback) _library_window_on_destroying_page_sidebar_tree_destroying_page, self, 0);
	_tmp101_ = self->priv->sidebar_tree;
	g_signal_connect_object (_tmp101_, "entry-selected", (GCallback) _library_window_on_sidebar_entry_selected_sidebar_tree_entry_selected, self, 0);
	_tmp102_ = self->priv->sidebar_tree;
	g_signal_connect_object (_tmp102_, "selected-entry-removed", (GCallback) _library_window_on_sidebar_selected_entry_removed_sidebar_tree_selected_entry_removed, self, 0);
	_tmp103_ = self->priv->sidebar_tree;
	_tmp104_ = self->priv->library_branch;
	sidebar_tree_graft (_tmp103_, (SidebarBranch*) _tmp104_, (gint) LIBRARY_WINDOW_SIDEBAR_ROOT_POSITION_LIBRARY);
	_tmp105_ = self->priv->sidebar_tree;
	_tmp106_ = self->priv->tags_branch;
	sidebar_tree_graft (_tmp105_, (SidebarBranch*) _tmp106_, (gint) LIBRARY_WINDOW_SIDEBAR_ROOT_POSITION_TAGS);
	_tmp107_ = self->priv->sidebar_tree;
	_tmp108_ = self->priv->events_branch;
	sidebar_tree_graft (_tmp107_, (SidebarBranch*) _tmp108_, (gint) LIBRARY_WINDOW_SIDEBAR_ROOT_POSITION_EVENTS);
	_tmp109_ = self->priv->sidebar_tree;
	_tmp110_ = self->priv->camera_branch;
	sidebar_tree_graft (_tmp109_, (SidebarBranch*) _tmp110_, (gint) LIBRARY_WINDOW_SIDEBAR_ROOT_POSITION_CAMERAS);
	_tmp111_ = self->priv->sidebar_tree;
	_tmp112_ = self->priv->saved_search_branch;
	sidebar_tree_graft (_tmp111_, (SidebarBranch*) _tmp112_, (gint) LIBRARY_WINDOW_SIDEBAR_ROOT_POSITION_SAVED_SEARCH);
	_g_object_unref0 (layout);
	_g_object_unref0 (settings);
	_g_object_unref0 (menu_popover);
	_g_object_unref0 (menu_popover_grid);
	_g_object_unref0 (preferences_menu_item);
	_g_object_unref0 (metadata_modelbutton);
	_g_object_unref0 (sidebar_modelbutton);
	_g_object_unref0 (separator);
	_g_object_unref0 (import_menu_item);
	return obj;
}

static void
library_window_class_init (LibraryWindowClass * klass,
                           gpointer klass_data)
{
	GeeHashSet* _tmp0_;
	GSettings* _tmp1_;
	library_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &LibraryWindow_private_offset);
	((AppWindowClass *) klass)->create_common_action_groups = (GtkActionGroup** (*) (AppWindow*, gint*)) library_window_real_create_common_action_groups;
	((PageWindowClass *) klass)->switched_pages = (void (*) (PageWindow*, Page*, Page*)) library_window_real_switched_pages;
	((GtkWidgetClass *) klass)->show_all = (void (*) (GtkWidget*)) library_window_real_show_all;
	((AppWindowClass *) klass)->get_app_role = (gchar* (*) (AppWindow*)) library_window_real_get_app_role;
	((AppWindowClass *) klass)->on_quit = (void (*) (AppWindow*)) library_window_real_on_quit;
	((AppWindowClass *) klass)->on_fullscreen = (void (*) (AppWindow*)) library_window_real_on_fullscreen;
	((AppWindowClass *) klass)->update_common_action_availability = (void (*) (AppWindow*, Page*, Page*)) library_window_real_update_common_action_availability;
	((AppWindowClass *) klass)->update_common_actions = (void (*) (AppWindow*, Page*, gint, gint)) library_window_real_update_common_actions;
	((GtkWidgetClass *) klass)->drag_motion = (gboolean (*) (GtkWidget*, GdkDragContext*, gint, gint, guint)) library_window_real_drag_motion;
	((GtkWidgetClass *) klass)->drag_data_received = (void (*) (GtkWidget*, GdkDragContext*, gint, gint, GtkSelectionData*, guint, guint)) library_window_real_drag_data_received;
	((PageWindowClass *) klass)->set_current_page = (void (*) (PageWindow*, Page*)) library_window_real_set_current_page;
	((GtkWidgetClass *) klass)->key_press_event = (gboolean (*) (GtkWidget*, GdkEventKey*)) library_window_real_key_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_library_window_get_property;
	G_OBJECT_CLASS (klass)->constructor = library_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = library_window_finalize;
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	library_window_initial_camera_uris = _tmp0_;
	_tmp1_ = g_settings_new (GSETTINGS_CONFIGURATION_ENGINE_UI_PREFS_SCHEMA_NAME);
	_g_object_unref0 (library_window_ui_settings);
	library_window_ui_settings = _tmp1_;
}

static void
library_window_instance_init (LibraryWindow * self,
                              gpointer klass)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GtkActionGroup* _tmp2_;
	LibraryBranch* _tmp3_;
	TagsBranch* _tmp4_;
	EventsBranch* _tmp5_;
	CameraBranch* _tmp6_;
	SearchesBranch* _tmp7_;
	GeeHashMap* _tmp8_;
	self->priv = library_window_get_instance_private (self);
	_tmp0_ = g_get_home_dir ();
	_tmp1_ = g_strdup (_tmp0_);
	self->priv->import_dir = _tmp1_;
	_tmp2_ = gtk_action_group_new ("LibraryWindowGlobalActionGroup");
	self->priv->common_action_group = _tmp2_;
	self->priv->properties_scheduler = NULL;
	self->priv->notify_library_is_home_dir = TRUE;
	_tmp3_ = library_branch_new ();
	self->priv->library_branch = _tmp3_;
	_tmp4_ = tags_branch_new ();
	self->priv->tags_branch = _tmp4_;
	_tmp5_ = events_branch_new ();
	self->priv->events_branch = _tmp5_;
	_tmp6_ = camera_branch_new ();
	self->priv->camera_branch = _tmp6_;
	_tmp7_ = searches_branch_new ();
	self->priv->saved_search_branch = _tmp7_;
	self->priv->page_switching_enabled = TRUE;
	_tmp8_ = gee_hash_map_new (TYPE_PAGE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, SIDEBAR_TYPE_ENTRY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->page_map = _tmp8_;
	self->priv->photo_page = NULL;
}

static void
library_window_finalize (GObject * obj)
{
	LibraryWindow * self;
	SidebarTree* _tmp0_;
	guint _tmp1_;
	SidebarTree* _tmp2_;
	guint _tmp3_;
	SidebarTree* _tmp4_;
	guint _tmp5_;
	SidebarTree* _tmp6_;
	guint _tmp7_;
	Page* _tmp8_;
	Page* _tmp9_;
	MetadataWriter* _tmp21_;
	MetadataWriter* _tmp22_;
	guint _tmp23_;
	LibraryMonitor* monitor = NULL;
	LibraryMonitorPool* _tmp24_;
	LibraryMonitorPool* _tmp25_;
	LibraryMonitor* _tmp26_;
	LibraryMonitor* _tmp27_;
	LibraryMonitor* _tmp28_;
	LibraryMonitorPool* _tmp30_;
	LibraryMonitorPool* _tmp31_;
	guint _tmp32_;
	LibraryMonitorPool* _tmp33_;
	LibraryMonitorPool* _tmp34_;
	guint _tmp35_;
	CameraTable* _tmp36_;
	CameraTable* _tmp37_;
	guint _tmp38_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LIBRARY_WINDOW, LibraryWindow);
	_tmp0_ = self->priv->sidebar_tree;
	g_signal_parse_name ("page-created", SIDEBAR_TYPE_TREE, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _library_window_on_page_created_sidebar_tree_page_created, self);
	_tmp2_ = self->priv->sidebar_tree;
	g_signal_parse_name ("destroying-page", SIDEBAR_TYPE_TREE, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _library_window_on_destroying_page_sidebar_tree_destroying_page, self);
	_tmp4_ = self->priv->sidebar_tree;
	g_signal_parse_name ("entry-selected", SIDEBAR_TYPE_TREE, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _library_window_on_sidebar_entry_selected_sidebar_tree_entry_selected, self);
	_tmp6_ = self->priv->sidebar_tree;
	g_signal_parse_name ("selected-entry-removed", SIDEBAR_TYPE_TREE, &_tmp7_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _library_window_on_sidebar_selected_entry_removed_sidebar_tree_selected_entry_removed, self);
	_tmp8_ = page_window_get_current_page ((PageWindow*) self);
	_tmp9_ = _tmp8_;
	library_window_unsubscribe_from_basic_information (self, _tmp9_);
	_g_object_unref0 (_tmp9_);
	{
		GeeIterator* _media_sources_it = NULL;
		MediaCollectionRegistry* _tmp10_;
		MediaCollectionRegistry* _tmp11_;
		GeeCollection* _tmp12_;
		GeeCollection* _tmp13_;
		GeeIterator* _tmp14_;
		GeeIterator* _tmp15_;
		_tmp10_ = media_collection_registry_get_instance ();
		_tmp11_ = _tmp10_;
		_tmp12_ = media_collection_registry_get_all (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = gee_iterable_iterator ((GeeIterable*) _tmp13_);
		_tmp15_ = _tmp14_;
		_g_object_unref0 (_tmp13_);
		_media_collection_registry_unref0 (_tmp11_);
		_media_sources_it = _tmp15_;
		while (TRUE) {
			GeeIterator* _tmp16_;
			MediaSourceCollection* media_sources = NULL;
			GeeIterator* _tmp17_;
			gpointer _tmp18_;
			MediaSourceCollection* _tmp19_;
			guint _tmp20_;
			_tmp16_ = _media_sources_it;
			if (!gee_iterator_next (_tmp16_)) {
				break;
			}
			_tmp17_ = _media_sources_it;
			_tmp18_ = gee_iterator_get (_tmp17_);
			media_sources = (MediaSourceCollection*) _tmp18_;
			_tmp19_ = media_sources;
			g_signal_parse_name ("items-altered", TYPE_DATA_COLLECTION, &_tmp20_, NULL, FALSE);
			g_signal_handlers_disconnect_matched ((DataCollection*) _tmp19_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp20_, 0, NULL, (GCallback) _library_window_on_media_altered_data_collection_items_altered, self);
			_data_collection_unref0 (media_sources);
		}
		_g_object_unref0 (_media_sources_it);
	}
	_tmp21_ = metadata_writer_get_instance ();
	_tmp22_ = _tmp21_;
	g_signal_parse_name ("progress", TYPE_METADATA_WRITER, &_tmp23_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp22_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp23_, 0, NULL, (GCallback) _library_window_on_metadata_writer_progress_metadata_writer_progress, self);
	_g_object_unref0 (_tmp22_);
	_tmp24_ = library_monitor_pool_get_instance ();
	_tmp25_ = _tmp24_;
	_tmp26_ = library_monitor_pool_get_monitor (_tmp25_);
	_tmp27_ = _tmp26_;
	_library_monitor_pool_unref0 (_tmp25_);
	monitor = _tmp27_;
	_tmp28_ = monitor;
	if (_tmp28_ != NULL) {
		LibraryMonitor* _tmp29_;
		_tmp29_ = monitor;
		library_window_on_library_monitor_destroyed (self, _tmp29_);
	}
	_tmp30_ = library_monitor_pool_get_instance ();
	_tmp31_ = _tmp30_;
	g_signal_parse_name ("monitor-installed", TYPE_LIBRARY_MONITOR_POOL, &_tmp32_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp31_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp32_, 0, NULL, (GCallback) _library_window_on_library_monitor_installed_library_monitor_pool_monitor_installed, self);
	_library_monitor_pool_unref0 (_tmp31_);
	_tmp33_ = library_monitor_pool_get_instance ();
	_tmp34_ = _tmp33_;
	g_signal_parse_name ("monitor-destroyed", TYPE_LIBRARY_MONITOR_POOL, &_tmp35_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp34_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp35_, 0, NULL, (GCallback) _library_window_on_library_monitor_destroyed_library_monitor_pool_monitor_destroyed, self);
	_library_monitor_pool_unref0 (_tmp34_);
	_tmp36_ = camera_table_get_instance ();
	_tmp37_ = _tmp36_;
	g_signal_parse_name ("camera-added", TYPE_CAMERA_TABLE, &_tmp38_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp37_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp38_, 0, NULL, (GCallback) _library_window_on_camera_added_camera_table_camera_added, self);
	_camera_table_unref0 (_tmp37_);
	_g_object_unref0 (monitor);
	_g_free0 (self->priv->import_dir);
	_g_object_unref0 (self->priv->client_paned);
	_g_object_unref0 (self->priv->right_client_paned);
	_g_object_unref0 (self->priv->metadata_sidebar);
	_g_object_unref0 (self->priv->scrolled_sidebar);
	_g_object_unref0 (self->priv->common_action_group);
	_one_shot_scheduler_unref0 (self->priv->properties_scheduler);
	_g_object_unref0 (self->priv->welcome_page);
	_g_object_unref0 (self->priv->right_frame);
	_g_object_unref0 (self->priv->sidebar_tree);
	_g_object_unref0 (self->priv->library_branch);
	_g_object_unref0 (self->priv->tags_branch);
	_g_object_unref0 (self->priv->events_branch);
	_g_object_unref0 (self->priv->camera_branch);
	_g_object_unref0 (self->priv->saved_search_branch);
	_g_object_unref0 (self->priv->page_map);
	_g_object_unref0 (self->priv->photo_page);
	_g_object_unref0 (self->priv->search_entry);
	_g_object_unref0 (self->priv->page_header_box);
	_g_object_unref0 (self->priv->top_display);
	_g_object_unref0 (self->priv->notebook);
	_g_object_unref0 (self->priv->right_vbox);
	G_OBJECT_CLASS (library_window_parent_class)->finalize (obj);
}

static GType
library_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (LibraryWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) library_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LibraryWindow), 0, (GInstanceInitFunc) library_window_instance_init, NULL };
	GType library_window_type_id;
	library_window_type_id = g_type_register_static (TYPE_APP_WINDOW, "LibraryWindow", &g_define_type_info, 0);
	LibraryWindow_private_offset = g_type_add_instance_private (library_window_type_id, sizeof (LibraryWindowPrivate));
	return library_window_type_id;
}

GType
library_window_get_type (void)
{
	static volatile gsize library_window_type_id__once = 0;
	if (g_once_init_enter (&library_window_type_id__once)) {
		GType library_window_type_id;
		library_window_type_id = library_window_get_type_once ();
		g_once_init_leave (&library_window_type_id__once, library_window_type_id);
	}
	return library_window_type_id__once;
}

static void
_vala_library_window_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	LibraryWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_LIBRARY_WINDOW, LibraryWindow);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

