/* Branch.c generated by valac 0.56.18, the Vala compiler
 * generated from Branch.vala, do not modify */

/*
* Copyright (c) 2011-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	TAGS_BRANCH_0_PROPERTY,
	TAGS_BRANCH_NUM_PROPERTIES
};
static GParamSpec* tags_branch_properties[TAGS_BRANCH_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _alteration_unref0(var) ((var == NULL) ? NULL : (var = (alteration_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	TAGS_GROUPING_0_PROPERTY,
	TAGS_GROUPING_NUM_PROPERTIES
};
static GParamSpec* tags_grouping_properties[TAGS_GROUPING_NUM_PROPERTIES];
#define _command_manager_unref0(var) ((var == NULL) ? NULL : (var = (command_manager_unref (var), NULL)))
enum  {
	TAGS_SIDEBAR_ENTRY_0_PROPERTY,
	TAGS_SIDEBAR_ENTRY_NUM_PROPERTIES
};
static GParamSpec* tags_sidebar_entry_properties[TAGS_SIDEBAR_ENTRY_NUM_PROPERTIES];
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _TagsBranchPrivate {
	GeeHashMap* entry_map;
};

struct _TagsGroupingPrivate {
	GtkMenu* context_menu;
};

struct _TagsSidebarEntryPrivate {
	Tag* tag;
};

static gint TagsBranch_private_offset;
static gpointer tags_branch_parent_class = NULL;
static gint TagsGrouping_private_offset;
static gpointer tags_grouping_parent_class = NULL;
static SidebarInternalDropTargetEntryIface * tags_grouping_sidebar_internal_drop_target_entry_parent_iface = NULL;
static SidebarInternalDragSourceEntryIface * tags_grouping_sidebar_internal_drag_source_entry_parent_iface = NULL;
static SidebarContextableIface * tags_grouping_sidebar_contextable_parent_iface = NULL;
static gint TagsSidebarEntry_private_offset;
static gpointer tags_sidebar_entry_parent_class = NULL;
static GIcon* tags_sidebar_entry_single_tag_icon;
static GIcon* tags_sidebar_entry_single_tag_icon = NULL;
static SidebarRenameableEntryIface * tags_sidebar_entry_sidebar_renameable_entry_parent_iface = NULL;
static SidebarDestroyableEntryIface * tags_sidebar_entry_sidebar_destroyable_entry_parent_iface = NULL;
static SidebarInternalDropTargetEntryIface * tags_sidebar_entry_sidebar_internal_drop_target_entry_parent_iface = NULL;
static SidebarExpandableEntryIface * tags_sidebar_entry_sidebar_expandable_entry_parent_iface = NULL;
static SidebarInternalDragSourceEntryIface * tags_sidebar_entry_sidebar_internal_drag_source_entry_parent_iface = NULL;

static void tags_branch_on_tags_added_removed (TagsBranch* self,
                                        GeeIterable* added_raw,
                                        GeeIterable* removed);
static void _tags_branch_on_tags_added_removed_data_collection_contents_altered (DataCollection* _sender,
                                                                          GeeIterable* added,
                                                                          GeeIterable* removed,
                                                                          gpointer self);
static void tags_branch_on_tags_altered (TagsBranch* self,
                                  GeeMap* altered);
static void _tags_branch_on_tags_altered_data_collection_items_altered (DataCollection* _sender,
                                                                 GeeMap* items,
                                                                 gpointer self);
static gint tags_branch_comparator (SidebarEntry* a,
                             SidebarEntry* b);
static gint _tags_branch_comparator_gcompare_func (gconstpointer a,
                                            gconstpointer b);
static gint _tag_compare_names_gcompare_data_func (gconstpointer a,
                                            gconstpointer b,
                                            gpointer self);
static void tags_branch_finalize (GObject * obj);
static GType tags_branch_get_type_once (void);
static gboolean tags_grouping_real_internal_drop_received (SidebarInternalDropTargetEntry* base,
                                                    GeeList* media);
static gboolean tags_grouping_real_internal_drop_received_arbitrary (SidebarInternalDropTargetEntry* base,
                                                              GtkSelectionData* data);
VALA_EXTERN GeeList* hierarchical_tag_utilities_enumerate_path_components (const gchar* in_path);
static void tags_grouping_real_prepare_selection_data (SidebarInternalDragSourceEntry* base,
                                                GtkSelectionData* data);
static GtkMenu* tags_grouping_real_get_sidebar_context_menu (SidebarContextable* base,
                                                      GdkEventButton* event);
static void ___lambda102_ (TagsGrouping* self);
static void tags_grouping_on_new_tag (TagsGrouping* self);
static void ____lambda102__gtk_menu_item_activate (GtkMenuItem* _sender,
                                            gpointer self);
static void tags_grouping_finalize (GObject * obj);
static GType tags_grouping_get_type_once (void);
static gchar* tags_sidebar_entry_real_get_sidebar_name (SidebarSimplePageEntry* base);
static GIcon* tags_sidebar_entry_real_get_sidebar_icon (SidebarSimplePageEntry* base);
static Page* tags_sidebar_entry_real_create_page (SidebarSimplePageEntry* base);
static void tags_sidebar_entry_real_rename (SidebarRenameableEntry* base,
                                     const gchar* new_name);
static void tags_sidebar_entry_real_destroy_source (SidebarDestroyableEntry* base);
static gboolean tags_sidebar_entry_real_internal_drop_received (SidebarInternalDropTargetEntry* base,
                                                         GeeList* media);
static gboolean tags_sidebar_entry_real_internal_drop_received_arbitrary (SidebarInternalDropTargetEntry* base,
                                                                   GtkSelectionData* data);
VALA_EXTERN GeeList* hierarchical_tag_utilities_enumerate_parent_paths (const gchar* in_path);
static GIcon* tags_sidebar_entry_real_get_sidebar_open_icon (SidebarExpandableEntry* base);
static GIcon* tags_sidebar_entry_real_get_sidebar_closed_icon (SidebarExpandableEntry* base);
static gboolean tags_sidebar_entry_real_expand_on_select (SidebarExpandableEntry* base);
static void tags_sidebar_entry_real_prepare_selection_data (SidebarInternalDragSourceEntry* base,
                                                     GtkSelectionData* data);
static void tags_sidebar_entry_finalize (GObject * obj);
static GType tags_sidebar_entry_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
tags_branch_get_instance_private (TagsBranch* self)
{
	return G_STRUCT_MEMBER_P (self, TagsBranch_private_offset);
}

static void
_tags_branch_on_tags_added_removed_data_collection_contents_altered (DataCollection* _sender,
                                                                     GeeIterable* added,
                                                                     GeeIterable* removed,
                                                                     gpointer self)
{
	tags_branch_on_tags_added_removed ((TagsBranch*) self, added, removed);
}

static void
_tags_branch_on_tags_altered_data_collection_items_altered (DataCollection* _sender,
                                                            GeeMap* items,
                                                            gpointer self)
{
	tags_branch_on_tags_altered ((TagsBranch*) self, items);
}

static gint
_tags_branch_comparator_gcompare_func (gconstpointer a,
                                       gconstpointer b)
{
	gint result;
	result = tags_branch_comparator ((SidebarEntry*) a, (SidebarEntry*) b);
	return result;
}

TagsBranch*
tags_branch_construct (GType object_type)
{
	TagsBranch * self = NULL;
	TagsGrouping* _tmp0_;
	TagsGrouping* _tmp1_;
	TagSourceCollection* _tmp2_;
	GeeCollection* _tmp3_;
	GeeCollection* _tmp4_;
	TagSourceCollection* _tmp5_;
	TagSourceCollection* _tmp6_;
	_tmp0_ = tags_grouping_new ();
	_tmp1_ = _tmp0_;
	self = (TagsBranch*) sidebar_branch_construct (object_type, (SidebarEntry*) _tmp1_, (SIDEBAR_BRANCH_OPTIONS_HIDE_IF_EMPTY | SIDEBAR_BRANCH_OPTIONS_AUTO_OPEN_ON_NEW_CHILD) | SIDEBAR_BRANCH_OPTIONS_STARTUP_OPEN_GROUPING, _tags_branch_comparator_gcompare_func, NULL);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = tag_global;
	_tmp3_ = data_collection_get_all ((DataCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	tags_branch_on_tags_added_removed (self, (GeeIterable*) _tmp4_, NULL);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = tag_global;
	g_signal_connect_object ((DataCollection*) _tmp5_, "contents-altered", (GCallback) _tags_branch_on_tags_added_removed_data_collection_contents_altered, self, 0);
	_tmp6_ = tag_global;
	g_signal_connect_object ((DataCollection*) _tmp6_, "items-altered", (GCallback) _tags_branch_on_tags_altered_data_collection_items_altered, self, 0);
	return self;
}

TagsBranch*
tags_branch_new (void)
{
	return tags_branch_construct (TAGS_TYPE_BRANCH);
}

TagsSidebarEntry*
tags_branch_get_entry_for_tag (TagsBranch* self,
                               Tag* tag)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	TagsSidebarEntry* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tag != NULL, NULL);
	_tmp0_ = self->priv->entry_map;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, tag);
	result = (TagsSidebarEntry*) _tmp1_;
	return result;
}

static gint
tags_branch_comparator (SidebarEntry* a,
                        SidebarEntry* b)
{
	Tag* _tmp0_;
	Tag* _tmp1_;
	Tag* _tmp2_;
	Tag* _tmp3_;
	gint _tmp4_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	if (a == b) {
		result = 0;
		return result;
	}
	_tmp0_ = tags_sidebar_entry_for_tag (G_TYPE_CHECK_INSTANCE_CAST (a, TAGS_TYPE_SIDEBAR_ENTRY, TagsSidebarEntry));
	_tmp1_ = _tmp0_;
	_tmp2_ = tags_sidebar_entry_for_tag (G_TYPE_CHECK_INSTANCE_CAST (b, TAGS_TYPE_SIDEBAR_ENTRY, TagsSidebarEntry));
	_tmp3_ = _tmp2_;
	_tmp4_ = tag_compare_names (_tmp1_, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	result = _tmp4_;
	return result;
}

static gint
_tag_compare_names_gcompare_data_func (gconstpointer a,
                                       gconstpointer b,
                                       gpointer self)
{
	gint result;
	result = tag_compare_names ((Tag*) a, (Tag*) b);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
tags_branch_on_tags_added_removed (TagsBranch* self,
                                   GeeIterable* added_raw,
                                   GeeIterable* removed)
{
	Tag* restore_point = NULL;
	g_return_if_fail (self != NULL);
	restore_point = NULL;
	if (added_raw != NULL) {
		GeeSortedSet* added = NULL;
		GeeTreeSet* _tmp0_;
		_tmp0_ = gee_tree_set_new (TYPE_TAG, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tag_compare_names_gcompare_data_func, NULL, NULL);
		added = (GeeSortedSet*) _tmp0_;
		{
			GeeIterator* _object_it = NULL;
			GeeIterator* _tmp1_;
			_tmp1_ = gee_iterable_iterator (added_raw);
			_object_it = _tmp1_;
			while (TRUE) {
				GeeIterator* _tmp2_;
				DataObject* object = NULL;
				GeeIterator* _tmp3_;
				gpointer _tmp4_;
				Tag* tag = NULL;
				DataObject* _tmp5_;
				Tag* _tmp6_;
				GeeSortedSet* _tmp7_;
				Tag* _tmp8_;
				_tmp2_ = _object_it;
				if (!gee_iterator_next (_tmp2_)) {
					break;
				}
				_tmp3_ = _object_it;
				_tmp4_ = gee_iterator_get (_tmp3_);
				object = (DataObject*) _tmp4_;
				_tmp5_ = object;
				_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_TAG, Tag));
				tag = _tmp6_;
				_tmp7_ = added;
				_tmp8_ = tag;
				gee_collection_add ((GeeCollection*) _tmp7_, _tmp8_);
				_g_object_unref0 (tag);
				_g_object_unref0 (object);
			}
			_g_object_unref0 (_object_it);
		}
		{
			GeeIterator* _tag_it = NULL;
			GeeSortedSet* _tmp9_;
			GeeIterator* _tmp10_;
			_tmp9_ = added;
			_tmp10_ = gee_iterable_iterator ((GeeIterable*) _tmp9_);
			_tag_it = _tmp10_;
			while (TRUE) {
				GeeIterator* _tmp11_;
				Tag* tag = NULL;
				GeeIterator* _tmp12_;
				gpointer _tmp13_;
				Tag* parent_tag = NULL;
				Tag* _tmp14_;
				Tag* _tmp15_;
				TagsSidebarEntry* entry = NULL;
				Tag* _tmp26_;
				TagsSidebarEntry* _tmp27_;
				GeeHashMap* _tmp28_;
				Tag* _tmp29_;
				TagsSidebarEntry* _tmp30_;
				Tag* _tmp31_;
				Tag* _tmp32_;
				Tag* _tmp33_;
				Tag* _tmp42_;
				Tag* _tmp43_;
				_tmp11_ = _tag_it;
				if (!gee_iterator_next (_tmp11_)) {
					break;
				}
				_tmp12_ = _tag_it;
				_tmp13_ = gee_iterator_get (_tmp12_);
				tag = (Tag*) _tmp13_;
				_tmp14_ = tag;
				_tmp15_ = tag_get_hierarchical_parent (_tmp14_);
				parent_tag = _tmp15_;
				while (TRUE) {
					Tag* _tmp16_;
					GeeHashMap* _tmp17_;
					Tag* _tmp18_;
					Tag* _tmp24_;
					Tag* _tmp25_;
					_tmp16_ = parent_tag;
					if (!(_tmp16_ != NULL)) {
						break;
					}
					_tmp17_ = self->priv->entry_map;
					_tmp18_ = parent_tag;
					if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp17_, _tmp18_)) {
						TagsSidebarEntry* parent_entry = NULL;
						Tag* _tmp19_;
						TagsSidebarEntry* _tmp20_;
						GeeHashMap* _tmp21_;
						Tag* _tmp22_;
						TagsSidebarEntry* _tmp23_;
						_tmp19_ = parent_tag;
						_tmp20_ = tags_sidebar_entry_new (_tmp19_);
						parent_entry = _tmp20_;
						_tmp21_ = self->priv->entry_map;
						_tmp22_ = parent_tag;
						_tmp23_ = parent_entry;
						gee_abstract_map_set ((GeeAbstractMap*) _tmp21_, _tmp22_, _tmp23_);
						_g_object_unref0 (parent_entry);
					}
					_tmp24_ = parent_tag;
					_tmp25_ = tag_get_hierarchical_parent (_tmp24_);
					_g_object_unref0 (parent_tag);
					parent_tag = _tmp25_;
				}
				_tmp26_ = tag;
				_tmp27_ = tags_sidebar_entry_new (_tmp26_);
				entry = _tmp27_;
				_tmp28_ = self->priv->entry_map;
				_tmp29_ = tag;
				_tmp30_ = entry;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp28_, _tmp29_, _tmp30_);
				_tmp31_ = tag;
				_tmp32_ = tag_get_hierarchical_parent (_tmp31_);
				_g_object_unref0 (parent_tag);
				parent_tag = _tmp32_;
				_tmp33_ = parent_tag;
				if (_tmp33_ != NULL) {
					TagsSidebarEntry* parent_entry = NULL;
					GeeHashMap* _tmp34_;
					Tag* _tmp35_;
					gpointer _tmp36_;
					TagsSidebarEntry* _tmp37_;
					TagsSidebarEntry* _tmp38_;
					_tmp34_ = self->priv->entry_map;
					_tmp35_ = parent_tag;
					_tmp36_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp34_, _tmp35_);
					parent_entry = (TagsSidebarEntry*) _tmp36_;
					_tmp37_ = parent_entry;
					_tmp38_ = entry;
					sidebar_branch_graft ((SidebarBranch*) self, (SidebarEntry*) _tmp37_, (SidebarEntry*) _tmp38_, NULL);
					_g_object_unref0 (parent_entry);
				} else {
					SidebarEntry* _tmp39_;
					SidebarEntry* _tmp40_;
					TagsSidebarEntry* _tmp41_;
					_tmp39_ = sidebar_branch_get_root ((SidebarBranch*) self);
					_tmp40_ = _tmp39_;
					_tmp41_ = entry;
					sidebar_branch_graft ((SidebarBranch*) self, _tmp40_, (SidebarEntry*) _tmp41_, NULL);
					_g_object_unref0 (_tmp40_);
				}
				_tmp42_ = tag;
				_tmp43_ = _g_object_ref0 (_tmp42_);
				_g_object_unref0 (restore_point);
				restore_point = _tmp43_;
				_g_object_unref0 (entry);
				_g_object_unref0 (parent_tag);
				_g_object_unref0 (tag);
			}
			_g_object_unref0 (_tag_it);
		}
		_g_object_unref0 (added);
	}
	if (removed != NULL) {
		{
			GeeIterator* _object_it = NULL;
			GeeIterator* _tmp44_;
			_tmp44_ = gee_iterable_iterator (removed);
			_object_it = _tmp44_;
			while (TRUE) {
				GeeIterator* _tmp45_;
				DataObject* object = NULL;
				GeeIterator* _tmp46_;
				gpointer _tmp47_;
				Tag* tag = NULL;
				DataObject* _tmp48_;
				Tag* _tmp49_;
				TagsSidebarEntry* entry = NULL;
				GeeHashMap* _tmp50_;
				Tag* _tmp51_;
				gpointer _tmp52_;
				TagsSidebarEntry* _tmp53_;
				gboolean is_removed = FALSE;
				GeeHashMap* _tmp54_;
				Tag* _tmp55_;
				TagsSidebarEntry* _tmp56_;
				_tmp45_ = _object_it;
				if (!gee_iterator_next (_tmp45_)) {
					break;
				}
				_tmp46_ = _object_it;
				_tmp47_ = gee_iterator_get (_tmp46_);
				object = (DataObject*) _tmp47_;
				_tmp48_ = object;
				_tmp49_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, TYPE_TAG, Tag));
				tag = _tmp49_;
				_tmp50_ = self->priv->entry_map;
				_tmp51_ = tag;
				_tmp52_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp50_, _tmp51_);
				entry = (TagsSidebarEntry*) _tmp52_;
				_tmp53_ = entry;
				_vala_assert (_tmp53_ != NULL, "entry != null");
				_tmp54_ = self->priv->entry_map;
				_tmp55_ = tag;
				is_removed = gee_abstract_map_unset ((GeeAbstractMap*) _tmp54_, _tmp55_, NULL);
				_vala_assert (is_removed, "is_removed");
				_tmp56_ = entry;
				sidebar_branch_prune ((SidebarBranch*) self, (SidebarEntry*) _tmp56_);
				_g_object_unref0 (entry);
				_g_object_unref0 (tag);
				_g_object_unref0 (object);
			}
			_g_object_unref0 (_object_it);
		}
	}
	_g_object_unref0 (restore_point);
}

static void
tags_branch_on_tags_altered (TagsBranch* self,
                             GeeMap* altered)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (altered != NULL);
	{
		GeeIterator* _object_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = gee_map_get_keys (altered);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_object_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			DataObject* object = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			DataObject* _tmp8_;
			gpointer _tmp9_;
			Alteration* _tmp10_;
			gboolean _tmp11_;
			Tag* tag = NULL;
			DataObject* _tmp12_;
			Tag* _tmp13_;
			TagsSidebarEntry* entry = NULL;
			GeeHashMap* _tmp14_;
			Tag* _tmp15_;
			gpointer _tmp16_;
			TagsSidebarEntry* _tmp17_;
			TagsSidebarEntry* _tmp18_;
			Tag* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			TagsSidebarEntry* _tmp22_;
			Tag* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			TagsSidebarEntry* _tmp26_;
			_tmp5_ = _object_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _object_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			object = (DataObject*) _tmp7_;
			_tmp8_ = object;
			_tmp9_ = gee_map_get (altered, _tmp8_);
			_tmp10_ = (Alteration*) _tmp9_;
			_tmp11_ = !alteration_has_detail (_tmp10_, "metadata", "name");
			_alteration_unref0 (_tmp10_);
			if (_tmp11_) {
				_g_object_unref0 (object);
				continue;
			}
			_tmp12_ = object;
			_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_TAG, Tag));
			tag = _tmp13_;
			_tmp14_ = self->priv->entry_map;
			_tmp15_ = tag;
			_tmp16_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp14_, _tmp15_);
			entry = (TagsSidebarEntry*) _tmp16_;
			_tmp17_ = entry;
			_vala_assert (_tmp17_ != NULL, "entry != null");
			_tmp18_ = entry;
			_tmp19_ = tag;
			_tmp20_ = tag_get_user_visible_name (_tmp19_);
			_tmp21_ = _tmp20_;
			g_signal_emit_by_name ((SidebarRenameableEntry*) _tmp18_, "sidebar-name-changed", _tmp21_);
			_g_free0 (_tmp21_);
			_tmp22_ = entry;
			_tmp23_ = tag;
			_tmp24_ = tag_get_user_visible_name (_tmp23_);
			_tmp25_ = _tmp24_;
			g_signal_emit_by_name ((SidebarEntry*) _tmp22_, "sidebar-tooltip-changed", _tmp25_);
			_g_free0 (_tmp25_);
			_tmp26_ = entry;
			sidebar_branch_reorder ((SidebarBranch*) self, (SidebarEntry*) _tmp26_);
			_g_object_unref0 (entry);
			_g_object_unref0 (tag);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
}

static void
tags_branch_class_init (TagsBranchClass * klass,
                        gpointer klass_data)
{
	tags_branch_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TagsBranch_private_offset);
	G_OBJECT_CLASS (klass)->finalize = tags_branch_finalize;
}

static void
tags_branch_instance_init (TagsBranch * self,
                           gpointer klass)
{
	GeeHashMap* _tmp0_;
	self->priv = tags_branch_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (TYPE_TAG, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TAGS_TYPE_SIDEBAR_ENTRY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->entry_map = _tmp0_;
}

static void
tags_branch_finalize (GObject * obj)
{
	TagsBranch * self;
	TagSourceCollection* _tmp0_;
	guint _tmp1_;
	TagSourceCollection* _tmp2_;
	guint _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TAGS_TYPE_BRANCH, TagsBranch);
	_tmp0_ = tag_global;
	g_signal_parse_name ("contents-altered", TYPE_DATA_COLLECTION, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((DataCollection*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _tags_branch_on_tags_added_removed_data_collection_contents_altered, self);
	_tmp2_ = tag_global;
	g_signal_parse_name ("items-altered", TYPE_DATA_COLLECTION, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((DataCollection*) _tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _tags_branch_on_tags_altered_data_collection_items_altered, self);
	_g_object_unref0 (self->priv->entry_map);
	G_OBJECT_CLASS (tags_branch_parent_class)->finalize (obj);
}

static GType
tags_branch_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TagsBranchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tags_branch_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TagsBranch), 0, (GInstanceInitFunc) tags_branch_instance_init, NULL };
	GType tags_branch_type_id;
	tags_branch_type_id = g_type_register_static (SIDEBAR_TYPE_BRANCH, "TagsBranch", &g_define_type_info, 0);
	TagsBranch_private_offset = g_type_add_instance_private (tags_branch_type_id, sizeof (TagsBranchPrivate));
	return tags_branch_type_id;
}

GType
tags_branch_get_type (void)
{
	static volatile gsize tags_branch_type_id__once = 0;
	if (g_once_init_enter (&tags_branch_type_id__once)) {
		GType tags_branch_type_id;
		tags_branch_type_id = tags_branch_get_type_once ();
		g_once_init_leave (&tags_branch_type_id__once, tags_branch_type_id);
	}
	return tags_branch_type_id__once;
}

static inline gpointer
tags_grouping_get_instance_private (TagsGrouping* self)
{
	return G_STRUCT_MEMBER_P (self, TagsGrouping_private_offset);
}

TagsGrouping*
tags_grouping_construct (GType object_type)
{
	TagsGrouping * self = NULL;
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	_tmp0_ = (GThemedIcon*) g_themed_icon_new (RESOURCES_ICON_TAGS);
	_tmp1_ = _tmp0_;
	self = (TagsGrouping*) sidebar_grouping_construct (object_type, _ ("Tags"), (GIcon*) _tmp1_, NULL);
	_g_object_unref0 (_tmp1_);
	return self;
}

TagsGrouping*
tags_grouping_new (void)
{
	return tags_grouping_construct (TAGS_TYPE_GROUPING);
}

static gboolean
tags_grouping_real_internal_drop_received (SidebarInternalDropTargetEntry* base,
                                           GeeList* media)
{
	TagsGrouping * self;
	gboolean result;
	self = (TagsGrouping*) base;
	g_return_val_if_fail (media != NULL, FALSE);
	result = TRUE;
	return result;
}

static gboolean
tags_grouping_real_internal_drop_received_arbitrary (SidebarInternalDropTargetEntry* base,
                                                     GtkSelectionData* data)
{
	TagsGrouping * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	self = (TagsGrouping*) base;
	g_return_val_if_fail (data != NULL, FALSE);
	_tmp0_ = gdk_atom_name (gtk_selection_data_get_data_type (data));
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strcmp0 (_tmp1_, LIBRARY_WINDOW_TAG_PATH_MIME_TYPE) == 0;
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		gchar* old_tag_path = NULL;
		guint8* _tmp3_;
		gchar* _tmp4_;
		TagSourceCollection* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		GeeList* _tmp8_;
		GeeList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gboolean _tmp12_;
		CommandManager* _tmp13_;
		CommandManager* _tmp14_;
		const gchar* _tmp15_;
		Tag* _tmp16_;
		Tag* _tmp17_;
		ReparentTagCommand* _tmp18_;
		ReparentTagCommand* _tmp19_;
		_tmp3_ = gtk_selection_data_get_data (data);
		_tmp4_ = g_strdup ((const gchar*) _tmp3_);
		old_tag_path = _tmp4_;
		_tmp5_ = tag_global;
		_tmp6_ = old_tag_path;
		_vala_assert (tag_source_collection_exists (_tmp5_, _tmp6_, FALSE), "Tag.global.exists (old_tag_path)");
		_tmp7_ = old_tag_path;
		_tmp8_ = hierarchical_tag_utilities_enumerate_path_components (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = gee_collection_get_size ((GeeCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_ < 2;
		_g_object_unref0 (_tmp9_);
		if (_tmp12_) {
			result = TRUE;
			_g_free0 (old_tag_path);
			return result;
		}
		_tmp13_ = app_window_get_command_manager ();
		_tmp14_ = _tmp13_;
		_tmp15_ = old_tag_path;
		_tmp16_ = tag_for_path (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = reparent_tag_command_new (_tmp17_, "/");
		_tmp19_ = _tmp18_;
		command_manager_execute (_tmp14_, (Command*) _tmp19_);
		_g_object_unref0 (_tmp19_);
		_g_object_unref0 (_tmp17_);
		_command_manager_unref0 (_tmp14_);
		result = TRUE;
		_g_free0 (old_tag_path);
		return result;
	}
	result = FALSE;
	return result;
}

static void
tags_grouping_real_prepare_selection_data (SidebarInternalDragSourceEntry* base,
                                           GtkSelectionData* data)
{
	TagsGrouping * self;
	self = (TagsGrouping*) base;
	g_return_if_fail (data != NULL);
}

static void
___lambda102_ (TagsGrouping* self)
{
}

static void
____lambda102__gtk_menu_item_activate (GtkMenuItem* _sender,
                                       gpointer self)
{
	___lambda102_ ((TagsGrouping*) self);
}

static GtkMenu*
tags_grouping_real_get_sidebar_context_menu (SidebarContextable* base,
                                             GdkEventButton* event)
{
	TagsGrouping * self;
	GtkMenu* _tmp0_;
	GtkMenu* _tmp7_;
	GtkMenu* _tmp8_;
	GtkMenu* result;
	self = (TagsGrouping*) base;
	_tmp0_ = self->priv->context_menu;
	if (_tmp0_ == NULL) {
		GtkMenu* _tmp1_;
		GtkMenuItem* new_tag_menu_item = NULL;
		GtkMenuItem* _tmp2_;
		GtkMenuItem* _tmp3_;
		GtkMenu* _tmp4_;
		GtkMenuItem* _tmp5_;
		GtkMenu* _tmp6_;
		_tmp1_ = (GtkMenu*) gtk_menu_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->context_menu);
		self->priv->context_menu = _tmp1_;
		_tmp2_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (RESOURCES_NEW_CHILD_TAG_SIDEBAR_MENU);
		g_object_ref_sink (_tmp2_);
		new_tag_menu_item = _tmp2_;
		_tmp3_ = new_tag_menu_item;
		g_signal_connect_object (_tmp3_, "activate", (GCallback) ____lambda102__gtk_menu_item_activate, self, 0);
		_tmp4_ = self->priv->context_menu;
		_tmp5_ = new_tag_menu_item;
		gtk_container_add ((GtkContainer*) _tmp4_, (GtkWidget*) _tmp5_);
		_tmp6_ = self->priv->context_menu;
		gtk_widget_show_all ((GtkWidget*) _tmp6_);
		_g_object_unref0 (new_tag_menu_item);
	}
	_tmp7_ = self->priv->context_menu;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	result = _tmp8_;
	return result;
}

static void
tags_grouping_on_new_tag (TagsGrouping* self)
{
	NewRootTagCommand* creation_command = NULL;
	NewRootTagCommand* _tmp0_;
	CommandManager* _tmp1_;
	CommandManager* _tmp2_;
	LibraryWindow* _tmp3_;
	LibraryWindow* _tmp4_;
	Tag* _tmp5_;
	Tag* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = new_root_tag_command_new ();
	creation_command = _tmp0_;
	_tmp1_ = app_window_get_command_manager ();
	_tmp2_ = _tmp1_;
	command_manager_execute (_tmp2_, (Command*) creation_command);
	_command_manager_unref0 (_tmp2_);
	_tmp3_ = library_window_get_app ();
	_tmp4_ = _tmp3_;
	_tmp5_ = new_root_tag_command_get_created_tag (creation_command);
	_tmp6_ = _tmp5_;
	library_window_rename_tag_in_sidebar (_tmp4_, _tmp6_);
	_g_object_unref0 (_tmp6_);
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (creation_command);
}

static void
tags_grouping_class_init (TagsGroupingClass * klass,
                          gpointer klass_data)
{
	tags_grouping_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TagsGrouping_private_offset);
	G_OBJECT_CLASS (klass)->finalize = tags_grouping_finalize;
}

static void
tags_grouping_sidebar_internal_drop_target_entry_interface_init (SidebarInternalDropTargetEntryIface * iface,
                                                                 gpointer iface_data)
{
	tags_grouping_sidebar_internal_drop_target_entry_parent_iface = g_type_interface_peek_parent (iface);
	iface->internal_drop_received = (gboolean (*) (SidebarInternalDropTargetEntry*, GeeList*)) tags_grouping_real_internal_drop_received;
	iface->internal_drop_received_arbitrary = (gboolean (*) (SidebarInternalDropTargetEntry*, GtkSelectionData*)) tags_grouping_real_internal_drop_received_arbitrary;
}

static void
tags_grouping_sidebar_internal_drag_source_entry_interface_init (SidebarInternalDragSourceEntryIface * iface,
                                                                 gpointer iface_data)
{
	tags_grouping_sidebar_internal_drag_source_entry_parent_iface = g_type_interface_peek_parent (iface);
	iface->prepare_selection_data = (void (*) (SidebarInternalDragSourceEntry*, GtkSelectionData*)) tags_grouping_real_prepare_selection_data;
}

static void
tags_grouping_sidebar_contextable_interface_init (SidebarContextableIface * iface,
                                                  gpointer iface_data)
{
	tags_grouping_sidebar_contextable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_sidebar_context_menu = (GtkMenu* (*) (SidebarContextable*, GdkEventButton*)) tags_grouping_real_get_sidebar_context_menu;
}

static void
tags_grouping_instance_init (TagsGrouping * self,
                             gpointer klass)
{
	self->priv = tags_grouping_get_instance_private (self);
	self->priv->context_menu = NULL;
}

static void
tags_grouping_finalize (GObject * obj)
{
	TagsGrouping * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TAGS_TYPE_GROUPING, TagsGrouping);
	_g_object_unref0 (self->priv->context_menu);
	G_OBJECT_CLASS (tags_grouping_parent_class)->finalize (obj);
}

static GType
tags_grouping_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TagsGroupingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tags_grouping_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TagsGrouping), 0, (GInstanceInitFunc) tags_grouping_instance_init, NULL };
	static const GInterfaceInfo sidebar_internal_drop_target_entry_info = { (GInterfaceInitFunc) tags_grouping_sidebar_internal_drop_target_entry_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo sidebar_internal_drag_source_entry_info = { (GInterfaceInitFunc) tags_grouping_sidebar_internal_drag_source_entry_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo sidebar_contextable_info = { (GInterfaceInitFunc) tags_grouping_sidebar_contextable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType tags_grouping_type_id;
	tags_grouping_type_id = g_type_register_static (SIDEBAR_TYPE_GROUPING, "TagsGrouping", &g_define_type_info, 0);
	g_type_add_interface_static (tags_grouping_type_id, SIDEBAR_TYPE_INTERNAL_DROP_TARGET_ENTRY, &sidebar_internal_drop_target_entry_info);
	g_type_add_interface_static (tags_grouping_type_id, SIDEBAR_TYPE_INTERNAL_DRAG_SOURCE_ENTRY, &sidebar_internal_drag_source_entry_info);
	g_type_add_interface_static (tags_grouping_type_id, SIDEBAR_TYPE_CONTEXTABLE, &sidebar_contextable_info);
	TagsGrouping_private_offset = g_type_add_instance_private (tags_grouping_type_id, sizeof (TagsGroupingPrivate));
	return tags_grouping_type_id;
}

GType
tags_grouping_get_type (void)
{
	static volatile gsize tags_grouping_type_id__once = 0;
	if (g_once_init_enter (&tags_grouping_type_id__once)) {
		GType tags_grouping_type_id;
		tags_grouping_type_id = tags_grouping_get_type_once ();
		g_once_init_leave (&tags_grouping_type_id__once, tags_grouping_type_id);
	}
	return tags_grouping_type_id__once;
}

static inline gpointer
tags_sidebar_entry_get_instance_private (TagsSidebarEntry* self)
{
	return G_STRUCT_MEMBER_P (self, TagsSidebarEntry_private_offset);
}

TagsSidebarEntry*
tags_sidebar_entry_construct (GType object_type,
                              Tag* tag)
{
	TagsSidebarEntry * self = NULL;
	Tag* _tmp0_;
	g_return_val_if_fail (tag != NULL, NULL);
	self = (TagsSidebarEntry*) sidebar_simple_page_entry_construct (object_type);
	_tmp0_ = _g_object_ref0 (tag);
	_g_object_unref0 (self->priv->tag);
	self->priv->tag = _tmp0_;
	return self;
}

TagsSidebarEntry*
tags_sidebar_entry_new (Tag* tag)
{
	return tags_sidebar_entry_construct (TAGS_TYPE_SIDEBAR_ENTRY, tag);
}

Tag*
tags_sidebar_entry_for_tag (TagsSidebarEntry* self)
{
	Tag* _tmp0_;
	Tag* _tmp1_;
	Tag* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->tag;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
tags_sidebar_entry_real_get_sidebar_name (SidebarSimplePageEntry* base)
{
	TagsSidebarEntry * self;
	Tag* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (TagsSidebarEntry*) base;
	_tmp0_ = self->priv->tag;
	_tmp1_ = tag_get_user_visible_name (_tmp0_);
	result = _tmp1_;
	return result;
}

static GIcon*
tags_sidebar_entry_real_get_sidebar_icon (SidebarSimplePageEntry* base)
{
	TagsSidebarEntry * self;
	GIcon* _tmp0_;
	GIcon* _tmp1_;
	GIcon* result;
	self = (TagsSidebarEntry*) base;
	_tmp0_ = tags_sidebar_entry_single_tag_icon;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static Page*
tags_sidebar_entry_real_create_page (SidebarSimplePageEntry* base)
{
	TagsSidebarEntry * self;
	Tag* _tmp0_;
	TagPage* _tmp1_;
	Page* result;
	self = (TagsSidebarEntry*) base;
	_tmp0_ = self->priv->tag;
	_tmp1_ = tag_page_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	result = (Page*) _tmp1_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
tags_sidebar_entry_real_rename (SidebarRenameableEntry* base,
                                const gchar* new_name)
{
	TagsSidebarEntry * self;
	gchar* prepped = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	Tag* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_;
	const gchar* _tmp9_;
	CommandManager* _tmp10_;
	CommandManager* _tmp11_;
	Tag* _tmp12_;
	const gchar* _tmp13_;
	RenameTagCommand* _tmp14_;
	RenameTagCommand* _tmp15_;
	self = (TagsSidebarEntry*) base;
	g_return_if_fail (new_name != NULL);
	_tmp0_ = tag_prep_tag_name (new_name);
	prepped = _tmp0_;
	_tmp1_ = prepped;
	if (_tmp1_ == NULL) {
		_g_free0 (prepped);
		return;
	}
	_tmp2_ = prepped;
	_tmp3_ = string_replace (_tmp2_, "/", "");
	_g_free0 (prepped);
	prepped = _tmp3_;
	_tmp4_ = prepped;
	_tmp5_ = self->priv->tag;
	_tmp6_ = tag_get_user_visible_name (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strcmp0 (_tmp4_, _tmp7_) == 0;
	_g_free0 (_tmp7_);
	if (_tmp8_) {
		_g_free0 (prepped);
		return;
	}
	_tmp9_ = prepped;
	if (g_strcmp0 (_tmp9_, "") == 0) {
		_g_free0 (prepped);
		return;
	}
	_tmp10_ = app_window_get_command_manager ();
	_tmp11_ = _tmp10_;
	_tmp12_ = self->priv->tag;
	_tmp13_ = prepped;
	_tmp14_ = rename_tag_command_new (_tmp12_, _tmp13_);
	_tmp15_ = _tmp14_;
	command_manager_execute (_tmp11_, (Command*) _tmp15_);
	_g_object_unref0 (_tmp15_);
	_command_manager_unref0 (_tmp11_);
	_g_free0 (prepped);
}

static void
tags_sidebar_entry_real_destroy_source (SidebarDestroyableEntry* base)
{
	TagsSidebarEntry * self;
	Tag* _tmp0_;
	self = (TagsSidebarEntry*) base;
	_tmp0_ = self->priv->tag;
	if (dialogs_confirm_delete_tag (_tmp0_)) {
		CommandManager* _tmp1_;
		CommandManager* _tmp2_;
		Tag* _tmp3_;
		DeleteTagCommand* _tmp4_;
		DeleteTagCommand* _tmp5_;
		_tmp1_ = app_window_get_command_manager ();
		_tmp2_ = _tmp1_;
		_tmp3_ = self->priv->tag;
		_tmp4_ = delete_tag_command_new (_tmp3_);
		_tmp5_ = _tmp4_;
		command_manager_execute (_tmp2_, (Command*) _tmp5_);
		_g_object_unref0 (_tmp5_);
		_command_manager_unref0 (_tmp2_);
	}
}

static gboolean
tags_sidebar_entry_real_internal_drop_received (SidebarInternalDropTargetEntry* base,
                                                GeeList* media)
{
	TagsSidebarEntry * self;
	CommandManager* _tmp0_;
	CommandManager* _tmp1_;
	Tag* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	TagUntagPhotosCommand* _tmp5_;
	TagUntagPhotosCommand* _tmp6_;
	gboolean result;
	self = (TagsSidebarEntry*) base;
	g_return_val_if_fail (media != NULL, FALSE);
	_tmp0_ = app_window_get_command_manager ();
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->tag;
	_tmp3_ = gee_collection_get_size ((GeeCollection*) media);
	_tmp4_ = _tmp3_;
	_tmp5_ = tag_untag_photos_command_new (_tmp2_, (GeeCollection*) media, _tmp4_, TRUE);
	_tmp6_ = _tmp5_;
	command_manager_execute (_tmp1_, (Command*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	_command_manager_unref0 (_tmp1_);
	result = TRUE;
	return result;
}

static gboolean
tags_sidebar_entry_real_internal_drop_received_arbitrary (SidebarInternalDropTargetEntry* base,
                                                          GtkSelectionData* data)
{
	TagsSidebarEntry * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	self = (TagsSidebarEntry*) base;
	g_return_val_if_fail (data != NULL, FALSE);
	_tmp0_ = gdk_atom_name (gtk_selection_data_get_data_type (data));
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strcmp0 (_tmp1_, LIBRARY_WINDOW_TAG_PATH_MIME_TYPE) == 0;
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		gchar* old_tag_path = NULL;
		guint8* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		Tag* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gboolean _tmp9_;
		TagSourceCollection* _tmp24_;
		const gchar* _tmp25_;
		Tag* old_tag = NULL;
		const gchar* _tmp26_;
		Tag* _tmp27_;
		Tag* old_tag_parent = NULL;
		Tag* _tmp28_;
		Tag* _tmp29_;
		gboolean _tmp30_ = FALSE;
		Tag* _tmp31_;
		CommandManager* _tmp38_;
		CommandManager* _tmp39_;
		Tag* _tmp40_;
		Tag* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		ReparentTagCommand* _tmp44_;
		ReparentTagCommand* _tmp45_;
		_tmp3_ = gtk_selection_data_get_data (data);
		_tmp4_ = g_strdup ((const gchar*) _tmp3_);
		old_tag_path = _tmp4_;
		_tmp5_ = old_tag_path;
		_tmp6_ = self->priv->tag;
		_tmp7_ = tag_get_path (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strcmp0 (_tmp5_, _tmp8_) == 0;
		_g_free0 (_tmp8_);
		if (_tmp9_) {
			result = TRUE;
			_g_free0 (old_tag_path);
			return result;
		}
		{
			GeeList* _parent_path_list = NULL;
			Tag* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			GeeList* _tmp13_;
			GeeList* _tmp14_;
			gint _parent_path_size = 0;
			GeeList* _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			gint _parent_path_index = 0;
			_tmp10_ = self->priv->tag;
			_tmp11_ = tag_get_path (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = hierarchical_tag_utilities_enumerate_parent_paths (_tmp12_);
			_tmp14_ = _tmp13_;
			_g_free0 (_tmp12_);
			_parent_path_list = _tmp14_;
			_tmp15_ = _parent_path_list;
			_tmp16_ = gee_collection_get_size ((GeeCollection*) _tmp15_);
			_tmp17_ = _tmp16_;
			_parent_path_size = _tmp17_;
			_parent_path_index = -1;
			while (TRUE) {
				gint _tmp18_;
				gint _tmp19_;
				gchar* parent_path = NULL;
				GeeList* _tmp20_;
				gpointer _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				_parent_path_index = _parent_path_index + 1;
				_tmp18_ = _parent_path_index;
				_tmp19_ = _parent_path_size;
				if (!(_tmp18_ < _tmp19_)) {
					break;
				}
				_tmp20_ = _parent_path_list;
				_tmp21_ = gee_list_get (_tmp20_, _parent_path_index);
				parent_path = (gchar*) _tmp21_;
				_tmp22_ = parent_path;
				_tmp23_ = old_tag_path;
				if (g_strcmp0 (_tmp22_, _tmp23_) == 0) {
					result = TRUE;
					_g_free0 (parent_path);
					_g_object_unref0 (_parent_path_list);
					_g_free0 (old_tag_path);
					return result;
				}
				_g_free0 (parent_path);
			}
			_g_object_unref0 (_parent_path_list);
		}
		_tmp24_ = tag_global;
		_tmp25_ = old_tag_path;
		_vala_assert (tag_source_collection_exists (_tmp24_, _tmp25_, FALSE), "Tag.global.exists (old_tag_path)");
		_tmp26_ = old_tag_path;
		_tmp27_ = tag_for_path (_tmp26_);
		old_tag = _tmp27_;
		_tmp28_ = old_tag;
		_tmp29_ = tag_get_hierarchical_parent (_tmp28_);
		old_tag_parent = _tmp29_;
		_tmp31_ = old_tag_parent;
		if (_tmp31_ != NULL) {
			Tag* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			Tag* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			_tmp32_ = old_tag_parent;
			_tmp33_ = tag_get_path (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = self->priv->tag;
			_tmp36_ = tag_get_path (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp30_ = g_strcmp0 (_tmp34_, _tmp37_) == 0;
			_g_free0 (_tmp37_);
			_g_free0 (_tmp34_);
		} else {
			_tmp30_ = FALSE;
		}
		if (_tmp30_) {
			result = TRUE;
			_g_object_unref0 (old_tag_parent);
			_g_object_unref0 (old_tag);
			_g_free0 (old_tag_path);
			return result;
		}
		_tmp38_ = app_window_get_command_manager ();
		_tmp39_ = _tmp38_;
		_tmp40_ = old_tag;
		_tmp41_ = self->priv->tag;
		_tmp42_ = tag_get_path (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = reparent_tag_command_new (_tmp40_, _tmp43_);
		_tmp45_ = _tmp44_;
		command_manager_execute (_tmp39_, (Command*) _tmp45_);
		_g_object_unref0 (_tmp45_);
		_g_free0 (_tmp43_);
		_command_manager_unref0 (_tmp39_);
		result = TRUE;
		_g_object_unref0 (old_tag_parent);
		_g_object_unref0 (old_tag);
		_g_free0 (old_tag_path);
		return result;
	}
	result = FALSE;
	return result;
}

static GIcon*
tags_sidebar_entry_real_get_sidebar_open_icon (SidebarExpandableEntry* base)
{
	TagsSidebarEntry * self;
	GIcon* _tmp0_;
	GIcon* _tmp1_;
	GIcon* result;
	self = (TagsSidebarEntry*) base;
	_tmp0_ = tags_sidebar_entry_single_tag_icon;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static GIcon*
tags_sidebar_entry_real_get_sidebar_closed_icon (SidebarExpandableEntry* base)
{
	TagsSidebarEntry * self;
	GIcon* _tmp0_;
	GIcon* _tmp1_;
	GIcon* result;
	self = (TagsSidebarEntry*) base;
	_tmp0_ = tags_sidebar_entry_single_tag_icon;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static gboolean
tags_sidebar_entry_real_expand_on_select (SidebarExpandableEntry* base)
{
	TagsSidebarEntry * self;
	gboolean result;
	self = (TagsSidebarEntry*) base;
	result = FALSE;
	return result;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static void
tags_sidebar_entry_real_prepare_selection_data (SidebarInternalDragSourceEntry* base,
                                                GtkSelectionData* data)
{
	TagsSidebarEntry * self;
	Tag* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	gint _tmp4_ = 0;
	guint8* _tmp5_;
	gint _tmp5__length1;
	self = (TagsSidebarEntry*) base;
	g_return_if_fail (data != NULL);
	_tmp0_ = self->priv->tag;
	_tmp1_ = tag_get_path (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = string_get_data (_tmp2_, &_tmp4_);
	_tmp3__length1 = _tmp4_;
	_tmp5_ = _tmp3_;
	_tmp5__length1 = _tmp3__length1;
	gtk_selection_data_set (data, gdk_atom_intern_static_string (LIBRARY_WINDOW_TAG_PATH_MIME_TYPE), 0, _tmp5_, (gint) _tmp5__length1);
	_g_free0 (_tmp2_);
}

static void
tags_sidebar_entry_base_init (TagsSidebarEntryClass * klass)
{
	GThemedIcon* _tmp0_;
	_tmp0_ = (GThemedIcon*) g_themed_icon_new (RESOURCES_ICON_ONE_TAG);
	_g_object_unref0 (tags_sidebar_entry_single_tag_icon);
	tags_sidebar_entry_single_tag_icon = (GIcon*) _tmp0_;
}

static void
tags_sidebar_entry_class_init (TagsSidebarEntryClass * klass,
                               gpointer klass_data)
{
	tags_sidebar_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TagsSidebarEntry_private_offset);
	((SidebarSimplePageEntryClass *) klass)->get_sidebar_name = (gchar* (*) (SidebarSimplePageEntry*)) tags_sidebar_entry_real_get_sidebar_name;
	((SidebarSimplePageEntryClass *) klass)->get_sidebar_icon = (GIcon* (*) (SidebarSimplePageEntry*)) tags_sidebar_entry_real_get_sidebar_icon;
	((SidebarSimplePageEntryClass *) klass)->create_page = (Page* (*) (SidebarSimplePageEntry*)) tags_sidebar_entry_real_create_page;
	G_OBJECT_CLASS (klass)->finalize = tags_sidebar_entry_finalize;
}

static void
tags_sidebar_entry_sidebar_renameable_entry_interface_init (SidebarRenameableEntryIface * iface,
                                                            gpointer iface_data)
{
	tags_sidebar_entry_sidebar_renameable_entry_parent_iface = g_type_interface_peek_parent (iface);
	iface->rename = (void (*) (SidebarRenameableEntry*, const gchar*)) tags_sidebar_entry_real_rename;
}

static void
tags_sidebar_entry_sidebar_destroyable_entry_interface_init (SidebarDestroyableEntryIface * iface,
                                                             gpointer iface_data)
{
	tags_sidebar_entry_sidebar_destroyable_entry_parent_iface = g_type_interface_peek_parent (iface);
	iface->destroy_source = (void (*) (SidebarDestroyableEntry*)) tags_sidebar_entry_real_destroy_source;
}

static void
tags_sidebar_entry_sidebar_internal_drop_target_entry_interface_init (SidebarInternalDropTargetEntryIface * iface,
                                                                      gpointer iface_data)
{
	tags_sidebar_entry_sidebar_internal_drop_target_entry_parent_iface = g_type_interface_peek_parent (iface);
	iface->internal_drop_received = (gboolean (*) (SidebarInternalDropTargetEntry*, GeeList*)) tags_sidebar_entry_real_internal_drop_received;
	iface->internal_drop_received_arbitrary = (gboolean (*) (SidebarInternalDropTargetEntry*, GtkSelectionData*)) tags_sidebar_entry_real_internal_drop_received_arbitrary;
}

static void
tags_sidebar_entry_sidebar_expandable_entry_interface_init (SidebarExpandableEntryIface * iface,
                                                            gpointer iface_data)
{
	tags_sidebar_entry_sidebar_expandable_entry_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_sidebar_open_icon = (GIcon* (*) (SidebarExpandableEntry*)) tags_sidebar_entry_real_get_sidebar_open_icon;
	iface->get_sidebar_closed_icon = (GIcon* (*) (SidebarExpandableEntry*)) tags_sidebar_entry_real_get_sidebar_closed_icon;
	iface->expand_on_select = (gboolean (*) (SidebarExpandableEntry*)) tags_sidebar_entry_real_expand_on_select;
}

static void
tags_sidebar_entry_sidebar_internal_drag_source_entry_interface_init (SidebarInternalDragSourceEntryIface * iface,
                                                                      gpointer iface_data)
{
	tags_sidebar_entry_sidebar_internal_drag_source_entry_parent_iface = g_type_interface_peek_parent (iface);
	iface->prepare_selection_data = (void (*) (SidebarInternalDragSourceEntry*, GtkSelectionData*)) tags_sidebar_entry_real_prepare_selection_data;
}

static void
tags_sidebar_entry_instance_init (TagsSidebarEntry * self,
                                  gpointer klass)
{
	self->priv = tags_sidebar_entry_get_instance_private (self);
}

static void
tags_sidebar_entry_finalize (GObject * obj)
{
	TagsSidebarEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TAGS_TYPE_SIDEBAR_ENTRY, TagsSidebarEntry);
	_g_object_unref0 (self->priv->tag);
	G_OBJECT_CLASS (tags_sidebar_entry_parent_class)->finalize (obj);
}

static GType
tags_sidebar_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TagsSidebarEntryClass), (GBaseInitFunc) tags_sidebar_entry_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tags_sidebar_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TagsSidebarEntry), 0, (GInstanceInitFunc) tags_sidebar_entry_instance_init, NULL };
	static const GInterfaceInfo sidebar_renameable_entry_info = { (GInterfaceInitFunc) tags_sidebar_entry_sidebar_renameable_entry_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo sidebar_destroyable_entry_info = { (GInterfaceInitFunc) tags_sidebar_entry_sidebar_destroyable_entry_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo sidebar_internal_drop_target_entry_info = { (GInterfaceInitFunc) tags_sidebar_entry_sidebar_internal_drop_target_entry_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo sidebar_expandable_entry_info = { (GInterfaceInitFunc) tags_sidebar_entry_sidebar_expandable_entry_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo sidebar_internal_drag_source_entry_info = { (GInterfaceInitFunc) tags_sidebar_entry_sidebar_internal_drag_source_entry_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType tags_sidebar_entry_type_id;
	tags_sidebar_entry_type_id = g_type_register_static (SIDEBAR_TYPE_SIMPLE_PAGE_ENTRY, "TagsSidebarEntry", &g_define_type_info, 0);
	g_type_add_interface_static (tags_sidebar_entry_type_id, SIDEBAR_TYPE_RENAMEABLE_ENTRY, &sidebar_renameable_entry_info);
	g_type_add_interface_static (tags_sidebar_entry_type_id, SIDEBAR_TYPE_DESTROYABLE_ENTRY, &sidebar_destroyable_entry_info);
	g_type_add_interface_static (tags_sidebar_entry_type_id, SIDEBAR_TYPE_INTERNAL_DROP_TARGET_ENTRY, &sidebar_internal_drop_target_entry_info);
	g_type_add_interface_static (tags_sidebar_entry_type_id, SIDEBAR_TYPE_EXPANDABLE_ENTRY, &sidebar_expandable_entry_info);
	g_type_add_interface_static (tags_sidebar_entry_type_id, SIDEBAR_TYPE_INTERNAL_DRAG_SOURCE_ENTRY, &sidebar_internal_drag_source_entry_info);
	TagsSidebarEntry_private_offset = g_type_add_instance_private (tags_sidebar_entry_type_id, sizeof (TagsSidebarEntryPrivate));
	return tags_sidebar_entry_type_id;
}

GType
tags_sidebar_entry_get_type (void)
{
	static volatile gsize tags_sidebar_entry_type_id__once = 0;
	if (g_once_init_enter (&tags_sidebar_entry_type_id__once)) {
		GType tags_sidebar_entry_type_id;
		tags_sidebar_entry_type_id = tags_sidebar_entry_get_type_once ();
		g_once_init_leave (&tags_sidebar_entry_type_id__once, tags_sidebar_entry_type_id);
	}
	return tags_sidebar_entry_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

