/* misc.c generated by valac 0.56.18, the Vala compiler
 * generated from misc.vala, do not modify */

/*
* Copyright (c) 2009-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#define _XOPEN_SOURCE

#include "io.elementary.photos.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <gdk/gdk.h>
#include <gobject/gvaluecollector.h>
#include <float.h>
#include <math.h>
#include <time.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_checksum_free0(var) ((var == NULL) ? NULL : (var = (g_checksum_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _media_collection_registry_unref0(var) ((var == NULL) ? NULL : (var = (media_collection_registry_unref (var), NULL)))
typedef struct _ParamSpecOneShotScheduler ParamSpecOneShotScheduler;
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
typedef struct _ParamSpecOpTimer ParamSpecOpTimer;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _OneShotSchedulerPrivate {
	gchar* name;
	OneShotCallback callback;
	gpointer callback_target;
	guint scheduled;
};

struct _ParamSpecOneShotScheduler {
	GParamSpec parent_instance;
};

struct _OpTimerPrivate {
	gchar* name;
	GTimer* timer;
	glong count;
	gdouble elapsed;
	gdouble shortest;
	gdouble longest;
};

struct _ParamSpecOpTimer {
	GParamSpec parent_instance;
};

static gint OneShotScheduler_private_offset;
static gpointer one_shot_scheduler_parent_class = NULL;
static gint OpTimer_private_offset;
static gpointer op_timer_parent_class = NULL;

static gboolean one_shot_scheduler_callback_wrapper (OneShotScheduler* self);
static gboolean _one_shot_scheduler_callback_wrapper_gsource_func (gpointer self);
static void one_shot_scheduler_finalize (OneShotScheduler * obj);
static GType one_shot_scheduler_get_type_once (void);
static void op_timer_finalize (OpTimer * obj);
static GType op_timer_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

guint
int64_hash (gint64* n)
{
	guint8* u8 = NULL;
	guint hash = 0U;
	guint result;
	u8 = (guint8*) n;
	hash = (guint) 0;
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				guint _tmp2_;
				guint _tmp3_;
				guint8* _tmp4_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = ctr;
					ctr = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(((gulong) ctr) < (sizeof (gint64) / sizeof (guint8)))) {
					break;
				}
				_tmp2_ = hash;
				_tmp3_ = hash;
				_tmp4_ = u8;
				u8 = _tmp4_ + 1;
				hash = ((_tmp2_ << 4) ^ (_tmp3_ >> 28)) ^ (*_tmp4_);
			}
		}
	}
	result = hash;
	return result;
}

gboolean
int64_equal (gint64* a,
             gint64* b)
{
	gint64* bia = NULL;
	gint64* bib = NULL;
	gboolean result;
	bia = (gint64*) a;
	bib = (gint64*) b;
	result = (*bia) == (*bib);
	return result;
}

gint
int64_compare (gint64* a,
               gint64* b)
{
	gint64 diff = 0LL;
	gint result;
	diff = (*((gint64*) a)) - (*((gint64*) b));
	if (diff < ((gint64) 0)) {
		result = -1;
		return result;
	} else {
		if (diff > ((gint64) 0)) {
			result = 1;
			return result;
		} else {
			result = 0;
			return result;
		}
	}
}

gint
uint64_compare (guint64* a,
                guint64* b)
{
	guint64 a64 = 0ULL;
	guint64 b64 = 0ULL;
	gint result;
	a64 = *((guint64*) a);
	b64 = *((guint64*) b);
	if (a64 < b64) {
		result = -1;
		return result;
	} else {
		if (a64 > b64) {
			result = 1;
			return result;
		} else {
			result = 0;
			return result;
		}
	}
}

gboolean
bool_value_equals (GValue* a,
                   GValue* b)
{
	GValue _tmp0_;
	GValue _tmp1_;
	gboolean result;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp0_ = *a;
	_tmp1_ = *b;
	result = g_value_get_boolean (&_tmp0_) == g_value_get_boolean (&_tmp1_);
	return result;
}

gboolean
int_value_equals (GValue* a,
                  GValue* b)
{
	GValue _tmp0_;
	GValue _tmp1_;
	gboolean result;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp0_ = *a;
	_tmp1_ = *b;
	result = g_value_get_int (&_tmp0_) == g_value_get_int (&_tmp1_);
	return result;
}

gint64
now_ms (void)
{
	GDateTime* date_time_now = NULL;
	GDateTime* _tmp0_;
	gint64 result;
	_tmp0_ = g_date_time_new_now_local ();
	date_time_now = _tmp0_;
	result = (g_date_time_to_unix (date_time_now) * 1000) + (g_date_time_get_microsecond (date_time_now) / 1000);
	_g_date_time_unref0 (date_time_now);
	return result;
}

gint64
now_sec (void)
{
	GDateTime* date_time_now = NULL;
	GDateTime* _tmp0_;
	gint64 result;
	_tmp0_ = g_date_time_new_now_local ();
	date_time_now = _tmp0_;
	result = g_date_time_to_unix (date_time_now);
	_g_date_time_unref0 (date_time_now);
	return result;
}

gchar*
md5_binary (guint8* buffer,
            gsize length)
{
	GChecksum* md5 = NULL;
	GChecksum* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	_vala_assert (length != ((gsize) 0), "length != 0");
	_tmp0_ = g_checksum_new (G_CHECKSUM_MD5);
	md5 = _tmp0_;
	g_checksum_update (md5, (guchar*) buffer, length);
	_tmp1_ = g_checksum_get_string (md5);
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	_g_checksum_free0 (md5);
	return result;
}

gchar*
md5_file (GFile* file,
          GError** error)
{
	GChecksum* md5 = NULL;
	GChecksum* _tmp0_;
	guint8* buffer = NULL;
	guint8* _tmp1_;
	gint buffer_length1;
	gint _buffer_size_;
	GFileInputStream* fins = NULL;
	GFileInputStream* _tmp2_;
	GChecksum* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = g_checksum_new (G_CHECKSUM_MD5);
	md5 = _tmp0_;
	_tmp1_ = g_new0 (guint8, 64 * 1024);
	buffer = _tmp1_;
	buffer_length1 = 64 * 1024;
	_buffer_size_ = buffer_length1;
	_tmp2_ = g_file_read (file, NULL, &_inner_error0_);
	fins = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		buffer = (g_free (buffer), NULL);
		_g_checksum_free0 (md5);
		return NULL;
	}
	{
		gboolean _tmp3_ = FALSE;
		_tmp3_ = TRUE;
		while (TRUE) {
			gsize bytes_read = 0UL;
			GFileInputStream* _tmp4_;
			guint8* _tmp5_;
			gint _tmp5__length1;
			GChecksum* _tmp6_;
			guint8* _tmp7_;
			gint _tmp7__length1;
			if (!_tmp3_) {
			}
			_tmp3_ = FALSE;
			_tmp4_ = fins;
			_tmp5_ = buffer;
			_tmp5__length1 = buffer_length1;
			bytes_read = (gsize) g_input_stream_read ((GInputStream*) _tmp4_, _tmp5_, (gsize) _tmp5__length1, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (fins);
				buffer = (g_free (buffer), NULL);
				_g_checksum_free0 (md5);
				return NULL;
			}
			if (bytes_read <= ((gsize) 0)) {
				break;
			}
			_tmp6_ = md5;
			_tmp7_ = buffer;
			_tmp7__length1 = buffer_length1;
			g_checksum_update (_tmp6_, (guchar*) _tmp7_, bytes_read);
		}
	}
	{
		GFileInputStream* _tmp8_;
		_tmp8_ = fins;
		g_input_stream_close ((GInputStream*) _tmp8_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		gchar* _tmp9_;
		gchar* _tmp10_;
		GError* _tmp11_;
		const gchar* _tmp12_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = g_file_get_path (file);
		_tmp10_ = _tmp9_;
		_tmp11_ = err;
		_tmp12_ = _tmp11_->message;
		g_warning ("misc.vala:107: Unable to close MD5 input stream for %s: %s", _tmp10_, _tmp12_);
		_g_free0 (_tmp10_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (fins);
		buffer = (g_free (buffer), NULL);
		_g_checksum_free0 (md5);
		return NULL;
	}
	_tmp13_ = md5;
	_tmp14_ = g_checksum_get_string (_tmp13_);
	_tmp15_ = g_strdup (_tmp14_);
	result = _tmp15_;
	_g_object_unref0 (fins);
	buffer = (g_free (buffer), NULL);
	_g_checksum_free0 (md5);
	return result;
}

gboolean
equal_sets (GeeSet* a,
            GeeSet* b)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gint _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gboolean result;
	if (a != NULL) {
		gint _tmp2_;
		gint _tmp3_;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) a);
		_tmp3_ = _tmp2_;
		_tmp1_ = _tmp3_ == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = b == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	if (a == NULL) {
		gboolean _tmp5_ = FALSE;
		if (b != NULL) {
			gint _tmp6_;
			gint _tmp7_;
			_tmp6_ = gee_collection_get_size ((GeeCollection*) b);
			_tmp7_ = _tmp6_;
			_tmp5_ = _tmp7_ == 0;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp4_ = _tmp5_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		result = TRUE;
		return result;
	}
	if (a == NULL) {
		_tmp9_ = b != NULL;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		_tmp8_ = TRUE;
	} else {
		gboolean _tmp10_ = FALSE;
		if (a != NULL) {
			_tmp10_ = b == NULL;
		} else {
			_tmp10_ = FALSE;
		}
		_tmp8_ = _tmp10_;
	}
	if (_tmp8_) {
		result = FALSE;
		return result;
	}
	if (a == NULL) {
		_tmp11_ = b == NULL;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		result = TRUE;
		return result;
	}
	_tmp12_ = gee_collection_get_size ((GeeCollection*) a);
	_tmp13_ = _tmp12_;
	_tmp14_ = gee_collection_get_size ((GeeCollection*) b);
	_tmp15_ = _tmp14_;
	if (_tmp13_ != _tmp15_) {
		result = FALSE;
		return result;
	}
	{
		GeeIterator* _element_it = NULL;
		GeeIterator* _tmp16_;
		_tmp16_ = gee_iterable_iterator ((GeeIterable*) a);
		_element_it = _tmp16_;
		while (TRUE) {
			GeeIterator* _tmp17_;
			gchar* element = NULL;
			GeeIterator* _tmp18_;
			gpointer _tmp19_;
			const gchar* _tmp20_;
			_tmp17_ = _element_it;
			if (!gee_iterator_next (_tmp17_)) {
				break;
			}
			_tmp18_ = _element_it;
			_tmp19_ = gee_iterator_get (_tmp18_);
			element = (gchar*) _tmp19_;
			_tmp20_ = element;
			if (!gee_collection_contains ((GeeCollection*) b, _tmp20_)) {
				result = FALSE;
				_g_free0 (element);
				_g_object_unref0 (_element_it);
				return result;
			}
			_g_free0 (element);
		}
		_g_object_unref0 (_element_it);
	}
	result = TRUE;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GeeSet*
intersection_of_sets (GeeSet* a,
                      GeeSet* b,
                      GeeSet* excluded)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GeeSet* intersection = NULL;
	GeeHashSet* _tmp2_;
	GeeSet* _tmp19_ = NULL;
	GeeSet* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	GeeSet* _tmp24_;
	GeeSet* result;
	if (a != NULL) {
		_tmp0_ = b == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		if (excluded != NULL) {
			gee_collection_add_all ((GeeCollection*) excluded, (GeeCollection*) a);
		}
		result = NULL;
		return result;
	}
	if (a == NULL) {
		_tmp1_ = b != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		if (excluded != NULL) {
			gee_collection_add_all ((GeeCollection*) excluded, (GeeCollection*) b);
		}
		result = NULL;
		return result;
	}
	_tmp2_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	intersection = (GeeSet*) _tmp2_;
	{
		GeeIterator* _element_it = NULL;
		GeeIterator* _tmp3_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) a);
		_element_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			gchar* element = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			const gchar* _tmp7_;
			_tmp4_ = _element_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _element_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			element = (gchar*) _tmp6_;
			_tmp7_ = element;
			if (gee_collection_contains ((GeeCollection*) b, _tmp7_)) {
				GeeSet* _tmp8_;
				const gchar* _tmp9_;
				_tmp8_ = intersection;
				_tmp9_ = element;
				gee_collection_add ((GeeCollection*) _tmp8_, _tmp9_);
			} else {
				if (excluded != NULL) {
					const gchar* _tmp10_;
					_tmp10_ = element;
					gee_collection_add ((GeeCollection*) excluded, _tmp10_);
				}
			}
			_g_free0 (element);
		}
		_g_object_unref0 (_element_it);
	}
	{
		GeeIterator* _element_it = NULL;
		GeeIterator* _tmp11_;
		_tmp11_ = gee_iterable_iterator ((GeeIterable*) b);
		_element_it = _tmp11_;
		while (TRUE) {
			GeeIterator* _tmp12_;
			gchar* element = NULL;
			GeeIterator* _tmp13_;
			gpointer _tmp14_;
			const gchar* _tmp15_;
			_tmp12_ = _element_it;
			if (!gee_iterator_next (_tmp12_)) {
				break;
			}
			_tmp13_ = _element_it;
			_tmp14_ = gee_iterator_get (_tmp13_);
			element = (gchar*) _tmp14_;
			_tmp15_ = element;
			if (gee_collection_contains ((GeeCollection*) a, _tmp15_)) {
				GeeSet* _tmp16_;
				const gchar* _tmp17_;
				_tmp16_ = intersection;
				_tmp17_ = element;
				gee_collection_add ((GeeCollection*) _tmp16_, _tmp17_);
			} else {
				if (excluded != NULL) {
					const gchar* _tmp18_;
					_tmp18_ = element;
					gee_collection_add ((GeeCollection*) excluded, _tmp18_);
				}
			}
			_g_free0 (element);
		}
		_g_object_unref0 (_element_it);
	}
	_tmp20_ = intersection;
	_tmp21_ = gee_collection_get_size ((GeeCollection*) _tmp20_);
	_tmp22_ = _tmp21_;
	if (_tmp22_ > 0) {
		GeeSet* _tmp23_;
		_tmp23_ = intersection;
		_tmp19_ = _tmp23_;
	} else {
		_tmp19_ = NULL;
	}
	_tmp24_ = _g_object_ref0 (_tmp19_);
	result = _tmp24_;
	_g_object_unref0 (intersection);
	return result;
}

guchar*
serialize_photo_ids (GeeCollection* photos,
                     gint* result_length1)
{
	gint64* ids = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint64* _tmp2_;
	gint ids_length1;
	gint _ids_size_;
	gint ctr = 0;
	gsize bytes = 0UL;
	gint _tmp12_;
	gint _tmp13_;
	guchar* serialized = NULL;
	guchar* _tmp14_;
	gint serialized_length1;
	gint _serialized_size_;
	gint64* _tmp15_;
	gint _tmp15__length1;
	guchar* _tmp16_;
	gint _tmp16__length1;
	guchar* result;
	g_return_val_if_fail (photos != NULL, NULL);
	_tmp0_ = gee_collection_get_size (photos);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (gint64, _tmp1_);
	ids = _tmp2_;
	ids_length1 = _tmp1_;
	_ids_size_ = ids_length1;
	ctr = 0;
	{
		GeeIterator* _photo_it = NULL;
		GeeIterator* _tmp3_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) photos);
		_photo_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			Photo* photo = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			gint64* _tmp7_;
			gint _tmp7__length1;
			gint _tmp8_;
			Photo* _tmp9_;
			PhotoID _tmp10_ = {0};
			gint64 _tmp11_;
			_tmp4_ = _photo_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _photo_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			photo = (Photo*) _tmp6_;
			_tmp7_ = ids;
			_tmp7__length1 = ids_length1;
			_tmp8_ = ctr;
			ctr = _tmp8_ + 1;
			_tmp9_ = photo;
			photo_get_photo_id (_tmp9_, &_tmp10_);
			_tmp11_ = _tmp10_.id;
			_tmp7_[_tmp8_] = _tmp11_;
			_g_object_unref0 (photo);
		}
		_g_object_unref0 (_photo_it);
	}
	_tmp12_ = gee_collection_get_size (photos);
	_tmp13_ = _tmp12_;
	bytes = (gsize) (_tmp13_ * sizeof (gint64));
	_tmp14_ = g_new0 (guchar, bytes);
	serialized = _tmp14_;
	serialized_length1 = bytes;
	_serialized_size_ = serialized_length1;
	_tmp15_ = ids;
	_tmp15__length1 = ids_length1;
	memcpy (serialized, _tmp15_, bytes);
	_tmp16_ = serialized;
	_tmp16__length1 = serialized_length1;
	if (result_length1) {
		*result_length1 = _tmp16__length1;
	}
	result = _tmp16_;
	ids = (g_free (ids), NULL);
	return result;
}

GeeList*
unserialize_photo_ids (guchar* serialized,
                       gint size)
{
	gsize count = 0UL;
	gboolean _tmp0_ = FALSE;
	gint64* ids = NULL;
	gint64* _tmp1_;
	gint ids_length1;
	gint _ids_size_;
	gint64* _tmp2_;
	gint _tmp2__length1;
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp3_;
	gint64* _tmp4_;
	gint _tmp4__length1;
	GeeList* result;
	count = (gsize) (size / sizeof (gint64));
	if (count <= ((gsize) 0)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = serialized == NULL;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp1_ = g_new0 (gint64, count);
	ids = _tmp1_;
	ids_length1 = count;
	_ids_size_ = ids_length1;
	_tmp2_ = ids;
	_tmp2__length1 = ids_length1;
	memcpy (_tmp2_, serialized, (gsize) size);
	_tmp3_ = gee_array_list_new (TYPE_PHOTO_ID, (GBoxedCopyFunc) photo_id_dup, (GDestroyNotify) photo_id_free, NULL, NULL, NULL);
	list = _tmp3_;
	_tmp4_ = ids;
	_tmp4__length1 = ids_length1;
	{
		gint64* id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
		id_collection = _tmp4_;
		id_collection_length1 = _tmp4__length1;
		for (id_it = 0; id_it < id_collection_length1; id_it = id_it + 1) {
			gint64 id = 0LL;
			id = id_collection[id_it];
			{
				GeeArrayList* _tmp5_;
				PhotoID _tmp6_ = {0};
				_tmp5_ = list;
				photo_id_init (&_tmp6_, id);
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, &_tmp6_);
			}
		}
	}
	result = (GeeList*) list;
	ids = (g_free (ids), NULL);
	return result;
}

guchar*
serialize_media_sources (GeeCollection* media,
                         gint* result_length1)
{
	GdkAtom* atoms = NULL;
	gint _tmp0_;
	gint _tmp1_;
	GdkAtom* _tmp2_;
	gint atoms_length1;
	gint _atoms_size_;
	gint ctr = 0;
	gsize bytes = 0UL;
	gint _tmp12_;
	gint _tmp13_;
	guchar* serialized = NULL;
	guchar* _tmp14_;
	gint serialized_length1;
	gint _serialized_size_;
	GdkAtom* _tmp15_;
	gint _tmp15__length1;
	guchar* _tmp16_;
	gint _tmp16__length1;
	guchar* result;
	g_return_val_if_fail (media != NULL, NULL);
	_tmp0_ = gee_collection_get_size (media);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (GdkAtom, _tmp1_);
	atoms = _tmp2_;
	atoms_length1 = _tmp1_;
	_atoms_size_ = atoms_length1;
	ctr = 0;
	{
		GeeIterator* _current_media_it = NULL;
		GeeIterator* _tmp3_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) media);
		_current_media_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			MediaSource* current_media = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			GdkAtom* _tmp7_;
			gint _tmp7__length1;
			gint _tmp8_;
			MediaSource* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp4_ = _current_media_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _current_media_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			current_media = (MediaSource*) _tmp6_;
			_tmp7_ = atoms;
			_tmp7__length1 = atoms_length1;
			_tmp8_ = ctr;
			ctr = _tmp8_ + 1;
			_tmp9_ = current_media;
			_tmp10_ = data_source_get_source_id ((DataSource*) _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp7_[_tmp8_] = gdk_atom_intern (_tmp11_, FALSE);
			_g_free0 (_tmp11_);
			_g_object_unref0 (current_media);
		}
		_g_object_unref0 (_current_media_it);
	}
	_tmp12_ = gee_collection_get_size (media);
	_tmp13_ = _tmp12_;
	bytes = (gsize) (_tmp13_ * sizeof (GdkAtom));
	_tmp14_ = g_new0 (guchar, bytes);
	serialized = _tmp14_;
	serialized_length1 = bytes;
	_serialized_size_ = serialized_length1;
	_tmp15_ = atoms;
	_tmp15__length1 = atoms_length1;
	memcpy (serialized, _tmp15_, bytes);
	_tmp16_ = serialized;
	_tmp16__length1 = serialized_length1;
	if (result_length1) {
		*result_length1 = _tmp16__length1;
	}
	result = _tmp16_;
	atoms = (g_free (atoms), NULL);
	return result;
}

GeeList*
unserialize_media_sources (guchar* serialized,
                           gint size)
{
	gsize count = 0UL;
	gboolean _tmp0_ = FALSE;
	GdkAtom* atoms = NULL;
	GdkAtom* _tmp1_;
	gint atoms_length1;
	gint _atoms_size_;
	GdkAtom* _tmp2_;
	gint _tmp2__length1;
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp3_;
	GdkAtom* _tmp4_;
	gint _tmp4__length1;
	GeeList* result;
	count = (gsize) (size / sizeof (GdkAtom));
	if (count <= ((gsize) 0)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = serialized == NULL;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp1_ = g_new0 (GdkAtom, count);
	atoms = _tmp1_;
	atoms_length1 = count;
	_atoms_size_ = atoms_length1;
	_tmp2_ = atoms;
	_tmp2__length1 = atoms_length1;
	memcpy (_tmp2_, serialized, (gsize) size);
	_tmp3_ = gee_array_list_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	list = _tmp3_;
	_tmp4_ = atoms;
	_tmp4__length1 = atoms_length1;
	{
		GdkAtom* current_atom_collection = NULL;
		gint current_atom_collection_length1 = 0;
		gint _current_atom_collection_size_ = 0;
		gint current_atom_it = 0;
		current_atom_collection = _tmp4_;
		current_atom_collection_length1 = _tmp4__length1;
		for (current_atom_it = 0; current_atom_it < current_atom_collection_length1; current_atom_it = current_atom_it + 1) {
			GdkAtom current_atom = (GdkAtom) 0U;
			current_atom = current_atom_collection[current_atom_it];
			{
				MediaSource* media = NULL;
				MediaCollectionRegistry* _tmp5_;
				MediaCollectionRegistry* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				MediaSource* _tmp9_;
				MediaSource* _tmp10_;
				MediaSource* _tmp11_;
				GeeArrayList* _tmp12_;
				MediaSource* _tmp13_;
				_tmp5_ = media_collection_registry_get_instance ();
				_tmp6_ = _tmp5_;
				_tmp7_ = gdk_atom_name (current_atom);
				_tmp8_ = _tmp7_;
				_tmp9_ = media_collection_registry_fetch_media (_tmp6_, _tmp8_);
				_tmp10_ = _tmp9_;
				_g_free0 (_tmp8_);
				_media_collection_registry_unref0 (_tmp6_);
				media = _tmp10_;
				_tmp11_ = media;
				_vala_assert (_tmp11_ != NULL, "media != null");
				_tmp12_ = list;
				_tmp13_ = media;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, _tmp13_);
				_g_object_unref0 (media);
			}
		}
	}
	result = (GeeList*) list;
	atoms = (g_free (atoms), NULL);
	return result;
}

gchar*
format_local_datespan (GDateTime* from_date,
                       GDateTime* to_date)
{
	gchar* from_format = NULL;
	gchar* to_format = NULL;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* result;
	g_return_val_if_fail (from_date != NULL, NULL);
	g_return_val_if_fail (to_date != NULL, NULL);
	if (g_date_time_get_year (from_date) == g_date_time_get_year (to_date)) {
		gboolean _tmp0_ = FALSE;
		if (g_date_time_get_month (from_date) == g_date_time_get_month (to_date)) {
			_tmp0_ = g_date_time_get_day_of_month (from_date) == (g_date_time_get_day_of_month (to_date) - 1);
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			gchar* _tmp1_;
			gchar* _tmp2_;
			_tmp1_ = resources_get_start_multiday_span_format_string ();
			_g_free0 (from_format);
			from_format = _tmp1_;
			_tmp2_ = resources_get_end_multiday_span_format_string ();
			_g_free0 (to_format);
			to_format = _tmp2_;
		} else {
			gchar* _tmp3_;
			gchar* _tmp4_;
			_tmp3_ = resources_get_start_multimonth_span_format_string ();
			_g_free0 (from_format);
			from_format = _tmp3_;
			_tmp4_ = resources_get_end_multimonth_span_format_string ();
			_g_free0 (to_format);
			to_format = _tmp4_;
		}
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = resources_get_long_date_format_string ();
		_g_free0 (from_format);
		from_format = _tmp5_;
		_tmp6_ = resources_get_long_date_format_string ();
		_g_free0 (to_format);
		to_format = _tmp6_;
	}
	_tmp7_ = from_format;
	_tmp8_ = g_date_time_format (from_date, _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = to_format;
	_tmp11_ = g_date_time_format (to_date, _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strdup_printf ("%s - %s", _tmp9_, _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = string_strip_leading_zeroes (_tmp14_);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp9_);
	result = _tmp16_;
	_g_free0 (to_format);
	_g_free0 (from_format);
	return result;
}

gchar*
format_local_date (GDateTime* date)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (date != NULL, NULL);
	_tmp0_ = resources_get_long_date_format_string ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_date_time_format (date, _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_strip_leading_zeroes (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp5_;
	return result;
}

static inline gpointer
one_shot_scheduler_get_instance_private (OneShotScheduler* self)
{
	return G_STRUCT_MEMBER_P (self, OneShotScheduler_private_offset);
}

OneShotScheduler*
one_shot_scheduler_construct (GType object_type,
                              const gchar* name,
                              OneShotCallback callback,
                              gpointer callback_target)
{
	OneShotScheduler* self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (name != NULL, NULL);
	self = (OneShotScheduler*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->priv->name);
	self->priv->name = _tmp0_;
	self->priv->callback = callback;
	self->priv->callback_target = callback_target;
	return self;
}

OneShotScheduler*
one_shot_scheduler_new (const gchar* name,
                        OneShotCallback callback,
                        gpointer callback_target)
{
	return one_shot_scheduler_construct (TYPE_ONE_SHOT_SCHEDULER, name, callback, callback_target);
}

gboolean
one_shot_scheduler_is_scheduled (OneShotScheduler* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->scheduled != ((guint) 0);
	return result;
}

void
one_shot_scheduler_at_idle (OneShotScheduler* self)
{
	g_return_if_fail (self != NULL);
	one_shot_scheduler_at_priority_idle (self, G_PRIORITY_DEFAULT_IDLE);
}

static gboolean
_one_shot_scheduler_callback_wrapper_gsource_func (gpointer self)
{
	gboolean result;
	result = one_shot_scheduler_callback_wrapper ((OneShotScheduler*) self);
	return result;
}

void
one_shot_scheduler_at_priority_idle (OneShotScheduler* self,
                                     gint priority)
{
	g_return_if_fail (self != NULL);
	if (self->priv->scheduled == ((guint) 0)) {
		self->priv->scheduled = g_idle_add_full (priority, _one_shot_scheduler_callback_wrapper_gsource_func, one_shot_scheduler_ref (self), one_shot_scheduler_unref);
	}
}

void
one_shot_scheduler_after_timeout (OneShotScheduler* self,
                                  guint msec,
                                  gboolean reschedule)
{
	g_return_if_fail (self != NULL);
	one_shot_scheduler_priority_after_timeout (self, G_PRIORITY_DEFAULT, msec, reschedule);
}

void
one_shot_scheduler_priority_after_timeout (OneShotScheduler* self,
                                           gint priority,
                                           guint msec,
                                           gboolean reschedule)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->scheduled != ((guint) 0)) {
		_tmp0_ = !reschedule;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	if (self->priv->scheduled != ((guint) 0)) {
		g_source_remove (self->priv->scheduled);
	}
	self->priv->scheduled = g_timeout_add_full (priority, msec, _one_shot_scheduler_callback_wrapper_gsource_func, one_shot_scheduler_ref (self), one_shot_scheduler_unref);
}

void
one_shot_scheduler_cancel (OneShotScheduler* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->scheduled == ((guint) 0)) {
		return;
	}
	g_source_remove (self->priv->scheduled);
	self->priv->scheduled = (guint) 0;
}

static gboolean
one_shot_scheduler_callback_wrapper (OneShotScheduler* self)
{
	OneShotCallback _tmp0_;
	gpointer _tmp0__target;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->scheduled = (guint) 0;
	_tmp0_ = self->priv->callback;
	_tmp0__target = self->priv->callback_target;
	_tmp0_ (_tmp0__target);
	result = FALSE;
	return result;
}

static void
value_one_shot_scheduler_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_one_shot_scheduler_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		one_shot_scheduler_unref (value->data[0].v_pointer);
	}
}

static void
value_one_shot_scheduler_copy_value (const GValue* src_value,
                                     GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = one_shot_scheduler_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_one_shot_scheduler_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_one_shot_scheduler_collect_value (GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		OneShotScheduler * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = one_shot_scheduler_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_one_shot_scheduler_lcopy_value (const GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	OneShotScheduler ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = one_shot_scheduler_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_one_shot_scheduler (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags)
{
	ParamSpecOneShotScheduler* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_ONE_SHOT_SCHEDULER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_one_shot_scheduler (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ONE_SHOT_SCHEDULER), NULL);
	return value->data[0].v_pointer;
}

void
value_set_one_shot_scheduler (GValue* value,
                              gpointer v_object)
{
	OneShotScheduler * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ONE_SHOT_SCHEDULER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ONE_SHOT_SCHEDULER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		one_shot_scheduler_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		one_shot_scheduler_unref (old);
	}
}

void
value_take_one_shot_scheduler (GValue* value,
                               gpointer v_object)
{
	OneShotScheduler * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ONE_SHOT_SCHEDULER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ONE_SHOT_SCHEDULER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		one_shot_scheduler_unref (old);
	}
}

static void
one_shot_scheduler_class_init (OneShotSchedulerClass * klass,
                               gpointer klass_data)
{
	one_shot_scheduler_parent_class = g_type_class_peek_parent (klass);
	((OneShotSchedulerClass *) klass)->finalize = one_shot_scheduler_finalize;
	g_type_class_adjust_private_offset (klass, &OneShotScheduler_private_offset);
}

static void
one_shot_scheduler_instance_init (OneShotScheduler * self,
                                  gpointer klass)
{
	self->priv = one_shot_scheduler_get_instance_private (self);
	self->priv->scheduled = (guint) 0;
	self->ref_count = 1;
}

static void
one_shot_scheduler_finalize (OneShotScheduler * obj)
{
	OneShotScheduler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ONE_SHOT_SCHEDULER, OneShotScheduler);
	g_signal_handlers_destroy (self);
	one_shot_scheduler_cancel (self);
	_g_free0 (self->priv->name);
}

static GType
one_shot_scheduler_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_one_shot_scheduler_init, value_one_shot_scheduler_free_value, value_one_shot_scheduler_copy_value, value_one_shot_scheduler_peek_pointer, "p", value_one_shot_scheduler_collect_value, "p", value_one_shot_scheduler_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (OneShotSchedulerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) one_shot_scheduler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (OneShotScheduler), 0, (GInstanceInitFunc) one_shot_scheduler_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType one_shot_scheduler_type_id;
	one_shot_scheduler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "OneShotScheduler", &g_define_type_info, &g_define_type_fundamental_info, 0);
	OneShotScheduler_private_offset = g_type_add_instance_private (one_shot_scheduler_type_id, sizeof (OneShotSchedulerPrivate));
	return one_shot_scheduler_type_id;
}

GType
one_shot_scheduler_get_type (void)
{
	static volatile gsize one_shot_scheduler_type_id__once = 0;
	if (g_once_init_enter (&one_shot_scheduler_type_id__once)) {
		GType one_shot_scheduler_type_id;
		one_shot_scheduler_type_id = one_shot_scheduler_get_type_once ();
		g_once_init_leave (&one_shot_scheduler_type_id__once, one_shot_scheduler_type_id);
	}
	return one_shot_scheduler_type_id__once;
}

gpointer
one_shot_scheduler_ref (gpointer instance)
{
	OneShotScheduler * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
one_shot_scheduler_unref (gpointer instance)
{
	OneShotScheduler * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		ONE_SHOT_SCHEDULER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
op_timer_get_instance_private (OpTimer* self)
{
	return G_STRUCT_MEMBER_P (self, OpTimer_private_offset);
}

OpTimer*
op_timer_construct (GType object_type,
                    const gchar* name)
{
	OpTimer* self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (name != NULL, NULL);
	self = (OpTimer*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->priv->name);
	self->priv->name = _tmp0_;
	return self;
}

OpTimer*
op_timer_new (const gchar* name)
{
	return op_timer_construct (TYPE_OP_TIMER, name);
}

void
op_timer_start (OpTimer* self)
{
	GTimer* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->timer;
	g_timer_start (_tmp0_);
}

void
op_timer_stop (OpTimer* self)
{
	gdouble time = 0.0;
	GTimer* _tmp0_;
	glong _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->timer;
	time = g_timer_elapsed (_tmp0_, NULL);
	self->priv->elapsed = self->priv->elapsed + time;
	if (time < self->priv->shortest) {
		self->priv->shortest = time;
	}
	if (time > self->priv->longest) {
		self->priv->longest = time;
	}
	_tmp1_ = self->priv->count;
	self->priv->count = _tmp1_ + 1;
}

gchar*
op_timer_to_string (OpTimer* self)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->count > ((glong) 0)) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = self->priv->name;
		_tmp1_ = g_strdup_printf ("%s: count=%ld elapsed=%.03lfs min/avg/max=%.03lf/%.03lf/%.03lf", _tmp0_, self->priv->count, self->priv->elapsed, self->priv->shortest, self->priv->elapsed / ((gdouble) self->priv->count), self->priv->longest);
		result = _tmp1_;
		return result;
	} else {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->name;
		_tmp3_ = g_strdup_printf ("%s: no operations", _tmp2_);
		result = _tmp3_;
		return result;
	}
}

static void
value_op_timer_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_op_timer_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		op_timer_unref (value->data[0].v_pointer);
	}
}

static void
value_op_timer_copy_value (const GValue* src_value,
                           GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = op_timer_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_op_timer_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_op_timer_collect_value (GValue* value,
                              guint n_collect_values,
                              GTypeCValue* collect_values,
                              guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		OpTimer * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = op_timer_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_op_timer_lcopy_value (const GValue* value,
                            guint n_collect_values,
                            GTypeCValue* collect_values,
                            guint collect_flags)
{
	OpTimer ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = op_timer_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_op_timer (const gchar* name,
                     const gchar* nick,
                     const gchar* blurb,
                     GType object_type,
                     GParamFlags flags)
{
	ParamSpecOpTimer* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_OP_TIMER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_op_timer (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_OP_TIMER), NULL);
	return value->data[0].v_pointer;
}

void
value_set_op_timer (GValue* value,
                    gpointer v_object)
{
	OpTimer * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_OP_TIMER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_OP_TIMER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		op_timer_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		op_timer_unref (old);
	}
}

void
value_take_op_timer (GValue* value,
                     gpointer v_object)
{
	OpTimer * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_OP_TIMER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_OP_TIMER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		op_timer_unref (old);
	}
}

static void
op_timer_class_init (OpTimerClass * klass,
                     gpointer klass_data)
{
	op_timer_parent_class = g_type_class_peek_parent (klass);
	((OpTimerClass *) klass)->finalize = op_timer_finalize;
	g_type_class_adjust_private_offset (klass, &OpTimer_private_offset);
}

static void
op_timer_instance_init (OpTimer * self,
                        gpointer klass)
{
	GTimer* _tmp0_;
	self->priv = op_timer_get_instance_private (self);
	_tmp0_ = g_timer_new ();
	self->priv->timer = _tmp0_;
	self->priv->count = (glong) 0;
	self->priv->elapsed = (gdouble) 0;
	self->priv->shortest = DBL_MAX;
	self->priv->longest = DBL_MIN;
	self->ref_count = 1;
}

static void
op_timer_finalize (OpTimer * obj)
{
	OpTimer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_OP_TIMER, OpTimer);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->name);
	_g_timer_destroy0 (self->priv->timer);
}

static GType
op_timer_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_op_timer_init, value_op_timer_free_value, value_op_timer_copy_value, value_op_timer_peek_pointer, "p", value_op_timer_collect_value, "p", value_op_timer_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (OpTimerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) op_timer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (OpTimer), 0, (GInstanceInitFunc) op_timer_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType op_timer_type_id;
	op_timer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "OpTimer", &g_define_type_info, &g_define_type_fundamental_info, 0);
	OpTimer_private_offset = g_type_add_instance_private (op_timer_type_id, sizeof (OpTimerPrivate));
	return op_timer_type_id;
}

GType
op_timer_get_type (void)
{
	static volatile gsize op_timer_type_id__once = 0;
	if (g_once_init_enter (&op_timer_type_id__once)) {
		GType op_timer_type_id;
		op_timer_type_id = op_timer_get_type_once ();
		g_once_init_leave (&op_timer_type_id__once, op_timer_type_id);
	}
	return op_timer_type_id__once;
}

gpointer
op_timer_ref (gpointer instance)
{
	OpTimer * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
op_timer_unref (gpointer instance)
{
	OpTimer * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		OP_TIMER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

void
suppress_warnings (const gchar* log_domain,
                   GLogLevelFlags log_levels,
                   const gchar* message)
{
	g_return_if_fail (message != NULL);
}

static void
g_time_local (time_t time,
              struct tm* result)
{
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
	localtime_r (&time, &_tmp0_);
	_result_ = _tmp0_;
	*result = _result_;
	return;
}

static gchar*
g_time_format (struct tm *self,
               const gchar* format)
{
	gchar* buffer = NULL;
	gchar* _tmp0_;
	gint buffer_length1;
	gint _buffer_size_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (format != NULL, NULL);
	_tmp0_ = g_new0 (gchar, 64);
	buffer = _tmp0_;
	buffer_length1 = 64;
	_buffer_size_ = buffer_length1;
	strftime (buffer, (gint) buffer_length1, format, &(*self));
	_tmp1_ = g_strdup ((const gchar*) buffer);
	result = _tmp1_;
	buffer = (g_free (buffer), NULL);
	return result;
}

gboolean
is_twentyfour_hr_time_system (void)
{
	struct tm _tmp0_ = {0};
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	g_time_local ((time_t) 0, &_tmp0_);
	_tmp1_ = g_time_format (&_tmp0_, "%p");
	_tmp2_ = _tmp1_;
	_tmp3_ = is_string_empty (_tmp2_);
	_g_free0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

