/* CPUMonitorDockItem.c generated by valac 0.56.17, the Vala compiler
 * generated from CPUMonitorDockItem.vala, do not modify */

/**/
/*  Copyright (C) 2016 Rico Tzschichholz*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include <plank.h>
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <stdlib.h>
#include <string.h>
#include <cairo-gobject.h>

#define DOCKY_CPU_MONITOR_DOCK_ITEM_UPDATE_DELAY 1000000UL
#define DOCKY_CPU_MONITOR_DOCK_ITEM_RADIUS_PERCENT 0.9
#define DOCKY_CPU_MONITOR_DOCK_ITEM_CPU_THRESHOLD 0.03
#define DOCKY_CPU_MONITOR_DOCK_ITEM_MEM_THRESHOLD 0.01
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define DOCKY_TYPE_CPU_MONITOR_DOCK_ITEM (docky_cpu_monitor_dock_item_get_type ())
#define DOCKY_CPU_MONITOR_DOCK_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DOCKY_TYPE_CPU_MONITOR_DOCK_ITEM, DockyCPUMonitorDockItem))
#define DOCKY_CPU_MONITOR_DOCK_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DOCKY_TYPE_CPU_MONITOR_DOCK_ITEM, DockyCPUMonitorDockItemClass))
#define DOCKY_IS_CPU_MONITOR_DOCK_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DOCKY_TYPE_CPU_MONITOR_DOCK_ITEM))
#define DOCKY_IS_CPU_MONITOR_DOCK_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DOCKY_TYPE_CPU_MONITOR_DOCK_ITEM))
#define DOCKY_CPU_MONITOR_DOCK_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DOCKY_TYPE_CPU_MONITOR_DOCK_ITEM, DockyCPUMonitorDockItemClass))

typedef struct _DockyCPUMonitorDockItem DockyCPUMonitorDockItem;
typedef struct _DockyCPUMonitorDockItemClass DockyCPUMonitorDockItemClass;
typedef struct _DockyCPUMonitorDockItemPrivate DockyCPUMonitorDockItemPrivate;
enum  {
	DOCKY_CPU_MONITOR_DOCK_ITEM_0_PROPERTY,
	DOCKY_CPU_MONITOR_DOCK_ITEM_NUM_PROPERTIES
};
static GParamSpec* docky_cpu_monitor_dock_item_properties[DOCKY_CPU_MONITOR_DOCK_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))

struct _DockyCPUMonitorDockItem {
	PlankDockletItem parent_instance;
	DockyCPUMonitorDockItemPrivate * priv;
};

struct _DockyCPUMonitorDockItemClass {
	PlankDockletItemClass parent_class;
};

struct _DockyCPUMonitorDockItemPrivate {
	gboolean disposed;
	gulong last_usage;
	gulong last_idle;
	gdouble cpu_utilization;
	gdouble memory_utilization;
	gdouble last_cpu_utilization;
	gdouble last_memory_utilization;
};

static gint DockyCPUMonitorDockItem_private_offset;
static gpointer docky_cpu_monitor_dock_item_parent_class = NULL;

VALA_EXTERN GType docky_cpu_monitor_dock_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DockyCPUMonitorDockItem, g_object_unref)
VALA_EXTERN DockyCPUMonitorDockItem* docky_cpu_monitor_dock_item_new_with_dockitem_file (GFile* file);
VALA_EXTERN DockyCPUMonitorDockItem* docky_cpu_monitor_dock_item_construct_with_dockitem_file (GType object_type,
                                                                                   GFile* file);
static PlankAnimationType docky_cpu_monitor_dock_item_real_on_clicked (PlankDockElement* base,
                                                                PlankPopupButton button,
                                                                GdkModifierType mod,
                                                                guint32 event_time);
static void docky_cpu_monitor_dock_item_update (DockyCPUMonitorDockItem* self);
static gboolean ___lambda4_ (DockyCPUMonitorDockItem* self);
static gboolean ____lambda4__gsource_func (gpointer self);
static void docky_cpu_monitor_dock_item_real_draw_icon (PlankDockItem* base,
                                                 PlankSurface* surface);
VALA_EXTERN DockyCPUMonitorDockItem* docky_cpu_monitor_dock_item_new (void);
VALA_EXTERN DockyCPUMonitorDockItem* docky_cpu_monitor_dock_item_construct (GType object_type);
static GObject * docky_cpu_monitor_dock_item_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static void* _docky_cpu_monitor_dock_item___lambda5_ (DockyCPUMonitorDockItem* self);
static gpointer __docky_cpu_monitor_dock_item___lambda5__gthread_func (gpointer self);
static void docky_cpu_monitor_dock_item_finalize (GObject * obj);
static GType docky_cpu_monitor_dock_item_get_type_once (void);

static inline gpointer
docky_cpu_monitor_dock_item_get_instance_private (DockyCPUMonitorDockItem* self)
{
	return G_STRUCT_MEMBER_P (self, DockyCPUMonitorDockItem_private_offset);
}

/**
 * {@inheritDoc}
 */
DockyCPUMonitorDockItem*
docky_cpu_monitor_dock_item_construct_with_dockitem_file (GType object_type,
                                                          GFile* file)
{
	DockyCPUMonitorDockItem * self = NULL;
	PlankDockItemPreferences* _tmp0_;
	PlankDockItemPreferences* _tmp1_;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = plank_dock_item_preferences_new_with_file (file);
	_tmp1_ = _tmp0_;
	self = (DockyCPUMonitorDockItem*) g_object_new (object_type, "Prefs", _tmp1_, NULL);
	_g_object_unref0 (_tmp1_);
	return self;
}

DockyCPUMonitorDockItem*
docky_cpu_monitor_dock_item_new_with_dockitem_file (GFile* file)
{
	return docky_cpu_monitor_dock_item_construct_with_dockitem_file (DOCKY_TYPE_CPU_MONITOR_DOCK_ITEM, file);
}

static PlankAnimationType
docky_cpu_monitor_dock_item_real_on_clicked (PlankDockElement* base,
                                             PlankPopupButton button,
                                             GdkModifierType mod,
                                             guint32 event_time)
{
	DockyCPUMonitorDockItem * self;
	PlankAnimationType result;
	self = (DockyCPUMonitorDockItem*) base;
	if (button == PLANK_POPUP_BUTTON_LEFT) {
	}
	result = PLANK_ANIMATION_TYPE_NONE;
	return result;
}

static gboolean
___lambda4_ (DockyCPUMonitorDockItem* self)
{
	gboolean result;
	plank_dock_item_reset_icon_buffer ((PlankDockItem*) self);
	result = FALSE;
	return result;
}

static gboolean
____lambda4__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda4_ ((DockyCPUMonitorDockItem*) self);
	return result;
}

static void
docky_cpu_monitor_dock_item_update (DockyCPUMonitorDockItem* self)
{
	FILE* stream = NULL;
	FILE* _tmp0_;
	FILE* _tmp1_;
	FILE* _tmp10_;
	FILE* _tmp11_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gboolean _tmp20_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_fopen ("/proc/stat", "r");
	_fclose0 (stream);
	stream = _tmp0_;
	_tmp1_ = stream;
	if (_tmp1_ != NULL) {
		gulong user = 0UL;
		gulong nice = 0UL;
		gulong system = 0UL;
		gulong idle = 0UL;
		gulong iowait = 0UL;
		gulong irq = 0UL;
		gulong softirq = 0UL;
		FILE* _tmp2_;
		gulong _tmp3_ = 0UL;
		gulong _tmp4_ = 0UL;
		gulong _tmp5_ = 0UL;
		gulong _tmp6_ = 0UL;
		gulong _tmp7_ = 0UL;
		gulong _tmp8_ = 0UL;
		gulong _tmp9_ = 0UL;
		gulong usage_final = 0UL;
		gulong idle_final = 0UL;
		gulong usage_diff = 0UL;
		gulong idle_diff = 0UL;
		_tmp2_ = stream;
		fscanf (_tmp2_, "%*s %lu %lu %lu %lu %lu %lu %lu", &_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_);
		user = _tmp3_;
		nice = _tmp4_;
		system = _tmp5_;
		idle = _tmp6_;
		iowait = _tmp7_;
		irq = _tmp8_;
		softirq = _tmp9_;
		usage_final = (((((user + nice) + system) + idle) + iowait) + irq) + softirq;
		idle_final = idle + iowait;
		usage_diff = usage_final - self->priv->last_usage;
		idle_diff = idle_final - self->priv->last_idle;
		self->priv->last_idle = idle_final;
		self->priv->last_usage = usage_final;
		if (usage_diff > 0UL) {
			self->priv->cpu_utilization = MAX (0.01, ((1.0 - (idle_diff / ((gdouble) usage_diff))) + self->priv->cpu_utilization) / 2.0);
		}
	}
	_tmp10_ = g_fopen ("/proc/meminfo", "r");
	_fclose0 (stream);
	stream = _tmp10_;
	_tmp11_ = stream;
	if (_tmp11_ != NULL) {
		gulong mem_total = 0UL;
		gulong mem_free = 0UL;
		gulong mem_avail = 0UL;
		FILE* _tmp12_;
		gulong _tmp13_ = 0UL;
		FILE* _tmp14_;
		gulong _tmp15_ = 0UL;
		FILE* _tmp16_;
		gulong _tmp17_ = 0UL;
		_tmp12_ = stream;
		fscanf (_tmp12_, "%*s %lu %*s", &_tmp13_);
		mem_total = _tmp13_;
		_tmp14_ = stream;
		fscanf (_tmp14_, "%*s %lu %*s", &_tmp15_);
		mem_free = _tmp15_;
		_tmp16_ = stream;
		fscanf (_tmp16_, "%*s %lu %*s", &_tmp17_);
		mem_avail = _tmp17_;
		self->priv->memory_utilization = 1.0 - (mem_avail / ((gdouble) mem_total));
	}
	_tmp18_ = g_strdup_printf ("CPU: %.1f%% | Mem: %.1f%%", self->priv->cpu_utilization * 100, self->priv->memory_utilization * 100);
	_tmp19_ = _tmp18_;
	plank_dock_element_set_Text ((PlankDockElement*) self, _tmp19_);
	_g_free0 (_tmp19_);
	if (fabs (self->priv->last_cpu_utilization - self->priv->cpu_utilization) >= DOCKY_CPU_MONITOR_DOCK_ITEM_CPU_THRESHOLD) {
		_tmp20_ = TRUE;
	} else {
		_tmp20_ = fabs (self->priv->last_memory_utilization - self->priv->memory_utilization) >= DOCKY_CPU_MONITOR_DOCK_ITEM_MEM_THRESHOLD;
	}
	if (_tmp20_) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda4__gsource_func, g_object_ref (self), g_object_unref);
		self->priv->last_cpu_utilization = self->priv->cpu_utilization;
		self->priv->last_memory_utilization = self->priv->memory_utilization;
	}
	_fclose0 (stream);
}

static void
docky_cpu_monitor_dock_item_real_draw_icon (PlankDockItem* base,
                                            PlankSurface* surface)
{
	DockyCPUMonitorDockItem * self;
	gint size = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	cairo_t* cr = NULL;
	cairo_t* _tmp4_;
	cairo_t* _tmp5_;
	cairo_pattern_t* pattern = NULL;
	gdouble center = 0.0;
	PlankColor base_color = {0};
	PlankColor _tmp6_ = {0};
	gdouble radius = 0.0;
	cairo_pattern_t* _tmp7_;
	cairo_pattern_t* _tmp8_;
	PlankColor _tmp9_;
	PlankColor _tmp10_;
	PlankColor _tmp11_;
	PlankColor _tmp12_;
	cairo_pattern_t* _tmp13_;
	PlankColor _tmp14_;
	PlankColor _tmp15_;
	PlankColor _tmp16_;
	PlankColor _tmp17_;
	cairo_pattern_t* _tmp18_;
	PlankColor _tmp19_;
	PlankColor _tmp20_;
	PlankColor _tmp21_;
	cairo_pattern_t* _tmp22_;
	cairo_pattern_t* _tmp23_;
	cairo_pattern_t* _tmp24_;
	PlankColor _tmp25_;
	PlankColor _tmp26_;
	PlankColor _tmp27_;
	cairo_pattern_t* _tmp28_;
	PlankColor _tmp29_;
	PlankColor _tmp30_;
	PlankColor _tmp31_;
	cairo_pattern_t* _tmp32_;
	PlankColor _tmp33_;
	PlankColor _tmp34_;
	PlankColor _tmp35_;
	cairo_pattern_t* _tmp36_;
	cairo_pattern_t* _tmp37_;
	cairo_pattern_t* _tmp38_;
	cairo_pattern_t* _tmp39_;
	cairo_pattern_t* _tmp40_;
	self = (DockyCPUMonitorDockItem*) base;
	g_return_if_fail (surface != NULL);
	_tmp0_ = plank_surface_get_Width (surface);
	_tmp1_ = _tmp0_;
	_tmp2_ = plank_surface_get_Height (surface);
	_tmp3_ = _tmp2_;
	size = MAX (_tmp1_, _tmp3_);
	_tmp4_ = plank_surface_get_Context (surface);
	_tmp5_ = _tmp4_;
	cr = _tmp5_;
	center = size / 2.0;
	_tmp6_.red = 1.0;
	_tmp6_.green = 0.3;
	_tmp6_.blue = 0.3;
	_tmp6_.alpha = 0.5;
	base_color = _tmp6_;
	plank_color_set_hue (&base_color, 120.0 * (1.0 - self->priv->cpu_utilization));
	radius = MAX (MIN (self->priv->cpu_utilization * 1.3, 1.0), 0.001);
	cairo_arc (cr, center, center, center * DOCKY_CPU_MONITOR_DOCK_ITEM_RADIUS_PERCENT, 0.0, 2.0 * G_PI);
	cairo_set_source_rgba (cr, 0.0, 0.0, 0.0, 0.5);
	cairo_fill_preserve (cr);
	_tmp7_ = cairo_pattern_create_radial (center, center, 0.0, center, center, center * DOCKY_CPU_MONITOR_DOCK_ITEM_RADIUS_PERCENT);
	_cairo_pattern_destroy0 (pattern);
	pattern = _tmp7_;
	_tmp8_ = pattern;
	_tmp9_ = base_color;
	_tmp10_ = base_color;
	_tmp11_ = base_color;
	_tmp12_ = base_color;
	cairo_pattern_add_color_stop_rgba (_tmp8_, 0.0, _tmp9_.red, _tmp10_.green, _tmp11_.blue, _tmp12_.alpha);
	_tmp13_ = pattern;
	_tmp14_ = base_color;
	_tmp15_ = base_color;
	_tmp16_ = base_color;
	_tmp17_ = base_color;
	cairo_pattern_add_color_stop_rgba (_tmp13_, 0.2, _tmp14_.red, _tmp15_.green, _tmp16_.blue, _tmp17_.alpha);
	_tmp18_ = pattern;
	_tmp19_ = base_color;
	_tmp20_ = base_color;
	_tmp21_ = base_color;
	cairo_pattern_add_color_stop_rgba (_tmp18_, 1.0, _tmp19_.red, _tmp20_.green, _tmp21_.blue, 0.15);
	_tmp22_ = pattern;
	cairo_set_source (cr, _tmp22_);
	cairo_fill_preserve (cr);
	_tmp23_ = cairo_pattern_create_radial (center, center, (gdouble) 0, center, center, (center * DOCKY_CPU_MONITOR_DOCK_ITEM_RADIUS_PERCENT) * radius);
	_cairo_pattern_destroy0 (pattern);
	pattern = _tmp23_;
	_tmp24_ = pattern;
	_tmp25_ = base_color;
	_tmp26_ = base_color;
	_tmp27_ = base_color;
	cairo_pattern_add_color_stop_rgba (_tmp24_, 0.0, _tmp25_.red, _tmp26_.green, _tmp27_.blue, 1.0);
	_tmp28_ = pattern;
	_tmp29_ = base_color;
	_tmp30_ = base_color;
	_tmp31_ = base_color;
	cairo_pattern_add_color_stop_rgba (_tmp28_, 0.2, _tmp29_.red, _tmp30_.green, _tmp31_.blue, 1.0);
	_tmp32_ = pattern;
	_tmp33_ = base_color;
	_tmp34_ = base_color;
	_tmp35_ = base_color;
	cairo_pattern_add_color_stop_rgba (_tmp32_, 1.0, _tmp33_.red, _tmp34_.green, _tmp35_.blue, MAX (0.0, (self->priv->cpu_utilization * 1.3) - 1.0));
	_tmp36_ = pattern;
	cairo_set_source (cr, _tmp36_);
	cairo_fill (cr);
	cairo_arc (cr, center, center * 0.8, center * 0.6, 0.0, 2.0 * G_PI);
	_tmp37_ = cairo_pattern_create_linear (0.0, 0.0, 0.0, center);
	_cairo_pattern_destroy0 (pattern);
	pattern = _tmp37_;
	_tmp38_ = pattern;
	cairo_pattern_add_color_stop_rgba (_tmp38_, 0.0, 1.0, 1.0, 1.0, 0.35);
	_tmp39_ = pattern;
	cairo_pattern_add_color_stop_rgba (_tmp39_, 1.0, 1.0, 1.0, 1.0, 0.0);
	_tmp40_ = pattern;
	cairo_set_source (cr, _tmp40_);
	cairo_fill (cr);
	cairo_set_line_width (cr, 1.0);
	cairo_arc (cr, center, center, center * DOCKY_CPU_MONITOR_DOCK_ITEM_RADIUS_PERCENT, 0.0, 2.0 * G_PI);
	cairo_set_source_rgba (cr, 1.0, 1.0, 1.0, 0.75);
	cairo_stroke (cr);
	cairo_set_line_width (cr, 1.0);
	cairo_arc (cr, center, center, (center * DOCKY_CPU_MONITOR_DOCK_ITEM_RADIUS_PERCENT) - 1.0, 0.0, 2.0 * G_PI);
	cairo_set_source_rgba (cr, 0.8, 0.8, 0.8, 0.75);
	cairo_stroke (cr);
	cairo_set_line_width (cr, size / 32.0);
	cairo_arc_negative (cr, center, center, (center * DOCKY_CPU_MONITOR_DOCK_ITEM_RADIUS_PERCENT) - 1.0, G_PI, G_PI - (G_PI * (2.0 * self->priv->memory_utilization)));
	cairo_set_source_rgba (cr, 1.0, 1.0, 1.0, 0.85);
	cairo_stroke (cr);
	_cairo_pattern_destroy0 (pattern);
}

DockyCPUMonitorDockItem*
docky_cpu_monitor_dock_item_construct (GType object_type)
{
	DockyCPUMonitorDockItem * self = NULL;
	self = (DockyCPUMonitorDockItem*) plank_docklet_item_construct (object_type);
	return self;
}

DockyCPUMonitorDockItem*
docky_cpu_monitor_dock_item_new (void)
{
	return docky_cpu_monitor_dock_item_construct (DOCKY_TYPE_CPU_MONITOR_DOCK_ITEM);
}

static void*
_docky_cpu_monitor_dock_item___lambda5_ (DockyCPUMonitorDockItem* self)
{
	void* result;
	while (TRUE) {
		if (!(!self->priv->disposed)) {
			break;
		}
		docky_cpu_monitor_dock_item_update (self);
		g_usleep (DOCKY_CPU_MONITOR_DOCK_ITEM_UPDATE_DELAY);
	}
	result = NULL;
	return result;
}

static gpointer
__docky_cpu_monitor_dock_item___lambda5__gthread_func (gpointer self)
{
	gpointer result;
	result = _docky_cpu_monitor_dock_item___lambda5_ ((DockyCPUMonitorDockItem*) self);
	g_object_unref (self);
	return result;
}

static GObject *
docky_cpu_monitor_dock_item_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	DockyCPUMonitorDockItem * self;
	GThread* _tmp0_;
	GThread* _tmp1_;
	parent_class = G_OBJECT_CLASS (docky_cpu_monitor_dock_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DOCKY_TYPE_CPU_MONITOR_DOCK_ITEM, DockyCPUMonitorDockItem);
	_tmp0_ = g_thread_new (NULL, __docky_cpu_monitor_dock_item___lambda5__gthread_func, g_object_ref (self));
	_tmp1_ = _tmp0_;
	_g_thread_unref0 (_tmp1_);
	return obj;
}

static void
docky_cpu_monitor_dock_item_class_init (DockyCPUMonitorDockItemClass * klass,
                                        gpointer klass_data)
{
	docky_cpu_monitor_dock_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DockyCPUMonitorDockItem_private_offset);
	((PlankDockElementClass *) klass)->on_clicked = (PlankAnimationType (*) (PlankDockElement*, PlankPopupButton, GdkModifierType, guint32)) docky_cpu_monitor_dock_item_real_on_clicked;
	((PlankDockItemClass *) klass)->draw_icon = (void (*) (PlankDockItem*, PlankSurface*)) docky_cpu_monitor_dock_item_real_draw_icon;
	G_OBJECT_CLASS (klass)->constructor = docky_cpu_monitor_dock_item_constructor;
	G_OBJECT_CLASS (klass)->finalize = docky_cpu_monitor_dock_item_finalize;
}

static void
docky_cpu_monitor_dock_item_instance_init (DockyCPUMonitorDockItem * self,
                                           gpointer klass)
{
	self->priv = docky_cpu_monitor_dock_item_get_instance_private (self);
	self->priv->disposed = FALSE;
}

static void
docky_cpu_monitor_dock_item_finalize (GObject * obj)
{
	DockyCPUMonitorDockItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DOCKY_TYPE_CPU_MONITOR_DOCK_ITEM, DockyCPUMonitorDockItem);
	self->priv->disposed = TRUE;
	G_OBJECT_CLASS (docky_cpu_monitor_dock_item_parent_class)->finalize (obj);
}

static GType
docky_cpu_monitor_dock_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DockyCPUMonitorDockItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) docky_cpu_monitor_dock_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DockyCPUMonitorDockItem), 0, (GInstanceInitFunc) docky_cpu_monitor_dock_item_instance_init, NULL };
	GType docky_cpu_monitor_dock_item_type_id;
	docky_cpu_monitor_dock_item_type_id = g_type_register_static (PLANK_TYPE_DOCKLET_ITEM, "DockyCPUMonitorDockItem", &g_define_type_info, 0);
	DockyCPUMonitorDockItem_private_offset = g_type_add_instance_private (docky_cpu_monitor_dock_item_type_id, sizeof (DockyCPUMonitorDockItemPrivate));
	return docky_cpu_monitor_dock_item_type_id;
}

GType
docky_cpu_monitor_dock_item_get_type (void)
{
	static volatile gsize docky_cpu_monitor_dock_item_type_id__once = 0;
	if (g_once_init_enter (&docky_cpu_monitor_dock_item_type_id__once)) {
		GType docky_cpu_monitor_dock_item_type_id;
		docky_cpu_monitor_dock_item_type_id = docky_cpu_monitor_dock_item_get_type_once ();
		g_once_init_leave (&docky_cpu_monitor_dock_item_type_id__once, docky_cpu_monitor_dock_item_type_id);
	}
	return docky_cpu_monitor_dock_item_type_id__once;
}

