/* DockletManager.c generated by valac 0.56.17, the Vala compiler
 * generated from DockletManager.vala, do not modify */

/**/
/*  Copyright (C) 2011 Robert Dyer*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/
/* portions based on code from Rygel*/
/*
 * Copyright (C) 2008 Nokia Corporation.
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "plank.h"
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include "config.h"
#include "plank-internal.h"
#include <gmodule.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PLANK_DOCKLET_MANAGER_0_PROPERTY,
	PLANK_DOCKLET_MANAGER_NUM_PROPERTIES
};
static GParamSpec* plank_docklet_manager_properties[PLANK_DOCKLET_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block4Data Block4Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_module_close0(var) ((var == NULL) ? NULL : (var = (g_module_close (var), NULL)))
enum  {
	PLANK_DOCKLET_MANAGER_DOCKLET_ADDED_SIGNAL,
	PLANK_DOCKLET_MANAGER_NUM_SIGNALS
};
static guint plank_docklet_manager_signals[PLANK_DOCKLET_MANAGER_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PlankDockletManagerPrivate {
	GeeHashMap* docklets;
};

struct _Block4Data {
	int _ref_count_;
	PlankDockletManager* self;
	PlankDocklet* docklet;
	gchar* uri;
};

static gint PlankDockletManager_private_offset;
static gpointer plank_docklet_manager_parent_class = NULL;
static GRegex* plank_docklet_manager_docklet_filename_regex;
static GRegex* plank_docklet_manager_docklet_filename_regex = NULL;
static PlankDockletManager* plank_docklet_manager_instance;
static PlankDockletManager* plank_docklet_manager_instance = NULL;

static PlankDockletManager* plank_docklet_manager_new (void);
static PlankDockletManager* plank_docklet_manager_construct (GType object_type);
static void plank_docklet_manager_load_modules_from_dir (PlankDockletManager* self,
                                                  GFile* dir);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static gboolean __lambda15_ (Block4Data* _data4_,
                      const gchar* k,
                      PlankDocklet* v);
static gboolean ___lambda15__gee_forall_map_func (gconstpointer k,
                                           gconstpointer v,
                                           gpointer self);
static void plank_docklet_manager_load_module_from_file (PlankDockletManager* self,
                                                  const gchar* file_path);
static GObject * plank_docklet_manager_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static void plank_docklet_manager_finalize (GObject * obj);
static GType plank_docklet_manager_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static GRegex* _tmp_regex_0 = NULL;

static inline gpointer
plank_docklet_manager_get_instance_private (PlankDockletManager* self)
{
	return G_STRUCT_MEMBER_P (self, PlankDockletManager_private_offset);
}

static inline GRegex*
_thread_safe_regex_init (GRegex** re,
                         const gchar * pattern,
                         GRegexCompileFlags compile_flags)
{
	if (g_once_init_enter ((volatile gsize*) re)) {
		GRegex* val = g_regex_new (pattern, compile_flags, 0, NULL);
		g_once_init_leave ((volatile gsize*) re, (gsize) val);
	}
	return *re;
}

static gpointer
_g_regex_ref0 (gpointer self)
{
	return self ? g_regex_ref (self) : NULL;
}

PlankDockletManager*
plank_docklet_manager_get_default (void)
{
	PlankDockletManager* _tmp0_;
	PlankDockletManager* _tmp2_;
	PlankDockletManager* result;
	_tmp0_ = plank_docklet_manager_instance;
	if (_tmp0_ == NULL) {
		PlankDockletManager* _tmp1_;
		_tmp1_ = plank_docklet_manager_new ();
		_g_object_unref0 (plank_docklet_manager_instance);
		plank_docklet_manager_instance = _tmp1_;
	}
	_tmp2_ = plank_docklet_manager_instance;
	result = _tmp2_;
	return result;
}

static PlankDockletManager*
plank_docklet_manager_construct (GType object_type)
{
	PlankDockletManager * self = NULL;
	self = (PlankDockletManager*) g_object_new (object_type, NULL);
	return self;
}

static PlankDockletManager*
plank_docklet_manager_new (void)
{
	return plank_docklet_manager_construct (PLANK_TYPE_DOCKLET_MANAGER);
}

/**
 * Load docklet modules from known directories
 */
void
plank_docklet_manager_load_docklets (PlankDockletManager* self)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	const gchar* docklet_dirs = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_file_new_for_path (DOCKLETSDIR);
	_tmp1_ = _tmp0_;
	plank_docklet_manager_load_modules_from_dir (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = g_getenv ("PLANK_DOCKLET_DIRS");
	docklet_dirs = _tmp2_;
	_tmp3_ = docklet_dirs;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		gchar** _tmp5_;
		gchar** _tmp6_;
		_tmp4_ = docklet_dirs;
		_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, ":", 0);
		{
			gchar** dir_collection = NULL;
			gint dir_collection_length1 = 0;
			gint _dir_collection_size_ = 0;
			gint dir_it = 0;
			dir_collection = _tmp6_;
			dir_collection_length1 = _vala_array_length (_tmp5_);
			for (dir_it = 0; dir_it < dir_collection_length1; dir_it = dir_it + 1) {
				const gchar* dir = NULL;
				dir = dir_collection[dir_it];
				{
					const gchar* _tmp7_;
					GFile* _tmp8_;
					GFile* _tmp9_;
					_tmp7_ = dir;
					_tmp8_ = g_file_new_for_path (_tmp7_);
					_tmp9_ = _tmp8_;
					plank_docklet_manager_load_modules_from_dir (self, _tmp9_);
					_g_object_unref0 (_tmp9_);
				}
			}
			dir_collection = (_vala_array_free (dir_collection, dir_collection_length1, (GDestroyNotify) g_free), NULL);
		}
	}
}

/**
 * Register docklet with given name and type
 *
 * @param type a type
 */
void
plank_docklet_manager_register_docklet (PlankDockletManager* self,
                                        GType type)
{
	PlankDocklet* docklet = NULL;
	GObject* _tmp1_;
	GObject* _tmp2_;
	const gchar* id = NULL;
	PlankDocklet* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GeeHashMap* _tmp6_;
	const gchar* _tmp7_;
	PlankDocklet* _tmp8_;
	PlankDocklet* _tmp9_;
	g_return_if_fail (self != NULL);
	if (!g_type_is_a (type, PLANK_TYPE_DOCKLET)) {
		const gchar* _tmp0_;
		_tmp0_ = g_type_name (type);
		g_warning ("DockletManager.vala:100: '%s' is not a Docklet", _tmp0_);
		return;
	}
	_tmp1_ = g_object_new (type, NULL);
	_tmp2_ = G_IS_INITIALLY_UNOWNED (_tmp1_) ? g_object_ref_sink (_tmp1_) : _tmp1_;
	docklet = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, PLANK_TYPE_DOCKLET, PlankDocklet);
	_tmp3_ = docklet;
	_tmp4_ = plank_docklet_get_id (_tmp3_);
	id = _tmp4_;
	_tmp5_ = id;
	g_message ("DockletManager.vala:107: Docklet '%s' registered", _tmp5_);
	_tmp6_ = self->priv->docklets;
	_tmp7_ = id;
	_tmp8_ = docklet;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp6_, _tmp7_, _tmp8_);
	_tmp9_ = docklet;
	g_signal_emit (self, plank_docklet_manager_signals[PLANK_DOCKLET_MANAGER_DOCKLET_ADDED_SIGNAL], 0, _tmp9_);
	_g_object_unref0 (docklet);
}

/**
 * Find docklet for given id
 *
 * @param id a unique id
 * @return a docklet or null
 */
PlankDocklet*
plank_docklet_manager_get_docklet_by_id (PlankDockletManager* self,
                                         const gchar* id)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	PlankDocklet* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = self->priv->docklets;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, id);
	result = (PlankDocklet*) _tmp1_;
	return result;
}

/**
 * Find docklet wich supports given uri
 *
 * @param uri an URI
 * @return a docklet or null
 */
static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		PlankDockletManager* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->docklet);
		_g_free0 (_data4_->uri);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
__lambda15_ (Block4Data* _data4_,
             const gchar* k,
             PlankDocklet* v)
{
	PlankDockletManager* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	self = _data4_->self;
	g_return_val_if_fail (k != NULL, FALSE);
	g_return_val_if_fail (v != NULL, FALSE);
	_tmp0_ = g_strdup_printf ("%s%s", PLANK_DOCKLET_URI_PREFIX, k);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strcmp0 (_data4_->uri, _tmp1_) == 0;
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		PlankDocklet* _tmp3_;
		_tmp3_ = _g_object_ref0 (v);
		_g_object_unref0 (_data4_->docklet);
		_data4_->docklet = _tmp3_;
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

static gboolean
___lambda15__gee_forall_map_func (gconstpointer k,
                                  gconstpointer v,
                                  gpointer self)
{
	gboolean result;
	result = __lambda15_ (self, (const gchar*) k, (PlankDocklet*) v);
	return result;
}

PlankDocklet*
plank_docklet_manager_get_docklet_by_uri (PlankDockletManager* self,
                                          const gchar* uri)
{
	Block4Data* _data4_;
	gchar* _tmp0_;
	GeeMapIterator* it = NULL;
	GeeHashMap* _tmp1_;
	GeeMapIterator* _tmp2_;
	PlankDocklet* _tmp3_;
	PlankDocklet* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = g_strdup (uri);
	_g_free0 (_data4_->uri);
	_data4_->uri = _tmp0_;
	_data4_->docklet = NULL;
	_tmp1_ = self->priv->docklets;
	_tmp2_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp1_);
	it = _tmp2_;
	gee_map_iterator_foreach (it, ___lambda15__gee_forall_map_func, _data4_);
	_tmp3_ = _g_object_ref0 (_data4_->docklet);
	result = _tmp3_;
	_g_object_unref0 (it);
	block4_data_unref (_data4_);
	_data4_ = NULL;
	return result;
}

/**
 * Get list of all registered docklets
 *
 * @return a list of all registered docklets
 */
GeeCollection*
plank_docklet_manager_list_docklets (PlankDockletManager* self)
{
	GeeHashMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->docklets;
	_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
plank_docklet_manager_load_modules_from_dir (PlankDockletManager* self,
                                             GFile* dir)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* attributes = NULL;
	gchar* _tmp27_;
	gchar* _tmp28_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dir != NULL);
	if (!g_file_query_exists (dir, NULL)) {
		return;
	}
	_tmp0_ = g_file_get_path (dir);
	_tmp1_ = _tmp0_;
	plank_logger_verbose ("Searching for modules in folder '%s'", _tmp1_, NULL);
	_g_free0 (_tmp1_);
	attributes = G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE;
	{
		GFileEnumerator* enumerator = NULL;
		const gchar* _tmp2_;
		GFileEnumerator* _tmp3_;
		GFileInfo* info = NULL;
		_tmp2_ = attributes;
		_tmp3_ = g_file_enumerate_children (dir, _tmp2_, 0, NULL, &_inner_error0_);
		enumerator = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		while (TRUE) {
			GFileInfo* _tmp4_ = NULL;
			GFileEnumerator* _tmp5_;
			GFileInfo* _tmp6_;
			GFileInfo* _tmp7_;
			GFileInfo* _tmp8_;
			const gchar* name = NULL;
			GFileInfo* _tmp9_;
			const gchar* _tmp10_;
			GFile* file = NULL;
			const gchar* _tmp11_;
			GFile* _tmp12_;
			gboolean _tmp13_ = FALSE;
			GFileInfo* _tmp14_;
			const gchar* _tmp15_;
			_tmp5_ = enumerator;
			_tmp6_ = g_file_enumerator_next_file (_tmp5_, NULL, &_inner_error0_);
			_tmp4_ = _tmp6_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (info);
				_g_object_unref0 (enumerator);
				goto __catch0_g_error;
			}
			_tmp7_ = _tmp4_;
			_tmp4_ = NULL;
			_g_object_unref0 (info);
			info = _tmp7_;
			_tmp8_ = info;
			if (!(_tmp8_ != NULL)) {
				_g_object_unref0 (_tmp4_);
				break;
			}
			_tmp9_ = info;
			_tmp10_ = g_file_info_get_name (_tmp9_);
			name = _tmp10_;
			_tmp11_ = name;
			_tmp12_ = g_file_get_child (dir, _tmp11_);
			file = _tmp12_;
			_tmp14_ = info;
			_tmp15_ = g_file_info_get_content_type (_tmp14_);
			if (g_strcmp0 (_tmp15_, "application/x-sharedlib") == 0) {
				GRegex* _tmp16_;
				const gchar* _tmp17_;
				_tmp16_ = plank_docklet_manager_docklet_filename_regex;
				_tmp17_ = name;
				_tmp13_ = g_regex_match (_tmp16_, _tmp17_, 0, NULL);
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				GFile* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				_tmp18_ = file;
				_tmp19_ = g_file_get_path (_tmp18_);
				_tmp20_ = _tmp19_;
				plank_docklet_manager_load_module_from_file (self, _tmp20_);
				_g_free0 (_tmp20_);
			} else {
				GFileInfo* _tmp21_;
				_tmp21_ = info;
				if (g_file_info_get_file_type (_tmp21_) == G_FILE_TYPE_DIRECTORY) {
					GFile* _tmp22_;
					_tmp22_ = file;
					plank_docklet_manager_load_modules_from_dir (self, _tmp22_);
				}
			}
			_g_object_unref0 (file);
			_g_object_unref0 (_tmp4_);
		}
		_g_object_unref0 (info);
		_g_object_unref0 (enumerator);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		gchar* _tmp23_;
		gchar* _tmp24_;
		GError* _tmp25_;
		const gchar* _tmp26_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp23_ = g_file_get_path (dir);
		_tmp24_ = _tmp23_;
		_tmp25_ = _error_;
		_tmp26_ = _tmp25_->message;
		g_critical ("DockletManager.vala:179: Error listing contents of folder '%s': %s", _tmp24_, _tmp26_);
		_g_free0 (_tmp24_);
		_g_error_free0 (_error_);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp27_ = g_file_get_path (dir);
	_tmp28_ = _tmp27_;
	plank_logger_verbose ("Finished searching for modules in folder '%s'", _tmp28_, NULL);
	_g_free0 (_tmp28_);
}

static void
plank_docklet_manager_load_module_from_file (PlankDockletManager* self,
                                             const gchar* file_path)
{
	GModule* module = NULL;
	GModule* _tmp0_;
	GModule* _tmp1_;
	void* function = NULL;
	GModule* _tmp3_;
	void* _tmp4_ = NULL;
	gboolean _tmp5_;
	PlankDockletInitFunc module_init = NULL;
	void* _tmp7_;
	gpointer module_init_target;
	PlankDockletInitFunc _tmp8_;
	gpointer _tmp8__target;
	GModule* _tmp9_;
	const gchar* _tmp10_;
	GModule* _tmp11_;
	PlankDockletInitFunc _tmp12_;
	gpointer _tmp12__target;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file_path != NULL);
	_tmp0_ = g_module_open (file_path, G_MODULE_BIND_LOCAL);
	module = _tmp0_;
	_tmp1_ = module;
	if (_tmp1_ == NULL) {
		const gchar* _tmp2_;
		_tmp2_ = g_module_error ();
		g_warning ("DockletManager.vala:190: Failed to load module '%s': %s", file_path, _tmp2_);
		_g_module_close0 (module);
		return;
	}
	_tmp3_ = module;
	_tmp5_ = g_module_symbol (_tmp3_, PLANK_DOCKLET_ENTRY_POINT, &_tmp4_);
	function = _tmp4_;
	if (!_tmp5_) {
		const gchar* _tmp6_;
		_tmp6_ = g_module_error ();
		g_warning ("DockletManager.vala:197: Failed to find entry point function '%s' in '" \
"%s': %s", PLANK_DOCKLET_ENTRY_POINT, file_path, _tmp6_);
		_g_module_close0 (module);
		return;
	}
	_tmp7_ = function;
	module_init = (PlankDockletInitFunc) _tmp7_;
	module_init_target = NULL;
	_tmp8_ = module_init;
	_tmp8__target = module_init_target;
	_vala_assert (_tmp8_ != NULL, "module_init != null");
	_tmp9_ = module;
	_tmp10_ = g_module_name (_tmp9_);
	g_debug ("DockletManager.vala:204: Loading module '%s'", _tmp10_);
	_tmp11_ = module;
	g_module_make_resident (_tmp11_);
	_tmp12_ = module_init;
	_tmp12__target = module_init_target;
	_tmp12_ (self, _tmp12__target);
	_g_module_close0 (module);
}

static GObject *
plank_docklet_manager_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PlankDockletManager * self;
	GeeHashMap* _tmp0_;
	parent_class = G_OBJECT_CLASS (plank_docklet_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_DOCKLET_MANAGER, PlankDockletManager);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, PLANK_TYPE_DOCKLET, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->docklets);
	self->priv->docklets = _tmp0_;
	return obj;
}

static void
plank_docklet_manager_class_init (PlankDockletManagerClass * klass,
                                  gpointer klass_data)
{
	GRegex* _tmp0_;
	plank_docklet_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PlankDockletManager_private_offset);
	G_OBJECT_CLASS (klass)->constructor = plank_docklet_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = plank_docklet_manager_finalize;
	plank_docklet_manager_signals[PLANK_DOCKLET_MANAGER_DOCKLET_ADDED_SIGNAL] = g_signal_new ("docklet-added", PLANK_TYPE_DOCKLET_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, PLANK_TYPE_DOCKLET);
	_tmp0_ = _g_regex_ref0 (_thread_safe_regex_init (&_tmp_regex_0, "^libdocklet-.+.so$", 0));
	plank_docklet_manager_docklet_filename_regex = _tmp0_;
}

static void
plank_docklet_manager_instance_init (PlankDockletManager * self,
                                     gpointer klass)
{
	self->priv = plank_docklet_manager_get_instance_private (self);
}

static void
plank_docklet_manager_finalize (GObject * obj)
{
	PlankDockletManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_DOCKLET_MANAGER, PlankDockletManager);
	_g_object_unref0 (self->priv->docklets);
	G_OBJECT_CLASS (plank_docklet_manager_parent_class)->finalize (obj);
}

/**
 * A controller class for managing all available docklets.
 */
static GType
plank_docklet_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankDockletManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_docklet_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankDockletManager), 0, (GInstanceInitFunc) plank_docklet_manager_instance_init, NULL };
	GType plank_docklet_manager_type_id;
	plank_docklet_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "PlankDockletManager", &g_define_type_info, 0);
	PlankDockletManager_private_offset = g_type_add_instance_private (plank_docklet_manager_type_id, sizeof (PlankDockletManagerPrivate));
	return plank_docklet_manager_type_id;
}

GType
plank_docklet_manager_get_type (void)
{
	static volatile gsize plank_docklet_manager_type_id__once = 0;
	if (g_once_init_enter (&plank_docklet_manager_type_id__once)) {
		GType plank_docklet_manager_type_id;
		plank_docklet_manager_type_id = plank_docklet_manager_get_type_once ();
		g_once_init_leave (&plank_docklet_manager_type_id__once, plank_docklet_manager_type_id);
	}
	return plank_docklet_manager_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

