/* HideManager.c generated by valac 0.56.17, the Vala compiler
 * generated from HideManager.vala, do not modify */

/**/
/*  Copyright (C) 2011-2012 Robert Dyer, Rico Tzschichholz*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "plank.h"
#include <glib.h>
#include <gdk/gdk.h>
#include <X11/extensions/Xfixes.h>
#include <float.h>
#include <math.h>
#include <libwnck/libwnck.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <cairo-gobject.h>
#include <stdlib.h>
#include <string.h>
#include <X11/extensions/XI2.h>
#include <X11/extensions/XInput2.h>
#include "unistd.h"

#define PLANK_HIDE_MANAGER_UPDATE_TIMEOUT 200U
#define PLANK_HIDE_MANAGER_PRESSURE_THRESHOLD 60.0
#define PLANK_HIDE_MANAGER_PRESSURE_TIMEOUT 1000U
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PLANK_HIDE_MANAGER_0_PROPERTY,
	PLANK_HIDE_MANAGER_CONTROLLER_PROPERTY,
	PLANK_HIDE_MANAGER_HIDDEN_PROPERTY,
	PLANK_HIDE_MANAGER_DISABLED_PROPERTY,
	PLANK_HIDE_MANAGER_HOVERED_PROPERTY,
	PLANK_HIDE_MANAGER_NUM_PROPERTIES
};
static GParamSpec* plank_hide_manager_properties[PLANK_HIDE_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PlankHideManagerPrivate {
	PlankDockController* _controller;
	gboolean _Hidden;
	gboolean _Disabled;
	gboolean _Hovered;
	guint hide_timer_id;
	guint unhide_timer_id;
	guint prefs_changed_timer_id;
	guint geometry_timer_id;
	guint window_changed_timer_id;
	gboolean pointer_update;
	gboolean window_intersect;
	gboolean active_window_intersect;
	gboolean active_application_intersect;
	gboolean active_maximized_window_intersect;
	gboolean dialog_windows_intersect;
	GdkRectangle last_window_rect;
	PointerBarrier barrier;
	gint opcode;
	gdouble pressure;
	guint pressure_timer_id;
	gboolean barriers_supported;
};

static gint PlankHideManager_private_offset;
static gpointer plank_hide_manager_parent_class = NULL;
static gint plank_hide_manager_plank_pid;
static gint plank_hide_manager_plank_pid = 0;

static PlankDockController* plank_hide_manager_get_controller (PlankHideManager* self);
static void plank_hide_manager_prefs_changed (PlankHideManager* self,
                                       GObject* prefs,
                                       GParamSpec* prop);
static void _plank_hide_manager_prefs_changed_g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self);
static gboolean plank_hide_manager_handle_enter_notify_event (GtkWidget* widget,
                                                       GdkEventCrossing* event,
                                                       PlankHideManager* self);
static gboolean _plank_hide_manager_handle_enter_notify_event_gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                                                      GdkEventCrossing* event,
                                                                                      gpointer self);
static gboolean plank_hide_manager_handle_leave_notify_event (GtkWidget* widget,
                                                       GdkEventCrossing* event,
                                                       PlankHideManager* self);
static gboolean _plank_hide_manager_handle_leave_notify_event_gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                                                      GdkEventCrossing* event,
                                                                                      gpointer self);
static void plank_hide_manager_schedule_update (PlankHideManager* self);
static void _plank_hide_manager_schedule_update_wnck_screen_window_opened (WnckScreen* _sender,
                                                                    WnckWindow* window,
                                                                    gpointer self);
static void _plank_hide_manager_schedule_update_wnck_screen_window_closed (WnckScreen* _sender,
                                                                    WnckWindow* window,
                                                                    gpointer self);
static void plank_hide_manager_handle_active_window_changed (WnckScreen* screen,
                                                      WnckWindow* previous,
                                                      PlankHideManager* self);
static void _plank_hide_manager_handle_active_window_changed_wnck_screen_active_window_changed (WnckScreen* _sender,
                                                                                         WnckWindow* previous_window,
                                                                                         gpointer self);
static void plank_hide_manager_handle_workspace_changed (WnckScreen* screen,
                                                  WnckWorkspace* previous,
                                                  PlankHideManager* self);
static void _plank_hide_manager_handle_workspace_changed_wnck_screen_active_workspace_changed (WnckScreen* _sender,
                                                                                        WnckWorkspace* previous_workspace,
                                                                                        gpointer self);
static void plank_hide_manager_stop_timers (PlankHideManager* self);
static GdkFilterReturn plank_hide_manager_xevent_filter (GdkXEvent* gdk_xevent,
                                                  GdkEvent* gdk_event,
                                                  PlankHideManager* self);
static void plank_hide_manager_initialize_barriers_support (PlankHideManager* self);
static void plank_hide_manager_setup_active_window (PlankHideManager* self,
                                             WnckScreen* screen);
static void plank_hide_manager_set_Hovered (PlankHideManager* self,
                                     gboolean value);
static void plank_hide_manager_set_Disabled (PlankHideManager* self,
                                      gboolean value);
static void plank_hide_manager_update_hidden (PlankHideManager* self);
static gboolean ___lambda50_ (PlankHideManager* self);
static void plank_hide_manager_update_window_intersect (PlankHideManager* self);
static gboolean ____lambda50__gsource_func (gpointer self);
static void plank_hide_manager_set_Hidden (PlankHideManager* self,
                                    gboolean value);
static void plank_hide_manager_show (PlankHideManager* self);
static void plank_hide_manager_hide (PlankHideManager* self);
static gboolean __lambda12_ (PlankHideManager* self);
static gboolean ___lambda12__gsource_func (gpointer self);
static gboolean __lambda11_ (PlankHideManager* self);
static gboolean ___lambda11__gsource_func (gpointer self);
static inline gboolean plank_hide_manager_device_supports_pressure (PlankHideManager* self,
                                                      GdkDevice* device);
static void plank_hide_manager_window_geometry (WnckWindow* window,
                                         GdkRectangle* result);
static gboolean __lambda48_ (PlankHideManager* self);
static gboolean ___lambda48__gsource_func (gpointer self);
static void plank_hide_manager_handle_geometry_changed (WnckWindow* window,
                                                 PlankHideManager* self);
static void _plank_hide_manager_handle_geometry_changed_wnck_window_geometry_changed (WnckWindow* _sender,
                                                                               gpointer self);
static void plank_hide_manager_handle_state_changed (WnckWindow* window,
                                              WnckWindowState changed_mask,
                                              WnckWindowState new_state,
                                              PlankHideManager* self);
static void _plank_hide_manager_handle_state_changed_wnck_window_state_changed (WnckWindow* _sender,
                                                                         WnckWindowState changed_mask,
                                                                         WnckWindowState new_state,
                                                                         gpointer self);
static gboolean _cairo_rectangle_int_equal (const cairo_rectangle_int_t * s1,
                                     const cairo_rectangle_int_t * s2);
static gboolean __lambda49_ (PlankHideManager* self);
static gboolean ___lambda49__gsource_func (gpointer self);
static gboolean ____lambda13_ (PlankHideManager* self);
static gboolean _____lambda13__gsource_func (gpointer self);
static void xinput_event_mask_destroy (XIEventMask * self);
static GObject * plank_hide_manager_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static void plank_hide_manager_finalize (GObject * obj);
static GType plank_hide_manager_get_type_once (void);
static void _vala_plank_hide_manager_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_plank_hide_manager_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);

/**
 * If/How the dock should hide itself.
 */
static GType
plank_hide_type_get_type_once (void)
{
	static const GEnumValue values[] = {{PLANK_HIDE_TYPE_NONE, "PLANK_HIDE_TYPE_NONE", "none"}, {PLANK_HIDE_TYPE_INTELLIGENT, "PLANK_HIDE_TYPE_INTELLIGENT", "intelligent"}, {PLANK_HIDE_TYPE_AUTO, "PLANK_HIDE_TYPE_AUTO", "auto"}, {PLANK_HIDE_TYPE_DODGE_MAXIMIZED, "PLANK_HIDE_TYPE_DODGE_MAXIMIZED", "dodge-maximized"}, {PLANK_HIDE_TYPE_WINDOW_DODGE, "PLANK_HIDE_TYPE_WINDOW_DODGE", "window-dodge"}, {PLANK_HIDE_TYPE_DODGE_ACTIVE, "PLANK_HIDE_TYPE_DODGE_ACTIVE", "dodge-active"}, {0, NULL, NULL}};
	GType plank_hide_type_type_id;
	plank_hide_type_type_id = g_enum_register_static ("PlankHideType", values);
	return plank_hide_type_type_id;
}

GType
plank_hide_type_get_type (void)
{
	static volatile gsize plank_hide_type_type_id__once = 0;
	if (g_once_init_enter (&plank_hide_type_type_id__once)) {
		GType plank_hide_type_type_id;
		plank_hide_type_type_id = plank_hide_type_get_type_once ();
		g_once_init_leave (&plank_hide_type_type_id__once, plank_hide_type_type_id);
	}
	return plank_hide_type_type_id__once;
}

static inline gpointer
plank_hide_manager_get_instance_private (PlankHideManager* self)
{
	return G_STRUCT_MEMBER_P (self, PlankHideManager_private_offset);
}

static void
_plank_hide_manager_prefs_changed_g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self)
{
	plank_hide_manager_prefs_changed ((PlankHideManager*) self, _sender, pspec);
}

static gboolean
_plank_hide_manager_handle_enter_notify_event_gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                                             GdkEventCrossing* event,
                                                                             gpointer self)
{
	gboolean result;
	result = plank_hide_manager_handle_enter_notify_event (_sender, event, (PlankHideManager*) self);
	return result;
}

static gboolean
_plank_hide_manager_handle_leave_notify_event_gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                                             GdkEventCrossing* event,
                                                                             gpointer self)
{
	gboolean result;
	result = plank_hide_manager_handle_leave_notify_event (_sender, event, (PlankHideManager*) self);
	return result;
}

static void
_plank_hide_manager_schedule_update_wnck_screen_window_opened (WnckScreen* _sender,
                                                               WnckWindow* window,
                                                               gpointer self)
{
	plank_hide_manager_schedule_update ((PlankHideManager*) self);
}

static void
_plank_hide_manager_schedule_update_wnck_screen_window_closed (WnckScreen* _sender,
                                                               WnckWindow* window,
                                                               gpointer self)
{
	plank_hide_manager_schedule_update ((PlankHideManager*) self);
}

static void
_plank_hide_manager_handle_active_window_changed_wnck_screen_active_window_changed (WnckScreen* _sender,
                                                                                    WnckWindow* previous_window,
                                                                                    gpointer self)
{
	plank_hide_manager_handle_active_window_changed (_sender, previous_window, (PlankHideManager*) self);
}

static void
_plank_hide_manager_handle_workspace_changed_wnck_screen_active_workspace_changed (WnckScreen* _sender,
                                                                                   WnckWorkspace* previous_workspace,
                                                                                   gpointer self)
{
	plank_hide_manager_handle_workspace_changed (_sender, previous_workspace, (PlankHideManager*) self);
}

/**
 * Creates a new instance of a HideManager, which handles
 * checking if a dock should hide or not.
 *
 * @param controller the {@link DockController} to manage hiding for
 */
PlankHideManager*
plank_hide_manager_construct (GType object_type,
                              PlankDockController* controller)
{
	PlankHideManager * self = NULL;
	g_return_val_if_fail (controller != NULL, NULL);
	self = (PlankHideManager*) g_object_new (object_type, "controller", controller, NULL);
	return self;
}

PlankHideManager*
plank_hide_manager_new (PlankDockController* controller)
{
	return plank_hide_manager_construct (PLANK_TYPE_HIDE_MANAGER, controller);
}

/**
 * Initializes the hide manager.  Call after the DockWindow is constructed.
 */
void
plank_hide_manager_initialize (PlankHideManager* self)
{
	PlankDockController* _tmp0_;
	PlankDockWindow* _tmp1_;
	PlankDockWindow* _tmp2_;
	PlankDockWindow* window = NULL;
	PlankDockController* _tmp3_;
	PlankDockWindow* _tmp4_;
	PlankDockWindow* _tmp5_;
	WnckScreen* wnck_screen = NULL;
	WnckScreen* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_window (_tmp0_);
	_tmp2_ = _tmp1_;
	_vala_return_if_fail (_tmp2_ != NULL, "controller.window != null");
	_tmp3_ = self->priv->_controller;
	_tmp4_ = plank_dock_controller_get_window (_tmp3_);
	_tmp5_ = _tmp4_;
	window = _tmp5_;
	_tmp6_ = wnck_screen_get_default ();
	wnck_screen = _tmp6_;
	plank_hide_manager_initialize_barriers_support (self);
	g_signal_connect_object ((GtkWidget*) window, "enter-notify-event", (GCallback) _plank_hide_manager_handle_enter_notify_event_gtk_widget_enter_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) window, "leave-notify-event", (GCallback) _plank_hide_manager_handle_leave_notify_event_gtk_widget_leave_notify_event, self, 0);
	g_signal_connect_object (wnck_screen, "window-opened", (GCallback) _plank_hide_manager_schedule_update_wnck_screen_window_opened, self, G_CONNECT_AFTER);
	g_signal_connect_object (wnck_screen, "window-closed", (GCallback) _plank_hide_manager_schedule_update_wnck_screen_window_closed, self, G_CONNECT_AFTER);
	g_signal_connect_object (wnck_screen, "active-window-changed", (GCallback) _plank_hide_manager_handle_active_window_changed_wnck_screen_active_window_changed, self, G_CONNECT_AFTER);
	g_signal_connect_object (wnck_screen, "active-workspace-changed", (GCallback) _plank_hide_manager_handle_workspace_changed_wnck_screen_active_workspace_changed, self, G_CONNECT_AFTER);
	plank_hide_manager_setup_active_window (self, wnck_screen);
}

/**
 * Checks to see if the dock is being hovered by the mouse cursor.
 */
void
plank_hide_manager_update_hovered (PlankHideManager* self)
{
	PlankPositionManager* position_manager = NULL;
	PlankDockController* _tmp0_;
	PlankPositionManager* _tmp1_;
	PlankPositionManager* _tmp2_;
	PlankDockWindow* window = NULL;
	PlankDockController* _tmp3_;
	PlankDockWindow* _tmp4_;
	PlankDockWindow* _tmp5_;
	gint x = 0;
	gint y = 0;
	GdkDisplay* _tmp6_;
	GdkDeviceManager* _tmp7_;
	GdkDevice* _tmp8_;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	GdkRectangle win_rect = {0};
	GdkRectangle _tmp11_ = {0};
	GdkRectangle _tmp12_;
	GdkRectangle _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_position_manager (_tmp0_);
	_tmp2_ = _tmp1_;
	position_manager = _tmp2_;
	_tmp3_ = self->priv->_controller;
	_tmp4_ = plank_dock_controller_get_window (_tmp3_);
	_tmp5_ = _tmp4_;
	window = _tmp5_;
	_tmp6_ = gtk_widget_get_display ((GtkWidget*) window);
	_tmp7_ = gdk_display_get_device_manager (_tmp6_);
	_tmp8_ = gdk_device_manager_get_client_pointer (_tmp7_);
	gdk_device_get_position (_tmp8_, NULL, &_tmp9_, &_tmp10_);
	x = _tmp9_;
	y = _tmp10_;
	plank_position_manager_get_dock_window_region (position_manager, &_tmp11_);
	win_rect = _tmp11_;
	_tmp12_ = win_rect;
	x -= _tmp12_.x;
	_tmp13_ = win_rect;
	y -= _tmp13_.y;
	plank_hide_manager_update_hovered_with_coords (self, x, y);
}

/**
 * Checks to see if the dock is being hovered by the mouse cursor.
 *
 * @param x the x coordinate of the pointer relative to the dock window
 * @param y the y coordinate of the pointer relative to the dock window
 */
void
plank_hide_manager_update_hovered_with_coords (PlankHideManager* self,
                                               gint x,
                                               gint y)
{
	PlankPositionManager* position_manager = NULL;
	PlankDockController* _tmp0_;
	PlankPositionManager* _tmp1_;
	PlankPositionManager* _tmp2_;
	PlankDockWindow* window = NULL;
	PlankDockController* _tmp3_;
	PlankDockWindow* _tmp4_;
	PlankDockWindow* _tmp5_;
	PlankDragManager* drag_manager = NULL;
	PlankDockController* _tmp6_;
	PlankDragManager* _tmp7_;
	PlankDragManager* _tmp8_;
	gboolean update_needed = FALSE;
	GdkRectangle dock_rect = {0};
	PlankPositionManager* _tmp9_;
	GdkRectangle _tmp10_ = {0};
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	GdkRectangle _tmp14_;
	gboolean hovered = FALSE;
	gboolean _tmp20_;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	PlankDockWindow* _tmp23_;
	gboolean disabled = FALSE;
	gboolean _tmp30_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_position_manager (_tmp0_);
	_tmp2_ = _tmp1_;
	position_manager = _tmp2_;
	_tmp3_ = self->priv->_controller;
	_tmp4_ = plank_dock_controller_get_window (_tmp3_);
	_tmp5_ = _tmp4_;
	window = _tmp5_;
	_tmp6_ = self->priv->_controller;
	_tmp7_ = plank_dock_controller_get_drag_manager (_tmp6_);
	_tmp8_ = _tmp7_;
	drag_manager = _tmp8_;
	g_object_freeze_notify ((GObject*) self);
	update_needed = FALSE;
	_tmp9_ = position_manager;
	plank_position_manager_get_cursor_region (_tmp9_, &_tmp10_);
	dock_rect = _tmp10_;
	_tmp14_ = dock_rect;
	if (x >= _tmp14_.x) {
		GdkRectangle _tmp15_;
		GdkRectangle _tmp16_;
		_tmp15_ = dock_rect;
		_tmp16_ = dock_rect;
		_tmp13_ = x < (_tmp15_.x + _tmp16_.width);
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		GdkRectangle _tmp17_;
		_tmp17_ = dock_rect;
		_tmp12_ = y >= _tmp17_.y;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		GdkRectangle _tmp18_;
		GdkRectangle _tmp19_;
		_tmp18_ = dock_rect;
		_tmp19_ = dock_rect;
		_tmp11_ = y < (_tmp18_.y + _tmp19_.height);
	} else {
		_tmp11_ = FALSE;
	}
	hovered = _tmp11_;
	_tmp20_ = self->priv->_Hovered;
	if (_tmp20_ != hovered) {
		plank_hide_manager_set_Hovered (self, hovered);
		update_needed = TRUE;
	}
	_tmp23_ = window;
	if (plank_dock_window_menu_is_visible (_tmp23_)) {
		_tmp22_ = TRUE;
	} else {
		PlankDragManager* _tmp24_;
		gboolean _tmp25_;
		gboolean _tmp26_;
		_tmp24_ = drag_manager;
		_tmp25_ = plank_drag_manager_get_InternalDragActive (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp22_ = _tmp26_;
	}
	if (_tmp22_) {
		_tmp21_ = TRUE;
	} else {
		PlankDragManager* _tmp27_;
		gboolean _tmp28_;
		gboolean _tmp29_;
		_tmp27_ = drag_manager;
		_tmp28_ = plank_drag_manager_get_ExternalDragActive (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp21_ = _tmp29_;
	}
	disabled = _tmp21_;
	_tmp30_ = self->priv->_Disabled;
	if (_tmp30_ != disabled) {
		plank_hide_manager_set_Disabled (self, disabled);
		update_needed = TRUE;
	}
	if (update_needed) {
		plank_hide_manager_update_hidden (self);
	}
	g_object_thaw_notify ((GObject*) self);
}

static gboolean
___lambda50_ (PlankHideManager* self)
{
	gboolean result;
	plank_hide_manager_update_window_intersect (self);
	plank_hide_manager_update_barrier (self);
	self->priv->prefs_changed_timer_id = 0U;
	result = FALSE;
	return result;
}

static gboolean
____lambda50__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda50_ ((PlankHideManager*) self);
	return result;
}

static void
plank_hide_manager_prefs_changed (PlankHideManager* self,
                                  GObject* prefs,
                                  GParamSpec* prop)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (prefs != NULL);
	g_return_if_fail (prop != NULL);
	_tmp0_ = prop->name;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if ((_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("HideMode")))) || (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("Position"))))) {
		switch (0) {
			default:
			{
				if (self->priv->prefs_changed_timer_id > 0U) {
					g_source_remove (self->priv->prefs_changed_timer_id);
					self->priv->prefs_changed_timer_id = 0U;
				}
				self->priv->prefs_changed_timer_id = gdk_threads_add_timeout (PLANK_HIDE_MANAGER_UPDATE_TIMEOUT, ____lambda50__gsource_func, self);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("PressureReveal")))) {
		switch (0) {
			default:
			{
				plank_hide_manager_update_barrier (self);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
}

static void
plank_hide_manager_update_hidden (PlankHideManager* self)
{
	gboolean _tmp0_;
	PlankDockController* _tmp2_;
	PlankDockPreferences* _tmp3_;
	PlankDockPreferences* _tmp4_;
	PlankHideType _tmp5_;
	PlankHideType _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_Disabled;
	if (_tmp0_) {
		gboolean _tmp1_;
		_tmp1_ = self->priv->_Hidden;
		if (_tmp1_) {
			plank_hide_manager_set_Hidden (self, FALSE);
		}
		return;
	}
	_tmp2_ = self->priv->_controller;
	_tmp3_ = plank_dock_controller_get_prefs (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = plank_dock_preferences_get_HideMode (_tmp4_);
	_tmp6_ = _tmp5_;
	switch (_tmp6_) {
		default:
		case PLANK_HIDE_TYPE_NONE:
		{
			plank_hide_manager_show (self);
			break;
		}
		case PLANK_HIDE_TYPE_INTELLIGENT:
		{
			gboolean _tmp7_ = FALSE;
			gboolean _tmp8_;
			_tmp8_ = self->priv->_Hovered;
			if (_tmp8_) {
				_tmp7_ = TRUE;
			} else {
				_tmp7_ = !self->priv->active_application_intersect;
			}
			if (_tmp7_) {
				plank_hide_manager_show (self);
			} else {
				plank_hide_manager_hide (self);
			}
			break;
		}
		case PLANK_HIDE_TYPE_AUTO:
		{
			gboolean _tmp9_;
			_tmp9_ = self->priv->_Hovered;
			if (_tmp9_) {
				plank_hide_manager_show (self);
			} else {
				plank_hide_manager_hide (self);
			}
			break;
		}
		case PLANK_HIDE_TYPE_DODGE_MAXIMIZED:
		{
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_;
			_tmp11_ = self->priv->_Hovered;
			if (_tmp11_) {
				_tmp10_ = TRUE;
			} else {
				gboolean _tmp12_ = FALSE;
				if (self->priv->active_maximized_window_intersect) {
					_tmp12_ = TRUE;
				} else {
					_tmp12_ = self->priv->dialog_windows_intersect;
				}
				_tmp10_ = !_tmp12_;
			}
			if (_tmp10_) {
				plank_hide_manager_show (self);
			} else {
				plank_hide_manager_hide (self);
			}
			break;
		}
		case PLANK_HIDE_TYPE_WINDOW_DODGE:
		{
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_;
			_tmp14_ = self->priv->_Hovered;
			if (_tmp14_) {
				_tmp13_ = TRUE;
			} else {
				_tmp13_ = !self->priv->window_intersect;
			}
			if (_tmp13_) {
				plank_hide_manager_show (self);
			} else {
				plank_hide_manager_hide (self);
			}
			break;
		}
		case PLANK_HIDE_TYPE_DODGE_ACTIVE:
		{
			gboolean _tmp15_ = FALSE;
			gboolean _tmp16_;
			_tmp16_ = self->priv->_Hovered;
			if (_tmp16_) {
				_tmp15_ = TRUE;
			} else {
				_tmp15_ = !self->priv->active_window_intersect;
			}
			if (_tmp15_) {
				plank_hide_manager_show (self);
			} else {
				plank_hide_manager_hide (self);
			}
			break;
		}
	}
	self->priv->pointer_update = TRUE;
}

static gboolean
__lambda12_ (PlankHideManager* self)
{
	gboolean _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->_Hidden;
	if (!_tmp0_) {
		plank_hide_manager_set_Hidden (self, TRUE);
	}
	self->priv->hide_timer_id = 0U;
	result = FALSE;
	return result;
}

static gboolean
___lambda12__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda12_ ((PlankHideManager*) self);
	return result;
}

static void
plank_hide_manager_hide (PlankHideManager* self)
{
	gboolean _tmp0_;
	PlankDockController* _tmp1_;
	PlankDockPreferences* _tmp2_;
	PlankDockPreferences* _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	PlankDockController* _tmp7_;
	PlankDockPreferences* _tmp8_;
	PlankDockPreferences* _tmp9_;
	guint _tmp10_;
	guint _tmp11_;
	g_return_if_fail (self != NULL);
	if (self->priv->unhide_timer_id > 0U) {
		g_source_remove (self->priv->unhide_timer_id);
		self->priv->unhide_timer_id = 0U;
	}
	_tmp0_ = self->priv->_Hidden;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->_controller;
	_tmp2_ = plank_dock_controller_get_prefs (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = plank_dock_preferences_get_HideDelay (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == 0U) {
		gboolean _tmp6_;
		_tmp6_ = self->priv->_Hidden;
		if (!_tmp6_) {
			plank_hide_manager_set_Hidden (self, TRUE);
		}
		return;
	}
	if (self->priv->hide_timer_id > 0U) {
		return;
	}
	_tmp7_ = self->priv->_controller;
	_tmp8_ = plank_dock_controller_get_prefs (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = plank_dock_preferences_get_HideDelay (_tmp9_);
	_tmp11_ = _tmp10_;
	self->priv->hide_timer_id = gdk_threads_add_timeout (_tmp11_, ___lambda12__gsource_func, self);
}

static gboolean
__lambda11_ (PlankHideManager* self)
{
	gboolean _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->_Hidden;
	if (_tmp0_) {
		plank_hide_manager_set_Hidden (self, FALSE);
	}
	self->priv->unhide_timer_id = 0U;
	result = FALSE;
	return result;
}

static gboolean
___lambda11__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda11_ ((PlankHideManager*) self);
	return result;
}

static void
plank_hide_manager_show (PlankHideManager* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_ = FALSE;
	PlankDockController* _tmp8_;
	PlankDockPreferences* _tmp9_;
	PlankDockPreferences* _tmp10_;
	guint _tmp11_;
	guint _tmp12_;
	g_return_if_fail (self != NULL);
	if (self->priv->hide_timer_id > 0U) {
		g_source_remove (self->priv->hide_timer_id);
		self->priv->hide_timer_id = 0U;
	}
	_tmp0_ = self->priv->_Hidden;
	if (!_tmp0_) {
		return;
	}
	if (!self->priv->pointer_update) {
		_tmp1_ = TRUE;
	} else {
		PlankDockController* _tmp2_;
		PlankDockPreferences* _tmp3_;
		PlankDockPreferences* _tmp4_;
		guint _tmp5_;
		guint _tmp6_;
		_tmp2_ = self->priv->_controller;
		_tmp3_ = plank_dock_controller_get_prefs (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = plank_dock_preferences_get_UnhideDelay (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp1_ = _tmp6_ == 0U;
	}
	if (_tmp1_) {
		gboolean _tmp7_;
		_tmp7_ = self->priv->_Hidden;
		if (_tmp7_) {
			plank_hide_manager_set_Hidden (self, FALSE);
		}
		return;
	}
	if (self->priv->unhide_timer_id > 0U) {
		return;
	}
	_tmp8_ = self->priv->_controller;
	_tmp9_ = plank_dock_controller_get_prefs (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = plank_dock_preferences_get_UnhideDelay (_tmp10_);
	_tmp12_ = _tmp11_;
	self->priv->unhide_timer_id = gdk_threads_add_timeout (_tmp12_, ___lambda11__gsource_func, self);
}

static gboolean
plank_hide_manager_handle_enter_notify_event (GtkWidget* widget,
                                              GdkEventCrossing* event,
                                              PlankHideManager* self)
{
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->detail == GDK_NOTIFY_INFERIOR) {
		gboolean _tmp0_;
		_tmp0_ = self->priv->_Hidden;
		result = _tmp0_;
		return result;
	}
	_tmp4_ = self->priv->_Hidden;
	if (_tmp4_) {
		_tmp3_ = self->priv->barriers_supported;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		PlankDockController* _tmp5_;
		PlankDockPreferences* _tmp6_;
		PlankDockPreferences* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp5_ = self->priv->_controller;
		_tmp6_ = plank_dock_controller_get_prefs (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = plank_dock_preferences_get_PressureReveal (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp2_ = _tmp9_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GdkDevice* _tmp10_;
		_tmp10_ = gdk_event_get_source_device ((GdkEvent*) event);
		_tmp1_ = plank_hide_manager_device_supports_pressure (self, _tmp10_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp11_;
		_tmp11_ = self->priv->_Hidden;
		result = _tmp11_;
		return result;
	}
	_tmp12_ = self->priv->_Hovered;
	if (!_tmp12_) {
		plank_hide_manager_update_hovered_with_coords (self, (gint) event->x, (gint) event->y);
	}
	_tmp13_ = self->priv->_Hidden;
	result = _tmp13_;
	return result;
}

static gboolean
plank_hide_manager_handle_leave_notify_event (GtkWidget* widget,
                                              GdkEventCrossing* event,
                                              PlankHideManager* self)
{
	gboolean _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->detail == GDK_NOTIFY_INFERIOR) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	if ((gboolean) event->send_event) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	_tmp0_ = self->priv->_Hovered;
	if (_tmp0_) {
		plank_hide_manager_update_hovered_with_coords (self, -1, -1);
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static inline gboolean
plank_hide_manager_device_supports_pressure (PlankHideManager* self,
                                             GdkDevice* device)
{
	gboolean _tmp0_ = FALSE;
	GdkInputSource _tmp1_;
	GdkInputSource _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (device != NULL, FALSE);
	g_object_get (device, "input-source", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == GDK_SOURCE_MOUSE) {
		_tmp0_ = TRUE;
	} else {
		GdkInputSource _tmp3_;
		GdkInputSource _tmp4_;
		g_object_get (device, "input-source", &_tmp3_, NULL);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == GDK_SOURCE_TOUCHPAD;
	}
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
plank_hide_manager_update_window_intersect (PlankHideManager* self)
{
	GdkRectangle dock_rect = {0};
	PlankDockController* _tmp0_;
	PlankPositionManager* _tmp1_;
	PlankPositionManager* _tmp2_;
	GdkRectangle _tmp3_ = {0};
	gint window_scale_factor = 0;
	PlankDockController* _tmp4_;
	PlankDockWindow* _tmp5_;
	PlankDockWindow* _tmp6_;
	GdkWindow* _tmp7_;
	gboolean intersect = FALSE;
	gboolean dialog_intersect = FALSE;
	gboolean active_intersect = FALSE;
	gboolean new_active_window_intersect = FALSE;
	gboolean active_maximized_intersect = FALSE;
	WnckScreen* screen = NULL;
	WnckScreen* _tmp8_;
	WnckWindow* active_window = NULL;
	WnckScreen* _tmp9_;
	WnckWindow* _tmp10_;
	WnckWorkspace* active_workspace = NULL;
	WnckScreen* _tmp11_;
	WnckWorkspace* _tmp12_;
	gboolean _tmp13_ = FALSE;
	WnckWindow* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_position_manager (_tmp0_);
	_tmp2_ = _tmp1_;
	plank_position_manager_get_static_dock_region (_tmp2_, &_tmp3_);
	dock_rect = _tmp3_;
	_tmp4_ = self->priv->_controller;
	_tmp5_ = plank_dock_controller_get_window (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = gtk_widget_get_window ((GtkWidget*) _tmp6_);
	window_scale_factor = gdk_window_get_scale_factor (_tmp7_);
	if (window_scale_factor > 1) {
		dock_rect.x = dock_rect.x * window_scale_factor;
		dock_rect.y = dock_rect.y * window_scale_factor;
		dock_rect.width = dock_rect.width * window_scale_factor;
		dock_rect.height = dock_rect.height * window_scale_factor;
	}
	intersect = FALSE;
	dialog_intersect = FALSE;
	active_intersect = FALSE;
	new_active_window_intersect = FALSE;
	active_maximized_intersect = FALSE;
	_tmp8_ = wnck_screen_get_default ();
	screen = _tmp8_;
	_tmp9_ = screen;
	_tmp10_ = wnck_screen_get_active_window (_tmp9_);
	active_window = _tmp10_;
	_tmp11_ = screen;
	_tmp12_ = wnck_screen_get_active_workspace (_tmp11_);
	active_workspace = _tmp12_;
	_tmp14_ = active_window;
	if (_tmp14_ != NULL) {
		WnckWorkspace* _tmp15_;
		_tmp15_ = active_workspace;
		_tmp13_ = _tmp15_ != NULL;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		gint active_pid = 0;
		WnckWindow* _tmp16_;
		WnckScreen* _tmp17_;
		GList* _tmp18_;
		_tmp16_ = active_window;
		active_pid = wnck_window_get_pid (_tmp16_);
		_tmp17_ = screen;
		_tmp18_ = wnck_screen_get_windows (_tmp17_);
		{
			GList* w_collection = NULL;
			GList* w_it = NULL;
			w_collection = _tmp18_;
			for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
				WnckWindow* _tmp19_;
				WnckWindow* w = NULL;
				_tmp19_ = _g_object_ref0 ((WnckWindow*) w_it->data);
				w = _tmp19_;
				{
					WnckWindow* _tmp20_;
					WnckWindowType type = 0;
					WnckWindow* _tmp21_;
					gboolean _tmp22_ = FALSE;
					gboolean _tmp23_ = FALSE;
					gboolean _tmp24_ = FALSE;
					WnckWindow* _tmp25_;
					WnckWorkspace* _tmp26_;
					gint pid = 0;
					WnckWindow* _tmp27_;
					WnckWindow* _tmp28_;
					GdkRectangle _tmp29_ = {0};
					GdkRectangle _tmp30_;
					_tmp20_ = w;
					if (wnck_window_is_minimized (_tmp20_)) {
						_g_object_unref0 (w);
						continue;
					}
					_tmp21_ = w;
					type = wnck_window_get_window_type (_tmp21_);
					if (type == WNCK_WINDOW_DESKTOP) {
						_tmp24_ = TRUE;
					} else {
						_tmp24_ = type == WNCK_WINDOW_DOCK;
					}
					if (_tmp24_) {
						_tmp23_ = TRUE;
					} else {
						_tmp23_ = type == WNCK_WINDOW_MENU;
					}
					if (_tmp23_) {
						_tmp22_ = TRUE;
					} else {
						_tmp22_ = type == WNCK_WINDOW_SPLASHSCREEN;
					}
					if (_tmp22_) {
						_g_object_unref0 (w);
						continue;
					}
					_tmp25_ = w;
					_tmp26_ = active_workspace;
					if (!wnck_window_is_visible_on_workspace (_tmp25_, _tmp26_)) {
						_g_object_unref0 (w);
						continue;
					}
					_tmp27_ = w;
					pid = wnck_window_get_pid (_tmp27_);
					if (pid == plank_hide_manager_plank_pid) {
						_g_object_unref0 (w);
						continue;
					}
					_tmp28_ = w;
					plank_hide_manager_window_geometry (_tmp28_, &_tmp29_);
					_tmp30_ = dock_rect;
					if (gdk_rectangle_intersect (&_tmp29_, &_tmp30_, NULL)) {
						gboolean _tmp31_ = FALSE;
						gboolean _tmp34_ = FALSE;
						gboolean _tmp43_ = FALSE;
						gboolean _tmp44_ = FALSE;
						intersect = TRUE;
						if (pid != active_pid) {
							_g_object_unref0 (w);
							continue;
						}
						active_intersect = TRUE;
						if (new_active_window_intersect) {
							_tmp31_ = TRUE;
						} else {
							WnckWindow* _tmp32_;
							WnckWindow* _tmp33_;
							_tmp32_ = active_window;
							_tmp33_ = w;
							_tmp31_ = _tmp32_ == _tmp33_;
						}
						new_active_window_intersect = _tmp31_;
						if (active_maximized_intersect) {
							_tmp34_ = TRUE;
						} else {
							gboolean _tmp35_ = FALSE;
							WnckWindow* _tmp36_;
							WnckWindow* _tmp37_;
							_tmp36_ = active_window;
							_tmp37_ = w;
							if (_tmp36_ == _tmp37_) {
								gboolean _tmp38_ = FALSE;
								gboolean _tmp39_ = FALSE;
								WnckWindow* _tmp40_;
								_tmp40_ = w;
								if (wnck_window_is_maximized (_tmp40_)) {
									_tmp39_ = TRUE;
								} else {
									WnckWindow* _tmp41_;
									_tmp41_ = w;
									_tmp39_ = wnck_window_is_maximized_vertically (_tmp41_);
								}
								if (_tmp39_) {
									_tmp38_ = TRUE;
								} else {
									WnckWindow* _tmp42_;
									_tmp42_ = w;
									_tmp38_ = wnck_window_is_maximized_horizontally (_tmp42_);
								}
								_tmp35_ = _tmp38_;
							} else {
								_tmp35_ = FALSE;
							}
							_tmp34_ = _tmp35_;
						}
						active_maximized_intersect = _tmp34_;
						if (dialog_intersect) {
							_tmp43_ = TRUE;
						} else {
							_tmp43_ = type == WNCK_WINDOW_DIALOG;
						}
						dialog_intersect = _tmp43_;
						if (active_maximized_intersect) {
							_tmp44_ = dialog_intersect;
						} else {
							_tmp44_ = FALSE;
						}
						if (_tmp44_) {
							_g_object_unref0 (w);
							break;
						}
					}
					_g_object_unref0 (w);
				}
			}
		}
	}
	self->priv->window_intersect = intersect;
	self->priv->dialog_windows_intersect = dialog_intersect;
	self->priv->active_application_intersect = active_intersect;
	self->priv->active_window_intersect = new_active_window_intersect;
	self->priv->active_maximized_window_intersect = active_maximized_intersect;
	self->priv->pointer_update = FALSE;
	plank_hide_manager_update_hidden (self);
}

static gboolean
__lambda48_ (PlankHideManager* self)
{
	gboolean result;
	plank_hide_manager_update_window_intersect (self);
	self->priv->window_changed_timer_id = 0U;
	result = FALSE;
	return result;
}

static gboolean
___lambda48__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda48_ ((PlankHideManager*) self);
	return result;
}

static void
plank_hide_manager_schedule_update (PlankHideManager* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->window_changed_timer_id > 0U) {
		return;
	}
	self->priv->window_changed_timer_id = gdk_threads_add_timeout (PLANK_HIDE_MANAGER_UPDATE_TIMEOUT, ___lambda48__gsource_func, self);
}

static void
plank_hide_manager_handle_workspace_changed (WnckScreen* screen,
                                             WnckWorkspace* previous,
                                             PlankHideManager* self)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (screen != NULL);
	plank_hide_manager_schedule_update (self);
}

static void
_plank_hide_manager_handle_geometry_changed_wnck_window_geometry_changed (WnckWindow* _sender,
                                                                          gpointer self)
{
	plank_hide_manager_handle_geometry_changed (_sender, (PlankHideManager*) self);
}

static void
_plank_hide_manager_handle_state_changed_wnck_window_state_changed (WnckWindow* _sender,
                                                                    WnckWindowState changed_mask,
                                                                    WnckWindowState new_state,
                                                                    gpointer self)
{
	plank_hide_manager_handle_state_changed (_sender, changed_mask, new_state, (PlankHideManager*) self);
}

static void
plank_hide_manager_handle_active_window_changed (WnckScreen* screen,
                                                 WnckWindow* previous,
                                                 PlankHideManager* self)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (screen != NULL);
	if (previous != NULL) {
		guint _tmp0_;
		guint _tmp1_;
		g_signal_parse_name ("geometry-changed", wnck_window_get_type (), &_tmp0_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (previous, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _plank_hide_manager_handle_geometry_changed_wnck_window_geometry_changed, self);
		g_signal_parse_name ("state-changed", wnck_window_get_type (), &_tmp1_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (previous, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _plank_hide_manager_handle_state_changed_wnck_window_state_changed, self);
	}
	plank_hide_manager_setup_active_window (self, screen);
}

static void
plank_hide_manager_setup_active_window (PlankHideManager* self,
                                        WnckScreen* screen)
{
	WnckWindow* active_window = NULL;
	WnckWindow* _tmp0_;
	WnckWindow* _tmp1_;
	WnckWindow* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (screen != NULL);
	_tmp0_ = wnck_screen_get_active_window (screen);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	active_window = _tmp1_;
	_tmp2_ = active_window;
	if (_tmp2_ != NULL) {
		WnckWindow* _tmp3_;
		GdkRectangle _tmp4_ = {0};
		WnckWindow* _tmp5_;
		WnckWindow* _tmp6_;
		_tmp3_ = active_window;
		plank_hide_manager_window_geometry (_tmp3_, &_tmp4_);
		self->priv->last_window_rect = _tmp4_;
		_tmp5_ = active_window;
		g_signal_connect_object (_tmp5_, "geometry-changed", (GCallback) _plank_hide_manager_handle_geometry_changed_wnck_window_geometry_changed, self, G_CONNECT_AFTER);
		_tmp6_ = active_window;
		g_signal_connect_object (_tmp6_, "state-changed", (GCallback) _plank_hide_manager_handle_state_changed_wnck_window_state_changed, self, G_CONNECT_AFTER);
	}
	plank_hide_manager_schedule_update (self);
	_g_object_unref0 (active_window);
}

static void
plank_hide_manager_handle_state_changed (WnckWindow* window,
                                         WnckWindowState changed_mask,
                                         WnckWindowState new_state,
                                         PlankHideManager* self)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	if ((changed_mask & WNCK_WINDOW_STATE_MINIMIZED) == 0) {
		return;
	}
	plank_hide_manager_schedule_update (self);
}

static gboolean
_cairo_rectangle_int_equal (const cairo_rectangle_int_t * s1,
                            const cairo_rectangle_int_t * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->x != s2->x) {
		return FALSE;
	}
	if (s1->y != s2->y) {
		return FALSE;
	}
	if (s1->width != s2->width) {
		return FALSE;
	}
	if (s1->height != s2->height) {
		return FALSE;
	}
	return TRUE;
}

static gboolean
__lambda49_ (PlankHideManager* self)
{
	gboolean result;
	plank_hide_manager_update_window_intersect (self);
	self->priv->geometry_timer_id = 0U;
	result = FALSE;
	return result;
}

static gboolean
___lambda49__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda49_ ((PlankHideManager*) self);
	return result;
}

static void
plank_hide_manager_handle_geometry_changed (WnckWindow* window,
                                            PlankHideManager* self)
{
	GdkRectangle geo = {0};
	GdkRectangle _tmp0_ = {0};
	GdkRectangle _tmp1_;
	GdkRectangle _tmp2_;
	GdkRectangle _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	plank_hide_manager_window_geometry (window, &_tmp0_);
	geo = _tmp0_;
	_tmp1_ = geo;
	_tmp2_ = self->priv->last_window_rect;
	if (_cairo_rectangle_int_equal (&_tmp1_, &_tmp2_) == TRUE) {
		return;
	}
	_tmp3_ = geo;
	self->priv->last_window_rect = _tmp3_;
	if (self->priv->geometry_timer_id > 0U) {
		return;
	}
	self->priv->geometry_timer_id = gdk_threads_add_timeout (PLANK_HIDE_MANAGER_UPDATE_TIMEOUT, ___lambda49__gsource_func, self);
}

static void
plank_hide_manager_window_geometry (WnckWindow* window,
                                    GdkRectangle* result)
{
	GdkRectangle win_rect = {0};
	GdkRectangle _tmp0_ = {0};
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	g_return_if_fail (window != NULL);
	win_rect = _tmp0_;
	wnck_window_get_geometry (window, &_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_);
	win_rect.x = _tmp1_;
	win_rect.y = _tmp2_;
	win_rect.width = _tmp3_;
	win_rect.height = _tmp4_;
	*result = win_rect;
	return;
}

static void
plank_hide_manager_stop_timers (PlankHideManager* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->geometry_timer_id > 0U) {
		g_source_remove (self->priv->geometry_timer_id);
		self->priv->geometry_timer_id = 0U;
	}
	if (self->priv->window_changed_timer_id > 0U) {
		g_source_remove (self->priv->window_changed_timer_id);
		self->priv->window_changed_timer_id = 0U;
	}
	if (self->priv->prefs_changed_timer_id > 0U) {
		g_source_remove (self->priv->prefs_changed_timer_id);
		self->priv->prefs_changed_timer_id = 0U;
	}
	if (self->priv->hide_timer_id > 0U) {
		g_source_remove (self->priv->hide_timer_id);
		self->priv->hide_timer_id = 0U;
	}
	if (self->priv->unhide_timer_id > 0U) {
		g_source_remove (self->priv->unhide_timer_id);
		self->priv->unhide_timer_id = 0U;
	}
}

static void
plank_hide_manager_initialize_barriers_support (PlankHideManager* self)
{
	GdkX11Display* gdk_display = NULL;
	PlankDockController* _tmp0_;
	PlankDockWindow* _tmp1_;
	PlankDockWindow* _tmp2_;
	GdkDisplay* _tmp3_;
	Display* display = NULL;
	GdkX11Display* _tmp4_;
	Display* _tmp5_;
	gint error_base = 0;
	gint first_event_return = 0;
	Display* _tmp6_;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gboolean _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_window (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_widget_get_display ((GtkWidget*) _tmp2_);
	gdk_display = G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gdk_x11_display_get_type ()) ? ((GdkX11Display*) _tmp3_) : NULL;
	_tmp4_ = gdk_display;
	_tmp5_ = gdk_x11_display_get_xdisplay (_tmp4_);
	display = _tmp5_;
	gdk_window_add_filter (NULL, (GdkFilterFunc) plank_hide_manager_xevent_filter, self);
	_tmp6_ = display;
	_tmp10_ = XQueryExtension (_tmp6_, "XInputExtension", &_tmp7_, &_tmp8_, &_tmp9_);
	self->priv->opcode = _tmp7_;
	first_event_return = _tmp8_;
	error_base = _tmp9_;
	if (!_tmp10_) {
		g_debug ("HideManager.vala:610: Barriers disabled (XInput needed)");
		self->priv->barriers_supported = FALSE;
	} else {
		gint major = 0;
		gint minor = 0;
		gboolean has_xinput = FALSE;
		Display* _tmp11_;
		Status _tmp12_;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		major = 2;
		minor = 3;
		_tmp11_ = display;
		_tmp12_ = XIQueryVersion (_tmp11_, &major, &minor);
		has_xinput = _tmp12_ == ((Status) Success);
		if (has_xinput) {
			_tmp14_ = major >= 2;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			_tmp13_ = minor >= 3;
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			g_message ("HideManager.vala:616: Barriers enabled (XInput %i.%i support)\n", major, minor);
			self->priv->barriers_supported = TRUE;
			gdk_window_add_filter (NULL, (GdkFilterFunc) plank_hide_manager_xevent_filter, self);
		} else {
			g_debug ("HideManager.vala:620: Barriers disabled (XInput %i.%i not sufficient)", major, minor);
			self->priv->barriers_supported = FALSE;
		}
	}
}

/**
 * Event filter method needed to fetch X.Events
 */
static gboolean
____lambda13_ (PlankHideManager* self)
{
	gboolean result;
	self->priv->pressure = 0.0;
	self->priv->pressure_timer_id = 0U;
	result = FALSE;
	return result;
}

static gboolean
_____lambda13__gsource_func (gpointer self)
{
	gboolean result;
	result = ____lambda13_ ((PlankHideManager*) self);
	return result;
}

static GdkFilterReturn
plank_hide_manager_xevent_filter (GdkXEvent* gdk_xevent,
                                  GdkEvent* gdk_event,
                                  PlankHideManager* self)
{
	XEvent* xevent = NULL;
	XGenericEventCookie* xcookie = NULL;
	Display* display = NULL;
	XGenericEventCookie* _tmp0_;
	Display* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	Display* _tmp8_;
	XGenericEventCookie* _tmp9_;
	XIBarrierEvent* barrier_event = NULL;
	XGenericEventCookie* _tmp10_;
	void* _tmp11_;
	XIBarrierEvent* _tmp12_;
	XGenericEventCookie* _tmp15_;
	Display* _tmp26_;
	XIBarrierEvent* _tmp27_;
	XIBarrierEvent* _tmp28_;
	Display* _tmp29_;
	Display* _tmp30_;
	XGenericEventCookie* _tmp31_;
	GdkFilterReturn result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (gdk_xevent != NULL, 0);
	g_return_val_if_fail (gdk_event != NULL, 0);
	xevent = (XEvent*) gdk_xevent;
	xcookie = &(*xevent).xcookie;
	_tmp0_ = xcookie;
	_tmp1_ = (*_tmp0_).display;
	display = _tmp1_;
	if (self->priv->barrier == ((PointerBarrier) 0)) {
		_tmp3_ = TRUE;
	} else {
		XGenericEventCookie* _tmp4_;
		_tmp4_ = xcookie;
		_tmp3_ = (*_tmp4_).extension != self->priv->opcode;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		XGenericEventCookie* _tmp6_;
		_tmp6_ = xcookie;
		if ((*_tmp6_).evtype != ((gint) XI_BarrierHit)) {
			XGenericEventCookie* _tmp7_;
			_tmp7_ = xcookie;
			_tmp5_ = (*_tmp7_).evtype != ((gint) XI_BarrierLeave);
		} else {
			_tmp5_ = FALSE;
		}
		_tmp2_ = _tmp5_;
	}
	if (_tmp2_) {
		result = GDK_FILTER_CONTINUE;
		return result;
	}
	_tmp8_ = display;
	_tmp9_ = xcookie;
	XGetEventData (_tmp8_, _tmp9_);
	_tmp10_ = xcookie;
	_tmp11_ = (*_tmp10_).data;
	barrier_event = (XIBarrierEvent*) _tmp11_;
	_tmp12_ = barrier_event;
	if ((*_tmp12_).barrier != self->priv->barrier) {
		Display* _tmp13_;
		XGenericEventCookie* _tmp14_;
		_tmp13_ = display;
		_tmp14_ = xcookie;
		XFreeEventData (_tmp13_, _tmp14_);
		result = GDK_FILTER_CONTINUE;
		return result;
	}
	_tmp15_ = xcookie;
	switch ((*_tmp15_).evtype) {
		case XI_BarrierHit:
		{
			gdouble slide = 0.0;
			gdouble distance = 0.0;
			PlankDockController* _tmp16_;
			PlankPositionManager* _tmp17_;
			PlankPositionManager* _tmp18_;
			GtkPositionType _tmp19_;
			GtkPositionType _tmp20_;
			slide = 0.0;
			distance = 0.0;
			_tmp16_ = self->priv->_controller;
			_tmp17_ = plank_dock_controller_get_position_manager (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = plank_position_manager_get_Position (_tmp18_);
			_tmp20_ = _tmp19_;
			switch (_tmp20_) {
				default:
				case GTK_POS_BOTTOM:
				case GTK_POS_TOP:
				{
					XIBarrierEvent* _tmp21_;
					XIBarrierEvent* _tmp22_;
					_tmp21_ = barrier_event;
					distance = fabs ((*_tmp21_).dy);
					_tmp22_ = barrier_event;
					slide = fabs ((*_tmp22_).dx);
					break;
				}
				case GTK_POS_LEFT:
				case GTK_POS_RIGHT:
				{
					XIBarrierEvent* _tmp23_;
					XIBarrierEvent* _tmp24_;
					_tmp23_ = barrier_event;
					distance = fabs ((*_tmp23_).dx);
					_tmp24_ = barrier_event;
					slide = fabs ((*_tmp24_).dy);
					break;
				}
			}
			if (slide < distance) {
				distance = fmin (15.0, distance);
				self->priv->pressure = self->priv->pressure + distance;
				plank_logger_verbose ("HideManager (pressure = %f)", self->priv->pressure, NULL);
			}
			if (self->priv->pressure >= PLANK_HIDE_MANAGER_PRESSURE_THRESHOLD) {
				gboolean _tmp25_;
				self->priv->pressure = 0.0;
				if (self->priv->pressure_timer_id > 0U) {
					g_source_remove (self->priv->pressure_timer_id);
					self->priv->pressure_timer_id = 0U;
				}
				plank_logger_verbose ("HideManager (pressure-threshold reached > unhide (%f))", PLANK_HIDE_MANAGER_PRESSURE_THRESHOLD, NULL);
				g_object_freeze_notify ((GObject*) self);
				_tmp25_ = self->priv->_Hovered;
				if (!_tmp25_) {
					plank_hide_manager_set_Hovered (self, TRUE);
					plank_hide_manager_update_hidden (self);
				}
				g_object_thaw_notify ((GObject*) self);
			}
			break;
		}
		case XI_BarrierLeave:
		{
			if (self->priv->pressure_timer_id == 0U) {
				self->priv->pressure_timer_id = gdk_threads_add_timeout (PLANK_HIDE_MANAGER_PRESSURE_TIMEOUT, _____lambda13__gsource_func, self);
			}
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp26_ = display;
	_tmp27_ = barrier_event;
	_tmp28_ = barrier_event;
	XIBarrierReleasePointer (_tmp26_, (*_tmp27_).deviceid, self->priv->barrier, (*_tmp28_).eventid);
	_tmp29_ = display;
	XFlush (_tmp29_);
	_tmp30_ = display;
	_tmp31_ = xcookie;
	XFreeEventData (_tmp30_, _tmp31_);
	result = GDK_FILTER_REMOVE;
	return result;
}

static void
xinput_event_mask_destroy (XIEventMask * self)
{
	(*self).mask = (g_free ((*self).mask), NULL);
}

void
plank_hide_manager_update_barrier (PlankHideManager* self)
{
	GdkX11Display* gdk_display = NULL;
	PlankDockController* _tmp0_;
	PlankDockWindow* _tmp1_;
	PlankDockWindow* _tmp2_;
	GdkDisplay* _tmp3_;
	Display* display = NULL;
	GdkX11Display* _tmp4_;
	Display* _tmp5_;
	PlankDockController* _tmp7_;
	PlankDockPreferences* _tmp8_;
	PlankDockPreferences* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	PlankDockController* _tmp12_;
	PlankDockPreferences* _tmp13_;
	PlankDockPreferences* _tmp14_;
	PlankHideType _tmp15_;
	PlankHideType _tmp16_;
	Window root_xwindow = 0;
	Display* _tmp17_;
	GdkRectangle barrier_area = {0};
	PlankDockController* _tmp18_;
	PlankPositionManager* _tmp19_;
	PlankPositionManager* _tmp20_;
	GdkRectangle _tmp21_ = {0};
	guchar* mask_bits = NULL;
	guchar* _tmp22_;
	gint mask_bits_length1;
	gint _mask_bits_size_;
	XIEventMask mask = {0};
	guchar* _tmp23_;
	gint _tmp23__length1;
	guchar* _tmp24_;
	gint _tmp24__length1;
	XIEventMask _tmp25_ = {0};
	XIEventMask _tmp26_;
	guchar* _tmp27_;
	gint _tmp27__length1;
	XIEventMask _tmp28_;
	guchar* _tmp29_;
	gint _tmp29__length1;
	Display* _tmp30_;
	GdkRectangle _tmp31_;
	GdkRectangle _tmp32_;
	GdkRectangle _tmp33_;
	GdkRectangle _tmp34_;
	GdkRectangle _tmp35_;
	GdkRectangle _tmp36_;
	Display* _tmp37_;
	GdkRectangle _tmp38_;
	GdkRectangle _tmp39_;
	GdkRectangle _tmp40_;
	GdkRectangle _tmp41_;
	GdkRectangle _tmp42_;
	GdkRectangle _tmp43_;
	g_return_if_fail (self != NULL);
	if (!self->priv->barriers_supported) {
		return;
	}
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_window (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_widget_get_display ((GtkWidget*) _tmp2_);
	gdk_display = G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gdk_x11_display_get_type ()) ? ((GdkX11Display*) _tmp3_) : NULL;
	_tmp4_ = gdk_display;
	_tmp5_ = gdk_x11_display_get_xdisplay (_tmp4_);
	display = _tmp5_;
	if (self->priv->barrier > ((PointerBarrier) 0)) {
		Display* _tmp6_;
		_tmp6_ = display;
		XFixesDestroyPointerBarrier (_tmp6_, self->priv->barrier);
		self->priv->barrier = (PointerBarrier) 0;
	}
	_tmp7_ = self->priv->_controller;
	_tmp8_ = plank_dock_controller_get_prefs (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = plank_dock_preferences_get_PressureReveal (_tmp9_);
	_tmp11_ = _tmp10_;
	if (!_tmp11_) {
		return;
	}
	_tmp12_ = self->priv->_controller;
	_tmp13_ = plank_dock_controller_get_prefs (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = plank_dock_preferences_get_HideMode (_tmp14_);
	_tmp16_ = _tmp15_;
	if (_tmp16_ == PLANK_HIDE_TYPE_NONE) {
		return;
	}
	_tmp17_ = display;
	root_xwindow = DefaultRootWindow (_tmp17_);
	_tmp18_ = self->priv->_controller;
	_tmp19_ = plank_dock_controller_get_position_manager (_tmp18_);
	_tmp20_ = _tmp19_;
	plank_position_manager_get_barrier (_tmp20_, &_tmp21_);
	barrier_area = _tmp21_;
	_tmp22_ = g_new0 (guchar, XIMaskLen (XI_LASTEVENT));
	mask_bits = _tmp22_;
	mask_bits_length1 = XIMaskLen (XI_LASTEVENT);
	_mask_bits_size_ = mask_bits_length1;
	_tmp23_ = mask_bits;
	_tmp23__length1 = mask_bits_length1;
	_tmp24_ = mask_bits;
	_tmp24__length1 = mask_bits_length1;
	mask_bits = NULL;
	mask_bits_length1 = 0;
	_tmp25_.deviceid = XIAllMasterDevices;
	_tmp25_.mask_len = (gint) (sizeof (guchar) * _tmp23__length1);
	_tmp25_.mask = (g_free (_tmp25_.mask), NULL);
	_tmp25_.mask = _tmp24_;
	_tmp25_.mask_len = _tmp24__length1;
	mask = _tmp25_;
	_tmp26_ = mask;
	_tmp27_ = _tmp26_.mask;
	_tmp27__length1 = _tmp26_.mask_len;
	XISetMask (_tmp27_, XI_BarrierHit);
	_tmp28_ = mask;
	_tmp29_ = _tmp28_.mask;
	_tmp29__length1 = _tmp28_.mask_len;
	XISetMask (_tmp29_, XI_BarrierLeave);
	_tmp30_ = display;
	XISelectEvents (_tmp30_, root_xwindow, &mask, 1);
	_tmp31_ = barrier_area;
	_tmp32_ = barrier_area;
	_tmp33_ = barrier_area;
	_tmp34_ = barrier_area;
	_tmp35_ = barrier_area;
	_tmp36_ = barrier_area;
	g_debug ("HideManager.vala:744: Barrier: %i,%i - %i,%i\n", _tmp31_.x, _tmp32_.y, _tmp33_.x + _tmp34_.width, _tmp35_.y + _tmp36_.height);
	_tmp37_ = display;
	_tmp38_ = barrier_area;
	_tmp39_ = barrier_area;
	_tmp40_ = barrier_area;
	_tmp41_ = barrier_area;
	_tmp42_ = barrier_area;
	_tmp43_ = barrier_area;
	self->priv->barrier = XFixesCreatePointerBarrier (_tmp37_, root_xwindow, _tmp38_.x, _tmp39_.y, _tmp40_.x + _tmp41_.width, _tmp42_.y + _tmp43_.height, 0, 0, NULL);
	g_warn_if_fail (self->priv->barrier > ((PointerBarrier) 0));
	xinput_event_mask_destroy (&mask);
	mask_bits = (g_free (mask_bits), NULL);
}

static PlankDockController*
plank_hide_manager_get_controller (PlankHideManager* self)
{
	PlankDockController* result;
	PlankDockController* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_controller;
	result = _tmp0_;
	return result;
}

static void
plank_hide_manager_set_controller (PlankHideManager* self,
                                   PlankDockController* value)
{
	PlankDockController* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_hide_manager_get_controller (self);
	if (old_value != value) {
		PlankDockController* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_controller);
		self->priv->_controller = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_hide_manager_properties[PLANK_HIDE_MANAGER_CONTROLLER_PROPERTY]);
	}
}

gboolean
plank_hide_manager_get_Hidden (PlankHideManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_Hidden;
	return result;
}

static void
plank_hide_manager_set_Hidden (PlankHideManager* self,
                               gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_hide_manager_get_Hidden (self);
	if (old_value != value) {
		self->priv->_Hidden = value;
		g_object_notify_by_pspec ((GObject *) self, plank_hide_manager_properties[PLANK_HIDE_MANAGER_HIDDEN_PROPERTY]);
	}
}

gboolean
plank_hide_manager_get_Disabled (PlankHideManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_Disabled;
	return result;
}

static void
plank_hide_manager_set_Disabled (PlankHideManager* self,
                                 gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_hide_manager_get_Disabled (self);
	if (old_value != value) {
		self->priv->_Disabled = value;
		g_object_notify_by_pspec ((GObject *) self, plank_hide_manager_properties[PLANK_HIDE_MANAGER_DISABLED_PROPERTY]);
	}
}

gboolean
plank_hide_manager_get_Hovered (PlankHideManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_Hovered;
	return result;
}

static void
plank_hide_manager_set_Hovered (PlankHideManager* self,
                                gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_hide_manager_get_Hovered (self);
	if (old_value != value) {
		self->priv->_Hovered = value;
		g_object_notify_by_pspec ((GObject *) self, plank_hide_manager_properties[PLANK_HIDE_MANAGER_HOVERED_PROPERTY]);
	}
}

static GObject *
plank_hide_manager_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PlankHideManager * self;
	PlankDockController* _tmp0_;
	PlankDockPreferences* _tmp1_;
	PlankDockPreferences* _tmp2_;
	parent_class = G_OBJECT_CLASS (plank_hide_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_HIDE_MANAGER, PlankHideManager);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_prefs (_tmp0_);
	_tmp2_ = _tmp1_;
	g_signal_connect_object ((GObject*) _tmp2_, "notify", (GCallback) _plank_hide_manager_prefs_changed_g_object_notify, self, 0);
	return obj;
}

static void
plank_hide_manager_class_init (PlankHideManagerClass * klass,
                               gpointer klass_data)
{
	plank_hide_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PlankHideManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_plank_hide_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_plank_hide_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = plank_hide_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = plank_hide_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_HIDE_MANAGER_CONTROLLER_PROPERTY, plank_hide_manager_properties[PLANK_HIDE_MANAGER_CONTROLLER_PROPERTY] = g_param_spec_object ("controller", "controller", "controller", PLANK_TYPE_DOCK_CONTROLLER, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	 * If the dock is currently hidden.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_HIDE_MANAGER_HIDDEN_PROPERTY, plank_hide_manager_properties[PLANK_HIDE_MANAGER_HIDDEN_PROPERTY] = g_param_spec_boolean ("Hidden", "Hidden", "Hidden", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * If hiding the dock is currently disabled
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_HIDE_MANAGER_DISABLED_PROPERTY, plank_hide_manager_properties[PLANK_HIDE_MANAGER_DISABLED_PROPERTY] = g_param_spec_boolean ("Disabled", "Disabled", "Disabled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * If the dock is currently hovered by the mouse cursor.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_HIDE_MANAGER_HOVERED_PROPERTY, plank_hide_manager_properties[PLANK_HIDE_MANAGER_HOVERED_PROPERTY] = g_param_spec_boolean ("Hovered", "Hovered", "Hovered", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	plank_hide_manager_plank_pid = getpid ();
}

static void
plank_hide_manager_instance_init (PlankHideManager * self,
                                  gpointer klass)
{
	self->priv = plank_hide_manager_get_instance_private (self);
	self->priv->_Hidden = TRUE;
	self->priv->_Disabled = FALSE;
	self->priv->_Hovered = FALSE;
	self->priv->hide_timer_id = 0U;
	self->priv->unhide_timer_id = 0U;
	self->priv->prefs_changed_timer_id = 0U;
	self->priv->geometry_timer_id = 0U;
	self->priv->window_changed_timer_id = 0U;
	self->priv->pointer_update = TRUE;
	self->priv->window_intersect = FALSE;
	self->priv->active_window_intersect = FALSE;
	self->priv->active_application_intersect = FALSE;
	self->priv->active_maximized_window_intersect = FALSE;
	self->priv->dialog_windows_intersect = FALSE;
	self->priv->barrier = (PointerBarrier) 0;
	self->priv->opcode = 0;
	self->priv->pressure = 0.0;
	self->priv->pressure_timer_id = 0U;
	self->priv->barriers_supported = FALSE;
}

static void
plank_hide_manager_finalize (GObject * obj)
{
	PlankHideManager * self;
	PlankDockWindow* window = NULL;
	PlankDockController* _tmp0_;
	PlankDockWindow* _tmp1_;
	PlankDockWindow* _tmp2_;
	PlankDragManager* drag_manager = NULL;
	PlankDockController* _tmp3_;
	PlankDragManager* _tmp4_;
	PlankDragManager* _tmp5_;
	WnckScreen* wnck_screen = NULL;
	WnckScreen* _tmp6_;
	PlankDockController* _tmp7_;
	PlankDockPreferences* _tmp8_;
	PlankDockPreferences* _tmp9_;
	guint _tmp10_;
	PlankDockWindow* _tmp11_;
	guint _tmp12_;
	PlankDockWindow* _tmp13_;
	guint _tmp14_;
	WnckScreen* _tmp15_;
	guint _tmp16_;
	WnckScreen* _tmp17_;
	guint _tmp18_;
	WnckScreen* _tmp19_;
	guint _tmp20_;
	WnckScreen* _tmp21_;
	guint _tmp22_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_HIDE_MANAGER, PlankHideManager);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_window (_tmp0_);
	_tmp2_ = _tmp1_;
	window = _tmp2_;
	_tmp3_ = self->priv->_controller;
	_tmp4_ = plank_dock_controller_get_drag_manager (_tmp3_);
	_tmp5_ = _tmp4_;
	drag_manager = _tmp5_;
	_tmp6_ = wnck_screen_get_default ();
	wnck_screen = _tmp6_;
	_tmp7_ = self->priv->_controller;
	_tmp8_ = plank_dock_controller_get_prefs (_tmp7_);
	_tmp9_ = _tmp8_;
	g_signal_parse_name ("notify", G_TYPE_OBJECT, &_tmp10_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp9_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, 0, NULL, (GCallback) _plank_hide_manager_prefs_changed_g_object_notify, self);
	_tmp11_ = window;
	g_signal_parse_name ("enter-notify-event", gtk_widget_get_type (), &_tmp12_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp11_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp12_, 0, NULL, (GCallback) _plank_hide_manager_handle_enter_notify_event_gtk_widget_enter_notify_event, self);
	_tmp13_ = window;
	g_signal_parse_name ("leave-notify-event", gtk_widget_get_type (), &_tmp14_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp13_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp14_, 0, NULL, (GCallback) _plank_hide_manager_handle_leave_notify_event_gtk_widget_leave_notify_event, self);
	_tmp15_ = wnck_screen;
	g_signal_parse_name ("window-opened", wnck_screen_get_type (), &_tmp16_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp15_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp16_, 0, NULL, (GCallback) _plank_hide_manager_schedule_update_wnck_screen_window_opened, self);
	_tmp17_ = wnck_screen;
	g_signal_parse_name ("window-closed", wnck_screen_get_type (), &_tmp18_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp17_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp18_, 0, NULL, (GCallback) _plank_hide_manager_schedule_update_wnck_screen_window_closed, self);
	_tmp19_ = wnck_screen;
	g_signal_parse_name ("active-window-changed", wnck_screen_get_type (), &_tmp20_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp19_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp20_, 0, NULL, (GCallback) _plank_hide_manager_handle_active_window_changed_wnck_screen_active_window_changed, self);
	_tmp21_ = wnck_screen;
	g_signal_parse_name ("active-workspace-changed", wnck_screen_get_type (), &_tmp22_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp21_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp22_, 0, NULL, (GCallback) _plank_hide_manager_handle_workspace_changed_wnck_screen_active_workspace_changed, self);
	plank_hide_manager_stop_timers (self);
	gdk_window_add_filter (NULL, (GdkFilterFunc) plank_hide_manager_xevent_filter, self);
	if (self->priv->barrier != ((PointerBarrier) 0)) {
		GdkX11Display* gdk_display = NULL;
		PlankDockController* _tmp23_;
		PlankDockWindow* _tmp24_;
		PlankDockWindow* _tmp25_;
		GdkDisplay* _tmp26_;
		Display* display = NULL;
		GdkX11Display* _tmp27_;
		Display* _tmp28_;
		Display* _tmp29_;
		_tmp23_ = self->priv->_controller;
		_tmp24_ = plank_dock_controller_get_window (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = gtk_widget_get_display ((GtkWidget*) _tmp25_);
		gdk_display = G_TYPE_CHECK_INSTANCE_TYPE (_tmp26_, gdk_x11_display_get_type ()) ? ((GdkX11Display*) _tmp26_) : NULL;
		_tmp27_ = gdk_display;
		_tmp28_ = gdk_x11_display_get_xdisplay (_tmp27_);
		display = _tmp28_;
		_tmp29_ = display;
		XFixesDestroyPointerBarrier (_tmp29_, self->priv->barrier);
		self->priv->barrier = (PointerBarrier) 0;
	}
	_g_object_unref0 (self->priv->_controller);
	G_OBJECT_CLASS (plank_hide_manager_parent_class)->finalize (obj);
}

/**
 * Handles checking if a dock should hide or not.
 */
static GType
plank_hide_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankHideManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_hide_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankHideManager), 0, (GInstanceInitFunc) plank_hide_manager_instance_init, NULL };
	GType plank_hide_manager_type_id;
	plank_hide_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "PlankHideManager", &g_define_type_info, 0);
	PlankHideManager_private_offset = g_type_add_instance_private (plank_hide_manager_type_id, sizeof (PlankHideManagerPrivate));
	return plank_hide_manager_type_id;
}

GType
plank_hide_manager_get_type (void)
{
	static volatile gsize plank_hide_manager_type_id__once = 0;
	if (g_once_init_enter (&plank_hide_manager_type_id__once)) {
		GType plank_hide_manager_type_id;
		plank_hide_manager_type_id = plank_hide_manager_get_type_once ();
		g_once_init_leave (&plank_hide_manager_type_id__once, plank_hide_manager_type_id);
	}
	return plank_hide_manager_type_id__once;
}

static void
_vala_plank_hide_manager_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	PlankHideManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_HIDE_MANAGER, PlankHideManager);
	switch (property_id) {
		case PLANK_HIDE_MANAGER_CONTROLLER_PROPERTY:
		g_value_set_object (value, plank_hide_manager_get_controller (self));
		break;
		case PLANK_HIDE_MANAGER_HIDDEN_PROPERTY:
		g_value_set_boolean (value, plank_hide_manager_get_Hidden (self));
		break;
		case PLANK_HIDE_MANAGER_DISABLED_PROPERTY:
		g_value_set_boolean (value, plank_hide_manager_get_Disabled (self));
		break;
		case PLANK_HIDE_MANAGER_HOVERED_PROPERTY:
		g_value_set_boolean (value, plank_hide_manager_get_Hovered (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_plank_hide_manager_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	PlankHideManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_HIDE_MANAGER, PlankHideManager);
	switch (property_id) {
		case PLANK_HIDE_MANAGER_CONTROLLER_PROPERTY:
		plank_hide_manager_set_controller (self, g_value_get_object (value));
		break;
		case PLANK_HIDE_MANAGER_HIDDEN_PROPERTY:
		plank_hide_manager_set_Hidden (self, g_value_get_boolean (value));
		break;
		case PLANK_HIDE_MANAGER_DISABLED_PROPERTY:
		plank_hide_manager_set_Disabled (self, g_value_get_boolean (value));
		break;
		case PLANK_HIDE_MANAGER_HOVERED_PROPERTY:
		plank_hide_manager_set_Hovered (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

