/* DockletViewModel.c generated by valac 0.56.17, the Vala compiler
 * generated from DockletViewModel.vala, do not modify */

/**/
/*  Copyright (C) 2015 Rico Tzschichholz*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gobject/gvaluecollector.h>
#include "plank-internal.h"
#include <gtk/gtk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define PLANK_TYPE_DOCKLET_NODE (plank_docklet_node_get_type ())
#define PLANK_DOCKLET_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PLANK_TYPE_DOCKLET_NODE, PlankDockletNode))
#define PLANK_DOCKLET_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PLANK_TYPE_DOCKLET_NODE, PlankDockletNodeClass))
#define PLANK_IS_DOCKLET_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PLANK_TYPE_DOCKLET_NODE))
#define PLANK_IS_DOCKLET_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PLANK_TYPE_DOCKLET_NODE))
#define PLANK_DOCKLET_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PLANK_TYPE_DOCKLET_NODE, PlankDockletNodeClass))

typedef struct _PlankDockletNode PlankDockletNode;
typedef struct _PlankDockletNodeClass PlankDockletNodeClass;
typedef struct _PlankDockletNodePrivate PlankDockletNodePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _PlankParamSpecDockletNode PlankParamSpecDockletNode;
enum  {
	PLANK_DOCKLET_VIEW_MODEL_0_PROPERTY,
	PLANK_DOCKLET_VIEW_MODEL_NUM_PROPERTIES
};
static GParamSpec* plank_docklet_view_model_properties[PLANK_DOCKLET_VIEW_MODEL_NUM_PROPERTIES];
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PlankDockletNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PlankDockletNodePrivate * priv;
	gchar* id;
	gchar* name;
	gchar* description;
	gchar* icon;
	GdkPixbuf* pixbuf;
};

struct _PlankDockletNodeClass {
	GTypeClass parent_class;
	void (*finalize) (PlankDockletNode *self);
};

struct _PlankParamSpecDockletNode {
	GParamSpec parent_instance;
};

struct _PlankDockletViewModelPrivate {
	GPtrArray* data;
	gint stamp;
};

static gpointer plank_docklet_node_parent_class = NULL;
static gint PlankDockletViewModel_private_offset;
static gpointer plank_docklet_view_model_parent_class = NULL;
static GtkTreeModelIface * plank_docklet_view_model_gtk_tree_model_parent_iface = NULL;
static GtkTreeDragSourceIface * plank_docklet_view_model_gtk_tree_drag_source_parent_iface = NULL;

VALA_EXTERN gpointer plank_docklet_node_ref (gpointer instance);
VALA_EXTERN void plank_docklet_node_unref (gpointer instance);
VALA_EXTERN GParamSpec* plank_param_spec_docklet_node (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void plank_value_set_docklet_node (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void plank_value_take_docklet_node (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer plank_value_get_docklet_node (const GValue* value);
VALA_EXTERN GType plank_docklet_node_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PlankDockletNode* plank_docklet_node_new (const gchar* id,
                                          const gchar* name,
                                          const gchar* description,
                                          const gchar* icon,
                                          GdkPixbuf* pixbuf);
VALA_EXTERN PlankDockletNode* plank_docklet_node_construct (GType object_type,
                                                const gchar* id,
                                                const gchar* name,
                                                const gchar* description,
                                                const gchar* icon,
                                                GdkPixbuf* pixbuf);
static void plank_docklet_node_finalize (PlankDockletNode * obj);
static GType plank_docklet_node_get_type_once (void);
static void _plank_docklet_node_unref0_ (gpointer var);
static GType plank_docklet_view_model_real_get_column_type (GtkTreeModel* base,
                                                     gint index);
static GtkTreeModelFlags plank_docklet_view_model_real_get_flags (GtkTreeModel* base);
static void plank_docklet_view_model_real_get_value (GtkTreeModel* base,
                                              GtkTreeIter* iter,
                                              gint column,
                                              GValue* val);
static gboolean plank_docklet_view_model_real_get_iter (GtkTreeModel* base,
                                                 GtkTreeIter* iter,
                                                 GtkTreePath* path);
static gboolean plank_docklet_view_model_invalid_iter (PlankDockletViewModel* self,
                                                GtkTreeIter* iter);
static gint plank_docklet_view_model_real_get_n_columns (GtkTreeModel* base);
static GtkTreePath* plank_docklet_view_model_real_get_path (GtkTreeModel* base,
                                                     GtkTreeIter* iter);
static gint plank_docklet_view_model_real_iter_n_children (GtkTreeModel* base,
                                                    GtkTreeIter* iter);
static gboolean plank_docklet_view_model_real_iter_next (GtkTreeModel* base,
                                                  GtkTreeIter* iter);
static gboolean plank_docklet_view_model_real_iter_previous (GtkTreeModel* base,
                                                      GtkTreeIter* iter);
static gboolean plank_docklet_view_model_real_iter_nth_child (GtkTreeModel* base,
                                                       GtkTreeIter* iter,
                                                       GtkTreeIter* parent,
                                                       gint n);
static gboolean plank_docklet_view_model_real_iter_children (GtkTreeModel* base,
                                                      GtkTreeIter* iter,
                                                      GtkTreeIter* parent);
static gboolean plank_docklet_view_model_real_iter_has_child (GtkTreeModel* base,
                                                       GtkTreeIter* iter);
static gboolean plank_docklet_view_model_real_iter_parent (GtkTreeModel* base,
                                                    GtkTreeIter* iter,
                                                    GtkTreeIter* child);
static gboolean plank_docklet_view_model_real_drag_data_delete (GtkTreeDragSource* base,
                                                         GtkTreePath* path);
static gboolean plank_docklet_view_model_real_drag_data_get (GtkTreeDragSource* base,
                                                      GtkTreePath* path,
                                                      GtkSelectionData* selection_data);
static gboolean plank_docklet_view_model_real_row_draggable (GtkTreeDragSource* base,
                                                      GtkTreePath* path);
static void plank_docklet_view_model_finalize (GObject * obj);
static GType plank_docklet_view_model_get_type_once (void);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

PlankDockletNode*
plank_docklet_node_construct (GType object_type,
                              const gchar* id,
                              const gchar* name,
                              const gchar* description,
                              const gchar* icon,
                              GdkPixbuf* pixbuf)
{
	PlankDockletNode* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GdkPixbuf* _tmp4_;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (description != NULL, NULL);
	g_return_val_if_fail (icon != NULL, NULL);
	g_return_val_if_fail (pixbuf != NULL, NULL);
	self = (PlankDockletNode*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (id);
	_g_free0 (self->id);
	self->id = _tmp0_;
	_tmp1_ = g_strdup (name);
	_g_free0 (self->name);
	self->name = _tmp1_;
	_tmp2_ = g_strdup (description);
	_g_free0 (self->description);
	self->description = _tmp2_;
	_tmp3_ = g_strdup (icon);
	_g_free0 (self->icon);
	self->icon = _tmp3_;
	_tmp4_ = _g_object_ref0 (pixbuf);
	_g_object_unref0 (self->pixbuf);
	self->pixbuf = _tmp4_;
	return self;
}

PlankDockletNode*
plank_docklet_node_new (const gchar* id,
                        const gchar* name,
                        const gchar* description,
                        const gchar* icon,
                        GdkPixbuf* pixbuf)
{
	return plank_docklet_node_construct (PLANK_TYPE_DOCKLET_NODE, id, name, description, icon, pixbuf);
}

static void
plank_value_docklet_node_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
plank_value_docklet_node_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		plank_docklet_node_unref (value->data[0].v_pointer);
	}
}

static void
plank_value_docklet_node_copy_value (const GValue* src_value,
                                     GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = plank_docklet_node_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
plank_value_docklet_node_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
plank_value_docklet_node_collect_value (GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PlankDockletNode * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = plank_docklet_node_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
plank_value_docklet_node_lcopy_value (const GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	PlankDockletNode ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = plank_docklet_node_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
plank_param_spec_docklet_node (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags)
{
	PlankParamSpecDockletNode* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PLANK_TYPE_DOCKLET_NODE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
plank_value_get_docklet_node (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PLANK_TYPE_DOCKLET_NODE), NULL);
	return value->data[0].v_pointer;
}

void
plank_value_set_docklet_node (GValue* value,
                              gpointer v_object)
{
	PlankDockletNode * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PLANK_TYPE_DOCKLET_NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PLANK_TYPE_DOCKLET_NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		plank_docklet_node_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		plank_docklet_node_unref (old);
	}
}

void
plank_value_take_docklet_node (GValue* value,
                               gpointer v_object)
{
	PlankDockletNode * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PLANK_TYPE_DOCKLET_NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PLANK_TYPE_DOCKLET_NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		plank_docklet_node_unref (old);
	}
}

static void
plank_docklet_node_class_init (PlankDockletNodeClass * klass,
                               gpointer klass_data)
{
	plank_docklet_node_parent_class = g_type_class_peek_parent (klass);
	((PlankDockletNodeClass *) klass)->finalize = plank_docklet_node_finalize;
}

static void
plank_docklet_node_instance_init (PlankDockletNode * self,
                                  gpointer klass)
{
	self->ref_count = 1;
}

static void
plank_docklet_node_finalize (PlankDockletNode * obj)
{
	PlankDockletNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_DOCKLET_NODE, PlankDockletNode);
	g_signal_handlers_destroy (self);
	_g_free0 (self->id);
	_g_free0 (self->name);
	_g_free0 (self->description);
	_g_free0 (self->icon);
	_g_object_unref0 (self->pixbuf);
}

static GType
plank_docklet_node_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { plank_value_docklet_node_init, plank_value_docklet_node_free_value, plank_value_docklet_node_copy_value, plank_value_docklet_node_peek_pointer, "p", plank_value_docklet_node_collect_value, "p", plank_value_docklet_node_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PlankDockletNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_docklet_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankDockletNode), 0, (GInstanceInitFunc) plank_docklet_node_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType plank_docklet_node_type_id;
	plank_docklet_node_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PlankDockletNode", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return plank_docklet_node_type_id;
}

GType
plank_docklet_node_get_type (void)
{
	static volatile gsize plank_docklet_node_type_id__once = 0;
	if (g_once_init_enter (&plank_docklet_node_type_id__once)) {
		GType plank_docklet_node_type_id;
		plank_docklet_node_type_id = plank_docklet_node_get_type_once ();
		g_once_init_leave (&plank_docklet_node_type_id__once, plank_docklet_node_type_id);
	}
	return plank_docklet_node_type_id__once;
}

gpointer
plank_docklet_node_ref (gpointer instance)
{
	PlankDockletNode * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
plank_docklet_node_unref (gpointer instance)
{
	PlankDockletNode * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PLANK_DOCKLET_NODE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
plank_docklet_view_model_get_instance_private (PlankDockletViewModel* self)
{
	return G_STRUCT_MEMBER_P (self, PlankDockletViewModel_private_offset);
}

static GType
plank_docklet_view_model_column_get_type_once (void)
{
	static const GEnumValue values[] = {{PLANK_DOCKLET_VIEW_MODEL_COLUMN_ID, "PLANK_DOCKLET_VIEW_MODEL_COLUMN_ID", "id"}, {PLANK_DOCKLET_VIEW_MODEL_COLUMN_NAME, "PLANK_DOCKLET_VIEW_MODEL_COLUMN_NAME", "name"}, {PLANK_DOCKLET_VIEW_MODEL_COLUMN_DESCRIPTION, "PLANK_DOCKLET_VIEW_MODEL_COLUMN_DESCRIPTION", "description"}, {PLANK_DOCKLET_VIEW_MODEL_COLUMN_ICON, "PLANK_DOCKLET_VIEW_MODEL_COLUMN_ICON", "icon"}, {PLANK_DOCKLET_VIEW_MODEL_COLUMN_PIXBUF, "PLANK_DOCKLET_VIEW_MODEL_COLUMN_PIXBUF", "pixbuf"}, {PLANK_DOCKLET_VIEW_MODEL_COLUMN_N_COLUMNS, "PLANK_DOCKLET_VIEW_MODEL_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
	GType plank_docklet_view_model_column_type_id;
	plank_docklet_view_model_column_type_id = g_enum_register_static ("PlankDockletViewModelColumn", values);
	return plank_docklet_view_model_column_type_id;
}

GType
plank_docklet_view_model_column_get_type (void)
{
	static volatile gsize plank_docklet_view_model_column_type_id__once = 0;
	if (g_once_init_enter (&plank_docklet_view_model_column_type_id__once)) {
		GType plank_docklet_view_model_column_type_id;
		plank_docklet_view_model_column_type_id = plank_docklet_view_model_column_get_type_once ();
		g_once_init_leave (&plank_docklet_view_model_column_type_id__once, plank_docklet_view_model_column_type_id);
	}
	return plank_docklet_view_model_column_type_id__once;
}

static void
_plank_docklet_node_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (plank_docklet_node_unref (var), NULL));
}

PlankDockletViewModel*
plank_docklet_view_model_construct (GType object_type)
{
	PlankDockletViewModel * self = NULL;
	GPtrArray* _tmp0_;
	self = (PlankDockletViewModel*) g_object_new (object_type, NULL);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _plank_docklet_node_unref0_);
	_g_ptr_array_unref0 (self->priv->data);
	self->priv->data = _tmp0_;
	return self;
}

PlankDockletViewModel*
plank_docklet_view_model_new (void)
{
	return plank_docklet_view_model_construct (PLANK_TYPE_DOCKLET_VIEW_MODEL);
}

void
plank_docklet_view_model_add (PlankDockletViewModel* self,
                              const gchar* id,
                              const gchar* name,
                              const gchar* descpription,
                              const gchar* icon,
                              GdkPixbuf* pixbuf)
{
	GPtrArray* _tmp0_;
	PlankDockletNode* _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (descpription != NULL);
	g_return_if_fail (icon != NULL);
	g_return_if_fail (pixbuf != NULL);
	_tmp0_ = self->priv->data;
	_tmp1_ = plank_docklet_node_new (id, name, descpription, icon, pixbuf);
	g_ptr_array_add (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->stamp;
	self->priv->stamp = _tmp2_ + 1;
}

static GType
plank_docklet_view_model_real_get_column_type (GtkTreeModel* base,
                                               gint index)
{
	PlankDockletViewModel * self;
	GType result;
	self = (PlankDockletViewModel*) base;
	switch (index) {
		case PLANK_DOCKLET_VIEW_MODEL_COLUMN_ID:
		case PLANK_DOCKLET_VIEW_MODEL_COLUMN_NAME:
		case PLANK_DOCKLET_VIEW_MODEL_COLUMN_DESCRIPTION:
		case PLANK_DOCKLET_VIEW_MODEL_COLUMN_ICON:
		{
			result = G_TYPE_STRING;
			return result;
		}
		case PLANK_DOCKLET_VIEW_MODEL_COLUMN_PIXBUF:
		{
			result = gdk_pixbuf_get_type ();
			return result;
		}
		default:
		{
			result = G_TYPE_INVALID;
			return result;
		}
	}
}

static GtkTreeModelFlags
plank_docklet_view_model_real_get_flags (GtkTreeModel* base)
{
	PlankDockletViewModel * self;
	GtkTreeModelFlags result;
	self = (PlankDockletViewModel*) base;
	result = 0;
	return result;
}

static void
plank_docklet_view_model_real_get_value (GtkTreeModel* base,
                                         GtkTreeIter* iter,
                                         gint column,
                                         GValue* val)
{
	PlankDockletViewModel * self;
	GValue _vala_val = {0};
	GtkTreeIter _tmp0_;
	PlankDockletNode* node = NULL;
	GPtrArray* _tmp1_;
	GtkTreeIter _tmp2_;
	void* _tmp3_;
	gconstpointer _tmp4_;
	self = (PlankDockletViewModel*) base;
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	_vala_assert (_tmp0_.stamp == self->priv->stamp, "iter.stamp == stamp");
	_tmp1_ = self->priv->data;
	_tmp2_ = *iter;
	_tmp3_ = _tmp2_.user_data;
	_tmp4_ = g_ptr_array_index (_tmp1_, (guint) ((gint) GPOINTER_TO_UINT (_tmp3_)));
	node = (PlankDockletNode*) _tmp4_;
	switch (column) {
		case PLANK_DOCKLET_VIEW_MODEL_COLUMN_ID:
		{
			GValue _tmp5_ = {0};
			PlankDockletNode* _tmp6_;
			const gchar* _tmp7_;
			g_value_init (&_tmp5_, G_TYPE_STRING);
			G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
			_vala_val = _tmp5_;
			_tmp6_ = node;
			_tmp7_ = _tmp6_->id;
			g_value_set_string (&_vala_val, _tmp7_);
			break;
		}
		case PLANK_DOCKLET_VIEW_MODEL_COLUMN_NAME:
		{
			GValue _tmp8_ = {0};
			PlankDockletNode* _tmp9_;
			const gchar* _tmp10_;
			g_value_init (&_tmp8_, G_TYPE_STRING);
			G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
			_vala_val = _tmp8_;
			_tmp9_ = node;
			_tmp10_ = _tmp9_->name;
			g_value_set_string (&_vala_val, _tmp10_);
			break;
		}
		case PLANK_DOCKLET_VIEW_MODEL_COLUMN_DESCRIPTION:
		{
			GValue _tmp11_ = {0};
			PlankDockletNode* _tmp12_;
			const gchar* _tmp13_;
			g_value_init (&_tmp11_, G_TYPE_STRING);
			G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
			_vala_val = _tmp11_;
			_tmp12_ = node;
			_tmp13_ = _tmp12_->description;
			g_value_set_string (&_vala_val, _tmp13_);
			break;
		}
		case PLANK_DOCKLET_VIEW_MODEL_COLUMN_ICON:
		{
			GValue _tmp14_ = {0};
			PlankDockletNode* _tmp15_;
			const gchar* _tmp16_;
			g_value_init (&_tmp14_, G_TYPE_STRING);
			G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
			_vala_val = _tmp14_;
			_tmp15_ = node;
			_tmp16_ = _tmp15_->icon;
			g_value_set_string (&_vala_val, _tmp16_);
			break;
		}
		case PLANK_DOCKLET_VIEW_MODEL_COLUMN_PIXBUF:
		{
			GValue _tmp17_ = {0};
			PlankDockletNode* _tmp18_;
			GdkPixbuf* _tmp19_;
			g_value_init (&_tmp17_, gdk_pixbuf_get_type ());
			G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
			_vala_val = _tmp17_;
			_tmp18_ = node;
			_tmp19_ = _tmp18_->pixbuf;
			g_value_set_object (&_vala_val, (GObject*) _tmp19_);
			break;
		}
		default:
		{
			GValue _tmp20_ = {0};
			g_value_init (&_tmp20_, G_TYPE_INVALID);
			G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
			_vala_val = _tmp20_;
			break;
		}
	}
	if (val) {
		*val = _vala_val;
	} else {
		G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
	}
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static gboolean
plank_docklet_view_model_real_get_iter (GtkTreeModel* base,
                                        GtkTreeIter* iter,
                                        GtkTreePath* path)
{
	PlankDockletViewModel * self;
	GtkTreeIter _vala_iter = {0};
	gboolean _tmp0_ = FALSE;
	gint _tmp6_ = 0;
	gint* _tmp7_;
	gint _tmp8_;
	void* _tmp9_;
	gboolean result;
	self = (PlankDockletViewModel*) base;
	g_return_val_if_fail (path != NULL, FALSE);
	if (gtk_tree_path_get_depth (path) != 1) {
		_tmp0_ = TRUE;
	} else {
		GPtrArray* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = self->priv->data;
		_tmp2_ = vala_g_ptr_array_get_length (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_ == 0;
	}
	if (_tmp0_) {
		GtkTreeIter _tmp4_ = {0};
		gboolean _tmp5_;
		_tmp5_ = plank_docklet_view_model_invalid_iter (self, &_tmp4_);
		_vala_iter = _tmp4_;
		result = _tmp5_;
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	}
	memset (&_vala_iter, 0, sizeof (GtkTreeIter));
	_tmp7_ = gtk_tree_path_get_indices_with_depth (path, &_tmp6_);
	_tmp8_ = _tmp7_[0];
	_tmp9_ = GUINT_TO_POINTER ((guint) _tmp8_);
	_vala_iter.user_data = _tmp9_;
	_vala_iter.stamp = self->priv->stamp;
	result = TRUE;
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}

static gint
plank_docklet_view_model_real_get_n_columns (GtkTreeModel* base)
{
	PlankDockletViewModel * self;
	gint result;
	self = (PlankDockletViewModel*) base;
	result = (gint) PLANK_DOCKLET_VIEW_MODEL_COLUMN_N_COLUMNS;
	return result;
}

static GtkTreePath*
plank_docklet_view_model_real_get_path (GtkTreeModel* base,
                                        GtkTreeIter* iter)
{
	PlankDockletViewModel * self;
	GtkTreeIter _tmp0_;
	GtkTreePath* path = NULL;
	GtkTreePath* _tmp1_;
	GtkTreeIter _tmp2_;
	void* _tmp3_;
	GtkTreePath* result;
	self = (PlankDockletViewModel*) base;
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = *iter;
	_vala_assert (_tmp0_.stamp == self->priv->stamp, "iter.stamp == stamp");
	_tmp1_ = gtk_tree_path_new ();
	path = _tmp1_;
	_tmp2_ = *iter;
	_tmp3_ = _tmp2_.user_data;
	gtk_tree_path_append_index (path, (gint) GPOINTER_TO_UINT (_tmp3_));
	result = path;
	return result;
}

static gint
plank_docklet_view_model_real_iter_n_children (GtkTreeModel* base,
                                               GtkTreeIter* iter)
{
	PlankDockletViewModel * self;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gint result;
	self = (PlankDockletViewModel*) base;
	if (iter == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = (*iter).stamp == self->priv->stamp;
	}
	_vala_assert (_tmp0_, "iter == null || iter.stamp == stamp");
	if (iter == NULL) {
		GPtrArray* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->data;
		_tmp3_ = vala_g_ptr_array_get_length (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp1_ = _tmp4_;
	} else {
		_tmp1_ = 0;
	}
	result = _tmp1_;
	return result;
}

static gboolean
plank_docklet_view_model_real_iter_next (GtkTreeModel* base,
                                         GtkTreeIter* iter)
{
	PlankDockletViewModel * self;
	GtkTreeIter _tmp0_;
	guint pos = 0U;
	GtkTreeIter _tmp1_;
	void* _tmp2_;
	GPtrArray* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	void* _tmp6_;
	gboolean result;
	self = (PlankDockletViewModel*) base;
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = *iter;
	_vala_assert (_tmp0_.stamp == self->priv->stamp, "iter.stamp == stamp");
	_tmp1_ = *iter;
	_tmp2_ = _tmp1_.user_data;
	pos = GPOINTER_TO_UINT (_tmp2_) + 1U;
	_tmp3_ = self->priv->data;
	_tmp4_ = vala_g_ptr_array_get_length (_tmp3_);
	_tmp5_ = _tmp4_;
	if (pos >= ((guint) _tmp5_)) {
		result = FALSE;
		return result;
	}
	_tmp6_ = GUINT_TO_POINTER (pos);
	(*iter).user_data = _tmp6_;
	result = TRUE;
	return result;
}

static gboolean
plank_docklet_view_model_real_iter_previous (GtkTreeModel* base,
                                             GtkTreeIter* iter)
{
	PlankDockletViewModel * self;
	GtkTreeIter _tmp0_;
	guint pos = 0U;
	GtkTreeIter _tmp1_;
	void* _tmp2_;
	guint _tmp3_;
	void* _tmp4_;
	gboolean result;
	self = (PlankDockletViewModel*) base;
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = *iter;
	_vala_assert (_tmp0_.stamp == self->priv->stamp, "iter.stamp == stamp");
	_tmp1_ = *iter;
	_tmp2_ = _tmp1_.user_data;
	pos = GPOINTER_TO_UINT (_tmp2_);
	if (pos >= ((guint) 0)) {
		result = FALSE;
		return result;
	}
	pos = pos - 1;
	_tmp3_ = pos;
	_tmp4_ = GUINT_TO_POINTER (_tmp3_);
	(*iter).user_data = _tmp4_;
	result = TRUE;
	return result;
}

static gboolean
plank_docklet_view_model_real_iter_nth_child (GtkTreeModel* base,
                                              GtkTreeIter* iter,
                                              GtkTreeIter* parent,
                                              gint n)
{
	PlankDockletViewModel * self;
	GtkTreeIter _vala_iter = {0};
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GtkTreeIter _tmp6_ = {0};
	gboolean _tmp7_;
	gboolean result;
	self = (PlankDockletViewModel*) base;
	if (parent == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = (*parent).stamp == self->priv->stamp;
	}
	_vala_assert (_tmp0_, "parent == null || parent.stamp == stamp");
	if (parent == NULL) {
		GPtrArray* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->data;
		_tmp3_ = vala_g_ptr_array_get_length (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp1_ = n < _tmp4_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		void* _tmp5_;
		memset (&_vala_iter, 0, sizeof (GtkTreeIter));
		_vala_iter.stamp = self->priv->stamp;
		_tmp5_ = GUINT_TO_POINTER ((guint) n);
		_vala_iter.user_data = _tmp5_;
		result = TRUE;
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	}
	_tmp7_ = plank_docklet_view_model_invalid_iter (self, &_tmp6_);
	_vala_iter = _tmp6_;
	result = _tmp7_;
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}

static gboolean
plank_docklet_view_model_real_iter_children (GtkTreeModel* base,
                                             GtkTreeIter* iter,
                                             GtkTreeIter* parent)
{
	PlankDockletViewModel * self;
	GtkTreeIter _vala_iter = {0};
	gboolean _tmp0_ = FALSE;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	gboolean result;
	self = (PlankDockletViewModel*) base;
	if (parent == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = (*parent).stamp == self->priv->stamp;
	}
	_vala_assert (_tmp0_, "parent == null || parent.stamp == stamp");
	_tmp2_ = plank_docklet_view_model_invalid_iter (self, &_tmp1_);
	_vala_iter = _tmp1_;
	result = _tmp2_;
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}

static gboolean
plank_docklet_view_model_real_iter_has_child (GtkTreeModel* base,
                                              GtkTreeIter* iter)
{
	PlankDockletViewModel * self;
	GtkTreeIter _tmp0_;
	gboolean result;
	self = (PlankDockletViewModel*) base;
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = *iter;
	_vala_assert (_tmp0_.stamp == self->priv->stamp, "iter.stamp == stamp");
	result = FALSE;
	return result;
}

static gboolean
plank_docklet_view_model_real_iter_parent (GtkTreeModel* base,
                                           GtkTreeIter* iter,
                                           GtkTreeIter* child)
{
	PlankDockletViewModel * self;
	GtkTreeIter _vala_iter = {0};
	GtkTreeIter _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	gboolean result;
	self = (PlankDockletViewModel*) base;
	g_return_val_if_fail (child != NULL, FALSE);
	_tmp0_ = *child;
	_vala_assert (_tmp0_.stamp == self->priv->stamp, "child.stamp == stamp");
	_tmp2_ = plank_docklet_view_model_invalid_iter (self, &_tmp1_);
	_vala_iter = _tmp1_;
	result = _tmp2_;
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}

static gboolean
plank_docklet_view_model_invalid_iter (PlankDockletViewModel* self,
                                       GtkTreeIter* iter)
{
	GtkTreeIter _vala_iter = {0};
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	memset (&_vala_iter, 0, sizeof (GtkTreeIter));
	_vala_iter.stamp = -1;
	result = FALSE;
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}

static gboolean
plank_docklet_view_model_real_drag_data_delete (GtkTreeDragSource* base,
                                                GtkTreePath* path)
{
	PlankDockletViewModel * self;
	gboolean result;
	self = (PlankDockletViewModel*) base;
	g_return_val_if_fail (path != NULL, FALSE);
	result = FALSE;
	return result;
}

static gchar*
string_to_utf8 (const gchar* self,
                gint* result_length1)
{
	gint string_length = 0;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _result_ = NULL;
	gchar* _tmp2_;
	gint _result__length1;
	gint __result__size_;
	gint _tmp3_;
	gchar* _tmp4_;
	gint _tmp4__length1;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = _tmp1_;
	_tmp2_ = g_new0 (gchar, string_length + 1);
	_result_ = _tmp2_;
	_result__length1 = string_length + 1;
	__result__size_ = _result__length1;
	_tmp3_ = _result__length1;
	_result__length1 = _tmp3_ - 1;
	memcpy (_result_, self, (gsize) string_length);
	_tmp4_ = _result_;
	_tmp4__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}

static gboolean
plank_docklet_view_model_real_drag_data_get (GtkTreeDragSource* base,
                                             GtkTreePath* path,
                                             GtkSelectionData* selection_data)
{
	PlankDockletViewModel * self;
	GtkTreeIter iter = {0};
	gchar* docklet_id = NULL;
	GtkTreeIter _tmp0_ = {0};
	GtkTreeIter _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* uri = NULL;
	gchar* _tmp3_;
	gint _tmp4_ = 0;
	gchar* _tmp5_;
	guchar* _tmp6_;
	gint _tmp6__length1;
	gboolean result;
	self = (PlankDockletViewModel*) base;
	g_return_val_if_fail (path != NULL, FALSE);
	g_return_val_if_fail (selection_data != NULL, FALSE);
	gtk_tree_model_get_iter ((GtkTreeModel*) self, &_tmp0_, path);
	iter = _tmp0_;
	_tmp1_ = iter;
	gtk_tree_model_get ((GtkTreeModel*) self, &_tmp1_, PLANK_DOCKLET_VIEW_MODEL_COLUMN_ID, &_tmp2_, -1, -1);
	_g_free0 (docklet_id);
	docklet_id = _tmp2_;
	_tmp3_ = g_strdup_printf ("%s%s\r\n", PLANK_DOCKLET_URI_PREFIX, docklet_id);
	uri = _tmp3_;
	_tmp5_ = string_to_utf8 (uri, &_tmp4_);
	_tmp6_ = (guchar*) _tmp5_;
	_tmp6__length1 = (_tmp4_ * sizeof (gchar)) / sizeof (guchar);
	gtk_selection_data_set (selection_data, gtk_selection_data_get_target (selection_data), 8, _tmp6_, (gint) ((_tmp4_ * sizeof (gchar)) / sizeof (guchar)));
	_tmp6_ = (g_free (_tmp6_), NULL);
	result = TRUE;
	_g_free0 (uri);
	_g_free0 (docklet_id);
	return result;
}

static gboolean
plank_docklet_view_model_real_row_draggable (GtkTreeDragSource* base,
                                             GtkTreePath* path)
{
	PlankDockletViewModel * self;
	gboolean result;
	self = (PlankDockletViewModel*) base;
	g_return_val_if_fail (path != NULL, FALSE);
	result = TRUE;
	return result;
}

static void
plank_docklet_view_model_class_init (PlankDockletViewModelClass * klass,
                                     gpointer klass_data)
{
	plank_docklet_view_model_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PlankDockletViewModel_private_offset);
	G_OBJECT_CLASS (klass)->finalize = plank_docklet_view_model_finalize;
}

static void
plank_docklet_view_model_gtk_tree_model_interface_init (GtkTreeModelIface * iface,
                                                        gpointer iface_data)
{
	plank_docklet_view_model_gtk_tree_model_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_column_type = (GType (*) (GtkTreeModel*, gint)) plank_docklet_view_model_real_get_column_type;
	iface->get_flags = (GtkTreeModelFlags (*) (GtkTreeModel*)) plank_docklet_view_model_real_get_flags;
	iface->get_value = (void (*) (GtkTreeModel*, GtkTreeIter*, gint, GValue*)) plank_docklet_view_model_real_get_value;
	iface->get_iter = (gboolean (*) (GtkTreeModel*, GtkTreeIter*, GtkTreePath*)) plank_docklet_view_model_real_get_iter;
	iface->get_n_columns = (gint (*) (GtkTreeModel*)) plank_docklet_view_model_real_get_n_columns;
	iface->get_path = (GtkTreePath* (*) (GtkTreeModel*, GtkTreeIter*)) plank_docklet_view_model_real_get_path;
	iface->iter_n_children = (gint (*) (GtkTreeModel*, GtkTreeIter*)) plank_docklet_view_model_real_iter_n_children;
	iface->iter_next = (gboolean (*) (GtkTreeModel*, GtkTreeIter*)) plank_docklet_view_model_real_iter_next;
	iface->iter_previous = (gboolean (*) (GtkTreeModel*, GtkTreeIter*)) plank_docklet_view_model_real_iter_previous;
	iface->iter_nth_child = (gboolean (*) (GtkTreeModel*, GtkTreeIter*, GtkTreeIter*, gint)) plank_docklet_view_model_real_iter_nth_child;
	iface->iter_children = (gboolean (*) (GtkTreeModel*, GtkTreeIter*, GtkTreeIter*)) plank_docklet_view_model_real_iter_children;
	iface->iter_has_child = (gboolean (*) (GtkTreeModel*, GtkTreeIter*)) plank_docklet_view_model_real_iter_has_child;
	iface->iter_parent = (gboolean (*) (GtkTreeModel*, GtkTreeIter*, GtkTreeIter*)) plank_docklet_view_model_real_iter_parent;
}

static void
plank_docklet_view_model_gtk_tree_drag_source_interface_init (GtkTreeDragSourceIface * iface,
                                                              gpointer iface_data)
{
	plank_docklet_view_model_gtk_tree_drag_source_parent_iface = g_type_interface_peek_parent (iface);
	iface->drag_data_delete = (gboolean (*) (GtkTreeDragSource*, GtkTreePath*)) plank_docklet_view_model_real_drag_data_delete;
	iface->drag_data_get = (gboolean (*) (GtkTreeDragSource*, GtkTreePath*, GtkSelectionData*)) plank_docklet_view_model_real_drag_data_get;
	iface->row_draggable = (gboolean (*) (GtkTreeDragSource*, GtkTreePath*)) plank_docklet_view_model_real_row_draggable;
}

static void
plank_docklet_view_model_instance_init (PlankDockletViewModel * self,
                                        gpointer klass)
{
	self->priv = plank_docklet_view_model_get_instance_private (self);
	self->priv->stamp = 0;
}

static void
plank_docklet_view_model_finalize (GObject * obj)
{
	PlankDockletViewModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_DOCKLET_VIEW_MODEL, PlankDockletViewModel);
	_g_ptr_array_unref0 (self->priv->data);
	G_OBJECT_CLASS (plank_docklet_view_model_parent_class)->finalize (obj);
}

static GType
plank_docklet_view_model_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankDockletViewModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_docklet_view_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankDockletViewModel), 0, (GInstanceInitFunc) plank_docklet_view_model_instance_init, NULL };
	static const GInterfaceInfo gtk_tree_model_info = { (GInterfaceInitFunc) plank_docklet_view_model_gtk_tree_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gtk_tree_drag_source_info = { (GInterfaceInitFunc) plank_docklet_view_model_gtk_tree_drag_source_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType plank_docklet_view_model_type_id;
	plank_docklet_view_model_type_id = g_type_register_static (G_TYPE_OBJECT, "PlankDockletViewModel", &g_define_type_info, 0);
	g_type_add_interface_static (plank_docklet_view_model_type_id, gtk_tree_model_get_type (), &gtk_tree_model_info);
	g_type_add_interface_static (plank_docklet_view_model_type_id, gtk_tree_drag_source_get_type (), &gtk_tree_drag_source_info);
	PlankDockletViewModel_private_offset = g_type_add_instance_private (plank_docklet_view_model_type_id, sizeof (PlankDockletViewModelPrivate));
	return plank_docklet_view_model_type_id;
}

GType
plank_docklet_view_model_get_type (void)
{
	static volatile gsize plank_docklet_view_model_type_id__once = 0;
	if (g_once_init_enter (&plank_docklet_view_model_type_id__once)) {
		GType plank_docklet_view_model_type_id;
		plank_docklet_view_model_type_id = plank_docklet_view_model_get_type_once ();
		g_once_init_leave (&plank_docklet_view_model_type_id__once, plank_docklet_view_model_type_id);
	}
	return plank_docklet_view_model_type_id__once;
}

