/* rygel-basic-management-test-ping.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from rygel-basic-management-test-ping.vala, do not modify */

/*
 * Copyright (C) 2013 Intel Corporation.
 *
 * Author: Christophe Guiraud,
 *         Jussi Kukkonen
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include "rygel-core.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <math.h>
#include <float.h>

#define RYGEL_BASIC_MANAGEMENT_TEST_PING_MAX_REPEAT_COUNT ((guint) 100)
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_DEFAULT_REPEAT_COUNT ((guint) 1)
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_DEFAULT_REPLY_TIMEOUT ((guint) 10000)
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_MIN_REQUEST_INTERVAL_TIMEOUT ((guint) 1000)
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_MAX_REQUEST_INTERVAL_TIMEOUT ((guint) 30000)
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_DEFAULT_REQUEST_INTERVAL_TIMEOUT ((guint) 1000)
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_MIN_DATA_BLOCK_SIZE ((guint) 20)
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_MAX_DATA_BLOCK_SIZE ((guint) 2048)
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_DEFAULT_DATA_BLOCK_SIZE ((guint) 32)
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_MAX_DSCP ((guint) 64)
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_DEFAULT_DSCP ((guint) 30)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define RYGEL_TYPE_BASIC_MANAGEMENT_TEST (rygel_basic_management_test_get_type ())
#define RYGEL_BASIC_MANAGEMENT_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTest))
#define RYGEL_BASIC_MANAGEMENT_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTestClass))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST))
#define RYGEL_BASIC_MANAGEMENT_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTestClass))

typedef struct _RygelBasicManagementTest RygelBasicManagementTest;
typedef struct _RygelBasicManagementTestClass RygelBasicManagementTestClass;
typedef struct _RygelBasicManagementTestPrivate RygelBasicManagementTestPrivate;
typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_OK,
	RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_SPAWN_FAILED,
	RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER
} RygelBasicManagementTestInitState;

#define RYGEL_BASIC_MANAGEMENT_TEST_TYPE_INIT_STATE (rygel_basic_management_test_init_state_get_type ())

#define RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING (rygel_basic_management_test_ping_get_type ())
#define RYGEL_BASIC_MANAGEMENT_TEST_PING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING, RygelBasicManagementTestPing))
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING, RygelBasicManagementTestPingClass))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_PING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING))
#define RYGEL_IS_BASIC_MANAGEMENT_TEST_PING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING))
#define RYGEL_BASIC_MANAGEMENT_TEST_PING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING, RygelBasicManagementTestPingClass))

typedef struct _RygelBasicManagementTestPing RygelBasicManagementTestPing;
typedef struct _RygelBasicManagementTestPingClass RygelBasicManagementTestPingClass;
typedef struct _RygelBasicManagementTestPingPrivate RygelBasicManagementTestPingPrivate;
typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_INIT,
	RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_STATISTICS,
	RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_RTT
} RygelBasicManagementTestPingProcessState;

#define RYGEL_BASIC_MANAGEMENT_TEST_PING_TYPE_PROCESS_STATE (rygel_basic_management_test_ping_process_state_get_type ())
typedef enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_SUCCESS,
	RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_CANNOT_RESOLVE_HOSTNAME,
	RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_INTERNAL,
	RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_OTHER
} RygelBasicManagementTestPingStatus;

#define RYGEL_BASIC_MANAGEMENT_TEST_PING_TYPE_STATUS (rygel_basic_management_test_ping_status_get_type ())
enum  {
	RYGEL_BASIC_MANAGEMENT_TEST_PING_0_PROPERTY,
	RYGEL_BASIC_MANAGEMENT_TEST_PING_HOST_PROPERTY,
	RYGEL_BASIC_MANAGEMENT_TEST_PING_REPEAT_COUNT_PROPERTY,
	RYGEL_BASIC_MANAGEMENT_TEST_PING_DATA_BLOCK_SIZE_PROPERTY,
	RYGEL_BASIC_MANAGEMENT_TEST_PING_DSCP_PROPERTY,
	RYGEL_BASIC_MANAGEMENT_TEST_PING_INTERVAL_TIME_OUT_PROPERTY,
	RYGEL_BASIC_MANAGEMENT_TEST_PING_METHOD_TYPE_PROPERTY,
	RYGEL_BASIC_MANAGEMENT_TEST_PING_RESULTS_TYPE_PROPERTY,
	RYGEL_BASIC_MANAGEMENT_TEST_PING_NUM_PROPERTIES
};
static GParamSpec* rygel_basic_management_test_ping_properties[RYGEL_BASIC_MANAGEMENT_TEST_PING_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelBasicManagementTest {
	GObject parent_instance;
	RygelBasicManagementTestPrivate * priv;
	GCancellable* _cancellable;
	RygelBasicManagementTestInitState init_state;
	gchar* id;
	guint iterations;
	GSpawnFlags flags;
	gchar** command;
	gint command_length1;
	gint _command_size_;
};

struct _RygelBasicManagementTestClass {
	GObjectClass parent_class;
	void (*init_iteration) (RygelBasicManagementTest* self);
	void (*handle_output) (RygelBasicManagementTest* self, const gchar* line);
	void (*handle_error) (RygelBasicManagementTest* self, const gchar* line);
	gboolean (*finish_iteration) (RygelBasicManagementTest* self);
	void (*run) (RygelBasicManagementTest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelBasicManagementTest* self, GAsyncResult* _res_);
	const gchar* (*get_method_type) (RygelBasicManagementTest* self);
	const gchar* (*get_results_type) (RygelBasicManagementTest* self);
};

struct _RygelBasicManagementTestPing {
	RygelBasicManagementTest parent_instance;
	RygelBasicManagementTestPingPrivate * priv;
};

struct _RygelBasicManagementTestPingClass {
	RygelBasicManagementTestClass parent_class;
};

struct _RygelBasicManagementTestPingPrivate {
	gchar* _host;
	guint _repeat_count;
	guint _data_block_size;
	guint _dscp;
	guint32 _interval_time_out;
	RygelBasicManagementTestPingProcessState state;
	RygelBasicManagementTestPingStatus status;
	gchar* additional_info;
	guint success_count;
	guint failure_count;
	guint32 avg_response_time;
	guint32 min_response_time;
	guint32 max_response_time;
};

static gint RygelBasicManagementTestPing_private_offset;
static gpointer rygel_basic_management_test_ping_parent_class = NULL;

VALA_EXTERN GType rygel_basic_management_test_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType rygel_basic_management_test_init_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType rygel_basic_management_test_ping_get_type (void) G_GNUC_CONST ;
static GType rygel_basic_management_test_ping_process_state_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GType rygel_basic_management_test_ping_status_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
VALA_EXTERN gboolean rygel_basic_management_test_finish_iteration (RygelBasicManagementTest* self);
VALA_EXTERN void rygel_basic_management_test_handle_error (RygelBasicManagementTest* self,
                                               const gchar* line);
VALA_EXTERN void rygel_basic_management_test_handle_output (RygelBasicManagementTest* self,
                                                const gchar* line);
VALA_EXTERN const gchar* rygel_basic_management_test_get_method_type (RygelBasicManagementTest* self);
VALA_EXTERN const gchar* rygel_basic_management_test_get_results_type (RygelBasicManagementTest* self);
static gchar* rygel_basic_management_test_ping_status_to_string (RygelBasicManagementTestPingStatus self);
VALA_EXTERN RygelBasicManagementTestPing* rygel_basic_management_test_ping_new (const gchar* host,
                                                                    guint repeat_count,
                                                                    guint32 interval_time_out,
                                                                    guint data_block_size,
                                                                    guint dscp);
VALA_EXTERN RygelBasicManagementTestPing* rygel_basic_management_test_ping_construct (GType object_type,
                                                                          const gchar* host,
                                                                          guint repeat_count,
                                                                          guint32 interval_time_out,
                                                                          guint data_block_size,
                                                                          guint dscp);
static void rygel_basic_management_test_ping_real_constructed (GObject* base);
VALA_EXTERN guint rygel_basic_management_test_ping_get_repeat_count (RygelBasicManagementTestPing* self);
VALA_EXTERN guint32 rygel_basic_management_test_ping_get_interval_time_out (RygelBasicManagementTestPing* self);
VALA_EXTERN guint rygel_basic_management_test_ping_get_data_block_size (RygelBasicManagementTestPing* self);
VALA_EXTERN guint rygel_basic_management_test_ping_get_dscp (RygelBasicManagementTestPing* self);
VALA_EXTERN const gchar* rygel_basic_management_test_ping_get_host (RygelBasicManagementTestPing* self);
static gboolean rygel_basic_management_test_ping_real_finish_iteration (RygelBasicManagementTest* base);
static void rygel_basic_management_test_ping_real_handle_error (RygelBasicManagementTest* base,
                                                         const gchar* line);
static void rygel_basic_management_test_ping_real_handle_output (RygelBasicManagementTest* base,
                                                          const gchar* line);
VALA_EXTERN void rygel_basic_management_test_ping_get_results (RygelBasicManagementTestPing* self,
                                                   gchar** status,
                                                   gchar** additional_info,
                                                   guint* success_count,
                                                   guint* failure_count,
                                                   guint32* avg_response_time,
                                                   guint32* min_response_time,
                                                   guint32* max_response_time);
static void rygel_basic_management_test_ping_set_host (RygelBasicManagementTestPing* self,
                                                const gchar* value);
static void rygel_basic_management_test_ping_set_repeat_count (RygelBasicManagementTestPing* self,
                                                        guint value);
static void rygel_basic_management_test_ping_set_data_block_size (RygelBasicManagementTestPing* self,
                                                           guint value);
static void rygel_basic_management_test_ping_set_dscp (RygelBasicManagementTestPing* self,
                                                guint value);
static void rygel_basic_management_test_ping_set_interval_time_out (RygelBasicManagementTestPing* self,
                                                             guint32 value);
static void rygel_basic_management_test_ping_finalize (GObject * obj);
static GType rygel_basic_management_test_ping_get_type_once (void);
static void _vala_rygel_basic_management_test_ping_get_property (GObject * object,
                                                          guint property_id,
                                                          GValue * value,
                                                          GParamSpec * pspec);
static void _vala_rygel_basic_management_test_ping_set_property (GObject * object,
                                                          guint property_id,
                                                          const GValue * value,
                                                          GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
rygel_basic_management_test_ping_get_instance_private (RygelBasicManagementTestPing* self)
{
	return G_STRUCT_MEMBER_P (self, RygelBasicManagementTestPing_private_offset);
}

 G_GNUC_NO_INLINE static GType
rygel_basic_management_test_ping_process_state_get_type_once (void)
{
	static const GEnumValue values[] = {{RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_INIT, "RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_INIT", "init"}, {RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_STATISTICS, "RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_STATISTICS", "statistics"}, {RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_RTT, "RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_RTT", "rtt"}, {0, NULL, NULL}};
	GType rygel_basic_management_test_ping_process_state_type_id;
	rygel_basic_management_test_ping_process_state_type_id = g_enum_register_static ("RygelBasicManagementTestPingProcessState", values);
	return rygel_basic_management_test_ping_process_state_type_id;
}

static GType
rygel_basic_management_test_ping_process_state_get_type (void)
{
	static volatile gsize rygel_basic_management_test_ping_process_state_type_id__once = 0;
	if (g_once_init_enter (&rygel_basic_management_test_ping_process_state_type_id__once)) {
		GType rygel_basic_management_test_ping_process_state_type_id;
		rygel_basic_management_test_ping_process_state_type_id = rygel_basic_management_test_ping_process_state_get_type_once ();
		g_once_init_leave (&rygel_basic_management_test_ping_process_state_type_id__once, rygel_basic_management_test_ping_process_state_type_id);
	}
	return rygel_basic_management_test_ping_process_state_type_id__once;
}

static gchar*
rygel_basic_management_test_ping_status_to_string (RygelBasicManagementTestPingStatus self)
{
	gchar* result;
	switch (self) {
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_SUCCESS:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("Success");
			result = _tmp0_;
			return result;
		}
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_CANNOT_RESOLVE_HOSTNAME:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("Error_CannotResolveHostName");
			result = _tmp1_;
			return result;
		}
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_INTERNAL:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("Error_Internal");
			result = _tmp2_;
			return result;
		}
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_OTHER:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("Error_Other");
			result = _tmp3_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

 G_GNUC_NO_INLINE static GType
rygel_basic_management_test_ping_status_get_type_once (void)
{
	static const GEnumValue values[] = {{RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_SUCCESS, "RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_SUCCESS", "success"}, {RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_CANNOT_RESOLVE_HOSTNAME, "RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_CANNOT_RESOLVE_HOSTNAME", "error-cannot-resolve-hostname"}, {RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_INTERNAL, "RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_INTERNAL", "error-internal"}, {RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_OTHER, "RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_OTHER", "error-other"}, {0, NULL, NULL}};
	GType rygel_basic_management_test_ping_status_type_id;
	rygel_basic_management_test_ping_status_type_id = g_enum_register_static ("RygelBasicManagementTestPingStatus", values);
	return rygel_basic_management_test_ping_status_type_id;
}

static GType
rygel_basic_management_test_ping_status_get_type (void)
{
	static volatile gsize rygel_basic_management_test_ping_status_type_id__once = 0;
	if (g_once_init_enter (&rygel_basic_management_test_ping_status_type_id__once)) {
		GType rygel_basic_management_test_ping_status_type_id;
		rygel_basic_management_test_ping_status_type_id = rygel_basic_management_test_ping_status_get_type_once ();
		g_once_init_leave (&rygel_basic_management_test_ping_status_type_id__once, rygel_basic_management_test_ping_status_type_id);
	}
	return rygel_basic_management_test_ping_status_type_id__once;
}

RygelBasicManagementTestPing*
rygel_basic_management_test_ping_construct (GType object_type,
                                            const gchar* host,
                                            guint repeat_count,
                                            guint32 interval_time_out,
                                            guint data_block_size,
                                            guint dscp)
{
	RygelBasicManagementTestPing * self = NULL;
	g_return_val_if_fail (host != NULL, NULL);
	self = (RygelBasicManagementTestPing*) g_object_new (object_type, "host", host, "repeat-count", repeat_count, "interval-time-out", interval_time_out, "data-block-size", data_block_size, "dscp", dscp, NULL);
	return self;
}

RygelBasicManagementTestPing*
rygel_basic_management_test_ping_new (const gchar* host,
                                      guint repeat_count,
                                      guint32 interval_time_out,
                                      guint data_block_size,
                                      guint dscp)
{
	return rygel_basic_management_test_ping_construct (RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING, host, repeat_count, interval_time_out, data_block_size, dscp);
}

static void
rygel_basic_management_test_ping_real_constructed (GObject* base)
{
	RygelBasicManagementTestPing * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	guint32 _tmp9_;
	guint32 _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	guint _tmp13_;
	guint _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	guint _tmp17_;
	guint _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar** _tmp22_;
	guint _tmp23_;
	guint _tmp24_;
	self = (RygelBasicManagementTestPing*) base;
	G_OBJECT_CLASS (rygel_basic_management_test_ping_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTest));
	self->priv->status = RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_INTERNAL;
	self->priv->state = RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_INIT;
	_tmp0_ = g_strdup ("");
	_g_free0 (self->priv->additional_info);
	self->priv->additional_info = _tmp0_;
	self->priv->success_count = (guint) 0;
	self->priv->failure_count = (guint) 0;
	self->priv->avg_response_time = (guint32) 0;
	self->priv->min_response_time = (guint32) 0;
	self->priv->max_response_time = (guint32) 0;
	_tmp1_ = g_strdup ("ping");
	_tmp2_ = g_strdup ("-c");
	_tmp3_ = rygel_basic_management_test_ping_get_repeat_count (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%u", _tmp4_);
	_tmp6_ = g_strdup ("-W");
	_tmp7_ = g_strdup_printf ("%u", RYGEL_BASIC_MANAGEMENT_TEST_PING_DEFAULT_REPLY_TIMEOUT / 1000);
	_tmp8_ = g_strdup ("-i");
	_tmp9_ = rygel_basic_management_test_ping_get_interval_time_out (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strdup_printf ("%u", _tmp10_ / 1000);
	_tmp12_ = g_strdup ("-s");
	_tmp13_ = rygel_basic_management_test_ping_get_data_block_size (self);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strdup_printf ("%u", _tmp14_);
	_tmp16_ = g_strdup ("-Q");
	_tmp17_ = rygel_basic_management_test_ping_get_dscp (self);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strdup_printf ("%u", _tmp18_ >> 2);
	_tmp20_ = self->priv->_host;
	_tmp21_ = g_strdup (_tmp20_);
	_tmp22_ = g_new0 (gchar*, 12 + 1);
	_tmp22_[0] = _tmp1_;
	_tmp22_[1] = _tmp2_;
	_tmp22_[2] = _tmp5_;
	_tmp22_[3] = _tmp6_;
	_tmp22_[4] = _tmp7_;
	_tmp22_[5] = _tmp8_;
	_tmp22_[6] = _tmp11_;
	_tmp22_[7] = _tmp12_;
	_tmp22_[8] = _tmp15_;
	_tmp22_[9] = _tmp16_;
	_tmp22_[10] = _tmp19_;
	_tmp22_[11] = _tmp21_;
	((RygelBasicManagementTest*) self)->command = (_vala_array_free (((RygelBasicManagementTest*) self)->command, ((RygelBasicManagementTest*) self)->command_length1, (GDestroyNotify) g_free), NULL);
	((RygelBasicManagementTest*) self)->command = _tmp22_;
	((RygelBasicManagementTest*) self)->command_length1 = 12;
	((RygelBasicManagementTest*) self)->_command_size_ = ((RygelBasicManagementTest*) self)->command_length1;
	_tmp23_ = rygel_basic_management_test_ping_get_repeat_count (self);
	_tmp24_ = _tmp23_;
	if (_tmp24_ > RYGEL_BASIC_MANAGEMENT_TEST_PING_MAX_REPEAT_COUNT) {
		gchar* msg = NULL;
		gchar* _tmp25_;
		const gchar* _tmp26_;
		guint _tmp27_;
		guint _tmp28_;
		gchar* _tmp29_;
		((RygelBasicManagementTest*) self)->init_state = RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER;
		self->priv->status = RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_OTHER;
		_tmp25_ = g_strdup ("NumberOfRepetitions %u is not in allowed range [0, %u]");
		msg = _tmp25_;
		_tmp26_ = msg;
		_tmp27_ = rygel_basic_management_test_ping_get_repeat_count (self);
		_tmp28_ = _tmp27_;
		_tmp29_ = g_strdup_printf (_tmp26_, _tmp28_, RYGEL_BASIC_MANAGEMENT_TEST_PING_MAX_REPEAT_COUNT);
		_g_free0 (self->priv->additional_info);
		self->priv->additional_info = _tmp29_;
		_g_free0 (msg);
	} else {
		gboolean _tmp30_ = FALSE;
		guint32 _tmp31_;
		guint32 _tmp32_;
		_tmp31_ = rygel_basic_management_test_ping_get_interval_time_out (self);
		_tmp32_ = _tmp31_;
		if (_tmp32_ < ((guint32) RYGEL_BASIC_MANAGEMENT_TEST_PING_MIN_REQUEST_INTERVAL_TIMEOUT)) {
			_tmp30_ = TRUE;
		} else {
			guint32 _tmp33_;
			guint32 _tmp34_;
			_tmp33_ = rygel_basic_management_test_ping_get_interval_time_out (self);
			_tmp34_ = _tmp33_;
			_tmp30_ = _tmp34_ > ((guint32) RYGEL_BASIC_MANAGEMENT_TEST_PING_MAX_REQUEST_INTERVAL_TIMEOUT);
		}
		if (_tmp30_) {
			gchar* msg = NULL;
			gchar* _tmp35_;
			const gchar* _tmp36_;
			guint32 _tmp37_;
			guint32 _tmp38_;
			gchar* _tmp39_;
			((RygelBasicManagementTest*) self)->init_state = RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER;
			self->priv->status = RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_OTHER;
			_tmp35_ = g_strdup ("Timeout %u is not in allowed range [%u, %u]");
			msg = _tmp35_;
			_tmp36_ = msg;
			_tmp37_ = rygel_basic_management_test_ping_get_interval_time_out (self);
			_tmp38_ = _tmp37_;
			_tmp39_ = g_strdup_printf (_tmp36_, _tmp38_, RYGEL_BASIC_MANAGEMENT_TEST_PING_MIN_REQUEST_INTERVAL_TIMEOUT, RYGEL_BASIC_MANAGEMENT_TEST_PING_MAX_REQUEST_INTERVAL_TIMEOUT);
			_g_free0 (self->priv->additional_info);
			self->priv->additional_info = _tmp39_;
			_g_free0 (msg);
		} else {
			gboolean _tmp40_ = FALSE;
			guint _tmp41_;
			guint _tmp42_;
			_tmp41_ = rygel_basic_management_test_ping_get_data_block_size (self);
			_tmp42_ = _tmp41_;
			if (_tmp42_ < RYGEL_BASIC_MANAGEMENT_TEST_PING_MIN_DATA_BLOCK_SIZE) {
				_tmp40_ = TRUE;
			} else {
				guint _tmp43_;
				guint _tmp44_;
				_tmp43_ = rygel_basic_management_test_ping_get_data_block_size (self);
				_tmp44_ = _tmp43_;
				_tmp40_ = _tmp44_ > RYGEL_BASIC_MANAGEMENT_TEST_PING_MAX_DATA_BLOCK_SIZE;
			}
			if (_tmp40_) {
				gchar* msg = NULL;
				gchar* _tmp45_;
				const gchar* _tmp46_;
				guint _tmp47_;
				guint _tmp48_;
				gchar* _tmp49_;
				((RygelBasicManagementTest*) self)->init_state = RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER;
				self->priv->status = RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_OTHER;
				_tmp45_ = g_strdup ("DataBlockSize %u is not in allowed range [%u, %u]");
				msg = _tmp45_;
				_tmp46_ = msg;
				_tmp47_ = rygel_basic_management_test_ping_get_data_block_size (self);
				_tmp48_ = _tmp47_;
				_tmp49_ = g_strdup_printf (_tmp46_, _tmp48_, RYGEL_BASIC_MANAGEMENT_TEST_PING_MIN_DATA_BLOCK_SIZE, RYGEL_BASIC_MANAGEMENT_TEST_PING_MAX_DATA_BLOCK_SIZE);
				_g_free0 (self->priv->additional_info);
				self->priv->additional_info = _tmp49_;
				_g_free0 (msg);
			} else {
				guint _tmp50_;
				guint _tmp51_;
				_tmp50_ = rygel_basic_management_test_ping_get_dscp (self);
				_tmp51_ = _tmp50_;
				if (_tmp51_ > RYGEL_BASIC_MANAGEMENT_TEST_PING_MAX_DSCP) {
					gchar* msg = NULL;
					gchar* _tmp52_;
					const gchar* _tmp53_;
					guint _tmp54_;
					guint _tmp55_;
					gchar* _tmp56_;
					((RygelBasicManagementTest*) self)->init_state = RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_INVALID_PARAMETER;
					self->priv->status = RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_OTHER;
					_tmp52_ = g_strdup ("DSCP %u is not in allowed range [0, %u]");
					msg = _tmp52_;
					_tmp53_ = msg;
					_tmp54_ = rygel_basic_management_test_ping_get_dscp (self);
					_tmp55_ = _tmp54_;
					_tmp56_ = g_strdup_printf (_tmp53_, _tmp55_, RYGEL_BASIC_MANAGEMENT_TEST_PING_MAX_DSCP);
					_g_free0 (self->priv->additional_info);
					self->priv->additional_info = _tmp56_;
					_g_free0 (msg);
				}
			}
		}
	}
}

static gboolean
rygel_basic_management_test_ping_real_finish_iteration (RygelBasicManagementTest* base)
{
	RygelBasicManagementTestPing * self;
	gboolean result;
	self = (RygelBasicManagementTestPing*) base;
	if (((RygelBasicManagementTest*) self)->init_state == RYGEL_BASIC_MANAGEMENT_TEST_INIT_STATE_SPAWN_FAILED) {
		gchar* _tmp0_;
		self->priv->status = RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_INTERNAL;
		_tmp0_ = g_strdup ("Failed to spawn ping");
		_g_free0 (self->priv->additional_info);
		self->priv->additional_info = _tmp0_;
	}
	result = RYGEL_BASIC_MANAGEMENT_TEST_CLASS (rygel_basic_management_test_ping_parent_class)->finish_iteration (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_BASIC_MANAGEMENT_TEST, RygelBasicManagementTest));
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
rygel_basic_management_test_ping_real_handle_error (RygelBasicManagementTest* base,
                                                    const gchar* line)
{
	RygelBasicManagementTestPing * self;
	self = (RygelBasicManagementTestPing*) base;
	g_return_if_fail (line != NULL);
	if (string_contains (line, "ping: unknown host")) {
		self->priv->status = RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_CANNOT_RESOLVE_HOSTNAME;
	} else {
		if (string_contains (line, "ping:")) {
			gint _tmp0_;
			gint _tmp1_;
			gchar* _tmp2_;
			gchar* _tmp3_;
			gchar* _tmp4_;
			self->priv->status = RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_ERROR_OTHER;
			_tmp0_ = strlen ("ping:");
			_tmp1_ = _tmp0_;
			_tmp2_ = string_substring (line, (glong) _tmp1_, (glong) -1);
			_tmp3_ = _tmp2_;
			_tmp4_ = string_strip (_tmp3_);
			_g_free0 (self->priv->additional_info);
			self->priv->additional_info = _tmp4_;
			_g_free0 (_tmp3_);
		}
	}
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

static void
rygel_basic_management_test_ping_real_handle_output (RygelBasicManagementTest* base,
                                                     const gchar* line)
{
	RygelBasicManagementTestPing * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (RygelBasicManagementTestPing*) base;
	g_return_if_fail (line != NULL);
	_tmp0_ = string_strip (line);
	_tmp1_ = _tmp0_;
	_g_free0 (_tmp1_);
	if (self->priv->state == RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_INIT) {
		if (string_contains (line, "statistics ---")) {
			self->priv->state = RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_STATISTICS;
			self->priv->status = RYGEL_BASIC_MANAGEMENT_TEST_PING_STATUS_SUCCESS;
		}
	} else {
		if (self->priv->state == RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_STATISTICS) {
			if (string_contains (line, "packets transmitted")) {
				gchar** rtt_values = NULL;
				gchar** _tmp2_;
				gchar** _tmp3_;
				gint rtt_values_length1;
				gint _rtt_values_size_;
				guint tx = 0U;
				gchar** _tmp4_;
				gint _tmp4__length1;
				const gchar* _tmp5_;
				gchar** _tmp6_;
				gchar** _tmp7_;
				gchar** _tmp8_;
				gint _tmp8__length1;
				const gchar* _tmp9_;
				guint _tmp10_;
				guint rx = 0U;
				gchar** _tmp11_;
				gint _tmp11__length1;
				const gchar* _tmp12_;
				gchar** _tmp13_;
				gchar** _tmp14_;
				gchar** _tmp15_;
				gint _tmp15__length1;
				const gchar* _tmp16_;
				guint _tmp17_;
				self->priv->state = RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_RTT;
				_tmp3_ = _tmp2_ = g_strsplit (line, ", ", 3);
				rtt_values = _tmp3_;
				rtt_values_length1 = _vala_array_length (_tmp2_);
				_rtt_values_size_ = rtt_values_length1;
				_tmp4_ = rtt_values;
				_tmp4__length1 = rtt_values_length1;
				_tmp5_ = _tmp4_[0];
				_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, " ", 3);
				_tmp8_ = _tmp7_;
				_tmp8__length1 = _vala_array_length (_tmp6_);
				_tmp9_ = _tmp8_[0];
				_tmp10_ = (guint) atoi (_tmp9_);
				_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
				tx = _tmp10_;
				_tmp11_ = rtt_values;
				_tmp11__length1 = rtt_values_length1;
				_tmp12_ = _tmp11_[1];
				_tmp14_ = _tmp13_ = g_strsplit (_tmp12_, " ", 3);
				_tmp15_ = _tmp14_;
				_tmp15__length1 = _vala_array_length (_tmp13_);
				_tmp16_ = _tmp15_[0];
				_tmp17_ = (guint) atoi (_tmp16_);
				_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_free), NULL);
				rx = _tmp17_;
				self->priv->failure_count = tx - rx;
				self->priv->success_count = rx;
				rtt_values = (_vala_array_free (rtt_values, rtt_values_length1, (GDestroyNotify) g_free), NULL);
			}
		} else {
			if (self->priv->state == RYGEL_BASIC_MANAGEMENT_TEST_PING_PROCESS_STATE_RTT) {
				if (string_contains (line, "min/avg/max")) {
					gchar** rtt = NULL;
					gchar** _tmp18_;
					gchar** _tmp19_;
					gint rtt_length1;
					gint _rtt_size_;
					gchar** _tmp20_;
					gint _tmp20__length1;
					_tmp19_ = _tmp18_ = g_strsplit (line, "=", 2);
					rtt = _tmp19_;
					rtt_length1 = _vala_array_length (_tmp18_);
					_rtt_size_ = rtt_length1;
					_tmp20_ = rtt;
					_tmp20__length1 = rtt_length1;
					if (_tmp20__length1 >= 2) {
						gchar** rtt_values = NULL;
						gchar** _tmp21_;
						gint _tmp21__length1;
						const gchar* _tmp22_;
						gchar** _tmp23_;
						gchar** _tmp24_;
						gint rtt_values_length1;
						gint _rtt_values_size_;
						gchar** _tmp25_;
						gint _tmp25__length1;
						_tmp21_ = rtt;
						_tmp21__length1 = rtt_length1;
						_tmp22_ = _tmp21_[1];
						_tmp24_ = _tmp23_ = g_strsplit (_tmp22_, "/", 4);
						rtt_values = _tmp24_;
						rtt_values_length1 = _vala_array_length (_tmp23_);
						_rtt_values_size_ = rtt_values_length1;
						_tmp25_ = rtt_values;
						_tmp25__length1 = rtt_values_length1;
						if (_tmp25__length1 >= 3) {
							gchar** _tmp26_;
							gint _tmp26__length1;
							const gchar* _tmp27_;
							gchar** _tmp28_;
							gint _tmp28__length1;
							const gchar* _tmp29_;
							gchar** _tmp30_;
							gint _tmp30__length1;
							const gchar* _tmp31_;
							_tmp26_ = rtt_values;
							_tmp26__length1 = rtt_values_length1;
							_tmp27_ = _tmp26_[0];
							self->priv->min_response_time = (guint32) ((guint) round (double_parse (_tmp27_)));
							_tmp28_ = rtt_values;
							_tmp28__length1 = rtt_values_length1;
							_tmp29_ = _tmp28_[1];
							self->priv->avg_response_time = (guint32) ((guint) round (double_parse (_tmp29_)));
							_tmp30_ = rtt_values;
							_tmp30__length1 = rtt_values_length1;
							_tmp31_ = _tmp30_[2];
							self->priv->max_response_time = (guint32) ((guint) round (double_parse (_tmp31_)));
						}
						rtt_values = (_vala_array_free (rtt_values, rtt_values_length1, (GDestroyNotify) g_free), NULL);
					}
					rtt = (_vala_array_free (rtt, rtt_length1, (GDestroyNotify) g_free), NULL);
				}
			}
		}
	}
}

void
rygel_basic_management_test_ping_get_results (RygelBasicManagementTestPing* self,
                                              gchar** status,
                                              gchar** additional_info,
                                              guint* success_count,
                                              guint* failure_count,
                                              guint32* avg_response_time,
                                              guint32* min_response_time,
                                              guint32* max_response_time)
{
	gchar* _vala_status = NULL;
	gchar* _vala_additional_info = NULL;
	guint _vala_success_count = 0U;
	guint _vala_failure_count = 0U;
	guint32 _vala_avg_response_time = 0U;
	guint32 _vala_min_response_time = 0U;
	guint32 _vala_max_response_time = 0U;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = rygel_basic_management_test_ping_status_to_string (self->priv->status);
	_g_free0 (_vala_status);
	_vala_status = _tmp0_;
	_tmp1_ = self->priv->additional_info;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_vala_additional_info);
	_vala_additional_info = _tmp2_;
	_vala_success_count = self->priv->success_count;
	_vala_failure_count = self->priv->failure_count;
	_vala_avg_response_time = self->priv->avg_response_time;
	_vala_min_response_time = self->priv->min_response_time;
	_vala_max_response_time = self->priv->max_response_time;
	if (status) {
		*status = _vala_status;
	} else {
		_g_free0 (_vala_status);
	}
	if (additional_info) {
		*additional_info = _vala_additional_info;
	} else {
		_g_free0 (_vala_additional_info);
	}
	if (success_count) {
		*success_count = _vala_success_count;
	}
	if (failure_count) {
		*failure_count = _vala_failure_count;
	}
	if (avg_response_time) {
		*avg_response_time = _vala_avg_response_time;
	}
	if (min_response_time) {
		*min_response_time = _vala_min_response_time;
	}
	if (max_response_time) {
		*max_response_time = _vala_max_response_time;
	}
}

const gchar*
rygel_basic_management_test_ping_get_host (RygelBasicManagementTestPing* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_host;
	result = _tmp0_;
	return result;
}

static void
rygel_basic_management_test_ping_set_host (RygelBasicManagementTestPing* self,
                                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_basic_management_test_ping_get_host (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_host);
		self->priv->_host = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_basic_management_test_ping_properties[RYGEL_BASIC_MANAGEMENT_TEST_PING_HOST_PROPERTY]);
	}
}

guint
rygel_basic_management_test_ping_get_repeat_count (RygelBasicManagementTestPing* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_repeat_count;
	return result;
}

static void
rygel_basic_management_test_ping_set_repeat_count (RygelBasicManagementTestPing* self,
                                                   guint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_repeat_count = value;
	if (self->priv->_repeat_count == ((guint) 0)) {
		self->priv->_repeat_count = RYGEL_BASIC_MANAGEMENT_TEST_PING_DEFAULT_REPEAT_COUNT;
	}
	g_object_notify_by_pspec ((GObject *) self, rygel_basic_management_test_ping_properties[RYGEL_BASIC_MANAGEMENT_TEST_PING_REPEAT_COUNT_PROPERTY]);
}

guint
rygel_basic_management_test_ping_get_data_block_size (RygelBasicManagementTestPing* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_data_block_size;
	return result;
}

static void
rygel_basic_management_test_ping_set_data_block_size (RygelBasicManagementTestPing* self,
                                                      guint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_data_block_size = value;
	if (self->priv->_data_block_size == ((guint) 0)) {
		self->priv->_data_block_size = RYGEL_BASIC_MANAGEMENT_TEST_PING_DEFAULT_DATA_BLOCK_SIZE;
	}
	g_object_notify_by_pspec ((GObject *) self, rygel_basic_management_test_ping_properties[RYGEL_BASIC_MANAGEMENT_TEST_PING_DATA_BLOCK_SIZE_PROPERTY]);
}

guint
rygel_basic_management_test_ping_get_dscp (RygelBasicManagementTestPing* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_dscp;
	return result;
}

static void
rygel_basic_management_test_ping_set_dscp (RygelBasicManagementTestPing* self,
                                           guint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_dscp = value;
	if (self->priv->_dscp == ((guint) 0)) {
		self->priv->_dscp = RYGEL_BASIC_MANAGEMENT_TEST_PING_DEFAULT_DSCP;
	}
	g_object_notify_by_pspec ((GObject *) self, rygel_basic_management_test_ping_properties[RYGEL_BASIC_MANAGEMENT_TEST_PING_DSCP_PROPERTY]);
}

guint32
rygel_basic_management_test_ping_get_interval_time_out (RygelBasicManagementTestPing* self)
{
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_interval_time_out;
	return result;
}

static void
rygel_basic_management_test_ping_set_interval_time_out (RygelBasicManagementTestPing* self,
                                                        guint32 value)
{
	g_return_if_fail (self != NULL);
	self->priv->_interval_time_out = value;
	if (self->priv->_interval_time_out == ((guint32) 0)) {
		self->priv->_interval_time_out = (guint32) RYGEL_BASIC_MANAGEMENT_TEST_PING_DEFAULT_REQUEST_INTERVAL_TIMEOUT;
	}
	g_object_notify_by_pspec ((GObject *) self, rygel_basic_management_test_ping_properties[RYGEL_BASIC_MANAGEMENT_TEST_PING_INTERVAL_TIME_OUT_PROPERTY]);
}

static const gchar*
rygel_basic_management_test_ping_real_get_method_type (RygelBasicManagementTest* base)
{
	const gchar* result;
	RygelBasicManagementTestPing* self;
	self = (RygelBasicManagementTestPing*) base;
	result = "Ping";
	return result;
}

static const gchar*
rygel_basic_management_test_ping_real_get_results_type (RygelBasicManagementTest* base)
{
	const gchar* result;
	RygelBasicManagementTestPing* self;
	self = (RygelBasicManagementTestPing*) base;
	result = "GetPingResult";
	return result;
}

static void
rygel_basic_management_test_ping_class_init (RygelBasicManagementTestPingClass * klass,
                                             gpointer klass_data)
{
	rygel_basic_management_test_ping_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelBasicManagementTestPing_private_offset);
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) rygel_basic_management_test_ping_real_constructed;
	((RygelBasicManagementTestClass *) klass)->finish_iteration = (gboolean (*) (RygelBasicManagementTest*)) rygel_basic_management_test_ping_real_finish_iteration;
	((RygelBasicManagementTestClass *) klass)->handle_error = (void (*) (RygelBasicManagementTest*, const gchar*)) rygel_basic_management_test_ping_real_handle_error;
	((RygelBasicManagementTestClass *) klass)->handle_output = (void (*) (RygelBasicManagementTest*, const gchar*)) rygel_basic_management_test_ping_real_handle_output;
	RYGEL_BASIC_MANAGEMENT_TEST_CLASS (klass)->get_method_type = (const gchar* (*) (RygelBasicManagementTest*)) rygel_basic_management_test_ping_real_get_method_type;
	RYGEL_BASIC_MANAGEMENT_TEST_CLASS (klass)->get_results_type = (const gchar* (*) (RygelBasicManagementTest*)) rygel_basic_management_test_ping_real_get_results_type;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_basic_management_test_ping_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_basic_management_test_ping_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_basic_management_test_ping_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_PING_HOST_PROPERTY, rygel_basic_management_test_ping_properties[RYGEL_BASIC_MANAGEMENT_TEST_PING_HOST_PROPERTY] = g_param_spec_string ("host", "host", "host", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_PING_REPEAT_COUNT_PROPERTY, rygel_basic_management_test_ping_properties[RYGEL_BASIC_MANAGEMENT_TEST_PING_REPEAT_COUNT_PROPERTY] = g_param_spec_uint ("repeat-count", "repeat-count", "repeat-count", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_PING_DATA_BLOCK_SIZE_PROPERTY, rygel_basic_management_test_ping_properties[RYGEL_BASIC_MANAGEMENT_TEST_PING_DATA_BLOCK_SIZE_PROPERTY] = g_param_spec_uint ("data-block-size", "data-block-size", "data-block-size", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_PING_DSCP_PROPERTY, rygel_basic_management_test_ping_properties[RYGEL_BASIC_MANAGEMENT_TEST_PING_DSCP_PROPERTY] = g_param_spec_uint ("dscp", "dscp", "dscp", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_PING_INTERVAL_TIME_OUT_PROPERTY, rygel_basic_management_test_ping_properties[RYGEL_BASIC_MANAGEMENT_TEST_PING_INTERVAL_TIME_OUT_PROPERTY] = g_param_spec_uint ("interval-time-out", "interval-time-out", "interval-time-out", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_PING_METHOD_TYPE_PROPERTY, rygel_basic_management_test_ping_properties[RYGEL_BASIC_MANAGEMENT_TEST_PING_METHOD_TYPE_PROPERTY] = g_param_spec_string ("method-type", "method-type", "method-type", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_BASIC_MANAGEMENT_TEST_PING_RESULTS_TYPE_PROPERTY, rygel_basic_management_test_ping_properties[RYGEL_BASIC_MANAGEMENT_TEST_PING_RESULTS_TYPE_PROPERTY] = g_param_spec_string ("results-type", "results-type", "results-type", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
rygel_basic_management_test_ping_instance_init (RygelBasicManagementTestPing * self,
                                                gpointer klass)
{
	gchar* _tmp0_;
	self->priv = rygel_basic_management_test_ping_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_host = _tmp0_;
	self->priv->_repeat_count = RYGEL_BASIC_MANAGEMENT_TEST_PING_DEFAULT_REPEAT_COUNT;
	self->priv->_data_block_size = RYGEL_BASIC_MANAGEMENT_TEST_PING_DEFAULT_DATA_BLOCK_SIZE;
	self->priv->_dscp = RYGEL_BASIC_MANAGEMENT_TEST_PING_DEFAULT_DSCP;
	self->priv->_interval_time_out = (guint32) RYGEL_BASIC_MANAGEMENT_TEST_PING_DEFAULT_REQUEST_INTERVAL_TIMEOUT;
}

static void
rygel_basic_management_test_ping_finalize (GObject * obj)
{
	RygelBasicManagementTestPing * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING, RygelBasicManagementTestPing);
	_g_free0 (self->priv->_host);
	_g_free0 (self->priv->additional_info);
	G_OBJECT_CLASS (rygel_basic_management_test_ping_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
rygel_basic_management_test_ping_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelBasicManagementTestPingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_basic_management_test_ping_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelBasicManagementTestPing), 0, (GInstanceInitFunc) rygel_basic_management_test_ping_instance_init, NULL };
	GType rygel_basic_management_test_ping_type_id;
	rygel_basic_management_test_ping_type_id = g_type_register_static (RYGEL_TYPE_BASIC_MANAGEMENT_TEST, "RygelBasicManagementTestPing", &g_define_type_info, 0);
	RygelBasicManagementTestPing_private_offset = g_type_add_instance_private (rygel_basic_management_test_ping_type_id, sizeof (RygelBasicManagementTestPingPrivate));
	return rygel_basic_management_test_ping_type_id;
}

GType
rygel_basic_management_test_ping_get_type (void)
{
	static volatile gsize rygel_basic_management_test_ping_type_id__once = 0;
	if (g_once_init_enter (&rygel_basic_management_test_ping_type_id__once)) {
		GType rygel_basic_management_test_ping_type_id;
		rygel_basic_management_test_ping_type_id = rygel_basic_management_test_ping_get_type_once ();
		g_once_init_leave (&rygel_basic_management_test_ping_type_id__once, rygel_basic_management_test_ping_type_id);
	}
	return rygel_basic_management_test_ping_type_id__once;
}

static void
_vala_rygel_basic_management_test_ping_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec)
{
	RygelBasicManagementTestPing * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING, RygelBasicManagementTestPing);
	switch (property_id) {
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_HOST_PROPERTY:
		g_value_set_string (value, rygel_basic_management_test_ping_get_host (self));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_REPEAT_COUNT_PROPERTY:
		g_value_set_uint (value, rygel_basic_management_test_ping_get_repeat_count (self));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_DATA_BLOCK_SIZE_PROPERTY:
		g_value_set_uint (value, rygel_basic_management_test_ping_get_data_block_size (self));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_DSCP_PROPERTY:
		g_value_set_uint (value, rygel_basic_management_test_ping_get_dscp (self));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_INTERVAL_TIME_OUT_PROPERTY:
		g_value_set_uint (value, rygel_basic_management_test_ping_get_interval_time_out (self));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_METHOD_TYPE_PROPERTY:
		g_value_set_string (value, rygel_basic_management_test_get_method_type ((RygelBasicManagementTest*) self));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_RESULTS_TYPE_PROPERTY:
		g_value_set_string (value, rygel_basic_management_test_get_results_type ((RygelBasicManagementTest*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_basic_management_test_ping_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec)
{
	RygelBasicManagementTestPing * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_BASIC_MANAGEMENT_TEST_PING, RygelBasicManagementTestPing);
	switch (property_id) {
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_HOST_PROPERTY:
		rygel_basic_management_test_ping_set_host (self, g_value_get_string (value));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_REPEAT_COUNT_PROPERTY:
		rygel_basic_management_test_ping_set_repeat_count (self, g_value_get_uint (value));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_DATA_BLOCK_SIZE_PROPERTY:
		rygel_basic_management_test_ping_set_data_block_size (self, g_value_get_uint (value));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_DSCP_PROPERTY:
		rygel_basic_management_test_ping_set_dscp (self, g_value_get_uint (value));
		break;
		case RYGEL_BASIC_MANAGEMENT_TEST_PING_INTERVAL_TIME_OUT_PROPERTY:
		rygel_basic_management_test_ping_set_interval_time_out (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

